#include <stdio.h>
#include <time.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/syscall.h>

int main() {
    time_t current_time;
    char time_string[100];
    char cwd[1024];
    
    // Print initial process information
    printf("=== PROCESS INFORMATION ===\n");
    printf("PID (Process ID): %d\n", getpid());
    printf("PPID (Parent Process ID): %d\n", getppid());
    printf("TID (Thread ID): %ld\n", syscall(SYS_gettid));
    printf("PGID (Process Group ID): %d\n", getpgrp());
    printf("SID (Session ID): %d\n", getsid(0));

    if (getcwd(cwd, sizeof(cwd))) {
        printf("Working Directory: %s\n", cwd);
    }
    
    printf("=== STARTING TIMESTAMP LOOP ===\n");
    
    while(1) {
        // Get current time
        current_time = time(NULL);
        
        // Convert to readable format
        struct tm *time_info = localtime(&current_time);
        strftime(time_string, sizeof(time_string), "%Y-%m-%d %H:%M:%S", time_info);
        
        // Print timestamp with all process IDs
        printf("[PID:%d PPID:%d TID:%ld PGID:%d] %s\n", 
               getpid(), getppid(), syscall(SYS_gettid), getpgrp(), time_string);
        fflush(stdout);
        
        // Sleep for 3 seconds
        sleep(1);
    }
    
    return 0;
}