OFFSET_HEADER	:= $(ARCH_SOURCE)/kernel/gen/asm-offsets.h
OFFSET_SOURCE	:= $(ARCH_SOURCE)/asm/asm-offsets.c

$(OFFSET_HEADER): $(OFFSET_SOURCE)
	mkdir -p $$(dirname $(OFFSET_HEADER))
	echo "/* SPDX-License-Identifier: copyleft-next-0.3.1 */" >> $(OFFSET_HEADER)
	echo "/* Copyright 2023 Kim Kuparinen < kimi.h.kuparinen@gmail.com > */" >> $(OFFSET_HEADER)
	echo "/* This file is autogenerated, see arch/riscv64/asm/source.mk. */" >> $(OFFSET_HEADER)
	echo "/* As such, license and copyright info is sort of meaningless" >> $(OFFSET_HEADER)
	echo " * but at least the build system doesn't crap out warnings */" >> $(OFFSET_HEADER)
	echo "#ifndef KMI_ASM_OFFSETS_H" >> $(OFFSET_HEADER)
	echo "#define KMI_ASM_OFFSETS_H" >> $(OFFSET_HEADER)
	echo "/**" >> $(OFFSET_HEADER)
	echo " * @file asm-offsets.h" >> $(OFFSET_HEADER)
	echo " * This comment is also to shut up warnings." >> $(OFFSET_HEADER)
	echo " */" >> $(OFFSET_HEADER)
	$(COMPILER) $(ARCH_CFLAGS) $(INCLUDE_FLAGS) -S $(OFFSET_SOURCE) -o - |\
		awk '($$1 == "#->") { print "#define " $$2 " " $$3 }' >> $(OFFSET_HEADER)
	echo "#endif /* KMI_ASM_OFFSETS_H */" >> $(OFFSET_HEADER)

CLEANUP	+= $(ARCH_SOURCE)/kernel/gen
