#define _GNU_SOURCE
#include <sys/types.h>
#include <sys/xattr.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char *argv[]) {
    if (argc == 1) {
        fprintf(stderr,
            "THIS EXAMPLE PROGRAM TAKES A FILEPATH, AND AN XATTR KEY AS ARGUMENTS.\n"
            "IT THEN REMOVES THE XATTR KEY FROM THAT FILE\n");
        return EXIT_FAILURE;
    }
    if (argc != 3) {
        fprintf(stderr, "Usage: %s <filepath> <xattr_key> <value>\n", argv[0]);
        return EXIT_FAILURE;
    }

    const char *filepath = argv[1];
    const char *key = argv[2];

    if (removexattr(filepath, key) == -1) {
        perror("removexattr");
        return EXIT_FAILURE;
    }

    printf("Extended attribute removed: %s -> %s\n", filepath, key);
    return EXIT_SUCCESS;
}
