#include <asm/bitsperlong.h>
#if BITS_PER_LONG == 64
#define PTR .quad
#define ALGN .balign 8
#else
#define PTR .long
#define ALGN .balign 4
#endif
	.section .rodata, "a"
.globl kallsyms_num_syms
	ALGN
kallsyms_num_syms:
	.long	175895

.globl kallsyms_names
	ALGN
kallsyms_names:
	.byte 0x0a, 0x41, 0xa5, 0x78, 0x9e, 0xec, 0xf5, 0x63, 0x9c, 0xed, 0x0a	/* Afixed_percpu_data */
	.byte 0x08, 0x41, 0xfd, 0xf5, 0xf0, 0x9c, 0xa9, 0x72, 0x74	/* A__per_cpu_start */
	.byte 0x0a, 0x41, 0x63, 0x9c, 0xed, 0x65, 0x06, 0x67, 0xf6, 0x8a, 0xf7	/* Acpu_debug_store */
	.byte 0x0c, 0x41, 0xab, 0x71, 0xa9, 0xc6, 0xb8, 0xf2, 0x6b, 0x8d, 0xf6, 0x8a, 0xf7	/* Airq_stack_backing_store */
	.byte 0x08, 0x41, 0x63, 0x9c, 0xa7, 0x73, 0xe9, 0x72, 0x77	/* Acpu_tss_rw */
	.byte 0x07, 0x41, 0x67, 0x64, 0xfe, 0x70, 0x83, 0x65	/* Agdt_page */
	.byte 0x0a, 0x41, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0xa9, 0xc6, 0x73	/* Aexception_stacks */
	.byte 0x0b, 0x41, 0xf1, 0xf3, 0x79, 0xa9, 0xc6, 0xf6, 0x74, 0xd5, 0x83, 0x65	/* Aentry_stack_storage */
	.byte 0x08, 0x41, 0xd6, 0x70, 0xa5, 0x78, 0x92, 0xc8, 0xac	/* Aespfix_waddr */
	.byte 0x07, 0x41, 0xd6, 0x70, 0xa5, 0x78, 0xa9, 0xc6	/* Aespfix_stack */
	.byte 0x0d, 0x41, 0x63, 0x9c, 0x5f, 0x6c, 0x32, 0x63, 0xf6, 0x68, 0x61, 0xf7, 0xda, 0x97	/* Acpu_l2c_shared_map */
	.byte 0x0d, 0x41, 0x63, 0x9c, 0x5f, 0x6c, 0x6c, 0x63, 0xf6, 0x68, 0x61, 0xf7, 0xda, 0x97	/* Acpu_llc_shared_map */
	.byte 0x06, 0x41, 0x63, 0x9c, 0xbf, 0x66, 0x6f	/* Acpu_info */
	.byte 0x0b, 0x41, 0x78, 0x38, 0x36, 0xf0, 0x9c, 0xa7, 0x6f, 0x5f, 0x5c, 0x9f	/* Ax86_cpu_to_acpiid */
	.byte 0x0d, 0x41, 0x78, 0x38, 0x36, 0xf0, 0x9c, 0xa7, 0x6f, 0x5f, 0x61, 0xb2, 0x63, 0x9f	/* Ax86_cpu_to_apicid */
	.byte 0x0a, 0x41, 0x2a, 0x64, 0x09, 0x5f, 0xc8, 0xac, 0x5f, 0xd9, 0x5e	/* Aamd_dr_addr_mask */
	.byte 0x0b, 0x41, 0x6d, 0x63, 0xfc, 0x62, 0xd2, 0x6b, 0xe9, 0xc5, 0xbc, 0x79	/* Amce_banks_array */
	.byte 0x0b, 0x41, 0x6d, 0x63, 0xfc, 0x6e, 0x75, 0x6d, 0xb8, 0xd2, 0x6b, 0x73	/* Amce_num_banks */
	.byte 0x0b, 0x41, 0x73, 0x6d, 0x63, 0x61, 0xb8, 0xd2, 0x6b, 0x3a, 0xe4, 0x93	/* Asmca_bank_counts */
	.byte 0x09, 0x41, 0x73, 0x6d, 0x63, 0x61, 0xb8, 0xd2, 0x6b, 0x73	/* Asmca_banks */
	.byte 0x07, 0x41, 0x63, 0x9c, 0xed, 0x69, 0xfc, 0x97	/* Acpu_die_map */
	.byte 0x07, 0x41, 0x63, 0x9c, 0xf0, 0xd5, 0xfc, 0x97	/* Acpu_core_map */
	.byte 0x0a, 0x41, 0x63, 0x9c, 0xf6, 0x69, 0x62, 0x6c, 0x8d, 0x5f, 0x97	/* Acpu_sibling_map */
	.byte 0x0a, 0x41, 0x74, 0x68, 0xca, 0xf0, 0x9c, 0x5f, 0x6f, 0x66, 0x66	/* Athis_cpu_off */
	.byte 0x0b, 0x41, 0x61, 0xe1, 0x6e, 0x63, 0xec, 0x3b, 0xf1, 0x90, 0xc4, 0x64	/* Aasync_pf_enabled */
	.byte 0x0d, 0x41, 0x73, 0xba, 0x9e, 0xf0, 0xd5, 0xfc, 0x70, 0x72, 0x69, 0xd5, 0xea, 0x79	/* Asched_core_priority */
	.byte 0x09, 0x41, 0xf0, 0x65, 0x61, 0x5f, 0x6f, 0x66, 0x95, 0xd4	/* A_cea_offset */
	.byte 0x09, 0x41, 0x6b, 0x3d, 0xc6, 0x5f, 0x6f, 0x66, 0x95, 0xd4	/* Akstack_offset */
	.byte 0x0f, 0x41, 0x63, 0x9c, 0x5f, 0xdd, 0xbe, 0x73, 0xec, 0xf5, 0x5f, 0x6a, 0x69, 0x66, 0x66, 0x79	/* Acpu_loops_per_jiffy */
	.byte 0x0b, 0x41, 0x70, 0x6d, 0x63, 0xec, 0xf7, 0x76, 0x5f, 0xc4, 0x66, 0x74	/* Apmc_prev_left */
	.byte 0x07, 0x41, 0x63, 0x9c, 0xa3, 0x8f, 0xd7, 0x93	/* Acpu_hw_events */
	.byte 0x09, 0x41, 0x19, 0x66, 0xbd, 0x6d, 0x69, 0xa7, 0x3d, 0xb6	/* Aperf_nmi_tstamp */
	.byte 0x06, 0x41, 0x62, 0x93, 0xf0, 0x74, 0x78	/* Abts_ctx */
	.byte 0x09, 0x41, 0xf8, 0x73, 0x6e, 0xb8, 0x75, 0x66, 0x66, 0xf5	/* Ainsn_buffer */
	.byte 0x07, 0x41, 0x70, 0x34, 0xa6, 0xe4, 0x6e, 0x8d	/* Ap4_running */
	.byte 0x06, 0x41, 0x70, 0xfe, 0x63, 0x74, 0x78	/* Apt_ctx */
	.byte 0x06, 0x41, 0x6e, 0x6d, 0x69, 0x09, 0x37	/* Anmi_dr7 */
	.byte 0x07, 0x41, 0x6e, 0x6d, 0x69, 0xf0, 0x72, 0x32	/* Anmi_cr2 */
	.byte 0x06, 0x41, 0x6e, 0x6d, 0x69, 0xa9, 0x2c	/* Anmi_state */
	.byte 0x09, 0x41, 0x6c, 0xbb, 0xfe, 0x6e, 0x6d, 0x69, 0xa6, 0x28	/* Alast_nmi_rip */
	.byte 0x08, 0x41, 0x73, 0x77, 0x22, 0x77, 0xbd, 0x6d, 0x69	/* Aswallow_nmi */
	.byte 0x06, 0x41, 0x6e, 0x6d, 0x69, 0xa9, 0x93	/* Anmi_stats */
	.byte 0x08, 0x41, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xab, 0x71	/* Avector_irq */
	.byte 0x07, 0x41, 0x62, 0x70, 0xec, 0xf5, 0xde, 0x67	/* Abp_per_reg */
	.byte 0x09, 0x41, 0x63, 0x9c, 0xed, 0x65, 0x06, 0x67, 0xf7, 0x67	/* Acpu_debugreg */
	.byte 0x05, 0x41, 0x63, 0x9c, 0x09, 0x37	/* Acpu_dr7 */
	.byte 0x06, 0x41, 0x73, 0x73, 0x62, 0xa9, 0x2c	/* Assb_state */
	.byte 0x0c, 0x41, 0xff, 0x93, 0xe9, 0x6c, 0x69, 0x6d, 0x9d, 0xf8, 0x76, 0xe5, 0x9f	/* A__tss_limit_invalid */
	.byte 0x10, 0x41, 0x6d, 0x73, 0x72, 0xc1, 0xca, 0x63, 0xe6, 0x65, 0xe8, 0x75, 0x29, 0xf6, 0x68, 0xc8, 0xad	/* Amsr_misc_features_shadow */
	.byte 0x09, 0x41, 0xf8, 0x5f, 0x6b, 0xf5, 0x6e, 0xdb, 0xe6, 0x9c	/* Ain_kernel_fpu */
	.byte 0x06, 0x41, 0x78, 0x66, 0x64, 0xa9, 0x2c	/* Axfd_state */
	.byte 0x0e, 0x41, 0x66, 0x9c, 0xe6, 0x70, 0xf7, 0x67, 0xe9, 0xad, 0x6e, 0xf5, 0xf0, 0x74, 0x78	/* Afpu_fpregs_owner_ctx */
	.byte 0x0f, 0x41, 0x78, 0x38, 0x36, 0xf6, 0x70, 0xb4, 0xf0, 0xf3, 0x6c, 0xf0, 0x98, 0xf7, 0x6e, 0x74	/* Ax86_spec_ctrl_current */
	.byte 0x0a, 0x41, 0xc5, 0xba, 0xe6, 0xf7, 0x71, 0xf6, 0x63, 0xe5, 0x65	/* Aarch_freq_scale */
	.byte 0x09, 0x41, 0x73, 0x61, 0x76, 0x65, 0xda, 0x65, 0x70, 0x62	/* Asaved_epb */
	.byte 0x06, 0x41, 0x6d, 0x63, 0xfc, 0x00, 0xf5	/* Amce_timer */
	.byte 0x0b, 0x41, 0x6d, 0x63, 0xfc, 0x6e, 0xcb, 0xfe, 0xb3, 0xf5, 0x76, 0xe5	/* Amce_next_interval */
	.byte 0x09, 0x41, 0x68, 0x8f, 0xf5, 0x72, 0x73, 0xf6, 0x65, 0xf1	/* Ahw_errs_seen */
	.byte 0x06, 0x41, 0xf8, 0x6a, 0xb4, 0x74, 0x6d	/* Ainjectm */
	.byte 0x0b, 0x41, 0x6d, 0x63, 0xfc, 0x70, 0xa0, 0x6c, 0xb8, 0xd2, 0x6b, 0x73	/* Amce_poll_banks */
	.byte 0x0a, 0x41, 0x6d, 0x63, 0xfc, 0x70, 0xa0, 0x6c, 0x3a, 0xe4, 0x74	/* Amce_poll_count */
	.byte 0x0d, 0x41, 0x6d, 0x63, 0xfc, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0x3a, 0xe4, 0x74	/* Amce_exception_count */
	.byte 0x07, 0x41, 0x6d, 0x63, 0xfc, 0xb5, 0xaa, 0x65	/* Amce_device */
	.byte 0x0b, 0x41, 0x6d, 0x63, 0xfc, 0x62, 0xd2, 0x6b, 0xe9, 0xad, 0x6e, 0x9e	/* Amce_banks_owned */
	.byte 0x0d, 0x41, 0x73, 0x6d, 0x63, 0x61, 0xc1, 0xca, 0xc9, 0x62, 0xd2, 0x6b, 0xe9, 0x97	/* Asmca_misc_banks_map */
	.byte 0x06, 0x41, 0x62, 0xd2, 0x6b, 0x5f, 0x97	/* Abank_map */
	.byte 0x0b, 0x41, 0x74, 0x68, 0x29, 0x68, 0xa0, 0xda, 0x62, 0xd2, 0x6b, 0x73	/* Athreshold_banks */
	.byte 0x08, 0x41, 0x73, 0x74, 0xd5, 0x6d, 0xed, 0xd6, 0x63	/* Astorm_desc */
	.byte 0x0a, 0x41, 0x76, 0x6d, 0x77, 0xf6, 0x2c, 0xe5, 0x5f, 0xdc, 0xa8	/* Avmw_steal_time */
	.byte 0x07, 0x41, 0x93, 0xc9, 0xc8, 0x6a, 0xb1, 0x74	/* Atsc_adjust */
	.byte 0x07, 0x41, 0x6c, 0x61, 0xb2, 0xc9, 0xd7, 0x93	/* Alapic_events */
	.byte 0x09, 0x41, 0x76, 0xb4, 0x74, 0xd5, 0xf0, 0xc4, 0xd2, 0xcd	/* Avector_cleanup */
	.byte 0x0a, 0x41, 0x6b, 0x70, 0x8c, 0xfc, 0x63, 0x23, 0x62, 0x6c, 0x6b	/* Akprobe_ctlblk */
	.byte 0x0a, 0x41, 0x63, 0x98, 0xf7, 0x6e, 0xfe, 0x6b, 0x70, 0x8c, 0x65	/* Acurrent_kprobe */
	.byte 0x0a, 0x41, 0x63, 0x9c, 0xa3, 0x70, 0xe2, 0xba, 0xd2, 0x6e, 0xdb	/* Acpu_hpet_channel */
	.byte 0x08, 0x41, 0xfd, 0x76, 0xf0, 0x9c, 0x5f, 0xd9, 0x5e	/* A__pv_cpu_mask */
	.byte 0x0a, 0x41, 0x6b, 0x76, 0xae, 0x61, 0xb2, 0xc9, 0x65, 0x6f, 0x69	/* Akvm_apic_eoi */
	.byte 0x07, 0x41, 0x73, 0x2c, 0xe5, 0x5f, 0xdc, 0xa8	/* Asteal_time */
	.byte 0x07, 0x41, 0x61, 0x70, 0x66, 0xde, 0xbb, 0xe7	/* Aapf_reason */
	.byte 0x09, 0x41, 0x68, 0x76, 0xf0, 0xa4, 0xec, 0xf5, 0xf0, 0x9c	/* Ahv_clock_per_cpu */
	.byte 0x0a, 0x41, 0x6e, 0x6d, 0x69, 0x5f, 0xb1, 0xf5, 0xde, 0x67, 0x73	/* Anmi_user_regs */
	.byte 0x0e, 0x41, 0x63, 0x65, 0x61, 0x5f, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0xa9, 0xc6, 0x73	/* Acea_exception_stacks */
	.byte 0x0b, 0x41, 0x78, 0x38, 0x36, 0xf0, 0x9c, 0xa7, 0x6f, 0xbd, 0x16, 0x97	/* Ax86_cpu_to_node_map */
	.byte 0x08, 0x41, 0x63, 0xf2, 0x68, 0x9e, 0xa9, 0xc6, 0x73	/* Acached_stacks */
	.byte 0x09, 0x41, 0x70, 0xe3, 0x63, 0xd6, 0x73, 0x3a, 0xe4, 0x93	/* Aprocess_counts */
	.byte 0x16, 0x41, 0xfd, 0xf5, 0x63, 0x9c, 0xa6, 0x77, 0x73, 0x65, 0xae, 0x72, 0x63, 0xf0, 0x9c, 0xa3, 0x6f, 0xce, 0x6c, 0x75, 0x67, 0x5f, 0xa4	/* A__percpu_rwsem_rc_cpu_hotplug_lock */
	.byte 0x07, 0x41, 0x63, 0x9c, 0x68, 0x70, 0xa9, 0x2c	/* Acpuhp_state */
	.byte 0x0a, 0x41, 0xf4, 0x5e, 0x6c, 0xe2, 0x68, 0x69, 0x5f, 0x76, 0xb4	/* Atasklet_hi_vec */
	.byte 0x07, 0x41, 0xf4, 0x5e, 0x6c, 0xe2, 0x76, 0xb4	/* Atasklet_vec */
	.byte 0x09, 0x41, 0x6b, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x64	/* Aksoftirqd */
	.byte 0x0e, 0x41, 0x70, 0xf1, 0x64, 0x8d, 0x5f, 0x00, 0xf5, 0xf6, 0x6f, 0x66, 0xdc, 0x72, 0x71	/* Apending_timer_softirq */
	.byte 0x05, 0x41, 0x6b, 0x00, 0xf5, 0x64	/* Aktimerd */
	.byte 0x0b, 0x41, 0x77, 0x71, 0xa6, 0x72, 0xf0, 0x9c, 0x5f, 0x6c, 0xbb, 0x74	/* Awq_rr_cpu_last */
	.byte 0x0d, 0x41, 0xab, 0x71, 0x92, 0xd5, 0x6b, 0x5f, 0x4e, 0x4d, 0x49, 0x07, 0x75, 0xa8	/* Airq_work_NMI_resume */
	.byte 0x08, 0x41, 0x9f, 0xb0, 0x74, 0x68, 0xf7, 0xc8, 0x73	/* Aidle_threads */
	.byte 0x07, 0x41, 0x70, 0xb1, 0x68, 0x92, 0xd5, 0x6b	/* Apush_work */
	.byte 0x0a, 0x41, 0x6b, 0xf5, 0x6e, 0xdb, 0xf0, 0x70, 0xb1, 0xf4, 0x74	/* Akernel_cpustat */
	.byte 0x04, 0x41, 0x6b, 0x3d, 0x74	/* Akstat */
	.byte 0x11, 0x41, 0x73, 0x68, 0x6f, 0x02, 0xda, 0x77, 0xfc, 0x62, 0xe5, 0xd2, 0x63, 0xfc, 0x74, 0xb6, 0xd9, 0x5e	/* Ashould_we_balance_tmpmask */
	.byte 0x0a, 0x41, 0x73, 0xdb, 0xb4, 0xfe, 0x72, 0x71, 0x5f, 0xd9, 0x5e	/* Aselect_rq_mask */
	.byte 0x0b, 0x41, 0xdd, 0x61, 0xda, 0x62, 0xe5, 0xd2, 0x63, 0xfc, 0xd9, 0x5e	/* Aload_balance_mask */
	.byte 0x0b, 0x41, 0xdd, 0x63, 0xe5, 0xf0, 0x9c, 0x5f, 0xd9, 0x5e, 0xed, 0x6c	/* Alocal_cpu_mask_dl */
	.byte 0x09, 0x41, 0x64, 0x6c, 0xec, 0x02, 0x6c, 0xa3, 0x65, 0xc8	/* Adl_pull_head */
	.byte 0x09, 0x41, 0x64, 0x6c, 0xec, 0xb1, 0x68, 0xa3, 0x65, 0xc8	/* Adl_push_head */
	.byte 0x09, 0x41, 0xdd, 0x63, 0xe5, 0xf0, 0x9c, 0x5f, 0xd9, 0x5e	/* Alocal_cpu_mask */
	.byte 0x09, 0x41, 0x72, 0xfe, 0x9c, 0x6c, 0x6c, 0xa3, 0x65, 0xc8	/* Art_pull_head */
	.byte 0x09, 0x41, 0x72, 0xfe, 0x70, 0xb1, 0x68, 0xa3, 0x65, 0xc8	/* Art_push_head */
	.byte 0x08, 0x41, 0x73, 0x75, 0x67, 0x6f, 0x76, 0xf0, 0x9c	/* Asugov_cpu */
	.byte 0x0e, 0x41, 0xe3, 0x6f, 0xfe, 0x63, 0x9c, 0xf2, 0x63, 0xfe, 0x63, 0x9c, 0xb1, 0x83, 0x65	/* Aroot_cpuacct_cpuusage */
	.byte 0x0f, 0x41, 0x63, 0x9c, 0x66, 0xf7, 0x71, 0x5f, 0xcd, 0x64, 0x91, 0x75, 0xdc, 0x6c, 0xed, 0x0a	/* Acpufreq_update_util_data */
	.byte 0x0d, 0x41, 0x73, 0xda, 0x61, 0xd3, 0xf0, 0x9c, 0x63, 0x61, 0x70, 0xf2, 0xea, 0x79	/* Asd_asym_cpucapacity */
	.byte 0x09, 0x41, 0x73, 0xda, 0x61, 0xd3, 0xec, 0xf2, 0x6b, 0x8d	/* Asd_asym_packing */
	.byte 0x06, 0x41, 0x73, 0xda, 0x6e, 0x75, 0xd9	/* Asd_numa */
	.byte 0x0b, 0x41, 0x73, 0xda, 0x6c, 0x6c, 0x63, 0xf6, 0x68, 0x61, 0xf7, 0x64	/* Asd_llc_shared */
	.byte 0x08, 0x41, 0x73, 0x64, 0xf6, 0x68, 0xc5, 0xfc, 0x9f	/* Asd_share_id */
	.byte 0x07, 0x41, 0x73, 0xda, 0x6c, 0x6c, 0xc9, 0x9f	/* Asd_llc_id */
	.byte 0x0a, 0x41, 0x73, 0xda, 0x6c, 0x6c, 0x63, 0xf6, 0x69, 0x7a, 0x65	/* Asd_llc_size */
	.byte 0x06, 0x41, 0x73, 0xda, 0x6c, 0x6c, 0x63	/* Asd_llc */
	.byte 0x0e, 0x41, 0x77, 0x61, 0x6b, 0xfc, 0xcd, 0x5f, 0x6b, 0xdd, 0x67, 0xda, 0x77, 0xd5, 0x6b	/* Awake_up_klogd_work */
	.byte 0x09, 0x41, 0x70, 0x72, 0xb3, 0x6b, 0xec, 0xf1, 0x64, 0x8d	/* Aprintk_pending */
	.byte 0x0b, 0x41, 0x70, 0x72, 0xb3, 0x6b, 0x3a, 0xe4, 0xfe, 0x6e, 0x6d, 0x69	/* Aprintk_count_nmi */
	.byte 0x08, 0x41, 0x70, 0x72, 0xb3, 0x6b, 0x3a, 0xe4, 0x74	/* Aprintk_count */
	.byte 0x0f, 0x41, 0x40, 0x73, 0x6f, 0xb0, 0x73, 0x72, 0x63, 0x75, 0xf6, 0x72, 0x63, 0x75, 0xed, 0x0a	/* Aconsole_srcu_srcu_data */
	.byte 0x08, 0x41, 0x70, 0x72, 0xb3, 0x6b, 0x3e, 0x74, 0x8e	/* Aprintk_context */
	.byte 0x12, 0x41, 0x6e, 0x62, 0x40, 0xec, 0x63, 0x9c, 0x5f, 0x65, 0x6d, 0xf5, 0x67, 0xf1, 0x63, 0x79, 0xbd, 0x60, 0x8d	/* Anbcon_pcpu_emergency_nesting */
	.byte 0x07, 0x41, 0xff, 0x74, 0xb6, 0x5f, 0xd9, 0x5e	/* A__tmp_mask */
	.byte 0x0d, 0x41, 0x72, 0x63, 0x75, 0x5f, 0xf4, 0x5e, 0xe9, 0x94, 0xfd, 0xf5, 0x63, 0x9c	/* Arcu_tasks_trace__percpu */
	.byte 0x09, 0x41, 0xf3, 0xc9, 0x69, 0xb2, 0xa7, 0x6f, 0xf0, 0x9c	/* Atrc_ipi_to_cpu */
	.byte 0x0c, 0x41, 0x72, 0x63, 0x75, 0x5f, 0xf4, 0x5e, 0x73, 0xfd, 0xf5, 0x63, 0x9c	/* Arcu_tasks__percpu */
	.byte 0x04, 0x41, 0x6b, 0x72, 0x63	/* Akrc */
	.byte 0x06, 0x41, 0x00, 0xf5, 0xb8, 0xbb, 0xd6	/* Atimer_bases */
	.byte 0x08, 0x41, 0x68, 0x72, 0x00, 0xf5, 0xb8, 0xbb, 0xd6	/* Ahrtimer_bases */
	.byte 0x08, 0x41, 0xdc, 0xc6, 0xec, 0xf5, 0x63, 0x9c, 0x2b	/* Atick_percpu_dev */
	.byte 0x08, 0x41, 0xdc, 0xc6, 0xf0, 0x9c, 0x2b, 0xaa, 0x65	/* Atick_cpu_device */
	.byte 0x11, 0x41, 0xdc, 0xc6, 0x5f, 0xe7, 0xd6, 0x68, 0x6f, 0xfe, 0x77, 0x61, 0x6b, 0x65, 0xcd, 0x2b, 0xaa, 0x65	/* Atick_oneshot_wakeup_device */
	.byte 0x08, 0x41, 0xdc, 0xc6, 0xf0, 0x9c, 0xf6, 0xba, 0x9e	/* Atick_cpu_sched */
	.byte 0x07, 0x41, 0x74, 0x6d, 0x0c, 0x72, 0xf0, 0x9c	/* Atmigr_cpu */
	.byte 0x11, 0x41, 0xdc, 0xa8, 0x6b, 0x8b, 0x70, 0x8d, 0xc1, 0x67, 0xe6, 0xdd, 0xd5, 0xf6, 0x77, 0x61, 0x70, 0x73	/* Atimekeeping_mg_floor_swaps */
	.byte 0x09, 0x41, 0xf3, 0x0c, 0x67, 0xf5, 0xb8, 0xf2, 0x6b, 0x94	/* Atrigger_backtrace */
	.byte 0x11, 0x41, 0x63, 0x67, 0x72, 0x70, 0xed, 0x66, 0x6c, 0x5f, 0xe3, 0x6f, 0xfe, 0x72, 0x3d, 0xfe, 0x63, 0x9c	/* Acgrp_dfl_root_rstat_cpu */
	.byte 0x1c, 0x41, 0xfd, 0xf5, 0x63, 0x9c, 0xa6, 0x77, 0x73, 0x65, 0xae, 0x72, 0x63, 0xf0, 0x67, 0xe3, 0xcd, 0xa7, 0x68, 0xf7, 0xc8, 0x67, 0xe3, 0xcd, 0xa6, 0x77, 0x73, 0x65, 0x6d	/* A__percpu_rwsem_rc_cgroup_threadgroup_rwsem */
	.byte 0x0c, 0x41, 0x63, 0x67, 0xe3, 0xcd, 0xa6, 0x3d, 0xfe, 0x63, 0x9c, 0x5f, 0xa4	/* Acgroup_rstat_cpu_lock */
	.byte 0x07, 0x41, 0x63, 0x9c, 0xf6, 0x74, 0xbe, 0x19	/* Acpu_stopper */
	.byte 0x0a, 0x41, 0x6b, 0x70, 0x8c, 0xfc, 0xf8, 0x3d, 0x6e, 0x63, 0x65	/* Akprobe_instance */
	.byte 0x0a, 0x41, 0x6c, 0xca, 0x74, 0xf1, 0xf5, 0x5f, 0xc5, 0xbc, 0x79	/* Alistener_array */
	.byte 0x0b, 0x41, 0xf4, 0x5e, 0x3d, 0x93, 0xf6, 0x65, 0x71, 0x6e, 0x75, 0x6d	/* Ataskstats_seqnum */
	.byte 0x08, 0x41, 0xb1, 0xf5, 0xa9, 0xc6, 0x3a, 0xe4, 0x74	/* Auser_stack_count */
	.byte 0x09, 0x41, 0x66, 0xc3, 0x3d, 0xc6, 0x07, 0xf5, 0x76, 0x65	/* Aftrace_stack_reserve */
	.byte 0x06, 0x41, 0x66, 0xc3, 0x3d, 0xc6, 0x73	/* Aftrace_stacks */
	.byte 0x09, 0x41, 0x63, 0x9c, 0x5f, 0xf2, 0x63, 0xd6, 0xe9, 0xa4	/* Acpu_access_lock */
	.byte 0x0c, 0x41, 0xc3, 0x06, 0x66, 0x66, 0x65, 0xf7, 0xda, 0xcc, 0x63, 0x6e, 0x74	/* Atrace_buffered_event_cnt */
	.byte 0x0a, 0x41, 0xc3, 0x06, 0x66, 0x66, 0x65, 0xf7, 0xda, 0xd7, 0x74	/* Atrace_buffered_event */
	.byte 0x0b, 0x41, 0xc3, 0xf4, 0x5e, 0xf8, 0x66, 0x6f, 0xf6, 0x61, 0x76, 0x65	/* Atrace_taskinfo_save */
	.byte 0x08, 0x41, 0x6c, 0x61, 0x7a, 0x1d, 0x6c, 0xca, 0x74	/* Alazy_list */
	.byte 0x08, 0x41, 0xbc, 0xca, 0x65, 0xda, 0x6c, 0xca, 0x74	/* Araised_list */
	.byte 0x0b, 0x41, 0x62, 0x70, 0x3b, 0xb1, 0xf5, 0xa6, 0x6e, 0x64, 0xa9, 0x2c	/* Abpf_user_rnd_state */
	.byte 0x0a, 0x41, 0x6e, 0xbe, 0xa7, 0x78, 0x6e, 0xe6, 0x6c, 0x83, 0x73	/* Anop_txn_flags */
	.byte 0x07, 0x41, 0x73, 0x77, 0xcc, 0x68, 0xe0, 0xc4	/* Aswevent_htable */
	.byte 0x0d, 0x41, 0x19, 0x66, 0xa7, 0x68, 0xe3, 0x74, 0x74, 0xc4, 0x64, 0xf6, 0x65, 0x71	/* Aperf_throttled_seq */
	.byte 0x0d, 0x41, 0x19, 0x66, 0xa7, 0x68, 0xe3, 0x74, 0x74, 0xc4, 0x64, 0x3a, 0xe4, 0x74	/* Aperf_throttled_count */
	.byte 0x0c, 0x41, 0x19, 0x66, 0xf6, 0xba, 0x9e, 0xf0, 0x62, 0x5f, 0xb1, 0x83, 0xd6	/* Aperf_sched_cb_usages */
	.byte 0x0a, 0x41, 0x73, 0xba, 0x9e, 0xf0, 0x62, 0x5f, 0x6c, 0xca, 0x74	/* Asched_cb_list */
	.byte 0x0e, 0x41, 0x72, 0xe4, 0x6e, 0x8d, 0xf6, 0x61, 0xb6, 0xb0, 0x6c, 0xf1, 0x67, 0x74, 0x68	/* Arunning_sample_length */
	.byte 0x09, 0x41, 0x70, 0x6d, 0x75, 0xf6, 0x62, 0x5f, 0xd7, 0x93	/* Apmu_sb_events */
	.byte 0x08, 0x41, 0x19, 0x66, 0xf0, 0x9c, 0x3e, 0x74, 0x8e	/* Aperf_cpu_context */
	.byte 0x07, 0x41, 0xfd, 0xf5, 0x66, 0xde, 0x67, 0x73	/* A__perf_regs */
	.byte 0x0b, 0x41, 0x63, 0x5d, 0xba, 0x61, 0xf8, 0xde, 0x63, 0x98, 0x85, 0xe7	/* Acallchain_recursion */
	.byte 0x16, 0x41, 0xfd, 0xf5, 0x63, 0x9c, 0xa6, 0x77, 0x73, 0x65, 0xae, 0x72, 0xc9, 0x62, 0x70, 0xf0, 0x9c, 0xf8, 0x66, 0x6f, 0xf6, 0x65, 0x6d	/* A__percpu_rwsem_rc_bp_cpuinfo_sem */
	.byte 0x08, 0x41, 0x62, 0x70, 0xf0, 0x9c, 0xf8, 0x66, 0x6f	/* Abp_cpuinfo */
	.byte 0x10, 0x41, 0x75, 0xf7, 0xce, 0x8c, 0xd6, 0xf6, 0x72, 0x63, 0x75, 0xf6, 0x72, 0x63, 0x75, 0xed, 0x0a	/* Auretprobes_srcu_srcu_data */
	.byte 0x13, 0x41, 0xfd, 0xf5, 0x63, 0x9c, 0xa6, 0x77, 0x73, 0x65, 0xae, 0x72, 0x63, 0xed, 0xcd, 0xc1, 0x97, 0xf6, 0x65, 0x6d	/* A__percpu_rwsem_rc_dup_mmap_sem */
	.byte 0x08, 0x41, 0x40, 0x74, 0xcb, 0xfe, 0xdf, 0x6b, 0x8d	/* Acontext_tracking */
	.byte 0x0a, 0x41, 0x62, 0x12, 0xa6, 0xe8, 0xdb, 0x69, 0x6d, 0xea, 0x73	/* Abdp_ratelimits */
	.byte 0x0f, 0x41, 0x64, 0xab, 0x74, 0x79, 0xa7, 0x68, 0xe3, 0x74, 0x74, 0xb0, 0xc4, 0x61, 0x6b, 0x73	/* Adirty_throttle_leaks */
	.byte 0x0d, 0x41, 0x6c, 0x72, 0x75, 0x5f, 0xc8, 0x64, 0xed, 0xbc, 0xf8, 0x92, 0xd5, 0x6b	/* Alru_add_drain_work */
	.byte 0x08, 0x41, 0x63, 0x9c, 0xe6, 0x62, 0xe8, 0xba, 0xd6	/* Acpu_fbatches */
	.byte 0x08, 0x41, 0x76, 0x6d, 0x3d, 0xfe, 0x77, 0xd5, 0x6b	/* Avmstat_work */
	.byte 0x07, 0x41, 0x76, 0xae, 0xcc, 0x3d, 0x74, 0xd6	/* Avm_event_states */
	.byte 0x0a, 0x41, 0x62, 0x6f, 0x6f, 0xfe, 0x6e, 0xb7, 0xd6, 0xf4, 0x93	/* Aboot_nodestats */
	.byte 0x07, 0x41, 0x6d, 0xa4, 0xe6, 0x62, 0xe8, 0xba	/* Amlock_fbatch */
	.byte 0x0a, 0x41, 0x76, 0x97, 0xb8, 0xa4, 0x5f, 0xa1, 0x65, 0x75, 0x65	/* Avmap_block_queue */
	.byte 0x0d, 0x41, 0x6e, 0xfc, 0xa5, 0xfe, 0x70, 0xf7, 0xdd, 0x61, 0xda, 0x6e, 0xb7, 0x65	/* Ane_fit_preload_node */
	.byte 0x0b, 0x41, 0x76, 0x66, 0xf7, 0xfc, 0x64, 0x65, 0x66, 0xf5, 0xf7, 0x64	/* Avfree_deferred */
	.byte 0x0a, 0x41, 0x62, 0x6f, 0x6f, 0xfe, 0x7a, 0xe7, 0xd6, 0xf4, 0x93	/* Aboot_zonestats */
	.byte 0x09, 0x41, 0x62, 0x6f, 0x6f, 0xfe, 0x70, 0x83, 0xd6, 0xd4	/* Aboot_pageset */
	.byte 0x07, 0x41, 0x6e, 0x75, 0xd9, 0xbd, 0xb7, 0x65	/* Anuma_node */
	.byte 0x08, 0x41, 0x73, 0x6c, 0x88, 0xe6, 0x6c, 0xb1, 0x68	/* Aslub_flush */
	.byte 0x07, 0x41, 0x73, 0x77, 0x70, 0xf6, 0xdd, 0x93	/* Aswp_slots */
	.byte 0x0b, 0x41, 0x73, 0x72, 0x63, 0x75, 0xf6, 0x72, 0x63, 0x75, 0xed, 0x0a	/* Asrcu_srcu_data */
	.byte 0x0e, 0x41, 0x6e, 0x72, 0xed, 0xf1, 0xf3, 0x79, 0xbd, 0x65, 0x67, 0xe8, 0x69, 0x76, 0x65	/* Anr_dentry_negative */
	.byte 0x0a, 0x41, 0x6e, 0x72, 0xed, 0xf1, 0xf3, 0x1d, 0xe4, 0xb1, 0x9e	/* Anr_dentry_unused */
	.byte 0x07, 0x41, 0x6e, 0x72, 0xed, 0xf1, 0xf3, 0x79	/* Anr_dentry */
	.byte 0x06, 0x41, 0x6c, 0xbb, 0xfe, 0xf8, 0x6f	/* Alast_ino */
	.byte 0x0b, 0x41, 0x6d, 0x67, 0xf0, 0x00, 0xfc, 0x73, 0x77, 0x61, 0x70, 0x73	/* Amg_ctime_swaps */
	.byte 0x09, 0x41, 0x6d, 0x67, 0xe6, 0xf8, 0xfc, 0x3d, 0xb6, 0x73	/* Amg_fine_stamps */
	.byte 0x0a, 0x41, 0x6d, 0x67, 0xf0, 0x00, 0xfc, 0xcd, 0x64, 0xe8, 0xd6	/* Amg_ctime_updates */
	.byte 0x07, 0x41, 0x6e, 0x72, 0x5f, 0xe4, 0xb1, 0x9e	/* Anr_unused */
	.byte 0x06, 0x41, 0x6e, 0x72, 0xbf, 0xb7, 0xd6	/* Anr_inodes */
	.byte 0x09, 0x41, 0x62, 0x68, 0x5f, 0xf2, 0x03, 0xe4, 0x74, 0x8d	/* Abh_accounting */
	.byte 0x07, 0x41, 0x62, 0x68, 0x5f, 0x6c, 0x72, 0xb1	/* Abh_lrus */
	.byte 0x14, 0x41, 0xfd, 0xf5, 0x63, 0x9c, 0xa6, 0x77, 0x73, 0x65, 0xae, 0x72, 0x63, 0xe6, 0x69, 0xb0, 0x72, 0x77, 0x73, 0x65, 0x6d	/* A__percpu_rwsem_rc_file_rwsem */
	.byte 0x08, 0x41, 0xa5, 0xb0, 0xa4, 0x5f, 0x6c, 0xca, 0x74	/* Afile_lock_list */
	.byte 0x0f, 0x41, 0x64, 0xa1, 0x6f, 0xfe, 0x73, 0x72, 0x63, 0x75, 0xf6, 0x72, 0x63, 0x75, 0xed, 0x0a	/* Adquot_srcu_srcu_data */
	.byte 0x12, 0x41, 0x76, 0x6d, 0x63, 0xd5, 0xfc, 0x63, 0x62, 0xf6, 0x72, 0x63, 0x75, 0xf6, 0x72, 0x63, 0x75, 0xed, 0x0a	/* Avmcore_cb_srcu_srcu_data */
	.byte 0x0b, 0x41, 0x64, 0xca, 0x63, 0xc5, 0x64, 0xec, 0x61, 0xf6, 0x65, 0x71	/* Adiscard_pa_seq */
	.byte 0x0e, 0x41, 0xd7, 0x74, 0x95, 0xf6, 0x72, 0x63, 0x75, 0xf6, 0x72, 0x63, 0x75, 0xed, 0x0a	/* Aeventfs_srcu_srcu_data */
	.byte 0x0a, 0x41, 0x61, 0x76, 0x63, 0xf0, 0xf2, 0x68, 0xfc, 0x3d, 0x93	/* Aavc_cache_stats */
	.byte 0x09, 0x41, 0x73, 0x03, 0xb6, 0xf6, 0x63, 0x72, 0xe8, 0xba	/* Ascomp_scratch */
	.byte 0x09, 0x41, 0x62, 0x6c, 0x6b, 0xf0, 0x9c, 0xf0, 0x73, 0x64	/* Ablk_cpu_csd */
	.byte 0x09, 0x41, 0x62, 0x6c, 0x6b, 0xf0, 0x9c, 0xed, 0xe7, 0x65	/* Ablk_cpu_done */
	.byte 0x0d, 0x41, 0x70, 0xe3, 0x63, 0xd6, 0x73, 0xd5, 0x2b, 0xaa, 0xfc, 0xc5, 0xbc, 0x79	/* Aprocessor_device_array */
	.byte 0x08, 0x41, 0x70, 0xe3, 0x63, 0xd6, 0x73, 0xd5, 0x73	/* Aprocessors */
	.byte 0x14, 0x41, 0x63, 0x9c, 0x66, 0xf7, 0x71, 0xa7, 0x68, 0xf5, 0x6d, 0xe5, 0xde, 0x64, 0x75, 0x63, 0xdc, 0xe7, 0xf6, 0x2c, 0x70	/* Acpufreq_thermal_reduction_step */
	.byte 0x05, 0x41, 0x5c, 0xf0, 0x3d, 0x2c	/* Aacpi_cstate */
	.byte 0x09, 0x41, 0x5c, 0xf0, 0x9c, 0x9f, 0xb0, 0xb5, 0xaa, 0x65	/* Aacpi_cpuidle_device */
	.byte 0x09, 0x41, 0x63, 0x70, 0x63, 0xed, 0xd6, 0x63, 0xec, 0xf3	/* Acpc_desc_ptr */
	.byte 0x0e, 0x41, 0x63, 0x9c, 0xec, 0x63, 0x63, 0xf6, 0x88, 0x73, 0x70, 0xf2, 0xfc, 0x9f, 0x78	/* Acpu_pcc_subspace_idx */
	.byte 0x0a, 0x41, 0xab, 0x71, 0xa6, 0x05, 0x6f, 0x6d, 0x6e, 0xd6, 0x73	/* Airq_randomness */
	.byte 0x0d, 0x41, 0x62, 0xe8, 0xba, 0x65, 0xda, 0xf1, 0xf3, 0xbe, 0x1d, 0x75, 0x36, 0x34	/* Abatched_entropy_u64 */
	.byte 0x0d, 0x41, 0x62, 0xe8, 0xba, 0x65, 0xda, 0xf1, 0xf3, 0xbe, 0x1d, 0x75, 0x33, 0x32	/* Abatched_entropy_u32 */
	.byte 0x0d, 0x41, 0x62, 0xe8, 0xba, 0x65, 0xda, 0xf1, 0xf3, 0xbe, 0x1d, 0x75, 0x31, 0x36	/* Abatched_entropy_u16 */
	.byte 0x0c, 0x41, 0x62, 0xe8, 0xba, 0x65, 0xda, 0xf1, 0xf3, 0xbe, 0x1d, 0x75, 0x38	/* Abatched_entropy_u8 */
	.byte 0x06, 0x41, 0x63, 0x72, 0x6e, 0x67, 0x73	/* Acrngs */
	.byte 0x12, 0x41, 0xac, 0xae, 0xe4, 0x70, 0x6c, 0x75, 0x67, 0xf6, 0x72, 0x63, 0x75, 0xf6, 0x72, 0x63, 0x75, 0xed, 0x0a	/* Adrm_unplug_srcu_srcu_data */
	.byte 0x07, 0x41, 0xdd, 0x63, 0xe5, 0x5f, 0xd7, 0x74	/* Alocal_event */
	.byte 0x10, 0x41, 0xb5, 0xaa, 0xfc, 0x01, 0x73, 0xf6, 0x72, 0x63, 0x75, 0xf6, 0x72, 0x63, 0x75, 0xed, 0x0a	/* Adevice_links_srcu_srcu_data */
	.byte 0x08, 0x41, 0x63, 0x9c, 0x7f, 0x73, 0x2b, 0xaa, 0xd6	/* Acpu_sys_devices */
	.byte 0x06, 0x41, 0x63, 0x9c, 0x2b, 0xaa, 0xd6	/* Acpu_devices */
	.byte 0x06, 0x41, 0x9b, 0xbf, 0x64, 0xcb, 0x2b	/* Aci_index_dev */
	.byte 0x07, 0x41, 0x9b, 0xf0, 0xf2, 0x68, 0xfc, 0xb5	/* Aci_cache_dev */
	.byte 0x0b, 0x41, 0x9b, 0xf0, 0x9c, 0xf0, 0xf2, 0x68, 0x65, 0xf8, 0x66, 0x6f	/* Aci_cpu_cacheinfo */
	.byte 0x10, 0x41, 0x77, 0x61, 0x6b, 0x65, 0xcd, 0xf6, 0x72, 0x63, 0x75, 0xf6, 0x72, 0x63, 0x75, 0xed, 0x0a	/* Awakeup_srcu_srcu_data */
	.byte 0x08, 0x41, 0x74, 0x68, 0xf5, 0x6d, 0xe5, 0xa9, 0x2c	/* Athermal_state */
	.byte 0x1f, 0x41, 0x63, 0x9c, 0x66, 0xf7, 0x71, 0x5f, 0xf3, 0xd2, 0x73, 0xea, 0x69, 0xe7, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0x5f, 0x6c, 0xca, 0xfe, 0x68, 0x65, 0xc8, 0xf6, 0x72, 0x63, 0x75, 0xed, 0x0a	/* Acpufreq_transition_notifier_list_head_srcu_data */
	.byte 0x0a, 0x41, 0x63, 0x9c, 0x66, 0xf7, 0x71, 0xf0, 0x9c, 0xed, 0x0a	/* Acpufreq_cpu_data */
	.byte 0x0b, 0x41, 0x63, 0x9c, 0x66, 0xf7, 0x71, 0xec, 0x29, 0x73, 0x75, 0xf7	/* Acpufreq_pressure */
	.byte 0x06, 0x41, 0x63, 0x9c, 0xed, 0x62, 0x73	/* Acpu_dbs */
	.byte 0x06, 0x41, 0x63, 0x9c, 0x9f, 0xb0, 0xb5	/* Acpuidle_dev */
	.byte 0x08, 0x41, 0x63, 0x9c, 0x9f, 0xb0, 0xb5, 0xaa, 0xd6	/* Acpuidle_devices */
	.byte 0x07, 0x41, 0x6d, 0xf1, 0x75, 0x2b, 0xaa, 0xd6	/* Amenu_devices */
	.byte 0x0b, 0x41, 0x6e, 0x61, 0xb2, 0x5f, 0x22, 0x63, 0xf0, 0xf2, 0x68, 0x65	/* Anapi_alloc_cache */
	.byte 0x0b, 0x41, 0x6e, 0xd4, 0xb5, 0x5f, 0x22, 0x63, 0xf0, 0xf2, 0x68, 0x65	/* Anetdev_alloc_cache */
	.byte 0x09, 0x41, 0xff, 0x6e, 0xe2, 0x03, 0x6f, 0x6b, 0x69, 0x65	/* A__net_cookie */
	.byte 0x09, 0x41, 0x66, 0x6c, 0xb1, 0x68, 0x92, 0xd5, 0x6b, 0x73	/* Aflush_works */
	.byte 0x09, 0x41, 0x62, 0xf2, 0x6b, 0xdd, 0x67, 0xbd, 0x61, 0xb2	/* Abacklog_napi */
	.byte 0x0b, 0x41, 0xe1, 0x73, 0x2c, 0x6d, 0xec, 0x83, 0xfc, 0x70, 0x6f, 0xa0	/* Asystem_page_pool */
	.byte 0x0a, 0x41, 0xff, 0x73, 0x6f, 0xc6, 0x3a, 0x6f, 0x6b, 0x69, 0x65	/* A__sock_cookie */
	.byte 0x0d, 0x41, 0x73, 0xba, 0xe6, 0xbc, 0x67, 0xed, 0x0a, 0xf6, 0x74, 0xd5, 0x83, 0x65	/* Asch_frag_data_storage */
	.byte 0x0c, 0x41, 0x6e, 0x66, 0xf6, 0x6b, 0x62, 0xed, 0xcd, 0x6c, 0xaa, 0xe8, 0x9e	/* Anf_skb_duplicated */
	.byte 0x08, 0x41, 0x78, 0xfe, 0xf7, 0x63, 0x73, 0x65, 0x71	/* Axt_recseq */
	.byte 0x09, 0x41, 0x72, 0xfe, 0x63, 0xf2, 0x68, 0xfc, 0x3d, 0x74	/* Art_cache_stat */
	.byte 0x10, 0x41, 0x26, 0x70, 0xc1, 0x65, 0x6d, 0xd5, 0x79, 0xec, 0xf5, 0xf0, 0x9c, 0xe6, 0x8f, 0x22, 0x63	/* Atcp_memory_per_cpu_fw_alloc */
	.byte 0x07, 0x41, 0x26, 0x70, 0xa7, 0x8f, 0xca, 0x6e	/* Atcp_tw_isn */
	.byte 0x0b, 0x41, 0x26, 0x70, 0x5f, 0xd5, 0x70, 0x68, 0xd2, 0x3a, 0xe4, 0x74	/* Atcp_orphan_count */
	.byte 0x08, 0x41, 0x93, 0x71, 0x5f, 0xf4, 0x5e, 0x6c, 0xd4	/* Atsq_tasklet */
	.byte 0x09, 0x41, 0x28, 0x76, 0x34, 0xa7, 0x63, 0x70, 0xf6, 0x6b	/* Aipv4_tcp_sk */
	.byte 0x10, 0x41, 0x75, 0x12, 0xc1, 0x65, 0x6d, 0xd5, 0x79, 0xec, 0xf5, 0xf0, 0x9c, 0xe6, 0x8f, 0x22, 0x63	/* Audp_memory_per_cpu_fw_alloc */
	.byte 0x09, 0x41, 0x28, 0x76, 0x34, 0x5f, 0xaa, 0xb6, 0xf6, 0x6b	/* Aipv4_icmp_sk */
	.byte 0x0b, 0x41, 0x85, 0x67, 0x70, 0x6f, 0xa0, 0xf6, 0x63, 0x72, 0xe8, 0xba	/* Asigpool_scratch */
	.byte 0x0c, 0x41, 0x78, 0x66, 0x72, 0xae, 0xf3, 0xd2, 0xe9, 0xf4, 0x5e, 0x6c, 0xd4	/* Axfrm_trans_tasklet */
	.byte 0x0f, 0x41, 0x6e, 0x61, 0xfe, 0x6b, 0x8b, 0x70, 0xe5, 0x69, 0x1a, 0x5e, 0x5f, 0x28, 0x76, 0x36	/* Anat_keepalive_sk_ipv6 */
	.byte 0x0f, 0x41, 0x6e, 0x61, 0xfe, 0x6b, 0x8b, 0x70, 0xe5, 0x69, 0x1a, 0x5e, 0x5f, 0x28, 0x76, 0x34	/* Anat_keepalive_sk_ipv4 */
	.byte 0x09, 0x41, 0x28, 0x76, 0x36, 0x5f, 0xaa, 0xb6, 0xf6, 0x6b	/* Aipv6_icmp_sk */
	.byte 0x10, 0x41, 0x64, 0xca, 0xf3, 0x69, 0x62, 0x20, 0xfc, 0x63, 0x9c, 0x5f, 0xd9, 0x5e, 0xec, 0xf7, 0x76	/* Adistribute_cpu_mask_prev */
	.byte 0x07, 0x41, 0xff, 0xab, 0x71, 0xde, 0x67, 0x73	/* A__irq_regs */
	.byte 0x0d, 0x41, 0x72, 0xc8, 0x69, 0x78, 0xa7, 0xf7, 0xfc, 0x70, 0xf7, 0xdd, 0xc8, 0x73	/* Aradix_tree_preloads */
	.byte 0x05, 0x41, 0xab, 0x71, 0xa9, 0x74	/* Airq_stat */
	.byte 0x07, 0x41, 0x63, 0x79, 0x63, 0x32, 0x6e, 0x73	/* Acyc2ns */
	.byte 0x0a, 0x41, 0x40, 0x73, 0xfe, 0x70, 0x63, 0x9c, 0xa3, 0x6f, 0x74	/* Aconst_pcpu_hot */
	.byte 0x07, 0x41, 0x70, 0x63, 0x9c, 0xa3, 0x6f, 0x74	/* Apcpu_hot */
	.byte 0x08, 0x41, 0x63, 0x9c, 0xf6, 0x61, 0xb6, 0x6c, 0xd6	/* Acpu_samples */
	.byte 0x0a, 0x41, 0x6d, 0x77, 0x61, 0x9d, 0x63, 0x9c, 0xed, 0x65, 0xc8	/* Amwait_cpu_dead */
	.byte 0x08, 0x41, 0x63, 0x9c, 0xa7, 0x6c, 0x62, 0x3d, 0x2c	/* Acpu_tlbstate */
	.byte 0x0b, 0x41, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0xbf, 0x66, 0x6f	/* Aflush_tlb_info */
	.byte 0x0e, 0x41, 0x63, 0x9c, 0xa7, 0x6c, 0x62, 0x3d, 0x74, 0xfc, 0x73, 0x68, 0x61, 0xf7, 0x64	/* Acpu_tlbstate_shared */
	.byte 0x0b, 0x41, 0x63, 0x9c, 0x92, 0xd5, 0x6b, 0xf5, 0xec, 0x6f, 0xa0, 0x73	/* Acpu_worker_pools */
	.byte 0x0b, 0x41, 0x62, 0x68, 0x92, 0xd5, 0x6b, 0xf5, 0xec, 0x6f, 0xa0, 0x73	/* Abh_worker_pools */
	.byte 0x0d, 0x41, 0x62, 0x68, 0xec, 0x6f, 0xa0, 0x5f, 0xab, 0x71, 0x92, 0xd5, 0x6b, 0x73	/* Abh_pool_irq_works */
	.byte 0x07, 0x41, 0x72, 0xe4, 0xa1, 0x65, 0x75, 0xd6	/* Arunqueues */
	.byte 0x08, 0x41, 0x73, 0xba, 0x9e, 0xf0, 0xa4, 0xed, 0x0a	/* Asched_clock_data */
	.byte 0x07, 0x41, 0x6f, 0x73, 0x71, 0xbd, 0xb7, 0x65	/* Aosq_node */
	.byte 0x05, 0x41, 0x71, 0x6e, 0xb7, 0xd6	/* Aqnodes */
	.byte 0x06, 0x41, 0x72, 0x63, 0x75, 0xed, 0x0a	/* Arcu_data */
	.byte 0x06, 0x41, 0x63, 0x73, 0x64, 0xed, 0x0a	/* Acsd_data */
	.byte 0x0a, 0x41, 0x63, 0x5d, 0xf6, 0x8d, 0xb0, 0xa1, 0x65, 0x75, 0x65	/* Acall_single_queue */
	.byte 0x06, 0x41, 0x63, 0x66, 0x64, 0xed, 0x0a	/* Acfd_data */
	.byte 0x0d, 0x41, 0x6e, 0x95, 0x34, 0xf0, 0x5d, 0x62, 0xf2, 0x6b, 0x3a, 0xe4, 0x74, 0x34	/* Anfs4_callback_count4 */
	.byte 0x0d, 0x41, 0x6e, 0x95, 0x34, 0xf0, 0x5d, 0x62, 0xf2, 0x6b, 0x3a, 0xe4, 0x74, 0x31	/* Anfs4_callback_count1 */
	.byte 0x0e, 0x41, 0x6e, 0x6c, 0x6d, 0x73, 0x76, 0xc9, 0x0b, 0x85, 0xe7, 0x34, 0x3a, 0xe4, 0x74	/* Anlmsvc_version4_count */
	.byte 0x0e, 0x41, 0x6e, 0x6c, 0x6d, 0x73, 0x76, 0xc9, 0x0b, 0x85, 0xe7, 0x33, 0x3a, 0xe4, 0x74	/* Anlmsvc_version3_count */
	.byte 0x0e, 0x41, 0x6e, 0x6c, 0x6d, 0x73, 0x76, 0xc9, 0x0b, 0x85, 0xe7, 0x31, 0x3a, 0xe4, 0x74	/* Anlmsvc_version1_count */
	.byte 0x09, 0x41, 0x73, 0x6f, 0x66, 0x74, 0x6e, 0xe2, 0x64, 0x0a	/* Asoftnet_data */
	.byte 0x0b, 0x41, 0x72, 0xfe, 0x96, 0xf2, 0x68, 0x65, 0xda, 0x6c, 0xca, 0x74	/* Art_uncached_list */
	.byte 0x0d, 0x41, 0x72, 0x74, 0x36, 0x5f, 0x96, 0xf2, 0x68, 0x65, 0xda, 0x6c, 0xca, 0x74	/* Art6_uncached_list */
	.byte 0x07, 0x41, 0xfd, 0xf5, 0xf0, 0x9c, 0x0d, 0x64	/* A__per_cpu_end */
	.byte 0x08, 0x54, 0x3d, 0x72, 0x74, 0xcd, 0x5f, 0x36, 0x34	/* Tstartup_64 */
	.byte 0x04, 0x54, 0xf6, 0x74, 0x8e	/* T_stext */
	.byte 0x03, 0x54, 0xa7, 0x8e	/* T_text */
	.byte 0x08, 0x99, 0xa9, 0x72, 0x74, 0xcd, 0x5f, 0x36, 0x34	/* T__pfx___startup_64 */
	.byte 0x08, 0xb9, 0x3d, 0x72, 0x74, 0xcd, 0x5f, 0x36, 0x34	/* T__startup_64 */
	.byte 0x10, 0xeb, 0x3d, 0x72, 0x74, 0xcd, 0x5f, 0x36, 0x34, 0xf6, 0xd4, 0xcd, 0xc7, 0x64, 0xfe, 0x9f, 0x74	/* T__pfx_startup_64_setup_gdt_idt */
	.byte 0x10, 0x54, 0x3d, 0x72, 0x74, 0xcd, 0x5f, 0x36, 0x34, 0xf6, 0xd4, 0xcd, 0xc7, 0x64, 0xfe, 0x9f, 0x74	/* Tstartup_64_setup_gdt_idt */
	.byte 0x0a, 0xb9, 0x73, 0x70, 0x6c, 0x9d, 0x74, 0xcb, 0xfe, 0xf1, 0x64	/* T__split_text_end */
	.byte 0x0b, 0xb9, 0x73, 0x70, 0x6c, 0x9d, 0x74, 0xcb, 0xfe, 0x3d, 0x72, 0x74	/* T__split_text_start */
	.byte 0x0d, 0xb9, 0xe4, 0x6c, 0x69, 0x6b, 0xdb, 0x79, 0xa7, 0xcb, 0xfe, 0x3d, 0x72, 0x74	/* T__unlikely_text_start */
	.byte 0x05, 0x57, 0xf9, 0x90, 0xd5, 0x74	/* W__pfx_abort */
	.byte 0x04, 0x57, 0x90, 0xd5, 0x74	/* Wabort */
	.byte 0x0c, 0xb9, 0xe4, 0x6c, 0x69, 0x6b, 0xdb, 0x79, 0xa7, 0xcb, 0xfe, 0xf1, 0x64	/* T__unlikely_text_end */
	.byte 0x0a, 0x08, 0x18, 0xbf, 0xea, 0x63, 0x5d, 0x5f, 0x6c, 0xee, 0xdb	/* T__pfx___traceiter_initcall_level */
	.byte 0x09, 0xb9, 0x68, 0x6f, 0xfe, 0x74, 0xcb, 0xfe, 0xf1, 0x64	/* T__hot_text_end */
	.byte 0x0a, 0xb9, 0x68, 0x6f, 0xfe, 0x74, 0xcb, 0xfe, 0x3d, 0x72, 0x74	/* T__hot_text_start */
	.byte 0x0a, 0xb9, 0x18, 0xbf, 0xea, 0x63, 0x5d, 0x5f, 0x6c, 0xee, 0xdb	/* T__traceiter_initcall_level */
	.byte 0x0b, 0x99, 0xec, 0x10, 0xbf, 0xea, 0x63, 0x5d, 0x5f, 0x6c, 0xee, 0xdb	/* T__pfx___probestub_initcall_level */
	.byte 0x0b, 0x54, 0xfd, 0x10, 0xbf, 0xea, 0x63, 0x5d, 0x5f, 0x6c, 0xee, 0xdb	/* T__probestub_initcall_level */
	.byte 0x09, 0x08, 0x18, 0xbf, 0xea, 0x63, 0x5d, 0xa9, 0x72, 0x74	/* T__pfx___traceiter_initcall_start */
	.byte 0x09, 0xb9, 0x18, 0xbf, 0xea, 0x63, 0x5d, 0xa9, 0x72, 0x74	/* T__traceiter_initcall_start */
	.byte 0x0a, 0x99, 0xec, 0x10, 0xbf, 0xea, 0x63, 0x5d, 0xa9, 0x72, 0x74	/* T__pfx___probestub_initcall_start */
	.byte 0x0a, 0x54, 0xfd, 0x10, 0xbf, 0xea, 0x63, 0x5d, 0xa9, 0x72, 0x74	/* T__probestub_initcall_start */
	.byte 0x0a, 0x08, 0x18, 0xbf, 0xea, 0x63, 0x5d, 0xe6, 0xf8, 0xca, 0x68	/* T__pfx___traceiter_initcall_finish */
	.byte 0x0a, 0xb9, 0x18, 0xbf, 0xea, 0x63, 0x5d, 0xe6, 0xf8, 0xca, 0x68	/* T__traceiter_initcall_finish */
	.byte 0x0b, 0x99, 0xec, 0x10, 0xbf, 0xea, 0x63, 0x5d, 0xe6, 0xf8, 0xca, 0x68	/* T__pfx___probestub_initcall_finish */
	.byte 0x0b, 0x54, 0xfd, 0x10, 0xbf, 0xea, 0x63, 0x5d, 0xe6, 0xf8, 0xca, 0x68	/* T__probestub_initcall_finish */
	.byte 0x0a, 0xef, 0xc3, 0x0f, 0x63, 0x5d, 0xa9, 0x72, 0xfe, 0x63, 0x62	/* t__pfx_trace_initcall_start_cb */
	.byte 0x0a, 0x74, 0xc3, 0x0f, 0x63, 0x5d, 0xa9, 0x72, 0xfe, 0x63, 0x62	/* ttrace_initcall_start_cb */
	.byte 0x0a, 0xef, 0x72, 0xe4, 0xbf, 0x9d, 0x70, 0xe3, 0x63, 0xd6, 0x73	/* t__pfx_run_init_process */
	.byte 0x09, 0xf3, 0xe4, 0xbf, 0x9d, 0x70, 0xe3, 0x63, 0xd6, 0x73	/* trun_init_process */
	.byte 0x0b, 0xef, 0x19, 0x3b, 0xc3, 0x0f, 0x63, 0x5d, 0x5f, 0x6c, 0xee, 0xdb	/* t__pfx_perf_trace_initcall_level */
	.byte 0x0b, 0xce, 0xf5, 0x3b, 0xc3, 0x0f, 0x63, 0x5d, 0x5f, 0x6c, 0xee, 0xdb	/* tperf_trace_initcall_level */
	.byte 0x0a, 0xef, 0x19, 0x3b, 0xc3, 0x0f, 0x63, 0x5d, 0xa9, 0x72, 0x74	/* t__pfx_perf_trace_initcall_start */
	.byte 0x0a, 0xce, 0xf5, 0x3b, 0xc3, 0x0f, 0x63, 0x5d, 0xa9, 0x72, 0x74	/* tperf_trace_initcall_start */
	.byte 0x0b, 0xef, 0x19, 0x3b, 0xc3, 0x0f, 0x63, 0x5d, 0xe6, 0xf8, 0xca, 0x68	/* t__pfx_perf_trace_initcall_finish */
	.byte 0x0b, 0xce, 0xf5, 0x3b, 0xc3, 0x0f, 0x63, 0x5d, 0xe6, 0xf8, 0xca, 0x68	/* tperf_trace_initcall_finish */
	.byte 0x0a, 0xef, 0x7d, 0x7b, 0xcc, 0x0f, 0x63, 0x5d, 0xa9, 0x72, 0x74	/* t__pfx_trace_event_raw_event_initcall_start */
	.byte 0x0a, 0x74, 0x7d, 0x7b, 0xcc, 0x0f, 0x63, 0x5d, 0xa9, 0x72, 0x74	/* ttrace_event_raw_event_initcall_start */
	.byte 0x0b, 0xef, 0x7d, 0x7b, 0xcc, 0x0f, 0x63, 0x5d, 0xe6, 0xf8, 0xca, 0x68	/* t__pfx_trace_event_raw_event_initcall_finish */
	.byte 0x0b, 0x74, 0x7d, 0x7b, 0xcc, 0x0f, 0x63, 0x5d, 0xe6, 0xf8, 0xca, 0x68	/* ttrace_event_raw_event_initcall_finish */
	.byte 0x0e, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x0f, 0x63, 0x5d, 0x5f, 0x6c, 0xee, 0xdb	/* t__pfx_trace_raw_output_initcall_level */
	.byte 0x0e, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x0f, 0x63, 0x5d, 0x5f, 0x6c, 0xee, 0xdb	/* ttrace_raw_output_initcall_level */
	.byte 0x0d, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x0f, 0x63, 0x5d, 0xa9, 0x72, 0x74	/* t__pfx_trace_raw_output_initcall_start */
	.byte 0x0d, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x0f, 0x63, 0x5d, 0xa9, 0x72, 0x74	/* ttrace_raw_output_initcall_start */
	.byte 0x0e, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x0f, 0x63, 0x5d, 0xe6, 0xf8, 0xca, 0x68	/* t__pfx_trace_raw_output_initcall_finish */
	.byte 0x0e, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x0f, 0x63, 0x5d, 0xe6, 0xf8, 0xca, 0x68	/* ttrace_raw_output_initcall_finish */
	.byte 0x0c, 0xef, 0x0f, 0x63, 0x5d, 0xb8, 0x6c, 0xf2, 0x6b, 0x6c, 0xca, 0x74, 0x9e	/* t__pfx_initcall_blacklisted */
	.byte 0x0c, 0x74, 0x0f, 0x63, 0x5d, 0xb8, 0x6c, 0xf2, 0x6b, 0x6c, 0xca, 0x74, 0x9e	/* tinitcall_blacklisted */
	.byte 0x0b, 0xef, 0xc3, 0x0f, 0x63, 0x5d, 0xe6, 0xf8, 0xca, 0x68, 0xf0, 0x62	/* t__pfx_trace_initcall_finish_cb */
	.byte 0x0b, 0x74, 0xc3, 0x0f, 0x63, 0x5d, 0xe6, 0xf8, 0xca, 0x68, 0xf0, 0x62	/* ttrace_initcall_finish_cb */
	.byte 0x0b, 0xef, 0x7d, 0x7b, 0xcc, 0x0f, 0x63, 0x5d, 0x5f, 0x6c, 0xee, 0xdb	/* t__pfx_trace_event_raw_event_initcall_level */
	.byte 0x0b, 0x74, 0x7d, 0x7b, 0xcc, 0x0f, 0x63, 0x5d, 0x5f, 0x6c, 0xee, 0xdb	/* ttrace_event_raw_event_initcall_level */
	.byte 0x09, 0xeb, 0x64, 0x6f, 0x5f, 0xe7, 0xfc, 0x0f, 0x63, 0x5d	/* T__pfx_do_one_initcall */
	.byte 0x09, 0x54, 0x64, 0x6f, 0x5f, 0xe7, 0xfc, 0x0f, 0x63, 0x5d	/* Tdo_one_initcall */
	.byte 0x0b, 0xef, 0xe3, 0x6f, 0x74, 0x80, 0xf8, 0x9d, 0x95, 0x3e, 0x74, 0x8e	/* t__pfx_rootfs_init_fs_context */
	.byte 0x0b, 0xf3, 0x6f, 0x6f, 0x74, 0x80, 0xf8, 0x9d, 0x95, 0x3e, 0x74, 0x8e	/* trootfs_init_fs_context */
	.byte 0x0b, 0xeb, 0x77, 0x61, 0x9d, 0x66, 0xd5, 0xbf, 0x69, 0xf3, 0x2a, 0x95	/* T__pfx_wait_for_initramfs */
	.byte 0x0b, 0x54, 0x77, 0x61, 0x9d, 0x66, 0xd5, 0xbf, 0x69, 0xf3, 0x2a, 0x95	/* Twait_for_initramfs */
	.byte 0x11, 0x57, 0xf9, 0x63, 0xe5, 0x69, 0x62, 0x72, 0xe8, 0x69, 0xe7, 0xed, 0xdb, 0x61, 0x79, 0xed, 0xe7, 0x65	/* W__pfx_calibration_delay_done */
	.byte 0x10, 0x57, 0x63, 0xe5, 0x69, 0x62, 0x72, 0xe8, 0x69, 0xe7, 0xed, 0xdb, 0x61, 0x79, 0xed, 0xe7, 0x65	/* Wcalibration_delay_done */
	.byte 0x0b, 0xeb, 0x63, 0xe5, 0x69, 0x62, 0x72, 0x91, 0x64, 0xdb, 0x61, 0x79	/* T__pfx_calibrate_delay */
	.byte 0x0b, 0x54, 0x63, 0xe5, 0x69, 0x62, 0x72, 0x91, 0x64, 0xdb, 0x61, 0x79	/* Tcalibrate_delay */
	.byte 0x0c, 0xeb, 0x77, 0xc5, 0x6e, 0xa7, 0x68, 0xe4, 0x6b, 0xa7, 0x68, 0xe4, 0x6b	/* T__pfx_warn_thunk_thunk */
	.byte 0x0c, 0x54, 0x77, 0xc5, 0x6e, 0xa7, 0x68, 0xe4, 0x6b, 0xa7, 0x68, 0xe4, 0x6b	/* Twarn_thunk_thunk */
	.byte 0x0a, 0x99, 0xf6, 0x77, 0xea, 0xba, 0xa7, 0x6f, 0x5f, 0xbb, 0x6d	/* T__pfx___switch_to_asm */
	.byte 0x0a, 0xb9, 0x73, 0x77, 0xea, 0xba, 0xa7, 0x6f, 0x5f, 0xbb, 0x6d	/* T__switch_to_asm */
	.byte 0x0c, 0x54, 0xf7, 0xfe, 0x66, 0xe3, 0x6d, 0xe6, 0xd5, 0x6b, 0x5f, 0xbb, 0x6d	/* Tret_from_fork_asm */
	.byte 0x10, 0x54, 0xf7, 0x77, 0xf8, 0x64, 0xa9, 0xc6, 0x5f, 0xd2, 0xda, 0xd9, 0x6b, 0xfc, 0x64, 0x65, 0xc8	/* Trewind_stack_and_make_dead */
	.byte 0x08, 0xeb, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf0, 0x5d	/* T__pfx_x64_sys_call */
	.byte 0x08, 0x54, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf0, 0x5d	/* Tx64_sys_call */
	.byte 0x17, 0xef, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x65, 0x6d, 0x02, 0xe8, 0x69, 0xe7, 0x5f, 0x6f, 0x0b, 0x72, 0x9f, 0xfc, 0x63, 0x6d, 0x64, 0x2d, 0x65	/* t__pfx_ia32_emulation_override_cmdline */
	.byte 0x16, 0xdc, 0x61, 0x33, 0x32, 0x5f, 0x65, 0x6d, 0x02, 0xe8, 0x69, 0xe7, 0x5f, 0x6f, 0x0b, 0x72, 0x9f, 0xfc, 0x63, 0x6d, 0x64, 0x2d, 0x65	/* tia32_emulation_override_cmdline */
	.byte 0x0c, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0xe9, 0x6e, 0x69, 0x7f, 0x73, 0x63, 0x5d	/* t__pfx___do_sys_ni_syscall */
	.byte 0x0d, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x6e, 0x69, 0x7f, 0x73, 0x63, 0x5d	/* T__pfx___ia32_sys_ni_syscall */
	.byte 0x0c, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x6e, 0x69, 0x7f, 0x73, 0x63, 0x5d	/* T__pfx___x64_sys_ni_syscall */
	.byte 0x0c, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0xe9, 0x6e, 0x69, 0x7f, 0x73, 0x63, 0x5d	/* t__do_sys_ni_syscall */
	.byte 0x0d, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x6e, 0x69, 0x7f, 0x73, 0x63, 0x5d	/* T__ia32_sys_ni_syscall */
	.byte 0x0c, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x6e, 0x69, 0x7f, 0x73, 0x63, 0x5d	/* T__x64_sys_ni_syscall */
	.byte 0x08, 0xef, 0x76, 0x64, 0x73, 0x6f, 0xc1, 0xf7, 0x97	/* t__pfx_vdso_mremap */
	.byte 0x08, 0x74, 0x76, 0x64, 0x73, 0x6f, 0xc1, 0xf7, 0x97	/* tvdso_mremap */
	.byte 0x08, 0xef, 0x76, 0x76, 0xc5, 0xe6, 0x61, 0x02, 0x74	/* t__pfx_vvar_fault */
	.byte 0x08, 0x74, 0x76, 0x76, 0xc5, 0xe6, 0x61, 0x02, 0x74	/* tvvar_fault */
	.byte 0x0c, 0xef, 0x76, 0x76, 0xc5, 0x5f, 0x76, 0x63, 0xa4, 0xe6, 0x61, 0x02, 0x74	/* t__pfx_vvar_vclock_fault */
	.byte 0x0c, 0x74, 0x76, 0x76, 0xc5, 0x5f, 0x76, 0x63, 0xa4, 0xe6, 0x61, 0x02, 0x74	/* tvvar_vclock_fault */
	.byte 0x09, 0xef, 0x76, 0x64, 0x73, 0x6f, 0xe6, 0x61, 0x02, 0x74	/* t__pfx_vdso_fault */
	.byte 0x09, 0x74, 0x76, 0x64, 0x73, 0x6f, 0xe6, 0x61, 0x02, 0x74	/* tvdso_fault */
	.byte 0x07, 0xef, 0x97, 0x5f, 0x76, 0x64, 0x73, 0x6f	/* t__pfx_map_vdso */
	.byte 0x07, 0x74, 0x97, 0x5f, 0x76, 0x64, 0x73, 0x6f	/* tmap_vdso */
	.byte 0x0a, 0xeb, 0xc5, 0xba, 0x86, 0x76, 0x64, 0x73, 0x6f, 0xed, 0x0a	/* T__pfx_arch_get_vdso_data */
	.byte 0x0a, 0x54, 0xc5, 0xba, 0x86, 0x76, 0x64, 0x73, 0x6f, 0xed, 0x0a	/* Tarch_get_vdso_data */
	.byte 0x0d, 0xeb, 0x76, 0x64, 0x73, 0x6f, 0x5f, 0x6a, 0x6f, 0xf8, 0x5f, 0x00, 0xf1, 0x73	/* T__pfx_vdso_join_timens */
	.byte 0x0d, 0x54, 0x76, 0x64, 0x73, 0x6f, 0x5f, 0x6a, 0x6f, 0xf8, 0x5f, 0x00, 0xf1, 0x73	/* Tvdso_join_timens */
	.byte 0x0b, 0xeb, 0x97, 0x5f, 0x76, 0x64, 0x73, 0x6f, 0x5f, 0xe7, 0x63, 0x65	/* T__pfx_map_vdso_once */
	.byte 0x0b, 0x54, 0x97, 0x5f, 0x76, 0x64, 0x73, 0x6f, 0x5f, 0xe7, 0x63, 0x65	/* Tmap_vdso_once */
	.byte 0x10, 0xeb, 0xc5, 0xba, 0xf6, 0xd4, 0xcd, 0x5f, 0xc8, 0x64, 0xea, 0x69, 0xe7, 0xe5, 0xec, 0x83, 0xd6	/* T__pfx_arch_setup_additional_pages */
	.byte 0x10, 0x54, 0xc5, 0xba, 0xf6, 0xd4, 0xcd, 0x5f, 0xc8, 0x64, 0xea, 0x69, 0xe7, 0xe5, 0xec, 0x83, 0xd6	/* Tarch_setup_additional_pages */
	.byte 0x14, 0xeb, 0x03, 0xb6, 0x61, 0xfe, 0xc5, 0xba, 0xf6, 0xd4, 0xcd, 0x5f, 0xc8, 0x64, 0xea, 0x69, 0xe7, 0xe5, 0xec, 0x83, 0xd6	/* T__pfx_compat_arch_setup_additional_pages */
	.byte 0x14, 0x54, 0x03, 0xb6, 0x61, 0xfe, 0xc5, 0xba, 0xf6, 0xd4, 0xcd, 0x5f, 0xc8, 0x64, 0xea, 0x69, 0xe7, 0xe5, 0xec, 0x83, 0xd6	/* Tcompat_arch_setup_additional_pages */
	.byte 0x14, 0xeb, 0xc5, 0xba, 0x7f, 0x73, 0x63, 0x5d, 0x5f, 0x69, 0xe9, 0x76, 0x64, 0x73, 0x6f, 0xf6, 0x0c, 0xf7, 0x74, 0x98, 0x6e	/* T__pfx_arch_syscall_is_vdso_sigreturn */
	.byte 0x14, 0x54, 0xc5, 0xba, 0x7f, 0x73, 0x63, 0x5d, 0x5f, 0x69, 0xe9, 0x76, 0x64, 0x73, 0x6f, 0xf6, 0x0c, 0xf7, 0x74, 0x98, 0x6e	/* Tarch_syscall_is_vdso_sigreturn */
	.byte 0x10, 0xeb, 0xa5, 0x78, 0xcd, 0x5f, 0x76, 0x64, 0x73, 0x6f, 0x5f, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7	/* T__pfx_fixup_vdso_exception */
	.byte 0x10, 0x54, 0xa5, 0x78, 0xcd, 0x5f, 0x76, 0x64, 0x73, 0x6f, 0x5f, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7	/* Tfixup_vdso_exception */
	.byte 0x0c, 0x08, 0x18, 0x5f, 0x65, 0x6d, 0x02, 0x91, 0x76, 0xe1, 0x73, 0x63, 0x5d	/* T__pfx___traceiter_emulate_vsyscall */
	.byte 0x0c, 0xb9, 0x18, 0x5f, 0x65, 0x6d, 0x02, 0x91, 0x76, 0xe1, 0x73, 0x63, 0x5d	/* T__traceiter_emulate_vsyscall */
	.byte 0x0d, 0x99, 0xec, 0x10, 0x5f, 0x65, 0x6d, 0x02, 0x91, 0x76, 0xe1, 0x73, 0x63, 0x5d	/* T__pfx___probestub_emulate_vsyscall */
	.byte 0x0d, 0x54, 0xfd, 0x10, 0x5f, 0x65, 0x6d, 0x02, 0x91, 0x76, 0xe1, 0x73, 0x63, 0x5d	/* T__probestub_emulate_vsyscall */
	.byte 0x08, 0xef, 0x67, 0x91, 0x76, 0xd9, 0xbd, 0x61, 0xa8	/* t__pfx_gate_vma_name */
	.byte 0x08, 0x74, 0x67, 0x91, 0x76, 0xd9, 0xbd, 0x61, 0xa8	/* tgate_vma_name */
	.byte 0x0d, 0xef, 0x19, 0x3b, 0xc3, 0x65, 0x6d, 0x02, 0x91, 0x76, 0xe1, 0x73, 0x63, 0x5d	/* t__pfx_perf_trace_emulate_vsyscall */
	.byte 0x0d, 0xce, 0xf5, 0x3b, 0xc3, 0x65, 0x6d, 0x02, 0x91, 0x76, 0xe1, 0x73, 0x63, 0x5d	/* tperf_trace_emulate_vsyscall */
	.byte 0x0d, 0xef, 0x7d, 0x7b, 0xcc, 0x65, 0x6d, 0x02, 0x91, 0x76, 0xe1, 0x73, 0x63, 0x5d	/* t__pfx_trace_event_raw_event_emulate_vsyscall */
	.byte 0x0d, 0x74, 0x7d, 0x7b, 0xcc, 0x65, 0x6d, 0x02, 0x91, 0x76, 0xe1, 0x73, 0x63, 0x5d	/* ttrace_event_raw_event_emulate_vsyscall */
	.byte 0x10, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x65, 0x6d, 0x02, 0x91, 0x76, 0xe1, 0x73, 0x63, 0x5d	/* t__pfx_trace_raw_output_emulate_vsyscall */
	.byte 0x10, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x65, 0x6d, 0x02, 0x91, 0x76, 0xe1, 0x73, 0x63, 0x5d	/* ttrace_raw_output_emulate_vsyscall */
	.byte 0x0c, 0xef, 0x77, 0xc5, 0x6e, 0xb8, 0x61, 0xda, 0x76, 0xe1, 0x73, 0x63, 0x5d	/* t__pfx_warn_bad_vsyscall */
	.byte 0x0c, 0x74, 0x77, 0xc5, 0x6e, 0xb8, 0x61, 0xda, 0x76, 0xe1, 0x73, 0x63, 0x5d	/* twarn_bad_vsyscall */
	.byte 0x0a, 0xeb, 0x65, 0x6d, 0x02, 0x91, 0x76, 0xe1, 0x73, 0x63, 0x5d	/* T__pfx_emulate_vsyscall */
	.byte 0x0a, 0x54, 0x65, 0x6d, 0x02, 0x91, 0x76, 0xe1, 0x73, 0x63, 0x5d	/* Temulate_vsyscall */
	.byte 0x07, 0xeb, 0x67, 0xe2, 0x67, 0x91, 0x76, 0xd9	/* T__pfx_get_gate_vma */
	.byte 0x07, 0x54, 0x67, 0xe2, 0x67, 0x91, 0x76, 0xd9	/* Tget_gate_vma */
	.byte 0x07, 0xeb, 0xf8, 0xc7, 0x91, 0x61, 0xf7, 0x61	/* T__pfx_in_gate_area */
	.byte 0x07, 0x54, 0xf8, 0xc7, 0x91, 0x61, 0xf7, 0x61	/* Tin_gate_area */
	.byte 0x0b, 0xeb, 0xf8, 0xc7, 0x91, 0x61, 0xf7, 0x61, 0xbd, 0x6f, 0xc1, 0x6d	/* T__pfx_in_gate_area_no_mm */
	.byte 0x0b, 0x54, 0xf8, 0xc7, 0x91, 0x61, 0xf7, 0x61, 0xbd, 0x6f, 0xc1, 0x6d	/* Tin_gate_area_no_mm */
	.byte 0x0f, 0xeb, 0x70, 0xf7, 0x65, 0xb6, 0xfe, 0x73, 0xba, 0x9e, 0x75, 0xb0, 0x74, 0x68, 0xe4, 0x6b	/* T__pfx_preempt_schedule_thunk */
	.byte 0x0f, 0x54, 0x70, 0xf7, 0x65, 0xb6, 0xfe, 0x73, 0xba, 0x9e, 0x75, 0xb0, 0x74, 0x68, 0xe4, 0x6b	/* Tpreempt_schedule_thunk */
	.byte 0x12, 0xeb, 0x70, 0xf7, 0x65, 0xb6, 0xfe, 0x73, 0xba, 0x9e, 0x75, 0xb0, 0x6e, 0x6f, 0xc3, 0x74, 0x68, 0xe4, 0x6b	/* T__pfx_preempt_schedule_notrace_thunk */
	.byte 0x12, 0x54, 0x70, 0xf7, 0x65, 0xb6, 0xfe, 0x73, 0xba, 0x9e, 0x75, 0xb0, 0x6e, 0x6f, 0xc3, 0x74, 0x68, 0xe4, 0x6b	/* Tpreempt_schedule_notrace_thunk */
	.byte 0x09, 0xeb, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf0, 0x5d	/* T__pfx_ia32_sys_call */
	.byte 0x09, 0x54, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf0, 0x5d	/* Tia32_sys_call */
	.byte 0x0e, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xec, 0xf7, 0x70, 0xc5, 0xfc, 0x63, 0x9c	/* t__pfx_x86_pmu_prepare_cpu */
	.byte 0x0e, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xec, 0xf7, 0x70, 0xc5, 0xfc, 0x63, 0x9c	/* tx86_pmu_prepare_cpu */
	.byte 0x0c, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xed, 0x65, 0xc8, 0xf0, 0x9c	/* t__pfx_x86_pmu_dead_cpu */
	.byte 0x0c, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xed, 0x65, 0xc8, 0xf0, 0x9c	/* tx86_pmu_dead_cpu */
	.byte 0x0d, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xa9, 0x72, 0x74, 0x8d, 0xf0, 0x9c	/* t__pfx_x86_pmu_starting_cpu */
	.byte 0x0d, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xa9, 0x72, 0x74, 0x8d, 0xf0, 0x9c	/* tx86_pmu_starting_cpu */
	.byte 0x0c, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xed, 0x79, 0x8d, 0xf0, 0x9c	/* t__pfx_x86_pmu_dying_cpu */
	.byte 0x0c, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xed, 0x79, 0x8d, 0xf0, 0x9c	/* tx86_pmu_dying_cpu */
	.byte 0x08, 0xef, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_is_visible */
	.byte 0x07, 0xdc, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* tis_visible */
	.byte 0x0e, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x25, 0x65, 0xc6, 0xec, 0xf5, 0xc0, 0x64	/* t__pfx_x86_pmu_check_period */
	.byte 0x0e, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x25, 0x65, 0xc6, 0xec, 0xf5, 0xc0, 0x64	/* tx86_pmu_check_period */
	.byte 0x0c, 0xef, 0x67, 0xe2, 0x73, 0x65, 0x67, 0x6d, 0xf1, 0xfe, 0x62, 0xbb, 0x65	/* t__pfx_get_segment_base */
	.byte 0x0c, 0x74, 0x67, 0xe2, 0x73, 0x65, 0x67, 0x6d, 0xf1, 0xfe, 0x62, 0xbb, 0x65	/* tget_segment_base */
	.byte 0x0e, 0xef, 0x69, 0xe9, 0xcd, 0x8c, 0xfc, 0x61, 0xfe, 0x66, 0xe4, 0xc9, 0xf1, 0xf3, 0x79	/* t__pfx_is_uprobe_at_func_entry */
	.byte 0x0d, 0xdc, 0xe9, 0xcd, 0x8c, 0xfc, 0x61, 0xfe, 0x66, 0xe4, 0xc9, 0xf1, 0xf3, 0x79	/* tis_uprobe_at_func_entry */
	.byte 0x0a, 0xeb, 0x19, 0x66, 0x86, 0x68, 0x8f, 0xcc, 0x40, 0xa5, 0x67	/* T__pfx_perf_get_hw_event_config */
	.byte 0x0a, 0x54, 0x19, 0x66, 0x86, 0x68, 0x8f, 0xcc, 0x40, 0xa5, 0x67	/* Tperf_get_hw_event_config */
	.byte 0x0b, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xe6, 0x69, 0x6c, 0xa2	/* t__pfx_x86_pmu_filter */
	.byte 0x0b, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xe6, 0x69, 0x6c, 0xa2	/* tx86_pmu_filter */
	.byte 0x11, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xf6, 0x77, 0x61, 0x70, 0x5f, 0xf4, 0x5e, 0xf0, 0x74, 0x78	/* t__pfx_x86_pmu_swap_task_ctx */
	.byte 0x11, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xf6, 0x77, 0x61, 0x70, 0x5f, 0xf4, 0x5e, 0xf0, 0x74, 0x78	/* tx86_pmu_swap_task_ctx */
	.byte 0x0d, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xf6, 0xba, 0x65, 0xda, 0xf4, 0x5e	/* t__pfx_x86_pmu_sched_task */
	.byte 0x0d, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xf6, 0xba, 0x65, 0xda, 0xf4, 0x5e	/* tx86_pmu_sched_task */
	.byte 0x0e, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0xcb, 0xf3, 0x61, 0xde, 0x67, 0x73	/* t__pfx_x86_pmu_extra_regs */
	.byte 0x0e, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0xcb, 0xf3, 0x61, 0xde, 0x67, 0x73	/* tx86_pmu_extra_regs */
	.byte 0x0e, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x3a, 0x6d, 0x6d, 0x9d, 0x74, 0x78, 0x6e	/* t__pfx_x86_pmu_commit_txn */
	.byte 0x0e, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x3a, 0x6d, 0x6d, 0x9d, 0x74, 0x78, 0x6e	/* tx86_pmu_commit_txn */
	.byte 0x09, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xde, 0xc8	/* t__pfx_x86_pmu_read */
	.byte 0x09, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xde, 0xc8	/* tx86_pmu_read */
	.byte 0x0a, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xa9, 0x72, 0x74	/* t__pfx_x86_pmu_start */
	.byte 0x0a, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xa9, 0x72, 0x74	/* tx86_pmu_start */
	.byte 0x0d, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0xe7, 0x2d, 0xfc, 0x63, 0x9c	/* t__pfx_x86_pmu_online_cpu */
	.byte 0x0d, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0xe7, 0x2d, 0xfc, 0x63, 0x9c	/* tx86_pmu_online_cpu */
	.byte 0x0b, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xc4	/* t__pfx_x86_pmu_disable */
	.byte 0x0b, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xc4	/* tx86_pmu_disable */
	.byte 0x08, 0xef, 0x67, 0xe2, 0x24, 0xa6, 0x12, 0x6d, 0x63	/* t__pfx_get_attr_rdpmc */
	.byte 0x08, 0x74, 0x67, 0xe2, 0x24, 0xa6, 0x12, 0x6d, 0x63	/* tget_attr_rdpmc */
	.byte 0x08, 0xef, 0x73, 0xe2, 0x24, 0xa6, 0x12, 0x6d, 0x63	/* t__pfx_set_attr_rdpmc */
	.byte 0x07, 0x93, 0xe2, 0x24, 0xa6, 0x12, 0x6d, 0x63	/* tset_attr_rdpmc */
	.byte 0x0b, 0xeb, 0x78, 0x38, 0x36, 0xec, 0xf5, 0x3b, 0xcc, 0xcd, 0x64, 0x14	/* T__pfx_x86_perf_event_update */
	.byte 0x0b, 0x54, 0x78, 0x38, 0x36, 0xec, 0xf5, 0x3b, 0xcc, 0xcd, 0x64, 0x14	/* Tx86_perf_event_update */
	.byte 0x0d, 0xeb, 0x19, 0x66, 0xc7, 0x75, 0xd6, 0xfe, 0x67, 0xe2, 0x6d, 0x73, 0x72, 0x73	/* T__pfx_perf_guest_get_msrs */
	.byte 0x0d, 0x54, 0x19, 0x66, 0xc7, 0x75, 0xd6, 0xfe, 0x67, 0xe2, 0x6d, 0x73, 0x72, 0x73	/* Tperf_guest_get_msrs */
	.byte 0x0a, 0xeb, 0x19, 0x3b, 0xbb, 0x85, 0x67, 0x6e, 0x5f, 0xd7, 0x93	/* T__pfx_perf_assign_events */
	.byte 0x0a, 0x54, 0x19, 0x3b, 0xbb, 0x85, 0x67, 0x6e, 0x5f, 0xd7, 0x93	/* Tperf_assign_events */
	.byte 0x0a, 0x74, 0xaf, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xde, 0xc8	/* t__pfx__x86_pmu_read */
	.byte 0x09, 0xfe, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xde, 0xc8	/* t_x86_pmu_read */
	.byte 0x0a, 0xeb, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xf6, 0x74, 0xbe	/* T__pfx_x86_pmu_stop */
	.byte 0x0a, 0x54, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xf6, 0x74, 0xbe	/* Tx86_pmu_stop */
	.byte 0x09, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xed, 0xdb	/* t__pfx_x86_pmu_del */
	.byte 0x09, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xed, 0xdb	/* tx86_pmu_del */
	.byte 0x08, 0xeb, 0xd7, 0x93, 0x7f, 0x73, 0x95, 0xf6, 0x7c	/* T__pfx_events_sysfs_show */
	.byte 0x08, 0x54, 0xd7, 0x93, 0x7f, 0x73, 0x95, 0xf6, 0x7c	/* Tevents_sysfs_show */
	.byte 0x0e, 0xeb, 0xd7, 0x74, 0xe9, 0x68, 0x79, 0x62, 0x72, 0x9f, 0x7f, 0x73, 0x95, 0xf6, 0x7c	/* T__pfx_events_hybrid_sysfs_show */
	.byte 0x0e, 0x54, 0xd7, 0x74, 0xe9, 0x68, 0x79, 0x62, 0x72, 0x9f, 0x7f, 0x73, 0x95, 0xf6, 0x7c	/* Tevents_hybrid_sysfs_show */
	.byte 0x0b, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x9f, 0x78	/* t__pfx_x86_pmu_event_idx */
	.byte 0x0b, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x9f, 0x78	/* tx86_pmu_event_idx */
	.byte 0x13, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0x61, 0x75, 0x78, 0x5f, 0x6f, 0x75, 0xce, 0x1e, 0x6d, 0xe8, 0xba	/* t__pfx_x86_pmu_aux_output_match */
	.byte 0x13, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0x61, 0x75, 0x78, 0x5f, 0x6f, 0x75, 0xce, 0x1e, 0x6d, 0xe8, 0xba	/* tx86_pmu_aux_output_match */
	.byte 0x0e, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xf0, 0xd2, 0x63, 0xdb, 0xa7, 0x78, 0x6e	/* t__pfx_x86_pmu_cancel_txn */
	.byte 0x0e, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xf0, 0xd2, 0x63, 0xdb, 0xa7, 0x78, 0x6e	/* tx86_pmu_cancel_txn */
	.byte 0x0d, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xa9, 0x72, 0xfe, 0x74, 0x78, 0x6e	/* t__pfx_x86_pmu_start_txn */
	.byte 0x0d, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xa9, 0x72, 0xfe, 0x74, 0x78, 0x6e	/* tx86_pmu_start_txn */
	.byte 0x0c, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x97, 0x70, 0x9e	/* t__pfx_x86_pmu_event_mapped */
	.byte 0x0c, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x97, 0x70, 0x9e	/* tx86_pmu_event_mapped */
	.byte 0x0b, 0xef, 0x19, 0x3b, 0xcc, 0x6e, 0x6d, 0x69, 0xa3, 0x05, 0x6c, 0xf5	/* t__pfx_perf_event_nmi_handler */
	.byte 0x0b, 0xce, 0xf5, 0x3b, 0xcc, 0x6e, 0x6d, 0x69, 0xa3, 0x05, 0x6c, 0xf5	/* tperf_event_nmi_handler */
	.byte 0x0b, 0xef, 0x22, 0x63, 0x91, 0x66, 0x61, 0x6b, 0xfc, 0x63, 0x9c, 0x63	/* t__pfx_allocate_fake_cpuc */
	.byte 0x0c, 0xf4, 0x6c, 0xdd, 0x63, 0x91, 0x66, 0x61, 0x6b, 0xfc, 0x63, 0x9c, 0x63	/* tallocate_fake_cpuc */
	.byte 0x08, 0xef, 0x63, 0xa0, 0xc4, 0x63, 0xfe, 0xd7, 0x74	/* t__pfx_collect_event */
	.byte 0x07, 0x26, 0xa0, 0xc4, 0x63, 0xfe, 0xd7, 0x74	/* tcollect_event */
	.byte 0x0d, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0xe4, 0x97, 0x70, 0x9e	/* t__pfx_x86_pmu_event_unmapped */
	.byte 0x0d, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0xe4, 0x97, 0x70, 0x9e	/* tx86_pmu_event_unmapped */
	.byte 0x0a, 0xef, 0xd9, 0x78, 0xec, 0xf7, 0x63, 0xca, 0xfc, 0x73, 0x7c	/* t__pfx_max_precise_show */
	.byte 0x0a, 0x74, 0xd9, 0x78, 0xec, 0xf7, 0x63, 0xca, 0xfc, 0x73, 0x7c	/* tmax_precise_show */
	.byte 0x0a, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xc4	/* t__pfx_x86_pmu_enable */
	.byte 0x0a, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xc4	/* tx86_pmu_enable */
	.byte 0x08, 0xef, 0x63, 0xa0, 0xc4, 0x63, 0xfe, 0xd7, 0x93	/* t__pfx_collect_events */
	.byte 0x07, 0x26, 0xa0, 0xc4, 0x63, 0xfe, 0xd7, 0x93	/* tcollect_events */
	.byte 0x0a, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0xc8, 0x64	/* t__pfx_x86_pmu_add */
	.byte 0x0a, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0xc8, 0x64	/* tx86_pmu_add */
	.byte 0x12, 0xeb, 0x19, 0x66, 0x86, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xf0, 0x61, 0x70, 0x90, 0x69, 0x6c, 0xea, 0x79	/* T__pfx_perf_get_x86_pmu_capability */
	.byte 0x12, 0x54, 0x19, 0x66, 0x86, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xf0, 0x61, 0x70, 0x90, 0x69, 0x6c, 0xea, 0x79	/* Tperf_get_x86_pmu_capability */
	.byte 0x0d, 0xeb, 0x78, 0x38, 0x36, 0xec, 0xf5, 0x3b, 0xcc, 0x73, 0xe2, 0x19, 0xc0, 0x64	/* T__pfx_x86_perf_event_set_period */
	.byte 0x0d, 0x54, 0x78, 0x38, 0x36, 0xec, 0xf5, 0x3b, 0xcc, 0x73, 0xe2, 0x19, 0xc0, 0x64	/* Tx86_perf_event_set_period */
	.byte 0x09, 0xeb, 0xba, 0x65, 0xc6, 0xa3, 0x8f, 0xcb, 0xca, 0x93	/* T__pfx_check_hw_exists */
	.byte 0x09, 0x54, 0xba, 0x65, 0xc6, 0xa3, 0x8f, 0xcb, 0xca, 0x93	/* Tcheck_hw_exists */
	.byte 0x0d, 0xeb, 0x78, 0x38, 0x36, 0x07, 0xf5, 0x1a, 0x68, 0xc5, 0x64, 0x77, 0x61, 0xf7	/* T__pfx_x86_reserve_hardware */
	.byte 0x0d, 0x54, 0x78, 0x38, 0x36, 0x07, 0xf5, 0x1a, 0x68, 0xc5, 0x64, 0x77, 0x61, 0xf7	/* Tx86_reserve_hardware */
	.byte 0x0a, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x0f	/* t__pfx_x86_pmu_event_init */
	.byte 0x0a, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x0f	/* tx86_pmu_event_init */
	.byte 0x0e, 0xeb, 0x78, 0x38, 0x36, 0xde, 0xc4, 0xbb, 0xfc, 0x68, 0xc5, 0x64, 0x77, 0x61, 0xf7	/* T__pfx_x86_release_hardware */
	.byte 0x0e, 0x54, 0x78, 0x38, 0x36, 0xde, 0xc4, 0xbb, 0xfc, 0x68, 0xc5, 0x64, 0x77, 0x61, 0xf7	/* Tx86_release_hardware */
	.byte 0x0c, 0xef, 0x68, 0x77, 0xec, 0xf5, 0x3b, 0xcc, 0x64, 0xd6, 0xf3, 0x6f, 0x79	/* t__pfx_hw_perf_event_destroy */
	.byte 0x0c, 0x74, 0x68, 0x77, 0xec, 0xf5, 0x3b, 0xcc, 0x64, 0xd6, 0xf3, 0x6f, 0x79	/* thw_perf_event_destroy */
	.byte 0x0e, 0xeb, 0x78, 0x38, 0x36, 0x5f, 0xc8, 0xda, 0xcb, 0x63, 0x6c, 0xb1, 0x69, 0x76, 0x65	/* T__pfx_x86_add_exclusive */
	.byte 0x0e, 0x54, 0x78, 0x38, 0x36, 0x5f, 0xc8, 0xda, 0xcb, 0x63, 0x6c, 0xb1, 0x69, 0x76, 0x65	/* Tx86_add_exclusive */
	.byte 0x0e, 0xeb, 0x78, 0x38, 0x36, 0xed, 0xdb, 0x5f, 0xcb, 0x63, 0x6c, 0xb1, 0x69, 0x76, 0x65	/* T__pfx_x86_del_exclusive */
	.byte 0x0e, 0x54, 0x78, 0x38, 0x36, 0xed, 0xdb, 0x5f, 0xcb, 0x63, 0x6c, 0xb1, 0x69, 0x76, 0x65	/* Tx86_del_exclusive */
	.byte 0x10, 0xeb, 0x68, 0x77, 0xec, 0xf5, 0x3b, 0x6c, 0x62, 0x72, 0x5f, 0xcc, 0x64, 0xd6, 0xf3, 0x6f, 0x79	/* T__pfx_hw_perf_lbr_event_destroy */
	.byte 0x10, 0x54, 0x68, 0x77, 0xec, 0xf5, 0x3b, 0x6c, 0x62, 0x72, 0x5f, 0xcc, 0x64, 0xd6, 0xf3, 0x6f, 0x79	/* Thw_perf_lbr_event_destroy */
	.byte 0x0c, 0xeb, 0x78, 0x38, 0x36, 0xf6, 0xd4, 0xcd, 0xec, 0xf5, 0x66, 0x63, 0xf3	/* T__pfx_x86_setup_perfctr */
	.byte 0x0c, 0x54, 0x78, 0x38, 0x36, 0xf6, 0xd4, 0xcd, 0xec, 0xf5, 0x66, 0x63, 0xf3	/* Tx86_setup_perfctr */
	.byte 0x0f, 0xeb, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0xd9, 0x78, 0xec, 0xf7, 0x63, 0xca, 0x65	/* T__pfx_x86_pmu_max_precise */
	.byte 0x0f, 0x54, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0xd9, 0x78, 0xec, 0xf7, 0x63, 0xca, 0x65	/* Tx86_pmu_max_precise */
	.byte 0x0c, 0xeb, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* T__pfx_x86_pmu_hw_config */
	.byte 0x0c, 0x54, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* Tx86_pmu_hw_config */
	.byte 0x0c, 0xeb, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0x5d	/* T__pfx_x86_pmu_disable_all */
	.byte 0x0c, 0x54, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0x5d	/* Tx86_pmu_disable_all */
	.byte 0x0b, 0xeb, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x5d	/* T__pfx_x86_pmu_enable_all */
	.byte 0x0b, 0x54, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x5d	/* Tx86_pmu_enable_all */
	.byte 0x08, 0xeb, 0x78, 0x38, 0x36, 0x86, 0x70, 0x6d, 0x75	/* T__pfx_x86_get_pmu */
	.byte 0x08, 0x54, 0x78, 0x38, 0x36, 0x86, 0x70, 0x6d, 0x75	/* Tx86_get_pmu */
	.byte 0x0b, 0xeb, 0x78, 0x38, 0x36, 0xf6, 0xba, 0x9e, 0x75, 0xb0, 0xd7, 0x93	/* T__pfx_x86_schedule_events */
	.byte 0x0b, 0x54, 0x78, 0x38, 0x36, 0xf6, 0xba, 0x9e, 0x75, 0xb0, 0xd7, 0x93	/* Tx86_schedule_events */
	.byte 0x0e, 0xeb, 0x78, 0x38, 0x36, 0xec, 0xf5, 0x66, 0xa6, 0x12, 0x6d, 0xc9, 0xf8, 0x64, 0xcb	/* T__pfx_x86_perf_rdpmc_index */
	.byte 0x0e, 0x54, 0x78, 0x38, 0x36, 0xec, 0xf5, 0x66, 0xa6, 0x12, 0x6d, 0xc9, 0xf8, 0x64, 0xcb	/* Tx86_perf_rdpmc_index */
	.byte 0x0c, 0xeb, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* T__pfx_x86_pmu_enable_event */
	.byte 0x0c, 0x54, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* Tx86_pmu_enable_event */
	.byte 0x0b, 0xeb, 0x19, 0x3b, 0xcc, 0x70, 0x72, 0x27, 0x64, 0x65, 0x06, 0x67	/* T__pfx_perf_event_print_debug */
	.byte 0x0b, 0x54, 0x19, 0x3b, 0xcc, 0x70, 0x72, 0x27, 0x64, 0x65, 0x06, 0x67	/* Tperf_event_print_debug */
	.byte 0x0c, 0xeb, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xa3, 0x05, 0xb0, 0xab, 0x71	/* T__pfx_x86_pmu_handle_irq */
	.byte 0x0c, 0x54, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xa3, 0x05, 0xb0, 0xab, 0x71	/* Tx86_pmu_handle_irq */
	.byte 0x0b, 0xeb, 0x19, 0x3b, 0xd7, 0x74, 0xe9, 0x6c, 0x61, 0xb2, 0xc9, 0x0f	/* T__pfx_perf_events_lapic_init */
	.byte 0x0b, 0x54, 0x19, 0x3b, 0xd7, 0x74, 0xe9, 0x6c, 0x61, 0xb2, 0xc9, 0x0f	/* Tperf_events_lapic_init */
	.byte 0x0b, 0xeb, 0xd7, 0x74, 0xe9, 0x68, 0xfe, 0xe1, 0x73, 0x95, 0xf6, 0x7c	/* T__pfx_events_ht_sysfs_show */
	.byte 0x0b, 0x54, 0xd7, 0x74, 0xe9, 0x68, 0xfe, 0xe1, 0x73, 0x95, 0xf6, 0x7c	/* Tevents_ht_sysfs_show */
	.byte 0x0b, 0xeb, 0x78, 0x38, 0x36, 0x5f, 0xcc, 0xe1, 0x73, 0x95, 0xf6, 0x7c	/* T__pfx_x86_event_sysfs_show */
	.byte 0x0b, 0x54, 0x78, 0x38, 0x36, 0x5f, 0xcc, 0xe1, 0x73, 0x95, 0xf6, 0x7c	/* Tx86_event_sysfs_show */
	.byte 0x0f, 0xeb, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xf6, 0x7c, 0xec, 0x6d, 0x75, 0xf0, 0x61, 0x70	/* T__pfx_x86_pmu_show_pmu_cap */
	.byte 0x0f, 0x54, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xf6, 0x7c, 0xec, 0x6d, 0x75, 0xf0, 0x61, 0x70	/* Tx86_pmu_show_pmu_cap */
	.byte 0x0e, 0xeb, 0x19, 0x66, 0xf0, 0xc4, 0xc5, 0xed, 0xab, 0x74, 0x79, 0x3a, 0xe4, 0xa2, 0x73	/* T__pfx_perf_clear_dirty_counters */
	.byte 0x0e, 0x54, 0x19, 0x66, 0xf0, 0xc4, 0xc5, 0xed, 0xab, 0x74, 0x79, 0x3a, 0xe4, 0xa2, 0x73	/* Tperf_clear_dirty_counters */
	.byte 0x0c, 0xeb, 0x19, 0x66, 0x25, 0x65, 0xc6, 0xc1, 0xaa, 0xe3, 0x63, 0xb7, 0x65	/* T__pfx_perf_check_microcode */
	.byte 0x0c, 0x54, 0x19, 0x66, 0x25, 0x65, 0xc6, 0xc1, 0xaa, 0xe3, 0x63, 0xb7, 0x65	/* Tperf_check_microcode */
	.byte 0x0e, 0xeb, 0xc5, 0xba, 0xec, 0xf5, 0x3b, 0xcd, 0x64, 0x91, 0xb1, 0xf5, 0x70, 0x83, 0x65	/* T__pfx_arch_perf_update_userpage */
	.byte 0x0e, 0x54, 0xc5, 0xba, 0xec, 0xf5, 0x3b, 0xcd, 0x64, 0x91, 0xb1, 0xf5, 0x70, 0x83, 0x65	/* Tarch_perf_update_userpage */
	.byte 0x0d, 0xeb, 0x19, 0x66, 0xf0, 0x5d, 0xba, 0x61, 0xf8, 0x5f, 0x6b, 0xf5, 0x6e, 0xdb	/* T__pfx_perf_callchain_kernel */
	.byte 0x0d, 0x54, 0x19, 0x66, 0xf0, 0x5d, 0xba, 0x61, 0xf8, 0x5f, 0x6b, 0xf5, 0x6e, 0xdb	/* Tperf_callchain_kernel */
	.byte 0x0b, 0xeb, 0x19, 0x66, 0xf0, 0x5d, 0xba, 0x61, 0xf8, 0x5f, 0xb1, 0xf5	/* T__pfx_perf_callchain_user */
	.byte 0x0b, 0x54, 0x19, 0x66, 0xf0, 0x5d, 0xba, 0x61, 0xf8, 0x5f, 0xb1, 0xf5	/* Tperf_callchain_user */
	.byte 0x10, 0xeb, 0x19, 0x3b, 0xc5, 0xba, 0xbf, 0x73, 0xf3, 0x75, 0x63, 0xdc, 0xe7, 0xec, 0x6f, 0xb3, 0xf5	/* T__pfx_perf_arch_instruction_pointer */
	.byte 0x10, 0x54, 0x19, 0x3b, 0xc5, 0xba, 0xbf, 0x73, 0xf3, 0x75, 0x63, 0xdc, 0xe7, 0xec, 0x6f, 0xb3, 0xf5	/* Tperf_arch_instruction_pointer */
	.byte 0x10, 0xeb, 0x19, 0x3b, 0xc5, 0xba, 0xc7, 0x75, 0xd6, 0xfe, 0x6d, 0xca, 0x63, 0xe6, 0x6c, 0x83, 0x73	/* T__pfx_perf_arch_guest_misc_flags */
	.byte 0x10, 0x54, 0x19, 0x3b, 0xc5, 0xba, 0xc7, 0x75, 0xd6, 0xfe, 0x6d, 0xca, 0x63, 0xe6, 0x6c, 0x83, 0x73	/* Tperf_arch_guest_misc_flags */
	.byte 0x0c, 0xeb, 0x19, 0x3b, 0xc5, 0xba, 0xc1, 0xca, 0x63, 0xe6, 0x6c, 0x83, 0x73	/* T__pfx_perf_arch_misc_flags */
	.byte 0x0c, 0x54, 0x19, 0x3b, 0xc5, 0xba, 0xc1, 0xca, 0x63, 0xe6, 0x6c, 0x83, 0x73	/* Tperf_arch_misc_flags */
	.byte 0x09, 0xef, 0x6e, 0x6f, 0xfe, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_not_visible */
	.byte 0x09, 0x74, 0x6e, 0x6f, 0xfe, 0x76, 0xca, 0x69, 0x62, 0xc4	/* tnot_visible */
	.byte 0x09, 0xeb, 0x19, 0x66, 0xc1, 0x73, 0x72, 0xec, 0x8c, 0x65	/* T__pfx_perf_msr_probe */
	.byte 0x09, 0x54, 0x19, 0x66, 0xc1, 0x73, 0x72, 0xec, 0x8c, 0x65	/* Tperf_msr_probe */
	.byte 0x0b, 0xef, 0x64, 0xb4, 0x16, 0x62, 0x72, 0xd2, 0xba, 0xa7, 0x21, 0x65	/* t__pfx_decode_branch_type */
	.byte 0x0b, 0x74, 0x64, 0xb4, 0x16, 0x62, 0x72, 0xd2, 0xba, 0xa7, 0x21, 0x65	/* tdecode_branch_type */
	.byte 0x0a, 0xef, 0x67, 0xe2, 0x62, 0x72, 0xd2, 0xba, 0xa7, 0x21, 0x65	/* t__pfx_get_branch_type */
	.byte 0x0a, 0x74, 0x67, 0xe2, 0x62, 0x72, 0xd2, 0xba, 0xa7, 0x21, 0x65	/* tget_branch_type */
	.byte 0x08, 0xeb, 0x62, 0x72, 0xd2, 0xba, 0xa7, 0x21, 0x65	/* T__pfx_branch_type */
	.byte 0x08, 0x54, 0x62, 0x72, 0xd2, 0xba, 0xa7, 0x21, 0x65	/* Tbranch_type */
	.byte 0x0b, 0xeb, 0x62, 0x72, 0xd2, 0xba, 0xa7, 0x21, 0xfc, 0x66, 0xb1, 0x9e	/* T__pfx_branch_type_fused */
	.byte 0x0b, 0x54, 0x62, 0x72, 0xd2, 0xba, 0xa7, 0x21, 0xfc, 0x66, 0xb1, 0x9e	/* Tbranch_type_fused */
	.byte 0x0c, 0xeb, 0x03, 0x6d, 0x6d, 0xe7, 0xb8, 0x72, 0xd2, 0xba, 0xa7, 0x21, 0x65	/* T__pfx_common_branch_type */
	.byte 0x0c, 0x54, 0x03, 0x6d, 0x6d, 0xe7, 0xb8, 0x72, 0xd2, 0xba, 0xa7, 0x21, 0x65	/* Tcommon_branch_type */
	.byte 0x0a, 0xef, 0xbc, 0x70, 0x6c, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x0f	/* t__pfx_rapl_pmu_event_init */
	.byte 0x0a, 0xf3, 0x61, 0x70, 0x6c, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x0f	/* trapl_pmu_event_init */
	.byte 0x07, 0xef, 0x74, 0xd6, 0xfe, 0x6d, 0x73, 0x72	/* t__pfx_test_msr */
	.byte 0x07, 0x74, 0x74, 0xd6, 0xfe, 0x6d, 0x73, 0x72	/* ttest_msr */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0xbc, 0x70, 0x6c, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x3d, 0x72, 0x74	/* t__pfx___rapl_pmu_event_start */
	.byte 0x0d, 0x74, 0xff, 0xbc, 0x70, 0x6c, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x3d, 0x72, 0x74	/* t__rapl_pmu_event_start */
	.byte 0x0c, 0xef, 0xbc, 0x70, 0x6c, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x3d, 0x72, 0x74	/* t__pfx_rapl_pmu_event_start */
	.byte 0x0c, 0xf3, 0x61, 0x70, 0x6c, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x3d, 0x72, 0x74	/* trapl_pmu_event_start */
	.byte 0x0b, 0xef, 0xbc, 0x70, 0x6c, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0xc8, 0x64	/* t__pfx_rapl_pmu_event_add */
	.byte 0x0b, 0xf3, 0x61, 0x70, 0x6c, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0xc8, 0x64	/* trapl_pmu_event_add */
	.byte 0x04, 0xef, 0xcc, 0x73, 0x7c	/* t__pfx_event_show */
	.byte 0x04, 0x74, 0xcc, 0x73, 0x7c	/* tevent_show */
	.byte 0x0d, 0xef, 0xbc, 0x70, 0x6c, 0x5f, 0xcc, 0xcd, 0x64, 0x14, 0x2e, 0xca, 0xbc, 0x7e	/* t__pfx_rapl_event_update.isra.0 */
	.byte 0x0d, 0xf3, 0x61, 0x70, 0x6c, 0x5f, 0xcc, 0xcd, 0x64, 0x14, 0x2e, 0xca, 0xbc, 0x7e	/* trapl_event_update.isra.0 */
	.byte 0x0b, 0xef, 0xbc, 0x70, 0x6c, 0xa3, 0x72, 0x00, 0xf5, 0xa3, 0x05, 0xc4	/* t__pfx_rapl_hrtimer_handle */
	.byte 0x0b, 0xf3, 0x61, 0x70, 0x6c, 0xa3, 0x72, 0x00, 0xf5, 0xa3, 0x05, 0xc4	/* trapl_hrtimer_handle */
	.byte 0x0c, 0xef, 0xbc, 0x70, 0x6c, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x73, 0x74, 0xbe	/* t__pfx_rapl_pmu_event_stop */
	.byte 0x0c, 0xf3, 0x61, 0x70, 0x6c, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x73, 0x74, 0xbe	/* trapl_pmu_event_stop */
	.byte 0x0b, 0xef, 0xbc, 0x70, 0x6c, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x64, 0xdb	/* t__pfx_rapl_pmu_event_del */
	.byte 0x0b, 0xf3, 0x61, 0x70, 0x6c, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x64, 0xdb	/* trapl_pmu_event_del */
	.byte 0x0b, 0xef, 0xbc, 0x70, 0x6c, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0xf7, 0xc8	/* t__pfx_rapl_pmu_event_read */
	.byte 0x0b, 0xf3, 0x61, 0x70, 0x6c, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0xf7, 0xc8	/* trapl_pmu_event_read */
	.byte 0x0b, 0xef, 0x2a, 0xda, 0x62, 0x72, 0xe9, 0x68, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_amd_brs_hw_config */
	.byte 0x0b, 0xf4, 0x6d, 0xda, 0x62, 0x72, 0xe9, 0x68, 0x77, 0x3e, 0xa5, 0x67	/* tamd_brs_hw_config */
	.byte 0x08, 0xef, 0x2a, 0xda, 0x62, 0x72, 0xe9, 0x29, 0xd4	/* t__pfx_amd_brs_reset */
	.byte 0x08, 0xf4, 0x6d, 0xda, 0x62, 0x72, 0xe9, 0x29, 0xd4	/* tamd_brs_reset */
	.byte 0x0b, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0xb8, 0x72, 0xe9, 0xc8, 0x64	/* t__pfx_amd_pmu_brs_add */
	.byte 0x0b, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0xb8, 0x72, 0xe9, 0xc8, 0x64	/* tamd_pmu_brs_add */
	.byte 0x0f, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0xb8, 0x72, 0x73, 0xf6, 0xba, 0x65, 0xda, 0xf4, 0x5e	/* t__pfx_amd_pmu_brs_sched_task */
	.byte 0x0f, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0xb8, 0x72, 0x73, 0xf6, 0xba, 0x65, 0xda, 0xf4, 0x5e	/* tamd_pmu_brs_sched_task */
	.byte 0x09, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x97	/* t__pfx_amd_pmu_event_map */
	.byte 0x09, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x97	/* tamd_pmu_event_map */
	.byte 0x10, 0xef, 0x2a, 0xda, 0x62, 0x72, 0xd2, 0xba, 0x65, 0xe9, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_amd_branches_is_visible */
	.byte 0x10, 0xf4, 0x6d, 0xda, 0x62, 0x72, 0xd2, 0xba, 0x65, 0xe9, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* tamd_branches_is_visible */
	.byte 0x0b, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0xf0, 0x9c, 0xed, 0x65, 0xc8	/* t__pfx_amd_pmu_cpu_dead */
	.byte 0x0b, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0xf0, 0x9c, 0xed, 0x65, 0xc8	/* tamd_pmu_cpu_dead */
	.byte 0x10, 0xef, 0x2a, 0xda, 0x67, 0xe2, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0xe9, 0x66, 0x31, 0x35, 0x68	/* t__pfx_amd_get_event_constraints_f15h */
	.byte 0x10, 0xf4, 0x6d, 0xda, 0x67, 0xe2, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0xe9, 0x66, 0x31, 0x35, 0x68	/* tamd_get_event_constraints_f15h */
	.byte 0x0d, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0xf0, 0x9c, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* t__pfx_amd_pmu_cpu_prepare */
	.byte 0x0d, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0xf0, 0x9c, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* tamd_pmu_cpu_prepare */
	.byte 0x09, 0xef, 0x2a, 0xda, 0xcc, 0xe1, 0x73, 0x95, 0xf6, 0x7c	/* t__pfx_amd_event_sysfs_show */
	.byte 0x09, 0xf4, 0x6d, 0xda, 0xcc, 0xe1, 0x73, 0x95, 0xf6, 0x7c	/* tamd_event_sysfs_show */
	.byte 0x06, 0xef, 0x63, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx_cmask_show */
	.byte 0x05, 0x26, 0xd9, 0x5e, 0xf6, 0x7c	/* tcmask_show */
	.byte 0x05, 0xef, 0xf8, 0x76, 0xf6, 0x7c	/* t__pfx_inv_show */
	.byte 0x05, 0x74, 0xf8, 0x76, 0xf6, 0x7c	/* tinv_show */
	.byte 0x06, 0xef, 0x9e, 0x67, 0xfc, 0x73, 0x7c	/* t__pfx_edge_show */
	.byte 0x06, 0x74, 0x9e, 0x67, 0xfc, 0x73, 0x7c	/* tedge_show */
	.byte 0x06, 0xef, 0x75, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx_umask_show */
	.byte 0x06, 0x74, 0x75, 0xd9, 0x5e, 0xf6, 0x7c	/* tumask_show */
	.byte 0x04, 0xef, 0xcc, 0x73, 0x7c	/* t__pfx_event_show */
	.byte 0x04, 0x74, 0xcc, 0x73, 0x7c	/* tevent_show */
	.byte 0x0b, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_amd_pmu_hw_config */
	.byte 0x0b, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* tamd_pmu_hw_config */
	.byte 0x0b, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0xed, 0xdb, 0x5f, 0xd7, 0x74	/* t__pfx_amd_pmu_del_event */
	.byte 0x0b, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0xed, 0xdb, 0x5f, 0xd7, 0x74	/* tamd_pmu_del_event */
	.byte 0x0b, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0xc8, 0xda, 0xd7, 0x74	/* t__pfx_amd_pmu_add_event */
	.byte 0x0b, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0xc8, 0xda, 0xd7, 0x74	/* tamd_pmu_add_event */
	.byte 0x0f, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x25, 0x65, 0xc6, 0x5f, 0x6f, 0x0b, 0x66, 0xdd, 0x77	/* t__pfx_amd_pmu_check_overflow */
	.byte 0x0f, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0x25, 0x65, 0xc6, 0x5f, 0x6f, 0x0b, 0x66, 0xdd, 0x77	/* tamd_pmu_check_overflow */
	.byte 0x0b, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_amd_pmu_enable_event */
	.byte 0x0b, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tamd_pmu_enable_event */
	.byte 0x0a, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x5d	/* t__pfx_amd_pmu_enable_all */
	.byte 0x0a, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x5d	/* tamd_pmu_enable_all */
	.byte 0x0b, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0x5d	/* t__pfx_amd_pmu_disable_all */
	.byte 0x0b, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0x5d	/* tamd_pmu_disable_all */
	.byte 0x08, 0xef, 0x62, 0x72, 0xd2, 0xba, 0xd6, 0xf6, 0x7c	/* t__pfx_branches_show */
	.byte 0x08, 0x74, 0x62, 0x72, 0xd2, 0xba, 0xd6, 0xf6, 0x7c	/* tbranches_show */
	.byte 0x0e, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0xc8, 0xac, 0x5f, 0x6f, 0x66, 0x95, 0xd4	/* t__pfx_amd_pmu_addr_offset */
	.byte 0x0e, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0xc8, 0xac, 0x5f, 0x6f, 0x66, 0x95, 0xd4	/* tamd_pmu_addr_offset */
	.byte 0x10, 0xef, 0x2a, 0x64, 0xec, 0x1e, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0xe9, 0x66, 0x31, 0x37, 0x68	/* t__pfx_amd_put_event_constraints_f17h */
	.byte 0x10, 0xf4, 0x6d, 0x64, 0xec, 0x1e, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0xe9, 0x66, 0x31, 0x37, 0x68	/* tamd_put_event_constraints_f17h */
	.byte 0x0e, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x69, 0x6d, 0x9d, 0x19, 0xc0, 0x64	/* t__pfx_amd_pmu_limit_period */
	.byte 0x0e, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x69, 0x6d, 0x9d, 0x19, 0xc0, 0x64	/* tamd_pmu_limit_period */
	.byte 0x0c, 0xef, 0x2a, 0x64, 0xec, 0x1e, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* t__pfx_amd_put_event_constraints */
	.byte 0x0c, 0xf4, 0x6d, 0x64, 0xec, 0x1e, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* tamd_put_event_constraints */
	.byte 0x0b, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0xb8, 0x72, 0x73, 0xed, 0xdb	/* t__pfx_amd_pmu_brs_del */
	.byte 0x0b, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0xb8, 0x72, 0x73, 0xed, 0xdb	/* tamd_pmu_brs_del */
	.byte 0x0b, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0xa3, 0x05, 0xb0, 0xab, 0x71	/* t__pfx_amd_pmu_handle_irq */
	.byte 0x0b, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0xa3, 0x05, 0xb0, 0xab, 0x71	/* tamd_pmu_handle_irq */
	.byte 0x10, 0xef, 0x2a, 0xda, 0x67, 0xe2, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0xe9, 0x66, 0x31, 0x37, 0x68	/* t__pfx_amd_get_event_constraints_f17h */
	.byte 0x10, 0xf4, 0x6d, 0xda, 0x67, 0xe2, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0xe9, 0x66, 0x31, 0x37, 0x68	/* tamd_get_event_constraints_f17h */
	.byte 0x10, 0xef, 0x2a, 0xda, 0x67, 0xe2, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0xe9, 0x66, 0x31, 0x39, 0x68	/* t__pfx_amd_get_event_constraints_f19h */
	.byte 0x10, 0xf4, 0x6d, 0xda, 0x67, 0xe2, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0xe9, 0x66, 0x31, 0x39, 0x68	/* tamd_get_event_constraints_f19h */
	.byte 0x0c, 0xef, 0x2a, 0xda, 0x67, 0xe2, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* t__pfx_amd_get_event_constraints */
	.byte 0x0c, 0xf4, 0x6d, 0xda, 0x67, 0xe2, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* tamd_get_event_constraints */
	.byte 0x11, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0xa7, 0xd6, 0xfe, 0x6f, 0x0b, 0x66, 0xdd, 0x77, 0xa9, 0x74, 0xb1	/* t__pfx_amd_pmu_test_overflow_status */
	.byte 0x11, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0xa7, 0xd6, 0xfe, 0x6f, 0x0b, 0x66, 0xdd, 0x77, 0xa9, 0x74, 0xb1	/* tamd_pmu_test_overflow_status */
	.byte 0x12, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0xa7, 0xd6, 0xfe, 0x6f, 0x0b, 0x66, 0xdd, 0x77, 0xa7, 0xbe, 0x62, 0xea	/* t__pfx_amd_pmu_test_overflow_topbit */
	.byte 0x12, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0xa7, 0xd6, 0xfe, 0x6f, 0x0b, 0x66, 0xdd, 0x77, 0xa7, 0xbe, 0x62, 0xea	/* tamd_pmu_test_overflow_topbit */
	.byte 0x0e, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x76, 0x32, 0xed, 0xca, 0x90, 0xb0, 0x5d	/* t__pfx_amd_pmu_v2_disable_all */
	.byte 0x0e, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x76, 0x32, 0xed, 0xca, 0x90, 0xb0, 0x5d	/* tamd_pmu_v2_disable_all */
	.byte 0x0d, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x76, 0x32, 0x0d, 0x90, 0xb0, 0x5d	/* t__pfx_amd_pmu_v2_enable_all */
	.byte 0x0d, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x76, 0x32, 0x0d, 0x90, 0xb0, 0x5d	/* tamd_pmu_v2_enable_all */
	.byte 0x0d, 0xeb, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0x76, 0xab, 0x74	/* T__pfx_amd_pmu_disable_virt */
	.byte 0x0d, 0x54, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0x76, 0xab, 0x74	/* Tamd_pmu_disable_virt */
	.byte 0x0c, 0xeb, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x76, 0xab, 0x74	/* T__pfx_amd_pmu_enable_virt */
	.byte 0x0c, 0x54, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x76, 0xab, 0x74	/* Tamd_pmu_enable_virt */
	.byte 0x0c, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0xf0, 0x9c, 0xa9, 0x72, 0x74, 0x8d	/* t__pfx_amd_pmu_cpu_starting */
	.byte 0x0c, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0xf0, 0x9c, 0xa9, 0x72, 0x74, 0x8d	/* tamd_pmu_cpu_starting */
	.byte 0x0c, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_amd_pmu_disable_event */
	.byte 0x0c, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* tamd_pmu_disable_event */
	.byte 0x0e, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x76, 0x32, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_amd_pmu_v2_enable_event */
	.byte 0x0e, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x76, 0x32, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tamd_pmu_v2_enable_event */
	.byte 0x0e, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x76, 0x32, 0xa3, 0x05, 0xb0, 0xab, 0x71	/* t__pfx_amd_pmu_v2_handle_irq */
	.byte 0x0e, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x76, 0x32, 0xa3, 0x05, 0xb0, 0xab, 0x71	/* tamd_pmu_v2_handle_irq */
	.byte 0x17, 0xef, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x76, 0x32, 0xf6, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0xfe, 0x62, 0x72, 0xd2, 0xba, 0xa9, 0xc6	/* t__pfx_amd_pmu_v2_snapshot_branch_stack */
	.byte 0x17, 0xf4, 0x6d, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x76, 0x32, 0xf6, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0xfe, 0x62, 0x72, 0xd2, 0xba, 0xa9, 0xc6	/* tamd_pmu_v2_snapshot_branch_stack */
	.byte 0x0c, 0xeb, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xde, 0xc8	/* T__pfx_amd_pmu_lbr_read */
	.byte 0x0c, 0x54, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xde, 0xc8	/* Tamd_pmu_lbr_read */
	.byte 0x0f, 0xeb, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* T__pfx_amd_pmu_lbr_hw_config */
	.byte 0x0f, 0x54, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* Tamd_pmu_lbr_hw_config */
	.byte 0x0c, 0xeb, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0x07, 0xd4	/* T__pfx_amd_pmu_lbr_reset */
	.byte 0x0c, 0x54, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0x07, 0xd4	/* Tamd_pmu_lbr_reset */
	.byte 0x0d, 0xeb, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0x5f, 0xc8, 0x64	/* T__pfx_amd_pmu_lbr_add */
	.byte 0x0d, 0x54, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0x5f, 0xc8, 0x64	/* Tamd_pmu_lbr_add */
	.byte 0x0c, 0xeb, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xed, 0xdb	/* T__pfx_amd_pmu_lbr_del */
	.byte 0x0c, 0x54, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xed, 0xdb	/* Tamd_pmu_lbr_del */
	.byte 0x10, 0xeb, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xf6, 0xba, 0x65, 0xda, 0xf4, 0x5e	/* T__pfx_amd_pmu_lbr_sched_task */
	.byte 0x10, 0x54, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xf6, 0xba, 0x65, 0xda, 0xf4, 0x5e	/* Tamd_pmu_lbr_sched_task */
	.byte 0x0e, 0xeb, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0x0d, 0x90, 0xb0, 0x5d	/* T__pfx_amd_pmu_lbr_enable_all */
	.byte 0x0e, 0x54, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0x0d, 0x90, 0xb0, 0x5d	/* Tamd_pmu_lbr_enable_all */
	.byte 0x0f, 0xeb, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xed, 0xca, 0x90, 0xb0, 0x5d	/* T__pfx_amd_pmu_lbr_disable_all */
	.byte 0x0f, 0x54, 0x2a, 0x64, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xed, 0xca, 0x90, 0xb0, 0x5d	/* Tamd_pmu_lbr_disable_all */
	.byte 0x07, 0xef, 0x19, 0x3b, 0x69, 0x62, 0xe9, 0x0f	/* t__pfx_perf_ibs_init */
	.byte 0x07, 0xce, 0xf5, 0x3b, 0x69, 0x62, 0xe9, 0x0f	/* tperf_ibs_init */
	.byte 0x0c, 0xef, 0x67, 0xe2, 0x69, 0x62, 0xe9, 0x66, 0xd4, 0xba, 0x3a, 0xe4, 0x74	/* t__pfx_get_ibs_fetch_count */
	.byte 0x0c, 0x74, 0x67, 0xe2, 0x69, 0x62, 0xe9, 0x66, 0xd4, 0xba, 0x3a, 0xe4, 0x74	/* tget_ibs_fetch_count */
	.byte 0x0a, 0xef, 0x67, 0xe2, 0x69, 0x62, 0xe9, 0xbe, 0x3a, 0xe4, 0x74	/* t__pfx_get_ibs_op_count */
	.byte 0x0a, 0x74, 0x67, 0xe2, 0x69, 0x62, 0xe9, 0xbe, 0x3a, 0xe4, 0x74	/* tget_ibs_op_count */
	.byte 0x08, 0xef, 0x19, 0x3b, 0x69, 0x62, 0xe9, 0xf7, 0xc8	/* t__pfx_perf_ibs_read */
	.byte 0x08, 0xce, 0xf5, 0x3b, 0x69, 0x62, 0xe9, 0xf7, 0xc8	/* tperf_ibs_read */
	.byte 0x14, 0xef, 0x7a, 0xf1, 0x34, 0x5f, 0x69, 0x62, 0xe9, 0x8e, 0xf1, 0x85, 0xe7, 0xe9, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_zen4_ibs_extensions_is_visible */
	.byte 0x14, 0x74, 0x7a, 0xf1, 0x34, 0x5f, 0x69, 0x62, 0xe9, 0x8e, 0xf1, 0x85, 0xe7, 0xe9, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* tzen4_ibs_extensions_is_visible */
	.byte 0x0e, 0xef, 0x63, 0x6e, 0xfe, 0x63, 0x23, 0x5f, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_cnt_ctl_is_visible */
	.byte 0x0d, 0x26, 0x6e, 0xfe, 0x63, 0x23, 0x5f, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* tcnt_ctl_is_visible */
	.byte 0x0a, 0xeb, 0x67, 0xe2, 0x69, 0x62, 0x73, 0xf0, 0x61, 0x70, 0x73	/* T__pfx_get_ibs_caps */
	.byte 0x0a, 0x54, 0x67, 0xe2, 0x69, 0x62, 0x73, 0xf0, 0x61, 0x70, 0x73	/* Tget_ibs_caps */
	.byte 0x07, 0xef, 0x72, 0xd2, 0xda, 0xf1, 0xf6, 0x7c	/* t__pfx_rand_en_show */
	.byte 0x06, 0xf3, 0xd2, 0xda, 0xf1, 0xf6, 0x7c	/* trand_en_show */
	.byte 0x08, 0xef, 0x63, 0x6e, 0xfe, 0x63, 0x23, 0xf6, 0x7c	/* t__pfx_cnt_ctl_show */
	.byte 0x07, 0x26, 0x6e, 0xfe, 0x63, 0x23, 0xf6, 0x7c	/* tcnt_ctl_show */
	.byte 0x0a, 0xef, 0x19, 0x3b, 0x69, 0x62, 0xe9, 0xcc, 0xcd, 0x64, 0x14	/* t__pfx_perf_ibs_event_update */
	.byte 0x0a, 0xce, 0xf5, 0x3b, 0x69, 0x62, 0xe9, 0xcc, 0xcd, 0x64, 0x14	/* tperf_ibs_event_update */
	.byte 0x12, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0x2a, 0xda, 0x69, 0x62, 0x73, 0xed, 0x79, 0x8d, 0xf0, 0x9c	/* t__pfx_x86_pmu_amd_ibs_dying_cpu */
	.byte 0x12, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0x2a, 0xda, 0x69, 0x62, 0x73, 0xed, 0x79, 0x8d, 0xf0, 0x9c	/* tx86_pmu_amd_ibs_dying_cpu */
	.byte 0x0b, 0xef, 0x19, 0x3b, 0x69, 0x62, 0x73, 0xf6, 0xb1, 0x70, 0xf1, 0x64	/* t__pfx_perf_ibs_suspend */
	.byte 0x0b, 0xce, 0xf5, 0x3b, 0x69, 0x62, 0x73, 0xf6, 0xb1, 0x70, 0xf1, 0x64	/* tperf_ibs_suspend */
	.byte 0x0d, 0xef, 0x73, 0xd4, 0xcd, 0x5f, 0x41, 0x50, 0x49, 0x43, 0x5f, 0x69, 0x62, 0x73	/* t__pfx_setup_APIC_ibs */
	.byte 0x0c, 0x93, 0xd4, 0xcd, 0x5f, 0x41, 0x50, 0x49, 0x43, 0x5f, 0x69, 0x62, 0x73	/* tsetup_APIC_ibs */
	.byte 0x13, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0x2a, 0xda, 0x69, 0x62, 0x73, 0xa9, 0x72, 0x74, 0x8d, 0xf0, 0x9c	/* t__pfx_x86_pmu_amd_ibs_starting_cpu */
	.byte 0x13, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0x2a, 0xda, 0x69, 0x62, 0x73, 0xa9, 0x72, 0x74, 0x8d, 0xf0, 0x9c	/* tx86_pmu_amd_ibs_starting_cpu */
	.byte 0x09, 0xef, 0x19, 0x3b, 0x69, 0x62, 0x73, 0xa9, 0x72, 0x74	/* t__pfx_perf_ibs_start */
	.byte 0x09, 0xce, 0xf5, 0x3b, 0x69, 0x62, 0x73, 0xa9, 0x72, 0x74	/* tperf_ibs_start */
	.byte 0x08, 0xef, 0x19, 0x3b, 0x69, 0x62, 0xe9, 0xc8, 0x64	/* t__pfx_perf_ibs_add */
	.byte 0x08, 0xce, 0xf5, 0x3b, 0x69, 0x62, 0xe9, 0xc8, 0x64	/* tperf_ibs_add */
	.byte 0x10, 0xef, 0x66, 0xd5, 0x63, 0xfc, 0x69, 0x62, 0xe9, 0x65, 0x69, 0x6c, 0x76, 0xfe, 0x73, 0xd4, 0xcd	/* t__pfx_force_ibs_eilvt_setup */
	.byte 0x10, 0x74, 0x66, 0xd5, 0x63, 0xfc, 0x69, 0x62, 0xe9, 0x65, 0x69, 0x6c, 0x76, 0xfe, 0x73, 0xd4, 0xcd	/* tforce_ibs_eilvt_setup */
	.byte 0x09, 0xef, 0x19, 0x3b, 0x69, 0x62, 0xe9, 0x29, 0x75, 0xa8	/* t__pfx_perf_ibs_resume */
	.byte 0x09, 0xce, 0xf5, 0x3b, 0x69, 0x62, 0xe9, 0x29, 0x75, 0xa8	/* tperf_ibs_resume */
	.byte 0x09, 0xef, 0x19, 0x3b, 0x69, 0x62, 0x73, 0xf6, 0x74, 0xbe	/* t__pfx_perf_ibs_stop */
	.byte 0x09, 0xce, 0xf5, 0x3b, 0x69, 0x62, 0x73, 0xf6, 0x74, 0xbe	/* tperf_ibs_stop */
	.byte 0x08, 0xef, 0x19, 0x3b, 0x69, 0x62, 0x73, 0xed, 0xdb	/* t__pfx_perf_ibs_del */
	.byte 0x08, 0xce, 0xf5, 0x3b, 0x69, 0x62, 0x73, 0xed, 0xdb	/* tperf_ibs_del */
	.byte 0x0b, 0xef, 0x19, 0x3b, 0x69, 0x62, 0xe9, 0x68, 0x05, 0xb0, 0xab, 0x71	/* t__pfx_perf_ibs_handle_irq */
	.byte 0x0b, 0xce, 0xf5, 0x3b, 0x69, 0x62, 0xe9, 0x68, 0x05, 0xb0, 0xab, 0x71	/* tperf_ibs_handle_irq */
	.byte 0x0d, 0xef, 0x19, 0x3b, 0x69, 0x62, 0xe9, 0x6e, 0x6d, 0x69, 0xa3, 0x05, 0x6c, 0xf5	/* t__pfx_perf_ibs_nmi_handler */
	.byte 0x0d, 0xce, 0xf5, 0x3b, 0x69, 0x62, 0xe9, 0x6e, 0x6d, 0x69, 0xa3, 0x05, 0x6c, 0xf5	/* tperf_ibs_nmi_handler */
	.byte 0x0c, 0xeb, 0x66, 0xd5, 0x77, 0xc5, 0xda, 0xcc, 0x8a, 0x5f, 0x69, 0x62, 0x73	/* T__pfx_forward_event_to_ibs */
	.byte 0x0c, 0x54, 0x66, 0xd5, 0x77, 0xc5, 0xda, 0xcc, 0x8a, 0x5f, 0x69, 0x62, 0x73	/* Tforward_event_to_ibs */
	.byte 0x12, 0xef, 0x2a, 0x64, 0xe6, 0x31, 0x37, 0x68, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_amd_f17h_uncore_is_visible */
	.byte 0x12, 0xf4, 0x6d, 0x64, 0xe6, 0x31, 0x37, 0x68, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* tamd_f17h_uncore_is_visible */
	.byte 0x12, 0xef, 0x2a, 0x64, 0xe6, 0x31, 0x39, 0x68, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_amd_f19h_uncore_is_visible */
	.byte 0x12, 0xf4, 0x6d, 0x64, 0xe6, 0x31, 0x39, 0x68, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* tamd_f19h_uncore_is_visible */
	.byte 0x0c, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xa9, 0x72, 0x74, 0x8d	/* t__pfx_amd_uncore_cpu_starting */
	.byte 0x0c, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xa9, 0x72, 0x74, 0x8d	/* tamd_uncore_cpu_starting */
	.byte 0x0c, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0x5f, 0xe7, 0x2d, 0x65	/* t__pfx_amd_uncore_cpu_online */
	.byte 0x0c, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0x5f, 0xe7, 0x2d, 0x65	/* tamd_uncore_cpu_online */
	.byte 0x10, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xed, 0xad, 0x6e, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* t__pfx_amd_uncore_cpu_down_prepare */
	.byte 0x10, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xed, 0xad, 0x6e, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* tamd_uncore_cpu_down_prepare */
	.byte 0x0b, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xed, 0x65, 0xc8	/* t__pfx_amd_uncore_cpu_dead */
	.byte 0x0b, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xed, 0x65, 0xc8	/* tamd_uncore_cpu_dead */
	.byte 0x0e, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x64, 0x66, 0xf0, 0x74, 0x78, 0xf6, 0x63, 0xd2	/* t__pfx_amd_uncore_df_ctx_scan */
	.byte 0x0e, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x64, 0x66, 0xf0, 0x74, 0x78, 0xf6, 0x63, 0xd2	/* tamd_uncore_df_ctx_scan */
	.byte 0x0b, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x6c, 0x33, 0x5f, 0xcc, 0x0f	/* t__pfx_amd_uncore_l3_event_init */
	.byte 0x0b, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x6c, 0x33, 0x5f, 0xcc, 0x0f	/* tamd_uncore_l3_event_init */
	.byte 0x0e, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x6c, 0x33, 0xf0, 0x74, 0x78, 0xf6, 0x63, 0xd2	/* t__pfx_amd_uncore_l3_ctx_scan */
	.byte 0x0e, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x6c, 0x33, 0xf0, 0x74, 0x78, 0xf6, 0x63, 0xd2	/* tamd_uncore_l3_ctx_scan */
	.byte 0x0f, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x75, 0x6d, 0x63, 0xf0, 0x74, 0x78, 0xf6, 0x63, 0xd2	/* t__pfx_amd_uncore_umc_ctx_scan */
	.byte 0x0f, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x75, 0x6d, 0x63, 0xf0, 0x74, 0x78, 0xf6, 0x63, 0xd2	/* tamd_uncore_umc_ctx_scan */
	.byte 0x08, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x64, 0xdb	/* t__pfx_amd_uncore_del */
	.byte 0x08, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x64, 0xdb	/* tamd_uncore_del */
	.byte 0x08, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0xc8, 0x64	/* t__pfx_amd_uncore_add */
	.byte 0x08, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0xc8, 0x64	/* tamd_uncore_add */
	.byte 0x08, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0xf7, 0xc8	/* t__pfx_amd_uncore_read */
	.byte 0x08, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0xf7, 0xc8	/* tamd_uncore_read */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x72, 0x64, 0x77, 0x72, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx___uncore_rdwrmask_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x72, 0x64, 0x77, 0x72, 0xd9, 0x5e, 0xf6, 0x7c	/* t__uncore_rdwrmask_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xd7, 0x74, 0x38, 0xf6, 0x7c	/* t__pfx___uncore_event8_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xd7, 0x74, 0x38, 0xf6, 0x7c	/* t__uncore_event8_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x73, 0x6c, 0xaa, 0x65, 0x9f, 0xf6, 0x7c	/* t__pfx___uncore_sliceid_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x73, 0x6c, 0xaa, 0x65, 0x9f, 0xf6, 0x7c	/* t__uncore_sliceid_show */
	.byte 0x0c, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xf1, 0x5d, 0x03, 0x29, 0xf6, 0x7c	/* t__pfx___uncore_enallcores_show */
	.byte 0x0b, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xf1, 0x5d, 0x03, 0x29, 0xf6, 0x7c	/* t__uncore_enallcores_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xf1, 0x5d, 0x73, 0x6c, 0xaa, 0xd6, 0xf6, 0x7c	/* t__pfx___uncore_enallslices_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xf1, 0x5d, 0x73, 0x6c, 0xaa, 0xd6, 0xf6, 0x7c	/* t__uncore_enallslices_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x03, 0xf7, 0x9f, 0xf6, 0x7c	/* t__pfx___uncore_coreid_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x03, 0xf7, 0x9f, 0xf6, 0x7c	/* t__uncore_coreid_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x73, 0x6c, 0xaa, 0x65, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx___uncore_slicemask_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x73, 0x6c, 0xaa, 0x65, 0xd9, 0x5e, 0xf6, 0x7c	/* t__uncore_slicemask_show */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x74, 0x68, 0xf7, 0xc8, 0xd9, 0x5e, 0x38, 0xf6, 0x7c	/* t__pfx___uncore_threadmask8_show */
	.byte 0x0e, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x74, 0x68, 0xf7, 0xc8, 0xd9, 0x5e, 0x38, 0xf6, 0x7c	/* t__uncore_threadmask8_show */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x74, 0x68, 0xf7, 0xc8, 0xd9, 0x5e, 0x32, 0xf6, 0x7c	/* t__pfx___uncore_threadmask2_show */
	.byte 0x0e, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x74, 0x68, 0xf7, 0xc8, 0xd9, 0x5e, 0x32, 0xf6, 0x7c	/* t__uncore_threadmask2_show */
	.byte 0x0c, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x75, 0xd9, 0x5e, 0x38, 0xf6, 0x7c	/* t__pfx___uncore_umask8_show */
	.byte 0x0b, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x75, 0xd9, 0x5e, 0x38, 0xf6, 0x7c	/* t__uncore_umask8_show */
	.byte 0x0c, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xd7, 0x74, 0x31, 0x32, 0xf6, 0x7c	/* t__pfx___uncore_event12_show */
	.byte 0x0b, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xd7, 0x74, 0x31, 0x32, 0xf6, 0x7c	/* t__uncore_event12_show */
	.byte 0x0c, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xd7, 0x74, 0x31, 0x34, 0xf6, 0x7c	/* t__pfx___uncore_event14_show */
	.byte 0x0b, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xd7, 0x74, 0x31, 0x34, 0xf6, 0x7c	/* t__uncore_event14_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x75, 0xd9, 0x5e, 0x31, 0x32, 0xf6, 0x7c	/* t__pfx___uncore_umask12_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x75, 0xd9, 0x5e, 0x31, 0x32, 0xf6, 0x7c	/* t__uncore_umask12_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xd7, 0x74, 0x31, 0x34, 0x76, 0x32, 0xf6, 0x7c	/* t__pfx___uncore_event14v2_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xd7, 0x74, 0x31, 0x34, 0x76, 0x32, 0xf6, 0x7c	/* t__uncore_event14v2_show */
	.byte 0x0d, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x24, 0xf6, 0x7c, 0xf0, 0x9c, 0xd9, 0x5e	/* t__pfx_amd_uncore_attr_show_cpumask */
	.byte 0x0d, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x24, 0xf6, 0x7c, 0xf0, 0x9c, 0xd9, 0x5e	/* tamd_uncore_attr_show_cpumask */
	.byte 0x11, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x63, 0x74, 0x78, 0xe6, 0xf7, 0x65, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__pfx_amd_uncore_ctx_free.part.0 */
	.byte 0x11, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x63, 0x74, 0x78, 0xe6, 0xf7, 0x65, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* tamd_uncore_ctx_free.part.0 */
	.byte 0x0c, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x63, 0x74, 0x78, 0xe6, 0xf7, 0x65	/* t__pfx_amd_uncore_ctx_free */
	.byte 0x0c, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x63, 0x74, 0x78, 0xe6, 0xf7, 0x65	/* tamd_uncore_ctx_free */
	.byte 0x0b, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x63, 0x74, 0x78, 0xbf, 0xea	/* t__pfx_amd_uncore_ctx_init */
	.byte 0x0b, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x63, 0x74, 0x78, 0xbf, 0xea	/* tamd_uncore_ctx_init */
	.byte 0x0d, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x63, 0x74, 0x78, 0xc1, 0x6f, 0x76, 0x65	/* t__pfx_amd_uncore_ctx_move */
	.byte 0x0d, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x63, 0x74, 0x78, 0xc1, 0x6f, 0x76, 0x65	/* tamd_uncore_ctx_move */
	.byte 0x0e, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x75, 0x6d, 0x63, 0xf0, 0x74, 0x78, 0xbf, 0xea	/* t__pfx_amd_uncore_umc_ctx_init */
	.byte 0x0e, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x75, 0x6d, 0x63, 0xf0, 0x74, 0x78, 0xbf, 0xea	/* tamd_uncore_umc_ctx_init */
	.byte 0x0d, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x64, 0x66, 0xf0, 0x74, 0x78, 0xbf, 0xea	/* t__pfx_amd_uncore_df_ctx_init */
	.byte 0x0d, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x64, 0x66, 0xf0, 0x74, 0x78, 0xbf, 0xea	/* tamd_uncore_df_ctx_init */
	.byte 0x0d, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x6c, 0x33, 0xf0, 0x74, 0x78, 0xbf, 0xea	/* t__pfx_amd_uncore_l3_ctx_init */
	.byte 0x0d, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x6c, 0x33, 0xf0, 0x74, 0x78, 0xbf, 0xea	/* tamd_uncore_l3_ctx_init */
	.byte 0x0b, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x75, 0x6d, 0xc9, 0xcc, 0x0f	/* t__pfx_amd_uncore_umc_event_init */
	.byte 0x0b, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x75, 0x6d, 0xc9, 0xcc, 0x0f	/* tamd_uncore_umc_event_init */
	.byte 0x0a, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x64, 0x3b, 0xcc, 0x0f	/* t__pfx_amd_uncore_df_event_init */
	.byte 0x0a, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x64, 0x3b, 0xcc, 0x0f	/* tamd_uncore_df_event_init */
	.byte 0x09, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x73, 0x74, 0xbe	/* t__pfx_amd_uncore_stop */
	.byte 0x09, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x73, 0x74, 0xbe	/* tamd_uncore_stop */
	.byte 0x09, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x3d, 0x72, 0x74	/* t__pfx_amd_uncore_start */
	.byte 0x09, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x3d, 0x72, 0x74	/* tamd_uncore_start */
	.byte 0x0c, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x75, 0x6d, 0x63, 0xa9, 0x72, 0x74	/* t__pfx_amd_uncore_umc_start */
	.byte 0x0c, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x75, 0x6d, 0x63, 0xa9, 0x72, 0x74	/* tamd_uncore_umc_start */
	.byte 0x0a, 0xef, 0x2a, 0xda, 0x96, 0xd5, 0xfc, 0x64, 0x3b, 0xc8, 0x64	/* t__pfx_amd_uncore_df_add */
	.byte 0x0a, 0xf4, 0x6d, 0xda, 0x96, 0xd5, 0xfc, 0x64, 0x3b, 0xc8, 0x64	/* tamd_uncore_df_add */
	.byte 0x0a, 0xef, 0x19, 0x3b, 0xc0, 0x6d, 0x6d, 0x75, 0x5f, 0xcc, 0x0f	/* t__pfx_perf_iommu_event_init */
	.byte 0x0a, 0xce, 0xf5, 0x3b, 0xc0, 0x6d, 0x6d, 0x75, 0x5f, 0xcc, 0x0f	/* tperf_iommu_event_init */
	.byte 0x0a, 0x74, 0xaf, 0xc0, 0x6d, 0x6d, 0x75, 0x5f, 0xcc, 0x73, 0x7c	/* t__pfx__iommu_event_show */
	.byte 0x09, 0xfe, 0xc0, 0x6d, 0x6d, 0x75, 0x5f, 0xcc, 0x73, 0x7c	/* t_iommu_event_show */
	.byte 0x0a, 0xef, 0x64, 0x6f, 0x6d, 0x69, 0xda, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx_domid_mask_show */
	.byte 0x0a, 0x74, 0x64, 0x6f, 0x6d, 0x69, 0xda, 0xd9, 0x5e, 0xf6, 0x7c	/* tdomid_mask_show */
	.byte 0x09, 0xef, 0x70, 0xbb, 0x69, 0xda, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx_pasid_mask_show */
	.byte 0x08, 0xce, 0xbb, 0x69, 0xda, 0xd9, 0x5e, 0xf6, 0x7c	/* tpasid_mask_show */
	.byte 0x08, 0xef, 0xb5, 0x69, 0xda, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx_devid_mask_show */
	.byte 0x08, 0x74, 0xb5, 0x69, 0xda, 0xd9, 0x5e, 0xf6, 0x7c	/* tdevid_mask_show */
	.byte 0x07, 0xef, 0x64, 0x6f, 0x6d, 0x9f, 0xf6, 0x7c	/* t__pfx_domid_show */
	.byte 0x07, 0x74, 0x64, 0x6f, 0x6d, 0x9f, 0xf6, 0x7c	/* tdomid_show */
	.byte 0x06, 0xef, 0x70, 0xbb, 0x9f, 0xf6, 0x7c	/* t__pfx_pasid_show */
	.byte 0x05, 0xce, 0xbb, 0x9f, 0xf6, 0x7c	/* tpasid_show */
	.byte 0x05, 0xef, 0xb5, 0x9f, 0xf6, 0x7c	/* t__pfx_devid_show */
	.byte 0x05, 0x74, 0xb5, 0x9f, 0xf6, 0x7c	/* tdevid_show */
	.byte 0x09, 0xef, 0x63, 0x73, 0x6f, 0x98, 0x63, 0xfc, 0x73, 0x7c	/* t__pfx_csource_show */
	.byte 0x08, 0x26, 0x73, 0x6f, 0x98, 0x63, 0xfc, 0x73, 0x7c	/* tcsource_show */
	.byte 0x09, 0xef, 0x19, 0x3b, 0xc0, 0x6d, 0x6d, 0x75, 0xde, 0xc8	/* t__pfx_perf_iommu_read */
	.byte 0x09, 0xce, 0xf5, 0x3b, 0xc0, 0x6d, 0x6d, 0x75, 0xde, 0xc8	/* tperf_iommu_read */
	.byte 0x0a, 0xef, 0x19, 0x3b, 0xc0, 0x6d, 0x6d, 0x75, 0xa9, 0x72, 0x74	/* t__pfx_perf_iommu_start */
	.byte 0x0a, 0xce, 0xf5, 0x3b, 0xc0, 0x6d, 0x6d, 0x75, 0xa9, 0x72, 0x74	/* tperf_iommu_start */
	.byte 0x0c, 0x74, 0xaf, 0xc0, 0x6d, 0x6d, 0x75, 0xf0, 0x9c, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx__iommu_cpumask_show */
	.byte 0x0b, 0xfe, 0xc0, 0x6d, 0x6d, 0x75, 0xf0, 0x9c, 0xd9, 0x5e, 0xf6, 0x7c	/* t_iommu_cpumask_show */
	.byte 0x0f, 0xef, 0x19, 0x3b, 0xc0, 0x6d, 0x6d, 0x75, 0xf6, 0x74, 0xbe, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__pfx_perf_iommu_stop.part.0 */
	.byte 0x0f, 0xce, 0xf5, 0x3b, 0xc0, 0x6d, 0x6d, 0x75, 0xf6, 0x74, 0xbe, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* tperf_iommu_stop.part.0 */
	.byte 0x0a, 0xef, 0x19, 0x3b, 0xc0, 0x6d, 0x6d, 0x75, 0xf6, 0x74, 0xbe	/* t__pfx_perf_iommu_stop */
	.byte 0x0a, 0xce, 0xf5, 0x3b, 0xc0, 0x6d, 0x6d, 0x75, 0xf6, 0x74, 0xbe	/* tperf_iommu_stop */
	.byte 0x0a, 0xef, 0x19, 0x3b, 0xc0, 0x6d, 0x6d, 0x75, 0x5f, 0xc8, 0x64	/* t__pfx_perf_iommu_add */
	.byte 0x0a, 0xce, 0xf5, 0x3b, 0xc0, 0x6d, 0x6d, 0x75, 0x5f, 0xc8, 0x64	/* tperf_iommu_add */
	.byte 0x09, 0xef, 0x19, 0x3b, 0xc0, 0x6d, 0x6d, 0x75, 0xed, 0xdb	/* t__pfx_perf_iommu_del */
	.byte 0x09, 0xce, 0xf5, 0x3b, 0xc0, 0x6d, 0x6d, 0x75, 0xed, 0xdb	/* tperf_iommu_del */
	.byte 0x0a, 0xef, 0x74, 0xd6, 0xfe, 0x61, 0x19, 0x66, 0xb6, 0xf5, 0x66	/* t__pfx_test_aperfmperf */
	.byte 0x0a, 0x74, 0x74, 0xd6, 0xfe, 0x61, 0x19, 0x66, 0xb6, 0xf5, 0x66	/* ttest_aperfmperf */
	.byte 0x07, 0xef, 0x74, 0xd6, 0xfe, 0x70, 0x93, 0x63	/* t__pfx_test_ptsc */
	.byte 0x07, 0x74, 0x74, 0xd6, 0xfe, 0x70, 0x93, 0x63	/* ttest_ptsc */
	.byte 0x07, 0xef, 0x74, 0xd6, 0xfe, 0xab, 0x19, 0x66	/* t__pfx_test_irperf */
	.byte 0x07, 0x74, 0x74, 0xd6, 0xfe, 0xab, 0x19, 0x66	/* ttest_irperf */
	.byte 0x0b, 0xef, 0x74, 0xd6, 0xfe, 0x74, 0x68, 0xf5, 0x6d, 0xa9, 0x74, 0xb1	/* t__pfx_test_therm_status */
	.byte 0x0b, 0x74, 0x74, 0xd6, 0xfe, 0x74, 0x68, 0xf5, 0x6d, 0xa9, 0x74, 0xb1	/* ttest_therm_status */
	.byte 0x05, 0xef, 0x74, 0xd6, 0xfe, 0x9a	/* t__pfx_test_intel */
	.byte 0x05, 0x74, 0x74, 0xd6, 0xfe, 0x9a	/* ttest_intel */
	.byte 0x07, 0xef, 0x6d, 0x73, 0x72, 0x5f, 0xcc, 0x0f	/* t__pfx_msr_event_init */
	.byte 0x07, 0x74, 0x6d, 0x73, 0x72, 0x5f, 0xcc, 0x0f	/* tmsr_event_init */
	.byte 0x04, 0xef, 0xcc, 0x73, 0x7c	/* t__pfx_event_show */
	.byte 0x04, 0x74, 0xcc, 0x73, 0x7c	/* tevent_show */
	.byte 0x08, 0xef, 0x6d, 0x73, 0x72, 0x5f, 0xcc, 0xc8, 0x64	/* t__pfx_msr_event_add */
	.byte 0x08, 0x74, 0x6d, 0x73, 0x72, 0x5f, 0xcc, 0xc8, 0x64	/* tmsr_event_add */
	.byte 0x09, 0xef, 0x6d, 0x73, 0x72, 0x5f, 0xcc, 0x3d, 0x72, 0x74	/* t__pfx_msr_event_start */
	.byte 0x09, 0x74, 0x6d, 0x73, 0x72, 0x5f, 0xcc, 0x3d, 0x72, 0x74	/* tmsr_event_start */
	.byte 0x09, 0xef, 0x6d, 0x73, 0x72, 0x5f, 0xcc, 0xcd, 0x64, 0x14	/* t__pfx_msr_event_update */
	.byte 0x09, 0x74, 0x6d, 0x73, 0x72, 0x5f, 0xcc, 0xcd, 0x64, 0x14	/* tmsr_event_update */
	.byte 0x09, 0xef, 0x6d, 0x73, 0x72, 0x5f, 0xcc, 0x73, 0x74, 0xbe	/* t__pfx_msr_event_stop */
	.byte 0x09, 0x74, 0x6d, 0x73, 0x72, 0x5f, 0xcc, 0x73, 0x74, 0xbe	/* tmsr_event_stop */
	.byte 0x08, 0xef, 0x6d, 0x73, 0x72, 0x5f, 0xcc, 0x64, 0xdb	/* t__pfx_msr_event_del */
	.byte 0x08, 0x74, 0x6d, 0x73, 0x72, 0x5f, 0xcc, 0x64, 0xdb	/* tmsr_event_del */
	.byte 0x08, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x97	/* t__pfx_intel_pmu_event_map */
	.byte 0x08, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x97	/* tintel_pmu_event_map */
	.byte 0x0a, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0x5d	/* t__pfx_intel_pmu_disable_all */
	.byte 0x0a, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0x5d	/* tintel_pmu_disable_all */
	.byte 0x11, 0x74, 0xaf, 0x5f, 0xaa, 0x6c, 0x5f, 0xcd, 0x64, 0x91, 0x74, 0xbe, 0x64, 0xad, 0x6e, 0x5f, 0xd7, 0x74	/* t__pfx___icl_update_topdown_event */
	.byte 0x10, 0x74, 0xff, 0xaa, 0x6c, 0x5f, 0xcd, 0x64, 0x91, 0x74, 0xbe, 0x64, 0xad, 0x6e, 0x5f, 0xd7, 0x74	/* t__icl_update_topdown_event */
	.byte 0x0d, 0xef, 0x9a, 0xec, 0x65, 0x62, 0xe9, 0xe5, 0x69, 0xbb, 0xd6, 0x3a, 0xf7, 0x32	/* t__pfx_intel_pebs_aliases_core2 */
	.byte 0x0d, 0x74, 0x9a, 0xec, 0x65, 0x62, 0xe9, 0xe5, 0x69, 0xbb, 0xd6, 0x3a, 0xf7, 0x32	/* tintel_pebs_aliases_core2 */
	.byte 0x0d, 0xef, 0x9a, 0xec, 0x65, 0x62, 0xe9, 0xe5, 0x69, 0xbb, 0xd6, 0xf6, 0x6e, 0x62	/* t__pfx_intel_pebs_aliases_snb */
	.byte 0x0d, 0x74, 0x9a, 0xec, 0x65, 0x62, 0xe9, 0xe5, 0x69, 0xbb, 0xd6, 0xf6, 0x6e, 0x62	/* tintel_pebs_aliases_snb */
	.byte 0x0e, 0xef, 0xc8, 0x6c, 0x86, 0x68, 0x79, 0x62, 0x72, 0x9f, 0xf0, 0x9c, 0xa7, 0x21, 0x65	/* t__pfx_adl_get_hybrid_cpu_type */
	.byte 0x0e, 0xf4, 0x64, 0x6c, 0x86, 0x68, 0x79, 0x62, 0x72, 0x9f, 0xf0, 0x9c, 0xa7, 0x21, 0x65	/* tadl_get_hybrid_cpu_type */
	.byte 0x0b, 0xef, 0x68, 0x73, 0x8f, 0x6c, 0x69, 0x6d, 0x9d, 0x19, 0xc0, 0x64	/* t__pfx_hsw_limit_period */
	.byte 0x0b, 0x74, 0x68, 0x73, 0x8f, 0x6c, 0x69, 0x6d, 0x9d, 0x19, 0xc0, 0x64	/* thsw_limit_period */
	.byte 0x0b, 0xef, 0x6e, 0x68, 0xae, 0x6c, 0x69, 0x6d, 0x9d, 0x19, 0xc0, 0x64	/* t__pfx_nhm_limit_period */
	.byte 0x0b, 0x74, 0x6e, 0x68, 0xae, 0x6c, 0x69, 0x6d, 0x9d, 0x19, 0xc0, 0x64	/* tnhm_limit_period */
	.byte 0x0b, 0xef, 0x93, 0x78, 0x5f, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_tsx_is_visible */
	.byte 0x0b, 0x74, 0x93, 0x78, 0x5f, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* ttsx_is_visible */
	.byte 0x0b, 0xef, 0xcb, 0xbc, 0x5f, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_exra_is_visible */
	.byte 0x0b, 0x74, 0xcb, 0xbc, 0x5f, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* texra_is_visible */
	.byte 0x11, 0xef, 0x68, 0x79, 0x62, 0x72, 0x69, 0xda, 0xd7, 0x74, 0xe9, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_hybrid_events_is_visible */
	.byte 0x11, 0x74, 0x68, 0x79, 0x62, 0x72, 0x69, 0xda, 0xd7, 0x74, 0xe9, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* thybrid_events_is_visible */
	.byte 0x10, 0xef, 0x68, 0x79, 0x62, 0x72, 0x69, 0xda, 0x74, 0xda, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_hybrid_td_is_visible */
	.byte 0x10, 0x74, 0x68, 0x79, 0x62, 0x72, 0x69, 0xda, 0x74, 0xda, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* thybrid_td_is_visible */
	.byte 0x10, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x76, 0x36, 0x5f, 0xc8, 0xac, 0x5f, 0x6f, 0x66, 0x95, 0xd4	/* t__pfx_intel_pmu_v6_addr_offset */
	.byte 0x10, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x76, 0x36, 0x5f, 0xc8, 0xac, 0x5f, 0x6f, 0x66, 0x95, 0xd4	/* tintel_pmu_v6_addr_offset */
	.byte 0x09, 0xef, 0x64, 0x79, 0x6e, 0x3e, 0x73, 0xf3, 0x61, 0xb3	/* t__pfx_dyn_constraint */
	.byte 0x09, 0x74, 0x64, 0x79, 0x6e, 0x3e, 0x73, 0xf3, 0x61, 0xb3	/* tdyn_constraint */
	.byte 0x0c, 0xef, 0x9a, 0xc7, 0x75, 0xd6, 0xfe, 0x67, 0xe2, 0x6d, 0x73, 0x72, 0x73	/* t__pfx_intel_guest_get_msrs */
	.byte 0x0c, 0x74, 0x9a, 0xc7, 0x75, 0xd6, 0xfe, 0x67, 0xe2, 0x6d, 0x73, 0x72, 0x73	/* tintel_guest_get_msrs */
	.byte 0x13, 0x74, 0xaf, 0xbf, 0x74, 0xdb, 0xf6, 0x68, 0x61, 0xf7, 0x64, 0xde, 0x67, 0x86, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* t__pfx___intel_shared_reg_get_constraints */
	.byte 0x11, 0x74, 0xff, 0x9a, 0xf6, 0x68, 0x61, 0xf7, 0x64, 0xde, 0x67, 0x86, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* t__intel_shared_reg_get_constraints */
	.byte 0x0a, 0xef, 0x9a, 0xf6, 0x74, 0xbe, 0xf6, 0xba, 0x9e, 0x02, 0x8d	/* t__pfx_intel_stop_scheduling */
	.byte 0x0a, 0x74, 0x9a, 0xf6, 0x74, 0xbe, 0xf6, 0xba, 0x9e, 0x02, 0x8d	/* tintel_stop_scheduling */
	.byte 0x0b, 0xef, 0x9a, 0x3a, 0x6d, 0x6d, 0x9d, 0x73, 0xba, 0x9e, 0x02, 0x8d	/* t__pfx_intel_commit_scheduling */
	.byte 0x0b, 0x74, 0x9a, 0x3a, 0x6d, 0x6d, 0x9d, 0x73, 0xba, 0x9e, 0x02, 0x8d	/* tintel_commit_scheduling */
	.byte 0x0a, 0xef, 0x9a, 0xa9, 0x72, 0xfe, 0x73, 0xba, 0x9e, 0x02, 0x8d	/* t__pfx_intel_start_scheduling */
	.byte 0x0a, 0x74, 0x9a, 0xa9, 0x72, 0xfe, 0x73, 0xba, 0x9e, 0x02, 0x8d	/* tintel_start_scheduling */
	.byte 0x09, 0xeb, 0x9a, 0x5f, 0xcc, 0xe1, 0x73, 0x95, 0xf6, 0x7c	/* T__pfx_intel_event_sysfs_show */
	.byte 0x09, 0x54, 0x9a, 0x5f, 0xcc, 0xe1, 0x73, 0x95, 0xf6, 0x7c	/* Tintel_event_sysfs_show */
	.byte 0x09, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xe6, 0x69, 0x6c, 0xa2	/* t__pfx_intel_pmu_filter */
	.byte 0x09, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xe6, 0x69, 0x6c, 0xa2	/* tintel_pmu_filter */
	.byte 0x09, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0xcd, 0x64, 0x14	/* t__pfx_intel_pmu_update */
	.byte 0x09, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0xcd, 0x64, 0x14	/* tintel_pmu_update */
	.byte 0x09, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0x84, 0x19, 0xc0, 0x64	/* t__pfx_intel_pmu_set_period */
	.byte 0x09, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0x84, 0x19, 0xc0, 0x64	/* tintel_pmu_set_period */
	.byte 0x0a, 0xef, 0x73, 0x7c, 0x7f, 0x73, 0x63, 0x23, 0xa7, 0x66, 0x61	/* t__pfx_show_sysctl_tfa */
	.byte 0x09, 0x93, 0x7c, 0x7f, 0x73, 0x63, 0x23, 0xa7, 0x66, 0x61	/* tshow_sysctl_tfa */
	.byte 0x0e, 0xef, 0x62, 0x72, 0xd2, 0xba, 0x3a, 0xe4, 0xa2, 0x92, 0x9f, 0x74, 0x68, 0xf6, 0x7c	/* t__pfx_branch_counter_width_show */
	.byte 0x0e, 0x74, 0x62, 0x72, 0xd2, 0xba, 0x3a, 0xe4, 0xa2, 0x92, 0x9f, 0x74, 0x68, 0xf6, 0x7c	/* tbranch_counter_width_show */
	.byte 0x08, 0xef, 0x62, 0x72, 0xd2, 0xba, 0xd6, 0xf6, 0x7c	/* t__pfx_branches_show */
	.byte 0x08, 0x74, 0x62, 0x72, 0xd2, 0xba, 0xd6, 0xf6, 0x7c	/* tbranches_show */
	.byte 0x0e, 0xef, 0x9a, 0xa3, 0x79, 0x62, 0x72, 0x69, 0xda, 0x67, 0xe2, 0x24, 0xf0, 0x70, 0xb1	/* t__pfx_intel_hybrid_get_attr_cpus */
	.byte 0x0e, 0x74, 0x9a, 0xa3, 0x79, 0x62, 0x72, 0x69, 0xda, 0x67, 0xe2, 0x24, 0xf0, 0x70, 0xb1	/* tintel_hybrid_get_attr_cpus */
	.byte 0x0a, 0xef, 0x73, 0xe2, 0xe1, 0x73, 0x63, 0x23, 0xa7, 0x66, 0x61	/* t__pfx_set_sysctl_tfa */
	.byte 0x09, 0x93, 0xe2, 0xe1, 0x73, 0x63, 0x23, 0xa7, 0x66, 0x61	/* tset_sysctl_tfa */
	.byte 0x0d, 0xef, 0x66, 0xf7, 0x65, 0x7a, 0xfc, 0xe7, 0xf6, 0x6d, 0x69, 0xf6, 0x8a, 0xf7	/* t__pfx_freeze_on_smi_store */
	.byte 0x0d, 0x74, 0x66, 0xf7, 0x65, 0x7a, 0xfc, 0xe7, 0xf6, 0x6d, 0x69, 0xf6, 0x8a, 0xf7	/* tfreeze_on_smi_store */
	.byte 0x0c, 0xef, 0x66, 0xf7, 0x65, 0x7a, 0xfc, 0xe7, 0xf6, 0x6d, 0x69, 0xf6, 0x7c	/* t__pfx_freeze_on_smi_show */
	.byte 0x0c, 0x74, 0x66, 0xf7, 0x65, 0x7a, 0xfc, 0xe7, 0xf6, 0x6d, 0x69, 0xf6, 0x7c	/* tfreeze_on_smi_show */
	.byte 0x05, 0xef, 0x65, 0x71, 0xf6, 0x7c	/* t__pfx_eq_show */
	.byte 0x04, 0x2c, 0x71, 0xf6, 0x7c	/* teq_show */
	.byte 0x07, 0xef, 0x75, 0xd9, 0x5e, 0x32, 0xf6, 0x7c	/* t__pfx_umask2_show */
	.byte 0x07, 0x74, 0x75, 0xd9, 0x5e, 0x32, 0xf6, 0x7c	/* tumask2_show */
	.byte 0x09, 0xef, 0x66, 0x72, 0xe7, 0x74, 0xf1, 0x64, 0xf6, 0x7c	/* t__pfx_frontend_show */
	.byte 0x09, 0x74, 0x66, 0x72, 0xe7, 0x74, 0xf1, 0x64, 0xf6, 0x7c	/* tfrontend_show */
	.byte 0x08, 0xef, 0x6c, 0x64, 0x6c, 0x61, 0xfe, 0x73, 0x7c	/* t__pfx_ldlat_show */
	.byte 0x07, 0x23, 0x64, 0x6c, 0x61, 0xfe, 0x73, 0x7c	/* tldlat_show */
	.byte 0x0c, 0xef, 0x6f, 0x66, 0x66, 0x63, 0xd5, 0xfc, 0x72, 0x73, 0x70, 0xf6, 0x7c	/* t__pfx_offcore_rsp_show */
	.byte 0x0b, 0x8a, 0x66, 0x66, 0x63, 0xd5, 0xfc, 0x72, 0x73, 0x70, 0xf6, 0x7c	/* toffcore_rsp_show */
	.byte 0x08, 0xef, 0xf8, 0xa7, 0x78, 0xf0, 0x70, 0xf6, 0x7c	/* t__pfx_in_tx_cp_show */
	.byte 0x08, 0x74, 0xf8, 0xa7, 0x78, 0xf0, 0x70, 0xf6, 0x7c	/* tin_tx_cp_show */
	.byte 0x06, 0xef, 0xf8, 0xa7, 0x78, 0xf6, 0x7c	/* t__pfx_in_tx_show */
	.byte 0x06, 0x74, 0xf8, 0xa7, 0x78, 0xf6, 0x7c	/* tin_tx_show */
	.byte 0x06, 0xef, 0x63, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx_cmask_show */
	.byte 0x05, 0x26, 0xd9, 0x5e, 0xf6, 0x7c	/* tcmask_show */
	.byte 0x05, 0xef, 0xf8, 0x76, 0xf6, 0x7c	/* t__pfx_inv_show */
	.byte 0x05, 0x74, 0xf8, 0x76, 0xf6, 0x7c	/* tinv_show */
	.byte 0x05, 0xef, 0xd2, 0x79, 0xf6, 0x7c	/* t__pfx_any_show */
	.byte 0x05, 0xf4, 0x6e, 0x79, 0xf6, 0x7c	/* tany_show */
	.byte 0x05, 0xef, 0x70, 0x63, 0xf6, 0x7c	/* t__pfx_pc_show */
	.byte 0x04, 0xce, 0x63, 0xf6, 0x7c	/* tpc_show */
	.byte 0x06, 0xef, 0x9e, 0x67, 0xfc, 0x73, 0x7c	/* t__pfx_edge_show */
	.byte 0x06, 0x74, 0x9e, 0x67, 0xfc, 0x73, 0x7c	/* tedge_show */
	.byte 0x06, 0xef, 0x75, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx_umask_show */
	.byte 0x06, 0x74, 0x75, 0xd9, 0x5e, 0xf6, 0x7c	/* tumask_show */
	.byte 0x04, 0xef, 0xcc, 0x73, 0x7c	/* t__pfx_event_show */
	.byte 0x04, 0x74, 0xcc, 0x73, 0x7c	/* tevent_show */
	.byte 0x0c, 0xef, 0x62, 0x72, 0xd2, 0xba, 0x3a, 0xe4, 0xa2, 0xbd, 0x72, 0xf6, 0x7c	/* t__pfx_branch_counter_nr_show */
	.byte 0x0c, 0x74, 0x62, 0x72, 0xd2, 0xba, 0x3a, 0xe4, 0xa2, 0xbd, 0x72, 0xf6, 0x7c	/* tbranch_counter_nr_show */
	.byte 0x11, 0xef, 0x68, 0x79, 0x62, 0x72, 0x69, 0xda, 0x93, 0x78, 0x5f, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_hybrid_tsx_is_visible */
	.byte 0x11, 0x74, 0x68, 0x79, 0x62, 0x72, 0x69, 0xda, 0x93, 0x78, 0x5f, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* thybrid_tsx_is_visible */
	.byte 0x11, 0xef, 0x68, 0x79, 0x62, 0x72, 0x9f, 0xe6, 0xd5, 0xd9, 0xfe, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_hybrid_format_is_visible */
	.byte 0x11, 0x74, 0x68, 0x79, 0x62, 0x72, 0x9f, 0xe6, 0xd5, 0xd9, 0xfe, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* thybrid_format_is_visible */
	.byte 0x11, 0xef, 0xcd, 0x64, 0x91, 0x73, 0x61, 0x76, 0x65, 0xda, 0x74, 0xbe, 0x64, 0xad, 0x6e, 0xde, 0x67, 0x73	/* t__pfx_update_saved_topdown_regs */
	.byte 0x11, 0x74, 0xcd, 0x64, 0x91, 0x73, 0x61, 0x76, 0x65, 0xda, 0x74, 0xbe, 0x64, 0xad, 0x6e, 0xde, 0x67, 0x73	/* tupdate_saved_topdown_regs */
	.byte 0x11, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x61, 0x75, 0x78, 0x5f, 0x6f, 0x75, 0xce, 0x1e, 0x6d, 0xe8, 0xba	/* t__pfx_intel_pmu_aux_output_match */
	.byte 0x11, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x61, 0x75, 0x78, 0x5f, 0x6f, 0x75, 0xce, 0x1e, 0x6d, 0xe8, 0xba	/* tintel_pmu_aux_output_match */
	.byte 0x0f, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xf6, 0x77, 0x61, 0x70, 0x5f, 0xf4, 0x5e, 0xf0, 0x74, 0x78	/* t__pfx_intel_pmu_swap_task_ctx */
	.byte 0x0f, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xf6, 0x77, 0x61, 0x70, 0x5f, 0xf4, 0x5e, 0xf0, 0x74, 0x78	/* tintel_pmu_swap_task_ctx */
	.byte 0x0b, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xf6, 0xba, 0x65, 0xda, 0xf4, 0x5e	/* t__pfx_intel_pmu_sched_task */
	.byte 0x0b, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xf6, 0xba, 0x65, 0xda, 0xf4, 0x5e	/* tintel_pmu_sched_task */
	.byte 0x0a, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xde, 0x61, 0xda, 0xd7, 0x74	/* t__pfx_intel_pmu_read_event */
	.byte 0x0a, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xde, 0x61, 0xda, 0xd7, 0x74	/* tintel_pmu_read_event */
	.byte 0x0a, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xed, 0xdb, 0x5f, 0xd7, 0x74	/* t__pfx_intel_pmu_del_event */
	.byte 0x0a, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xed, 0xdb, 0x5f, 0xd7, 0x74	/* tintel_pmu_del_event */
	.byte 0x0a, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0xc8, 0xda, 0xd7, 0x74	/* t__pfx_intel_pmu_add_event */
	.byte 0x0a, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0xc8, 0xda, 0xd7, 0x74	/* tintel_pmu_add_event */
	.byte 0x0a, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xf0, 0x9c, 0xed, 0x79, 0x8d	/* t__pfx_intel_pmu_cpu_dying */
	.byte 0x0a, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xf0, 0x9c, 0xed, 0x79, 0x8d	/* tintel_pmu_cpu_dying */
	.byte 0x0c, 0xef, 0x63, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_core_pmu_enable_event */
	.byte 0x0b, 0x26, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tcore_pmu_enable_event */
	.byte 0x0e, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0x25, 0x65, 0xc6, 0x3a, 0xe4, 0xa2, 0xe9, 0xd9, 0x5e	/* t__pfx_intel_pmu_check_counters_mask */
	.byte 0x0e, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0x25, 0x65, 0xc6, 0x3a, 0xe4, 0xa2, 0xe9, 0xd9, 0x5e	/* tintel_pmu_check_counters_mask */
	.byte 0x0d, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0xbb, 0x85, 0x67, 0x6e, 0x5f, 0xd7, 0x74	/* t__pfx_intel_pmu_assign_event */
	.byte 0x0d, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0xbb, 0x85, 0x67, 0x6e, 0x5f, 0xd7, 0x74	/* tintel_pmu_assign_event */
	.byte 0x0e, 0xef, 0x9a, 0x25, 0x65, 0xc6, 0xec, 0x65, 0x62, 0xe9, 0xca, 0xa0, 0xe8, 0x69, 0xe7	/* t__pfx_intel_check_pebs_isolation */
	.byte 0x0e, 0x74, 0x9a, 0x25, 0x65, 0xc6, 0xec, 0x65, 0x62, 0xe9, 0xca, 0xa0, 0xe8, 0x69, 0xe7	/* tintel_check_pebs_isolation */
	.byte 0x0e, 0xef, 0x9a, 0xec, 0x65, 0x62, 0xe9, 0xe5, 0x69, 0xbb, 0x65, 0xe9, 0x69, 0x76, 0x62	/* t__pfx_intel_pebs_aliases_ivb */
	.byte 0x0e, 0x74, 0x9a, 0xec, 0x65, 0x62, 0xe9, 0xe5, 0x69, 0xbb, 0x65, 0xe9, 0x69, 0x76, 0x62	/* tintel_pebs_aliases_ivb */
	.byte 0x0d, 0xef, 0x9a, 0xec, 0x65, 0x62, 0xe9, 0xe5, 0x69, 0xbb, 0xd6, 0xf6, 0x6b, 0x6c	/* t__pfx_intel_pebs_aliases_skl */
	.byte 0x0d, 0x74, 0x9a, 0xec, 0x65, 0x62, 0xe9, 0xe5, 0x69, 0xbb, 0xd6, 0xf6, 0x6b, 0x6c	/* tintel_pebs_aliases_skl */
	.byte 0x0b, 0xef, 0x62, 0x64, 0x8f, 0x6c, 0x69, 0x6d, 0x9d, 0x19, 0xc0, 0x64	/* t__pfx_bdw_limit_period */
	.byte 0x0b, 0x74, 0x62, 0x64, 0x8f, 0x6c, 0x69, 0x6d, 0x9d, 0x19, 0xc0, 0x64	/* tbdw_limit_period */
	.byte 0x0c, 0xef, 0x6c, 0x62, 0x72, 0x5f, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_lbr_is_visible */
	.byte 0x0b, 0x23, 0x62, 0x72, 0x5f, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* tlbr_is_visible */
	.byte 0x0e, 0xef, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_default_is_visible */
	.byte 0x0e, 0x74, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* tdefault_is_visible */
	.byte 0x0a, 0xef, 0xa8, 0xae, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_mem_is_visible */
	.byte 0x0a, 0x74, 0xa8, 0xae, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* tmem_is_visible */
	.byte 0x0a, 0xef, 0x74, 0xda, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_td_is_visible */
	.byte 0x0a, 0x74, 0x74, 0xda, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* ttd_is_visible */
	.byte 0x0e, 0xef, 0xee, 0x93, 0xdb, 0x5f, 0xcb, 0xfe, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_evtsel_ext_is_visible */
	.byte 0x0e, 0x74, 0xee, 0x93, 0xdb, 0x5f, 0xcb, 0xfe, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* tevtsel_ext_is_visible */
	.byte 0x15, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0x25, 0x65, 0xc6, 0x5f, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__pfx_intel_pmu_check_event_constraints.part.0 */
	.byte 0x15, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0x25, 0x65, 0xc6, 0x5f, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* tintel_pmu_check_event_constraints.part.0 */
	.byte 0x0a, 0xef, 0xcd, 0x64, 0x91, 0x74, 0x66, 0x61, 0xf6, 0xba, 0x9e	/* t__pfx_update_tfa_sched */
	.byte 0x0a, 0x74, 0xcd, 0x64, 0x91, 0x74, 0x66, 0x61, 0xf6, 0xba, 0x9e	/* tupdate_tfa_sched */
	.byte 0x09, 0xef, 0x66, 0x6c, 0x28, 0xf6, 0x6d, 0x6d, 0xb8, 0xea	/* t__pfx_flip_smm_bit */
	.byte 0x09, 0x74, 0x66, 0x6c, 0x28, 0xf6, 0x6d, 0x6d, 0xb8, 0xea	/* tflip_smm_bit */
	.byte 0x0b, 0xef, 0x67, 0x6c, 0xc9, 0x6c, 0x69, 0x6d, 0x9d, 0x19, 0xc0, 0x64	/* t__pfx_glc_limit_period */
	.byte 0x0b, 0x74, 0x67, 0x6c, 0xc9, 0x6c, 0x69, 0x6d, 0x9d, 0x19, 0xc0, 0x64	/* tglc_limit_period */
	.byte 0x0e, 0xef, 0x9a, 0xf6, 0x6e, 0x62, 0x25, 0x65, 0xc6, 0xc1, 0xaa, 0xe3, 0x63, 0xb7, 0x65	/* t__pfx_intel_snb_check_microcode */
	.byte 0x0e, 0x74, 0x9a, 0xf6, 0x6e, 0x62, 0x25, 0x65, 0xc6, 0xc1, 0xaa, 0xe3, 0x63, 0xb7, 0x65	/* tintel_snb_check_microcode */
	.byte 0x0f, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xa3, 0x77, 0x3e, 0xa5, 0x67, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__pfx_intel_pmu_hw_config.part.0 */
	.byte 0x0f, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xa3, 0x77, 0x3e, 0xa5, 0x67, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* tintel_pmu_hw_config.part.0 */
	.byte 0x0a, 0xef, 0x73, 0x6e, 0x6f, 0xbe, 0xa6, 0x73, 0x70, 0xf6, 0x7c	/* t__pfx_snoop_rsp_show */
	.byte 0x09, 0x93, 0x6e, 0x6f, 0xbe, 0xa6, 0x73, 0x70, 0xf6, 0x7c	/* tsnoop_rsp_show */
	.byte 0x0c, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0x25, 0x65, 0xc6, 0xec, 0xf5, 0xc0, 0x64	/* t__pfx_intel_pmu_check_period */
	.byte 0x0c, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0x25, 0x65, 0xc6, 0xec, 0xf5, 0xc0, 0x64	/* tintel_pmu_check_period */
	.byte 0x0a, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xb8, 0x93, 0x3e, 0xa5, 0x67	/* t__pfx_intel_pmu_bts_config */
	.byte 0x0a, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xb8, 0x93, 0x3e, 0xa5, 0x67	/* tintel_pmu_bts_config */
	.byte 0x0c, 0xef, 0x63, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_core_pmu_hw_config */
	.byte 0x0b, 0x26, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* tcore_pmu_hw_config */
	.byte 0x0a, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_intel_pmu_hw_config */
	.byte 0x0a, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* tintel_pmu_hw_config */
	.byte 0x0b, 0xef, 0x9a, 0xec, 0x1e, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* t__pfx_intel_put_event_constraints */
	.byte 0x0b, 0x74, 0x9a, 0xec, 0x1e, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* tintel_put_event_constraints */
	.byte 0x0e, 0xef, 0x63, 0xd5, 0xfc, 0x67, 0x75, 0xd6, 0xfe, 0x67, 0xe2, 0x6d, 0x73, 0x72, 0x73	/* t__pfx_core_guest_get_msrs */
	.byte 0x0d, 0x26, 0xd5, 0xfc, 0x67, 0x75, 0xd6, 0xfe, 0x67, 0xe2, 0x6d, 0x73, 0x72, 0x73	/* tcore_guest_get_msrs */
	.byte 0x09, 0xef, 0x68, 0x73, 0x77, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_hsw_hw_config */
	.byte 0x09, 0x74, 0x68, 0x73, 0x77, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* thsw_hw_config */
	.byte 0x08, 0xef, 0xc8, 0x6c, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_adl_hw_config */
	.byte 0x08, 0xf4, 0x64, 0x6c, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* tadl_hw_config */
	.byte 0x09, 0xef, 0xc5, 0x6c, 0xa3, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_arl_h_hw_config */
	.byte 0x09, 0xf4, 0x72, 0x6c, 0xa3, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* tarl_h_hw_config */
	.byte 0x0d, 0xef, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_x86_pmu_disable_event */
	.byte 0x0d, 0x74, 0x78, 0x38, 0x36, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* tx86_pmu_disable_event */
	.byte 0x13, 0x74, 0xaf, 0xbf, 0x74, 0xdb, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x5d, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__pfx___intel_pmu_enable_all.constprop.0 */
	.byte 0x11, 0x74, 0xff, 0x9a, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x5d, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__intel_pmu_enable_all.constprop.0 */
	.byte 0x16, 0x74, 0xaf, 0xbf, 0x74, 0xdb, 0xec, 0x6d, 0x75, 0xf6, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0xfe, 0x62, 0x72, 0xd2, 0xba, 0xa9, 0xc6	/* t__pfx___intel_pmu_snapshot_branch_stack */
	.byte 0x14, 0x74, 0xff, 0x9a, 0xec, 0x6d, 0x75, 0xf6, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0xfe, 0x62, 0x72, 0xd2, 0xba, 0xa9, 0xc6	/* t__intel_pmu_snapshot_branch_stack */
	.byte 0x13, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xf6, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0xfe, 0x62, 0x72, 0xd2, 0xba, 0xa9, 0xc6	/* t__pfx_intel_pmu_snapshot_branch_stack */
	.byte 0x13, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xf6, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0xfe, 0x62, 0x72, 0xd2, 0xba, 0xa9, 0xc6	/* tintel_pmu_snapshot_branch_stack */
	.byte 0x15, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xf6, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0xfe, 0xc5, 0xba, 0xb8, 0x72, 0xd2, 0xba, 0xa9, 0xc6	/* t__pfx_intel_pmu_snapshot_arch_branch_stack */
	.byte 0x15, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xf6, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0xfe, 0xc5, 0xba, 0xb8, 0x72, 0xd2, 0xba, 0xa9, 0xc6	/* tintel_pmu_snapshot_arch_branch_stack */
	.byte 0x09, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x5d	/* t__pfx_intel_pmu_enable_all */
	.byte 0x09, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x5d	/* tintel_pmu_enable_all */
	.byte 0x0c, 0xef, 0x9a, 0xa7, 0x66, 0x61, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x5d	/* t__pfx_intel_tfa_pmu_enable_all */
	.byte 0x0c, 0x74, 0x9a, 0xa7, 0x66, 0x61, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x5d	/* tintel_tfa_pmu_enable_all */
	.byte 0x0e, 0xef, 0x9a, 0xa7, 0x66, 0x61, 0x3a, 0x6d, 0x6d, 0x9d, 0x73, 0xba, 0x9e, 0x02, 0x8d	/* t__pfx_intel_tfa_commit_scheduling */
	.byte 0x0e, 0x74, 0x9a, 0xa7, 0x66, 0x61, 0x3a, 0x6d, 0x6d, 0x9d, 0x73, 0xba, 0x9e, 0x02, 0x8d	/* tintel_tfa_commit_scheduling */
	.byte 0x0f, 0xef, 0xaa, 0x6c, 0x5f, 0xcd, 0x64, 0x91, 0x74, 0xbe, 0x64, 0xad, 0x6e, 0x5f, 0xd7, 0x74	/* t__pfx_icl_update_topdown_event */
	.byte 0x0f, 0xdc, 0x63, 0x6c, 0x5f, 0xcd, 0x64, 0x91, 0x74, 0xbe, 0x64, 0xad, 0x6e, 0x5f, 0xd7, 0x74	/* ticl_update_topdown_event */
	.byte 0x0c, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xbd, 0x68, 0xae, 0xf1, 0x90, 0xb0, 0x5d	/* t__pfx_intel_pmu_nhm_enable_all */
	.byte 0x0c, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xbd, 0x68, 0xae, 0xf1, 0x90, 0xb0, 0x5d	/* tintel_pmu_nhm_enable_all */
	.byte 0x0e, 0xef, 0xaa, 0x6c, 0x84, 0x74, 0xbe, 0x64, 0xad, 0x6e, 0x5f, 0xcc, 0x19, 0xc0, 0x64	/* t__pfx_icl_set_topdown_event_period */
	.byte 0x0e, 0xdc, 0x63, 0x6c, 0x84, 0x74, 0xbe, 0x64, 0xad, 0x6e, 0x5f, 0xcc, 0x19, 0xc0, 0x64	/* ticl_set_topdown_event_period */
	.byte 0x0b, 0xef, 0x68, 0x05, 0xb0, 0x70, 0x6d, 0x69, 0x3a, 0x6d, 0x6d, 0xe7	/* t__pfx_handle_pmi_common */
	.byte 0x0b, 0x74, 0x68, 0x05, 0xb0, 0x70, 0x6d, 0x69, 0x3a, 0x6d, 0x6d, 0xe7	/* thandle_pmi_common */
	.byte 0x0b, 0xef, 0x63, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x5d	/* t__pfx_core_pmu_enable_all */
	.byte 0x0a, 0x26, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x5d	/* tcore_pmu_enable_all */
	.byte 0x0a, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xa3, 0x05, 0xb0, 0xab, 0x71	/* t__pfx_intel_pmu_handle_irq */
	.byte 0x0a, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xa3, 0x05, 0xb0, 0xab, 0x71	/* tintel_pmu_handle_irq */
	.byte 0x0b, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_intel_pmu_disable_event */
	.byte 0x0b, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* tintel_pmu_disable_event */
	.byte 0x07, 0xef, 0xba, 0x65, 0xc6, 0xc1, 0x73, 0x72	/* t__pfx_check_msr */
	.byte 0x07, 0x74, 0xba, 0x65, 0xc6, 0xc1, 0x73, 0x72	/* tcheck_msr */
	.byte 0x0b, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xf0, 0x9c, 0xa9, 0x72, 0x74, 0x8d	/* t__pfx_intel_pmu_cpu_starting */
	.byte 0x0b, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xf0, 0x9c, 0xa9, 0x72, 0x74, 0x8d	/* tintel_pmu_cpu_starting */
	.byte 0x0a, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_intel_pmu_enable_event */
	.byte 0x0a, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tintel_pmu_enable_event */
	.byte 0x0d, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0xf6, 0x61, 0x1a, 0x05, 0xde, 0x3d, 0x72, 0x74	/* T__pfx_intel_pmu_save_and_restart */
	.byte 0x0d, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0xf6, 0x61, 0x1a, 0x05, 0xde, 0x3d, 0x72, 0x74	/* Tintel_pmu_save_and_restart */
	.byte 0x0c, 0xeb, 0x78, 0x38, 0x36, 0x86, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* T__pfx_x86_get_event_constraints */
	.byte 0x0c, 0x54, 0x78, 0x38, 0x36, 0x86, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* Tx86_get_event_constraints */
	.byte 0x0a, 0xef, 0x9a, 0x86, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* t__pfx_intel_get_event_constraints */
	.byte 0x0a, 0x74, 0x9a, 0x86, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* tintel_get_event_constraints */
	.byte 0x0c, 0xef, 0x68, 0x73, 0x77, 0x86, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* t__pfx_hsw_get_event_constraints */
	.byte 0x0c, 0x74, 0x68, 0x73, 0x77, 0x86, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* thsw_get_event_constraints */
	.byte 0x0d, 0xef, 0x63, 0x6d, 0xfe, 0x67, 0xe2, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* t__pfx_cmt_get_event_constraints */
	.byte 0x0c, 0x26, 0x6d, 0xfe, 0x67, 0xe2, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* tcmt_get_event_constraints */
	.byte 0x0d, 0xef, 0x74, 0x6e, 0xfe, 0x67, 0xe2, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* t__pfx_tnt_get_event_constraints */
	.byte 0x0d, 0x74, 0x74, 0x6e, 0xfe, 0x67, 0xe2, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* ttnt_get_event_constraints */
	.byte 0x0c, 0xef, 0x67, 0x6c, 0x70, 0x86, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* t__pfx_glp_get_event_constraints */
	.byte 0x0c, 0x74, 0x67, 0x6c, 0x70, 0x86, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* tglp_get_event_constraints */
	.byte 0x0b, 0xef, 0xaa, 0x6c, 0x86, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* t__pfx_icl_get_event_constraints */
	.byte 0x0b, 0xdc, 0x63, 0x6c, 0x86, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* ticl_get_event_constraints */
	.byte 0x0c, 0xef, 0x74, 0x66, 0x61, 0x86, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* t__pfx_tfa_get_event_constraints */
	.byte 0x0c, 0x74, 0x74, 0x66, 0x61, 0x86, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* ttfa_get_event_constraints */
	.byte 0x0d, 0xef, 0x67, 0x6c, 0xc9, 0x67, 0xe2, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* t__pfx_glc_get_event_constraints */
	.byte 0x0d, 0x74, 0x67, 0x6c, 0xc9, 0x67, 0xe2, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* tglc_get_event_constraints */
	.byte 0x0b, 0xef, 0x6d, 0x23, 0x86, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* t__pfx_mtl_get_event_constraints */
	.byte 0x0b, 0x74, 0x6d, 0x23, 0x86, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* tmtl_get_event_constraints */
	.byte 0x0c, 0xef, 0xc5, 0x6c, 0xa3, 0x86, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* t__pfx_arl_h_get_event_constraints */
	.byte 0x0c, 0xf4, 0x72, 0x6c, 0xa3, 0x86, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* tarl_h_get_event_constraints */
	.byte 0x0b, 0xef, 0xc8, 0x6c, 0x86, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* t__pfx_adl_get_event_constraints */
	.byte 0x0b, 0xf4, 0x64, 0x6c, 0x86, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* tadl_get_event_constraints */
	.byte 0x0a, 0xeb, 0x9a, 0xf0, 0x9c, 0x63, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* T__pfx_intel_cpuc_prepare */
	.byte 0x0a, 0x54, 0x9a, 0xf0, 0x9c, 0x63, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* Tintel_cpuc_prepare */
	.byte 0x0c, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xf0, 0x9c, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* t__pfx_intel_pmu_cpu_prepare */
	.byte 0x0c, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xf0, 0x9c, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* tintel_pmu_cpu_prepare */
	.byte 0x09, 0xeb, 0x9a, 0xf0, 0x9c, 0x63, 0xe6, 0xf8, 0xca, 0x68	/* T__pfx_intel_cpuc_finish */
	.byte 0x09, 0x54, 0x9a, 0xf0, 0x9c, 0x63, 0xe6, 0xf8, 0xca, 0x68	/* Tintel_cpuc_finish */
	.byte 0x0a, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xf0, 0x9c, 0xed, 0x65, 0xc8	/* t__pfx_intel_pmu_cpu_dead */
	.byte 0x0a, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xf0, 0x9c, 0xed, 0x65, 0xc8	/* tintel_pmu_cpu_dead */
	.byte 0x07, 0xef, 0x62, 0x74, 0xe9, 0xcc, 0xf7, 0xc8	/* t__pfx_bts_event_read */
	.byte 0x07, 0x74, 0x62, 0x74, 0xe9, 0xcc, 0xf7, 0xc8	/* tbts_event_read */
	.byte 0x09, 0x74, 0xaf, 0xb8, 0x74, 0xe9, 0xcc, 0x3d, 0x72, 0x74	/* t__pfx___bts_event_start */
	.byte 0x09, 0x74, 0xff, 0x62, 0x74, 0xe9, 0xcc, 0x3d, 0x72, 0x74	/* t__bts_event_start */
	.byte 0x07, 0xef, 0x62, 0x74, 0xe9, 0xcd, 0x64, 0x14	/* t__pfx_bts_update */
	.byte 0x07, 0x74, 0x62, 0x74, 0xe9, 0xcd, 0x64, 0x14	/* tbts_update */
	.byte 0x08, 0xef, 0x62, 0x74, 0xe9, 0xcc, 0x73, 0x74, 0xbe	/* t__pfx_bts_event_stop */
	.byte 0x08, 0x74, 0x62, 0x74, 0xe9, 0xcc, 0x73, 0x74, 0xbe	/* tbts_event_stop */
	.byte 0x07, 0xef, 0x62, 0x74, 0xe9, 0xcc, 0x64, 0xdb	/* t__pfx_bts_event_del */
	.byte 0x07, 0x74, 0x62, 0x74, 0xe9, 0xcc, 0x64, 0xdb	/* tbts_event_del */
	.byte 0x0a, 0xef, 0x62, 0x74, 0xe9, 0x06, 0x66, 0x66, 0xf5, 0x07, 0xd4	/* t__pfx_bts_buffer_reset */
	.byte 0x0a, 0x74, 0x62, 0x74, 0xe9, 0x06, 0x66, 0x66, 0xf5, 0x07, 0xd4	/* tbts_buffer_reset */
	.byte 0x0e, 0xef, 0x62, 0x74, 0xe9, 0x06, 0x66, 0x66, 0xf5, 0xe6, 0xf7, 0xfc, 0x61, 0x75, 0x78	/* t__pfx_bts_buffer_free_aux */
	.byte 0x0e, 0x74, 0x62, 0x74, 0xe9, 0x06, 0x66, 0x66, 0xf5, 0xe6, 0xf7, 0xfc, 0x61, 0x75, 0x78	/* tbts_buffer_free_aux */
	.byte 0x0f, 0xef, 0x62, 0x74, 0xe9, 0x06, 0x66, 0x66, 0xf5, 0xf6, 0xd4, 0xcd, 0x5f, 0x61, 0x75, 0x78	/* t__pfx_bts_buffer_setup_aux */
	.byte 0x0f, 0x74, 0x62, 0x74, 0xe9, 0x06, 0x66, 0x66, 0xf5, 0xf6, 0xd4, 0xcd, 0x5f, 0x61, 0x75, 0x78	/* tbts_buffer_setup_aux */
	.byte 0x08, 0xef, 0x62, 0x74, 0xe9, 0xcc, 0x3d, 0x72, 0x74	/* t__pfx_bts_event_start */
	.byte 0x08, 0x74, 0x62, 0x74, 0xe9, 0xcc, 0x3d, 0x72, 0x74	/* tbts_event_start */
	.byte 0x07, 0xef, 0x62, 0x74, 0xe9, 0xcc, 0xc8, 0x64	/* t__pfx_bts_event_add */
	.byte 0x07, 0x74, 0x62, 0x74, 0xe9, 0xcc, 0xc8, 0x64	/* tbts_event_add */
	.byte 0x06, 0xef, 0x62, 0x74, 0xe9, 0xcc, 0x0f	/* t__pfx_bts_event_init */
	.byte 0x06, 0x74, 0x62, 0x74, 0xe9, 0xcc, 0x0f	/* tbts_event_init */
	.byte 0x0a, 0xef, 0x62, 0x74, 0xe9, 0xcc, 0x64, 0xd6, 0xf3, 0x6f, 0x79	/* t__pfx_bts_event_destroy */
	.byte 0x0a, 0x74, 0x62, 0x74, 0xe9, 0xcc, 0x64, 0xd6, 0xf3, 0x6f, 0x79	/* tbts_event_destroy */
	.byte 0x0b, 0xeb, 0x9a, 0xb8, 0x74, 0xe9, 0xf1, 0x90, 0xb0, 0xdd, 0x63, 0xe5	/* T__pfx_intel_bts_enable_local */
	.byte 0x0b, 0x54, 0x9a, 0xb8, 0x74, 0xe9, 0xf1, 0x90, 0xb0, 0xdd, 0x63, 0xe5	/* Tintel_bts_enable_local */
	.byte 0x0b, 0xeb, 0x9a, 0xb8, 0x93, 0xed, 0xca, 0x90, 0xb0, 0xdd, 0x63, 0xe5	/* T__pfx_intel_bts_disable_local */
	.byte 0x0b, 0x54, 0x9a, 0xb8, 0x93, 0xed, 0xca, 0x90, 0xb0, 0xdd, 0x63, 0xe5	/* Tintel_bts_disable_local */
	.byte 0x0a, 0xeb, 0x9a, 0xb8, 0x74, 0xe9, 0xb3, 0xf5, 0x72, 0xcd, 0x74	/* T__pfx_intel_bts_interrupt */
	.byte 0x0a, 0x54, 0x9a, 0xb8, 0x74, 0xe9, 0xb3, 0xf5, 0x72, 0xcd, 0x74	/* Tintel_bts_interrupt */
	.byte 0x10, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xed, 0xbc, 0xf8, 0xec, 0x65, 0x62, 0xe9, 0x06, 0x66, 0x66, 0xf5	/* t__pfx_intel_pmu_drain_pebs_buffer */
	.byte 0x10, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xed, 0xbc, 0xf8, 0xec, 0x65, 0x62, 0xe9, 0x06, 0x66, 0x66, 0xf5	/* tintel_pmu_drain_pebs_buffer */
	.byte 0x09, 0xef, 0x64, 0x73, 0xf0, 0xc4, 0xc5, 0xf0, 0x65, 0x61	/* t__pfx_ds_clear_cea */
	.byte 0x09, 0x74, 0x64, 0x73, 0xf0, 0xc4, 0xc5, 0xf0, 0x65, 0x61	/* tds_clear_cea */
	.byte 0x09, 0xef, 0x64, 0xe9, 0xcd, 0x64, 0x91, 0x63, 0x65, 0x61	/* t__pfx_ds_update_cea */
	.byte 0x09, 0x74, 0x64, 0xe9, 0xcd, 0x64, 0x91, 0x63, 0x65, 0x61	/* tds_update_cea */
	.byte 0x0c, 0xef, 0xf7, 0xc4, 0xbb, 0xfc, 0x62, 0x74, 0xe9, 0x06, 0x66, 0x66, 0xf5	/* t__pfx_release_bts_buffer */
	.byte 0x0c, 0x74, 0xf7, 0xc4, 0xbb, 0xfc, 0x62, 0x74, 0xe9, 0x06, 0x66, 0x66, 0xf5	/* trelease_bts_buffer */
	.byte 0x09, 0xef, 0x64, 0x73, 0x66, 0xf7, 0xfc, 0x70, 0x83, 0xd6	/* t__pfx_dsfree_pages */
	.byte 0x09, 0x74, 0x64, 0x73, 0x66, 0xf7, 0xfc, 0x70, 0x83, 0xd6	/* tdsfree_pages */
	.byte 0x0d, 0xef, 0xf7, 0xc4, 0xbb, 0xfc, 0x70, 0x65, 0x62, 0xe9, 0x06, 0x66, 0x66, 0xf5	/* t__pfx_release_pebs_buffer */
	.byte 0x0d, 0x74, 0xf7, 0xc4, 0xbb, 0xfc, 0x70, 0x65, 0x62, 0xe9, 0x06, 0x66, 0x66, 0xf5	/* trelease_pebs_buffer */
	.byte 0x0a, 0xef, 0x70, 0x65, 0x62, 0xe9, 0xcd, 0x64, 0x91, 0x3d, 0x2c	/* t__pfx_pebs_update_state */
	.byte 0x09, 0xce, 0x65, 0x62, 0xe9, 0xcd, 0x64, 0x91, 0x3d, 0x2c	/* tpebs_update_state */
	.byte 0x0e, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xec, 0x65, 0x62, 0xe9, 0xa5, 0x78, 0xcd, 0x5f, 0x28	/* t__pfx_intel_pmu_pebs_fixup_ip */
	.byte 0x0e, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xec, 0x65, 0x62, 0xe9, 0xa5, 0x78, 0xcd, 0x5f, 0x28	/* tintel_pmu_pebs_fixup_ip */
	.byte 0x0a, 0xef, 0x73, 0xd4, 0xcd, 0xec, 0x65, 0x62, 0xe9, 0xdc, 0xa8	/* t__pfx_setup_pebs_time */
	.byte 0x09, 0x93, 0xd4, 0xcd, 0xec, 0x65, 0x62, 0xe9, 0xdc, 0xa8	/* tsetup_pebs_time */
	.byte 0x14, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xf6, 0x61, 0x1a, 0x05, 0xde, 0x3d, 0x72, 0xfe, 0xf7, 0xdd, 0xc8, 0x2e, 0xca, 0xbc, 0x7e	/* t__pfx_intel_pmu_save_and_restart_reload.isra.0 */
	.byte 0x14, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xf6, 0x61, 0x1a, 0x05, 0xde, 0x3d, 0x72, 0xfe, 0xf7, 0xdd, 0xc8, 0x2e, 0xca, 0xbc, 0x7e	/* tintel_pmu_save_and_restart_reload.isra.0 */
	.byte 0x12, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xec, 0x65, 0x62, 0xe9, 0xcc, 0xcd, 0x64, 0x91, 0x6e, 0x6f, 0xed, 0xbc, 0xf8	/* t__pfx_intel_pmu_pebs_event_update_no_drain */
	.byte 0x12, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xec, 0x65, 0x62, 0xe9, 0xcc, 0xcd, 0x64, 0x91, 0x6e, 0x6f, 0xed, 0xbc, 0xf8	/* tintel_pmu_pebs_event_update_no_drain */
	.byte 0x08, 0xef, 0x64, 0x73, 0x22, 0x63, 0xec, 0x83, 0xd6	/* t__pfx_dsalloc_pages */
	.byte 0x08, 0x74, 0x64, 0x73, 0x22, 0x63, 0xec, 0x83, 0xd6	/* tdsalloc_pages */
	.byte 0x08, 0xef, 0x67, 0xe2, 0x64, 0x0a, 0xf6, 0x72, 0x63	/* t__pfx_get_data_src */
	.byte 0x08, 0x74, 0x67, 0xe2, 0x64, 0x0a, 0xf6, 0x72, 0x63	/* tget_data_src */
	.byte 0x13, 0xef, 0x73, 0xd4, 0xcd, 0xec, 0x65, 0x62, 0xe9, 0xc8, 0x61, 0x70, 0xdc, 0x1a, 0x73, 0x61, 0xb6, 0xb0, 0x64, 0x0a	/* t__pfx_setup_pebs_adaptive_sample_data */
	.byte 0x12, 0x93, 0xd4, 0xcd, 0xec, 0x65, 0x62, 0xe9, 0xc8, 0x61, 0x70, 0xdc, 0x1a, 0x73, 0x61, 0xb6, 0xb0, 0x64, 0x0a	/* tsetup_pebs_adaptive_sample_data */
	.byte 0x17, 0x74, 0xaf, 0xc7, 0x72, 0xfe, 0x6c, 0xe8, 0xf1, 0x63, 0x79, 0xed, 0x0a, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e, 0x2e, 0xca, 0xbc, 0x7e	/* t__pfx___grt_latency_data.constprop.0.isra.0 */
	.byte 0x17, 0x74, 0xff, 0x67, 0x72, 0xfe, 0x6c, 0xe8, 0xf1, 0x63, 0x79, 0xed, 0x0a, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e, 0x2e, 0xca, 0xbc, 0x7e	/* t__grt_latency_data.constprop.0.isra.0 */
	.byte 0x11, 0xef, 0x73, 0xd4, 0xcd, 0xec, 0x65, 0x62, 0xe9, 0xa5, 0x78, 0x9e, 0xf6, 0x61, 0xb6, 0xb0, 0x64, 0x0a	/* t__pfx_setup_pebs_fixed_sample_data */
	.byte 0x10, 0x93, 0xd4, 0xcd, 0xec, 0x65, 0x62, 0xe9, 0xa5, 0x78, 0x9e, 0xf6, 0x61, 0xb6, 0xb0, 0x64, 0x0a	/* tsetup_pebs_fixed_sample_data */
	.byte 0x0e, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xed, 0xbc, 0xf8, 0xec, 0x65, 0x62, 0xe9, 0xaa, 0x6c	/* t__pfx_intel_pmu_drain_pebs_icl */
	.byte 0x0e, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xed, 0xbc, 0xf8, 0xec, 0x65, 0x62, 0xe9, 0xaa, 0x6c	/* tintel_pmu_drain_pebs_icl */
	.byte 0x0e, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xed, 0xbc, 0xf8, 0xec, 0x65, 0x62, 0x73, 0x3a, 0xf7	/* t__pfx_intel_pmu_drain_pebs_core */
	.byte 0x0e, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xed, 0xbc, 0xf8, 0xec, 0x65, 0x62, 0x73, 0x3a, 0xf7	/* tintel_pmu_drain_pebs_core */
	.byte 0x0f, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xed, 0xbc, 0xf8, 0xec, 0x65, 0x62, 0xe9, 0x6e, 0x68, 0x6d	/* t__pfx_intel_pmu_drain_pebs_nhm */
	.byte 0x0f, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xed, 0xbc, 0xf8, 0xec, 0x65, 0x62, 0xe9, 0x6e, 0x68, 0x6d	/* tintel_pmu_drain_pebs_nhm */
	.byte 0x0b, 0xeb, 0x67, 0x72, 0xfe, 0x6c, 0xe8, 0xf1, 0x63, 0x79, 0xed, 0x0a	/* T__pfx_grt_latency_data */
	.byte 0x0b, 0x54, 0x67, 0x72, 0xfe, 0x6c, 0xe8, 0xf1, 0x63, 0x79, 0xed, 0x0a	/* Tgrt_latency_data */
	.byte 0x0b, 0xeb, 0x63, 0x6d, 0xfe, 0x6c, 0xe8, 0xf1, 0x63, 0x79, 0xed, 0x0a	/* T__pfx_cmt_latency_data */
	.byte 0x0b, 0x54, 0x63, 0x6d, 0xfe, 0x6c, 0xe8, 0xf1, 0x63, 0x79, 0xed, 0x0a	/* Tcmt_latency_data */
	.byte 0x0c, 0xeb, 0x6c, 0x6e, 0x6c, 0x5f, 0x6c, 0xe8, 0xf1, 0x63, 0x79, 0xed, 0x0a	/* T__pfx_lnl_latency_data */
	.byte 0x0c, 0x54, 0x6c, 0x6e, 0x6c, 0x5f, 0x6c, 0xe8, 0xf1, 0x63, 0x79, 0xed, 0x0a	/* Tlnl_latency_data */
	.byte 0x0c, 0xeb, 0xc5, 0x6c, 0xa3, 0x5f, 0x6c, 0xe8, 0xf1, 0x63, 0x79, 0xed, 0x0a	/* T__pfx_arl_h_latency_data */
	.byte 0x0c, 0x54, 0xc5, 0x6c, 0xa3, 0x5f, 0x6c, 0xe8, 0xf1, 0x63, 0x79, 0xed, 0x0a	/* Tarl_h_latency_data */
	.byte 0x0e, 0xeb, 0xf8, 0x9d, 0x64, 0x65, 0x06, 0x67, 0xf6, 0x74, 0xd5, 0xfc, 0xe7, 0xf0, 0x9c	/* T__pfx_init_debug_store_on_cpu */
	.byte 0x0e, 0x54, 0xf8, 0x9d, 0x64, 0x65, 0x06, 0x67, 0xf6, 0x74, 0xd5, 0xfc, 0xe7, 0xf0, 0x9c	/* Tinit_debug_store_on_cpu */
	.byte 0x0f, 0xeb, 0x66, 0xf8, 0x69, 0xed, 0x65, 0x06, 0x67, 0xf6, 0x74, 0xd5, 0xfc, 0xe7, 0xf0, 0x9c	/* T__pfx_fini_debug_store_on_cpu */
	.byte 0x0f, 0x54, 0x66, 0xf8, 0x69, 0xed, 0x65, 0x06, 0x67, 0xf6, 0x74, 0xd5, 0xfc, 0xe7, 0xf0, 0x9c	/* Tfini_debug_store_on_cpu */
	.byte 0x0c, 0xeb, 0xf7, 0xc4, 0xbb, 0xfc, 0x64, 0xe9, 0x06, 0x66, 0x66, 0xf5, 0x73	/* T__pfx_release_ds_buffers */
	.byte 0x0c, 0x54, 0xf7, 0xc4, 0xbb, 0xfc, 0x64, 0xe9, 0x06, 0x66, 0x66, 0xf5, 0x73	/* Trelease_ds_buffers */
	.byte 0x0b, 0xeb, 0x29, 0xf5, 0x1a, 0x64, 0xe9, 0x06, 0x66, 0x66, 0xf5, 0x73	/* T__pfx_reserve_ds_buffers */
	.byte 0x0b, 0x54, 0x29, 0xf5, 0x1a, 0x64, 0xe9, 0x06, 0x66, 0x66, 0xf5, 0x73	/* Treserve_ds_buffers */
	.byte 0x0a, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x62, 0x93	/* T__pfx_intel_pmu_enable_bts */
	.byte 0x0a, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x62, 0x93	/* Tintel_pmu_enable_bts */
	.byte 0x0b, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x93	/* T__pfx_intel_pmu_disable_bts */
	.byte 0x0b, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x93	/* Tintel_pmu_disable_bts */
	.byte 0x0f, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0xed, 0xbc, 0xf8, 0xb8, 0x74, 0xe9, 0x06, 0x66, 0x66, 0xf5	/* T__pfx_intel_pmu_drain_bts_buffer */
	.byte 0x0f, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0xed, 0xbc, 0xf8, 0xb8, 0x74, 0xe9, 0x06, 0x66, 0x66, 0xf5	/* Tintel_pmu_drain_bts_buffer */
	.byte 0x0c, 0xeb, 0x9a, 0xec, 0x65, 0x62, 0x73, 0x3e, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* T__pfx_intel_pebs_constraints */
	.byte 0x0c, 0x54, 0x9a, 0xec, 0x65, 0x62, 0x73, 0x3e, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* Tintel_pebs_constraints */
	.byte 0x0f, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0xec, 0x65, 0x62, 0x73, 0xf6, 0xba, 0x65, 0xda, 0xf4, 0x5e	/* T__pfx_intel_pmu_pebs_sched_task */
	.byte 0x0f, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0xec, 0x65, 0x62, 0x73, 0xf6, 0xba, 0x65, 0xda, 0xf4, 0x5e	/* Tintel_pmu_pebs_sched_task */
	.byte 0x0b, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0xec, 0x65, 0x62, 0xe9, 0xc8, 0x64	/* T__pfx_intel_pmu_pebs_add */
	.byte 0x0b, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0xec, 0x65, 0x62, 0xe9, 0xc8, 0x64	/* Tintel_pmu_pebs_add */
	.byte 0x0c, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0xec, 0x65, 0x62, 0xe9, 0xf1, 0x90, 0xc4	/* T__pfx_intel_pmu_pebs_enable */
	.byte 0x0c, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0xec, 0x65, 0x62, 0xe9, 0xf1, 0x90, 0xc4	/* Tintel_pmu_pebs_enable */
	.byte 0x0b, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0xec, 0x65, 0x62, 0x73, 0xed, 0xdb	/* T__pfx_intel_pmu_pebs_del */
	.byte 0x0b, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0xec, 0x65, 0x62, 0x73, 0xed, 0xdb	/* Tintel_pmu_pebs_del */
	.byte 0x0d, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0xec, 0x65, 0x62, 0x73, 0xed, 0xca, 0x90, 0xc4	/* T__pfx_intel_pmu_pebs_disable */
	.byte 0x0d, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0xec, 0x65, 0x62, 0x73, 0xed, 0xca, 0x90, 0xc4	/* Tintel_pmu_pebs_disable */
	.byte 0x0d, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0xec, 0x65, 0x62, 0xe9, 0xf1, 0x90, 0xb0, 0x5d	/* T__pfx_intel_pmu_pebs_enable_all */
	.byte 0x0d, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0xec, 0x65, 0x62, 0xe9, 0xf1, 0x90, 0xb0, 0x5d	/* Tintel_pmu_pebs_enable_all */
	.byte 0x0e, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0xec, 0x65, 0x62, 0x73, 0xed, 0xca, 0x90, 0xb0, 0x5d	/* T__pfx_intel_pmu_pebs_disable_all */
	.byte 0x0e, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0xec, 0x65, 0x62, 0x73, 0xed, 0xca, 0x90, 0xb0, 0x5d	/* Tintel_pmu_pebs_disable_all */
	.byte 0x0e, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x61, 0x75, 0x8a, 0xde, 0xdd, 0xc8, 0xde, 0xc8	/* T__pfx_intel_pmu_auto_reload_read */
	.byte 0x0e, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x61, 0x75, 0x8a, 0xde, 0xdd, 0xc8, 0xde, 0xc8	/* Tintel_pmu_auto_reload_read */
	.byte 0x0e, 0xeb, 0x19, 0x66, 0x07, 0x74, 0xd5, 0xfc, 0x64, 0x65, 0x06, 0x67, 0xf6, 0x8a, 0xf7	/* T__pfx_perf_restore_debug_store */
	.byte 0x0e, 0x54, 0x19, 0x66, 0x07, 0x74, 0xd5, 0xfc, 0x64, 0x65, 0x06, 0x67, 0xf6, 0x8a, 0xf7	/* Tperf_restore_debug_store */
	.byte 0x0a, 0xef, 0x6b, 0x6e, 0x63, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x97	/* t__pfx_knc_pmu_event_map */
	.byte 0x0a, 0x74, 0x6b, 0x6e, 0x63, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x97	/* tknc_pmu_event_map */
	.byte 0x06, 0xef, 0x63, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx_cmask_show */
	.byte 0x05, 0x26, 0xd9, 0x5e, 0xf6, 0x7c	/* tcmask_show */
	.byte 0x05, 0xef, 0xf8, 0x76, 0xf6, 0x7c	/* t__pfx_inv_show */
	.byte 0x05, 0x74, 0xf8, 0x76, 0xf6, 0x7c	/* tinv_show */
	.byte 0x06, 0xef, 0x9e, 0x67, 0xfc, 0x73, 0x7c	/* t__pfx_edge_show */
	.byte 0x06, 0x74, 0x9e, 0x67, 0xfc, 0x73, 0x7c	/* tedge_show */
	.byte 0x06, 0xef, 0x75, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx_umask_show */
	.byte 0x06, 0x74, 0x75, 0xd9, 0x5e, 0xf6, 0x7c	/* tumask_show */
	.byte 0x04, 0xef, 0xcc, 0x73, 0x7c	/* t__pfx_event_show */
	.byte 0x04, 0x74, 0xcc, 0x73, 0x7c	/* tevent_show */
	.byte 0x0d, 0xef, 0x6b, 0x6e, 0x63, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_knc_pmu_disable_event */
	.byte 0x0d, 0x74, 0x6b, 0x6e, 0x63, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* tknc_pmu_disable_event */
	.byte 0x0c, 0xef, 0x6b, 0x6e, 0x63, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_knc_pmu_enable_event */
	.byte 0x0c, 0x74, 0x6b, 0x6e, 0x63, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tknc_pmu_enable_event */
	.byte 0x0c, 0xef, 0x6b, 0x6e, 0x63, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0x5d	/* t__pfx_knc_pmu_disable_all */
	.byte 0x0c, 0x74, 0x6b, 0x6e, 0x63, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0x5d	/* tknc_pmu_disable_all */
	.byte 0x0b, 0xef, 0x6b, 0x6e, 0x63, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x5d	/* t__pfx_knc_pmu_enable_all */
	.byte 0x0b, 0x74, 0x6b, 0x6e, 0x63, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x5d	/* tknc_pmu_enable_all */
	.byte 0x0c, 0xef, 0x6b, 0x6e, 0x63, 0xec, 0x6d, 0x75, 0xa3, 0x05, 0xb0, 0xab, 0x71	/* t__pfx_knc_pmu_handle_irq */
	.byte 0x0c, 0x74, 0x6b, 0x6e, 0x63, 0xec, 0x6d, 0x75, 0xa3, 0x05, 0xb0, 0xab, 0x71	/* tknc_pmu_handle_irq */
	.byte 0x0b, 0xeb, 0x78, 0x38, 0x36, 0xec, 0xf5, 0x66, 0x86, 0x6c, 0x62, 0x72	/* T__pfx_x86_perf_get_lbr */
	.byte 0x0b, 0x54, 0x78, 0x38, 0x36, 0xec, 0xf5, 0x66, 0x86, 0x6c, 0x62, 0x72	/* Tx86_perf_get_lbr */
	.byte 0x0d, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xe6, 0x69, 0x6c, 0xa2	/* t__pfx_intel_pmu_lbr_filter */
	.byte 0x0d, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xe6, 0x69, 0x6c, 0xa2	/* tintel_pmu_lbr_filter */
	.byte 0x12, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0xc5, 0xba, 0x5f, 0x6c, 0x62, 0x72, 0x5f, 0x78, 0x73, 0x61, 0x76, 0xd6	/* t__pfx_intel_pmu_arch_lbr_xsaves */
	.byte 0x12, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0xc5, 0xba, 0x5f, 0x6c, 0x62, 0x72, 0x5f, 0x78, 0x73, 0x61, 0x76, 0xd6	/* tintel_pmu_arch_lbr_xsaves */
	.byte 0x13, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0xc5, 0xba, 0x5f, 0x6c, 0x62, 0x72, 0x5f, 0x78, 0x72, 0x73, 0x74, 0xd5, 0x73	/* t__pfx_intel_pmu_arch_lbr_xrstors */
	.byte 0x13, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0xc5, 0xba, 0x5f, 0x6c, 0x62, 0x72, 0x5f, 0x78, 0x72, 0x73, 0x74, 0xd5, 0x73	/* tintel_pmu_arch_lbr_xrstors */
	.byte 0x15, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0x3a, 0xe4, 0xa2, 0xe9, 0xf7, 0xd5, 0x64, 0xf5, 0x2e, 0xca, 0xbc, 0x7e	/* t__pfx_intel_pmu_lbr_counters_reorder.isra.0 */
	.byte 0x15, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0x3a, 0xe4, 0xa2, 0xe9, 0xf7, 0xd5, 0x64, 0xf5, 0x2e, 0xca, 0xbc, 0x7e	/* tintel_pmu_lbr_counters_reorder.isra.0 */
	.byte 0x0e, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0xc5, 0xba, 0x5f, 0x6c, 0x62, 0x72, 0x07, 0xd4	/* t__pfx_intel_pmu_arch_lbr_reset */
	.byte 0x0e, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0xc5, 0xba, 0x5f, 0x6c, 0x62, 0x72, 0x07, 0xd4	/* tintel_pmu_arch_lbr_reset */
	.byte 0x10, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0xc5, 0xba, 0x5f, 0x6c, 0x62, 0x72, 0xf6, 0x61, 0x76, 0x65	/* t__pfx_intel_pmu_arch_lbr_save */
	.byte 0x10, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0xc5, 0xba, 0x5f, 0x6c, 0x62, 0x72, 0xf6, 0x61, 0x76, 0x65	/* tintel_pmu_arch_lbr_save */
	.byte 0x0c, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0xf6, 0x74, 0xd5, 0xfc, 0x6c, 0x62, 0x72	/* t__pfx_intel_pmu_store_lbr */
	.byte 0x0c, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0xf6, 0x74, 0xd5, 0xfc, 0x6c, 0x62, 0x72	/* tintel_pmu_store_lbr */
	.byte 0x0e, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0xc5, 0xba, 0x5f, 0x6c, 0x62, 0x72, 0xde, 0xc8	/* t__pfx_intel_pmu_arch_lbr_read */
	.byte 0x0e, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0xc5, 0xba, 0x5f, 0x6c, 0x62, 0x72, 0xde, 0xc8	/* tintel_pmu_arch_lbr_read */
	.byte 0x14, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0xc5, 0xba, 0x5f, 0x6c, 0x62, 0x72, 0xde, 0x61, 0xda, 0x78, 0x73, 0x61, 0x76, 0x65	/* t__pfx_intel_pmu_arch_lbr_read_xsave */
	.byte 0x14, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0xc5, 0xba, 0x5f, 0x6c, 0x62, 0x72, 0xde, 0x61, 0xda, 0x78, 0x73, 0x61, 0x76, 0x65	/* tintel_pmu_arch_lbr_read_xsave */
	.byte 0x0f, 0xef, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0xc5, 0xba, 0x5f, 0x6c, 0x62, 0x72, 0x07, 0x8a, 0xf7	/* t__pfx_intel_pmu_arch_lbr_restore */
	.byte 0x0f, 0x74, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0xc5, 0xba, 0x5f, 0x6c, 0x62, 0x72, 0x07, 0x8a, 0xf7	/* tintel_pmu_arch_lbr_restore */
	.byte 0x0d, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0x07, 0xe2, 0x33, 0x32	/* T__pfx_intel_pmu_lbr_reset_32 */
	.byte 0x0d, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0x07, 0xe2, 0x33, 0x32	/* Tintel_pmu_lbr_reset_32 */
	.byte 0x0d, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0x07, 0xe2, 0x36, 0x34	/* T__pfx_intel_pmu_lbr_reset_64 */
	.byte 0x0d, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0x07, 0xe2, 0x36, 0x34	/* Tintel_pmu_lbr_reset_64 */
	.byte 0x0b, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0x07, 0xd4	/* T__pfx_intel_pmu_lbr_reset */
	.byte 0x0b, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0x07, 0xd4	/* Tintel_pmu_lbr_reset */
	.byte 0x11, 0xeb, 0x6c, 0x62, 0x72, 0xe6, 0xe3, 0x6d, 0xf6, 0x0c, 0x6e, 0xcb, 0xfe, 0xa1, 0xab, 0x6b, 0x92, 0x72	/* T__pfx_lbr_from_signext_quirk_wr */
	.byte 0x11, 0x54, 0x6c, 0x62, 0x72, 0xe6, 0xe3, 0x6d, 0xf6, 0x0c, 0x6e, 0xcb, 0xfe, 0xa1, 0xab, 0x6b, 0x92, 0x72	/* Tlbr_from_signext_quirk_wr */
	.byte 0x0c, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0x07, 0x8a, 0xf7	/* T__pfx_intel_pmu_lbr_restore */
	.byte 0x0c, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0x07, 0x8a, 0xf7	/* Tintel_pmu_lbr_restore */
	.byte 0x0d, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xf6, 0x61, 0x76, 0x65	/* T__pfx_intel_pmu_lbr_save */
	.byte 0x0d, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xf6, 0x61, 0x76, 0x65	/* Tintel_pmu_lbr_save */
	.byte 0x13, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xf6, 0x77, 0x61, 0x70, 0x5f, 0xf4, 0x5e, 0xf0, 0x74, 0x78	/* T__pfx_intel_pmu_lbr_swap_task_ctx */
	.byte 0x13, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xf6, 0x77, 0x61, 0x70, 0x5f, 0xf4, 0x5e, 0xf0, 0x74, 0x78	/* Tintel_pmu_lbr_swap_task_ctx */
	.byte 0x0f, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xf6, 0xba, 0x65, 0xda, 0xf4, 0x5e	/* T__pfx_intel_pmu_lbr_sched_task */
	.byte 0x0f, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xf6, 0xba, 0x65, 0xda, 0xf4, 0x5e	/* Tintel_pmu_lbr_sched_task */
	.byte 0x0c, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0x5f, 0xc8, 0x64	/* T__pfx_intel_pmu_lbr_add */
	.byte 0x0c, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0x5f, 0xc8, 0x64	/* Tintel_pmu_lbr_add */
	.byte 0x0e, 0xeb, 0xf7, 0xc4, 0xbb, 0xfc, 0x6c, 0x62, 0x72, 0xb8, 0x75, 0x66, 0x66, 0xf5, 0x73	/* T__pfx_release_lbr_buffers */
	.byte 0x0e, 0x54, 0xf7, 0xc4, 0xbb, 0xfc, 0x6c, 0x62, 0x72, 0xb8, 0x75, 0x66, 0x66, 0xf5, 0x73	/* Trelease_lbr_buffers */
	.byte 0x0d, 0xeb, 0x29, 0xf5, 0x1a, 0x6c, 0x62, 0x72, 0xb8, 0x75, 0x66, 0x66, 0xf5, 0x73	/* T__pfx_reserve_lbr_buffers */
	.byte 0x0d, 0x54, 0x29, 0xf5, 0x1a, 0x6c, 0x62, 0x72, 0xb8, 0x75, 0x66, 0x66, 0xf5, 0x73	/* Treserve_lbr_buffers */
	.byte 0x0b, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xed, 0xdb	/* T__pfx_intel_pmu_lbr_del */
	.byte 0x0b, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xed, 0xdb	/* Tintel_pmu_lbr_del */
	.byte 0x0d, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0x0d, 0x90, 0xb0, 0x5d	/* T__pfx_intel_pmu_lbr_enable_all */
	.byte 0x0d, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0x0d, 0x90, 0xb0, 0x5d	/* Tintel_pmu_lbr_enable_all */
	.byte 0x0e, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xed, 0xca, 0x90, 0xb0, 0x5d	/* T__pfx_intel_pmu_lbr_disable_all */
	.byte 0x0e, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xed, 0xca, 0x90, 0xb0, 0x5d	/* Tintel_pmu_lbr_disable_all */
	.byte 0x0e, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xde, 0x61, 0xda, 0x33, 0x32	/* T__pfx_intel_pmu_lbr_read_32 */
	.byte 0x0e, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xde, 0x61, 0xda, 0x33, 0x32	/* Tintel_pmu_lbr_read_32 */
	.byte 0x0e, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xde, 0x61, 0xda, 0x36, 0x34	/* T__pfx_intel_pmu_lbr_read_64 */
	.byte 0x0e, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xde, 0x61, 0xda, 0x36, 0x34	/* Tintel_pmu_lbr_read_64 */
	.byte 0x10, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xf6, 0x61, 0x1a, 0x62, 0x72, 0x3d, 0xc6	/* T__pfx_intel_pmu_lbr_save_brstack */
	.byte 0x10, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xf6, 0x61, 0x1a, 0x62, 0x72, 0x3d, 0xc6	/* Tintel_pmu_lbr_save_brstack */
	.byte 0x0b, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xde, 0xc8	/* T__pfx_intel_pmu_lbr_read */
	.byte 0x0b, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xde, 0xc8	/* Tintel_pmu_lbr_read */
	.byte 0x10, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0xf6, 0xd4, 0xcd, 0x5f, 0x6c, 0x62, 0x72, 0xe6, 0x69, 0x6c, 0xa2	/* T__pfx_intel_pmu_setup_lbr_filter */
	.byte 0x10, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0xf6, 0xd4, 0xcd, 0x5f, 0x6c, 0x62, 0x72, 0xe6, 0x69, 0x6c, 0xa2	/* Tintel_pmu_setup_lbr_filter */
	.byte 0x11, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0xf6, 0x74, 0xd5, 0xfc, 0x70, 0x65, 0x62, 0xe9, 0x6c, 0x62, 0x72, 0x73	/* T__pfx_intel_pmu_store_pebs_lbrs */
	.byte 0x11, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0xf6, 0x74, 0xd5, 0xfc, 0x70, 0x65, 0x62, 0xe9, 0x6c, 0x62, 0x72, 0x73	/* Tintel_pmu_store_pebs_lbrs */
	.byte 0x0e, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xbf, 0x9d, 0x68, 0x73, 0x77	/* T__pfx_intel_pmu_lbr_init_hsw */
	.byte 0x0e, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xbf, 0x9d, 0x68, 0x73, 0x77	/* Tintel_pmu_lbr_init_hsw */
	.byte 0x0e, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xbf, 0x9d, 0x6b, 0x6e, 0x6c	/* T__pfx_intel_pmu_lbr_init_knl */
	.byte 0x0e, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xbf, 0x9d, 0x6b, 0x6e, 0x6c	/* Tintel_pmu_lbr_init_knl */
	.byte 0x0b, 0xeb, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xbf, 0xea	/* T__pfx_intel_pmu_lbr_init */
	.byte 0x0b, 0x54, 0x9a, 0xec, 0x6d, 0x75, 0x5f, 0x6c, 0x62, 0x72, 0xbf, 0xea	/* Tintel_pmu_lbr_init */
	.byte 0x09, 0xef, 0x70, 0x34, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x97	/* t__pfx_p4_pmu_event_map */
	.byte 0x08, 0xce, 0x34, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x97	/* tp4_pmu_event_map */
	.byte 0x05, 0xef, 0x68, 0xfe, 0x73, 0x7c	/* t__pfx_ht_show */
	.byte 0x05, 0x74, 0x68, 0xfe, 0x73, 0x7c	/* tht_show */
	.byte 0x06, 0xef, 0xd6, 0x63, 0x72, 0xf6, 0x7c	/* t__pfx_escr_show */
	.byte 0x06, 0x74, 0xd6, 0x63, 0x72, 0xf6, 0x7c	/* tescr_show */
	.byte 0x07, 0xef, 0x63, 0x63, 0x63, 0x72, 0xf6, 0x7c	/* t__pfx_cccr_show */
	.byte 0x06, 0x26, 0x63, 0x63, 0x72, 0xf6, 0x7c	/* tcccr_show */
	.byte 0x0a, 0xef, 0x70, 0x34, 0xec, 0x6d, 0x75, 0x84, 0x19, 0xc0, 0x64	/* t__pfx_p4_pmu_set_period */
	.byte 0x09, 0xce, 0x34, 0xec, 0x6d, 0x75, 0x84, 0x19, 0xc0, 0x64	/* tp4_pmu_set_period */
	.byte 0x08, 0xef, 0x70, 0x34, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_p4_hw_config */
	.byte 0x07, 0xce, 0x34, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* tp4_hw_config */
	.byte 0x0b, 0xef, 0x70, 0x34, 0xec, 0x6d, 0x75, 0xa3, 0x05, 0xb0, 0xab, 0x71	/* t__pfx_p4_pmu_handle_irq */
	.byte 0x0a, 0xce, 0x34, 0xec, 0x6d, 0x75, 0xa3, 0x05, 0xb0, 0xab, 0x71	/* tp4_pmu_handle_irq */
	.byte 0x0c, 0xef, 0x70, 0x34, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_p4_pmu_disable_event */
	.byte 0x0b, 0xce, 0x34, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* tp4_pmu_disable_event */
	.byte 0x0d, 0xef, 0x70, 0x34, 0xec, 0x6d, 0x75, 0xf6, 0xba, 0x9e, 0x75, 0xb0, 0xd7, 0x93	/* t__pfx_p4_pmu_schedule_events */
	.byte 0x0c, 0xce, 0x34, 0xec, 0x6d, 0x75, 0xf6, 0xba, 0x9e, 0x75, 0xb0, 0xd7, 0x93	/* tp4_pmu_schedule_events */
	.byte 0x0b, 0xef, 0x70, 0x34, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0x5d	/* t__pfx_p4_pmu_disable_all */
	.byte 0x0a, 0xce, 0x34, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0x5d	/* tp4_pmu_disable_all */
	.byte 0x0c, 0x74, 0xaf, 0xec, 0x34, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx___p4_pmu_enable_event */
	.byte 0x0b, 0x74, 0xfd, 0x34, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__p4_pmu_enable_event */
	.byte 0x0b, 0xef, 0x70, 0x34, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_p4_pmu_enable_event */
	.byte 0x0a, 0xce, 0x34, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tp4_pmu_enable_event */
	.byte 0x0a, 0xef, 0x70, 0x34, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x5d	/* t__pfx_p4_pmu_enable_all */
	.byte 0x09, 0xce, 0x34, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x5d	/* tp4_pmu_enable_all */
	.byte 0x09, 0xef, 0x70, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x97	/* t__pfx_p6_pmu_event_map */
	.byte 0x08, 0xce, 0x36, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x97	/* tp6_pmu_event_map */
	.byte 0x06, 0xef, 0x63, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx_cmask_show */
	.byte 0x05, 0x26, 0xd9, 0x5e, 0xf6, 0x7c	/* tcmask_show */
	.byte 0x05, 0xef, 0xf8, 0x76, 0xf6, 0x7c	/* t__pfx_inv_show */
	.byte 0x05, 0x74, 0xf8, 0x76, 0xf6, 0x7c	/* tinv_show */
	.byte 0x05, 0xef, 0x70, 0x63, 0xf6, 0x7c	/* t__pfx_pc_show */
	.byte 0x04, 0xce, 0x63, 0xf6, 0x7c	/* tpc_show */
	.byte 0x06, 0xef, 0x9e, 0x67, 0xfc, 0x73, 0x7c	/* t__pfx_edge_show */
	.byte 0x06, 0x74, 0x9e, 0x67, 0xfc, 0x73, 0x7c	/* tedge_show */
	.byte 0x06, 0xef, 0x75, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx_umask_show */
	.byte 0x06, 0x74, 0x75, 0xd9, 0x5e, 0xf6, 0x7c	/* tumask_show */
	.byte 0x04, 0xef, 0xcc, 0x73, 0x7c	/* t__pfx_event_show */
	.byte 0x04, 0x74, 0xcc, 0x73, 0x7c	/* tevent_show */
	.byte 0x0b, 0xef, 0x70, 0x36, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_p6_pmu_enable_event */
	.byte 0x0a, 0xce, 0x36, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tp6_pmu_enable_event */
	.byte 0x0a, 0xef, 0x70, 0x36, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x5d	/* t__pfx_p6_pmu_enable_all */
	.byte 0x09, 0xce, 0x36, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x5d	/* tp6_pmu_enable_all */
	.byte 0x0b, 0xef, 0x70, 0x36, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0x5d	/* t__pfx_p6_pmu_disable_all */
	.byte 0x0a, 0xce, 0x36, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0x5d	/* tp6_pmu_disable_all */
	.byte 0x0c, 0xef, 0x70, 0x36, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_p6_pmu_disable_event */
	.byte 0x0b, 0xce, 0x36, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* tp6_pmu_disable_event */
	.byte 0x0e, 0xef, 0x70, 0xfe, 0xcc, 0xc8, 0xac, 0xe6, 0x69, 0x6c, 0xa2, 0x73, 0x7f, 0x6e, 0x63	/* t__pfx_pt_event_addr_filters_sync */
	.byte 0x0d, 0xce, 0xfe, 0xcc, 0xc8, 0xac, 0xe6, 0x69, 0x6c, 0xa2, 0x73, 0x7f, 0x6e, 0x63	/* tpt_event_addr_filters_sync */
	.byte 0x06, 0xef, 0x70, 0xfe, 0xcc, 0xf7, 0xc8	/* t__pfx_pt_event_read */
	.byte 0x05, 0xce, 0xfe, 0xcc, 0xf7, 0xc8	/* tpt_event_read */
	.byte 0x0b, 0xeb, 0x9a, 0xec, 0xfe, 0x76, 0xe5, 0x9f, 0x91, 0x63, 0x61, 0x70	/* T__pfx_intel_pt_validate_cap */
	.byte 0x0b, 0x54, 0x9a, 0xec, 0xfe, 0x76, 0xe5, 0x9f, 0x91, 0x63, 0x61, 0x70	/* Tintel_pt_validate_cap */
	.byte 0x09, 0xef, 0x70, 0xfe, 0xcd, 0x64, 0x91, 0x68, 0x65, 0xc8	/* t__pfx_pt_update_head */
	.byte 0x08, 0xce, 0xfe, 0xcd, 0x64, 0x91, 0x68, 0x65, 0xc8	/* tpt_update_head */
	.byte 0x0e, 0xef, 0x70, 0xfe, 0x74, 0xbe, 0x61, 0x0d, 0xf3, 0x79, 0xe6, 0xd5, 0xec, 0x83, 0x65	/* t__pfx_pt_topa_entry_for_page */
	.byte 0x0d, 0xce, 0xfe, 0x74, 0xbe, 0x61, 0x0d, 0xf3, 0x79, 0xe6, 0xd5, 0xec, 0x83, 0x65	/* tpt_topa_entry_for_page */
	.byte 0x0e, 0xef, 0x70, 0xfe, 0x06, 0x66, 0x66, 0xf5, 0x07, 0xe2, 0x6f, 0x66, 0x95, 0xd4, 0x73	/* t__pfx_pt_buffer_reset_offsets */
	.byte 0x0d, 0xce, 0xfe, 0x06, 0x66, 0x66, 0xf5, 0x07, 0xe2, 0x6f, 0x66, 0x95, 0xd4, 0x73	/* tpt_buffer_reset_offsets */
	.byte 0x09, 0xef, 0x70, 0xfe, 0xcc, 0x64, 0xd6, 0xf3, 0x6f, 0x79	/* t__pfx_pt_event_destroy */
	.byte 0x08, 0xce, 0xfe, 0xcc, 0x64, 0xd6, 0xf3, 0x6f, 0x79	/* tpt_event_destroy */
	.byte 0x0a, 0xef, 0x70, 0x73, 0x62, 0xec, 0xf5, 0xc0, 0x64, 0xf6, 0x7c	/* t__pfx_psb_period_show */
	.byte 0x09, 0xce, 0x73, 0x62, 0xec, 0xf5, 0xc0, 0x64, 0xf6, 0x7c	/* tpsb_period_show */
	.byte 0x0a, 0xef, 0x63, 0x79, 0xc9, 0x74, 0x68, 0x29, 0x68, 0xf6, 0x7c	/* t__pfx_cyc_thresh_show */
	.byte 0x09, 0x26, 0x79, 0xc9, 0x74, 0x68, 0x29, 0x68, 0xf6, 0x7c	/* tcyc_thresh_show */
	.byte 0x09, 0xef, 0x6d, 0x26, 0xec, 0xf5, 0xc0, 0x64, 0xf6, 0x7c	/* t__pfx_mtc_period_show */
	.byte 0x09, 0x74, 0x6d, 0x26, 0xec, 0xf5, 0xc0, 0x64, 0xf6, 0x7c	/* tmtc_period_show */
	.byte 0x07, 0xef, 0x62, 0x72, 0xd2, 0xba, 0xf6, 0x7c	/* t__pfx_branch_show */
	.byte 0x07, 0x74, 0x62, 0x72, 0xd2, 0xba, 0xf6, 0x7c	/* tbranch_show */
	.byte 0x06, 0xef, 0x70, 0x74, 0x77, 0xf6, 0x7c	/* t__pfx_ptw_show */
	.byte 0x05, 0xce, 0x74, 0x77, 0xf6, 0x7c	/* tptw_show */
	.byte 0x09, 0xef, 0x6e, 0x6f, 0xf7, 0x26, 0x6f, 0xb6, 0xf6, 0x7c	/* t__pfx_noretcomp_show */
	.byte 0x09, 0x74, 0x6e, 0x6f, 0xf7, 0x26, 0x6f, 0xb6, 0xf6, 0x7c	/* tnoretcomp_show */
	.byte 0x05, 0xef, 0x93, 0x63, 0xf6, 0x7c	/* t__pfx_tsc_show */
	.byte 0x05, 0x74, 0x93, 0x63, 0xf6, 0x7c	/* ttsc_show */
	.byte 0x05, 0xef, 0x6d, 0x26, 0xf6, 0x7c	/* t__pfx_mtc_show */
	.byte 0x05, 0x74, 0x6d, 0x26, 0xf6, 0x7c	/* tmtc_show */
	.byte 0x0a, 0xef, 0x66, 0xcd, 0x5f, 0xe7, 0xec, 0x74, 0x77, 0xf6, 0x7c	/* t__pfx_fup_on_ptw_show */
	.byte 0x0a, 0x74, 0x66, 0xcd, 0x5f, 0xe7, 0xec, 0x74, 0x77, 0xf6, 0x7c	/* tfup_on_ptw_show */
	.byte 0x08, 0xef, 0x6e, 0x6f, 0x74, 0x6e, 0xfe, 0x73, 0x7c	/* t__pfx_notnt_show */
	.byte 0x08, 0x74, 0x6e, 0x6f, 0x74, 0x6e, 0xfe, 0x73, 0x7c	/* tnotnt_show */
	.byte 0x04, 0xef, 0xcc, 0x73, 0x7c	/* t__pfx_event_show */
	.byte 0x04, 0x74, 0xcc, 0x73, 0x7c	/* tevent_show */
	.byte 0x09, 0xef, 0x70, 0x77, 0x72, 0x5f, 0xee, 0xfe, 0x73, 0x7c	/* t__pfx_pwr_evt_show */
	.byte 0x08, 0xce, 0x77, 0x72, 0x5f, 0xee, 0xfe, 0x73, 0x7c	/* tpwr_evt_show */
	.byte 0x06, 0xef, 0x63, 0x79, 0x63, 0xf6, 0x7c	/* t__pfx_cyc_show */
	.byte 0x05, 0x26, 0x79, 0x63, 0xf6, 0x7c	/* tcyc_show */
	.byte 0x05, 0xef, 0x70, 0xfe, 0x73, 0x7c	/* t__pfx_pt_show */
	.byte 0x04, 0xce, 0xfe, 0x73, 0x7c	/* tpt_show */
	.byte 0x09, 0xef, 0x70, 0xfe, 0x00, 0x8d, 0x5f, 0x24, 0xf6, 0x7c	/* t__pfx_pt_timing_attr_show */
	.byte 0x08, 0xce, 0xfe, 0x00, 0x8d, 0x5f, 0x24, 0xf6, 0x7c	/* tpt_timing_attr_show */
	.byte 0x0d, 0xef, 0x70, 0xfe, 0x06, 0x66, 0x66, 0xf5, 0xe6, 0xf7, 0xfc, 0x61, 0x75, 0x78	/* t__pfx_pt_buffer_free_aux */
	.byte 0x0c, 0xce, 0xfe, 0x06, 0x66, 0x66, 0xf5, 0xe6, 0xf7, 0xfc, 0x61, 0x75, 0x78	/* tpt_buffer_free_aux */
	.byte 0x09, 0xef, 0x70, 0xfe, 0x74, 0xbe, 0x61, 0xed, 0x75, 0xb6	/* t__pfx_pt_topa_dump */
	.byte 0x08, 0xce, 0xfe, 0x74, 0xbe, 0x61, 0xed, 0x75, 0xb6	/* tpt_topa_dump */
	.byte 0x0f, 0xef, 0x70, 0xfe, 0xcc, 0xc8, 0xac, 0xe6, 0x69, 0x6c, 0xa2, 0xe9, 0x76, 0xe5, 0x9f, 0x14	/* t__pfx_pt_event_addr_filters_validate */
	.byte 0x0e, 0xce, 0xfe, 0xcc, 0xc8, 0xac, 0xe6, 0x69, 0x6c, 0xa2, 0xe9, 0x76, 0xe5, 0x9f, 0x14	/* tpt_event_addr_filters_validate */
	.byte 0x0a, 0xef, 0x70, 0xfe, 0xf7, 0x61, 0xda, 0x6f, 0x66, 0x95, 0xd4	/* t__pfx_pt_read_offset */
	.byte 0x09, 0xce, 0xfe, 0xf7, 0x61, 0xda, 0x6f, 0x66, 0x95, 0xd4	/* tpt_read_offset */
	.byte 0x09, 0xef, 0x70, 0xfe, 0x40, 0xa5, 0x67, 0xa9, 0x72, 0x74	/* t__pfx_pt_config_start */
	.byte 0x08, 0xce, 0xfe, 0x40, 0xa5, 0x67, 0xa9, 0x72, 0x74	/* tpt_config_start */
	.byte 0x0b, 0xef, 0x70, 0xfe, 0x40, 0xa5, 0x67, 0xb8, 0x75, 0x66, 0x66, 0xf5	/* t__pfx_pt_config_buffer */
	.byte 0x0a, 0xce, 0xfe, 0x40, 0xa5, 0x67, 0xb8, 0x75, 0x66, 0x66, 0xf5	/* tpt_config_buffer */
	.byte 0x0d, 0xeb, 0x9a, 0xec, 0xfe, 0x76, 0xe5, 0x9f, 0x91, 0x68, 0x77, 0xf0, 0x61, 0x70	/* T__pfx_intel_pt_validate_hw_cap */
	.byte 0x0d, 0x54, 0x9a, 0xec, 0xfe, 0x76, 0xe5, 0x9f, 0x91, 0x68, 0x77, 0xf0, 0x61, 0x70	/* Tintel_pt_validate_hw_cap */
	.byte 0x0a, 0xeb, 0x9a, 0xec, 0xfe, 0x68, 0x05, 0xb0, 0x76, 0x6d, 0x78	/* T__pfx_intel_pt_handle_vmx */
	.byte 0x0a, 0x54, 0x9a, 0xec, 0xfe, 0x68, 0x05, 0xb0, 0x76, 0x6d, 0x78	/* Tintel_pt_handle_vmx */
	.byte 0x08, 0xef, 0x70, 0xfe, 0x63, 0x61, 0x70, 0xf6, 0x7c	/* t__pfx_pt_cap_show */
	.byte 0x07, 0xce, 0xfe, 0x63, 0x61, 0x70, 0xf6, 0x7c	/* tpt_cap_show */
	.byte 0x0e, 0xef, 0x74, 0xbe, 0x61, 0x5f, 0x22, 0x63, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__pfx_topa_alloc.constprop.0 */
	.byte 0x0e, 0x74, 0x74, 0xbe, 0x61, 0x5f, 0x22, 0x63, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* ttopa_alloc.constprop.0 */
	.byte 0x0a, 0xef, 0x74, 0xbe, 0x61, 0xbf, 0x73, 0xf5, 0xfe, 0xe0, 0xc4	/* t__pfx_topa_insert_table */
	.byte 0x0a, 0x74, 0x74, 0xbe, 0x61, 0xbf, 0x73, 0xf5, 0xfe, 0xe0, 0xc4	/* ttopa_insert_table */
	.byte 0x0f, 0xef, 0x70, 0xfe, 0xcc, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0xfe, 0x61, 0x75, 0x78	/* t__pfx_pt_event_snapshot_aux */
	.byte 0x0e, 0xce, 0xfe, 0xcc, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0xfe, 0x61, 0x75, 0x78	/* tpt_event_snapshot_aux */
	.byte 0x0e, 0xef, 0x70, 0xfe, 0x06, 0x66, 0x66, 0xf5, 0x07, 0xe2, 0xd9, 0x72, 0x6b, 0xf5, 0x73	/* t__pfx_pt_buffer_reset_markers */
	.byte 0x0d, 0xce, 0xfe, 0x06, 0x66, 0x66, 0xf5, 0x07, 0xe2, 0xd9, 0x72, 0x6b, 0xf5, 0x73	/* tpt_buffer_reset_markers */
	.byte 0x07, 0xef, 0x70, 0xfe, 0xcc, 0x3d, 0x72, 0x74	/* t__pfx_pt_event_start */
	.byte 0x06, 0xce, 0xfe, 0xcc, 0x3d, 0x72, 0x74	/* tpt_event_start */
	.byte 0x06, 0xef, 0x70, 0xfe, 0xcc, 0xc8, 0x64	/* t__pfx_pt_event_add */
	.byte 0x05, 0xce, 0xfe, 0xcc, 0xc8, 0x64	/* tpt_event_add */
	.byte 0x09, 0xef, 0x70, 0xfe, 0x68, 0x05, 0xb0, 0x3d, 0x74, 0xb1	/* t__pfx_pt_handle_status */
	.byte 0x08, 0xce, 0xfe, 0x68, 0x05, 0xb0, 0x3d, 0x74, 0xb1	/* tpt_handle_status */
	.byte 0x07, 0xef, 0x70, 0xfe, 0xcc, 0x73, 0x74, 0xbe	/* t__pfx_pt_event_stop */
	.byte 0x06, 0xce, 0xfe, 0xcc, 0x73, 0x74, 0xbe	/* tpt_event_stop */
	.byte 0x06, 0xef, 0x70, 0xfe, 0xcc, 0x64, 0xdb	/* t__pfx_pt_event_del */
	.byte 0x05, 0xce, 0xfe, 0xcc, 0x64, 0xdb	/* tpt_event_del */
	.byte 0x0e, 0xef, 0x70, 0xfe, 0x06, 0x66, 0x66, 0xf5, 0xf6, 0xd4, 0xcd, 0x5f, 0x61, 0x75, 0x78	/* t__pfx_pt_buffer_setup_aux */
	.byte 0x0d, 0xce, 0xfe, 0x06, 0x66, 0x66, 0xf5, 0xf6, 0xd4, 0xcd, 0x5f, 0x61, 0x75, 0x78	/* tpt_buffer_setup_aux */
	.byte 0x05, 0xef, 0x70, 0xfe, 0xcc, 0x0f	/* t__pfx_pt_event_init */
	.byte 0x04, 0xce, 0xfe, 0xcc, 0x0f	/* tpt_event_init */
	.byte 0x09, 0xeb, 0x9a, 0xec, 0xfe, 0xb3, 0xf5, 0x72, 0xcd, 0x74	/* T__pfx_intel_pt_interrupt */
	.byte 0x09, 0x54, 0x9a, 0xec, 0xfe, 0xb3, 0xf5, 0x72, 0xcd, 0x74	/* Tintel_pt_interrupt */
	.byte 0x10, 0xeb, 0x63, 0x9c, 0x5f, 0x65, 0x6d, 0xf5, 0x67, 0xf1, 0x63, 0x79, 0xf6, 0x74, 0xbe, 0xec, 0x74	/* T__pfx_cpu_emergency_stop_pt */
	.byte 0x10, 0x54, 0x63, 0x9c, 0x5f, 0x65, 0x6d, 0xf5, 0x67, 0xf1, 0x63, 0x79, 0xf6, 0x74, 0xbe, 0xec, 0x74	/* Tcpu_emergency_stop_pt */
	.byte 0x08, 0xeb, 0x69, 0xe9, 0x9a, 0xec, 0xfe, 0xd7, 0x74	/* T__pfx_is_intel_pt_event */
	.byte 0x08, 0x54, 0x69, 0xe9, 0x9a, 0xec, 0xfe, 0xd7, 0x74	/* Tis_intel_pt_event */
	.byte 0x0b, 0xef, 0x96, 0xd5, 0xfc, 0x63, 0xa0, 0xc4, 0x63, 0xfe, 0xd7, 0x93	/* t__pfx_uncore_collect_events */
	.byte 0x0b, 0x74, 0x96, 0xd5, 0xfc, 0x63, 0xa0, 0xc4, 0x63, 0xfe, 0xd7, 0x93	/* tuncore_collect_events */
	.byte 0x13, 0xef, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xe6, 0xf8, 0x64, 0x2b, 0xec, 0x6d, 0x75, 0xe6, 0xe3, 0xae, 0x74, 0x21, 0xd6	/* t__pfx_uncore_pci_find_dev_pmu_from_types */
	.byte 0x13, 0x74, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xe6, 0xf8, 0x64, 0x2b, 0xec, 0x6d, 0x75, 0xe6, 0xe3, 0xae, 0x74, 0x21, 0xd6	/* tuncore_pci_find_dev_pmu_from_types */
	.byte 0x0b, 0xef, 0x96, 0xd5, 0xfc, 0x67, 0xe2, 0x24, 0xf0, 0x9c, 0xd9, 0x5e	/* t__pfx_uncore_get_attr_cpumask */
	.byte 0x0b, 0x74, 0x96, 0xd5, 0xfc, 0x67, 0xe2, 0x24, 0xf0, 0x9c, 0xd9, 0x5e	/* tuncore_get_attr_cpumask */
	.byte 0x12, 0xef, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xe6, 0xf8, 0x64, 0x2b, 0xec, 0x6d, 0x75, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__pfx_uncore_pci_find_dev_pmu.part.0 */
	.byte 0x12, 0x74, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xe6, 0xf8, 0x64, 0x2b, 0xec, 0x6d, 0x75, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* tuncore_pci_find_dev_pmu.part.0 */
	.byte 0x0d, 0xef, 0x96, 0xd5, 0xfc, 0x22, 0xc9, 0x62, 0x6f, 0x78, 0x2e, 0xca, 0xbc, 0x7e	/* t__pfx_uncore_alloc_box.isra.0 */
	.byte 0x0d, 0x74, 0x96, 0xd5, 0xfc, 0x22, 0xc9, 0x62, 0x6f, 0x78, 0x2e, 0xca, 0xbc, 0x7e	/* tuncore_alloc_box.isra.0 */
	.byte 0x08, 0xef, 0x22, 0x63, 0x91, 0x62, 0x6f, 0x78, 0xd6	/* t__pfx_allocate_boxes */
	.byte 0x09, 0xf4, 0x6c, 0xdd, 0x63, 0x91, 0x62, 0x6f, 0x78, 0xd6	/* tallocate_boxes */
	.byte 0x0a, 0xef, 0x96, 0xd5, 0xfc, 0x74, 0x21, 0x65, 0xe9, 0xcb, 0xea	/* t__pfx_uncore_types_exit */
	.byte 0x0a, 0x74, 0x96, 0xd5, 0xfc, 0x74, 0x21, 0x65, 0xe9, 0xcb, 0xea	/* tuncore_types_exit */
	.byte 0x0e, 0xef, 0x96, 0xd5, 0xfc, 0xba, 0xd2, 0x67, 0xfc, 0x74, 0x21, 0xfc, 0x63, 0x74, 0x78	/* t__pfx_uncore_change_type_ctx */
	.byte 0x0e, 0x74, 0x96, 0xd5, 0xfc, 0xba, 0xd2, 0x67, 0xfc, 0x74, 0x21, 0xfc, 0x63, 0x74, 0x78	/* tuncore_change_type_ctx */
	.byte 0x0e, 0xef, 0x96, 0xd5, 0xfc, 0x62, 0x6f, 0x78, 0xde, 0x66, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__pfx_uncore_box_ref.part.0 */
	.byte 0x0e, 0x74, 0x96, 0xd5, 0xfc, 0x62, 0x6f, 0x78, 0xde, 0x66, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* tuncore_box_ref.part.0 */
	.byte 0x0b, 0xef, 0x96, 0xd5, 0xfc, 0xbb, 0x85, 0x67, 0x6e, 0x5f, 0xd7, 0x93	/* t__pfx_uncore_assign_events */
	.byte 0x0b, 0x74, 0x96, 0xd5, 0xfc, 0xbb, 0x85, 0x67, 0x6e, 0x5f, 0xd7, 0x93	/* tuncore_assign_events */
	.byte 0x0b, 0xef, 0x96, 0xd5, 0xfc, 0x62, 0x6f, 0x78, 0x5f, 0xe4, 0xf7, 0x66	/* t__pfx_uncore_box_unref */
	.byte 0x0b, 0x74, 0x96, 0xd5, 0xfc, 0x62, 0x6f, 0x78, 0x5f, 0xe4, 0xf7, 0x66	/* tuncore_box_unref */
	.byte 0x0e, 0xef, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0x5f, 0xcb, 0xea, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__pfx_uncore_pci_exit.part.0 */
	.byte 0x0e, 0x74, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0x5f, 0xcb, 0xea, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* tuncore_pci_exit.part.0 */
	.byte 0x0d, 0xef, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xec, 0x6d, 0x75, 0x5f, 0xe4, 0xf7, 0x0e	/* t__pfx_uncore_pci_pmu_unregister */
	.byte 0x0d, 0x74, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xec, 0x6d, 0x75, 0x5f, 0xe4, 0xf7, 0x0e	/* tuncore_pci_pmu_unregister */
	.byte 0x0d, 0xef, 0x96, 0xd5, 0xfc, 0xcc, 0x63, 0x9c, 0x5f, 0x6f, 0x66, 0x66, 0x2d, 0x65	/* t__pfx_uncore_event_cpu_offline */
	.byte 0x0d, 0x74, 0x96, 0xd5, 0xfc, 0xcc, 0x63, 0x9c, 0x5f, 0x6f, 0x66, 0x66, 0x2d, 0x65	/* tuncore_event_cpu_offline */
	.byte 0x0a, 0xef, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0x0d, 0x90, 0xc4	/* t__pfx_uncore_pmu_enable */
	.byte 0x0a, 0x74, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0x0d, 0x90, 0xc4	/* tuncore_pmu_enable */
	.byte 0x0b, 0xef, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xc4	/* t__pfx_uncore_pmu_disable */
	.byte 0x0b, 0x74, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xc4	/* tuncore_pmu_disable */
	.byte 0x0b, 0xef, 0x96, 0xd5, 0xfc, 0xcc, 0x63, 0x9c, 0x5f, 0xe7, 0x2d, 0x65	/* t__pfx_uncore_event_cpu_online */
	.byte 0x0b, 0x74, 0x96, 0xd5, 0xfc, 0xcc, 0x63, 0x9c, 0x5f, 0xe7, 0x2d, 0x65	/* tuncore_event_cpu_online */
	.byte 0x0c, 0xeb, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0x3d, 0x72, 0x74	/* T__pfx_uncore_pmu_event_start */
	.byte 0x0c, 0x54, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0x3d, 0x72, 0x74	/* Tuncore_pmu_event_start */
	.byte 0x0a, 0xef, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0x0f	/* t__pfx_uncore_pmu_event_init */
	.byte 0x0a, 0x74, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0x0f	/* tuncore_pmu_event_init */
	.byte 0x0a, 0xef, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xde, 0x17, 0x76, 0x65	/* t__pfx_uncore_pci_remove */
	.byte 0x0a, 0x74, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xde, 0x17, 0x76, 0x65	/* tuncore_pci_remove */
	.byte 0x0e, 0xef, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xb8, 0x75, 0xe9, 0x6e, 0x6f, 0xdc, 0x66, 0x79	/* t__pfx_uncore_pci_bus_notify */
	.byte 0x0e, 0x74, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xb8, 0x75, 0xe9, 0x6e, 0x6f, 0xdc, 0x66, 0x79	/* tuncore_pci_bus_notify */
	.byte 0x10, 0xef, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xf6, 0x88, 0xb8, 0x75, 0xe9, 0x6e, 0x6f, 0xdc, 0x66, 0x79	/* t__pfx_uncore_pci_sub_bus_notify */
	.byte 0x10, 0x74, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xf6, 0x88, 0xb8, 0x75, 0xe9, 0x6e, 0x6f, 0xdc, 0x66, 0x79	/* tuncore_pci_sub_bus_notify */
	.byte 0x0d, 0xeb, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0x06, 0xe9, 0x8a, 0xed, 0x69, 0x65, 0x9f	/* T__pfx_uncore_pcibus_to_dieid */
	.byte 0x0d, 0x54, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0x06, 0xe9, 0x8a, 0xed, 0x69, 0x65, 0x9f	/* Tuncore_pcibus_to_dieid */
	.byte 0x0e, 0xeb, 0x96, 0xd5, 0xfc, 0x64, 0x69, 0xfc, 0x8a, 0xf6, 0x65, 0x67, 0x6d, 0xf1, 0x74	/* T__pfx_uncore_die_to_segment */
	.byte 0x0e, 0x54, 0x96, 0xd5, 0xfc, 0x64, 0x69, 0xfc, 0x8a, 0xf6, 0x65, 0x67, 0x6d, 0xf1, 0x74	/* Tuncore_die_to_segment */
	.byte 0x0b, 0xeb, 0x96, 0xd5, 0xfc, 0xb5, 0xaa, 0xfc, 0x8a, 0xed, 0x69, 0x65	/* T__pfx_uncore_device_to_die */
	.byte 0x0b, 0x54, 0x96, 0xd5, 0xfc, 0xb5, 0xaa, 0xfc, 0x8a, 0xed, 0x69, 0x65	/* Tuncore_device_to_die */
	.byte 0x0b, 0x99, 0xe6, 0xf8, 0x64, 0xec, 0x9b, 0x32, 0x70, 0x68, 0x1d, 0x97	/* T__pfx___find_pci2phy_map */
	.byte 0x0b, 0xb9, 0x66, 0xf8, 0x64, 0xec, 0x9b, 0x32, 0x70, 0x68, 0x1d, 0x97	/* T__find_pci2phy_map */
	.byte 0x07, 0xeb, 0x96, 0xd5, 0xfc, 0xcc, 0x73, 0x7c	/* T__pfx_uncore_event_show */
	.byte 0x07, 0x54, 0x96, 0xd5, 0xfc, 0xcc, 0x73, 0x7c	/* Tuncore_event_show */
	.byte 0x0c, 0xeb, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0xa7, 0x6f, 0xb8, 0x6f, 0x78	/* T__pfx_uncore_pmu_to_box */
	.byte 0x0c, 0x54, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0xa7, 0x6f, 0xb8, 0x6f, 0x78	/* Tuncore_pmu_to_box */
	.byte 0x0c, 0xeb, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xde, 0xc8, 0x3a, 0xe4, 0xa2	/* T__pfx_uncore_msr_read_counter */
	.byte 0x0c, 0x54, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xde, 0xc8, 0x3a, 0xe4, 0xa2	/* Tuncore_msr_read_counter */
	.byte 0x0d, 0xeb, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0x5f, 0xcb, 0x9d, 0x62, 0x6f, 0x78	/* T__pfx_uncore_mmio_exit_box */
	.byte 0x0d, 0x54, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0x5f, 0xcb, 0x9d, 0x62, 0x6f, 0x78	/* Tuncore_mmio_exit_box */
	.byte 0x0c, 0xeb, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xde, 0xc8, 0x3a, 0xe4, 0xa2	/* T__pfx_uncore_mmio_read_counter */
	.byte 0x0c, 0x54, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xde, 0xc8, 0x3a, 0xe4, 0xa2	/* Tuncore_mmio_read_counter */
	.byte 0x0b, 0xeb, 0x96, 0xd5, 0xfc, 0x67, 0xe2, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* T__pfx_uncore_get_constraint */
	.byte 0x0b, 0x54, 0x96, 0xd5, 0xfc, 0x67, 0xe2, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* Tuncore_get_constraint */
	.byte 0x0b, 0xeb, 0x96, 0xd5, 0xfc, 0x9c, 0xfe, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* T__pfx_uncore_put_constraint */
	.byte 0x0b, 0x54, 0x96, 0xd5, 0xfc, 0x9c, 0xfe, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* Tuncore_put_constraint */
	.byte 0x0e, 0xeb, 0x96, 0xd5, 0xfc, 0x73, 0x68, 0x61, 0xf7, 0x64, 0xde, 0x67, 0x3e, 0xa5, 0x67	/* T__pfx_uncore_shared_reg_config */
	.byte 0x0e, 0x54, 0x96, 0xd5, 0xfc, 0x73, 0x68, 0x61, 0xf7, 0x64, 0xde, 0x67, 0x3e, 0xa5, 0x67	/* Tuncore_shared_reg_config */
	.byte 0x0a, 0xeb, 0x96, 0xd5, 0xfc, 0x19, 0x3b, 0xcc, 0xcd, 0x64, 0x14	/* T__pfx_uncore_perf_event_update */
	.byte 0x0a, 0x54, 0x96, 0xd5, 0xfc, 0x19, 0x3b, 0xcc, 0xcd, 0x64, 0x14	/* Tuncore_perf_event_update */
	.byte 0x0b, 0xeb, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0xf7, 0xc8	/* T__pfx_uncore_pmu_event_read */
	.byte 0x0b, 0x54, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0xf7, 0xc8	/* Tuncore_pmu_event_read */
	.byte 0x0b, 0xef, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0xa3, 0x72, 0x00, 0xf5	/* t__pfx_uncore_pmu_hrtimer */
	.byte 0x0b, 0x74, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0xa3, 0x72, 0x00, 0xf5	/* tuncore_pmu_hrtimer */
	.byte 0x0c, 0xeb, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0x73, 0x74, 0xbe	/* T__pfx_uncore_pmu_event_stop */
	.byte 0x0c, 0x54, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0x73, 0x74, 0xbe	/* Tuncore_pmu_event_stop */
	.byte 0x0b, 0xeb, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0xc8, 0x64	/* T__pfx_uncore_pmu_event_add */
	.byte 0x0b, 0x54, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0xc8, 0x64	/* Tuncore_pmu_event_add */
	.byte 0x0b, 0xeb, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0x64, 0xdb	/* T__pfx_uncore_pmu_event_del */
	.byte 0x0b, 0x54, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0x64, 0xdb	/* Tuncore_pmu_event_del */
	.byte 0x0e, 0xeb, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0xa9, 0x72, 0xfe, 0x68, 0x72, 0x00, 0xf5	/* T__pfx_uncore_pmu_start_hrtimer */
	.byte 0x0e, 0x54, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0xa9, 0x72, 0xfe, 0x68, 0x72, 0x00, 0xf5	/* Tuncore_pmu_start_hrtimer */
	.byte 0x0f, 0xeb, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0xf0, 0xd2, 0x63, 0xdb, 0xa3, 0x72, 0x00, 0xf5	/* T__pfx_uncore_pmu_cancel_hrtimer */
	.byte 0x0f, 0x54, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0xf0, 0xd2, 0x63, 0xdb, 0xa3, 0x72, 0x00, 0xf5	/* Tuncore_pmu_cancel_hrtimer */
	.byte 0x0d, 0xeb, 0x96, 0xd5, 0xfc, 0x67, 0xe2, 0xe5, 0x69, 0x61, 0xe9, 0x6e, 0x61, 0xa8	/* T__pfx_uncore_get_alias_name */
	.byte 0x0d, 0x54, 0x96, 0xd5, 0xfc, 0x67, 0xe2, 0xe5, 0x69, 0x61, 0xe9, 0x6e, 0x61, 0xa8	/* Tuncore_get_alias_name */
	.byte 0x09, 0xef, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0xde, 0x0e	/* t__pfx_uncore_pmu_register */
	.byte 0x09, 0x74, 0x96, 0xd5, 0xfc, 0x70, 0x6d, 0x75, 0xde, 0x0e	/* tuncore_pmu_register */
	.byte 0x0b, 0xef, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xec, 0x6d, 0x75, 0xde, 0x0e	/* t__pfx_uncore_pci_pmu_register */
	.byte 0x0b, 0x74, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xec, 0x6d, 0x75, 0xde, 0x0e	/* tuncore_pci_pmu_register */
	.byte 0x09, 0xef, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xec, 0x8c, 0x65	/* t__pfx_uncore_pci_probe */
	.byte 0x09, 0x74, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xec, 0x8c, 0x65	/* tuncore_pci_probe */
	.byte 0x0e, 0xef, 0x6e, 0x68, 0x6d, 0xcb, 0xb8, 0x62, 0x6f, 0x78, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_nhmex_bbox_hw_config */
	.byte 0x0e, 0x74, 0x6e, 0x68, 0x6d, 0xcb, 0xb8, 0x62, 0x6f, 0x78, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* tnhmex_bbox_hw_config */
	.byte 0x0e, 0xef, 0x6e, 0x68, 0x6d, 0xcb, 0xc1, 0x62, 0x6f, 0x78, 0x5f, 0xe5, 0xa2, 0x5f, 0xf5	/* t__pfx_nhmex_mbox_alter_er */
	.byte 0x0e, 0x74, 0x6e, 0x68, 0x6d, 0xcb, 0xc1, 0x62, 0x6f, 0x78, 0x5f, 0xe5, 0xa2, 0x5f, 0xf5	/* tnhmex_mbox_alter_er */
	.byte 0x0e, 0xef, 0x6e, 0x68, 0x6d, 0xcb, 0xa6, 0x62, 0x6f, 0x78, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_nhmex_rbox_hw_config */
	.byte 0x0e, 0x74, 0x6e, 0x68, 0x6d, 0xcb, 0xa6, 0x62, 0x6f, 0x78, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* tnhmex_rbox_hw_config */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x74, 0x68, 0x29, 0x68, 0x38, 0xf6, 0x7c	/* t__pfx___uncore_thresh8_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x74, 0x68, 0x29, 0x68, 0x38, 0xf6, 0x7c	/* t__uncore_thresh8_show */
	.byte 0x0a, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xf8, 0x76, 0xf6, 0x7c	/* t__pfx___uncore_inv_show */
	.byte 0x09, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xf8, 0x76, 0xf6, 0x7c	/* t__uncore_inv_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x9e, 0x67, 0xfc, 0x73, 0x7c	/* t__pfx___uncore_edge_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x9e, 0x67, 0xfc, 0x73, 0x7c	/* t__uncore_edge_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x75, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx___uncore_umask_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x75, 0xd9, 0x5e, 0xf6, 0x7c	/* t__uncore_umask_show */
	.byte 0x09, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xcc, 0x73, 0x7c	/* t__pfx___uncore_event_show */
	.byte 0x08, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xcc, 0x73, 0x7c	/* t__uncore_event_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x71, 0x6c, 0x78, 0xf0, 0x66, 0x67, 0xf6, 0x7c	/* t__pfx___uncore_qlx_cfg_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x71, 0x6c, 0x78, 0xf0, 0x66, 0x67, 0xf6, 0x7c	/* t__uncore_qlx_cfg_show */
	.byte 0x10, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x78, 0x62, 0x72, 0xc1, 0x6d, 0xf0, 0x66, 0x67, 0xf6, 0x7c	/* t__pfx___uncore_xbr_mm_cfg_show */
	.byte 0x0f, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x78, 0x62, 0x72, 0xc1, 0x6d, 0xf0, 0x66, 0x67, 0xf6, 0x7c	/* t__uncore_xbr_mm_cfg_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xd7, 0x74, 0x35, 0xf6, 0x7c	/* t__pfx___uncore_event5_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xd7, 0x74, 0x35, 0xf6, 0x7c	/* t__uncore_event5_show */
	.byte 0x0a, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx___uncore_mask_show */
	.byte 0x09, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xd9, 0x5e, 0xf6, 0x7c	/* t__uncore_mask_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0xe8, 0xba, 0xf6, 0x7c	/* t__pfx___uncore_match_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x6d, 0xe8, 0xba, 0xf6, 0x7c	/* t__uncore_match_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x03, 0xe4, 0xa2, 0xf6, 0x7c	/* t__pfx___uncore_counter_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x03, 0xe4, 0xa2, 0xf6, 0x7c	/* t__uncore_counter_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x6c, 0x64, 0xf6, 0x7c	/* t__pfx___uncore_pld_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x70, 0x6c, 0x64, 0xf6, 0x7c	/* t__uncore_pld_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x64, 0x73, 0x70, 0xf6, 0x7c	/* t__pfx___uncore_dsp_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x64, 0x73, 0x70, 0xf6, 0x7c	/* t__uncore_dsp_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx___uncore_filter_mask_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xd9, 0x5e, 0xf6, 0x7c	/* t__uncore_filter_mask_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xc1, 0xe8, 0xba, 0xf6, 0x7c	/* t__pfx___uncore_filter_match_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xc1, 0xe8, 0xba, 0xf6, 0x7c	/* t__uncore_filter_match_show */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xf0, 0x66, 0x67, 0x0d, 0xf6, 0x7c	/* t__pfx___uncore_filter_cfg_en_show */
	.byte 0x0e, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xf0, 0x66, 0x67, 0x0d, 0xf6, 0x7c	/* t__uncore_filter_cfg_en_show */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x73, 0xe2, 0x66, 0x6c, 0x83, 0xf6, 0xdb, 0xf6, 0x7c	/* t__pfx___uncore_set_flag_sel_show */
	.byte 0x0e, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x73, 0xe2, 0x66, 0x6c, 0x83, 0xf6, 0xdb, 0xf6, 0x7c	/* t__uncore_set_flag_sel_show */
	.byte 0x0c, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xf8, 0x63, 0xf6, 0xdb, 0xf6, 0x7c	/* t__pfx___uncore_inc_sel_show */
	.byte 0x0b, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xf8, 0x63, 0xf6, 0xdb, 0xf6, 0x7c	/* t__uncore_inc_sel_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x66, 0x6c, 0x83, 0xc1, 0x16, 0x73, 0x7c	/* t__pfx___uncore_flag_mode_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x66, 0x6c, 0x83, 0xc1, 0x16, 0x73, 0x7c	/* t__uncore_flag_mode_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x77, 0xbc, 0x70, 0xc1, 0x16, 0x73, 0x7c	/* t__pfx___uncore_wrap_mode_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x77, 0xbc, 0x70, 0xc1, 0x16, 0x73, 0x7c	/* t__uncore_wrap_mode_show */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x73, 0x74, 0xd5, 0x83, 0xfc, 0x6d, 0x16, 0x73, 0x7c	/* t__pfx___uncore_storage_mode_show */
	.byte 0x0e, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x73, 0x74, 0xd5, 0x83, 0xfc, 0x6d, 0x16, 0x73, 0x7c	/* t__uncore_storage_mode_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x03, 0xe4, 0xfe, 0x6d, 0x16, 0x73, 0x7c	/* t__pfx___uncore_count_mode_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x03, 0xe4, 0xfe, 0x6d, 0x16, 0x73, 0x7c	/* t__uncore_count_mode_show */
	.byte 0x11, 0xef, 0x6e, 0x68, 0x6d, 0xcb, 0xc1, 0x62, 0x6f, 0x78, 0x86, 0x73, 0x68, 0x61, 0xf7, 0x64, 0xde, 0x67	/* t__pfx_nhmex_mbox_get_shared_reg */
	.byte 0x11, 0x74, 0x6e, 0x68, 0x6d, 0xcb, 0xc1, 0x62, 0x6f, 0x78, 0x86, 0x73, 0x68, 0x61, 0xf7, 0x64, 0xde, 0x67	/* tnhmex_mbox_get_shared_reg */
	.byte 0x0e, 0xef, 0x6e, 0x68, 0x6d, 0xcb, 0xc1, 0x62, 0x6f, 0x78, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_nhmex_mbox_hw_config */
	.byte 0x0e, 0x74, 0x6e, 0x68, 0x6d, 0xcb, 0xc1, 0x62, 0x6f, 0x78, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* tnhmex_mbox_hw_config */
	.byte 0x0e, 0xef, 0x6e, 0x68, 0x6d, 0xcb, 0xf6, 0x62, 0x6f, 0x78, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_nhmex_sbox_hw_config */
	.byte 0x0e, 0x74, 0x6e, 0x68, 0x6d, 0xcb, 0xf6, 0x62, 0x6f, 0x78, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* tnhmex_sbox_hw_config */
	.byte 0x12, 0xef, 0x6e, 0x68, 0x6d, 0xcb, 0xc1, 0x62, 0x6f, 0x78, 0xec, 0x1e, 0x73, 0x68, 0x61, 0xf7, 0x64, 0xde, 0x67	/* t__pfx_nhmex_mbox_put_shared_reg */
	.byte 0x12, 0x74, 0x6e, 0x68, 0x6d, 0xcb, 0xc1, 0x62, 0x6f, 0x78, 0xec, 0x1e, 0x73, 0x68, 0x61, 0xf7, 0x64, 0xde, 0x67	/* tnhmex_mbox_put_shared_reg */
	.byte 0x10, 0xef, 0x6e, 0x68, 0x6d, 0xcb, 0xc1, 0x62, 0x6f, 0x78, 0xec, 0x1e, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* t__pfx_nhmex_mbox_put_constraint */
	.byte 0x10, 0x74, 0x6e, 0x68, 0x6d, 0xcb, 0xc1, 0x62, 0x6f, 0x78, 0xec, 0x1e, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* tnhmex_mbox_put_constraint */
	.byte 0x0f, 0xef, 0x6e, 0x68, 0x6d, 0xcb, 0xc1, 0x62, 0x6f, 0x78, 0x86, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* t__pfx_nhmex_mbox_get_constraint */
	.byte 0x0f, 0x74, 0x6e, 0x68, 0x6d, 0xcb, 0xc1, 0x62, 0x6f, 0x78, 0x86, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* tnhmex_mbox_get_constraint */
	.byte 0x10, 0xef, 0x6e, 0x68, 0x6d, 0xcb, 0xa6, 0x62, 0x6f, 0x78, 0xec, 0x1e, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* t__pfx_nhmex_rbox_put_constraint */
	.byte 0x10, 0x74, 0x6e, 0x68, 0x6d, 0xcb, 0xa6, 0x62, 0x6f, 0x78, 0xec, 0x1e, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* tnhmex_rbox_put_constraint */
	.byte 0x0f, 0xef, 0x6e, 0x68, 0x6d, 0xcb, 0xa6, 0x62, 0x6f, 0x78, 0x86, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* t__pfx_nhmex_rbox_get_constraint */
	.byte 0x0f, 0x74, 0x6e, 0x68, 0x6d, 0xcb, 0xa6, 0x62, 0x6f, 0x78, 0x86, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* tnhmex_rbox_get_constraint */
	.byte 0x0a, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xca, 0x73, 0xf6, 0x7c	/* t__pfx___uncore_iss_show */
	.byte 0x09, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xca, 0x73, 0xf6, 0x7c	/* t__uncore_iss_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x28, 0xf5, 0x66, 0xf0, 0x66, 0x67, 0xf6, 0x7c	/* t__pfx___uncore_iperf_cfg_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x28, 0xf5, 0x66, 0xf0, 0x66, 0x67, 0xf6, 0x7c	/* t__uncore_iperf_cfg_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x74, 0x68, 0x72, 0xf6, 0x7c	/* t__pfx___uncore_thr_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x74, 0x68, 0x72, 0xf6, 0x7c	/* t__uncore_thr_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x66, 0x76, 0x63, 0xf6, 0x7c	/* t__pfx___uncore_fvc_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x66, 0x76, 0x63, 0xf6, 0x7c	/* t__uncore_fvc_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x67, 0xfe, 0x73, 0x7c	/* t__pfx___uncore_pgt_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x70, 0x67, 0xfe, 0x73, 0x7c	/* t__uncore_pgt_show */
	.byte 0x09, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x97, 0xf6, 0x7c	/* t__pfx___uncore_map_show */
	.byte 0x08, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x97, 0xf6, 0x7c	/* t__uncore_map_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x78, 0x62, 0x72, 0xc1, 0xe8, 0xba, 0xf6, 0x7c	/* t__pfx___uncore_xbr_match_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x78, 0x62, 0x72, 0xc1, 0xe8, 0xba, 0xf6, 0x7c	/* t__uncore_xbr_match_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x78, 0x62, 0x72, 0x5f, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx___uncore_xbr_mask_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x78, 0x62, 0x72, 0x5f, 0xd9, 0x5e, 0xf6, 0x7c	/* t__uncore_xbr_mask_show */
	.byte 0x11, 0xef, 0x6e, 0x68, 0x6d, 0xcb, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_nhmex_uncore_msr_init_box */
	.byte 0x11, 0x74, 0x6e, 0x68, 0x6d, 0xcb, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* tnhmex_uncore_msr_init_box */
	.byte 0x12, 0xef, 0x6e, 0x68, 0x6d, 0xcb, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x5f, 0xcb, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_nhmex_uncore_msr_exit_box */
	.byte 0x12, 0x74, 0x6e, 0x68, 0x6d, 0xcb, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x5f, 0xcb, 0x9d, 0x62, 0x6f, 0x78	/* tnhmex_uncore_msr_exit_box */
	.byte 0x12, 0xef, 0x6e, 0x68, 0x6d, 0xcb, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_nhmex_uncore_msr_disable_event */
	.byte 0x12, 0x74, 0x6e, 0x68, 0x6d, 0xcb, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* tnhmex_uncore_msr_disable_event */
	.byte 0x11, 0xef, 0x6e, 0x68, 0x6d, 0xcb, 0xb8, 0x62, 0x6f, 0x78, 0xc1, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_nhmex_bbox_msr_enable_event */
	.byte 0x11, 0x74, 0x6e, 0x68, 0x6d, 0xcb, 0xb8, 0x62, 0x6f, 0x78, 0xc1, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tnhmex_bbox_msr_enable_event */
	.byte 0x11, 0xef, 0x6e, 0x68, 0x6d, 0xcb, 0xf6, 0x62, 0x6f, 0x78, 0xc1, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_nhmex_sbox_msr_enable_event */
	.byte 0x11, 0x74, 0x6e, 0x68, 0x6d, 0xcb, 0xf6, 0x62, 0x6f, 0x78, 0xc1, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tnhmex_sbox_msr_enable_event */
	.byte 0x13, 0xef, 0x6e, 0x68, 0x6d, 0xcb, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* t__pfx_nhmex_uncore_msr_disable_box */
	.byte 0x13, 0x74, 0x6e, 0x68, 0x6d, 0xcb, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* tnhmex_uncore_msr_disable_box */
	.byte 0x12, 0xef, 0x6e, 0x68, 0x6d, 0xcb, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* t__pfx_nhmex_uncore_msr_enable_box */
	.byte 0x12, 0x74, 0x6e, 0x68, 0x6d, 0xcb, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* tnhmex_uncore_msr_enable_box */
	.byte 0x11, 0xef, 0x6e, 0x68, 0x6d, 0xcb, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_nhmex_uncore_msr_enable_event */
	.byte 0x11, 0x74, 0x6e, 0x68, 0x6d, 0xcb, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tnhmex_uncore_msr_enable_event */
	.byte 0x11, 0xef, 0x6e, 0x68, 0x6d, 0xcb, 0xc1, 0x62, 0x6f, 0x78, 0xc1, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_nhmex_mbox_msr_enable_event */
	.byte 0x11, 0x74, 0x6e, 0x68, 0x6d, 0xcb, 0xc1, 0x62, 0x6f, 0x78, 0xc1, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tnhmex_mbox_msr_enable_event */
	.byte 0x11, 0xef, 0x6e, 0x68, 0x6d, 0xcb, 0xa6, 0x62, 0x6f, 0x78, 0xc1, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_nhmex_rbox_msr_enable_event */
	.byte 0x11, 0x74, 0x6e, 0x68, 0x6d, 0xcb, 0xa6, 0x62, 0x6f, 0x78, 0xc1, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tnhmex_rbox_msr_enable_event */
	.byte 0x0d, 0xeb, 0x6e, 0x68, 0x6d, 0xcb, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* T__pfx_nhmex_uncore_cpu_init */
	.byte 0x0d, 0x54, 0x6e, 0x68, 0x6d, 0xcb, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* Tnhmex_uncore_cpu_init */
	.byte 0x0f, 0xef, 0x96, 0xd5, 0xfc, 0x66, 0xf7, 0xf5, 0xe4, 0x6e, 0x8d, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_uncore_freerunning_hw_config */
	.byte 0x0f, 0x74, 0x96, 0xd5, 0xfc, 0x66, 0xf7, 0xf5, 0xe4, 0x6e, 0x8d, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* tuncore_freerunning_hw_config */
	.byte 0x11, 0xef, 0x73, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0xc9, 0xf1, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* t__pfx_snb_uncore_imc_enable_box */
	.byte 0x10, 0x93, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0xc9, 0xf1, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* tsnb_uncore_imc_enable_box */
	.byte 0x10, 0xef, 0x73, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0xc9, 0xf1, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_snb_uncore_imc_enable_event */
	.byte 0x0f, 0x93, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0xc9, 0xf1, 0x90, 0xb0, 0xd7, 0x74	/* tsnb_uncore_imc_enable_event */
	.byte 0x10, 0xef, 0x73, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0xc9, 0x68, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_snb_uncore_imc_hw_config */
	.byte 0x0f, 0x93, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0xc9, 0x68, 0x77, 0x3e, 0xa5, 0x67	/* tsnb_uncore_imc_hw_config */
	.byte 0x10, 0xef, 0x73, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0x63, 0xde, 0xc8, 0x3a, 0xe4, 0xa2	/* t__pfx_snb_uncore_imc_read_counter */
	.byte 0x0f, 0x93, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0x63, 0xde, 0xc8, 0x3a, 0xe4, 0xa2	/* tsnb_uncore_imc_read_counter */
	.byte 0x11, 0xef, 0xc8, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* t__pfx_adl_uncore_mmio_disable_box */
	.byte 0x11, 0xf4, 0x64, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* tadl_uncore_mmio_disable_box */
	.byte 0x10, 0xef, 0xc8, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* t__pfx_adl_uncore_mmio_enable_box */
	.byte 0x10, 0xf4, 0x64, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* tadl_uncore_mmio_enable_box */
	.byte 0x0c, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0xd9, 0x5e, 0x35, 0xf6, 0x7c	/* t__pfx___uncore_cmask5_show */
	.byte 0x0b, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x63, 0xd9, 0x5e, 0x35, 0xf6, 0x7c	/* t__uncore_cmask5_show */
	.byte 0x0a, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xf8, 0x76, 0xf6, 0x7c	/* t__pfx___uncore_inv_show */
	.byte 0x09, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xf8, 0x76, 0xf6, 0x7c	/* t__uncore_inv_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x9e, 0x67, 0xfc, 0x73, 0x7c	/* t__pfx___uncore_edge_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x9e, 0x67, 0xfc, 0x73, 0x7c	/* t__uncore_edge_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x75, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx___uncore_umask_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x75, 0xd9, 0x5e, 0xf6, 0x7c	/* t__uncore_umask_show */
	.byte 0x09, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xcc, 0x73, 0x7c	/* t__pfx___uncore_event_show */
	.byte 0x08, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xcc, 0x73, 0x7c	/* t__uncore_event_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x74, 0x68, 0x29, 0x68, 0xa0, 0x64, 0xf6, 0x7c	/* t__pfx___uncore_threshold_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x74, 0x68, 0x29, 0x68, 0xa0, 0x64, 0xf6, 0x7c	/* t__uncore_threshold_show */
	.byte 0x0c, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0xd9, 0x5e, 0x38, 0xf6, 0x7c	/* t__pfx___uncore_cmask8_show */
	.byte 0x0b, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x63, 0xd9, 0x5e, 0x38, 0xf6, 0x7c	/* t__uncore_cmask8_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xba, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx___uncore_chmask_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xba, 0xd9, 0x5e, 0xf6, 0x7c	/* t__uncore_chmask_show */
	.byte 0x0d, 0xef, 0x73, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0xc9, 0xcc, 0x0f	/* t__pfx_snb_uncore_imc_event_init */
	.byte 0x0c, 0x93, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0xc9, 0xcc, 0x0f	/* tsnb_uncore_imc_event_init */
	.byte 0x10, 0xef, 0x73, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0xc9, 0xf8, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_snb_uncore_imc_init_box */
	.byte 0x0f, 0x93, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0xc9, 0xf8, 0x9d, 0x62, 0x6f, 0x78	/* tsnb_uncore_imc_init_box */
	.byte 0x0f, 0xef, 0x96, 0xd5, 0xfc, 0x67, 0xe2, 0x62, 0x6f, 0x78, 0xc1, 0x6d, 0xc0, 0x5f, 0xc8, 0xac	/* t__pfx_uncore_get_box_mmio_addr */
	.byte 0x0f, 0x74, 0x96, 0xd5, 0xfc, 0x67, 0xe2, 0x62, 0x6f, 0x78, 0xc1, 0x6d, 0xc0, 0x5f, 0xc8, 0xac	/* tuncore_get_box_mmio_addr */
	.byte 0x16, 0xef, 0x74, 0x67, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0x63, 0xe6, 0xf7, 0xf5, 0xe4, 0x6e, 0x8d, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_tgl_uncore_imc_freerunning_init_box */
	.byte 0x16, 0x74, 0x74, 0x67, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0x63, 0xe6, 0xf7, 0xf5, 0xe4, 0x6e, 0x8d, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* ttgl_uncore_imc_freerunning_init_box */
	.byte 0x15, 0xef, 0xc8, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0x63, 0xe6, 0xf7, 0xf5, 0xe4, 0x6e, 0x8d, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_adl_uncore_imc_freerunning_init_box */
	.byte 0x15, 0xf4, 0x64, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0x63, 0xe6, 0xf7, 0xf5, 0xe4, 0x6e, 0x8d, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* tadl_uncore_imc_freerunning_init_box */
	.byte 0x0f, 0xef, 0xc8, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0xc9, 0xf8, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_adl_uncore_imc_init_box */
	.byte 0x0f, 0xf4, 0x64, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0xc9, 0xf8, 0x9d, 0x62, 0x6f, 0x78	/* tadl_uncore_imc_init_box */
	.byte 0x11, 0xef, 0x6c, 0x6e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x73, 0x6e, 0x63, 0x75, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_lnl_uncore_sncu_init_box */
	.byte 0x10, 0x23, 0x6e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x73, 0x6e, 0x63, 0x75, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* tlnl_uncore_sncu_init_box */
	.byte 0x10, 0xef, 0x6c, 0x6e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x68, 0x62, 0x6f, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_lnl_uncore_hbo_init_box */
	.byte 0x0f, 0x23, 0x6e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x68, 0x62, 0x6f, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* tlnl_uncore_hbo_init_box */
	.byte 0x11, 0xef, 0x73, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0x63, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_snb_uncore_imc_disable_event */
	.byte 0x10, 0x93, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0x63, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* tsnb_uncore_imc_disable_event */
	.byte 0x12, 0xef, 0x73, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0x63, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* t__pfx_snb_uncore_imc_disable_box */
	.byte 0x11, 0x93, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0x63, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* tsnb_uncore_imc_disable_box */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x74, 0x68, 0x29, 0x68, 0xa0, 0x64, 0x32, 0xf6, 0x7c	/* t__pfx___uncore_threshold2_show */
	.byte 0x0e, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x74, 0x68, 0x29, 0x68, 0xa0, 0x64, 0x32, 0xf6, 0x7c	/* t__uncore_threshold2_show */
	.byte 0x11, 0xef, 0x6e, 0x68, 0xae, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* t__pfx_nhm_uncore_msr_disable_box */
	.byte 0x11, 0x74, 0x6e, 0x68, 0xae, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* tnhm_uncore_msr_disable_box */
	.byte 0x10, 0xef, 0x6e, 0x68, 0xae, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* t__pfx_nhm_uncore_msr_enable_box */
	.byte 0x10, 0x74, 0x6e, 0x68, 0xae, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* tnhm_uncore_msr_enable_box */
	.byte 0x10, 0xef, 0x5e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* t__pfx_skl_uncore_msr_enable_box */
	.byte 0x10, 0x93, 0x6b, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* tskl_uncore_msr_enable_box */
	.byte 0x11, 0xef, 0x73, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* t__pfx_snb_uncore_msr_enable_box */
	.byte 0x10, 0x93, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* tsnb_uncore_msr_enable_box */
	.byte 0x10, 0xef, 0xc8, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* t__pfx_adl_uncore_msr_enable_box */
	.byte 0x10, 0xf4, 0x64, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* tadl_uncore_msr_enable_box */
	.byte 0x11, 0xef, 0x73, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_snb_uncore_msr_disable_event */
	.byte 0x10, 0x93, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* tsnb_uncore_msr_disable_event */
	.byte 0x0f, 0xef, 0x6d, 0x23, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_mtl_uncore_msr_init_box */
	.byte 0x0f, 0x74, 0x6d, 0x23, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* tmtl_uncore_msr_init_box */
	.byte 0x10, 0xef, 0x73, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_snb_uncore_msr_enable_event */
	.byte 0x0f, 0x93, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tsnb_uncore_msr_enable_event */
	.byte 0x10, 0xef, 0x73, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_snb_uncore_msr_init_box */
	.byte 0x0f, 0x93, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* tsnb_uncore_msr_init_box */
	.byte 0x10, 0xef, 0xc8, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x5f, 0xcb, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_adl_uncore_msr_exit_box */
	.byte 0x10, 0xf4, 0x64, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x5f, 0xcb, 0x9d, 0x62, 0x6f, 0x78	/* tadl_uncore_msr_exit_box */
	.byte 0x11, 0xef, 0xc8, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* t__pfx_adl_uncore_msr_disable_box */
	.byte 0x11, 0xf4, 0x64, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* tadl_uncore_msr_disable_box */
	.byte 0x10, 0xef, 0x5e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x5f, 0xcb, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_skl_uncore_msr_exit_box */
	.byte 0x10, 0x93, 0x6b, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x5f, 0xcb, 0x9d, 0x62, 0x6f, 0x78	/* tskl_uncore_msr_exit_box */
	.byte 0x0f, 0xef, 0xc8, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_adl_uncore_msr_init_box */
	.byte 0x0f, 0xf4, 0x64, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* tadl_uncore_msr_init_box */
	.byte 0x10, 0xef, 0x72, 0x6b, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_rkl_uncore_msr_init_box */
	.byte 0x0f, 0xf3, 0x6b, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* trkl_uncore_msr_init_box */
	.byte 0x10, 0xef, 0x6c, 0x6e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_lnl_uncore_msr_init_box */
	.byte 0x0f, 0x23, 0x6e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* tlnl_uncore_msr_init_box */
	.byte 0x11, 0xef, 0x73, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x5f, 0xcb, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_snb_uncore_msr_exit_box */
	.byte 0x10, 0x93, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x5f, 0xcb, 0x9d, 0x62, 0x6f, 0x78	/* tsnb_uncore_msr_exit_box */
	.byte 0x0f, 0xef, 0x5e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_skl_uncore_msr_init_box */
	.byte 0x0f, 0x93, 0x6b, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* tskl_uncore_msr_init_box */
	.byte 0x0f, 0xef, 0x6e, 0x68, 0xae, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_nhm_uncore_msr_enable_event */
	.byte 0x0f, 0x74, 0x6e, 0x68, 0xae, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tnhm_uncore_msr_enable_event */
	.byte 0x0c, 0xeb, 0x73, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* T__pfx_snb_uncore_cpu_init */
	.byte 0x0c, 0x54, 0x73, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* Tsnb_uncore_cpu_init */
	.byte 0x0b, 0xeb, 0x5e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* T__pfx_skl_uncore_cpu_init */
	.byte 0x0b, 0x54, 0x5e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* Tskl_uncore_cpu_init */
	.byte 0x0b, 0xeb, 0xaa, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* T__pfx_icl_uncore_cpu_init */
	.byte 0x0b, 0x54, 0xaa, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* Ticl_uncore_cpu_init */
	.byte 0x0c, 0xeb, 0x74, 0x67, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* T__pfx_tgl_uncore_cpu_init */
	.byte 0x0c, 0x54, 0x74, 0x67, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* Ttgl_uncore_cpu_init */
	.byte 0x0b, 0xeb, 0xc8, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* T__pfx_adl_uncore_cpu_init */
	.byte 0x0b, 0x54, 0xc8, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* Tadl_uncore_cpu_init */
	.byte 0x0b, 0xeb, 0x6d, 0x23, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* T__pfx_mtl_uncore_cpu_init */
	.byte 0x0b, 0x54, 0x6d, 0x23, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* Tmtl_uncore_cpu_init */
	.byte 0x0c, 0xeb, 0x6c, 0x6e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* T__pfx_lnl_uncore_cpu_init */
	.byte 0x0c, 0x54, 0x6c, 0x6e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* Tlnl_uncore_cpu_init */
	.byte 0x0d, 0xeb, 0x73, 0x6e, 0x62, 0xec, 0x9b, 0x32, 0x70, 0x68, 0x1d, 0x97, 0xbf, 0xea	/* T__pfx_snb_pci2phy_map_init */
	.byte 0x0d, 0x54, 0x73, 0x6e, 0x62, 0xec, 0x9b, 0x32, 0x70, 0x68, 0x1d, 0x97, 0xbf, 0xea	/* Tsnb_pci2phy_map_init */
	.byte 0x0c, 0xeb, 0x73, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* T__pfx_snb_uncore_pci_init */
	.byte 0x0c, 0x54, 0x73, 0x6e, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* Tsnb_uncore_pci_init */
	.byte 0x0c, 0xeb, 0x69, 0x76, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* T__pfx_ivb_uncore_pci_init */
	.byte 0x0c, 0x54, 0x69, 0x76, 0x62, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* Tivb_uncore_pci_init */
	.byte 0x0b, 0xeb, 0x68, 0x73, 0x8f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* T__pfx_hsw_uncore_pci_init */
	.byte 0x0b, 0x54, 0x68, 0x73, 0x8f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* Thsw_uncore_pci_init */
	.byte 0x0b, 0xeb, 0x62, 0x64, 0x8f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* T__pfx_bdw_uncore_pci_init */
	.byte 0x0b, 0x54, 0x62, 0x64, 0x8f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* Tbdw_uncore_pci_init */
	.byte 0x0b, 0xeb, 0x5e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* T__pfx_skl_uncore_pci_init */
	.byte 0x0b, 0x54, 0x5e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* Tskl_uncore_pci_init */
	.byte 0x0b, 0xeb, 0x6e, 0x68, 0xae, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* T__pfx_nhm_uncore_cpu_init */
	.byte 0x0b, 0x54, 0x6e, 0x68, 0xae, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* Tnhm_uncore_cpu_init */
	.byte 0x0f, 0xeb, 0x74, 0x67, 0x6c, 0x5f, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xbf, 0xea	/* T__pfx_tgl_l_uncore_mmio_init */
	.byte 0x0f, 0x54, 0x74, 0x67, 0x6c, 0x5f, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xbf, 0xea	/* Ttgl_l_uncore_mmio_init */
	.byte 0x0d, 0xeb, 0x74, 0x67, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xbf, 0xea	/* T__pfx_tgl_uncore_mmio_init */
	.byte 0x0d, 0x54, 0x74, 0x67, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xbf, 0xea	/* Ttgl_uncore_mmio_init */
	.byte 0x0c, 0xeb, 0xc8, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xbf, 0xea	/* T__pfx_adl_uncore_mmio_init */
	.byte 0x0c, 0x54, 0xc8, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xbf, 0xea	/* Tadl_uncore_mmio_init */
	.byte 0x0d, 0xeb, 0x6c, 0x6e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xbf, 0xea	/* T__pfx_lnl_uncore_mmio_init */
	.byte 0x0d, 0x54, 0x6c, 0x6e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xbf, 0xea	/* Tlnl_uncore_mmio_init */
	.byte 0x0f, 0xef, 0x96, 0xd5, 0xfc, 0x66, 0xf7, 0xf5, 0xe4, 0x6e, 0x8d, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_uncore_freerunning_hw_config */
	.byte 0x0f, 0x74, 0x96, 0xd5, 0xfc, 0x66, 0xf7, 0xf5, 0xe4, 0x6e, 0x8d, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* tuncore_freerunning_hw_config */
	.byte 0x11, 0x74, 0xaf, 0xf6, 0x6e, 0x62, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0x86, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* t__pfx___snbep_cbox_get_constraint */
	.byte 0x11, 0x74, 0xff, 0x73, 0x6e, 0x62, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0x86, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* t__snbep_cbox_get_constraint */
	.byte 0x11, 0xef, 0x73, 0x6e, 0x62, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0xe6, 0x69, 0x6c, 0xa2, 0x5f, 0xd9, 0x5e	/* t__pfx_snbep_cbox_filter_mask */
	.byte 0x10, 0x93, 0x6e, 0x62, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0xe6, 0x69, 0x6c, 0xa2, 0x5f, 0xd9, 0x5e	/* tsnbep_cbox_filter_mask */
	.byte 0x10, 0xef, 0x73, 0x6e, 0x62, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0x86, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* t__pfx_snbep_cbox_get_constraint */
	.byte 0x0f, 0x93, 0x6e, 0x62, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0x86, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* tsnbep_cbox_get_constraint */
	.byte 0x0e, 0xef, 0x73, 0x6e, 0x62, 0x65, 0x70, 0xec, 0x63, 0x75, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_snbep_pcu_hw_config */
	.byte 0x0d, 0x93, 0x6e, 0x62, 0x65, 0x70, 0xec, 0x63, 0x75, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* tsnbep_pcu_hw_config */
	.byte 0x11, 0xef, 0x69, 0x76, 0x62, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0xe6, 0x69, 0x6c, 0xa2, 0x5f, 0xd9, 0x5e	/* t__pfx_ivbep_cbox_filter_mask */
	.byte 0x10, 0xdc, 0x76, 0x62, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0xe6, 0x69, 0x6c, 0xa2, 0x5f, 0xd9, 0x5e	/* tivbep_cbox_filter_mask */
	.byte 0x10, 0xef, 0x69, 0x76, 0x62, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0x86, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* t__pfx_ivbep_cbox_get_constraint */
	.byte 0x0f, 0xdc, 0x76, 0x62, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0x86, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* tivbep_cbox_get_constraint */
	.byte 0x0f, 0xef, 0x69, 0x76, 0x62, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_ivbep_cbox_hw_config */
	.byte 0x0e, 0xdc, 0x76, 0x62, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* tivbep_cbox_hw_config */
	.byte 0x0d, 0xef, 0x6b, 0x6e, 0x6c, 0x25, 0x61, 0xe6, 0x69, 0x6c, 0xa2, 0x5f, 0xd9, 0x5e	/* t__pfx_knl_cha_filter_mask */
	.byte 0x0d, 0x74, 0x6b, 0x6e, 0x6c, 0x25, 0x61, 0xe6, 0x69, 0x6c, 0xa2, 0x5f, 0xd9, 0x5e	/* tknl_cha_filter_mask */
	.byte 0x0c, 0xef, 0x6b, 0x6e, 0x6c, 0x25, 0x61, 0x86, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* t__pfx_knl_cha_get_constraint */
	.byte 0x0c, 0x74, 0x6b, 0x6e, 0x6c, 0x25, 0x61, 0x86, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* tknl_cha_get_constraint */
	.byte 0x0f, 0xef, 0x68, 0x73, 0x77, 0x65, 0x70, 0x5f, 0x88, 0x6f, 0x78, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_hswep_ubox_hw_config */
	.byte 0x0f, 0x74, 0x68, 0x73, 0x77, 0x65, 0x70, 0x5f, 0x88, 0x6f, 0x78, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* thswep_ubox_hw_config */
	.byte 0x11, 0xef, 0x68, 0x73, 0x77, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0xe6, 0x69, 0x6c, 0xa2, 0x5f, 0xd9, 0x5e	/* t__pfx_hswep_cbox_filter_mask */
	.byte 0x11, 0x74, 0x68, 0x73, 0x77, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0xe6, 0x69, 0x6c, 0xa2, 0x5f, 0xd9, 0x5e	/* thswep_cbox_filter_mask */
	.byte 0x10, 0xef, 0x68, 0x73, 0x77, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0x86, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* t__pfx_hswep_cbox_get_constraint */
	.byte 0x10, 0x74, 0x68, 0x73, 0x77, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0x86, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* thswep_cbox_get_constraint */
	.byte 0x0f, 0xef, 0x68, 0x73, 0x77, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_hswep_cbox_hw_config */
	.byte 0x0f, 0x74, 0x68, 0x73, 0x77, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* thswep_cbox_hw_config */
	.byte 0x0e, 0xef, 0x68, 0x73, 0x77, 0x65, 0x70, 0xec, 0x63, 0x75, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_hswep_pcu_hw_config */
	.byte 0x0e, 0x74, 0x68, 0x73, 0x77, 0x65, 0x70, 0xec, 0x63, 0x75, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* thswep_pcu_hw_config */
	.byte 0x0c, 0xef, 0x5e, 0x78, 0x25, 0x61, 0xe6, 0x69, 0x6c, 0xa2, 0x5f, 0xd9, 0x5e	/* t__pfx_skx_cha_filter_mask */
	.byte 0x0c, 0x93, 0x6b, 0x78, 0x25, 0x61, 0xe6, 0x69, 0x6c, 0xa2, 0x5f, 0xd9, 0x5e	/* tskx_cha_filter_mask */
	.byte 0x0b, 0xef, 0x5e, 0x78, 0x25, 0x61, 0x86, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* t__pfx_skx_cha_get_constraint */
	.byte 0x0b, 0x93, 0x6b, 0x78, 0x25, 0x61, 0x86, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* tskx_cha_get_constraint */
	.byte 0x0e, 0xef, 0x5e, 0x78, 0x5f, 0x69, 0xc0, 0xa7, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0xf0, 0x62	/* t__pfx_skx_iio_topology_cb */
	.byte 0x0e, 0x93, 0x6b, 0x78, 0x5f, 0x69, 0xc0, 0xa7, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0xf0, 0x62	/* tskx_iio_topology_cb */
	.byte 0x0d, 0xef, 0x70, 0x6d, 0x75, 0xf0, 0xc4, 0xc5, 0x5f, 0x97, 0x70, 0x8d, 0x5f, 0x24	/* t__pfx_pmu_clear_mapping_attr */
	.byte 0x0c, 0xce, 0x6d, 0x75, 0xf0, 0xc4, 0xc5, 0x5f, 0x97, 0x70, 0x8d, 0x5f, 0x24	/* tpmu_clear_mapping_attr */
	.byte 0x10, 0xef, 0x5e, 0x78, 0x5f, 0xcd, 0x69, 0x5f, 0x97, 0x70, 0x8d, 0x5f, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_skx_upi_mapping_visible */
	.byte 0x10, 0x93, 0x6b, 0x78, 0x5f, 0xcd, 0x69, 0x5f, 0x97, 0x70, 0x8d, 0x5f, 0x76, 0xca, 0x69, 0x62, 0xc4	/* tskx_upi_mapping_visible */
	.byte 0x0b, 0xef, 0x73, 0x6e, 0x72, 0x25, 0x61, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_snr_cha_hw_config */
	.byte 0x0a, 0x93, 0x6e, 0x72, 0x25, 0x61, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* tsnr_cha_hw_config */
	.byte 0x0c, 0xef, 0x73, 0x6e, 0x72, 0xec, 0x63, 0x75, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_snr_pcu_hw_config */
	.byte 0x0b, 0x93, 0x6e, 0x72, 0xec, 0x63, 0x75, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* tsnr_pcu_hw_config */
	.byte 0x12, 0xef, 0x73, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* t__pfx_snr_uncore_mmio_disable_box */
	.byte 0x11, 0x93, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* tsnr_uncore_mmio_disable_box */
	.byte 0x11, 0xef, 0x73, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* t__pfx_snr_uncore_mmio_enable_box */
	.byte 0x10, 0x93, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* tsnr_uncore_mmio_enable_box */
	.byte 0x10, 0xef, 0x73, 0x70, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_spr_uncore_mmio_enable_event */
	.byte 0x0f, 0x93, 0x70, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tspr_uncore_mmio_enable_event */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xb8, 0x05, 0x33, 0xf6, 0x7c	/* t__pfx___uncore_filter_band3_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xb8, 0x05, 0x33, 0xf6, 0x7c	/* t__uncore_filter_band3_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xb8, 0x05, 0x32, 0xf6, 0x7c	/* t__pfx___uncore_filter_band2_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xb8, 0x05, 0x32, 0xf6, 0x7c	/* t__uncore_filter_band2_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xb8, 0x05, 0x31, 0xf6, 0x7c	/* t__pfx___uncore_filter_band1_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xb8, 0x05, 0x31, 0xf6, 0x7c	/* t__uncore_filter_band1_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xb8, 0x05, 0x30, 0xf6, 0x7c	/* t__pfx___uncore_filter_band0_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xb8, 0x05, 0x30, 0xf6, 0x7c	/* t__uncore_filter_band0_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x6f, 0x63, 0xc9, 0x9e, 0x67, 0xfc, 0x73, 0x7c	/* t__pfx___uncore_occ_edge_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x6f, 0x63, 0xc9, 0x9e, 0x67, 0xfc, 0x73, 0x7c	/* t__uncore_occ_edge_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x6f, 0x63, 0xc9, 0xf8, 0x0b, 0xfe, 0x73, 0x7c	/* t__pfx___uncore_occ_invert_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x6f, 0x63, 0xc9, 0xf8, 0x0b, 0xfe, 0x73, 0x7c	/* t__uncore_occ_invert_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x74, 0x68, 0x29, 0x68, 0x35, 0xf6, 0x7c	/* t__pfx___uncore_thresh5_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x74, 0x68, 0x29, 0x68, 0x35, 0xf6, 0x7c	/* t__uncore_thresh5_show */
	.byte 0x0a, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xf8, 0x76, 0xf6, 0x7c	/* t__pfx___uncore_inv_show */
	.byte 0x09, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xf8, 0x76, 0xf6, 0x7c	/* t__uncore_inv_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x9e, 0x67, 0xfc, 0x73, 0x7c	/* t__pfx___uncore_edge_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x9e, 0x67, 0xfc, 0x73, 0x7c	/* t__uncore_edge_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x6f, 0x63, 0x63, 0xf6, 0xdb, 0xf6, 0x7c	/* t__pfx___uncore_occ_sel_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x6f, 0x63, 0x63, 0xf6, 0xdb, 0xf6, 0x7c	/* t__uncore_occ_sel_show */
	.byte 0x09, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xcc, 0x73, 0x7c	/* t__pfx___uncore_event_show */
	.byte 0x08, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xcc, 0x73, 0x7c	/* t__uncore_event_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x75, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx___uncore_umask_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x75, 0xd9, 0x5e, 0xf6, 0x7c	/* t__uncore_umask_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xbe, 0x63, 0xf6, 0x7c	/* t__pfx___uncore_filter_opc_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xbe, 0x63, 0xf6, 0x7c	/* t__uncore_filter_opc_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xa9, 0x74, 0xfc, 0x73, 0x7c	/* t__pfx___uncore_filter_state_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xa9, 0x74, 0xfc, 0x73, 0x7c	/* t__uncore_filter_state_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xbd, 0x9f, 0xf6, 0x7c	/* t__pfx___uncore_filter_nid_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xbd, 0x9f, 0xf6, 0x7c	/* t__uncore_filter_nid_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xdc, 0x64, 0xf6, 0x7c	/* t__pfx___uncore_filter_tid_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xdc, 0x64, 0xf6, 0x7c	/* t__uncore_filter_tid_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x74, 0x68, 0x29, 0x68, 0x38, 0xf6, 0x7c	/* t__pfx___uncore_thresh8_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x74, 0x68, 0x29, 0x68, 0x38, 0xf6, 0x7c	/* t__uncore_thresh8_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xdc, 0xda, 0xf1, 0xf6, 0x7c	/* t__pfx___uncore_tid_en_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xdc, 0xda, 0xf1, 0xf6, 0x7c	/* t__uncore_tid_en_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xd9, 0x5e, 0x31, 0xf6, 0x7c	/* t__pfx___uncore_mask1_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xd9, 0x5e, 0x31, 0xf6, 0x7c	/* t__uncore_mask1_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xd9, 0x5e, 0x30, 0xf6, 0x7c	/* t__pfx___uncore_mask0_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xd9, 0x5e, 0x30, 0xf6, 0x7c	/* t__uncore_mask0_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xd9, 0x5e, 0x5f, 0x76, 0x6e, 0x77, 0xf6, 0x7c	/* t__pfx___uncore_mask_vnw_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xd9, 0x5e, 0x5f, 0x76, 0x6e, 0x77, 0xf6, 0x7c	/* t__uncore_mask_vnw_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xd9, 0x5e, 0x5f, 0xbe, 0x63, 0xf6, 0x7c	/* t__pfx___uncore_mask_opc_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xd9, 0x5e, 0x5f, 0xbe, 0x63, 0xf6, 0x7c	/* t__uncore_mask_opc_show */
	.byte 0x0c, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xd9, 0x5e, 0xc1, 0x63, 0xf6, 0x7c	/* t__pfx___uncore_mask_mc_show */
	.byte 0x0b, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xd9, 0x5e, 0xc1, 0x63, 0xf6, 0x7c	/* t__uncore_mask_mc_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xd9, 0x5e, 0xed, 0x6e, 0x9f, 0xf6, 0x7c	/* t__pfx___uncore_mask_dnid_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xd9, 0x5e, 0xed, 0x6e, 0x9f, 0xf6, 0x7c	/* t__uncore_mask_dnid_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xd9, 0x5e, 0xa6, 0x6e, 0x9f, 0x34, 0xf6, 0x7c	/* t__pfx___uncore_mask_rnid4_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xd9, 0x5e, 0xa6, 0x6e, 0x9f, 0x34, 0xf6, 0x7c	/* t__uncore_mask_rnid4_show */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xd9, 0x5e, 0xa6, 0x6e, 0x9f, 0x33, 0x30, 0xf6, 0x7c	/* t__pfx___uncore_mask_rnid30_show */
	.byte 0x0e, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xd9, 0x5e, 0xa6, 0x6e, 0x9f, 0x33, 0x30, 0xf6, 0x7c	/* t__uncore_mask_rnid30_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xd9, 0x5e, 0xa6, 0x64, 0x73, 0xf6, 0x7c	/* t__pfx___uncore_mask_rds_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xd9, 0x5e, 0xa6, 0x64, 0x73, 0xf6, 0x7c	/* t__uncore_mask_rds_show */
	.byte 0x0c, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0xe8, 0xba, 0x31, 0xf6, 0x7c	/* t__pfx___uncore_match1_show */
	.byte 0x0b, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x6d, 0xe8, 0xba, 0x31, 0xf6, 0x7c	/* t__uncore_match1_show */
	.byte 0x0c, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0xe8, 0xba, 0x30, 0xf6, 0x7c	/* t__pfx___uncore_match0_show */
	.byte 0x0b, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x6d, 0xe8, 0xba, 0x30, 0xf6, 0x7c	/* t__uncore_match0_show */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0xe8, 0xba, 0x5f, 0x76, 0x6e, 0x77, 0xf6, 0x7c	/* t__pfx___uncore_match_vnw_show */
	.byte 0x0e, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x6d, 0xe8, 0xba, 0x5f, 0x76, 0x6e, 0x77, 0xf6, 0x7c	/* t__uncore_match_vnw_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0xe8, 0xba, 0xc1, 0x63, 0xf6, 0x7c	/* t__pfx___uncore_match_mc_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x6d, 0xe8, 0xba, 0xc1, 0x63, 0xf6, 0x7c	/* t__uncore_match_mc_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0xe8, 0xba, 0xed, 0x6e, 0x9f, 0xf6, 0x7c	/* t__pfx___uncore_match_dnid_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x6d, 0xe8, 0xba, 0xed, 0x6e, 0x9f, 0xf6, 0x7c	/* t__uncore_match_dnid_show */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0xe8, 0xba, 0xa6, 0x6e, 0x9f, 0x34, 0xf6, 0x7c	/* t__pfx___uncore_match_rnid4_show */
	.byte 0x0e, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x6d, 0xe8, 0xba, 0xa6, 0x6e, 0x9f, 0x34, 0xf6, 0x7c	/* t__uncore_match_rnid4_show */
	.byte 0x10, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0xe8, 0xba, 0xa6, 0x6e, 0x9f, 0x33, 0x30, 0xf6, 0x7c	/* t__pfx___uncore_match_rnid30_show */
	.byte 0x0f, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x6d, 0xe8, 0xba, 0xa6, 0x6e, 0x9f, 0x33, 0x30, 0xf6, 0x7c	/* t__uncore_match_rnid30_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0xe8, 0xba, 0xa6, 0x64, 0x73, 0xf6, 0x7c	/* t__pfx___uncore_match_rds_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x6d, 0xe8, 0xba, 0xa6, 0x64, 0x73, 0xf6, 0x7c	/* t__uncore_match_rds_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xcc, 0xcb, 0xfe, 0x73, 0x7c	/* t__pfx___uncore_event_ext_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xcc, 0xcb, 0xfe, 0x73, 0x7c	/* t__uncore_event_ext_show */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xca, 0x6f, 0x63, 0xf6, 0x7c	/* t__pfx___uncore_filter_isoc_show */
	.byte 0x0e, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xca, 0x6f, 0x63, 0xf6, 0x7c	/* t__uncore_filter_isoc_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xf0, 0x36, 0xf6, 0x7c	/* t__pfx___uncore_filter_c6_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xf0, 0x36, 0xf6, 0x7c	/* t__uncore_filter_c6_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xbd, 0x63, 0xf6, 0x7c	/* t__pfx___uncore_filter_nc_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xbd, 0x63, 0xf6, 0x7c	/* t__uncore_filter_nc_show */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xbe, 0x63, 0x32, 0xf6, 0x7c	/* t__pfx___uncore_filter_opc2_show */
	.byte 0x0e, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xbe, 0x63, 0x32, 0xf6, 0x7c	/* t__uncore_filter_opc2_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xbd, 0x9f, 0x32, 0xf6, 0x7c	/* t__pfx___uncore_filter_nid2_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xbd, 0x9f, 0x32, 0xf6, 0x7c	/* t__uncore_filter_nid2_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xa9, 0x2c, 0x32, 0xf6, 0x7c	/* t__pfx___uncore_filter_state2_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xa9, 0x2c, 0x32, 0xf6, 0x7c	/* t__uncore_filter_state2_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0x01, 0xf6, 0x7c	/* t__pfx___uncore_filter_link_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0x01, 0xf6, 0x7c	/* t__uncore_filter_link_show */
	.byte 0x10, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x6f, 0x63, 0xc9, 0x9e, 0x67, 0xfc, 0x64, 0xe2, 0x73, 0x7c	/* t__pfx___uncore_occ_edge_det_show */
	.byte 0x0f, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x6f, 0x63, 0xc9, 0x9e, 0x67, 0xfc, 0x64, 0xe2, 0x73, 0x7c	/* t__uncore_occ_edge_det_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x74, 0x68, 0x29, 0x68, 0x36, 0xf6, 0x7c	/* t__pfx___uncore_thresh6_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x74, 0x68, 0x29, 0x68, 0x36, 0xf6, 0x7c	/* t__uncore_thresh6_show */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xb1, 0xfc, 0x6f, 0x63, 0x63, 0xf0, 0xf3, 0xf6, 0x7c	/* t__pfx___uncore_use_occ_ctr_show */
	.byte 0x0e, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xb1, 0xfc, 0x6f, 0x63, 0x63, 0xf0, 0xf3, 0xf6, 0x7c	/* t__uncore_use_occ_ctr_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xd7, 0x74, 0x32, 0xf6, 0x7c	/* t__pfx___uncore_event2_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xd7, 0x74, 0x32, 0xf6, 0x7c	/* t__uncore_event2_show */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xbe, 0x63, 0x33, 0xf6, 0x7c	/* t__pfx___uncore_filter_opc3_show */
	.byte 0x0e, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xbe, 0x63, 0x33, 0xf6, 0x7c	/* t__uncore_filter_opc3_show */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0x5d, 0x5f, 0xbe, 0xf6, 0x7c	/* t__pfx___uncore_filter_all_op_show */
	.byte 0x0e, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0x5d, 0x5f, 0xbe, 0xf6, 0x7c	/* t__uncore_filter_all_op_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xa9, 0x2c, 0x34, 0xf6, 0x7c	/* t__pfx___uncore_filter_state4_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xa9, 0x2c, 0x34, 0xf6, 0x7c	/* t__uncore_filter_state4_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0x01, 0x33, 0xf6, 0x7c	/* t__pfx___uncore_filter_link3_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0x01, 0x33, 0xf6, 0x7c	/* t__uncore_filter_link3_show */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xdc, 0x64, 0x34, 0xf6, 0x7c	/* t__pfx___uncore_filter_tid4_show */
	.byte 0x0e, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xdc, 0x64, 0x34, 0xf6, 0x7c	/* t__uncore_filter_tid4_show */
	.byte 0x0a, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x71, 0xd5, 0xf6, 0x7c	/* t__pfx___uncore_qor_show */
	.byte 0x09, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x71, 0xd5, 0xf6, 0x7c	/* t__uncore_qor_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xf0, 0x9f, 0xf6, 0x7c	/* t__pfx___uncore_filter_cid_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xf0, 0x9f, 0xf6, 0x7c	/* t__uncore_filter_cid_show */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xdc, 0x64, 0x32, 0xf6, 0x7c	/* t__pfx___uncore_filter_tid2_show */
	.byte 0x0e, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xdc, 0x64, 0x32, 0xf6, 0x7c	/* t__uncore_filter_tid2_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xa9, 0x2c, 0x33, 0xf6, 0x7c	/* t__pfx___uncore_filter_state3_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xa9, 0x2c, 0x33, 0xf6, 0x7c	/* t__uncore_filter_state3_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0x01, 0x32, 0xf6, 0x7c	/* t__pfx___uncore_filter_link2_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0x01, 0x32, 0xf6, 0x7c	/* t__uncore_filter_link2_show */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xdc, 0x64, 0x33, 0xf6, 0x7c	/* t__pfx___uncore_filter_tid3_show */
	.byte 0x0e, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xdc, 0x64, 0x33, 0xf6, 0x7c	/* t__uncore_filter_tid3_show */
	.byte 0x0c, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x66, 0xc9, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx___uncore_fc_mask_show */
	.byte 0x0b, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x66, 0xc9, 0xd9, 0x5e, 0xf6, 0x7c	/* t__uncore_fc_mask_show */
	.byte 0x0c, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xba, 0x5f, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx___uncore_ch_mask_show */
	.byte 0x0b, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xba, 0x5f, 0xd9, 0x5e, 0xf6, 0x7c	/* t__uncore_ch_mask_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x74, 0x68, 0x29, 0x68, 0x39, 0xf6, 0x7c	/* t__pfx___uncore_thresh9_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x74, 0x68, 0x29, 0x68, 0x39, 0xf6, 0x7c	/* t__uncore_thresh9_show */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xbe, 0xc9, 0x31, 0xf6, 0x7c	/* t__pfx___uncore_filter_opc_1_show */
	.byte 0x0e, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xbe, 0xc9, 0x31, 0xf6, 0x7c	/* t__uncore_filter_opc_1_show */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xbe, 0xc9, 0x30, 0xf6, 0x7c	/* t__pfx___uncore_filter_opc_0_show */
	.byte 0x0e, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xbe, 0xc9, 0x30, 0xf6, 0x7c	/* t__uncore_filter_opc_0_show */
	.byte 0x10, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xbd, 0x6f, 0xfe, 0x6e, 0x6d, 0xf6, 0x7c	/* t__pfx___uncore_filter_not_nm_show */
	.byte 0x0f, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xbd, 0x6f, 0xfe, 0x6e, 0x6d, 0xf6, 0x7c	/* t__uncore_filter_not_nm_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xbd, 0x6d, 0xf6, 0x7c	/* t__pfx___uncore_filter_nm_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xbd, 0x6d, 0xf6, 0x7c	/* t__uncore_filter_nm_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xdd, 0x63, 0xf6, 0x7c	/* t__pfx___uncore_filter_loc_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xdd, 0x63, 0xf6, 0x7c	/* t__uncore_filter_loc_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xde, 0x6d, 0xf6, 0x7c	/* t__pfx___uncore_filter_rem_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xde, 0x6d, 0xf6, 0x7c	/* t__uncore_filter_rem_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xa9, 0x2c, 0x35, 0xf6, 0x7c	/* t__pfx___uncore_filter_state5_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xa9, 0x2c, 0x35, 0xf6, 0x7c	/* t__uncore_filter_state5_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x75, 0xd9, 0x5e, 0x5f, 0xcb, 0xfe, 0x73, 0x7c	/* t__pfx___uncore_umask_ext_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x75, 0xd9, 0x5e, 0x5f, 0xcb, 0xfe, 0x73, 0x7c	/* t__uncore_umask_ext_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x66, 0xc9, 0xd9, 0x5e, 0x32, 0xf6, 0x7c	/* t__pfx___uncore_fc_mask2_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x66, 0xc9, 0xd9, 0x5e, 0x32, 0xf6, 0x7c	/* t__uncore_fc_mask2_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xba, 0x5f, 0xd9, 0x5e, 0x32, 0xf6, 0x7c	/* t__pfx___uncore_ch_mask2_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xba, 0x5f, 0xd9, 0x5e, 0x32, 0xf6, 0x7c	/* t__uncore_ch_mask2_show */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xdc, 0x64, 0x35, 0xf6, 0x7c	/* t__pfx___uncore_filter_tid5_show */
	.byte 0x0e, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xdc, 0x64, 0x35, 0xf6, 0x7c	/* t__uncore_filter_tid5_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x75, 0xd9, 0x5e, 0x5f, 0x8e, 0x32, 0xf6, 0x7c	/* t__pfx___uncore_umask_ext2_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x75, 0xd9, 0x5e, 0x5f, 0x8e, 0x32, 0xf6, 0x7c	/* t__uncore_umask_ext2_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x75, 0xd9, 0x5e, 0x5f, 0x8e, 0x33, 0xf6, 0x7c	/* t__pfx___uncore_umask_ext3_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x75, 0xd9, 0x5e, 0x5f, 0x8e, 0x33, 0xf6, 0x7c	/* t__uncore_umask_ext3_show */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x75, 0xd9, 0x5e, 0x5f, 0x1f, 0xf6, 0x7c	/* t__pfx___uncore_umask_ext4_show */
	.byte 0x0c, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x75, 0xd9, 0x5e, 0x5f, 0x1f, 0xf6, 0x7c	/* t__uncore_umask_ext4_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x75, 0xd9, 0x5e, 0x5f, 0x8e, 0x35, 0xf6, 0x7c	/* t__pfx___uncore_umask_ext5_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x75, 0xd9, 0x5e, 0x5f, 0x8e, 0x35, 0xf6, 0x7c	/* t__uncore_umask_ext5_show */
	.byte 0x11, 0xef, 0x73, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xde, 0xc8, 0x3a, 0xe4, 0xa2	/* t__pfx_snbep_uncore_pci_read_counter */
	.byte 0x10, 0x93, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xde, 0xc8, 0x3a, 0xe4, 0xa2	/* tsnbep_uncore_pci_read_counter */
	.byte 0x11, 0xef, 0x69, 0x76, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0xab, 0x70, 0xde, 0xc8, 0x3a, 0xe4, 0xa2	/* t__pfx_ivbep_uncore_irp_read_counter */
	.byte 0x10, 0xdc, 0x76, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0xab, 0x70, 0xde, 0xc8, 0x3a, 0xe4, 0xa2	/* tivbep_uncore_irp_read_counter */
	.byte 0x11, 0xef, 0x68, 0x73, 0x77, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0xab, 0x70, 0xde, 0xc8, 0x3a, 0xe4, 0xa2	/* t__pfx_hswep_uncore_irp_read_counter */
	.byte 0x11, 0x74, 0x68, 0x73, 0x77, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0xab, 0x70, 0xde, 0xc8, 0x3a, 0xe4, 0xa2	/* thswep_uncore_irp_read_counter */
	.byte 0x0d, 0xef, 0xcd, 0x69, 0xe6, 0x69, 0x6c, 0x6c, 0xa7, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* t__pfx_upi_fill_topology */
	.byte 0x0d, 0x74, 0xcd, 0x69, 0xe6, 0x69, 0x6c, 0x6c, 0xa7, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* tupi_fill_topology */
	.byte 0x11, 0xef, 0x73, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_snbep_uncore_pci_enable_event */
	.byte 0x10, 0x93, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tsnbep_uncore_pci_enable_event */
	.byte 0x12, 0xef, 0x73, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_snbep_uncore_pci_disable_event */
	.byte 0x11, 0x93, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* tsnbep_uncore_pci_disable_event */
	.byte 0x12, 0xef, 0x73, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* t__pfx_snbep_uncore_pci_enable_box */
	.byte 0x11, 0x93, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* tsnbep_uncore_pci_enable_box */
	.byte 0x13, 0xef, 0x73, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* t__pfx_snbep_uncore_pci_disable_box */
	.byte 0x12, 0x93, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* tsnbep_uncore_pci_disable_box */
	.byte 0x11, 0xef, 0x73, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_snbep_uncore_pci_init_box */
	.byte 0x10, 0x93, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* tsnbep_uncore_pci_init_box */
	.byte 0x0e, 0xef, 0x73, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x71, 0xb2, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_snbep_qpi_enable_event */
	.byte 0x0d, 0x93, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x71, 0xb2, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tsnbep_qpi_enable_event */
	.byte 0x11, 0xef, 0x69, 0x76, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_ivbep_uncore_pci_init_box */
	.byte 0x10, 0xdc, 0x76, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* tivbep_uncore_pci_init_box */
	.byte 0x11, 0xef, 0x69, 0x76, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0xab, 0x70, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_ivbep_uncore_irp_enable_event */
	.byte 0x10, 0xdc, 0x76, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0xab, 0x70, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tivbep_uncore_irp_enable_event */
	.byte 0x12, 0xef, 0x69, 0x76, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0xab, 0x70, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_ivbep_uncore_irp_disable_event */
	.byte 0x11, 0xdc, 0x76, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0xab, 0x70, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* tivbep_uncore_irp_disable_event */
	.byte 0x10, 0xef, 0x6b, 0x6e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0xc9, 0xf1, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_knl_uncore_imc_enable_event */
	.byte 0x10, 0x74, 0x6b, 0x6e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0xc9, 0xf1, 0x90, 0xb0, 0xd7, 0x74	/* tknl_uncore_imc_enable_event */
	.byte 0x11, 0xef, 0x6b, 0x6e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0xc9, 0xf1, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* t__pfx_knl_uncore_imc_enable_box */
	.byte 0x11, 0x74, 0x6b, 0x6e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0xc9, 0xf1, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* tknl_uncore_imc_enable_box */
	.byte 0x0f, 0xef, 0x73, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_snr_uncore_pci_enable_event */
	.byte 0x0e, 0x93, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tsnr_uncore_pci_enable_event */
	.byte 0x0f, 0xef, 0x73, 0x70, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_spr_uncore_pci_enable_event */
	.byte 0x0e, 0x93, 0x70, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tspr_uncore_pci_enable_event */
	.byte 0x11, 0xef, 0x68, 0x73, 0x77, 0x65, 0x70, 0xa3, 0x61, 0xe9, 0x6c, 0x69, 0x6d, 0x9d, 0x73, 0x62, 0x6f, 0x78	/* t__pfx_hswep_has_limit_sbox */
	.byte 0x11, 0x74, 0x68, 0x73, 0x77, 0x65, 0x70, 0xa3, 0x61, 0xe9, 0x6c, 0x69, 0x6d, 0x9d, 0x73, 0x62, 0x6f, 0x78	/* thswep_has_limit_sbox */
	.byte 0x0d, 0xef, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0xc7, 0x9f, 0x6e, 0x69, 0xda, 0x97	/* t__pfx_topology_gidnid_map */
	.byte 0x0d, 0x74, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0xc7, 0x9f, 0x6e, 0x69, 0xda, 0x97	/* ttopology_gidnid_map */
	.byte 0x11, 0xef, 0x5e, 0x78, 0x5f, 0xcd, 0x69, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_skx_upi_uncore_pci_init_box */
	.byte 0x11, 0x93, 0x6b, 0x78, 0x5f, 0xcd, 0x69, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* tskx_upi_uncore_pci_init_box */
	.byte 0x10, 0xef, 0x5e, 0x78, 0xc1, 0x32, 0xae, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_skx_m2m_uncore_pci_init_box */
	.byte 0x10, 0x93, 0x6b, 0x78, 0xc1, 0x32, 0xae, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* tskx_m2m_uncore_pci_init_box */
	.byte 0x11, 0xef, 0x73, 0x6e, 0x72, 0xc1, 0x32, 0xae, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_snr_m2m_uncore_pci_init_box */
	.byte 0x10, 0x93, 0x6e, 0x72, 0xc1, 0x32, 0xae, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* tsnr_m2m_uncore_pci_init_box */
	.byte 0x0d, 0xef, 0x5e, 0x78, 0xec, 0x6d, 0x75, 0x86, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* t__pfx_skx_pmu_get_topology */
	.byte 0x0d, 0x93, 0x6b, 0x78, 0xec, 0x6d, 0x75, 0x86, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* tskx_pmu_get_topology */
	.byte 0x0d, 0xef, 0x5e, 0x78, 0x5f, 0x69, 0xc0, 0x86, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* t__pfx_skx_iio_get_topology */
	.byte 0x0d, 0x93, 0x6b, 0x78, 0x5f, 0x69, 0xc0, 0x86, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* tskx_iio_get_topology */
	.byte 0x0d, 0xef, 0x5e, 0x78, 0x5f, 0xcd, 0x69, 0x86, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* t__pfx_skx_upi_get_topology */
	.byte 0x0d, 0x93, 0x6b, 0x78, 0x5f, 0xcd, 0x69, 0x86, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* tskx_upi_get_topology */
	.byte 0x0c, 0xef, 0x5e, 0x78, 0x5f, 0xcd, 0x69, 0x5f, 0x97, 0x70, 0x8d, 0xf6, 0x7c	/* t__pfx_skx_upi_mapping_show */
	.byte 0x0c, 0x93, 0x6b, 0x78, 0x5f, 0xcd, 0x69, 0x5f, 0x97, 0x70, 0x8d, 0xf6, 0x7c	/* tskx_upi_mapping_show */
	.byte 0x0e, 0xef, 0x5e, 0x78, 0x5f, 0xcd, 0x69, 0xa7, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0xf0, 0x62	/* t__pfx_skx_upi_topology_cb */
	.byte 0x0e, 0x93, 0x6b, 0x78, 0x5f, 0xcd, 0x69, 0xa7, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0xf0, 0x62	/* tskx_upi_topology_cb */
	.byte 0x0f, 0xef, 0x73, 0xc8, 0xf0, 0x66, 0x67, 0x5f, 0x69, 0xc0, 0xa7, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* t__pfx_sad_cfg_iio_topology */
	.byte 0x0e, 0x93, 0xc8, 0xf0, 0x66, 0x67, 0x5f, 0x69, 0xc0, 0xa7, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* tsad_cfg_iio_topology */
	.byte 0x0e, 0xef, 0x73, 0x6e, 0x72, 0x5f, 0x69, 0xc0, 0x86, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* t__pfx_snr_iio_get_topology */
	.byte 0x0d, 0x93, 0x6e, 0x72, 0x5f, 0x69, 0xc0, 0x86, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* tsnr_iio_get_topology */
	.byte 0x0d, 0xef, 0xaa, 0x78, 0x5f, 0x69, 0xc0, 0x86, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* t__pfx_icx_iio_get_topology */
	.byte 0x0d, 0xdc, 0x63, 0x78, 0x5f, 0x69, 0xc0, 0x86, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* ticx_iio_get_topology */
	.byte 0x0d, 0xef, 0x73, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0x5f, 0x97	/* t__pfx_snr_uncore_mmio_map */
	.byte 0x0c, 0x93, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0x5f, 0x97	/* tsnr_uncore_mmio_map */
	.byte 0x15, 0xef, 0xaa, 0x78, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0x63, 0xe6, 0xf7, 0xf5, 0xe4, 0x6e, 0x8d, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_icx_uncore_imc_freerunning_init_box */
	.byte 0x15, 0xdc, 0x63, 0x78, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0x63, 0xe6, 0xf7, 0xf5, 0xe4, 0x6e, 0x8d, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* ticx_uncore_imc_freerunning_init_box */
	.byte 0x16, 0xef, 0x73, 0x70, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0x63, 0xe6, 0xf7, 0xf5, 0xe4, 0x6e, 0x8d, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_spr_uncore_imc_freerunning_init_box */
	.byte 0x15, 0x93, 0x70, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0x63, 0xe6, 0xf7, 0xf5, 0xe4, 0x6e, 0x8d, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* tspr_uncore_imc_freerunning_init_box */
	.byte 0x06, 0xef, 0xe5, 0x69, 0xbb, 0xf6, 0x7c	/* t__pfx_alias_show */
	.byte 0x06, 0xf4, 0x6c, 0x69, 0xbb, 0xf6, 0x7c	/* talias_show */
	.byte 0x15, 0xef, 0x73, 0x70, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0x5f, 0x6f, 0x66, 0x95, 0x38, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_spr_uncore_mmio_offs8_init_box */
	.byte 0x14, 0x93, 0x70, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0x5f, 0x6f, 0x66, 0x95, 0x38, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* tspr_uncore_mmio_offs8_init_box */
	.byte 0x0b, 0xef, 0x73, 0x70, 0x72, 0x25, 0x61, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_spr_cha_hw_config */
	.byte 0x0a, 0x93, 0x70, 0x72, 0x25, 0x61, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* tspr_cha_hw_config */
	.byte 0x09, 0xef, 0x96, 0xd5, 0xfc, 0x67, 0xe2, 0x96, 0x6f, 0x29	/* t__pfx_uncore_get_uncores */
	.byte 0x09, 0x74, 0x96, 0xd5, 0xfc, 0x67, 0xe2, 0x96, 0x6f, 0x29	/* tuncore_get_uncores */
	.byte 0x0d, 0xef, 0x96, 0xd5, 0xfc, 0x74, 0x21, 0xfc, 0xd9, 0x78, 0xb8, 0x6f, 0x78, 0xd6	/* t__pfx_uncore_type_max_boxes */
	.byte 0x0d, 0x74, 0x96, 0xd5, 0xfc, 0x74, 0x21, 0xfc, 0xd9, 0x78, 0xb8, 0x6f, 0x78, 0xd6	/* tuncore_type_max_boxes */
	.byte 0x11, 0xef, 0x73, 0x6e, 0x62, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0xec, 0x1e, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* t__pfx_snbep_cbox_put_constraint */
	.byte 0x10, 0x93, 0x6e, 0x62, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0xec, 0x1e, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* tsnbep_cbox_put_constraint */
	.byte 0x10, 0xef, 0x73, 0x6e, 0x62, 0x65, 0x70, 0xec, 0x63, 0x75, 0xec, 0x1e, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* t__pfx_snbep_pcu_put_constraint */
	.byte 0x0f, 0x93, 0x6e, 0x62, 0x65, 0x70, 0xec, 0x63, 0x75, 0xec, 0x1e, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* tsnbep_pcu_put_constraint */
	.byte 0x0e, 0xef, 0x73, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x71, 0xb2, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_snbep_qpi_hw_config */
	.byte 0x0d, 0x93, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x71, 0xb2, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* tsnbep_qpi_hw_config */
	.byte 0x0a, 0xef, 0xaa, 0x78, 0x25, 0x61, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_icx_cha_hw_config */
	.byte 0x0a, 0xdc, 0x63, 0x78, 0x25, 0x61, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* ticx_cha_hw_config */
	.byte 0x0e, 0xef, 0x64, 0xca, 0x03, 0x0b, 0x5f, 0xcd, 0x69, 0xa7, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* t__pfx_discover_upi_topology */
	.byte 0x0e, 0x74, 0x64, 0xca, 0x03, 0x0b, 0x5f, 0xcd, 0x69, 0xa7, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* tdiscover_upi_topology */
	.byte 0x0d, 0xef, 0xaa, 0x78, 0x5f, 0xcd, 0x69, 0x86, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* t__pfx_icx_upi_get_topology */
	.byte 0x0d, 0xdc, 0x63, 0x78, 0x5f, 0xcd, 0x69, 0x86, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* ticx_upi_get_topology */
	.byte 0x0e, 0xef, 0x73, 0x70, 0x72, 0x5f, 0xcd, 0x69, 0x86, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* t__pfx_spr_upi_get_topology */
	.byte 0x0d, 0x93, 0x70, 0x72, 0x5f, 0xcd, 0x69, 0x86, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* tspr_upi_get_topology */
	.byte 0x12, 0xef, 0x70, 0x6d, 0x75, 0xe6, 0xf7, 0xfc, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__pfx_pmu_free_topology.part.0 */
	.byte 0x11, 0xce, 0x6d, 0x75, 0xe6, 0xf7, 0xfc, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* tpmu_free_topology.part.0 */
	.byte 0x0c, 0xef, 0x70, 0x6d, 0x75, 0xf0, 0xc4, 0xd2, 0xcd, 0x5f, 0x97, 0x70, 0x8d	/* t__pfx_pmu_cleanup_mapping */
	.byte 0x0b, 0xce, 0x6d, 0x75, 0xf0, 0xc4, 0xd2, 0xcd, 0x5f, 0x97, 0x70, 0x8d	/* tpmu_cleanup_mapping */
	.byte 0x0e, 0xef, 0x5e, 0x78, 0x5f, 0x69, 0xc0, 0xf0, 0xc4, 0xd2, 0xcd, 0x5f, 0x97, 0x70, 0x8d	/* t__pfx_skx_iio_cleanup_mapping */
	.byte 0x0e, 0x93, 0x6b, 0x78, 0x5f, 0x69, 0xc0, 0xf0, 0xc4, 0xd2, 0xcd, 0x5f, 0x97, 0x70, 0x8d	/* tskx_iio_cleanup_mapping */
	.byte 0x0e, 0xef, 0x5e, 0x78, 0x5f, 0xcd, 0x69, 0xf0, 0xc4, 0xd2, 0xcd, 0x5f, 0x97, 0x70, 0x8d	/* t__pfx_skx_upi_cleanup_mapping */
	.byte 0x0e, 0x93, 0x6b, 0x78, 0x5f, 0xcd, 0x69, 0xf0, 0xc4, 0xd2, 0xcd, 0x5f, 0x97, 0x70, 0x8d	/* tskx_upi_cleanup_mapping */
	.byte 0x0f, 0xef, 0x73, 0x6e, 0x72, 0x5f, 0x69, 0xc0, 0xf0, 0xc4, 0xd2, 0xcd, 0x5f, 0x97, 0x70, 0x8d	/* t__pfx_snr_iio_cleanup_mapping */
	.byte 0x0e, 0x93, 0x6e, 0x72, 0x5f, 0x69, 0xc0, 0xf0, 0xc4, 0xd2, 0xcd, 0x5f, 0x97, 0x70, 0x8d	/* tsnr_iio_cleanup_mapping */
	.byte 0x0e, 0xef, 0xaa, 0x78, 0x5f, 0x69, 0xc0, 0xf0, 0xc4, 0xd2, 0xcd, 0x5f, 0x97, 0x70, 0x8d	/* t__pfx_icx_iio_cleanup_mapping */
	.byte 0x0e, 0xdc, 0x63, 0x78, 0x5f, 0x69, 0xc0, 0xf0, 0xc4, 0xd2, 0xcd, 0x5f, 0x97, 0x70, 0x8d	/* ticx_iio_cleanup_mapping */
	.byte 0x0e, 0xef, 0xaa, 0x78, 0x5f, 0xcd, 0x69, 0xf0, 0xc4, 0xd2, 0xcd, 0x5f, 0x97, 0x70, 0x8d	/* t__pfx_icx_upi_cleanup_mapping */
	.byte 0x0e, 0xdc, 0x63, 0x78, 0x5f, 0xcd, 0x69, 0xf0, 0xc4, 0xd2, 0xcd, 0x5f, 0x97, 0x70, 0x8d	/* ticx_upi_cleanup_mapping */
	.byte 0x0f, 0xef, 0x73, 0x70, 0x72, 0x5f, 0xcd, 0x69, 0xf0, 0xc4, 0xd2, 0xcd, 0x5f, 0x97, 0x70, 0x8d	/* t__pfx_spr_upi_cleanup_mapping */
	.byte 0x0e, 0x93, 0x70, 0x72, 0x5f, 0xcd, 0x69, 0xf0, 0xc4, 0xd2, 0xcd, 0x5f, 0x97, 0x70, 0x8d	/* tspr_upi_cleanup_mapping */
	.byte 0x10, 0xef, 0x73, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_snr_uncore_mmio_enable_event */
	.byte 0x0f, 0x93, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tsnr_uncore_mmio_enable_event */
	.byte 0x10, 0xef, 0x73, 0x70, 0x72, 0x5f, 0xcb, 0xf3, 0x61, 0xb8, 0x6f, 0x78, 0xd6, 0xf0, 0xc4, 0xd2, 0xcd	/* t__pfx_spr_extra_boxes_cleanup */
	.byte 0x0f, 0x93, 0x70, 0x72, 0x5f, 0xcb, 0xf3, 0x61, 0xb8, 0x6f, 0x78, 0xd6, 0xf0, 0xc4, 0xd2, 0xcd	/* tspr_extra_boxes_cleanup */
	.byte 0x0f, 0xef, 0xaa, 0x78, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0xc9, 0xf8, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_icx_uncore_imc_init_box */
	.byte 0x0f, 0xdc, 0x63, 0x78, 0x5f, 0x96, 0xd5, 0xfc, 0x69, 0x6d, 0xc9, 0xf8, 0x9d, 0x62, 0x6f, 0x78	/* ticx_uncore_imc_init_box */
	.byte 0x0c, 0xef, 0x5e, 0x78, 0x5f, 0x69, 0xc0, 0x5f, 0x97, 0x70, 0x8d, 0xf6, 0x7c	/* t__pfx_skx_iio_mapping_show */
	.byte 0x0c, 0x93, 0x6b, 0x78, 0x5f, 0x69, 0xc0, 0x5f, 0x97, 0x70, 0x8d, 0xf6, 0x7c	/* tskx_iio_mapping_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0xe8, 0xba, 0x5f, 0xbe, 0x63, 0xf6, 0x7c	/* t__pfx___uncore_match_opc_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x6d, 0xe8, 0xba, 0x5f, 0xbe, 0x63, 0xf6, 0x7c	/* t__uncore_match_opc_show */
	.byte 0x0c, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xdc, 0xda, 0xf1, 0x32, 0xf6, 0x7c	/* t__pfx___uncore_tid_en2_show */
	.byte 0x0b, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xdc, 0xda, 0xf1, 0x32, 0xf6, 0x7c	/* t__uncore_tid_en2_show */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xdd, 0x63, 0xe5, 0xf6, 0x7c	/* t__pfx___uncore_filter_local_show */
	.byte 0x0e, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0x5f, 0xdd, 0x63, 0xe5, 0xf6, 0x7c	/* t__uncore_filter_local_show */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xbd, 0x6e, 0x6d, 0xf6, 0x7c	/* t__pfx___uncore_filter_nnm_show */
	.byte 0x0d, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xa5, 0x6c, 0xa2, 0xbd, 0x6e, 0x6d, 0xf6, 0x7c	/* t__uncore_filter_nnm_show */
	.byte 0x10, 0xef, 0x73, 0x70, 0x72, 0x5f, 0xcd, 0x64, 0x91, 0xb5, 0xaa, 0xfc, 0xdd, 0x63, 0xe8, 0x69, 0xe7	/* t__pfx_spr_update_device_location */
	.byte 0x0f, 0x93, 0x70, 0x72, 0x5f, 0xcd, 0x64, 0x91, 0xb5, 0xaa, 0xfc, 0xdd, 0x63, 0xe8, 0x69, 0xe7	/* tspr_update_device_location */
	.byte 0x0f, 0xef, 0x73, 0x6e, 0x62, 0x65, 0x70, 0xec, 0x63, 0x75, 0x86, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* t__pfx_snbep_pcu_get_constraint */
	.byte 0x0e, 0x93, 0x6e, 0x62, 0x65, 0x70, 0xec, 0x63, 0x75, 0x86, 0x40, 0x73, 0xf3, 0x61, 0xb3	/* tsnbep_pcu_get_constraint */
	.byte 0x10, 0xef, 0x73, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_snr_uncore_mmio_init_box */
	.byte 0x0f, 0x93, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* tsnr_uncore_mmio_init_box */
	.byte 0x0f, 0xef, 0x73, 0x6e, 0x62, 0x65, 0x70, 0xec, 0x9b, 0x32, 0x70, 0x68, 0x1d, 0x97, 0xbf, 0xea	/* t__pfx_snbep_pci2phy_map_init */
	.byte 0x0e, 0x93, 0x6e, 0x62, 0x65, 0x70, 0xec, 0x9b, 0x32, 0x70, 0x68, 0x1d, 0x97, 0xbf, 0xea	/* tsnbep_pci2phy_map_init */
	.byte 0x11, 0xef, 0x70, 0x6d, 0x75, 0x5f, 0x69, 0xc0, 0x5f, 0x97, 0x70, 0x8d, 0x5f, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_pmu_iio_mapping_visible */
	.byte 0x10, 0xce, 0x6d, 0x75, 0x5f, 0x69, 0xc0, 0x5f, 0x97, 0x70, 0x8d, 0x5f, 0x76, 0xca, 0x69, 0x62, 0xc4	/* tpmu_iio_mapping_visible */
	.byte 0x10, 0xef, 0x5e, 0x78, 0x5f, 0x69, 0xc0, 0x5f, 0x97, 0x70, 0x8d, 0x5f, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_skx_iio_mapping_visible */
	.byte 0x10, 0x93, 0x6b, 0x78, 0x5f, 0x69, 0xc0, 0x5f, 0x97, 0x70, 0x8d, 0x5f, 0x76, 0xca, 0x69, 0x62, 0xc4	/* tskx_iio_mapping_visible */
	.byte 0x11, 0xef, 0x73, 0x6e, 0x72, 0x5f, 0x69, 0xc0, 0x5f, 0x97, 0x70, 0x8d, 0x5f, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_snr_iio_mapping_visible */
	.byte 0x10, 0x93, 0x6e, 0x72, 0x5f, 0x69, 0xc0, 0x5f, 0x97, 0x70, 0x8d, 0x5f, 0x76, 0xca, 0x69, 0x62, 0xc4	/* tsnr_iio_mapping_visible */
	.byte 0x10, 0xef, 0xaa, 0x78, 0x5f, 0x69, 0xc0, 0x5f, 0x97, 0x70, 0x8d, 0x5f, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_icx_iio_mapping_visible */
	.byte 0x10, 0xdc, 0x63, 0x78, 0x5f, 0x69, 0xc0, 0x5f, 0x97, 0x70, 0x8d, 0x5f, 0x76, 0xca, 0x69, 0x62, 0xc4	/* ticx_iio_mapping_visible */
	.byte 0x11, 0xef, 0x73, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_snr_uncore_mmio_disable_event */
	.byte 0x10, 0x93, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* tsnr_uncore_mmio_disable_event */
	.byte 0x13, 0xef, 0x73, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* t__pfx_snbep_uncore_msr_enable_box */
	.byte 0x12, 0x93, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* tsnbep_uncore_msr_enable_box */
	.byte 0x0b, 0xef, 0x6b, 0x6e, 0x6c, 0x25, 0x61, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_knl_cha_hw_config */
	.byte 0x0b, 0x74, 0x6b, 0x6e, 0x6c, 0x25, 0x61, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* tknl_cha_hw_config */
	.byte 0x0f, 0xef, 0x73, 0x6e, 0x62, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_snbep_cbox_hw_config */
	.byte 0x0e, 0x93, 0x6e, 0x62, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* tsnbep_cbox_hw_config */
	.byte 0x0a, 0xef, 0x5e, 0x78, 0x25, 0x61, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* t__pfx_skx_cha_hw_config */
	.byte 0x0a, 0x93, 0x6b, 0x78, 0x25, 0x61, 0xa3, 0x77, 0x3e, 0xa5, 0x67	/* tskx_cha_hw_config */
	.byte 0x13, 0xef, 0x73, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_snbep_uncore_msr_disable_event */
	.byte 0x12, 0x93, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* tsnbep_uncore_msr_disable_event */
	.byte 0x0b, 0xef, 0x5e, 0x78, 0x5f, 0x69, 0xc0, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_skx_iio_enable_event */
	.byte 0x0b, 0x93, 0x6b, 0x78, 0x5f, 0x69, 0xc0, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tskx_iio_enable_event */
	.byte 0x11, 0xef, 0x73, 0x70, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_spr_uncore_msr_disable_event */
	.byte 0x10, 0x93, 0x70, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* tspr_uncore_msr_disable_event */
	.byte 0x12, 0xef, 0x69, 0x76, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_ivbep_uncore_msr_init_box */
	.byte 0x11, 0xdc, 0x76, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* tivbep_uncore_msr_init_box */
	.byte 0x12, 0xef, 0x73, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_snbep_uncore_msr_init_box */
	.byte 0x11, 0x93, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* tsnbep_uncore_msr_init_box */
	.byte 0x10, 0xef, 0x73, 0x70, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_spr_uncore_msr_enable_event */
	.byte 0x0f, 0x93, 0x70, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tspr_uncore_msr_enable_event */
	.byte 0x0b, 0xef, 0x73, 0x6e, 0x72, 0x25, 0x61, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_snr_cha_enable_event */
	.byte 0x0a, 0x93, 0x6e, 0x72, 0x25, 0x61, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tsnr_cha_enable_event */
	.byte 0x12, 0xef, 0x73, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_snbep_uncore_msr_enable_event */
	.byte 0x11, 0x93, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tsnbep_uncore_msr_enable_event */
	.byte 0x16, 0xef, 0x68, 0x73, 0x77, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x73, 0x62, 0x6f, 0x78, 0xc1, 0x73, 0x72, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* t__pfx_hswep_uncore_sbox_msr_init_box */
	.byte 0x16, 0x74, 0x68, 0x73, 0x77, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x73, 0x62, 0x6f, 0x78, 0xc1, 0x73, 0x72, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* thswep_uncore_sbox_msr_init_box */
	.byte 0x0f, 0xef, 0x69, 0x76, 0x62, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_ivbep_cbox_enable_event */
	.byte 0x0e, 0xdc, 0x76, 0x62, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tivbep_cbox_enable_event */
	.byte 0x0f, 0xef, 0x68, 0x73, 0x77, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_hswep_cbox_enable_event */
	.byte 0x0f, 0x74, 0x68, 0x73, 0x77, 0x65, 0x70, 0xf0, 0x62, 0x6f, 0x78, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* thswep_cbox_enable_event */
	.byte 0x14, 0xef, 0x73, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* t__pfx_snbep_uncore_msr_disable_box */
	.byte 0x13, 0x93, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* tsnbep_uncore_msr_disable_box */
	.byte 0x08, 0xef, 0x70, 0x6d, 0x75, 0x84, 0x97, 0x70, 0x8d	/* t__pfx_pmu_set_mapping */
	.byte 0x07, 0xce, 0x6d, 0x75, 0x84, 0x97, 0x70, 0x8d	/* tpmu_set_mapping */
	.byte 0x0a, 0xef, 0x5e, 0x78, 0x5f, 0x69, 0xc0, 0x84, 0x97, 0x70, 0x8d	/* t__pfx_skx_iio_set_mapping */
	.byte 0x0a, 0x93, 0x6b, 0x78, 0x5f, 0x69, 0xc0, 0x84, 0x97, 0x70, 0x8d	/* tskx_iio_set_mapping */
	.byte 0x0b, 0xef, 0x73, 0x6e, 0x72, 0x5f, 0x69, 0xc0, 0x84, 0x97, 0x70, 0x8d	/* t__pfx_snr_iio_set_mapping */
	.byte 0x0a, 0x93, 0x6e, 0x72, 0x5f, 0x69, 0xc0, 0x84, 0x97, 0x70, 0x8d	/* tsnr_iio_set_mapping */
	.byte 0x0a, 0xef, 0xaa, 0x78, 0x5f, 0x69, 0xc0, 0x84, 0x97, 0x70, 0x8d	/* t__pfx_icx_iio_set_mapping */
	.byte 0x0a, 0xdc, 0x63, 0x78, 0x5f, 0x69, 0xc0, 0x84, 0x97, 0x70, 0x8d	/* ticx_iio_set_mapping */
	.byte 0x0a, 0xef, 0x5e, 0x78, 0x5f, 0xcd, 0x69, 0x84, 0x97, 0x70, 0x8d	/* t__pfx_skx_upi_set_mapping */
	.byte 0x0a, 0x93, 0x6b, 0x78, 0x5f, 0xcd, 0x69, 0x84, 0x97, 0x70, 0x8d	/* tskx_upi_set_mapping */
	.byte 0x0a, 0xef, 0xaa, 0x78, 0x5f, 0xcd, 0x69, 0x84, 0x97, 0x70, 0x8d	/* t__pfx_icx_upi_set_mapping */
	.byte 0x0a, 0xdc, 0x63, 0x78, 0x5f, 0xcd, 0x69, 0x84, 0x97, 0x70, 0x8d	/* ticx_upi_set_mapping */
	.byte 0x0b, 0xef, 0x73, 0x70, 0x72, 0x5f, 0xcd, 0x69, 0x84, 0x97, 0x70, 0x8d	/* t__pfx_spr_upi_set_mapping */
	.byte 0x0a, 0x93, 0x70, 0x72, 0x5f, 0xcd, 0x69, 0x84, 0x97, 0x70, 0x8d	/* tspr_upi_set_mapping */
	.byte 0x0e, 0xeb, 0x73, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* T__pfx_snbep_uncore_cpu_init */
	.byte 0x0e, 0x54, 0x73, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* Tsnbep_uncore_cpu_init */
	.byte 0x0e, 0xeb, 0x73, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* T__pfx_snbep_uncore_pci_init */
	.byte 0x0e, 0x54, 0x73, 0x6e, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* Tsnbep_uncore_pci_init */
	.byte 0x0e, 0xeb, 0x69, 0x76, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* T__pfx_ivbep_uncore_cpu_init */
	.byte 0x0e, 0x54, 0x69, 0x76, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* Tivbep_uncore_cpu_init */
	.byte 0x0e, 0xeb, 0x69, 0x76, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* T__pfx_ivbep_uncore_pci_init */
	.byte 0x0e, 0x54, 0x69, 0x76, 0x62, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* Tivbep_uncore_pci_init */
	.byte 0x0c, 0xeb, 0x6b, 0x6e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* T__pfx_knl_uncore_cpu_init */
	.byte 0x0c, 0x54, 0x6b, 0x6e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* Tknl_uncore_cpu_init */
	.byte 0x0c, 0xeb, 0x6b, 0x6e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* T__pfx_knl_uncore_pci_init */
	.byte 0x0c, 0x54, 0x6b, 0x6e, 0x6c, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* Tknl_uncore_pci_init */
	.byte 0x0e, 0xeb, 0x68, 0x73, 0x77, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* T__pfx_hswep_uncore_cpu_init */
	.byte 0x0e, 0x54, 0x68, 0x73, 0x77, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* Thswep_uncore_cpu_init */
	.byte 0x0e, 0xeb, 0x68, 0x73, 0x77, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* T__pfx_hswep_uncore_pci_init */
	.byte 0x0e, 0x54, 0x68, 0x73, 0x77, 0x65, 0x70, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* Thswep_uncore_pci_init */
	.byte 0x0c, 0xeb, 0x62, 0x64, 0x78, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* T__pfx_bdx_uncore_cpu_init */
	.byte 0x0c, 0x54, 0x62, 0x64, 0x78, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* Tbdx_uncore_cpu_init */
	.byte 0x0c, 0xeb, 0x62, 0x64, 0x78, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* T__pfx_bdx_uncore_pci_init */
	.byte 0x0c, 0x54, 0x62, 0x64, 0x78, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* Tbdx_uncore_pci_init */
	.byte 0x0b, 0xeb, 0x5e, 0x78, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* T__pfx_skx_uncore_cpu_init */
	.byte 0x0b, 0x54, 0x5e, 0x78, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* Tskx_uncore_cpu_init */
	.byte 0x0b, 0xeb, 0x5e, 0x78, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* T__pfx_skx_uncore_pci_init */
	.byte 0x0b, 0x54, 0x5e, 0x78, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* Tskx_uncore_pci_init */
	.byte 0x0c, 0xeb, 0x73, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* T__pfx_snr_uncore_cpu_init */
	.byte 0x0c, 0x54, 0x73, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* Tsnr_uncore_cpu_init */
	.byte 0x0c, 0xeb, 0x73, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* T__pfx_snr_uncore_pci_init */
	.byte 0x0c, 0x54, 0x73, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* Tsnr_uncore_pci_init */
	.byte 0x0d, 0xeb, 0x73, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xbf, 0xea	/* T__pfx_snr_uncore_mmio_init */
	.byte 0x0d, 0x54, 0x73, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xbf, 0xea	/* Tsnr_uncore_mmio_init */
	.byte 0x0b, 0xeb, 0xaa, 0x78, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* T__pfx_icx_uncore_cpu_init */
	.byte 0x0b, 0x54, 0xaa, 0x78, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* Ticx_uncore_cpu_init */
	.byte 0x0b, 0xeb, 0xaa, 0x78, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* T__pfx_icx_uncore_pci_init */
	.byte 0x0b, 0x54, 0xaa, 0x78, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* Ticx_uncore_pci_init */
	.byte 0x0c, 0xeb, 0xaa, 0x78, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xbf, 0xea	/* T__pfx_icx_uncore_mmio_init */
	.byte 0x0c, 0x54, 0xaa, 0x78, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xbf, 0xea	/* Ticx_uncore_mmio_init */
	.byte 0x0c, 0xeb, 0x73, 0x70, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* T__pfx_spr_uncore_cpu_init */
	.byte 0x0c, 0x54, 0x73, 0x70, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* Tspr_uncore_cpu_init */
	.byte 0x0c, 0xeb, 0x73, 0x70, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* T__pfx_spr_uncore_pci_init */
	.byte 0x0c, 0x54, 0x73, 0x70, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* Tspr_uncore_pci_init */
	.byte 0x0d, 0xeb, 0x73, 0x70, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xbf, 0xea	/* T__pfx_spr_uncore_mmio_init */
	.byte 0x0d, 0x54, 0x73, 0x70, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xbf, 0xea	/* Tspr_uncore_mmio_init */
	.byte 0x0c, 0xeb, 0x67, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* T__pfx_gnr_uncore_cpu_init */
	.byte 0x0c, 0x54, 0x67, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* Tgnr_uncore_cpu_init */
	.byte 0x0c, 0xeb, 0x67, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* T__pfx_gnr_uncore_pci_init */
	.byte 0x0c, 0x54, 0x67, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* Tgnr_uncore_pci_init */
	.byte 0x0d, 0xeb, 0x67, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xbf, 0xea	/* T__pfx_gnr_uncore_mmio_init */
	.byte 0x0d, 0x54, 0x67, 0x6e, 0x72, 0x5f, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xbf, 0xea	/* Tgnr_uncore_mmio_init */
	.byte 0x14, 0xeb, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* T__pfx_intel_generic_uncore_mmio_disable_box */
	.byte 0x14, 0x54, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* Tintel_generic_uncore_mmio_disable_box */
	.byte 0x13, 0xeb, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* T__pfx_intel_generic_uncore_mmio_enable_box */
	.byte 0x13, 0x54, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* Tintel_generic_uncore_mmio_enable_box */
	.byte 0x12, 0xeb, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* T__pfx_intel_generic_uncore_mmio_enable_event */
	.byte 0x12, 0x54, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* Tintel_generic_uncore_mmio_enable_event */
	.byte 0x13, 0xeb, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* T__pfx_intel_generic_uncore_mmio_disable_event */
	.byte 0x13, 0x54, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* Tintel_generic_uncore_mmio_disable_event */
	.byte 0x10, 0xef, 0x9a, 0x5f, 0x96, 0xd5, 0xfc, 0x66, 0xf8, 0x64, 0xed, 0xca, 0x03, 0x0b, 0x1d, 0xe4, 0xea	/* t__pfx_intel_uncore_find_discovery_unit */
	.byte 0x10, 0x74, 0x9a, 0x5f, 0x96, 0xd5, 0xfc, 0x66, 0xf8, 0x64, 0xed, 0xca, 0x03, 0x0b, 0x1d, 0xe4, 0xea	/* tintel_uncore_find_discovery_unit */
	.byte 0x11, 0xeb, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xde, 0xc8, 0x3a, 0xe4, 0xa2	/* T__pfx_intel_generic_uncore_pci_read_counter */
	.byte 0x11, 0x54, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xde, 0xc8, 0x3a, 0xe4, 0xa2	/* Tintel_generic_uncore_pci_read_counter */
	.byte 0x12, 0xeb, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* T__pfx_intel_generic_uncore_mmio_init_box */
	.byte 0x12, 0x54, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* Tintel_generic_uncore_mmio_init_box */
	.byte 0x12, 0xef, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_intel_generic_uncore_msr_enable_event */
	.byte 0x12, 0x74, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tintel_generic_uncore_msr_enable_event */
	.byte 0x12, 0xeb, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* T__pfx_intel_generic_uncore_pci_disable_event */
	.byte 0x12, 0x54, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* Tintel_generic_uncore_pci_disable_event */
	.byte 0x11, 0xef, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_intel_generic_uncore_pci_enable_event */
	.byte 0x11, 0x74, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tintel_generic_uncore_pci_enable_event */
	.byte 0x0c, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x74, 0x68, 0x29, 0x68, 0xf6, 0x7c	/* t__pfx___uncore_thresh_show */
	.byte 0x0b, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x74, 0x68, 0x29, 0x68, 0xf6, 0x7c	/* t__uncore_thresh_show */
	.byte 0x0a, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xf8, 0x76, 0xf6, 0x7c	/* t__pfx___uncore_inv_show */
	.byte 0x09, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xf8, 0x76, 0xf6, 0x7c	/* t__uncore_inv_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x9e, 0x67, 0xfc, 0x73, 0x7c	/* t__pfx___uncore_edge_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x9e, 0x67, 0xfc, 0x73, 0x7c	/* t__uncore_edge_show */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0x75, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx___uncore_umask_show */
	.byte 0x0a, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0x75, 0xd9, 0x5e, 0xf6, 0x7c	/* t__uncore_umask_show */
	.byte 0x09, 0x74, 0xaf, 0x5f, 0x96, 0xd5, 0xfc, 0xcc, 0x73, 0x7c	/* t__pfx___uncore_event_show */
	.byte 0x08, 0x74, 0xff, 0x96, 0xd5, 0xfc, 0xcc, 0x73, 0x7c	/* t__uncore_event_show */
	.byte 0x0f, 0xef, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x62, 0x6f, 0x78, 0xf0, 0x23	/* t__pfx_intel_generic_uncore_box_ctl */
	.byte 0x0f, 0x74, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x62, 0x6f, 0x78, 0xf0, 0x23	/* tintel_generic_uncore_box_ctl */
	.byte 0x11, 0xeb, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* T__pfx_intel_generic_uncore_pci_init_box */
	.byte 0x11, 0x54, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* Tintel_generic_uncore_pci_init_box */
	.byte 0x13, 0xeb, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* T__pfx_intel_generic_uncore_pci_disable_box */
	.byte 0x13, 0x54, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* Tintel_generic_uncore_pci_disable_box */
	.byte 0x12, 0xeb, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* T__pfx_intel_generic_uncore_pci_enable_box */
	.byte 0x12, 0x54, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* Tintel_generic_uncore_pci_enable_box */
	.byte 0x13, 0xef, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_intel_generic_uncore_msr_disable_event */
	.byte 0x13, 0x74, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* tintel_generic_uncore_msr_disable_event */
	.byte 0x12, 0xeb, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* T__pfx_intel_generic_uncore_msr_init_box */
	.byte 0x12, 0x54, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xbf, 0x9d, 0x62, 0x6f, 0x78	/* Tintel_generic_uncore_msr_init_box */
	.byte 0x14, 0xeb, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* T__pfx_intel_generic_uncore_msr_disable_box */
	.byte 0x14, 0x54, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0xed, 0xca, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* Tintel_generic_uncore_msr_disable_box */
	.byte 0x13, 0xeb, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* T__pfx_intel_generic_uncore_msr_enable_box */
	.byte 0x13, 0x54, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x6d, 0x73, 0x72, 0x0d, 0x90, 0xb0, 0x62, 0x6f, 0x78	/* Tintel_generic_uncore_msr_enable_box */
	.byte 0x11, 0xeb, 0x9a, 0x5f, 0x96, 0xd5, 0xfc, 0x66, 0xf8, 0x64, 0xed, 0xca, 0x03, 0x0b, 0x1d, 0xe4, 0x9d, 0x9f	/* T__pfx_intel_uncore_find_discovery_unit_id */
	.byte 0x11, 0x54, 0x9a, 0x5f, 0x96, 0xd5, 0xfc, 0x66, 0xf8, 0x64, 0xed, 0xca, 0x03, 0x0b, 0x1d, 0xe4, 0x9d, 0x9f	/* Tintel_uncore_find_discovery_unit_id */
	.byte 0x0b, 0xeb, 0x96, 0xd5, 0xfc, 0x66, 0xf8, 0xda, 0xc8, 0xda, 0xe4, 0xea	/* T__pfx_uncore_find_add_unit */
	.byte 0x0b, 0x54, 0x96, 0xd5, 0xfc, 0x66, 0xf8, 0xda, 0xc8, 0xda, 0xe4, 0xea	/* Tuncore_find_add_unit */
	.byte 0x10, 0xeb, 0x9a, 0x5f, 0x96, 0xd5, 0xfc, 0x68, 0xbb, 0xed, 0xca, 0x03, 0x0b, 0x1d, 0xe0, 0x6c, 0xd6	/* T__pfx_intel_uncore_has_discovery_tables */
	.byte 0x10, 0x54, 0x9a, 0x5f, 0x96, 0xd5, 0xfc, 0x68, 0xbb, 0xed, 0xca, 0x03, 0x0b, 0x1d, 0xe0, 0x6c, 0xd6	/* Tintel_uncore_has_discovery_tables */
	.byte 0x11, 0xeb, 0x9a, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0xc4, 0xc5, 0xed, 0xca, 0x03, 0x0b, 0x1d, 0xe0, 0x6c, 0xd6	/* T__pfx_intel_uncore_clear_discovery_tables */
	.byte 0x11, 0x54, 0x9a, 0x5f, 0x96, 0xd5, 0xfc, 0x63, 0xc4, 0xc5, 0xed, 0xca, 0x03, 0x0b, 0x1d, 0xe0, 0x6c, 0xd6	/* Tintel_uncore_clear_discovery_tables */
	.byte 0x12, 0xeb, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0xbb, 0x85, 0x67, 0x6e, 0xa3, 0x8f, 0xd7, 0x74	/* T__pfx_intel_generic_uncore_assign_hw_event */
	.byte 0x12, 0x54, 0x9a, 0xc7, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0xbb, 0x85, 0x67, 0x6e, 0xa3, 0x8f, 0xd7, 0x74	/* Tintel_generic_uncore_assign_hw_event */
	.byte 0x10, 0xeb, 0x9a, 0x5f, 0x96, 0xd5, 0xfc, 0x67, 0xf1, 0xf5, 0x69, 0xc9, 0xf8, 0x9d, 0x96, 0x6f, 0x29	/* T__pfx_intel_uncore_generic_init_uncores */
	.byte 0x10, 0x54, 0x9a, 0x5f, 0x96, 0xd5, 0xfc, 0x67, 0xf1, 0xf5, 0x69, 0xc9, 0xf8, 0x9d, 0x96, 0x6f, 0x29	/* Tintel_uncore_generic_init_uncores */
	.byte 0x12, 0xeb, 0x9a, 0x5f, 0x96, 0xd5, 0xfc, 0x67, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* T__pfx_intel_uncore_generic_uncore_cpu_init */
	.byte 0x12, 0x54, 0x9a, 0x5f, 0x96, 0xd5, 0xfc, 0x67, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* Tintel_uncore_generic_uncore_cpu_init */
	.byte 0x12, 0xeb, 0x9a, 0x5f, 0x96, 0xd5, 0xfc, 0x67, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* T__pfx_intel_uncore_generic_uncore_pci_init */
	.byte 0x12, 0x54, 0x9a, 0x5f, 0x96, 0xd5, 0xfc, 0x67, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x70, 0x9b, 0xbf, 0xea	/* Tintel_uncore_generic_uncore_pci_init */
	.byte 0x13, 0xeb, 0x9a, 0x5f, 0x96, 0xd5, 0xfc, 0x67, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xbf, 0xea	/* T__pfx_intel_uncore_generic_uncore_mmio_init */
	.byte 0x13, 0x54, 0x9a, 0x5f, 0x96, 0xd5, 0xfc, 0x67, 0xf1, 0xf5, 0x69, 0xc9, 0x96, 0xd5, 0xfc, 0x6d, 0x6d, 0xc0, 0xbf, 0xea	/* Tintel_uncore_generic_uncore_mmio_init */
	.byte 0x0b, 0xef, 0x63, 0x3d, 0x74, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0x0f	/* t__pfx_cstate_pmu_event_init */
	.byte 0x0a, 0x26, 0x3d, 0x74, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0x0f	/* tcstate_pmu_event_init */
	.byte 0x07, 0xef, 0x74, 0xd6, 0xfe, 0x6d, 0x73, 0x72	/* t__pfx_test_msr */
	.byte 0x07, 0x74, 0x74, 0xd6, 0xfe, 0x6d, 0x73, 0x72	/* ttest_msr */
	.byte 0x0d, 0x74, 0xaf, 0xf0, 0x3d, 0x74, 0xfc, 0x63, 0x3d, 0x74, 0xfc, 0xcc, 0x73, 0x7c	/* t__pfx___cstate_cstate_event_show */
	.byte 0x0d, 0x74, 0xff, 0x63, 0x3d, 0x74, 0xfc, 0x63, 0x3d, 0x74, 0xfc, 0xcc, 0x73, 0x7c	/* t__cstate_cstate_event_show */
	.byte 0x0c, 0xef, 0x63, 0x3d, 0x74, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0xc8, 0x64	/* t__pfx_cstate_pmu_event_add */
	.byte 0x0b, 0x26, 0x3d, 0x74, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0xc8, 0x64	/* tcstate_pmu_event_add */
	.byte 0x0d, 0xef, 0x63, 0x3d, 0x74, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0x3d, 0x72, 0x74	/* t__pfx_cstate_pmu_event_start */
	.byte 0x0c, 0x26, 0x3d, 0x74, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0x3d, 0x72, 0x74	/* tcstate_pmu_event_start */
	.byte 0x0c, 0xef, 0x63, 0x3d, 0x74, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0x64, 0xdb	/* t__pfx_cstate_pmu_event_del */
	.byte 0x0b, 0x26, 0x3d, 0x74, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0x64, 0xdb	/* tcstate_pmu_event_del */
	.byte 0x0d, 0xef, 0x63, 0x3d, 0x74, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0x73, 0x74, 0xbe	/* t__pfx_cstate_pmu_event_stop */
	.byte 0x0c, 0x26, 0x3d, 0x74, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0x73, 0x74, 0xbe	/* tcstate_pmu_event_stop */
	.byte 0x0d, 0xef, 0x63, 0x3d, 0x74, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0xcd, 0x64, 0x14	/* t__pfx_cstate_pmu_event_update */
	.byte 0x0c, 0x26, 0x3d, 0x74, 0xfc, 0x70, 0x6d, 0x75, 0x5f, 0xcc, 0xcd, 0x64, 0x14	/* tcstate_pmu_event_update */
	.byte 0x0d, 0xef, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf8, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x97	/* t__pfx_zhaoxin_pmu_event_map */
	.byte 0x0d, 0x74, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf8, 0xec, 0x6d, 0x75, 0x5f, 0xcc, 0x97	/* tzhaoxin_pmu_event_map */
	.byte 0x0f, 0xef, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf8, 0x86, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* t__pfx_zhaoxin_get_event_constraints */
	.byte 0x0f, 0x74, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf8, 0x86, 0xcc, 0x40, 0x73, 0xf3, 0x61, 0xb3, 0x73	/* tzhaoxin_get_event_constraints */
	.byte 0x0e, 0xef, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf8, 0x5f, 0xcc, 0xe1, 0x73, 0x95, 0xf6, 0x7c	/* t__pfx_zhaoxin_event_sysfs_show */
	.byte 0x0e, 0x74, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf8, 0x5f, 0xcc, 0xe1, 0x73, 0x95, 0xf6, 0x7c	/* tzhaoxin_event_sysfs_show */
	.byte 0x06, 0xef, 0x63, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx_cmask_show */
	.byte 0x05, 0x26, 0xd9, 0x5e, 0xf6, 0x7c	/* tcmask_show */
	.byte 0x05, 0xef, 0xf8, 0x76, 0xf6, 0x7c	/* t__pfx_inv_show */
	.byte 0x05, 0x74, 0xf8, 0x76, 0xf6, 0x7c	/* tinv_show */
	.byte 0x06, 0xef, 0x9e, 0x67, 0xfc, 0x73, 0x7c	/* t__pfx_edge_show */
	.byte 0x06, 0x74, 0x9e, 0x67, 0xfc, 0x73, 0x7c	/* tedge_show */
	.byte 0x06, 0xef, 0x75, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx_umask_show */
	.byte 0x06, 0x74, 0x75, 0xd9, 0x5e, 0xf6, 0x7c	/* tumask_show */
	.byte 0x04, 0xef, 0xcc, 0x73, 0x7c	/* t__pfx_event_show */
	.byte 0x04, 0x74, 0xcc, 0x73, 0x7c	/* tevent_show */
	.byte 0x0f, 0xef, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf8, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0x5d	/* t__pfx_zhaoxin_pmu_disable_all */
	.byte 0x0f, 0x74, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf8, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0x5d	/* tzhaoxin_pmu_disable_all */
	.byte 0x0e, 0xef, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf8, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x5d	/* t__pfx_zhaoxin_pmu_enable_all */
	.byte 0x0e, 0x74, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf8, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0x5d	/* tzhaoxin_pmu_enable_all */
	.byte 0x0f, 0xef, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf8, 0xec, 0x6d, 0x75, 0xa3, 0x05, 0xb0, 0xab, 0x71	/* t__pfx_zhaoxin_pmu_handle_irq */
	.byte 0x0f, 0x74, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf8, 0xec, 0x6d, 0x75, 0xa3, 0x05, 0xb0, 0xab, 0x71	/* tzhaoxin_pmu_handle_irq */
	.byte 0x0f, 0xef, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf8, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_zhaoxin_pmu_enable_event */
	.byte 0x0f, 0x74, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf8, 0xec, 0x6d, 0x75, 0x0d, 0x90, 0xb0, 0xd7, 0x74	/* tzhaoxin_pmu_enable_event */
	.byte 0x10, 0xef, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf8, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* t__pfx_zhaoxin_pmu_disable_event */
	.byte 0x10, 0x74, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf8, 0xec, 0x6d, 0x75, 0xed, 0xca, 0x90, 0xb0, 0xd7, 0x74	/* tzhaoxin_pmu_disable_event */
	.byte 0x0e, 0xeb, 0xdd, 0x61, 0xda, 0xf3, 0x61, 0xb6, 0xa0, 0xf8, 0xfc, 0x70, 0x67, 0xe0, 0xc4	/* T__pfx_load_trampoline_pgtable */
	.byte 0x0e, 0x54, 0xdd, 0x61, 0xda, 0xf3, 0x61, 0xb6, 0xa0, 0xf8, 0xfc, 0x70, 0x67, 0xe0, 0xc4	/* Tload_trampoline_pgtable */
	.byte 0x0e, 0x54, 0x73, 0xb4, 0xe7, 0x64, 0xc5, 0x79, 0xa9, 0x72, 0x74, 0xcd, 0x5f, 0x36, 0x34	/* Tsecondary_startup_64 */
	.byte 0x15, 0x54, 0x73, 0xb4, 0xe7, 0x64, 0xc5, 0x79, 0xa9, 0x72, 0x74, 0xcd, 0x5f, 0x36, 0x34, 0xbd, 0x6f, 0x5f, 0x0b, 0x69, 0x66, 0x79	/* Tsecondary_startup_64_no_verify */
	.byte 0x0c, 0x26, 0x6f, 0x6d, 0x6d, 0xe7, 0xa9, 0x72, 0x74, 0xcd, 0x5f, 0x36, 0x34	/* tcommon_startup_64 */
	.byte 0x07, 0xef, 0x0b, 0x69, 0x66, 0x79, 0xf0, 0x9c	/* t__pfx_verify_cpu */
	.byte 0x07, 0x74, 0x0b, 0x69, 0x66, 0x79, 0xf0, 0x9c	/* tverify_cpu */
	.byte 0x0b, 0xeb, 0x73, 0xee, 0x5f, 0x0b, 0x69, 0x66, 0x79, 0xf0, 0x62, 0xea	/* T__pfx_sev_verify_cbit */
	.byte 0x0b, 0x54, 0x73, 0xee, 0x5f, 0x0b, 0x69, 0x66, 0x79, 0xf0, 0x62, 0xea	/* Tsev_verify_cbit */
	.byte 0x16, 0xef, 0x73, 0xd2, 0xea, 0x69, 0x7a, 0xfc, 0x62, 0x6f, 0x6f, 0xfe, 0x70, 0xc5, 0x2a, 0x73, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__pfx_sanitize_boot_params.constprop.0 */
	.byte 0x15, 0x93, 0xd2, 0xea, 0x69, 0x7a, 0xfc, 0x62, 0x6f, 0x6f, 0xfe, 0x70, 0xc5, 0x2a, 0x73, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* tsanitize_boot_params.constprop.0 */
	.byte 0x0b, 0xeb, 0x65, 0xc5, 0x6c, 0x79, 0xf6, 0xd4, 0xcd, 0x5f, 0x9f, 0x74	/* T__pfx_early_setup_idt */
	.byte 0x0b, 0x54, 0x65, 0xc5, 0x6c, 0x79, 0xf6, 0xd4, 0xcd, 0x5f, 0x9f, 0x74	/* Tearly_setup_idt */
	.byte 0x0d, 0xeb, 0x73, 0xe2, 0x19, 0x73, 0xe7, 0xe5, 0xea, 0x1d, 0x69, 0x61, 0x33, 0x32	/* T__pfx_set_personality_ia32 */
	.byte 0x0d, 0x54, 0x73, 0xe2, 0x19, 0x73, 0xe7, 0xe5, 0xea, 0x1d, 0x69, 0x61, 0x33, 0x32	/* Tset_personality_ia32 */
	.byte 0x13, 0xef, 0x3d, 0x72, 0xfe, 0x74, 0x68, 0xf7, 0xc8, 0x3a, 0x6d, 0x6d, 0xe7, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__pfx_start_thread_common.constprop.0 */
	.byte 0x13, 0x93, 0xf4, 0x72, 0xfe, 0x74, 0x68, 0xf7, 0xc8, 0x3a, 0x6d, 0x6d, 0xe7, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* tstart_thread_common.constprop.0 */
	.byte 0x08, 0xeb, 0x3d, 0x72, 0xfe, 0x74, 0x68, 0xf7, 0xc8	/* T__pfx_start_thread */
	.byte 0x08, 0x54, 0x3d, 0x72, 0xfe, 0x74, 0x68, 0xf7, 0xc8	/* Tstart_thread */
	.byte 0x06, 0x99, 0xf6, 0x7c, 0xde, 0x67, 0x73	/* T__pfx___show_regs */
	.byte 0x06, 0xb9, 0x73, 0x7c, 0xde, 0x67, 0x73	/* T__show_regs */
	.byte 0x09, 0xeb, 0xf7, 0xc4, 0xbb, 0xfc, 0x74, 0x68, 0xf7, 0xc8	/* T__pfx_release_thread */
	.byte 0x09, 0x54, 0xf7, 0xc4, 0xbb, 0xfc, 0x74, 0x68, 0xf7, 0xc8	/* Trelease_thread */
	.byte 0x0c, 0xeb, 0x63, 0x98, 0xf7, 0x6e, 0xfe, 0x73, 0x61, 0x1a, 0x95, 0x67, 0x73	/* T__pfx_current_save_fsgs */
	.byte 0x0c, 0x54, 0x63, 0x98, 0xf7, 0x6e, 0xfe, 0x73, 0x61, 0x1a, 0x95, 0x67, 0x73	/* Tcurrent_save_fsgs */
	.byte 0x10, 0xeb, 0x78, 0x38, 0x36, 0xe6, 0x73, 0x67, 0x73, 0x62, 0xbb, 0xfc, 0xf7, 0x61, 0xda, 0xf4, 0x5e	/* T__pfx_x86_fsgsbase_read_task */
	.byte 0x10, 0x54, 0x78, 0x38, 0x36, 0xe6, 0x73, 0x67, 0x73, 0x62, 0xbb, 0xfc, 0xf7, 0x61, 0xda, 0xf4, 0x5e	/* Tx86_fsgsbase_read_task */
	.byte 0x12, 0xeb, 0x78, 0x38, 0x36, 0xc7, 0x73, 0x62, 0xbb, 0xfc, 0xf7, 0xc8, 0xf0, 0x9c, 0xbf, 0xf2, 0xdc, 0x76, 0x65	/* T__pfx_x86_gsbase_read_cpu_inactive */
	.byte 0x12, 0x54, 0x78, 0x38, 0x36, 0xc7, 0x73, 0x62, 0xbb, 0xfc, 0xf7, 0xc8, 0xf0, 0x9c, 0xbf, 0xf2, 0xdc, 0x76, 0x65	/* Tx86_gsbase_read_cpu_inactive */
	.byte 0x13, 0xeb, 0x78, 0x38, 0x36, 0xc7, 0x73, 0x62, 0xbb, 0xfc, 0x77, 0x3c, 0xfc, 0x63, 0x9c, 0xbf, 0xf2, 0xdc, 0x76, 0x65	/* T__pfx_x86_gsbase_write_cpu_inactive */
	.byte 0x13, 0x54, 0x78, 0x38, 0x36, 0xc7, 0x73, 0x62, 0xbb, 0xfc, 0x77, 0x3c, 0xfc, 0x63, 0x9c, 0xbf, 0xf2, 0xdc, 0x76, 0x65	/* Tx86_gsbase_write_cpu_inactive */
	.byte 0x0e, 0xeb, 0x78, 0x38, 0x36, 0xe6, 0x73, 0x62, 0xbb, 0xfc, 0xf7, 0x61, 0xda, 0xf4, 0x5e	/* T__pfx_x86_fsbase_read_task */
	.byte 0x0e, 0x54, 0x78, 0x38, 0x36, 0xe6, 0x73, 0x62, 0xbb, 0xfc, 0xf7, 0x61, 0xda, 0xf4, 0x5e	/* Tx86_fsbase_read_task */
	.byte 0x0e, 0xeb, 0x78, 0x38, 0x36, 0xc7, 0x73, 0x62, 0xbb, 0xfc, 0xf7, 0x61, 0xda, 0xf4, 0x5e	/* T__pfx_x86_gsbase_read_task */
	.byte 0x0e, 0x54, 0x78, 0x38, 0x36, 0xc7, 0x73, 0x62, 0xbb, 0xfc, 0xf7, 0x61, 0xda, 0xf4, 0x5e	/* Tx86_gsbase_read_task */
	.byte 0x0e, 0xeb, 0x78, 0x38, 0x36, 0xe6, 0x73, 0x62, 0xbb, 0xfc, 0x77, 0x3c, 0xfc, 0xf4, 0x5e	/* T__pfx_x86_fsbase_write_task */
	.byte 0x0e, 0x54, 0x78, 0x38, 0x36, 0xe6, 0x73, 0x62, 0xbb, 0xfc, 0x77, 0x3c, 0xfc, 0xf4, 0x5e	/* Tx86_fsbase_write_task */
	.byte 0x0e, 0xeb, 0x78, 0x38, 0x36, 0xc7, 0x73, 0x62, 0xbb, 0xfc, 0x77, 0x3c, 0xfc, 0xf4, 0x5e	/* T__pfx_x86_gsbase_write_task */
	.byte 0x0e, 0x54, 0x78, 0x38, 0x36, 0xc7, 0x73, 0x62, 0xbb, 0xfc, 0x77, 0x3c, 0xfc, 0xf4, 0x5e	/* Tx86_gsbase_write_task */
	.byte 0x0c, 0xeb, 0x03, 0xb6, 0x61, 0xfe, 0x3d, 0x72, 0xfe, 0x74, 0x68, 0xf7, 0xc8	/* T__pfx_compat_start_thread */
	.byte 0x0c, 0x54, 0x03, 0xb6, 0x61, 0xfe, 0x3d, 0x72, 0xfe, 0x74, 0x68, 0xf7, 0xc8	/* Tcompat_start_thread */
	.byte 0x07, 0x99, 0xf6, 0x77, 0xea, 0xba, 0xa7, 0x6f	/* T__pfx___switch_to */
	.byte 0x07, 0xb9, 0x73, 0x77, 0xea, 0xba, 0xa7, 0x6f	/* T__switch_to */
	.byte 0x0d, 0xeb, 0x73, 0xe2, 0x19, 0x73, 0xe7, 0xe5, 0xea, 0x1d, 0x36, 0x34, 0x62, 0xea	/* T__pfx_set_personality_64bit */
	.byte 0x0d, 0x54, 0x73, 0xe2, 0x19, 0x73, 0xe7, 0xe5, 0xea, 0x1d, 0x36, 0x34, 0x62, 0xea	/* Tset_personality_64bit */
	.byte 0x0d, 0xeb, 0x64, 0x6f, 0x5f, 0xc5, 0xba, 0xec, 0x72, 0x63, 0x23, 0x5f, 0x36, 0x34	/* T__pfx_do_arch_prctl_64 */
	.byte 0x0d, 0x54, 0x64, 0x6f, 0x5f, 0xc5, 0xba, 0xec, 0x72, 0x63, 0x23, 0x5f, 0x36, 0x34	/* Tdo_arch_prctl_64 */
	.byte 0x0c, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xc5, 0xba, 0xec, 0x72, 0x63, 0x23	/* T__pfx___x64_sys_arch_prctl */
	.byte 0x0c, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xc5, 0xba, 0xec, 0x72, 0x63, 0x23	/* T__x64_sys_arch_prctl */
	.byte 0x0d, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xc5, 0xba, 0xec, 0x72, 0x63, 0x23	/* T__pfx___ia32_sys_arch_prctl */
	.byte 0x0d, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xc5, 0xba, 0xec, 0x72, 0x63, 0x23	/* T__ia32_sys_arch_prctl */
	.byte 0x11, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0xc5, 0xba, 0xec, 0x72, 0x63, 0x23	/* T__pfx___ia32_compat_sys_arch_prctl */
	.byte 0x11, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0xc5, 0xba, 0xec, 0x72, 0x63, 0x23	/* T__ia32_compat_sys_arch_prctl */
	.byte 0x08, 0xeb, 0x4b, 0x04, 0x4b, 0x5f, 0x45, 0x53, 0x50	/* T__pfx_KSTK_ESP */
	.byte 0x08, 0x54, 0x4b, 0x04, 0x4b, 0x5f, 0x45, 0x53, 0x50	/* TKSTK_ESP */
	.byte 0x08, 0xeb, 0x67, 0xe2, 0x85, 0x67, 0x66, 0xbc, 0xa8	/* T__pfx_get_sigframe */
	.byte 0x08, 0x54, 0x67, 0xe2, 0x85, 0x67, 0x66, 0xbc, 0xa8	/* Tget_sigframe */
	.byte 0x0c, 0xeb, 0x67, 0xe2, 0x85, 0x67, 0x66, 0xbc, 0x6d, 0xfc, 0x85, 0x7a, 0x65	/* T__pfx_get_sigframe_size */
	.byte 0x0c, 0x54, 0x67, 0xe2, 0x85, 0x67, 0x66, 0xbc, 0x6d, 0xfc, 0x85, 0x7a, 0x65	/* Tget_sigframe_size */
	.byte 0x0f, 0xeb, 0xc5, 0xba, 0xed, 0x6f, 0xf6, 0x0c, 0x6e, 0xe5, 0x5f, 0xd5, 0xde, 0x3d, 0x72, 0x74	/* T__pfx_arch_do_signal_or_restart */
	.byte 0x0f, 0x54, 0xc5, 0xba, 0xed, 0x6f, 0xf6, 0x0c, 0x6e, 0xe5, 0x5f, 0xd5, 0xde, 0x3d, 0x72, 0x74	/* Tarch_do_signal_or_restart */
	.byte 0x09, 0xeb, 0x85, 0x67, 0x6e, 0xe5, 0xe6, 0x61, 0x02, 0x74	/* T__pfx_signal_fault */
	.byte 0x09, 0x54, 0x85, 0x67, 0x6e, 0xe5, 0xe6, 0x61, 0x02, 0x74	/* Tsignal_fault */
	.byte 0x0e, 0xeb, 0x85, 0x67, 0xe5, 0x93, 0xf4, 0xc6, 0xf6, 0x69, 0x7a, 0xfc, 0x76, 0xe5, 0x9f	/* T__pfx_sigaltstack_size_valid */
	.byte 0x0e, 0x54, 0x85, 0x67, 0xe5, 0x93, 0xf4, 0xc6, 0xf6, 0x69, 0x7a, 0xfc, 0x76, 0xe5, 0x9f	/* Tsigaltstack_size_valid */
	.byte 0x0a, 0xef, 0x29, 0x74, 0xd5, 0xfc, 0x85, 0x67, 0x40, 0x74, 0x8e	/* t__pfx_restore_sigcontext */
	.byte 0x0a, 0x74, 0x29, 0x74, 0xd5, 0xfc, 0x85, 0x67, 0x40, 0x74, 0x8e	/* trestore_sigcontext */
	.byte 0x0c, 0xeb, 0x78, 0x36, 0x34, 0xf6, 0xd4, 0xcd, 0xa6, 0xfe, 0x66, 0xbc, 0xa8	/* T__pfx_x64_setup_rt_frame */
	.byte 0x0c, 0x54, 0x78, 0x36, 0x34, 0xf6, 0xd4, 0xcd, 0xa6, 0xfe, 0x66, 0xbc, 0xa8	/* Tx64_setup_rt_frame */
	.byte 0x0e, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xf7, 0x74, 0x98, 0x6e	/* t__pfx___do_sys_rt_sigreturn */
	.byte 0x0f, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xf7, 0x74, 0x98, 0x6e	/* T__pfx___ia32_sys_rt_sigreturn */
	.byte 0x0e, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xf7, 0x74, 0x98, 0x6e	/* T__pfx___x64_sys_rt_sigreturn */
	.byte 0x0e, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xf7, 0x74, 0x98, 0x6e	/* t__do_sys_rt_sigreturn */
	.byte 0x0f, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xf7, 0x74, 0x98, 0x6e	/* T__ia32_sys_rt_sigreturn */
	.byte 0x0e, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xf7, 0x74, 0x98, 0x6e	/* T__x64_sys_rt_sigreturn */
	.byte 0x0c, 0xeb, 0x85, 0x67, 0xf2, 0xdc, 0xe7, 0x3a, 0xb6, 0x61, 0xfe, 0x90, 0x69	/* T__pfx_sigaction_compat_abi */
	.byte 0x0c, 0x54, 0x85, 0x67, 0xf2, 0xdc, 0xe7, 0x3a, 0xb6, 0x61, 0xfe, 0x90, 0x69	/* Tsigaction_compat_abi */
	.byte 0x0e, 0xef, 0x67, 0xe2, 0x6b, 0xf5, 0x6e, 0xdb, 0xc7, 0x70, 0x5f, 0xc8, 0x64, 0x29, 0x73	/* t__pfx_get_kernel_gp_address */
	.byte 0x0e, 0x74, 0x67, 0xe2, 0x6b, 0xf5, 0x6e, 0xdb, 0xc7, 0x70, 0x5f, 0xc8, 0x64, 0x29, 0x73	/* tget_kernel_gp_address */
	.byte 0x08, 0xef, 0x6d, 0xe8, 0x68, 0x5f, 0xf5, 0xe3, 0x72	/* t__pfx_math_error */
	.byte 0x08, 0x74, 0x6d, 0xe8, 0x68, 0x5f, 0xf5, 0xe3, 0x72	/* tmath_error */
	.byte 0x07, 0xef, 0x73, 0x7c, 0xf6, 0x0c, 0x6e, 0xe5	/* t__pfx_show_signal */
	.byte 0x06, 0x93, 0x7c, 0xf6, 0x0c, 0x6e, 0xe5	/* tshow_signal */
	.byte 0x07, 0xef, 0x64, 0x6f, 0x5f, 0xf3, 0x61, 0x70	/* t__pfx_do_trap */
	.byte 0x07, 0x74, 0x64, 0x6f, 0x5f, 0xf3, 0x61, 0x70	/* tdo_trap */
	.byte 0x0b, 0xef, 0x64, 0x6f, 0x5f, 0xf5, 0xe3, 0x72, 0x5f, 0xf3, 0x61, 0x70	/* t__pfx_do_error_trap */
	.byte 0x0b, 0x74, 0x64, 0x6f, 0x5f, 0xf5, 0xe3, 0x72, 0x5f, 0xf3, 0x61, 0x70	/* tdo_error_trap */
	.byte 0x06, 0xef, 0x64, 0x6f, 0xbf, 0x74, 0x33	/* t__pfx_do_int3 */
	.byte 0x06, 0x74, 0x64, 0x6f, 0xbf, 0x74, 0x33	/* tdo_int3 */
	.byte 0x0b, 0xeb, 0x69, 0xe9, 0x76, 0xe5, 0x69, 0xda, 0x06, 0x67, 0xc8, 0xac	/* T__pfx_is_valid_bugaddr */
	.byte 0x0b, 0x54, 0x69, 0xe9, 0x76, 0xe5, 0x69, 0xda, 0x06, 0x67, 0xc8, 0xac	/* Tis_valid_bugaddr */
	.byte 0x06, 0xeb, 0x64, 0xb4, 0x16, 0x06, 0x67	/* T__pfx_decode_bug */
	.byte 0x06, 0x54, 0x64, 0xb4, 0x16, 0x06, 0x67	/* Tdecode_bug */
	.byte 0x0c, 0xeb, 0x68, 0x05, 0xb0, 0x3d, 0xc6, 0x5f, 0x6f, 0x0b, 0x66, 0xdd, 0x77	/* T__pfx_handle_stack_overflow */
	.byte 0x0c, 0x54, 0x68, 0x05, 0xb0, 0x3d, 0xc6, 0x5f, 0x6f, 0x0b, 0x66, 0xdd, 0x77	/* Thandle_stack_overflow */
	.byte 0x0a, 0xeb, 0xdd, 0xc8, 0xf0, 0x98, 0xf7, 0x6e, 0xfe, 0x9f, 0x74	/* T__pfx_load_current_idt */
	.byte 0x0a, 0x54, 0xdd, 0xc8, 0xf0, 0x98, 0xf7, 0x6e, 0xfe, 0x9f, 0x74	/* Tload_current_idt */
	.byte 0x08, 0xeb, 0x9f, 0xfe, 0xf8, 0x76, 0xe5, 0x9f, 0x14	/* T__pfx_idt_invalidate */
	.byte 0x08, 0x54, 0x9f, 0xfe, 0xf8, 0x76, 0xe5, 0x9f, 0x14	/* Tidt_invalidate */
	.byte 0x0c, 0x08, 0x18, 0x5f, 0xdd, 0x63, 0xe5, 0x5f, 0x00, 0xf5, 0x0d, 0xf3, 0x79	/* T__pfx___traceiter_local_timer_entry */
	.byte 0x0c, 0xb9, 0x18, 0x5f, 0xdd, 0x63, 0xe5, 0x5f, 0x00, 0xf5, 0x0d, 0xf3, 0x79	/* T__traceiter_local_timer_entry */
	.byte 0x0d, 0x99, 0xec, 0x10, 0x5f, 0xdd, 0x63, 0xe5, 0x5f, 0x00, 0xf5, 0x0d, 0xf3, 0x79	/* T__pfx___probestub_local_timer_entry */
	.byte 0x0d, 0x54, 0xfd, 0x10, 0x5f, 0xdd, 0x63, 0xe5, 0x5f, 0x00, 0xf5, 0x0d, 0xf3, 0x79	/* T__probestub_local_timer_entry */
	.byte 0x0c, 0x08, 0x18, 0x5f, 0xdd, 0x63, 0xe5, 0x5f, 0x00, 0xf5, 0x5f, 0xcb, 0xea	/* T__pfx___traceiter_local_timer_exit */
	.byte 0x0c, 0xb9, 0x18, 0x5f, 0xdd, 0x63, 0xe5, 0x5f, 0x00, 0xf5, 0x5f, 0xcb, 0xea	/* T__traceiter_local_timer_exit */
	.byte 0x0e, 0x08, 0x18, 0xf6, 0x9c, 0x72, 0xc0, 0x75, 0xe9, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x79	/* T__pfx___traceiter_spurious_apic_entry */
	.byte 0x0e, 0xb9, 0x18, 0xf6, 0x9c, 0x72, 0xc0, 0x75, 0xe9, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x79	/* T__traceiter_spurious_apic_entry */
	.byte 0x0d, 0x08, 0x18, 0xf6, 0x9c, 0x72, 0xc0, 0x75, 0xe9, 0x61, 0xb2, 0xc9, 0xcb, 0xea	/* T__pfx___traceiter_spurious_apic_exit */
	.byte 0x0d, 0xb9, 0x18, 0xf6, 0x9c, 0x72, 0xc0, 0x75, 0xe9, 0x61, 0xb2, 0xc9, 0xcb, 0xea	/* T__traceiter_spurious_apic_exit */
	.byte 0x0d, 0x08, 0x18, 0x5f, 0xf5, 0xe3, 0x72, 0x5f, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x79	/* T__pfx___traceiter_error_apic_entry */
	.byte 0x0d, 0xb9, 0x18, 0x5f, 0xf5, 0xe3, 0x72, 0x5f, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x79	/* T__traceiter_error_apic_entry */
	.byte 0x0c, 0x08, 0x18, 0x5f, 0xf5, 0xe3, 0x72, 0x5f, 0x61, 0xb2, 0xc9, 0xcb, 0xea	/* T__pfx___traceiter_error_apic_exit */
	.byte 0x0c, 0xb9, 0x18, 0x5f, 0xf5, 0xe3, 0x72, 0x5f, 0x61, 0xb2, 0xc9, 0xcb, 0xea	/* T__traceiter_error_apic_exit */
	.byte 0x11, 0x08, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xec, 0x6c, 0xe8, 0x66, 0xd5, 0xae, 0x69, 0xb2, 0x0d, 0xf3, 0x79	/* T__pfx___traceiter_x86_platform_ipi_entry */
	.byte 0x11, 0xb9, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xec, 0x6c, 0xe8, 0x66, 0xd5, 0xae, 0x69, 0xb2, 0x0d, 0xf3, 0x79	/* T__traceiter_x86_platform_ipi_entry */
	.byte 0x11, 0x08, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xec, 0x6c, 0xe8, 0x66, 0xd5, 0xae, 0x69, 0xb2, 0x5f, 0xcb, 0xea	/* T__pfx___traceiter_x86_platform_ipi_exit */
	.byte 0x11, 0xb9, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xec, 0x6c, 0xe8, 0x66, 0xd5, 0xae, 0x69, 0xb2, 0x5f, 0xcb, 0xea	/* T__traceiter_x86_platform_ipi_exit */
	.byte 0x0b, 0x08, 0x18, 0x5f, 0xab, 0x71, 0x92, 0xd5, 0x6b, 0x0d, 0xf3, 0x79	/* T__pfx___traceiter_irq_work_entry */
	.byte 0x0b, 0xb9, 0x18, 0x5f, 0xab, 0x71, 0x92, 0xd5, 0x6b, 0x0d, 0xf3, 0x79	/* T__traceiter_irq_work_entry */
	.byte 0x0b, 0x08, 0x18, 0x5f, 0xab, 0x71, 0x92, 0xd5, 0x6b, 0x5f, 0xcb, 0xea	/* T__pfx___traceiter_irq_work_exit */
	.byte 0x0b, 0xb9, 0x18, 0x5f, 0xab, 0x71, 0x92, 0xd5, 0x6b, 0x5f, 0xcb, 0xea	/* T__traceiter_irq_work_exit */
	.byte 0x0a, 0x08, 0x18, 0x07, 0xba, 0x9e, 0x75, 0xb0, 0xf1, 0xf3, 0x79	/* T__pfx___traceiter_reschedule_entry */
	.byte 0x0a, 0xb9, 0x18, 0x07, 0xba, 0x9e, 0x75, 0xb0, 0xf1, 0xf3, 0x79	/* T__traceiter_reschedule_entry */
	.byte 0x09, 0x08, 0x18, 0x07, 0xba, 0x9e, 0x75, 0xb0, 0xcb, 0xea	/* T__pfx___traceiter_reschedule_exit */
	.byte 0x09, 0xb9, 0x18, 0x07, 0xba, 0x9e, 0x75, 0xb0, 0xcb, 0xea	/* T__traceiter_reschedule_exit */
	.byte 0x0b, 0x08, 0x18, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7, 0x0d, 0xf3, 0x79	/* T__pfx___traceiter_call_function_entry */
	.byte 0x0b, 0xb9, 0x18, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7, 0x0d, 0xf3, 0x79	/* T__traceiter_call_function_entry */
	.byte 0x0b, 0x08, 0x18, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7, 0x5f, 0xcb, 0xea	/* T__pfx___traceiter_call_function_exit */
	.byte 0x0b, 0xb9, 0x18, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7, 0x5f, 0xcb, 0xea	/* T__traceiter_call_function_exit */
	.byte 0x0e, 0x08, 0x18, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7, 0xf6, 0x8d, 0xb0, 0xf1, 0xf3, 0x79	/* T__pfx___traceiter_call_function_single_entry */
	.byte 0x0e, 0xb9, 0x18, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7, 0xf6, 0x8d, 0xb0, 0xf1, 0xf3, 0x79	/* T__traceiter_call_function_single_entry */
	.byte 0x0d, 0x08, 0x18, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7, 0xf6, 0x8d, 0xb0, 0xcb, 0xea	/* T__pfx___traceiter_call_function_single_exit */
	.byte 0x0d, 0xb9, 0x18, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7, 0xf6, 0x8d, 0xb0, 0xcb, 0xea	/* T__traceiter_call_function_single_exit */
	.byte 0x0e, 0x08, 0x18, 0xa7, 0x68, 0x29, 0x68, 0xa0, 0xda, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x79	/* T__pfx___traceiter_threshold_apic_entry */
	.byte 0x0e, 0xb9, 0x18, 0xa7, 0x68, 0x29, 0x68, 0xa0, 0xda, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x79	/* T__traceiter_threshold_apic_entry */
	.byte 0x0d, 0x08, 0x18, 0xa7, 0x68, 0x29, 0x68, 0xa0, 0xda, 0x61, 0xb2, 0xc9, 0xcb, 0xea	/* T__pfx___traceiter_threshold_apic_exit */
	.byte 0x0d, 0xb9, 0x18, 0xa7, 0x68, 0x29, 0x68, 0xa0, 0xda, 0x61, 0xb2, 0xc9, 0xcb, 0xea	/* T__traceiter_threshold_apic_exit */
	.byte 0x12, 0x08, 0x18, 0xed, 0x65, 0x66, 0xf5, 0xf7, 0xda, 0xf5, 0xe3, 0x72, 0x5f, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x79	/* T__pfx___traceiter_deferred_error_apic_entry */
	.byte 0x12, 0xb9, 0x18, 0xed, 0x65, 0x66, 0xf5, 0xf7, 0xda, 0xf5, 0xe3, 0x72, 0x5f, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x79	/* T__traceiter_deferred_error_apic_entry */
	.byte 0x11, 0x08, 0x18, 0xed, 0x65, 0x66, 0xf5, 0xf7, 0xda, 0xf5, 0xe3, 0x72, 0x5f, 0x61, 0xb2, 0xc9, 0xcb, 0xea	/* T__pfx___traceiter_deferred_error_apic_exit */
	.byte 0x11, 0xb9, 0x18, 0xed, 0x65, 0x66, 0xf5, 0xf7, 0xda, 0xf5, 0xe3, 0x72, 0x5f, 0x61, 0xb2, 0xc9, 0xcb, 0xea	/* T__traceiter_deferred_error_apic_exit */
	.byte 0x0e, 0x08, 0x18, 0xa7, 0x68, 0xf5, 0x6d, 0xe5, 0x5f, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x79	/* T__pfx___traceiter_thermal_apic_entry */
	.byte 0x0e, 0xb9, 0x18, 0xa7, 0x68, 0xf5, 0x6d, 0xe5, 0x5f, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x79	/* T__traceiter_thermal_apic_entry */
	.byte 0x0d, 0x08, 0x18, 0xa7, 0x68, 0xf5, 0x6d, 0xe5, 0x5f, 0x61, 0xb2, 0xc9, 0xcb, 0xea	/* T__pfx___traceiter_thermal_apic_exit */
	.byte 0x0d, 0xb9, 0x18, 0xa7, 0x68, 0xf5, 0x6d, 0xe5, 0x5f, 0x61, 0xb2, 0xc9, 0xcb, 0xea	/* T__traceiter_thermal_apic_exit */
	.byte 0x0a, 0x08, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x3e, 0xa5, 0x67	/* T__pfx___traceiter_vector_config */
	.byte 0x0a, 0xb9, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x3e, 0xa5, 0x67	/* T__traceiter_vector_config */
	.byte 0x0b, 0x99, 0xec, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x3e, 0xa5, 0x67	/* T__pfx___probestub_vector_config */
	.byte 0x0b, 0x54, 0xfd, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x3e, 0xa5, 0x67	/* T__probestub_vector_config */
	.byte 0x0b, 0x08, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xcd, 0x64, 0x14	/* T__pfx___traceiter_vector_update */
	.byte 0x0b, 0xb9, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xcd, 0x64, 0x14	/* T__traceiter_vector_update */
	.byte 0x0c, 0x99, 0xec, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xcd, 0x64, 0x14	/* T__pfx___probestub_vector_update */
	.byte 0x0c, 0x54, 0xfd, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xcd, 0x64, 0x14	/* T__probestub_vector_update */
	.byte 0x0a, 0x08, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xf0, 0xc4, 0xc5	/* T__pfx___traceiter_vector_clear */
	.byte 0x0a, 0xb9, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xf0, 0xc4, 0xc5	/* T__traceiter_vector_clear */
	.byte 0x0e, 0x08, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x07, 0xf5, 0x1a, 0xd9, 0x6e, 0x83, 0x9e	/* T__pfx___traceiter_vector_reserve_managed */
	.byte 0x0e, 0xb9, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x07, 0xf5, 0x1a, 0xd9, 0x6e, 0x83, 0x9e	/* T__traceiter_vector_reserve_managed */
	.byte 0x0f, 0x99, 0xec, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x07, 0xf5, 0x1a, 0xd9, 0x6e, 0x83, 0x9e	/* T__pfx___probestub_vector_reserve_managed */
	.byte 0x0f, 0x54, 0xfd, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x07, 0xf5, 0x1a, 0xd9, 0x6e, 0x83, 0x9e	/* T__probestub_vector_reserve_managed */
	.byte 0x0b, 0x08, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x07, 0xf5, 0x76, 0x65	/* T__pfx___traceiter_vector_reserve */
	.byte 0x0b, 0xb9, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x07, 0xf5, 0x76, 0x65	/* T__traceiter_vector_reserve */
	.byte 0x0a, 0x08, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0x22, 0x63	/* T__pfx___traceiter_vector_alloc */
	.byte 0x0a, 0xb9, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0x22, 0x63	/* T__traceiter_vector_alloc */
	.byte 0x0b, 0x99, 0xec, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0x22, 0x63	/* T__pfx___probestub_vector_alloc */
	.byte 0x0b, 0x54, 0xfd, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0x22, 0x63	/* T__probestub_vector_alloc */
	.byte 0x0e, 0x08, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0x22, 0xc9, 0xd9, 0x6e, 0x83, 0x9e	/* T__pfx___traceiter_vector_alloc_managed */
	.byte 0x0e, 0xb9, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0x22, 0xc9, 0xd9, 0x6e, 0x83, 0x9e	/* T__traceiter_vector_alloc_managed */
	.byte 0x0f, 0x99, 0xec, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0x22, 0xc9, 0xd9, 0x6e, 0x83, 0x9e	/* T__pfx___probestub_vector_alloc_managed */
	.byte 0x0f, 0x54, 0xfd, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0x22, 0xc9, 0xd9, 0x6e, 0x83, 0x9e	/* T__probestub_vector_alloc_managed */
	.byte 0x0c, 0x08, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xf2, 0xdc, 0x76, 0x14	/* T__pfx___traceiter_vector_activate */
	.byte 0x0c, 0xb9, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xf2, 0xdc, 0x76, 0x14	/* T__traceiter_vector_activate */
	.byte 0x0d, 0x99, 0xec, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xf2, 0xdc, 0x76, 0x14	/* T__pfx___probestub_vector_activate */
	.byte 0x0d, 0x54, 0xfd, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xf2, 0xdc, 0x76, 0x14	/* T__probestub_vector_activate */
	.byte 0x0d, 0x08, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xed, 0x65, 0xf2, 0xdc, 0x76, 0x14	/* T__pfx___traceiter_vector_deactivate */
	.byte 0x0d, 0xb9, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xed, 0x65, 0xf2, 0xdc, 0x76, 0x14	/* T__traceiter_vector_deactivate */
	.byte 0x0d, 0x08, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xa7, 0x65, 0xc5, 0x64, 0xad, 0x6e	/* T__pfx___traceiter_vector_teardown */
	.byte 0x0d, 0xb9, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xa7, 0x65, 0xc5, 0x64, 0xad, 0x6e	/* T__traceiter_vector_teardown */
	.byte 0x0e, 0x99, 0xec, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xa7, 0x65, 0xc5, 0x64, 0xad, 0x6e	/* T__pfx___probestub_vector_teardown */
	.byte 0x0e, 0x54, 0xfd, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xa7, 0x65, 0xc5, 0x64, 0xad, 0x6e	/* T__probestub_vector_teardown */
	.byte 0x0a, 0x08, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xf6, 0xd4, 0xcd	/* T__pfx___traceiter_vector_setup */
	.byte 0x0a, 0xb9, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xf6, 0xd4, 0xcd	/* T__traceiter_vector_setup */
	.byte 0x0b, 0x99, 0xec, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xf6, 0xd4, 0xcd	/* T__pfx___probestub_vector_setup */
	.byte 0x0b, 0x54, 0xfd, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xf6, 0xd4, 0xcd	/* T__probestub_vector_setup */
	.byte 0x0d, 0x08, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xe6, 0xf7, 0xfc, 0x17, 0x76, 0x9e	/* T__pfx___traceiter_vector_free_moved */
	.byte 0x0d, 0xb9, 0x18, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xe6, 0xf7, 0xfc, 0x17, 0x76, 0x9e	/* T__traceiter_vector_free_moved */
	.byte 0x0e, 0x99, 0xec, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xe6, 0xf7, 0xfc, 0x17, 0x76, 0x9e	/* T__pfx___probestub_vector_free_moved */
	.byte 0x0e, 0x54, 0xfd, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xe6, 0xf7, 0xfc, 0x17, 0x76, 0x9e	/* T__probestub_vector_free_moved */
	.byte 0x0e, 0xef, 0x19, 0x66, 0xec, 0xf5, 0xae, 0xab, 0x71, 0x92, 0xd5, 0x6b, 0x5f, 0xcb, 0xea	/* t__pfx_perf_perm_irq_work_exit */
	.byte 0x0e, 0xce, 0xf5, 0x66, 0xec, 0xf5, 0xae, 0xab, 0x71, 0x92, 0xd5, 0x6b, 0x5f, 0xcb, 0xea	/* tperf_perm_irq_work_exit */
	.byte 0x0f, 0xef, 0x19, 0x3b, 0xc3, 0x78, 0x38, 0x36, 0x5f, 0xab, 0x71, 0x5f, 0x76, 0xb4, 0x74, 0xd5	/* t__pfx_perf_trace_x86_irq_vector */
	.byte 0x0f, 0xce, 0xf5, 0x3b, 0xc3, 0x78, 0x38, 0x36, 0x5f, 0xab, 0x71, 0x5f, 0x76, 0xb4, 0x74, 0xd5	/* tperf_trace_x86_irq_vector */
	.byte 0x0b, 0xef, 0x19, 0x3b, 0xc3, 0x76, 0xb4, 0x74, 0xd5, 0x3e, 0xa5, 0x67	/* t__pfx_perf_trace_vector_config */
	.byte 0x0b, 0xce, 0xf5, 0x3b, 0xc3, 0x76, 0xb4, 0x74, 0xd5, 0x3e, 0xa5, 0x67	/* tperf_trace_vector_config */
	.byte 0x0a, 0xef, 0x19, 0x3b, 0xc3, 0x76, 0xb4, 0x74, 0xd5, 0xc1, 0xb7	/* t__pfx_perf_trace_vector_mod */
	.byte 0x0a, 0xce, 0xf5, 0x3b, 0xc3, 0x76, 0xb4, 0x74, 0xd5, 0xc1, 0xb7	/* tperf_trace_vector_mod */
	.byte 0x0c, 0xef, 0x19, 0x3b, 0xc3, 0x76, 0xb4, 0x74, 0xd5, 0x07, 0xf5, 0x76, 0x65	/* t__pfx_perf_trace_vector_reserve */
	.byte 0x0c, 0xce, 0xf5, 0x3b, 0xc3, 0x76, 0xb4, 0x74, 0xd5, 0x07, 0xf5, 0x76, 0x65	/* tperf_trace_vector_reserve */
	.byte 0x0b, 0xef, 0x19, 0x3b, 0xc3, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0x22, 0x63	/* t__pfx_perf_trace_vector_alloc */
	.byte 0x0b, 0xce, 0xf5, 0x3b, 0xc3, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0x22, 0x63	/* tperf_trace_vector_alloc */
	.byte 0x0f, 0xef, 0x19, 0x3b, 0xc3, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0x22, 0xc9, 0xd9, 0x6e, 0x83, 0x9e	/* t__pfx_perf_trace_vector_alloc_managed */
	.byte 0x0f, 0xce, 0xf5, 0x3b, 0xc3, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0x22, 0xc9, 0xd9, 0x6e, 0x83, 0x9e	/* tperf_trace_vector_alloc_managed */
	.byte 0x0d, 0xef, 0x19, 0x3b, 0xc3, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xf2, 0xdc, 0x76, 0x14	/* t__pfx_perf_trace_vector_activate */
	.byte 0x0d, 0xce, 0xf5, 0x3b, 0xc3, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xf2, 0xdc, 0x76, 0x14	/* tperf_trace_vector_activate */
	.byte 0x0e, 0xef, 0x19, 0x3b, 0xc3, 0x76, 0xb4, 0x74, 0xd5, 0xa7, 0x65, 0xc5, 0x64, 0xad, 0x6e	/* t__pfx_perf_trace_vector_teardown */
	.byte 0x0e, 0xce, 0xf5, 0x3b, 0xc3, 0x76, 0xb4, 0x74, 0xd5, 0xa7, 0x65, 0xc5, 0x64, 0xad, 0x6e	/* tperf_trace_vector_teardown */
	.byte 0x0b, 0xef, 0x19, 0x3b, 0xc3, 0x76, 0xb4, 0x74, 0xd5, 0xf6, 0xd4, 0xcd	/* t__pfx_perf_trace_vector_setup */
	.byte 0x0b, 0xce, 0xf5, 0x3b, 0xc3, 0x76, 0xb4, 0x74, 0xd5, 0xf6, 0xd4, 0xcd	/* tperf_trace_vector_setup */
	.byte 0x0e, 0xef, 0x19, 0x3b, 0xc3, 0x76, 0xb4, 0x74, 0xd5, 0xe6, 0xf7, 0xfc, 0x17, 0x76, 0x9e	/* t__pfx_perf_trace_vector_free_moved */
	.byte 0x0e, 0xce, 0xf5, 0x3b, 0xc3, 0x76, 0xb4, 0x74, 0xd5, 0xe6, 0xf7, 0xfc, 0x17, 0x76, 0x9e	/* tperf_trace_vector_free_moved */
	.byte 0x0f, 0xef, 0x7d, 0x7b, 0xcc, 0x78, 0x38, 0x36, 0x5f, 0xab, 0x71, 0x5f, 0x76, 0xb4, 0x74, 0xd5	/* t__pfx_trace_event_raw_event_x86_irq_vector */
	.byte 0x0f, 0x74, 0x7d, 0x7b, 0xcc, 0x78, 0x38, 0x36, 0x5f, 0xab, 0x71, 0x5f, 0x76, 0xb4, 0x74, 0xd5	/* ttrace_event_raw_event_x86_irq_vector */
	.byte 0x0b, 0xef, 0x7d, 0x7b, 0xcc, 0x76, 0xb4, 0x74, 0xd5, 0x3e, 0xa5, 0x67	/* t__pfx_trace_event_raw_event_vector_config */
	.byte 0x0b, 0x74, 0x7d, 0x7b, 0xcc, 0x76, 0xb4, 0x74, 0xd5, 0x3e, 0xa5, 0x67	/* ttrace_event_raw_event_vector_config */
	.byte 0x0a, 0xef, 0x7d, 0x7b, 0xcc, 0x76, 0xb4, 0x74, 0xd5, 0xc1, 0xb7	/* t__pfx_trace_event_raw_event_vector_mod */
	.byte 0x0a, 0x74, 0x7d, 0x7b, 0xcc, 0x76, 0xb4, 0x74, 0xd5, 0xc1, 0xb7	/* ttrace_event_raw_event_vector_mod */
	.byte 0x0c, 0xef, 0x7d, 0x7b, 0xcc, 0x76, 0xb4, 0x74, 0xd5, 0x07, 0xf5, 0x76, 0x65	/* t__pfx_trace_event_raw_event_vector_reserve */
	.byte 0x0c, 0x74, 0x7d, 0x7b, 0xcc, 0x76, 0xb4, 0x74, 0xd5, 0x07, 0xf5, 0x76, 0x65	/* ttrace_event_raw_event_vector_reserve */
	.byte 0x0b, 0xef, 0x7d, 0x7b, 0xcc, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0x22, 0x63	/* t__pfx_trace_event_raw_event_vector_alloc */
	.byte 0x0b, 0x74, 0x7d, 0x7b, 0xcc, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0x22, 0x63	/* ttrace_event_raw_event_vector_alloc */
	.byte 0x0f, 0xef, 0x7d, 0x7b, 0xcc, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0x22, 0xc9, 0xd9, 0x6e, 0x83, 0x9e	/* t__pfx_trace_event_raw_event_vector_alloc_managed */
	.byte 0x0f, 0x74, 0x7d, 0x7b, 0xcc, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0x22, 0xc9, 0xd9, 0x6e, 0x83, 0x9e	/* ttrace_event_raw_event_vector_alloc_managed */
	.byte 0x0d, 0xef, 0x7d, 0x7b, 0xcc, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xf2, 0xdc, 0x76, 0x14	/* t__pfx_trace_event_raw_event_vector_activate */
	.byte 0x0d, 0x74, 0x7d, 0x7b, 0xcc, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xf2, 0xdc, 0x76, 0x14	/* ttrace_event_raw_event_vector_activate */
	.byte 0x0e, 0xef, 0x7d, 0x7b, 0xcc, 0x76, 0xb4, 0x74, 0xd5, 0xa7, 0x65, 0xc5, 0x64, 0xad, 0x6e	/* t__pfx_trace_event_raw_event_vector_teardown */
	.byte 0x0e, 0x74, 0x7d, 0x7b, 0xcc, 0x76, 0xb4, 0x74, 0xd5, 0xa7, 0x65, 0xc5, 0x64, 0xad, 0x6e	/* ttrace_event_raw_event_vector_teardown */
	.byte 0x0b, 0xef, 0x7d, 0x7b, 0xcc, 0x76, 0xb4, 0x74, 0xd5, 0xf6, 0xd4, 0xcd	/* t__pfx_trace_event_raw_event_vector_setup */
	.byte 0x0b, 0x74, 0x7d, 0x7b, 0xcc, 0x76, 0xb4, 0x74, 0xd5, 0xf6, 0xd4, 0xcd	/* ttrace_event_raw_event_vector_setup */
	.byte 0x0e, 0xef, 0x7d, 0x7b, 0xcc, 0x76, 0xb4, 0x74, 0xd5, 0xe6, 0xf7, 0xfc, 0x17, 0x76, 0x9e	/* t__pfx_trace_event_raw_event_vector_free_moved */
	.byte 0x0e, 0x74, 0x7d, 0x7b, 0xcc, 0x76, 0xb4, 0x74, 0xd5, 0xe6, 0xf7, 0xfc, 0x17, 0x76, 0x9e	/* ttrace_event_raw_event_vector_free_moved */
	.byte 0x12, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x78, 0x38, 0x36, 0x5f, 0xab, 0x71, 0x5f, 0x76, 0xb4, 0x74, 0xd5	/* t__pfx_trace_raw_output_x86_irq_vector */
	.byte 0x12, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x78, 0x38, 0x36, 0x5f, 0xab, 0x71, 0x5f, 0x76, 0xb4, 0x74, 0xd5	/* ttrace_raw_output_x86_irq_vector */
	.byte 0x0e, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x76, 0xb4, 0x74, 0xd5, 0x3e, 0xa5, 0x67	/* t__pfx_trace_raw_output_vector_config */
	.byte 0x0e, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x76, 0xb4, 0x74, 0xd5, 0x3e, 0xa5, 0x67	/* ttrace_raw_output_vector_config */
	.byte 0x0d, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x76, 0xb4, 0x74, 0xd5, 0xc1, 0xb7	/* t__pfx_trace_raw_output_vector_mod */
	.byte 0x0d, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x76, 0xb4, 0x74, 0xd5, 0xc1, 0xb7	/* ttrace_raw_output_vector_mod */
	.byte 0x0f, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x76, 0xb4, 0x74, 0xd5, 0x07, 0xf5, 0x76, 0x65	/* t__pfx_trace_raw_output_vector_reserve */
	.byte 0x0f, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x76, 0xb4, 0x74, 0xd5, 0x07, 0xf5, 0x76, 0x65	/* ttrace_raw_output_vector_reserve */
	.byte 0x0e, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0x22, 0x63	/* t__pfx_trace_raw_output_vector_alloc */
	.byte 0x0e, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0x22, 0x63	/* ttrace_raw_output_vector_alloc */
	.byte 0x12, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0x22, 0xc9, 0xd9, 0x6e, 0x83, 0x9e	/* t__pfx_trace_raw_output_vector_alloc_managed */
	.byte 0x12, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0x22, 0xc9, 0xd9, 0x6e, 0x83, 0x9e	/* ttrace_raw_output_vector_alloc_managed */
	.byte 0x10, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xf2, 0xdc, 0x76, 0x14	/* t__pfx_trace_raw_output_vector_activate */
	.byte 0x10, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xf2, 0xdc, 0x76, 0x14	/* ttrace_raw_output_vector_activate */
	.byte 0x11, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x76, 0xb4, 0x74, 0xd5, 0xa7, 0x65, 0xc5, 0x64, 0xad, 0x6e	/* t__pfx_trace_raw_output_vector_teardown */
	.byte 0x11, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x76, 0xb4, 0x74, 0xd5, 0xa7, 0x65, 0xc5, 0x64, 0xad, 0x6e	/* ttrace_raw_output_vector_teardown */
	.byte 0x0e, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x76, 0xb4, 0x74, 0xd5, 0xf6, 0xd4, 0xcd	/* t__pfx_trace_raw_output_vector_setup */
	.byte 0x0e, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x76, 0xb4, 0x74, 0xd5, 0xf6, 0xd4, 0xcd	/* ttrace_raw_output_vector_setup */
	.byte 0x11, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x76, 0xb4, 0x74, 0xd5, 0xe6, 0xf7, 0xfc, 0x17, 0x76, 0x9e	/* t__pfx_trace_raw_output_vector_free_moved */
	.byte 0x11, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x76, 0xb4, 0x74, 0xd5, 0xe6, 0xf7, 0xfc, 0x17, 0x76, 0x9e	/* ttrace_raw_output_vector_free_moved */
	.byte 0x0b, 0x74, 0xaf, 0x3a, 0x6d, 0x6d, 0xe7, 0xbf, 0xa2, 0x72, 0xcd, 0x74	/* t__pfx___common_interrupt */
	.byte 0x0b, 0x74, 0xff, 0x03, 0x6d, 0x6d, 0xe7, 0xbf, 0xa2, 0x72, 0xcd, 0x74	/* t__common_interrupt */
	.byte 0x0e, 0x99, 0xec, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xed, 0x65, 0xf2, 0xdc, 0x76, 0x14	/* T__pfx___probestub_vector_deactivate */
	.byte 0x0e, 0x54, 0xfd, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xed, 0x65, 0xf2, 0xdc, 0x76, 0x14	/* T__probestub_vector_deactivate */
	.byte 0x0c, 0x99, 0xec, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x07, 0xf5, 0x76, 0x65	/* T__pfx___probestub_vector_reserve */
	.byte 0x0c, 0x54, 0xfd, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x07, 0xf5, 0x76, 0x65	/* T__probestub_vector_reserve */
	.byte 0x0b, 0x99, 0xec, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xf0, 0xc4, 0xc5	/* T__pfx___probestub_vector_clear */
	.byte 0x0b, 0x54, 0xfd, 0x10, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xf0, 0xc4, 0xc5	/* T__probestub_vector_clear */
	.byte 0x0e, 0x99, 0xec, 0x10, 0xa7, 0x68, 0xf5, 0x6d, 0xe5, 0x5f, 0x61, 0xb2, 0xc9, 0xcb, 0xea	/* T__pfx___probestub_thermal_apic_exit */
	.byte 0x0e, 0x54, 0xfd, 0x10, 0xa7, 0x68, 0xf5, 0x6d, 0xe5, 0x5f, 0x61, 0xb2, 0xc9, 0xcb, 0xea	/* T__probestub_thermal_apic_exit */
	.byte 0x0d, 0x99, 0xec, 0x10, 0x5f, 0xdd, 0x63, 0xe5, 0x5f, 0x00, 0xf5, 0x5f, 0xcb, 0xea	/* T__pfx___probestub_local_timer_exit */
	.byte 0x0d, 0x54, 0xfd, 0x10, 0x5f, 0xdd, 0x63, 0xe5, 0x5f, 0x00, 0xf5, 0x5f, 0xcb, 0xea	/* T__probestub_local_timer_exit */
	.byte 0x0f, 0x99, 0xec, 0x10, 0xf6, 0x9c, 0x72, 0xc0, 0x75, 0xe9, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x79	/* T__pfx___probestub_spurious_apic_entry */
	.byte 0x0f, 0x54, 0xfd, 0x10, 0xf6, 0x9c, 0x72, 0xc0, 0x75, 0xe9, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x79	/* T__probestub_spurious_apic_entry */
	.byte 0x0e, 0x99, 0xec, 0x10, 0xf6, 0x9c, 0x72, 0xc0, 0x75, 0xe9, 0x61, 0xb2, 0xc9, 0xcb, 0xea	/* T__pfx___probestub_spurious_apic_exit */
	.byte 0x0e, 0x54, 0xfd, 0x10, 0xf6, 0x9c, 0x72, 0xc0, 0x75, 0xe9, 0x61, 0xb2, 0xc9, 0xcb, 0xea	/* T__probestub_spurious_apic_exit */
	.byte 0x0e, 0x99, 0xec, 0x10, 0x5f, 0xf5, 0xe3, 0x72, 0x5f, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x79	/* T__pfx___probestub_error_apic_entry */
	.byte 0x0e, 0x54, 0xfd, 0x10, 0x5f, 0xf5, 0xe3, 0x72, 0x5f, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x79	/* T__probestub_error_apic_entry */
	.byte 0x0d, 0x99, 0xec, 0x10, 0x5f, 0xf5, 0xe3, 0x72, 0x5f, 0x61, 0xb2, 0xc9, 0xcb, 0xea	/* T__pfx___probestub_error_apic_exit */
	.byte 0x0d, 0x54, 0xfd, 0x10, 0x5f, 0xf5, 0xe3, 0x72, 0x5f, 0x61, 0xb2, 0xc9, 0xcb, 0xea	/* T__probestub_error_apic_exit */
	.byte 0x12, 0x99, 0xec, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xec, 0x6c, 0xe8, 0x66, 0xd5, 0xae, 0x69, 0xb2, 0x0d, 0xf3, 0x79	/* T__pfx___probestub_x86_platform_ipi_entry */
	.byte 0x12, 0x54, 0xfd, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xec, 0x6c, 0xe8, 0x66, 0xd5, 0xae, 0x69, 0xb2, 0x0d, 0xf3, 0x79	/* T__probestub_x86_platform_ipi_entry */
	.byte 0x12, 0x99, 0xec, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xec, 0x6c, 0xe8, 0x66, 0xd5, 0xae, 0x69, 0xb2, 0x5f, 0xcb, 0xea	/* T__pfx___probestub_x86_platform_ipi_exit */
	.byte 0x12, 0x54, 0xfd, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xec, 0x6c, 0xe8, 0x66, 0xd5, 0xae, 0x69, 0xb2, 0x5f, 0xcb, 0xea	/* T__probestub_x86_platform_ipi_exit */
	.byte 0x0c, 0x99, 0xec, 0x10, 0x5f, 0xab, 0x71, 0x92, 0xd5, 0x6b, 0x0d, 0xf3, 0x79	/* T__pfx___probestub_irq_work_entry */
	.byte 0x0c, 0x54, 0xfd, 0x10, 0x5f, 0xab, 0x71, 0x92, 0xd5, 0x6b, 0x0d, 0xf3, 0x79	/* T__probestub_irq_work_entry */
	.byte 0x0c, 0x99, 0xec, 0x10, 0x5f, 0xab, 0x71, 0x92, 0xd5, 0x6b, 0x5f, 0xcb, 0xea	/* T__pfx___probestub_irq_work_exit */
	.byte 0x0c, 0x54, 0xfd, 0x10, 0x5f, 0xab, 0x71, 0x92, 0xd5, 0x6b, 0x5f, 0xcb, 0xea	/* T__probestub_irq_work_exit */
	.byte 0x0b, 0x99, 0xec, 0x10, 0x07, 0xba, 0x9e, 0x75, 0xb0, 0xf1, 0xf3, 0x79	/* T__pfx___probestub_reschedule_entry */
	.byte 0x0b, 0x54, 0xfd, 0x10, 0x07, 0xba, 0x9e, 0x75, 0xb0, 0xf1, 0xf3, 0x79	/* T__probestub_reschedule_entry */
	.byte 0x0a, 0x99, 0xec, 0x10, 0x07, 0xba, 0x9e, 0x75, 0xb0, 0xcb, 0xea	/* T__pfx___probestub_reschedule_exit */
	.byte 0x0a, 0x54, 0xfd, 0x10, 0x07, 0xba, 0x9e, 0x75, 0xb0, 0xcb, 0xea	/* T__probestub_reschedule_exit */
	.byte 0x0c, 0x99, 0xec, 0x10, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7, 0x0d, 0xf3, 0x79	/* T__pfx___probestub_call_function_entry */
	.byte 0x0c, 0x54, 0xfd, 0x10, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7, 0x0d, 0xf3, 0x79	/* T__probestub_call_function_entry */
	.byte 0x0c, 0x99, 0xec, 0x10, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7, 0x5f, 0xcb, 0xea	/* T__pfx___probestub_call_function_exit */
	.byte 0x0c, 0x54, 0xfd, 0x10, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7, 0x5f, 0xcb, 0xea	/* T__probestub_call_function_exit */
	.byte 0x0f, 0x99, 0xec, 0x10, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7, 0xf6, 0x8d, 0xb0, 0xf1, 0xf3, 0x79	/* T__pfx___probestub_call_function_single_entry */
	.byte 0x0f, 0x54, 0xfd, 0x10, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7, 0xf6, 0x8d, 0xb0, 0xf1, 0xf3, 0x79	/* T__probestub_call_function_single_entry */
	.byte 0x0e, 0x99, 0xec, 0x10, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7, 0xf6, 0x8d, 0xb0, 0xcb, 0xea	/* T__pfx___probestub_call_function_single_exit */
	.byte 0x0e, 0x54, 0xfd, 0x10, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7, 0xf6, 0x8d, 0xb0, 0xcb, 0xea	/* T__probestub_call_function_single_exit */
	.byte 0x0f, 0x99, 0xec, 0x10, 0xa7, 0x68, 0x29, 0x68, 0xa0, 0xda, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x79	/* T__pfx___probestub_threshold_apic_entry */
	.byte 0x0f, 0x54, 0xfd, 0x10, 0xa7, 0x68, 0x29, 0x68, 0xa0, 0xda, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x79	/* T__probestub_threshold_apic_entry */
	.byte 0x0e, 0x99, 0xec, 0x10, 0xa7, 0x68, 0x29, 0x68, 0xa0, 0xda, 0x61, 0xb2, 0xc9, 0xcb, 0xea	/* T__pfx___probestub_threshold_apic_exit */
	.byte 0x0e, 0x54, 0xfd, 0x10, 0xa7, 0x68, 0x29, 0x68, 0xa0, 0xda, 0x61, 0xb2, 0xc9, 0xcb, 0xea	/* T__probestub_threshold_apic_exit */
	.byte 0x13, 0x99, 0xec, 0x10, 0xed, 0x65, 0x66, 0xf5, 0xf7, 0xda, 0xf5, 0xe3, 0x72, 0x5f, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x79	/* T__pfx___probestub_deferred_error_apic_entry */
	.byte 0x13, 0x54, 0xfd, 0x10, 0xed, 0x65, 0x66, 0xf5, 0xf7, 0xda, 0xf5, 0xe3, 0x72, 0x5f, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x79	/* T__probestub_deferred_error_apic_entry */
	.byte 0x12, 0x99, 0xec, 0x10, 0xed, 0x65, 0x66, 0xf5, 0xf7, 0xda, 0xf5, 0xe3, 0x72, 0x5f, 0x61, 0xb2, 0xc9, 0xcb, 0xea	/* T__pfx___probestub_deferred_error_apic_exit */
	.byte 0x12, 0x54, 0xfd, 0x10, 0xed, 0x65, 0x66, 0xf5, 0xf7, 0xda, 0xf5, 0xe3, 0x72, 0x5f, 0x61, 0xb2, 0xc9, 0xcb, 0xea	/* T__probestub_deferred_error_apic_exit */
	.byte 0x0f, 0x99, 0xec, 0x10, 0xa7, 0x68, 0xf5, 0x6d, 0xe5, 0x5f, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x79	/* T__pfx___probestub_thermal_apic_entry */
	.byte 0x0f, 0x54, 0xfd, 0x10, 0xa7, 0x68, 0xf5, 0x6d, 0xe5, 0x5f, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x79	/* T__probestub_thermal_apic_entry */
	.byte 0x12, 0x74, 0xaf, 0x7f, 0x73, 0x76, 0x65, 0xc9, 0x78, 0x38, 0x36, 0xec, 0x6c, 0xe8, 0x66, 0xd5, 0xae, 0x69, 0xb2	/* t__pfx___sysvec_x86_platform_ipi */
	.byte 0x12, 0x74, 0xff, 0xe1, 0x73, 0x76, 0x65, 0xc9, 0x78, 0x38, 0x36, 0xec, 0x6c, 0xe8, 0x66, 0xd5, 0xae, 0x69, 0xb2	/* t__sysvec_x86_platform_ipi */
	.byte 0x0c, 0x74, 0xaf, 0x7f, 0x73, 0x76, 0x65, 0xc9, 0x74, 0x68, 0xf5, 0x6d, 0xe5	/* t__pfx___sysvec_thermal */
	.byte 0x0c, 0x74, 0xff, 0xe1, 0x73, 0x76, 0x65, 0xc9, 0x74, 0x68, 0xf5, 0x6d, 0xe5	/* t__sysvec_thermal */
	.byte 0x08, 0xeb, 0xf2, 0x6b, 0xb8, 0x61, 0xda, 0xab, 0x71	/* T__pfx_ack_bad_irq */
	.byte 0x08, 0x54, 0xf2, 0x6b, 0xb8, 0x61, 0xda, 0xab, 0x71	/* Tack_bad_irq */
	.byte 0x0a, 0xeb, 0xc5, 0xba, 0xf6, 0x7c, 0xbf, 0xa2, 0x72, 0xcd, 0x93	/* T__pfx_arch_show_interrupts */
	.byte 0x0a, 0x54, 0xc5, 0xba, 0xf6, 0x7c, 0xbf, 0xa2, 0x72, 0xcd, 0x93	/* Tarch_show_interrupts */
	.byte 0x0a, 0xeb, 0xc5, 0xba, 0x5f, 0xab, 0x71, 0xa9, 0xfe, 0x63, 0x9c	/* T__pfx_arch_irq_stat_cpu */
	.byte 0x0a, 0x54, 0xc5, 0xba, 0x5f, 0xab, 0x71, 0xa9, 0xfe, 0x63, 0x9c	/* Tarch_irq_stat_cpu */
	.byte 0x08, 0xeb, 0xc5, 0xba, 0x5f, 0xab, 0x71, 0xa9, 0x74	/* T__pfx_arch_irq_stat */
	.byte 0x08, 0x54, 0xc5, 0xba, 0x5f, 0xab, 0x71, 0xa9, 0x74	/* Tarch_irq_stat */
	.byte 0x14, 0xeb, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0x65, 0xc9, 0x78, 0x38, 0x36, 0xec, 0x6c, 0xe8, 0x66, 0xd5, 0xae, 0x69, 0xb2	/* T__pfx_fred_sysvec_x86_platform_ipi */
	.byte 0x14, 0x54, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0x65, 0xc9, 0x78, 0x38, 0x36, 0xec, 0x6c, 0xe8, 0x66, 0xd5, 0xae, 0x69, 0xb2	/* Tfred_sysvec_x86_platform_ipi */
	.byte 0x08, 0xeb, 0xa5, 0x78, 0xcd, 0x5f, 0xab, 0x71, 0x73	/* T__pfx_fixup_irqs */
	.byte 0x08, 0x54, 0xa5, 0x78, 0xcd, 0x5f, 0xab, 0x71, 0x73	/* Tfixup_irqs */
	.byte 0x0e, 0xeb, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0x65, 0xc9, 0x74, 0x68, 0xf5, 0x6d, 0xe5	/* T__pfx_fred_sysvec_thermal */
	.byte 0x0e, 0x54, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0x65, 0xc9, 0x74, 0x68, 0xf5, 0x6d, 0xe5	/* Tfred_sysvec_thermal */
	.byte 0x0d, 0xeb, 0xab, 0x71, 0xbf, 0x9d, 0x19, 0x63, 0x9c, 0x5f, 0xab, 0x71, 0x3d, 0xc6	/* T__pfx_irq_init_percpu_irqstack */
	.byte 0x0d, 0x54, 0xab, 0x71, 0xbf, 0x9d, 0x19, 0x63, 0x9c, 0x5f, 0xab, 0x71, 0x3d, 0xc6	/* Tirq_init_percpu_irqstack */
	.byte 0x09, 0xeb, 0x3d, 0xc6, 0xa7, 0x21, 0xfc, 0x6e, 0x61, 0xa8	/* T__pfx_stack_type_name */
	.byte 0x09, 0x54, 0x3d, 0xc6, 0xa7, 0x21, 0xfc, 0x6e, 0x61, 0xa8	/* Tstack_type_name */
	.byte 0x08, 0xeb, 0x67, 0xe2, 0x3d, 0xc6, 0xbf, 0x66, 0x6f	/* T__pfx_get_stack_info */
	.byte 0x08, 0x54, 0x67, 0xe2, 0x3d, 0xc6, 0xbf, 0x66, 0x6f	/* Tget_stack_info */
	.byte 0x07, 0xeb, 0x70, 0xe3, 0xa5, 0xb0, 0x70, 0x63	/* T__pfx_profile_pc */
	.byte 0x07, 0x54, 0x70, 0xe3, 0xa5, 0xb0, 0x70, 0x63	/* Tprofile_pc */
	.byte 0x08, 0xef, 0x00, 0xf5, 0xbf, 0xa2, 0x72, 0xcd, 0x74	/* t__pfx_timer_interrupt */
	.byte 0x08, 0x74, 0x00, 0xf5, 0xbf, 0xa2, 0x72, 0xcd, 0x74	/* ttimer_interrupt */
	.byte 0x0c, 0xeb, 0x63, 0xa4, 0x73, 0x6f, 0x98, 0x63, 0xfc, 0xc5, 0xba, 0xbf, 0xea	/* T__pfx_clocksource_arch_init */
	.byte 0x0c, 0x54, 0x63, 0xa4, 0x73, 0x6f, 0x98, 0x63, 0xfc, 0xc5, 0xba, 0xbf, 0xea	/* Tclocksource_arch_init */
	.byte 0x0b, 0xef, 0xf4, 0x5e, 0x5f, 0xcd, 0x64, 0x91, 0xc0, 0xb8, 0xea, 0x97	/* t__pfx_task_update_io_bitmap */
	.byte 0x0b, 0x74, 0xf4, 0x5e, 0x5f, 0xcd, 0x64, 0x91, 0xc0, 0xb8, 0xea, 0x97	/* ttask_update_io_bitmap */
	.byte 0x09, 0xeb, 0xc0, 0xb8, 0xea, 0x97, 0xf6, 0x68, 0x61, 0xf7	/* T__pfx_io_bitmap_share */
	.byte 0x09, 0x54, 0xc0, 0xb8, 0xea, 0x97, 0xf6, 0x68, 0x61, 0xf7	/* Tio_bitmap_share */
	.byte 0x08, 0xeb, 0xc0, 0xb8, 0xea, 0x97, 0x5f, 0xcb, 0xea	/* T__pfx_io_bitmap_exit */
	.byte 0x08, 0x54, 0xc0, 0xb8, 0xea, 0x97, 0x5f, 0xcb, 0xea	/* Tio_bitmap_exit */
	.byte 0x07, 0xeb, 0x6b, 0xe1, 0xe9, 0xc0, 0x19, 0x6d	/* T__pfx_ksys_ioperm */
	.byte 0x07, 0x54, 0x6b, 0xe1, 0xe9, 0xc0, 0x19, 0x6d	/* Tksys_ioperm */
	.byte 0x09, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xc0, 0x19, 0x6d	/* T__pfx___x64_sys_ioperm */
	.byte 0x09, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xc0, 0x19, 0x6d	/* T__x64_sys_ioperm */
	.byte 0x0a, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xc0, 0x19, 0x6d	/* T__pfx___ia32_sys_ioperm */
	.byte 0x0a, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xc0, 0x19, 0x6d	/* T__ia32_sys_ioperm */
	.byte 0x09, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xc0, 0x70, 0x6c	/* T__pfx___x64_sys_iopl */
	.byte 0x09, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xc0, 0x70, 0x6c	/* T__x64_sys_iopl */
	.byte 0x0a, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xc0, 0x70, 0x6c	/* T__pfx___ia32_sys_iopl */
	.byte 0x0a, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xc0, 0x70, 0x6c	/* T__ia32_sys_iopl */
	.byte 0x09, 0x74, 0xaf, 0xed, 0x69, 0xfc, 0x68, 0x65, 0xc8, 0xf5	/* t__pfx___die_header */
	.byte 0x09, 0x74, 0xff, 0x64, 0x69, 0xfc, 0x68, 0x65, 0xc8, 0xf5	/* t__die_header */
	.byte 0x08, 0xeb, 0x6f, 0xbe, 0xe9, 0x62, 0x65, 0x67, 0xf8	/* T__pfx_oops_begin */
	.byte 0x08, 0x54, 0x6f, 0xbe, 0xe9, 0x62, 0x65, 0x67, 0xf8	/* Toops_begin */
	.byte 0x06, 0xeb, 0x6f, 0xbe, 0xe9, 0xf1, 0x64	/* T__pfx_oops_end */
	.byte 0x06, 0x54, 0x6f, 0xbe, 0xe9, 0xf1, 0x64	/* Toops_end */
	.byte 0x08, 0xeb, 0x73, 0x7c, 0x5f, 0xbe, 0x63, 0xb7, 0xd6	/* T__pfx_show_opcodes */
	.byte 0x08, 0x54, 0x73, 0x7c, 0x5f, 0xbe, 0x63, 0xb7, 0xd6	/* Tshow_opcodes */
	.byte 0x0b, 0xef, 0x73, 0x7c, 0xde, 0x67, 0xe9, 0x69, 0x3b, 0xe7, 0xa9, 0xc6	/* t__pfx_show_regs_if_on_stack */
	.byte 0x0a, 0x93, 0x7c, 0xde, 0x67, 0xe9, 0x69, 0x3b, 0xe7, 0xa9, 0xc6	/* tshow_regs_if_on_stack */
	.byte 0x0b, 0xef, 0x73, 0x7c, 0x5f, 0xc3, 0xdd, 0x67, 0x5f, 0x6c, 0x76, 0x6c	/* t__pfx_show_trace_log_lvl */
	.byte 0x0a, 0x93, 0x7c, 0x5f, 0xc3, 0xdd, 0x67, 0x5f, 0x6c, 0x76, 0x6c	/* tshow_trace_log_lvl */
	.byte 0x05, 0xeb, 0x73, 0x7c, 0x5f, 0x28	/* T__pfx_show_ip */
	.byte 0x05, 0x54, 0x73, 0x7c, 0x5f, 0x28	/* Tshow_ip */
	.byte 0x0a, 0xeb, 0x73, 0x7c, 0x5f, 0x69, 0xf7, 0xfe, 0xf7, 0x67, 0x73	/* T__pfx_show_iret_regs */
	.byte 0x0a, 0x54, 0x73, 0x7c, 0x5f, 0x69, 0xf7, 0xfe, 0xf7, 0x67, 0x73	/* Tshow_iret_regs */
	.byte 0x05, 0xeb, 0x73, 0x7c, 0xa9, 0xc6	/* T__pfx_show_stack */
	.byte 0x05, 0x54, 0x73, 0x7c, 0xa9, 0xc6	/* Tshow_stack */
	.byte 0x08, 0xeb, 0x73, 0x7c, 0xa9, 0xc6, 0xde, 0x67, 0x73	/* T__pfx_show_stack_regs */
	.byte 0x08, 0x54, 0x73, 0x7c, 0xa9, 0xc6, 0xde, 0x67, 0x73	/* Tshow_stack_regs */
	.byte 0x06, 0xeb, 0x73, 0x7c, 0xde, 0x67, 0x73	/* T__pfx_show_regs */
	.byte 0x06, 0x54, 0x73, 0x7c, 0xde, 0x67, 0x73	/* Tshow_regs */
	.byte 0x08, 0x74, 0xaf, 0xed, 0x69, 0xfc, 0x62, 0xb7, 0x79	/* t__pfx___die_body */
	.byte 0x08, 0x74, 0xff, 0x64, 0x69, 0xfc, 0x62, 0xb7, 0x79	/* t__die_body */
	.byte 0x04, 0x99, 0xed, 0x69, 0x65	/* T__pfx___die */
	.byte 0x04, 0xb9, 0x64, 0x69, 0x65	/* T__die */
	.byte 0x04, 0xeb, 0x64, 0x69, 0x65	/* T__pfx_die */
	.byte 0x04, 0x54, 0x64, 0x69, 0x65	/* Tdie */
	.byte 0x06, 0xeb, 0x64, 0x69, 0xfc, 0xc8, 0xac	/* T__pfx_die_addr */
	.byte 0x06, 0x54, 0x64, 0x69, 0xfc, 0xc8, 0xac	/* Tdie_addr */
	.byte 0x09, 0x08, 0x18, 0xbd, 0x6d, 0x69, 0xa3, 0x05, 0x6c, 0xf5	/* T__pfx___traceiter_nmi_handler */
	.byte 0x09, 0xb9, 0x18, 0xbd, 0x6d, 0x69, 0xa3, 0x05, 0x6c, 0xf5	/* T__traceiter_nmi_handler */
	.byte 0x0a, 0x99, 0xec, 0x10, 0xbd, 0x6d, 0x69, 0xa3, 0x05, 0x6c, 0xf5	/* T__pfx___probestub_nmi_handler */
	.byte 0x0a, 0x54, 0xfd, 0x10, 0xbd, 0x6d, 0x69, 0xa3, 0x05, 0x6c, 0xf5	/* T__probestub_nmi_handler */
	.byte 0x0b, 0xeb, 0xdd, 0x63, 0xe5, 0xa7, 0x6f, 0x75, 0xba, 0xbd, 0x6d, 0x69	/* T__pfx_local_touch_nmi */
	.byte 0x0b, 0x54, 0xdd, 0x63, 0xe5, 0xa7, 0x6f, 0x75, 0xba, 0xbd, 0x6d, 0x69	/* Tlocal_touch_nmi */
	.byte 0x0b, 0xef, 0x19, 0x3b, 0xc3, 0x6e, 0x6d, 0x69, 0xa3, 0x05, 0x6c, 0xf5	/* t__pfx_perf_trace_nmi_handler */
	.byte 0x0b, 0xce, 0xf5, 0x3b, 0xc3, 0x6e, 0x6d, 0x69, 0xa3, 0x05, 0x6c, 0xf5	/* tperf_trace_nmi_handler */
	.byte 0x0a, 0x99, 0xde, 0x0e, 0xbd, 0x6d, 0x69, 0xa3, 0x05, 0x6c, 0xf5	/* T__pfx___register_nmi_handler */
	.byte 0x0a, 0xb9, 0xf7, 0x0e, 0xbd, 0x6d, 0x69, 0xa3, 0x05, 0x6c, 0xf5	/* T__register_nmi_handler */
	.byte 0x0b, 0xef, 0x7d, 0x7b, 0xcc, 0x6e, 0x6d, 0x69, 0xa3, 0x05, 0x6c, 0xf5	/* t__pfx_trace_event_raw_event_nmi_handler */
	.byte 0x0b, 0x74, 0x7d, 0x7b, 0xcc, 0x6e, 0x6d, 0x69, 0xa3, 0x05, 0x6c, 0xf5	/* ttrace_event_raw_event_nmi_handler */
	.byte 0x0e, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x6e, 0x6d, 0x69, 0xa3, 0x05, 0x6c, 0xf5	/* t__pfx_trace_raw_output_nmi_handler */
	.byte 0x0e, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x6e, 0x6d, 0x69, 0xa3, 0x05, 0x6c, 0xf5	/* ttrace_raw_output_nmi_handler */
	.byte 0x0b, 0xeb, 0xe4, 0xf7, 0x0e, 0xbd, 0x6d, 0x69, 0xa3, 0x05, 0x6c, 0xf5	/* T__pfx_unregister_nmi_handler */
	.byte 0x0b, 0x54, 0xe4, 0xf7, 0x0e, 0xbd, 0x6d, 0x69, 0xa3, 0x05, 0x6c, 0xf5	/* Tunregister_nmi_handler */
	.byte 0x07, 0xef, 0x6e, 0x6d, 0x69, 0xa3, 0x05, 0xc4	/* t__pfx_nmi_handle */
	.byte 0x07, 0x74, 0x6e, 0x6d, 0x69, 0xa3, 0x05, 0xc4	/* tnmi_handle */
	.byte 0x0a, 0xef, 0x70, 0x9b, 0xf6, 0xf5, 0x72, 0x5f, 0xf5, 0xe3, 0x72	/* t__pfx_pci_serr_error */
	.byte 0x09, 0xce, 0x9b, 0xf6, 0xf5, 0x72, 0x5f, 0xf5, 0xe3, 0x72	/* tpci_serr_error */
	.byte 0x0d, 0xef, 0xe4, 0x6b, 0x6e, 0xad, 0x6e, 0xbd, 0x6d, 0x69, 0x5f, 0xf5, 0xe3, 0x72	/* t__pfx_unknown_nmi_error */
	.byte 0x0d, 0x74, 0xe4, 0x6b, 0x6e, 0xad, 0x6e, 0xbd, 0x6d, 0x69, 0x5f, 0xf5, 0xe3, 0x72	/* tunknown_nmi_error */
	.byte 0x09, 0xef, 0xc0, 0x25, 0x65, 0xc6, 0x5f, 0xf5, 0xe3, 0x72	/* t__pfx_io_check_error */
	.byte 0x09, 0xdc, 0x6f, 0x25, 0x65, 0xc6, 0x5f, 0xf5, 0xe3, 0x72	/* tio_check_error */
	.byte 0x07, 0xeb, 0x73, 0x74, 0xbe, 0xbd, 0x6d, 0x69	/* T__pfx_stop_nmi */
	.byte 0x07, 0x54, 0x73, 0x74, 0xbe, 0xbd, 0x6d, 0x69	/* Tstop_nmi */
	.byte 0x08, 0xeb, 0xf7, 0x3d, 0x72, 0xfe, 0x6e, 0x6d, 0x69	/* T__pfx_restart_nmi */
	.byte 0x08, 0x54, 0xf7, 0x3d, 0x72, 0xfe, 0x6e, 0x6d, 0x69	/* Trestart_nmi */
	.byte 0x0b, 0xef, 0x22, 0xc9, 0x6c, 0x64, 0xfe, 0x73, 0xf3, 0x75, 0x63, 0x74	/* t__pfx_alloc_ldt_struct */
	.byte 0x0c, 0xf4, 0x6c, 0xdd, 0xc9, 0x6c, 0x64, 0xfe, 0x73, 0xf3, 0x75, 0x63, 0x74	/* talloc_ldt_struct */
	.byte 0x0b, 0xef, 0x97, 0x5f, 0x6c, 0x64, 0xfe, 0x73, 0xf3, 0x75, 0x63, 0x74	/* t__pfx_map_ldt_struct */
	.byte 0x0b, 0x74, 0x97, 0x5f, 0x6c, 0x64, 0xfe, 0x73, 0xf3, 0x75, 0x63, 0x74	/* tmap_ldt_struct */
	.byte 0x0c, 0xef, 0x66, 0xf7, 0xfc, 0x6c, 0x64, 0xfe, 0x70, 0x67, 0xe0, 0x6c, 0xd6	/* t__pfx_free_ldt_pgtables */
	.byte 0x0c, 0x74, 0x66, 0xf7, 0xfc, 0x6c, 0x64, 0xfe, 0x70, 0x67, 0xe0, 0x6c, 0xd6	/* tfree_ldt_pgtables */
	.byte 0x0c, 0xef, 0xf7, 0xc8, 0xed, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x6c, 0x64, 0x74	/* t__pfx_read_default_ldt */
	.byte 0x0c, 0x74, 0xf7, 0xc8, 0xed, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x6c, 0x64, 0x74	/* tread_default_ldt */
	.byte 0x07, 0xef, 0xf7, 0x61, 0xda, 0x6c, 0x64, 0x74	/* t__pfx_read_ldt */
	.byte 0x07, 0x74, 0xf7, 0x61, 0xda, 0x6c, 0x64, 0x74	/* tread_ldt */
	.byte 0x07, 0xef, 0x77, 0x3c, 0xfc, 0x6c, 0x64, 0x74	/* t__pfx_write_ldt */
	.byte 0x07, 0x74, 0x77, 0x3c, 0xfc, 0x6c, 0x64, 0x74	/* twrite_ldt */
	.byte 0x09, 0xeb, 0xdd, 0x61, 0xda, 0x6d, 0xae, 0x6c, 0x64, 0x74	/* T__pfx_load_mm_ldt */
	.byte 0x09, 0x54, 0xdd, 0x61, 0xda, 0x6d, 0xae, 0x6c, 0x64, 0x74	/* Tload_mm_ldt */
	.byte 0x09, 0xef, 0x66, 0x6c, 0xb1, 0x68, 0x5f, 0x6c, 0x64, 0x74	/* t__pfx_flush_ldt */
	.byte 0x09, 0x74, 0x66, 0x6c, 0xb1, 0x68, 0x5f, 0x6c, 0x64, 0x74	/* tflush_ldt */
	.byte 0x09, 0xeb, 0x73, 0x77, 0xea, 0xba, 0x5f, 0x6c, 0x64, 0x74	/* T__pfx_switch_ldt */
	.byte 0x09, 0x54, 0x73, 0x77, 0xea, 0xba, 0x5f, 0x6c, 0x64, 0x74	/* Tswitch_ldt */
	.byte 0x09, 0xeb, 0x6c, 0x64, 0xfe, 0x64, 0xcd, 0x3e, 0x74, 0x8e	/* T__pfx_ldt_dup_context */
	.byte 0x09, 0x54, 0x6c, 0x64, 0xfe, 0x64, 0xcd, 0x3e, 0x74, 0x8e	/* Tldt_dup_context */
	.byte 0x0d, 0xeb, 0x64, 0xd6, 0xf3, 0x6f, 0x79, 0x3e, 0x74, 0xcb, 0xfe, 0x6c, 0x64, 0x74	/* T__pfx_destroy_context_ldt */
	.byte 0x0d, 0x54, 0x64, 0xd6, 0xf3, 0x6f, 0x79, 0x3e, 0x74, 0xcb, 0xfe, 0x6c, 0x64, 0x74	/* Tdestroy_context_ldt */
	.byte 0x0b, 0xeb, 0x6c, 0x64, 0xfe, 0xc5, 0xba, 0x5f, 0xcb, 0x9d, 0x6d, 0x97	/* T__pfx_ldt_arch_exit_mmap */
	.byte 0x0b, 0x54, 0x6c, 0x64, 0xfe, 0xc5, 0xba, 0x5f, 0xcb, 0x9d, 0x6d, 0x97	/* Tldt_arch_exit_mmap */
	.byte 0x0e, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x6d, 0xb7, 0x69, 0x66, 0x1d, 0x6c, 0x64, 0x74	/* T__pfx___x64_sys_modify_ldt */
	.byte 0x0e, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x6d, 0xb7, 0x69, 0x66, 0x1d, 0x6c, 0x64, 0x74	/* T__x64_sys_modify_ldt */
	.byte 0x0f, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x6d, 0xb7, 0x69, 0x66, 0x1d, 0x6c, 0x64, 0x74	/* T__pfx___ia32_sys_modify_ldt */
	.byte 0x0f, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x6d, 0xb7, 0x69, 0x66, 0x1d, 0x6c, 0x64, 0x74	/* T__ia32_sys_modify_ldt */
	.byte 0x10, 0x54, 0x69, 0x62, 0xfe, 0x73, 0xdb, 0x66, 0x74, 0xd6, 0xfe, 0x6e, 0x6f, 0xf1, 0x64, 0x62, 0x72	/* Tibt_selftest_noendbr */
	.byte 0x09, 0xeb, 0x69, 0x62, 0xfe, 0x73, 0xdb, 0x66, 0x74, 0x60	/* T__pfx_ibt_selftest */
	.byte 0x09, 0x54, 0x69, 0x62, 0xfe, 0x73, 0xdb, 0x66, 0x74, 0x60	/* Tibt_selftest */
	.byte 0x0e, 0xef, 0x64, 0x75, 0xb6, 0x5f, 0x6b, 0xf5, 0x6e, 0xdb, 0x5f, 0x6f, 0x66, 0x95, 0xd4	/* t__pfx_dump_kernel_offset */
	.byte 0x0e, 0x74, 0x64, 0x75, 0xb6, 0x5f, 0x6b, 0xf5, 0x6e, 0xdb, 0x5f, 0x6f, 0x66, 0x95, 0xd4	/* tdump_kernel_offset */
	.byte 0x0b, 0xeb, 0x78, 0x38, 0x36, 0x3e, 0xa5, 0x67, 0x98, 0xfc, 0x6e, 0x78	/* T__pfx_x86_configure_nx */
	.byte 0x0b, 0x54, 0x78, 0x38, 0x36, 0x3e, 0xa5, 0x67, 0x98, 0xfc, 0x6e, 0x78	/* Tx86_configure_nx */
	.byte 0x11, 0xeb, 0xc5, 0xba, 0xf0, 0x9c, 0x5f, 0x69, 0xe9, 0x68, 0x6f, 0xce, 0x6c, 0x75, 0x67, 0x67, 0x90, 0xc4	/* T__pfx_arch_cpu_is_hotpluggable */
	.byte 0x11, 0x54, 0xc5, 0xba, 0xf0, 0x9c, 0x5f, 0x69, 0xe9, 0x68, 0x6f, 0xce, 0x6c, 0x75, 0x67, 0x67, 0x90, 0xc4	/* Tarch_cpu_is_hotpluggable */
	.byte 0x0a, 0xef, 0x69, 0xe9, 0x49, 0x53, 0x41, 0xa6, 0xd2, 0x67, 0x65	/* t__pfx_is_ISA_range */
	.byte 0x09, 0xdc, 0xe9, 0x49, 0x53, 0x41, 0xa6, 0xd2, 0x67, 0x65	/* tis_ISA_range */
	.byte 0x0f, 0xef, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x67, 0xe2, 0x6e, 0x6d, 0x69, 0xde, 0xbb, 0xe7	/* t__pfx_default_get_nmi_reason */
	.byte 0x0f, 0x74, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x67, 0xe2, 0x6e, 0x6d, 0x69, 0xde, 0xbb, 0xe7	/* tdefault_get_nmi_reason */
	.byte 0x09, 0xeb, 0x78, 0x38, 0x36, 0xbf, 0x9d, 0x6e, 0x6f, 0xbe	/* T__pfx_x86_init_noop */
	.byte 0x09, 0x54, 0x78, 0x38, 0x36, 0xbf, 0x9d, 0x6e, 0x6f, 0xbe	/* Tx86_init_noop */
	.byte 0x0b, 0xeb, 0x78, 0x38, 0x36, 0x5f, 0xbe, 0xbf, 0xfe, 0x6e, 0x6f, 0xbe	/* T__pfx_x86_op_int_noop */
	.byte 0x0b, 0x54, 0x78, 0x38, 0x36, 0x5f, 0xbe, 0xbf, 0xfe, 0x6e, 0x6f, 0xbe	/* Tx86_op_int_noop */
	.byte 0x12, 0xef, 0xf1, 0x63, 0xa9, 0x74, 0xb1, 0x25, 0xd2, 0x67, 0xfc, 0x70, 0xf7, 0x70, 0xc5, 0xfc, 0x6e, 0x6f, 0xbe	/* t__pfx_enc_status_change_prepare_noop */
	.byte 0x12, 0x74, 0xf1, 0x63, 0xa9, 0x74, 0xb1, 0x25, 0xd2, 0x67, 0xfc, 0x70, 0xf7, 0x70, 0xc5, 0xfc, 0x6e, 0x6f, 0xbe	/* tenc_status_change_prepare_noop */
	.byte 0x11, 0xef, 0xf1, 0xc9, 0x23, 0x62, 0xe6, 0x6c, 0xb1, 0x68, 0xde, 0xa1, 0x69, 0xf7, 0xda, 0x6e, 0x6f, 0xbe	/* t__pfx_enc_tlb_flush_required_noop */
	.byte 0x11, 0x74, 0xf1, 0xc9, 0x23, 0x62, 0xe6, 0x6c, 0xb1, 0x68, 0xde, 0xa1, 0x69, 0xf7, 0xda, 0x6e, 0x6f, 0xbe	/* tenc_tlb_flush_required_noop */
	.byte 0x13, 0xef, 0xf1, 0x63, 0xf0, 0xf2, 0x68, 0xfc, 0x66, 0x6c, 0xb1, 0x68, 0xde, 0xa1, 0x69, 0xf7, 0xda, 0x6e, 0x6f, 0xbe	/* t__pfx_enc_cache_flush_required_noop */
	.byte 0x13, 0x74, 0xf1, 0x63, 0xf0, 0xf2, 0x68, 0xfc, 0x66, 0x6c, 0xb1, 0x68, 0xde, 0xa1, 0x69, 0xf7, 0xda, 0x6e, 0x6f, 0xbe	/* tenc_cache_flush_required_noop */
	.byte 0x0d, 0xef, 0xca, 0xec, 0x72, 0x69, 0x76, 0x91, 0x6d, 0x6d, 0xc0, 0xbd, 0x6f, 0xbe	/* t__pfx_is_private_mmio_noop */
	.byte 0x0d, 0xdc, 0x73, 0xec, 0x72, 0x69, 0x76, 0x91, 0x6d, 0x6d, 0xc0, 0xbd, 0x6f, 0xbe	/* tis_private_mmio_noop */
	.byte 0x11, 0xef, 0xf1, 0x63, 0xa9, 0x74, 0xb1, 0x25, 0xd2, 0x67, 0xfc, 0x66, 0xf8, 0xca, 0x68, 0xbd, 0x6f, 0xbe	/* t__pfx_enc_status_change_finish_noop */
	.byte 0x11, 0x74, 0xf1, 0x63, 0xa9, 0x74, 0xb1, 0x25, 0xd2, 0x67, 0xfc, 0x66, 0xf8, 0xca, 0x68, 0xbd, 0x6f, 0xbe	/* tenc_status_change_finish_noop */
	.byte 0x0e, 0xef, 0xf1, 0xc9, 0x6b, 0xcb, 0x65, 0xc9, 0x62, 0x65, 0x67, 0xf8, 0xbd, 0x6f, 0xbe	/* t__pfx_enc_kexec_begin_noop */
	.byte 0x0e, 0x74, 0xf1, 0xc9, 0x6b, 0xcb, 0x65, 0xc9, 0x62, 0x65, 0x67, 0xf8, 0xbd, 0x6f, 0xbe	/* tenc_kexec_begin_noop */
	.byte 0x0d, 0xef, 0xf1, 0xc9, 0x6b, 0xcb, 0xb4, 0xe6, 0xf8, 0xca, 0x68, 0xbd, 0x6f, 0xbe	/* t__pfx_enc_kexec_finish_noop */
	.byte 0x0d, 0x74, 0xf1, 0xc9, 0x6b, 0xcb, 0xb4, 0xe6, 0xf8, 0xca, 0x68, 0xbd, 0x6f, 0xbe	/* tenc_kexec_finish_noop */
	.byte 0x0e, 0xef, 0xc0, 0x6d, 0x6d, 0x75, 0xf6, 0x68, 0x20, 0x64, 0xad, 0x6e, 0xbd, 0x6f, 0xbe	/* t__pfx_iommu_shutdown_noop */
	.byte 0x0e, 0xdc, 0x6f, 0x6d, 0x6d, 0x75, 0xf6, 0x68, 0x20, 0x64, 0xad, 0x6e, 0xbd, 0x6f, 0xbe	/* tiommu_shutdown_noop */
	.byte 0x0c, 0xef, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x6e, 0x6d, 0x69, 0xbf, 0xea	/* t__pfx_default_nmi_init */
	.byte 0x0c, 0x74, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x6e, 0x6d, 0x69, 0xbf, 0xea	/* tdefault_nmi_init */
	.byte 0x09, 0xeb, 0x73, 0xe2, 0x72, 0x74, 0xc9, 0x6e, 0x6f, 0xbe	/* T__pfx_set_rtc_noop */
	.byte 0x09, 0x54, 0x73, 0xe2, 0x72, 0x74, 0xc9, 0x6e, 0x6f, 0xbe	/* Tset_rtc_noop */
	.byte 0x09, 0xeb, 0x67, 0xe2, 0x72, 0x74, 0xc9, 0x6e, 0x6f, 0xbe	/* T__pfx_get_rtc_noop */
	.byte 0x09, 0x54, 0x67, 0xe2, 0x72, 0x74, 0xc9, 0x6e, 0x6f, 0xbe	/* Tget_rtc_noop */
	.byte 0x0c, 0xef, 0xd9, 0x5e, 0x5f, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xab, 0x71	/* t__pfx_mask_8259A_irq */
	.byte 0x0c, 0x74, 0xd9, 0x5e, 0x5f, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xab, 0x71	/* tmask_8259A_irq */
	.byte 0x0d, 0xef, 0xe4, 0xd9, 0x5e, 0x5f, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xab, 0x71	/* t__pfx_unmask_8259A_irq */
	.byte 0x0d, 0x74, 0xe4, 0xd9, 0x5e, 0x5f, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xab, 0x71	/* tunmask_8259A_irq */
	.byte 0x0e, 0xef, 0x69, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xab, 0x71, 0xec, 0xf1, 0x64, 0x8d	/* t__pfx_i8259A_irq_pending */
	.byte 0x0d, 0xdc, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xab, 0x71, 0xec, 0xf1, 0x64, 0x8d	/* ti8259A_irq_pending */
	.byte 0x0c, 0xef, 0x69, 0x38, 0x32, 0x35, 0x39, 0x41, 0xf6, 0xb1, 0x70, 0xf1, 0x64	/* t__pfx_i8259A_suspend */
	.byte 0x0b, 0xdc, 0x38, 0x32, 0x35, 0x39, 0x41, 0xf6, 0xb1, 0x70, 0xf1, 0x64	/* ti8259A_suspend */
	.byte 0x0d, 0xef, 0x69, 0x38, 0x32, 0x35, 0x39, 0x41, 0xf6, 0x68, 0x20, 0x64, 0xad, 0x6e	/* t__pfx_i8259A_shutdown */
	.byte 0x0c, 0xdc, 0x38, 0x32, 0x35, 0x39, 0x41, 0xf6, 0x68, 0x20, 0x64, 0xad, 0x6e	/* ti8259A_shutdown */
	.byte 0x09, 0xef, 0xd9, 0x5e, 0x5f, 0x38, 0x32, 0x35, 0x39, 0x41	/* t__pfx_mask_8259A */
	.byte 0x09, 0x74, 0xd9, 0x5e, 0x5f, 0x38, 0x32, 0x35, 0x39, 0x41	/* tmask_8259A */
	.byte 0x0a, 0xef, 0xe4, 0xd9, 0x5e, 0x5f, 0x38, 0x32, 0x35, 0x39, 0x41	/* t__pfx_unmask_8259A */
	.byte 0x0a, 0x74, 0xe4, 0xd9, 0x5e, 0x5f, 0x38, 0x32, 0x35, 0x39, 0x41	/* tunmask_8259A */
	.byte 0x0b, 0xef, 0xc4, 0x67, 0xf2, 0x79, 0xec, 0x69, 0xc9, 0x6e, 0x6f, 0xbe	/* t__pfx_legacy_pic_noop */
	.byte 0x0b, 0x74, 0xc4, 0x67, 0xf2, 0x79, 0xec, 0x69, 0xc9, 0x6e, 0x6f, 0xbe	/* tlegacy_pic_noop */
	.byte 0x0d, 0xef, 0xc4, 0x67, 0xf2, 0x79, 0xec, 0x69, 0xc9, 0x75, 0x27, 0x6e, 0x6f, 0xbe	/* t__pfx_legacy_pic_uint_noop */
	.byte 0x0d, 0x74, 0xc4, 0x67, 0xf2, 0x79, 0xec, 0x69, 0xc9, 0x75, 0x27, 0x6e, 0x6f, 0xbe	/* tlegacy_pic_uint_noop */
	.byte 0x0c, 0xef, 0xc4, 0x67, 0xf2, 0x79, 0xec, 0x69, 0xc9, 0x27, 0x6e, 0x6f, 0xbe	/* t__pfx_legacy_pic_int_noop */
	.byte 0x0c, 0x74, 0xc4, 0x67, 0xf2, 0x79, 0xec, 0x69, 0xc9, 0x27, 0x6e, 0x6f, 0xbe	/* tlegacy_pic_int_noop */
	.byte 0x11, 0xef, 0xc4, 0x67, 0xf2, 0x79, 0xec, 0x69, 0xc9, 0xab, 0x71, 0xec, 0xf1, 0x64, 0x8d, 0xbd, 0x6f, 0xbe	/* t__pfx_legacy_pic_irq_pending_noop */
	.byte 0x11, 0x74, 0xc4, 0x67, 0xf2, 0x79, 0xec, 0x69, 0xc9, 0xab, 0x71, 0xec, 0xf1, 0x64, 0x8d, 0xbd, 0x6f, 0xbe	/* tlegacy_pic_irq_pending_noop */
	.byte 0x0a, 0xef, 0xc4, 0x67, 0xf2, 0x79, 0xec, 0xaa, 0xec, 0x8c, 0x65	/* t__pfx_legacy_pic_probe */
	.byte 0x0a, 0x74, 0xc4, 0x67, 0xf2, 0x79, 0xec, 0xaa, 0xec, 0x8c, 0x65	/* tlegacy_pic_probe */
	.byte 0x0e, 0xef, 0xd9, 0x5e, 0x5f, 0xd2, 0xda, 0xf2, 0x6b, 0x5f, 0x38, 0x32, 0x35, 0x39, 0x41	/* t__pfx_mask_and_ack_8259A */
	.byte 0x0e, 0x74, 0xd9, 0x5e, 0x5f, 0xd2, 0xda, 0xf2, 0x6b, 0x5f, 0x38, 0x32, 0x35, 0x39, 0x41	/* tmask_and_ack_8259A */
	.byte 0x0c, 0xef, 0xd9, 0x6b, 0xfc, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xab, 0x71	/* t__pfx_make_8259A_irq */
	.byte 0x0c, 0x74, 0xd9, 0x6b, 0xfc, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xab, 0x71	/* tmake_8259A_irq */
	.byte 0x08, 0xef, 0xf8, 0x9d, 0x38, 0x32, 0x35, 0x39, 0x41	/* t__pfx_init_8259A */
	.byte 0x08, 0x74, 0xf8, 0x9d, 0x38, 0x32, 0x35, 0x39, 0x41	/* tinit_8259A */
	.byte 0x0a, 0xef, 0x69, 0x38, 0x32, 0x35, 0x39, 0x41, 0x07, 0x75, 0xa8	/* t__pfx_i8259A_resume */
	.byte 0x09, 0xdc, 0x38, 0x32, 0x35, 0x39, 0x41, 0x07, 0x75, 0xa8	/* ti8259A_resume */
	.byte 0x09, 0xef, 0x70, 0x8c, 0xfc, 0x38, 0x32, 0x35, 0x39, 0x41	/* t__pfx_probe_8259A */
	.byte 0x08, 0xce, 0x8c, 0xfc, 0x38, 0x32, 0x35, 0x39, 0x41	/* tprobe_8259A */
	.byte 0x0d, 0xef, 0x64, 0xca, 0x90, 0xb0, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xab, 0x71	/* t__pfx_disable_8259A_irq */
	.byte 0x0d, 0x74, 0x64, 0xca, 0x90, 0xb0, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xab, 0x71	/* tdisable_8259A_irq */
	.byte 0x0c, 0xef, 0xf1, 0x90, 0xb0, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xab, 0x71	/* t__pfx_enable_8259A_irq */
	.byte 0x0c, 0x74, 0xf1, 0x90, 0xb0, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xab, 0x71	/* tenable_8259A_irq */
	.byte 0x13, 0xef, 0xc5, 0xba, 0x5f, 0x6a, 0x75, 0xb6, 0x0d, 0xf3, 0x79, 0xf6, 0x69, 0x7a, 0x65, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__pfx_arch_jump_entry_size.part.0 */
	.byte 0x13, 0xf4, 0x72, 0xba, 0x5f, 0x6a, 0x75, 0xb6, 0x0d, 0xf3, 0x79, 0xf6, 0x69, 0x7a, 0x65, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* tarch_jump_entry_size.part.0 */
	.byte 0x0e, 0xeb, 0xc5, 0xba, 0x5f, 0x6a, 0x75, 0xb6, 0x0d, 0xf3, 0x79, 0xf6, 0x69, 0x7a, 0x65	/* T__pfx_arch_jump_entry_size */
	.byte 0x0e, 0x54, 0xc5, 0xba, 0x5f, 0x6a, 0x75, 0xb6, 0x0d, 0xf3, 0x79, 0xf6, 0x69, 0x7a, 0x65	/* Tarch_jump_entry_size */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x6a, 0x75, 0xb6, 0x5f, 0x6c, 0x90, 0xdb, 0xec, 0xe8, 0xba	/* t__pfx___jump_label_patch */
	.byte 0x0c, 0x74, 0xff, 0x6a, 0x75, 0xb6, 0x5f, 0x6c, 0x90, 0xdb, 0xec, 0xe8, 0xba	/* t__jump_label_patch */
	.byte 0x12, 0xeb, 0xc5, 0xba, 0x5f, 0x6a, 0x75, 0xb6, 0x5f, 0x6c, 0x90, 0xdb, 0x5f, 0xf3, 0xd2, 0x73, 0x66, 0xd5, 0x6d	/* T__pfx_arch_jump_label_transform */
	.byte 0x12, 0x54, 0xc5, 0xba, 0x5f, 0x6a, 0x75, 0xb6, 0x5f, 0x6c, 0x90, 0xdb, 0x5f, 0xf3, 0xd2, 0x73, 0x66, 0xd5, 0x6d	/* Tarch_jump_label_transform */
	.byte 0x16, 0xeb, 0xc5, 0xba, 0x5f, 0x6a, 0x75, 0xb6, 0x5f, 0x6c, 0x90, 0xdb, 0x5f, 0xf3, 0xd2, 0x73, 0x66, 0xd5, 0xae, 0xa1, 0x65, 0x75, 0x65	/* T__pfx_arch_jump_label_transform_queue */
	.byte 0x16, 0x54, 0xc5, 0xba, 0x5f, 0x6a, 0x75, 0xb6, 0x5f, 0x6c, 0x90, 0xdb, 0x5f, 0xf3, 0xd2, 0x73, 0x66, 0xd5, 0xae, 0xa1, 0x65, 0x75, 0x65	/* Tarch_jump_label_transform_queue */
	.byte 0x17, 0xeb, 0xc5, 0xba, 0x5f, 0x6a, 0x75, 0xb6, 0x5f, 0x6c, 0x90, 0xdb, 0x5f, 0xf3, 0xd2, 0x73, 0x66, 0xd5, 0xae, 0x61, 0x70, 0x70, 0x6c, 0x79	/* T__pfx_arch_jump_label_transform_apply */
	.byte 0x17, 0x54, 0xc5, 0xba, 0x5f, 0x6a, 0x75, 0xb6, 0x5f, 0x6c, 0x90, 0xdb, 0x5f, 0xf3, 0xd2, 0x73, 0x66, 0xd5, 0xae, 0x61, 0x70, 0x70, 0x6c, 0x79	/* Tarch_jump_label_transform_apply */
	.byte 0x0c, 0x74, 0xaf, 0x7f, 0x73, 0x76, 0x65, 0xc9, 0xab, 0x71, 0x92, 0xd5, 0x6b	/* t__pfx___sysvec_irq_work */
	.byte 0x0c, 0x74, 0xff, 0xe1, 0x73, 0x76, 0x65, 0xc9, 0xab, 0x71, 0x92, 0xd5, 0x6b	/* t__sysvec_irq_work */
	.byte 0x0e, 0xeb, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0x65, 0xc9, 0xab, 0x71, 0x92, 0xd5, 0x6b	/* T__pfx_fred_sysvec_irq_work */
	.byte 0x0e, 0x54, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0x65, 0xc9, 0xab, 0x71, 0x92, 0xd5, 0x6b	/* Tfred_sysvec_irq_work */
	.byte 0x0d, 0xeb, 0xc5, 0xba, 0x5f, 0xab, 0x71, 0x92, 0xd5, 0x6b, 0x5f, 0xbc, 0xca, 0x65	/* T__pfx_arch_irq_work_raise */
	.byte 0x0d, 0x54, 0xc5, 0xba, 0x5f, 0xab, 0x71, 0x92, 0xd5, 0x6b, 0x5f, 0xbc, 0xca, 0x65	/* Tarch_irq_work_raise */
	.byte 0x0b, 0xeb, 0x70, 0x9b, 0x5f, 0xe4, 0x97, 0xb8, 0xc0, 0x73, 0xe3, 0x6d	/* T__pfx_pci_unmap_biosrom */
	.byte 0x0b, 0x54, 0x70, 0x9b, 0x5f, 0xe4, 0x97, 0xb8, 0xc0, 0x73, 0xe3, 0x6d	/* Tpci_unmap_biosrom */
	.byte 0x0a, 0xef, 0x6d, 0xe8, 0xba, 0x5f, 0x9f, 0x2e, 0xca, 0xbc, 0x7e	/* t__pfx_match_id.isra.0 */
	.byte 0x0a, 0x74, 0x6d, 0xe8, 0xba, 0x5f, 0x9f, 0x2e, 0xca, 0xbc, 0x7e	/* tmatch_id.isra.0 */
	.byte 0x07, 0xef, 0x66, 0xf8, 0xda, 0xbe, 0xe3, 0x6d	/* t__pfx_find_oprom */
	.byte 0x07, 0x74, 0x66, 0xf8, 0xda, 0xbe, 0xe3, 0x6d	/* tfind_oprom */
	.byte 0x0a, 0xeb, 0x70, 0x9b, 0x5f, 0x97, 0xb8, 0xc0, 0x73, 0xe3, 0x6d	/* T__pfx_pci_map_biosrom */
	.byte 0x0a, 0x54, 0x70, 0x9b, 0x5f, 0x97, 0xb8, 0xc0, 0x73, 0xe3, 0x6d	/* Tpci_map_biosrom */
	.byte 0x0c, 0xeb, 0x70, 0x9b, 0xb8, 0xc0, 0x73, 0xe3, 0x6d, 0xf6, 0x69, 0x7a, 0x65	/* T__pfx_pci_biosrom_size */
	.byte 0x0c, 0x54, 0x70, 0x9b, 0xb8, 0xc0, 0x73, 0xe3, 0x6d, 0xf6, 0x69, 0x7a, 0x65	/* Tpci_biosrom_size */
	.byte 0x12, 0x74, 0xaf, 0xed, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xf0, 0x6c, 0xe7, 0x65	/* t__pfx___do_compat_sys_ia32_clone */
	.byte 0x12, 0x74, 0xff, 0x64, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xf0, 0x6c, 0xe7, 0x65	/* t__do_compat_sys_ia32_clone */
	.byte 0x07, 0xef, 0x63, 0x70, 0xa9, 0x74, 0x36, 0x34	/* t__pfx_cp_stat64 */
	.byte 0x06, 0x26, 0x70, 0xa9, 0x74, 0x36, 0x34	/* tcp_stat64 */
	.byte 0x12, 0x74, 0xaf, 0xed, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xa9, 0x74, 0x36, 0x34	/* t__pfx___do_compat_sys_ia32_stat64 */
	.byte 0x12, 0x74, 0xff, 0x64, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xa9, 0x74, 0x36, 0x34	/* t__do_compat_sys_ia32_stat64 */
	.byte 0x14, 0x74, 0xaf, 0xed, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x6c, 0x3d, 0x74, 0x36, 0x34	/* t__pfx___do_compat_sys_ia32_lstat64 */
	.byte 0x14, 0x74, 0xff, 0x64, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x6c, 0x3d, 0x74, 0x36, 0x34	/* t__do_compat_sys_ia32_lstat64 */
	.byte 0x14, 0x74, 0xaf, 0xed, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0x3d, 0xf4, 0x74, 0x36, 0x34	/* t__pfx___do_compat_sys_ia32_fstatat64 */
	.byte 0x14, 0x74, 0xff, 0x64, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0x3d, 0xf4, 0x74, 0x36, 0x34	/* t__do_compat_sys_ia32_fstatat64 */
	.byte 0x13, 0x74, 0xaf, 0xed, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0x3d, 0x74, 0x36, 0x34	/* t__pfx___do_compat_sys_ia32_fstat64 */
	.byte 0x13, 0x74, 0xff, 0x64, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0x3d, 0x74, 0x36, 0x34	/* t__do_compat_sys_ia32_fstat64 */
	.byte 0x10, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0x5f, 0xf3, 0x96, 0x14, 0x36, 0x34	/* T__pfx___x64_sys_ia32_truncate64 */
	.byte 0x10, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0x5f, 0xf3, 0x96, 0x14, 0x36, 0x34	/* T__x64_sys_ia32_truncate64 */
	.byte 0x11, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0x5f, 0xf3, 0x96, 0x14, 0x36, 0x34	/* T__pfx___ia32_sys_ia32_truncate64 */
	.byte 0x11, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0x5f, 0xf3, 0x96, 0x14, 0x36, 0x34	/* T__ia32_sys_ia32_truncate64 */
	.byte 0x10, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0xf3, 0x96, 0x14, 0x36, 0x34	/* T__pfx___x64_sys_ia32_ftruncate64 */
	.byte 0x10, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0xf3, 0x96, 0x14, 0x36, 0x34	/* T__x64_sys_ia32_ftruncate64 */
	.byte 0x11, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0xf3, 0x96, 0x14, 0x36, 0x34	/* T__pfx___ia32_sys_ia32_ftruncate64 */
	.byte 0x11, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0xf3, 0x96, 0x14, 0x36, 0x34	/* T__ia32_sys_ia32_ftruncate64 */
	.byte 0x0f, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xec, 0xf7, 0xc8, 0x36, 0x34	/* T__pfx___x64_sys_ia32_pread64 */
	.byte 0x0f, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xec, 0xf7, 0xc8, 0x36, 0x34	/* T__x64_sys_ia32_pread64 */
	.byte 0x10, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xec, 0xf7, 0xc8, 0x36, 0x34	/* T__pfx___ia32_sys_ia32_pread64 */
	.byte 0x10, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xec, 0xf7, 0xc8, 0x36, 0x34	/* T__ia32_sys_ia32_pread64 */
	.byte 0x10, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xec, 0x77, 0x3c, 0x65, 0x36, 0x34	/* T__pfx___x64_sys_ia32_pwrite64 */
	.byte 0x10, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xec, 0x77, 0x3c, 0x65, 0x36, 0x34	/* T__x64_sys_ia32_pwrite64 */
	.byte 0x11, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xec, 0x77, 0x3c, 0x65, 0x36, 0x34	/* T__pfx___ia32_sys_ia32_pwrite64 */
	.byte 0x11, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xec, 0x77, 0x3c, 0x65, 0x36, 0x34	/* T__ia32_sys_ia32_pwrite64 */
	.byte 0x14, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0xc8, 0x76, 0xca, 0x65, 0x36, 0x34, 0x5f, 0x36, 0x34	/* T__pfx___x64_sys_ia32_fadvise64_64 */
	.byte 0x14, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0xc8, 0x76, 0xca, 0x65, 0x36, 0x34, 0x5f, 0x36, 0x34	/* T__x64_sys_ia32_fadvise64_64 */
	.byte 0x15, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0xc8, 0x76, 0xca, 0x65, 0x36, 0x34, 0x5f, 0x36, 0x34	/* T__pfx___ia32_sys_ia32_fadvise64_64 */
	.byte 0x15, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0xc8, 0x76, 0xca, 0x65, 0x36, 0x34, 0x5f, 0x36, 0x34	/* T__ia32_sys_ia32_fadvise64_64 */
	.byte 0x10, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xde, 0xc8, 0x61, 0x68, 0x65, 0xc8	/* T__pfx___x64_sys_ia32_readahead */
	.byte 0x10, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xde, 0xc8, 0x61, 0x68, 0x65, 0xc8	/* T__x64_sys_ia32_readahead */
	.byte 0x11, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xde, 0xc8, 0x61, 0x68, 0x65, 0xc8	/* T__pfx___ia32_sys_ia32_readahead */
	.byte 0x11, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xde, 0xc8, 0x61, 0x68, 0x65, 0xc8	/* T__ia32_sys_ia32_readahead */
	.byte 0x14, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x6e, 0x63, 0xe6, 0x69, 0xb0, 0x72, 0xd2, 0x67, 0x65	/* T__pfx___x64_sys_ia32_sync_file_range */
	.byte 0x14, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x6e, 0x63, 0xe6, 0x69, 0xb0, 0x72, 0xd2, 0x67, 0x65	/* T__x64_sys_ia32_sync_file_range */
	.byte 0x15, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x6e, 0x63, 0xe6, 0x69, 0xb0, 0x72, 0xd2, 0x67, 0x65	/* T__pfx___ia32_sys_ia32_sync_file_range */
	.byte 0x15, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x6e, 0x63, 0xe6, 0x69, 0xb0, 0x72, 0xd2, 0x67, 0x65	/* T__ia32_sys_ia32_sync_file_range */
	.byte 0x11, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0xc8, 0x76, 0xca, 0x65, 0x36, 0x34	/* T__pfx___x64_sys_ia32_fadvise64 */
	.byte 0x11, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0xc8, 0x76, 0xca, 0x65, 0x36, 0x34	/* T__x64_sys_ia32_fadvise64 */
	.byte 0x12, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0xc8, 0x76, 0xca, 0x65, 0x36, 0x34	/* T__pfx___ia32_sys_ia32_fadvise64 */
	.byte 0x12, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0xc8, 0x76, 0xca, 0x65, 0x36, 0x34	/* T__ia32_sys_ia32_fadvise64 */
	.byte 0x0e, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0x22, 0x63, 0x14	/* T__pfx___x64_sys_ia32_fallocate */
	.byte 0x0e, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0x22, 0x63, 0x14	/* T__x64_sys_ia32_fallocate */
	.byte 0x0f, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0x22, 0x63, 0x14	/* T__pfx___ia32_sys_ia32_fallocate */
	.byte 0x0f, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0x22, 0x63, 0x14	/* T__ia32_sys_ia32_fallocate */
	.byte 0x13, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xa9, 0x74, 0x36, 0x34	/* T__pfx___ia32_compat_sys_ia32_stat64 */
	.byte 0x13, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xa9, 0x74, 0x36, 0x34	/* T__ia32_compat_sys_ia32_stat64 */
	.byte 0x15, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x6c, 0x3d, 0x74, 0x36, 0x34	/* T__pfx___ia32_compat_sys_ia32_lstat64 */
	.byte 0x15, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x6c, 0x3d, 0x74, 0x36, 0x34	/* T__ia32_compat_sys_ia32_lstat64 */
	.byte 0x14, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0x3d, 0x74, 0x36, 0x34	/* T__pfx___ia32_compat_sys_ia32_fstat64 */
	.byte 0x14, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0x3d, 0x74, 0x36, 0x34	/* T__ia32_compat_sys_ia32_fstat64 */
	.byte 0x15, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0x3d, 0xf4, 0x74, 0x36, 0x34	/* T__pfx___ia32_compat_sys_ia32_fstatat64 */
	.byte 0x15, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xe6, 0x3d, 0xf4, 0x74, 0x36, 0x34	/* T__ia32_compat_sys_ia32_fstatat64 */
	.byte 0x11, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xc1, 0x97	/* T__pfx___ia32_compat_sys_ia32_mmap */
	.byte 0x11, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xc1, 0x97	/* T__ia32_compat_sys_ia32_mmap */
	.byte 0x13, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xf0, 0x6c, 0xe7, 0x65	/* T__pfx___ia32_compat_sys_ia32_clone */
	.byte 0x13, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x69, 0x61, 0x33, 0x32, 0xf0, 0x6c, 0xe7, 0x65	/* T__ia32_compat_sys_ia32_clone */
	.byte 0x0e, 0xef, 0x69, 0x61, 0x33, 0x32, 0x07, 0x74, 0xd5, 0xfc, 0x85, 0x67, 0x40, 0x74, 0x8e	/* t__pfx_ia32_restore_sigcontext */
	.byte 0x0d, 0xdc, 0x61, 0x33, 0x32, 0x07, 0x74, 0xd5, 0xfc, 0x85, 0x67, 0x40, 0x74, 0x8e	/* tia32_restore_sigcontext */
	.byte 0x10, 0x74, 0xaf, 0xed, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0xf6, 0x0c, 0xf7, 0x74, 0x98, 0x6e	/* t__pfx___do_compat_sys_sigreturn */
	.byte 0x11, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0xf6, 0x0c, 0xf7, 0x74, 0x98, 0x6e	/* T__pfx___ia32_compat_sys_sigreturn */
	.byte 0x10, 0x74, 0xff, 0x64, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0xf6, 0x0c, 0xf7, 0x74, 0x98, 0x6e	/* t__do_compat_sys_sigreturn */
	.byte 0x11, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0xf6, 0x0c, 0xf7, 0x74, 0x98, 0x6e	/* T__ia32_compat_sys_sigreturn */
	.byte 0x12, 0x74, 0xaf, 0xed, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xf7, 0x74, 0x98, 0x6e	/* t__pfx___do_compat_sys_rt_sigreturn */
	.byte 0x13, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xf7, 0x74, 0x98, 0x6e	/* T__pfx___ia32_compat_sys_rt_sigreturn */
	.byte 0x12, 0x74, 0xff, 0x64, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xf7, 0x74, 0x98, 0x6e	/* t__do_compat_sys_rt_sigreturn */
	.byte 0x13, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xf7, 0x74, 0x98, 0x6e	/* T__ia32_compat_sys_rt_sigreturn */
	.byte 0x0b, 0xeb, 0x69, 0x61, 0x33, 0x32, 0xf6, 0xd4, 0xcd, 0xe6, 0xbc, 0xa8	/* T__pfx_ia32_setup_frame */
	.byte 0x0b, 0x54, 0x69, 0x61, 0x33, 0x32, 0xf6, 0xd4, 0xcd, 0xe6, 0xbc, 0xa8	/* Tia32_setup_frame */
	.byte 0x0d, 0xeb, 0x69, 0x61, 0x33, 0x32, 0xf6, 0xd4, 0xcd, 0xa6, 0xfe, 0x66, 0xbc, 0xa8	/* T__pfx_ia32_setup_rt_frame */
	.byte 0x0d, 0x54, 0x69, 0x61, 0x33, 0x32, 0xf6, 0xd4, 0xcd, 0xa6, 0xfe, 0x66, 0xbc, 0xa8	/* Tia32_setup_rt_frame */
	.byte 0x09, 0xef, 0x67, 0xe2, 0xe5, 0x0c, 0x6e, 0x5f, 0xd9, 0x5e	/* t__pfx_get_align_mask */
	.byte 0x09, 0x74, 0x67, 0xe2, 0xe5, 0x0c, 0x6e, 0x5f, 0xd9, 0x5e	/* tget_align_mask */
	.byte 0x08, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x6d, 0x97	/* T__pfx___x64_sys_mmap */
	.byte 0x08, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x6d, 0x97	/* T__x64_sys_mmap */
	.byte 0x09, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x6d, 0x97	/* T__pfx___ia32_sys_mmap */
	.byte 0x09, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x6d, 0x97	/* T__ia32_sys_mmap */
	.byte 0x0c, 0xeb, 0xc5, 0xba, 0x86, 0xe4, 0x97, 0x70, 0x65, 0xda, 0x61, 0xf7, 0x61	/* T__pfx_arch_get_unmapped_area */
	.byte 0x0c, 0x54, 0xc5, 0xba, 0x86, 0xe4, 0x97, 0x70, 0x65, 0xda, 0x61, 0xf7, 0x61	/* Tarch_get_unmapped_area */
	.byte 0x11, 0xeb, 0xc5, 0xba, 0x86, 0xe4, 0x97, 0x70, 0x65, 0xda, 0x61, 0xf7, 0x61, 0xa7, 0xbe, 0x64, 0xad, 0x6e	/* T__pfx_arch_get_unmapped_area_topdown */
	.byte 0x11, 0x54, 0xc5, 0xba, 0x86, 0xe4, 0x97, 0x70, 0x65, 0xda, 0x61, 0xf7, 0x61, 0xa7, 0xbe, 0x64, 0xad, 0x6e	/* Tarch_get_unmapped_area_topdown */
	.byte 0x0a, 0xeb, 0xf8, 0x9d, 0xd6, 0x70, 0xa5, 0x78, 0x5f, 0x61, 0x70	/* T__pfx_init_espfix_ap */
	.byte 0x0a, 0x54, 0xf8, 0x9d, 0xd6, 0x70, 0xa5, 0x78, 0x5f, 0x61, 0x70	/* Tinit_espfix_ap */
	.byte 0x0d, 0xef, 0x62, 0x6f, 0x6f, 0xfe, 0x70, 0xc5, 0x2a, 0x73, 0xed, 0x0a, 0xde, 0xc8	/* t__pfx_boot_params_data_read */
	.byte 0x0d, 0x74, 0x62, 0x6f, 0x6f, 0xfe, 0x70, 0xc5, 0x2a, 0x73, 0xed, 0x0a, 0xde, 0xc8	/* tboot_params_data_read */
	.byte 0x06, 0xef, 0x0b, 0x85, 0xe7, 0xf6, 0x7c	/* t__pfx_version_show */
	.byte 0x06, 0x74, 0x0b, 0x85, 0xe7, 0xf6, 0x7c	/* tversion_show */
	.byte 0x0a, 0xef, 0x73, 0xd4, 0xcd, 0xed, 0x0a, 0xed, 0x0a, 0xde, 0xc8	/* t__pfx_setup_data_data_read */
	.byte 0x09, 0x93, 0xd4, 0xcd, 0xed, 0x0a, 0xed, 0x0a, 0xde, 0xc8	/* tsetup_data_data_read */
	.byte 0x06, 0xef, 0x74, 0x21, 0xfc, 0x73, 0x7c	/* t__pfx_type_show */
	.byte 0x06, 0x74, 0x74, 0x21, 0xfc, 0x73, 0x7c	/* ttype_show */
	.byte 0x0c, 0xeb, 0x65, 0x38, 0x32, 0x30, 0xff, 0x97, 0x70, 0x65, 0xda, 0xd2, 0x79	/* T__pfx_e820__mapped_any */
	.byte 0x0c, 0x54, 0x65, 0x38, 0x32, 0x30, 0xff, 0x97, 0x70, 0x65, 0xda, 0xd2, 0x79	/* Te820__mapped_any */
	.byte 0x0d, 0xeb, 0x65, 0x38, 0x32, 0x30, 0xff, 0x97, 0x70, 0x65, 0xda, 0x7b, 0xd2, 0x79	/* T__pfx_e820__mapped_raw_any */
	.byte 0x0d, 0x54, 0x65, 0x38, 0x32, 0x30, 0xff, 0x97, 0x70, 0x65, 0xda, 0x7b, 0xd2, 0x79	/* Te820__mapped_raw_any */
	.byte 0x0e, 0xeb, 0x65, 0x38, 0x32, 0x30, 0xff, 0x67, 0xe2, 0xf1, 0xf3, 0x79, 0xa7, 0x21, 0x65	/* T__pfx_e820__get_entry_type */
	.byte 0x0e, 0x54, 0x65, 0x38, 0x32, 0x30, 0xff, 0x67, 0xe2, 0xf1, 0xf3, 0x79, 0xa7, 0x21, 0x65	/* Te820__get_entry_type */
	.byte 0x0a, 0xef, 0x76, 0x69, 0x61, 0xbd, 0x6f, 0xed, 0xf2, 0xf0, 0x62	/* t__pfx_via_no_dac_cb */
	.byte 0x0a, 0x74, 0x76, 0x69, 0x61, 0xbd, 0x6f, 0xed, 0xf2, 0xf0, 0x62	/* tvia_no_dac_cb */
	.byte 0x08, 0xef, 0x76, 0x69, 0x61, 0xbd, 0x6f, 0xed, 0xf2	/* t__pfx_via_no_dac */
	.byte 0x08, 0x74, 0x76, 0x69, 0x61, 0xbd, 0x6f, 0xed, 0xf2	/* tvia_no_dac */
	.byte 0x0e, 0xef, 0x66, 0xd5, 0x63, 0xfc, 0x64, 0xca, 0x90, 0xb0, 0x68, 0x70, 0xe2, 0x6d, 0x85	/* t__pfx_force_disable_hpet_msi */
	.byte 0x0e, 0x74, 0x66, 0xd5, 0x63, 0xfc, 0x64, 0xca, 0x90, 0xb0, 0x68, 0x70, 0xe2, 0x6d, 0x85	/* tforce_disable_hpet_msi */
	.byte 0x0f, 0xef, 0xa1, 0xab, 0x6b, 0xbf, 0x74, 0xdb, 0x5f, 0xab, 0x71, 0x62, 0xe5, 0xd2, 0x63, 0x65	/* t__pfx_quirk_intel_irqbalance */
	.byte 0x0f, 0x74, 0xa1, 0xab, 0x6b, 0xbf, 0x74, 0xdb, 0x5f, 0xab, 0x71, 0x62, 0xe5, 0xd2, 0x63, 0x65	/* tquirk_intel_irqbalance */
	.byte 0x0d, 0xef, 0x69, 0xba, 0xe6, 0xd5, 0x63, 0xfc, 0xf1, 0x90, 0xb0, 0x68, 0x70, 0xd4	/* t__pfx_ich_force_enable_hpet */
	.byte 0x0c, 0xdc, 0xba, 0xe6, 0xd5, 0x63, 0xfc, 0xf1, 0x90, 0xb0, 0x68, 0x70, 0xd4	/* tich_force_enable_hpet */
	.byte 0x0f, 0xef, 0xa0, 0xda, 0x69, 0xba, 0xe6, 0xd5, 0x63, 0xfc, 0xf1, 0x90, 0xb0, 0x68, 0x70, 0xd4	/* t__pfx_old_ich_force_enable_hpet */
	.byte 0x0f, 0x74, 0xa0, 0xda, 0x69, 0xba, 0xe6, 0xd5, 0x63, 0xfc, 0xf1, 0x90, 0xb0, 0x68, 0x70, 0xd4	/* told_ich_force_enable_hpet */
	.byte 0x11, 0xef, 0xa0, 0xda, 0x69, 0xba, 0xe6, 0xd5, 0x63, 0xfc, 0xf1, 0x90, 0xb0, 0x68, 0x70, 0xe2, 0xb1, 0xf5	/* t__pfx_old_ich_force_enable_hpet_user */
	.byte 0x11, 0x74, 0xa0, 0xda, 0x69, 0xba, 0xe6, 0xd5, 0x63, 0xfc, 0xf1, 0x90, 0xb0, 0x68, 0x70, 0xe2, 0xb1, 0xf5	/* told_ich_force_enable_hpet_user */
	.byte 0x16, 0xef, 0x2a, 0x64, 0xed, 0xca, 0x90, 0xb0, 0x73, 0x65, 0x71, 0x5f, 0x05, 0xde, 0x64, 0x69, 0xf7, 0x63, 0xfe, 0x73, 0x63, 0x72, 0x88	/* t__pfx_amd_disable_seq_and_redirect_scrub */
	.byte 0x16, 0xf4, 0x6d, 0x64, 0xed, 0xca, 0x90, 0xb0, 0x73, 0x65, 0x71, 0x5f, 0x05, 0xde, 0x64, 0x69, 0xf7, 0x63, 0xfe, 0x73, 0x63, 0x72, 0x88	/* tamd_disable_seq_and_redirect_scrub */
	.byte 0x11, 0xef, 0x76, 0x74, 0x38, 0x32, 0x33, 0x37, 0xe6, 0xd5, 0x63, 0xfc, 0xf1, 0x90, 0xb0, 0x68, 0x70, 0xd4	/* t__pfx_vt8237_force_enable_hpet */
	.byte 0x11, 0x74, 0x76, 0x74, 0x38, 0x32, 0x33, 0x37, 0xe6, 0xd5, 0x63, 0xfc, 0xf1, 0x90, 0xb0, 0x68, 0x70, 0xd4	/* tvt8237_force_enable_hpet */
	.byte 0x10, 0xef, 0x6e, 0x76, 0x9f, 0x69, 0x61, 0xe6, 0xd5, 0x63, 0xfc, 0xf1, 0x90, 0xb0, 0x68, 0x70, 0xd4	/* t__pfx_nvidia_force_enable_hpet */
	.byte 0x10, 0x74, 0x6e, 0x76, 0x9f, 0x69, 0x61, 0xe6, 0xd5, 0x63, 0xfc, 0xf1, 0x90, 0xb0, 0x68, 0x70, 0xd4	/* tnvidia_force_enable_hpet */
	.byte 0x0d, 0xef, 0xe8, 0x69, 0xe6, 0xd5, 0x63, 0xfc, 0xf1, 0x90, 0xb0, 0x68, 0x70, 0xd4	/* t__pfx_ati_force_enable_hpet */
	.byte 0x0c, 0xf4, 0xdc, 0xe6, 0xd5, 0x63, 0xfc, 0xf1, 0x90, 0xb0, 0x68, 0x70, 0xd4	/* tati_force_enable_hpet */
	.byte 0x0c, 0xef, 0xa1, 0xab, 0x6b, 0x5f, 0x2a, 0xda, 0x6e, 0x62, 0xbd, 0xb7, 0x65	/* t__pfx_quirk_amd_nb_node */
	.byte 0x0c, 0x74, 0xa1, 0xab, 0x6b, 0x5f, 0x2a, 0xda, 0x6e, 0x62, 0xbd, 0xb7, 0x65	/* tquirk_amd_nb_node */
	.byte 0x17, 0xef, 0xa1, 0xab, 0x6b, 0xbf, 0x74, 0xdb, 0xb8, 0x72, 0x69, 0xc6, 0x6c, 0xd2, 0xda, 0x78, 0x65, 0xe7, 0x5f, 0xbc, 0x73, 0xf0, 0x61, 0x70	/* t__pfx_quirk_intel_brickland_xeon_ras_cap */
	.byte 0x17, 0x74, 0xa1, 0xab, 0x6b, 0xbf, 0x74, 0xdb, 0xb8, 0x72, 0x69, 0xc6, 0x6c, 0xd2, 0xda, 0x78, 0x65, 0xe7, 0x5f, 0xbc, 0x73, 0xf0, 0x61, 0x70	/* tquirk_intel_brickland_xeon_ras_cap */
	.byte 0x14, 0xef, 0xa1, 0xab, 0x6b, 0xbf, 0x74, 0xdb, 0xec, 0x98, 0xc4, 0x1d, 0x78, 0x65, 0xe7, 0x5f, 0xbc, 0x73, 0xf0, 0x61, 0x70	/* t__pfx_quirk_intel_purley_xeon_ras_cap */
	.byte 0x14, 0x74, 0xa1, 0xab, 0x6b, 0xbf, 0x74, 0xdb, 0xec, 0x98, 0xc4, 0x1d, 0x78, 0x65, 0xe7, 0x5f, 0xbc, 0x73, 0xf0, 0x61, 0x70	/* tquirk_intel_purley_xeon_ras_cap */
	.byte 0x0f, 0xef, 0x65, 0x36, 0x78, 0x78, 0xe6, 0xd5, 0x63, 0xfc, 0xf1, 0x90, 0xb0, 0x68, 0x70, 0xd4	/* t__pfx_e6xx_force_enable_hpet */
	.byte 0x0e, 0x2c, 0x36, 0x78, 0x78, 0xe6, 0xd5, 0x63, 0xfc, 0xf1, 0x90, 0xb0, 0x68, 0x70, 0xd4	/* te6xx_force_enable_hpet */
	.byte 0x0b, 0xeb, 0x66, 0xd5, 0x63, 0xfc, 0x68, 0x70, 0xe2, 0x29, 0x75, 0xa8	/* T__pfx_force_hpet_resume */
	.byte 0x0b, 0x54, 0x66, 0xd5, 0x63, 0xfc, 0x68, 0x70, 0xe2, 0x29, 0x75, 0xa8	/* Tforce_hpet_resume */
	.byte 0x08, 0xef, 0x73, 0xd4, 0xcd, 0xed, 0x0a, 0xde, 0xc8	/* t__pfx_setup_data_read */
	.byte 0x07, 0x93, 0xd4, 0xcd, 0xed, 0x0a, 0xde, 0xc8	/* tsetup_data_read */
	.byte 0x08, 0xef, 0x64, 0x6f, 0x7f, 0x6e, 0x63, 0x3a, 0xf7	/* t__pfx_do_sync_core */
	.byte 0x08, 0x74, 0x64, 0x6f, 0x7f, 0x6e, 0x63, 0x3a, 0xf7	/* tdo_sync_core */
	.byte 0x0c, 0xef, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0xfc, 0xa8, 0x6d, 0x73, 0xd4	/* t__pfx_text_poke_memset */
	.byte 0x0c, 0x74, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0xfc, 0xa8, 0x6d, 0x73, 0xd4	/* ttext_poke_memset */
	.byte 0x0d, 0xef, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0xfc, 0xa8, 0x6d, 0x63, 0x70, 0x79	/* t__pfx_text_poke_memcpy */
	.byte 0x0d, 0x74, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0xfc, 0xa8, 0x6d, 0x63, 0x70, 0x79	/* ttext_poke_memcpy */
	.byte 0x0b, 0xef, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0xfc, 0xdd, 0xc9, 0x0f	/* t__pfx_text_poke_loc_init */
	.byte 0x0b, 0x74, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0xfc, 0xdd, 0xc9, 0x0f	/* ttext_poke_loc_init */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x79, 0xde, 0xdd, 0x63, 0xe8, 0x69, 0xe7	/* t__pfx___apply_relocation */
	.byte 0x0d, 0x74, 0xff, 0x61, 0x70, 0x70, 0x6c, 0x79, 0xde, 0xdd, 0x63, 0xe8, 0x69, 0xe7	/* t__apply_relocation */
	.byte 0x06, 0xef, 0x5e, 0x28, 0xbd, 0xbe, 0x73	/* t__pfx_skip_nops */
	.byte 0x06, 0x93, 0x6b, 0x28, 0xbd, 0xbe, 0x73	/* tskip_nops */
	.byte 0x09, 0xef, 0xbe, 0x00, 0x69, 0x7a, 0xfc, 0x6e, 0xbe, 0x73	/* t__pfx_optimize_nops */
	.byte 0x09, 0x74, 0xbe, 0x00, 0x69, 0x7a, 0xfc, 0x6e, 0xbe, 0x73	/* toptimize_nops */
	.byte 0x09, 0x74, 0xaf, 0xa7, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0x65	/* t__pfx___text_poke */
	.byte 0x09, 0x74, 0xff, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0x65	/* t__text_poke */
	.byte 0x0d, 0xef, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0xfc, 0x62, 0x70, 0xb8, 0xe8, 0xba	/* t__pfx_text_poke_bp_batch */
	.byte 0x0d, 0x74, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0xfc, 0x62, 0x70, 0xb8, 0xe8, 0xba	/* ttext_poke_bp_batch */
	.byte 0x0c, 0xeb, 0x61, 0x70, 0x70, 0x6c, 0x79, 0xde, 0xdd, 0x63, 0xe8, 0x69, 0xe7	/* T__pfx_apply_relocation */
	.byte 0x0c, 0x54, 0x61, 0x70, 0x70, 0x6c, 0x79, 0xde, 0xdd, 0x63, 0xe8, 0x69, 0xe7	/* Tapply_relocation */
	.byte 0x0c, 0xeb, 0x61, 0x70, 0x70, 0x6c, 0x79, 0xe6, 0xf8, 0x65, 0x69, 0x62, 0x74	/* T__pfx_apply_fineibt */
	.byte 0x0c, 0x54, 0x61, 0x70, 0x70, 0x6c, 0x79, 0xe6, 0xf8, 0x65, 0x69, 0x62, 0x74	/* Tapply_fineibt */
	.byte 0x10, 0xeb, 0xe5, 0xa2, 0x6e, 0xe8, 0x69, 0x76, 0xd6, 0xf6, 0xb6, 0xc1, 0xb7, 0x75, 0xb0, 0xc8, 0x64	/* T__pfx_alternatives_smp_module_add */
	.byte 0x10, 0x54, 0xe5, 0xa2, 0x6e, 0xe8, 0x69, 0x76, 0xd6, 0xf6, 0xb6, 0xc1, 0xb7, 0x75, 0xb0, 0xc8, 0x64	/* Talternatives_smp_module_add */
	.byte 0x10, 0xeb, 0xe5, 0xa2, 0x6e, 0xe8, 0x69, 0x76, 0xd6, 0xf6, 0xb6, 0xc1, 0xb7, 0x75, 0xb0, 0x64, 0xdb	/* T__pfx_alternatives_smp_module_del */
	.byte 0x10, 0x54, 0xe5, 0xa2, 0x6e, 0xe8, 0x69, 0x76, 0xd6, 0xf6, 0xb6, 0xc1, 0xb7, 0x75, 0xb0, 0x64, 0xdb	/* Talternatives_smp_module_del */
	.byte 0x0e, 0xeb, 0xe5, 0xa2, 0x6e, 0xe8, 0x69, 0x76, 0x65, 0xe9, 0xf1, 0x90, 0xb0, 0x73, 0xb6	/* T__pfx_alternatives_enable_smp */
	.byte 0x0e, 0x54, 0xe5, 0xa2, 0x6e, 0xe8, 0x69, 0x76, 0x65, 0xe9, 0xf1, 0x90, 0xb0, 0x73, 0xb6	/* Talternatives_enable_smp */
	.byte 0x10, 0xeb, 0xe5, 0xa2, 0x6e, 0xe8, 0x69, 0x76, 0x65, 0xe9, 0x74, 0xcb, 0xfe, 0x29, 0xf5, 0x76, 0x9e	/* T__pfx_alternatives_text_reserved */
	.byte 0x10, 0x54, 0xe5, 0xa2, 0x6e, 0xe8, 0x69, 0x76, 0x65, 0xe9, 0x74, 0xcb, 0xfe, 0x29, 0xf5, 0x76, 0x9e	/* Talternatives_text_reserved */
	.byte 0x0c, 0xeb, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0xfc, 0x65, 0xc5, 0x6c, 0x79	/* T__pfx_text_poke_early */
	.byte 0x0c, 0x54, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0xfc, 0x65, 0xc5, 0x6c, 0x79	/* Ttext_poke_early */
	.byte 0x0d, 0xeb, 0x61, 0x70, 0x70, 0x6c, 0x1d, 0xe5, 0xa2, 0x6e, 0xe8, 0x69, 0x76, 0xd6	/* T__pfx_apply_alternatives */
	.byte 0x0d, 0x54, 0x61, 0x70, 0x70, 0x6c, 0x1d, 0xe5, 0xa2, 0x6e, 0xe8, 0x69, 0x76, 0xd6	/* Tapply_alternatives */
	.byte 0x0b, 0xeb, 0x61, 0x70, 0x70, 0x6c, 0x79, 0xde, 0xce, 0xa0, 0xf8, 0xd6	/* T__pfx_apply_retpolines */
	.byte 0x0b, 0x54, 0x61, 0x70, 0x70, 0x6c, 0x79, 0xde, 0xce, 0xa0, 0xf8, 0xd6	/* Tapply_retpolines */
	.byte 0x0b, 0xeb, 0x61, 0x70, 0x70, 0x6c, 0x79, 0xde, 0x74, 0x98, 0x6e, 0x73	/* T__pfx_apply_returns */
	.byte 0x0b, 0x54, 0x61, 0x70, 0x70, 0x6c, 0x79, 0xde, 0x74, 0x98, 0x6e, 0x73	/* Tapply_returns */
	.byte 0x0d, 0xeb, 0x61, 0x70, 0x70, 0x6c, 0x79, 0xf6, 0x65, 0xe5, 0x0d, 0x64, 0x62, 0x72	/* T__pfx_apply_seal_endbr */
	.byte 0x0d, 0x54, 0x61, 0x70, 0x70, 0x6c, 0x79, 0xf6, 0x65, 0xe5, 0x0d, 0x64, 0x62, 0x72	/* Tapply_seal_endbr */
	.byte 0x08, 0xeb, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0x65	/* T__pfx_text_poke */
	.byte 0x08, 0x54, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0x65	/* Ttext_poke */
	.byte 0x0c, 0xeb, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0xfc, 0x6b, 0x67, 0x64, 0x62	/* T__pfx_text_poke_kgdb */
	.byte 0x0c, 0x54, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0xfc, 0x6b, 0x67, 0x64, 0x62	/* Ttext_poke_kgdb */
	.byte 0x0d, 0xeb, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0xfc, 0x63, 0xbe, 0x1d, 0xa4, 0x9e	/* T__pfx_text_poke_copy_locked */
	.byte 0x0d, 0x54, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0xfc, 0x63, 0xbe, 0x1d, 0xa4, 0x9e	/* Ttext_poke_copy_locked */
	.byte 0x0b, 0xeb, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0xfc, 0x63, 0xbe, 0x79	/* T__pfx_text_poke_copy */
	.byte 0x0b, 0x54, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0xfc, 0x63, 0xbe, 0x79	/* Ttext_poke_copy */
	.byte 0x0a, 0xeb, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0xfc, 0x73, 0xd4	/* T__pfx_text_poke_set */
	.byte 0x0a, 0x54, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0xfc, 0x73, 0xd4	/* Ttext_poke_set */
	.byte 0x0b, 0xeb, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0xfc, 0xe1, 0x6e, 0x63	/* T__pfx_text_poke_sync */
	.byte 0x0b, 0x54, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0xfc, 0xe1, 0x6e, 0x63	/* Ttext_poke_sync */
	.byte 0x0c, 0xeb, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0xfc, 0x66, 0xf8, 0xca, 0x68	/* T__pfx_text_poke_finish */
	.byte 0x0c, 0x54, 0x74, 0xcb, 0xfe, 0x70, 0x6f, 0x6b, 0xfc, 0x66, 0xf8, 0xca, 0x68	/* Ttext_poke_finish */
	.byte 0x0d, 0xeb, 0x68, 0x77, 0xb8, 0xf7, 0x61, 0x6b, 0x70, 0x6f, 0x27, 0x29, 0x8a, 0xf7	/* T__pfx_hw_breakpoint_restore */
	.byte 0x0d, 0x54, 0x68, 0x77, 0xb8, 0xf7, 0x61, 0x6b, 0x70, 0x6f, 0x27, 0x29, 0x8a, 0xf7	/* Thw_breakpoint_restore */
	.byte 0x06, 0xeb, 0xf1, 0x63, 0x16, 0xac, 0x37	/* T__pfx_encode_dr7 */
	.byte 0x06, 0x54, 0xf1, 0x63, 0x16, 0xac, 0x37	/* Tencode_dr7 */
	.byte 0x06, 0xeb, 0x64, 0xb4, 0x16, 0xac, 0x37	/* T__pfx_decode_dr7 */
	.byte 0x06, 0x54, 0x64, 0xb4, 0x16, 0xac, 0x37	/* Tdecode_dr7 */
	.byte 0x10, 0xeb, 0xc5, 0xba, 0xbf, 0x3d, 0x6c, 0x6c, 0xa3, 0x77, 0xb8, 0xf7, 0x61, 0x6b, 0x70, 0x6f, 0xb3	/* T__pfx_arch_install_hw_breakpoint */
	.byte 0x10, 0x54, 0xc5, 0xba, 0xbf, 0x3d, 0x6c, 0x6c, 0xa3, 0x77, 0xb8, 0xf7, 0x61, 0x6b, 0x70, 0x6f, 0xb3	/* Tarch_install_hw_breakpoint */
	.byte 0x12, 0xeb, 0xc5, 0xba, 0x5f, 0xe4, 0xf8, 0x3d, 0x6c, 0x6c, 0xa3, 0x77, 0xb8, 0xf7, 0x61, 0x6b, 0x70, 0x6f, 0xb3	/* T__pfx_arch_uninstall_hw_breakpoint */
	.byte 0x12, 0x54, 0xc5, 0xba, 0x5f, 0xe4, 0xf8, 0x3d, 0x6c, 0x6c, 0xa3, 0x77, 0xb8, 0xf7, 0x61, 0x6b, 0x70, 0x6f, 0xb3	/* Tarch_uninstall_hw_breakpoint */
	.byte 0x0e, 0xeb, 0xc5, 0xba, 0xb8, 0x70, 0xc7, 0xf1, 0xf5, 0xaa, 0xe6, 0x69, 0xdb, 0x64, 0x73	/* T__pfx_arch_bp_generic_fields */
	.byte 0x0e, 0x54, 0xc5, 0xba, 0xb8, 0x70, 0xc7, 0xf1, 0xf5, 0xaa, 0xe6, 0x69, 0xdb, 0x64, 0x73	/* Tarch_bp_generic_fields */
	.byte 0x12, 0xeb, 0xc5, 0xba, 0x25, 0x65, 0xc6, 0xb8, 0x70, 0xbf, 0x5f, 0x6b, 0xf5, 0x6e, 0xdb, 0x73, 0x70, 0xf2, 0x65	/* T__pfx_arch_check_bp_in_kernelspace */
	.byte 0x12, 0x54, 0xc5, 0xba, 0x25, 0x65, 0xc6, 0xb8, 0x70, 0xbf, 0x5f, 0x6b, 0xf5, 0x6e, 0xdb, 0x73, 0x70, 0xf2, 0x65	/* Tarch_check_bp_in_kernelspace */
	.byte 0x10, 0xeb, 0x68, 0x77, 0xb8, 0xf7, 0x61, 0x6b, 0x70, 0x6f, 0x27, 0xc5, 0xba, 0xec, 0xc5, 0x73, 0x65	/* T__pfx_hw_breakpoint_arch_parse */
	.byte 0x10, 0x54, 0x68, 0x77, 0xb8, 0xf7, 0x61, 0x6b, 0x70, 0x6f, 0x27, 0xc5, 0xba, 0xec, 0xc5, 0x73, 0x65	/* Thw_breakpoint_arch_parse */
	.byte 0x10, 0xeb, 0x66, 0x6c, 0xb1, 0x68, 0xec, 0xc3, 0x68, 0x77, 0xb8, 0xf7, 0x61, 0x6b, 0x70, 0x6f, 0xb3	/* T__pfx_flush_ptrace_hw_breakpoint */
	.byte 0x10, 0x54, 0x66, 0x6c, 0xb1, 0x68, 0xec, 0xc3, 0x68, 0x77, 0xb8, 0xf7, 0x61, 0x6b, 0x70, 0x6f, 0xb3	/* Tflush_ptrace_hw_breakpoint */
	.byte 0x16, 0xeb, 0x68, 0x77, 0xb8, 0xf7, 0x61, 0x6b, 0x70, 0x6f, 0x27, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0xe9, 0x6e, 0x6f, 0xdc, 0x66, 0x79	/* T__pfx_hw_breakpoint_exceptions_notify */
	.byte 0x16, 0x54, 0x68, 0x77, 0xb8, 0xf7, 0x61, 0x6b, 0x70, 0x6f, 0x27, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0xe9, 0x6e, 0x6f, 0xdc, 0x66, 0x79	/* Thw_breakpoint_exceptions_notify */
	.byte 0x0f, 0xeb, 0x68, 0x77, 0xb8, 0xf7, 0x61, 0x6b, 0x70, 0x6f, 0x27, 0x70, 0x6d, 0x75, 0xde, 0xc8	/* T__pfx_hw_breakpoint_pmu_read */
	.byte 0x0f, 0x54, 0x68, 0x77, 0xb8, 0xf7, 0x61, 0x6b, 0x70, 0x6f, 0x27, 0x70, 0x6d, 0x75, 0xde, 0xc8	/* Thw_breakpoint_pmu_read */
	.byte 0x0b, 0xeb, 0xba, 0x65, 0xc6, 0xa7, 0x73, 0xc9, 0xe4, 0x73, 0xe0, 0xc4	/* T__pfx_check_tsc_unstable */
	.byte 0x0b, 0x54, 0xba, 0x65, 0xc6, 0xa7, 0x73, 0xc9, 0xe4, 0x73, 0xe0, 0xc4	/* Tcheck_tsc_unstable */
	.byte 0x0e, 0xeb, 0xf7, 0x63, 0xe5, 0x69, 0x62, 0x72, 0x91, 0x63, 0x9c, 0x5f, 0x6b, 0x68, 0x7a	/* T__pfx_recalibrate_cpu_khz */
	.byte 0x0e, 0x54, 0xf7, 0x63, 0xe5, 0x69, 0x62, 0x72, 0x91, 0x63, 0x9c, 0x5f, 0x6b, 0x68, 0x7a	/* Trecalibrate_cpu_khz */
	.byte 0x06, 0xef, 0xf7, 0x61, 0xda, 0x93, 0x63	/* t__pfx_read_tsc */
	.byte 0x06, 0x74, 0xf7, 0x61, 0xda, 0x93, 0x63	/* tread_tsc */
	.byte 0x08, 0xef, 0x93, 0x63, 0xf0, 0xe9, 0xf1, 0x90, 0xc4	/* t__pfx_tsc_cs_enable */
	.byte 0x08, 0x74, 0x93, 0x63, 0xf0, 0xe9, 0xf1, 0x90, 0xc4	/* ttsc_cs_enable */
	.byte 0x0d, 0x74, 0xaf, 0x84, 0x63, 0x79, 0x63, 0x32, 0x6e, 0x73, 0xf6, 0x63, 0xe5, 0x65	/* t__pfx___set_cyc2ns_scale */
	.byte 0x0e, 0x74, 0xff, 0x73, 0xe2, 0x63, 0x79, 0x63, 0x32, 0x6e, 0x73, 0xf6, 0x63, 0xe5, 0x65	/* t__set_cyc2ns_scale */
	.byte 0x06, 0xef, 0x93, 0x63, 0x07, 0x75, 0xa8	/* t__pfx_tsc_resume */
	.byte 0x06, 0x74, 0x93, 0x63, 0x07, 0x75, 0xa8	/* ttsc_resume */
	.byte 0x07, 0xef, 0x93, 0x63, 0xde, 0xc8, 0xde, 0x95	/* t__pfx_tsc_read_refs */
	.byte 0x07, 0x74, 0x93, 0x63, 0xde, 0xc8, 0xde, 0x95	/* ttsc_read_refs */
	.byte 0x0a, 0xef, 0x93, 0x63, 0xf0, 0xe9, 0xdc, 0xc6, 0xf6, 0xe0, 0xc4	/* t__pfx_tsc_cs_tick_stable */
	.byte 0x0a, 0x74, 0x93, 0x63, 0xf0, 0xe9, 0xdc, 0xc6, 0xf6, 0xe0, 0xc4	/* ttsc_cs_tick_stable */
	.byte 0x0d, 0xef, 0x93, 0x63, 0xf0, 0xe9, 0xd9, 0x72, 0x6b, 0x5f, 0xe4, 0x73, 0xe0, 0xc4	/* t__pfx_tsc_cs_mark_unstable */
	.byte 0x0d, 0x74, 0x93, 0x63, 0xf0, 0xe9, 0xd9, 0x72, 0x6b, 0x5f, 0xe4, 0x73, 0xe0, 0xc4	/* ttsc_cs_mark_unstable */
	.byte 0x12, 0xef, 0x93, 0x63, 0xde, 0x66, 0xf8, 0xfc, 0x63, 0xe5, 0x69, 0x62, 0x72, 0xe8, 0x69, 0xe7, 0x92, 0xd5, 0x6b	/* t__pfx_tsc_refine_calibration_work */
	.byte 0x12, 0x74, 0x93, 0x63, 0xde, 0x66, 0xf8, 0xfc, 0x63, 0xe5, 0x69, 0x62, 0x72, 0xe8, 0x69, 0xe7, 0x92, 0xd5, 0x6b	/* ttsc_refine_calibration_work */
	.byte 0x11, 0xef, 0xb2, 0xfe, 0x68, 0x70, 0xe2, 0x70, 0x00, 0xf5, 0xf0, 0xe5, 0x69, 0x62, 0x72, 0x91, 0x63, 0x9c	/* t__pfx_pit_hpet_ptimer_calibrate_cpu */
	.byte 0x10, 0xce, 0x9d, 0x68, 0x70, 0xe2, 0x70, 0x00, 0xf5, 0xf0, 0xe5, 0x69, 0x62, 0x72, 0x91, 0x63, 0x9c	/* tpit_hpet_ptimer_calibrate_cpu */
	.byte 0x0c, 0xef, 0xa1, 0x69, 0xc6, 0xec, 0x9d, 0x63, 0xe5, 0x69, 0x62, 0x72, 0x14	/* t__pfx_quick_pit_calibrate */
	.byte 0x0c, 0x74, 0xa1, 0x69, 0xc6, 0xec, 0x9d, 0x63, 0xe5, 0x69, 0x62, 0x72, 0x14	/* tquick_pit_calibrate */
	.byte 0x12, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0x63, 0xe5, 0x69, 0x62, 0x72, 0x91, 0x63, 0x9c, 0x5f, 0x65, 0xc5, 0x6c, 0x79	/* T__pfx_native_calibrate_cpu_early */
	.byte 0x12, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0x63, 0xe5, 0x69, 0x62, 0x72, 0x91, 0x63, 0x9c, 0x5f, 0x65, 0xc5, 0x6c, 0x79	/* Tnative_calibrate_cpu_early */
	.byte 0x0d, 0xef, 0x6e, 0xe8, 0x69, 0x1a, 0x63, 0xe5, 0x69, 0x62, 0x72, 0x91, 0x63, 0x9c	/* t__pfx_native_calibrate_cpu */
	.byte 0x0d, 0x74, 0x6e, 0xe8, 0x69, 0x1a, 0x63, 0xe5, 0x69, 0x62, 0x72, 0x91, 0x63, 0x9c	/* tnative_calibrate_cpu */
	.byte 0x0b, 0xeb, 0xd9, 0x72, 0x6b, 0xa7, 0x73, 0xc9, 0xe4, 0x73, 0xe0, 0xc4	/* T__pfx_mark_tsc_unstable */
	.byte 0x0b, 0x54, 0xd9, 0x72, 0x6b, 0xa7, 0x73, 0xc9, 0xe4, 0x73, 0xe0, 0xc4	/* Tmark_tsc_unstable */
	.byte 0x0d, 0xef, 0x00, 0xfc, 0x63, 0x9c, 0x66, 0xf7, 0x71, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5	/* t__pfx_time_cpufreq_notifier */
	.byte 0x0d, 0x74, 0x00, 0xfc, 0x63, 0x9c, 0x66, 0xf7, 0x71, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5	/* ttime_cpufreq_notifier */
	.byte 0x09, 0x99, 0xf0, 0x79, 0x63, 0x32, 0x6e, 0xe9, 0xf7, 0xc8	/* T__pfx___cyc2ns_read */
	.byte 0x09, 0xb9, 0x63, 0x79, 0x63, 0x32, 0x6e, 0xe9, 0xf7, 0xc8	/* T__cyc2ns_read */
	.byte 0x0e, 0xeb, 0x63, 0x79, 0x63, 0x32, 0x6e, 0xe9, 0xf7, 0x61, 0xda, 0x62, 0x65, 0x67, 0xf8	/* T__pfx_cyc2ns_read_begin */
	.byte 0x0e, 0x54, 0x63, 0x79, 0x63, 0x32, 0x6e, 0xe9, 0xf7, 0x61, 0xda, 0x62, 0x65, 0x67, 0xf8	/* Tcyc2ns_read_begin */
	.byte 0x0c, 0xeb, 0x63, 0x79, 0x63, 0x32, 0x6e, 0xe9, 0xf7, 0x61, 0xda, 0xf1, 0x64	/* T__pfx_cyc2ns_read_end */
	.byte 0x0c, 0x54, 0x63, 0x79, 0x63, 0x32, 0x6e, 0xe9, 0xf7, 0x61, 0xda, 0xf1, 0x64	/* Tcyc2ns_read_end */
	.byte 0x0f, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0x73, 0xba, 0x9e, 0xf0, 0xa4, 0xe6, 0xe3, 0xae, 0x93, 0x63	/* T__pfx_native_sched_clock_from_tsc */
	.byte 0x0f, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0x73, 0xba, 0x9e, 0xf0, 0xa4, 0xe6, 0xe3, 0xae, 0x93, 0x63	/* Tnative_sched_clock_from_tsc */
	.byte 0x0c, 0xeb, 0xb1, 0x8d, 0xbd, 0xe8, 0x69, 0x1a, 0x73, 0xba, 0x9e, 0xf0, 0xa4	/* T__pfx_using_native_sched_clock */
	.byte 0x0c, 0x54, 0xb1, 0x8d, 0xbd, 0xe8, 0x69, 0x1a, 0x73, 0xba, 0x9e, 0xf0, 0xa4	/* Tusing_native_sched_clock */
	.byte 0x06, 0xeb, 0x73, 0xba, 0x9e, 0xf0, 0xa4	/* T__pfx_sched_clock */
	.byte 0x06, 0x54, 0x73, 0xba, 0x9e, 0xf0, 0xa4	/* Tsched_clock */
	.byte 0x0d, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0x63, 0xe5, 0x69, 0x62, 0x72, 0x91, 0x93, 0x63	/* T__pfx_native_calibrate_tsc */
	.byte 0x0d, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0x63, 0xe5, 0x69, 0x62, 0x72, 0x91, 0x93, 0x63	/* Tnative_calibrate_tsc */
	.byte 0x0d, 0xeb, 0x93, 0x63, 0xf6, 0x61, 0x1a, 0x73, 0xba, 0x9e, 0xf0, 0xa4, 0xa9, 0x2c	/* T__pfx_tsc_save_sched_clock_state */
	.byte 0x0d, 0x54, 0x93, 0x63, 0xf6, 0x61, 0x1a, 0x73, 0xba, 0x9e, 0xf0, 0xa4, 0xa9, 0x2c	/* Ttsc_save_sched_clock_state */
	.byte 0x0e, 0xeb, 0x93, 0x63, 0x07, 0x74, 0xd5, 0xfc, 0x73, 0xba, 0x9e, 0xf0, 0xa4, 0xa9, 0x2c	/* T__pfx_tsc_restore_sched_clock_state */
	.byte 0x0e, 0x54, 0x93, 0x63, 0x07, 0x74, 0xd5, 0xfc, 0x73, 0xba, 0x9e, 0xf0, 0xa4, 0xa9, 0x2c	/* Ttsc_restore_sched_clock_state */
	.byte 0x15, 0xeb, 0x93, 0x63, 0xf0, 0xa4, 0x73, 0x6f, 0x98, 0x63, 0xfc, 0x77, 0xe8, 0xba, 0x64, 0x6f, 0x67, 0xed, 0xca, 0x90, 0xc4, 0x64	/* T__pfx_tsc_clocksource_watchdog_disabled */
	.byte 0x15, 0x54, 0x93, 0x63, 0xf0, 0xa4, 0x73, 0x6f, 0x98, 0x63, 0xfc, 0x77, 0xe8, 0xba, 0x64, 0x6f, 0x67, 0xed, 0xca, 0x90, 0xc4, 0x64	/* Ttsc_clocksource_watchdog_disabled */
	.byte 0x0d, 0xeb, 0xe4, 0xe1, 0x6e, 0xba, 0x72, 0xe7, 0x69, 0x7a, 0x65, 0xda, 0x93, 0x63	/* T__pfx_unsynchronized_tsc */
	.byte 0x0d, 0x54, 0xe4, 0xe1, 0x6e, 0xba, 0x72, 0xe7, 0x69, 0x7a, 0x65, 0xda, 0x93, 0x63	/* Tunsynchronized_tsc */
	.byte 0x11, 0xeb, 0x63, 0xe5, 0x69, 0x62, 0x72, 0x91, 0x64, 0xdb, 0x61, 0x1d, 0x69, 0xe9, 0x6b, 0x6e, 0xad, 0x6e	/* T__pfx_calibrate_delay_is_known */
	.byte 0x11, 0x54, 0x63, 0xe5, 0x69, 0x62, 0x72, 0x91, 0x64, 0xdb, 0x61, 0x1d, 0x69, 0xe9, 0x6b, 0x6e, 0xad, 0x6e	/* Tcalibrate_delay_is_known */
	.byte 0x0d, 0xeb, 0x63, 0x9c, 0x5f, 0x6b, 0x68, 0x7a, 0xe6, 0xe3, 0x6d, 0xc1, 0x73, 0x72	/* T__pfx_cpu_khz_from_msr */
	.byte 0x0d, 0x54, 0x63, 0x9c, 0x5f, 0x6b, 0x68, 0x7a, 0xe6, 0xe3, 0x6d, 0xc1, 0x73, 0x72	/* Tcpu_khz_from_msr */
	.byte 0x0a, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0xc0, 0xed, 0xdb, 0x61, 0x79	/* T__pfx_native_io_delay */
	.byte 0x0a, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0xc0, 0xed, 0xdb, 0x61, 0x79	/* Tnative_io_delay */
	.byte 0x08, 0xeb, 0x72, 0x26, 0xf0, 0x17, 0xe9, 0xf7, 0xc8	/* T__pfx_rtc_cmos_read */
	.byte 0x08, 0x54, 0x72, 0x26, 0xf0, 0x17, 0xe9, 0xf7, 0xc8	/* Trtc_cmos_read */
	.byte 0x09, 0xeb, 0x72, 0x26, 0xf0, 0x17, 0xe9, 0x77, 0x3c, 0x65	/* T__pfx_rtc_cmos_write */
	.byte 0x09, 0x54, 0x72, 0x26, 0xf0, 0x17, 0xe9, 0x77, 0x3c, 0x65	/* Trtc_cmos_write */
	.byte 0x0a, 0xeb, 0x6d, 0xf2, 0x68, 0x84, 0x63, 0x17, 0xe9, 0xdc, 0xa8	/* T__pfx_mach_set_cmos_time */
	.byte 0x0a, 0x54, 0x6d, 0xf2, 0x68, 0x84, 0x63, 0x17, 0xe9, 0xdc, 0xa8	/* Tmach_set_cmos_time */
	.byte 0x0a, 0xeb, 0x6d, 0xf2, 0x68, 0x86, 0x63, 0x17, 0xe9, 0xdc, 0xa8	/* T__pfx_mach_get_cmos_time */
	.byte 0x0a, 0x54, 0x6d, 0xf2, 0x68, 0x86, 0x63, 0x17, 0xe9, 0xdc, 0xa8	/* Tmach_get_cmos_time */
	.byte 0x0e, 0xeb, 0xcd, 0x64, 0x91, 0x19, 0x73, 0xca, 0x74, 0xf1, 0xfe, 0x63, 0xa4, 0x36, 0x34	/* T__pfx_update_persistent_clock64 */
	.byte 0x0e, 0x54, 0xcd, 0x64, 0x91, 0x19, 0x73, 0xca, 0x74, 0xf1, 0xfe, 0x63, 0xa4, 0x36, 0x34	/* Tupdate_persistent_clock64 */
	.byte 0x0e, 0xeb, 0xf7, 0xc8, 0xec, 0xf5, 0x73, 0xca, 0x74, 0xf1, 0xfe, 0x63, 0xa4, 0x36, 0x34	/* T__pfx_read_persistent_clock64 */
	.byte 0x0e, 0x54, 0xf7, 0xc8, 0xec, 0xf5, 0x73, 0xca, 0x74, 0xf1, 0xfe, 0x63, 0xa4, 0x36, 0x34	/* Tread_persistent_clock64 */
	.byte 0x0d, 0xeb, 0xc5, 0xba, 0xde, 0x17, 0x1a, 0x29, 0xf5, 0x76, 0xe8, 0x69, 0xe7, 0x73	/* T__pfx_arch_remove_reservations */
	.byte 0x0d, 0x54, 0xc5, 0xba, 0xde, 0x17, 0x1a, 0x29, 0xf5, 0x76, 0xe8, 0x69, 0xe7, 0x73	/* Tarch_remove_reservations */
	.byte 0x0a, 0x99, 0xa9, 0xdc, 0x63, 0xf0, 0x5d, 0xde, 0x74, 0x98, 0x6e	/* T__pfx___static_call_return */
	.byte 0x0a, 0xb9, 0x3d, 0xdc, 0x63, 0xf0, 0x5d, 0xde, 0x74, 0x98, 0x6e	/* T__static_call_return */
	.byte 0x0c, 0x74, 0xaf, 0xa9, 0xdc, 0x63, 0xf0, 0x5d, 0x5f, 0x76, 0xe5, 0x9f, 0x14	/* t__pfx___static_call_validate */
	.byte 0x0c, 0x74, 0xff, 0x3d, 0xdc, 0x63, 0xf0, 0x5d, 0x5f, 0x76, 0xe5, 0x9f, 0x14	/* t__static_call_validate */
	.byte 0x0f, 0xeb, 0xc5, 0xba, 0xa9, 0xdc, 0x63, 0xf0, 0x5d, 0x5f, 0xf3, 0xd2, 0x73, 0x66, 0xd5, 0x6d	/* T__pfx_arch_static_call_transform */
	.byte 0x0f, 0x54, 0xc5, 0xba, 0xa9, 0xdc, 0x63, 0xf0, 0x5d, 0x5f, 0xf3, 0xd2, 0x73, 0x66, 0xd5, 0x6d	/* Tarch_static_call_transform */
	.byte 0x0a, 0x99, 0xa9, 0xdc, 0x63, 0xf0, 0x5d, 0xe6, 0x69, 0x78, 0xcd	/* T__pfx___static_call_fixup */
	.byte 0x0a, 0xb9, 0x3d, 0xdc, 0x63, 0xf0, 0x5d, 0xe6, 0x69, 0x78, 0xcd	/* T__static_call_fixup */
	.byte 0x11, 0xef, 0x73, 0x70, 0xb4, 0x02, 0xe8, 0x69, 0xe7, 0xf0, 0xf3, 0x6c, 0x5f, 0xcd, 0x64, 0x91, 0xdc, 0x66	/* t__pfx_speculation_ctrl_update_tif */
	.byte 0x10, 0x93, 0x70, 0xb4, 0x02, 0xe8, 0x69, 0xe7, 0xf0, 0xf3, 0x6c, 0x5f, 0xcd, 0x64, 0x91, 0xdc, 0x66	/* tspeculation_ctrl_update_tif */
	.byte 0x07, 0xef, 0xf1, 0x90, 0xb0, 0x63, 0x9c, 0x9f	/* t__pfx_enable_cpuid */
	.byte 0x07, 0x74, 0xf1, 0x90, 0xb0, 0x63, 0x9c, 0x9f	/* tenable_cpuid */
	.byte 0x0d, 0xeb, 0xc5, 0xba, 0xed, 0xcd, 0x5f, 0xf4, 0x5e, 0xf6, 0xf3, 0x75, 0x63, 0x74	/* T__pfx_arch_dup_task_struct */
	.byte 0x0d, 0x54, 0xc5, 0xba, 0xed, 0xcd, 0x5f, 0xf4, 0x5e, 0xf6, 0xf3, 0x75, 0x63, 0x74	/* Tarch_dup_task_struct */
	.byte 0x0e, 0xeb, 0xc5, 0xba, 0xde, 0xc4, 0xbb, 0xfc, 0xf4, 0x5e, 0xf6, 0xf3, 0x75, 0x63, 0x74	/* T__pfx_arch_release_task_struct */
	.byte 0x0e, 0x54, 0xc5, 0xba, 0xde, 0xc4, 0xbb, 0xfc, 0xf4, 0x5e, 0xf6, 0xf3, 0x75, 0x63, 0x74	/* Tarch_release_task_struct */
	.byte 0x07, 0xeb, 0xcb, 0x9d, 0x74, 0x68, 0xf7, 0xc8	/* T__pfx_exit_thread */
	.byte 0x07, 0x54, 0xcb, 0x9d, 0x74, 0x68, 0xf7, 0xc8	/* Texit_thread */
	.byte 0x09, 0xeb, 0xf7, 0xfe, 0x66, 0xe3, 0x6d, 0xe6, 0xd5, 0x6b	/* T__pfx_ret_from_fork */
	.byte 0x09, 0x54, 0xf7, 0xfe, 0x66, 0xe3, 0x6d, 0xe6, 0xd5, 0x6b	/* Tret_from_fork */
	.byte 0x08, 0xeb, 0x63, 0xbe, 0x79, 0xa7, 0x68, 0xf7, 0xc8	/* T__pfx_copy_thread */
	.byte 0x08, 0x54, 0x63, 0xbe, 0x79, 0xa7, 0x68, 0xf7, 0xc8	/* Tcopy_thread */
	.byte 0x09, 0xeb, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x68, 0xf7, 0xc8	/* T__pfx_flush_thread */
	.byte 0x09, 0x54, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x68, 0xf7, 0xc8	/* Tflush_thread */
	.byte 0x07, 0xeb, 0x64, 0xca, 0x90, 0xb0, 0x54, 0x87	/* T__pfx_disable_TSC */
	.byte 0x07, 0x54, 0x64, 0xca, 0x90, 0xb0, 0x54, 0x87	/* Tdisable_TSC */
	.byte 0x08, 0xeb, 0x67, 0xe2, 0x93, 0xc9, 0x6d, 0xb7, 0x65	/* T__pfx_get_tsc_mode */
	.byte 0x08, 0x54, 0x67, 0xe2, 0x93, 0xc9, 0x6d, 0xb7, 0x65	/* Tget_tsc_mode */
	.byte 0x08, 0xeb, 0x73, 0xe2, 0x93, 0xc9, 0x6d, 0xb7, 0x65	/* T__pfx_set_tsc_mode */
	.byte 0x08, 0x54, 0x73, 0xe2, 0x93, 0xc9, 0x6d, 0xb7, 0x65	/* Tset_tsc_mode */
	.byte 0x0e, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0x93, 0xe9, 0xcd, 0x64, 0x91, 0xc0, 0xb8, 0xea, 0x97	/* T__pfx_native_tss_update_io_bitmap */
	.byte 0x0e, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0x93, 0xe9, 0xcd, 0x64, 0x91, 0xc0, 0xb8, 0xea, 0x97	/* Tnative_tss_update_io_bitmap */
	.byte 0x13, 0xeb, 0x73, 0x70, 0xb4, 0x02, 0xe8, 0x69, 0x1a, 0x73, 0x74, 0xd5, 0xfc, 0x62, 0x21, 0xbb, 0xe9, 0x68, 0xfe, 0x0f	/* T__pfx_speculative_store_bypass_ht_init */
	.byte 0x13, 0x54, 0x73, 0x70, 0xb4, 0x02, 0xe8, 0x69, 0x1a, 0x73, 0x74, 0xd5, 0xfc, 0x62, 0x21, 0xbb, 0xe9, 0x68, 0xfe, 0x0f	/* Tspeculative_store_bypass_ht_init */
	.byte 0x0f, 0xeb, 0x73, 0x70, 0xb4, 0x02, 0xe8, 0x69, 0xe7, 0xf0, 0xf3, 0x6c, 0x5f, 0xcd, 0x64, 0x14	/* T__pfx_speculation_ctrl_update */
	.byte 0x0f, 0x54, 0x73, 0x70, 0xb4, 0x02, 0xe8, 0x69, 0xe7, 0xf0, 0xf3, 0x6c, 0x5f, 0xcd, 0x64, 0x14	/* Tspeculation_ctrl_update */
	.byte 0x0b, 0xeb, 0xc5, 0xba, 0xf6, 0xd4, 0xcd, 0xbd, 0x65, 0x8f, 0xcb, 0xb4	/* T__pfx_arch_setup_new_exec */
	.byte 0x0b, 0x54, 0xc5, 0xba, 0xf6, 0xd4, 0xcd, 0xbd, 0x65, 0x8f, 0xcb, 0xb4	/* Tarch_setup_new_exec */
	.byte 0x14, 0xeb, 0x73, 0x70, 0xb4, 0x02, 0xe8, 0x69, 0xe7, 0xf0, 0xf3, 0x6c, 0x5f, 0xcd, 0x64, 0x91, 0x63, 0x98, 0xf7, 0x6e, 0x74	/* T__pfx_speculation_ctrl_update_current */
	.byte 0x14, 0x54, 0x73, 0x70, 0xb4, 0x02, 0xe8, 0x69, 0xe7, 0xf0, 0xf3, 0x6c, 0x5f, 0xcd, 0x64, 0x91, 0x63, 0x98, 0xf7, 0x6e, 0x74	/* Tspeculation_ctrl_update_current */
	.byte 0x0b, 0x99, 0xf6, 0x77, 0xea, 0xba, 0xa7, 0x6f, 0x5f, 0x78, 0xf3, 0x61	/* T__pfx___switch_to_xtra */
	.byte 0x0b, 0xb9, 0x73, 0x77, 0xea, 0xba, 0xa7, 0x6f, 0x5f, 0x78, 0xf3, 0x61	/* T__switch_to_xtra */
	.byte 0x0a, 0xeb, 0xc5, 0xba, 0xf0, 0x9c, 0x5f, 0x9f, 0xb0, 0xf1, 0xa2	/* T__pfx_arch_cpu_idle_enter */
	.byte 0x0a, 0x54, 0xc5, 0xba, 0xf0, 0x9c, 0x5f, 0x9f, 0xb0, 0xf1, 0xa2	/* Tarch_cpu_idle_enter */
	.byte 0x0b, 0xeb, 0xc5, 0xba, 0xf0, 0x9c, 0x5f, 0x9f, 0xb0, 0x64, 0x65, 0xc8	/* T__pfx_arch_cpu_idle_dead */
	.byte 0x0b, 0x54, 0xc5, 0xba, 0xf0, 0x9c, 0x5f, 0x9f, 0xb0, 0x64, 0x65, 0xc8	/* Tarch_cpu_idle_dead */
	.byte 0x09, 0xeb, 0x73, 0x74, 0xbe, 0xa7, 0x68, 0xca, 0xf0, 0x9c	/* T__pfx_stop_this_cpu */
	.byte 0x09, 0x54, 0x73, 0x74, 0xbe, 0xa7, 0x68, 0xca, 0xf0, 0x9c	/* Tstop_this_cpu */
	.byte 0x10, 0xeb, 0x2a, 0xda, 0x65, 0x34, 0x30, 0x30, 0xf0, 0x31, 0xfc, 0x61, 0xb2, 0x63, 0xf6, 0xd4, 0xcd	/* T__pfx_amd_e400_c1e_apic_setup */
	.byte 0x10, 0x54, 0x2a, 0xda, 0x65, 0x34, 0x30, 0x30, 0xf0, 0x31, 0xfc, 0x61, 0xb2, 0x63, 0xf6, 0xd4, 0xcd	/* Tamd_e400_c1e_apic_setup */
	.byte 0x09, 0xeb, 0xc5, 0xba, 0x5f, 0xe5, 0x0c, 0x6e, 0xa9, 0xc6	/* T__pfx_arch_align_stack */
	.byte 0x09, 0x54, 0xc5, 0xba, 0x5f, 0xe5, 0x0c, 0x6e, 0xa9, 0xc6	/* Tarch_align_stack */
	.byte 0x0d, 0xeb, 0xc5, 0xba, 0xa6, 0x05, 0x6f, 0x6d, 0x69, 0x7a, 0xfc, 0x62, 0x72, 0x6b	/* T__pfx_arch_randomize_brk */
	.byte 0x0d, 0x54, 0xc5, 0xba, 0xa6, 0x05, 0x6f, 0x6d, 0x69, 0x7a, 0xfc, 0x62, 0x72, 0x6b	/* Tarch_randomize_brk */
	.byte 0x05, 0x99, 0x86, 0x77, 0xba, 0xd2	/* T__pfx___get_wchan */
	.byte 0x06, 0xb9, 0x67, 0xe2, 0x77, 0xba, 0xd2	/* T__get_wchan */
	.byte 0x0e, 0xeb, 0x64, 0x6f, 0x5f, 0xc5, 0xba, 0xec, 0x72, 0x63, 0x23, 0x3a, 0x6d, 0x6d, 0xe7	/* T__pfx_do_arch_prctl_common */
	.byte 0x0e, 0x54, 0x64, 0x6f, 0x5f, 0xc5, 0xba, 0xec, 0x72, 0x63, 0x23, 0x3a, 0x6d, 0x6d, 0xe7	/* Tdo_arch_prctl_common */
	.byte 0x0c, 0xef, 0x66, 0x9c, 0xff, 0xf8, 0x9d, 0x63, 0x9c, 0xc7, 0xf1, 0xf5, 0xaa	/* t__pfx_fpu__init_cpu_generic */
	.byte 0x0c, 0x74, 0x66, 0x9c, 0xff, 0xf8, 0x9d, 0x63, 0x9c, 0xc7, 0xf1, 0xf5, 0xaa	/* tfpu__init_cpu_generic */
	.byte 0x08, 0xeb, 0x66, 0x9c, 0xff, 0xf8, 0x9d, 0x63, 0x9c	/* T__pfx_fpu__init_cpu */
	.byte 0x08, 0x54, 0x66, 0x9c, 0xff, 0xf8, 0x9d, 0x63, 0x9c	/* Tfpu__init_cpu */
	.byte 0x11, 0x08, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xb8, 0x65, 0x66, 0xd5, 0xfc, 0x73, 0x61, 0x76, 0x65	/* T__pfx___traceiter_x86_fpu_before_save */
	.byte 0x11, 0xb9, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xb8, 0x65, 0x66, 0xd5, 0xfc, 0x73, 0x61, 0x76, 0x65	/* T__traceiter_x86_fpu_before_save */
	.byte 0x12, 0x99, 0xec, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xb8, 0x65, 0x66, 0xd5, 0xfc, 0x73, 0x61, 0x76, 0x65	/* T__pfx___probestub_x86_fpu_before_save */
	.byte 0x12, 0x54, 0xfd, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xb8, 0x65, 0x66, 0xd5, 0xfc, 0x73, 0x61, 0x76, 0x65	/* T__probestub_x86_fpu_before_save */
	.byte 0x10, 0x08, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0x5f, 0x61, 0x66, 0xa2, 0xf6, 0x61, 0x76, 0x65	/* T__pfx___traceiter_x86_fpu_after_save */
	.byte 0x10, 0xb9, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0x5f, 0x61, 0x66, 0xa2, 0xf6, 0x61, 0x76, 0x65	/* T__traceiter_x86_fpu_after_save */
	.byte 0x10, 0x08, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xb8, 0x65, 0x66, 0xd5, 0xfc, 0x29, 0x8a, 0xf7	/* T__pfx___traceiter_x86_fpu_before_restore */
	.byte 0x10, 0xb9, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xb8, 0x65, 0x66, 0xd5, 0xfc, 0x29, 0x8a, 0xf7	/* T__traceiter_x86_fpu_before_restore */
	.byte 0x0f, 0x08, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0x5f, 0x61, 0x66, 0xa2, 0x07, 0x8a, 0xf7	/* T__pfx___traceiter_x86_fpu_after_restore */
	.byte 0x0f, 0xb9, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0x5f, 0x61, 0x66, 0xa2, 0x07, 0x8a, 0xf7	/* T__traceiter_x86_fpu_after_restore */
	.byte 0x10, 0x08, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xde, 0x67, 0xe9, 0xf2, 0xdc, 0x76, 0xe8, 0x9e	/* T__pfx___traceiter_x86_fpu_regs_activated */
	.byte 0x10, 0xb9, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xde, 0x67, 0xe9, 0xf2, 0xdc, 0x76, 0xe8, 0x9e	/* T__traceiter_x86_fpu_regs_activated */
	.byte 0x12, 0x08, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xde, 0x67, 0x73, 0xed, 0x65, 0xf2, 0xdc, 0x76, 0xe8, 0x9e	/* T__pfx___traceiter_x86_fpu_regs_deactivated */
	.byte 0x12, 0xb9, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xde, 0x67, 0x73, 0xed, 0x65, 0xf2, 0xdc, 0x76, 0xe8, 0x9e	/* T__traceiter_x86_fpu_regs_deactivated */
	.byte 0x0c, 0x08, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xbf, 0x9d, 0x3d, 0x2c	/* T__pfx___traceiter_x86_fpu_init_state */
	.byte 0x0c, 0xb9, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xbf, 0x9d, 0x3d, 0x2c	/* T__traceiter_x86_fpu_init_state */
	.byte 0x0d, 0x08, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xed, 0xe3, 0x70, 0x70, 0x9e	/* T__pfx___traceiter_x86_fpu_dropped */
	.byte 0x0d, 0xb9, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xed, 0xe3, 0x70, 0x70, 0x9e	/* T__traceiter_x86_fpu_dropped */
	.byte 0x0e, 0x08, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xf0, 0xbe, 0x79, 0xf6, 0x72, 0x63	/* T__pfx___traceiter_x86_fpu_copy_src */
	.byte 0x0e, 0xb9, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xf0, 0xbe, 0x79, 0xf6, 0x72, 0x63	/* T__traceiter_x86_fpu_copy_src */
	.byte 0x0e, 0x08, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xf0, 0xbe, 0x79, 0xed, 0x73, 0x74	/* T__pfx___traceiter_x86_fpu_copy_dst */
	.byte 0x0e, 0xb9, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xf0, 0xbe, 0x79, 0xed, 0x73, 0x74	/* T__traceiter_x86_fpu_copy_dst */
	.byte 0x15, 0x08, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0x5f, 0x78, 0x3d, 0x74, 0xfc, 0xba, 0x65, 0xc6, 0xe6, 0x61, 0x69, 0xc4, 0x64	/* T__pfx___traceiter_x86_fpu_xstate_check_failed */
	.byte 0x15, 0xb9, 0x18, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0x5f, 0x78, 0x3d, 0x74, 0xfc, 0xba, 0x65, 0xc6, 0xe6, 0x61, 0x69, 0xc4, 0x64	/* T__traceiter_x86_fpu_xstate_check_failed */
	.byte 0x09, 0xeb, 0xab, 0x71, 0xe6, 0x9c, 0x5f, 0xb1, 0x90, 0xc4	/* T__pfx_irq_fpu_usable */
	.byte 0x09, 0x54, 0xab, 0x71, 0xe6, 0x9c, 0x5f, 0xb1, 0x90, 0xc4	/* Tirq_fpu_usable */
	.byte 0x09, 0xeb, 0x6b, 0xf5, 0x6e, 0xdb, 0xe6, 0x9c, 0x0d, 0x64	/* T__pfx_kernel_fpu_end */
	.byte 0x09, 0x54, 0x6b, 0xf5, 0x6e, 0xdb, 0xe6, 0x9c, 0x0d, 0x64	/* Tkernel_fpu_end */
	.byte 0x0c, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x78, 0x38, 0x36, 0xe6, 0x9c	/* t__pfx_trace_raw_output_x86_fpu */
	.byte 0x0c, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x78, 0x38, 0x36, 0xe6, 0x9c	/* ttrace_raw_output_x86_fpu */
	.byte 0x0f, 0x99, 0xec, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xf0, 0xbe, 0x79, 0xed, 0x73, 0x74	/* T__pfx___probestub_x86_fpu_copy_dst */
	.byte 0x0f, 0x54, 0xfd, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xf0, 0xbe, 0x79, 0xed, 0x73, 0x74	/* T__probestub_x86_fpu_copy_dst */
	.byte 0x16, 0x99, 0xec, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0x5f, 0x78, 0x3d, 0x74, 0xfc, 0xba, 0x65, 0xc6, 0xe6, 0x61, 0x69, 0xc4, 0x64	/* T__pfx___probestub_x86_fpu_xstate_check_failed */
	.byte 0x16, 0x54, 0xfd, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0x5f, 0x78, 0x3d, 0x74, 0xfc, 0xba, 0x65, 0xc6, 0xe6, 0x61, 0x69, 0xc4, 0x64	/* T__probestub_x86_fpu_xstate_check_failed */
	.byte 0x11, 0x99, 0xec, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0x5f, 0x61, 0x66, 0xa2, 0xf6, 0x61, 0x76, 0x65	/* T__pfx___probestub_x86_fpu_after_save */
	.byte 0x11, 0x54, 0xfd, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0x5f, 0x61, 0x66, 0xa2, 0xf6, 0x61, 0x76, 0x65	/* T__probestub_x86_fpu_after_save */
	.byte 0x11, 0x99, 0xec, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xb8, 0x65, 0x66, 0xd5, 0xfc, 0x29, 0x8a, 0xf7	/* T__pfx___probestub_x86_fpu_before_restore */
	.byte 0x11, 0x54, 0xfd, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xb8, 0x65, 0x66, 0xd5, 0xfc, 0x29, 0x8a, 0xf7	/* T__probestub_x86_fpu_before_restore */
	.byte 0x10, 0x99, 0xec, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0x5f, 0x61, 0x66, 0xa2, 0x07, 0x8a, 0xf7	/* T__pfx___probestub_x86_fpu_after_restore */
	.byte 0x10, 0x54, 0xfd, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0x5f, 0x61, 0x66, 0xa2, 0x07, 0x8a, 0xf7	/* T__probestub_x86_fpu_after_restore */
	.byte 0x11, 0x99, 0xec, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xde, 0x67, 0xe9, 0xf2, 0xdc, 0x76, 0xe8, 0x9e	/* T__pfx___probestub_x86_fpu_regs_activated */
	.byte 0x11, 0x54, 0xfd, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xde, 0x67, 0xe9, 0xf2, 0xdc, 0x76, 0xe8, 0x9e	/* T__probestub_x86_fpu_regs_activated */
	.byte 0x13, 0x99, 0xec, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xde, 0x67, 0x73, 0xed, 0x65, 0xf2, 0xdc, 0x76, 0xe8, 0x9e	/* T__pfx___probestub_x86_fpu_regs_deactivated */
	.byte 0x13, 0x54, 0xfd, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xde, 0x67, 0x73, 0xed, 0x65, 0xf2, 0xdc, 0x76, 0xe8, 0x9e	/* T__probestub_x86_fpu_regs_deactivated */
	.byte 0x0d, 0x99, 0xec, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xbf, 0x9d, 0x3d, 0x2c	/* T__pfx___probestub_x86_fpu_init_state */
	.byte 0x0d, 0x54, 0xfd, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xbf, 0x9d, 0x3d, 0x2c	/* T__probestub_x86_fpu_init_state */
	.byte 0x0e, 0x99, 0xec, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xed, 0xe3, 0x70, 0x70, 0x9e	/* T__pfx___probestub_x86_fpu_dropped */
	.byte 0x0e, 0x54, 0xfd, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xed, 0xe3, 0x70, 0x70, 0x9e	/* T__probestub_x86_fpu_dropped */
	.byte 0x0f, 0x99, 0xec, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xf0, 0xbe, 0x79, 0xf6, 0x72, 0x63	/* T__pfx___probestub_x86_fpu_copy_src */
	.byte 0x0f, 0x54, 0xfd, 0x10, 0x5f, 0x78, 0x38, 0x36, 0xe6, 0x9c, 0xf0, 0xbe, 0x79, 0xf6, 0x72, 0x63	/* T__probestub_x86_fpu_copy_src */
	.byte 0x13, 0xeb, 0x66, 0x70, 0xf7, 0x67, 0xe9, 0xbb, 0x73, 0xf5, 0xfe, 0x3d, 0x74, 0xfc, 0x40, 0x73, 0xca, 0x74, 0xf1, 0x74	/* T__pfx_fpregs_assert_state_consistent */
	.byte 0x13, 0x54, 0x66, 0x70, 0xf7, 0x67, 0xe9, 0xbb, 0x73, 0xf5, 0xfe, 0x3d, 0x74, 0xfc, 0x40, 0x73, 0xca, 0x74, 0xf1, 0x74	/* Tfpregs_assert_state_consistent */
	.byte 0x09, 0xef, 0x7d, 0x7b, 0xcc, 0x78, 0x38, 0x36, 0xe6, 0x9c	/* t__pfx_trace_event_raw_event_x86_fpu */
	.byte 0x09, 0x74, 0x7d, 0x7b, 0xcc, 0x78, 0x38, 0x36, 0xe6, 0x9c	/* ttrace_event_raw_event_x86_fpu */
	.byte 0x09, 0xef, 0x19, 0x3b, 0xc3, 0x78, 0x38, 0x36, 0xe6, 0x9c	/* t__pfx_perf_trace_x86_fpu */
	.byte 0x09, 0xce, 0xf5, 0x3b, 0xc3, 0x78, 0x38, 0x36, 0xe6, 0x9c	/* tperf_trace_x86_fpu */
	.byte 0x0e, 0xeb, 0x73, 0x61, 0x1a, 0x66, 0x70, 0xf7, 0x67, 0xe9, 0x8a, 0xe6, 0x70, 0x3d, 0x2c	/* T__pfx_save_fpregs_to_fpstate */
	.byte 0x0e, 0x54, 0x73, 0x61, 0x1a, 0x66, 0x70, 0xf7, 0x67, 0xe9, 0x8a, 0xe6, 0x70, 0x3d, 0x2c	/* Tsave_fpregs_to_fpstate */
	.byte 0x0e, 0xeb, 0x6b, 0xf5, 0x6e, 0xdb, 0xe6, 0x9c, 0xb8, 0x65, 0x67, 0xf8, 0x5f, 0xd9, 0x5e	/* T__pfx_kernel_fpu_begin_mask */
	.byte 0x0e, 0x54, 0x6b, 0xf5, 0x6e, 0xdb, 0xe6, 0x9c, 0xb8, 0x65, 0x67, 0xf8, 0x5f, 0xd9, 0x5e	/* Tkernel_fpu_begin_mask */
	.byte 0x11, 0xeb, 0x29, 0x74, 0xd5, 0xfc, 0x66, 0x70, 0xf7, 0x67, 0xe9, 0x66, 0xe3, 0x6d, 0xe6, 0x70, 0x3d, 0x2c	/* T__pfx_restore_fpregs_from_fpstate */
	.byte 0x11, 0x54, 0x29, 0x74, 0xd5, 0xfc, 0x66, 0x70, 0xf7, 0x67, 0xe9, 0x66, 0xe3, 0x6d, 0xe6, 0x70, 0x3d, 0x2c	/* Trestore_fpregs_from_fpstate */
	.byte 0x0f, 0xef, 0x66, 0x70, 0xf7, 0x67, 0xe9, 0x29, 0x74, 0xd5, 0xfc, 0xb1, 0xf5, 0xf7, 0x67, 0x73	/* t__pfx_fpregs_restore_userregs */
	.byte 0x0f, 0x74, 0x66, 0x70, 0xf7, 0x67, 0xe9, 0x29, 0x74, 0xd5, 0xfc, 0xb1, 0xf5, 0xf7, 0x67, 0x73	/* tfpregs_restore_userregs */
	.byte 0x0b, 0xeb, 0x73, 0x77, 0xea, 0xba, 0xe6, 0x9c, 0xde, 0x74, 0x98, 0x6e	/* T__pfx_switch_fpu_return */
	.byte 0x0b, 0x54, 0x73, 0x77, 0xea, 0xba, 0xe6, 0x9c, 0xde, 0x74, 0x98, 0x6e	/* Tswitch_fpu_return */
	.byte 0x12, 0xeb, 0x66, 0x9c, 0x07, 0xe2, 0x66, 0xe3, 0xae, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0xe6, 0x69, 0x78, 0xcd	/* T__pfx_fpu_reset_from_exception_fixup */
	.byte 0x12, 0x54, 0x66, 0x9c, 0x07, 0xe2, 0x66, 0xe3, 0xae, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0xe6, 0x69, 0x78, 0xcd	/* Tfpu_reset_from_exception_fixup */
	.byte 0x0a, 0xeb, 0x66, 0x9c, 0x7f, 0x6e, 0x63, 0xe6, 0x70, 0x3d, 0x2c	/* T__pfx_fpu_sync_fpstate */
	.byte 0x0a, 0x54, 0x66, 0x9c, 0x7f, 0x6e, 0x63, 0xe6, 0x70, 0x3d, 0x2c	/* Tfpu_sync_fpstate */
	.byte 0x0a, 0xeb, 0x66, 0x70, 0x3d, 0x74, 0xfc, 0xf8, 0x9d, 0xb1, 0xf5	/* T__pfx_fpstate_init_user */
	.byte 0x0a, 0x54, 0x66, 0x70, 0x3d, 0x74, 0xfc, 0xf8, 0x9d, 0xb1, 0xf5	/* Tfpstate_init_user */
	.byte 0x08, 0xeb, 0x66, 0x70, 0x3d, 0x74, 0xfc, 0x29, 0xd4	/* T__pfx_fpstate_reset */
	.byte 0x08, 0x54, 0x66, 0x70, 0x3d, 0x74, 0xfc, 0x29, 0xd4	/* Tfpstate_reset */
	.byte 0x07, 0xeb, 0x66, 0x9c, 0xf0, 0x6c, 0xe7, 0x65	/* T__pfx_fpu_clone */
	.byte 0x07, 0x54, 0x66, 0x9c, 0xf0, 0x6c, 0xe7, 0x65	/* Tfpu_clone */
	.byte 0x12, 0xeb, 0x66, 0x9c, 0xa7, 0x68, 0xf7, 0xc8, 0xf6, 0xf3, 0x75, 0x63, 0xfe, 0x77, 0x68, 0xea, 0xdb, 0xca, 0x74	/* T__pfx_fpu_thread_struct_whitelist */
	.byte 0x12, 0x54, 0x66, 0x9c, 0xa7, 0x68, 0xf7, 0xc8, 0xf6, 0xf3, 0x75, 0x63, 0xfe, 0x77, 0x68, 0xea, 0xdb, 0xca, 0x74	/* Tfpu_thread_struct_whitelist */
	.byte 0x07, 0xeb, 0x66, 0x9c, 0xff, 0x64, 0xe3, 0x70	/* T__pfx_fpu__drop */
	.byte 0x07, 0x54, 0x66, 0x9c, 0xff, 0x64, 0xe3, 0x70	/* Tfpu__drop */
	.byte 0x0b, 0xeb, 0x66, 0x9c, 0xe6, 0x6c, 0xb1, 0x68, 0xa7, 0x68, 0xf7, 0xc8	/* T__pfx_fpu_flush_thread */
	.byte 0x0b, 0x54, 0x66, 0x9c, 0xe6, 0x6c, 0xb1, 0x68, 0xa7, 0x68, 0xf7, 0xc8	/* Tfpu_flush_thread */
	.byte 0x0c, 0xeb, 0x66, 0x70, 0xf7, 0x67, 0xe9, 0xa4, 0x5f, 0xd2, 0xda, 0xdd, 0xc8	/* T__pfx_fpregs_lock_and_load */
	.byte 0x0c, 0x54, 0x66, 0x70, 0xf7, 0x67, 0xe9, 0xa4, 0x5f, 0xd2, 0xda, 0xdd, 0xc8	/* Tfpregs_lock_and_load */
	.byte 0x0e, 0xeb, 0x66, 0x70, 0xf7, 0x67, 0xe9, 0xd9, 0x72, 0x6b, 0x5f, 0xf2, 0xdc, 0x76, 0x14	/* T__pfx_fpregs_mark_activate */
	.byte 0x0e, 0x54, 0x66, 0x70, 0xf7, 0x67, 0xe9, 0xd9, 0x72, 0x6b, 0x5f, 0xf2, 0xdc, 0x76, 0x14	/* Tfpregs_mark_activate */
	.byte 0x0d, 0xeb, 0x66, 0x9c, 0xff, 0x63, 0xc4, 0xc5, 0x5f, 0xb1, 0xf5, 0xa9, 0x74, 0xd6	/* T__pfx_fpu__clear_user_states */
	.byte 0x0d, 0x54, 0x66, 0x9c, 0xff, 0x63, 0xc4, 0xc5, 0x5f, 0xb1, 0xf5, 0xa9, 0x74, 0xd6	/* Tfpu__clear_user_states */
	.byte 0x0d, 0xeb, 0x66, 0x9c, 0xff, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0xf0, 0xb7, 0x65	/* T__pfx_fpu__exception_code */
	.byte 0x0d, 0x54, 0x66, 0x9c, 0xff, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0xf0, 0xb7, 0x65	/* Tfpu__exception_code */
	.byte 0x0b, 0x74, 0xaf, 0x3e, 0x0b, 0xfe, 0x66, 0xe3, 0xae, 0xfb, 0x73, 0x72	/* t__pfx___convert_from_fxsr */
	.byte 0x0b, 0x74, 0xff, 0x40, 0x0b, 0xfe, 0x66, 0xe3, 0xae, 0xfb, 0x73, 0x72	/* t__convert_from_fxsr */
	.byte 0x0e, 0xeb, 0xf7, 0x67, 0x73, 0xe2, 0x66, 0x70, 0xf7, 0x67, 0xe9, 0xf2, 0xdc, 0x76, 0x65	/* T__pfx_regset_fpregs_active */
	.byte 0x0e, 0x54, 0xf7, 0x67, 0x73, 0xe2, 0x66, 0x70, 0xf7, 0x67, 0xe9, 0xf2, 0xdc, 0x76, 0x65	/* Tregset_fpregs_active */
	.byte 0x13, 0xeb, 0xf7, 0x67, 0x73, 0xe2, 0x78, 0xf7, 0x67, 0x73, 0xe2, 0x66, 0x70, 0xf7, 0x67, 0xe9, 0xf2, 0xdc, 0x76, 0x65	/* T__pfx_regset_xregset_fpregs_active */
	.byte 0x13, 0x54, 0xf7, 0x67, 0x73, 0xe2, 0x78, 0xf7, 0x67, 0x73, 0xe2, 0x66, 0x70, 0xf7, 0x67, 0xe9, 0xf2, 0xdc, 0x76, 0x65	/* Tregset_xregset_fpregs_active */
	.byte 0x09, 0xeb, 0x78, 0x66, 0x70, 0xf7, 0x67, 0xe9, 0x67, 0xd4	/* T__pfx_xfpregs_get */
	.byte 0x09, 0x54, 0x78, 0x66, 0x70, 0xf7, 0x67, 0xe9, 0x67, 0xd4	/* Txfpregs_get */
	.byte 0x09, 0xeb, 0x78, 0x66, 0x70, 0xf7, 0x67, 0x73, 0xf6, 0xd4	/* T__pfx_xfpregs_set */
	.byte 0x09, 0x54, 0x78, 0x66, 0x70, 0xf7, 0x67, 0x73, 0xf6, 0xd4	/* Txfpregs_set */
	.byte 0x09, 0xeb, 0x78, 0x3d, 0x2c, 0xf7, 0x67, 0xe9, 0x67, 0xd4	/* T__pfx_xstateregs_get */
	.byte 0x09, 0x54, 0x78, 0x3d, 0x2c, 0xf7, 0x67, 0xe9, 0x67, 0xd4	/* Txstateregs_get */
	.byte 0x09, 0xeb, 0x78, 0x3d, 0x2c, 0xf7, 0x67, 0x73, 0xf6, 0xd4	/* T__pfx_xstateregs_set */
	.byte 0x09, 0x54, 0x78, 0x3d, 0x2c, 0xf7, 0x67, 0x73, 0xf6, 0xd4	/* Txstateregs_set */
	.byte 0x0a, 0xeb, 0x40, 0x0b, 0xfe, 0x66, 0xe3, 0xae, 0xfb, 0x73, 0x72	/* T__pfx_convert_from_fxsr */
	.byte 0x0a, 0x54, 0x40, 0x0b, 0xfe, 0x66, 0xe3, 0xae, 0xfb, 0x73, 0x72	/* Tconvert_from_fxsr */
	.byte 0x09, 0xeb, 0x40, 0x0b, 0xfe, 0x8a, 0x5f, 0xfb, 0x73, 0x72	/* T__pfx_convert_to_fxsr */
	.byte 0x09, 0x54, 0x40, 0x0b, 0xfe, 0x8a, 0x5f, 0xfb, 0x73, 0x72	/* Tconvert_to_fxsr */
	.byte 0x08, 0xeb, 0x66, 0x70, 0xf7, 0x67, 0xe9, 0x67, 0xd4	/* T__pfx_fpregs_get */
	.byte 0x08, 0x54, 0x66, 0x70, 0xf7, 0x67, 0xe9, 0x67, 0xd4	/* Tfpregs_get */
	.byte 0x08, 0xeb, 0x66, 0x70, 0xf7, 0x67, 0x73, 0xf6, 0xd4	/* T__pfx_fpregs_set */
	.byte 0x08, 0x54, 0x66, 0x70, 0xf7, 0x67, 0x73, 0xf6, 0xd4	/* Tfpregs_set */
	.byte 0x0b, 0xef, 0x73, 0x61, 0x1a, 0x95, 0x61, 0x1a, 0x68, 0x65, 0xc8, 0xf5	/* t__pfx_save_fsave_header */
	.byte 0x0a, 0x93, 0x61, 0x1a, 0x95, 0x61, 0x1a, 0x68, 0x65, 0xc8, 0xf5	/* tsave_fsave_header */
	.byte 0x0a, 0x74, 0xaf, 0xe6, 0x9c, 0x07, 0x74, 0xd5, 0xfc, 0x85, 0x67	/* t__pfx___fpu_restore_sig */
	.byte 0x0a, 0x74, 0xff, 0x66, 0x9c, 0x07, 0x74, 0xd5, 0xfc, 0x85, 0x67	/* t__fpu_restore_sig */
	.byte 0x0f, 0xeb, 0x63, 0xbe, 0x79, 0xe6, 0x70, 0x3d, 0x74, 0xfc, 0x8a, 0xf6, 0x0c, 0x66, 0xbc, 0xa8	/* T__pfx_copy_fpstate_to_sigframe */
	.byte 0x0f, 0x54, 0x63, 0xbe, 0x79, 0xe6, 0x70, 0x3d, 0x74, 0xfc, 0x8a, 0xf6, 0x0c, 0x66, 0xbc, 0xa8	/* Tcopy_fpstate_to_sigframe */
	.byte 0x0a, 0xeb, 0x66, 0x9c, 0xff, 0x29, 0x74, 0xd5, 0xfc, 0x85, 0x67	/* T__pfx_fpu__restore_sig */
	.byte 0x0a, 0x54, 0x66, 0x9c, 0xff, 0x29, 0x74, 0xd5, 0xfc, 0x85, 0x67	/* Tfpu__restore_sig */
	.byte 0x0c, 0xeb, 0x66, 0x9c, 0xff, 0x22, 0xc9, 0x6d, 0xe8, 0x68, 0x66, 0xbc, 0xa8	/* T__pfx_fpu__alloc_mathframe */
	.byte 0x0c, 0x54, 0x66, 0x9c, 0xff, 0x22, 0xc9, 0x6d, 0xe8, 0x68, 0x66, 0xbc, 0xa8	/* Tfpu__alloc_mathframe */
	.byte 0x11, 0xeb, 0x78, 0x3d, 0x74, 0xfc, 0x67, 0xe2, 0x67, 0x75, 0xd6, 0xfe, 0x67, 0xe3, 0xcd, 0xec, 0xf5, 0x6d	/* T__pfx_xstate_get_guest_group_perm */
	.byte 0x11, 0x54, 0x78, 0x3d, 0x74, 0xfc, 0x67, 0xe2, 0x67, 0x75, 0xd6, 0xfe, 0x67, 0xe3, 0xcd, 0xec, 0xf5, 0x6d	/* Txstate_get_guest_group_perm */
	.byte 0x0c, 0xeb, 0x63, 0x9c, 0xa3, 0x61, 0xe9, 0x78, 0x66, 0x65, 0xe8, 0x75, 0x29	/* T__pfx_cpu_has_xfeatures */
	.byte 0x0c, 0x54, 0x63, 0x9c, 0xa3, 0x61, 0xe9, 0x78, 0x66, 0x65, 0xe8, 0x75, 0x29	/* Tcpu_has_xfeatures */
	.byte 0x0d, 0xef, 0x78, 0x66, 0x65, 0xe8, 0x98, 0xfc, 0x67, 0xe2, 0x6f, 0x66, 0x95, 0xd4	/* t__pfx_xfeature_get_offset */
	.byte 0x0d, 0x74, 0x78, 0x66, 0x65, 0xe8, 0x98, 0xfc, 0x67, 0xe2, 0x6f, 0x66, 0x95, 0xd4	/* txfeature_get_offset */
	.byte 0x0d, 0xef, 0x78, 0x3d, 0x74, 0xfc, 0x63, 0xe5, 0x63, 0x02, 0x91, 0x85, 0x7a, 0x65	/* t__pfx_xstate_calculate_size */
	.byte 0x0d, 0x74, 0x78, 0x3d, 0x74, 0xfc, 0x63, 0xe5, 0x63, 0x02, 0x91, 0x85, 0x7a, 0x65	/* txstate_calculate_size */
	.byte 0x0a, 0x74, 0xaf, 0x5f, 0x7b, 0x78, 0x73, 0x61, 0x1a, 0xc8, 0xac	/* t__pfx___raw_xsave_addr */
	.byte 0x09, 0x74, 0xff, 0x7b, 0x78, 0x73, 0x61, 0x1a, 0xc8, 0xac	/* t__raw_xsave_addr */
	.byte 0x09, 0xeb, 0x67, 0xe2, 0x78, 0x73, 0x61, 0x1a, 0xc8, 0xac	/* T__pfx_get_xsave_addr */
	.byte 0x09, 0x54, 0x67, 0xe2, 0x78, 0x73, 0x61, 0x1a, 0xc8, 0xac	/* Tget_xsave_addr */
	.byte 0x0c, 0xef, 0x63, 0xbe, 0x79, 0xe6, 0xe3, 0x6d, 0xb8, 0x75, 0x66, 0x66, 0xf5	/* t__pfx_copy_from_buffer */
	.byte 0x0b, 0x26, 0xbe, 0x79, 0xe6, 0xe3, 0x6d, 0xb8, 0x75, 0x66, 0x66, 0xf5	/* tcopy_from_buffer */
	.byte 0x0d, 0xef, 0x63, 0xbe, 0x1d, 0x75, 0x90, 0x69, 0xa7, 0x6f, 0x5f, 0x78, 0x3d, 0x2c	/* t__pfx_copy_uabi_to_xstate */
	.byte 0x0c, 0x26, 0xbe, 0x1d, 0x75, 0x90, 0x69, 0xa7, 0x6f, 0x5f, 0x78, 0x3d, 0x2c	/* tcopy_uabi_to_xstate */
	.byte 0x11, 0xef, 0x66, 0x9c, 0xff, 0xf8, 0x9d, 0x63, 0x9c, 0x5f, 0x78, 0x3d, 0x2c, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__pfx_fpu__init_cpu_xstate.part.0 */
	.byte 0x11, 0x74, 0x66, 0x9c, 0xff, 0xf8, 0x9d, 0x63, 0x9c, 0x5f, 0x78, 0x3d, 0x2c, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* tfpu__init_cpu_xstate.part.0 */
	.byte 0x12, 0xef, 0x76, 0xe5, 0x9f, 0x91, 0xf8, 0x64, 0x65, 0x70, 0xf1, 0x64, 0xf1, 0xfe, 0x03, 0xb6, 0xe7, 0xf1, 0x93	/* t__pfx_validate_independent_components */
	.byte 0x12, 0x74, 0x76, 0xe5, 0x9f, 0x91, 0xf8, 0x64, 0x65, 0x70, 0xf1, 0x64, 0xf1, 0xfe, 0x03, 0xb6, 0xe7, 0xf1, 0x93	/* tvalidate_independent_components */
	.byte 0x0c, 0xeb, 0x66, 0x9c, 0xff, 0xf8, 0x9d, 0x63, 0x9c, 0x5f, 0x78, 0x3d, 0x2c	/* T__pfx_fpu__init_cpu_xstate */
	.byte 0x0c, 0x54, 0x66, 0x9c, 0xff, 0xf8, 0x9d, 0x63, 0x9c, 0x5f, 0x78, 0x3d, 0x2c	/* Tfpu__init_cpu_xstate */
	.byte 0x0a, 0xeb, 0x78, 0x66, 0x65, 0xe8, 0x98, 0xfc, 0x85, 0x7a, 0x65	/* T__pfx_xfeature_size */
	.byte 0x0a, 0x54, 0x78, 0x66, 0x65, 0xe8, 0x98, 0xfc, 0x85, 0x7a, 0x65	/* Txfeature_size */
	.byte 0x0a, 0xeb, 0x66, 0x9c, 0xff, 0x29, 0x75, 0x6d, 0xfc, 0x63, 0x9c	/* T__pfx_fpu__resume_cpu */
	.byte 0x0a, 0x54, 0x66, 0x9c, 0xff, 0x29, 0x75, 0x6d, 0xfc, 0x63, 0x9c	/* Tfpu__resume_cpu */
	.byte 0x0c, 0xeb, 0x67, 0xe2, 0x78, 0x73, 0x61, 0x1a, 0xc8, 0xac, 0x5f, 0xb1, 0xf5	/* T__pfx_get_xsave_addr_user */
	.byte 0x0c, 0x54, 0x67, 0xe2, 0x78, 0x73, 0x61, 0x1a, 0xc8, 0xac, 0x5f, 0xb1, 0xf5	/* Tget_xsave_addr_user */
	.byte 0x0e, 0xeb, 0xc5, 0xba, 0x84, 0xb1, 0xf5, 0xec, 0x6b, 0x65, 0x1d, 0xf2, 0x63, 0xd6, 0x73	/* T__pfx_arch_set_user_pkey_access */
	.byte 0x0e, 0x54, 0xc5, 0xba, 0x84, 0xb1, 0xf5, 0xec, 0x6b, 0x65, 0x1d, 0xf2, 0x63, 0xd6, 0x73	/* Tarch_set_user_pkey_access */
	.byte 0x10, 0x99, 0xf0, 0xbe, 0x1d, 0x78, 0x3d, 0x74, 0xfc, 0x8a, 0x5f, 0x75, 0x90, 0x69, 0xb8, 0x75, 0x66	/* T__pfx___copy_xstate_to_uabi_buf */
	.byte 0x10, 0xb9, 0x63, 0xbe, 0x1d, 0x78, 0x3d, 0x74, 0xfc, 0x8a, 0x5f, 0x75, 0x90, 0x69, 0xb8, 0x75, 0x66	/* T__copy_xstate_to_uabi_buf */
	.byte 0x10, 0xeb, 0x63, 0xbe, 0x1d, 0x78, 0x3d, 0x74, 0xfc, 0x8a, 0x5f, 0x75, 0x90, 0x69, 0xb8, 0x75, 0x66	/* T__pfx_copy_xstate_to_uabi_buf */
	.byte 0x10, 0x54, 0x63, 0xbe, 0x1d, 0x78, 0x3d, 0x74, 0xfc, 0x8a, 0x5f, 0x75, 0x90, 0x69, 0xb8, 0x75, 0x66	/* Tcopy_xstate_to_uabi_buf */
	.byte 0x14, 0xeb, 0x63, 0xbe, 0x1d, 0x75, 0x90, 0x69, 0xe6, 0xe3, 0xae, 0x6b, 0xf5, 0x6e, 0xdb, 0xa7, 0x6f, 0x5f, 0x78, 0x3d, 0x2c	/* T__pfx_copy_uabi_from_kernel_to_xstate */
	.byte 0x14, 0x54, 0x63, 0xbe, 0x1d, 0x75, 0x90, 0x69, 0xe6, 0xe3, 0xae, 0x6b, 0xf5, 0x6e, 0xdb, 0xa7, 0x6f, 0x5f, 0x78, 0x3d, 0x2c	/* Tcopy_uabi_from_kernel_to_xstate */
	.byte 0x15, 0xeb, 0x63, 0xbe, 0x79, 0xf6, 0x0c, 0x66, 0xbc, 0x6d, 0xfc, 0x66, 0xe3, 0xae, 0xb1, 0xf5, 0xa7, 0x6f, 0x5f, 0x78, 0x3d, 0x2c	/* T__pfx_copy_sigframe_from_user_to_xstate */
	.byte 0x15, 0x54, 0x63, 0xbe, 0x79, 0xf6, 0x0c, 0x66, 0xbc, 0x6d, 0xfc, 0x66, 0xe3, 0xae, 0xb1, 0xf5, 0xa7, 0x6f, 0x5f, 0x78, 0x3d, 0x2c	/* Tcopy_sigframe_from_user_to_xstate */
	.byte 0x06, 0xeb, 0x78, 0x73, 0x61, 0x76, 0xd6	/* T__pfx_xsaves */
	.byte 0x06, 0x54, 0x78, 0x73, 0x61, 0x76, 0xd6	/* Txsaves */
	.byte 0x07, 0xeb, 0x78, 0x72, 0x73, 0x74, 0xd5, 0x73	/* T__pfx_xrstors */
	.byte 0x07, 0x54, 0x78, 0x72, 0x73, 0x74, 0xd5, 0x73	/* Txrstors */
	.byte 0x0a, 0xeb, 0x78, 0x66, 0xda, 0x76, 0xe5, 0x9f, 0x91, 0x3d, 0x2c	/* T__pfx_xfd_validate_state */
	.byte 0x0a, 0x54, 0x78, 0x66, 0xda, 0x76, 0xe5, 0x9f, 0x91, 0x3d, 0x2c	/* Txfd_validate_state */
	.byte 0x09, 0xeb, 0x66, 0x70, 0x3d, 0x74, 0xfc, 0x66, 0xf7, 0x65	/* T__pfx_fpstate_free */
	.byte 0x09, 0x54, 0x66, 0x70, 0x3d, 0x74, 0xfc, 0x66, 0xf7, 0x65	/* Tfpstate_free */
	.byte 0x0c, 0x08, 0x78, 0x66, 0xda, 0xf1, 0x90, 0xb0, 0x66, 0x65, 0xe8, 0x75, 0xf7	/* T__pfx___xfd_enable_feature */
	.byte 0x0c, 0xb9, 0x78, 0x66, 0xda, 0xf1, 0x90, 0xb0, 0x66, 0x65, 0xe8, 0x75, 0xf7	/* T__xfd_enable_feature */
	.byte 0x0c, 0xeb, 0x78, 0x66, 0xda, 0xf1, 0x90, 0xb0, 0x66, 0x65, 0xe8, 0x75, 0xf7	/* T__pfx_xfd_enable_feature */
	.byte 0x0c, 0x54, 0x78, 0x66, 0xda, 0xf1, 0x90, 0xb0, 0x66, 0x65, 0xe8, 0x75, 0xf7	/* Txfd_enable_feature */
	.byte 0x0c, 0xeb, 0x66, 0x9c, 0x5f, 0x78, 0x3d, 0x74, 0xfc, 0x70, 0x72, 0x63, 0x23	/* T__pfx_fpu_xstate_prctl */
	.byte 0x0c, 0x54, 0x66, 0x9c, 0x5f, 0x78, 0x3d, 0x74, 0xfc, 0x70, 0x72, 0x63, 0x23	/* Tfpu_xstate_prctl */
	.byte 0x0c, 0xeb, 0x70, 0xe3, 0x63, 0xec, 0x69, 0xda, 0xc5, 0xba, 0xa9, 0x74, 0xb1	/* T__pfx_proc_pid_arch_status */
	.byte 0x0c, 0x54, 0x70, 0xe3, 0x63, 0xec, 0x69, 0xda, 0xc5, 0xba, 0xa9, 0x74, 0xb1	/* Tproc_pid_arch_status */
	.byte 0x13, 0xeb, 0xdb, 0x66, 0x3a, 0xf7, 0x64, 0x75, 0xb6, 0x5f, 0xcb, 0xf3, 0x61, 0xbd, 0x6f, 0x2c, 0xe9, 0x77, 0x3c, 0x65	/* T__pfx_elf_coredump_extra_notes_write */
	.byte 0x13, 0x54, 0xdb, 0x66, 0x3a, 0xf7, 0x64, 0x75, 0xb6, 0x5f, 0xcb, 0xf3, 0x61, 0xbd, 0x6f, 0x2c, 0xe9, 0x77, 0x3c, 0x65	/* Telf_coredump_extra_notes_write */
	.byte 0x14, 0xeb, 0xdb, 0x66, 0x3a, 0xf7, 0x64, 0x75, 0xb6, 0x5f, 0xcb, 0xf3, 0x61, 0xbd, 0x6f, 0x74, 0xd6, 0xf6, 0x69, 0x7a, 0x65	/* T__pfx_elf_coredump_extra_notes_size */
	.byte 0x14, 0x54, 0xdb, 0x66, 0x3a, 0xf7, 0x64, 0x75, 0xb6, 0x5f, 0xcb, 0xf3, 0x61, 0xbd, 0x6f, 0x74, 0xd6, 0xf6, 0x69, 0x7a, 0x65	/* Telf_coredump_extra_notes_size */
	.byte 0x09, 0xef, 0x70, 0xc3, 0xf3, 0x0c, 0x67, 0x65, 0xf7, 0x64	/* t__pfx_ptrace_triggered */
	.byte 0x08, 0xce, 0xc3, 0xf3, 0x0c, 0x67, 0x65, 0xf7, 0x64	/* tptrace_triggered */
	.byte 0x08, 0xef, 0xc0, 0x19, 0xae, 0xf2, 0xdc, 0x76, 0x65	/* t__pfx_ioperm_active */
	.byte 0x08, 0xdc, 0xbe, 0xf5, 0xae, 0xf2, 0xdc, 0x76, 0x65	/* tioperm_active */
	.byte 0x0b, 0xef, 0x73, 0xe2, 0x73, 0x65, 0x67, 0x6d, 0xf1, 0xfe, 0xf7, 0x67	/* t__pfx_set_segment_reg */
	.byte 0x0a, 0x93, 0xe2, 0x73, 0x65, 0x67, 0x6d, 0xf1, 0xfe, 0xf7, 0x67	/* tset_segment_reg */
	.byte 0x0c, 0xef, 0x70, 0xc3, 0xf7, 0x0e, 0xb8, 0xf7, 0x61, 0x6b, 0x70, 0x6f, 0xb3	/* t__pfx_ptrace_register_breakpoint */
	.byte 0x0b, 0xce, 0xc3, 0xf7, 0x0e, 0xb8, 0xf7, 0x61, 0x6b, 0x70, 0x6f, 0xb3	/* tptrace_register_breakpoint */
	.byte 0x0e, 0xef, 0x70, 0xc3, 0x73, 0xe2, 0x62, 0xf7, 0x61, 0x6b, 0x70, 0x6f, 0x27, 0xc8, 0xac	/* t__pfx_ptrace_set_breakpoint_addr */
	.byte 0x0d, 0xce, 0xc3, 0x73, 0xe2, 0x62, 0xf7, 0x61, 0x6b, 0x70, 0x6f, 0x27, 0xc8, 0xac	/* tptrace_set_breakpoint_addr */
	.byte 0x06, 0xef, 0xc0, 0x19, 0x6d, 0xc7, 0xd4	/* t__pfx_ioperm_get */
	.byte 0x06, 0xdc, 0xbe, 0xf5, 0x6d, 0xc7, 0xd4	/* tioperm_get */
	.byte 0x07, 0xef, 0x73, 0xe2, 0x66, 0x6c, 0x83, 0x73	/* t__pfx_set_flags */
	.byte 0x06, 0x93, 0xe2, 0x66, 0x6c, 0x83, 0x73	/* tset_flags */
	.byte 0x05, 0xef, 0x9c, 0x74, 0xf7, 0x67	/* t__pfx_putreg */
	.byte 0x04, 0xce, 0x20, 0xf7, 0x67	/* tputreg */
	.byte 0x08, 0xef, 0x67, 0xf1, 0xf7, 0x67, 0x73, 0xf6, 0xd4	/* t__pfx_genregs_set */
	.byte 0x08, 0x74, 0x67, 0xf1, 0xf7, 0x67, 0x73, 0xf6, 0xd4	/* tgenregs_set */
	.byte 0x0f, 0xef, 0x70, 0xc3, 0x6d, 0xb7, 0x69, 0x66, 0x79, 0xb8, 0xf7, 0x61, 0x6b, 0x70, 0x6f, 0xb3	/* t__pfx_ptrace_modify_breakpoint */
	.byte 0x0e, 0xce, 0xc3, 0x6d, 0xb7, 0x69, 0x66, 0x79, 0xb8, 0xf7, 0x61, 0x6b, 0x70, 0x6f, 0xb3	/* tptrace_modify_breakpoint */
	.byte 0x08, 0xef, 0x70, 0xc3, 0x77, 0x3c, 0xfc, 0xac, 0x37	/* t__pfx_ptrace_write_dr7 */
	.byte 0x07, 0xce, 0xc3, 0x77, 0x3c, 0xfc, 0xac, 0x37	/* tptrace_write_dr7 */
	.byte 0x07, 0xef, 0x67, 0xe2, 0x66, 0x6c, 0x83, 0x73	/* t__pfx_get_flags */
	.byte 0x07, 0x74, 0x67, 0xe2, 0x66, 0x6c, 0x83, 0x73	/* tget_flags */
	.byte 0x05, 0xef, 0x67, 0xd4, 0xf7, 0x67	/* t__pfx_getreg */
	.byte 0x05, 0x74, 0x67, 0xd4, 0xf7, 0x67	/* tgetreg */
	.byte 0x08, 0xef, 0x67, 0xf1, 0xf7, 0x67, 0xe9, 0x67, 0xd4	/* t__pfx_genregs_get */
	.byte 0x08, 0x74, 0x67, 0xf1, 0xf7, 0x67, 0xe9, 0x67, 0xd4	/* tgenregs_get */
	.byte 0x07, 0xef, 0x67, 0xd4, 0xf7, 0x67, 0x33, 0x32	/* t__pfx_getreg32 */
	.byte 0x07, 0x74, 0x67, 0xd4, 0xf7, 0x67, 0x33, 0x32	/* tgetreg32 */
	.byte 0x0a, 0xef, 0x67, 0xf1, 0xf7, 0x67, 0x73, 0x33, 0x32, 0xc7, 0xd4	/* t__pfx_genregs32_get */
	.byte 0x0a, 0x74, 0x67, 0xf1, 0xf7, 0x67, 0x73, 0x33, 0x32, 0xc7, 0xd4	/* tgenregs32_get */
	.byte 0x07, 0xef, 0x9c, 0x74, 0xf7, 0x67, 0x33, 0x32	/* t__pfx_putreg32 */
	.byte 0x06, 0xce, 0x20, 0xf7, 0x67, 0x33, 0x32	/* tputreg32 */
	.byte 0x0a, 0xef, 0x67, 0xf1, 0xf7, 0x67, 0x73, 0x33, 0x32, 0xf6, 0xd4	/* t__pfx_genregs32_set */
	.byte 0x0a, 0x74, 0x67, 0xf1, 0xf7, 0x67, 0x73, 0x33, 0x32, 0xf6, 0xd4	/* tgenregs32_set */
	.byte 0x0e, 0xeb, 0xf7, 0x67, 0xe9, 0xa1, 0xf5, 0x79, 0xde, 0x0e, 0x5f, 0x6f, 0x66, 0x95, 0xd4	/* T__pfx_regs_query_register_offset */
	.byte 0x0e, 0x54, 0xf7, 0x67, 0xe9, 0xa1, 0xf5, 0x79, 0xde, 0x0e, 0x5f, 0x6f, 0x66, 0x95, 0xd4	/* Tregs_query_register_offset */
	.byte 0x0c, 0xeb, 0xf7, 0x67, 0xe9, 0xa1, 0xf5, 0x79, 0xde, 0x0e, 0xbd, 0x61, 0xa8	/* T__pfx_regs_query_register_name */
	.byte 0x0c, 0x54, 0xf7, 0x67, 0xe9, 0xa1, 0xf5, 0x79, 0xde, 0x0e, 0xbd, 0x61, 0xa8	/* Tregs_query_register_name */
	.byte 0x07, 0xeb, 0x70, 0xc3, 0x64, 0xca, 0x90, 0xc4	/* T__pfx_ptrace_disable */
	.byte 0x07, 0x54, 0x70, 0xc3, 0x64, 0xca, 0x90, 0xc4	/* Tptrace_disable */
	.byte 0x05, 0xeb, 0xc5, 0xba, 0xec, 0x94	/* T__pfx_arch_ptrace */
	.byte 0x05, 0x54, 0xc5, 0xba, 0xec, 0x94	/* Tarch_ptrace */
	.byte 0x09, 0xeb, 0x03, 0xb6, 0x61, 0xfe, 0xc5, 0xba, 0xec, 0x94	/* T__pfx_compat_arch_ptrace */
	.byte 0x09, 0x54, 0x03, 0xb6, 0x61, 0xfe, 0xc5, 0xba, 0xec, 0x94	/* Tcompat_arch_ptrace */
	.byte 0x0e, 0xeb, 0xf4, 0x5e, 0x5f, 0xb1, 0xf5, 0xde, 0x67, 0x73, 0xe2, 0x76, 0x69, 0x65, 0x77	/* T__pfx_task_user_regset_view */
	.byte 0x0e, 0x54, 0xf4, 0x5e, 0x5f, 0xb1, 0xf5, 0xde, 0x67, 0x73, 0xe2, 0x76, 0x69, 0x65, 0x77	/* Ttask_user_regset_view */
	.byte 0x09, 0xeb, 0x73, 0xf1, 0x64, 0xf6, 0x0c, 0xf3, 0x61, 0x70	/* T__pfx_send_sigtrap */
	.byte 0x09, 0x54, 0x73, 0xf1, 0x64, 0xf6, 0x0c, 0xf3, 0x61, 0x70	/* Tsend_sigtrap */
	.byte 0x0d, 0xeb, 0xb1, 0xf5, 0xf6, 0x8d, 0xb0, 0x73, 0x2c, 0x70, 0xde, 0x70, 0xd5, 0x74	/* T__pfx_user_single_step_report */
	.byte 0x0d, 0x54, 0xb1, 0xf5, 0xf6, 0x8d, 0xb0, 0x73, 0x2c, 0x70, 0xde, 0x70, 0xd5, 0x74	/* Tuser_single_step_report */
	.byte 0x08, 0xef, 0x73, 0xe2, 0x23, 0x73, 0xed, 0xd6, 0x63	/* t__pfx_set_tls_desc */
	.byte 0x07, 0x93, 0xe2, 0x23, 0x73, 0xed, 0xd6, 0x63	/* tset_tls_desc */
	.byte 0x0c, 0xeb, 0x64, 0x6f, 0x84, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x61, 0xf7, 0x61	/* T__pfx_do_set_thread_area */
	.byte 0x0c, 0x54, 0x64, 0x6f, 0x84, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x61, 0xf7, 0x61	/* Tdo_set_thread_area */
	.byte 0x0f, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0x84, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x61, 0xf7, 0x61	/* T__pfx___x64_sys_set_thread_area */
	.byte 0x0f, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0x84, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x61, 0xf7, 0x61	/* T__x64_sys_set_thread_area */
	.byte 0x10, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0x84, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x61, 0xf7, 0x61	/* T__pfx___ia32_sys_set_thread_area */
	.byte 0x10, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0x84, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x61, 0xf7, 0x61	/* T__ia32_sys_set_thread_area */
	.byte 0x0c, 0xeb, 0x64, 0x6f, 0x86, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x61, 0xf7, 0x61	/* T__pfx_do_get_thread_area */
	.byte 0x0c, 0x54, 0x64, 0x6f, 0x86, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x61, 0xf7, 0x61	/* Tdo_get_thread_area */
	.byte 0x10, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xe2, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x61, 0xf7, 0x61	/* T__pfx___x64_sys_get_thread_area */
	.byte 0x10, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xe2, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x61, 0xf7, 0x61	/* T__x64_sys_get_thread_area */
	.byte 0x11, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xe2, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x61, 0xf7, 0x61	/* T__pfx___ia32_sys_get_thread_area */
	.byte 0x11, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xe2, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x61, 0xf7, 0x61	/* T__ia32_sys_get_thread_area */
	.byte 0x0b, 0xeb, 0xf7, 0x67, 0x73, 0xe2, 0x23, 0xe9, 0xf2, 0xdc, 0x76, 0x65	/* T__pfx_regset_tls_active */
	.byte 0x0b, 0x54, 0xf7, 0x67, 0x73, 0xe2, 0x23, 0xe9, 0xf2, 0xdc, 0x76, 0x65	/* Tregset_tls_active */
	.byte 0x09, 0xeb, 0xf7, 0x67, 0x73, 0xe2, 0x23, 0xe9, 0x67, 0xd4	/* T__pfx_regset_tls_get */
	.byte 0x09, 0x54, 0xf7, 0x67, 0x73, 0xe2, 0x23, 0xe9, 0x67, 0xd4	/* Tregset_tls_get */
	.byte 0x09, 0xeb, 0xf7, 0x67, 0x73, 0xe2, 0x23, 0x73, 0xf6, 0xd4	/* T__pfx_regset_tls_set */
	.byte 0x09, 0x54, 0xf7, 0x67, 0x73, 0xe2, 0x23, 0x73, 0xf6, 0xd4	/* Tregset_tls_set */
	.byte 0x0b, 0xeb, 0x40, 0x0b, 0xfe, 0x28, 0xa7, 0x6f, 0x5f, 0x2d, 0x65, 0xc5	/* T__pfx_convert_ip_to_linear */
	.byte 0x0b, 0x54, 0x40, 0x0b, 0xfe, 0x28, 0xa7, 0x6f, 0x5f, 0x2d, 0x65, 0xc5	/* Tconvert_ip_to_linear */
	.byte 0x0a, 0xef, 0xf1, 0x90, 0xb0, 0x73, 0x8d, 0xb0, 0x73, 0x2c, 0x70	/* t__pfx_enable_single_step */
	.byte 0x0a, 0x74, 0xf1, 0x90, 0xb0, 0x73, 0x8d, 0xb0, 0x73, 0x2c, 0x70	/* tenable_single_step */
	.byte 0x0a, 0xeb, 0x73, 0xe2, 0xf4, 0x5e, 0xb8, 0xa4, 0x73, 0x2c, 0x70	/* T__pfx_set_task_blockstep */
	.byte 0x0a, 0x54, 0x73, 0xe2, 0xf4, 0x5e, 0xb8, 0xa4, 0x73, 0x2c, 0x70	/* Tset_task_blockstep */
	.byte 0x0c, 0xeb, 0xb1, 0xf5, 0x0d, 0x90, 0xb0, 0x73, 0x8d, 0xb0, 0x73, 0x2c, 0x70	/* T__pfx_user_enable_single_step */
	.byte 0x0c, 0x54, 0xb1, 0xf5, 0x0d, 0x90, 0xb0, 0x73, 0x8d, 0xb0, 0x73, 0x2c, 0x70	/* Tuser_enable_single_step */
	.byte 0x0b, 0xeb, 0xb1, 0xf5, 0x0d, 0x90, 0xb0, 0x62, 0xa4, 0xf6, 0x2c, 0x70	/* T__pfx_user_enable_block_step */
	.byte 0x0b, 0x54, 0xb1, 0xf5, 0x0d, 0x90, 0xb0, 0x62, 0xa4, 0xf6, 0x2c, 0x70	/* Tuser_enable_block_step */
	.byte 0x0d, 0xeb, 0xb1, 0xf5, 0xed, 0xca, 0x90, 0xb0, 0x73, 0x8d, 0xb0, 0x73, 0x2c, 0x70	/* T__pfx_user_disable_single_step */
	.byte 0x0d, 0x54, 0xb1, 0xf5, 0xed, 0xca, 0x90, 0xb0, 0x73, 0x8d, 0xb0, 0x73, 0x2c, 0x70	/* Tuser_disable_single_step */
	.byte 0x0a, 0xef, 0x69, 0x38, 0x32, 0x33, 0x37, 0x41, 0x07, 0x75, 0xa8	/* t__pfx_i8237A_resume */
	.byte 0x09, 0xdc, 0x38, 0x32, 0x33, 0x37, 0x41, 0x07, 0x75, 0xa8	/* ti8237A_resume */
	.byte 0x08, 0xeb, 0xc5, 0xba, 0xa9, 0xc6, 0x92, 0xe5, 0x6b	/* T__pfx_arch_stack_walk */
	.byte 0x08, 0x54, 0xc5, 0xba, 0xa9, 0xc6, 0x92, 0xe5, 0x6b	/* Tarch_stack_walk */
	.byte 0x0d, 0xeb, 0xc5, 0xba, 0xa9, 0xc6, 0x92, 0xe5, 0x6b, 0xde, 0x6c, 0x69, 0x90, 0xc4	/* T__pfx_arch_stack_walk_reliable */
	.byte 0x0d, 0x54, 0xc5, 0xba, 0xa9, 0xc6, 0x92, 0xe5, 0x6b, 0xde, 0x6c, 0x69, 0x90, 0xc4	/* Tarch_stack_walk_reliable */
	.byte 0x0b, 0xeb, 0xc5, 0xba, 0xa9, 0xc6, 0x92, 0xe5, 0x6b, 0x5f, 0xb1, 0xf5	/* T__pfx_arch_stack_walk_user */
	.byte 0x0b, 0x54, 0xc5, 0xba, 0xa9, 0xc6, 0x92, 0xe5, 0x6b, 0x5f, 0xb1, 0xf5	/* Tarch_stack_walk_user */
	.byte 0x13, 0xef, 0x63, 0xf2, 0x68, 0xfc, 0x70, 0x72, 0x69, 0x76, 0x91, 0x24, 0xe9, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* t__pfx_cache_private_attrs_is_visible */
	.byte 0x12, 0x26, 0xf2, 0x68, 0xfc, 0x70, 0x72, 0x69, 0x76, 0x91, 0x24, 0xe9, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* tcache_private_attrs_is_visible */
	.byte 0x0d, 0xef, 0x63, 0xf2, 0x68, 0xfc, 0x61, 0x70, 0x5f, 0x6f, 0x66, 0x66, 0x2d, 0x65	/* t__pfx_cache_ap_offline */
	.byte 0x0c, 0x26, 0xf2, 0x68, 0xfc, 0x61, 0x70, 0x5f, 0x6f, 0x66, 0x66, 0x2d, 0x65	/* tcache_ap_offline */
	.byte 0x0a, 0xef, 0x73, 0x88, 0x63, 0xf2, 0x68, 0xd6, 0xf6, 0x8a, 0xf7	/* t__pfx_subcaches_store */
	.byte 0x09, 0x93, 0x88, 0x63, 0xf2, 0x68, 0xd6, 0xf6, 0x8a, 0xf7	/* tsubcaches_store */
	.byte 0x09, 0xef, 0x73, 0x88, 0x63, 0xf2, 0x68, 0xd6, 0xf6, 0x7c	/* t__pfx_subcaches_show */
	.byte 0x08, 0x93, 0x88, 0x63, 0xf2, 0x68, 0xd6, 0xf6, 0x7c	/* tsubcaches_show */
	.byte 0x0b, 0xef, 0x63, 0xf2, 0x68, 0xfc, 0x61, 0x70, 0x5f, 0xe7, 0x2d, 0x65	/* t__pfx_cache_ap_online */
	.byte 0x0a, 0x26, 0xf2, 0x68, 0xfc, 0x61, 0x70, 0x5f, 0xe7, 0x2d, 0x65	/* tcache_ap_online */
	.byte 0x10, 0xef, 0x2a, 0xda, 0xf8, 0x9d, 0x6c, 0x33, 0xf0, 0xf2, 0x68, 0x65, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__pfx_amd_init_l3_cache.part.0 */
	.byte 0x10, 0xf4, 0x6d, 0xda, 0xf8, 0x9d, 0x6c, 0x33, 0xf0, 0xf2, 0x68, 0x65, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* tamd_init_l3_cache.part.0 */
	.byte 0x10, 0xef, 0x63, 0x9c, 0x9f, 0x34, 0xf0, 0xf2, 0x68, 0xfc, 0xdd, 0x6f, 0x6b, 0xcd, 0xde, 0x67, 0x73	/* t__pfx_cpuid4_cache_lookup_regs */
	.byte 0x0f, 0x26, 0x9c, 0x9f, 0x34, 0xf0, 0xf2, 0x68, 0xfc, 0xdd, 0x6f, 0x6b, 0xcd, 0xde, 0x67, 0x73	/* tcpuid4_cache_lookup_regs */
	.byte 0x0c, 0xef, 0x63, 0xf2, 0x68, 0xfc, 0x64, 0xca, 0x90, 0xb0, 0x30, 0xf6, 0x7c	/* t__pfx_cache_disable_0_show */
	.byte 0x0b, 0x26, 0xf2, 0x68, 0xfc, 0x64, 0xca, 0x90, 0xb0, 0x30, 0xf6, 0x7c	/* tcache_disable_0_show */
	.byte 0x0c, 0xef, 0x63, 0xf2, 0x68, 0xfc, 0x64, 0xca, 0x90, 0xb0, 0x31, 0xf6, 0x7c	/* t__pfx_cache_disable_1_show */
	.byte 0x0b, 0x26, 0xf2, 0x68, 0xfc, 0x64, 0xca, 0x90, 0xb0, 0x31, 0xf6, 0x7c	/* tcache_disable_1_show */
	.byte 0x0d, 0xef, 0x73, 0x74, 0xd5, 0xfc, 0x63, 0xf2, 0x68, 0xfc, 0x64, 0xca, 0x90, 0xc4	/* t__pfx_store_cache_disable */
	.byte 0x0c, 0x93, 0x74, 0xd5, 0xfc, 0x63, 0xf2, 0x68, 0xfc, 0x64, 0xca, 0x90, 0xc4	/* tstore_cache_disable */
	.byte 0x0d, 0xef, 0x63, 0xf2, 0x68, 0xfc, 0x64, 0xca, 0x90, 0xb0, 0x31, 0xf6, 0x8a, 0xf7	/* t__pfx_cache_disable_1_store */
	.byte 0x0c, 0x26, 0xf2, 0x68, 0xfc, 0x64, 0xca, 0x90, 0xb0, 0x31, 0xf6, 0x8a, 0xf7	/* tcache_disable_1_store */
	.byte 0x0d, 0xef, 0x63, 0xf2, 0x68, 0xfc, 0x64, 0xca, 0x90, 0xb0, 0x30, 0xf6, 0x8a, 0xf7	/* t__pfx_cache_disable_0_store */
	.byte 0x0c, 0x26, 0xf2, 0x68, 0xfc, 0x64, 0xca, 0x90, 0xb0, 0x30, 0xf6, 0x8a, 0xf7	/* tcache_disable_0_store */
	.byte 0x0e, 0xeb, 0x63, 0xf2, 0x68, 0xfc, 0x67, 0xe2, 0x70, 0x72, 0x69, 0x76, 0xc7, 0xe3, 0xcd	/* T__pfx_cache_get_priv_group */
	.byte 0x0e, 0x54, 0x63, 0xf2, 0x68, 0xfc, 0x67, 0xe2, 0x70, 0x72, 0x69, 0x76, 0xc7, 0xe3, 0xcd	/* Tcache_get_priv_group */
	.byte 0x11, 0xeb, 0x63, 0xf2, 0x68, 0x65, 0xf8, 0x66, 0x6f, 0x5f, 0x2a, 0xda, 0xf8, 0x9d, 0x6c, 0x6c, 0xc9, 0x9f	/* T__pfx_cacheinfo_amd_init_llc_id */
	.byte 0x11, 0x54, 0x63, 0xf2, 0x68, 0x65, 0xf8, 0x66, 0x6f, 0x5f, 0x2a, 0xda, 0xf8, 0x9d, 0x6c, 0x6c, 0xc9, 0x9f	/* Tcacheinfo_amd_init_llc_id */
	.byte 0x12, 0xeb, 0x63, 0xf2, 0x68, 0x65, 0xf8, 0x66, 0x6f, 0xa3, 0x79, 0x67, 0xe7, 0xbf, 0x9d, 0x6c, 0x6c, 0xc9, 0x9f	/* T__pfx_cacheinfo_hygon_init_llc_id */
	.byte 0x12, 0x54, 0x63, 0xf2, 0x68, 0x65, 0xf8, 0x66, 0x6f, 0xa3, 0x79, 0x67, 0xe7, 0xbf, 0x9d, 0x6c, 0x6c, 0xc9, 0x9f	/* Tcacheinfo_hygon_init_llc_id */
	.byte 0x0c, 0xeb, 0xf8, 0x9d, 0x2a, 0x64, 0xf0, 0xf2, 0x68, 0x65, 0xf8, 0x66, 0x6f	/* T__pfx_init_amd_cacheinfo */
	.byte 0x0c, 0x54, 0xf8, 0x9d, 0x2a, 0x64, 0xf0, 0xf2, 0x68, 0x65, 0xf8, 0x66, 0x6f	/* Tinit_amd_cacheinfo */
	.byte 0x0e, 0xeb, 0xf8, 0x9d, 0x68, 0x79, 0x67, 0xe7, 0xf0, 0xf2, 0x68, 0x65, 0xf8, 0x66, 0x6f	/* T__pfx_init_hygon_cacheinfo */
	.byte 0x0e, 0x54, 0xf8, 0x9d, 0x68, 0x79, 0x67, 0xe7, 0xf0, 0xf2, 0x68, 0x65, 0xf8, 0x66, 0x6f	/* Tinit_hygon_cacheinfo */
	.byte 0x0b, 0xeb, 0xf8, 0x9d, 0x9a, 0xf0, 0xf2, 0x68, 0x65, 0xf8, 0x66, 0x6f	/* T__pfx_init_intel_cacheinfo */
	.byte 0x0b, 0x54, 0xf8, 0x9d, 0x9a, 0xf0, 0xf2, 0x68, 0x65, 0xf8, 0x66, 0x6f	/* Tinit_intel_cacheinfo */
	.byte 0x0a, 0xeb, 0xf8, 0x9d, 0x63, 0xf2, 0x68, 0xfc, 0x6c, 0xee, 0xdb	/* T__pfx_init_cache_level */
	.byte 0x0a, 0x54, 0xf8, 0x9d, 0x63, 0xf2, 0x68, 0xfc, 0x6c, 0xee, 0xdb	/* Tinit_cache_level */
	.byte 0x0d, 0xeb, 0x70, 0xbe, 0x02, 0x91, 0x63, 0xf2, 0x68, 0xfc, 0xc4, 0x61, 0x76, 0xd6	/* T__pfx_populate_cache_leaves */
	.byte 0x0d, 0x54, 0x70, 0xbe, 0x02, 0x91, 0x63, 0xf2, 0x68, 0xfc, 0xc4, 0x61, 0x76, 0xd6	/* Tpopulate_cache_leaves */
	.byte 0x09, 0xeb, 0x63, 0xf2, 0x68, 0xfc, 0x64, 0xca, 0x90, 0xc4	/* T__pfx_cache_disable */
	.byte 0x09, 0x54, 0x63, 0xf2, 0x68, 0xfc, 0x64, 0xca, 0x90, 0xc4	/* Tcache_disable */
	.byte 0x08, 0xeb, 0x63, 0xf2, 0x68, 0xfc, 0xf1, 0x90, 0xc4	/* T__pfx_cache_enable */
	.byte 0x08, 0x54, 0x63, 0xf2, 0x68, 0xfc, 0xf1, 0x90, 0xc4	/* Tcache_enable */
	.byte 0x09, 0xef, 0x63, 0xf2, 0x68, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* t__pfx_cache_cpu_init */
	.byte 0x08, 0x26, 0xf2, 0x68, 0xfc, 0x63, 0x9c, 0xbf, 0xea	/* tcache_cpu_init */
	.byte 0x12, 0xef, 0x63, 0xf2, 0x68, 0xfc, 0xf7, 0x6e, 0x64, 0x65, 0x7a, 0x76, 0x6f, 0x75, 0xe9, 0x68, 0x05, 0x6c, 0xf5	/* t__pfx_cache_rendezvous_handler */
	.byte 0x11, 0x26, 0xf2, 0x68, 0xfc, 0xf7, 0x6e, 0x64, 0x65, 0x7a, 0x76, 0x6f, 0x75, 0xe9, 0x68, 0x05, 0x6c, 0xf5	/* tcache_rendezvous_handler */
	.byte 0x11, 0xeb, 0x73, 0xe2, 0x63, 0xf2, 0x68, 0xfc, 0x61, 0x70, 0x73, 0xed, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x0f	/* T__pfx_set_cache_aps_delayed_init */
	.byte 0x11, 0x54, 0x73, 0xe2, 0x63, 0xf2, 0x68, 0xfc, 0x61, 0x70, 0x73, 0xed, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x0f	/* Tset_cache_aps_delayed_init */
	.byte 0x11, 0xeb, 0x67, 0xe2, 0x63, 0xf2, 0x68, 0xfc, 0x61, 0x70, 0x73, 0xed, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x0f	/* T__pfx_get_cache_aps_delayed_init */
	.byte 0x11, 0x54, 0x67, 0xe2, 0x63, 0xf2, 0x68, 0xfc, 0x61, 0x70, 0x73, 0xed, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x0f	/* Tget_cache_aps_delayed_init */
	.byte 0x0a, 0xeb, 0x63, 0xf2, 0x68, 0xfc, 0x62, 0x70, 0x07, 0x8a, 0xf7	/* T__pfx_cache_bp_restore */
	.byte 0x0a, 0x54, 0x63, 0xf2, 0x68, 0xfc, 0x62, 0x70, 0x07, 0x8a, 0xf7	/* Tcache_bp_restore */
	.byte 0x09, 0xeb, 0x63, 0xf2, 0x68, 0xfc, 0x61, 0x70, 0xe9, 0x0f	/* T__pfx_cache_aps_init */
	.byte 0x09, 0x54, 0x63, 0xf2, 0x68, 0xfc, 0x61, 0x70, 0xe9, 0x0f	/* Tcache_aps_init */
	.byte 0x11, 0xeb, 0xf8, 0x9d, 0x73, 0x63, 0xe8, 0x2c, 0xf7, 0x64, 0xf0, 0x9c, 0x9f, 0xe6, 0x65, 0xe8, 0x75, 0x29	/* T__pfx_init_scattered_cpuid_features */
	.byte 0x11, 0x54, 0xf8, 0x9d, 0x73, 0x63, 0xe8, 0x2c, 0xf7, 0x64, 0xf0, 0x9c, 0x9f, 0xe6, 0x65, 0xe8, 0x75, 0x29	/* Tinit_scattered_cpuid_features */
	.byte 0x07, 0xef, 0x74, 0xbe, 0x6f, 0x84, 0x9f, 0x73	/* t__pfx_topo_set_ids */
	.byte 0x07, 0x74, 0x74, 0xbe, 0x6f, 0x84, 0x9f, 0x73	/* ttopo_set_ids */
	.byte 0x09, 0xef, 0x70, 0xc5, 0x73, 0xfc, 0xc4, 0x67, 0xf2, 0x79	/* t__pfx_parse_legacy */
	.byte 0x08, 0xce, 0xc5, 0x73, 0xfc, 0xc4, 0x67, 0xf2, 0x79	/* tparse_legacy */
	.byte 0x0b, 0xef, 0x70, 0xc5, 0x73, 0xfc, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* t__pfx_parse_topology */
	.byte 0x0a, 0xce, 0xc5, 0x73, 0xfc, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* tparse_topology */
	.byte 0x0b, 0xeb, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0x84, 0x64, 0x6f, 0x6d	/* T__pfx_topology_set_dom */
	.byte 0x0b, 0x54, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0x84, 0x64, 0x6f, 0x6d	/* Ttopology_set_dom */
	.byte 0x0e, 0xeb, 0x67, 0xe2, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0xf0, 0x9c, 0xa7, 0x21, 0x65	/* T__pfx_get_topology_cpu_type */
	.byte 0x0e, 0x54, 0x67, 0xe2, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0xf0, 0x9c, 0xa7, 0x21, 0x65	/* Tget_topology_cpu_type */
	.byte 0x11, 0xeb, 0x67, 0xe2, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0xf0, 0x9c, 0xa7, 0x21, 0xfc, 0x6e, 0x61, 0xa8	/* T__pfx_get_topology_cpu_type_name */
	.byte 0x11, 0x54, 0x67, 0xe2, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0xf0, 0x9c, 0xa7, 0x21, 0xfc, 0x6e, 0x61, 0xa8	/* Tget_topology_cpu_type_name */
	.byte 0x0d, 0xeb, 0x63, 0x9c, 0xec, 0xc5, 0x73, 0xfc, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* T__pfx_cpu_parse_topology */
	.byte 0x0d, 0x54, 0x63, 0x9c, 0xec, 0xc5, 0x73, 0xfc, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* Tcpu_parse_topology */
	.byte 0x0e, 0xef, 0x70, 0xc5, 0x73, 0xfc, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x1d, 0xc4, 0x61, 0x66	/* t__pfx_parse_topology_leaf */
	.byte 0x0d, 0xce, 0xc5, 0x73, 0xfc, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x1d, 0xc4, 0x61, 0x66	/* tparse_topology_leaf */
	.byte 0x0e, 0xeb, 0x63, 0x9c, 0xec, 0xc5, 0x73, 0xfc, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x1d, 0x8e	/* T__pfx_cpu_parse_topology_ext */
	.byte 0x0e, 0x54, 0x63, 0x9c, 0xec, 0xc5, 0x73, 0xfc, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x1d, 0x8e	/* Tcpu_parse_topology_ext */
	.byte 0x0f, 0xeb, 0x63, 0x9c, 0xec, 0xc5, 0x73, 0xfc, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x1d, 0x2a, 0x64	/* T__pfx_cpu_parse_topology_amd */
	.byte 0x0f, 0x54, 0x63, 0x9c, 0xec, 0xc5, 0x73, 0xfc, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x1d, 0x2a, 0x64	/* Tcpu_parse_topology_amd */
	.byte 0x10, 0xeb, 0x63, 0x9c, 0xa7, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0xe6, 0x69, 0x78, 0xcd, 0x5f, 0x2a, 0x64	/* T__pfx_cpu_topology_fixup_amd */
	.byte 0x10, 0x54, 0x63, 0x9c, 0xa7, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0xe6, 0x69, 0x78, 0xcd, 0x5f, 0x2a, 0x64	/* Tcpu_topology_fixup_amd */
	.byte 0x0a, 0xeb, 0x63, 0x72, 0x34, 0xde, 0xc8, 0xf6, 0x68, 0xc8, 0xad	/* T__pfx_cr4_read_shadow */
	.byte 0x0a, 0x54, 0x63, 0x72, 0x34, 0xde, 0xc8, 0xf6, 0x68, 0xc8, 0xad	/* Tcr4_read_shadow */
	.byte 0x0b, 0xeb, 0xdd, 0xc8, 0xed, 0x69, 0xf7, 0x63, 0xfe, 0x67, 0x64, 0x74	/* T__pfx_load_direct_gdt */
	.byte 0x0b, 0x54, 0xdd, 0xc8, 0xed, 0x69, 0xf7, 0x63, 0xfe, 0x67, 0x64, 0x74	/* Tload_direct_gdt */
	.byte 0x0b, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0x77, 0x3c, 0xfc, 0x63, 0x72, 0x30	/* T__pfx_native_write_cr0 */
	.byte 0x0b, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0x77, 0x3c, 0xfc, 0x63, 0x72, 0x30	/* Tnative_write_cr0 */
	.byte 0x0a, 0xeb, 0xdd, 0xc8, 0xe6, 0x69, 0x78, 0x97, 0xc7, 0x64, 0x74	/* T__pfx_load_fixmap_gdt */
	.byte 0x0a, 0x54, 0xdd, 0xc8, 0xe6, 0x69, 0x78, 0x97, 0xc7, 0x64, 0x74	/* Tload_fixmap_gdt */
	.byte 0x0c, 0xef, 0xa5, 0x6c, 0xa2, 0xf0, 0x9c, 0x9f, 0xe6, 0x65, 0xe8, 0x75, 0x29	/* t__pfx_filter_cpuid_features */
	.byte 0x0c, 0x74, 0xa5, 0x6c, 0xa2, 0xf0, 0x9c, 0x9f, 0xe6, 0x65, 0xe8, 0x75, 0x29	/* tfilter_cpuid_features */
	.byte 0x08, 0xef, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x0f	/* t__pfx_default_init */
	.byte 0x08, 0x74, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x0f	/* tdefault_init */
	.byte 0x0b, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0x77, 0x3c, 0xfc, 0x63, 0x72, 0x34	/* T__pfx_native_write_cr4 */
	.byte 0x0b, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0x77, 0x3c, 0xfc, 0x63, 0x72, 0x34	/* Tnative_write_cr4 */
	.byte 0x0e, 0xeb, 0x63, 0x72, 0x34, 0x5f, 0xcd, 0x64, 0x91, 0xab, 0x71, 0x73, 0x6f, 0x66, 0x66	/* T__pfx_cr4_update_irqsoff */
	.byte 0x0e, 0x54, 0x63, 0x72, 0x34, 0x5f, 0xcd, 0x64, 0x91, 0xab, 0x71, 0x73, 0x6f, 0x66, 0x66	/* Tcr4_update_irqsoff */
	.byte 0x06, 0xeb, 0x63, 0x72, 0x34, 0xbf, 0xea	/* T__pfx_cr4_init */
	.byte 0x06, 0x54, 0x63, 0x72, 0x34, 0xbf, 0xea	/* Tcr4_init */
	.byte 0x08, 0xeb, 0x69, 0x62, 0xfe, 0x73, 0x61, 0x76, 0x65	/* T__pfx_ibt_save */
	.byte 0x08, 0x54, 0x69, 0x62, 0xfe, 0x73, 0x61, 0x76, 0x65	/* Tibt_save */
	.byte 0x07, 0xeb, 0x69, 0x62, 0xfe, 0x29, 0x8a, 0xf7	/* T__pfx_ibt_restore */
	.byte 0x07, 0x54, 0x69, 0x62, 0xfe, 0x29, 0x8a, 0xf7	/* Tibt_restore */
	.byte 0x07, 0xeb, 0x63, 0xe2, 0x64, 0xca, 0x90, 0xc4	/* T__pfx_cet_disable */
	.byte 0x07, 0x54, 0x63, 0xe2, 0x64, 0xca, 0x90, 0xc4	/* Tcet_disable */
	.byte 0x0e, 0xeb, 0x63, 0x9c, 0xed, 0xd4, 0xb4, 0xfe, 0x63, 0xf2, 0x68, 0xfc, 0x85, 0x7a, 0xd6	/* T__pfx_cpu_detect_cache_sizes */
	.byte 0x0e, 0x54, 0x63, 0x9c, 0xed, 0xd4, 0xb4, 0xfe, 0x63, 0xf2, 0x68, 0xfc, 0x85, 0x7a, 0xd6	/* Tcpu_detect_cache_sizes */
	.byte 0x0a, 0xeb, 0x67, 0xe2, 0x63, 0x9c, 0x5f, 0x76, 0xf1, 0x64, 0xd5	/* T__pfx_get_cpu_vendor */
	.byte 0x0a, 0x54, 0x67, 0xe2, 0x63, 0x9c, 0x5f, 0x76, 0xf1, 0x64, 0xd5	/* Tget_cpu_vendor */
	.byte 0x07, 0xeb, 0x63, 0x9c, 0xed, 0xd4, 0xb4, 0x74	/* T__pfx_cpu_detect */
	.byte 0x07, 0x54, 0x63, 0x9c, 0xed, 0xd4, 0xb4, 0x74	/* Tcpu_detect */
	.byte 0x08, 0xeb, 0x67, 0xe2, 0x63, 0x9c, 0xf0, 0x61, 0x70	/* T__pfx_get_cpu_cap */
	.byte 0x08, 0x54, 0x67, 0xe2, 0x63, 0x9c, 0xf0, 0x61, 0x70	/* Tget_cpu_cap */
	.byte 0x08, 0xef, 0x9f, 0xf1, 0xdc, 0x66, 0x79, 0xf0, 0x9c	/* t__pfx_identify_cpu */
	.byte 0x08, 0xdc, 0x64, 0xf1, 0xdc, 0x66, 0x79, 0xf0, 0x9c	/* tidentify_cpu */
	.byte 0x0e, 0xeb, 0x67, 0xe2, 0x63, 0x9c, 0x5f, 0xc8, 0x64, 0x29, 0x73, 0xf6, 0x69, 0x7a, 0xd6	/* T__pfx_get_cpu_address_sizes */
	.byte 0x0e, 0x54, 0x67, 0xe2, 0x63, 0x9c, 0x5f, 0xc8, 0x64, 0x29, 0x73, 0xf6, 0x69, 0x7a, 0xd6	/* Tget_cpu_address_sizes */
	.byte 0x0f, 0xeb, 0x78, 0x38, 0x36, 0xde, 0x61, 0xda, 0xc5, 0xba, 0xf0, 0x61, 0x70, 0xc1, 0x73, 0x72	/* T__pfx_x86_read_arch_cap_msr */
	.byte 0x0f, 0x54, 0x78, 0x38, 0x36, 0xde, 0x61, 0xda, 0xc5, 0xba, 0xf0, 0x61, 0x70, 0xc1, 0x73, 0x72	/* Tx86_read_arch_cap_msr */
	.byte 0x11, 0xeb, 0xba, 0x65, 0xc6, 0xbd, 0x02, 0x6c, 0xf6, 0x65, 0x67, 0xf0, 0xc4, 0xc5, 0xe9, 0x62, 0xbb, 0x65	/* T__pfx_check_null_seg_clears_base */
	.byte 0x11, 0x54, 0xba, 0x65, 0xc6, 0xbd, 0x02, 0x6c, 0xf6, 0x65, 0x67, 0xf0, 0xc4, 0xc5, 0xe9, 0x62, 0xbb, 0x65	/* Tcheck_null_seg_clears_base */
	.byte 0x0e, 0xeb, 0x9f, 0xf1, 0xdc, 0x66, 0x79, 0xf6, 0xb4, 0xe7, 0x64, 0xc5, 0x79, 0xf0, 0x9c	/* T__pfx_identify_secondary_cpu */
	.byte 0x0e, 0x54, 0x9f, 0xf1, 0xdc, 0x66, 0x79, 0xf6, 0xb4, 0xe7, 0x64, 0xc5, 0x79, 0xf0, 0x9c	/* Tidentify_secondary_cpu */
	.byte 0x09, 0xeb, 0x70, 0x72, 0x27, 0x63, 0x9c, 0xbf, 0x66, 0x6f	/* T__pfx_print_cpu_info */
	.byte 0x09, 0x54, 0x70, 0x72, 0x27, 0x63, 0x9c, 0xbf, 0x66, 0x6f	/* Tprint_cpu_info */
	.byte 0x07, 0xeb, 0xe1, 0x73, 0x63, 0x5d, 0xbf, 0xea	/* T__pfx_syscall_init */
	.byte 0x07, 0x54, 0xe1, 0x73, 0x63, 0x5d, 0xbf, 0xea	/* Tsyscall_init */
	.byte 0x0f, 0xeb, 0x63, 0x9c, 0xbf, 0x9d, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0xa3, 0x05, 0x6c, 0x8d	/* T__pfx_cpu_init_exception_handling */
	.byte 0x0f, 0x54, 0x63, 0x9c, 0xbf, 0x9d, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0xa3, 0x05, 0x6c, 0x8d	/* Tcpu_init_exception_handling */
	.byte 0x05, 0xeb, 0x63, 0x9c, 0xbf, 0xea	/* T__pfx_cpu_init */
	.byte 0x05, 0x54, 0x63, 0x9c, 0xbf, 0xea	/* Tcpu_init */
	.byte 0x09, 0xeb, 0xc5, 0xba, 0xf6, 0x6d, 0xfe, 0xcd, 0x64, 0x14	/* T__pfx_arch_smt_update */
	.byte 0x09, 0x54, 0xc5, 0xba, 0xf6, 0x6d, 0xfe, 0xcd, 0x64, 0x14	/* Tarch_smt_update */
	.byte 0x09, 0xeb, 0x78, 0x38, 0x36, 0xbf, 0x9d, 0x72, 0xac, 0x05	/* T__pfx_x86_init_rdrand */
	.byte 0x09, 0x54, 0x78, 0x38, 0x36, 0xbf, 0x9d, 0x72, 0xac, 0x05	/* Tx86_init_rdrand */
	.byte 0x12, 0xeb, 0x78, 0x38, 0x36, 0xf0, 0x9c, 0xa3, 0x61, 0xe9, 0x6d, 0xf8, 0xc1, 0xaa, 0xe3, 0x63, 0x16, 0xf7, 0x76	/* T__pfx_x86_cpu_has_min_microcode_rev */
	.byte 0x12, 0x54, 0x78, 0x38, 0x36, 0xf0, 0x9c, 0xa3, 0x61, 0xe9, 0x6d, 0xf8, 0xc1, 0xaa, 0xe3, 0x63, 0x16, 0xf7, 0x76	/* Tx86_cpu_has_min_microcode_rev */
	.byte 0x09, 0xeb, 0x78, 0x38, 0x36, 0xc1, 0xe8, 0xba, 0xf0, 0x9c	/* T__pfx_x86_match_cpu */
	.byte 0x09, 0x54, 0x78, 0x38, 0x36, 0xc1, 0xe8, 0xba, 0xf0, 0x9c	/* Tx86_match_cpu */
	.byte 0x0c, 0xeb, 0x67, 0x64, 0xe9, 0x75, 0x63, 0x16, 0x6d, 0xea, 0x0c, 0xe8, 0x9e	/* T__pfx_gds_ucode_mitigated */
	.byte 0x0c, 0x54, 0x67, 0x64, 0xe9, 0x75, 0x63, 0x16, 0x6d, 0xea, 0x0c, 0xe8, 0x9e	/* Tgds_ucode_mitigated */
	.byte 0x0e, 0xeb, 0x78, 0x38, 0x36, 0x5f, 0x76, 0xab, 0xfe, 0x73, 0x70, 0xb4, 0xf0, 0xf3, 0x6c	/* T__pfx_x86_virt_spec_ctrl */
	.byte 0x0e, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x76, 0xab, 0xfe, 0x73, 0x70, 0xb4, 0xf0, 0xf3, 0x6c	/* Tx86_virt_spec_ctrl */
	.byte 0x0a, 0xef, 0xcd, 0x64, 0x91, 0x73, 0x70, 0xb4, 0xf0, 0xf3, 0x6c	/* t__pfx_update_spec_ctrl */
	.byte 0x0a, 0x74, 0xcd, 0x64, 0x91, 0x73, 0x70, 0xb4, 0xf0, 0xf3, 0x6c	/* tupdate_spec_ctrl */
	.byte 0x0b, 0xef, 0xcd, 0x64, 0x91, 0x73, 0xdc, 0x62, 0x70, 0xc1, 0x73, 0x72	/* t__pfx_update_stibp_msr */
	.byte 0x0b, 0x74, 0xcd, 0x64, 0x91, 0x73, 0xdc, 0x62, 0x70, 0xc1, 0x73, 0x72	/* tupdate_stibp_msr */
	.byte 0x09, 0xef, 0x69, 0x62, 0xec, 0x72, 0x63, 0x23, 0xf6, 0xd4	/* t__pfx_ib_prctl_set */
	.byte 0x08, 0xdc, 0x62, 0xec, 0x72, 0x63, 0x23, 0xf6, 0xd4	/* tib_prctl_set */
	.byte 0x0a, 0xef, 0x73, 0x73, 0x62, 0xec, 0x72, 0x63, 0x23, 0xf6, 0xd4	/* t__pfx_ssb_prctl_set */
	.byte 0x09, 0x93, 0x73, 0x62, 0xec, 0x72, 0x63, 0x23, 0xf6, 0xd4	/* tssb_prctl_set */
	.byte 0x0e, 0xef, 0x78, 0x38, 0x36, 0x5f, 0x2a, 0x64, 0xf6, 0x73, 0x62, 0xed, 0xca, 0x90, 0xc4	/* t__pfx_x86_amd_ssb_disable */
	.byte 0x0e, 0x74, 0x78, 0x38, 0x36, 0x5f, 0x2a, 0x64, 0xf6, 0x73, 0x62, 0xed, 0xca, 0x90, 0xc4	/* tx86_amd_ssb_disable */
	.byte 0x0c, 0xeb, 0xcd, 0x64, 0x91, 0x73, 0x70, 0xb4, 0xf0, 0xf3, 0x6c, 0x3e, 0x64	/* T__pfx_update_spec_ctrl_cond */
	.byte 0x0c, 0x54, 0xcd, 0x64, 0x91, 0x73, 0x70, 0xb4, 0xf0, 0xf3, 0x6c, 0x3e, 0x64	/* Tupdate_spec_ctrl_cond */
	.byte 0x0c, 0xeb, 0xcd, 0x64, 0x91, 0x73, 0x72, 0x62, 0x64, 0xe9, 0x6d, 0x73, 0x72	/* T__pfx_update_srbds_msr */
	.byte 0x0c, 0x54, 0xcd, 0x64, 0x91, 0x73, 0x72, 0x62, 0x64, 0xe9, 0x6d, 0x73, 0x72	/* Tupdate_srbds_msr */
	.byte 0x0a, 0xeb, 0xcd, 0x64, 0x91, 0x67, 0x64, 0xe9, 0x6d, 0x73, 0x72	/* T__pfx_update_gds_msr */
	.byte 0x0a, 0x54, 0xcd, 0x64, 0x91, 0x67, 0x64, 0xe9, 0x6d, 0x73, 0x72	/* Tupdate_gds_msr */
	.byte 0x0c, 0xeb, 0xf7, 0xce, 0xa0, 0xf8, 0xfc, 0x6d, 0xb7, 0x75, 0xb0, 0x6f, 0x6b	/* T__pfx_retpoline_module_ok */
	.byte 0x0c, 0x54, 0xf7, 0xce, 0xa0, 0xf8, 0xfc, 0x6d, 0xb7, 0x75, 0xb0, 0x6f, 0x6b	/* Tretpoline_module_ok */
	.byte 0x0d, 0xeb, 0x63, 0x9c, 0xb8, 0x75, 0x67, 0x73, 0xf6, 0x6d, 0xfe, 0xcd, 0x64, 0x14	/* T__pfx_cpu_bugs_smt_update */
	.byte 0x0d, 0x54, 0x63, 0x9c, 0xb8, 0x75, 0x67, 0x73, 0xf6, 0x6d, 0xfe, 0xcd, 0x64, 0x14	/* Tcpu_bugs_smt_update */
	.byte 0x0f, 0xeb, 0xc5, 0xba, 0xec, 0x72, 0x63, 0x23, 0xf6, 0x70, 0xb4, 0xf0, 0xf3, 0x6c, 0xf6, 0xd4	/* T__pfx_arch_prctl_spec_ctrl_set */
	.byte 0x0f, 0x54, 0xc5, 0xba, 0xec, 0x72, 0x63, 0x23, 0xf6, 0x70, 0xb4, 0xf0, 0xf3, 0x6c, 0xf6, 0xd4	/* Tarch_prctl_spec_ctrl_set */
	.byte 0x0f, 0xeb, 0xc5, 0xba, 0xf6, 0xb4, 0x03, 0xb6, 0xf6, 0x70, 0x65, 0xc9, 0x6d, 0xea, 0x0c, 0x14	/* T__pfx_arch_seccomp_spec_mitigate */
	.byte 0x0f, 0x54, 0xc5, 0xba, 0xf6, 0xb4, 0x03, 0xb6, 0xf6, 0x70, 0x65, 0xc9, 0x6d, 0xea, 0x0c, 0x14	/* Tarch_seccomp_spec_mitigate */
	.byte 0x0f, 0xeb, 0xc5, 0xba, 0xec, 0x72, 0x63, 0x23, 0xf6, 0x70, 0xb4, 0xf0, 0xf3, 0x6c, 0xc7, 0xd4	/* T__pfx_arch_prctl_spec_ctrl_get */
	.byte 0x0f, 0x54, 0xc5, 0xba, 0xec, 0x72, 0x63, 0x23, 0xf6, 0x70, 0xb4, 0xf0, 0xf3, 0x6c, 0xc7, 0xd4	/* Tarch_prctl_spec_ctrl_get */
	.byte 0x10, 0xeb, 0x78, 0x38, 0x36, 0xf6, 0x70, 0xb4, 0xf0, 0xf3, 0x6c, 0xf6, 0xd4, 0xcd, 0x5f, 0x61, 0x70	/* T__pfx_x86_spec_ctrl_setup_ap */
	.byte 0x10, 0x54, 0x78, 0x38, 0x36, 0xf6, 0x70, 0xb4, 0xf0, 0xf3, 0x6c, 0xf6, 0xd4, 0xcd, 0x5f, 0x61, 0x70	/* Tx86_spec_ctrl_setup_ap */
	.byte 0x0b, 0xeb, 0x63, 0x9c, 0xf6, 0x7c, 0xc1, 0xdb, 0x74, 0x64, 0xad, 0x6e	/* T__pfx_cpu_show_meltdown */
	.byte 0x0b, 0x54, 0x63, 0x9c, 0xf6, 0x7c, 0xc1, 0xdb, 0x74, 0x64, 0xad, 0x6e	/* Tcpu_show_meltdown */
	.byte 0x0c, 0xeb, 0x63, 0x9c, 0xf6, 0x7c, 0xf6, 0x70, 0xb4, 0xf3, 0xfc, 0x76, 0x31	/* T__pfx_cpu_show_spectre_v1 */
	.byte 0x0c, 0x54, 0x63, 0x9c, 0xf6, 0x7c, 0xf6, 0x70, 0xb4, 0xf3, 0xfc, 0x76, 0x31	/* Tcpu_show_spectre_v1 */
	.byte 0x0c, 0xeb, 0x63, 0x9c, 0xf6, 0x7c, 0xf6, 0x70, 0xb4, 0xf3, 0xfc, 0x76, 0x32	/* T__pfx_cpu_show_spectre_v2 */
	.byte 0x0c, 0x54, 0x63, 0x9c, 0xf6, 0x7c, 0xf6, 0x70, 0xb4, 0xf3, 0xfc, 0x76, 0x32	/* Tcpu_show_spectre_v2 */
	.byte 0x10, 0xeb, 0x63, 0x9c, 0xf6, 0x7c, 0xf6, 0x70, 0xb4, 0xf6, 0x74, 0xd5, 0xfc, 0x62, 0x21, 0xbb, 0x73	/* T__pfx_cpu_show_spec_store_bypass */
	.byte 0x10, 0x54, 0x63, 0x9c, 0xf6, 0x7c, 0xf6, 0x70, 0xb4, 0xf6, 0x74, 0xd5, 0xfc, 0x62, 0x21, 0xbb, 0x73	/* Tcpu_show_spec_store_bypass */
	.byte 0x0a, 0xeb, 0x63, 0x9c, 0xf6, 0x7c, 0x5f, 0x6c, 0x31, 0x74, 0x66	/* T__pfx_cpu_show_l1tf */
	.byte 0x0a, 0x54, 0x63, 0x9c, 0xf6, 0x7c, 0x5f, 0x6c, 0x31, 0x74, 0x66	/* Tcpu_show_l1tf */
	.byte 0x08, 0xeb, 0x63, 0x9c, 0xf6, 0x7c, 0xc1, 0x64, 0x73	/* T__pfx_cpu_show_mds */
	.byte 0x08, 0x54, 0x63, 0x9c, 0xf6, 0x7c, 0xc1, 0x64, 0x73	/* Tcpu_show_mds */
	.byte 0x10, 0xeb, 0x63, 0x9c, 0xf6, 0x7c, 0xa7, 0x73, 0x78, 0x5f, 0x61, 0xe1, 0x6e, 0xc9, 0x90, 0xd5, 0x74	/* T__pfx_cpu_show_tsx_async_abort */
	.byte 0x10, 0x54, 0x63, 0x9c, 0xf6, 0x7c, 0xa7, 0x73, 0x78, 0x5f, 0x61, 0xe1, 0x6e, 0xc9, 0x90, 0xd5, 0x74	/* Tcpu_show_tsx_async_abort */
	.byte 0x0e, 0xeb, 0x63, 0x9c, 0xf6, 0x7c, 0x5f, 0xea, 0x6c, 0x62, 0xc1, 0x02, 0xdc, 0x68, 0xea	/* T__pfx_cpu_show_itlb_multihit */
	.byte 0x0e, 0x54, 0x63, 0x9c, 0xf6, 0x7c, 0x5f, 0xea, 0x6c, 0x62, 0xc1, 0x02, 0xdc, 0x68, 0xea	/* Tcpu_show_itlb_multihit */
	.byte 0x0a, 0xeb, 0x63, 0x9c, 0xf6, 0x7c, 0xf6, 0x72, 0x62, 0x64, 0x73	/* T__pfx_cpu_show_srbds */
	.byte 0x0a, 0x54, 0x63, 0x9c, 0xf6, 0x7c, 0xf6, 0x72, 0x62, 0x64, 0x73	/* Tcpu_show_srbds */
	.byte 0x0c, 0xeb, 0x63, 0x9c, 0xf6, 0x7c, 0xc1, 0x6d, 0xc0, 0xa9, 0xb0, 0x64, 0x0a	/* T__pfx_cpu_show_mmio_stale_data */
	.byte 0x0c, 0x54, 0x63, 0x9c, 0xf6, 0x7c, 0xc1, 0x6d, 0xc0, 0xa9, 0xb0, 0x64, 0x0a	/* Tcpu_show_mmio_stale_data */
	.byte 0x0a, 0xeb, 0x63, 0x9c, 0xf6, 0x7c, 0xde, 0x74, 0x62, 0xc4, 0x9e	/* T__pfx_cpu_show_retbleed */
	.byte 0x0a, 0x54, 0x63, 0x9c, 0xf6, 0x7c, 0xde, 0x74, 0x62, 0xc4, 0x9e	/* Tcpu_show_retbleed */
	.byte 0x12, 0xeb, 0x63, 0x9c, 0xf6, 0x7c, 0xf6, 0x70, 0x65, 0xc9, 0x72, 0x3d, 0xc6, 0x5f, 0x6f, 0x0b, 0x66, 0xdd, 0x77	/* T__pfx_cpu_show_spec_rstack_overflow */
	.byte 0x12, 0x54, 0x63, 0x9c, 0xf6, 0x7c, 0xf6, 0x70, 0x65, 0xc9, 0x72, 0x3d, 0xc6, 0x5f, 0x6f, 0x0b, 0x66, 0xdd, 0x77	/* Tcpu_show_spec_rstack_overflow */
	.byte 0x08, 0xeb, 0x63, 0x9c, 0xf6, 0x7c, 0xc7, 0x64, 0x73	/* T__pfx_cpu_show_gds */
	.byte 0x08, 0x54, 0x63, 0x9c, 0xf6, 0x7c, 0xc7, 0x64, 0x73	/* Tcpu_show_gds */
	.byte 0x11, 0xeb, 0x63, 0x9c, 0xf6, 0x7c, 0xde, 0x67, 0xe6, 0x69, 0xb0, 0x64, 0x0a, 0xf6, 0x61, 0xb6, 0x6c, 0x8d	/* T__pfx_cpu_show_reg_file_data_sampling */
	.byte 0x11, 0x54, 0x63, 0x9c, 0xf6, 0x7c, 0xde, 0x67, 0xe6, 0x69, 0xb0, 0x64, 0x0a, 0xf6, 0x61, 0xb6, 0x6c, 0x8d	/* Tcpu_show_reg_file_data_sampling */
	.byte 0x08, 0x99, 0x92, 0xc5, 0x6e, 0xa7, 0x68, 0xe4, 0x6b	/* T__pfx___warn_thunk */
	.byte 0x08, 0xb9, 0x77, 0xc5, 0x6e, 0xa7, 0x68, 0xe4, 0x6b	/* T__warn_thunk */
	.byte 0x0c, 0xeb, 0xc5, 0xba, 0x84, 0xd9, 0x78, 0xe6, 0xf7, 0x71, 0xa6, 0xe8, 0xc0	/* T__pfx_arch_set_max_freq_ratio */
	.byte 0x0c, 0x54, 0xc5, 0xba, 0x84, 0xd9, 0x78, 0xe6, 0xf7, 0x71, 0xa6, 0xe8, 0xc0	/* Tarch_set_max_freq_ratio */
	.byte 0x14, 0xef, 0x64, 0xca, 0x90, 0xb0, 0x66, 0xf7, 0x71, 0xbf, 0x76, 0xc5, 0x69, 0xd2, 0x63, 0xfc, 0x77, 0xd5, 0x6b, 0x66, 0x6e	/* t__pfx_disable_freq_invariance_workfn */
	.byte 0x14, 0x74, 0x64, 0xca, 0x90, 0xb0, 0x66, 0xf7, 0x71, 0xbf, 0x76, 0xc5, 0x69, 0xd2, 0x63, 0xfc, 0x77, 0xd5, 0x6b, 0x66, 0x6e	/* tdisable_freq_invariance_workfn */
	.byte 0x0f, 0xeb, 0xc5, 0xba, 0xf6, 0x63, 0xe5, 0xfc, 0x63, 0x9c, 0xf0, 0x61, 0x70, 0xf2, 0xea, 0x79	/* T__pfx_arch_scale_cpu_capacity */
	.byte 0x0f, 0x54, 0xc5, 0xba, 0xf6, 0x63, 0xe5, 0xfc, 0x63, 0x9c, 0xf0, 0x61, 0x70, 0xf2, 0xea, 0x79	/* Tarch_scale_cpu_capacity */
	.byte 0x0e, 0xef, 0x66, 0xf7, 0x71, 0xbf, 0x76, 0xc5, 0x69, 0xd2, 0x63, 0xfc, 0xf1, 0x90, 0xc4	/* t__pfx_freq_invariance_enable */
	.byte 0x0e, 0x74, 0x66, 0xf7, 0x71, 0xbf, 0x76, 0xc5, 0x69, 0xd2, 0x63, 0xfc, 0xf1, 0x90, 0xc4	/* tfreq_invariance_enable */
	.byte 0x08, 0xef, 0xf8, 0x9d, 0x03, 0xe4, 0xa2, 0xde, 0x95	/* t__pfx_init_counter_refs */
	.byte 0x08, 0x74, 0xf8, 0x9d, 0x03, 0xe4, 0xa2, 0xde, 0x95	/* tinit_counter_refs */
	.byte 0x12, 0xeb, 0x66, 0xf7, 0x71, 0xbf, 0x76, 0xc5, 0x69, 0xd2, 0x63, 0xfc, 0x73, 0xe2, 0x19, 0x66, 0xa6, 0xe8, 0xc0	/* T__pfx_freq_invariance_set_perf_ratio */
	.byte 0x12, 0x54, 0x66, 0xf7, 0x71, 0xbf, 0x76, 0xc5, 0x69, 0xd2, 0x63, 0xfc, 0x73, 0xe2, 0x19, 0x66, 0xa6, 0xe8, 0xc0	/* Tfreq_invariance_set_perf_ratio */
	.byte 0x15, 0xeb, 0xc5, 0xba, 0x0d, 0x90, 0xb0, 0x68, 0x79, 0x62, 0x72, 0x9f, 0xf0, 0x61, 0x70, 0xf2, 0xea, 0x79, 0xf6, 0x63, 0xe5, 0x65	/* T__pfx_arch_enable_hybrid_capacity_scale */
	.byte 0x15, 0x54, 0xc5, 0xba, 0x0d, 0x90, 0xb0, 0x68, 0x79, 0x62, 0x72, 0x9f, 0xf0, 0x61, 0x70, 0xf2, 0xea, 0x79, 0xf6, 0x63, 0xe5, 0x65	/* Tarch_enable_hybrid_capacity_scale */
	.byte 0x0c, 0xeb, 0xc5, 0xba, 0x84, 0x63, 0x9c, 0xf0, 0x61, 0x70, 0xf2, 0xea, 0x79	/* T__pfx_arch_set_cpu_capacity */
	.byte 0x0c, 0x54, 0xc5, 0xba, 0x84, 0x63, 0x9c, 0xf0, 0x61, 0x70, 0xf2, 0xea, 0x79	/* Tarch_set_cpu_capacity */
	.byte 0x0d, 0xeb, 0xc5, 0xba, 0xf6, 0x63, 0xe5, 0xfc, 0x66, 0xf7, 0x71, 0x5f, 0xdc, 0xc6	/* T__pfx_arch_scale_freq_tick */
	.byte 0x0d, 0x54, 0xc5, 0xba, 0xf6, 0x63, 0xe5, 0xfc, 0x66, 0xf7, 0x71, 0x5f, 0xdc, 0xc6	/* Tarch_scale_freq_tick */
	.byte 0x0a, 0xeb, 0xc5, 0xba, 0xe6, 0xf7, 0x71, 0x86, 0xe7, 0xf0, 0x9c	/* T__pfx_arch_freq_get_on_cpu */
	.byte 0x0a, 0x54, 0xc5, 0xba, 0xe6, 0xf7, 0x71, 0x86, 0xe7, 0xf0, 0x9c	/* Tarch_freq_get_on_cpu */
	.byte 0x0b, 0xeb, 0x61, 0x70, 0xbf, 0x9d, 0x61, 0x19, 0x66, 0xb6, 0xf5, 0x66	/* T__pfx_ap_init_aperfmperf */
	.byte 0x0b, 0x54, 0x61, 0x70, 0xbf, 0x9d, 0x61, 0x19, 0x66, 0xb6, 0xf5, 0x66	/* Tap_init_aperfmperf */
	.byte 0x0b, 0xef, 0x64, 0x6f, 0xf0, 0xc4, 0xc5, 0xf0, 0x9c, 0xf0, 0x61, 0x70	/* t__pfx_do_clear_cpu_cap */
	.byte 0x0b, 0x74, 0x64, 0x6f, 0xf0, 0xc4, 0xc5, 0xf0, 0x9c, 0xf0, 0x61, 0x70	/* tdo_clear_cpu_cap */
	.byte 0x09, 0xeb, 0x63, 0xc4, 0xc5, 0xf0, 0x9c, 0xf0, 0x61, 0x70	/* T__pfx_clear_cpu_cap */
	.byte 0x09, 0x54, 0x63, 0xc4, 0xc5, 0xf0, 0x9c, 0xf0, 0x61, 0x70	/* Tclear_cpu_cap */
	.byte 0x0c, 0xeb, 0x73, 0xd4, 0xcd, 0xf0, 0xc4, 0xc5, 0xf0, 0x9c, 0xf0, 0x61, 0x70	/* T__pfx_setup_clear_cpu_cap */
	.byte 0x0c, 0x54, 0x73, 0xd4, 0xcd, 0xf0, 0xc4, 0xc5, 0xf0, 0x9c, 0xf0, 0x61, 0x70	/* Tsetup_clear_cpu_cap */
	.byte 0x08, 0xef, 0xd9, 0x78, 0x5f, 0x00, 0xfc, 0x73, 0x7c	/* t__pfx_max_time_show */
	.byte 0x08, 0x74, 0xd9, 0x78, 0x5f, 0x00, 0xfc, 0x73, 0x7c	/* tmax_time_show */
	.byte 0x09, 0xef, 0xf1, 0x90, 0xb0, 0x63, 0x30, 0x32, 0xf6, 0x7c	/* t__pfx_enable_c02_show */
	.byte 0x09, 0x74, 0xf1, 0x90, 0xb0, 0x63, 0x30, 0x32, 0xf6, 0x7c	/* tenable_c02_show */
	.byte 0x0a, 0xef, 0xf1, 0x90, 0xb0, 0x63, 0x30, 0x32, 0xf6, 0x8a, 0xf7	/* t__pfx_enable_c02_store */
	.byte 0x0a, 0x74, 0xf1, 0x90, 0xb0, 0x63, 0x30, 0x32, 0xf6, 0x8a, 0xf7	/* tenable_c02_store */
	.byte 0x0c, 0xef, 0x75, 0x6d, 0x77, 0x61, 0x9d, 0x63, 0x9c, 0x5f, 0xe7, 0x2d, 0x65	/* t__pfx_umwait_cpu_online */
	.byte 0x0c, 0x74, 0x75, 0x6d, 0x77, 0x61, 0x9d, 0x63, 0x9c, 0x5f, 0xe7, 0x2d, 0x65	/* tumwait_cpu_online */
	.byte 0x09, 0xef, 0xd9, 0x78, 0x5f, 0x00, 0xfc, 0x73, 0x8a, 0xf7	/* t__pfx_max_time_store */
	.byte 0x09, 0x74, 0xd9, 0x78, 0x5f, 0x00, 0xfc, 0x73, 0x8a, 0xf7	/* tmax_time_store */
	.byte 0x0f, 0xef, 0x75, 0x6d, 0x77, 0x61, 0x9d, 0xcd, 0x64, 0x91, 0x40, 0xf3, 0xa0, 0xc1, 0x73, 0x72	/* t__pfx_umwait_update_control_msr */
	.byte 0x0f, 0x74, 0x75, 0x6d, 0x77, 0x61, 0x9d, 0xcd, 0x64, 0x91, 0x40, 0xf3, 0xa0, 0xc1, 0x73, 0x72	/* tumwait_update_control_msr */
	.byte 0x0e, 0xef, 0x75, 0x6d, 0x77, 0x61, 0x9d, 0x63, 0x9c, 0x5f, 0x6f, 0x66, 0x66, 0x2d, 0x65	/* t__pfx_umwait_cpu_offline */
	.byte 0x0e, 0x74, 0x75, 0x6d, 0x77, 0x61, 0x9d, 0x63, 0x9c, 0x5f, 0x6f, 0x66, 0x66, 0x2d, 0x65	/* tumwait_cpu_offline */
	.byte 0x0e, 0xef, 0x75, 0x6d, 0x77, 0x61, 0x9d, 0xe1, 0x73, 0x63, 0xd5, 0xfc, 0x29, 0x75, 0xa8	/* t__pfx_umwait_syscore_resume */
	.byte 0x0e, 0x74, 0x75, 0x6d, 0x77, 0x61, 0x9d, 0xe1, 0x73, 0x63, 0xd5, 0xfc, 0x29, 0x75, 0xa8	/* tumwait_syscore_resume */
	.byte 0x09, 0xef, 0x74, 0xbe, 0x6f, 0x84, 0x63, 0x9c, 0x9f, 0x73	/* t__pfx_topo_set_cpuids */
	.byte 0x09, 0x74, 0x74, 0xbe, 0x6f, 0x84, 0x63, 0x9c, 0x9f, 0x73	/* ttopo_set_cpuids */
	.byte 0x0a, 0xef, 0x74, 0xbe, 0x6f, 0x5f, 0xe4, 0x9d, 0x03, 0xe4, 0x74	/* t__pfx_topo_unit_count */
	.byte 0x0a, 0x74, 0x74, 0xbe, 0x6f, 0x5f, 0xe4, 0x9d, 0x03, 0xe4, 0x74	/* ttopo_unit_count */
	.byte 0x0e, 0xeb, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0x86, 0xdd, 0x67, 0xaa, 0xe5, 0x5f, 0x9f	/* T__pfx_topology_get_logical_id */
	.byte 0x0e, 0x54, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0x86, 0xdd, 0x67, 0xaa, 0xe5, 0x5f, 0x9f	/* Ttopology_get_logical_id */
	.byte 0x16, 0xef, 0x63, 0x9c, 0x5f, 0xd9, 0x72, 0x6b, 0xec, 0x72, 0x69, 0xd9, 0x72, 0x79, 0xa7, 0x68, 0xf7, 0xc8, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__pfx_cpu_mark_primary_thread.part.0 */
	.byte 0x15, 0x26, 0x9c, 0x5f, 0xd9, 0x72, 0x6b, 0xec, 0x72, 0x69, 0xd9, 0x72, 0x79, 0xa7, 0x68, 0xf7, 0xc8, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* tcpu_mark_primary_thread.part.0 */
	.byte 0x0d, 0xeb, 0xc5, 0xba, 0xc1, 0xe8, 0xba, 0xf0, 0x9c, 0xec, 0x68, 0x79, 0xe9, 0x9f	/* T__pfx_arch_match_cpu_phys_id */
	.byte 0x0d, 0x54, 0xc5, 0xba, 0xc1, 0xe8, 0xba, 0xf0, 0x9c, 0xec, 0x68, 0x79, 0xe9, 0x9f	/* Tarch_match_cpu_phys_id */
	.byte 0x0c, 0xeb, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x1d, 0xe4, 0x9d, 0x03, 0xe4, 0x74	/* T__pfx_topology_unit_count */
	.byte 0x0c, 0x54, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x1d, 0xe4, 0x9d, 0x03, 0xe4, 0x74	/* Ttopology_unit_count */
	.byte 0x11, 0xeb, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0xa3, 0x6f, 0xce, 0x6c, 0x75, 0x67, 0x5f, 0x61, 0xb2, 0x63	/* T__pfx_topology_hotplug_apic */
	.byte 0x11, 0x54, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0xa3, 0x6f, 0xce, 0x6c, 0x75, 0x67, 0x5f, 0x61, 0xb2, 0x63	/* Ttopology_hotplug_apic */
	.byte 0x13, 0xeb, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0xa3, 0x6f, 0x74, 0xe4, 0x70, 0x6c, 0x75, 0x67, 0x5f, 0x61, 0xb2, 0x63	/* T__pfx_topology_hotunplug_apic */
	.byte 0x13, 0x54, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0xa3, 0x6f, 0x74, 0xe4, 0x70, 0x6c, 0x75, 0x67, 0x5f, 0x61, 0xb2, 0x63	/* Ttopology_hotunplug_apic */
	.byte 0x05, 0xef, 0x63, 0xf6, 0x74, 0xbe	/* t__pfx_c_stop */
	.byte 0x04, 0x26, 0xf6, 0x74, 0xbe	/* tc_stop */
	.byte 0x08, 0xef, 0x73, 0x7c, 0xf0, 0x9c, 0xf8, 0x66, 0x6f	/* t__pfx_show_cpuinfo */
	.byte 0x07, 0x93, 0x7c, 0xf0, 0x9c, 0xf8, 0x66, 0x6f	/* tshow_cpuinfo */
	.byte 0x05, 0xef, 0x63, 0xa9, 0x72, 0x74	/* t__pfx_c_start */
	.byte 0x04, 0x26, 0xa9, 0x72, 0x74	/* tc_start */
	.byte 0x04, 0xef, 0xc9, 0x6e, 0x8e	/* t__pfx_c_next */
	.byte 0x04, 0x74, 0xc9, 0x6e, 0x8e	/* tc_next */
	.byte 0x0d, 0xeb, 0xf8, 0x9d, 0x69, 0x61, 0x33, 0x32, 0xe6, 0x65, 0x61, 0xfe, 0x63, 0x23	/* T__pfx_init_ia32_feat_ctl */
	.byte 0x0d, 0x54, 0xf8, 0x9d, 0x69, 0x61, 0x33, 0x32, 0xe6, 0x65, 0x61, 0xfe, 0x63, 0x23	/* Tinit_ia32_feat_ctl */
	.byte 0x07, 0xef, 0x62, 0x73, 0x70, 0xbf, 0x9d, 0x9a	/* t__pfx_bsp_init_intel */
	.byte 0x07, 0x74, 0x62, 0x73, 0x70, 0xbf, 0x9d, 0x9a	/* tbsp_init_intel */
	.byte 0x08, 0xef, 0x9a, 0xed, 0xd4, 0xb4, 0xfe, 0x23, 0x62	/* t__pfx_intel_detect_tlb */
	.byte 0x08, 0x74, 0x9a, 0xed, 0xd4, 0xb4, 0xfe, 0x23, 0x62	/* tintel_detect_tlb */
	.byte 0x08, 0xef, 0x65, 0xc5, 0x6c, 0x79, 0xbf, 0x9d, 0x9a	/* t__pfx_early_init_intel */
	.byte 0x07, 0x2c, 0xc5, 0x6c, 0x79, 0xbf, 0x9d, 0x9a	/* tearly_init_intel */
	.byte 0x04, 0xef, 0xf8, 0x9d, 0x9a	/* t__pfx_init_intel */
	.byte 0x04, 0x74, 0xf8, 0x9d, 0x9a	/* tinit_intel */
	.byte 0x0c, 0xeb, 0x9a, 0x5f, 0xe4, 0xa4, 0xf0, 0x9c, 0x69, 0xda, 0xc4, 0x61, 0x95	/* T__pfx_intel_unlock_cpuid_leafs */
	.byte 0x0c, 0x54, 0x9a, 0x5f, 0xe4, 0xa4, 0xf0, 0x9c, 0x69, 0xda, 0xc4, 0x61, 0x95	/* Tintel_unlock_cpuid_leafs */
	.byte 0x11, 0xeb, 0x67, 0xe2, 0x74, 0x68, 0x69, 0xe9, 0x68, 0x79, 0x62, 0x72, 0x9f, 0xf0, 0x9c, 0xa7, 0x21, 0x65	/* T__pfx_get_this_hybrid_cpu_type */
	.byte 0x11, 0x54, 0x67, 0xe2, 0x74, 0x68, 0x69, 0xe9, 0x68, 0x79, 0x62, 0x72, 0x9f, 0xf0, 0x9c, 0xa7, 0x21, 0x65	/* Tget_this_hybrid_cpu_type */
	.byte 0x13, 0xeb, 0x67, 0xe2, 0x74, 0x68, 0x69, 0xe9, 0x68, 0x79, 0x62, 0x72, 0x9f, 0xf0, 0x9c, 0xbd, 0xe8, 0x69, 0x1a, 0x9f	/* T__pfx_get_this_hybrid_cpu_native_id */
	.byte 0x13, 0x54, 0x67, 0xe2, 0x74, 0x68, 0x69, 0xe9, 0x68, 0x79, 0x62, 0x72, 0x9f, 0xf0, 0x9c, 0xbd, 0xe8, 0x69, 0x1a, 0x9f	/* Tget_this_hybrid_cpu_native_id */
	.byte 0x09, 0xef, 0x93, 0x78, 0xf0, 0xc4, 0xc5, 0xf0, 0x9c, 0x9f	/* t__pfx_tsx_clear_cpuid */
	.byte 0x09, 0x74, 0x93, 0x78, 0xf0, 0xc4, 0xc5, 0xf0, 0x9c, 0x9f	/* ttsx_clear_cpuid */
	.byte 0x0a, 0xef, 0x93, 0x78, 0x2b, 0xc1, 0x16, 0x64, 0xca, 0x90, 0xc4	/* t__pfx_tsx_dev_mode_disable */
	.byte 0x0a, 0x74, 0x93, 0x78, 0x2b, 0xc1, 0x16, 0x64, 0xca, 0x90, 0xc4	/* ttsx_dev_mode_disable */
	.byte 0x08, 0xeb, 0x93, 0x78, 0x5f, 0x61, 0x70, 0xbf, 0xea	/* T__pfx_tsx_ap_init */
	.byte 0x08, 0x54, 0x93, 0x78, 0x5f, 0x61, 0x70, 0xbf, 0xea	/* Ttsx_ap_init */
	.byte 0x0e, 0xef, 0xf1, 0xf5, 0x67, 0x79, 0xec, 0xf5, 0x66, 0xb8, 0x69, 0xbb, 0xf6, 0x8a, 0xf7	/* t__pfx_energy_perf_bias_store */
	.byte 0x0e, 0x74, 0xf1, 0xf5, 0x67, 0x79, 0xec, 0xf5, 0x66, 0xb8, 0x69, 0xbb, 0xf6, 0x8a, 0xf7	/* tenergy_perf_bias_store */
	.byte 0x0d, 0xef, 0xf1, 0xf5, 0x67, 0x79, 0xec, 0xf5, 0x66, 0xb8, 0x69, 0xbb, 0xf6, 0x7c	/* t__pfx_energy_perf_bias_show */
	.byte 0x0d, 0x74, 0xf1, 0xf5, 0x67, 0x79, 0xec, 0xf5, 0x66, 0xb8, 0x69, 0xbb, 0xf6, 0x7c	/* tenergy_perf_bias_show */
	.byte 0x09, 0xef, 0x9a, 0x5f, 0x65, 0x70, 0x62, 0x07, 0x8a, 0xf7	/* t__pfx_intel_epb_restore */
	.byte 0x09, 0x74, 0x9a, 0x5f, 0x65, 0x70, 0x62, 0x07, 0x8a, 0xf7	/* tintel_epb_restore */
	.byte 0x0a, 0xef, 0x9a, 0x5f, 0x65, 0x70, 0x62, 0x5f, 0xe7, 0x2d, 0x65	/* t__pfx_intel_epb_online */
	.byte 0x0a, 0x74, 0x9a, 0x5f, 0x65, 0x70, 0x62, 0x5f, 0xe7, 0x2d, 0x65	/* tintel_epb_online */
	.byte 0x0a, 0xef, 0x9a, 0x5f, 0x65, 0x70, 0x62, 0xf6, 0x61, 0x76, 0x65	/* t__pfx_intel_epb_save */
	.byte 0x0a, 0x74, 0x9a, 0x5f, 0x65, 0x70, 0x62, 0xf6, 0x61, 0x76, 0x65	/* tintel_epb_save */
	.byte 0x0c, 0xef, 0x9a, 0x5f, 0x65, 0x70, 0x62, 0x5f, 0x6f, 0x66, 0x66, 0x2d, 0x65	/* t__pfx_intel_epb_offline */
	.byte 0x0c, 0x74, 0x9a, 0x5f, 0x65, 0x70, 0x62, 0x5f, 0x6f, 0x66, 0x66, 0x2d, 0x65	/* tintel_epb_offline */
	.byte 0x0c, 0xeb, 0x2a, 0xda, 0x67, 0xe2, 0xac, 0x5f, 0xc8, 0xac, 0x5f, 0xd9, 0x5e	/* T__pfx_amd_get_dr_addr_mask */
	.byte 0x0c, 0x54, 0x2a, 0xda, 0x67, 0xe2, 0xac, 0x5f, 0xc8, 0xac, 0x5f, 0xd9, 0x5e	/* Tamd_get_dr_addr_mask */
	.byte 0x0c, 0xef, 0x63, 0x9c, 0xed, 0xd4, 0xb4, 0xfe, 0x23, 0x62, 0x5f, 0x2a, 0x64	/* t__pfx_cpu_detect_tlb_amd */
	.byte 0x0b, 0x26, 0x9c, 0xed, 0xd4, 0xb4, 0xfe, 0x23, 0x62, 0x5f, 0x2a, 0x64	/* tcpu_detect_tlb_amd */
	.byte 0x12, 0xef, 0x63, 0xc4, 0xc5, 0xa6, 0xac, 0x05, 0xf0, 0x9c, 0x69, 0xda, 0x62, 0xea, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__pfx_clear_rdrand_cpuid_bit.part.0 */
	.byte 0x11, 0x26, 0xc4, 0xc5, 0xa6, 0xac, 0x05, 0xf0, 0x9c, 0x69, 0xda, 0x62, 0xea, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* tclear_rdrand_cpuid_bit.part.0 */
	.byte 0x0d, 0xef, 0x7a, 0xf1, 0x32, 0x5f, 0x7a, 0xf1, 0x62, 0xc4, 0x9e, 0x25, 0x65, 0xc6	/* t__pfx_zen2_zenbleed_check */
	.byte 0x0d, 0x74, 0x7a, 0xf1, 0x32, 0x5f, 0x7a, 0xf1, 0x62, 0xc4, 0x9e, 0x25, 0x65, 0xc6	/* tzen2_zenbleed_check */
	.byte 0x0b, 0xef, 0x7a, 0xf1, 0x62, 0xc4, 0x9e, 0x25, 0x65, 0xc6, 0xf0, 0x9c	/* t__pfx_zenbleed_check_cpu */
	.byte 0x0b, 0x74, 0x7a, 0xf1, 0x62, 0xc4, 0x9e, 0x25, 0x65, 0xc6, 0xf0, 0x9c	/* tzenbleed_check_cpu */
	.byte 0x09, 0xef, 0x65, 0xc5, 0x6c, 0x79, 0xbf, 0x9d, 0x2a, 0x64	/* t__pfx_early_init_amd */
	.byte 0x08, 0x2c, 0xc5, 0x6c, 0x79, 0xbf, 0x9d, 0x2a, 0x64	/* tearly_init_amd */
	.byte 0x05, 0xef, 0xf8, 0x9d, 0x2a, 0x64	/* t__pfx_init_amd */
	.byte 0x05, 0x74, 0xf8, 0x9d, 0x2a, 0x64	/* tinit_amd */
	.byte 0x08, 0xef, 0x62, 0x73, 0x70, 0xbf, 0x9d, 0x2a, 0x64	/* t__pfx_bsp_init_amd */
	.byte 0x08, 0x74, 0x62, 0x73, 0x70, 0xbf, 0x9d, 0x2a, 0x64	/* tbsp_init_amd */
	.byte 0x0c, 0xeb, 0xf8, 0x9d, 0x73, 0x70, 0xb4, 0xf3, 0xe5, 0x25, 0x69, 0xc6, 0xf1	/* T__pfx_init_spectral_chicken */
	.byte 0x0c, 0x54, 0xf8, 0x9d, 0x73, 0x70, 0xb4, 0xf3, 0xe5, 0x25, 0x69, 0xc6, 0xf1	/* Tinit_spectral_chicken */
	.byte 0x0b, 0xeb, 0x2a, 0x64, 0x84, 0xac, 0x5f, 0xc8, 0xac, 0x5f, 0xd9, 0x5e	/* T__pfx_amd_set_dr_addr_mask */
	.byte 0x0b, 0x54, 0x2a, 0x64, 0x84, 0xac, 0x5f, 0xc8, 0xac, 0x5f, 0xd9, 0x5e	/* Tamd_set_dr_addr_mask */
	.byte 0x0c, 0xeb, 0x2a, 0x64, 0x25, 0x65, 0xc6, 0xc1, 0xaa, 0xe3, 0x63, 0xb7, 0x65	/* T__pfx_amd_check_microcode */
	.byte 0x0c, 0x54, 0x2a, 0x64, 0x25, 0x65, 0xc6, 0xc1, 0xaa, 0xe3, 0x63, 0xb7, 0x65	/* Tamd_check_microcode */
	.byte 0x0d, 0xef, 0x63, 0x9c, 0xed, 0xd4, 0xb4, 0xfe, 0x23, 0x62, 0xa3, 0x79, 0x67, 0xe7	/* t__pfx_cpu_detect_tlb_hygon */
	.byte 0x0c, 0x26, 0x9c, 0xed, 0xd4, 0xb4, 0xfe, 0x23, 0x62, 0xa3, 0x79, 0x67, 0xe7	/* tcpu_detect_tlb_hygon */
	.byte 0x0a, 0xef, 0x62, 0x73, 0x70, 0xbf, 0x9d, 0x68, 0x79, 0x67, 0xe7	/* t__pfx_bsp_init_hygon */
	.byte 0x0a, 0x74, 0x62, 0x73, 0x70, 0xbf, 0x9d, 0x68, 0x79, 0x67, 0xe7	/* tbsp_init_hygon */
	.byte 0x0b, 0xef, 0x65, 0xc5, 0x6c, 0x79, 0xbf, 0x9d, 0x68, 0x79, 0x67, 0xe7	/* t__pfx_early_init_hygon */
	.byte 0x0a, 0x2c, 0xc5, 0x6c, 0x79, 0xbf, 0x9d, 0x68, 0x79, 0x67, 0xe7	/* tearly_init_hygon */
	.byte 0x07, 0xef, 0xf8, 0x9d, 0x68, 0x79, 0x67, 0xe7	/* t__pfx_init_hygon */
	.byte 0x07, 0x74, 0xf8, 0x9d, 0x68, 0x79, 0x67, 0xe7	/* tinit_hygon */
	.byte 0x0b, 0xef, 0x65, 0xc5, 0x6c, 0x79, 0xbf, 0x9d, 0x63, 0xf1, 0xf4, 0x98	/* t__pfx_early_init_centaur */
	.byte 0x0a, 0x2c, 0xc5, 0x6c, 0x79, 0xbf, 0x9d, 0x63, 0xf1, 0xf4, 0x98	/* tearly_init_centaur */
	.byte 0x07, 0xef, 0xf8, 0x9d, 0x63, 0xf1, 0xf4, 0x98	/* t__pfx_init_centaur */
	.byte 0x07, 0x74, 0xf8, 0x9d, 0x63, 0xf1, 0xf4, 0x98	/* tinit_centaur */
	.byte 0x0d, 0xef, 0x65, 0xc5, 0x6c, 0x79, 0xbf, 0x9d, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf8	/* t__pfx_early_init_zhaoxin */
	.byte 0x0c, 0x2c, 0xc5, 0x6c, 0x79, 0xbf, 0x9d, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf8	/* tearly_init_zhaoxin */
	.byte 0x09, 0xef, 0xf8, 0x9d, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf8	/* t__pfx_init_zhaoxin */
	.byte 0x09, 0x74, 0xf8, 0x9d, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf8	/* tinit_zhaoxin */
	.byte 0x09, 0x08, 0x18, 0xc1, 0x63, 0xfc, 0xf7, 0x63, 0xd5, 0x64	/* T__pfx___traceiter_mce_record */
	.byte 0x09, 0xb9, 0x18, 0xc1, 0x63, 0xfc, 0xf7, 0x63, 0xd5, 0x64	/* T__traceiter_mce_record */
	.byte 0x0a, 0x99, 0xec, 0x10, 0xc1, 0x63, 0xfc, 0xf7, 0x63, 0xd5, 0x64	/* T__pfx___probestub_mce_record */
	.byte 0x0a, 0x54, 0xfd, 0x10, 0xc1, 0x63, 0xfc, 0xf7, 0x63, 0xd5, 0x64	/* T__probestub_mce_record */
	.byte 0x0b, 0xef, 0x6d, 0x73, 0x72, 0xa7, 0x6f, 0x5f, 0x6f, 0x66, 0x95, 0xd4	/* t__pfx_msr_to_offset */
	.byte 0x0b, 0x74, 0x6d, 0x73, 0x72, 0xa7, 0x6f, 0x5f, 0x6f, 0x66, 0x95, 0xd4	/* tmsr_to_offset */
	.byte 0x0b, 0xeb, 0x6d, 0x63, 0xfc, 0xca, 0xf0, 0xd5, 0xf7, 0x63, 0xe0, 0xc4	/* T__pfx_mce_is_correctable */
	.byte 0x0b, 0x54, 0x6d, 0x63, 0xfc, 0xca, 0xf0, 0xd5, 0xf7, 0x63, 0xe0, 0xc4	/* Tmce_is_correctable */
	.byte 0x0b, 0xef, 0x66, 0x61, 0x6b, 0xfc, 0x70, 0xd2, 0x69, 0xc9, 0x67, 0xd4	/* t__pfx_fake_panic_get */
	.byte 0x0b, 0x74, 0x66, 0x61, 0x6b, 0xfc, 0x70, 0xd2, 0x69, 0xc9, 0x67, 0xd4	/* tfake_panic_get */
	.byte 0x0a, 0xef, 0x66, 0x61, 0x6b, 0xfc, 0x70, 0xd2, 0xaa, 0xf6, 0xd4	/* t__pfx_fake_panic_set */
	.byte 0x0a, 0x74, 0x66, 0x61, 0x6b, 0xfc, 0x70, 0xd2, 0xaa, 0xf6, 0xd4	/* tfake_panic_set */
	.byte 0x0b, 0xef, 0x19, 0x3b, 0xc3, 0x6d, 0x63, 0xfc, 0xf7, 0x63, 0xd5, 0x64	/* t__pfx_perf_trace_mce_record */
	.byte 0x0b, 0xce, 0xf5, 0x3b, 0xc3, 0x6d, 0x63, 0xfc, 0xf7, 0x63, 0xd5, 0x64	/* tperf_trace_mce_record */
	.byte 0x0b, 0xef, 0x7d, 0x7b, 0xcc, 0x6d, 0x63, 0xfc, 0xf7, 0x63, 0xd5, 0x64	/* t__pfx_trace_event_raw_event_mce_record */
	.byte 0x0b, 0x74, 0x7d, 0x7b, 0xcc, 0x6d, 0x63, 0xfc, 0xf7, 0x63, 0xd5, 0x64	/* ttrace_event_raw_event_mce_record */
	.byte 0x0e, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x6d, 0x63, 0xfc, 0xf7, 0x63, 0xd5, 0x64	/* t__pfx_trace_raw_output_mce_record */
	.byte 0x0e, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x6d, 0x63, 0xfc, 0xf7, 0x63, 0xd5, 0x64	/* ttrace_raw_output_mce_record */
	.byte 0x0c, 0xeb, 0x6d, 0x63, 0xfc, 0xf7, 0x0e, 0xed, 0xb4, 0x16, 0xba, 0x61, 0xf8	/* T__pfx_mce_register_decode_chain */
	.byte 0x0c, 0x54, 0x6d, 0x63, 0xfc, 0xf7, 0x0e, 0xed, 0xb4, 0x16, 0xba, 0x61, 0xf8	/* Tmce_register_decode_chain */
	.byte 0x0d, 0xeb, 0x6d, 0x63, 0xfc, 0xe4, 0xf7, 0x0e, 0xed, 0xb4, 0x16, 0xba, 0x61, 0xf8	/* T__pfx_mce_unregister_decode_chain */
	.byte 0x0d, 0x54, 0x6d, 0x63, 0xfc, 0xe4, 0xf7, 0x0e, 0xed, 0xb4, 0x16, 0xba, 0x61, 0xf8	/* Tmce_unregister_decode_chain */
	.byte 0x08, 0x74, 0xaf, 0xec, 0x72, 0x27, 0x6d, 0x63, 0x65	/* t__pfx___print_mce */
	.byte 0x07, 0x74, 0xfd, 0x72, 0x27, 0x6d, 0x63, 0x65	/* t__print_mce */
	.byte 0x0f, 0xef, 0x6d, 0x63, 0xfc, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5	/* t__pfx_mce_default_notifier */
	.byte 0x0f, 0x74, 0x6d, 0x63, 0xfc, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5	/* tmce_default_notifier */
	.byte 0x0a, 0xef, 0x6b, 0x69, 0x6c, 0x6c, 0xc1, 0xfc, 0x6e, 0xee, 0xf5	/* t__pfx_kill_me_never */
	.byte 0x0a, 0x74, 0x6b, 0x69, 0x6c, 0x6c, 0xc1, 0xfc, 0x6e, 0xee, 0xf5	/* tkill_me_never */
	.byte 0x09, 0xef, 0x6b, 0x69, 0x6c, 0x6c, 0xc1, 0xfc, 0x6e, 0xad	/* t__pfx_kill_me_now */
	.byte 0x09, 0x74, 0x6b, 0x69, 0x6c, 0x6c, 0xc1, 0xfc, 0x6e, 0xad	/* tkill_me_now */
	.byte 0x09, 0xef, 0x77, 0x61, 0x9d, 0x66, 0xd5, 0xec, 0xd2, 0xaa	/* t__pfx_wait_for_panic */
	.byte 0x09, 0x74, 0x77, 0x61, 0x9d, 0x66, 0xd5, 0xec, 0xd2, 0xaa	/* twait_for_panic */
	.byte 0x07, 0x74, 0xaf, 0xa9, 0x72, 0xfe, 0x00, 0xf5	/* t__pfx___start_timer */
	.byte 0x07, 0x74, 0xff, 0x3d, 0x72, 0xfe, 0x00, 0xf5	/* t__start_timer */
	.byte 0x0e, 0x74, 0xaf, 0xc1, 0xba, 0x65, 0xc6, 0xf0, 0x9c, 0xbf, 0x9d, 0x76, 0xf1, 0x64, 0xd5	/* t__pfx___mcheck_cpu_init_vendor */
	.byte 0x0e, 0x74, 0xff, 0x6d, 0xba, 0x65, 0xc6, 0xf0, 0x9c, 0xbf, 0x9d, 0x76, 0xf1, 0x64, 0xd5	/* t__mcheck_cpu_init_vendor */
	.byte 0x0c, 0x74, 0xaf, 0xc1, 0x63, 0xfc, 0x64, 0xca, 0x90, 0xb0, 0x62, 0xd2, 0x6b	/* t__pfx___mce_disable_bank */
	.byte 0x0c, 0x74, 0xff, 0x6d, 0x63, 0xfc, 0x64, 0xca, 0x90, 0xb0, 0x62, 0xd2, 0x6b	/* t__mce_disable_bank */
	.byte 0x0b, 0xef, 0x6d, 0x63, 0xfc, 0x00, 0xf5, 0xed, 0xdb, 0xd4, 0xfc, 0x5d	/* t__pfx_mce_timer_delete_all */
	.byte 0x0b, 0x74, 0x6d, 0x63, 0xfc, 0x00, 0xf5, 0xed, 0xdb, 0xd4, 0xfc, 0x5d	/* tmce_timer_delete_all */
	.byte 0x0b, 0xef, 0x6d, 0x63, 0xfc, 0xb5, 0xaa, 0xfc, 0xf7, 0x17, 0x76, 0x65	/* t__pfx_mce_device_remove */
	.byte 0x0b, 0x74, 0x6d, 0x63, 0xfc, 0xb5, 0xaa, 0xfc, 0xf7, 0x17, 0x76, 0x65	/* tmce_device_remove */
	.byte 0x0b, 0xef, 0x73, 0xe2, 0x63, 0x6d, 0x9b, 0xed, 0xca, 0x90, 0xc4, 0x64	/* t__pfx_set_cmci_disabled */
	.byte 0x0a, 0x93, 0xe2, 0x63, 0x6d, 0x9b, 0xed, 0xca, 0x90, 0xc4, 0x64	/* tset_cmci_disabled */
	.byte 0x09, 0xef, 0x73, 0xe2, 0x0c, 0x6e, 0xd5, 0xfc, 0x63, 0x65	/* t__pfx_set_ignore_ce */
	.byte 0x08, 0x93, 0xe2, 0x0c, 0x6e, 0xd5, 0xfc, 0x63, 0x65	/* tset_ignore_ce */
	.byte 0x0b, 0xef, 0x6d, 0x63, 0xfc, 0xb5, 0xaa, 0xfc, 0xf7, 0xc4, 0xbb, 0x65	/* t__pfx_mce_device_release */
	.byte 0x0b, 0x74, 0x6d, 0x63, 0xfc, 0xb5, 0xaa, 0xfc, 0xf7, 0xc4, 0xbb, 0x65	/* tmce_device_release */
	.byte 0x09, 0xef, 0x6d, 0x63, 0xfc, 0x63, 0x9c, 0xed, 0x65, 0xc8	/* t__pfx_mce_cpu_dead */
	.byte 0x09, 0x74, 0x6d, 0x63, 0xfc, 0x63, 0x9c, 0xed, 0x65, 0xc8	/* tmce_cpu_dead */
	.byte 0x06, 0xef, 0x73, 0x7c, 0xb8, 0xd2, 0x6b	/* t__pfx_show_bank */
	.byte 0x05, 0x93, 0x7c, 0xb8, 0xd2, 0x6b	/* tshow_bank */
	.byte 0x0d, 0xef, 0x66, 0x61, 0x6b, 0xfc, 0x70, 0xd2, 0xaa, 0xe6, 0xbe, 0xe9, 0xbe, 0xf1	/* t__pfx_fake_panic_fops_open */
	.byte 0x0d, 0x74, 0x66, 0x61, 0x6b, 0xfc, 0x70, 0xd2, 0xaa, 0xe6, 0xbe, 0xe9, 0xbe, 0xf1	/* tfake_panic_fops_open */
	.byte 0x06, 0xeb, 0x6d, 0x63, 0xfc, 0xdd, 0x67	/* T__pfx_mce_log */
	.byte 0x06, 0x54, 0x6d, 0x63, 0xfc, 0xdd, 0x67	/* Tmce_log */
	.byte 0x0b, 0xeb, 0x6d, 0x63, 0xfc, 0xb1, 0x90, 0xb0, 0xc8, 0x64, 0x29, 0x73	/* T__pfx_mce_usable_address */
	.byte 0x0b, 0x54, 0x6d, 0x63, 0xfc, 0xb1, 0x90, 0xb0, 0xc8, 0x64, 0x29, 0x73	/* Tmce_usable_address */
	.byte 0x0b, 0xeb, 0x6d, 0x63, 0xfc, 0x6e, 0x6f, 0xdc, 0x66, 0x1d, 0xab, 0x71	/* T__pfx_mce_notify_irq */
	.byte 0x0b, 0x54, 0x6d, 0x63, 0xfc, 0x6e, 0x6f, 0xdc, 0x66, 0x1d, 0xab, 0x71	/* Tmce_notify_irq */
	.byte 0x06, 0xef, 0x73, 0xe2, 0x62, 0xd2, 0x6b	/* t__pfx_set_bank */
	.byte 0x05, 0x93, 0xe2, 0x62, 0xd2, 0x6b	/* tset_bank */
	.byte 0x0d, 0xeb, 0x6d, 0x63, 0xfc, 0x69, 0xe9, 0xa8, 0x6d, 0xd5, 0x1d, 0xf5, 0xe3, 0x72	/* T__pfx_mce_is_memory_error */
	.byte 0x0d, 0x54, 0x6d, 0x63, 0xfc, 0x69, 0xe9, 0xa8, 0x6d, 0xd5, 0x1d, 0xf5, 0xe3, 0x72	/* Tmce_is_memory_error */
	.byte 0x0c, 0xef, 0x70, 0x66, 0x6e, 0x5f, 0x76, 0xe5, 0x9f, 0x2e, 0xca, 0xbc, 0x7e	/* t__pfx_pfn_valid.isra.0 */
	.byte 0x0b, 0xce, 0x66, 0x6e, 0x5f, 0x76, 0xe5, 0x9f, 0x2e, 0xca, 0xbc, 0x7e	/* tpfn_valid.isra.0 */
	.byte 0x0d, 0xef, 0x6d, 0x63, 0xfc, 0x65, 0xc5, 0x6c, 0x79, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5	/* t__pfx_mce_early_notifier */
	.byte 0x0d, 0x74, 0x6d, 0x63, 0xfc, 0x65, 0xc5, 0x6c, 0x79, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5	/* tmce_early_notifier */
	.byte 0x0b, 0xef, 0x6d, 0x63, 0xfc, 0xab, 0x71, 0x92, 0xd5, 0x6b, 0xf0, 0x62	/* t__pfx_mce_irq_work_cb */
	.byte 0x0b, 0x74, 0x6d, 0x63, 0xfc, 0xab, 0x71, 0x92, 0xd5, 0x6b, 0xf0, 0x62	/* tmce_irq_work_cb */
	.byte 0x0c, 0x74, 0xaf, 0xc1, 0xba, 0x65, 0xc6, 0xf0, 0x9c, 0xbf, 0x9d, 0x00, 0xf5	/* t__pfx___mcheck_cpu_init_timer */
	.byte 0x0c, 0x74, 0xff, 0x6d, 0xba, 0x65, 0xc6, 0xf0, 0x9c, 0xbf, 0x9d, 0x00, 0xf5	/* t__mcheck_cpu_init_timer */
	.byte 0x0b, 0xef, 0x6b, 0x69, 0x6c, 0x6c, 0xc1, 0xfc, 0xd9, 0x79, 0x62, 0x65	/* t__pfx_kill_me_maybe */
	.byte 0x0b, 0x74, 0x6b, 0x69, 0x6c, 0x6c, 0xc1, 0xfc, 0xd9, 0x79, 0x62, 0x65	/* tkill_me_maybe */
	.byte 0x0d, 0xef, 0x73, 0x74, 0xd5, 0xfc, 0x27, 0x77, 0xea, 0x68, 0xde, 0x3d, 0x72, 0x74	/* t__pfx_store_int_with_restart */
	.byte 0x0c, 0x93, 0x74, 0xd5, 0xfc, 0x27, 0x77, 0xea, 0x68, 0xde, 0x3d, 0x72, 0x74	/* tstore_int_with_restart */
	.byte 0x0b, 0xef, 0x75, 0x63, 0xed, 0xb4, 0x16, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5	/* t__pfx_uc_decode_notifier */
	.byte 0x0b, 0x74, 0x75, 0x63, 0xed, 0xb4, 0x16, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5	/* tuc_decode_notifier */
	.byte 0x11, 0x74, 0xaf, 0xc1, 0xba, 0x65, 0xc6, 0xf0, 0x9c, 0xbf, 0x9d, 0x63, 0xc4, 0xc5, 0xb8, 0xd2, 0x6b, 0x73	/* t__pfx___mcheck_cpu_init_clear_banks */
	.byte 0x11, 0x74, 0xff, 0x6d, 0xba, 0x65, 0xc6, 0xf0, 0x9c, 0xbf, 0x9d, 0x63, 0xc4, 0xc5, 0xb8, 0xd2, 0x6b, 0x73	/* t__mcheck_cpu_init_clear_banks */
	.byte 0x0a, 0xef, 0xa1, 0x65, 0x75, 0xfc, 0xf4, 0x5e, 0x92, 0xd5, 0x6b	/* t__pfx_queue_task_work */
	.byte 0x0a, 0x74, 0xa1, 0x65, 0x75, 0xfc, 0xf4, 0x5e, 0x92, 0xd5, 0x6b	/* tqueue_task_work */
	.byte 0x11, 0xef, 0x76, 0xf1, 0x64, 0xd5, 0xed, 0xca, 0x90, 0xb0, 0xf5, 0xe3, 0x72, 0xde, 0x70, 0xd5, 0x74, 0x8d	/* t__pfx_vendor_disable_error_reporting */
	.byte 0x11, 0x74, 0x76, 0xf1, 0x64, 0xd5, 0xed, 0xca, 0x90, 0xb0, 0xf5, 0xe3, 0x72, 0xde, 0x70, 0xd5, 0x74, 0x8d	/* tvendor_disable_error_reporting */
	.byte 0x0f, 0xef, 0x6d, 0x63, 0xfc, 0xe1, 0x73, 0x63, 0xd5, 0xfc, 0x73, 0x68, 0x20, 0x64, 0xad, 0x6e	/* t__pfx_mce_syscore_shutdown */
	.byte 0x0f, 0x74, 0x6d, 0x63, 0xfc, 0xe1, 0x73, 0x63, 0xd5, 0xfc, 0x73, 0x68, 0x20, 0x64, 0xad, 0x6e	/* tmce_syscore_shutdown */
	.byte 0x0e, 0xef, 0x6d, 0x63, 0xfc, 0xe1, 0x73, 0x63, 0xd5, 0xfc, 0x73, 0xb1, 0x70, 0xf1, 0x64	/* t__pfx_mce_syscore_suspend */
	.byte 0x0e, 0x74, 0x6d, 0x63, 0xfc, 0xe1, 0x73, 0x63, 0xd5, 0xfc, 0x73, 0xb1, 0x70, 0xf1, 0x64	/* tmce_syscore_suspend */
	.byte 0x0b, 0xef, 0x6d, 0x63, 0xfc, 0x64, 0xca, 0x90, 0xb0, 0x63, 0x6d, 0x9b	/* t__pfx_mce_disable_cmci */
	.byte 0x0b, 0x74, 0x6d, 0x63, 0xfc, 0x64, 0xca, 0x90, 0xb0, 0x63, 0x6d, 0x9b	/* tmce_disable_cmci */
	.byte 0x09, 0xef, 0x6d, 0x63, 0xfc, 0xf1, 0x90, 0xb0, 0x63, 0x65	/* t__pfx_mce_enable_ce */
	.byte 0x09, 0x74, 0x6d, 0x63, 0xfc, 0xf1, 0x90, 0xb0, 0x63, 0x65	/* tmce_enable_ce */
	.byte 0x0c, 0xef, 0x6d, 0x63, 0xfc, 0x63, 0x9c, 0xec, 0x72, 0xfc, 0x64, 0xad, 0x6e	/* t__pfx_mce_cpu_pre_down */
	.byte 0x0c, 0x74, 0x6d, 0x63, 0xfc, 0x63, 0x9c, 0xec, 0x72, 0xfc, 0x64, 0xad, 0x6e	/* tmce_cpu_pre_down */
	.byte 0x08, 0xef, 0x6d, 0x63, 0xfc, 0x00, 0xf5, 0xe6, 0x6e	/* t__pfx_mce_timer_fn */
	.byte 0x08, 0x74, 0x6d, 0x63, 0xfc, 0x00, 0xf5, 0xe6, 0x6e	/* tmce_timer_fn */
	.byte 0x0a, 0xef, 0x6d, 0x63, 0xfc, 0x63, 0x9c, 0x5f, 0xe7, 0x2d, 0x65	/* t__pfx_mce_cpu_online */
	.byte 0x0a, 0x74, 0x6d, 0x63, 0xfc, 0x63, 0x9c, 0x5f, 0xe7, 0x2d, 0x65	/* tmce_cpu_online */
	.byte 0x0f, 0xeb, 0x6d, 0x63, 0xfc, 0x70, 0xf7, 0x70, 0xde, 0x63, 0xd5, 0x64, 0x3a, 0x6d, 0x6d, 0xe7	/* T__pfx_mce_prep_record_common */
	.byte 0x0f, 0x54, 0x6d, 0x63, 0xfc, 0x70, 0xf7, 0x70, 0xde, 0x63, 0xd5, 0x64, 0x3a, 0x6d, 0x6d, 0xe7	/* Tmce_prep_record_common */
	.byte 0x0f, 0xeb, 0x6d, 0x63, 0xfc, 0x70, 0xf7, 0x70, 0xde, 0x63, 0xd5, 0x64, 0xec, 0xf5, 0xf0, 0x9c	/* T__pfx_mce_prep_record_per_cpu */
	.byte 0x0f, 0x54, 0x6d, 0x63, 0xfc, 0x70, 0xf7, 0x70, 0xde, 0x63, 0xd5, 0x64, 0xec, 0xf5, 0xf0, 0x9c	/* Tmce_prep_record_per_cpu */
	.byte 0x0c, 0xeb, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0xba, 0x65, 0xc6, 0xec, 0xa0, 0x6c	/* T__pfx_machine_check_poll */
	.byte 0x0c, 0x54, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0xba, 0x65, 0xc6, 0xec, 0xa0, 0x6c	/* Tmachine_check_poll */
	.byte 0x10, 0xef, 0x6d, 0x63, 0xec, 0xa0, 0x6c, 0xb8, 0xd2, 0x6b, 0x73, 0xed, 0x65, 0x66, 0x61, 0x02, 0x74	/* t__pfx_mc_poll_banks_default */
	.byte 0x10, 0x74, 0x6d, 0x63, 0xec, 0xa0, 0x6c, 0xb8, 0xd2, 0x6b, 0x73, 0xed, 0x65, 0x66, 0x61, 0x02, 0x74	/* tmc_poll_banks_default */
	.byte 0x0e, 0x74, 0xaf, 0xc1, 0xba, 0x65, 0xc6, 0xf0, 0x9c, 0xbf, 0x9d, 0x67, 0xf1, 0xf5, 0xaa	/* t__pfx___mcheck_cpu_init_generic */
	.byte 0x0e, 0x74, 0xff, 0x6d, 0xba, 0x65, 0xc6, 0xf0, 0x9c, 0xbf, 0x9d, 0x67, 0xf1, 0xf5, 0xaa	/* t__mcheck_cpu_init_generic */
	.byte 0x0c, 0xef, 0x6d, 0x63, 0xfc, 0xe1, 0x73, 0x63, 0xd5, 0xfc, 0x29, 0x75, 0xa8	/* t__pfx_mce_syscore_resume */
	.byte 0x0c, 0x74, 0x6d, 0x63, 0xfc, 0xe1, 0x73, 0x63, 0xd5, 0xfc, 0x29, 0x75, 0xa8	/* tmce_syscore_resume */
	.byte 0x0a, 0xef, 0x6d, 0x63, 0xfc, 0x63, 0x9c, 0xde, 0x3d, 0x72, 0x74	/* t__pfx_mce_cpu_restart */
	.byte 0x0a, 0x74, 0x6d, 0x63, 0xfc, 0x63, 0x9c, 0xde, 0x3d, 0x72, 0x74	/* tmce_cpu_restart */
	.byte 0x0b, 0xeb, 0x6d, 0x63, 0xfc, 0x70, 0xf7, 0x70, 0xde, 0x63, 0xd5, 0x64	/* T__pfx_mce_prep_record */
	.byte 0x0b, 0x54, 0x6d, 0x63, 0xfc, 0x70, 0xf7, 0x70, 0xde, 0x63, 0xd5, 0x64	/* Tmce_prep_record */
	.byte 0x0c, 0xeb, 0xcb, 0xa3, 0x05, 0x6c, 0xf5, 0xc1, 0x73, 0x72, 0xc1, 0x63, 0x65	/* T__pfx_ex_handler_msr_mce */
	.byte 0x0c, 0x54, 0xcb, 0xa3, 0x05, 0x6c, 0xf5, 0xc1, 0x73, 0x72, 0xc1, 0x63, 0x65	/* Tex_handler_msr_mce */
	.byte 0x0b, 0xeb, 0x6d, 0x63, 0xfc, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x90, 0xc4	/* T__pfx_mce_available */
	.byte 0x0b, 0x54, 0x6d, 0x63, 0xfc, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x90, 0xc4	/* Tmce_available */
	.byte 0x0b, 0xeb, 0xa8, 0x6d, 0xd5, 0x79, 0xe6, 0x61, 0x69, 0x6c, 0x75, 0xf7	/* T__pfx_memory_failure */
	.byte 0x0b, 0x54, 0xa8, 0x6d, 0xd5, 0x79, 0xe6, 0x61, 0x69, 0x6c, 0x75, 0xf7	/* Tmemory_failure */
	.byte 0x0a, 0xeb, 0x6d, 0x63, 0xfc, 0x00, 0xf5, 0x5f, 0x6b, 0x69, 0xc6	/* T__pfx_mce_timer_kick */
	.byte 0x0a, 0x54, 0x6d, 0x63, 0xfc, 0x00, 0xf5, 0x5f, 0x6b, 0x69, 0xc6	/* Tmce_timer_kick */
	.byte 0x07, 0xeb, 0xa5, 0x6c, 0xa2, 0xc1, 0x63, 0x65	/* T__pfx_filter_mce */
	.byte 0x07, 0x54, 0xa5, 0x6c, 0xa2, 0xc1, 0x63, 0x65	/* Tfilter_mce */
	.byte 0x09, 0xeb, 0x6d, 0xba, 0x65, 0xc6, 0xf0, 0x9c, 0xbf, 0xea	/* T__pfx_mcheck_cpu_init */
	.byte 0x09, 0x54, 0x6d, 0xba, 0x65, 0xc6, 0xf0, 0x9c, 0xbf, 0xea	/* Tmcheck_cpu_init */
	.byte 0x0a, 0xeb, 0x6d, 0xba, 0x65, 0xc6, 0xf0, 0x9c, 0xf0, 0xc4, 0xc5	/* T__pfx_mcheck_cpu_clear */
	.byte 0x0a, 0x54, 0x6d, 0xba, 0x65, 0xc6, 0xf0, 0x9c, 0xf0, 0xc4, 0xc5	/* Tmcheck_cpu_clear */
	.byte 0x0b, 0xeb, 0x6d, 0x63, 0xfc, 0x64, 0xca, 0x90, 0xb0, 0x62, 0xd2, 0x6b	/* T__pfx_mce_disable_bank */
	.byte 0x0b, 0x54, 0x6d, 0x63, 0xfc, 0x64, 0xca, 0x90, 0xb0, 0x62, 0xd2, 0x6b	/* Tmce_disable_bank */
	.byte 0x0d, 0xeb, 0x6d, 0x63, 0xfc, 0x67, 0xe2, 0x64, 0x65, 0x06, 0x67, 0x95, 0xed, 0xab	/* T__pfx_mce_get_debugfs_dir */
	.byte 0x0d, 0x54, 0x6d, 0x63, 0xfc, 0x67, 0xe2, 0x64, 0x65, 0x06, 0x67, 0x95, 0xed, 0xab	/* Tmce_get_debugfs_dir */
	.byte 0x05, 0xef, 0x73, 0xa9, 0x72, 0x74	/* t__pfx_s_start */
	.byte 0x04, 0x93, 0xa9, 0x72, 0x74	/* ts_start */
	.byte 0x04, 0xef, 0xe9, 0x6e, 0x8e	/* t__pfx_s_next */
	.byte 0x04, 0x74, 0xe9, 0x6e, 0x8e	/* ts_next */
	.byte 0x05, 0xef, 0x73, 0xf6, 0x74, 0xbe	/* t__pfx_s_stop */
	.byte 0x04, 0x93, 0xf6, 0x74, 0xbe	/* ts_stop */
	.byte 0x0e, 0xef, 0x73, 0xee, 0xf5, 0xea, 0x69, 0xd6, 0x3a, 0x0b, 0x83, 0xfc, 0x77, 0x3c, 0x65	/* t__pfx_severities_coverage_write */
	.byte 0x0d, 0x93, 0xee, 0xf5, 0xea, 0x69, 0xd6, 0x3a, 0x0b, 0x83, 0xfc, 0x77, 0x3c, 0x65	/* tseverities_coverage_write */
	.byte 0x0a, 0xef, 0xca, 0xf0, 0xbe, 0x79, 0xe6, 0xe3, 0xae, 0xb1, 0xf5	/* t__pfx_is_copy_from_user */
	.byte 0x0a, 0xdc, 0x73, 0xf0, 0xbe, 0x79, 0xe6, 0xe3, 0xae, 0xb1, 0xf5	/* tis_copy_from_user */
	.byte 0x0d, 0xef, 0x73, 0xee, 0xf5, 0xea, 0x69, 0xd6, 0x3a, 0x0b, 0x83, 0xfc, 0xbe, 0xf1	/* t__pfx_severities_coverage_open */
	.byte 0x0c, 0x93, 0xee, 0xf5, 0xea, 0x69, 0xd6, 0x3a, 0x0b, 0x83, 0xfc, 0xbe, 0xf1	/* tseverities_coverage_open */
	.byte 0x04, 0xef, 0x73, 0xf6, 0x7c	/* t__pfx_s_show */
	.byte 0x03, 0x93, 0xf6, 0x7c	/* ts_show */
	.byte 0x13, 0xeb, 0x6d, 0x63, 0xfc, 0x67, 0xf1, 0xec, 0x6f, 0xa0, 0xec, 0xf7, 0x70, 0xc5, 0xfc, 0xf7, 0x63, 0xd5, 0x64, 0x73	/* T__pfx_mce_gen_pool_prepare_records */
	.byte 0x13, 0x54, 0x6d, 0x63, 0xfc, 0x67, 0xf1, 0xec, 0x6f, 0xa0, 0xec, 0xf7, 0x70, 0xc5, 0xfc, 0xf7, 0x63, 0xd5, 0x64, 0x73	/* Tmce_gen_pool_prepare_records */
	.byte 0x0e, 0xeb, 0x6d, 0x63, 0xfc, 0x67, 0xf1, 0xec, 0x6f, 0xa0, 0xec, 0xe3, 0x63, 0xd6, 0x73	/* T__pfx_mce_gen_pool_process */
	.byte 0x0e, 0x54, 0x6d, 0x63, 0xfc, 0x67, 0xf1, 0xec, 0x6f, 0xa0, 0xec, 0xe3, 0x63, 0xd6, 0x73	/* Tmce_gen_pool_process */
	.byte 0x0e, 0xeb, 0x6d, 0x63, 0xfc, 0x67, 0xf1, 0xec, 0x6f, 0xa0, 0x5f, 0x65, 0xb6, 0x74, 0x79	/* T__pfx_mce_gen_pool_empty */
	.byte 0x0e, 0x54, 0x6d, 0x63, 0xfc, 0x67, 0xf1, 0xec, 0x6f, 0xa0, 0x5f, 0x65, 0xb6, 0x74, 0x79	/* Tmce_gen_pool_empty */
	.byte 0x0c, 0xeb, 0x6d, 0x63, 0xfc, 0x67, 0xf1, 0xec, 0x6f, 0xa0, 0x5f, 0xc8, 0x64	/* T__pfx_mce_gen_pool_add */
	.byte 0x0c, 0x54, 0x6d, 0x63, 0xfc, 0x67, 0xf1, 0xec, 0x6f, 0xa0, 0x5f, 0xc8, 0x64	/* Tmce_gen_pool_add */
	.byte 0x0b, 0xeb, 0x6d, 0x63, 0xfc, 0x67, 0xf1, 0xec, 0x6f, 0xa0, 0xbf, 0xea	/* T__pfx_mce_gen_pool_init */
	.byte 0x0b, 0x54, 0x6d, 0x63, 0xfc, 0x67, 0xf1, 0xec, 0x6f, 0xa0, 0xbf, 0xea	/* Tmce_gen_pool_init */
	.byte 0x0d, 0xef, 0x9a, 0xa7, 0x68, 0x29, 0x68, 0xa0, 0xda, 0xb3, 0xf5, 0x72, 0xcd, 0x74	/* t__pfx_intel_threshold_interrupt */
	.byte 0x0d, 0x74, 0x9a, 0xa7, 0x68, 0x29, 0x68, 0xa0, 0xda, 0xb3, 0xf5, 0x72, 0xcd, 0x74	/* tintel_threshold_interrupt */
	.byte 0x0d, 0xef, 0x63, 0x6d, 0x9b, 0xc1, 0x63, 0xec, 0xa0, 0x6c, 0xb8, 0xd2, 0x6b, 0x73	/* t__pfx_cmci_mc_poll_banks */
	.byte 0x0c, 0x26, 0x6d, 0x9b, 0xc1, 0x63, 0xec, 0xa0, 0x6c, 0xb8, 0xd2, 0x6b, 0x73	/* tcmci_mc_poll_banks */
	.byte 0x0c, 0x74, 0xaf, 0xf0, 0x6d, 0x9b, 0xed, 0xca, 0x90, 0xb0, 0x62, 0xd2, 0x6b	/* t__pfx___cmci_disable_bank */
	.byte 0x0c, 0x74, 0xff, 0x63, 0x6d, 0x9b, 0xed, 0xca, 0x90, 0xb0, 0x62, 0xd2, 0x6b	/* t__cmci_disable_bank */
	.byte 0x08, 0xef, 0x63, 0x6d, 0x9b, 0xed, 0xca, 0x03, 0x0b	/* t__pfx_cmci_discover */
	.byte 0x07, 0x26, 0x6d, 0x9b, 0xed, 0xca, 0x03, 0x0b	/* tcmci_discover */
	.byte 0x0b, 0xef, 0x6c, 0x6d, 0x63, 0xfc, 0x73, 0xcd, 0x70, 0xd5, 0x74, 0x9e	/* t__pfx_lmce_supported */
	.byte 0x0a, 0x23, 0x6d, 0x63, 0xfc, 0x73, 0xcd, 0x70, 0xd5, 0x74, 0x9e	/* tlmce_supported */
	.byte 0x0a, 0xef, 0x63, 0x6d, 0x9b, 0xf6, 0xcd, 0x70, 0xd5, 0x74, 0x9e	/* t__pfx_cmci_supported */
	.byte 0x09, 0x26, 0x6d, 0x9b, 0xf6, 0xcd, 0x70, 0xd5, 0x74, 0x9e	/* tcmci_supported */
	.byte 0x0e, 0xef, 0x63, 0x6d, 0x9b, 0xde, 0x64, 0xca, 0x03, 0x0b, 0x92, 0xd5, 0x6b, 0xe6, 0x96	/* t__pfx_cmci_rediscover_work_func */
	.byte 0x0d, 0x26, 0x6d, 0x9b, 0xde, 0x64, 0xca, 0x03, 0x0b, 0x92, 0xd5, 0x6b, 0xe6, 0x96	/* tcmci_rediscover_work_func */
	.byte 0x0c, 0xeb, 0x6d, 0x63, 0xfc, 0x9a, 0xa3, 0x05, 0xb0, 0x73, 0x74, 0xd5, 0x6d	/* T__pfx_mce_intel_handle_storm */
	.byte 0x0c, 0x54, 0x6d, 0x63, 0xfc, 0x9a, 0xa3, 0x05, 0xb0, 0x73, 0x74, 0xd5, 0x6d	/* Tmce_intel_handle_storm */
	.byte 0x08, 0xeb, 0x63, 0x6d, 0x9b, 0xde, 0xba, 0x65, 0xc6	/* T__pfx_cmci_recheck */
	.byte 0x08, 0x54, 0x63, 0x6d, 0x9b, 0xde, 0xba, 0x65, 0xc6	/* Tcmci_recheck */
	.byte 0x07, 0xeb, 0x63, 0x6d, 0x9b, 0xf0, 0xc4, 0xc5	/* T__pfx_cmci_clear */
	.byte 0x07, 0x54, 0x63, 0x6d, 0x9b, 0xf0, 0xc4, 0xc5	/* Tcmci_clear */
	.byte 0x09, 0xeb, 0x63, 0x6d, 0x9b, 0xde, 0x64, 0xca, 0x03, 0x0b	/* T__pfx_cmci_rediscover */
	.byte 0x09, 0x54, 0x63, 0x6d, 0x9b, 0xde, 0x64, 0xca, 0x03, 0x0b	/* Tcmci_rediscover */
	.byte 0x08, 0xeb, 0x63, 0x6d, 0x9b, 0xde, 0xf1, 0x90, 0xc4	/* T__pfx_cmci_reenable */
	.byte 0x08, 0x54, 0x63, 0x6d, 0x9b, 0xde, 0xf1, 0x90, 0xc4	/* Tcmci_reenable */
	.byte 0x0b, 0xeb, 0x63, 0x6d, 0x9b, 0xed, 0xca, 0x90, 0xb0, 0x62, 0xd2, 0x6b	/* T__pfx_cmci_disable_bank */
	.byte 0x0b, 0x54, 0x63, 0x6d, 0x9b, 0xed, 0xca, 0x90, 0xb0, 0x62, 0xd2, 0x6b	/* Tcmci_disable_bank */
	.byte 0x07, 0xeb, 0x9a, 0xbf, 0x9d, 0x63, 0x6d, 0x9b	/* T__pfx_intel_init_cmci */
	.byte 0x07, 0x54, 0x9a, 0xbf, 0x9d, 0x63, 0x6d, 0x9b	/* Tintel_init_cmci */
	.byte 0x08, 0xeb, 0x9a, 0xbf, 0x9d, 0x6c, 0x6d, 0x63, 0x65	/* T__pfx_intel_init_lmce */
	.byte 0x08, 0x54, 0x9a, 0xbf, 0x9d, 0x6c, 0x6d, 0x63, 0x65	/* Tintel_init_lmce */
	.byte 0x0a, 0xeb, 0x9a, 0xf0, 0xc4, 0xc5, 0x5f, 0x6c, 0x6d, 0x63, 0x65	/* T__pfx_intel_clear_lmce */
	.byte 0x0a, 0x54, 0x9a, 0xf0, 0xc4, 0xc5, 0x5f, 0x6c, 0x6d, 0x63, 0x65	/* Tintel_clear_lmce */
	.byte 0x0b, 0xeb, 0x6d, 0x63, 0xfc, 0x9a, 0xe6, 0x65, 0xe8, 0x98, 0xfc, 0x0f	/* T__pfx_mce_intel_feature_init */
	.byte 0x0b, 0x54, 0x6d, 0x63, 0xfc, 0x9a, 0xe6, 0x65, 0xe8, 0x98, 0xfc, 0x0f	/* Tmce_intel_feature_init */
	.byte 0x0d, 0xeb, 0x6d, 0x63, 0xfc, 0x9a, 0xe6, 0x65, 0xe8, 0x98, 0xfc, 0x63, 0xc4, 0xc5	/* T__pfx_mce_intel_feature_clear */
	.byte 0x0d, 0x54, 0x6d, 0x63, 0xfc, 0x9a, 0xe6, 0x65, 0xe8, 0x98, 0xfc, 0x63, 0xc4, 0xc5	/* Tmce_intel_feature_clear */
	.byte 0x09, 0xeb, 0x9a, 0xe6, 0x69, 0x6c, 0xa2, 0xc1, 0x63, 0x65	/* T__pfx_intel_filter_mce */
	.byte 0x09, 0x54, 0x9a, 0xe6, 0x69, 0x6c, 0xa2, 0xc1, 0x63, 0x65	/* Tintel_filter_mce */
	.byte 0x0c, 0xeb, 0x9a, 0xc1, 0x63, 0xfc, 0xb1, 0x90, 0xb0, 0xc8, 0x64, 0x29, 0x73	/* T__pfx_intel_mce_usable_address */
	.byte 0x0c, 0x54, 0x9a, 0xc1, 0x63, 0xfc, 0xb1, 0x90, 0xb0, 0xc8, 0x64, 0x29, 0x73	/* Tintel_mce_usable_address */
	.byte 0x0c, 0xeb, 0x73, 0x6d, 0x63, 0x61, 0x86, 0x62, 0xd2, 0x6b, 0xa7, 0x21, 0x65	/* T__pfx_smca_get_bank_type */
	.byte 0x0c, 0x54, 0x73, 0x6d, 0x63, 0x61, 0x86, 0x62, 0xd2, 0x6b, 0xa7, 0x21, 0x65	/* Tsmca_get_bank_type */
	.byte 0x03, 0xef, 0x73, 0x7c	/* t__pfx_show */
	.byte 0x02, 0x93, 0x7c	/* tshow */
	.byte 0x04, 0xef, 0x73, 0x8a, 0xf7	/* t__pfx_store */
	.byte 0x03, 0x93, 0x8a, 0xf7	/* tstore */
	.byte 0x15, 0xef, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x64, 0x65, 0x66, 0xf5, 0xf7, 0xda, 0xf5, 0xe3, 0x72, 0xbf, 0xa2, 0x72, 0xcd, 0x74	/* t__pfx_default_deferred_error_interrupt */
	.byte 0x15, 0x74, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x64, 0x65, 0x66, 0xf5, 0xf7, 0xda, 0xf5, 0xe3, 0x72, 0xbf, 0xa2, 0x72, 0xcd, 0x74	/* tdefault_deferred_error_interrupt */
	.byte 0x0d, 0xef, 0x74, 0x68, 0x29, 0x68, 0xa0, 0xda, 0x62, 0xa4, 0xde, 0xc4, 0xbb, 0x65	/* t__pfx_threshold_block_release */
	.byte 0x0d, 0x74, 0x74, 0x68, 0x29, 0x68, 0xa0, 0xda, 0x62, 0xa4, 0xde, 0xc4, 0xbb, 0x65	/* tthreshold_block_release */
	.byte 0x0d, 0xef, 0x73, 0x74, 0xd5, 0xfc, 0xb3, 0xf5, 0x72, 0xcd, 0xfe, 0xf1, 0x90, 0xc4	/* t__pfx_store_interrupt_enable */
	.byte 0x0c, 0x93, 0x74, 0xd5, 0xfc, 0xb3, 0xf5, 0x72, 0xcd, 0xfe, 0xf1, 0x90, 0xc4	/* tstore_interrupt_enable */
	.byte 0x0f, 0xef, 0x73, 0x74, 0xd5, 0xfc, 0x74, 0x68, 0x29, 0x68, 0xa0, 0xda, 0x6c, 0x69, 0x6d, 0xea	/* t__pfx_store_threshold_limit */
	.byte 0x0e, 0x93, 0x74, 0xd5, 0xfc, 0x74, 0x68, 0x29, 0x68, 0xa0, 0xda, 0x6c, 0x69, 0x6d, 0xea	/* tstore_threshold_limit */
	.byte 0x0b, 0xef, 0x73, 0x7c, 0xbf, 0xa2, 0x72, 0xcd, 0xfe, 0xf1, 0x90, 0xc4	/* t__pfx_show_interrupt_enable */
	.byte 0x0a, 0x93, 0x7c, 0xbf, 0xa2, 0x72, 0xcd, 0xfe, 0xf1, 0x90, 0xc4	/* tshow_interrupt_enable */
	.byte 0x0d, 0xef, 0x73, 0x7c, 0xa7, 0x68, 0x29, 0x68, 0xa0, 0xda, 0x6c, 0x69, 0x6d, 0xea	/* t__pfx_show_threshold_limit */
	.byte 0x0c, 0x93, 0x7c, 0xa7, 0x68, 0x29, 0x68, 0xa0, 0xda, 0x6c, 0x69, 0x6d, 0xea	/* tshow_threshold_limit */
	.byte 0x0a, 0xef, 0x73, 0x7c, 0x5f, 0xf5, 0xe3, 0x72, 0x3a, 0xe4, 0x74	/* t__pfx_show_error_count */
	.byte 0x09, 0x93, 0x7c, 0x5f, 0xf5, 0xe3, 0x72, 0x3a, 0xe4, 0x74	/* tshow_error_count */
	.byte 0x11, 0xef, 0x67, 0xe2, 0x62, 0xa4, 0x5f, 0xc8, 0x64, 0x29, 0x73, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__pfx_get_block_address.constprop.0 */
	.byte 0x11, 0x74, 0x67, 0xe2, 0x62, 0xa4, 0x5f, 0xc8, 0x64, 0x29, 0x73, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* tget_block_address.constprop.0 */
	.byte 0x0e, 0x74, 0xaf, 0xa7, 0x68, 0x29, 0x68, 0xa0, 0x64, 0xde, 0x17, 0x1a, 0xb5, 0xaa, 0x65	/* t__pfx___threshold_remove_device */
	.byte 0x0e, 0x74, 0xff, 0x74, 0x68, 0x29, 0x68, 0xa0, 0x64, 0xde, 0x17, 0x1a, 0xb5, 0xaa, 0x65	/* t__threshold_remove_device */
	.byte 0x0f, 0x74, 0xaf, 0x7f, 0x73, 0x76, 0xb4, 0xed, 0x65, 0x66, 0xf5, 0xf7, 0xda, 0xf5, 0xe3, 0x72	/* t__pfx___sysvec_deferred_error */
	.byte 0x0f, 0x74, 0xff, 0xe1, 0x73, 0x76, 0xb4, 0xed, 0x65, 0x66, 0xf5, 0xf7, 0xda, 0xf5, 0xe3, 0x72	/* t__sysvec_deferred_error */
	.byte 0x06, 0xef, 0x67, 0xe2, 0x6e, 0x61, 0xa8	/* t__pfx_get_name */
	.byte 0x06, 0x74, 0x67, 0xe2, 0x6e, 0x61, 0xa8	/* tget_name */
	.byte 0x0e, 0xef, 0x74, 0x68, 0x29, 0x68, 0xa0, 0x64, 0xde, 0x3d, 0x72, 0xfe, 0x62, 0xd2, 0x6b	/* t__pfx_threshold_restart_bank */
	.byte 0x0e, 0x74, 0x74, 0x68, 0x29, 0x68, 0xa0, 0x64, 0xde, 0x3d, 0x72, 0xfe, 0x62, 0xd2, 0x6b	/* tthreshold_restart_bank */
	.byte 0x09, 0x74, 0xaf, 0x5f, 0xdd, 0x67, 0x5f, 0xf5, 0xe3, 0x72	/* t__pfx___log_error */
	.byte 0x08, 0x74, 0xff, 0xdd, 0x67, 0x5f, 0xf5, 0xe3, 0x72	/* t__log_error */
	.byte 0x0e, 0x74, 0xaf, 0xdd, 0x67, 0x5f, 0xf5, 0xe3, 0x72, 0xed, 0x65, 0x66, 0xf5, 0xf7, 0x64	/* t__pfx__log_error_deferred */
	.byte 0x0d, 0xfe, 0xdd, 0x67, 0x5f, 0xf5, 0xe3, 0x72, 0xed, 0x65, 0x66, 0xf5, 0xf7, 0x64	/* t_log_error_deferred */
	.byte 0x09, 0xef, 0xdd, 0x67, 0x5f, 0x05, 0x07, 0xe2, 0x62, 0xa4	/* t__pfx_log_and_reset_block */
	.byte 0x09, 0x74, 0xdd, 0x67, 0x5f, 0x05, 0x07, 0xe2, 0x62, 0xa4	/* tlog_and_reset_block */
	.byte 0x0e, 0xef, 0x2a, 0xda, 0x74, 0x68, 0x29, 0x68, 0xa0, 0xda, 0xb3, 0xf5, 0x72, 0xcd, 0x74	/* t__pfx_amd_threshold_interrupt */
	.byte 0x0e, 0xf4, 0x6d, 0xda, 0x74, 0x68, 0x29, 0x68, 0xa0, 0xda, 0xb3, 0xf5, 0x72, 0xcd, 0x74	/* tamd_threshold_interrupt */
	.byte 0x11, 0xef, 0x2a, 0x64, 0xed, 0x65, 0x66, 0xf5, 0xf7, 0xda, 0xf5, 0xe3, 0x72, 0xbf, 0xa2, 0x72, 0xcd, 0x74	/* t__pfx_amd_deferred_error_interrupt */
	.byte 0x11, 0xf4, 0x6d, 0x64, 0xed, 0x65, 0x66, 0xf5, 0xf7, 0xda, 0xf5, 0xe3, 0x72, 0xbf, 0xa2, 0x72, 0xcd, 0x74	/* tamd_deferred_error_interrupt */
	.byte 0x0e, 0xef, 0x70, 0xf7, 0x70, 0xc5, 0xfc, 0x74, 0x68, 0x29, 0x68, 0xa0, 0xda, 0x62, 0xa4	/* t__pfx_prepare_threshold_block */
	.byte 0x0d, 0xce, 0xf7, 0x70, 0xc5, 0xfc, 0x74, 0x68, 0x29, 0x68, 0xa0, 0xda, 0x62, 0xa4	/* tprepare_threshold_block */
	.byte 0x0d, 0xef, 0x22, 0x63, 0x91, 0x74, 0x68, 0x29, 0x68, 0xa0, 0xda, 0x62, 0xa4, 0x73	/* t__pfx_allocate_threshold_blocks */
	.byte 0x0e, 0xf4, 0x6c, 0xdd, 0x63, 0x91, 0x74, 0x68, 0x29, 0x68, 0xa0, 0xda, 0x62, 0xa4, 0x73	/* tallocate_threshold_blocks */
	.byte 0x0a, 0xeb, 0x2a, 0x64, 0xe6, 0x69, 0x6c, 0xa2, 0xc1, 0x63, 0x65	/* T__pfx_amd_filter_mce */
	.byte 0x0a, 0x54, 0x2a, 0x64, 0xe6, 0x69, 0x6c, 0xa2, 0xc1, 0x63, 0x65	/* Tamd_filter_mce */
	.byte 0x0c, 0xeb, 0x6d, 0x63, 0xfc, 0x2a, 0x64, 0xe6, 0x65, 0xe8, 0x98, 0xfc, 0x0f	/* T__pfx_mce_amd_feature_init */
	.byte 0x0c, 0x54, 0x6d, 0x63, 0xfc, 0x2a, 0x64, 0xe6, 0x65, 0xe8, 0x98, 0xfc, 0x0f	/* Tmce_amd_feature_init */
	.byte 0x0f, 0xeb, 0x2a, 0xda, 0x6d, 0x63, 0xfc, 0x69, 0xe9, 0xa8, 0x6d, 0xd5, 0x1d, 0xf5, 0xe3, 0x72	/* T__pfx_amd_mce_is_memory_error */
	.byte 0x0f, 0x54, 0x2a, 0xda, 0x6d, 0x63, 0xfc, 0x69, 0xe9, 0xa8, 0x6d, 0xd5, 0x1d, 0xf5, 0xe3, 0x72	/* Tamd_mce_is_memory_error */
	.byte 0x0d, 0xeb, 0x2a, 0xda, 0x6d, 0x63, 0xfc, 0xb1, 0x90, 0xb0, 0xc8, 0x64, 0x29, 0x73	/* T__pfx_amd_mce_usable_address */
	.byte 0x0d, 0x54, 0x2a, 0xda, 0x6d, 0x63, 0xfc, 0xb1, 0x90, 0xb0, 0xc8, 0x64, 0x29, 0x73	/* Tamd_mce_usable_address */
	.byte 0x11, 0xeb, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0xb4, 0xed, 0x65, 0x66, 0xf5, 0xf7, 0xda, 0xf5, 0xe3, 0x72	/* T__pfx_fred_sysvec_deferred_error */
	.byte 0x11, 0x54, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0xb4, 0xed, 0x65, 0x66, 0xf5, 0xf7, 0xda, 0xf5, 0xe3, 0x72	/* Tfred_sysvec_deferred_error */
	.byte 0x10, 0xeb, 0x6d, 0x63, 0xfc, 0x74, 0x68, 0x29, 0x68, 0xa0, 0x64, 0xde, 0x17, 0x1a, 0xb5, 0xaa, 0x65	/* T__pfx_mce_threshold_remove_device */
	.byte 0x10, 0x54, 0x6d, 0x63, 0xfc, 0x74, 0x68, 0x29, 0x68, 0xa0, 0x64, 0xde, 0x17, 0x1a, 0xb5, 0xaa, 0x65	/* Tmce_threshold_remove_device */
	.byte 0x10, 0xeb, 0x6d, 0x63, 0xfc, 0x74, 0x68, 0x29, 0x68, 0xa0, 0x64, 0xf0, 0xf7, 0x91, 0xb5, 0xaa, 0x65	/* T__pfx_mce_threshold_create_device */
	.byte 0x10, 0x54, 0x6d, 0x63, 0xfc, 0x74, 0x68, 0x29, 0x68, 0xa0, 0x64, 0xf0, 0xf7, 0x91, 0xb5, 0xaa, 0x65	/* Tmce_threshold_create_device */
	.byte 0x12, 0xef, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x74, 0x68, 0x29, 0x68, 0xa0, 0xda, 0xb3, 0xf5, 0x72, 0xcd, 0x74	/* t__pfx_default_threshold_interrupt */
	.byte 0x12, 0x74, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x74, 0x68, 0x29, 0x68, 0xa0, 0xda, 0xb3, 0xf5, 0x72, 0xcd, 0x74	/* tdefault_threshold_interrupt */
	.byte 0x0d, 0x74, 0xaf, 0x7f, 0x73, 0x76, 0x65, 0xc9, 0x74, 0x68, 0x29, 0x68, 0xa0, 0x64	/* t__pfx___sysvec_threshold */
	.byte 0x0d, 0x74, 0xff, 0xe1, 0x73, 0x76, 0x65, 0xc9, 0x74, 0x68, 0x29, 0x68, 0xa0, 0x64	/* t__sysvec_threshold */
	.byte 0x0f, 0xeb, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0x65, 0xc9, 0x74, 0x68, 0x29, 0x68, 0xa0, 0x64	/* T__pfx_fred_sysvec_threshold */
	.byte 0x0f, 0x54, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0x65, 0xc9, 0x74, 0x68, 0x29, 0x68, 0xa0, 0x64	/* Tfred_sysvec_threshold */
	.byte 0x0c, 0xeb, 0x6d, 0x63, 0xfc, 0xf8, 0x68, 0xf5, 0x9d, 0x73, 0x74, 0xd5, 0x6d	/* T__pfx_mce_inherit_storm */
	.byte 0x0c, 0x54, 0x6d, 0x63, 0xfc, 0xf8, 0x68, 0xf5, 0x9d, 0x73, 0x74, 0xd5, 0x6d	/* Tmce_inherit_storm */
	.byte 0x0d, 0xeb, 0x6d, 0x63, 0xfc, 0x67, 0xe2, 0x73, 0x74, 0xd5, 0x6d, 0xc1, 0xb7, 0x65	/* T__pfx_mce_get_storm_mode */
	.byte 0x0d, 0x54, 0x6d, 0x63, 0xfc, 0x67, 0xe2, 0x73, 0x74, 0xd5, 0x6d, 0xc1, 0xb7, 0x65	/* Tmce_get_storm_mode */
	.byte 0x0d, 0xeb, 0x6d, 0x63, 0xfc, 0x73, 0xe2, 0x73, 0x74, 0xd5, 0x6d, 0xc1, 0xb7, 0x65	/* T__pfx_mce_set_storm_mode */
	.byte 0x0d, 0x54, 0x6d, 0x63, 0xfc, 0x73, 0xe2, 0x73, 0x74, 0xd5, 0x6d, 0xc1, 0xb7, 0x65	/* Tmce_set_storm_mode */
	.byte 0x0c, 0xeb, 0x63, 0x6d, 0x9b, 0xf6, 0x74, 0xd5, 0x6d, 0xb8, 0x65, 0x67, 0xf8	/* T__pfx_cmci_storm_begin */
	.byte 0x0c, 0x54, 0x63, 0x6d, 0x9b, 0xf6, 0x74, 0xd5, 0x6d, 0xb8, 0x65, 0x67, 0xf8	/* Tcmci_storm_begin */
	.byte 0x0a, 0xeb, 0x63, 0x6d, 0x9b, 0xf6, 0x74, 0xd5, 0xae, 0xf1, 0x64	/* T__pfx_cmci_storm_end */
	.byte 0x0a, 0x54, 0x63, 0x6d, 0x9b, 0xf6, 0x74, 0xd5, 0xae, 0xf1, 0x64	/* Tcmci_storm_end */
	.byte 0x0a, 0xeb, 0x6d, 0x63, 0xfc, 0xdf, 0x6b, 0xf6, 0x74, 0xd5, 0x6d	/* T__pfx_mce_track_storm */
	.byte 0x0a, 0x54, 0x6d, 0x63, 0xfc, 0xdf, 0x6b, 0xf6, 0x74, 0xd5, 0x6d	/* Tmce_track_storm */
	.byte 0x11, 0xef, 0x6d, 0xf3, 0x72, 0xde, 0x6e, 0x64, 0x65, 0x7a, 0x76, 0x6f, 0x75, 0xe9, 0x68, 0x05, 0x6c, 0xf5	/* t__pfx_mtrr_rendezvous_handler */
	.byte 0x11, 0x74, 0x6d, 0xf3, 0x72, 0xde, 0x6e, 0x64, 0x65, 0x7a, 0x76, 0x6f, 0x75, 0xe9, 0x68, 0x05, 0x6c, 0xf5	/* tmtrr_rendezvous_handler */
	.byte 0x0c, 0xeb, 0xc5, 0xba, 0xec, 0x68, 0x79, 0xe9, 0x77, 0xc9, 0xf8, 0x64, 0xcb	/* T__pfx_arch_phys_wc_index */
	.byte 0x0c, 0x54, 0xc5, 0xba, 0xec, 0x68, 0x79, 0xe9, 0x77, 0xc9, 0xf8, 0x64, 0xcb	/* Tarch_phys_wc_index */
	.byte 0x0a, 0xeb, 0x6d, 0xf3, 0x72, 0x5f, 0xc8, 0x64, 0xec, 0x83, 0x65	/* T__pfx_mtrr_add_page */
	.byte 0x0a, 0x54, 0x6d, 0xf3, 0x72, 0x5f, 0xc8, 0x64, 0xec, 0x83, 0x65	/* Tmtrr_add_page */
	.byte 0x07, 0xeb, 0x6d, 0xf3, 0x72, 0x5f, 0xc8, 0x64	/* T__pfx_mtrr_add */
	.byte 0x07, 0x54, 0x6d, 0xf3, 0x72, 0x5f, 0xc8, 0x64	/* Tmtrr_add */
	.byte 0x0b, 0xeb, 0xc5, 0xba, 0xec, 0x68, 0x79, 0xe9, 0x77, 0xc9, 0xc8, 0x64	/* T__pfx_arch_phys_wc_add */
	.byte 0x0b, 0x54, 0xc5, 0xba, 0xec, 0x68, 0x79, 0xe9, 0x77, 0xc9, 0xc8, 0x64	/* Tarch_phys_wc_add */
	.byte 0x09, 0xeb, 0x6d, 0xf3, 0x72, 0xed, 0xdb, 0xec, 0x83, 0x65	/* T__pfx_mtrr_del_page */
	.byte 0x09, 0x54, 0x6d, 0xf3, 0x72, 0xed, 0xdb, 0xec, 0x83, 0x65	/* Tmtrr_del_page */
	.byte 0x0b, 0xeb, 0xc5, 0xba, 0xec, 0x68, 0x79, 0xe9, 0x77, 0x63, 0xed, 0xdb	/* T__pfx_arch_phys_wc_del */
	.byte 0x0b, 0x54, 0xc5, 0xba, 0xec, 0x68, 0x79, 0xe9, 0x77, 0x63, 0xed, 0xdb	/* Tarch_phys_wc_del */
	.byte 0x06, 0xeb, 0x6d, 0xf3, 0x72, 0xed, 0xdb	/* T__pfx_mtrr_del */
	.byte 0x06, 0x54, 0x6d, 0xf3, 0x72, 0xed, 0xdb	/* Tmtrr_del */
	.byte 0x09, 0xeb, 0x6d, 0xf3, 0x72, 0xf6, 0x61, 0x1a, 0x3d, 0x2c	/* T__pfx_mtrr_save_state */
	.byte 0x09, 0x54, 0x6d, 0xf3, 0x72, 0xf6, 0x61, 0x1a, 0x3d, 0x2c	/* Tmtrr_save_state */
	.byte 0x08, 0xef, 0x6d, 0xf3, 0x72, 0xf0, 0xdd, 0x73, 0x65	/* t__pfx_mtrr_close */
	.byte 0x08, 0x74, 0x6d, 0xf3, 0x72, 0xf0, 0xdd, 0x73, 0x65	/* tmtrr_close */
	.byte 0x07, 0xef, 0x6d, 0xf3, 0x72, 0x92, 0x3c, 0x65	/* t__pfx_mtrr_write */
	.byte 0x07, 0x74, 0x6d, 0xf3, 0x72, 0x92, 0x3c, 0x65	/* tmtrr_write */
	.byte 0x07, 0xef, 0x6d, 0xf3, 0x72, 0x5f, 0xbe, 0xf1	/* t__pfx_mtrr_open */
	.byte 0x07, 0x74, 0x6d, 0xf3, 0x72, 0x5f, 0xbe, 0xf1	/* tmtrr_open */
	.byte 0x09, 0xef, 0x6d, 0xf3, 0x72, 0xf6, 0x65, 0x71, 0xf6, 0x7c	/* t__pfx_mtrr_seq_show */
	.byte 0x09, 0x74, 0x6d, 0xf3, 0x72, 0xf6, 0x65, 0x71, 0xf6, 0x7c	/* tmtrr_seq_show */
	.byte 0x10, 0xef, 0x6d, 0xf3, 0x72, 0xe6, 0x69, 0xb0, 0xc8, 0x64, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__pfx_mtrr_file_add.constprop.0 */
	.byte 0x10, 0x74, 0x6d, 0xf3, 0x72, 0xe6, 0x69, 0xb0, 0xc8, 0x64, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* tmtrr_file_add.constprop.0 */
	.byte 0x08, 0xef, 0x6d, 0xf3, 0x72, 0x5f, 0xc0, 0x63, 0x23	/* t__pfx_mtrr_ioctl */
	.byte 0x08, 0x74, 0x6d, 0xf3, 0x72, 0x5f, 0xc0, 0x63, 0x23	/* tmtrr_ioctl */
	.byte 0x0c, 0xeb, 0x6d, 0xf3, 0x72, 0x5f, 0x24, 0x69, 0x62, 0xa7, 0x6f, 0xf6, 0xf3	/* T__pfx_mtrr_attrib_to_str */
	.byte 0x0c, 0x54, 0x6d, 0xf3, 0x72, 0x5f, 0x24, 0x69, 0x62, 0xa7, 0x6f, 0xf6, 0xf3	/* Tmtrr_attrib_to_str */
	.byte 0x0f, 0xeb, 0x67, 0xf1, 0xf5, 0x69, 0xc9, 0x67, 0xe2, 0x66, 0xf7, 0xfc, 0xf7, 0x67, 0x69, 0xe7	/* T__pfx_generic_get_free_region */
	.byte 0x0f, 0x54, 0x67, 0xf1, 0xf5, 0x69, 0xc9, 0x67, 0xe2, 0x66, 0xf7, 0xfc, 0xf7, 0x67, 0x69, 0xe7	/* Tgeneric_get_free_region */
	.byte 0x08, 0xef, 0x72, 0xae, 0x97, 0x0d, 0xf3, 0x1d, 0xe8	/* t__pfx_rm_map_entry_at */
	.byte 0x07, 0xf3, 0xae, 0x97, 0x0d, 0xf3, 0x1d, 0xe8	/* trm_map_entry_at */
	.byte 0x08, 0xef, 0xc8, 0xda, 0x97, 0x0d, 0xf3, 0x1d, 0xe8	/* t__pfx_add_map_entry_at */
	.byte 0x08, 0xf4, 0x64, 0xda, 0x97, 0x0d, 0xf3, 0x1d, 0xe8	/* tadd_map_entry_at */
	.byte 0x0f, 0xeb, 0x67, 0xf1, 0xf5, 0x69, 0xc9, 0x76, 0xe5, 0x9f, 0x91, 0xc8, 0x64, 0xec, 0x83, 0x65	/* T__pfx_generic_validate_add_page */
	.byte 0x0f, 0x54, 0x67, 0xf1, 0xf5, 0x69, 0xc9, 0x76, 0xe5, 0x9f, 0x91, 0xc8, 0x64, 0xec, 0x83, 0x65	/* Tgeneric_validate_add_page */
	.byte 0x08, 0xef, 0x74, 0x21, 0xfc, 0x6d, 0xf5, 0x67, 0x65	/* t__pfx_type_merge */
	.byte 0x08, 0x74, 0x74, 0x21, 0xfc, 0x6d, 0xf5, 0x67, 0x65	/* ttype_merge */
	.byte 0x07, 0xef, 0xc8, 0xda, 0x97, 0x0d, 0xf3, 0x79	/* t__pfx_add_map_entry */
	.byte 0x07, 0xf4, 0x64, 0xda, 0x97, 0x0d, 0xf3, 0x79	/* tadd_map_entry */
	.byte 0x07, 0xef, 0x97, 0x5f, 0xc8, 0xda, 0x76, 0xc5	/* t__pfx_map_add_var */
	.byte 0x07, 0x74, 0x97, 0x5f, 0xc8, 0xda, 0x76, 0xc5	/* tmap_add_var */
	.byte 0x0e, 0xef, 0x67, 0xf1, 0xf5, 0x69, 0xc9, 0x68, 0x61, 0x1a, 0x77, 0x72, 0x03, 0x6d, 0x62	/* t__pfx_generic_have_wrcomb */
	.byte 0x0e, 0x74, 0x67, 0xf1, 0xf5, 0x69, 0xc9, 0x68, 0x61, 0x1a, 0x77, 0x72, 0x03, 0x6d, 0x62	/* tgeneric_have_wrcomb */
	.byte 0x0b, 0xef, 0x67, 0xf1, 0xf5, 0x69, 0xc9, 0x67, 0xe2, 0x6d, 0xf3, 0x72	/* t__pfx_generic_get_mtrr */
	.byte 0x0b, 0x74, 0x67, 0xf1, 0xf5, 0x69, 0xc9, 0x67, 0xe2, 0x6d, 0xf3, 0x72	/* tgeneric_get_mtrr */
	.byte 0x0b, 0xeb, 0x67, 0xf1, 0xf5, 0xaa, 0xde, 0x06, 0x69, 0x6c, 0xda, 0x97	/* T__pfx_generic_rebuild_map */
	.byte 0x0b, 0x54, 0x67, 0xf1, 0xf5, 0xaa, 0xde, 0x06, 0x69, 0x6c, 0xda, 0x97	/* Tgeneric_rebuild_map */
	.byte 0x0c, 0xeb, 0x6d, 0xf3, 0x72, 0x5f, 0x6f, 0x0b, 0x77, 0x3c, 0xfc, 0x3d, 0x2c	/* T__pfx_mtrr_overwrite_state */
	.byte 0x0c, 0x54, 0x6d, 0xf3, 0x72, 0x5f, 0x6f, 0x0b, 0x77, 0x3c, 0xfc, 0x3d, 0x2c	/* Tmtrr_overwrite_state */
	.byte 0x0b, 0xeb, 0x6d, 0xf3, 0x72, 0xa7, 0x21, 0xfc, 0xdd, 0x6f, 0x6b, 0xcd	/* T__pfx_mtrr_type_lookup */
	.byte 0x0b, 0x54, 0x6d, 0xf3, 0x72, 0xa7, 0x21, 0xfc, 0xdd, 0x6f, 0x6b, 0xcd	/* Tmtrr_type_lookup */
	.byte 0x0e, 0xeb, 0xa5, 0x6c, 0x6c, 0xc1, 0xf3, 0x72, 0x5f, 0x76, 0xc5, 0xa6, 0xd2, 0x67, 0x65	/* T__pfx_fill_mtrr_var_range */
	.byte 0x0e, 0x54, 0xa5, 0x6c, 0x6c, 0xc1, 0xf3, 0x72, 0x5f, 0x76, 0xc5, 0xa6, 0xd2, 0x67, 0x65	/* Tfill_mtrr_var_range */
	.byte 0x09, 0xeb, 0x6d, 0xf3, 0x72, 0x92, 0x72, 0x6d, 0x73, 0x72	/* T__pfx_mtrr_wrmsr */
	.byte 0x09, 0x54, 0x6d, 0xf3, 0x72, 0x92, 0x72, 0x6d, 0x73, 0x72	/* Tmtrr_wrmsr */
	.byte 0x12, 0xef, 0x67, 0xe2, 0xa5, 0x78, 0x65, 0xda, 0x72, 0xd2, 0x67, 0xd6, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__pfx_get_fixed_ranges.constprop.0 */
	.byte 0x12, 0x74, 0x67, 0xe2, 0xa5, 0x78, 0x65, 0xda, 0x72, 0xd2, 0x67, 0xd6, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* tget_fixed_ranges.constprop.0 */
	.byte 0x0f, 0xeb, 0x6d, 0xf3, 0x72, 0xf6, 0x61, 0x1a, 0xa5, 0x78, 0x65, 0xda, 0x72, 0xd2, 0x67, 0xd6	/* T__pfx_mtrr_save_fixed_ranges */
	.byte 0x0f, 0x54, 0x6d, 0xf3, 0x72, 0xf6, 0x61, 0x1a, 0xa5, 0x78, 0x65, 0xda, 0x72, 0xd2, 0x67, 0xd6	/* Tmtrr_save_fixed_ranges */
	.byte 0x09, 0xef, 0x67, 0xf1, 0xf5, 0xaa, 0x84, 0x6d, 0xf3, 0x72	/* t__pfx_generic_set_mtrr */
	.byte 0x09, 0x74, 0x67, 0xf1, 0xf5, 0xaa, 0x84, 0x6d, 0xf3, 0x72	/* tgeneric_set_mtrr */
	.byte 0x08, 0xeb, 0x6d, 0xf3, 0x72, 0xed, 0xca, 0x90, 0xc4	/* T__pfx_mtrr_disable */
	.byte 0x08, 0x54, 0x6d, 0xf3, 0x72, 0xed, 0xca, 0x90, 0xc4	/* Tmtrr_disable */
	.byte 0x07, 0xeb, 0x6d, 0xf3, 0x72, 0x0d, 0x90, 0xc4	/* T__pfx_mtrr_enable */
	.byte 0x07, 0x54, 0x6d, 0xf3, 0x72, 0x0d, 0x90, 0xc4	/* Tmtrr_enable */
	.byte 0x0b, 0xeb, 0x6d, 0xf3, 0x72, 0xc7, 0xf1, 0xf5, 0xaa, 0x84, 0x3d, 0x2c	/* T__pfx_mtrr_generic_set_state */
	.byte 0x0b, 0x54, 0x6d, 0xf3, 0x72, 0xc7, 0xf1, 0xf5, 0xaa, 0x84, 0x3d, 0x2c	/* Tmtrr_generic_set_state */
	.byte 0x0f, 0xeb, 0x70, 0x6f, 0x73, 0xea, 0x69, 0x1a, 0x68, 0x61, 0x1a, 0x77, 0x72, 0x03, 0x6d, 0x62	/* T__pfx_positive_have_wrcomb */
	.byte 0x0f, 0x54, 0x70, 0x6f, 0x73, 0xea, 0x69, 0x1a, 0x68, 0x61, 0x1a, 0x77, 0x72, 0x03, 0x6d, 0x62	/* Tpositive_have_wrcomb */
	.byte 0x0b, 0xef, 0x6d, 0x63, 0xf0, 0x9c, 0xed, 0xad, 0x6e, 0xec, 0xf7, 0x70	/* t__pfx_mc_cpu_down_prep */
	.byte 0x0b, 0x74, 0x6d, 0x63, 0xf0, 0x9c, 0xed, 0xad, 0x6e, 0xec, 0xf7, 0x70	/* tmc_cpu_down_prep */
	.byte 0x0d, 0xef, 0x70, 0xe3, 0x63, 0xd6, 0x73, 0xd5, 0xe6, 0x6c, 0x83, 0x73, 0xf6, 0x7c	/* t__pfx_processor_flags_show */
	.byte 0x0c, 0xce, 0xe3, 0x63, 0xd6, 0x73, 0xd5, 0xe6, 0x6c, 0x83, 0x73, 0xf6, 0x7c	/* tprocessor_flags_show */
	.byte 0x06, 0xef, 0x0b, 0x85, 0xe7, 0xf6, 0x7c	/* t__pfx_version_show */
	.byte 0x06, 0x74, 0x0b, 0x85, 0xe7, 0xf6, 0x7c	/* tversion_show */
	.byte 0x09, 0xef, 0x6d, 0x63, 0xf0, 0x9c, 0x5f, 0xe7, 0x2d, 0x65	/* t__pfx_mc_cpu_online */
	.byte 0x09, 0x74, 0x6d, 0x63, 0xf0, 0x9c, 0x5f, 0xe7, 0x2d, 0x65	/* tmc_cpu_online */
	.byte 0x0c, 0xeb, 0x6d, 0xaa, 0xe3, 0x63, 0x16, 0x62, 0x73, 0x70, 0x07, 0x75, 0xa8	/* T__pfx_microcode_bsp_resume */
	.byte 0x0c, 0x54, 0x6d, 0xaa, 0xe3, 0x63, 0x16, 0x62, 0x73, 0x70, 0x07, 0x75, 0xa8	/* Tmicrocode_bsp_resume */
	.byte 0x09, 0xeb, 0xdd, 0x61, 0xda, 0x75, 0x63, 0x16, 0x61, 0x70	/* T__pfx_load_ucode_ap */
	.byte 0x09, 0x54, 0xdd, 0x61, 0xda, 0x75, 0x63, 0x16, 0x61, 0x70	/* Tload_ucode_ap */
	.byte 0x0e, 0xeb, 0x9a, 0xc1, 0xaa, 0xe3, 0x63, 0x16, 0x73, 0xd2, 0xea, 0x79, 0x25, 0x65, 0xc6	/* T__pfx_intel_microcode_sanity_check */
	.byte 0x0e, 0x54, 0x9a, 0xc1, 0xaa, 0xe3, 0x63, 0x16, 0x73, 0xd2, 0xea, 0x79, 0x25, 0x65, 0xc6	/* Tintel_microcode_sanity_check */
	.byte 0x0b, 0xef, 0x66, 0xf8, 0xe5, 0x69, 0x7a, 0xfc, 0x6c, 0x91, 0xdd, 0xc8	/* t__pfx_finalize_late_load */
	.byte 0x0b, 0x74, 0x66, 0xf8, 0xe5, 0x69, 0x7a, 0xfc, 0x6c, 0x91, 0xdd, 0xc8	/* tfinalize_late_load */
	.byte 0x0f, 0xeb, 0x9a, 0xe6, 0xf8, 0xda, 0x6d, 0xe8, 0xba, 0x8d, 0xf6, 0x0c, 0x6e, 0xe8, 0x75, 0xf7	/* T__pfx_intel_find_matching_signature */
	.byte 0x0f, 0x54, 0x9a, 0xe6, 0xf8, 0xda, 0x6d, 0xe8, 0xba, 0x8d, 0xf6, 0x0c, 0x6e, 0xe8, 0x75, 0xf7	/* Tintel_find_matching_signature */
	.byte 0x0e, 0xef, 0x70, 0xc5, 0x73, 0xfc, 0x6d, 0xaa, 0xe3, 0x63, 0x16, 0x62, 0xdd, 0x62, 0x73	/* t__pfx_parse_microcode_blobs */
	.byte 0x0d, 0xce, 0xc5, 0x73, 0xfc, 0x6d, 0xaa, 0xe3, 0x63, 0x16, 0x62, 0xdd, 0x62, 0x73	/* tparse_microcode_blobs */
	.byte 0x0c, 0xef, 0xf7, 0xa1, 0xd6, 0xfe, 0x6d, 0xaa, 0xe3, 0x63, 0x16, 0x66, 0x77	/* t__pfx_request_microcode_fw */
	.byte 0x0c, 0x74, 0xf7, 0xa1, 0xd6, 0xfe, 0x6d, 0xaa, 0xe3, 0x63, 0x16, 0x66, 0x77	/* trequest_microcode_fw */
	.byte 0x0c, 0xeb, 0x9a, 0xf0, 0xa0, 0xc4, 0x63, 0xfe, 0x63, 0x9c, 0xbf, 0x66, 0x6f	/* T__pfx_intel_collect_cpu_info */
	.byte 0x0c, 0x54, 0x9a, 0xf0, 0xa0, 0xc4, 0x63, 0xfe, 0x63, 0x9c, 0xbf, 0x66, 0x6f	/* Tintel_collect_cpu_info */
	.byte 0x0b, 0xef, 0x63, 0xa0, 0xc4, 0x63, 0xfe, 0x63, 0x9c, 0xbf, 0x66, 0x6f	/* t__pfx_collect_cpu_info */
	.byte 0x0a, 0x26, 0xa0, 0xc4, 0x63, 0xfe, 0x63, 0x9c, 0xbf, 0x66, 0x6f	/* tcollect_cpu_info */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x79, 0xc1, 0xaa, 0xe3, 0x63, 0xb7, 0x65	/* t__pfx___apply_microcode */
	.byte 0x0d, 0x74, 0xff, 0x61, 0x70, 0x70, 0x6c, 0x79, 0xc1, 0xaa, 0xe3, 0x63, 0xb7, 0x65	/* t__apply_microcode */
	.byte 0x0d, 0xef, 0x61, 0x70, 0x70, 0x6c, 0x79, 0xc1, 0xaa, 0xe3, 0x63, 0x16, 0x6c, 0x14	/* t__pfx_apply_microcode_late */
	.byte 0x0c, 0xf4, 0x70, 0x70, 0x6c, 0x79, 0xc1, 0xaa, 0xe3, 0x63, 0x16, 0x6c, 0x14	/* tapply_microcode_late */
	.byte 0x0b, 0xeb, 0xdd, 0x61, 0xda, 0x75, 0x63, 0x16, 0x9a, 0x5f, 0x61, 0x70	/* T__pfx_load_ucode_intel_ap */
	.byte 0x0b, 0x54, 0xdd, 0x61, 0xda, 0x75, 0x63, 0x16, 0x9a, 0x5f, 0x61, 0x70	/* Tload_ucode_intel_ap */
	.byte 0x09, 0xeb, 0xf7, 0xdd, 0x61, 0xda, 0x75, 0x63, 0x16, 0x9a	/* T__pfx_reload_ucode_intel */
	.byte 0x09, 0x54, 0xf7, 0xdd, 0x61, 0xda, 0x75, 0x63, 0x16, 0x9a	/* Treload_ucode_intel */
	.byte 0x0e, 0xef, 0x6d, 0xaa, 0xe3, 0x63, 0x16, 0x66, 0xf8, 0x69, 0xf0, 0x9c, 0x5f, 0x2a, 0x64	/* t__pfx_microcode_fini_cpu_amd */
	.byte 0x0e, 0x74, 0x6d, 0xaa, 0xe3, 0x63, 0x16, 0x66, 0xf8, 0x69, 0xf0, 0x9c, 0x5f, 0x2a, 0x64	/* tmicrocode_fini_cpu_amd */
	.byte 0x0f, 0xef, 0x0b, 0x69, 0x66, 0x1d, 0x65, 0xa1, 0x69, 0x76, 0xe5, 0xf1, 0x63, 0xfc, 0xe0, 0xc4	/* t__pfx_verify_equivalence_table */
	.byte 0x0f, 0x74, 0x0b, 0x69, 0x66, 0x1d, 0x65, 0xa1, 0x69, 0x76, 0xe5, 0xf1, 0x63, 0xfc, 0xe0, 0xc4	/* tverify_equivalence_table */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x79, 0xc1, 0xaa, 0xe3, 0x63, 0x16, 0x2a, 0x64	/* t__pfx___apply_microcode_amd */
	.byte 0x0e, 0x74, 0xff, 0x61, 0x70, 0x70, 0x6c, 0x79, 0xc1, 0xaa, 0xe3, 0x63, 0x16, 0x2a, 0x64	/* t__apply_microcode_amd */
	.byte 0x08, 0xef, 0x0b, 0x69, 0x66, 0x79, 0xec, 0xe8, 0xba	/* t__pfx_verify_patch */
	.byte 0x08, 0x74, 0x0b, 0x69, 0x66, 0x79, 0xec, 0xe8, 0xba	/* tverify_patch */
	.byte 0x09, 0xef, 0x73, 0x63, 0xd2, 0x3e, 0xf4, 0xf8, 0xf5, 0x73	/* t__pfx_scan_containers */
	.byte 0x08, 0x93, 0x63, 0xd2, 0x3e, 0xf4, 0xf8, 0xf5, 0x73	/* tscan_containers */
	.byte 0x07, 0xef, 0x66, 0xf8, 0x64, 0xec, 0xe8, 0xba	/* t__pfx_find_patch */
	.byte 0x07, 0x74, 0x66, 0xf8, 0x64, 0xec, 0xe8, 0xba	/* tfind_patch */
	.byte 0x0d, 0xef, 0x61, 0x70, 0x70, 0x6c, 0x79, 0xc1, 0xaa, 0xe3, 0x63, 0x16, 0x2a, 0x64	/* t__pfx_apply_microcode_amd */
	.byte 0x0c, 0xf4, 0x70, 0x70, 0x6c, 0x79, 0xc1, 0xaa, 0xe3, 0x63, 0x16, 0x2a, 0x64	/* tapply_microcode_amd */
	.byte 0x0e, 0xef, 0x63, 0xa0, 0xc4, 0x63, 0xfe, 0x63, 0x9c, 0xbf, 0x66, 0x6f, 0x5f, 0x2a, 0x64	/* t__pfx_collect_cpu_info_amd */
	.byte 0x0d, 0x26, 0xa0, 0xc4, 0x63, 0xfe, 0x63, 0x9c, 0xbf, 0x66, 0x6f, 0x5f, 0x2a, 0x64	/* tcollect_cpu_info_amd */
	.byte 0x11, 0x74, 0xaf, 0x5f, 0xdd, 0x61, 0xda, 0x6d, 0xaa, 0xe3, 0x63, 0x16, 0x2a, 0x64, 0x2e, 0xca, 0xbc, 0x7e	/* t__pfx___load_microcode_amd.isra.0 */
	.byte 0x10, 0x74, 0xff, 0xdd, 0x61, 0xda, 0x6d, 0xaa, 0xe3, 0x63, 0x16, 0x2a, 0x64, 0x2e, 0xca, 0xbc, 0x7e	/* t__load_microcode_amd.isra.0 */
	.byte 0x0c, 0xef, 0xf7, 0xa1, 0xd6, 0xfe, 0x6d, 0xaa, 0xe3, 0x63, 0x16, 0x2a, 0x64	/* t__pfx_request_microcode_amd */
	.byte 0x0c, 0x74, 0xf7, 0xa1, 0xd6, 0xfe, 0x6d, 0xaa, 0xe3, 0x63, 0x16, 0x2a, 0x64	/* trequest_microcode_amd */
	.byte 0x0a, 0xeb, 0xf7, 0xdd, 0x61, 0xda, 0x75, 0x63, 0x16, 0x2a, 0x64	/* T__pfx_reload_ucode_amd */
	.byte 0x0a, 0x54, 0xf7, 0xdd, 0x61, 0xda, 0x75, 0x63, 0x16, 0x2a, 0x64	/* Treload_ucode_amd */
	.byte 0x0b, 0xeb, 0xdd, 0x61, 0xda, 0x75, 0x63, 0x16, 0x2a, 0xda, 0x61, 0x70	/* T__pfx_load_ucode_amd_ap */
	.byte 0x0b, 0x54, 0xdd, 0x61, 0xda, 0x75, 0x63, 0x16, 0x2a, 0xda, 0x61, 0x70	/* Tload_ucode_amd_ap */
	.byte 0x0c, 0xeb, 0xf7, 0xc4, 0xbb, 0xfc, 0x19, 0x66, 0x63, 0xf3, 0xbd, 0x6d, 0x69	/* T__pfx_release_perfctr_nmi */
	.byte 0x0c, 0x54, 0xf7, 0xc4, 0xbb, 0xfc, 0x19, 0x66, 0x63, 0xf3, 0xbd, 0x6d, 0x69	/* Trelease_perfctr_nmi */
	.byte 0x0c, 0xeb, 0xf7, 0xc4, 0xbb, 0xfc, 0xee, 0x6e, 0x93, 0xdb, 0xbd, 0x6d, 0x69	/* T__pfx_release_evntsel_nmi */
	.byte 0x0c, 0x54, 0xf7, 0xc4, 0xbb, 0xfc, 0xee, 0x6e, 0x93, 0xdb, 0xbd, 0x6d, 0x69	/* Trelease_evntsel_nmi */
	.byte 0x0b, 0xeb, 0x29, 0xf5, 0x1a, 0xee, 0x6e, 0x93, 0xdb, 0xbd, 0x6d, 0x69	/* T__pfx_reserve_evntsel_nmi */
	.byte 0x0b, 0x54, 0x29, 0xf5, 0x1a, 0xee, 0x6e, 0x93, 0xdb, 0xbd, 0x6d, 0x69	/* Treserve_evntsel_nmi */
	.byte 0x0b, 0xeb, 0x29, 0xf5, 0x1a, 0x19, 0x66, 0x63, 0xf3, 0xbd, 0x6d, 0x69	/* T__pfx_reserve_perfctr_nmi */
	.byte 0x0b, 0x54, 0x29, 0xf5, 0x1a, 0x19, 0x66, 0x63, 0xf3, 0xbd, 0x6d, 0x69	/* Treserve_perfctr_nmi */
	.byte 0x0d, 0xef, 0x76, 0x6d, 0x77, 0xc5, 0xfc, 0x67, 0xe2, 0x93, 0xc9, 0x6b, 0x68, 0x7a	/* t__pfx_vmware_get_tsc_khz */
	.byte 0x0d, 0x74, 0x76, 0x6d, 0x77, 0xc5, 0xfc, 0x67, 0xe2, 0x93, 0xc9, 0x6b, 0x68, 0x7a	/* tvmware_get_tsc_khz */
	.byte 0x0b, 0xef, 0x76, 0x6d, 0x77, 0xc5, 0xfc, 0x73, 0x2c, 0xe5, 0xf0, 0xa4	/* t__pfx_vmware_steal_clock */
	.byte 0x0b, 0x74, 0x76, 0x6d, 0x77, 0xc5, 0xfc, 0x73, 0x2c, 0xe5, 0xf0, 0xa4	/* tvmware_steal_clock */
	.byte 0x12, 0xef, 0x76, 0x6d, 0x77, 0xc5, 0xfc, 0x70, 0x76, 0xde, 0x62, 0x6f, 0x6f, 0xfe, 0x6e, 0x6f, 0xdc, 0x66, 0x79	/* t__pfx_vmware_pv_reboot_notify */
	.byte 0x12, 0x74, 0x76, 0x6d, 0x77, 0xc5, 0xfc, 0x70, 0x76, 0xde, 0x62, 0x6f, 0x6f, 0xfe, 0x6e, 0x6f, 0xdc, 0x66, 0x79	/* tvmware_pv_reboot_notify */
	.byte 0x13, 0xef, 0x76, 0x6d, 0x77, 0xc5, 0xfc, 0x70, 0x76, 0xc7, 0x75, 0xd6, 0xfe, 0x63, 0x9c, 0xde, 0x62, 0x6f, 0x6f, 0x74	/* t__pfx_vmware_pv_guest_cpu_reboot */
	.byte 0x13, 0x74, 0x76, 0x6d, 0x77, 0xc5, 0xfc, 0x70, 0x76, 0xc7, 0x75, 0xd6, 0xfe, 0x63, 0x9c, 0xde, 0x62, 0x6f, 0x6f, 0x74	/* tvmware_pv_guest_cpu_reboot */
	.byte 0x10, 0xef, 0x76, 0x6d, 0x77, 0xc5, 0xfc, 0x63, 0x9c, 0xed, 0xad, 0x6e, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* t__pfx_vmware_cpu_down_prepare */
	.byte 0x10, 0x74, 0x76, 0x6d, 0x77, 0xc5, 0xfc, 0x63, 0x9c, 0xed, 0xad, 0x6e, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* tvmware_cpu_down_prepare */
	.byte 0x0e, 0xef, 0x76, 0x6d, 0x77, 0xc5, 0xfc, 0xf7, 0x0e, 0xf6, 0x2c, 0xe5, 0x5f, 0xdc, 0xa8	/* t__pfx_vmware_register_steal_time */
	.byte 0x0e, 0x74, 0x76, 0x6d, 0x77, 0xc5, 0xfc, 0xf7, 0x0e, 0xf6, 0x2c, 0xe5, 0x5f, 0xdc, 0xa8	/* tvmware_register_steal_time */
	.byte 0x0c, 0xef, 0x76, 0x6d, 0x77, 0xc5, 0xfc, 0x63, 0x9c, 0x5f, 0xe7, 0x2d, 0x65	/* t__pfx_vmware_cpu_online */
	.byte 0x0c, 0x74, 0x76, 0x6d, 0x77, 0xc5, 0xfc, 0x63, 0x9c, 0x5f, 0xe7, 0x2d, 0x65	/* tvmware_cpu_online */
	.byte 0x0e, 0xeb, 0x76, 0x6d, 0x77, 0xc5, 0xfc, 0x68, 0x21, 0xf5, 0x63, 0x5d, 0xf6, 0xdd, 0x77	/* T__pfx_vmware_hypercall_slow */
	.byte 0x0e, 0x54, 0x76, 0x6d, 0x77, 0xc5, 0xfc, 0x68, 0x21, 0xf5, 0x63, 0x5d, 0xf6, 0xdd, 0x77	/* Tvmware_hypercall_slow */
	.byte 0x0a, 0xef, 0x68, 0x76, 0x86, 0x6e, 0x6d, 0x69, 0xde, 0xbb, 0xe7	/* t__pfx_hv_get_nmi_reason */
	.byte 0x0a, 0x74, 0x68, 0x76, 0x86, 0x6e, 0x6d, 0x69, 0xde, 0xbb, 0xe7	/* thv_get_nmi_reason */
	.byte 0x0b, 0xef, 0x6d, 0xe9, 0x68, 0x21, 0xf5, 0x76, 0x5f, 0x6c, 0x91, 0x0f	/* t__pfx_ms_hyperv_late_init */
	.byte 0x0b, 0x74, 0x6d, 0xe9, 0x68, 0x21, 0xf5, 0x76, 0x5f, 0x6c, 0x91, 0x0f	/* tms_hyperv_late_init */
	.byte 0x0c, 0xef, 0x68, 0x76, 0xbd, 0x6d, 0x69, 0x5f, 0xe4, 0x6b, 0x6e, 0xad, 0x6e	/* t__pfx_hv_nmi_unknown */
	.byte 0x0c, 0x74, 0x68, 0x76, 0xbd, 0x6d, 0x69, 0x5f, 0xe4, 0x6b, 0x6e, 0xad, 0x6e	/* thv_nmi_unknown */
	.byte 0x09, 0xef, 0x68, 0x76, 0x86, 0x93, 0xc9, 0x6b, 0x68, 0x7a	/* t__pfx_hv_get_tsc_khz */
	.byte 0x09, 0x74, 0x68, 0x76, 0x86, 0x93, 0xc9, 0x6b, 0x68, 0x7a	/* thv_get_tsc_khz */
	.byte 0x0e, 0xeb, 0x68, 0x76, 0x86, 0x68, 0x21, 0xf5, 0x76, 0xca, 0xd5, 0x5f, 0x0b, 0x85, 0xe7	/* T__pfx_hv_get_hypervisor_version */
	.byte 0x0e, 0x54, 0x68, 0x76, 0x86, 0x68, 0x21, 0xf5, 0x76, 0xca, 0xd5, 0x5f, 0x0b, 0x85, 0xe7	/* Thv_get_hypervisor_version */
	.byte 0x0a, 0xef, 0x63, 0x9c, 0xed, 0x65, 0x06, 0x67, 0x5f, 0xbe, 0xf1	/* t__pfx_cpu_debug_open */
	.byte 0x09, 0x26, 0x9c, 0xed, 0x65, 0x06, 0x67, 0x5f, 0xbe, 0xf1	/* tcpu_debug_open */
	.byte 0x0b, 0xef, 0x64, 0x6f, 0x6d, 0xed, 0x65, 0x06, 0x67, 0x5f, 0xbe, 0xf1	/* t__pfx_dom_debug_open */
	.byte 0x0b, 0x74, 0x64, 0x6f, 0x6d, 0xed, 0x65, 0x06, 0x67, 0x5f, 0xbe, 0xf1	/* tdom_debug_open */
	.byte 0x0a, 0xef, 0x64, 0x6f, 0x6d, 0xed, 0x65, 0x06, 0x67, 0xf6, 0x7c	/* t__pfx_dom_debug_show */
	.byte 0x0a, 0x74, 0x64, 0x6f, 0x6d, 0xed, 0x65, 0x06, 0x67, 0xf6, 0x7c	/* tdom_debug_show */
	.byte 0x09, 0xef, 0x63, 0x9c, 0xed, 0x65, 0x06, 0x67, 0xf6, 0x7c	/* t__pfx_cpu_debug_show */
	.byte 0x08, 0x26, 0x9c, 0xed, 0x65, 0x06, 0x67, 0xf6, 0x7c	/* tcpu_debug_show */
	.byte 0x0e, 0xef, 0x73, 0x70, 0x6c, 0xea, 0xa4, 0xf0, 0x9c, 0x5f, 0x6f, 0x66, 0x66, 0x2d, 0x65	/* t__pfx_splitlock_cpu_offline */
	.byte 0x0d, 0x93, 0x70, 0x6c, 0xea, 0xa4, 0xf0, 0x9c, 0x5f, 0x6f, 0x66, 0x66, 0x2d, 0x65	/* tsplitlock_cpu_offline */
	.byte 0x0b, 0x74, 0xaf, 0xf6, 0x70, 0x6c, 0x9d, 0xa4, 0xde, 0xf1, 0x90, 0xc4	/* t__pfx___split_lock_reenable */
	.byte 0x0b, 0x74, 0xff, 0x73, 0x70, 0x6c, 0x9d, 0xa4, 0xde, 0xf1, 0x90, 0xc4	/* t__split_lock_reenable */
	.byte 0x0d, 0x74, 0xaf, 0xf6, 0x70, 0x6c, 0x9d, 0xa4, 0xde, 0xf1, 0x90, 0xb0, 0xe4, 0xa4	/* t__pfx___split_lock_reenable_unlock */
	.byte 0x0d, 0x74, 0xff, 0x73, 0x70, 0x6c, 0x9d, 0xa4, 0xde, 0xf1, 0x90, 0xb0, 0xe4, 0xa4	/* t__split_lock_reenable_unlock */
	.byte 0x09, 0xef, 0x73, 0x70, 0x6c, 0x9d, 0xa4, 0x92, 0xc5, 0x6e	/* t__pfx_split_lock_warn */
	.byte 0x08, 0x93, 0x70, 0x6c, 0x9d, 0xa4, 0x92, 0xc5, 0x6e	/* tsplit_lock_warn */
	.byte 0x0d, 0xeb, 0x68, 0x05, 0xb0, 0x67, 0x75, 0xd6, 0xfe, 0x73, 0x70, 0x6c, 0x9d, 0xa4	/* T__pfx_handle_guest_split_lock */
	.byte 0x0d, 0x54, 0x68, 0x05, 0xb0, 0x67, 0x75, 0xd6, 0xfe, 0x73, 0x70, 0x6c, 0x9d, 0xa4	/* Thandle_guest_split_lock */
	.byte 0x0e, 0xef, 0x73, 0x70, 0x6c, 0x9d, 0xa4, 0x5f, 0x0b, 0x69, 0x66, 0x79, 0xc1, 0x73, 0x72	/* t__pfx_split_lock_verify_msr */
	.byte 0x0d, 0x93, 0x70, 0x6c, 0x9d, 0xa4, 0x5f, 0x0b, 0x69, 0x66, 0x79, 0xc1, 0x73, 0x72	/* tsplit_lock_verify_msr */
	.byte 0x08, 0xeb, 0x73, 0x70, 0x6c, 0x9d, 0xa4, 0xbf, 0xea	/* T__pfx_split_lock_init */
	.byte 0x08, 0x54, 0x73, 0x70, 0x6c, 0x9d, 0xa4, 0xbf, 0xea	/* Tsplit_lock_init */
	.byte 0x06, 0xeb, 0x06, 0xe9, 0xa4, 0xbf, 0xea	/* T__pfx_bus_lock_init */
	.byte 0x06, 0x54, 0x06, 0xe9, 0xa4, 0xbf, 0xea	/* Tbus_lock_init */
	.byte 0x0b, 0xeb, 0x68, 0x05, 0xb0, 0xb1, 0xf5, 0xf6, 0x70, 0x6c, 0x9d, 0xa4	/* T__pfx_handle_user_split_lock */
	.byte 0x0b, 0x54, 0x68, 0x05, 0xb0, 0xb1, 0xf5, 0xf6, 0x70, 0x6c, 0x9d, 0xa4	/* Thandle_user_split_lock */
	.byte 0x07, 0xeb, 0x68, 0x05, 0xb0, 0x06, 0xe9, 0xa4	/* T__pfx_handle_bus_lock */
	.byte 0x07, 0x54, 0x68, 0x05, 0xb0, 0x06, 0xe9, 0xa4	/* Thandle_bus_lock */
	.byte 0x06, 0xeb, 0x5c, 0xde, 0x0e, 0xc7, 0x85	/* T__pfx_acpi_register_gsi */
	.byte 0x06, 0x54, 0x5c, 0xde, 0x0e, 0xc7, 0x85	/* Tacpi_register_gsi */
	.byte 0x08, 0xeb, 0x5c, 0x5f, 0xe4, 0xf7, 0x0e, 0xc7, 0x85	/* T__pfx_acpi_unregister_gsi */
	.byte 0x08, 0x54, 0x5c, 0x5f, 0xe4, 0xf7, 0x0e, 0xc7, 0x85	/* Tacpi_unregister_gsi */
	.byte 0x09, 0xeb, 0x5c, 0xc7, 0x85, 0xa7, 0x6f, 0x5f, 0xab, 0x71	/* T__pfx_acpi_gsi_to_irq */
	.byte 0x09, 0x54, 0x5c, 0xc7, 0x85, 0xa7, 0x6f, 0x5f, 0xab, 0x71	/* Tacpi_gsi_to_irq */
	.byte 0x08, 0xef, 0x5c, 0xde, 0x0e, 0xc7, 0x85, 0xec, 0xaa	/* t__pfx_acpi_register_gsi_pic */
	.byte 0x09, 0xf4, 0x63, 0xb2, 0xde, 0x0e, 0xc7, 0x85, 0xec, 0xaa	/* tacpi_register_gsi_pic */
	.byte 0x07, 0xeb, 0x5c, 0x5f, 0xe4, 0x97, 0xf0, 0x9c	/* T__pfx_acpi_unmap_cpu */
	.byte 0x07, 0x54, 0x5c, 0x5f, 0xe4, 0x97, 0xf0, 0x9c	/* Tacpi_unmap_cpu */
	.byte 0x09, 0xeb, 0x5c, 0xde, 0x0e, 0x5f, 0xc0, 0x61, 0xb2, 0x63	/* T__pfx_acpi_register_ioapic */
	.byte 0x09, 0x54, 0x5c, 0xde, 0x0e, 0x5f, 0xc0, 0x61, 0xb2, 0x63	/* Tacpi_register_ioapic */
	.byte 0x0b, 0xeb, 0x5c, 0x5f, 0xe4, 0xf7, 0x0e, 0x5f, 0xc0, 0x61, 0xb2, 0x63	/* T__pfx_acpi_unregister_ioapic */
	.byte 0x0b, 0x54, 0x5c, 0x5f, 0xe4, 0xf7, 0x0e, 0x5f, 0xc0, 0x61, 0xb2, 0x63	/* Tacpi_unregister_ioapic */
	.byte 0x0d, 0xef, 0x5c, 0x5f, 0xe4, 0xf7, 0x0e, 0xc7, 0x85, 0x5f, 0xc0, 0x61, 0xb2, 0x63	/* t__pfx_acpi_unregister_gsi_ioapic */
	.byte 0x0e, 0xf4, 0x63, 0xb2, 0x5f, 0xe4, 0xf7, 0x0e, 0xc7, 0x85, 0x5f, 0xc0, 0x61, 0xb2, 0x63	/* tacpi_unregister_gsi_ioapic */
	.byte 0x0b, 0xef, 0x5c, 0xde, 0x0e, 0xc7, 0x85, 0x5f, 0xc0, 0x61, 0xb2, 0x63	/* t__pfx_acpi_register_gsi_ioapic */
	.byte 0x0c, 0xf4, 0x63, 0xb2, 0xde, 0x0e, 0xc7, 0x85, 0x5f, 0xc0, 0x61, 0xb2, 0x63	/* tacpi_register_gsi_ioapic */
	.byte 0x06, 0xeb, 0x5c, 0x5f, 0x97, 0xf0, 0x9c	/* T__pfx_acpi_map_cpu */
	.byte 0x06, 0x54, 0x5c, 0x5f, 0x97, 0xf0, 0x9c	/* Tacpi_map_cpu */
	.byte 0x0c, 0xeb, 0x5c, 0x5f, 0xca, 0x61, 0x5f, 0xab, 0x71, 0xa7, 0x6f, 0xc7, 0x85	/* T__pfx_acpi_isa_irq_to_gsi */
	.byte 0x0c, 0x54, 0x5c, 0x5f, 0xca, 0x61, 0x5f, 0xab, 0x71, 0xa7, 0x6f, 0xc7, 0x85	/* Tacpi_isa_irq_to_gsi */
	.byte 0x0c, 0xeb, 0x5c, 0x5f, 0xc0, 0x61, 0xb2, 0x63, 0xde, 0x13, 0x2c, 0xf7, 0x64	/* T__pfx_acpi_ioapic_registered */
	.byte 0x0c, 0x54, 0x5c, 0x5f, 0xc0, 0x61, 0xb2, 0x63, 0xde, 0x13, 0x2c, 0xf7, 0x64	/* Tacpi_ioapic_registered */
	.byte 0x0d, 0x08, 0x5c, 0x5f, 0xf2, 0xa1, 0xab, 0xfc, 0x67, 0xdd, 0x62, 0xe5, 0x5f, 0xa4	/* T__pfx___acpi_acquire_global_lock */
	.byte 0x0d, 0xb9, 0x5c, 0x5f, 0xf2, 0xa1, 0xab, 0xfc, 0x67, 0xdd, 0x62, 0xe5, 0x5f, 0xa4	/* T__acpi_acquire_global_lock */
	.byte 0x0c, 0x08, 0x5c, 0xde, 0xc4, 0xbb, 0xfc, 0x67, 0xdd, 0x62, 0xe5, 0x5f, 0xa4	/* T__pfx___acpi_release_global_lock */
	.byte 0x0c, 0xb9, 0x5c, 0xde, 0xc4, 0xbb, 0xfc, 0x67, 0xdd, 0x62, 0xe5, 0x5f, 0xa4	/* T__acpi_release_global_lock */
	.byte 0x13, 0xeb, 0x78, 0x38, 0x36, 0xed, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x73, 0xe2, 0xe3, 0x6f, 0xfe, 0x70, 0x6f, 0xb3, 0xf5	/* T__pfx_x86_default_set_root_pointer */
	.byte 0x13, 0x54, 0x78, 0x38, 0x36, 0xed, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x73, 0xe2, 0xe3, 0x6f, 0xfe, 0x70, 0x6f, 0xb3, 0xf5	/* Tx86_default_set_root_pointer */
	.byte 0x13, 0xeb, 0x78, 0x38, 0x36, 0xed, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x67, 0xe2, 0xe3, 0x6f, 0xfe, 0x70, 0x6f, 0xb3, 0xf5	/* T__pfx_x86_default_get_root_pointer */
	.byte 0x13, 0x54, 0x78, 0x38, 0x36, 0xed, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x67, 0xe2, 0xe3, 0x6f, 0xfe, 0x70, 0x6f, 0xb3, 0xf5	/* Tx86_default_get_root_pointer */
	.byte 0x0d, 0xeb, 0x5c, 0x86, 0x77, 0x61, 0x6b, 0x65, 0xcd, 0x5f, 0xc8, 0x64, 0x29, 0x73	/* T__pfx_acpi_get_wakeup_address */
	.byte 0x0d, 0x54, 0x5c, 0x86, 0x77, 0x61, 0x6b, 0x65, 0xcd, 0x5f, 0xc8, 0x64, 0x29, 0x73	/* Tacpi_get_wakeup_address */
	.byte 0x0e, 0xeb, 0x78, 0x38, 0x36, 0x5f, 0x5c, 0x0d, 0xa2, 0xf6, 0xc4, 0x65, 0x70, 0xa9, 0x2c	/* T__pfx_x86_acpi_enter_sleep_state */
	.byte 0x0e, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x5c, 0x0d, 0xa2, 0xf6, 0xc4, 0x65, 0x70, 0xa9, 0x2c	/* Tx86_acpi_enter_sleep_state */
	.byte 0x10, 0xeb, 0x78, 0x38, 0x36, 0x5f, 0x5c, 0xf6, 0xb1, 0x70, 0xf1, 0xda, 0xdd, 0x77, 0x6c, 0xee, 0xdb	/* T__pfx_x86_acpi_suspend_lowlevel */
	.byte 0x10, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x5c, 0xf6, 0xb1, 0x70, 0xf1, 0xda, 0xdd, 0x77, 0x6c, 0xee, 0xdb	/* Tx86_acpi_suspend_lowlevel */
	.byte 0x0c, 0xeb, 0x77, 0x61, 0x6b, 0x65, 0xcd, 0x5f, 0x6c, 0xe7, 0x67, 0x36, 0x34	/* T__pfx_wakeup_long64 */
	.byte 0x0c, 0x54, 0x77, 0x61, 0x6b, 0x65, 0xcd, 0x5f, 0x6c, 0xe7, 0x67, 0x36, 0x34	/* Twakeup_long64 */
	.byte 0x0d, 0xeb, 0x64, 0x6f, 0xf6, 0xb1, 0x70, 0xf1, 0xda, 0xdd, 0x77, 0x6c, 0xee, 0xdb	/* T__pfx_do_suspend_lowlevel */
	.byte 0x0d, 0x54, 0x64, 0x6f, 0xf6, 0xb1, 0x70, 0xf1, 0xda, 0xdd, 0x77, 0x6c, 0xee, 0xdb	/* Tdo_suspend_lowlevel */
	.byte 0x0c, 0xeb, 0x2a, 0xda, 0x67, 0xe2, 0x68, 0x0c, 0x68, 0xd6, 0xfe, 0x19, 0x66	/* T__pfx_amd_get_highest_perf */
	.byte 0x0c, 0x54, 0x2a, 0xda, 0x67, 0xe2, 0x68, 0x0c, 0x68, 0xd6, 0xfe, 0x19, 0x66	/* Tamd_get_highest_perf */
	.byte 0x0c, 0xeb, 0x2a, 0x64, 0xed, 0xd4, 0xb4, 0xfe, 0x70, 0xf7, 0x66, 0x03, 0xf7	/* T__pfx_amd_detect_prefcore */
	.byte 0x0c, 0x54, 0x2a, 0x64, 0xed, 0xd4, 0xb4, 0xfe, 0x70, 0xf7, 0x66, 0x03, 0xf7	/* Tamd_detect_prefcore */
	.byte 0x13, 0xeb, 0x2a, 0xda, 0x67, 0xe2, 0x62, 0x6f, 0x6f, 0x73, 0xfe, 0x72, 0xe8, 0xc0, 0xbd, 0x75, 0x6d, 0xf5, 0xe8, 0xd5	/* T__pfx_amd_get_boost_ratio_numerator */
	.byte 0x13, 0x54, 0x2a, 0xda, 0x67, 0xe2, 0x62, 0x6f, 0x6f, 0x73, 0xfe, 0x72, 0xe8, 0xc0, 0xbd, 0x75, 0x6d, 0xf5, 0xe8, 0xd5	/* Tamd_get_boost_ratio_numerator */
	.byte 0x0e, 0xeb, 0x63, 0x70, 0x63, 0xf6, 0xcd, 0x70, 0xd5, 0x2c, 0xda, 0x62, 0x79, 0xf0, 0x9c	/* T__pfx_cpc_supported_by_cpu */
	.byte 0x0e, 0x54, 0x63, 0x70, 0x63, 0xf6, 0xcd, 0x70, 0xd5, 0x2c, 0xda, 0x62, 0x79, 0xf0, 0x9c	/* Tcpc_supported_by_cpu */
	.byte 0x0d, 0xeb, 0x63, 0x70, 0x63, 0xe6, 0x66, 0x68, 0xf6, 0xcd, 0x70, 0xd5, 0x74, 0x9e	/* T__pfx_cpc_ffh_supported */
	.byte 0x0d, 0x54, 0x63, 0x70, 0x63, 0xe6, 0x66, 0x68, 0xf6, 0xcd, 0x70, 0xd5, 0x74, 0x9e	/* Tcpc_ffh_supported */
	.byte 0x09, 0xeb, 0x63, 0x70, 0x63, 0xde, 0xc8, 0xe6, 0x66, 0x68	/* T__pfx_cpc_read_ffh */
	.byte 0x09, 0x54, 0x63, 0x70, 0x63, 0xde, 0xc8, 0xe6, 0x66, 0x68	/* Tcpc_read_ffh */
	.byte 0x0a, 0xeb, 0x63, 0x70, 0xc9, 0x77, 0x3c, 0xfc, 0x66, 0x66, 0x68	/* T__pfx_cpc_write_ffh */
	.byte 0x0a, 0x54, 0x63, 0x70, 0xc9, 0x77, 0x3c, 0xfc, 0x66, 0x66, 0x68	/* Tcpc_write_ffh */
	.byte 0x15, 0xeb, 0x5c, 0xec, 0xe3, 0x63, 0xd6, 0x73, 0xd5, 0xbf, 0x9d, 0xf8, 0x76, 0xc5, 0x69, 0xd2, 0x63, 0xfc, 0x63, 0x70, 0x70, 0x63	/* T__pfx_acpi_processor_init_invariance_cppc */
	.byte 0x15, 0x54, 0x5c, 0xec, 0xe3, 0x63, 0xd6, 0x73, 0xd5, 0xbf, 0x9d, 0xf8, 0x76, 0xc5, 0x69, 0xd2, 0x63, 0xfc, 0x63, 0x70, 0x70, 0x63	/* Tacpi_processor_init_invariance_cppc */
	.byte 0x09, 0xef, 0x5c, 0x92, 0x61, 0x6b, 0x65, 0xcd, 0xf0, 0x9c	/* t__pfx_acpi_wakeup_cpu */
	.byte 0x0a, 0xf4, 0x63, 0xb2, 0x92, 0x61, 0x6b, 0x65, 0xcd, 0xf0, 0x9c	/* tacpi_wakeup_cpu */
	.byte 0x0c, 0xef, 0x5c, 0xc1, 0x70, 0xf6, 0x74, 0xbe, 0xa7, 0x68, 0xca, 0xf0, 0x9c	/* t__pfx_acpi_mp_stop_this_cpu */
	.byte 0x0d, 0xf4, 0x63, 0xb2, 0xc1, 0x70, 0xf6, 0x74, 0xbe, 0xa7, 0x68, 0xca, 0xf0, 0x9c	/* tacpi_mp_stop_this_cpu */
	.byte 0x0b, 0xef, 0x5c, 0xc1, 0x70, 0xec, 0x6c, 0x61, 0x79, 0xed, 0x65, 0xc8	/* t__pfx_acpi_mp_play_dead */
	.byte 0x0c, 0xf4, 0x63, 0xb2, 0xc1, 0x70, 0xec, 0x6c, 0x61, 0x79, 0xed, 0x65, 0xc8	/* tacpi_mp_play_dead */
	.byte 0x09, 0xef, 0x5c, 0xc1, 0x70, 0xf0, 0x9c, 0xed, 0x69, 0x65	/* t__pfx_acpi_mp_cpu_die */
	.byte 0x0a, 0xf4, 0x63, 0xb2, 0xc1, 0x70, 0xf0, 0x9c, 0xed, 0x69, 0x65	/* tacpi_mp_cpu_die */
	.byte 0x0d, 0xeb, 0xbb, 0xae, 0x5c, 0xc1, 0x70, 0xec, 0x6c, 0x61, 0x79, 0xed, 0x65, 0xc8	/* T__pfx_asm_acpi_mp_play_dead */
	.byte 0x0d, 0x54, 0xbb, 0xae, 0x5c, 0xc1, 0x70, 0xec, 0x6c, 0x61, 0x79, 0xed, 0x65, 0xc8	/* Tasm_acpi_mp_play_dead */
	.byte 0x12, 0xeb, 0x5c, 0xec, 0xe3, 0x63, 0xd6, 0x73, 0xd5, 0xec, 0xad, 0xf5, 0xbf, 0x9d, 0x62, 0x6d, 0x25, 0x65, 0xc6	/* T__pfx_acpi_processor_power_init_bm_check */
	.byte 0x12, 0x54, 0x5c, 0xec, 0xe3, 0x63, 0xd6, 0x73, 0xd5, 0xec, 0xad, 0xf5, 0xbf, 0x9d, 0x62, 0x6d, 0x25, 0x65, 0xc6	/* Tacpi_processor_power_init_bm_check */
	.byte 0x14, 0xef, 0x5c, 0xec, 0xe3, 0x63, 0xd6, 0x73, 0xd5, 0xe6, 0x66, 0x68, 0xf0, 0x3d, 0x74, 0xfc, 0x70, 0x8c, 0xfc, 0x63, 0x9c	/* t__pfx_acpi_processor_ffh_cstate_probe_cpu */
	.byte 0x15, 0xf4, 0x63, 0xb2, 0xec, 0xe3, 0x63, 0xd6, 0x73, 0xd5, 0xe6, 0x66, 0x68, 0xf0, 0x3d, 0x74, 0xfc, 0x70, 0x8c, 0xfc, 0x63, 0x9c	/* tacpi_processor_ffh_cstate_probe_cpu */
	.byte 0x12, 0xeb, 0x5c, 0xec, 0xe3, 0x63, 0xd6, 0x73, 0xd5, 0xe6, 0x66, 0x68, 0xf0, 0x3d, 0x74, 0xfc, 0x70, 0x8c, 0x65	/* T__pfx_acpi_processor_ffh_cstate_probe */
	.byte 0x12, 0x54, 0x5c, 0xec, 0xe3, 0x63, 0xd6, 0x73, 0xd5, 0xe6, 0x66, 0x68, 0xf0, 0x3d, 0x74, 0xfc, 0x70, 0x8c, 0x65	/* Tacpi_processor_ffh_cstate_probe */
	.byte 0x0c, 0xeb, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0xf7, 0xe5, 0xde, 0x3d, 0x72, 0x74	/* T__pfx_machine_real_restart */
	.byte 0x0c, 0x54, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0xf7, 0xe5, 0xde, 0x3d, 0x72, 0x74	/* Tmachine_real_restart */
	.byte 0x0e, 0xef, 0x6e, 0xe8, 0x69, 0x1a, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0xf7, 0x3d, 0x72, 0x74	/* t__pfx_native_machine_restart */
	.byte 0x0e, 0x74, 0x6e, 0xe8, 0x69, 0x1a, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0xf7, 0x3d, 0x72, 0x74	/* tnative_machine_restart */
	.byte 0x10, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x73, 0x68, 0x20, 0x64, 0xad, 0x6e	/* T__pfx_native_machine_shutdown */
	.byte 0x10, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x73, 0x68, 0x20, 0x64, 0xad, 0x6e	/* Tnative_machine_shutdown */
	.byte 0x0d, 0xef, 0x6e, 0xe8, 0x69, 0x1a, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x68, 0xe5, 0x74	/* t__pfx_native_machine_halt */
	.byte 0x0d, 0x74, 0x6e, 0xe8, 0x69, 0x1a, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x68, 0xe5, 0x74	/* tnative_machine_halt */
	.byte 0x0d, 0xef, 0x63, 0xbc, 0x73, 0x68, 0xbd, 0x6d, 0x69, 0xf0, 0x5d, 0x62, 0xf2, 0x6b	/* t__pfx_crash_nmi_callback */
	.byte 0x0c, 0x26, 0xbc, 0x73, 0x68, 0xbd, 0x6d, 0x69, 0xf0, 0x5d, 0x62, 0xf2, 0x6b	/* tcrash_nmi_callback */
	.byte 0x11, 0xef, 0x6e, 0xe8, 0x69, 0x1a, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x70, 0xad, 0xf5, 0x5f, 0x6f, 0x66, 0x66	/* t__pfx_native_machine_power_off */
	.byte 0x11, 0x74, 0x6e, 0xe8, 0x69, 0x1a, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x70, 0xad, 0xf5, 0x5f, 0x6f, 0x66, 0x66	/* tnative_machine_power_off */
	.byte 0x0e, 0x57, 0xf9, 0x6d, 0xf2, 0x68, 0xde, 0x62, 0x6f, 0x6f, 0xfe, 0xa5, 0x78, 0xcd, 0x73	/* W__pfx_mach_reboot_fixups */
	.byte 0x0d, 0x57, 0x6d, 0xf2, 0x68, 0xde, 0x62, 0x6f, 0x6f, 0xfe, 0xa5, 0x78, 0xcd, 0x73	/* Wmach_reboot_fixups */
	.byte 0x15, 0xef, 0x6e, 0xe8, 0x69, 0x1a, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x65, 0x6d, 0xf5, 0x67, 0xf1, 0x63, 0x79, 0xde, 0x3d, 0x72, 0x74	/* t__pfx_native_machine_emergency_restart */
	.byte 0x15, 0x74, 0x6e, 0xe8, 0x69, 0x1a, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x65, 0x6d, 0xf5, 0x67, 0xf1, 0x63, 0x79, 0xde, 0x3d, 0x72, 0x74	/* tnative_machine_emergency_restart */
	.byte 0x0d, 0xeb, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x70, 0xad, 0xf5, 0x5f, 0x6f, 0x66, 0x66	/* T__pfx_machine_power_off */
	.byte 0x0d, 0x54, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x70, 0xad, 0xf5, 0x5f, 0x6f, 0x66, 0x66	/* Tmachine_power_off */
	.byte 0x0c, 0xeb, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x73, 0x68, 0x20, 0x64, 0xad, 0x6e	/* T__pfx_machine_shutdown */
	.byte 0x0c, 0x54, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x73, 0x68, 0x20, 0x64, 0xad, 0x6e	/* Tmachine_shutdown */
	.byte 0x11, 0xeb, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x65, 0x6d, 0xf5, 0x67, 0xf1, 0x63, 0x79, 0xde, 0x3d, 0x72, 0x74	/* T__pfx_machine_emergency_restart */
	.byte 0x11, 0x54, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x65, 0x6d, 0xf5, 0x67, 0xf1, 0x63, 0x79, 0xde, 0x3d, 0x72, 0x74	/* Tmachine_emergency_restart */
	.byte 0x0a, 0xeb, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0xf7, 0x3d, 0x72, 0x74	/* T__pfx_machine_restart */
	.byte 0x0a, 0x54, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0xf7, 0x3d, 0x72, 0x74	/* Tmachine_restart */
	.byte 0x09, 0xeb, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x68, 0xe5, 0x74	/* T__pfx_machine_halt */
	.byte 0x09, 0x54, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x68, 0xe5, 0x74	/* Tmachine_halt */
	.byte 0x10, 0xeb, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x63, 0xbc, 0x73, 0x68, 0xf6, 0x68, 0x20, 0x64, 0xad, 0x6e	/* T__pfx_machine_crash_shutdown */
	.byte 0x10, 0x54, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x63, 0xbc, 0x73, 0x68, 0xf6, 0x68, 0x20, 0x64, 0xad, 0x6e	/* Tmachine_crash_shutdown */
	.byte 0x0f, 0xeb, 0x6e, 0x6d, 0x69, 0xf6, 0x68, 0x6f, 0x6f, 0x74, 0x64, 0xad, 0x6e, 0xf0, 0x70, 0xb1	/* T__pfx_nmi_shootdown_cpus */
	.byte 0x0f, 0x54, 0x6e, 0x6d, 0x69, 0xf6, 0x68, 0x6f, 0x6f, 0x74, 0x64, 0xad, 0x6e, 0xf0, 0x70, 0xb1	/* Tnmi_shootdown_cpus */
	.byte 0x0f, 0xeb, 0x72, 0xe4, 0xf0, 0xbc, 0x73, 0x68, 0x5f, 0x69, 0xb2, 0xf0, 0x5d, 0x62, 0xf2, 0x6b	/* T__pfx_run_crash_ipi_callback */
	.byte 0x0f, 0x54, 0x72, 0xe4, 0xf0, 0xbc, 0x73, 0x68, 0x5f, 0x69, 0xb2, 0xf0, 0x5d, 0x62, 0xf2, 0x6b	/* Trun_crash_ipi_callback */
	.byte 0x0d, 0xeb, 0x6e, 0x6d, 0x69, 0xec, 0xd2, 0xaa, 0xf6, 0xdb, 0x66, 0xf6, 0x74, 0xbe	/* T__pfx_nmi_panic_self_stop */
	.byte 0x0d, 0x54, 0x6e, 0x6d, 0x69, 0xec, 0xd2, 0xaa, 0xf6, 0xdb, 0x66, 0xf6, 0x74, 0xbe	/* Tnmi_panic_self_stop */
	.byte 0x0c, 0xef, 0x6d, 0x73, 0x72, 0x2b, 0xaa, 0xfc, 0x64, 0xd6, 0xf3, 0x6f, 0x79	/* t__pfx_msr_device_destroy */
	.byte 0x0c, 0x74, 0x6d, 0x73, 0x72, 0x2b, 0xaa, 0xfc, 0x64, 0xd6, 0xf3, 0x6f, 0x79	/* tmsr_device_destroy */
	.byte 0x0a, 0xef, 0x6d, 0x73, 0x72, 0x2b, 0xaa, 0xfc, 0x63, 0xf7, 0x14	/* t__pfx_msr_device_create */
	.byte 0x0a, 0x74, 0x6d, 0x73, 0x72, 0x2b, 0xaa, 0xfc, 0x63, 0xf7, 0x14	/* tmsr_device_create */
	.byte 0x08, 0xef, 0x6d, 0x73, 0x72, 0x2b, 0x6e, 0xb7, 0x65	/* t__pfx_msr_devnode */
	.byte 0x08, 0x74, 0x6d, 0x73, 0x72, 0x2b, 0x6e, 0xb7, 0x65	/* tmsr_devnode */
	.byte 0x07, 0xef, 0x6d, 0x73, 0x72, 0x5f, 0xbe, 0xf1	/* t__pfx_msr_open */
	.byte 0x07, 0x74, 0x6d, 0x73, 0x72, 0x5f, 0xbe, 0xf1	/* tmsr_open */
	.byte 0x07, 0xef, 0xa5, 0x6c, 0xa2, 0x92, 0x3c, 0x65	/* t__pfx_filter_write */
	.byte 0x07, 0x74, 0xa5, 0x6c, 0xa2, 0x92, 0x3c, 0x65	/* tfilter_write */
	.byte 0x08, 0xef, 0x6d, 0x73, 0x72, 0x5f, 0xc0, 0x63, 0x23	/* t__pfx_msr_ioctl */
	.byte 0x08, 0x74, 0x6d, 0x73, 0x72, 0x5f, 0xc0, 0x63, 0x23	/* tmsr_ioctl */
	.byte 0x07, 0xef, 0x6d, 0x73, 0x72, 0x92, 0x3c, 0x65	/* t__pfx_msr_write */
	.byte 0x07, 0x74, 0x6d, 0x73, 0x72, 0x92, 0x3c, 0x65	/* tmsr_write */
	.byte 0x06, 0xef, 0x6d, 0x73, 0x72, 0xde, 0xc8	/* t__pfx_msr_read */
	.byte 0x06, 0x74, 0x6d, 0x73, 0x72, 0xde, 0xc8	/* tmsr_read */
	.byte 0x08, 0xef, 0x67, 0xe2, 0x22, 0x77, 0x92, 0x3c, 0xd6	/* t__pfx_get_allow_writes */
	.byte 0x08, 0x74, 0x67, 0xe2, 0x22, 0x77, 0x92, 0x3c, 0xd6	/* tget_allow_writes */
	.byte 0x08, 0xef, 0x73, 0xe2, 0x22, 0x77, 0x92, 0x3c, 0xd6	/* t__pfx_set_allow_writes */
	.byte 0x07, 0x93, 0xe2, 0x22, 0x77, 0x92, 0x3c, 0xd6	/* tset_allow_writes */
	.byte 0x0c, 0xef, 0x63, 0x9c, 0x9f, 0x2b, 0xaa, 0xfc, 0x64, 0xd6, 0xf3, 0x6f, 0x79	/* t__pfx_cpuid_device_destroy */
	.byte 0x0b, 0x26, 0x9c, 0x9f, 0x2b, 0xaa, 0xfc, 0x64, 0xd6, 0xf3, 0x6f, 0x79	/* tcpuid_device_destroy */
	.byte 0x0a, 0xef, 0x63, 0x9c, 0x9f, 0x2b, 0xaa, 0xfc, 0x63, 0xf7, 0x14	/* t__pfx_cpuid_device_create */
	.byte 0x09, 0x26, 0x9c, 0x9f, 0x2b, 0xaa, 0xfc, 0x63, 0xf7, 0x14	/* tcpuid_device_create */
	.byte 0x08, 0xef, 0x63, 0x9c, 0x9f, 0x2b, 0x6e, 0xb7, 0x65	/* t__pfx_cpuid_devnode */
	.byte 0x07, 0x26, 0x9c, 0x9f, 0x2b, 0x6e, 0xb7, 0x65	/* tcpuid_devnode */
	.byte 0x07, 0xef, 0x63, 0x9c, 0x69, 0xda, 0xbe, 0xf1	/* t__pfx_cpuid_open */
	.byte 0x06, 0x26, 0x9c, 0x69, 0xda, 0xbe, 0xf1	/* tcpuid_open */
	.byte 0x09, 0xef, 0x63, 0x9c, 0x9f, 0xf6, 0xb6, 0xf0, 0x9c, 0x9f	/* t__pfx_cpuid_smp_cpuid */
	.byte 0x08, 0x26, 0x9c, 0x9f, 0xf6, 0xb6, 0xf0, 0x9c, 0x9f	/* tcpuid_smp_cpuid */
	.byte 0x06, 0xef, 0x63, 0x9c, 0x9f, 0xde, 0xc8	/* t__pfx_cpuid_read */
	.byte 0x05, 0x26, 0x9c, 0x9f, 0xde, 0xc8	/* tcpuid_read */
	.byte 0x0e, 0xef, 0x73, 0xb6, 0xf6, 0x74, 0xbe, 0xbd, 0x6d, 0x69, 0xf0, 0x5d, 0x62, 0xf2, 0x6b	/* t__pfx_smp_stop_nmi_callback */
	.byte 0x0d, 0x93, 0xb6, 0xf6, 0x74, 0xbe, 0xbd, 0x6d, 0x69, 0xf0, 0x5d, 0x62, 0xf2, 0x6b	/* tsmp_stop_nmi_callback */
	.byte 0x0b, 0x74, 0xaf, 0x7f, 0x73, 0x76, 0xb4, 0xde, 0x62, 0x6f, 0x6f, 0x74	/* t__pfx___sysvec_reboot */
	.byte 0x0b, 0x74, 0xff, 0xe1, 0x73, 0x76, 0xb4, 0xde, 0x62, 0x6f, 0x6f, 0x74	/* t__sysvec_reboot */
	.byte 0x10, 0xef, 0x6e, 0xe8, 0x69, 0x1a, 0x73, 0x74, 0xbe, 0x5f, 0x6f, 0x74, 0x68, 0xf5, 0xf0, 0x70, 0xb1	/* t__pfx_native_stop_other_cpus */
	.byte 0x10, 0x74, 0x6e, 0xe8, 0x69, 0x1a, 0x73, 0x74, 0xbe, 0x5f, 0x6f, 0x74, 0x68, 0xf5, 0xf0, 0x70, 0xb1	/* tnative_stop_other_cpus */
	.byte 0x0f, 0x74, 0xaf, 0x7f, 0x73, 0x76, 0xb4, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7, 0xf6, 0x8d, 0xc4	/* t__pfx___sysvec_call_function_single */
	.byte 0x0f, 0x74, 0xff, 0xe1, 0x73, 0x76, 0xb4, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7, 0xf6, 0x8d, 0xc4	/* t__sysvec_call_function_single */
	.byte 0x0c, 0x74, 0xaf, 0x7f, 0x73, 0x76, 0xb4, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7	/* t__pfx___sysvec_call_function */
	.byte 0x0c, 0x74, 0xff, 0xe1, 0x73, 0x76, 0xb4, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7	/* t__sysvec_call_function */
	.byte 0x0d, 0xeb, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0xb4, 0xde, 0x62, 0x6f, 0x6f, 0x74	/* T__pfx_fred_sysvec_reboot */
	.byte 0x0d, 0x54, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0xb4, 0xde, 0x62, 0x6f, 0x6f, 0x74	/* Tfred_sysvec_reboot */
	.byte 0x0f, 0xeb, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0xb4, 0x07, 0xba, 0x9e, 0x75, 0xb0, 0x69, 0xb2	/* T__pfx_fred_sysvec_reschedule_ipi */
	.byte 0x0f, 0x54, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0xb4, 0x07, 0xba, 0x9e, 0x75, 0xb0, 0x69, 0xb2	/* Tfred_sysvec_reschedule_ipi */
	.byte 0x0e, 0xeb, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0xb4, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7	/* T__pfx_fred_sysvec_call_function */
	.byte 0x0e, 0x54, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0xb4, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7	/* Tfred_sysvec_call_function */
	.byte 0x11, 0xeb, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0xb4, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7, 0xf6, 0x8d, 0xc4	/* T__pfx_fred_sysvec_call_function_single */
	.byte 0x11, 0x54, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0xb4, 0xf0, 0x5d, 0xe6, 0x96, 0xdc, 0xe7, 0xf6, 0x8d, 0xc4	/* Tfred_sysvec_call_function_single */
	.byte 0x08, 0xef, 0x63, 0x9c, 0xf6, 0x6d, 0xfe, 0xd9, 0x5e	/* t__pfx_cpu_smt_mask */
	.byte 0x07, 0x26, 0x9c, 0xf6, 0x6d, 0xfe, 0xd9, 0x5e	/* tcpu_smt_mask */
	.byte 0x08, 0xef, 0x63, 0x9c, 0xf0, 0x9c, 0x5f, 0xd9, 0x5e	/* t__pfx_cpu_cpu_mask */
	.byte 0x07, 0x26, 0x9c, 0xf0, 0x9c, 0x5f, 0xd9, 0x5e	/* tcpu_cpu_mask */
	.byte 0x0b, 0xef, 0x78, 0x38, 0x36, 0xf0, 0xd5, 0xfc, 0x66, 0x6c, 0x83, 0x73	/* t__pfx_x86_core_flags */
	.byte 0x0b, 0x74, 0x78, 0x38, 0x36, 0xf0, 0xd5, 0xfc, 0x66, 0x6c, 0x83, 0x73	/* tx86_core_flags */
	.byte 0x0b, 0xef, 0x78, 0x38, 0x36, 0xf6, 0x6d, 0xfe, 0x66, 0x6c, 0x83, 0x73	/* t__pfx_x86_smt_flags */
	.byte 0x0b, 0x74, 0x78, 0x38, 0x36, 0xf6, 0x6d, 0xfe, 0x66, 0x6c, 0x83, 0x73	/* tx86_smt_flags */
	.byte 0x0c, 0xef, 0x78, 0x38, 0x36, 0xf0, 0x6c, 0xb1, 0xa2, 0xe6, 0x6c, 0x83, 0x73	/* t__pfx_x86_cluster_flags */
	.byte 0x0c, 0x74, 0x78, 0x38, 0x36, 0xf0, 0x6c, 0xb1, 0xa2, 0xe6, 0x6c, 0x83, 0x73	/* tx86_cluster_flags */
	.byte 0x0b, 0xef, 0x78, 0x38, 0x36, 0xed, 0x69, 0xfc, 0x66, 0x6c, 0x83, 0x73	/* t__pfx_x86_die_flags */
	.byte 0x0b, 0x74, 0x78, 0x38, 0x36, 0xed, 0x69, 0xfc, 0x66, 0x6c, 0x83, 0x73	/* tx86_die_flags */
	.byte 0x0b, 0xeb, 0x63, 0x9c, 0x3a, 0xf7, 0x67, 0xe3, 0xcd, 0x5f, 0xd9, 0x5e	/* T__pfx_cpu_coregroup_mask */
	.byte 0x0b, 0x54, 0x63, 0x9c, 0x3a, 0xf7, 0x67, 0xe3, 0xcd, 0x5f, 0xd9, 0x5e	/* Tcpu_coregroup_mask */
	.byte 0x0d, 0xeb, 0x63, 0x9c, 0xf0, 0x6c, 0xb1, 0xa2, 0x67, 0xe3, 0xcd, 0x5f, 0xd9, 0x5e	/* T__pfx_cpu_clustergroup_mask */
	.byte 0x0d, 0x54, 0x63, 0x9c, 0xf0, 0x6c, 0xb1, 0xa2, 0x67, 0xe3, 0xcd, 0x5f, 0xd9, 0x5e	/* Tcpu_clustergroup_mask */
	.byte 0x0b, 0xef, 0xf7, 0x17, 0x1a, 0x85, 0x62, 0x6c, 0x8d, 0xf8, 0x66, 0x6f	/* t__pfx_remove_siblinginfo */
	.byte 0x0b, 0x74, 0xf7, 0x17, 0x1a, 0x85, 0x62, 0x6c, 0x8d, 0xf8, 0x66, 0x6f	/* tremove_siblinginfo */
	.byte 0x0e, 0xef, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0xf6, 0xd2, 0x65, 0x2e, 0xca, 0xbc, 0x7e	/* t__pfx_topology_sane.isra.0 */
	.byte 0x0e, 0x74, 0x74, 0xbe, 0x6f, 0xdd, 0x67, 0x79, 0xf6, 0xd2, 0x65, 0x2e, 0xca, 0xbc, 0x7e	/* ttopology_sane.isra.0 */
	.byte 0x07, 0xef, 0x6d, 0xe8, 0xba, 0xf6, 0x6d, 0x74	/* t__pfx_match_smt */
	.byte 0x07, 0x74, 0x6d, 0xe8, 0xba, 0xf6, 0x6d, 0x74	/* tmatch_smt */
	.byte 0x0b, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0x6b, 0x69, 0xc6, 0x5f, 0x61, 0x70	/* T__pfx_native_kick_ap */
	.byte 0x0b, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0x6b, 0x69, 0xc6, 0x5f, 0x61, 0x70	/* Tnative_kick_ap */
	.byte 0x0f, 0xeb, 0xc5, 0xba, 0x5f, 0xcd, 0x64, 0x91, 0x63, 0x9c, 0xa7, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* T__pfx_arch_update_cpu_topology */
	.byte 0x0f, 0x54, 0xc5, 0xba, 0x5f, 0xcd, 0x64, 0x91, 0x63, 0x9c, 0xa7, 0xbe, 0x6f, 0xdd, 0x67, 0x79	/* Tarch_update_cpu_topology */
	.byte 0x0c, 0xeb, 0x73, 0xb6, 0xf6, 0x74, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0x66, 0x6f	/* T__pfx_smp_store_cpu_info */
	.byte 0x0c, 0x54, 0x73, 0xb6, 0xf6, 0x74, 0xd5, 0xfc, 0x63, 0x9c, 0xbf, 0x66, 0x6f	/* Tsmp_store_cpu_info */
	.byte 0x0c, 0xeb, 0x73, 0xe2, 0x63, 0x9c, 0xf6, 0x69, 0x62, 0x6c, 0x8d, 0x5f, 0x97	/* T__pfx_set_cpu_sibling_map */
	.byte 0x0c, 0x54, 0x73, 0xe2, 0x63, 0x9c, 0xf6, 0x69, 0x62, 0x6c, 0x8d, 0x5f, 0x97	/* Tset_cpu_sibling_map */
	.byte 0x0a, 0xef, 0x3d, 0x72, 0xfe, 0x73, 0xb4, 0xe7, 0x64, 0xc5, 0x79	/* t__pfx_start_secondary */
	.byte 0x0a, 0x93, 0xf4, 0x72, 0xfe, 0x73, 0xb4, 0xe7, 0x64, 0xc5, 0x79	/* tstart_secondary */
	.byte 0x09, 0xeb, 0x03, 0x6d, 0x6d, 0xe7, 0xf0, 0x9c, 0x5f, 0xcd	/* T__pfx_common_cpu_up */
	.byte 0x09, 0x54, 0x03, 0x6d, 0x6d, 0xe7, 0xf0, 0x9c, 0x5f, 0xcd	/* Tcommon_cpu_up */
	.byte 0x13, 0xeb, 0xc5, 0xba, 0xf0, 0x9c, 0x68, 0x70, 0x5f, 0x6b, 0x69, 0xc6, 0x5f, 0x61, 0x70, 0x5f, 0xe5, 0x69, 0x76, 0x65	/* T__pfx_arch_cpuhp_kick_ap_alive */
	.byte 0x13, 0x54, 0xc5, 0xba, 0xf0, 0x9c, 0x68, 0x70, 0x5f, 0x6b, 0x69, 0xc6, 0x5f, 0x61, 0x70, 0x5f, 0xe5, 0x69, 0x76, 0x65	/* Tarch_cpuhp_kick_ap_alive */
	.byte 0x11, 0xeb, 0xc5, 0xba, 0xf0, 0x9c, 0x68, 0x70, 0xf0, 0xc4, 0xd2, 0xcd, 0x5f, 0x6b, 0x69, 0xc6, 0xf0, 0x9c	/* T__pfx_arch_cpuhp_cleanup_kick_cpu */
	.byte 0x11, 0x54, 0xc5, 0xba, 0xf0, 0x9c, 0x68, 0x70, 0xf0, 0xc4, 0xd2, 0xcd, 0x5f, 0x6b, 0x69, 0xc6, 0xf0, 0x9c	/* Tarch_cpuhp_cleanup_kick_cpu */
	.byte 0x10, 0xeb, 0xc5, 0xba, 0xf0, 0x9c, 0x68, 0x70, 0xf0, 0xc4, 0xd2, 0xcd, 0xed, 0x65, 0xc8, 0xf0, 0x9c	/* T__pfx_arch_cpuhp_cleanup_dead_cpu */
	.byte 0x10, 0x54, 0xc5, 0xba, 0xf0, 0x9c, 0x68, 0x70, 0xf0, 0xc4, 0xd2, 0xcd, 0xed, 0x65, 0xc8, 0xf0, 0x9c	/* Tarch_cpuhp_cleanup_dead_cpu */
	.byte 0x10, 0xeb, 0xc5, 0xba, 0xf0, 0x9c, 0x68, 0x70, 0x7f, 0x6e, 0x63, 0xa9, 0x74, 0xfc, 0x70, 0xa0, 0x6c	/* T__pfx_arch_cpuhp_sync_state_poll */
	.byte 0x10, 0x54, 0xc5, 0xba, 0xf0, 0x9c, 0x68, 0x70, 0x7f, 0x6e, 0x63, 0xa9, 0x74, 0xfc, 0x70, 0xa0, 0x6c	/* Tarch_cpuhp_sync_state_poll */
	.byte 0x14, 0xeb, 0xc5, 0xba, 0xa7, 0x68, 0x61, 0x77, 0xf6, 0xb4, 0xe7, 0x64, 0xc5, 0x79, 0xf0, 0x9c, 0xe9, 0x62, 0x65, 0x67, 0xf8	/* T__pfx_arch_thaw_secondary_cpus_begin */
	.byte 0x14, 0x54, 0xc5, 0xba, 0xa7, 0x68, 0x61, 0x77, 0xf6, 0xb4, 0xe7, 0x64, 0xc5, 0x79, 0xf0, 0x9c, 0xe9, 0x62, 0x65, 0x67, 0xf8	/* Tarch_thaw_secondary_cpus_begin */
	.byte 0x12, 0xeb, 0xc5, 0xba, 0xa7, 0x68, 0x61, 0x77, 0xf6, 0xb4, 0xe7, 0x64, 0xc5, 0x79, 0xf0, 0x9c, 0xe9, 0xf1, 0x64	/* T__pfx_arch_thaw_secondary_cpus_end */
	.byte 0x12, 0x54, 0xc5, 0xba, 0xa7, 0x68, 0x61, 0x77, 0xf6, 0xb4, 0xe7, 0x64, 0xc5, 0x79, 0xf0, 0x9c, 0xe9, 0xf1, 0x64	/* Tarch_thaw_secondary_cpus_end */
	.byte 0x0b, 0xeb, 0x63, 0x9c, 0xed, 0xca, 0x90, 0xb0, 0x03, 0x6d, 0x6d, 0xe7	/* T__pfx_cpu_disable_common */
	.byte 0x0b, 0x54, 0x63, 0x9c, 0xed, 0xca, 0x90, 0xb0, 0x03, 0x6d, 0x6d, 0xe7	/* Tcpu_disable_common */
	.byte 0x0b, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0x63, 0x9c, 0xed, 0xca, 0x90, 0xc4	/* T__pfx_native_cpu_disable */
	.byte 0x0b, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0x63, 0x9c, 0xed, 0xca, 0x90, 0xc4	/* Tnative_cpu_disable */
	.byte 0x0c, 0xeb, 0x70, 0x6c, 0x61, 0x79, 0xed, 0x65, 0xc8, 0x3a, 0x6d, 0x6d, 0xe7	/* T__pfx_play_dead_common */
	.byte 0x0c, 0x54, 0x70, 0x6c, 0x61, 0x79, 0xed, 0x65, 0xc8, 0x3a, 0x6d, 0x6d, 0xe7	/* Tplay_dead_common */
	.byte 0x12, 0xeb, 0x73, 0xb6, 0x5f, 0x6b, 0x69, 0xc6, 0xc1, 0x77, 0x61, 0x9d, 0x70, 0x6c, 0x61, 0x79, 0xed, 0x65, 0xc8	/* T__pfx_smp_kick_mwait_play_dead */
	.byte 0x12, 0x54, 0x73, 0xb6, 0x5f, 0x6b, 0x69, 0xc6, 0xc1, 0x77, 0x61, 0x9d, 0x70, 0x6c, 0x61, 0x79, 0xed, 0x65, 0xc8	/* Tsmp_kick_mwait_play_dead */
	.byte 0x0b, 0xeb, 0x68, 0x6c, 0xfe, 0x70, 0x6c, 0x61, 0x79, 0xed, 0x65, 0xc8	/* T__pfx_hlt_play_dead */
	.byte 0x0b, 0x54, 0x68, 0x6c, 0xfe, 0x70, 0x6c, 0x61, 0x79, 0xed, 0x65, 0xc8	/* Thlt_play_dead */
	.byte 0x0c, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0x70, 0x6c, 0x61, 0x79, 0xed, 0x65, 0xc8	/* T__pfx_native_play_dead */
	.byte 0x0c, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0x70, 0x6c, 0x61, 0x79, 0xed, 0x65, 0xc8	/* Tnative_play_dead */
	.byte 0x08, 0xef, 0xdd, 0xbe, 0x5f, 0xdc, 0xa8, 0x6f, 0x20	/* t__pfx_loop_timeout */
	.byte 0x08, 0x74, 0xdd, 0xbe, 0x5f, 0xdc, 0xa8, 0x6f, 0x20	/* tloop_timeout */
	.byte 0x10, 0xef, 0x93, 0x63, 0x7f, 0x6e, 0xc9, 0xd9, 0x72, 0x6b, 0xa7, 0x73, 0xc9, 0xe4, 0x73, 0xe0, 0xc4	/* t__pfx_tsc_sync_mark_tsc_unstable */
	.byte 0x10, 0x74, 0x93, 0x63, 0x7f, 0x6e, 0xc9, 0xd9, 0x72, 0x6b, 0xa7, 0x73, 0xc9, 0xe4, 0x73, 0xe0, 0xc4	/* ttsc_sync_mark_tsc_unstable */
	.byte 0x0a, 0xef, 0xba, 0x65, 0xc6, 0xa7, 0x73, 0xc9, 0x77, 0xc5, 0x70	/* t__pfx_check_tsc_warp */
	.byte 0x0a, 0x74, 0xba, 0x65, 0xc6, 0xa7, 0x73, 0xc9, 0x77, 0xc5, 0x70	/* tcheck_tsc_warp */
	.byte 0x0f, 0xef, 0xba, 0x65, 0xc6, 0xa7, 0x73, 0x63, 0x7f, 0x6e, 0x63, 0xf6, 0x6f, 0x98, 0x63, 0x65	/* t__pfx_check_tsc_sync_source */
	.byte 0x0f, 0x74, 0xba, 0x65, 0xc6, 0xa7, 0x73, 0x63, 0x7f, 0x6e, 0x63, 0xf6, 0x6f, 0x98, 0x63, 0x65	/* tcheck_tsc_sync_source */
	.byte 0x0e, 0xeb, 0xd9, 0x72, 0x6b, 0xa7, 0x73, 0xc9, 0x61, 0xe1, 0x6e, 0x63, 0x07, 0xd4, 0x73	/* T__pfx_mark_tsc_async_resets */
	.byte 0x0e, 0x54, 0xd9, 0x72, 0x6b, 0xa7, 0x73, 0xc9, 0x61, 0xe1, 0x6e, 0x63, 0x07, 0xd4, 0x73	/* Tmark_tsc_async_resets */
	.byte 0x0e, 0xeb, 0x93, 0xc9, 0x0b, 0x69, 0x66, 0x79, 0xa7, 0x73, 0xc9, 0xc8, 0x6a, 0xb1, 0x74	/* T__pfx_tsc_verify_tsc_adjust */
	.byte 0x0e, 0x54, 0x93, 0xc9, 0x0b, 0x69, 0x66, 0x79, 0xa7, 0x73, 0xc9, 0xc8, 0x6a, 0xb1, 0x74	/* Ttsc_verify_tsc_adjust */
	.byte 0x0e, 0xef, 0x93, 0x63, 0x7f, 0x6e, 0x63, 0x25, 0x65, 0xc6, 0x5f, 0x00, 0xf5, 0xe6, 0x6e	/* t__pfx_tsc_sync_check_timer_fn */
	.byte 0x0e, 0x74, 0x93, 0x63, 0x7f, 0x6e, 0x63, 0x25, 0x65, 0xc6, 0x5f, 0x00, 0xf5, 0xe6, 0x6e	/* ttsc_sync_check_timer_fn */
	.byte 0x12, 0xeb, 0x93, 0x63, 0xf6, 0x74, 0xd5, 0xfc, 0x05, 0x25, 0x65, 0xc6, 0xa7, 0x73, 0xc9, 0xc8, 0x6a, 0xb1, 0x74	/* T__pfx_tsc_store_and_check_tsc_adjust */
	.byte 0x12, 0x54, 0x93, 0x63, 0xf6, 0x74, 0xd5, 0xfc, 0x05, 0x25, 0x65, 0xc6, 0xa7, 0x73, 0xc9, 0xc8, 0x6a, 0xb1, 0x74	/* Ttsc_store_and_check_tsc_adjust */
	.byte 0x0e, 0xeb, 0xba, 0x65, 0xc6, 0xa7, 0x73, 0x63, 0x7f, 0x6e, 0xc9, 0xf4, 0x72, 0x67, 0xd4	/* T__pfx_check_tsc_sync_target */
	.byte 0x0e, 0x54, 0xba, 0x65, 0xc6, 0xa7, 0x73, 0x63, 0x7f, 0x6e, 0xc9, 0xf4, 0x72, 0x67, 0xd4	/* Tcheck_tsc_sync_target */
	.byte 0x0e, 0xeb, 0x78, 0x38, 0x36, 0xc1, 0x85, 0xc1, 0x73, 0x67, 0x86, 0x64, 0xd6, 0xdc, 0x64	/* T__pfx_x86_msi_msg_get_destid */
	.byte 0x0e, 0x54, 0x78, 0x38, 0x36, 0xc1, 0x85, 0xc1, 0x73, 0x67, 0x86, 0x64, 0xd6, 0xdc, 0x64	/* Tx86_msi_msg_get_destid */
	.byte 0x0a, 0xef, 0x6c, 0x61, 0xb2, 0xc9, 0x6e, 0xcb, 0xfe, 0xd7, 0x74	/* t__pfx_lapic_next_event */
	.byte 0x09, 0x23, 0x61, 0xb2, 0xc9, 0x6e, 0xcb, 0xfe, 0xd7, 0x74	/* tlapic_next_event */
	.byte 0x0f, 0xeb, 0x73, 0xd4, 0xcd, 0x5f, 0x41, 0x50, 0x49, 0x43, 0x5f, 0x65, 0x69, 0x6c, 0x76, 0x74	/* T__pfx_setup_APIC_eilvt */
	.byte 0x0f, 0x54, 0x73, 0xd4, 0xcd, 0x5f, 0x41, 0x50, 0x49, 0x43, 0x5f, 0x65, 0x69, 0x6c, 0x76, 0x74	/* Tsetup_APIC_eilvt */
	.byte 0x0b, 0xef, 0x6c, 0x61, 0xb2, 0x63, 0xf6, 0xd4, 0xcd, 0x5f, 0xd6, 0x72	/* t__pfx_lapic_setup_esr */
	.byte 0x0a, 0x23, 0x61, 0xb2, 0x63, 0xf6, 0xd4, 0xcd, 0x5f, 0xd6, 0x72	/* tlapic_setup_esr */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x6c, 0x61, 0xb2, 0xc9, 0xcd, 0x64, 0x91, 0x93, 0x63, 0xe6, 0xf7, 0x71	/* t__pfx___lapic_update_tsc_freq */
	.byte 0x0e, 0x74, 0xff, 0x6c, 0x61, 0xb2, 0xc9, 0xcd, 0x64, 0x91, 0x93, 0x63, 0xe6, 0xf7, 0x71	/* t__lapic_update_tsc_freq */
	.byte 0x0d, 0xef, 0x6c, 0x61, 0xb2, 0xc9, 0x00, 0xf5, 0xb8, 0xe3, 0xc8, 0x63, 0xbb, 0x74	/* t__pfx_lapic_timer_broadcast */
	.byte 0x0c, 0x23, 0x61, 0xb2, 0xc9, 0x00, 0xf5, 0xb8, 0xe3, 0xc8, 0x63, 0xbb, 0x74	/* tlapic_timer_broadcast */
	.byte 0x0c, 0xef, 0x73, 0xd4, 0xcd, 0x5f, 0x41, 0x50, 0x49, 0x43, 0x5f, 0x00, 0xf5	/* t__pfx_setup_APIC_timer */
	.byte 0x0b, 0x93, 0xd4, 0xcd, 0x5f, 0x41, 0x50, 0x49, 0x43, 0x5f, 0x00, 0xf5	/* tsetup_APIC_timer */
	.byte 0x0d, 0xef, 0x73, 0xd4, 0xcd, 0x5f, 0xdd, 0x63, 0xe5, 0x5f, 0x41, 0x50, 0x49, 0x43	/* t__pfx_setup_local_APIC */
	.byte 0x0c, 0x93, 0xd4, 0xcd, 0x5f, 0xdd, 0x63, 0xe5, 0x5f, 0x41, 0x50, 0x49, 0x43	/* tsetup_local_APIC */
	.byte 0x12, 0xef, 0x63, 0xc4, 0xc5, 0x5f, 0xdd, 0x63, 0xe5, 0x5f, 0x41, 0x50, 0x49, 0x43, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__pfx_clear_local_APIC.part.0 */
	.byte 0x11, 0x26, 0xc4, 0xc5, 0x5f, 0xdd, 0x63, 0xe5, 0x5f, 0x41, 0x50, 0x49, 0x43, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* tclear_local_APIC.part.0 */
	.byte 0x08, 0xef, 0x6c, 0x61, 0xb2, 0x63, 0x07, 0x75, 0xa8	/* t__pfx_lapic_resume */
	.byte 0x07, 0x23, 0x61, 0xb2, 0x63, 0x07, 0x75, 0xa8	/* tlapic_resume */
	.byte 0x06, 0xef, 0x73, 0xe2, 0x6d, 0x02, 0xdc	/* t__pfx_set_multi */
	.byte 0x05, 0x93, 0xe2, 0x6d, 0x02, 0xdc	/* tset_multi */
	.byte 0x0d, 0xef, 0x6c, 0x61, 0xb2, 0xc9, 0x00, 0xf5, 0x84, 0xe7, 0xd6, 0x68, 0x6f, 0x74	/* t__pfx_lapic_timer_set_oneshot */
	.byte 0x0c, 0x23, 0x61, 0xb2, 0xc9, 0x00, 0xf5, 0x84, 0xe7, 0xd6, 0x68, 0x6f, 0x74	/* tlapic_timer_set_oneshot */
	.byte 0x0c, 0xef, 0x6c, 0x61, 0xb2, 0xc9, 0x00, 0xf5, 0x84, 0x19, 0xc0, 0x64, 0xaa	/* t__pfx_lapic_timer_set_periodic */
	.byte 0x0b, 0x23, 0x61, 0xb2, 0xc9, 0x00, 0xf5, 0x84, 0x19, 0xc0, 0x64, 0xaa	/* tlapic_timer_set_periodic */
	.byte 0x0d, 0xef, 0x6c, 0x61, 0xb2, 0xc9, 0x6e, 0xcb, 0xfe, 0x64, 0x65, 0xc8, 0x2d, 0x65	/* t__pfx_lapic_next_deadline */
	.byte 0x0c, 0x23, 0x61, 0xb2, 0xc9, 0x6e, 0xcb, 0xfe, 0x64, 0x65, 0xc8, 0x2d, 0x65	/* tlapic_next_deadline */
	.byte 0x0d, 0xef, 0x6c, 0x61, 0xb2, 0xc9, 0x00, 0xf5, 0xf6, 0x68, 0x20, 0x64, 0xad, 0x6e	/* t__pfx_lapic_timer_shutdown */
	.byte 0x0c, 0x23, 0x61, 0xb2, 0xc9, 0x00, 0xf5, 0xf6, 0x68, 0x20, 0x64, 0xad, 0x6e	/* tlapic_timer_shutdown */
	.byte 0x0a, 0xef, 0x6c, 0x61, 0xb2, 0x63, 0xf6, 0xb1, 0x70, 0xf1, 0x64	/* t__pfx_lapic_suspend */
	.byte 0x09, 0x23, 0x61, 0xb2, 0x63, 0xf6, 0xb1, 0x70, 0xf1, 0x64	/* tlapic_suspend */
	.byte 0x11, 0x74, 0xaf, 0x7f, 0x73, 0x76, 0x65, 0xc9, 0x61, 0xb2, 0xc9, 0x00, 0xf5, 0xbf, 0xa2, 0x72, 0xcd, 0x74	/* t__pfx___sysvec_apic_timer_interrupt */
	.byte 0x11, 0x74, 0xff, 0xe1, 0x73, 0x76, 0x65, 0xc9, 0x61, 0xb2, 0xc9, 0x00, 0xf5, 0xbf, 0xa2, 0x72, 0xcd, 0x74	/* t__sysvec_apic_timer_interrupt */
	.byte 0x0f, 0xef, 0x68, 0x05, 0xb0, 0x73, 0x9c, 0x72, 0xc0, 0x75, 0xe9, 0xb3, 0xf5, 0x72, 0xcd, 0x74	/* t__pfx_handle_spurious_interrupt */
	.byte 0x0f, 0x74, 0x68, 0x05, 0xb0, 0x73, 0x9c, 0x72, 0xc0, 0x75, 0xe9, 0xb3, 0xf5, 0x72, 0xcd, 0x74	/* thandle_spurious_interrupt */
	.byte 0x0d, 0x74, 0xaf, 0xf6, 0x9c, 0x72, 0xc0, 0x75, 0xe9, 0xb3, 0xf5, 0x72, 0xcd, 0x74	/* t__pfx___spurious_interrupt */
	.byte 0x0d, 0x74, 0xff, 0x73, 0x9c, 0x72, 0xc0, 0x75, 0xe9, 0xb3, 0xf5, 0x72, 0xcd, 0x74	/* t__spurious_interrupt */
	.byte 0x14, 0x74, 0xaf, 0x7f, 0x73, 0x76, 0xb4, 0xf6, 0x9c, 0x72, 0xc0, 0x75, 0xe9, 0x61, 0xb2, 0xc9, 0xb3, 0xf5, 0x72, 0xcd, 0x74	/* t__pfx___sysvec_spurious_apic_interrupt */
	.byte 0x14, 0x74, 0xff, 0xe1, 0x73, 0x76, 0xb4, 0xf6, 0x9c, 0x72, 0xc0, 0x75, 0xe9, 0x61, 0xb2, 0xc9, 0xb3, 0xf5, 0x72, 0xcd, 0x74	/* t__sysvec_spurious_apic_interrupt */
	.byte 0x0f, 0x74, 0xaf, 0x7f, 0x73, 0x76, 0x65, 0xc9, 0xf5, 0xe3, 0x72, 0xbf, 0xa2, 0x72, 0xcd, 0x74	/* t__pfx___sysvec_error_interrupt */
	.byte 0x0f, 0x74, 0xff, 0xe1, 0x73, 0x76, 0x65, 0xc9, 0xf5, 0xe3, 0x72, 0xbf, 0xa2, 0x72, 0xcd, 0x74	/* t__sysvec_error_interrupt */
	.byte 0x0d, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0x61, 0xb2, 0xc9, 0xaa, 0x72, 0x92, 0x3c, 0x65	/* T__pfx_native_apic_icr_write */
	.byte 0x0d, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0x61, 0xb2, 0xc9, 0xaa, 0x72, 0x92, 0x3c, 0x65	/* Tnative_apic_icr_write */
	.byte 0x0c, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0x61, 0xb2, 0xc9, 0xaa, 0x72, 0xde, 0xc8	/* T__pfx_native_apic_icr_read */
	.byte 0x0c, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0x61, 0xb2, 0xc9, 0xaa, 0x72, 0xde, 0xc8	/* Tnative_apic_icr_read */
	.byte 0x0c, 0xeb, 0x6c, 0x61, 0xb2, 0xc9, 0x67, 0xe2, 0xd9, 0x78, 0x6c, 0x76, 0x74	/* T__pfx_lapic_get_maxlvt */
	.byte 0x0c, 0x54, 0x6c, 0x61, 0xb2, 0xc9, 0x67, 0xe2, 0xd9, 0x78, 0x6c, 0x76, 0x74	/* Tlapic_get_maxlvt */
	.byte 0x0d, 0xeb, 0x6c, 0x61, 0xb2, 0xc9, 0xcd, 0x64, 0x91, 0x93, 0x63, 0xe6, 0xf7, 0x71	/* T__pfx_lapic_update_tsc_freq */
	.byte 0x0d, 0x54, 0x6c, 0x61, 0xb2, 0xc9, 0xcd, 0x64, 0x91, 0x93, 0x63, 0xe6, 0xf7, 0x71	/* Tlapic_update_tsc_freq */
	.byte 0x10, 0xeb, 0x73, 0xd4, 0xcd, 0xf6, 0xb4, 0xe7, 0x64, 0xc5, 0x1d, 0x41, 0x50, 0x49, 0x43, 0xf0, 0xa4	/* T__pfx_setup_secondary_APIC_clock */
	.byte 0x10, 0x54, 0x73, 0xd4, 0xcd, 0xf6, 0xb4, 0xe7, 0x64, 0xc5, 0x1d, 0x41, 0x50, 0x49, 0x43, 0xf0, 0xa4	/* Tsetup_secondary_APIC_clock */
	.byte 0x13, 0xeb, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0x65, 0xc9, 0x61, 0xb2, 0xc9, 0x00, 0xf5, 0xbf, 0xa2, 0x72, 0xcd, 0x74	/* T__pfx_fred_sysvec_apic_timer_interrupt */
	.byte 0x13, 0x54, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0x65, 0xc9, 0x61, 0xb2, 0xc9, 0x00, 0xf5, 0xbf, 0xa2, 0x72, 0xcd, 0x74	/* Tfred_sysvec_apic_timer_interrupt */
	.byte 0x0d, 0xeb, 0x63, 0xc4, 0xc5, 0x5f, 0xdd, 0x63, 0xe5, 0x5f, 0x41, 0x50, 0x49, 0x43	/* T__pfx_clear_local_APIC */
	.byte 0x0d, 0x54, 0x63, 0xc4, 0xc5, 0x5f, 0xdd, 0x63, 0xe5, 0x5f, 0x41, 0x50, 0x49, 0x43	/* Tclear_local_APIC */
	.byte 0x0c, 0xeb, 0x61, 0xb2, 0x63, 0xf6, 0x6f, 0x66, 0xfe, 0x64, 0xca, 0x90, 0xc4	/* T__pfx_apic_soft_disable */
	.byte 0x0c, 0x54, 0x61, 0xb2, 0x63, 0xf6, 0x6f, 0x66, 0xfe, 0x64, 0xca, 0x90, 0xc4	/* Tapic_soft_disable */
	.byte 0x0d, 0xeb, 0x64, 0xca, 0x90, 0xb0, 0xdd, 0x63, 0xe5, 0x5f, 0x41, 0x50, 0x49, 0x43	/* T__pfx_disable_local_APIC */
	.byte 0x0d, 0x54, 0x64, 0xca, 0x90, 0xb0, 0xdd, 0x63, 0xe5, 0x5f, 0x41, 0x50, 0x49, 0x43	/* Tdisable_local_APIC */
	.byte 0x0b, 0xeb, 0x6c, 0x61, 0xb2, 0x63, 0xf6, 0x68, 0x20, 0x64, 0xad, 0x6e	/* T__pfx_lapic_shutdown */
	.byte 0x0b, 0x54, 0x6c, 0x61, 0xb2, 0x63, 0xf6, 0x68, 0x20, 0x64, 0xad, 0x6e	/* Tlapic_shutdown */
	.byte 0x09, 0xeb, 0x61, 0xb2, 0xc9, 0x61, 0x70, 0xf6, 0xd4, 0xcd	/* T__pfx_apic_ap_setup */
	.byte 0x09, 0x54, 0x61, 0xb2, 0xc9, 0x61, 0x70, 0xf6, 0xd4, 0xcd	/* Tapic_ap_setup */
	.byte 0x16, 0xeb, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0xb4, 0xf6, 0x9c, 0x72, 0xc0, 0x75, 0xe9, 0x61, 0xb2, 0xc9, 0xb3, 0xf5, 0x72, 0xcd, 0x74	/* T__pfx_fred_sysvec_spurious_apic_interrupt */
	.byte 0x16, 0x54, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0xb4, 0xf6, 0x9c, 0x72, 0xc0, 0x75, 0xe9, 0x61, 0xb2, 0xc9, 0xb3, 0xf5, 0x72, 0xcd, 0x74	/* Tfred_sysvec_spurious_apic_interrupt */
	.byte 0x11, 0xeb, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0x65, 0xc9, 0xf5, 0xe3, 0x72, 0xbf, 0xa2, 0x72, 0xcd, 0x74	/* T__pfx_fred_sysvec_error_interrupt */
	.byte 0x11, 0x54, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0x65, 0xc9, 0xf5, 0xe3, 0x72, 0xbf, 0xa2, 0x72, 0xcd, 0x74	/* Tfred_sysvec_error_interrupt */
	.byte 0x0f, 0xeb, 0x64, 0xca, 0x40, 0x6e, 0xb4, 0xfe, 0x62, 0x73, 0x70, 0x5f, 0x41, 0x50, 0x49, 0x43	/* T__pfx_disconnect_bsp_APIC */
	.byte 0x0f, 0x54, 0x64, 0xca, 0x40, 0x6e, 0xb4, 0xfe, 0x62, 0x73, 0x70, 0x5f, 0x41, 0x50, 0x49, 0x43	/* Tdisconnect_bsp_APIC */
	.byte 0x0d, 0x08, 0xab, 0x71, 0xc1, 0x85, 0x3a, 0xb6, 0x6f, 0x73, 0xfc, 0x6d, 0x73, 0x67	/* T__pfx___irq_msi_compose_msg */
	.byte 0x0d, 0xb9, 0xab, 0x71, 0xc1, 0x85, 0x3a, 0xb6, 0x6f, 0x73, 0xfc, 0x6d, 0x73, 0x67	/* T__irq_msi_compose_msg */
	.byte 0x0e, 0xeb, 0x61, 0xb2, 0xc9, 0xca, 0xf0, 0x6c, 0xb1, 0x2c, 0xf7, 0xda, 0x62, 0x6f, 0x78	/* T__pfx_apic_is_clustered_box */
	.byte 0x0e, 0x54, 0x61, 0xb2, 0xc9, 0xca, 0xf0, 0x6c, 0xb1, 0x2c, 0xf7, 0xda, 0x62, 0x6f, 0x78	/* Tapic_is_clustered_box */
	.byte 0x13, 0xeb, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x63, 0x9c, 0xec, 0x29, 0xf1, 0xfe, 0x8a, 0x5f, 0x61, 0xb2, 0x63, 0x9f	/* T__pfx_default_cpu_present_to_apicid */
	.byte 0x13, 0x54, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x63, 0x9c, 0xec, 0x29, 0xf1, 0xfe, 0x8a, 0x5f, 0x61, 0xb2, 0x63, 0x9f	/* Tdefault_cpu_present_to_apicid */
	.byte 0x11, 0xeb, 0x61, 0xb2, 0x63, 0xed, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x63, 0xe5, 0xc9, 0x61, 0xb2, 0x63, 0x9f	/* T__pfx_apic_default_calc_apicid */
	.byte 0x11, 0x54, 0x61, 0xb2, 0x63, 0xed, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x63, 0xe5, 0xc9, 0x61, 0xb2, 0x63, 0x9f	/* Tapic_default_calc_apicid */
	.byte 0x0f, 0xeb, 0x61, 0xb2, 0x63, 0xe6, 0x6c, 0x61, 0xfe, 0x63, 0xe5, 0xc9, 0x61, 0xb2, 0x63, 0x9f	/* T__pfx_apic_flat_calc_apicid */
	.byte 0x0f, 0x54, 0x61, 0xb2, 0x63, 0xe6, 0x6c, 0x61, 0xfe, 0x63, 0xe5, 0xc9, 0x61, 0xb2, 0x63, 0x9f	/* Tapic_flat_calc_apicid */
	.byte 0x0e, 0xeb, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0xf8, 0x9d, 0x61, 0xb2, 0xc9, 0x6c, 0xac	/* T__pfx_default_init_apic_ldr */
	.byte 0x0e, 0x54, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0xf8, 0x9d, 0x61, 0xb2, 0xc9, 0x6c, 0xac	/* Tdefault_init_apic_ldr */
	.byte 0x0a, 0xef, 0x6e, 0x6f, 0xbe, 0xf6, 0xf1, 0xda, 0x49, 0x50, 0x49	/* t__pfx_noop_send_IPI */
	.byte 0x0a, 0x74, 0x6e, 0x6f, 0xbe, 0xf6, 0xf1, 0xda, 0x49, 0x50, 0x49	/* tnoop_send_IPI */
	.byte 0x0d, 0xef, 0x6e, 0x6f, 0xbe, 0xf6, 0xf1, 0xda, 0x49, 0x50, 0x49, 0x5f, 0xd9, 0x5e	/* t__pfx_noop_send_IPI_mask */
	.byte 0x0d, 0x74, 0x6e, 0x6f, 0xbe, 0xf6, 0xf1, 0xda, 0x49, 0x50, 0x49, 0x5f, 0xd9, 0x5e	/* tnoop_send_IPI_mask */
	.byte 0x10, 0xef, 0x6e, 0x6f, 0xbe, 0xf6, 0xf1, 0xda, 0x49, 0x50, 0x49, 0x5f, 0x5d, 0x06, 0x93, 0xdb, 0x66	/* t__pfx_noop_send_IPI_allbutself */
	.byte 0x10, 0x74, 0x6e, 0x6f, 0xbe, 0xf6, 0xf1, 0xda, 0x49, 0x50, 0x49, 0x5f, 0x5d, 0x06, 0x93, 0xdb, 0x66	/* tnoop_send_IPI_allbutself */
	.byte 0x0d, 0xef, 0x6e, 0x6f, 0xbe, 0x5f, 0x61, 0xb2, 0xc9, 0xaa, 0x72, 0x92, 0x3c, 0x65	/* t__pfx_noop_apic_icr_write */
	.byte 0x0d, 0x74, 0x6e, 0x6f, 0xbe, 0x5f, 0x61, 0xb2, 0xc9, 0xaa, 0x72, 0x92, 0x3c, 0x65	/* tnoop_apic_icr_write */
	.byte 0x11, 0xef, 0x6e, 0x6f, 0xbe, 0x92, 0x61, 0x6b, 0x65, 0xcd, 0xf6, 0xb4, 0xe7, 0x64, 0xc5, 0x79, 0xf0, 0x9c	/* t__pfx_noop_wakeup_secondary_cpu */
	.byte 0x11, 0x74, 0x6e, 0x6f, 0xbe, 0x92, 0x61, 0x6b, 0x65, 0xcd, 0xf6, 0xb4, 0xe7, 0x64, 0xc5, 0x79, 0xf0, 0x9c	/* tnoop_wakeup_secondary_cpu */
	.byte 0x0c, 0xef, 0x6e, 0x6f, 0xbe, 0x5f, 0x61, 0xb2, 0xc9, 0xaa, 0x72, 0xde, 0xc8	/* t__pfx_noop_apic_icr_read */
	.byte 0x0c, 0x74, 0x6e, 0x6f, 0xbe, 0x5f, 0x61, 0xb2, 0xc9, 0xaa, 0x72, 0xde, 0xc8	/* tnoop_apic_icr_read */
	.byte 0x09, 0xef, 0x6e, 0x6f, 0xbe, 0x86, 0x61, 0xb2, 0xc9, 0x9f	/* t__pfx_noop_get_apic_id */
	.byte 0x09, 0x74, 0x6e, 0x6f, 0xbe, 0x86, 0x61, 0xb2, 0xc9, 0x9f	/* tnoop_get_apic_id */
	.byte 0x0b, 0xef, 0x6e, 0x6f, 0xbe, 0x5f, 0x61, 0xb2, 0xc9, 0x65, 0x6f, 0x69	/* t__pfx_noop_apic_eoi */
	.byte 0x0b, 0x74, 0x6e, 0x6f, 0xbe, 0x5f, 0x61, 0xb2, 0xc9, 0x65, 0x6f, 0x69	/* tnoop_apic_eoi */
	.byte 0x0a, 0xef, 0x6e, 0x6f, 0xbe, 0x5f, 0x61, 0xb2, 0x63, 0xde, 0xc8	/* t__pfx_noop_apic_read */
	.byte 0x0a, 0x74, 0x6e, 0x6f, 0xbe, 0x5f, 0x61, 0xb2, 0x63, 0xde, 0xc8	/* tnoop_apic_read */
	.byte 0x0b, 0xef, 0x6e, 0x6f, 0xbe, 0x5f, 0x61, 0xb2, 0xc9, 0x77, 0x3c, 0x65	/* t__pfx_noop_apic_write */
	.byte 0x0b, 0x74, 0x6e, 0x6f, 0xbe, 0x5f, 0x61, 0xb2, 0xc9, 0x77, 0x3c, 0x65	/* tnoop_apic_write */
	.byte 0x13, 0xef, 0x6e, 0x6f, 0xbe, 0xf6, 0xf1, 0xda, 0x49, 0x50, 0x49, 0x5f, 0xd9, 0x5e, 0x5f, 0x5d, 0x06, 0x93, 0xdb, 0x66	/* t__pfx_noop_send_IPI_mask_allbutself */
	.byte 0x13, 0x74, 0x6e, 0x6f, 0xbe, 0xf6, 0xf1, 0xda, 0x49, 0x50, 0x49, 0x5f, 0xd9, 0x5e, 0x5f, 0x5d, 0x06, 0x93, 0xdb, 0x66	/* tnoop_send_IPI_mask_allbutself */
	.byte 0x0c, 0xef, 0x6e, 0x6f, 0xbe, 0xf6, 0xf1, 0xda, 0x49, 0x50, 0x49, 0x5f, 0x5d	/* t__pfx_noop_send_IPI_all */
	.byte 0x0c, 0x74, 0x6e, 0x6f, 0xbe, 0xf6, 0xf1, 0xda, 0x49, 0x50, 0x49, 0x5f, 0x5d	/* tnoop_send_IPI_all */
	.byte 0x0d, 0xef, 0x6e, 0x6f, 0xbe, 0xf6, 0xf1, 0xda, 0x49, 0x50, 0x49, 0xf6, 0xdb, 0x66	/* t__pfx_noop_send_IPI_self */
	.byte 0x0d, 0x74, 0x6e, 0x6f, 0xbe, 0xf6, 0xf1, 0xda, 0x49, 0x50, 0x49, 0xf6, 0xdb, 0x66	/* tnoop_send_IPI_self */
	.byte 0x0a, 0xeb, 0x61, 0xb2, 0x63, 0xf6, 0x6d, 0xfe, 0xcd, 0x64, 0x14	/* T__pfx_apic_smt_update */
	.byte 0x0a, 0x54, 0x61, 0xb2, 0x63, 0xf6, 0x6d, 0xfe, 0xcd, 0x64, 0x14	/* Tapic_smt_update */
	.byte 0x10, 0xeb, 0x61, 0xb2, 0x63, 0xf6, 0xf1, 0xda, 0x49, 0x50, 0x49, 0x5f, 0x5d, 0x06, 0x93, 0xdb, 0x66	/* T__pfx_apic_send_IPI_allbutself */
	.byte 0x10, 0x54, 0x61, 0xb2, 0x63, 0xf6, 0xf1, 0xda, 0x49, 0x50, 0x49, 0x5f, 0x5d, 0x06, 0x93, 0xdb, 0x66	/* Tapic_send_IPI_allbutself */
	.byte 0x0f, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0x73, 0xb6, 0xf6, 0xf1, 0x64, 0x07, 0xba, 0x9e, 0x75, 0xc4	/* T__pfx_native_smp_send_reschedule */
	.byte 0x0f, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0x73, 0xb6, 0xf6, 0xf1, 0x64, 0x07, 0xba, 0x9e, 0x75, 0xc4	/* Tnative_smp_send_reschedule */
	.byte 0x11, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0x73, 0xf1, 0x64, 0xf0, 0x5d, 0xe6, 0x96, 0xf6, 0x8d, 0xb0, 0x69, 0xb2	/* T__pfx_native_send_call_func_single_ipi */
	.byte 0x11, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0x73, 0xf1, 0x64, 0xf0, 0x5d, 0xe6, 0x96, 0xf6, 0x8d, 0xb0, 0x69, 0xb2	/* Tnative_send_call_func_single_ipi */
	.byte 0x0f, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0x73, 0xf1, 0x64, 0xf0, 0x5d, 0xe6, 0xe4, 0xc9, 0x69, 0xb2	/* T__pfx_native_send_call_func_ipi */
	.byte 0x0f, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0x73, 0xf1, 0x64, 0xf0, 0x5d, 0xe6, 0xe4, 0xc9, 0x69, 0xb2	/* Tnative_send_call_func_ipi */
	.byte 0x14, 0xeb, 0x61, 0xb2, 0x63, 0xf6, 0xf1, 0xda, 0x6e, 0x6d, 0x69, 0xa7, 0x6f, 0x5f, 0x6f, 0x66, 0x66, 0x2d, 0xfc, 0x63, 0x9c	/* T__pfx_apic_send_nmi_to_offline_cpu */
	.byte 0x14, 0x54, 0x61, 0xb2, 0x63, 0xf6, 0xf1, 0xda, 0x6e, 0x6d, 0x69, 0xa7, 0x6f, 0x5f, 0x6f, 0x66, 0x66, 0x2d, 0xfc, 0x63, 0x9c	/* Tapic_send_nmi_to_offline_cpu */
	.byte 0x12, 0xeb, 0x61, 0xb2, 0xc9, 0xa8, 0xae, 0x77, 0x61, 0x9d, 0xaa, 0x72, 0x5f, 0x9f, 0xb0, 0xdc, 0xa8, 0x6f, 0x20	/* T__pfx_apic_mem_wait_icr_idle_timeout */
	.byte 0x12, 0x54, 0x61, 0xb2, 0xc9, 0xa8, 0xae, 0x77, 0x61, 0x9d, 0xaa, 0x72, 0x5f, 0x9f, 0xb0, 0xdc, 0xa8, 0x6f, 0x20	/* Tapic_mem_wait_icr_idle_timeout */
	.byte 0x0e, 0xeb, 0x61, 0xb2, 0xc9, 0xa8, 0xae, 0x77, 0x61, 0x9d, 0xaa, 0x72, 0x5f, 0x9f, 0xc4	/* T__pfx_apic_mem_wait_icr_idle */
	.byte 0x0e, 0x54, 0x61, 0xb2, 0xc9, 0xa8, 0xae, 0x77, 0x61, 0x9d, 0xaa, 0x72, 0x5f, 0x9f, 0xc4	/* Tapic_mem_wait_icr_idle */
	.byte 0x13, 0x99, 0xed, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x73, 0xf1, 0xda, 0x49, 0x50, 0x49, 0xed, 0xd6, 0xfe, 0xa5, 0xdb, 0x64	/* T__pfx___default_send_IPI_dest_field */
	.byte 0x13, 0xb9, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x73, 0xf1, 0xda, 0x49, 0x50, 0x49, 0xed, 0xd6, 0xfe, 0xa5, 0xdb, 0x64	/* T__default_send_IPI_dest_field */
	.byte 0x14, 0xeb, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x73, 0xf1, 0xda, 0x49, 0x50, 0x49, 0xf6, 0x8d, 0xb0, 0x70, 0x68, 0x79, 0x73	/* T__pfx_default_send_IPI_single_phys */
	.byte 0x14, 0x54, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x73, 0xf1, 0xda, 0x49, 0x50, 0x49, 0xf6, 0x8d, 0xb0, 0x70, 0x68, 0x79, 0x73	/* Tdefault_send_IPI_single_phys */
	.byte 0x1a, 0xeb, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x73, 0xf1, 0xda, 0x49, 0x50, 0x49, 0x5f, 0xd9, 0x5e, 0xf6, 0x65, 0xa1, 0xf1, 0x63, 0xfc, 0x70, 0x68, 0x79, 0x73	/* T__pfx_default_send_IPI_mask_sequence_phys */
	.byte 0x1a, 0x54, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x73, 0xf1, 0xda, 0x49, 0x50, 0x49, 0x5f, 0xd9, 0x5e, 0xf6, 0x65, 0xa1, 0xf1, 0x63, 0xfc, 0x70, 0x68, 0x79, 0x73	/* Tdefault_send_IPI_mask_sequence_phys */
	.byte 0x1a, 0xeb, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x73, 0xf1, 0xda, 0x49, 0x50, 0x49, 0x5f, 0xd9, 0x5e, 0x5f, 0x5d, 0x06, 0x93, 0xdb, 0x66, 0xec, 0x68, 0x79, 0x73	/* T__pfx_default_send_IPI_mask_allbutself_phys */
	.byte 0x1a, 0x54, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x73, 0xf1, 0xda, 0x49, 0x50, 0x49, 0x5f, 0xd9, 0x5e, 0x5f, 0x5d, 0x06, 0x93, 0xdb, 0x66, 0xec, 0x68, 0x79, 0x73	/* Tdefault_send_IPI_mask_allbutself_phys */
	.byte 0x10, 0xeb, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x73, 0xf1, 0xda, 0x49, 0x50, 0x49, 0xf6, 0x8d, 0xc4	/* T__pfx_default_send_IPI_single */
	.byte 0x10, 0x54, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x73, 0xf1, 0xda, 0x49, 0x50, 0x49, 0xf6, 0x8d, 0xc4	/* Tdefault_send_IPI_single */
	.byte 0x13, 0xeb, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x73, 0xf1, 0xda, 0x49, 0x50, 0x49, 0x5f, 0x5d, 0x06, 0x93, 0xdb, 0x66	/* T__pfx_default_send_IPI_allbutself */
	.byte 0x13, 0x54, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x73, 0xf1, 0xda, 0x49, 0x50, 0x49, 0x5f, 0x5d, 0x06, 0x93, 0xdb, 0x66	/* Tdefault_send_IPI_allbutself */
	.byte 0x0f, 0xeb, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x73, 0xf1, 0xda, 0x49, 0x50, 0x49, 0x5f, 0x5d	/* T__pfx_default_send_IPI_all */
	.byte 0x0f, 0x54, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x73, 0xf1, 0xda, 0x49, 0x50, 0x49, 0x5f, 0x5d	/* Tdefault_send_IPI_all */
	.byte 0x10, 0xeb, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x73, 0xf1, 0xda, 0x49, 0x50, 0x49, 0xf6, 0xdb, 0x66	/* T__pfx_default_send_IPI_self */
	.byte 0x10, 0x54, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x73, 0xf1, 0xda, 0x49, 0x50, 0x49, 0xf6, 0xdb, 0x66	/* Tdefault_send_IPI_self */
	.byte 0x0d, 0xef, 0x78, 0x38, 0x36, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xf6, 0xdb, 0xb4, 0x74	/* t__pfx_x86_vector_select */
	.byte 0x0d, 0x74, 0x78, 0x38, 0x36, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xf6, 0xdb, 0xb4, 0x74	/* tx86_vector_select */
	.byte 0x07, 0xeb, 0xab, 0x71, 0x64, 0xf0, 0x66, 0x67	/* T__pfx_irqd_cfg */
	.byte 0x07, 0x54, 0xab, 0x71, 0x64, 0xf0, 0x66, 0x67	/* Tirqd_cfg */
	.byte 0x0c, 0xef, 0x61, 0xb2, 0x63, 0xde, 0xf3, 0x0c, 0x67, 0xf5, 0x5f, 0xab, 0x71	/* t__pfx_apic_retrigger_irq */
	.byte 0x0b, 0xf4, 0xb2, 0x63, 0xde, 0xf3, 0x0c, 0x67, 0xf5, 0x5f, 0xab, 0x71	/* tapic_retrigger_irq */
	.byte 0x13, 0xef, 0x78, 0x38, 0x36, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xc1, 0x85, 0x3a, 0xb6, 0x6f, 0x73, 0xfc, 0x6d, 0x73, 0x67	/* t__pfx_x86_vector_msi_compose_msg */
	.byte 0x13, 0x74, 0x78, 0x38, 0x36, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xc1, 0x85, 0x3a, 0xb6, 0x6f, 0x73, 0xfc, 0x6d, 0x73, 0x67	/* tx86_vector_msi_compose_msg */
	.byte 0x0c, 0xef, 0x61, 0xb2, 0xc9, 0xcd, 0x64, 0x91, 0xab, 0x71, 0xf0, 0x66, 0x67	/* t__pfx_apic_update_irq_cfg */
	.byte 0x0b, 0xf4, 0xb2, 0xc9, 0xcd, 0x64, 0x91, 0xab, 0x71, 0xf0, 0x66, 0x67	/* tapic_update_irq_cfg */
	.byte 0x0e, 0xef, 0x29, 0xf5, 0x1a, 0xab, 0x71, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xa4, 0x9e	/* t__pfx_reserve_irq_vector_locked */
	.byte 0x0e, 0x74, 0x29, 0xf5, 0x1a, 0xab, 0x71, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xa4, 0x9e	/* treserve_irq_vector_locked */
	.byte 0x0c, 0xef, 0x66, 0xf7, 0xfc, 0x17, 0x76, 0x65, 0xda, 0x76, 0xb4, 0x74, 0xd5	/* t__pfx_free_moved_vector */
	.byte 0x0c, 0x74, 0x66, 0xf7, 0xfc, 0x17, 0x76, 0x65, 0xda, 0x76, 0xb4, 0x74, 0xd5	/* tfree_moved_vector */
	.byte 0x0b, 0x74, 0xaf, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xf0, 0xc4, 0xd2, 0xcd	/* t__pfx___vector_cleanup */
	.byte 0x0a, 0x74, 0xff, 0x76, 0xb4, 0x74, 0xd5, 0xf0, 0xc4, 0xd2, 0xcd	/* t__vector_cleanup */
	.byte 0x0e, 0xef, 0x76, 0xb4, 0x74, 0xd5, 0xf0, 0xc4, 0xd2, 0xcd, 0xf0, 0x5d, 0x62, 0xf2, 0x6b	/* t__pfx_vector_cleanup_callback */
	.byte 0x0e, 0x74, 0x76, 0xb4, 0x74, 0xd5, 0xf0, 0xc4, 0xd2, 0xcd, 0xf0, 0x5d, 0x62, 0xf2, 0x6b	/* tvector_cleanup_callback */
	.byte 0x10, 0x74, 0xaf, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xf6, 0xba, 0x9e, 0x75, 0xb0, 0x63, 0xc4, 0xd2, 0xcd	/* t__pfx___vector_schedule_cleanup */
	.byte 0x0f, 0x74, 0xff, 0x76, 0xb4, 0x74, 0xd5, 0xf6, 0xba, 0x9e, 0x75, 0xb0, 0x63, 0xc4, 0xd2, 0xcd	/* t__vector_schedule_cleanup */
	.byte 0x0a, 0xeb, 0x61, 0xb2, 0xc9, 0xf2, 0x6b, 0x5f, 0x9e, 0x67, 0x65	/* T__pfx_apic_ack_edge */
	.byte 0x0a, 0x54, 0x61, 0xb2, 0xc9, 0xf2, 0x6b, 0x5f, 0x9e, 0x67, 0x65	/* Tapic_ack_edge */
	.byte 0x0b, 0xef, 0x61, 0xb2, 0xc9, 0xcd, 0x64, 0x91, 0x76, 0xb4, 0x74, 0xd5	/* t__pfx_apic_update_vector */
	.byte 0x0a, 0xf4, 0xb2, 0xc9, 0xcd, 0x64, 0x91, 0x76, 0xb4, 0x74, 0xd5	/* tapic_update_vector */
	.byte 0x0d, 0xef, 0xbb, 0x85, 0x67, 0x6e, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xa4, 0x9e	/* t__pfx_assign_vector_locked */
	.byte 0x0d, 0xf4, 0x73, 0x85, 0x67, 0x6e, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xa4, 0x9e	/* tassign_vector_locked */
	.byte 0x12, 0xef, 0xbb, 0x85, 0x67, 0x6e, 0x5f, 0xab, 0x71, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xd2, 0x1d, 0xa4, 0x9e	/* t__pfx_assign_irq_vector_any_locked */
	.byte 0x12, 0xf4, 0x73, 0x85, 0x67, 0x6e, 0x5f, 0xab, 0x71, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xd2, 0x1d, 0xa4, 0x9e	/* tassign_irq_vector_any_locked */
	.byte 0x16, 0xef, 0xbb, 0x85, 0x67, 0x6e, 0x5f, 0xd9, 0x6e, 0x83, 0x65, 0xda, 0x76, 0xb4, 0x74, 0xd5, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__pfx_assign_managed_vector.constprop.0 */
	.byte 0x16, 0xf4, 0x73, 0x85, 0x67, 0x6e, 0x5f, 0xd9, 0x6e, 0x83, 0x65, 0xda, 0x76, 0xb4, 0x74, 0xd5, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* tassign_managed_vector.constprop.0 */
	.byte 0x0a, 0xef, 0x61, 0xb2, 0x63, 0x84, 0x61, 0x66, 0x66, 0x0f, 0x79	/* t__pfx_apic_set_affinity */
	.byte 0x09, 0xf4, 0xb2, 0x63, 0x84, 0x61, 0x66, 0x66, 0x0f, 0x79	/* tapic_set_affinity */
	.byte 0x0e, 0xef, 0x78, 0x38, 0x36, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xf2, 0xdc, 0x76, 0x14	/* t__pfx_x86_vector_activate */
	.byte 0x0e, 0x74, 0x78, 0x38, 0x36, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xf2, 0xdc, 0x76, 0x14	/* tx86_vector_activate */
	.byte 0x0c, 0xef, 0x63, 0xc4, 0xc5, 0x5f, 0xab, 0x71, 0x5f, 0x76, 0xb4, 0x74, 0xd5	/* t__pfx_clear_irq_vector */
	.byte 0x0b, 0x26, 0xc4, 0xc5, 0x5f, 0xab, 0x71, 0x5f, 0x76, 0xb4, 0x74, 0xd5	/* tclear_irq_vector */
	.byte 0x0f, 0xef, 0x78, 0x38, 0x36, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xed, 0x65, 0xf2, 0xdc, 0x76, 0x14	/* t__pfx_x86_vector_deactivate */
	.byte 0x0f, 0x74, 0x78, 0x38, 0x36, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xed, 0x65, 0xf2, 0xdc, 0x76, 0x14	/* tx86_vector_deactivate */
	.byte 0x0f, 0xef, 0x78, 0x38, 0x36, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xe6, 0xf7, 0xfc, 0xab, 0x71, 0x73	/* t__pfx_x86_vector_free_irqs */
	.byte 0x0f, 0x74, 0x78, 0x38, 0x36, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0xe6, 0xf7, 0xfc, 0xab, 0x71, 0x73	/* tx86_vector_free_irqs */
	.byte 0x0f, 0xef, 0x78, 0x38, 0x36, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0x22, 0xc9, 0xab, 0x71, 0x73	/* t__pfx_x86_vector_alloc_irqs */
	.byte 0x0f, 0x74, 0x78, 0x38, 0x36, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0x22, 0xc9, 0xab, 0x71, 0x73	/* tx86_vector_alloc_irqs */
	.byte 0x09, 0xeb, 0xa4, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xa4	/* T__pfx_lock_vector_lock */
	.byte 0x09, 0x54, 0xa4, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xa4	/* Tlock_vector_lock */
	.byte 0x0a, 0xeb, 0xe4, 0xa4, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xa4	/* T__pfx_unlock_vector_lock */
	.byte 0x0a, 0x54, 0xe4, 0xa4, 0x5f, 0x76, 0xb4, 0x74, 0xd5, 0x5f, 0xa4	/* Tunlock_vector_lock */
	.byte 0x0b, 0xeb, 0xf8, 0x9d, 0xab, 0x71, 0x5f, 0x22, 0xc9, 0xf8, 0x66, 0x6f	/* T__pfx_init_irq_alloc_info */
	.byte 0x0b, 0x54, 0xf8, 0x9d, 0xab, 0x71, 0x5f, 0x22, 0xc9, 0xf8, 0x66, 0x6f	/* Tinit_irq_alloc_info */
	.byte 0x0c, 0xeb, 0x63, 0xbe, 0x1d, 0xab, 0x71, 0x5f, 0x22, 0xc9, 0xf8, 0x66, 0x6f	/* T__pfx_copy_irq_alloc_info */
	.byte 0x0c, 0x54, 0x63, 0xbe, 0x1d, 0xab, 0x71, 0x5f, 0x22, 0xc9, 0xf8, 0x66, 0x6f	/* Tcopy_irq_alloc_info */
	.byte 0x06, 0xeb, 0xab, 0x71, 0xf0, 0x66, 0x67	/* T__pfx_irq_cfg */
	.byte 0x06, 0x54, 0xab, 0x71, 0xf0, 0x66, 0x67	/* Tirq_cfg */
	.byte 0x10, 0xeb, 0x78, 0x38, 0x36, 0xe6, 0x77, 0x73, 0x70, 0x65, 0xc9, 0x69, 0xe9, 0xc0, 0x61, 0xb2, 0x63	/* T__pfx_x86_fwspec_is_ioapic */
	.byte 0x10, 0x54, 0x78, 0x38, 0x36, 0xe6, 0x77, 0x73, 0x70, 0x65, 0xc9, 0x69, 0xe9, 0xc0, 0x61, 0xb2, 0x63	/* Tx86_fwspec_is_ioapic */
	.byte 0x0f, 0xeb, 0x78, 0x38, 0x36, 0xe6, 0x77, 0x73, 0x70, 0x65, 0xc9, 0x69, 0xe9, 0x68, 0x70, 0xd4	/* T__pfx_x86_fwspec_is_hpet */
	.byte 0x0f, 0x54, 0x78, 0x38, 0x36, 0xe6, 0x77, 0x73, 0x70, 0x65, 0xc9, 0x69, 0xe9, 0x68, 0x70, 0xd4	/* Tx86_fwspec_is_hpet */
	.byte 0x12, 0xeb, 0x6c, 0x61, 0xb2, 0xc9, 0xbb, 0x85, 0x67, 0x6e, 0x5f, 0xc4, 0x67, 0xf2, 0x1d, 0x76, 0xb4, 0x74, 0xd5	/* T__pfx_lapic_assign_legacy_vector */
	.byte 0x12, 0x54, 0x6c, 0x61, 0xb2, 0xc9, 0xbb, 0x85, 0x67, 0x6e, 0x5f, 0xc4, 0x67, 0xf2, 0x1d, 0x76, 0xb4, 0x74, 0xd5	/* Tlapic_assign_legacy_vector */
	.byte 0x08, 0xeb, 0x6c, 0x61, 0xb2, 0xc9, 0xe7, 0x2d, 0x65	/* T__pfx_lapic_online */
	.byte 0x08, 0x54, 0x6c, 0x61, 0xb2, 0xc9, 0xe7, 0x2d, 0x65	/* Tlapic_online */
	.byte 0x0a, 0xeb, 0x6c, 0x61, 0xb2, 0xc9, 0x6f, 0x66, 0x66, 0x2d, 0x65	/* T__pfx_lapic_offline */
	.byte 0x0a, 0x54, 0x6c, 0x61, 0xb2, 0xc9, 0x6f, 0x66, 0x66, 0x2d, 0x65	/* Tlapic_offline */
	.byte 0x09, 0xeb, 0x61, 0xb2, 0xc9, 0xf2, 0x6b, 0x5f, 0xab, 0x71	/* T__pfx_apic_ack_irq */
	.byte 0x09, 0x54, 0x61, 0xb2, 0xc9, 0xf2, 0x6b, 0x5f, 0xab, 0x71	/* Tapic_ack_irq */
	.byte 0x0e, 0xeb, 0x76, 0xb4, 0x74, 0xd5, 0xf6, 0xba, 0x9e, 0x75, 0xb0, 0x63, 0xc4, 0xd2, 0xcd	/* T__pfx_vector_schedule_cleanup */
	.byte 0x0e, 0x54, 0x76, 0xb4, 0x74, 0xd5, 0xf6, 0xba, 0x9e, 0x75, 0xb0, 0x63, 0xc4, 0xd2, 0xcd	/* Tvector_schedule_cleanup */
	.byte 0x0b, 0xeb, 0xab, 0x71, 0x3a, 0xb6, 0x6c, 0xd4, 0xfc, 0x17, 0x76, 0x65	/* T__pfx_irq_complete_move */
	.byte 0x0b, 0x54, 0xab, 0x71, 0x3a, 0xb6, 0x6c, 0xd4, 0xfc, 0x17, 0x76, 0x65	/* Tirq_complete_move */
	.byte 0x0f, 0xeb, 0xab, 0x71, 0xe6, 0xd5, 0x63, 0xfc, 0x03, 0xb6, 0x6c, 0xd4, 0xfc, 0x17, 0x76, 0x65	/* T__pfx_irq_force_complete_move */
	.byte 0x0f, 0x54, 0xab, 0x71, 0xe6, 0xd5, 0x63, 0xfc, 0x03, 0xb6, 0x6c, 0xd4, 0xfc, 0x17, 0x76, 0x65	/* Tirq_force_complete_move */
	.byte 0x0f, 0xeb, 0x6c, 0x61, 0xb2, 0x63, 0xf0, 0xd2, 0x5f, 0xe4, 0x70, 0x6c, 0x75, 0x67, 0xf0, 0x9c	/* T__pfx_lapic_can_unplug_cpu */
	.byte 0x0f, 0x54, 0x6c, 0x61, 0xb2, 0x63, 0xf0, 0xd2, 0x5f, 0xe4, 0x70, 0x6c, 0x75, 0x67, 0xf0, 0x9c	/* Tlapic_can_unplug_cpu */
	.byte 0x0e, 0xef, 0x6e, 0x6d, 0x69, 0x5f, 0xbc, 0xca, 0xfc, 0x63, 0x9c, 0xb8, 0xf2, 0x6b, 0x94	/* t__pfx_nmi_raise_cpu_backtrace */
	.byte 0x0e, 0x74, 0x6e, 0x6d, 0x69, 0x5f, 0xbc, 0xca, 0xfc, 0x63, 0x9c, 0xb8, 0xf2, 0x6b, 0x94	/* tnmi_raise_cpu_backtrace */
	.byte 0x0e, 0xef, 0x6e, 0x6d, 0x69, 0xf0, 0x9c, 0xb8, 0xf2, 0x6b, 0xc3, 0x68, 0x05, 0x6c, 0xf5	/* t__pfx_nmi_cpu_backtrace_handler */
	.byte 0x0e, 0x74, 0x6e, 0x6d, 0x69, 0xf0, 0x9c, 0xb8, 0xf2, 0x6b, 0xc3, 0x68, 0x05, 0x6c, 0xf5	/* tnmi_cpu_backtrace_handler */
	.byte 0x10, 0xeb, 0xc5, 0xba, 0x5f, 0xf3, 0x0c, 0x67, 0xf5, 0xf0, 0x9c, 0xd9, 0x5e, 0xb8, 0xf2, 0x6b, 0x94	/* T__pfx_arch_trigger_cpumask_backtrace */
	.byte 0x10, 0x54, 0xc5, 0xba, 0x5f, 0xf3, 0x0c, 0x67, 0xf5, 0xf0, 0x9c, 0xd9, 0x5e, 0xb8, 0xf2, 0x6b, 0x94	/* Tarch_trigger_cpumask_backtrace */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0xc0, 0x61, 0xb2, 0x63, 0xde, 0x61, 0xda, 0xf1, 0xf3, 0x79	/* t__pfx___ioapic_read_entry */
	.byte 0x0c, 0x74, 0xff, 0xc0, 0x61, 0xb2, 0x63, 0xde, 0x61, 0xda, 0xf1, 0xf3, 0x79	/* t__ioapic_read_entry */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0xc0, 0x61, 0xb2, 0xc9, 0x77, 0x3c, 0xfc, 0xf1, 0xf3, 0x79	/* t__pfx___ioapic_write_entry */
	.byte 0x0c, 0x74, 0xff, 0xc0, 0x61, 0xb2, 0xc9, 0x77, 0x3c, 0xfc, 0xf1, 0xf3, 0x79	/* t__ioapic_write_entry */
	.byte 0x09, 0xef, 0xc0, 0x5f, 0x61, 0xb2, 0x63, 0x7f, 0x6e, 0x63	/* t__pfx_io_apic_sync */
	.byte 0x09, 0xdc, 0x6f, 0x5f, 0x61, 0xb2, 0x63, 0x7f, 0x6e, 0x63	/* tio_apic_sync */
	.byte 0x0c, 0xef, 0xc0, 0x61, 0xb2, 0xc9, 0xab, 0x71, 0x86, 0xba, 0x28, 0xa9, 0x2c	/* t__pfx_ioapic_irq_get_chip_state */
	.byte 0x0c, 0xdc, 0x6f, 0x61, 0xb2, 0xc9, 0xab, 0x71, 0x86, 0xba, 0x28, 0xa9, 0x2c	/* tioapic_irq_get_chip_state */
	.byte 0x09, 0xef, 0xab, 0x71, 0x5f, 0x69, 0xe9, 0x6c, 0xee, 0xdb	/* t__pfx_irq_is_level */
	.byte 0x09, 0xdc, 0x72, 0x71, 0x5f, 0x69, 0xe9, 0x6c, 0xee, 0xdb	/* tirq_is_level */
	.byte 0x0d, 0xef, 0xc8, 0x64, 0xec, 0xf8, 0xa7, 0x6f, 0x5f, 0xab, 0x71, 0xbd, 0xb7, 0x65	/* t__pfx_add_pin_to_irq_node */
	.byte 0x0d, 0xf4, 0x64, 0x64, 0xec, 0xf8, 0xa7, 0x6f, 0x5f, 0xab, 0x71, 0xbd, 0xb7, 0x65	/* tadd_pin_to_irq_node */
	.byte 0x09, 0xef, 0xb6, 0x25, 0x65, 0xc6, 0xec, 0xf8, 0x5f, 0x24	/* t__pfx_mp_check_pin_attr */
	.byte 0x09, 0x74, 0xb6, 0x25, 0x65, 0xc6, 0xec, 0xf8, 0x5f, 0x24	/* tmp_check_pin_attr */
	.byte 0x0a, 0xef, 0xf2, 0x6b, 0x5f, 0x6c, 0x61, 0xb2, 0xc9, 0xab, 0x71	/* t__pfx_ack_lapic_irq */
	.byte 0x09, 0xf4, 0xc6, 0x5f, 0x6c, 0x61, 0xb2, 0xc9, 0xab, 0x71	/* tack_lapic_irq */
	.byte 0x0c, 0xef, 0xb6, 0x5f, 0xab, 0x71, 0x64, 0x6f, 0xd9, 0xf8, 0xf0, 0xf7, 0x14	/* t__pfx_mp_irqdomain_create */
	.byte 0x0c, 0x74, 0xb6, 0x5f, 0xab, 0x71, 0x64, 0x6f, 0xd9, 0xf8, 0xf0, 0xf7, 0x14	/* tmp_irqdomain_create */
	.byte 0x0a, 0xef, 0xd9, 0x5e, 0x5f, 0x6c, 0x61, 0xb2, 0xc9, 0xab, 0x71	/* t__pfx_mask_lapic_irq */
	.byte 0x0a, 0x74, 0xd9, 0x5e, 0x5f, 0x6c, 0x61, 0xb2, 0xc9, 0xab, 0x71	/* tmask_lapic_irq */
	.byte 0x0b, 0xef, 0xe4, 0xd9, 0x5e, 0x5f, 0x6c, 0x61, 0xb2, 0xc9, 0xab, 0x71	/* t__pfx_unmask_lapic_irq */
	.byte 0x0b, 0x74, 0xe4, 0xd9, 0x5e, 0x5f, 0x6c, 0x61, 0xb2, 0xc9, 0xab, 0x71	/* tunmask_lapic_irq */
	.byte 0x0c, 0xeb, 0xb6, 0x5f, 0xab, 0x71, 0x64, 0x6f, 0xd9, 0xf8, 0xe6, 0xf7, 0x65	/* T__pfx_mp_irqdomain_free */
	.byte 0x0c, 0x54, 0xb6, 0x5f, 0xab, 0x71, 0x64, 0x6f, 0xd9, 0xf8, 0xe6, 0xf7, 0x65	/* Tmp_irqdomain_free */
	.byte 0x16, 0xef, 0x22, 0xc9, 0xca, 0x61, 0x5f, 0xab, 0x71, 0xe6, 0xe3, 0x6d, 0xed, 0x6f, 0xd9, 0xf8, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__pfx_alloc_isa_irq_from_domain.constprop.0 */
	.byte 0x17, 0xf4, 0x6c, 0xdd, 0xc9, 0xca, 0x61, 0x5f, 0xab, 0x71, 0xe6, 0xe3, 0x6d, 0xed, 0x6f, 0xd9, 0xf8, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* talloc_isa_irq_from_domain.constprop.0 */
	.byte 0x10, 0xef, 0x66, 0xf8, 0xda, 0xab, 0x71, 0x0d, 0xf3, 0x79, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__pfx_find_irq_entry.constprop.0 */
	.byte 0x10, 0x74, 0x66, 0xf8, 0xda, 0xab, 0x71, 0x0d, 0xf3, 0x79, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* tfind_irq_entry.constprop.0 */
	.byte 0x0e, 0xef, 0x22, 0xc9, 0xc0, 0x61, 0xb2, 0x63, 0xf6, 0x61, 0x76, 0x9e, 0xde, 0x0e, 0x73	/* t__pfx_alloc_ioapic_saved_registers */
	.byte 0x0f, 0xf4, 0x6c, 0xdd, 0xc9, 0xc0, 0x61, 0xb2, 0x63, 0xf6, 0x61, 0x76, 0x9e, 0xde, 0x0e, 0x73	/* talloc_ioapic_saved_registers */
	.byte 0x0c, 0xef, 0x3d, 0x72, 0x74, 0xcd, 0x5f, 0xc0, 0x61, 0xb2, 0xc9, 0xab, 0x71	/* t__pfx_startup_ioapic_irq */
	.byte 0x0c, 0x93, 0xf4, 0x72, 0x74, 0xcd, 0x5f, 0xc0, 0x61, 0xb2, 0xc9, 0xab, 0x71	/* tstartup_ioapic_irq */
	.byte 0x0c, 0xeb, 0x73, 0x61, 0x1a, 0xc0, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x69, 0xd6	/* T__pfx_save_ioapic_entries */
	.byte 0x0c, 0x54, 0x73, 0x61, 0x1a, 0xc0, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x69, 0xd6	/* Tsave_ioapic_entries */
	.byte 0x0b, 0xef, 0x65, 0x6f, 0x69, 0x5f, 0xc0, 0x61, 0xb2, 0x63, 0xec, 0xf8	/* t__pfx_eoi_ioapic_pin */
	.byte 0x0a, 0x2c, 0x6f, 0x69, 0x5f, 0xc0, 0x61, 0xb2, 0x63, 0xec, 0xf8	/* teoi_ioapic_pin */
	.byte 0x0d, 0xef, 0xc0, 0x61, 0xb2, 0xc9, 0xab, 0x5f, 0xf2, 0x6b, 0x5f, 0x6c, 0xee, 0xdb	/* t__pfx_ioapic_ir_ack_level */
	.byte 0x0d, 0xdc, 0x6f, 0x61, 0xb2, 0xc9, 0xab, 0x5f, 0xf2, 0x6b, 0x5f, 0x6c, 0xee, 0xdb	/* tioapic_ir_ack_level */
	.byte 0x0a, 0xef, 0xc0, 0x61, 0xb2, 0xc9, 0xd9, 0x5e, 0x0d, 0xf3, 0x79	/* t__pfx_ioapic_mask_entry */
	.byte 0x0a, 0xdc, 0x6f, 0x61, 0xb2, 0xc9, 0xd9, 0x5e, 0x0d, 0xf3, 0x79	/* tioapic_mask_entry */
	.byte 0x0f, 0xeb, 0xb6, 0x5f, 0xab, 0x71, 0x64, 0x6f, 0xd9, 0xf8, 0xed, 0x65, 0xf2, 0xdc, 0x76, 0x14	/* T__pfx_mp_irqdomain_deactivate */
	.byte 0x0f, 0x54, 0xb6, 0x5f, 0xab, 0x71, 0x64, 0x6f, 0xd9, 0xf8, 0xed, 0x65, 0xf2, 0xdc, 0x76, 0x14	/* Tmp_irqdomain_deactivate */
	.byte 0x0a, 0xef, 0xd9, 0x5e, 0x5f, 0xc0, 0x61, 0xb2, 0xc9, 0xab, 0x71	/* t__pfx_mask_ioapic_irq */
	.byte 0x0a, 0x74, 0xd9, 0x5e, 0x5f, 0xc0, 0x61, 0xb2, 0xc9, 0xab, 0x71	/* tmask_ioapic_irq */
	.byte 0x0b, 0xef, 0xe4, 0xd9, 0x5e, 0x5f, 0xc0, 0x61, 0xb2, 0xc9, 0xab, 0x71	/* t__pfx_unmask_ioapic_irq */
	.byte 0x0b, 0x74, 0xe4, 0xd9, 0x5e, 0x5f, 0xc0, 0x61, 0xb2, 0xc9, 0xab, 0x71	/* tunmask_ioapic_irq */
	.byte 0x0d, 0xef, 0xc0, 0x5f, 0x61, 0xb2, 0x63, 0xec, 0x72, 0x27, 0xf1, 0xf3, 0x69, 0xd6	/* t__pfx_io_apic_print_entries */
	.byte 0x0d, 0xdc, 0x6f, 0x5f, 0x61, 0xb2, 0x63, 0xec, 0x72, 0x27, 0xf1, 0xf3, 0x69, 0xd6	/* tio_apic_print_entries */
	.byte 0x0d, 0xef, 0xc0, 0x61, 0xb2, 0x63, 0x3e, 0xa5, 0x67, 0x98, 0xfc, 0xf1, 0xf3, 0x79	/* t__pfx_ioapic_configure_entry */
	.byte 0x0d, 0xdc, 0x6f, 0x61, 0xb2, 0x63, 0x3e, 0xa5, 0x67, 0x98, 0xfc, 0xf1, 0xf3, 0x79	/* tioapic_configure_entry */
	.byte 0x0b, 0xef, 0xc0, 0x61, 0xb2, 0x63, 0x84, 0x61, 0x66, 0x66, 0x0f, 0x79	/* t__pfx_ioapic_set_affinity */
	.byte 0x0b, 0xdc, 0x6f, 0x61, 0xb2, 0x63, 0x84, 0x61, 0x66, 0x66, 0x0f, 0x79	/* tioapic_set_affinity */
	.byte 0x0e, 0xeb, 0xb6, 0x5f, 0xab, 0x71, 0x64, 0x6f, 0xd9, 0xf8, 0x5f, 0xf2, 0xdc, 0x76, 0x14	/* T__pfx_mp_irqdomain_activate */
	.byte 0x0e, 0x54, 0xb6, 0x5f, 0xab, 0x71, 0x64, 0x6f, 0xd9, 0xf8, 0x5f, 0xf2, 0xdc, 0x76, 0x14	/* Tmp_irqdomain_activate */
	.byte 0x0b, 0xef, 0xc0, 0x61, 0xb2, 0xc9, 0xf2, 0x6b, 0x5f, 0x6c, 0xee, 0xdb	/* t__pfx_ioapic_ack_level */
	.byte 0x0b, 0xdc, 0x6f, 0x61, 0xb2, 0xc9, 0xf2, 0x6b, 0x5f, 0x6c, 0xee, 0xdb	/* tioapic_ack_level */
	.byte 0x0e, 0xef, 0x63, 0xc4, 0xc5, 0x5f, 0x49, 0x4f, 0x5f, 0x41, 0x50, 0x49, 0x43, 0xec, 0xf8	/* t__pfx_clear_IO_APIC_pin */
	.byte 0x0d, 0x26, 0xc4, 0xc5, 0x5f, 0x49, 0x4f, 0x5f, 0x41, 0x50, 0x49, 0x43, 0xec, 0xf8	/* tclear_IO_APIC_pin */
	.byte 0x08, 0xeb, 0xb6, 0xc9, 0xc0, 0x61, 0xb2, 0xc9, 0x9f	/* T__pfx_mpc_ioapic_id */
	.byte 0x08, 0x54, 0xb6, 0xc9, 0xc0, 0x61, 0xb2, 0xc9, 0x9f	/* Tmpc_ioapic_id */
	.byte 0x09, 0xeb, 0xb6, 0xc9, 0xc0, 0x61, 0xb2, 0xc9, 0xc8, 0xac	/* T__pfx_mpc_ioapic_addr */
	.byte 0x09, 0x54, 0xb6, 0xc9, 0xc0, 0x61, 0xb2, 0xc9, 0xc8, 0xac	/* Tmpc_ioapic_addr */
	.byte 0x0e, 0xeb, 0x64, 0xca, 0x90, 0xb0, 0xc0, 0x61, 0xb2, 0x63, 0xf6, 0xcd, 0x70, 0xd5, 0x74	/* T__pfx_disable_ioapic_support */
	.byte 0x0e, 0x54, 0x64, 0xca, 0x90, 0xb0, 0xc0, 0x61, 0xb2, 0x63, 0xf6, 0xcd, 0x70, 0xd5, 0x74	/* Tdisable_ioapic_support */
	.byte 0x07, 0xeb, 0xb6, 0xf6, 0x61, 0x1a, 0xab, 0x71	/* T__pfx_mp_save_irq */
	.byte 0x07, 0x54, 0xb6, 0xf6, 0x61, 0x1a, 0xab, 0x71	/* Tmp_save_irq */
	.byte 0x0c, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0xc0, 0x5f, 0x61, 0xb2, 0x63, 0xde, 0xc8	/* T__pfx_native_io_apic_read */
	.byte 0x0c, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0xc0, 0x5f, 0x61, 0xb2, 0x63, 0xde, 0xc8	/* Tnative_io_apic_read */
	.byte 0x0c, 0xeb, 0x63, 0xc4, 0xc5, 0x5f, 0x49, 0x4f, 0x5f, 0x41, 0x50, 0x49, 0x43	/* T__pfx_clear_IO_APIC */
	.byte 0x0c, 0x54, 0x63, 0xc4, 0xc5, 0x5f, 0x49, 0x4f, 0x5f, 0x41, 0x50, 0x49, 0x43	/* Tclear_IO_APIC */
	.byte 0x0c, 0xeb, 0xd9, 0x5e, 0x5f, 0xc0, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x69, 0xd6	/* T__pfx_mask_ioapic_entries */
	.byte 0x0c, 0x54, 0xd9, 0x5e, 0x5f, 0xc0, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x69, 0xd6	/* Tmask_ioapic_entries */
	.byte 0x0d, 0xeb, 0x29, 0x74, 0xd5, 0xfc, 0xc0, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x69, 0xd6	/* T__pfx_restore_ioapic_entries */
	.byte 0x0d, 0x54, 0x29, 0x74, 0xd5, 0xfc, 0xc0, 0x61, 0xb2, 0xc9, 0xf1, 0xf3, 0x69, 0xd6	/* Trestore_ioapic_entries */
	.byte 0x08, 0xef, 0xc0, 0x61, 0xb2, 0x63, 0x07, 0x75, 0xa8	/* t__pfx_ioapic_resume */
	.byte 0x08, 0xdc, 0x6f, 0x61, 0xb2, 0x63, 0x07, 0x75, 0xa8	/* tioapic_resume */
	.byte 0x09, 0xeb, 0xc0, 0x61, 0xb2, 0x63, 0x84, 0x22, 0xc9, 0x24	/* T__pfx_ioapic_set_alloc_attr */
	.byte 0x09, 0x54, 0xc0, 0x61, 0xb2, 0x63, 0x84, 0x22, 0xc9, 0x24	/* Tioapic_set_alloc_attr */
	.byte 0x08, 0xeb, 0xb6, 0x5f, 0xe4, 0x97, 0x5f, 0xab, 0x71	/* T__pfx_mp_unmap_irq */
	.byte 0x08, 0x54, 0xb6, 0x5f, 0xe4, 0x97, 0x5f, 0xab, 0x71	/* Tmp_unmap_irq */
	.byte 0x0b, 0xeb, 0xc0, 0x61, 0xb2, 0xc9, 0x7a, 0x61, 0x70, 0x5f, 0xa4, 0x73	/* T__pfx_ioapic_zap_locks */
	.byte 0x0b, 0x54, 0xc0, 0x61, 0xb2, 0xc9, 0x7a, 0x61, 0x70, 0x5f, 0xa4, 0x73	/* Tioapic_zap_locks */
	.byte 0x12, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0x29, 0x74, 0xd5, 0xfc, 0x62, 0x6f, 0x6f, 0xfe, 0xab, 0x71, 0xc1, 0xb7, 0x65	/* T__pfx_native_restore_boot_irq_mode */
	.byte 0x12, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0x29, 0x74, 0xd5, 0xfc, 0x62, 0x6f, 0x6f, 0xfe, 0xab, 0x71, 0xc1, 0xb7, 0x65	/* Tnative_restore_boot_irq_mode */
	.byte 0x0e, 0xeb, 0x29, 0x74, 0xd5, 0xfc, 0x62, 0x6f, 0x6f, 0xfe, 0xab, 0x71, 0xc1, 0xb7, 0x65	/* T__pfx_restore_boot_irq_mode */
	.byte 0x0e, 0x54, 0x29, 0x74, 0xd5, 0xfc, 0x62, 0x6f, 0x6f, 0xfe, 0xab, 0x71, 0xc1, 0xb7, 0x65	/* Trestore_boot_irq_mode */
	.byte 0x10, 0xeb, 0xc5, 0xba, 0xed, 0x79, 0x6e, 0xab, 0x71, 0x5f, 0xdd, 0x77, 0xf5, 0xb8, 0x6f, 0xe4, 0x64	/* T__pfx_arch_dynirq_lower_bound */
	.byte 0x10, 0x54, 0xc5, 0xba, 0xed, 0x79, 0x6e, 0xab, 0x71, 0x5f, 0xdd, 0x77, 0xf5, 0xb8, 0x6f, 0xe4, 0x64	/* Tarch_dynirq_lower_bound */
	.byte 0x09, 0xeb, 0xb6, 0xe6, 0xf8, 0xda, 0xc0, 0x61, 0xb2, 0x63	/* T__pfx_mp_find_ioapic */
	.byte 0x09, 0x54, 0xb6, 0xe6, 0xf8, 0xda, 0xc0, 0x61, 0xb2, 0x63	/* Tmp_find_ioapic */
	.byte 0x0b, 0xeb, 0xb6, 0xe6, 0xf8, 0xda, 0xc0, 0x61, 0xb2, 0x63, 0xec, 0xf8	/* T__pfx_mp_find_ioapic_pin */
	.byte 0x0b, 0x54, 0xb6, 0xe6, 0xf8, 0xda, 0xc0, 0x61, 0xb2, 0x63, 0xec, 0xf8	/* Tmp_find_ioapic_pin */
	.byte 0x0c, 0x74, 0xaf, 0x5f, 0x5c, 0x86, 0x6f, 0x0b, 0x72, 0x9f, 0xfc, 0xab, 0x71	/* t__pfx___acpi_get_override_irq */
	.byte 0x0b, 0x74, 0xff, 0x5c, 0x86, 0x6f, 0x0b, 0x72, 0x9f, 0xfc, 0xab, 0x71	/* t__acpi_get_override_irq */
	.byte 0x0a, 0xeb, 0x5c, 0x86, 0x6f, 0x0b, 0x72, 0x9f, 0xfc, 0xab, 0x71	/* T__pfx_acpi_get_override_irq */
	.byte 0x0a, 0x54, 0x5c, 0x86, 0x6f, 0x0b, 0x72, 0x9f, 0xfc, 0xab, 0x71	/* Tacpi_get_override_irq */
	.byte 0x0b, 0xef, 0xb6, 0x5f, 0x97, 0xec, 0xf8, 0xa7, 0x6f, 0x5f, 0xab, 0x71	/* t__pfx_mp_map_pin_to_irq */
	.byte 0x0b, 0x74, 0xb6, 0x5f, 0x97, 0xec, 0xf8, 0xa7, 0x6f, 0x5f, 0xab, 0x71	/* tmp_map_pin_to_irq */
	.byte 0x14, 0xeb, 0x49, 0x4f, 0x5f, 0x41, 0x50, 0x49, 0x43, 0x86, 0x50, 0x43, 0x49, 0x5f, 0xab, 0x71, 0x5f, 0x76, 0xb4, 0x74, 0xd5	/* T__pfx_IO_APIC_get_PCI_irq_vector */
	.byte 0x14, 0x54, 0x49, 0x4f, 0x5f, 0x41, 0x50, 0x49, 0x43, 0x86, 0x50, 0x43, 0x49, 0x5f, 0xab, 0x71, 0x5f, 0x76, 0xb4, 0x74, 0xd5	/* TIO_APIC_get_PCI_irq_vector */
	.byte 0x0c, 0xeb, 0xb6, 0x5f, 0xab, 0x71, 0x64, 0x6f, 0xd9, 0xf8, 0x5f, 0x22, 0x63	/* T__pfx_mp_irqdomain_alloc */
	.byte 0x0c, 0x54, 0xb6, 0x5f, 0xab, 0x71, 0x64, 0x6f, 0xd9, 0xf8, 0x5f, 0x22, 0x63	/* Tmp_irqdomain_alloc */
	.byte 0x0b, 0xeb, 0xb6, 0x5f, 0x97, 0xc7, 0x85, 0xa7, 0x6f, 0x5f, 0xab, 0x71	/* T__pfx_mp_map_gsi_to_irq */
	.byte 0x0b, 0x54, 0xb6, 0x5f, 0x97, 0xc7, 0x85, 0xa7, 0x6f, 0x5f, 0xab, 0x71	/* Tmp_map_gsi_to_irq */
	.byte 0x09, 0xeb, 0xb6, 0xde, 0x0e, 0x5f, 0xc0, 0x61, 0xb2, 0x63	/* T__pfx_mp_register_ioapic */
	.byte 0x09, 0x54, 0xb6, 0xde, 0x0e, 0x5f, 0xc0, 0x61, 0xb2, 0x63	/* Tmp_register_ioapic */
	.byte 0x0b, 0xeb, 0xb6, 0x5f, 0xe4, 0xf7, 0x0e, 0x5f, 0xc0, 0x61, 0xb2, 0x63	/* T__pfx_mp_unregister_ioapic */
	.byte 0x0b, 0x54, 0xb6, 0x5f, 0xe4, 0xf7, 0x0e, 0x5f, 0xc0, 0x61, 0xb2, 0x63	/* Tmp_unregister_ioapic */
	.byte 0x0c, 0xeb, 0xb6, 0x5f, 0xc0, 0x61, 0xb2, 0x63, 0xde, 0x13, 0x2c, 0xf7, 0x64	/* T__pfx_mp_ioapic_registered */
	.byte 0x0c, 0x54, 0xb6, 0x5f, 0xc0, 0x61, 0xb2, 0x63, 0xde, 0x13, 0x2c, 0xf7, 0x64	/* Tmp_ioapic_registered */
	.byte 0x10, 0xeb, 0xb6, 0x5f, 0xab, 0x71, 0x64, 0x6f, 0xd9, 0xf8, 0x5f, 0xc0, 0x61, 0xb2, 0xc9, 0x9f, 0x78	/* T__pfx_mp_irqdomain_ioapic_idx */
	.byte 0x10, 0x54, 0xb6, 0x5f, 0xab, 0x71, 0x64, 0x6f, 0xd9, 0xf8, 0x5f, 0xc0, 0x61, 0xb2, 0xc9, 0x9f, 0x78	/* Tmp_irqdomain_ioapic_idx */
	.byte 0x0c, 0xef, 0x78, 0x38, 0x36, 0xbf, 0x9d, 0xb5, 0xc1, 0x85, 0xbf, 0x66, 0x6f	/* t__pfx_x86_init_dev_msi_info */
	.byte 0x0c, 0x74, 0x78, 0x38, 0x36, 0xbf, 0x9d, 0xb5, 0xc1, 0x85, 0xbf, 0x66, 0x6f	/* tx86_init_dev_msi_info */
	.byte 0x0b, 0xef, 0x78, 0x38, 0x36, 0xc1, 0x85, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* t__pfx_x86_msi_prepare */
	.byte 0x0b, 0x74, 0x78, 0x38, 0x36, 0xc1, 0x85, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* tx86_msi_prepare */
	.byte 0x0a, 0xeb, 0x70, 0x9b, 0xc1, 0x85, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* T__pfx_pci_msi_prepare */
	.byte 0x0a, 0x54, 0x70, 0x9b, 0xc1, 0x85, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* Tpci_msi_prepare */
	.byte 0x0e, 0xef, 0x64, 0xd9, 0x72, 0xc1, 0x85, 0x3a, 0xb6, 0x6f, 0x73, 0xfc, 0x6d, 0x73, 0x67	/* t__pfx_dmar_msi_compose_msg */
	.byte 0x0e, 0x74, 0x64, 0xd9, 0x72, 0xc1, 0x85, 0x3a, 0xb6, 0x6f, 0x73, 0xfc, 0x6d, 0x73, 0x67	/* tdmar_msi_compose_msg */
	.byte 0x0c, 0xef, 0x64, 0xd9, 0x72, 0xc1, 0x85, 0x92, 0x3c, 0xfc, 0x6d, 0x73, 0x67	/* t__pfx_dmar_msi_write_msg */
	.byte 0x0c, 0x74, 0x64, 0xd9, 0x72, 0xc1, 0x85, 0x92, 0x3c, 0xfc, 0x6d, 0x73, 0x67	/* tdmar_msi_write_msg */
	.byte 0x08, 0xef, 0x64, 0xd9, 0x72, 0xc1, 0x85, 0xbf, 0xea	/* t__pfx_dmar_msi_init */
	.byte 0x08, 0x74, 0x64, 0xd9, 0x72, 0xc1, 0x85, 0xbf, 0xea	/* tdmar_msi_init */
	.byte 0x09, 0xef, 0x6d, 0x85, 0x84, 0x61, 0x66, 0x66, 0x0f, 0x79	/* t__pfx_msi_set_affinity */
	.byte 0x09, 0x74, 0x6d, 0x85, 0x84, 0x61, 0x66, 0x66, 0x0f, 0x79	/* tmsi_set_affinity */
	.byte 0x17, 0xeb, 0x70, 0x9b, 0x2b, 0xa3, 0xbb, 0xed, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x6d, 0x85, 0xec, 0x61, 0xf7, 0x6e, 0xfe, 0x64, 0x6f, 0xd9, 0xf8	/* T__pfx_pci_dev_has_default_msi_parent_domain */
	.byte 0x17, 0x54, 0x70, 0x9b, 0x2b, 0xa3, 0xbb, 0xed, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x6d, 0x85, 0xec, 0x61, 0xf7, 0x6e, 0xfe, 0x64, 0x6f, 0xd9, 0xf8	/* Tpci_dev_has_default_msi_parent_domain */
	.byte 0x0b, 0xeb, 0x64, 0xd9, 0x72, 0x5f, 0x22, 0xc9, 0x68, 0x77, 0xab, 0x71	/* T__pfx_dmar_alloc_hwirq */
	.byte 0x0b, 0x54, 0x64, 0xd9, 0x72, 0x5f, 0x22, 0xc9, 0x68, 0x77, 0xab, 0x71	/* Tdmar_alloc_hwirq */
	.byte 0x0b, 0xeb, 0x64, 0xd9, 0x72, 0xe6, 0xf7, 0xfc, 0x68, 0x77, 0xab, 0x71	/* T__pfx_dmar_free_hwirq */
	.byte 0x0b, 0x54, 0x64, 0xd9, 0x72, 0xe6, 0xf7, 0xfc, 0x68, 0x77, 0xab, 0x71	/* Tdmar_free_hwirq */
	.byte 0x0d, 0xeb, 0xc5, 0xba, 0x07, 0x74, 0xd5, 0xfc, 0x6d, 0x85, 0x5f, 0xab, 0x71, 0x73	/* T__pfx_arch_restore_msi_irqs */
	.byte 0x0d, 0x54, 0xc5, 0xba, 0x07, 0x74, 0xd5, 0xfc, 0x6d, 0x85, 0x5f, 0xab, 0x71, 0x73	/* Tarch_restore_msi_irqs */
	.byte 0x0d, 0xef, 0x6e, 0xe8, 0x69, 0x1a, 0x61, 0xb2, 0xc9, 0xa8, 0xae, 0x77, 0x3c, 0x65	/* t__pfx_native_apic_mem_write */
	.byte 0x0d, 0x74, 0x6e, 0xe8, 0x69, 0x1a, 0x61, 0xb2, 0xc9, 0xa8, 0xae, 0x77, 0x3c, 0x65	/* tnative_apic_mem_write */
	.byte 0x0c, 0xef, 0x6e, 0xe8, 0x69, 0x1a, 0x61, 0xb2, 0xc9, 0xa8, 0x6d, 0xde, 0xc8	/* t__pfx_native_apic_mem_read */
	.byte 0x0c, 0x74, 0x6e, 0xe8, 0x69, 0x1a, 0x61, 0xb2, 0xc9, 0xa8, 0x6d, 0xde, 0xc8	/* tnative_apic_mem_read */
	.byte 0x0d, 0xef, 0x6e, 0xe8, 0x69, 0x1a, 0x61, 0xb2, 0xc9, 0xa8, 0xae, 0x65, 0x6f, 0x69	/* t__pfx_native_apic_mem_eoi */
	.byte 0x0d, 0x74, 0x6e, 0xe8, 0x69, 0x1a, 0x61, 0xb2, 0xc9, 0xa8, 0xae, 0x65, 0x6f, 0x69	/* tnative_apic_mem_eoi */
	.byte 0x0f, 0xef, 0x70, 0x68, 0x79, 0x73, 0x66, 0x6c, 0x61, 0xfe, 0x67, 0xe2, 0x61, 0xb2, 0xc9, 0x9f	/* t__pfx_physflat_get_apic_id */
	.byte 0x0e, 0xce, 0x68, 0x79, 0x73, 0x66, 0x6c, 0x61, 0xfe, 0x67, 0xe2, 0x61, 0xb2, 0xc9, 0x9f	/* tphysflat_get_apic_id */
	.byte 0x0c, 0xef, 0x70, 0x68, 0x79, 0x73, 0x66, 0x6c, 0x61, 0xfe, 0x70, 0x8c, 0x65	/* t__pfx_physflat_probe */
	.byte 0x0b, 0xce, 0x68, 0x79, 0x73, 0x66, 0x6c, 0x61, 0xfe, 0x70, 0x8c, 0x65	/* tphysflat_probe */
	.byte 0x14, 0xef, 0x70, 0x68, 0x79, 0x73, 0x66, 0x6c, 0x61, 0xfe, 0x5c, 0x5f, 0xd9, 0x64, 0xfe, 0x6f, 0x65, 0x6d, 0x25, 0x65, 0xc6	/* t__pfx_physflat_acpi_madt_oem_check */
	.byte 0x13, 0xce, 0x68, 0x79, 0x73, 0x66, 0x6c, 0x61, 0xfe, 0x5c, 0x5f, 0xd9, 0x64, 0xfe, 0x6f, 0x65, 0x6d, 0x25, 0x65, 0xc6	/* tphysflat_acpi_madt_oem_check */
	.byte 0x0b, 0xeb, 0xc3, 0x63, 0xa4, 0x5f, 0x78, 0x38, 0x36, 0xa7, 0x73, 0x63	/* T__pfx_trace_clock_x86_tsc */
	.byte 0x0b, 0x54, 0xc3, 0x63, 0xa4, 0x5f, 0x78, 0x38, 0x36, 0xa7, 0x73, 0x63	/* Ttrace_clock_x86_tsc */
	.byte 0x10, 0x54, 0xc5, 0xba, 0xde, 0x74, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0xf3, 0x61, 0xb6, 0xa0, 0xf8, 0x65	/* Tarch_rethook_trampoline */
	.byte 0x11, 0xeb, 0xc5, 0xba, 0xde, 0x74, 0x68, 0x6f, 0x6f, 0x6b, 0xe6, 0x69, 0x78, 0xcd, 0xde, 0x74, 0x98, 0x6e	/* T__pfx_arch_rethook_fixup_return */
	.byte 0x11, 0x54, 0xc5, 0xba, 0xde, 0x74, 0x68, 0x6f, 0x6f, 0x6b, 0xe6, 0x69, 0x78, 0xcd, 0xde, 0x74, 0x98, 0x6e	/* Tarch_rethook_fixup_return */
	.byte 0x0e, 0xeb, 0xc5, 0xba, 0xde, 0x74, 0x68, 0x6f, 0x6f, 0x6b, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* T__pfx_arch_rethook_prepare */
	.byte 0x0e, 0x54, 0xc5, 0xba, 0xde, 0x74, 0x68, 0x6f, 0x6f, 0x6b, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* Tarch_rethook_prepare */
	.byte 0x15, 0xeb, 0xc5, 0xba, 0xde, 0x74, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0xf3, 0x61, 0xb6, 0xa0, 0xf8, 0xfc, 0x63, 0x5d, 0x62, 0xf2, 0x6b	/* T__pfx_arch_rethook_trampoline_callback */
	.byte 0x15, 0x54, 0xc5, 0xba, 0xde, 0x74, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0xf3, 0x61, 0xb6, 0xa0, 0xf8, 0xfc, 0x63, 0x5d, 0x62, 0xf2, 0x6b	/* Tarch_rethook_trampoline_callback */
	.byte 0x11, 0xeb, 0xc5, 0xba, 0xf0, 0xbc, 0x73, 0x68, 0xf6, 0x61, 0x1a, 0x76, 0x6d, 0x03, 0xf7, 0xf8, 0x66, 0x6f	/* T__pfx_arch_crash_save_vmcoreinfo */
	.byte 0x11, 0x54, 0xc5, 0xba, 0xf0, 0xbc, 0x73, 0x68, 0xf6, 0x61, 0x1a, 0x76, 0x6d, 0x03, 0xf7, 0xf8, 0x66, 0x6f	/* Tarch_crash_save_vmcoreinfo */
	.byte 0x0c, 0xef, 0xa8, 0x6d, 0xde, 0x67, 0x69, 0xe7, 0xf0, 0x5d, 0x62, 0xf2, 0x6b	/* t__pfx_mem_region_callback */
	.byte 0x0c, 0x74, 0xa8, 0x6d, 0xde, 0x67, 0x69, 0xe7, 0xf0, 0x5d, 0x62, 0xf2, 0x6b	/* tmem_region_callback */
	.byte 0x09, 0xef, 0x22, 0x63, 0xec, 0x67, 0xfe, 0x70, 0x83, 0x65	/* t__pfx_alloc_pgt_page */
	.byte 0x0a, 0xf4, 0x6c, 0xdd, 0x63, 0xec, 0x67, 0xfe, 0x70, 0x83, 0x65	/* talloc_pgt_page */
	.byte 0x10, 0xef, 0x6b, 0xcb, 0x65, 0xc9, 0xd9, 0x72, 0x6b, 0xa6, 0xd2, 0x67, 0x65, 0x2e, 0xca, 0xbc, 0x7e	/* t__pfx_kexec_mark_range.isra.0 */
	.byte 0x10, 0x74, 0x6b, 0xcb, 0x65, 0xc9, 0xd9, 0x72, 0x6b, 0xa6, 0xd2, 0x67, 0x65, 0x2e, 0xca, 0xbc, 0x7e	/* tkexec_mark_range.isra.0 */
	.byte 0x0e, 0xef, 0x6b, 0xcb, 0x65, 0xc9, 0xd9, 0x72, 0x6b, 0xf0, 0xbc, 0x73, 0x68, 0x6b, 0x29	/* t__pfx_kexec_mark_crashkres */
	.byte 0x0e, 0x74, 0x6b, 0xcb, 0x65, 0xc9, 0xd9, 0x72, 0x6b, 0xf0, 0xbc, 0x73, 0x68, 0x6b, 0x29	/* tkexec_mark_crashkres */
	.byte 0x0e, 0xeb, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x6b, 0xcb, 0xb4, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* T__pfx_machine_kexec_prepare */
	.byte 0x0e, 0x54, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x6b, 0xcb, 0xb4, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* Tmachine_kexec_prepare */
	.byte 0x0d, 0xeb, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x6b, 0xcb, 0xb4, 0xf0, 0xc4, 0xd2, 0xcd	/* T__pfx_machine_kexec_cleanup */
	.byte 0x0d, 0x54, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x6b, 0xcb, 0xb4, 0xf0, 0xc4, 0xd2, 0xcd	/* Tmachine_kexec_cleanup */
	.byte 0x09, 0xeb, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x6b, 0xcb, 0xb4	/* T__pfx_machine_kexec */
	.byte 0x09, 0x54, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x6b, 0xcb, 0xb4	/* Tmachine_kexec */
	.byte 0x12, 0xeb, 0xc5, 0xba, 0x5f, 0x6b, 0xcb, 0xb4, 0xec, 0xe3, 0x74, 0xb4, 0xfe, 0x63, 0xbc, 0x73, 0x68, 0x6b, 0x29	/* T__pfx_arch_kexec_protect_crashkres */
	.byte 0x12, 0x54, 0xc5, 0xba, 0x5f, 0x6b, 0xcb, 0xb4, 0xec, 0xe3, 0x74, 0xb4, 0xfe, 0x63, 0xbc, 0x73, 0x68, 0x6b, 0x29	/* Tarch_kexec_protect_crashkres */
	.byte 0x14, 0xeb, 0xc5, 0xba, 0x5f, 0x6b, 0xcb, 0x65, 0xc9, 0xe4, 0x70, 0xe3, 0x74, 0xb4, 0xfe, 0x63, 0xbc, 0x73, 0x68, 0x6b, 0x29	/* T__pfx_arch_kexec_unprotect_crashkres */
	.byte 0x14, 0x54, 0xc5, 0xba, 0x5f, 0x6b, 0xcb, 0x65, 0xc9, 0xe4, 0x70, 0xe3, 0x74, 0xb4, 0xfe, 0x63, 0xbc, 0x73, 0x68, 0x6b, 0x29	/* Tarch_kexec_unprotect_crashkres */
	.byte 0x10, 0xeb, 0xc5, 0xba, 0x5f, 0x6b, 0xcb, 0xb4, 0xec, 0x6f, 0x73, 0xfe, 0x22, 0x63, 0xec, 0x83, 0xd6	/* T__pfx_arch_kexec_post_alloc_pages */
	.byte 0x10, 0x54, 0xc5, 0xba, 0x5f, 0x6b, 0xcb, 0xb4, 0xec, 0x6f, 0x73, 0xfe, 0x22, 0x63, 0xec, 0x83, 0xd6	/* Tarch_kexec_post_alloc_pages */
	.byte 0x10, 0xeb, 0xc5, 0xba, 0x5f, 0x6b, 0xcb, 0xb4, 0xec, 0x72, 0xfc, 0x66, 0xf7, 0xfc, 0x70, 0x83, 0xd6	/* T__pfx_arch_kexec_pre_free_pages */
	.byte 0x10, 0x54, 0xc5, 0xba, 0x5f, 0x6b, 0xcb, 0xb4, 0xec, 0x72, 0xfc, 0x66, 0xf7, 0xfc, 0x70, 0x83, 0xd6	/* Tarch_kexec_pre_free_pages */
	.byte 0x09, 0x54, 0xf7, 0xdd, 0x63, 0x91, 0x6b, 0xf5, 0x6e, 0xdb	/* Trelocate_kernel */
	.byte 0x09, 0x54, 0xf7, 0xdd, 0x63, 0x91, 0x72, 0xd2, 0x67, 0x65	/* Trelocate_range */
	.byte 0x09, 0xdc, 0x64, 0xf1, 0x74, 0xea, 0x1d, 0x97, 0x70, 0x9e	/* tidentity_mapped */
	.byte 0x0a, 0x74, 0x76, 0xab, 0x74, 0x75, 0xe5, 0x5f, 0x97, 0x70, 0x9e	/* tvirtual_mapped */
	.byte 0x07, 0x93, 0x77, 0x61, 0x70, 0xec, 0x83, 0xd6	/* tswap_pages */
	.byte 0x0c, 0x74, 0xaf, 0xf0, 0xbe, 0x1d, 0xa0, 0x64, 0xa8, 0x6d, 0xec, 0x83, 0x65	/* t__pfx___copy_oldmem_page */
	.byte 0x0c, 0x74, 0xff, 0x63, 0xbe, 0x1d, 0xa0, 0x64, 0xa8, 0x6d, 0xec, 0x83, 0x65	/* t__copy_oldmem_page */
	.byte 0x0b, 0xeb, 0x63, 0xbe, 0x1d, 0xa0, 0x64, 0xa8, 0x6d, 0xec, 0x83, 0x65	/* T__pfx_copy_oldmem_page */
	.byte 0x0b, 0x54, 0x63, 0xbe, 0x1d, 0xa0, 0x64, 0xa8, 0x6d, 0xec, 0x83, 0x65	/* Tcopy_oldmem_page */
	.byte 0x11, 0xeb, 0x63, 0xbe, 0x1d, 0xa0, 0x64, 0xa8, 0x6d, 0xec, 0x83, 0xfc, 0xf1, 0x63, 0x72, 0x21, 0x74, 0x9e	/* T__pfx_copy_oldmem_page_encrypted */
	.byte 0x11, 0x54, 0x63, 0xbe, 0x1d, 0xa0, 0x64, 0xa8, 0x6d, 0xec, 0x83, 0xfc, 0xf1, 0x63, 0x72, 0x21, 0x74, 0x9e	/* Tcopy_oldmem_page_encrypted */
	.byte 0x09, 0xeb, 0xdb, 0x66, 0x03, 0xf7, 0x68, 0xac, 0xde, 0xc8	/* T__pfx_elfcorehdr_read */
	.byte 0x09, 0x54, 0xdb, 0x66, 0x03, 0xf7, 0x68, 0xac, 0xde, 0xc8	/* Telfcorehdr_read */
	.byte 0x11, 0xef, 0x67, 0xe2, 0x6e, 0x72, 0x5f, 0xbc, 0xae, 0x72, 0xd2, 0x67, 0xd6, 0xf0, 0x5d, 0x62, 0xf2, 0x6b	/* t__pfx_get_nr_ram_ranges_callback */
	.byte 0x11, 0x74, 0x67, 0xe2, 0x6e, 0x72, 0x5f, 0xbc, 0xae, 0x72, 0xd2, 0x67, 0xd6, 0xf0, 0x5d, 0x62, 0xf2, 0x6b	/* tget_nr_ram_ranges_callback */
	.byte 0x17, 0xef, 0x70, 0xf7, 0x70, 0xc5, 0xfc, 0xdb, 0x66, 0x36, 0x34, 0x5f, 0xbc, 0xae, 0x68, 0x65, 0xc8, 0xf5, 0x73, 0xf0, 0x5d, 0x62, 0xf2, 0x6b	/* t__pfx_prepare_elf64_ram_headers_callback */
	.byte 0x16, 0xce, 0xf7, 0x70, 0xc5, 0xfc, 0xdb, 0x66, 0x36, 0x34, 0x5f, 0xbc, 0xae, 0x68, 0x65, 0xc8, 0xf5, 0x73, 0xf0, 0x5d, 0x62, 0xf2, 0x6b	/* tprepare_elf64_ram_headers_callback */
	.byte 0x0d, 0xef, 0x6b, 0x64, 0x75, 0xb6, 0xbd, 0x6d, 0x69, 0xf0, 0x5d, 0x62, 0xf2, 0x6b	/* t__pfx_kdump_nmi_callback */
	.byte 0x0d, 0x74, 0x6b, 0x64, 0x75, 0xb6, 0xbd, 0x6d, 0x69, 0xf0, 0x5d, 0x62, 0xf2, 0x6b	/* tkdump_nmi_callback */
	.byte 0x13, 0xeb, 0x6b, 0x64, 0x75, 0xb6, 0xbd, 0x6d, 0x69, 0xf6, 0x68, 0x6f, 0x6f, 0x74, 0x64, 0xad, 0x6e, 0xf0, 0x70, 0xb1	/* T__pfx_kdump_nmi_shootdown_cpus */
	.byte 0x13, 0x54, 0x6b, 0x64, 0x75, 0xb6, 0xbd, 0x6d, 0x69, 0xf6, 0x68, 0x6f, 0x6f, 0x74, 0x64, 0xad, 0x6e, 0xf0, 0x70, 0xb1	/* Tkdump_nmi_shootdown_cpus */
	.byte 0x0d, 0xeb, 0x63, 0xbc, 0x73, 0x68, 0xf6, 0xb6, 0xf6, 0xf1, 0x64, 0xf6, 0x74, 0xbe	/* T__pfx_crash_smp_send_stop */
	.byte 0x0d, 0x54, 0x63, 0xbc, 0x73, 0x68, 0xf6, 0xb6, 0xf6, 0xf1, 0x64, 0xf6, 0x74, 0xbe	/* Tcrash_smp_send_stop */
	.byte 0x14, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x63, 0xbc, 0x73, 0x68, 0xf6, 0x68, 0x20, 0x64, 0xad, 0x6e	/* T__pfx_native_machine_crash_shutdown */
	.byte 0x14, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0x6d, 0xf2, 0x68, 0xf8, 0xfc, 0x63, 0xbc, 0x73, 0x68, 0xf6, 0x68, 0x20, 0x64, 0xad, 0x6e	/* Tnative_machine_crash_shutdown */
	.byte 0x12, 0xeb, 0xc5, 0xba, 0xf0, 0xbc, 0x73, 0x68, 0xa3, 0x6f, 0xce, 0x6c, 0x75, 0x67, 0xf6, 0xcd, 0x70, 0xd5, 0x74	/* T__pfx_arch_crash_hotplug_support */
	.byte 0x12, 0x54, 0xc5, 0xba, 0xf0, 0xbc, 0x73, 0x68, 0xa3, 0x6f, 0xce, 0x6c, 0x75, 0x67, 0xf6, 0xcd, 0x70, 0xd5, 0x74	/* Tarch_crash_hotplug_support */
	.byte 0x12, 0xeb, 0xc5, 0xba, 0xf0, 0xbc, 0x73, 0x68, 0x86, 0xdb, 0x66, 0x03, 0xf7, 0x68, 0xac, 0xf6, 0x69, 0x7a, 0x65	/* T__pfx_arch_crash_get_elfcorehdr_size */
	.byte 0x12, 0x54, 0xc5, 0xba, 0xf0, 0xbc, 0x73, 0x68, 0x86, 0xdb, 0x66, 0x03, 0xf7, 0x68, 0xac, 0xf6, 0x69, 0x7a, 0x65	/* Tarch_crash_get_elfcorehdr_size */
	.byte 0x13, 0xeb, 0xc5, 0xba, 0xf0, 0xbc, 0x73, 0x68, 0xa3, 0x05, 0xb0, 0x68, 0x6f, 0xce, 0x6c, 0x75, 0x67, 0x5f, 0xd7, 0x74	/* T__pfx_arch_crash_handle_hotplug_event */
	.byte 0x13, 0x54, 0xc5, 0xba, 0xf0, 0xbc, 0x73, 0x68, 0xa3, 0x05, 0xb0, 0x68, 0x6f, 0xce, 0x6c, 0x75, 0x67, 0x5f, 0xd7, 0x74	/* Tarch_crash_handle_hotplug_event */
	.byte 0x0e, 0xeb, 0xe1, 0x6e, 0x74, 0x68, 0xd6, 0x69, 0x7a, 0xfc, 0xf7, 0x6c, 0x6a, 0x75, 0xb6	/* T__pfx_synthesize_reljump */
	.byte 0x0e, 0x54, 0xe1, 0x6e, 0x74, 0x68, 0xd6, 0x69, 0x7a, 0xfc, 0xf7, 0x6c, 0x6a, 0x75, 0xb6	/* Tsynthesize_reljump */
	.byte 0x0d, 0xeb, 0xe1, 0x6e, 0x74, 0x68, 0xd6, 0x69, 0x7a, 0xfc, 0xf7, 0x6c, 0x63, 0x5d	/* T__pfx_synthesize_relcall */
	.byte 0x0d, 0x54, 0xe1, 0x6e, 0x74, 0x68, 0xd6, 0x69, 0x7a, 0xfc, 0xf7, 0x6c, 0x63, 0x5d	/* Tsynthesize_relcall */
	.byte 0x11, 0xef, 0x6b, 0x70, 0x8c, 0xfc, 0x65, 0x6d, 0x02, 0x91, 0x69, 0x66, 0x6d, 0xb7, 0x69, 0xa5, 0xf5, 0x73	/* t__pfx_kprobe_emulate_ifmodifiers */
	.byte 0x11, 0x74, 0x6b, 0x70, 0x8c, 0xfc, 0x65, 0x6d, 0x02, 0x91, 0x69, 0x66, 0x6d, 0xb7, 0x69, 0xa5, 0xf5, 0x73	/* tkprobe_emulate_ifmodifiers */
	.byte 0x0b, 0xef, 0x6b, 0x70, 0x8c, 0xfc, 0x65, 0x6d, 0x02, 0x91, 0xf7, 0x74	/* t__pfx_kprobe_emulate_ret */
	.byte 0x0b, 0x74, 0x6b, 0x70, 0x8c, 0xfc, 0x65, 0x6d, 0x02, 0x91, 0xf7, 0x74	/* tkprobe_emulate_ret */
	.byte 0x0b, 0xef, 0x6b, 0x70, 0x8c, 0xfc, 0x65, 0x6d, 0x02, 0x91, 0x63, 0x5d	/* t__pfx_kprobe_emulate_call */
	.byte 0x0b, 0x74, 0x6b, 0x70, 0x8c, 0xfc, 0x65, 0x6d, 0x02, 0x91, 0x63, 0x5d	/* tkprobe_emulate_call */
	.byte 0x0b, 0xef, 0x6b, 0x70, 0x8c, 0xfc, 0x65, 0x6d, 0x02, 0x91, 0x6a, 0xb6	/* t__pfx_kprobe_emulate_jmp */
	.byte 0x0b, 0x74, 0x6b, 0x70, 0x8c, 0xfc, 0x65, 0x6d, 0x02, 0x91, 0x6a, 0xb6	/* tkprobe_emulate_jmp */
	.byte 0x0c, 0xef, 0x6b, 0x70, 0x8c, 0xfc, 0x65, 0x6d, 0x02, 0x91, 0x6a, 0x63, 0x63	/* t__pfx_kprobe_emulate_jcc */
	.byte 0x0c, 0x74, 0x6b, 0x70, 0x8c, 0xfc, 0x65, 0x6d, 0x02, 0x91, 0x6a, 0x63, 0x63	/* tkprobe_emulate_jcc */
	.byte 0x0b, 0xef, 0x6b, 0x70, 0x8c, 0xfc, 0x65, 0x6d, 0x02, 0x91, 0xdd, 0xbe	/* t__pfx_kprobe_emulate_loop */
	.byte 0x0b, 0x74, 0x6b, 0x70, 0x8c, 0xfc, 0x65, 0x6d, 0x02, 0x91, 0xdd, 0xbe	/* tkprobe_emulate_loop */
	.byte 0x0b, 0xef, 0x29, 0x75, 0x6d, 0xfc, 0x73, 0x8d, 0x6c, 0x60, 0x65, 0x70	/* t__pfx_resume_singlestep */
	.byte 0x0b, 0x74, 0x29, 0x75, 0x6d, 0xfc, 0x73, 0x8d, 0x6c, 0x60, 0x65, 0x70	/* tresume_singlestep */
	.byte 0x11, 0xef, 0x6b, 0x70, 0x8c, 0xfc, 0x65, 0x6d, 0x02, 0x91, 0x63, 0x5d, 0xbf, 0x64, 0x69, 0xf7, 0x63, 0x74	/* t__pfx_kprobe_emulate_call_indirect */
	.byte 0x11, 0x74, 0x6b, 0x70, 0x8c, 0xfc, 0x65, 0x6d, 0x02, 0x91, 0x63, 0x5d, 0xbf, 0x64, 0x69, 0xf7, 0x63, 0x74	/* tkprobe_emulate_call_indirect */
	.byte 0x11, 0xef, 0x6b, 0x70, 0x8c, 0xfc, 0x65, 0x6d, 0x02, 0x91, 0x6a, 0xb6, 0xbf, 0x64, 0x69, 0xf7, 0x63, 0x74	/* t__pfx_kprobe_emulate_jmp_indirect */
	.byte 0x11, 0x74, 0x6b, 0x70, 0x8c, 0xfc, 0x65, 0x6d, 0x02, 0x91, 0x6a, 0xb6, 0xbf, 0x64, 0x69, 0xf7, 0x63, 0x74	/* tkprobe_emulate_jmp_indirect */
	.byte 0x0d, 0xeb, 0x6b, 0x70, 0x8c, 0xfc, 0x66, 0x61, 0x02, 0xfe, 0x68, 0x05, 0x6c, 0xf5	/* T__pfx_kprobe_fault_handler */
	.byte 0x0d, 0x54, 0x6b, 0x70, 0x8c, 0xfc, 0x66, 0x61, 0x02, 0xfe, 0x68, 0x05, 0x6c, 0xf5	/* Tkprobe_fault_handler */
	.byte 0x0e, 0xef, 0x6b, 0x70, 0x8c, 0xfc, 0x70, 0x6f, 0x73, 0xfe, 0x70, 0xe3, 0x63, 0xd6, 0x73	/* t__pfx_kprobe_post_process */
	.byte 0x0e, 0x74, 0x6b, 0x70, 0x8c, 0xfc, 0x70, 0x6f, 0x73, 0xfe, 0x70, 0xe3, 0x63, 0xd6, 0x73	/* tkprobe_post_process */
	.byte 0x0a, 0xef, 0x73, 0xd4, 0xcd, 0xf6, 0x8d, 0x6c, 0x60, 0x65, 0x70	/* t__pfx_setup_singlestep */
	.byte 0x09, 0x93, 0xd4, 0xcd, 0xf6, 0x8d, 0x6c, 0x60, 0x65, 0x70	/* tsetup_singlestep */
	.byte 0x09, 0xef, 0xf7, 0xf1, 0xa2, 0x5f, 0x6b, 0x70, 0x8c, 0x65	/* t__pfx_reenter_kprobe */
	.byte 0x09, 0x74, 0xf7, 0xf1, 0xa2, 0x5f, 0x6b, 0x70, 0x8c, 0x65	/* treenter_kprobe */
	.byte 0x0b, 0xeb, 0x6b, 0x70, 0x8c, 0xfc, 0xb3, 0x33, 0xa3, 0x05, 0x6c, 0xf5	/* T__pfx_kprobe_int3_handler */
	.byte 0x0b, 0x54, 0x6b, 0x70, 0x8c, 0xfc, 0xb3, 0x33, 0xa3, 0x05, 0x6c, 0xf5	/* Tkprobe_int3_handler */
	.byte 0x08, 0xeb, 0x63, 0xd2, 0xb8, 0x6f, 0x6f, 0x73, 0x74	/* T__pfx_can_boost */
	.byte 0x08, 0x54, 0x63, 0xd2, 0xb8, 0x6f, 0x6f, 0x73, 0x74	/* Tcan_boost */
	.byte 0x0f, 0xeb, 0xf7, 0x03, 0x0b, 0xec, 0x8c, 0x65, 0xda, 0xf8, 0x73, 0xf3, 0x75, 0x63, 0xdc, 0xe7	/* T__pfx_recover_probed_instruction */
	.byte 0x0f, 0x54, 0xf7, 0x03, 0x0b, 0xec, 0x8c, 0x65, 0xda, 0xf8, 0x73, 0xf3, 0x75, 0x63, 0xdc, 0xe7	/* Trecover_probed_instruction */
	.byte 0x06, 0xef, 0x63, 0xd2, 0xec, 0x8c, 0x65	/* t__pfx_can_probe */
	.byte 0x05, 0x26, 0xd2, 0xec, 0x8c, 0x65	/* tcan_probe */
	.byte 0x0e, 0xeb, 0xc5, 0xba, 0x5f, 0xc8, 0x6a, 0xb1, 0xfe, 0x6b, 0x70, 0x8c, 0xfc, 0xc8, 0xac	/* T__pfx_arch_adjust_kprobe_addr */
	.byte 0x0e, 0x54, 0xc5, 0xba, 0x5f, 0xc8, 0x6a, 0xb1, 0xfe, 0x6b, 0x70, 0x8c, 0xfc, 0xc8, 0xac	/* Tarch_adjust_kprobe_addr */
	.byte 0x0b, 0x99, 0xf0, 0xbe, 0x79, 0xbf, 0x73, 0xf3, 0x75, 0x63, 0xdc, 0xe7	/* T__pfx___copy_instruction */
	.byte 0x0b, 0xb9, 0x63, 0xbe, 0x79, 0xbf, 0x73, 0xf3, 0x75, 0x63, 0xdc, 0xe7	/* T__copy_instruction */
	.byte 0x0a, 0xef, 0xc5, 0xba, 0xf0, 0xbe, 0x1d, 0x6b, 0x70, 0x8c, 0x65	/* t__pfx_arch_copy_kprobe */
	.byte 0x0a, 0xf4, 0x72, 0xba, 0xf0, 0xbe, 0x1d, 0x6b, 0x70, 0x8c, 0x65	/* tarch_copy_kprobe */
	.byte 0x09, 0xeb, 0x22, 0xc9, 0xf8, 0x73, 0x6e, 0xec, 0x83, 0x65	/* T__pfx_alloc_insn_page */
	.byte 0x09, 0x54, 0x22, 0xc9, 0xf8, 0x73, 0x6e, 0xec, 0x83, 0x65	/* Talloc_insn_page */
	.byte 0x0c, 0xeb, 0xc5, 0xba, 0xec, 0xf7, 0x70, 0xc5, 0xfc, 0x6b, 0x70, 0x8c, 0x65	/* T__pfx_arch_prepare_kprobe */
	.byte 0x0c, 0x54, 0xc5, 0xba, 0xec, 0xf7, 0x70, 0xc5, 0xfc, 0x6b, 0x70, 0x8c, 0x65	/* Tarch_prepare_kprobe */
	.byte 0x0a, 0xeb, 0xc5, 0xba, 0x5f, 0xc5, 0xae, 0x6b, 0x70, 0x8c, 0x65	/* T__pfx_arch_arm_kprobe */
	.byte 0x0a, 0x54, 0xc5, 0xba, 0x5f, 0xc5, 0xae, 0x6b, 0x70, 0x8c, 0x65	/* Tarch_arm_kprobe */
	.byte 0x0b, 0xeb, 0xc5, 0xba, 0xed, 0xca, 0xc5, 0xae, 0x6b, 0x70, 0x8c, 0x65	/* T__pfx_arch_disarm_kprobe */
	.byte 0x0b, 0x54, 0xc5, 0xba, 0xed, 0xca, 0xc5, 0xae, 0x6b, 0x70, 0x8c, 0x65	/* Tarch_disarm_kprobe */
	.byte 0x0a, 0xeb, 0xc5, 0xba, 0xde, 0x17, 0x1a, 0x6b, 0x70, 0x8c, 0x65	/* T__pfx_arch_remove_kprobe */
	.byte 0x0a, 0x54, 0xc5, 0xba, 0xde, 0x17, 0x1a, 0x6b, 0x70, 0x8c, 0x65	/* Tarch_remove_kprobe */
	.byte 0x0e, 0xeb, 0xc5, 0xba, 0x5f, 0xf3, 0x61, 0xb6, 0xa0, 0xf8, 0xfc, 0x6b, 0x70, 0x8c, 0x65	/* T__pfx_arch_trampoline_kprobe */
	.byte 0x0e, 0x54, 0xc5, 0xba, 0x5f, 0xf3, 0x61, 0xb6, 0xa0, 0xf8, 0xfc, 0x6b, 0x70, 0x8c, 0x65	/* Tarch_trampoline_kprobe */
	.byte 0x12, 0xef, 0x63, 0xbe, 0x1d, 0xbe, 0x00, 0x69, 0x7a, 0x65, 0xda, 0xf8, 0x73, 0xf3, 0x75, 0x63, 0xdc, 0xe7, 0x73	/* t__pfx_copy_optimized_instructions */
	.byte 0x11, 0x26, 0xbe, 0x1d, 0xbe, 0x00, 0x69, 0x7a, 0x65, 0xda, 0xf8, 0x73, 0xf3, 0x75, 0x63, 0xdc, 0xe7, 0x73	/* tcopy_optimized_instructions */
	.byte 0x0e, 0xeb, 0x73, 0xd4, 0xcd, 0xed, 0xd4, 0x6f, 0x98, 0x5f, 0xcb, 0xb4, 0x75, 0xdc, 0xe7	/* T__pfx_setup_detour_execution */
	.byte 0x0e, 0x54, 0x73, 0xd4, 0xcd, 0xed, 0xd4, 0x6f, 0x98, 0x5f, 0xcb, 0xb4, 0x75, 0xdc, 0xe7	/* Tsetup_detour_execution */
	.byte 0x0b, 0xef, 0xbe, 0x00, 0x69, 0x7a, 0x9e, 0xf0, 0x5d, 0x62, 0xf2, 0x6b	/* t__pfx_optimized_callback */
	.byte 0x0b, 0x74, 0xbe, 0x00, 0x69, 0x7a, 0x9e, 0xf0, 0x5d, 0x62, 0xf2, 0x6b	/* toptimized_callback */
	.byte 0x09, 0xef, 0x63, 0xd2, 0x5f, 0xbe, 0x00, 0x69, 0x7a, 0x65	/* t__pfx_can_optimize */
	.byte 0x08, 0x26, 0xd2, 0x5f, 0xbe, 0x00, 0x69, 0x7a, 0x65	/* tcan_optimize */
	.byte 0x0d, 0x99, 0xde, 0x03, 0x0b, 0x5f, 0xbe, 0xce, 0x8c, 0x65, 0xda, 0xf8, 0x73, 0x6e	/* T__pfx___recover_optprobed_insn */
	.byte 0x0d, 0xb9, 0xf7, 0x03, 0x0b, 0x5f, 0xbe, 0xce, 0x8c, 0x65, 0xda, 0xf8, 0x73, 0x6e	/* T__recover_optprobed_insn */
	.byte 0x11, 0xeb, 0xc5, 0xba, 0x25, 0x65, 0xc6, 0x5f, 0xbe, 0x00, 0x69, 0x7a, 0x65, 0xda, 0x6b, 0x70, 0x8c, 0x65	/* T__pfx_arch_check_optimized_kprobe */
	.byte 0x11, 0x54, 0xc5, 0xba, 0x25, 0x65, 0xc6, 0x5f, 0xbe, 0x00, 0x69, 0x7a, 0x65, 0xda, 0x6b, 0x70, 0x8c, 0x65	/* Tarch_check_optimized_kprobe */
	.byte 0x12, 0xeb, 0xc5, 0xba, 0x92, 0xea, 0x68, 0xf8, 0x5f, 0xbe, 0x00, 0x69, 0x7a, 0x65, 0xda, 0x6b, 0x70, 0x8c, 0x65	/* T__pfx_arch_within_optimized_kprobe */
	.byte 0x12, 0x54, 0xc5, 0xba, 0x92, 0xea, 0x68, 0xf8, 0x5f, 0xbe, 0x00, 0x69, 0x7a, 0x65, 0xda, 0x6b, 0x70, 0x8c, 0x65	/* Tarch_within_optimized_kprobe */
	.byte 0x10, 0xeb, 0xc5, 0xba, 0xde, 0x17, 0x1a, 0xbe, 0x00, 0x69, 0x7a, 0x65, 0xda, 0x6b, 0x70, 0x8c, 0x65	/* T__pfx_arch_remove_optimized_kprobe */
	.byte 0x10, 0x54, 0xc5, 0xba, 0xde, 0x17, 0x1a, 0xbe, 0x00, 0x69, 0x7a, 0x65, 0xda, 0x6b, 0x70, 0x8c, 0x65	/* Tarch_remove_optimized_kprobe */
	.byte 0x12, 0xeb, 0xc5, 0xba, 0xec, 0xf7, 0x70, 0xc5, 0xfc, 0xbe, 0x00, 0x69, 0x7a, 0x65, 0xda, 0x6b, 0x70, 0x8c, 0x65	/* T__pfx_arch_prepare_optimized_kprobe */
	.byte 0x12, 0x54, 0xc5, 0xba, 0xec, 0xf7, 0x70, 0xc5, 0xfc, 0xbe, 0x00, 0x69, 0x7a, 0x65, 0xda, 0x6b, 0x70, 0x8c, 0x65	/* Tarch_prepare_optimized_kprobe */
	.byte 0x0d, 0xeb, 0xc5, 0xba, 0x5f, 0xbe, 0x00, 0x69, 0x7a, 0xfc, 0x6b, 0x70, 0x8c, 0xd6	/* T__pfx_arch_optimize_kprobes */
	.byte 0x0d, 0x54, 0xc5, 0xba, 0x5f, 0xbe, 0x00, 0x69, 0x7a, 0xfc, 0x6b, 0x70, 0x8c, 0xd6	/* Tarch_optimize_kprobes */
	.byte 0x0e, 0xeb, 0xc5, 0xba, 0x5f, 0xe4, 0xbe, 0x00, 0x69, 0x7a, 0xfc, 0x6b, 0x70, 0x8c, 0x65	/* T__pfx_arch_unoptimize_kprobe */
	.byte 0x0e, 0x54, 0xc5, 0xba, 0x5f, 0xe4, 0xbe, 0x00, 0x69, 0x7a, 0xfc, 0x6b, 0x70, 0x8c, 0x65	/* Tarch_unoptimize_kprobe */
	.byte 0x0e, 0xeb, 0xc5, 0xba, 0x5f, 0xe4, 0xbe, 0x00, 0x69, 0x7a, 0xfc, 0x6b, 0x70, 0x8c, 0xd6	/* T__pfx_arch_unoptimize_kprobes */
	.byte 0x0e, 0x54, 0xc5, 0xba, 0x5f, 0xe4, 0xbe, 0x00, 0x69, 0x7a, 0xfc, 0x6b, 0x70, 0x8c, 0xd6	/* Tarch_unoptimize_kprobes */
	.byte 0x0c, 0xeb, 0x61, 0x70, 0x70, 0x6c, 0x79, 0xde, 0xdd, 0x63, 0x91, 0xc8, 0x64	/* T__pfx_apply_relocate_add */
	.byte 0x0c, 0x54, 0x61, 0x70, 0x70, 0x6c, 0x79, 0xde, 0xdd, 0x63, 0x91, 0xc8, 0x64	/* Tapply_relocate_add */
	.byte 0x0b, 0xeb, 0x6d, 0xb7, 0x75, 0xb0, 0x66, 0xf8, 0xe5, 0x69, 0x7a, 0x65	/* T__pfx_module_finalize */
	.byte 0x0b, 0x54, 0x6d, 0xb7, 0x75, 0xb0, 0x66, 0xf8, 0xe5, 0x69, 0x7a, 0x65	/* Tmodule_finalize */
	.byte 0x0f, 0xeb, 0x6d, 0xb7, 0x75, 0xb0, 0x70, 0x6f, 0x73, 0xfe, 0x66, 0xf8, 0xe5, 0x69, 0x7a, 0x65	/* T__pfx_module_post_finalize */
	.byte 0x0f, 0x54, 0x6d, 0xb7, 0x75, 0xb0, 0x70, 0x6f, 0x73, 0xfe, 0x66, 0xf8, 0xe5, 0x69, 0x7a, 0x65	/* Tmodule_post_finalize */
	.byte 0x0b, 0xeb, 0x6d, 0xb7, 0x75, 0xb0, 0xc5, 0xba, 0xf0, 0xc4, 0xd2, 0xcd	/* T__pfx_module_arch_cleanup */
	.byte 0x0b, 0x54, 0x6d, 0xb7, 0x75, 0xb0, 0xc5, 0xba, 0xf0, 0xc4, 0xd2, 0xcd	/* Tmodule_arch_cleanup */
	.byte 0x0b, 0xef, 0x65, 0xc5, 0x6c, 0x1d, 0x76, 0x67, 0x61, 0x92, 0x3c, 0x65	/* t__pfx_early_vga_write */
	.byte 0x0a, 0x2c, 0xc5, 0x6c, 0x1d, 0x76, 0x67, 0x61, 0x92, 0x3c, 0x65	/* tearly_vga_write */
	.byte 0x07, 0xef, 0xc0, 0xf6, 0xf5, 0x69, 0xe5, 0xbf	/* t__pfx_io_serial_in */
	.byte 0x07, 0xdc, 0x6f, 0xf6, 0xf5, 0x69, 0xe5, 0xbf	/* tio_serial_in */
	.byte 0x09, 0xef, 0xc0, 0xf6, 0xf5, 0x69, 0xe5, 0x5f, 0x6f, 0x20	/* t__pfx_io_serial_out */
	.byte 0x09, 0xdc, 0x6f, 0xf6, 0xf5, 0x69, 0xe5, 0x5f, 0x6f, 0x20	/* tio_serial_out */
	.byte 0x0c, 0xef, 0xa8, 0x6d, 0x33, 0x32, 0xf6, 0xf5, 0x69, 0xe5, 0x5f, 0x6f, 0x20	/* t__pfx_mem32_serial_out */
	.byte 0x0c, 0x74, 0xa8, 0x6d, 0x33, 0x32, 0xf6, 0xf5, 0x69, 0xe5, 0x5f, 0x6f, 0x20	/* tmem32_serial_out */
	.byte 0x0a, 0xef, 0xa8, 0x6d, 0x33, 0x32, 0xf6, 0xf5, 0x69, 0xe5, 0xbf	/* t__pfx_mem32_serial_in */
	.byte 0x0a, 0x74, 0xa8, 0x6d, 0x33, 0x32, 0xf6, 0xf5, 0x69, 0xe5, 0xbf	/* tmem32_serial_in */
	.byte 0x10, 0xef, 0x65, 0xc5, 0x6c, 0x79, 0xf6, 0xf5, 0x69, 0xe5, 0xec, 0x75, 0x26, 0x2e, 0xca, 0xbc, 0x7e	/* t__pfx_early_serial_putc.isra.0 */
	.byte 0x0f, 0x2c, 0xc5, 0x6c, 0x79, 0xf6, 0xf5, 0x69, 0xe5, 0xec, 0x75, 0x26, 0x2e, 0xca, 0xbc, 0x7e	/* tearly_serial_putc.isra.0 */
	.byte 0x0c, 0xef, 0x65, 0xc5, 0x6c, 0x79, 0xf6, 0xf5, 0x69, 0xe5, 0x92, 0x3c, 0x65	/* t__pfx_early_serial_write */
	.byte 0x0b, 0x2c, 0xc5, 0x6c, 0x79, 0xf6, 0xf5, 0x69, 0xe5, 0x92, 0x3c, 0x65	/* tearly_serial_write */
	.byte 0x0a, 0xeb, 0x69, 0xe9, 0x68, 0x70, 0xe2, 0xf1, 0x90, 0xc4, 0x64	/* T__pfx_is_hpet_enabled */
	.byte 0x0a, 0x54, 0x69, 0xe9, 0x68, 0x70, 0xe2, 0xf1, 0x90, 0xc4, 0x64	/* Tis_hpet_enabled */
	.byte 0x0b, 0xef, 0x68, 0x70, 0xe2, 0xf7, 0x3d, 0x72, 0xfe, 0x03, 0xe4, 0xa2	/* t__pfx_hpet_restart_counter */
	.byte 0x0b, 0x74, 0x68, 0x70, 0xe2, 0xf7, 0x3d, 0x72, 0xfe, 0x03, 0xe4, 0xa2	/* thpet_restart_counter */
	.byte 0x13, 0xef, 0x68, 0x70, 0xe2, 0x63, 0x6c, 0x6b, 0xee, 0xfe, 0x73, 0xe2, 0x3d, 0x74, 0xfc, 0xe7, 0xd6, 0x68, 0x6f, 0x74	/* t__pfx_hpet_clkevt_set_state_oneshot */
	.byte 0x13, 0x74, 0x68, 0x70, 0xe2, 0x63, 0x6c, 0x6b, 0xee, 0xfe, 0x73, 0xe2, 0x3d, 0x74, 0xfc, 0xe7, 0xd6, 0x68, 0x6f, 0x74	/* thpet_clkevt_set_state_oneshot */
	.byte 0x14, 0xef, 0x68, 0x70, 0xe2, 0x63, 0x6c, 0x6b, 0xee, 0xfe, 0x73, 0xe2, 0x3d, 0x74, 0xfc, 0x73, 0x68, 0x20, 0x64, 0xad, 0x6e	/* t__pfx_hpet_clkevt_set_state_shutdown */
	.byte 0x14, 0x74, 0x68, 0x70, 0xe2, 0x63, 0x6c, 0x6b, 0xee, 0xfe, 0x73, 0xe2, 0x3d, 0x74, 0xfc, 0x73, 0x68, 0x20, 0x64, 0xad, 0x6e	/* thpet_clkevt_set_state_shutdown */
	.byte 0x10, 0xef, 0x68, 0x70, 0xe2, 0x63, 0x6c, 0x6b, 0xee, 0xfe, 0x73, 0xe2, 0x6e, 0xcb, 0xfe, 0xd7, 0x74	/* t__pfx_hpet_clkevt_set_next_event */
	.byte 0x10, 0x74, 0x68, 0x70, 0xe2, 0x63, 0x6c, 0x6b, 0xee, 0xfe, 0x73, 0xe2, 0x6e, 0xcb, 0xfe, 0xd7, 0x74	/* thpet_clkevt_set_next_event */
	.byte 0x0a, 0xef, 0x68, 0x70, 0xe2, 0x6d, 0x85, 0x5f, 0xe4, 0xd9, 0x5e	/* t__pfx_hpet_msi_unmask */
	.byte 0x0a, 0x74, 0x68, 0x70, 0xe2, 0x6d, 0x85, 0x5f, 0xe4, 0xd9, 0x5e	/* thpet_msi_unmask */
	.byte 0x09, 0xef, 0x68, 0x70, 0xe2, 0x6d, 0x85, 0x5f, 0xd9, 0x5e	/* t__pfx_hpet_msi_mask */
	.byte 0x09, 0x74, 0x68, 0x70, 0xe2, 0x6d, 0x85, 0x5f, 0xd9, 0x5e	/* thpet_msi_mask */
	.byte 0x0b, 0x74, 0xaf, 0x68, 0x70, 0xe2, 0x70, 0x72, 0x27, 0x40, 0xa5, 0x67	/* t__pfx__hpet_print_config */
	.byte 0x0a, 0xfe, 0x68, 0x70, 0xe2, 0x70, 0x72, 0x27, 0x40, 0xa5, 0x67	/* t_hpet_print_config */
	.byte 0x0b, 0xef, 0x68, 0x70, 0xe2, 0x29, 0x75, 0x6d, 0xfc, 0x03, 0xe4, 0xa2	/* t__pfx_hpet_resume_counter */
	.byte 0x0b, 0x74, 0x68, 0x70, 0xe2, 0x29, 0x75, 0x6d, 0xfc, 0x03, 0xe4, 0xa2	/* thpet_resume_counter */
	.byte 0x07, 0xef, 0xf7, 0x61, 0xda, 0x68, 0x70, 0xd4	/* t__pfx_read_hpet */
	.byte 0x07, 0x74, 0xf7, 0x61, 0xda, 0x68, 0x70, 0xd4	/* tread_hpet */
	.byte 0x12, 0xef, 0x68, 0x70, 0xe2, 0x63, 0x6c, 0x6b, 0xee, 0xfe, 0x73, 0xe2, 0x3d, 0x74, 0xfc, 0x19, 0xc0, 0x64, 0xaa	/* t__pfx_hpet_clkevt_set_state_periodic */
	.byte 0x12, 0x74, 0x68, 0x70, 0xe2, 0x63, 0x6c, 0x6b, 0xee, 0xfe, 0x73, 0xe2, 0x3d, 0x74, 0xfc, 0x19, 0xc0, 0x64, 0xaa	/* thpet_clkevt_set_state_periodic */
	.byte 0x0b, 0xef, 0x68, 0x70, 0xe2, 0x63, 0x9c, 0x68, 0x70, 0xed, 0x65, 0xc8	/* t__pfx_hpet_cpuhp_dead */
	.byte 0x0b, 0x74, 0x68, 0x70, 0xe2, 0x63, 0x9c, 0x68, 0x70, 0xed, 0x65, 0xc8	/* thpet_cpuhp_dead */
	.byte 0x09, 0xef, 0x68, 0x70, 0xe2, 0x6d, 0x85, 0xe6, 0xf7, 0x65	/* t__pfx_hpet_msi_free */
	.byte 0x09, 0x74, 0x68, 0x70, 0xe2, 0x6d, 0x85, 0xe6, 0xf7, 0x65	/* thpet_msi_free */
	.byte 0x08, 0xef, 0x68, 0x70, 0xe2, 0x6d, 0x85, 0xbf, 0xea	/* t__pfx_hpet_msi_init */
	.byte 0x08, 0x74, 0x68, 0x70, 0xe2, 0x6d, 0x85, 0xbf, 0xea	/* thpet_msi_init */
	.byte 0x0c, 0xeb, 0x68, 0x70, 0xe2, 0x72, 0x74, 0xc9, 0xb3, 0xf5, 0x72, 0xcd, 0x74	/* T__pfx_hpet_rtc_interrupt */
	.byte 0x0c, 0x54, 0x68, 0x70, 0xe2, 0x72, 0x74, 0xc9, 0xb3, 0xf5, 0x72, 0xcd, 0x74	/* Thpet_rtc_interrupt */
	.byte 0x0f, 0xef, 0x68, 0x70, 0xe2, 0x6d, 0x85, 0xbf, 0xa2, 0x72, 0xcd, 0xfe, 0x68, 0x05, 0x6c, 0xf5	/* t__pfx_hpet_msi_interrupt_handler */
	.byte 0x0f, 0x74, 0x68, 0x70, 0xe2, 0x6d, 0x85, 0xbf, 0xa2, 0x72, 0xcd, 0xfe, 0x68, 0x05, 0x6c, 0xf5	/* thpet_msi_interrupt_handler */
	.byte 0x0c, 0xef, 0x68, 0x70, 0xe2, 0x63, 0x9c, 0x68, 0x70, 0x5f, 0xe7, 0x2d, 0x65	/* t__pfx_hpet_cpuhp_online */
	.byte 0x0c, 0x74, 0x68, 0x70, 0xe2, 0x63, 0x9c, 0x68, 0x70, 0x5f, 0xe7, 0x2d, 0x65	/* thpet_cpuhp_online */
	.byte 0x0c, 0xef, 0x68, 0x70, 0xe2, 0x6d, 0x85, 0x92, 0x3c, 0xfc, 0x6d, 0x73, 0x67	/* t__pfx_hpet_msi_write_msg */
	.byte 0x0c, 0x74, 0x68, 0x70, 0xe2, 0x6d, 0x85, 0x92, 0x3c, 0xfc, 0x6d, 0x73, 0x67	/* thpet_msi_write_msg */
	.byte 0x10, 0xef, 0x68, 0x70, 0xe2, 0x63, 0x6c, 0x6b, 0xee, 0xfe, 0xc4, 0x67, 0xf2, 0x79, 0x07, 0x75, 0xa8	/* t__pfx_hpet_clkevt_legacy_resume */
	.byte 0x10, 0x74, 0x68, 0x70, 0xe2, 0x63, 0x6c, 0x6b, 0xee, 0xfe, 0xc4, 0x67, 0xf2, 0x79, 0x07, 0x75, 0xa8	/* thpet_clkevt_legacy_resume */
	.byte 0x0e, 0xef, 0x68, 0x70, 0xe2, 0x63, 0x6c, 0x6b, 0xee, 0xfe, 0x6d, 0x85, 0x07, 0x75, 0xa8	/* t__pfx_hpet_clkevt_msi_resume */
	.byte 0x0e, 0x74, 0x68, 0x70, 0xe2, 0x63, 0x6c, 0x6b, 0xee, 0xfe, 0x6d, 0x85, 0x07, 0x75, 0xa8	/* thpet_clkevt_msi_resume */
	.byte 0x0e, 0xeb, 0x68, 0x70, 0xe2, 0x72, 0x26, 0xed, 0xe3, 0x70, 0x70, 0x65, 0xda, 0xab, 0x71	/* T__pfx_hpet_rtc_dropped_irq */
	.byte 0x0e, 0x54, 0x68, 0x70, 0xe2, 0x72, 0x26, 0xed, 0xe3, 0x70, 0x70, 0x65, 0xda, 0xab, 0x71	/* Thpet_rtc_dropped_irq */
	.byte 0x0e, 0xeb, 0x68, 0x70, 0xe2, 0xe4, 0xf7, 0x0e, 0x5f, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5	/* T__pfx_hpet_unregister_irq_handler */
	.byte 0x0e, 0x54, 0x68, 0x70, 0xe2, 0xe4, 0xf7, 0x0e, 0x5f, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5	/* Thpet_unregister_irq_handler */
	.byte 0x0b, 0xeb, 0x68, 0x70, 0xe2, 0x73, 0xe2, 0xe5, 0xc5, 0xae, 0xdc, 0xa8	/* T__pfx_hpet_set_alarm_time */
	.byte 0x0b, 0x54, 0x68, 0x70, 0xe2, 0x73, 0xe2, 0xe5, 0xc5, 0xae, 0xdc, 0xa8	/* Thpet_set_alarm_time */
	.byte 0x0d, 0xeb, 0x68, 0x70, 0xe2, 0xf7, 0x0e, 0x5f, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5	/* T__pfx_hpet_register_irq_handler */
	.byte 0x0d, 0x54, 0x68, 0x70, 0xe2, 0xf7, 0x0e, 0x5f, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5	/* Thpet_register_irq_handler */
	.byte 0x0d, 0xeb, 0x68, 0x70, 0xe2, 0xd9, 0x5e, 0xa6, 0x74, 0xc9, 0xab, 0x71, 0xb8, 0xea	/* T__pfx_hpet_mask_rtc_irq_bit */
	.byte 0x0d, 0x54, 0x68, 0x70, 0xe2, 0xd9, 0x5e, 0xa6, 0x74, 0xc9, 0xab, 0x71, 0xb8, 0xea	/* Thpet_mask_rtc_irq_bit */
	.byte 0x0d, 0xeb, 0x68, 0x70, 0xe2, 0x73, 0xe2, 0x19, 0xc0, 0x64, 0xaa, 0xe6, 0xf7, 0x71	/* T__pfx_hpet_set_periodic_freq */
	.byte 0x0d, 0x54, 0x68, 0x70, 0xe2, 0x73, 0xe2, 0x19, 0xc0, 0x64, 0xaa, 0xe6, 0xf7, 0x71	/* Thpet_set_periodic_freq */
	.byte 0x0b, 0xeb, 0x68, 0x70, 0xe2, 0x72, 0x74, 0xc9, 0x00, 0xf5, 0xbf, 0xea	/* T__pfx_hpet_rtc_timer_init */
	.byte 0x0b, 0x54, 0x68, 0x70, 0xe2, 0x72, 0x74, 0xc9, 0x00, 0xf5, 0xbf, 0xea	/* Thpet_rtc_timer_init */
	.byte 0x0d, 0xeb, 0x68, 0x70, 0xe2, 0x73, 0xe2, 0x72, 0x74, 0xc9, 0xab, 0x71, 0xb8, 0xea	/* T__pfx_hpet_set_rtc_irq_bit */
	.byte 0x0d, 0x54, 0x68, 0x70, 0xe2, 0x73, 0xe2, 0x72, 0x74, 0xc9, 0xab, 0x71, 0xb8, 0xea	/* Thpet_set_rtc_irq_bit */
	.byte 0x07, 0xeb, 0x68, 0x70, 0xe2, 0xf7, 0xc8, 0x6c	/* T__pfx_hpet_readl */
	.byte 0x07, 0x54, 0x68, 0x70, 0xe2, 0xf7, 0xc8, 0x6c	/* Thpet_readl */
	.byte 0x08, 0xeb, 0x68, 0x70, 0xe2, 0x64, 0xca, 0x90, 0xc4	/* T__pfx_hpet_disable */
	.byte 0x08, 0x54, 0x68, 0x70, 0xe2, 0x64, 0xca, 0x90, 0xc4	/* Thpet_disable */
	.byte 0x08, 0xeb, 0x2a, 0xda, 0x6e, 0x62, 0xbd, 0x75, 0x6d	/* T__pfx_amd_nb_num */
	.byte 0x08, 0x54, 0x2a, 0xda, 0x6e, 0x62, 0xbd, 0x75, 0x6d	/* Tamd_nb_num */
	.byte 0x0d, 0xeb, 0x2a, 0xda, 0x6e, 0x62, 0xa3, 0x61, 0xe9, 0x66, 0x65, 0xe8, 0x75, 0xf7	/* T__pfx_amd_nb_has_feature */
	.byte 0x0d, 0x54, 0x2a, 0xda, 0x6e, 0x62, 0xa3, 0x61, 0xe9, 0x66, 0x65, 0xe8, 0x75, 0xf7	/* Tamd_nb_has_feature */
	.byte 0x09, 0xeb, 0x6e, 0x16, 0x8a, 0x5f, 0x2a, 0xda, 0x6e, 0x62	/* T__pfx_node_to_amd_nb */
	.byte 0x09, 0x54, 0x6e, 0x16, 0x8a, 0x5f, 0x2a, 0xda, 0x6e, 0x62	/* Tnode_to_amd_nb */
	.byte 0x0a, 0x74, 0xaf, 0x5f, 0x2a, 0x64, 0xf6, 0x6d, 0x6e, 0xa6, 0x77	/* t__pfx___amd_smn_rw */
	.byte 0x09, 0x74, 0xff, 0x2a, 0x64, 0xf6, 0x6d, 0x6e, 0xa6, 0x77	/* t__amd_smn_rw */
	.byte 0x08, 0xeb, 0x2a, 0x64, 0xf6, 0x6d, 0x6e, 0xde, 0xc8	/* T__pfx_amd_smn_read */
	.byte 0x08, 0x54, 0x2a, 0x64, 0xf6, 0x6d, 0x6e, 0xde, 0xc8	/* Tamd_smn_read */
	.byte 0x09, 0xeb, 0x2a, 0x64, 0xf6, 0x6d, 0x6e, 0x92, 0x3c, 0x65	/* T__pfx_amd_smn_write */
	.byte 0x09, 0x54, 0x2a, 0x64, 0xf6, 0x6d, 0x6e, 0x92, 0x3c, 0x65	/* Tamd_smn_write */
	.byte 0x0e, 0x74, 0xaf, 0xe6, 0x69, 0x78, 0x5f, 0xf5, 0x72, 0xe8, 0x75, 0xae, 0x36, 0x38, 0x38	/* t__pfx___fix_erratum_688 */
	.byte 0x0d, 0x74, 0xff, 0xa5, 0x78, 0x5f, 0xf5, 0x72, 0xe8, 0x75, 0xae, 0x36, 0x38, 0x38	/* t__fix_erratum_688 */
	.byte 0x0a, 0xeb, 0x2a, 0x64, 0xe6, 0x6c, 0xb1, 0x68, 0xc7, 0xc5, 0x93	/* T__pfx_amd_flush_garts */
	.byte 0x0a, 0x54, 0x2a, 0x64, 0xe6, 0x6c, 0xb1, 0x68, 0xc7, 0xc5, 0x93	/* Tamd_flush_garts */
	.byte 0x0e, 0xeb, 0x2a, 0xda, 0x67, 0xe2, 0x6d, 0x6d, 0x40, 0xa5, 0x67, 0xa6, 0xd2, 0x67, 0x65	/* T__pfx_amd_get_mmconfig_range */
	.byte 0x0e, 0x54, 0x2a, 0xda, 0x67, 0xe2, 0x6d, 0x6d, 0x40, 0xa5, 0x67, 0xa6, 0xd2, 0x67, 0x65	/* Tamd_get_mmconfig_range */
	.byte 0x0b, 0xeb, 0x2a, 0xda, 0x67, 0xe2, 0x73, 0x88, 0x63, 0xf2, 0x68, 0xd6	/* T__pfx_amd_get_subcaches */
	.byte 0x0b, 0x54, 0x2a, 0xda, 0x67, 0xe2, 0x73, 0x88, 0x63, 0xf2, 0x68, 0xd6	/* Tamd_get_subcaches */
	.byte 0x0a, 0xeb, 0x2a, 0x64, 0x84, 0x73, 0x88, 0x63, 0xf2, 0x68, 0xd6	/* T__pfx_amd_set_subcaches */
	.byte 0x0a, 0x54, 0x2a, 0x64, 0x84, 0x73, 0x88, 0x63, 0xf2, 0x68, 0xd6	/* Tamd_set_subcaches */
	.byte 0x1b, 0x08, 0xbc, 0x77, 0xf0, 0xe5, 0xc4, 0xfc, 0x73, 0x61, 0x76, 0x65, 0xff, 0x5f, 0x6b, 0x76, 0xae, 0x76, 0x63, 0x9c, 0x5f, 0xca, 0xec, 0xf7, 0x65, 0xb6, 0x74, 0x9e	/* T__pfx___raw_callee_save___kvm_vcpu_is_preempted */
	.byte 0x1b, 0xb9, 0xbc, 0x77, 0xf0, 0xe5, 0xc4, 0xfc, 0x73, 0x61, 0x76, 0x65, 0xff, 0x5f, 0x6b, 0x76, 0xae, 0x76, 0x63, 0x9c, 0x5f, 0xca, 0xec, 0xf7, 0x65, 0xb6, 0x74, 0x9e	/* T__raw_callee_save___kvm_vcpu_is_preempted */
	.byte 0x09, 0xef, 0x6b, 0x76, 0xae, 0xc0, 0xed, 0xdb, 0x61, 0x79	/* t__pfx_kvm_io_delay */
	.byte 0x09, 0x74, 0x6b, 0x76, 0xae, 0xc0, 0xed, 0xdb, 0x61, 0x79	/* tkvm_io_delay */
	.byte 0x09, 0xef, 0x6b, 0x76, 0x6d, 0xf6, 0x2c, 0xe5, 0xf0, 0xa4	/* t__pfx_kvm_steal_clock */
	.byte 0x09, 0x74, 0x6b, 0x76, 0x6d, 0xf6, 0x2c, 0xe5, 0xf0, 0xa4	/* tkvm_steal_clock */
	.byte 0x14, 0xeb, 0x6b, 0x76, 0xae, 0x61, 0xe1, 0x6e, 0x63, 0xec, 0x3b, 0xf4, 0x5e, 0x92, 0x61, 0x9d, 0x73, 0xba, 0x9e, 0x75, 0xc4	/* T__pfx_kvm_async_pf_task_wait_schedule */
	.byte 0x14, 0x54, 0x6b, 0x76, 0xae, 0x61, 0xe1, 0x6e, 0x63, 0xec, 0x3b, 0xf4, 0x5e, 0x92, 0x61, 0x9d, 0x73, 0xba, 0x9e, 0x75, 0xc4	/* Tkvm_async_pf_task_wait_schedule */
	.byte 0x10, 0xef, 0x6b, 0x76, 0x6d, 0xf6, 0xb6, 0xf6, 0xf1, 0x64, 0xf0, 0x5d, 0xe6, 0xe4, 0xc9, 0x69, 0xb2	/* t__pfx_kvm_smp_send_call_func_ipi */
	.byte 0x10, 0x74, 0x6b, 0x76, 0x6d, 0xf6, 0xb6, 0xf6, 0xf1, 0x64, 0xf0, 0x5d, 0xe6, 0xe4, 0xc9, 0x69, 0xb2	/* tkvm_smp_send_call_func_ipi */
	.byte 0x0e, 0xef, 0x6b, 0x76, 0x6d, 0xe6, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0xc1, 0x02, 0xdc	/* t__pfx_kvm_flush_tlb_multi */
	.byte 0x0e, 0x74, 0x6b, 0x76, 0x6d, 0xe6, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0xc1, 0x02, 0xdc	/* tkvm_flush_tlb_multi */
	.byte 0x11, 0xef, 0x6b, 0x76, 0x6d, 0xc7, 0x75, 0xd6, 0xfe, 0x61, 0xb2, 0xc9, 0x65, 0x6f, 0x69, 0x92, 0x3c, 0x65	/* t__pfx_kvm_guest_apic_eoi_write */
	.byte 0x11, 0x74, 0x6b, 0x76, 0x6d, 0xc7, 0x75, 0xd6, 0xfe, 0x61, 0xb2, 0xc9, 0x65, 0x6f, 0x69, 0x92, 0x3c, 0x65	/* tkvm_guest_apic_eoi_write */
	.byte 0x10, 0xef, 0x6b, 0x76, 0x6d, 0xec, 0x76, 0xde, 0x62, 0x6f, 0x6f, 0xfe, 0x6e, 0x6f, 0xdc, 0x66, 0x79	/* t__pfx_kvm_pv_reboot_notify */
	.byte 0x10, 0x74, 0x6b, 0x76, 0x6d, 0xec, 0x76, 0xde, 0x62, 0x6f, 0x6f, 0xfe, 0x6e, 0x6f, 0xdc, 0x66, 0x79	/* tkvm_pv_reboot_notify */
	.byte 0x0d, 0x74, 0xaf, 0x5f, 0x6b, 0x76, 0x6d, 0xf0, 0x9c, 0x69, 0xda, 0x62, 0xbb, 0x65	/* t__pfx___kvm_cpuid_base */
	.byte 0x0b, 0x74, 0xd8, 0x76, 0x6d, 0xf0, 0x9c, 0x69, 0xda, 0x62, 0xbb, 0x65	/* t__kvm_cpuid_base */
	.byte 0x0b, 0xef, 0x61, 0x70, 0x3b, 0xf4, 0x5e, 0x92, 0x61, 0x6b, 0xfc, 0x5d	/* t__pfx_apf_task_wake_all */
	.byte 0x0a, 0xf4, 0x70, 0x3b, 0xf4, 0x5e, 0x92, 0x61, 0x6b, 0xfc, 0x5d	/* tapf_task_wake_all */
	.byte 0x10, 0xeb, 0x6b, 0x76, 0xae, 0x61, 0xe1, 0x6e, 0x63, 0xec, 0x3b, 0xf4, 0x5e, 0x92, 0x61, 0x6b, 0x65	/* T__pfx_kvm_async_pf_task_wake */
	.byte 0x10, 0x54, 0x6b, 0x76, 0xae, 0x61, 0xe1, 0x6e, 0x63, 0xec, 0x3b, 0xf4, 0x5e, 0x92, 0x61, 0x6b, 0x65	/* Tkvm_async_pf_task_wake */
	.byte 0x0a, 0x74, 0xaf, 0xf6, 0xf1, 0xda, 0x69, 0xb2, 0x5f, 0xd9, 0x5e	/* t__pfx___send_ipi_mask */
	.byte 0x0a, 0x74, 0xff, 0x73, 0xf1, 0xda, 0x69, 0xb2, 0x5f, 0xd9, 0x5e	/* t__send_ipi_mask */
	.byte 0x12, 0xef, 0x6b, 0x76, 0x6d, 0xf6, 0xf1, 0xda, 0x69, 0xb2, 0x5f, 0xd9, 0x5e, 0x5f, 0x5d, 0x06, 0x93, 0xdb, 0x66	/* t__pfx_kvm_send_ipi_mask_allbutself */
	.byte 0x12, 0x74, 0x6b, 0x76, 0x6d, 0xf6, 0xf1, 0xda, 0x69, 0xb2, 0x5f, 0xd9, 0x5e, 0x5f, 0x5d, 0x06, 0x93, 0xdb, 0x66	/* tkvm_send_ipi_mask_allbutself */
	.byte 0x0c, 0xef, 0x6b, 0x76, 0x6d, 0xf6, 0xf1, 0xda, 0x69, 0xb2, 0x5f, 0xd9, 0x5e	/* t__pfx_kvm_send_ipi_mask */
	.byte 0x0c, 0x74, 0x6b, 0x76, 0x6d, 0xf6, 0xf1, 0xda, 0x69, 0xb2, 0x5f, 0xd9, 0x5e	/* tkvm_send_ipi_mask */
	.byte 0x0f, 0xeb, 0x6b, 0x76, 0x6d, 0xec, 0xc5, 0x61, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x90, 0xc4	/* T__pfx_kvm_para_available */
	.byte 0x0f, 0x54, 0x6b, 0x76, 0x6d, 0xec, 0xc5, 0x61, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x90, 0xc4	/* Tkvm_para_available */
	.byte 0x0c, 0xeb, 0x6b, 0x76, 0xae, 0xc5, 0xba, 0xec, 0xc5, 0x61, 0xa3, 0xb3, 0x73	/* T__pfx_kvm_arch_para_hints */
	.byte 0x0c, 0x54, 0x6b, 0x76, 0xae, 0xc5, 0xba, 0xec, 0xc5, 0x61, 0xa3, 0xb3, 0x73	/* Tkvm_arch_para_hints */
	.byte 0x0c, 0xeb, 0xc5, 0xba, 0xa3, 0xe5, 0xce, 0xa0, 0x6c, 0xed, 0xca, 0x90, 0xc4	/* T__pfx_arch_haltpoll_disable */
	.byte 0x0c, 0x54, 0xc5, 0xba, 0xa3, 0xe5, 0xce, 0xa0, 0x6c, 0xed, 0xca, 0x90, 0xc4	/* Tarch_haltpoll_disable */
	.byte 0x0b, 0xeb, 0xc5, 0xba, 0xa3, 0xe5, 0xce, 0xa0, 0x6c, 0x0d, 0x90, 0xc4	/* T__pfx_arch_haltpoll_enable */
	.byte 0x0b, 0x54, 0xc5, 0xba, 0xa3, 0xe5, 0xce, 0xa0, 0x6c, 0x0d, 0x90, 0xc4	/* Tarch_haltpoll_enable */
	.byte 0x0c, 0xef, 0x70, 0x76, 0x5f, 0x69, 0xb2, 0xf6, 0xcd, 0x70, 0xd5, 0x74, 0x9e	/* t__pfx_pv_ipi_supported */
	.byte 0x0b, 0xce, 0x76, 0x5f, 0x69, 0xb2, 0xf6, 0xcd, 0x70, 0xd5, 0x74, 0x9e	/* tpv_ipi_supported */
	.byte 0x11, 0xef, 0x6b, 0x76, 0x6d, 0xed, 0xca, 0x90, 0xb0, 0x68, 0x6f, 0x73, 0xfe, 0x68, 0xe5, 0xce, 0xa0, 0x6c	/* t__pfx_kvm_disable_host_haltpoll */
	.byte 0x11, 0x74, 0x6b, 0x76, 0x6d, 0xed, 0xca, 0x90, 0xb0, 0x68, 0x6f, 0x73, 0xfe, 0x68, 0xe5, 0xce, 0xa0, 0x6c	/* tkvm_disable_host_haltpoll */
	.byte 0x10, 0xef, 0x6b, 0x76, 0xae, 0xf1, 0x90, 0xb0, 0x68, 0x6f, 0x73, 0xfe, 0x68, 0xe5, 0xce, 0xa0, 0x6c	/* t__pfx_kvm_enable_host_haltpoll */
	.byte 0x10, 0x74, 0x6b, 0x76, 0xae, 0xf1, 0x90, 0xb0, 0x68, 0x6f, 0x73, 0xfe, 0x68, 0xe5, 0xce, 0xa0, 0x6c	/* tkvm_enable_host_haltpoll */
	.byte 0x10, 0xef, 0x70, 0x76, 0xa7, 0x6c, 0x62, 0xe6, 0x6c, 0xb1, 0x68, 0xf6, 0xcd, 0x70, 0xd5, 0x74, 0x9e	/* t__pfx_pv_tlb_flush_supported */
	.byte 0x0f, 0xce, 0x76, 0xa7, 0x6c, 0x62, 0xe6, 0x6c, 0xb1, 0x68, 0xf6, 0xcd, 0x70, 0xd5, 0x74, 0x9e	/* tpv_tlb_flush_supported */
	.byte 0x15, 0x74, 0xaf, 0x7f, 0x73, 0x76, 0x65, 0xc9, 0x6b, 0x76, 0xae, 0x61, 0xe1, 0x6e, 0x63, 0x70, 0x66, 0xbf, 0xa2, 0x72, 0xcd, 0x74	/* t__pfx___sysvec_kvm_asyncpf_interrupt */
	.byte 0x15, 0x74, 0xff, 0xe1, 0x73, 0x76, 0x65, 0xc9, 0x6b, 0x76, 0xae, 0x61, 0xe1, 0x6e, 0x63, 0x70, 0x66, 0xbf, 0xa2, 0x72, 0xcd, 0x74	/* t__sysvec_kvm_asyncpf_interrupt */
	.byte 0x10, 0xef, 0x6b, 0x76, 0x6d, 0xc7, 0x75, 0xd6, 0xfe, 0x63, 0x9c, 0x5f, 0x6f, 0x66, 0x66, 0x2d, 0x65	/* t__pfx_kvm_guest_cpu_offline */
	.byte 0x10, 0x74, 0x6b, 0x76, 0x6d, 0xc7, 0x75, 0xd6, 0xfe, 0x63, 0x9c, 0x5f, 0x6f, 0x66, 0x66, 0x2d, 0x65	/* tkvm_guest_cpu_offline */
	.byte 0x0e, 0xef, 0x6b, 0x76, 0x6d, 0xf0, 0xbc, 0x73, 0x68, 0xf6, 0x68, 0x20, 0x64, 0xad, 0x6e	/* t__pfx_kvm_crash_shutdown */
	.byte 0x0e, 0x74, 0x6b, 0x76, 0x6d, 0xf0, 0xbc, 0x73, 0x68, 0xf6, 0x68, 0x20, 0x64, 0xad, 0x6e	/* tkvm_crash_shutdown */
	.byte 0x0e, 0xef, 0x6b, 0x76, 0x6d, 0xf0, 0x9c, 0xed, 0xad, 0x6e, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* t__pfx_kvm_cpu_down_prepare */
	.byte 0x0e, 0x74, 0x6b, 0x76, 0x6d, 0xf0, 0x9c, 0xed, 0xad, 0x6e, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* tkvm_cpu_down_prepare */
	.byte 0x11, 0xef, 0x6b, 0x76, 0x6d, 0xec, 0x76, 0xc7, 0x75, 0xd6, 0xfe, 0x63, 0x9c, 0xde, 0x62, 0x6f, 0x6f, 0x74	/* t__pfx_kvm_pv_guest_cpu_reboot */
	.byte 0x11, 0x74, 0x6b, 0x76, 0x6d, 0xec, 0x76, 0xc7, 0x75, 0xd6, 0xfe, 0x63, 0x9c, 0xde, 0x62, 0x6f, 0x6f, 0x74	/* tkvm_pv_guest_cpu_reboot */
	.byte 0x09, 0xef, 0x6b, 0x76, 0x6d, 0xf6, 0xb1, 0x70, 0xf1, 0x64	/* t__pfx_kvm_suspend */
	.byte 0x09, 0x74, 0x6b, 0x76, 0x6d, 0xf6, 0xb1, 0x70, 0xf1, 0x64	/* tkvm_suspend */
	.byte 0x0c, 0xef, 0x6b, 0x76, 0x6d, 0xc7, 0x75, 0xd6, 0xfe, 0x63, 0x9c, 0xbf, 0xea	/* t__pfx_kvm_guest_cpu_init */
	.byte 0x0c, 0x74, 0x6b, 0x76, 0x6d, 0xc7, 0x75, 0xd6, 0xfe, 0x63, 0x9c, 0xbf, 0xea	/* tkvm_guest_cpu_init */
	.byte 0x0a, 0xef, 0x6b, 0x76, 0x6d, 0xf0, 0x9c, 0x5f, 0xe7, 0x2d, 0x65	/* t__pfx_kvm_cpu_online */
	.byte 0x0a, 0x74, 0x6b, 0x76, 0x6d, 0xf0, 0x9c, 0x5f, 0xe7, 0x2d, 0x65	/* tkvm_cpu_online */
	.byte 0x07, 0xef, 0x6b, 0x76, 0x6d, 0x07, 0x75, 0xa8	/* t__pfx_kvm_resume */
	.byte 0x07, 0x74, 0x6b, 0x76, 0x6d, 0x07, 0x75, 0xa8	/* tkvm_resume */
	.byte 0x17, 0xeb, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0x65, 0xc9, 0x6b, 0x76, 0xae, 0x61, 0xe1, 0x6e, 0x63, 0x70, 0x66, 0xbf, 0xa2, 0x72, 0xcd, 0x74	/* T__pfx_fred_sysvec_kvm_asyncpf_interrupt */
	.byte 0x17, 0x54, 0x66, 0xf7, 0x64, 0x7f, 0x73, 0x76, 0x65, 0xc9, 0x6b, 0x76, 0xae, 0x61, 0xe1, 0x6e, 0x63, 0x70, 0x66, 0xbf, 0xa2, 0x72, 0xcd, 0x74	/* Tfred_sysvec_kvm_asyncpf_interrupt */
	.byte 0x0e, 0xeb, 0x6b, 0x76, 0xae, 0xc5, 0xba, 0xec, 0xc5, 0x61, 0xe6, 0x65, 0xe8, 0x75, 0x29	/* T__pfx_kvm_arch_para_features */
	.byte 0x0e, 0x54, 0x6b, 0x76, 0xae, 0xc5, 0xba, 0xec, 0xc5, 0x61, 0xe6, 0x65, 0xe8, 0x75, 0x29	/* Tkvm_arch_para_features */
	.byte 0x09, 0xef, 0x6b, 0x76, 0x6d, 0x84, 0x77, 0x5d, 0x63, 0xa4	/* t__pfx_kvm_set_wallclock */
	.byte 0x09, 0x74, 0x6b, 0x76, 0x6d, 0x84, 0x77, 0x5d, 0x63, 0xa4	/* tkvm_set_wallclock */
	.byte 0x09, 0xef, 0x6b, 0x76, 0x6d, 0xf0, 0xe9, 0xf1, 0x90, 0xc4	/* t__pfx_kvm_cs_enable */
	.byte 0x09, 0x74, 0x6b, 0x76, 0x6d, 0xf0, 0xe9, 0xf1, 0x90, 0xc4	/* tkvm_cs_enable */
	.byte 0x0e, 0xef, 0x6b, 0x76, 0x6d, 0xf6, 0x61, 0x1a, 0x73, 0xba, 0x9e, 0xf0, 0xa4, 0xa9, 0x2c	/* t__pfx_kvm_save_sched_clock_state */
	.byte 0x0e, 0x74, 0x6b, 0x76, 0x6d, 0xf6, 0x61, 0x1a, 0x73, 0xba, 0x9e, 0xf0, 0xa4, 0xa9, 0x2c	/* tkvm_save_sched_clock_state */
	.byte 0x0d, 0xef, 0x6b, 0x76, 0x6d, 0x63, 0xa4, 0xf6, 0xd4, 0xcd, 0xec, 0xf5, 0x63, 0x9c	/* t__pfx_kvmclock_setup_percpu */
	.byte 0x0d, 0x74, 0x6b, 0x76, 0x6d, 0x63, 0xa4, 0xf6, 0xd4, 0xcd, 0xec, 0xf5, 0x63, 0x9c	/* tkvmclock_setup_percpu */
	.byte 0x0a, 0xef, 0x6b, 0x76, 0x6d, 0x86, 0x93, 0xc9, 0x6b, 0x68, 0x7a	/* t__pfx_kvm_get_tsc_khz */
	.byte 0x0a, 0x74, 0x6b, 0x76, 0x6d, 0x86, 0x93, 0xc9, 0x6b, 0x68, 0x7a	/* tkvm_get_tsc_khz */
	.byte 0x0c, 0xef, 0x6b, 0x76, 0x6d, 0xf0, 0xa4, 0x86, 0x63, 0x79, 0x63, 0x6c, 0xd6	/* t__pfx_kvm_clock_get_cycles */
	.byte 0x0c, 0x74, 0x6b, 0x76, 0x6d, 0xf0, 0xa4, 0x86, 0x63, 0x79, 0x63, 0x6c, 0xd6	/* tkvm_clock_get_cycles */
	.byte 0x09, 0xef, 0x6b, 0x76, 0x6d, 0x86, 0x77, 0x5d, 0x63, 0xa4	/* t__pfx_kvm_get_wallclock */
	.byte 0x09, 0x74, 0x6b, 0x76, 0x6d, 0x86, 0x77, 0x5d, 0x63, 0xa4	/* tkvm_get_wallclock */
	.byte 0x0f, 0xef, 0x6b, 0x76, 0x6d, 0xf6, 0xd4, 0xcd, 0xf6, 0xb4, 0xe7, 0x64, 0xc5, 0x79, 0xf0, 0xa4	/* t__pfx_kvm_setup_secondary_clock */
	.byte 0x0f, 0x74, 0x6b, 0x76, 0x6d, 0xf6, 0xd4, 0xcd, 0xf6, 0xb4, 0xe7, 0x64, 0xc5, 0x79, 0xf0, 0xa4	/* tkvm_setup_secondary_clock */
	.byte 0x0f, 0xef, 0x6b, 0x76, 0x6d, 0x07, 0x74, 0xd5, 0xfc, 0x73, 0xba, 0x9e, 0xf0, 0xa4, 0xa9, 0x2c	/* t__pfx_kvm_restore_sched_clock_state */
	.byte 0x0f, 0x74, 0x6b, 0x76, 0x6d, 0x07, 0x74, 0xd5, 0xfc, 0x73, 0xba, 0x9e, 0xf0, 0xa4, 0xa9, 0x2c	/* tkvm_restore_sched_clock_state */
	.byte 0x14, 0xeb, 0x6b, 0x76, 0x6d, 0x25, 0x65, 0xc6, 0x5f, 0x05, 0xf0, 0xc4, 0xc5, 0xc7, 0x75, 0xd6, 0xfe, 0x70, 0x61, 0xb1, 0x9e	/* T__pfx_kvm_check_and_clear_guest_paused */
	.byte 0x14, 0x54, 0x6b, 0x76, 0x6d, 0x25, 0x65, 0xc6, 0x5f, 0x05, 0xf0, 0xc4, 0xc5, 0xc7, 0x75, 0xd6, 0xfe, 0x70, 0x61, 0xb1, 0x9e	/* Tkvm_check_and_clear_guest_paused */
	.byte 0x0a, 0xeb, 0x6b, 0x76, 0x6d, 0x63, 0xa4, 0xed, 0xca, 0x90, 0xc4	/* T__pfx_kvmclock_disable */
	.byte 0x0a, 0x54, 0x6b, 0x76, 0x6d, 0x63, 0xa4, 0xed, 0xca, 0x90, 0xc4	/* Tkvmclock_disable */
	.byte 0x0a, 0xef, 0x6e, 0xe8, 0x69, 0x1a, 0x73, 0x2c, 0xe5, 0xf0, 0xa4	/* t__pfx_native_steal_clock */
	.byte 0x0a, 0x74, 0x6e, 0xe8, 0x69, 0x1a, 0x73, 0x2c, 0xe5, 0xf0, 0xa4	/* tnative_steal_clock */
	.byte 0x0c, 0xef, 0x6e, 0xe8, 0x69, 0x1a, 0x23, 0x62, 0xde, 0x17, 0x1a, 0xe0, 0xc4	/* t__pfx_native_tlb_remove_table */
	.byte 0x0c, 0x74, 0x6e, 0xe8, 0x69, 0x1a, 0x23, 0x62, 0xde, 0x17, 0x1a, 0xe0, 0xc4	/* tnative_tlb_remove_table */
	.byte 0x0e, 0xeb, 0x70, 0xc5, 0x61, 0x76, 0xab, 0xfe, 0x73, 0xe2, 0x73, 0xba, 0x9e, 0xf0, 0xa4	/* T__pfx_paravirt_set_sched_clock */
	.byte 0x0e, 0x54, 0x70, 0xc5, 0x61, 0x76, 0xab, 0xfe, 0x73, 0xe2, 0x73, 0xba, 0x9e, 0xf0, 0xa4	/* Tparavirt_set_sched_clock */
	.byte 0x10, 0xeb, 0x70, 0xc5, 0x61, 0x76, 0xab, 0xfe, 0x64, 0xca, 0x90, 0xb0, 0xc0, 0x73, 0x70, 0xf2, 0x65	/* T__pfx_paravirt_disable_iospace */
	.byte 0x10, 0x54, 0x70, 0xc5, 0x61, 0x76, 0xab, 0xfe, 0x64, 0xca, 0x90, 0xb0, 0xc0, 0x73, 0x70, 0xf2, 0x65	/* Tparavirt_disable_iospace */
	.byte 0x0f, 0xeb, 0x70, 0x76, 0x63, 0xa4, 0x86, 0x70, 0x76, 0xdc, 0xf0, 0x9c, 0x30, 0x5f, 0x76, 0x61	/* T__pfx_pvclock_get_pvti_cpu0_va */
	.byte 0x0f, 0x54, 0x70, 0x76, 0x63, 0xa4, 0x86, 0x70, 0x76, 0xdc, 0xf0, 0x9c, 0x30, 0x5f, 0x76, 0x61	/* Tpvclock_get_pvti_cpu0_va */
	.byte 0x0a, 0xeb, 0x70, 0x76, 0x63, 0xa4, 0x84, 0x66, 0x6c, 0x83, 0x73	/* T__pfx_pvclock_set_flags */
	.byte 0x0a, 0x54, 0x70, 0x76, 0x63, 0xa4, 0x84, 0x66, 0x6c, 0x83, 0x73	/* Tpvclock_set_flags */
	.byte 0x0b, 0xeb, 0x70, 0x76, 0x63, 0xa4, 0xa7, 0x73, 0xc9, 0x6b, 0x68, 0x7a	/* T__pfx_pvclock_tsc_khz */
	.byte 0x0b, 0x54, 0x70, 0x76, 0x63, 0xa4, 0xa7, 0x73, 0xc9, 0x6b, 0x68, 0x7a	/* Tpvclock_tsc_khz */
	.byte 0x10, 0xeb, 0x70, 0x76, 0x63, 0xa4, 0xa7, 0x6f, 0x75, 0xba, 0x92, 0xe8, 0xba, 0x64, 0x6f, 0x67, 0x73	/* T__pfx_pvclock_touch_watchdogs */
	.byte 0x10, 0x54, 0x70, 0x76, 0x63, 0xa4, 0xa7, 0x6f, 0x75, 0xba, 0x92, 0xe8, 0xba, 0x64, 0x6f, 0x67, 0x73	/* Tpvclock_touch_watchdogs */
	.byte 0x08, 0xeb, 0x70, 0x76, 0x63, 0xa4, 0x07, 0x75, 0xa8	/* T__pfx_pvclock_resume */
	.byte 0x08, 0x54, 0x70, 0x76, 0x63, 0xa4, 0x07, 0x75, 0xa8	/* Tpvclock_resume */
	.byte 0x0b, 0xeb, 0x70, 0x76, 0x63, 0xa4, 0xde, 0xc8, 0xe6, 0x6c, 0x83, 0x73	/* T__pfx_pvclock_read_flags */
	.byte 0x0b, 0x54, 0x70, 0x76, 0x63, 0xa4, 0xde, 0xc8, 0xe6, 0x6c, 0x83, 0x73	/* Tpvclock_read_flags */
	.byte 0x0e, 0xeb, 0x70, 0x76, 0x63, 0xa4, 0xf0, 0xa4, 0x73, 0x6f, 0x98, 0x63, 0xfc, 0xf7, 0xc8	/* T__pfx_pvclock_clocksource_read */
	.byte 0x0e, 0x54, 0x70, 0x76, 0x63, 0xa4, 0xf0, 0xa4, 0x73, 0x6f, 0x98, 0x63, 0xfc, 0xf7, 0xc8	/* Tpvclock_clocksource_read */
	.byte 0x0c, 0xeb, 0x70, 0x76, 0x63, 0xa4, 0xde, 0x61, 0xda, 0x77, 0x5d, 0x63, 0xa4	/* T__pfx_pvclock_read_wallclock */
	.byte 0x0c, 0x54, 0x70, 0x76, 0x63, 0xa4, 0xde, 0x61, 0xda, 0x77, 0x5d, 0x63, 0xa4	/* Tpvclock_read_wallclock */
	.byte 0x0f, 0xeb, 0x70, 0x76, 0x63, 0xa4, 0x84, 0x70, 0x76, 0xdc, 0xf0, 0x9c, 0x30, 0x5f, 0x76, 0x61	/* T__pfx_pvclock_set_pvti_cpu0_va */
	.byte 0x0f, 0x54, 0x70, 0x76, 0x63, 0xa4, 0x84, 0x70, 0x76, 0xdc, 0xf0, 0x9c, 0x30, 0x5f, 0x76, 0x61	/* Tpvclock_set_pvti_cpu0_va */
	.byte 0x13, 0xef, 0x3d, 0x72, 0xfe, 0x19, 0xc0, 0x64, 0xaa, 0x25, 0x65, 0xc6, 0xe6, 0xd5, 0xf0, 0xd5, 0x72, 0xcd, 0xdc, 0xe7	/* t__pfx_start_periodic_check_for_corruption */
	.byte 0x13, 0x93, 0xf4, 0x72, 0xfe, 0x19, 0xc0, 0x64, 0xaa, 0x25, 0x65, 0xc6, 0xe6, 0xd5, 0xf0, 0xd5, 0x72, 0xcd, 0xdc, 0xe7	/* tstart_periodic_check_for_corruption */
	.byte 0x0a, 0xef, 0xba, 0x65, 0xc6, 0xf0, 0xd5, 0x72, 0xcd, 0xdc, 0xe7	/* t__pfx_check_corruption */
	.byte 0x0a, 0x74, 0xba, 0x65, 0xc6, 0xf0, 0xd5, 0x72, 0xcd, 0xdc, 0xe7	/* tcheck_corruption */
	.byte 0x0e, 0xef, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x70, 0x72, 0xfc, 0x78, 0xa0, 0x5f, 0xbe	/* t__pfx_default_pre_xol_op */
	.byte 0x0e, 0x74, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x70, 0x72, 0xfc, 0x78, 0xa0, 0x5f, 0xbe	/* tdefault_pre_xol_op */
	.byte 0x0d, 0xef, 0x62, 0x72, 0xd2, 0xba, 0xec, 0x6f, 0x73, 0xfe, 0x78, 0xa0, 0x5f, 0xbe	/* t__pfx_branch_post_xol_op */
	.byte 0x0d, 0x74, 0x62, 0x72, 0xd2, 0xba, 0xec, 0x6f, 0x73, 0xfe, 0x78, 0xa0, 0x5f, 0xbe	/* tbranch_post_xol_op */
	.byte 0x0f, 0xef, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x70, 0x6f, 0x73, 0xfe, 0x78, 0xa0, 0x5f, 0xbe	/* t__pfx_default_post_xol_op */
	.byte 0x0f, 0x74, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x70, 0x6f, 0x73, 0xfe, 0x78, 0xa0, 0x5f, 0xbe	/* tdefault_post_xol_op */
	.byte 0x0b, 0xef, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x90, 0xd5, 0xfe, 0xbe	/* t__pfx_default_abort_op */
	.byte 0x0b, 0x74, 0x64, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x90, 0xd5, 0xfe, 0xbe	/* tdefault_abort_op */
	.byte 0x0a, 0xef, 0x70, 0xb1, 0x68, 0x5f, 0x65, 0x6d, 0x02, 0x91, 0xbe	/* t__pfx_push_emulate_op */
	.byte 0x09, 0xce, 0xb1, 0x68, 0x5f, 0x65, 0x6d, 0x02, 0x91, 0xbe	/* tpush_emulate_op */
	.byte 0x0b, 0xef, 0x62, 0x72, 0xd2, 0xba, 0x5f, 0x65, 0x6d, 0x02, 0x91, 0xbe	/* t__pfx_branch_emulate_op */
	.byte 0x0b, 0x74, 0x62, 0x72, 0xd2, 0xba, 0x5f, 0x65, 0x6d, 0x02, 0x91, 0xbe	/* tbranch_emulate_op */
	.byte 0x0d, 0xeb, 0xc5, 0xba, 0x5f, 0xcd, 0x8c, 0xfc, 0xf3, 0x61, 0xb6, 0xa0, 0xf8, 0x65	/* T__pfx_arch_uprobe_trampoline */
	.byte 0x0d, 0x54, 0xc5, 0xba, 0x5f, 0xcd, 0x8c, 0xfc, 0xf3, 0x61, 0xb6, 0xa0, 0xf8, 0x65	/* Tarch_uprobe_trampoline */
	.byte 0x0b, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0xe9, 0x75, 0xf7, 0xce, 0x8c, 0x65	/* t__pfx___do_sys_uretprobe */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x75, 0xf7, 0xce, 0x8c, 0x65	/* T__pfx___ia32_sys_uretprobe */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x75, 0xf7, 0xce, 0x8c, 0x65	/* T__pfx___x64_sys_uretprobe */
	.byte 0x0b, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0xe9, 0x75, 0xf7, 0xce, 0x8c, 0x65	/* t__do_sys_uretprobe */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x75, 0xf7, 0xce, 0x8c, 0x65	/* T__ia32_sys_uretprobe */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x75, 0xf7, 0xce, 0x8c, 0x65	/* T__x64_sys_uretprobe */
	.byte 0x0f, 0xeb, 0xc5, 0xba, 0x5f, 0xcd, 0x8c, 0xfc, 0xd2, 0xe5, 0x79, 0x7a, 0xfc, 0xf8, 0x73, 0x6e	/* T__pfx_arch_uprobe_analyze_insn */
	.byte 0x0f, 0x54, 0xc5, 0xba, 0x5f, 0xcd, 0x8c, 0xfc, 0xd2, 0xe5, 0x79, 0x7a, 0xfc, 0xf8, 0x73, 0x6e	/* Tarch_uprobe_analyze_insn */
	.byte 0x0c, 0xeb, 0xc5, 0xba, 0x5f, 0xcd, 0x8c, 0xfc, 0x70, 0x72, 0xfc, 0x78, 0xa0	/* T__pfx_arch_uprobe_pre_xol */
	.byte 0x0c, 0x54, 0xc5, 0xba, 0x5f, 0xcd, 0x8c, 0xfc, 0x70, 0x72, 0xfc, 0x78, 0xa0	/* Tarch_uprobe_pre_xol */
	.byte 0x11, 0xeb, 0xc5, 0xba, 0x5f, 0xcd, 0x8c, 0xfc, 0x78, 0xa0, 0x92, 0x61, 0xe9, 0xf3, 0x61, 0x70, 0x70, 0x9e	/* T__pfx_arch_uprobe_xol_was_trapped */
	.byte 0x11, 0x54, 0xc5, 0xba, 0x5f, 0xcd, 0x8c, 0xfc, 0x78, 0xa0, 0x92, 0x61, 0xe9, 0xf3, 0x61, 0x70, 0x70, 0x9e	/* Tarch_uprobe_xol_was_trapped */
	.byte 0x0d, 0xeb, 0xc5, 0xba, 0x5f, 0xcd, 0x8c, 0xfc, 0x70, 0x6f, 0x73, 0xfe, 0x78, 0xa0	/* T__pfx_arch_uprobe_post_xol */
	.byte 0x0d, 0x54, 0xc5, 0xba, 0x5f, 0xcd, 0x8c, 0xfc, 0x70, 0x6f, 0x73, 0xfe, 0x78, 0xa0	/* Tarch_uprobe_post_xol */
	.byte 0x12, 0xeb, 0xc5, 0xba, 0x5f, 0xcd, 0x8c, 0xfc, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0xbd, 0x6f, 0xdc, 0x66, 0x79	/* T__pfx_arch_uprobe_exception_notify */
	.byte 0x12, 0x54, 0xc5, 0xba, 0x5f, 0xcd, 0x8c, 0xfc, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0xbd, 0x6f, 0xdc, 0x66, 0x79	/* Tarch_uprobe_exception_notify */
	.byte 0x0c, 0xeb, 0xc5, 0xba, 0x5f, 0xcd, 0x8c, 0xfc, 0x90, 0xd5, 0xfe, 0x78, 0xa0	/* T__pfx_arch_uprobe_abort_xol */
	.byte 0x0c, 0x54, 0xc5, 0xba, 0x5f, 0xcd, 0x8c, 0xfc, 0x90, 0xd5, 0xfe, 0x78, 0xa0	/* Tarch_uprobe_abort_xol */
	.byte 0x0d, 0xeb, 0xc5, 0xba, 0x5f, 0xcd, 0x8c, 0xfc, 0x5e, 0x28, 0xf6, 0x73, 0x2c, 0x70	/* T__pfx_arch_uprobe_skip_sstep */
	.byte 0x0d, 0x54, 0xc5, 0xba, 0x5f, 0xcd, 0x8c, 0xfc, 0x5e, 0x28, 0xf6, 0x73, 0x2c, 0x70	/* Tarch_uprobe_skip_sstep */
	.byte 0x15, 0xeb, 0xc5, 0xba, 0x5f, 0x75, 0xf7, 0xce, 0x8c, 0xfc, 0x68, 0x69, 0x6a, 0xf2, 0x6b, 0xde, 0x74, 0x98, 0x6e, 0x5f, 0xc8, 0xac	/* T__pfx_arch_uretprobe_hijack_return_addr */
	.byte 0x15, 0x54, 0xc5, 0xba, 0x5f, 0x75, 0xf7, 0xce, 0x8c, 0xfc, 0x68, 0x69, 0x6a, 0xf2, 0x6b, 0xde, 0x74, 0x98, 0x6e, 0x5f, 0xc8, 0xac	/* Tarch_uretprobe_hijack_return_addr */
	.byte 0x0f, 0xeb, 0xc5, 0xba, 0x5f, 0x75, 0xf7, 0xce, 0x8c, 0xfc, 0x69, 0xe9, 0xe5, 0x69, 0x76, 0x65	/* T__pfx_arch_uretprobe_is_alive */
	.byte 0x0f, 0x54, 0xc5, 0xba, 0x5f, 0x75, 0xf7, 0xce, 0x8c, 0xfc, 0x69, 0xe9, 0xe5, 0x69, 0x76, 0x65	/* Tarch_uretprobe_is_alive */
	.byte 0x0a, 0xeb, 0x19, 0x66, 0xde, 0x67, 0x5f, 0x76, 0xe5, 0x75, 0x65	/* T__pfx_perf_reg_value */
	.byte 0x0a, 0x54, 0x19, 0x66, 0xde, 0x67, 0x5f, 0x76, 0xe5, 0x75, 0x65	/* Tperf_reg_value */
	.byte 0x0a, 0xeb, 0x19, 0x66, 0xde, 0x67, 0x5f, 0x76, 0xe5, 0x9f, 0x14	/* T__pfx_perf_reg_validate */
	.byte 0x0a, 0x54, 0x19, 0x66, 0xde, 0x67, 0x5f, 0x76, 0xe5, 0x9f, 0x14	/* Tperf_reg_validate */
	.byte 0x08, 0xeb, 0x19, 0x66, 0xde, 0x67, 0x5f, 0x90, 0x69	/* T__pfx_perf_reg_abi */
	.byte 0x08, 0x54, 0x19, 0x66, 0xde, 0x67, 0x5f, 0x90, 0x69	/* Tperf_reg_abi */
	.byte 0x09, 0xeb, 0x19, 0x66, 0x86, 0xf7, 0x67, 0xe9, 0xb1, 0xf5	/* T__pfx_perf_get_regs_user */
	.byte 0x09, 0x54, 0x19, 0x66, 0x86, 0xf7, 0x67, 0xe9, 0xb1, 0xf5	/* Tperf_get_regs_user */
	.byte 0x0b, 0xeb, 0xc3, 0x70, 0x83, 0x65, 0x66, 0x61, 0x02, 0xfe, 0xf7, 0x67	/* T__pfx_trace_pagefault_reg */
	.byte 0x0b, 0x54, 0xc3, 0x70, 0x83, 0x65, 0x66, 0x61, 0x02, 0xfe, 0xf7, 0x67	/* Ttrace_pagefault_reg */
	.byte 0x0c, 0xeb, 0xc3, 0x70, 0x83, 0x65, 0x66, 0x61, 0x02, 0xfe, 0xe4, 0xf7, 0x67	/* T__pfx_trace_pagefault_unreg */
	.byte 0x0c, 0x54, 0xc3, 0x70, 0x83, 0x65, 0x66, 0x61, 0x02, 0xfe, 0xe4, 0xf7, 0x67	/* Ttrace_pagefault_unreg */
	.byte 0x0f, 0xef, 0x73, 0xba, 0x65, 0xda, 0xea, 0x6d, 0xfe, 0xcd, 0x64, 0x91, 0x68, 0x05, 0x6c, 0xf5	/* t__pfx_sched_itmt_update_handler */
	.byte 0x0e, 0x93, 0xba, 0x65, 0xda, 0xea, 0x6d, 0xfe, 0xcd, 0x64, 0x91, 0x68, 0x05, 0x6c, 0xf5	/* tsched_itmt_update_handler */
	.byte 0x0d, 0xeb, 0x73, 0xba, 0x9e, 0x84, 0xea, 0x6d, 0xfe, 0x73, 0xcd, 0x70, 0xd5, 0x74	/* T__pfx_sched_set_itmt_support */
	.byte 0x0d, 0x54, 0x73, 0xba, 0x9e, 0x84, 0xea, 0x6d, 0xfe, 0x73, 0xcd, 0x70, 0xd5, 0x74	/* Tsched_set_itmt_support */
	.byte 0x10, 0xeb, 0x73, 0xba, 0x9e, 0xf0, 0xc4, 0xc5, 0x5f, 0xea, 0x6d, 0xfe, 0x73, 0xcd, 0x70, 0xd5, 0x74	/* T__pfx_sched_clear_itmt_support */
	.byte 0x10, 0x54, 0x73, 0xba, 0x9e, 0xf0, 0xc4, 0xc5, 0x5f, 0xea, 0x6d, 0xfe, 0x73, 0xcd, 0x70, 0xd5, 0x74	/* Tsched_clear_itmt_support */
	.byte 0x0e, 0xeb, 0xc5, 0xba, 0x5f, 0x61, 0xd3, 0xf0, 0x9c, 0xec, 0x72, 0x69, 0xd5, 0xea, 0x79	/* T__pfx_arch_asym_cpu_priority */
	.byte 0x0e, 0x54, 0xc5, 0xba, 0x5f, 0x61, 0xd3, 0xf0, 0x9c, 0xec, 0x72, 0x69, 0xd5, 0xea, 0x79	/* Tarch_asym_cpu_priority */
	.byte 0x0e, 0xeb, 0x73, 0xba, 0x9e, 0x84, 0xea, 0x6d, 0xfe, 0x63, 0xd5, 0xfc, 0x70, 0x72, 0xc0	/* T__pfx_sched_set_itmt_core_prio */
	.byte 0x0e, 0x54, 0x73, 0xba, 0x9e, 0x84, 0xea, 0x6d, 0xfe, 0x63, 0xd5, 0xfc, 0x70, 0x72, 0xc0	/* Tsched_set_itmt_core_prio */
	.byte 0x08, 0xef, 0x75, 0x6d, 0x28, 0xec, 0x72, 0xb3, 0x6b	/* t__pfx_umip_printk */
	.byte 0x08, 0x74, 0x75, 0x6d, 0x28, 0xec, 0x72, 0xb3, 0x6b	/* tumip_printk */
	.byte 0x0f, 0xeb, 0xa5, 0x78, 0xcd, 0x5f, 0x75, 0x6d, 0x28, 0x5f, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7	/* T__pfx_fixup_umip_exception */
	.byte 0x0f, 0x54, 0xa5, 0x78, 0xcd, 0x5f, 0x75, 0x6d, 0x28, 0x5f, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7	/* Tfixup_umip_exception */
	.byte 0x08, 0x74, 0xaf, 0x5f, 0xd5, 0x63, 0xe6, 0xf8, 0x64	/* t__pfx___orc_find */
	.byte 0x07, 0x74, 0xff, 0xd5, 0x63, 0xe6, 0xf8, 0x64	/* t__orc_find */
	.byte 0x0a, 0xef, 0xd5, 0x63, 0xf6, 0xd5, 0xfe, 0x73, 0x77, 0x61, 0x70	/* t__pfx_orc_sort_swap */
	.byte 0x0a, 0x74, 0xd5, 0x63, 0xf6, 0xd5, 0xfe, 0x73, 0x77, 0x61, 0x70	/* torc_sort_swap */
	.byte 0x08, 0xef, 0xd5, 0x63, 0xf6, 0xd5, 0xfe, 0x63, 0xb6	/* t__pfx_orc_sort_cmp */
	.byte 0x08, 0x74, 0xd5, 0x63, 0xf6, 0xd5, 0xfe, 0x63, 0xb6	/* torc_sort_cmp */
	.byte 0x10, 0xeb, 0xe4, 0x77, 0xf8, 0xda, 0x67, 0xe2, 0xf7, 0x74, 0x98, 0x6e, 0x5f, 0xc8, 0x64, 0x29, 0x73	/* T__pfx_unwind_get_return_address */
	.byte 0x10, 0x54, 0xe4, 0x77, 0xf8, 0xda, 0x67, 0xe2, 0xf7, 0x74, 0x98, 0x6e, 0x5f, 0xc8, 0x64, 0x29, 0x73	/* Tunwind_get_return_address */
	.byte 0x08, 0xef, 0xe4, 0x77, 0xf8, 0x64, 0xed, 0x75, 0xb6	/* t__pfx_unwind_dump */
	.byte 0x08, 0x74, 0xe4, 0x77, 0xf8, 0x64, 0xed, 0x75, 0xb6	/* tunwind_dump */
	.byte 0x0a, 0xef, 0x3d, 0xc6, 0x5f, 0xf2, 0x63, 0xd6, 0xe9, 0x6f, 0x6b	/* t__pfx_stack_access_ok */
	.byte 0x0a, 0x93, 0xf4, 0xc6, 0x5f, 0xf2, 0x63, 0xd6, 0xe9, 0x6f, 0x6b	/* tstack_access_ok */
	.byte 0x0b, 0xeb, 0xe4, 0x77, 0xf8, 0xda, 0x6e, 0xcb, 0xfe, 0x66, 0xbc, 0xa8	/* T__pfx_unwind_next_frame */
	.byte 0x0b, 0x54, 0xe4, 0x77, 0xf8, 0xda, 0x6e, 0xcb, 0xfe, 0x66, 0xbc, 0xa8	/* Tunwind_next_frame */
	.byte 0x08, 0x08, 0xe4, 0x77, 0xf8, 0x64, 0xa9, 0x72, 0x74	/* T__pfx___unwind_start */
	.byte 0x08, 0xb9, 0xe4, 0x77, 0xf8, 0x64, 0xa9, 0x72, 0x74	/* T__unwind_start */
	.byte 0x0a, 0xeb, 0xe4, 0x77, 0xf8, 0xda, 0x6d, 0xb7, 0x75, 0xb0, 0x0f	/* T__pfx_unwind_module_init */
	.byte 0x0a, 0x54, 0xe4, 0x77, 0xf8, 0xda, 0x6d, 0xb7, 0x75, 0xb0, 0x0f	/* Tunwind_module_init */
	.byte 0x12, 0xeb, 0xe4, 0x77, 0xf8, 0xda, 0x67, 0xe2, 0xf7, 0x74, 0x98, 0x6e, 0x5f, 0xc8, 0x64, 0x29, 0x73, 0xec, 0xf3	/* T__pfx_unwind_get_return_address_ptr */
	.byte 0x12, 0x54, 0xe4, 0x77, 0xf8, 0xda, 0x67, 0xe2, 0xf7, 0x74, 0x98, 0x6e, 0x5f, 0xc8, 0x64, 0x29, 0x73, 0xec, 0xf3	/* Tunwind_get_return_address_ptr */
	.byte 0x06, 0xef, 0xca, 0x3a, 0xf7, 0x74, 0x8e	/* t__pfx_is_coretext */
	.byte 0x06, 0xdc, 0x73, 0x3a, 0xf7, 0x74, 0x8e	/* tis_coretext */
	.byte 0x06, 0xef, 0x70, 0xe8, 0xba, 0xed, 0x60	/* t__pfx_patch_dest */
	.byte 0x05, 0xce, 0xe8, 0xba, 0xed, 0x60	/* tpatch_dest */
	.byte 0x06, 0xef, 0x63, 0x5d, 0x86, 0x64, 0x60	/* t__pfx_call_get_dest */
	.byte 0x05, 0x26, 0x5d, 0x86, 0x64, 0x60	/* tcall_get_dest */
	.byte 0x06, 0xef, 0x70, 0xe8, 0xba, 0xf0, 0x5d	/* t__pfx_patch_call */
	.byte 0x05, 0xce, 0xe8, 0xba, 0xf0, 0x5d	/* tpatch_call */
	.byte 0x0b, 0xef, 0x63, 0x5d, 0x74, 0x68, 0xe4, 0x6b, 0x73, 0xf6, 0xd4, 0xcd	/* t__pfx_callthunks_setup */
	.byte 0x0a, 0x26, 0x5d, 0x74, 0x68, 0xe4, 0x6b, 0x73, 0xf6, 0xd4, 0xcd	/* tcallthunks_setup */
	.byte 0x11, 0xeb, 0x63, 0x5d, 0x74, 0x68, 0xe4, 0x6b, 0xe9, 0xf3, 0xd2, 0x73, 0x6c, 0x91, 0x63, 0x5d, 0xed, 0x60	/* T__pfx_callthunks_translate_call_dest */
	.byte 0x11, 0x54, 0x63, 0x5d, 0x74, 0x68, 0xe4, 0x6b, 0xe9, 0xf3, 0xd2, 0x73, 0x6c, 0x91, 0x63, 0x5d, 0xed, 0x60	/* Tcallthunks_translate_call_dest */
	.byte 0x12, 0xeb, 0x63, 0x5d, 0x74, 0x68, 0xe4, 0x6b, 0x73, 0xec, 0xe8, 0xba, 0xc1, 0xb7, 0x75, 0xb0, 0x63, 0x5d, 0x73	/* T__pfx_callthunks_patch_module_calls */
	.byte 0x12, 0x54, 0x63, 0x5d, 0x74, 0x68, 0xe4, 0x6b, 0x73, 0xec, 0xe8, 0xba, 0xc1, 0xb7, 0x75, 0xb0, 0x63, 0x5d, 0x73	/* Tcallthunks_patch_module_calls */
	.byte 0x11, 0xef, 0x64, 0x6f, 0x5f, 0xe4, 0xcb, 0x70, 0xb4, 0x74, 0x9e, 0xf0, 0x70, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__pfx_do_unexpected_cp.part.0 */
	.byte 0x11, 0x74, 0x64, 0x6f, 0x5f, 0xe4, 0xcb, 0x70, 0xb4, 0x74, 0x9e, 0xf0, 0x70, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* tdo_unexpected_cp.part.0 */
	.byte 0x0d, 0xeb, 0x61, 0x75, 0x64, 0x9d, 0x63, 0x6c, 0xbb, 0x85, 0x66, 0x1d, 0xc5, 0xba	/* T__pfx_audit_classify_arch */
	.byte 0x0d, 0x54, 0x61, 0x75, 0x64, 0x9d, 0x63, 0x6c, 0xbb, 0x85, 0x66, 0x1d, 0xc5, 0xba	/* Taudit_classify_arch */
	.byte 0x0f, 0xeb, 0x61, 0x75, 0x64, 0x9d, 0x63, 0x6c, 0xbb, 0x85, 0x66, 0x79, 0x7f, 0x73, 0x63, 0x5d	/* T__pfx_audit_classify_syscall */
	.byte 0x0f, 0x54, 0x61, 0x75, 0x64, 0x9d, 0x63, 0x6c, 0xbb, 0x85, 0x66, 0x79, 0x7f, 0x73, 0x63, 0x5d	/* Taudit_classify_syscall */
	.byte 0x07, 0xef, 0x63, 0xb6, 0xa6, 0xd2, 0x67, 0x65	/* t__pfx_cmp_range */
	.byte 0x06, 0x26, 0xb6, 0xa6, 0xd2, 0x67, 0x65	/* tcmp_range */
	.byte 0x11, 0xef, 0x67, 0xe2, 0x66, 0x2a, 0x31, 0x30, 0x68, 0xec, 0x9b, 0xc1, 0x6d, 0x40, 0x66, 0xb8, 0xbb, 0x65	/* t__pfx_get_fam10h_pci_mmconf_base */
	.byte 0x11, 0x74, 0x67, 0xe2, 0x66, 0x2a, 0x31, 0x30, 0x68, 0xec, 0x9b, 0xc1, 0x6d, 0x40, 0x66, 0xb8, 0xbb, 0x65	/* tget_fam10h_pci_mmconf_base */
	.byte 0x11, 0xeb, 0x66, 0x2a, 0x31, 0x30, 0x68, 0x25, 0x65, 0xc6, 0x0d, 0x90, 0xb0, 0x6d, 0x6d, 0x63, 0x66, 0x67	/* T__pfx_fam10h_check_enable_mmcfg */
	.byte 0x11, 0x54, 0x66, 0x2a, 0x31, 0x30, 0x68, 0x25, 0x65, 0xc6, 0x0d, 0x90, 0xb0, 0x6d, 0x6d, 0x63, 0x66, 0x67	/* Tfam10h_check_enable_mmcfg */
	.byte 0x0e, 0xeb, 0x63, 0xf2, 0x68, 0x65, 0x6d, 0xb7, 0x65, 0x32, 0x70, 0xe3, 0x74, 0x76, 0xe5	/* T__pfx_cachemode2protval */
	.byte 0x0e, 0x54, 0x63, 0xf2, 0x68, 0x65, 0x6d, 0xb7, 0x65, 0x32, 0x70, 0xe3, 0x74, 0x76, 0xe5	/* Tcachemode2protval */
	.byte 0x0b, 0xeb, 0x78, 0x38, 0x36, 0xa3, 0xbb, 0xec, 0x61, 0xfe, 0x77, 0x70	/* T__pfx_x86_has_pat_wp */
	.byte 0x0b, 0x54, 0x78, 0x38, 0x36, 0xa3, 0xbb, 0xec, 0x61, 0xfe, 0x77, 0x70	/* Tx86_has_pat_wp */
	.byte 0x0e, 0xeb, 0x70, 0x67, 0x70, 0xe3, 0x74, 0x32, 0x63, 0xf2, 0x68, 0x65, 0x6d, 0xb7, 0x65	/* T__pfx_pgprot2cachemode */
	.byte 0x0e, 0x54, 0x70, 0x67, 0x70, 0xe3, 0x74, 0x32, 0x63, 0xf2, 0x68, 0x65, 0x6d, 0xb7, 0x65	/* Tpgprot2cachemode */
	.byte 0x0d, 0xeb, 0x70, 0x66, 0x6e, 0xa6, 0xd2, 0x67, 0xfc, 0x69, 0xe9, 0x97, 0x70, 0x9e	/* T__pfx_pfn_range_is_mapped */
	.byte 0x0d, 0x54, 0x70, 0x66, 0x6e, 0xa6, 0xd2, 0x67, 0xfc, 0x69, 0xe9, 0x97, 0x70, 0x9e	/* Tpfn_range_is_mapped */
	.byte 0x09, 0xeb, 0xb5, 0xa8, 0xae, 0x69, 0xe9, 0x22, 0x77, 0x9e	/* T__pfx_devmem_is_allowed */
	.byte 0x09, 0x54, 0xb5, 0xa8, 0xae, 0x69, 0xe9, 0x22, 0x77, 0x9e	/* Tdevmem_is_allowed */
	.byte 0x09, 0xeb, 0x66, 0xf7, 0xfc, 0xf8, 0x9d, 0x70, 0x83, 0xd6	/* T__pfx_free_init_pages */
	.byte 0x09, 0x54, 0x66, 0xf7, 0xfc, 0xf8, 0x9d, 0x70, 0x83, 0xd6	/* Tfree_init_pages */
	.byte 0x10, 0xeb, 0x66, 0xf7, 0xfc, 0x6b, 0xf5, 0x6e, 0xdb, 0x5f, 0x69, 0xd9, 0x67, 0xfc, 0x70, 0x83, 0xd6	/* T__pfx_free_kernel_image_pages */
	.byte 0x10, 0x54, 0x66, 0xf7, 0xfc, 0x6b, 0xf5, 0x6e, 0xdb, 0x5f, 0x69, 0xd9, 0x67, 0xfc, 0x70, 0x83, 0xd6	/* Tfree_kernel_image_pages */
	.byte 0x0d, 0xeb, 0xcd, 0x64, 0x91, 0x63, 0xf2, 0x68, 0xfc, 0x6d, 0x16, 0xf1, 0xf3, 0x79	/* T__pfx_update_cache_mode_entry */
	.byte 0x0d, 0x54, 0xcd, 0x64, 0x91, 0x63, 0xf2, 0x68, 0xfc, 0x6d, 0x16, 0xf1, 0xf3, 0x79	/* Tupdate_cache_mode_entry */
	.byte 0x0f, 0xeb, 0xc5, 0xba, 0x5f, 0xd9, 0x78, 0xf6, 0x77, 0x61, 0x70, 0xa5, 0xb0, 0x85, 0x7a, 0x65	/* T__pfx_arch_max_swapfile_size */
	.byte 0x0f, 0x54, 0xc5, 0xba, 0x5f, 0xd9, 0x78, 0xf6, 0x77, 0x61, 0x70, 0xa5, 0xb0, 0x85, 0x7a, 0x65	/* Tarch_max_swapfile_size */
	.byte 0x08, 0xef, 0x9f, 0xf1, 0xfe, 0x70, 0x6d, 0xda, 0x0f	/* t__pfx_ident_pmd_init */
	.byte 0x08, 0xdc, 0x64, 0xf1, 0xfe, 0x70, 0x6d, 0xda, 0x0f	/* tident_pmd_init */
	.byte 0x07, 0xef, 0x9f, 0xf1, 0xfe, 0x9c, 0xda, 0x0f	/* t__pfx_ident_pud_init */
	.byte 0x07, 0xdc, 0x64, 0xf1, 0xfe, 0x9c, 0xda, 0x0f	/* tident_pud_init */
	.byte 0x07, 0xef, 0xa5, 0x6c, 0x6c, 0xec, 0x6d, 0x64	/* t__pfx_fill_pmd */
	.byte 0x07, 0x74, 0xa5, 0x6c, 0x6c, 0xec, 0x6d, 0x64	/* tfill_pmd */
	.byte 0x06, 0xef, 0xa5, 0x6c, 0x6c, 0xec, 0x2c	/* t__pfx_fill_pte */
	.byte 0x06, 0x74, 0xa5, 0x6c, 0x6c, 0xec, 0x2c	/* tfill_pte */
	.byte 0x08, 0xef, 0x9f, 0xf1, 0xfe, 0x70, 0x34, 0xda, 0x0f	/* t__pfx_ident_p4d_init */
	.byte 0x08, 0xdc, 0x64, 0xf1, 0xfe, 0x70, 0x34, 0xda, 0x0f	/* tident_p4d_init */
	.byte 0x0c, 0xef, 0xe1, 0x6e, 0xc9, 0x67, 0xdd, 0x62, 0xe5, 0xec, 0x67, 0x64, 0x73	/* t__pfx_sync_global_pgds */
	.byte 0x0c, 0x74, 0xe1, 0x6e, 0xc9, 0x67, 0xdd, 0x62, 0xe5, 0xec, 0x67, 0x64, 0x73	/* tsync_global_pgds */
	.byte 0x0a, 0xef, 0x6e, 0xe8, 0x69, 0x1a, 0x73, 0xe2, 0x70, 0x34, 0x64	/* t__pfx_native_set_p4d */
	.byte 0x0a, 0x74, 0x6e, 0xe8, 0x69, 0x1a, 0x73, 0xe2, 0x70, 0x34, 0x64	/* tnative_set_p4d */
	.byte 0x07, 0xef, 0xa5, 0x6c, 0x6c, 0xec, 0x75, 0x64	/* t__pfx_fill_pud */
	.byte 0x07, 0x74, 0xa5, 0x6c, 0x6c, 0xec, 0x75, 0x64	/* tfill_pud */
	.byte 0x0f, 0xeb, 0x6b, 0xf5, 0x6e, 0xdb, 0x5f, 0x9f, 0xf1, 0xfe, 0x97, 0x70, 0x8d, 0xe6, 0xf7, 0x65	/* T__pfx_kernel_ident_mapping_free */
	.byte 0x0f, 0x54, 0x6b, 0xf5, 0x6e, 0xdb, 0x5f, 0x9f, 0xf1, 0xfe, 0x97, 0x70, 0x8d, 0xe6, 0xf7, 0x65	/* Tkernel_ident_mapping_free */
	.byte 0x0e, 0xeb, 0x6b, 0xf5, 0x6e, 0xdb, 0x5f, 0x9f, 0xf1, 0xfe, 0x97, 0x70, 0x8d, 0xbf, 0xea	/* T__pfx_kernel_ident_mapping_init */
	.byte 0x0e, 0x54, 0x6b, 0xf5, 0x6e, 0xdb, 0x5f, 0x9f, 0xf1, 0xfe, 0x97, 0x70, 0x8d, 0xbf, 0xea	/* Tkernel_ident_mapping_init */
	.byte 0x0c, 0xeb, 0x73, 0xe2, 0x70, 0x74, 0xfc, 0x76, 0xc8, 0xac, 0xec, 0x34, 0x64	/* T__pfx_set_pte_vaddr_p4d */
	.byte 0x0c, 0x54, 0x73, 0xe2, 0x70, 0x74, 0xfc, 0x76, 0xc8, 0xac, 0xec, 0x34, 0x64	/* Tset_pte_vaddr_p4d */
	.byte 0x0c, 0xeb, 0x73, 0xe2, 0x70, 0x74, 0xfc, 0x76, 0xc8, 0xac, 0xec, 0x75, 0x64	/* T__pfx_set_pte_vaddr_pud */
	.byte 0x0c, 0x54, 0x73, 0xe2, 0x70, 0x74, 0xfc, 0x76, 0xc8, 0xac, 0xec, 0x75, 0x64	/* Tset_pte_vaddr_pud */
	.byte 0x09, 0xeb, 0x73, 0xe2, 0x70, 0x74, 0xfc, 0x76, 0xc8, 0xac	/* T__pfx_set_pte_vaddr */
	.byte 0x09, 0x54, 0x73, 0xe2, 0x70, 0x74, 0xfc, 0x76, 0xc8, 0xac	/* Tset_pte_vaddr */
	.byte 0x0a, 0xeb, 0xd9, 0x72, 0x6b, 0x5f, 0xe3, 0x64, 0x0a, 0x5f, 0xe3	/* T__pfx_mark_rodata_ro */
	.byte 0x0a, 0x54, 0xd9, 0x72, 0x6b, 0x5f, 0xe3, 0x64, 0x0a, 0x5f, 0xe3	/* Tmark_rodata_ro */
	.byte 0x0f, 0xeb, 0xa8, 0x6d, 0xd5, 0x79, 0xb8, 0xa4, 0xf6, 0x69, 0x7a, 0xfc, 0x62, 0x79, 0x74, 0xd6	/* T__pfx_memory_block_size_bytes */
	.byte 0x0f, 0x54, 0xa8, 0x6d, 0xd5, 0x79, 0xb8, 0xa4, 0xf6, 0x69, 0x7a, 0xfc, 0x62, 0x79, 0x74, 0xd6	/* Tmemory_block_size_bytes */
	.byte 0x0b, 0x08, 0x18, 0xec, 0x83, 0xfc, 0x66, 0x61, 0x02, 0xfe, 0xb1, 0xf5	/* T__pfx___traceiter_page_fault_user */
	.byte 0x0b, 0xb9, 0x18, 0xec, 0x83, 0xfc, 0x66, 0x61, 0x02, 0xfe, 0xb1, 0xf5	/* T__traceiter_page_fault_user */
	.byte 0x0c, 0x99, 0xec, 0x10, 0xec, 0x83, 0xfc, 0x66, 0x61, 0x02, 0xfe, 0xb1, 0xf5	/* T__pfx___probestub_page_fault_user */
	.byte 0x0c, 0x54, 0xfd, 0x10, 0xec, 0x83, 0xfc, 0x66, 0x61, 0x02, 0xfe, 0xb1, 0xf5	/* T__probestub_page_fault_user */
	.byte 0x0d, 0x08, 0x18, 0xec, 0x83, 0xfc, 0x66, 0x61, 0x02, 0xfe, 0x6b, 0xf5, 0x6e, 0xdb	/* T__pfx___traceiter_page_fault_kernel */
	.byte 0x0d, 0xb9, 0x18, 0xec, 0x83, 0xfc, 0x66, 0x61, 0x02, 0xfe, 0x6b, 0xf5, 0x6e, 0xdb	/* T__traceiter_page_fault_kernel */
	.byte 0x12, 0xef, 0x73, 0x9c, 0x72, 0xc0, 0x75, 0xe9, 0x6b, 0xf5, 0x6e, 0xdb, 0xe6, 0x61, 0x02, 0xfe, 0xba, 0x65, 0xc6	/* t__pfx_spurious_kernel_fault_check */
	.byte 0x11, 0x93, 0x9c, 0x72, 0xc0, 0x75, 0xe9, 0x6b, 0xf5, 0x6e, 0xdb, 0xe6, 0x61, 0x02, 0xfe, 0xba, 0x65, 0xc6	/* tspurious_kernel_fault_check */
	.byte 0x0f, 0xef, 0x19, 0x3b, 0xc3, 0x78, 0x38, 0x36, 0x5f, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0x73	/* t__pfx_perf_trace_x86_exceptions */
	.byte 0x0f, 0xce, 0xf5, 0x3b, 0xc3, 0x78, 0x38, 0x36, 0x5f, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0x73	/* tperf_trace_x86_exceptions */
	.byte 0x0f, 0xef, 0x7d, 0x7b, 0xcc, 0x78, 0x38, 0x36, 0x5f, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0x73	/* t__pfx_trace_event_raw_event_x86_exceptions */
	.byte 0x0f, 0x74, 0x7d, 0x7b, 0xcc, 0x78, 0x38, 0x36, 0x5f, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0x73	/* ttrace_event_raw_event_x86_exceptions */
	.byte 0x12, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x78, 0x38, 0x36, 0x5f, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0x73	/* t__pfx_trace_raw_output_x86_exceptions */
	.byte 0x12, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x78, 0x38, 0x36, 0x5f, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0x73	/* ttrace_raw_output_x86_exceptions */
	.byte 0x09, 0xef, 0x73, 0x7c, 0x5f, 0x6c, 0x64, 0x74, 0x93, 0x73	/* t__pfx_show_ldttss */
	.byte 0x08, 0x93, 0x7c, 0x5f, 0x6c, 0x64, 0x74, 0x93, 0x73	/* tshow_ldttss */
	.byte 0x0e, 0xef, 0xca, 0xec, 0xf7, 0x66, 0xd4, 0xba, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__pfx_is_prefetch.constprop.0 */
	.byte 0x0e, 0xdc, 0x73, 0xec, 0xf7, 0x66, 0xd4, 0xba, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* tis_prefetch.constprop.0 */
	.byte 0x0e, 0x99, 0xec, 0x10, 0xec, 0x83, 0xfc, 0x66, 0x61, 0x02, 0xfe, 0x6b, 0xf5, 0x6e, 0xdb	/* T__pfx___probestub_page_fault_kernel */
	.byte 0x0e, 0x54, 0xfd, 0x10, 0xec, 0x83, 0xfc, 0x66, 0x61, 0x02, 0xfe, 0x6b, 0xf5, 0x6e, 0xdb	/* T__probestub_page_fault_kernel */
	.byte 0x09, 0xef, 0x64, 0x75, 0xb6, 0xec, 0x83, 0x65, 0xe0, 0xc4	/* t__pfx_dump_pagetable */
	.byte 0x09, 0x74, 0x64, 0x75, 0xb6, 0xec, 0x83, 0x65, 0xe0, 0xc4	/* tdump_pagetable */
	.byte 0x0b, 0xef, 0x70, 0x83, 0xfc, 0x66, 0x61, 0x02, 0xfe, 0x6f, 0xbe, 0x73	/* t__pfx_page_fault_oops */
	.byte 0x0a, 0xce, 0x83, 0xfc, 0x66, 0x61, 0x02, 0xfe, 0x6f, 0xbe, 0x73	/* tpage_fault_oops */
	.byte 0x17, 0xef, 0x6b, 0xf5, 0x6e, 0xdb, 0x6d, 0x16, 0xa5, 0x78, 0xcd, 0x5f, 0xd5, 0x5f, 0x6f, 0xbe, 0x73, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__pfx_kernelmode_fixup_or_oops.constprop.0 */
	.byte 0x17, 0x74, 0x6b, 0xf5, 0x6e, 0xdb, 0x6d, 0x16, 0xa5, 0x78, 0xcd, 0x5f, 0xd5, 0x5f, 0x6f, 0xbe, 0x73, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* tkernelmode_fixup_or_oops.constprop.0 */
	.byte 0x07, 0xef, 0x70, 0x67, 0xe0, 0xb0, 0x62, 0xc8	/* t__pfx_pgtable_bad */
	.byte 0x06, 0xce, 0x67, 0xe0, 0xb0, 0x62, 0xc8	/* tpgtable_bad */
	.byte 0x10, 0x74, 0xaf, 0xb8, 0x61, 0xda, 0x61, 0xf7, 0x61, 0xbd, 0x6f, 0x73, 0x65, 0x97, 0x68, 0x6f, 0xf7	/* t__pfx___bad_area_nosemaphore */
	.byte 0x10, 0x74, 0xff, 0x62, 0x61, 0xda, 0x61, 0xf7, 0x61, 0xbd, 0x6f, 0x73, 0x65, 0x97, 0x68, 0x6f, 0xf7	/* t__bad_area_nosemaphore */
	.byte 0x0f, 0xef, 0x62, 0x61, 0xda, 0x61, 0xf7, 0x61, 0xbd, 0x6f, 0x73, 0x65, 0x97, 0x68, 0x6f, 0xf7	/* t__pfx_bad_area_nosemaphore */
	.byte 0x0f, 0x74, 0x62, 0x61, 0xda, 0x61, 0xf7, 0x61, 0xbd, 0x6f, 0x73, 0x65, 0x97, 0x68, 0x6f, 0xf7	/* tbad_area_nosemaphore */
	.byte 0x08, 0x74, 0xaf, 0xb8, 0x61, 0xda, 0x61, 0xf7, 0x61	/* t__pfx___bad_area */
	.byte 0x08, 0x74, 0xff, 0x62, 0x61, 0xda, 0x61, 0xf7, 0x61	/* t__bad_area */
	.byte 0x0f, 0xef, 0x62, 0x61, 0xda, 0x61, 0xf7, 0x61, 0x5f, 0xf2, 0x63, 0xd6, 0xe9, 0xf5, 0xe3, 0x72	/* t__pfx_bad_area_access_error */
	.byte 0x0f, 0x74, 0x62, 0x61, 0xda, 0x61, 0xf7, 0x61, 0x5f, 0xf2, 0x63, 0xd6, 0xe9, 0xf5, 0xe3, 0x72	/* tbad_area_access_error */
	.byte 0x08, 0xef, 0xf2, 0x63, 0xd6, 0xe9, 0xf5, 0xe3, 0x72	/* t__pfx_access_error */
	.byte 0x08, 0xf4, 0x63, 0x63, 0xd6, 0xe9, 0xf5, 0xe3, 0x72	/* taccess_error */
	.byte 0x0d, 0xef, 0x64, 0x6f, 0x5f, 0xb1, 0xf5, 0x5f, 0xc8, 0xac, 0xe6, 0x61, 0x02, 0x74	/* t__pfx_do_user_addr_fault */
	.byte 0x0d, 0x74, 0x64, 0x6f, 0x5f, 0xb1, 0xf5, 0x5f, 0xc8, 0xac, 0xe6, 0x61, 0x02, 0x74	/* tdo_user_addr_fault */
	.byte 0x0f, 0xef, 0x73, 0x9c, 0x72, 0xc0, 0x75, 0xe9, 0x6b, 0xf5, 0x6e, 0xdb, 0xe6, 0x61, 0x02, 0x74	/* t__pfx_spurious_kernel_fault */
	.byte 0x0e, 0x93, 0x9c, 0x72, 0xc0, 0x75, 0xe9, 0x6b, 0xf5, 0x6e, 0xdb, 0xe6, 0x61, 0x02, 0x74	/* tspurious_kernel_fault */
	.byte 0x0e, 0xef, 0x64, 0x6f, 0x5f, 0x6b, 0xf5, 0x6e, 0x5f, 0xc8, 0xac, 0xe6, 0x61, 0x02, 0x74	/* t__pfx_do_kern_addr_fault */
	.byte 0x0e, 0x74, 0x64, 0x6f, 0x5f, 0x6b, 0xf5, 0x6e, 0x5f, 0xc8, 0xac, 0xe6, 0x61, 0x02, 0x74	/* tdo_kern_addr_fault */
	.byte 0x0f, 0xeb, 0x66, 0x61, 0x02, 0xfe, 0xf8, 0x5f, 0x6b, 0xf5, 0x6e, 0xdb, 0xf6, 0x70, 0xf2, 0x65	/* T__pfx_fault_in_kernel_space */
	.byte 0x0f, 0x54, 0x66, 0x61, 0x02, 0xfe, 0xf8, 0x5f, 0x6b, 0xf5, 0x6e, 0xdb, 0xf6, 0x70, 0xf2, 0x65	/* Tfault_in_kernel_space */
	.byte 0x10, 0x74, 0xaf, 0x5f, 0xc0, 0xf7, 0x97, 0xf0, 0xa0, 0xc4, 0x63, 0xfe, 0x97, 0xe6, 0x6c, 0x83, 0x73	/* t__pfx___ioremap_collect_map_flags */
	.byte 0x0f, 0x74, 0xff, 0xc0, 0xf7, 0x97, 0xf0, 0xa0, 0xc4, 0x63, 0xfe, 0x97, 0xe6, 0x6c, 0x83, 0x73	/* t__ioremap_collect_map_flags */
	.byte 0x04, 0xeb, 0xc0, 0xe4, 0x97	/* T__pfx_iounmap */
	.byte 0x04, 0x54, 0xc0, 0xe4, 0x97	/* Tiounmap */
	.byte 0x10, 0x74, 0xaf, 0x5f, 0xc0, 0xf7, 0x97, 0xf0, 0x5d, 0xf5, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__pfx___ioremap_caller.constprop.0 */
	.byte 0x0f, 0x74, 0xff, 0xc0, 0xf7, 0x97, 0xf0, 0x5d, 0xf5, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__ioremap_caller.constprop.0 */
	.byte 0x07, 0xeb, 0xc0, 0xf7, 0x97, 0xec, 0xe3, 0x74	/* T__pfx_ioremap_prot */
	.byte 0x07, 0x54, 0xc0, 0xf7, 0x97, 0xec, 0xe3, 0x74	/* Tioremap_prot */
	.byte 0x08, 0xeb, 0xc0, 0xf7, 0x97, 0xf0, 0xf2, 0x68, 0x65	/* T__pfx_ioremap_cache */
	.byte 0x08, 0x54, 0xc0, 0xf7, 0x97, 0xf0, 0xf2, 0x68, 0x65	/* Tioremap_cache */
	.byte 0x0a, 0xeb, 0xc0, 0xf7, 0x97, 0x0d, 0x63, 0x72, 0x21, 0x74, 0x9e	/* T__pfx_ioremap_encrypted */
	.byte 0x0a, 0x54, 0xc0, 0xf7, 0x97, 0x0d, 0x63, 0x72, 0x21, 0x74, 0x9e	/* Tioremap_encrypted */
	.byte 0x06, 0xeb, 0xc0, 0xf7, 0x97, 0x92, 0x74	/* T__pfx_ioremap_wt */
	.byte 0x06, 0x54, 0xc0, 0xf7, 0x97, 0x92, 0x74	/* Tioremap_wt */
	.byte 0x06, 0xeb, 0xc0, 0xf7, 0x97, 0x92, 0x63	/* T__pfx_ioremap_wc */
	.byte 0x06, 0x54, 0xc0, 0xf7, 0x97, 0x92, 0x63	/* Tioremap_wc */
	.byte 0x07, 0xeb, 0xc0, 0xf7, 0x97, 0x5f, 0x75, 0x63	/* T__pfx_ioremap_uc */
	.byte 0x07, 0x54, 0xc0, 0xf7, 0x97, 0x5f, 0x75, 0x63	/* Tioremap_uc */
	.byte 0x04, 0xeb, 0xc0, 0xf7, 0x97	/* T__pfx_ioremap */
	.byte 0x04, 0x54, 0xc0, 0xf7, 0x97	/* Tioremap */
	.byte 0x09, 0xeb, 0xc0, 0xf7, 0x97, 0x25, 0xd2, 0x67, 0xfc, 0x24	/* T__pfx_ioremap_change_attr */
	.byte 0x09, 0x54, 0xc0, 0xf7, 0x97, 0x25, 0xd2, 0x67, 0xfc, 0x24	/* Tioremap_change_attr */
	.byte 0x0a, 0xeb, 0x78, 0x6c, 0x91, 0xb5, 0xc1, 0x65, 0x6d, 0xec, 0xf3	/* T__pfx_xlate_dev_mem_ptr */
	.byte 0x0a, 0x54, 0x78, 0x6c, 0x91, 0xb5, 0xc1, 0x65, 0x6d, 0xec, 0xf3	/* Txlate_dev_mem_ptr */
	.byte 0x0b, 0xeb, 0xe4, 0x78, 0x6c, 0x91, 0xb5, 0xc1, 0x65, 0x6d, 0xec, 0xf3	/* T__pfx_unxlate_dev_mem_ptr */
	.byte 0x0b, 0x54, 0xe4, 0x78, 0x6c, 0x91, 0xb5, 0xc1, 0x65, 0x6d, 0xec, 0xf3	/* Tunxlate_dev_mem_ptr */
	.byte 0x0c, 0xef, 0xcb, 0xa3, 0x05, 0x6c, 0xf5, 0x5f, 0x75, 0xf2, 0x63, 0xd6, 0x73	/* t__pfx_ex_handler_uaccess */
	.byte 0x0c, 0x74, 0xcb, 0xa3, 0x05, 0x6c, 0xf5, 0x5f, 0x75, 0xf2, 0x63, 0xd6, 0x73	/* tex_handler_uaccess */
	.byte 0x0b, 0xef, 0xcb, 0xa3, 0x05, 0x6c, 0xf5, 0x5f, 0x7a, 0xf5, 0xbe, 0xc8	/* t__pfx_ex_handler_zeropad */
	.byte 0x0b, 0x74, 0xcb, 0xa3, 0x05, 0x6c, 0xf5, 0x5f, 0x7a, 0xf5, 0xbe, 0xc8	/* tex_handler_zeropad */
	.byte 0x09, 0xef, 0xcb, 0xa3, 0x05, 0x6c, 0xf5, 0xc1, 0x73, 0x72	/* t__pfx_ex_handler_msr */
	.byte 0x09, 0x74, 0xcb, 0xa3, 0x05, 0x6c, 0xf5, 0xc1, 0x73, 0x72	/* tex_handler_msr */
	.byte 0x09, 0xeb, 0xcb, 0x86, 0xa5, 0x78, 0xcd, 0xa7, 0x21, 0x65	/* T__pfx_ex_get_fixup_type */
	.byte 0x09, 0x54, 0xcb, 0x86, 0xa5, 0x78, 0xcd, 0xa7, 0x21, 0x65	/* Tex_get_fixup_type */
	.byte 0x0b, 0xeb, 0xa5, 0x78, 0xcd, 0x5f, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7	/* T__pfx_fixup_exception */
	.byte 0x0b, 0x54, 0xa5, 0x78, 0xcd, 0x5f, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7	/* Tfixup_exception */
	.byte 0x0a, 0xef, 0x6d, 0x97, 0xb8, 0xbb, 0x65, 0x2e, 0xca, 0xbc, 0x7e	/* t__pfx_mmap_base.isra.0 */
	.byte 0x0a, 0x74, 0x6d, 0x97, 0xb8, 0xbb, 0x65, 0x2e, 0xca, 0xbc, 0x7e	/* tmmap_base.isra.0 */
	.byte 0x0b, 0xeb, 0xf4, 0x5e, 0xf6, 0x69, 0x7a, 0xfc, 0x33, 0x32, 0x62, 0xea	/* T__pfx_task_size_32bit */
	.byte 0x0b, 0x54, 0xf4, 0x5e, 0xf6, 0x69, 0x7a, 0xfc, 0x33, 0x32, 0x62, 0xea	/* Ttask_size_32bit */
	.byte 0x0b, 0xeb, 0xf4, 0x5e, 0xf6, 0x69, 0x7a, 0xfc, 0x36, 0x34, 0x62, 0xea	/* T__pfx_task_size_64bit */
	.byte 0x0b, 0x54, 0xf4, 0x5e, 0xf6, 0x69, 0x7a, 0xfc, 0x36, 0x34, 0x62, 0xea	/* Ttask_size_64bit */
	.byte 0x08, 0xeb, 0xc5, 0xba, 0xc1, 0x97, 0xa6, 0x6e, 0x64	/* T__pfx_arch_mmap_rnd */
	.byte 0x08, 0x54, 0xc5, 0xba, 0xc1, 0x97, 0xa6, 0x6e, 0x64	/* Tarch_mmap_rnd */
	.byte 0x0e, 0xeb, 0xc5, 0xba, 0xec, 0x69, 0xc6, 0xc1, 0x97, 0x5f, 0x6c, 0x61, 0x79, 0x6f, 0x20	/* T__pfx_arch_pick_mmap_layout */
	.byte 0x0e, 0x54, 0xc5, 0xba, 0xec, 0x69, 0xc6, 0xc1, 0x97, 0x5f, 0x6c, 0x61, 0x79, 0x6f, 0x20	/* Tarch_pick_mmap_layout */
	.byte 0x08, 0xeb, 0x67, 0xe2, 0x6d, 0x97, 0xb8, 0xbb, 0x65	/* T__pfx_get_mmap_base */
	.byte 0x08, 0x54, 0x67, 0xe2, 0x6d, 0x97, 0xb8, 0xbb, 0x65	/* Tget_mmap_base */
	.byte 0x0d, 0xeb, 0x6d, 0x97, 0x5f, 0xc8, 0x64, 0x29, 0xe9, 0x68, 0x27, 0x76, 0xe5, 0x9f	/* T__pfx_mmap_address_hint_valid */
	.byte 0x0d, 0x54, 0x6d, 0x97, 0x5f, 0xc8, 0x64, 0x29, 0xe9, 0x68, 0x27, 0x76, 0xe5, 0x9f	/* Tmmap_address_hint_valid */
	.byte 0x0e, 0xeb, 0x76, 0xe5, 0x9f, 0xec, 0x68, 0x79, 0xe9, 0xc8, 0xac, 0xa6, 0xd2, 0x67, 0x65	/* T__pfx_valid_phys_addr_range */
	.byte 0x0e, 0x54, 0x76, 0xe5, 0x9f, 0xec, 0x68, 0x79, 0xe9, 0xc8, 0xac, 0xa6, 0xd2, 0x67, 0x65	/* Tvalid_phys_addr_range */
	.byte 0x11, 0xeb, 0x76, 0xe5, 0x69, 0xda, 0x6d, 0x97, 0xec, 0x68, 0x79, 0xe9, 0xc8, 0xac, 0xa6, 0xd2, 0x67, 0x65	/* T__pfx_valid_mmap_phys_addr_range */
	.byte 0x11, 0x54, 0x76, 0xe5, 0x69, 0xda, 0x6d, 0x97, 0xec, 0x68, 0x79, 0xe9, 0xc8, 0xac, 0xa6, 0xd2, 0x67, 0x65	/* Tvalid_mmap_phys_addr_range */
	.byte 0x0c, 0xeb, 0x70, 0x66, 0x6e, 0xc1, 0xb7, 0x69, 0x66, 0x1d, 0x22, 0x77, 0x9e	/* T__pfx_pfn_modify_allowed */
	.byte 0x0c, 0x54, 0x70, 0x66, 0x6e, 0xc1, 0xb7, 0x69, 0x66, 0x1d, 0x22, 0x77, 0x9e	/* Tpfn_modify_allowed */
	.byte 0x10, 0x74, 0xaf, 0xbd, 0xe8, 0x69, 0x1a, 0x73, 0xe2, 0xa5, 0x78, 0x97, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__pfx___native_set_fixmap.part.0 */
	.byte 0x10, 0x74, 0xff, 0x6e, 0xe8, 0x69, 0x1a, 0x73, 0xe2, 0xa5, 0x78, 0x97, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__native_set_fixmap.part.0 */
	.byte 0x08, 0xeb, 0x70, 0x74, 0xfc, 0x22, 0xc9, 0xe7, 0x65	/* T__pfx_pte_alloc_one */
	.byte 0x08, 0x54, 0x70, 0x74, 0xfc, 0x22, 0xc9, 0xe7, 0x65	/* Tpte_alloc_one */
	.byte 0x09, 0x99, 0xfd, 0x74, 0xfc, 0x66, 0xf7, 0xfc, 0x23, 0x62	/* T__pfx____pte_free_tlb */
	.byte 0x09, 0xb9, 0xec, 0x74, 0xfc, 0x66, 0xf7, 0xfc, 0x23, 0x62	/* T___pte_free_tlb */
	.byte 0x09, 0x99, 0xfd, 0x6d, 0x64, 0xe6, 0xf7, 0xfc, 0x23, 0x62	/* T__pfx____pmd_free_tlb */
	.byte 0x09, 0xb9, 0xec, 0x6d, 0x64, 0xe6, 0xf7, 0xfc, 0x23, 0x62	/* T___pmd_free_tlb */
	.byte 0x09, 0x99, 0xfd, 0x75, 0x64, 0xe6, 0xf7, 0xfc, 0x23, 0x62	/* T__pfx____pud_free_tlb */
	.byte 0x09, 0xb9, 0xec, 0x75, 0x64, 0xe6, 0xf7, 0xfc, 0x23, 0x62	/* T___pud_free_tlb */
	.byte 0x09, 0x99, 0xfd, 0x34, 0x64, 0xe6, 0xf7, 0xfc, 0x23, 0x62	/* T__pfx____p4d_free_tlb */
	.byte 0x09, 0xb9, 0xec, 0x34, 0x64, 0xe6, 0xf7, 0xfc, 0x23, 0x62	/* T___p4d_free_tlb */
	.byte 0x0b, 0xeb, 0x70, 0x67, 0x64, 0xec, 0x83, 0xfc, 0x67, 0xe2, 0x6d, 0x6d	/* T__pfx_pgd_page_get_mm */
	.byte 0x0b, 0x54, 0x70, 0x67, 0x64, 0xec, 0x83, 0xfc, 0x67, 0xe2, 0x6d, 0x6d	/* Tpgd_page_get_mm */
	.byte 0x06, 0xeb, 0x70, 0x67, 0xda, 0x22, 0x63	/* T__pfx_pgd_alloc */
	.byte 0x06, 0x54, 0x70, 0x67, 0xda, 0x22, 0x63	/* Tpgd_alloc */
	.byte 0x07, 0xeb, 0x70, 0x67, 0x64, 0xe6, 0xf7, 0x65	/* T__pfx_pgd_free */
	.byte 0x07, 0x54, 0x70, 0x67, 0x64, 0xe6, 0xf7, 0x65	/* Tpgd_free */
	.byte 0x0d, 0xeb, 0x70, 0x2c, 0x70, 0x84, 0xf2, 0x63, 0xd6, 0xe9, 0x66, 0x6c, 0x83, 0x73	/* T__pfx_ptep_set_access_flags */
	.byte 0x0d, 0x54, 0x70, 0x2c, 0x70, 0x84, 0xf2, 0x63, 0xd6, 0xe9, 0x66, 0x6c, 0x83, 0x73	/* Tptep_set_access_flags */
	.byte 0x10, 0xeb, 0x70, 0x2c, 0x70, 0xa7, 0xd6, 0xfe, 0x05, 0xf0, 0xc4, 0xc5, 0x5f, 0x79, 0x6f, 0xe4, 0x67	/* T__pfx_ptep_test_and_clear_young */
	.byte 0x10, 0x54, 0x70, 0x2c, 0x70, 0xa7, 0xd6, 0xfe, 0x05, 0xf0, 0xc4, 0xc5, 0x5f, 0x79, 0x6f, 0xe4, 0x67	/* Tptep_test_and_clear_young */
	.byte 0x10, 0xeb, 0x70, 0x6d, 0x12, 0xa7, 0xd6, 0xfe, 0x05, 0xf0, 0xc4, 0xc5, 0x5f, 0x79, 0x6f, 0xe4, 0x67	/* T__pfx_pmdp_test_and_clear_young */
	.byte 0x10, 0x54, 0x70, 0x6d, 0x12, 0xa7, 0xd6, 0xfe, 0x05, 0xf0, 0xc4, 0xc5, 0x5f, 0x79, 0x6f, 0xe4, 0x67	/* Tpmdp_test_and_clear_young */
	.byte 0x10, 0xeb, 0x70, 0x2c, 0x70, 0xf0, 0xc4, 0xc5, 0xe6, 0x6c, 0xb1, 0x68, 0x5f, 0x79, 0x6f, 0xe4, 0x67	/* T__pfx_ptep_clear_flush_young */
	.byte 0x10, 0x54, 0x70, 0x2c, 0x70, 0xf0, 0xc4, 0xc5, 0xe6, 0x6c, 0xb1, 0x68, 0x5f, 0x79, 0x6f, 0xe4, 0x67	/* Tptep_clear_flush_young */
	.byte 0x0a, 0x99, 0xbd, 0xe8, 0x69, 0x1a, 0x73, 0xe2, 0xa5, 0x78, 0x97	/* T__pfx___native_set_fixmap */
	.byte 0x0a, 0xb9, 0x6e, 0xe8, 0x69, 0x1a, 0x73, 0xe2, 0xa5, 0x78, 0x97	/* T__native_set_fixmap */
	.byte 0x0a, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0x73, 0xe2, 0xa5, 0x78, 0x97	/* T__pfx_native_set_fixmap */
	.byte 0x0a, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0x73, 0xe2, 0xa5, 0x78, 0x97	/* Tnative_set_fixmap */
	.byte 0x09, 0xeb, 0x70, 0x34, 0x64, 0x84, 0x68, 0x75, 0x67, 0x65	/* T__pfx_p4d_set_huge */
	.byte 0x09, 0x54, 0x70, 0x34, 0x64, 0x84, 0x68, 0x75, 0x67, 0x65	/* Tp4d_set_huge */
	.byte 0x0b, 0xeb, 0x70, 0x34, 0x64, 0xf0, 0xc4, 0xc5, 0xa3, 0x75, 0x67, 0x65	/* T__pfx_p4d_clear_huge */
	.byte 0x0b, 0x54, 0x70, 0x34, 0x64, 0xf0, 0xc4, 0xc5, 0xa3, 0x75, 0x67, 0x65	/* Tp4d_clear_huge */
	.byte 0x08, 0xeb, 0x9c, 0x64, 0x84, 0x68, 0x75, 0x67, 0x65	/* T__pfx_pud_set_huge */
	.byte 0x08, 0x54, 0x9c, 0x64, 0x84, 0x68, 0x75, 0x67, 0x65	/* Tpud_set_huge */
	.byte 0x09, 0xeb, 0x70, 0x6d, 0x64, 0x84, 0x68, 0x75, 0x67, 0x65	/* T__pfx_pmd_set_huge */
	.byte 0x09, 0x54, 0x70, 0x6d, 0x64, 0x84, 0x68, 0x75, 0x67, 0x65	/* Tpmd_set_huge */
	.byte 0x0a, 0xeb, 0x9c, 0x64, 0xf0, 0xc4, 0xc5, 0xa3, 0x75, 0x67, 0x65	/* T__pfx_pud_clear_huge */
	.byte 0x0a, 0x54, 0x9c, 0x64, 0xf0, 0xc4, 0xc5, 0xa3, 0x75, 0x67, 0x65	/* Tpud_clear_huge */
	.byte 0x0b, 0xeb, 0x70, 0x6d, 0x64, 0xf0, 0xc4, 0xc5, 0xa3, 0x75, 0x67, 0x65	/* T__pfx_pmd_clear_huge */
	.byte 0x0b, 0x54, 0x70, 0x6d, 0x64, 0xf0, 0xc4, 0xc5, 0xa3, 0x75, 0x67, 0x65	/* Tpmd_clear_huge */
	.byte 0x0c, 0xeb, 0x9c, 0x64, 0xe6, 0xf7, 0xfc, 0x70, 0x6d, 0x64, 0xec, 0x83, 0x65	/* T__pfx_pud_free_pmd_page */
	.byte 0x0c, 0x54, 0x9c, 0x64, 0xe6, 0xf7, 0xfc, 0x70, 0x6d, 0x64, 0xec, 0x83, 0x65	/* Tpud_free_pmd_page */
	.byte 0x0d, 0xeb, 0x70, 0x6d, 0x64, 0xe6, 0xf7, 0xfc, 0x70, 0x74, 0xfc, 0x70, 0x83, 0x65	/* T__pfx_pmd_free_pte_page */
	.byte 0x0d, 0x54, 0x70, 0x6d, 0x64, 0xe6, 0xf7, 0xfc, 0x70, 0x74, 0xfc, 0x70, 0x83, 0x65	/* Tpmd_free_pte_page */
	.byte 0x09, 0xeb, 0x70, 0x74, 0xfc, 0x6d, 0x6b, 0x77, 0x3c, 0x65	/* T__pfx_pte_mkwrite */
	.byte 0x09, 0x54, 0x70, 0x74, 0xfc, 0x6d, 0x6b, 0x77, 0x3c, 0x65	/* Tpte_mkwrite */
	.byte 0x09, 0xeb, 0x70, 0x6d, 0xda, 0x6d, 0x6b, 0x77, 0x3c, 0x65	/* T__pfx_pmd_mkwrite */
	.byte 0x09, 0x54, 0x70, 0x6d, 0xda, 0x6d, 0x6b, 0x77, 0x3c, 0x65	/* Tpmd_mkwrite */
	.byte 0x0e, 0xeb, 0xc5, 0xba, 0x25, 0x65, 0xc6, 0x5f, 0x7a, 0x61, 0x70, 0x70, 0x9e, 0xec, 0x2c	/* T__pfx_arch_check_zapped_pte */
	.byte 0x0e, 0x54, 0xc5, 0xba, 0x25, 0x65, 0xc6, 0x5f, 0x7a, 0x61, 0x70, 0x70, 0x9e, 0xec, 0x2c	/* Tarch_check_zapped_pte */
	.byte 0x0f, 0xeb, 0xc5, 0xba, 0x25, 0x65, 0xc6, 0x5f, 0x7a, 0x61, 0x70, 0x70, 0x9e, 0xec, 0x6d, 0x64	/* T__pfx_arch_check_zapped_pmd */
	.byte 0x0f, 0x54, 0xc5, 0xba, 0x25, 0x65, 0xc6, 0x5f, 0x7a, 0x61, 0x70, 0x70, 0x9e, 0xec, 0x6d, 0x64	/* Tarch_check_zapped_pmd */
	.byte 0x0f, 0xeb, 0xc5, 0xba, 0x25, 0x65, 0xc6, 0x5f, 0x7a, 0x61, 0x70, 0x70, 0x9e, 0xec, 0x75, 0x64	/* T__pfx_arch_check_zapped_pud */
	.byte 0x0f, 0x54, 0xc5, 0xba, 0x25, 0x65, 0xc6, 0x5f, 0x7a, 0x61, 0x70, 0x70, 0x9e, 0xec, 0x75, 0x64	/* Tarch_check_zapped_pud */
	.byte 0x0a, 0x08, 0x76, 0xab, 0xfe, 0xc8, 0xac, 0x5f, 0x76, 0xe5, 0x9f	/* T__pfx___virt_addr_valid */
	.byte 0x0a, 0xb9, 0x76, 0xab, 0xfe, 0xc8, 0xac, 0x5f, 0x76, 0xe5, 0x9f	/* T__virt_addr_valid */
	.byte 0x0d, 0xef, 0x23, 0x62, 0x5f, 0x69, 0xe9, 0x6e, 0x6f, 0xfe, 0x6c, 0x61, 0x7a, 0x79	/* t__pfx_tlb_is_not_lazy */
	.byte 0x0d, 0x74, 0x23, 0x62, 0x5f, 0x69, 0xe9, 0x6e, 0x6f, 0xfe, 0x6c, 0x61, 0x7a, 0x79	/* ttlb_is_not_lazy */
	.byte 0x10, 0xef, 0x6c, 0x31, 0x64, 0xe6, 0x6c, 0xb1, 0x68, 0xe6, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0x62, 0xb1	/* t__pfx_l1d_flush_force_sigbus */
	.byte 0x0f, 0x23, 0x31, 0x64, 0xe6, 0x6c, 0xb1, 0x68, 0xe6, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0x62, 0xb1	/* tl1d_flush_force_sigbus */
	.byte 0x0c, 0xef, 0x23, 0x62, 0x66, 0x6c, 0xb1, 0x68, 0x92, 0x3c, 0xfc, 0xa5, 0xc4	/* t__pfx_tlbflush_write_file */
	.byte 0x0c, 0x74, 0x23, 0x62, 0x66, 0x6c, 0xb1, 0x68, 0x92, 0x3c, 0xfc, 0xa5, 0xc4	/* ttlbflush_write_file */
	.byte 0x0c, 0xef, 0x23, 0x62, 0x66, 0x6c, 0xb1, 0x68, 0xde, 0xc8, 0xe6, 0x69, 0xc4	/* t__pfx_tlbflush_read_file */
	.byte 0x0c, 0x74, 0x23, 0x62, 0x66, 0x6c, 0xb1, 0x68, 0xde, 0xc8, 0xe6, 0x69, 0xc4	/* ttlbflush_read_file */
	.byte 0x0b, 0xef, 0xf8, 0x76, 0xe5, 0x9f, 0x91, 0xb1, 0xf5, 0x5f, 0xbb, 0x9f	/* t__pfx_invalidate_user_asid */
	.byte 0x0b, 0x74, 0xf8, 0x76, 0xe5, 0x9f, 0x91, 0xb1, 0xf5, 0x5f, 0xbb, 0x9f	/* tinvalidate_user_asid */
	.byte 0x0a, 0x99, 0xe6, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0x5f, 0x5d	/* T__pfx___flush_tlb_all */
	.byte 0x0a, 0xb9, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0x5f, 0x5d	/* T__flush_tlb_all */
	.byte 0x0c, 0xef, 0x64, 0x6f, 0xe6, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0x5f, 0x5d	/* t__pfx_do_flush_tlb_all */
	.byte 0x0c, 0x74, 0x64, 0x6f, 0xe6, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0x5f, 0x5d	/* tdo_flush_tlb_all */
	.byte 0x0d, 0x99, 0x86, 0x63, 0x98, 0xf7, 0x6e, 0xfe, 0x63, 0x72, 0x33, 0xe6, 0xbb, 0x74	/* T__pfx___get_current_cr3_fast */
	.byte 0x0e, 0xb9, 0x67, 0xe2, 0x63, 0x98, 0xf7, 0x6e, 0xfe, 0x63, 0x72, 0x33, 0xe6, 0xbb, 0x74	/* T__get_current_cr3_fast */
	.byte 0x0b, 0xeb, 0x63, 0x72, 0x34, 0x5f, 0xcd, 0x64, 0x91, 0x70, 0x63, 0x65	/* T__pfx_cr4_update_pce */
	.byte 0x0b, 0x54, 0x63, 0x72, 0x34, 0x5f, 0xcd, 0x64, 0x91, 0x70, 0x63, 0x65	/* Tcr4_update_pce */
	.byte 0x0d, 0xeb, 0x73, 0x77, 0xea, 0xba, 0xc1, 0xae, 0xab, 0x71, 0xe9, 0x6f, 0x66, 0x66	/* T__pfx_switch_mm_irqs_off */
	.byte 0x0d, 0x54, 0x73, 0x77, 0xea, 0xba, 0xc1, 0xae, 0xab, 0x71, 0xe9, 0x6f, 0x66, 0x66	/* Tswitch_mm_irqs_off */
	.byte 0x07, 0xeb, 0x73, 0x77, 0xea, 0xba, 0xc1, 0x6d	/* T__pfx_switch_mm */
	.byte 0x07, 0x54, 0x73, 0x77, 0xea, 0xba, 0xc1, 0x6d	/* Tswitch_mm */
	.byte 0x0a, 0xef, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0xe6, 0x96	/* t__pfx_flush_tlb_func */
	.byte 0x0a, 0x74, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0xe6, 0x96	/* tflush_tlb_func */
	.byte 0x06, 0xeb, 0xc4, 0x61, 0x1a, 0x6d, 0x6d	/* T__pfx_leave_mm */
	.byte 0x06, 0x54, 0xc4, 0x61, 0x1a, 0x6d, 0x6d	/* Tleave_mm */
	.byte 0x0b, 0xeb, 0xf1, 0xa2, 0x5f, 0x6c, 0x61, 0x7a, 0x79, 0xa7, 0x6c, 0x62	/* T__pfx_enter_lazy_tlb */
	.byte 0x0b, 0x54, 0xf1, 0xa2, 0x5f, 0x6c, 0x61, 0x7a, 0x79, 0xa7, 0x6c, 0x62	/* Tenter_lazy_tlb */
	.byte 0x11, 0xeb, 0x0f, 0x69, 0xe5, 0x69, 0x7a, 0xfc, 0x23, 0x62, 0x3d, 0x74, 0xfc, 0x05, 0xe6, 0x6c, 0xb1, 0x68	/* T__pfx_initialize_tlbstate_and_flush */
	.byte 0x11, 0x54, 0x0f, 0x69, 0xe5, 0x69, 0x7a, 0xfc, 0x23, 0x62, 0x3d, 0x74, 0xfc, 0x05, 0xe6, 0x6c, 0xb1, 0x68	/* Tinitialize_tlbstate_and_flush */
	.byte 0x0f, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0xc1, 0x02, 0xdc	/* T__pfx_native_flush_tlb_multi */
	.byte 0x0f, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0xc1, 0x02, 0xdc	/* Tnative_flush_tlb_multi */
	.byte 0x0b, 0xeb, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0xc1, 0x02, 0xdc	/* T__pfx_flush_tlb_multi */
	.byte 0x0b, 0x54, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0xc1, 0x02, 0xdc	/* Tflush_tlb_multi */
	.byte 0x0e, 0xeb, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0xc1, 0xae, 0x72, 0xd2, 0x67, 0x65	/* T__pfx_flush_tlb_mm_range */
	.byte 0x0e, 0x54, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0xc1, 0xae, 0x72, 0xd2, 0x67, 0x65	/* Tflush_tlb_mm_range */
	.byte 0x0a, 0xeb, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0x5f, 0x5d	/* T__pfx_flush_tlb_all */
	.byte 0x0a, 0x54, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0x5f, 0x5d	/* Tflush_tlb_all */
	.byte 0x11, 0xeb, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0x5f, 0x6b, 0xf5, 0x6e, 0xdb, 0xa6, 0xd2, 0x67, 0x65	/* T__pfx_flush_tlb_kernel_range */
	.byte 0x11, 0x54, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0x5f, 0x6b, 0xf5, 0x6e, 0xdb, 0xa6, 0xd2, 0x67, 0x65	/* Tflush_tlb_kernel_range */
	.byte 0x0f, 0xeb, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0x5f, 0xe7, 0xfc, 0x6b, 0xf5, 0x6e, 0xdb	/* T__pfx_flush_tlb_one_kernel */
	.byte 0x0f, 0x54, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0x5f, 0xe7, 0xfc, 0x6b, 0xf5, 0x6e, 0xdb	/* Tflush_tlb_one_kernel */
	.byte 0x10, 0xef, 0x64, 0x6f, 0x5f, 0x6b, 0xf5, 0x6e, 0xdb, 0xa6, 0xd2, 0x67, 0xfc, 0x66, 0x6c, 0xb1, 0x68	/* t__pfx_do_kernel_range_flush */
	.byte 0x10, 0x74, 0x64, 0x6f, 0x5f, 0x6b, 0xf5, 0x6e, 0xdb, 0xa6, 0xd2, 0x67, 0xfc, 0x66, 0x6c, 0xb1, 0x68	/* tdo_kernel_range_flush */
	.byte 0x11, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0x5f, 0xe7, 0xfc, 0xb1, 0xf5	/* T__pfx_native_flush_tlb_one_user */
	.byte 0x11, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0x5f, 0xe7, 0xfc, 0xb1, 0xf5	/* Tnative_flush_tlb_one_user */
	.byte 0x0d, 0xeb, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0x5f, 0xe7, 0xfc, 0xb1, 0xf5	/* T__pfx_flush_tlb_one_user */
	.byte 0x0d, 0x54, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0x5f, 0xe7, 0xfc, 0xb1, 0xf5	/* Tflush_tlb_one_user */
	.byte 0x10, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0xc7, 0xdd, 0x62, 0xe5	/* T__pfx_native_flush_tlb_global */
	.byte 0x10, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0xc7, 0xdd, 0x62, 0xe5	/* Tnative_flush_tlb_global */
	.byte 0x10, 0xeb, 0x6e, 0xe8, 0x69, 0x1a, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0x5f, 0xdd, 0x63, 0xe5	/* T__pfx_native_flush_tlb_local */
	.byte 0x10, 0x54, 0x6e, 0xe8, 0x69, 0x1a, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0x5f, 0xdd, 0x63, 0xe5	/* Tnative_flush_tlb_local */
	.byte 0x0c, 0xeb, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0x5f, 0xdd, 0x63, 0xe5	/* T__pfx_flush_tlb_local */
	.byte 0x0c, 0x54, 0x66, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62, 0x5f, 0xdd, 0x63, 0xe5	/* Tflush_tlb_local */
	.byte 0x0d, 0xeb, 0xc5, 0xba, 0xa7, 0x6c, 0x62, 0x62, 0xe8, 0xba, 0xe6, 0x6c, 0xb1, 0x68	/* T__pfx_arch_tlbbatch_flush */
	.byte 0x0d, 0x54, 0xc5, 0xba, 0xa7, 0x6c, 0x62, 0x62, 0xe8, 0xba, 0xe6, 0x6c, 0xb1, 0x68	/* Tarch_tlbbatch_flush */
	.byte 0x0e, 0xeb, 0x6e, 0x6d, 0x69, 0x5f, 0x75, 0xf2, 0x63, 0xd6, 0xe9, 0x6f, 0x6b, 0x61, 0x79	/* T__pfx_nmi_uaccess_okay */
	.byte 0x0e, 0x54, 0x6e, 0x6d, 0x69, 0x5f, 0x75, 0xf2, 0x63, 0xd6, 0xe9, 0x6f, 0x6b, 0x61, 0x79	/* Tnmi_uaccess_okay */
	.byte 0x07, 0xeb, 0x63, 0x65, 0x61, 0x84, 0x70, 0x2c	/* T__pfx_cea_set_pte */
	.byte 0x07, 0x54, 0x63, 0x65, 0x61, 0x84, 0x70, 0x2c	/* Tcea_set_pte */
	.byte 0x14, 0xeb, 0x63, 0xbe, 0x79, 0xe6, 0xe3, 0xae, 0x6b, 0xf5, 0x6e, 0xdb, 0xbd, 0x6f, 0x66, 0x61, 0x02, 0xfe, 0x22, 0x77, 0x9e	/* T__pfx_copy_from_kernel_nofault_allowed */
	.byte 0x14, 0x54, 0x63, 0xbe, 0x79, 0xe6, 0xe3, 0xae, 0x6b, 0xf5, 0x6e, 0xdb, 0xbd, 0x6f, 0x66, 0x61, 0x02, 0xfe, 0x22, 0x77, 0x9e	/* Tcopy_from_kernel_nofault_allowed */
	.byte 0x0a, 0xeb, 0x76, 0x6d, 0x86, 0x70, 0x83, 0xfc, 0x70, 0xe3, 0x74	/* T__pfx_vm_get_page_prot */
	.byte 0x0a, 0x54, 0x76, 0x6d, 0x86, 0x70, 0x83, 0xfc, 0x70, 0xe3, 0x74	/* Tvm_get_page_prot */
	.byte 0x10, 0xeb, 0xc8, 0xda, 0xf1, 0x63, 0x72, 0x21, 0xfe, 0x70, 0xe3, 0x74, 0xb4, 0xdc, 0xe7, 0x5f, 0x97	/* T__pfx_add_encrypt_protection_map */
	.byte 0x10, 0x54, 0xc8, 0xda, 0xf1, 0x63, 0x72, 0x21, 0xfe, 0x70, 0xe3, 0x74, 0xb4, 0xdc, 0xe7, 0x5f, 0x97	/* Tadd_encrypt_protection_map */
	.byte 0x15, 0xeb, 0x63, 0x9c, 0xf0, 0xf2, 0x68, 0xfc, 0x68, 0x61, 0xe9, 0xf8, 0x76, 0xe5, 0x9f, 0x91, 0xa8, 0x6d, 0xf7, 0x67, 0x69, 0xe7	/* T__pfx_cpu_cache_has_invalidate_memregion */
	.byte 0x15, 0x54, 0x63, 0x9c, 0xf0, 0xf2, 0x68, 0xfc, 0x68, 0x61, 0xe9, 0xf8, 0x76, 0xe5, 0x9f, 0x91, 0xa8, 0x6d, 0xf7, 0x67, 0x69, 0xe7	/* Tcpu_cache_has_invalidate_memregion */
	.byte 0x0d, 0xeb, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x1d, 0xf1, 0x63, 0x72, 0x21, 0x74, 0x9e	/* T__pfx_set_memory_encrypted */
	.byte 0x0d, 0x54, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x1d, 0xf1, 0x63, 0x72, 0x21, 0x74, 0x9e	/* Tset_memory_encrypted */
	.byte 0x0b, 0x74, 0xaf, 0xf0, 0x70, 0x61, 0xe6, 0x6c, 0xb1, 0x68, 0x5f, 0x5d	/* t__pfx___cpa_flush_all */
	.byte 0x0b, 0x74, 0xff, 0x63, 0x70, 0x61, 0xe6, 0x6c, 0xb1, 0x68, 0x5f, 0x5d	/* t__cpa_flush_all */
	.byte 0x12, 0xeb, 0x63, 0x9c, 0xf0, 0xf2, 0x68, 0xfc, 0xf8, 0x76, 0xe5, 0x9f, 0x91, 0xa8, 0x6d, 0xf7, 0x67, 0x69, 0xe7	/* T__pfx_cpu_cache_invalidate_memregion */
	.byte 0x12, 0x54, 0x63, 0x9c, 0xf0, 0xf2, 0x68, 0xfc, 0xf8, 0x76, 0xe5, 0x9f, 0x91, 0xa8, 0x6d, 0xf7, 0x67, 0x69, 0xe7	/* Tcpu_cache_invalidate_memregion */
	.byte 0x0a, 0xef, 0x63, 0x70, 0x61, 0xe6, 0x6c, 0xb1, 0x68, 0x5f, 0x5d	/* t__pfx_cpa_flush_all */
	.byte 0x09, 0x26, 0x70, 0x61, 0xe6, 0x6c, 0xb1, 0x68, 0x5f, 0x5d	/* tcpa_flush_all */
	.byte 0x08, 0x74, 0xaf, 0xf0, 0x70, 0x61, 0x5f, 0xc8, 0xac	/* t__pfx___cpa_addr */
	.byte 0x08, 0x74, 0xff, 0x63, 0x70, 0x61, 0x5f, 0xc8, 0xac	/* t__cpa_addr */
	.byte 0x0d, 0xeb, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0xed, 0xb4, 0x72, 0x21, 0x74, 0x9e	/* T__pfx_set_memory_decrypted */
	.byte 0x0d, 0x54, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0xed, 0xb4, 0x72, 0x21, 0x74, 0x9e	/* Tset_memory_decrypted */
	.byte 0x0a, 0xef, 0xe4, 0x97, 0xec, 0x74, 0xfc, 0x72, 0xd2, 0x67, 0x65	/* t__pfx_unmap_pte_range */
	.byte 0x0a, 0x74, 0xe4, 0x97, 0xec, 0x74, 0xfc, 0x72, 0xd2, 0x67, 0x65	/* tunmap_pte_range */
	.byte 0x0b, 0xef, 0x70, 0xbe, 0x02, 0x91, 0x70, 0x2c, 0x2e, 0xca, 0xbc, 0x7e	/* t__pfx_populate_pte.isra.0 */
	.byte 0x0a, 0xce, 0xbe, 0x02, 0x91, 0x70, 0x2c, 0x2e, 0xca, 0xbc, 0x7e	/* tpopulate_pte.isra.0 */
	.byte 0x0b, 0xeb, 0xc5, 0xba, 0xbf, 0x76, 0xe5, 0x9f, 0x91, 0x70, 0xa8, 0x6d	/* T__pfx_arch_invalidate_pmem */
	.byte 0x0b, 0x54, 0xc5, 0xba, 0xbf, 0x76, 0xe5, 0x9f, 0x91, 0x70, 0xa8, 0x6d	/* Tarch_invalidate_pmem */
	.byte 0x0f, 0xeb, 0x63, 0x6c, 0x66, 0x6c, 0xb1, 0x68, 0xf0, 0xf2, 0x68, 0xfc, 0x72, 0xd2, 0x67, 0x65	/* T__pfx_clflush_cache_range */
	.byte 0x0f, 0x54, 0x63, 0x6c, 0x66, 0x6c, 0xb1, 0x68, 0xf0, 0xf2, 0x68, 0xfc, 0x72, 0xd2, 0x67, 0x65	/* Tclflush_cache_range */
	.byte 0x0c, 0x74, 0xaf, 0xf0, 0x70, 0x61, 0xe6, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62	/* t__pfx___cpa_flush_tlb */
	.byte 0x0c, 0x74, 0xff, 0x63, 0x70, 0x61, 0xe6, 0x6c, 0xb1, 0x68, 0xa7, 0x6c, 0x62	/* t__cpa_flush_tlb */
	.byte 0x0a, 0xef, 0xe4, 0x97, 0xec, 0x6d, 0xda, 0x72, 0xd2, 0x67, 0x65	/* t__pfx_unmap_pmd_range */
	.byte 0x0a, 0x74, 0xe4, 0x97, 0xec, 0x6d, 0xda, 0x72, 0xd2, 0x67, 0x65	/* tunmap_pmd_range */
	.byte 0x08, 0xef, 0x70, 0xbe, 0x02, 0x91, 0x70, 0x6d, 0x64	/* t__pfx_populate_pmd */
	.byte 0x07, 0xce, 0xbe, 0x02, 0x91, 0x70, 0x6d, 0x64	/* tpopulate_pmd */
	.byte 0x0e, 0x74, 0xaf, 0xf0, 0x70, 0x61, 0xec, 0xe3, 0x63, 0xd6, 0xe9, 0x66, 0x61, 0x02, 0x74	/* t__pfx___cpa_process_fault */
	.byte 0x0e, 0x74, 0xff, 0x63, 0x70, 0x61, 0xec, 0xe3, 0x63, 0xd6, 0xe9, 0x66, 0x61, 0x02, 0x74	/* t__cpa_process_fault */
	.byte 0x0a, 0xeb, 0xcd, 0x64, 0x91, 0x70, 0x83, 0xfc, 0x03, 0xe4, 0x74	/* T__pfx_update_page_count */
	.byte 0x0a, 0x54, 0xcd, 0x64, 0x91, 0x70, 0x83, 0xfc, 0x03, 0xe4, 0x74	/* Tupdate_page_count */
	.byte 0x0c, 0xeb, 0xc5, 0xba, 0xde, 0x70, 0xd5, 0xfe, 0xa8, 0x6d, 0xf8, 0x66, 0x6f	/* T__pfx_arch_report_meminfo */
	.byte 0x0c, 0x54, 0xc5, 0xba, 0xde, 0x70, 0xd5, 0xfe, 0xa8, 0x6d, 0xf8, 0x66, 0x6f	/* Tarch_report_meminfo */
	.byte 0x0f, 0xeb, 0xdd, 0x6f, 0x6b, 0xcd, 0x5f, 0xc8, 0x64, 0x29, 0xe9, 0xf8, 0xec, 0x67, 0xda, 0x24	/* T__pfx_lookup_address_in_pgd_attr */
	.byte 0x0f, 0x54, 0xdd, 0x6f, 0x6b, 0xcd, 0x5f, 0xc8, 0x64, 0x29, 0xe9, 0xf8, 0xec, 0x67, 0xda, 0x24	/* Tlookup_address_in_pgd_attr */
	.byte 0x0a, 0xeb, 0xdd, 0x6f, 0x6b, 0xcd, 0x5f, 0xc8, 0x64, 0x29, 0x73	/* T__pfx_lookup_address */
	.byte 0x0a, 0x54, 0xdd, 0x6f, 0x6b, 0xcd, 0x5f, 0xc8, 0x64, 0x29, 0x73	/* Tlookup_address */
	.byte 0x08, 0xef, 0x63, 0x70, 0x61, 0xe6, 0x6c, 0xb1, 0x68	/* t__pfx_cpa_flush */
	.byte 0x07, 0x26, 0x70, 0x61, 0xe6, 0x6c, 0xb1, 0x68	/* tcpa_flush */
	.byte 0x0c, 0xeb, 0x73, 0xdd, 0x8f, 0x76, 0xab, 0xfe, 0x8a, 0xec, 0x68, 0x79, 0x73	/* T__pfx_slow_virt_to_phys */
	.byte 0x0c, 0x54, 0x73, 0xdd, 0x8f, 0x76, 0xab, 0xfe, 0x8a, 0xec, 0x68, 0x79, 0x73	/* Tslow_virt_to_phys */
	.byte 0x0b, 0xef, 0x3d, 0xdc, 0x63, 0xec, 0xe3, 0x74, 0xb4, 0xdc, 0xe7, 0x73	/* t__pfx_static_protections */
	.byte 0x0b, 0x93, 0xf4, 0xdc, 0x63, 0xec, 0xe3, 0x74, 0xb4, 0xdc, 0xe7, 0x73	/* tstatic_protections */
	.byte 0x0e, 0x74, 0xaf, 0x25, 0xd2, 0x67, 0xfc, 0x70, 0x83, 0xfc, 0x24, 0x84, 0x63, 0x6c, 0x72	/* t__pfx___change_page_attr_set_clr */
	.byte 0x0e, 0x74, 0xff, 0xba, 0xd2, 0x67, 0xfc, 0x70, 0x83, 0xfc, 0x24, 0x84, 0x63, 0x6c, 0x72	/* t__change_page_attr_set_clr */
	.byte 0x0d, 0xef, 0xba, 0xd2, 0x67, 0xfc, 0x70, 0x83, 0xfc, 0x24, 0x84, 0x63, 0x6c, 0x72	/* t__pfx_change_page_attr_set_clr */
	.byte 0x0d, 0x74, 0xba, 0xd2, 0x67, 0xfc, 0x70, 0x83, 0xfc, 0x24, 0x84, 0x63, 0x6c, 0x72	/* tchange_page_attr_set_clr */
	.byte 0x0b, 0x74, 0xaf, 0x73, 0xe2, 0x70, 0x83, 0x65, 0xe9, 0xc5, 0xbc, 0x79	/* t__pfx__set_pages_array */
	.byte 0x0a, 0xfe, 0x73, 0xe2, 0x70, 0x83, 0x65, 0xe9, 0xc5, 0xbc, 0x79	/* t_set_pages_array */
	.byte 0x0c, 0xeb, 0x73, 0xe2, 0x70, 0x83, 0x65, 0xe9, 0xc5, 0xbc, 0x1d, 0x75, 0x63	/* T__pfx_set_pages_array_uc */
	.byte 0x0c, 0x54, 0x73, 0xe2, 0x70, 0x83, 0x65, 0xe9, 0xc5, 0xbc, 0x1d, 0x75, 0x63	/* Tset_pages_array_uc */
	.byte 0x0c, 0xeb, 0x73, 0xe2, 0x70, 0x83, 0x65, 0xe9, 0xc5, 0xbc, 0x79, 0x92, 0x63	/* T__pfx_set_pages_array_wc */
	.byte 0x0c, 0x54, 0x73, 0xe2, 0x70, 0x83, 0x65, 0xe9, 0xc5, 0xbc, 0x79, 0x92, 0x63	/* Tset_pages_array_wc */
	.byte 0x0c, 0xeb, 0x63, 0xc4, 0xc5, 0xc1, 0x63, 0xfc, 0x6e, 0x6f, 0x73, 0x70, 0xb4	/* T__pfx_clear_mce_nospec */
	.byte 0x0c, 0x54, 0x63, 0xc4, 0xc5, 0xc1, 0x63, 0xfc, 0x6e, 0x6f, 0x73, 0x70, 0xb4	/* Tclear_mce_nospec */
	.byte 0x09, 0xeb, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0x92, 0x62	/* T__pfx_set_memory_wb */
	.byte 0x09, 0x54, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0x92, 0x62	/* Tset_memory_wb */
	.byte 0x09, 0xeb, 0x73, 0xe2, 0x70, 0x83, 0x65, 0xe9, 0x77, 0x62	/* T__pfx_set_pages_wb */
	.byte 0x09, 0x54, 0x73, 0xe2, 0x70, 0x83, 0x65, 0xe9, 0x77, 0x62	/* Tset_pages_wb */
	.byte 0x09, 0xeb, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x1d, 0x75, 0x63	/* T__pfx_set_memory_uc */
	.byte 0x09, 0x54, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x1d, 0x75, 0x63	/* Tset_memory_uc */
	.byte 0x09, 0xeb, 0x73, 0xe2, 0x70, 0x83, 0x65, 0xe9, 0x75, 0x63	/* T__pfx_set_pages_uc */
	.byte 0x09, 0x54, 0x73, 0xe2, 0x70, 0x83, 0x65, 0xe9, 0x75, 0x63	/* Tset_pages_uc */
	.byte 0x0c, 0xeb, 0x73, 0xe2, 0x70, 0x83, 0x65, 0xe9, 0xc5, 0xbc, 0x79, 0x92, 0x62	/* T__pfx_set_pages_array_wb */
	.byte 0x0c, 0x54, 0x73, 0xe2, 0x70, 0x83, 0x65, 0xe9, 0xc5, 0xbc, 0x79, 0x92, 0x62	/* Tset_pages_array_wb */
	.byte 0x0e, 0xeb, 0xdd, 0x6f, 0x6b, 0xcd, 0x5f, 0xc8, 0x64, 0x29, 0xe9, 0xf8, 0xec, 0x67, 0x64	/* T__pfx_lookup_address_in_pgd */
	.byte 0x0e, 0x54, 0xdd, 0x6f, 0x6b, 0xcd, 0x5f, 0xc8, 0x64, 0x29, 0xe9, 0xf8, 0xec, 0x67, 0x64	/* Tlookup_address_in_pgd */
	.byte 0x0c, 0xeb, 0xdd, 0x6f, 0x6b, 0xcd, 0xec, 0x6d, 0xda, 0xc8, 0x64, 0x29, 0x73	/* T__pfx_lookup_pmd_address */
	.byte 0x0c, 0x54, 0xdd, 0x6f, 0x6b, 0xcd, 0xec, 0x6d, 0xda, 0xc8, 0x64, 0x29, 0x73	/* Tlookup_pmd_address */
	.byte 0x09, 0x99, 0x84, 0xa8, 0x6d, 0xd5, 0x79, 0xec, 0xe3, 0x74	/* T__pfx___set_memory_prot */
	.byte 0x0a, 0xb9, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0xec, 0xe3, 0x74	/* T__set_memory_prot */
	.byte 0x09, 0x99, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x1d, 0x75, 0x63	/* T__pfx__set_memory_uc */
	.byte 0x08, 0x54, 0x84, 0xa8, 0x6d, 0xd5, 0x1d, 0x75, 0x63	/* T_set_memory_uc */
	.byte 0x09, 0x99, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0x92, 0x63	/* T__pfx__set_memory_wc */
	.byte 0x08, 0x54, 0x84, 0xa8, 0x6d, 0xd5, 0x79, 0x92, 0x63	/* T_set_memory_wc */
	.byte 0x09, 0xeb, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0x92, 0x63	/* T__pfx_set_memory_wc */
	.byte 0x09, 0x54, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0x92, 0x63	/* Tset_memory_wc */
	.byte 0x09, 0x99, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0x92, 0x74	/* T__pfx__set_memory_wt */
	.byte 0x08, 0x54, 0x84, 0xa8, 0x6d, 0xd5, 0x79, 0x92, 0x74	/* T_set_memory_wt */
	.byte 0x09, 0x99, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0x92, 0x62	/* T__pfx__set_memory_wb */
	.byte 0x08, 0x54, 0x84, 0xa8, 0x6d, 0xd5, 0x79, 0x92, 0x62	/* T_set_memory_wb */
	.byte 0x0b, 0xeb, 0x73, 0xe2, 0x6d, 0x63, 0xfc, 0x6e, 0x6f, 0x73, 0x70, 0xb4	/* T__pfx_set_mce_nospec */
	.byte 0x0b, 0x54, 0x73, 0xe2, 0x6d, 0x63, 0xfc, 0x6e, 0x6f, 0x73, 0x70, 0xb4	/* Tset_mce_nospec */
	.byte 0x08, 0xeb, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x1d, 0x78	/* T__pfx_set_memory_x */
	.byte 0x08, 0x54, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x1d, 0x78	/* Tset_memory_x */
	.byte 0x09, 0xeb, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0xbd, 0x78	/* T__pfx_set_memory_nx */
	.byte 0x09, 0x54, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0xbd, 0x78	/* Tset_memory_nx */
	.byte 0x08, 0xeb, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x1d, 0xe3	/* T__pfx_set_memory_ro */
	.byte 0x08, 0x54, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x1d, 0xe3	/* Tset_memory_ro */
	.byte 0x09, 0xeb, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x1d, 0xe3, 0x78	/* T__pfx_set_memory_rox */
	.byte 0x09, 0x54, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x1d, 0xe3, 0x78	/* Tset_memory_rox */
	.byte 0x09, 0xeb, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0xa6, 0x77	/* T__pfx_set_memory_rw */
	.byte 0x09, 0x54, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0xa6, 0x77	/* Tset_memory_rw */
	.byte 0x09, 0xeb, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0xbd, 0x70	/* T__pfx_set_memory_np */
	.byte 0x09, 0x54, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0xbd, 0x70	/* Tset_memory_np */
	.byte 0x0e, 0xeb, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0xbd, 0x70, 0xbd, 0x6f, 0xe5, 0x69, 0xbb	/* T__pfx_set_memory_np_noalias */
	.byte 0x0e, 0x54, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0xbd, 0x70, 0xbd, 0x6f, 0xe5, 0x69, 0xbb	/* Tset_memory_np_noalias */
	.byte 0x08, 0xeb, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0xec	/* T__pfx_set_memory_p */
	.byte 0x08, 0x54, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0xec	/* Tset_memory_p */
	.byte 0x09, 0xeb, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x1d, 0x34, 0x6b	/* T__pfx_set_memory_4k */
	.byte 0x09, 0x54, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x1d, 0x34, 0x6b	/* Tset_memory_4k */
	.byte 0x0d, 0xeb, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0xbd, 0xe7, 0x67, 0xdd, 0x62, 0xe5	/* T__pfx_set_memory_nonglobal */
	.byte 0x0d, 0x54, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0xbd, 0xe7, 0x67, 0xdd, 0x62, 0xe5	/* Tset_memory_nonglobal */
	.byte 0x0b, 0xeb, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0xc7, 0xdd, 0x62, 0xe5	/* T__pfx_set_memory_global */
	.byte 0x0b, 0x54, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x79, 0xc7, 0xdd, 0x62, 0xe5	/* Tset_memory_global */
	.byte 0x10, 0xeb, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x1d, 0xf1, 0x63, 0xf6, 0x74, 0xbe, 0x3e, 0x0b, 0x85, 0xe7	/* T__pfx_set_memory_enc_stop_conversion */
	.byte 0x10, 0x54, 0x73, 0xe2, 0xa8, 0x6d, 0xd5, 0x1d, 0xf1, 0x63, 0xf6, 0x74, 0xbe, 0x3e, 0x0b, 0x85, 0xe7	/* Tset_memory_enc_stop_conversion */
	.byte 0x08, 0xeb, 0x73, 0xe2, 0x70, 0x83, 0x65, 0xe9, 0xe3	/* T__pfx_set_pages_ro */
	.byte 0x08, 0x54, 0x73, 0xe2, 0x70, 0x83, 0x65, 0xe9, 0xe3	/* Tset_pages_ro */
	.byte 0x09, 0xeb, 0x73, 0xe2, 0x70, 0x83, 0x65, 0xe9, 0x72, 0x77	/* T__pfx_set_pages_rw */
	.byte 0x09, 0x54, 0x73, 0xe2, 0x70, 0x83, 0x65, 0xe9, 0x72, 0x77	/* Tset_pages_rw */
	.byte 0x14, 0xeb, 0x73, 0xe2, 0x64, 0x69, 0xf7, 0x63, 0xfe, 0x97, 0xbf, 0x76, 0xe5, 0x69, 0xda, 0x6e, 0x6f, 0x66, 0x6c, 0xb1, 0x68	/* T__pfx_set_direct_map_invalid_noflush */
	.byte 0x14, 0x54, 0x73, 0xe2, 0x64, 0x69, 0xf7, 0x63, 0xfe, 0x97, 0xbf, 0x76, 0xe5, 0x69, 0xda, 0x6e, 0x6f, 0x66, 0x6c, 0xb1, 0x68	/* Tset_direct_map_invalid_noflush */
	.byte 0x15, 0xeb, 0x73, 0xe2, 0x64, 0x69, 0xf7, 0x63, 0xfe, 0x97, 0xed, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x6e, 0x6f, 0x66, 0x6c, 0xb1, 0x68	/* T__pfx_set_direct_map_default_noflush */
	.byte 0x15, 0x54, 0x73, 0xe2, 0x64, 0x69, 0xf7, 0x63, 0xfe, 0x97, 0xed, 0x65, 0x66, 0x61, 0x02, 0xfe, 0x6e, 0x6f, 0x66, 0x6c, 0xb1, 0x68	/* Tset_direct_map_default_noflush */
	.byte 0x14, 0xeb, 0x73, 0xe2, 0x64, 0x69, 0xf7, 0x63, 0xfe, 0x97, 0x5f, 0x76, 0xe5, 0x69, 0xda, 0x6e, 0x6f, 0x66, 0x6c, 0xb1, 0x68	/* T__pfx_set_direct_map_valid_noflush */
	.byte 0x14, 0x54, 0x73, 0xe2, 0x64, 0x69, 0xf7, 0x63, 0xfe, 0x97, 0x5f, 0x76, 0xe5, 0x69, 0xda, 0x6e, 0x6f, 0x66, 0x6c, 0xb1, 0x68	/* Tset_direct_map_valid_noflush */
	.byte 0x0c, 0xeb, 0x6b, 0xf5, 0x6e, 0xdb, 0xec, 0x83, 0xfc, 0x70, 0x29, 0xf1, 0x74	/* T__pfx_kernel_page_present */
	.byte 0x0c, 0x54, 0x6b, 0xf5, 0x6e, 0xdb, 0xec, 0x83, 0xfc, 0x70, 0x29, 0xf1, 0x74	/* Tkernel_page_present */
	.byte 0x08, 0xeb, 0x70, 0x61, 0xfe, 0xf1, 0x90, 0xc4, 0x64	/* T__pfx_pat_enabled */
	.byte 0x08, 0x54, 0x70, 0x61, 0xfe, 0xf1, 0x90, 0xc4, 0x64	/* Tpat_enabled */
	.byte 0x10, 0xef, 0x70, 0x83, 0xf5, 0xd2, 0x67, 0xfc, 0x69, 0xe9, 0xbc, 0x6d, 0xf0, 0x5d, 0x62, 0xf2, 0x6b	/* t__pfx_pagerange_is_ram_callback */
	.byte 0x0f, 0xce, 0x83, 0xf5, 0xd2, 0x67, 0xfc, 0x69, 0xe9, 0xbc, 0x6d, 0xf0, 0x5d, 0x62, 0xf2, 0x6b	/* tpagerange_is_ram_callback */
	.byte 0x0c, 0xef, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x73, 0x65, 0x71, 0xf6, 0x74, 0xbe	/* t__pfx_memtype_seq_stop */
	.byte 0x0c, 0x74, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x73, 0x65, 0x71, 0xf6, 0x74, 0xbe	/* tmemtype_seq_stop */
	.byte 0x0e, 0xef, 0x70, 0x61, 0xfe, 0x70, 0x83, 0xf5, 0xd2, 0x67, 0xfc, 0x69, 0xe9, 0xbc, 0x6d	/* t__pfx_pat_pagerange_is_ram */
	.byte 0x0d, 0xce, 0x61, 0xfe, 0x70, 0x83, 0xf5, 0xd2, 0x67, 0xfc, 0x69, 0xe9, 0xbc, 0x6d	/* tpat_pagerange_is_ram */
	.byte 0x0b, 0xef, 0xdd, 0x6f, 0x6b, 0xcd, 0xc1, 0x65, 0x6d, 0x74, 0x21, 0x65	/* t__pfx_lookup_memtype */
	.byte 0x0b, 0x74, 0xdd, 0x6f, 0x6b, 0xcd, 0xc1, 0x65, 0x6d, 0x74, 0x21, 0x65	/* tlookup_memtype */
	.byte 0x14, 0xeb, 0x70, 0x61, 0xfe, 0x70, 0x66, 0x6e, 0x5f, 0x69, 0x6d, 0x6d, 0xe4, 0xfc, 0x8a, 0x5f, 0x75, 0xc9, 0x6d, 0xf3, 0x72	/* T__pfx_pat_pfn_immune_to_uc_mtrr */
	.byte 0x14, 0x54, 0x70, 0x61, 0xfe, 0x70, 0x66, 0x6e, 0x5f, 0x69, 0x6d, 0x6d, 0xe4, 0xfc, 0x8a, 0x5f, 0x75, 0xc9, 0x6d, 0xf3, 0x72	/* Tpat_pfn_immune_to_uc_mtrr */
	.byte 0x0e, 0xeb, 0x70, 0x67, 0x70, 0xe3, 0xfe, 0x77, 0x3c, 0xb4, 0x6f, 0x6d, 0x62, 0xf8, 0x65	/* T__pfx_pgprot_writecombine */
	.byte 0x0e, 0x54, 0x70, 0x67, 0x70, 0xe3, 0xfe, 0x77, 0x3c, 0xb4, 0x6f, 0x6d, 0x62, 0xf8, 0x65	/* Tpgprot_writecombine */
	.byte 0x0e, 0xeb, 0x70, 0x67, 0x70, 0xe3, 0xfe, 0x77, 0x3c, 0xd4, 0x68, 0xe3, 0x75, 0x67, 0x68	/* T__pfx_pgprot_writethrough */
	.byte 0x0e, 0x54, 0x70, 0x67, 0x70, 0xe3, 0xfe, 0x77, 0x3c, 0xd4, 0x68, 0xe3, 0x75, 0x67, 0x68	/* Tpgprot_writethrough */
	.byte 0x0c, 0xef, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x73, 0x65, 0x71, 0x5f, 0xbe, 0xf1	/* t__pfx_memtype_seq_open */
	.byte 0x0c, 0x74, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x73, 0x65, 0x71, 0x5f, 0xbe, 0xf1	/* tmemtype_seq_open */
	.byte 0x0b, 0xef, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x73, 0x65, 0x71, 0xf6, 0x7c	/* t__pfx_memtype_seq_show */
	.byte 0x0b, 0x74, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x73, 0x65, 0x71, 0xf6, 0x7c	/* tmemtype_seq_show */
	.byte 0x09, 0xef, 0x67, 0xe2, 0x70, 0x61, 0xfe, 0xf8, 0x66, 0x6f	/* t__pfx_get_pat_info */
	.byte 0x09, 0x74, 0x67, 0xe2, 0x70, 0x61, 0xfe, 0xf8, 0x66, 0x6f	/* tget_pat_info */
	.byte 0x0a, 0xef, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x67, 0xe2, 0x9f, 0x78	/* t__pfx_memtype_get_idx */
	.byte 0x0a, 0x74, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x67, 0xe2, 0x9f, 0x78	/* tmemtype_get_idx */
	.byte 0x0b, 0xef, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x73, 0x65, 0x71, 0xbd, 0x8e	/* t__pfx_memtype_seq_next */
	.byte 0x0b, 0x74, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x73, 0x65, 0x71, 0xbd, 0x8e	/* tmemtype_seq_next */
	.byte 0x0c, 0xef, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x73, 0x65, 0x71, 0xa9, 0x72, 0x74	/* t__pfx_memtype_seq_start */
	.byte 0x0c, 0x74, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x73, 0x65, 0x71, 0xa9, 0x72, 0x74	/* tmemtype_seq_start */
	.byte 0x08, 0xeb, 0x70, 0x61, 0xfe, 0x63, 0x9c, 0xbf, 0xea	/* T__pfx_pat_cpu_init */
	.byte 0x08, 0x54, 0x70, 0x61, 0xfe, 0x63, 0x9c, 0xbf, 0xea	/* Tpat_cpu_init */
	.byte 0x0a, 0xeb, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x29, 0xf5, 0x76, 0x65	/* T__pfx_memtype_reserve */
	.byte 0x0a, 0x54, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x29, 0xf5, 0x76, 0x65	/* Tmemtype_reserve */
	.byte 0x09, 0xeb, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x66, 0xf7, 0x65	/* T__pfx_memtype_free */
	.byte 0x09, 0x54, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x66, 0xf7, 0x65	/* Tmemtype_free */
	.byte 0x0f, 0xeb, 0xc5, 0xba, 0x5f, 0xc0, 0xe6, 0xf7, 0xfc, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x77, 0x63	/* T__pfx_arch_io_free_memtype_wc */
	.byte 0x0f, 0x54, 0xc5, 0xba, 0x5f, 0xc0, 0xe6, 0xf7, 0xfc, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x77, 0x63	/* Tarch_io_free_memtype_wc */
	.byte 0x0a, 0xeb, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x66, 0xf7, 0xfc, 0xc0	/* T__pfx_memtype_free_io */
	.byte 0x0a, 0x54, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x66, 0xf7, 0xfc, 0xc0	/* Tmemtype_free_io */
	.byte 0x0e, 0xeb, 0x70, 0x68, 0x79, 0xe9, 0xa8, 0xae, 0xf2, 0x63, 0xd6, 0x73, 0xec, 0xe3, 0x74	/* T__pfx_phys_mem_access_prot */
	.byte 0x0e, 0x54, 0x70, 0x68, 0x79, 0xe9, 0xa8, 0xae, 0xf2, 0x63, 0xd6, 0x73, 0xec, 0xe3, 0x74	/* Tphys_mem_access_prot */
	.byte 0x11, 0xeb, 0x70, 0x68, 0x79, 0xe9, 0xa8, 0xae, 0xf2, 0x63, 0xd6, 0x73, 0xec, 0xe3, 0xfe, 0x22, 0x77, 0x9e	/* T__pfx_phys_mem_access_prot_allowed */
	.byte 0x11, 0x54, 0x70, 0x68, 0x79, 0xe9, 0xa8, 0xae, 0xf2, 0x63, 0xd6, 0x73, 0xec, 0xe3, 0xfe, 0x22, 0x77, 0x9e	/* Tphys_mem_access_prot_allowed */
	.byte 0x0f, 0xeb, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x6b, 0xf5, 0x6e, 0xdb, 0x5f, 0x97, 0x7f, 0x6e, 0x63	/* T__pfx_memtype_kernel_map_sync */
	.byte 0x0f, 0x54, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x6b, 0xf5, 0x6e, 0xdb, 0x5f, 0x97, 0x7f, 0x6e, 0x63	/* Tmemtype_kernel_map_sync */
	.byte 0x0a, 0xeb, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x29, 0xf5, 0x1a, 0xc0	/* T__pfx_memtype_reserve_io */
	.byte 0x0a, 0x54, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x29, 0xf5, 0x1a, 0xc0	/* Tmemtype_reserve_io */
	.byte 0x0f, 0xeb, 0xc5, 0xba, 0x5f, 0xc0, 0x07, 0xf5, 0x1a, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x77, 0x63	/* T__pfx_arch_io_reserve_memtype_wc */
	.byte 0x0f, 0x54, 0xc5, 0xba, 0x5f, 0xc0, 0x07, 0xf5, 0x1a, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x77, 0x63	/* Tarch_io_reserve_memtype_wc */
	.byte 0x0b, 0xef, 0x29, 0xf5, 0x1a, 0x70, 0x66, 0x6e, 0xa6, 0xd2, 0x67, 0x65	/* t__pfx_reserve_pfn_range */
	.byte 0x0b, 0x74, 0x29, 0xf5, 0x1a, 0x70, 0x66, 0x6e, 0xa6, 0xd2, 0x67, 0x65	/* treserve_pfn_range */
	.byte 0x09, 0xeb, 0xdf, 0x6b, 0xec, 0x66, 0x6e, 0xf0, 0xbe, 0x79	/* T__pfx_track_pfn_copy */
	.byte 0x09, 0x54, 0xdf, 0x6b, 0xec, 0x66, 0x6e, 0xf0, 0xbe, 0x79	/* Ttrack_pfn_copy */
	.byte 0x08, 0xeb, 0xdf, 0x6b, 0xec, 0x66, 0x6e, 0xde, 0x97	/* T__pfx_track_pfn_remap */
	.byte 0x08, 0x54, 0xdf, 0x6b, 0xec, 0x66, 0x6e, 0xde, 0x97	/* Ttrack_pfn_remap */
	.byte 0x0a, 0xeb, 0xdf, 0x6b, 0xec, 0x66, 0x6e, 0xbf, 0x73, 0xf5, 0x74	/* T__pfx_track_pfn_insert */
	.byte 0x0a, 0x54, 0xdf, 0x6b, 0xec, 0x66, 0x6e, 0xbf, 0x73, 0xf5, 0x74	/* Ttrack_pfn_insert */
	.byte 0x07, 0xeb, 0xe4, 0xdf, 0x6b, 0xec, 0x66, 0x6e	/* T__pfx_untrack_pfn */
	.byte 0x07, 0x54, 0xe4, 0xdf, 0x6b, 0xec, 0x66, 0x6e	/* Tuntrack_pfn */
	.byte 0x0a, 0xeb, 0xe4, 0xdf, 0x6b, 0xec, 0x66, 0x6e, 0xf0, 0xc4, 0xc5	/* T__pfx_untrack_pfn_clear */
	.byte 0x0a, 0x54, 0xe4, 0xdf, 0x6b, 0xec, 0x66, 0x6e, 0xf0, 0xc4, 0xc5	/* Tuntrack_pfn_clear */
	.byte 0x0f, 0xef, 0xb3, 0xf5, 0x76, 0xe5, 0x5f, 0x61, 0x75, 0x67, 0x6d, 0xf1, 0xfe, 0xe3, 0xf4, 0x2c	/* t__pfx_interval_augment_rotate */
	.byte 0x0f, 0x74, 0xb3, 0xf5, 0x76, 0xe5, 0x5f, 0x61, 0x75, 0x67, 0x6d, 0xf1, 0xfe, 0xe3, 0xf4, 0x2c	/* tinterval_augment_rotate */
	.byte 0x0e, 0xef, 0xb3, 0xf5, 0x76, 0xe5, 0xf6, 0x88, 0x74, 0xf7, 0xfc, 0x73, 0x65, 0xc5, 0xba	/* t__pfx_interval_subtree_search */
	.byte 0x0e, 0x74, 0xb3, 0xf5, 0x76, 0xe5, 0xf6, 0x88, 0x74, 0xf7, 0xfc, 0x73, 0x65, 0xc5, 0xba	/* tinterval_subtree_search */
	.byte 0x09, 0xef, 0xb3, 0xf5, 0x76, 0xe5, 0x5f, 0x89, 0xbd, 0x8e	/* t__pfx_interval_iter_next */
	.byte 0x09, 0x74, 0xb3, 0xf5, 0x76, 0xe5, 0x5f, 0x89, 0xbd, 0x8e	/* tinterval_iter_next */
	.byte 0x10, 0xef, 0xb3, 0xf5, 0x76, 0xe5, 0xbf, 0x73, 0xf5, 0x74, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__pfx_interval_insert.constprop.0 */
	.byte 0x10, 0x74, 0xb3, 0xf5, 0x76, 0xe5, 0xbf, 0x73, 0xf5, 0x74, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* tinterval_insert.constprop.0 */
	.byte 0x10, 0xef, 0xb3, 0xf5, 0x76, 0xe5, 0xde, 0x17, 0x76, 0x65, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__pfx_interval_remove.constprop.0 */
	.byte 0x10, 0x74, 0xb3, 0xf5, 0x76, 0xe5, 0xde, 0x17, 0x76, 0x65, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* tinterval_remove.constprop.0 */
	.byte 0x09, 0xef, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x6d, 0xe8, 0xba	/* t__pfx_memtype_match */
	.byte 0x09, 0x74, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x6d, 0xe8, 0xba	/* tmemtype_match */
	.byte 0x0d, 0xeb, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0xba, 0x65, 0xc6, 0xbf, 0x73, 0xf5, 0x74	/* T__pfx_memtype_check_insert */
	.byte 0x0d, 0x54, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0xba, 0x65, 0xc6, 0xbf, 0x73, 0xf5, 0x74	/* Tmemtype_check_insert */
	.byte 0x09, 0xeb, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0xf5, 0xbb, 0x65	/* T__pfx_memtype_erase */
	.byte 0x09, 0x54, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0xf5, 0xbb, 0x65	/* Tmemtype_erase */
	.byte 0x0a, 0xeb, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0xdd, 0x6f, 0x6b, 0xcd	/* T__pfx_memtype_lookup */
	.byte 0x0a, 0x54, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0xdd, 0x6f, 0x6b, 0xcd	/* Tmemtype_lookup */
	.byte 0x12, 0xeb, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x63, 0xbe, 0x79, 0xbd, 0x74, 0x68, 0x5f, 0xdb, 0x65, 0x6d, 0xf1, 0x74	/* T__pfx_memtype_copy_nth_element */
	.byte 0x12, 0x54, 0xa8, 0x6d, 0x74, 0x21, 0xfc, 0x63, 0xbe, 0x79, 0xbd, 0x74, 0x68, 0x5f, 0xdb, 0x65, 0x6d, 0xf1, 0x74	/* Tmemtype_copy_nth_element */
	.byte 0x0a, 0xef, 0x65, 0x66, 0x66, 0xb4, 0xdc, 0x1a, 0x70, 0xe3, 0x74	/* t__pfx_effective_prot */
	.byte 0x09, 0x2c, 0x66, 0x66, 0xb4, 0xdc, 0x1a, 0x70, 0xe3, 0x74	/* teffective_prot */
	.byte 0x08, 0xef, 0x6e, 0x6f, 0x74, 0xfc, 0x70, 0x83, 0x65	/* t__pfx_note_page */
	.byte 0x08, 0x74, 0x6e, 0x6f, 0x74, 0xfc, 0x70, 0x83, 0x65	/* tnote_page */
	.byte 0x11, 0xeb, 0x70, 0x74, 0x64, 0x75, 0xb6, 0x92, 0xe5, 0x6b, 0xec, 0x67, 0xda, 0x6c, 0xee, 0xdb, 0x3a, 0xf7	/* T__pfx_ptdump_walk_pgd_level_core */
	.byte 0x11, 0x54, 0x70, 0x74, 0x64, 0x75, 0xb6, 0x92, 0xe5, 0x6b, 0xec, 0x67, 0xda, 0x6c, 0xee, 0xdb, 0x3a, 0xf7	/* Tptdump_walk_pgd_level_core */
	.byte 0x14, 0xeb, 0x70, 0x74, 0x64, 0x75, 0xb6, 0x92, 0xe5, 0x6b, 0xec, 0x67, 0xda, 0x6c, 0xee, 0xdb, 0xed, 0x65, 0x06, 0x67, 0x95	/* T__pfx_ptdump_walk_pgd_level_debugfs */
	.byte 0x14, 0x54, 0x70, 0x74, 0x64, 0x75, 0xb6, 0x92, 0xe5, 0x6b, 0xec, 0x67, 0xda, 0x6c, 0xee, 0xdb, 0xed, 0x65, 0x06, 0x67, 0x95	/* Tptdump_walk_pgd_level_debugfs */
	.byte 0x0f, 0xeb, 0x70, 0x74, 0x64, 0x75, 0xb6, 0x92, 0xe5, 0x6b, 0xec, 0x67, 0xda, 0x6c, 0xee, 0xdb	/* T__pfx_ptdump_walk_pgd_level */
	.byte 0x0f, 0x54, 0x70, 0x74, 0x64, 0x75, 0xb6, 0x92, 0xe5, 0x6b, 0xec, 0x67, 0xda, 0x6c, 0xee, 0xdb	/* Tptdump_walk_pgd_level */
	.byte 0x17, 0xeb, 0x70, 0x74, 0x64, 0x75, 0xb6, 0x92, 0xe5, 0x6b, 0x5f, 0xb1, 0xf5, 0xec, 0x67, 0xda, 0x6c, 0xee, 0xdb, 0x25, 0x65, 0xc6, 0x77, 0x78	/* T__pfx_ptdump_walk_user_pgd_level_checkwx */
	.byte 0x17, 0x54, 0x70, 0x74, 0x64, 0x75, 0xb6, 0x92, 0xe5, 0x6b, 0x5f, 0xb1, 0xf5, 0xec, 0x67, 0xda, 0x6c, 0xee, 0xdb, 0x25, 0x65, 0xc6, 0x77, 0x78	/* Tptdump_walk_user_pgd_level_checkwx */
	.byte 0x14, 0xeb, 0x70, 0x74, 0x64, 0x75, 0xb6, 0x92, 0xe5, 0x6b, 0xec, 0x67, 0xda, 0x6c, 0xee, 0xdb, 0x25, 0x65, 0xc6, 0x77, 0x78	/* T__pfx_ptdump_walk_pgd_level_checkwx */
	.byte 0x14, 0x54, 0x70, 0x74, 0x64, 0x75, 0xb6, 0x92, 0xe5, 0x6b, 0xec, 0x67, 0xda, 0x6c, 0xee, 0xdb, 0x25, 0x65, 0xc6, 0x77, 0x78	/* Tptdump_walk_pgd_level_checkwx */
	.byte 0x08, 0xef, 0x6f, 0x66, 0xbd, 0x75, 0xd9, 0xbf, 0xea	/* t__pfx_of_numa_init */
	.byte 0x07, 0x8a, 0x66, 0xbd, 0x75, 0xd9, 0xbf, 0xea	/* tof_numa_init */
	.byte 0x09, 0xeb, 0x6e, 0x75, 0xd9, 0xf0, 0x9c, 0xbd, 0xb7, 0x65	/* T__pfx_numa_cpu_node */
	.byte 0x09, 0x54, 0x6e, 0x75, 0xd9, 0xf0, 0x9c, 0xbd, 0xb7, 0x65	/* Tnuma_cpu_node */
	.byte 0x08, 0xeb, 0x6e, 0x75, 0xd9, 0x84, 0x6e, 0xb7, 0x65	/* T__pfx_numa_set_node */
	.byte 0x08, 0x54, 0x6e, 0x75, 0xd9, 0x84, 0x6e, 0xb7, 0x65	/* Tnuma_set_node */
	.byte 0x0a, 0xeb, 0x6e, 0x75, 0xd9, 0xf0, 0xc4, 0xc5, 0xbd, 0xb7, 0x65	/* T__pfx_numa_clear_node */
	.byte 0x0a, 0x54, 0x6e, 0x75, 0xd9, 0xf0, 0xc4, 0xc5, 0xbd, 0xb7, 0x65	/* Tnuma_clear_node */
	.byte 0x09, 0xeb, 0x6e, 0x75, 0xd9, 0x5f, 0xc8, 0x64, 0xf0, 0x9c	/* T__pfx_numa_add_cpu */
	.byte 0x09, 0x54, 0x6e, 0x75, 0xd9, 0x5f, 0xc8, 0x64, 0xf0, 0x9c	/* Tnuma_add_cpu */
	.byte 0x09, 0xeb, 0x6e, 0x75, 0xd9, 0xde, 0x17, 0x1a, 0x63, 0x9c	/* T__pfx_numa_remove_cpu */
	.byte 0x09, 0x54, 0x6e, 0x75, 0xd9, 0xde, 0x17, 0x1a, 0x63, 0x9c	/* Tnuma_remove_cpu */
	.byte 0x0c, 0xef, 0xf8, 0x9d, 0x70, 0x6b, 0x72, 0x75, 0x92, 0x3c, 0xfc, 0xa5, 0xc4	/* t__pfx_init_pkru_write_file */
	.byte 0x0c, 0x74, 0xf8, 0x9d, 0x70, 0x6b, 0x72, 0x75, 0x92, 0x3c, 0xfc, 0xa5, 0xc4	/* tinit_pkru_write_file */
	.byte 0x0c, 0xef, 0xf8, 0x9d, 0x70, 0x6b, 0x72, 0x75, 0xde, 0xc8, 0xe6, 0x69, 0xc4	/* t__pfx_init_pkru_read_file */
	.byte 0x0c, 0x74, 0xf8, 0x9d, 0x70, 0x6b, 0x72, 0x75, 0xde, 0xc8, 0xe6, 0x69, 0xc4	/* tinit_pkru_read_file */
	.byte 0x0c, 0x08, 0xcb, 0xb4, 0x20, 0xfc, 0xe7, 0x6c, 0x79, 0xec, 0x6b, 0x65, 0x79	/* T__pfx___execute_only_pkey */
	.byte 0x0c, 0xb9, 0xcb, 0xb4, 0x20, 0xfc, 0xe7, 0x6c, 0x79, 0xec, 0x6b, 0x65, 0x79	/* T__execute_only_pkey */
	.byte 0x12, 0x08, 0xc5, 0xba, 0x5f, 0x6f, 0x0b, 0x72, 0x9f, 0xfc, 0xb6, 0xe3, 0x74, 0xb4, 0xfe, 0x70, 0x6b, 0x65, 0x79	/* T__pfx___arch_override_mprotect_pkey */
	.byte 0x12, 0xb9, 0xc5, 0xba, 0x5f, 0x6f, 0x0b, 0x72, 0x9f, 0xfc, 0xb6, 0xe3, 0x74, 0xb4, 0xfe, 0x70, 0x6b, 0x65, 0x79	/* T__arch_override_mprotect_pkey */
	.byte 0x11, 0xef, 0x70, 0xdc, 0x5f, 0xb1, 0xf5, 0xec, 0x83, 0x65, 0xe0, 0xb0, 0x77, 0xe5, 0x6b, 0xec, 0x34, 0x64	/* t__pfx_pti_user_pagetable_walk_p4d */
	.byte 0x10, 0xce, 0xdc, 0x5f, 0xb1, 0xf5, 0xec, 0x83, 0x65, 0xe0, 0xb0, 0x77, 0xe5, 0x6b, 0xec, 0x34, 0x64	/* tpti_user_pagetable_walk_p4d */
	.byte 0x11, 0xef, 0x70, 0xdc, 0x5f, 0xb1, 0xf5, 0xec, 0x83, 0x65, 0xe0, 0xb0, 0x77, 0xe5, 0x6b, 0xec, 0x6d, 0x64	/* t__pfx_pti_user_pagetable_walk_pmd */
	.byte 0x10, 0xce, 0xdc, 0x5f, 0xb1, 0xf5, 0xec, 0x83, 0x65, 0xe0, 0xb0, 0x77, 0xe5, 0x6b, 0xec, 0x6d, 0x64	/* tpti_user_pagetable_walk_pmd */
	.byte 0x10, 0xef, 0x70, 0xdc, 0x5f, 0xb1, 0xf5, 0xec, 0x83, 0x65, 0xe0, 0xb0, 0x77, 0xe5, 0x6b, 0xec, 0x2c	/* t__pfx_pti_user_pagetable_walk_pte */
	.byte 0x0f, 0xce, 0xdc, 0x5f, 0xb1, 0xf5, 0xec, 0x83, 0x65, 0xe0, 0xb0, 0x77, 0xe5, 0x6b, 0xec, 0x2c	/* tpti_user_pagetable_walk_pte */
	.byte 0x12, 0xef, 0x70, 0xdc, 0xf0, 0x6c, 0xe7, 0xfc, 0x70, 0x67, 0xe0, 0xc4, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__pfx_pti_clone_pgtable.constprop.0 */
	.byte 0x11, 0xce, 0xdc, 0xf0, 0x6c, 0xe7, 0xfc, 0x70, 0x67, 0xe0, 0xc4, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* tpti_clone_pgtable.constprop.0 */
	.byte 0x0b, 0x99, 0xec, 0xdc, 0x84, 0xb1, 0xf5, 0xec, 0x67, 0x74, 0x62, 0x6c	/* T__pfx___pti_set_user_pgtbl */
	.byte 0x0b, 0x54, 0xfd, 0xdc, 0x84, 0xb1, 0xf5, 0xec, 0x67, 0x74, 0x62, 0x6c	/* T__pti_set_user_pgtbl */
	.byte 0x09, 0xeb, 0x70, 0xdc, 0xe6, 0xf8, 0xe5, 0x69, 0x7a, 0x65	/* T__pfx_pti_finalize */
	.byte 0x09, 0x54, 0x70, 0xdc, 0xe6, 0xf8, 0xe5, 0x69, 0x7a, 0x65	/* Tpti_finalize */
	.byte 0x0f, 0xeb, 0x69, 0x61, 0x33, 0x32, 0xf0, 0x6c, 0xbb, 0x85, 0x66, 0x79, 0x7f, 0x73, 0x63, 0x5d	/* T__pfx_ia32_classify_syscall */
	.byte 0x0f, 0x54, 0x69, 0x61, 0x33, 0x32, 0xf0, 0x6c, 0xbb, 0x85, 0x66, 0x79, 0x7f, 0x73, 0x63, 0x5d	/* Tia32_classify_syscall */
	.byte 0x0d, 0xeb, 0x65, 0xa5, 0x76, 0xc5, 0x07, 0xf5, 0x76, 0x9e, 0xf6, 0x70, 0xf2, 0x65	/* T__pfx_efivar_reserved_space */
	.byte 0x0d, 0x54, 0x65, 0xa5, 0x76, 0xc5, 0x07, 0xf5, 0x76, 0x9e, 0xf6, 0x70, 0xf2, 0x65	/* Tefivar_reserved_space */
	.byte 0x11, 0xeb, 0x65, 0xa5, 0xed, 0xdb, 0xd4, 0xfc, 0x64, 0x75, 0x6d, 0x6d, 0x1d, 0x76, 0xc5, 0x69, 0x90, 0xc4	/* T__pfx_efi_delete_dummy_variable */
	.byte 0x11, 0x54, 0x65, 0xa5, 0xed, 0xdb, 0xd4, 0xfc, 0x64, 0x75, 0x6d, 0x6d, 0x1d, 0x76, 0xc5, 0x69, 0x90, 0xc4	/* Tefi_delete_dummy_variable */
	.byte 0x0f, 0xeb, 0x65, 0xa5, 0x5f, 0xa1, 0xf5, 0x1d, 0x76, 0xc5, 0x69, 0x90, 0xb0, 0x73, 0x8a, 0xf7	/* T__pfx_efi_query_variable_store */
	.byte 0x0f, 0x54, 0x65, 0xa5, 0x5f, 0xa1, 0xf5, 0x1d, 0x76, 0xc5, 0x69, 0x90, 0xb0, 0x73, 0x8a, 0xf7	/* Tefi_query_variable_store */
	.byte 0x0d, 0xeb, 0x65, 0xa5, 0xde, 0x62, 0x6f, 0x6f, 0xfe, 0xf7, 0xa1, 0x69, 0xf7, 0x64	/* T__pfx_efi_reboot_required */
	.byte 0x0d, 0x54, 0x65, 0xa5, 0xde, 0x62, 0x6f, 0x6f, 0xfe, 0xf7, 0xa1, 0x69, 0xf7, 0x64	/* Tefi_reboot_required */
	.byte 0x0e, 0xeb, 0x65, 0xa5, 0xec, 0xad, 0xf5, 0x6f, 0x66, 0x66, 0xde, 0xa1, 0x69, 0xf7, 0x64	/* T__pfx_efi_poweroff_required */
	.byte 0x0e, 0x54, 0x65, 0xa5, 0xec, 0xad, 0xf5, 0x6f, 0x66, 0x66, 0xde, 0xa1, 0x69, 0xf7, 0x64	/* Tefi_poweroff_required */
	.byte 0x17, 0xeb, 0x65, 0xa5, 0xf0, 0xbc, 0x73, 0x68, 0xc7, 0x72, 0xf2, 0x65, 0x66, 0x02, 0x6c, 0x1d, 0xe7, 0xec, 0x83, 0xfc, 0x66, 0x61, 0x02, 0x74	/* T__pfx_efi_crash_gracefully_on_page_fault */
	.byte 0x17, 0x54, 0x65, 0xa5, 0xf0, 0xbc, 0x73, 0x68, 0xc7, 0x72, 0xf2, 0x65, 0x66, 0x02, 0x6c, 0x1d, 0xe7, 0xec, 0x83, 0xfc, 0x66, 0x61, 0x02, 0x74	/* Tefi_crash_gracefully_on_page_fault */
	.byte 0x09, 0xef, 0x66, 0x8f, 0x76, 0xf1, 0x64, 0xd5, 0xf6, 0x7c	/* t__pfx_fw_vendor_show */
	.byte 0x09, 0x74, 0x66, 0x8f, 0x76, 0xf1, 0x64, 0xd5, 0xf6, 0x7c	/* tfw_vendor_show */
	.byte 0x07, 0xef, 0x72, 0xe4, 0x00, 0xfc, 0x73, 0x7c	/* t__pfx_runtime_show */
	.byte 0x06, 0xf3, 0xe4, 0x00, 0xfc, 0x73, 0x7c	/* truntime_show */
	.byte 0x09, 0xef, 0x40, 0xa5, 0x67, 0x5f, 0xe0, 0xb0, 0x73, 0x7c	/* t__pfx_config_table_show */
	.byte 0x09, 0x74, 0x40, 0xa5, 0x67, 0x5f, 0xe0, 0xb0, 0x73, 0x7c	/* tconfig_table_show */
	.byte 0x0c, 0xeb, 0x65, 0xa5, 0x5f, 0x69, 0xe9, 0xe0, 0xb0, 0xc8, 0x64, 0x29, 0x73	/* T__pfx_efi_is_table_address */
	.byte 0x0c, 0x54, 0x65, 0xa5, 0x5f, 0x69, 0xe9, 0xe0, 0xb0, 0xc8, 0x64, 0x29, 0x73	/* Tefi_is_table_address */
	.byte 0x0b, 0xeb, 0x65, 0xa5, 0x7f, 0x73, 0xe0, 0xf6, 0x7c, 0x5f, 0xc5, 0xba	/* T__pfx_efi_systab_show_arch */
	.byte 0x0b, 0x54, 0x65, 0xa5, 0x7f, 0x73, 0xe0, 0xf6, 0x7c, 0x5f, 0xc5, 0xba	/* Tefi_systab_show_arch */
	.byte 0x0d, 0xeb, 0x65, 0xa5, 0x5f, 0x24, 0x5f, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* T__pfx_efi_attr_is_visible */
	.byte 0x0d, 0x54, 0x65, 0xa5, 0x5f, 0x24, 0x5f, 0x69, 0xe9, 0x76, 0xca, 0x69, 0x62, 0xc4	/* Tefi_attr_is_visible */
	.byte 0x11, 0x08, 0x78, 0x38, 0x36, 0x5f, 0x69, 0xd9, 0x5f, 0x65, 0xa5, 0xb8, 0x6f, 0x6f, 0xfe, 0x6d, 0xb7, 0x65	/* T__pfx___x86_ima_efi_boot_mode */
	.byte 0x11, 0xb9, 0x78, 0x38, 0x36, 0x5f, 0x69, 0xd9, 0x5f, 0x65, 0xa5, 0xb8, 0x6f, 0x6f, 0xfe, 0x6d, 0xb7, 0x65	/* T__x86_ima_efi_boot_mode */
	.byte 0x0a, 0xef, 0x65, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x86, 0xdc, 0xa8	/* t__pfx_efi_thunk_get_time */
	.byte 0x09, 0x2c, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x86, 0xdc, 0xa8	/* tefi_thunk_get_time */
	.byte 0x0a, 0xef, 0x65, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x84, 0xdc, 0xa8	/* t__pfx_efi_thunk_set_time */
	.byte 0x09, 0x2c, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x84, 0xdc, 0xa8	/* tefi_thunk_set_time */
	.byte 0x10, 0xef, 0x65, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x86, 0x77, 0x61, 0x6b, 0x65, 0xcd, 0x5f, 0xdc, 0xa8	/* t__pfx_efi_thunk_get_wakeup_time */
	.byte 0x0f, 0x2c, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x86, 0x77, 0x61, 0x6b, 0x65, 0xcd, 0x5f, 0xdc, 0xa8	/* tefi_thunk_get_wakeup_time */
	.byte 0x10, 0xef, 0x65, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x84, 0x77, 0x61, 0x6b, 0x65, 0xcd, 0x5f, 0xdc, 0xa8	/* t__pfx_efi_thunk_set_wakeup_time */
	.byte 0x0f, 0x2c, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x84, 0x77, 0x61, 0x6b, 0x65, 0xcd, 0x5f, 0xdc, 0xa8	/* tefi_thunk_set_wakeup_time */
	.byte 0x11, 0xef, 0x65, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x5f, 0xcd, 0x64, 0x91, 0x63, 0x61, 0x70, 0x73, 0x75, 0xc4	/* t__pfx_efi_thunk_update_capsule */
	.byte 0x10, 0x2c, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x5f, 0xcd, 0x64, 0x91, 0x63, 0x61, 0x70, 0x73, 0x75, 0xc4	/* tefi_thunk_update_capsule */
	.byte 0x15, 0xef, 0x65, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x5f, 0xa1, 0xf5, 0x79, 0xf0, 0x61, 0x70, 0x73, 0x75, 0xb0, 0x63, 0x61, 0x70, 0x73	/* t__pfx_efi_thunk_query_capsule_caps */
	.byte 0x14, 0x2c, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x5f, 0xa1, 0xf5, 0x79, 0xf0, 0x61, 0x70, 0x73, 0x75, 0xb0, 0x63, 0x61, 0x70, 0x73	/* tefi_thunk_query_capsule_caps */
	.byte 0x14, 0xef, 0x65, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x86, 0x6e, 0xcb, 0xfe, 0x68, 0x0c, 0x68, 0xc1, 0xe7, 0x6f, 0x3a, 0xe4, 0x74	/* t__pfx_efi_thunk_get_next_high_mono_count */
	.byte 0x13, 0x2c, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x86, 0x6e, 0xcb, 0xfe, 0x68, 0x0c, 0x68, 0xc1, 0xe7, 0x6f, 0x3a, 0xe4, 0x74	/* tefi_thunk_get_next_high_mono_count */
	.byte 0x11, 0xeb, 0x65, 0xa5, 0x7f, 0x6e, 0xc9, 0xdd, 0x8f, 0x6b, 0xf5, 0x6e, 0xdb, 0x5f, 0x97, 0x70, 0x8d, 0x73	/* T__pfx_efi_sync_low_kernel_mappings */
	.byte 0x11, 0x54, 0x65, 0xa5, 0x7f, 0x6e, 0xc9, 0xdd, 0x8f, 0x6b, 0xf5, 0x6e, 0xdb, 0x5f, 0x97, 0x70, 0x8d, 0x73	/* Tefi_sync_low_kernel_mappings */
	.byte 0x0f, 0xeb, 0xc5, 0xba, 0x5f, 0x65, 0xa5, 0xf0, 0x5d, 0x5f, 0x76, 0xab, 0xfe, 0x73, 0xd4, 0xcd	/* T__pfx_arch_efi_call_virt_setup */
	.byte 0x0f, 0x54, 0xc5, 0xba, 0x5f, 0x65, 0xa5, 0xf0, 0x5d, 0x5f, 0x76, 0xab, 0xfe, 0x73, 0xd4, 0xcd	/* Tarch_efi_call_virt_setup */
	.byte 0x11, 0xeb, 0xc5, 0xba, 0x5f, 0x65, 0xa5, 0xf0, 0x5d, 0x5f, 0x76, 0xab, 0xfe, 0x2c, 0xc5, 0x64, 0xad, 0x6e	/* T__pfx_arch_efi_call_virt_teardown */
	.byte 0x11, 0x54, 0xc5, 0xba, 0x5f, 0x65, 0xa5, 0xf0, 0x5d, 0x5f, 0x76, 0xab, 0xfe, 0x2c, 0xc5, 0x64, 0xad, 0x6e	/* Tarch_efi_call_virt_teardown */
	.byte 0x18, 0xef, 0x65, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x5f, 0xa1, 0xf5, 0x1d, 0x76, 0xc5, 0x69, 0x90, 0xb0, 0xf8, 0x66, 0x6f, 0xbd, 0xe7, 0x62, 0xa4, 0x8d	/* t__pfx_efi_thunk_query_variable_info_nonblocking */
	.byte 0x17, 0x2c, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x5f, 0xa1, 0xf5, 0x1d, 0x76, 0xc5, 0x69, 0x90, 0xb0, 0xf8, 0x66, 0x6f, 0xbd, 0xe7, 0x62, 0xa4, 0x8d	/* tefi_thunk_query_variable_info_nonblocking */
	.byte 0x13, 0xef, 0x65, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x5f, 0xa1, 0xf5, 0x1d, 0x76, 0xc5, 0x69, 0x90, 0xb0, 0xf8, 0x66, 0x6f	/* t__pfx_efi_thunk_query_variable_info */
	.byte 0x12, 0x2c, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x5f, 0xa1, 0xf5, 0x1d, 0x76, 0xc5, 0x69, 0x90, 0xb0, 0xf8, 0x66, 0x6f	/* tefi_thunk_query_variable_info */
	.byte 0x0d, 0xef, 0x65, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x07, 0xe2, 0xe1, 0x73, 0x2c, 0x6d	/* t__pfx_efi_thunk_reset_system */
	.byte 0x0c, 0x2c, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x07, 0xe2, 0xe1, 0x73, 0x2c, 0x6d	/* tefi_thunk_reset_system */
	.byte 0x12, 0xef, 0x65, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x84, 0x76, 0xc5, 0x69, 0x90, 0xb0, 0x6e, 0xe7, 0x62, 0xa4, 0x8d	/* t__pfx_efi_thunk_set_variable_nonblocking */
	.byte 0x11, 0x2c, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x84, 0x76, 0xc5, 0x69, 0x90, 0xb0, 0x6e, 0xe7, 0x62, 0xa4, 0x8d	/* tefi_thunk_set_variable_nonblocking */
	.byte 0x0d, 0xef, 0x65, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x84, 0x76, 0xc5, 0x69, 0x90, 0xc4	/* t__pfx_efi_thunk_set_variable */
	.byte 0x0c, 0x2c, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x84, 0x76, 0xc5, 0x69, 0x90, 0xc4	/* tefi_thunk_set_variable */
	.byte 0x10, 0xef, 0x65, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x86, 0x6e, 0xcb, 0xfe, 0x76, 0xc5, 0x69, 0x90, 0xc4	/* t__pfx_efi_thunk_get_next_variable */
	.byte 0x0f, 0x2c, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x86, 0x6e, 0xcb, 0xfe, 0x76, 0xc5, 0x69, 0x90, 0xc4	/* tefi_thunk_get_next_variable */
	.byte 0x0d, 0xef, 0x65, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x86, 0x76, 0xc5, 0x69, 0x90, 0xc4	/* t__pfx_efi_thunk_get_variable */
	.byte 0x0c, 0x2c, 0xa5, 0xa7, 0x68, 0xe4, 0x6b, 0x86, 0x76, 0xc5, 0x69, 0x90, 0xc4	/* tefi_thunk_get_variable */
	.byte 0x05, 0x08, 0x65, 0xa5, 0xf0, 0x5d	/* T__pfx___efi_call */
	.byte 0x05, 0xb9, 0x65, 0xa5, 0xf0, 0x5d	/* T__efi_call */
	.byte 0x09, 0x08, 0x65, 0xa5, 0x36, 0x34, 0xa7, 0x68, 0xe4, 0x6b	/* T__pfx___efi64_thunk */
	.byte 0x09, 0xb9, 0x65, 0xa5, 0x36, 0x34, 0xa7, 0x68, 0xe4, 0x6b	/* T__efi64_thunk */
	.byte 0x06, 0xef, 0x97, 0x5f, 0x24, 0xf6, 0x7c	/* t__pfx_map_attr_show */
	.byte 0x06, 0x74, 0x97, 0x5f, 0x24, 0xf6, 0x7c	/* tmap_attr_show */
	.byte 0x08, 0xef, 0x24, 0x69, 0x62, 0x20, 0xfc, 0x73, 0x7c	/* t__pfx_attribute_show */
	.byte 0x09, 0xf4, 0x74, 0xf3, 0x69, 0x62, 0x20, 0xfc, 0x73, 0x7c	/* tattribute_show */
	.byte 0x09, 0xef, 0x6e, 0x75, 0x6d, 0xec, 0x83, 0xd6, 0xf6, 0x7c	/* t__pfx_num_pages_show */
	.byte 0x09, 0x74, 0x6e, 0x75, 0x6d, 0xec, 0x83, 0xd6, 0xf6, 0x7c	/* tnum_pages_show */
	.byte 0x08, 0xef, 0x76, 0xab, 0xfe, 0xc8, 0xac, 0xf6, 0x7c	/* t__pfx_virt_addr_show */
	.byte 0x08, 0x74, 0x76, 0xab, 0xfe, 0xc8, 0xac, 0xf6, 0x7c	/* tvirt_addr_show */
	.byte 0x09, 0xef, 0x70, 0x68, 0x79, 0xe9, 0xc8, 0xac, 0xf6, 0x7c	/* t__pfx_phys_addr_show */
	.byte 0x08, 0xce, 0x68, 0x79, 0xe9, 0xc8, 0xac, 0xf6, 0x7c	/* tphys_addr_show */
	.byte 0x06, 0xef, 0x74, 0x21, 0xfc, 0x73, 0x7c	/* t__pfx_type_show */
	.byte 0x06, 0x74, 0x74, 0x21, 0xfc, 0x73, 0x7c	/* ttype_show */
	.byte 0x06, 0xef, 0x97, 0xde, 0xc4, 0xbb, 0x65	/* t__pfx_map_release */
	.byte 0x06, 0x74, 0x97, 0xde, 0xc4, 0xbb, 0x65	/* tmap_release */
	.byte 0x0d, 0xeb, 0x65, 0xa5, 0x86, 0x72, 0xe4, 0x00, 0xfc, 0x97, 0xf6, 0x69, 0x7a, 0x65	/* T__pfx_efi_get_runtime_map_size */
	.byte 0x0d, 0x54, 0x65, 0xa5, 0x86, 0x72, 0xe4, 0x00, 0xfc, 0x97, 0xf6, 0x69, 0x7a, 0x65	/* Tefi_get_runtime_map_size */
	.byte 0x10, 0xeb, 0x65, 0xa5, 0x86, 0x72, 0xe4, 0x00, 0xfc, 0x97, 0xed, 0xd6, 0x63, 0xf6, 0x69, 0x7a, 0x65	/* T__pfx_efi_get_runtime_map_desc_size */
	.byte 0x10, 0x54, 0x65, 0xa5, 0x86, 0x72, 0xe4, 0x00, 0xfc, 0x97, 0xed, 0xd6, 0x63, 0xf6, 0x69, 0x7a, 0x65	/* Tefi_get_runtime_map_desc_size */
	.byte 0x0b, 0xeb, 0x65, 0xa5, 0xa6, 0xe4, 0x00, 0xfc, 0x97, 0xf0, 0xbe, 0x79	/* T__pfx_efi_runtime_map_copy */
	.byte 0x0b, 0x54, 0x65, 0xa5, 0xa6, 0xe4, 0x00, 0xfc, 0x97, 0xf0, 0xbe, 0x79	/* Tefi_runtime_map_copy */
	.byte 0x0f, 0xeb, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x90, 0xc4	/* T__pfx_iosf_mbi_available */
	.byte 0x0f, 0x54, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x90, 0xc4	/* Tiosf_mbi_available */
	.byte 0x0e, 0xef, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0xec, 0x9b, 0xde, 0x61, 0xda, 0x6d, 0xac	/* t__pfx_iosf_mbi_pci_read_mdr */
	.byte 0x0e, 0xdc, 0x6f, 0x73, 0x66, 0xc1, 0x62, 0x69, 0xec, 0x9b, 0xde, 0x61, 0xda, 0x6d, 0xac	/* tiosf_mbi_pci_read_mdr */
	.byte 0x0e, 0xef, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0xec, 0x9b, 0x92, 0x3c, 0xfc, 0x6d, 0xac	/* t__pfx_iosf_mbi_pci_write_mdr */
	.byte 0x0e, 0xdc, 0x6f, 0x73, 0x66, 0xc1, 0x62, 0x69, 0xec, 0x9b, 0x92, 0x3c, 0xfc, 0x6d, 0xac	/* tiosf_mbi_pci_write_mdr */
	.byte 0x0c, 0xeb, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0xc1, 0xb7, 0x69, 0x66, 0x79	/* T__pfx_iosf_mbi_modify */
	.byte 0x0c, 0x54, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0xc1, 0xb7, 0x69, 0x66, 0x79	/* Tiosf_mbi_modify */
	.byte 0x0e, 0xeb, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0xec, 0xe4, 0x9d, 0xf2, 0xa1, 0x69, 0xf7	/* T__pfx_iosf_mbi_punit_acquire */
	.byte 0x0e, 0x54, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0xec, 0xe4, 0x9d, 0xf2, 0xa1, 0x69, 0xf7	/* Tiosf_mbi_punit_acquire */
	.byte 0x0f, 0xef, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0x07, 0xe2, 0x73, 0x65, 0x97, 0x68, 0x6f, 0xf7	/* t__pfx_iosf_mbi_reset_semaphore */
	.byte 0x0f, 0xdc, 0x6f, 0x73, 0x66, 0xc1, 0x62, 0x69, 0x07, 0xe2, 0x73, 0x65, 0x97, 0x68, 0x6f, 0xf7	/* tiosf_mbi_reset_semaphore */
	.byte 0x0a, 0xef, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0xec, 0x8c, 0x65	/* t__pfx_iosf_mbi_probe */
	.byte 0x0a, 0xdc, 0x6f, 0x73, 0x66, 0xc1, 0x62, 0x69, 0xec, 0x8c, 0x65	/* tiosf_mbi_probe */
	.byte 0x09, 0xeb, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0xde, 0xc8	/* T__pfx_iosf_mbi_read */
	.byte 0x09, 0x54, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0xde, 0xc8	/* Tiosf_mbi_read */
	.byte 0x0a, 0xeb, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0x92, 0x3c, 0x65	/* T__pfx_iosf_mbi_write */
	.byte 0x0a, 0x54, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0x92, 0x3c, 0x65	/* Tiosf_mbi_write */
	.byte 0x15, 0xeb, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0x5f, 0xe4, 0x62, 0xa4, 0xec, 0xe4, 0x9d, 0x69, 0x32, 0xc9, 0xf2, 0x63, 0xd6, 0x73	/* T__pfx_iosf_mbi_unblock_punit_i2c_access */
	.byte 0x15, 0x54, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0x5f, 0xe4, 0x62, 0xa4, 0xec, 0xe4, 0x9d, 0x69, 0x32, 0xc9, 0xf2, 0x63, 0xd6, 0x73	/* Tiosf_mbi_unblock_punit_i2c_access */
	.byte 0x0e, 0xeb, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0xec, 0xe4, 0x9d, 0xf7, 0xc4, 0xbb, 0x65	/* T__pfx_iosf_mbi_punit_release */
	.byte 0x0e, 0x54, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0xec, 0xe4, 0x9d, 0xf7, 0xc4, 0xbb, 0x65	/* Tiosf_mbi_punit_release */
	.byte 0x13, 0xeb, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0xb8, 0xa4, 0xec, 0xe4, 0x9d, 0x69, 0x32, 0xc9, 0xf2, 0x63, 0xd6, 0x73	/* T__pfx_iosf_mbi_block_punit_i2c_access */
	.byte 0x13, 0x54, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0xb8, 0xa4, 0xec, 0xe4, 0x9d, 0x69, 0x32, 0xc9, 0xf2, 0x63, 0xd6, 0x73	/* Tiosf_mbi_block_punit_i2c_access */
	.byte 0x14, 0xeb, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0x5f, 0xbb, 0x73, 0xf5, 0xfe, 0x70, 0xe4, 0x9d, 0xf2, 0xa1, 0x69, 0xf7, 0x64	/* T__pfx_iosf_mbi_assert_punit_acquired */
	.byte 0x14, 0x54, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0x5f, 0xbb, 0x73, 0xf5, 0xfe, 0x70, 0xe4, 0x9d, 0xf2, 0xa1, 0x69, 0xf7, 0x64	/* Tiosf_mbi_assert_punit_acquired */
	.byte 0x1e, 0xeb, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0x5f, 0xe4, 0xf7, 0x0e, 0xec, 0x6d, 0x69, 0xc9, 0x06, 0xe9, 0xf2, 0x63, 0xd6, 0xe9, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0x5f, 0xe4, 0xa4, 0x9e	/* T__pfx_iosf_mbi_unregister_pmic_bus_access_notifier_unlocked */
	.byte 0x1e, 0x54, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0x5f, 0xe4, 0xf7, 0x0e, 0xec, 0x6d, 0x69, 0xc9, 0x06, 0xe9, 0xf2, 0x63, 0xd6, 0xe9, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0x5f, 0xe4, 0xa4, 0x9e	/* Tiosf_mbi_unregister_pmic_bus_access_notifier_unlocked */
	.byte 0x18, 0xeb, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0xde, 0x0e, 0xec, 0x6d, 0x69, 0xc9, 0x06, 0xe9, 0xf2, 0x63, 0xd6, 0xe9, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5	/* T__pfx_iosf_mbi_register_pmic_bus_access_notifier */
	.byte 0x18, 0x54, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0xde, 0x0e, 0xec, 0x6d, 0x69, 0xc9, 0x06, 0xe9, 0xf2, 0x63, 0xd6, 0xe9, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5	/* Tiosf_mbi_register_pmic_bus_access_notifier */
	.byte 0x1a, 0xeb, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0x5f, 0xe4, 0xf7, 0x0e, 0xec, 0x6d, 0x69, 0xc9, 0x06, 0xe9, 0xf2, 0x63, 0xd6, 0xe9, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5	/* T__pfx_iosf_mbi_unregister_pmic_bus_access_notifier */
	.byte 0x1a, 0x54, 0xc0, 0x73, 0x66, 0xc1, 0x62, 0x69, 0x5f, 0xe4, 0xf7, 0x0e, 0xec, 0x6d, 0x69, 0xc9, 0x06, 0xe9, 0xf2, 0x63, 0xd6, 0xe9, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5	/* Tiosf_mbi_unregister_pmic_bus_access_notifier */
	.byte 0x0a, 0x08, 0x18, 0x5f, 0xf4, 0x5e, 0xbd, 0x65, 0x77, 0xf4, 0x5e	/* T__pfx___traceiter_task_newtask */
	.byte 0x0a, 0xb9, 0x18, 0x5f, 0xf4, 0x5e, 0xbd, 0x65, 0x77, 0xf4, 0x5e	/* T__traceiter_task_newtask */
	.byte 0x0b, 0x99, 0xec, 0x10, 0x5f, 0xf4, 0x5e, 0xbd, 0x65, 0x77, 0xf4, 0x5e	/* T__pfx___probestub_task_newtask */
	.byte 0x0b, 0x54, 0xfd, 0x10, 0x5f, 0xf4, 0x5e, 0xbd, 0x65, 0x77, 0xf4, 0x5e	/* T__probestub_task_newtask */
	.byte 0x09, 0x08, 0x18, 0x5f, 0xf4, 0x5e, 0xde, 0x6e, 0x61, 0xa8	/* T__pfx___traceiter_task_rename */
	.byte 0x09, 0xb9, 0x18, 0x5f, 0xf4, 0x5e, 0xde, 0x6e, 0x61, 0xa8	/* T__traceiter_task_rename */
	.byte 0x0a, 0x99, 0xec, 0x10, 0x5f, 0xf4, 0x5e, 0xde, 0x6e, 0x61, 0xa8	/* T__pfx___probestub_task_rename */
	.byte 0x0a, 0x54, 0xfd, 0x10, 0x5f, 0xf4, 0x5e, 0xde, 0x6e, 0x61, 0xa8	/* T__probestub_task_rename */
	.byte 0x07, 0xeb, 0x67, 0xe2, 0xf4, 0x5e, 0xc1, 0x6d	/* T__pfx_get_task_mm */
	.byte 0x07, 0x54, 0x67, 0xe2, 0xf4, 0x5e, 0xc1, 0x6d	/* Tget_task_mm */
	.byte 0x08, 0xef, 0x9f, 0xb0, 0x64, 0x75, 0x6d, 0x6d, 0x79	/* t__pfx_idle_dummy */
	.byte 0x08, 0xdc, 0x64, 0xb0, 0x64, 0x75, 0x6d, 0x6d, 0x79	/* tidle_dummy */
	.byte 0x0b, 0xef, 0x19, 0x3b, 0xc3, 0xf4, 0x5e, 0xbd, 0x65, 0x77, 0xf4, 0x5e	/* t__pfx_perf_trace_task_newtask */
	.byte 0x0b, 0xce, 0xf5, 0x3b, 0xc3, 0xf4, 0x5e, 0xbd, 0x65, 0x77, 0xf4, 0x5e	/* tperf_trace_task_newtask */
	.byte 0x0b, 0xef, 0x7d, 0x7b, 0xcc, 0xf4, 0x5e, 0xbd, 0x65, 0x77, 0xf4, 0x5e	/* t__pfx_trace_event_raw_event_task_newtask */
	.byte 0x0b, 0x74, 0x7d, 0x7b, 0xcc, 0xf4, 0x5e, 0xbd, 0x65, 0x77, 0xf4, 0x5e	/* ttrace_event_raw_event_task_newtask */
	.byte 0x0e, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0xf4, 0x5e, 0xbd, 0x65, 0x77, 0xf4, 0x5e	/* t__pfx_trace_raw_output_task_newtask */
	.byte 0x0e, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0xf4, 0x5e, 0xbd, 0x65, 0x77, 0xf4, 0x5e	/* ttrace_raw_output_task_newtask */
	.byte 0x0d, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0xf4, 0x5e, 0xde, 0x6e, 0x61, 0xa8	/* t__pfx_trace_raw_output_task_rename */
	.byte 0x0d, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0xf4, 0x5e, 0xde, 0x6e, 0x61, 0xa8	/* ttrace_raw_output_task_rename */
	.byte 0x0a, 0xef, 0x19, 0x3b, 0xc3, 0xf4, 0x5e, 0xde, 0x6e, 0x61, 0xa8	/* t__pfx_perf_trace_task_rename */
	.byte 0x0a, 0xce, 0xf5, 0x3b, 0xc3, 0xf4, 0x5e, 0xde, 0x6e, 0x61, 0xa8	/* tperf_trace_task_rename */
	.byte 0x0a, 0xef, 0x7d, 0x7b, 0xcc, 0xf4, 0x5e, 0xde, 0x6e, 0x61, 0xa8	/* t__pfx_trace_event_raw_event_task_rename */
	.byte 0x0a, 0x74, 0x7d, 0x7b, 0xcc, 0xf4, 0x5e, 0xde, 0x6e, 0x61, 0xa8	/* ttrace_event_raw_event_task_rename */
	.byte 0x0d, 0xef, 0x74, 0x68, 0xf7, 0xc8, 0xa9, 0xc6, 0xe6, 0xf7, 0xfc, 0x72, 0x63, 0x75	/* t__pfx_thread_stack_free_rcu */
	.byte 0x0d, 0x74, 0x74, 0x68, 0xf7, 0xc8, 0xa9, 0xc6, 0xe6, 0xf7, 0xfc, 0x72, 0x63, 0x75	/* tthread_stack_free_rcu */
	.byte 0x0c, 0xef, 0x66, 0xf7, 0xfc, 0x76, 0x6d, 0xa9, 0xc6, 0xf0, 0xf2, 0x68, 0x65	/* t__pfx_free_vm_stack_cache */
	.byte 0x0c, 0x74, 0x66, 0xf7, 0xfc, 0x76, 0x6d, 0xa9, 0xc6, 0xf0, 0xf2, 0x68, 0x65	/* tfree_vm_stack_cache */
	.byte 0x06, 0x99, 0xc1, 0x6d, 0x64, 0xe3, 0x70	/* T__pfx___mmdrop */
	.byte 0x06, 0xb9, 0x6d, 0x6d, 0x64, 0xe3, 0x70	/* T__mmdrop */
	.byte 0x0d, 0xef, 0x6d, 0x6d, 0x64, 0xe3, 0x70, 0x5f, 0x61, 0xe1, 0x6e, 0x63, 0xe6, 0x6e	/* t__pfx_mmdrop_async_fn */
	.byte 0x0d, 0x74, 0x6d, 0x6d, 0x64, 0xe3, 0x70, 0x5f, 0x61, 0xe1, 0x6e, 0x63, 0xe6, 0x6e	/* tmmdrop_async_fn */
	.byte 0x08, 0xef, 0x85, 0x67, 0x68, 0x05, 0xf0, 0x74, 0xd5	/* t__pfx_sighand_ctor */
	.byte 0x07, 0x93, 0x0c, 0x68, 0x05, 0xf0, 0x74, 0xd5	/* tsighand_ctor */
	.byte 0x10, 0xef, 0x63, 0xbe, 0x79, 0xf0, 0x6c, 0xe7, 0xfc, 0xc5, 0x67, 0xe9, 0x66, 0xe3, 0xae, 0xb1, 0xf5	/* t__pfx_copy_clone_args_from_user */
	.byte 0x0f, 0x26, 0xbe, 0x79, 0xf0, 0x6c, 0xe7, 0xfc, 0xc5, 0x67, 0xe9, 0x66, 0xe3, 0xae, 0xb1, 0xf5	/* tcopy_clone_args_from_user */
	.byte 0x0c, 0xef, 0x6d, 0x6d, 0xbf, 0xea, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__pfx_mm_init.constprop.0 */
	.byte 0x0c, 0x74, 0x6d, 0x6d, 0xbf, 0xea, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* tmm_init.constprop.0 */
	.byte 0x10, 0x74, 0xaf, 0xde, 0x66, 0x03, 0xe4, 0xfe, 0xc8, 0x64, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__pfx___refcount_add.constprop.0 */
	.byte 0x10, 0x74, 0xff, 0xf7, 0x66, 0x03, 0xe4, 0xfe, 0xc8, 0x64, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__refcount_add.constprop.0 */
	.byte 0x07, 0xef, 0x6d, 0x6d, 0xde, 0xc4, 0xbb, 0x65	/* t__pfx_mm_release */
	.byte 0x07, 0x74, 0x6d, 0x6d, 0xde, 0xc4, 0xbb, 0x65	/* tmm_release */
	.byte 0x08, 0xeb, 0x6d, 0xb6, 0x1e, 0x61, 0xe1, 0x6e, 0x63	/* T__pfx_mmput_async */
	.byte 0x08, 0x54, 0x6d, 0xb6, 0x1e, 0x61, 0xe1, 0x6e, 0x63	/* Tmmput_async */
	.byte 0x0e, 0xef, 0x76, 0xae, 0x61, 0xf7, 0x61, 0xe6, 0xf7, 0xfc, 0x72, 0x63, 0x75, 0xf0, 0x62	/* t__pfx_vm_area_free_rcu_cb */
	.byte 0x0e, 0x74, 0x76, 0xae, 0x61, 0xf7, 0x61, 0xe6, 0xf7, 0xfc, 0x72, 0x63, 0x75, 0xf0, 0x62	/* tvm_area_free_rcu_cb */
	.byte 0x04, 0xeb, 0x6d, 0xb6, 0x20	/* T__pfx_mmput */
	.byte 0x04, 0x54, 0x6d, 0xb6, 0x20	/* Tmmput */
	.byte 0x0a, 0xef, 0x6d, 0xb6, 0x1e, 0x61, 0xe1, 0x6e, 0x63, 0xe6, 0x6e	/* t__pfx_mmput_async_fn */
	.byte 0x0a, 0x74, 0x6d, 0xb6, 0x1e, 0x61, 0xe1, 0x6e, 0x63, 0xe6, 0x6e	/* tmmput_async_fn */
	.byte 0x09, 0xeb, 0x6e, 0x72, 0xec, 0xe3, 0x63, 0xd6, 0x73, 0xd6	/* T__pfx_nr_processes */
	.byte 0x09, 0x54, 0x6e, 0x72, 0xec, 0xe3, 0x63, 0xd6, 0x73, 0xd6	/* Tnr_processes */
	.byte 0x06, 0xeb, 0x66, 0xf7, 0xfc, 0xf4, 0x5e	/* T__pfx_free_task */
	.byte 0x06, 0x54, 0x66, 0xf7, 0xfc, 0xf4, 0x5e	/* Tfree_task */
	.byte 0x0a, 0x99, 0xec, 0x1e, 0xf4, 0x5e, 0xf6, 0xf3, 0x75, 0x63, 0x74	/* T__pfx___put_task_struct */
	.byte 0x0a, 0x54, 0xfd, 0x1e, 0xf4, 0x5e, 0xf6, 0xf3, 0x75, 0x63, 0x74	/* T__put_task_struct */
	.byte 0x0f, 0x99, 0xec, 0x1e, 0xf4, 0x5e, 0xf6, 0xf3, 0x75, 0x63, 0xfe, 0x72, 0x63, 0x75, 0xf0, 0x62	/* T__pfx___put_task_struct_rcu_cb */
	.byte 0x0f, 0x54, 0xfd, 0x1e, 0xf4, 0x5e, 0xf6, 0xf3, 0x75, 0x63, 0xfe, 0x72, 0x63, 0x75, 0xf0, 0x62	/* T__put_task_struct_rcu_cb */
	.byte 0x09, 0xeb, 0x76, 0xae, 0x61, 0xf7, 0x61, 0x5f, 0x22, 0x63	/* T__pfx_vm_area_alloc */
	.byte 0x09, 0x54, 0x76, 0xae, 0x61, 0xf7, 0x61, 0x5f, 0x22, 0x63	/* Tvm_area_alloc */
	.byte 0x08, 0xeb, 0x76, 0xae, 0x61, 0xf7, 0x61, 0xed, 0xcd	/* T__pfx_vm_area_dup */
	.byte 0x08, 0x54, 0x76, 0xae, 0x61, 0xf7, 0x61, 0xed, 0xcd	/* Tvm_area_dup */
	.byte 0x06, 0xef, 0x63, 0xbe, 0x79, 0xc1, 0x6d	/* t__pfx_copy_mm */
	.byte 0x05, 0x26, 0xbe, 0x79, 0xc1, 0x6d	/* tcopy_mm */
	.byte 0x09, 0x08, 0x76, 0xae, 0x61, 0xf7, 0x61, 0xe6, 0xf7, 0x65	/* T__pfx___vm_area_free */
	.byte 0x09, 0xb9, 0x76, 0xae, 0x61, 0xf7, 0x61, 0xe6, 0xf7, 0x65	/* T__vm_area_free */
	.byte 0x09, 0xeb, 0x76, 0xae, 0x61, 0xf7, 0x61, 0xe6, 0xf7, 0x65	/* T__pfx_vm_area_free */
	.byte 0x09, 0x54, 0x76, 0xae, 0x61, 0xf7, 0x61, 0xe6, 0xf7, 0x65	/* Tvm_area_free */
	.byte 0x0c, 0xeb, 0xcb, 0x9d, 0xf4, 0x5e, 0xa9, 0xc6, 0x5f, 0xf2, 0x03, 0xe4, 0x74	/* T__pfx_exit_task_stack_account */
	.byte 0x0c, 0x54, 0xcb, 0x9d, 0xf4, 0x5e, 0xa9, 0xc6, 0x5f, 0xf2, 0x03, 0xe4, 0x74	/* Texit_task_stack_account */
	.byte 0x07, 0xeb, 0x9c, 0xfe, 0xf4, 0x5e, 0xa9, 0xc6	/* T__pfx_put_task_stack */
	.byte 0x07, 0x54, 0x9c, 0xfe, 0xf4, 0x5e, 0xa9, 0xc6	/* Tput_task_stack */
	.byte 0x0c, 0xeb, 0x73, 0xe2, 0xf4, 0x5e, 0xa9, 0xc6, 0x0d, 0xda, 0xd9, 0x67, 0xaa	/* T__pfx_set_task_stack_end_magic */
	.byte 0x0c, 0x54, 0x73, 0xe2, 0xf4, 0x5e, 0xa9, 0xc6, 0x0d, 0xda, 0xd9, 0x67, 0xaa	/* Tset_task_stack_end_magic */
	.byte 0x05, 0xeb, 0x6d, 0xae, 0x22, 0x63	/* T__pfx_mm_alloc */
	.byte 0x05, 0x54, 0x6d, 0xae, 0x22, 0x63	/* Tmm_alloc */
	.byte 0x09, 0xeb, 0x73, 0xe2, 0x6d, 0xae, 0xcb, 0xfc, 0xa5, 0xc4	/* T__pfx_set_mm_exe_file */
	.byte 0x09, 0x54, 0x73, 0xe2, 0x6d, 0xae, 0xcb, 0xfc, 0xa5, 0xc4	/* Tset_mm_exe_file */
	.byte 0x0c, 0xeb, 0xf7, 0x70, 0x6c, 0xf2, 0xfc, 0x6d, 0xae, 0xcb, 0xfc, 0xa5, 0xc4	/* T__pfx_replace_mm_exe_file */
	.byte 0x0c, 0x54, 0xf7, 0x70, 0x6c, 0xf2, 0xfc, 0x6d, 0xae, 0xcb, 0xfc, 0xa5, 0xc4	/* Treplace_mm_exe_file */
	.byte 0x09, 0xeb, 0x67, 0xe2, 0x6d, 0xae, 0xcb, 0xfc, 0xa5, 0xc4	/* T__pfx_get_mm_exe_file */
	.byte 0x09, 0x54, 0x67, 0xe2, 0x6d, 0xae, 0xcb, 0xfc, 0xa5, 0xc4	/* Tget_mm_exe_file */
	.byte 0x0a, 0xeb, 0x67, 0xe2, 0xf4, 0x5e, 0x5f, 0xcb, 0xfc, 0xa5, 0xc4	/* T__pfx_get_task_exe_file */
	.byte 0x0a, 0x54, 0x67, 0xe2, 0xf4, 0x5e, 0x5f, 0xcb, 0xfc, 0xa5, 0xc4	/* Tget_task_exe_file */
	.byte 0x07, 0xeb, 0x6d, 0xae, 0xf2, 0x63, 0xd6, 0x73	/* T__pfx_mm_access */
	.byte 0x07, 0x54, 0x6d, 0xae, 0xf2, 0x63, 0xd6, 0x73	/* Tmm_access */
	.byte 0x09, 0xeb, 0xcb, 0x9d, 0x6d, 0x6d, 0xde, 0xc4, 0xbb, 0x65	/* T__pfx_exit_mm_release */
	.byte 0x09, 0x54, 0xcb, 0x9d, 0x6d, 0x6d, 0xde, 0xc4, 0xbb, 0x65	/* Texit_mm_release */
	.byte 0x0a, 0xeb, 0xcb, 0x65, 0xc9, 0x6d, 0x6d, 0xde, 0xc4, 0xbb, 0x65	/* T__pfx_exec_mm_release */
	.byte 0x0a, 0x54, 0xcb, 0x65, 0xc9, 0x6d, 0x6d, 0xde, 0xc4, 0xbb, 0x65	/* Texec_mm_release */
	.byte 0x09, 0x99, 0xf0, 0xc4, 0xd2, 0xcd, 0xf6, 0x0c, 0x68, 0x05	/* T__pfx___cleanup_sighand */
	.byte 0x09, 0xb9, 0x63, 0xc4, 0xd2, 0xcd, 0xf6, 0x0c, 0x68, 0x05	/* T__cleanup_sighand */
	.byte 0x0d, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0x84, 0xdc, 0xda, 0xc8, 0x64, 0x29, 0x73	/* T__pfx___x64_sys_set_tid_address */
	.byte 0x0d, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0x84, 0xdc, 0xda, 0xc8, 0x64, 0x29, 0x73	/* T__x64_sys_set_tid_address */
	.byte 0x0e, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0x84, 0xdc, 0xda, 0xc8, 0x64, 0x29, 0x73	/* T__pfx___ia32_sys_set_tid_address */
	.byte 0x0e, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0x84, 0xdc, 0xda, 0xc8, 0x64, 0x29, 0x73	/* T__ia32_sys_set_tid_address */
	.byte 0x0a, 0xeb, 0xb2, 0x64, 0x66, 0x64, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* T__pfx_pidfd_prepare */
	.byte 0x0a, 0x54, 0xb2, 0x64, 0x66, 0x64, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* Tpidfd_prepare */
	.byte 0x09, 0xeb, 0x63, 0xbe, 0x79, 0xec, 0xe3, 0x63, 0xd6, 0x73	/* T__pfx_copy_process */
	.byte 0x09, 0x54, 0x63, 0xbe, 0x79, 0xec, 0xe3, 0x63, 0xd6, 0x73	/* Tcopy_process */
	.byte 0x09, 0xeb, 0x63, 0xf7, 0x91, 0xc0, 0xa7, 0x68, 0xf7, 0xc8	/* T__pfx_create_io_thread */
	.byte 0x09, 0x54, 0x63, 0xf7, 0x91, 0xc0, 0xa7, 0x68, 0xf7, 0xc8	/* Tcreate_io_thread */
	.byte 0x09, 0xeb, 0x6b, 0xf5, 0x6e, 0xdb, 0xf0, 0x6c, 0xe7, 0x65	/* T__pfx_kernel_clone */
	.byte 0x09, 0x54, 0x6b, 0xf5, 0x6e, 0xdb, 0xf0, 0x6c, 0xe7, 0x65	/* Tkernel_clone */
	.byte 0x0a, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0x73, 0xf0, 0x6c, 0xe7, 0x65	/* t__pfx___do_sys_clone */
	.byte 0x0a, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0x73, 0xf0, 0x6c, 0xe7, 0x65	/* t__do_sys_clone */
	.byte 0x0b, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0x73, 0xf0, 0x6c, 0xe7, 0x65, 0x33	/* t__pfx___do_sys_clone3 */
	.byte 0x0b, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0x73, 0xf0, 0x6c, 0xe7, 0x65, 0x33	/* t__do_sys_clone3 */
	.byte 0x09, 0xeb, 0x6b, 0xf5, 0x6e, 0xdb, 0xa7, 0x68, 0xf7, 0xc8	/* T__pfx_kernel_thread */
	.byte 0x09, 0x54, 0x6b, 0xf5, 0x6e, 0xdb, 0xa7, 0x68, 0xf7, 0xc8	/* Tkernel_thread */
	.byte 0x09, 0xeb, 0xb1, 0xf5, 0xc1, 0x16, 0x74, 0x68, 0xf7, 0xc8	/* T__pfx_user_mode_thread */
	.byte 0x09, 0x54, 0xb1, 0xf5, 0xc1, 0x16, 0x74, 0x68, 0xf7, 0xc8	/* Tuser_mode_thread */
	.byte 0x09, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0xe9, 0x66, 0xd5, 0x6b	/* t__pfx___do_sys_fork */
	.byte 0x0a, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x66, 0xd5, 0x6b	/* T__pfx___ia32_sys_fork */
	.byte 0x09, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x66, 0xd5, 0x6b	/* T__pfx___x64_sys_fork */
	.byte 0x09, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0xe9, 0x66, 0xd5, 0x6b	/* t__do_sys_fork */
	.byte 0x0a, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x66, 0xd5, 0x6b	/* T__ia32_sys_fork */
	.byte 0x09, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x66, 0xd5, 0x6b	/* T__x64_sys_fork */
	.byte 0x0a, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0xe9, 0x76, 0x66, 0xd5, 0x6b	/* t__pfx___do_sys_vfork */
	.byte 0x0b, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x76, 0x66, 0xd5, 0x6b	/* T__pfx___ia32_sys_vfork */
	.byte 0x0a, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x76, 0x66, 0xd5, 0x6b	/* T__pfx___x64_sys_vfork */
	.byte 0x0a, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0xe9, 0x76, 0x66, 0xd5, 0x6b	/* t__do_sys_vfork */
	.byte 0x0b, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x76, 0x66, 0xd5, 0x6b	/* T__ia32_sys_vfork */
	.byte 0x0a, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x76, 0x66, 0xd5, 0x6b	/* T__x64_sys_vfork */
	.byte 0x0a, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf0, 0x6c, 0xe7, 0x65	/* T__pfx___x64_sys_clone */
	.byte 0x0a, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf0, 0x6c, 0xe7, 0x65	/* T__x64_sys_clone */
	.byte 0x0b, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf0, 0x6c, 0xe7, 0x65	/* T__pfx___ia32_sys_clone */
	.byte 0x0b, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf0, 0x6c, 0xe7, 0x65	/* T__ia32_sys_clone */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf0, 0x6c, 0xe7, 0x65, 0x33	/* T__pfx___x64_sys_clone3 */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf0, 0x6c, 0xe7, 0x65, 0x33	/* T__x64_sys_clone3 */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf0, 0x6c, 0xe7, 0x65, 0x33	/* T__pfx___ia32_sys_clone3 */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf0, 0x6c, 0xe7, 0x65, 0x33	/* T__ia32_sys_clone3 */
	.byte 0x0c, 0xeb, 0x77, 0xe5, 0x6b, 0xec, 0xe3, 0x63, 0xd6, 0xe9, 0x74, 0xf7, 0x65	/* T__pfx_walk_process_tree */
	.byte 0x0c, 0x54, 0x77, 0xe5, 0x6b, 0xec, 0xe3, 0x63, 0xd6, 0xe9, 0x74, 0xf7, 0x65	/* Twalk_process_tree */
	.byte 0x09, 0xeb, 0x6b, 0xe1, 0xe9, 0xe4, 0x73, 0x68, 0x61, 0xf7	/* T__pfx_ksys_unshare */
	.byte 0x09, 0x54, 0x6b, 0xe1, 0xe9, 0xe4, 0x73, 0x68, 0x61, 0xf7	/* Tksys_unshare */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xe4, 0x73, 0x68, 0x61, 0xf7	/* T__pfx___x64_sys_unshare */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xe4, 0x73, 0x68, 0x61, 0xf7	/* T__x64_sys_unshare */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xe4, 0x73, 0x68, 0x61, 0xf7	/* T__pfx___ia32_sys_unshare */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xe4, 0x73, 0x68, 0x61, 0xf7	/* T__ia32_sys_unshare */
	.byte 0x09, 0xeb, 0xe4, 0x73, 0x68, 0xc5, 0xfc, 0xa5, 0x6c, 0xd6	/* T__pfx_unshare_files */
	.byte 0x09, 0x54, 0xe4, 0x73, 0x68, 0xc5, 0xfc, 0xa5, 0x6c, 0xd6	/* Tunshare_files */
	.byte 0x0d, 0xeb, 0xe1, 0x73, 0x63, 0x23, 0x5f, 0xd9, 0x78, 0xa7, 0x68, 0xf7, 0xc8, 0x73	/* T__pfx_sysctl_max_threads */
	.byte 0x0d, 0x54, 0xe1, 0x73, 0x63, 0x23, 0x5f, 0xd9, 0x78, 0xa7, 0x68, 0xf7, 0xc8, 0x73	/* Tsysctl_max_threads */
	.byte 0x0d, 0xef, 0xcb, 0xb4, 0x64, 0x6f, 0xd9, 0xf8, 0x73, 0xec, 0xe3, 0x63, 0xf6, 0x7c	/* t__pfx_execdomains_proc_show */
	.byte 0x0d, 0x74, 0xcb, 0xb4, 0x64, 0x6f, 0xd9, 0xf8, 0x73, 0xec, 0xe3, 0x63, 0xf6, 0x7c	/* texecdomains_proc_show */
	.byte 0x0d, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0xf5, 0x73, 0xe7, 0xe5, 0xea, 0x79	/* T__pfx___x64_sys_personality */
	.byte 0x0d, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0xf5, 0x73, 0xe7, 0xe5, 0xea, 0x79	/* T__x64_sys_personality */
	.byte 0x0e, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0xf5, 0x73, 0xe7, 0xe5, 0xea, 0x79	/* T__pfx___ia32_sys_personality */
	.byte 0x0e, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0xf5, 0x73, 0xe7, 0xe5, 0xea, 0x79	/* T__ia32_sys_personality */
	.byte 0x05, 0xef, 0x6e, 0x6f, 0xb8, 0x01	/* t__pfx_no_blink */
	.byte 0x05, 0x74, 0x6e, 0x6f, 0xb8, 0x01	/* tno_blink */
	.byte 0x09, 0xef, 0x77, 0xc5, 0x6e, 0x3a, 0xe4, 0xfe, 0x73, 0x7c	/* t__pfx_warn_count_show */
	.byte 0x09, 0x74, 0x77, 0xc5, 0x6e, 0x3a, 0xe4, 0xfe, 0x73, 0x7c	/* twarn_count_show */
	.byte 0x06, 0xeb, 0x74, 0xd6, 0xfe, 0xf4, 0xb3	/* T__pfx_test_taint */
	.byte 0x06, 0x54, 0x74, 0xd6, 0xfe, 0xf4, 0xb3	/* Ttest_taint */
	.byte 0x08, 0x99, 0x92, 0xc5, 0x6e, 0xec, 0x72, 0xb3, 0x6b	/* T__pfx___warn_printk */
	.byte 0x08, 0xb9, 0x77, 0xc5, 0x6e, 0xec, 0x72, 0xb3, 0x6b	/* T__warn_printk */
	.byte 0x10, 0xef, 0x63, 0xc4, 0xc5, 0x92, 0xc5, 0x6e, 0x5f, 0xe7, 0x63, 0xfc, 0x66, 0xbe, 0xe9, 0xbe, 0xf1	/* t__pfx_clear_warn_once_fops_open */
	.byte 0x0f, 0x26, 0xc4, 0xc5, 0x92, 0xc5, 0x6e, 0x5f, 0xe7, 0x63, 0xfc, 0x66, 0xbe, 0xe9, 0xbe, 0xf1	/* tclear_warn_once_fops_open */
	.byte 0x0d, 0xef, 0x63, 0xc4, 0xc5, 0x92, 0xc5, 0x6e, 0x5f, 0xe7, 0x63, 0xfc, 0x73, 0xd4	/* t__pfx_clear_warn_once_set */
	.byte 0x0c, 0x26, 0xc4, 0xc5, 0x92, 0xc5, 0x6e, 0x5f, 0xe7, 0x63, 0xfc, 0x73, 0xd4	/* tclear_warn_once_set */
	.byte 0x11, 0xef, 0x64, 0x6f, 0x5f, 0x6f, 0xbe, 0xe9, 0xf1, 0xa2, 0x5f, 0xcb, 0xea, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__pfx_do_oops_enter_exit.part.0 */
	.byte 0x11, 0x74, 0x64, 0x6f, 0x5f, 0x6f, 0xbe, 0xe9, 0xf1, 0xa2, 0x5f, 0xcb, 0xea, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* tdo_oops_enter_exit.part.0 */
	.byte 0x11, 0xef, 0x70, 0xd2, 0xaa, 0xec, 0x72, 0x27, 0xe1, 0xe9, 0xf8, 0x66, 0x6f, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__pfx_panic_print_sys_info.part.0 */
	.byte 0x10, 0xce, 0xd2, 0xaa, 0xec, 0x72, 0x27, 0xe1, 0xe9, 0xf8, 0x66, 0x6f, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* tpanic_print_sys_info.part.0 */
	.byte 0x08, 0x74, 0xfa, 0xfd, 0x72, 0x27, 0xf4, 0xb3, 0x9e	/* t__pfx__print_tainted */
	.byte 0x07, 0xfe, 0x70, 0x72, 0x27, 0xf4, 0xb3, 0x9e	/* t_print_tainted */
	.byte 0x0d, 0x57, 0xf9, 0x70, 0xd2, 0xaa, 0xf6, 0xb6, 0xf6, 0xdb, 0x66, 0xf6, 0x74, 0xbe	/* W__pfx_panic_smp_self_stop */
	.byte 0x0c, 0x57, 0x70, 0xd2, 0xaa, 0xf6, 0xb6, 0xf6, 0xdb, 0x66, 0xf6, 0x74, 0xbe	/* Wpanic_smp_self_stop */
	.byte 0x04, 0xeb, 0x70, 0xd2, 0xaa	/* T__pfx_panic */
	.byte 0x04, 0x54, 0x70, 0xd2, 0xaa	/* Tpanic */
	.byte 0x07, 0xeb, 0x6e, 0x6d, 0x69, 0xec, 0xd2, 0xaa	/* T__pfx_nmi_panic */
	.byte 0x07, 0x54, 0x6e, 0x6d, 0x69, 0xec, 0xd2, 0xaa	/* Tnmi_panic */
	.byte 0x05, 0xeb, 0xc8, 0xda, 0xf4, 0xb3	/* T__pfx_add_taint */
	.byte 0x05, 0x54, 0xc8, 0xda, 0xf4, 0xb3	/* Tadd_taint */
	.byte 0x0c, 0xeb, 0xba, 0x65, 0xc6, 0xec, 0xd2, 0x69, 0xc9, 0xe7, 0x92, 0xc5, 0x6e	/* T__pfx_check_panic_on_warn */
	.byte 0x0c, 0x54, 0xba, 0x65, 0xc6, 0xec, 0xd2, 0x69, 0xc9, 0xe7, 0x92, 0xc5, 0x6e	/* Tcheck_panic_on_warn */
	.byte 0x07, 0xeb, 0x70, 0x72, 0x27, 0xf4, 0xb3, 0x9e	/* T__pfx_print_tainted */
	.byte 0x07, 0x54, 0x70, 0x72, 0x27, 0xf4, 0xb3, 0x9e	/* Tprint_tainted */
	.byte 0x0d, 0xeb, 0x70, 0x72, 0x27, 0xf4, 0xb3, 0x65, 0xda, 0x0b, 0x62, 0x6f, 0x73, 0x65	/* T__pfx_print_tainted_verbose */
	.byte 0x0d, 0x54, 0x70, 0x72, 0x27, 0xf4, 0xb3, 0x65, 0xda, 0x0b, 0x62, 0x6f, 0x73, 0x65	/* Tprint_tainted_verbose */
	.byte 0x05, 0xeb, 0x67, 0xe2, 0xf4, 0xb3	/* T__pfx_get_taint */
	.byte 0x05, 0x54, 0x67, 0xe2, 0xf4, 0xb3	/* Tget_taint */
	.byte 0x09, 0xeb, 0x6f, 0xbe, 0xe9, 0xd9, 0x79, 0xec, 0x72, 0xb3	/* T__pfx_oops_may_print */
	.byte 0x09, 0x54, 0x6f, 0xbe, 0xe9, 0xd9, 0x79, 0xec, 0x72, 0xb3	/* Toops_may_print */
	.byte 0x06, 0xeb, 0x6f, 0xbe, 0xe9, 0xf1, 0xa2	/* T__pfx_oops_enter */
	.byte 0x06, 0x54, 0x6f, 0xbe, 0xe9, 0xf1, 0xa2	/* Toops_enter */
	.byte 0x06, 0xeb, 0x6f, 0xbe, 0xe9, 0xcb, 0xea	/* T__pfx_oops_exit */
	.byte 0x06, 0x54, 0x6f, 0xbe, 0xe9, 0xcb, 0xea	/* Toops_exit */
	.byte 0x04, 0x99, 0x92, 0xc5, 0x6e	/* T__pfx___warn */
	.byte 0x04, 0xb9, 0x77, 0xc5, 0x6e	/* T__warn */
	.byte 0x08, 0x08, 0x18, 0xf0, 0x9c, 0x68, 0x70, 0x0d, 0xa2	/* T__pfx___traceiter_cpuhp_enter */
	.byte 0x08, 0xb9, 0x18, 0xf0, 0x9c, 0x68, 0x70, 0x0d, 0xa2	/* T__traceiter_cpuhp_enter */
	.byte 0x09, 0x99, 0xec, 0x10, 0xf0, 0x9c, 0x68, 0x70, 0x0d, 0xa2	/* T__pfx___probestub_cpuhp_enter */
	.byte 0x09, 0x54, 0xfd, 0x10, 0xf0, 0x9c, 0x68, 0x70, 0x0d, 0xa2	/* T__probestub_cpuhp_enter */
	.byte 0x0b, 0x08, 0x18, 0xf0, 0x9c, 0x68, 0x70, 0xc1, 0x02, 0xdc, 0x0d, 0xa2	/* T__pfx___traceiter_cpuhp_multi_enter */
	.byte 0x0b, 0xb9, 0x18, 0xf0, 0x9c, 0x68, 0x70, 0xc1, 0x02, 0xdc, 0x0d, 0xa2	/* T__traceiter_cpuhp_multi_enter */
	.byte 0x0c, 0x99, 0xec, 0x10, 0xf0, 0x9c, 0x68, 0x70, 0xc1, 0x02, 0xdc, 0x0d, 0xa2	/* T__pfx___probestub_cpuhp_multi_enter */
	.byte 0x0c, 0x54, 0xfd, 0x10, 0xf0, 0x9c, 0x68, 0x70, 0xc1, 0x02, 0xdc, 0x0d, 0xa2	/* T__probestub_cpuhp_multi_enter */
	.byte 0x09, 0x08, 0x18, 0xf0, 0x9c, 0x68, 0x70, 0x5f, 0xcb, 0xea	/* T__pfx___traceiter_cpuhp_exit */
	.byte 0x09, 0xb9, 0x18, 0xf0, 0x9c, 0x68, 0x70, 0x5f, 0xcb, 0xea	/* T__traceiter_cpuhp_exit */
	.byte 0x0a, 0x99, 0xec, 0x10, 0xf0, 0x9c, 0x68, 0x70, 0x5f, 0xcb, 0xea	/* T__pfx___probestub_cpuhp_exit */
	.byte 0x0a, 0x54, 0xfd, 0x10, 0xf0, 0x9c, 0x68, 0x70, 0x5f, 0xcb, 0xea	/* T__probestub_cpuhp_exit */
	.byte 0x0c, 0xeb, 0x63, 0x9c, 0xf6, 0x6d, 0xfe, 0x70, 0x6f, 0x73, 0x85, 0x62, 0xc4	/* T__pfx_cpu_smt_possible */
	.byte 0x0c, 0x54, 0x63, 0x9c, 0xf6, 0x6d, 0xfe, 0x70, 0x6f, 0x73, 0x85, 0x62, 0xc4	/* Tcpu_smt_possible */
	.byte 0x0a, 0xef, 0x63, 0x9c, 0x68, 0x70, 0xbd, 0xcb, 0xfe, 0x3d, 0x2c	/* t__pfx_cpuhp_next_state */
	.byte 0x09, 0x26, 0x9c, 0x68, 0x70, 0xbd, 0xcb, 0xfe, 0x3d, 0x2c	/* tcpuhp_next_state */
	.byte 0x0c, 0xef, 0x63, 0x9c, 0x68, 0x70, 0xf6, 0x68, 0x6f, 0x02, 0xda, 0x72, 0xe4	/* t__pfx_cpuhp_should_run */
	.byte 0x0b, 0x26, 0x9c, 0x68, 0x70, 0xf6, 0x68, 0x6f, 0x02, 0xda, 0x72, 0xe4	/* tcpuhp_should_run */
	.byte 0x0d, 0xeb, 0x63, 0x9c, 0xc1, 0xea, 0x0c, 0xe8, 0x69, 0xe7, 0xe9, 0x6f, 0x66, 0x66	/* T__pfx_cpu_mitigations_off */
	.byte 0x0d, 0x54, 0x63, 0x9c, 0xc1, 0xea, 0x0c, 0xe8, 0x69, 0xe7, 0xe9, 0x6f, 0x66, 0x66	/* Tcpu_mitigations_off */
	.byte 0x12, 0xeb, 0x63, 0x9c, 0xc1, 0xea, 0x0c, 0xe8, 0x69, 0xe7, 0xe9, 0x61, 0x75, 0x8a, 0xbd, 0x6f, 0x73, 0x6d, 0x74	/* T__pfx_cpu_mitigations_auto_nosmt */
	.byte 0x12, 0x54, 0x63, 0x9c, 0xc1, 0xea, 0x0c, 0xe8, 0x69, 0xe7, 0xe9, 0x61, 0x75, 0x8a, 0xbd, 0x6f, 0x73, 0x6d, 0x74	/* Tcpu_mitigations_auto_nosmt */
	.byte 0x0a, 0xef, 0x19, 0x3b, 0xc3, 0x63, 0x9c, 0x68, 0x70, 0x0d, 0xa2	/* t__pfx_perf_trace_cpuhp_enter */
	.byte 0x0a, 0xce, 0xf5, 0x3b, 0xc3, 0x63, 0x9c, 0x68, 0x70, 0x0d, 0xa2	/* tperf_trace_cpuhp_enter */
	.byte 0x0b, 0xef, 0x19, 0x3b, 0xc3, 0x63, 0x9c, 0x68, 0x70, 0x5f, 0xcb, 0xea	/* t__pfx_perf_trace_cpuhp_exit */
	.byte 0x0b, 0xce, 0xf5, 0x3b, 0xc3, 0x63, 0x9c, 0x68, 0x70, 0x5f, 0xcb, 0xea	/* tperf_trace_cpuhp_exit */
	.byte 0x0a, 0xef, 0x7d, 0x7b, 0xcc, 0x63, 0x9c, 0x68, 0x70, 0x0d, 0xa2	/* t__pfx_trace_event_raw_event_cpuhp_enter */
	.byte 0x0a, 0x74, 0x7d, 0x7b, 0xcc, 0x63, 0x9c, 0x68, 0x70, 0x0d, 0xa2	/* ttrace_event_raw_event_cpuhp_enter */
	.byte 0x0b, 0xef, 0x7d, 0x7b, 0xcc, 0x63, 0x9c, 0x68, 0x70, 0x5f, 0xcb, 0xea	/* t__pfx_trace_event_raw_event_cpuhp_exit */
	.byte 0x0b, 0x74, 0x7d, 0x7b, 0xcc, 0x63, 0x9c, 0x68, 0x70, 0x5f, 0xcb, 0xea	/* ttrace_event_raw_event_cpuhp_exit */
	.byte 0x0d, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x63, 0x9c, 0x68, 0x70, 0x0d, 0xa2	/* t__pfx_trace_raw_output_cpuhp_enter */
	.byte 0x0d, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x63, 0x9c, 0x68, 0x70, 0x0d, 0xa2	/* ttrace_raw_output_cpuhp_enter */
	.byte 0x10, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x63, 0x9c, 0x68, 0x70, 0xc1, 0x02, 0xdc, 0x0d, 0xa2	/* t__pfx_trace_raw_output_cpuhp_multi_enter */
	.byte 0x10, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x63, 0x9c, 0x68, 0x70, 0xc1, 0x02, 0xdc, 0x0d, 0xa2	/* ttrace_raw_output_cpuhp_multi_enter */
	.byte 0x0e, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x63, 0x9c, 0x68, 0x70, 0x5f, 0xcb, 0xea	/* t__pfx_trace_raw_output_cpuhp_exit */
	.byte 0x0e, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x63, 0x9c, 0x68, 0x70, 0x5f, 0xcb, 0xea	/* ttrace_raw_output_cpuhp_exit */
	.byte 0x07, 0xef, 0x66, 0xf8, 0xca, 0x68, 0xf0, 0x9c	/* t__pfx_finish_cpu */
	.byte 0x07, 0x74, 0x66, 0xf8, 0xca, 0x68, 0xf0, 0x9c	/* tfinish_cpu */
	.byte 0x11, 0xef, 0x63, 0x9c, 0x68, 0x70, 0x5f, 0x6b, 0x69, 0xc6, 0x5f, 0x61, 0x70, 0x5f, 0xe5, 0x69, 0x76, 0x65	/* t__pfx_cpuhp_kick_ap_alive */
	.byte 0x10, 0x26, 0x9c, 0x68, 0x70, 0x5f, 0x6b, 0x69, 0xc6, 0x5f, 0x61, 0x70, 0x5f, 0xe5, 0x69, 0x76, 0x65	/* tcpuhp_kick_ap_alive */
	.byte 0x0f, 0xef, 0x63, 0x9c, 0x68, 0x70, 0x3a, 0xb6, 0x6c, 0xd4, 0xfc, 0x9f, 0xb0, 0x64, 0x65, 0xc8	/* t__pfx_cpuhp_complete_idle_dead */
	.byte 0x0e, 0x26, 0x9c, 0x68, 0x70, 0x3a, 0xb6, 0x6c, 0xd4, 0xfc, 0x9f, 0xb0, 0x64, 0x65, 0xc8	/* tcpuhp_complete_idle_dead */
	.byte 0x0d, 0xeb, 0x63, 0x9c, 0xa3, 0x6f, 0xce, 0x6c, 0x75, 0x67, 0xed, 0xca, 0x90, 0xc4	/* T__pfx_cpu_hotplug_disable */
	.byte 0x0d, 0x54, 0x63, 0x9c, 0xa3, 0x6f, 0xce, 0x6c, 0x75, 0x67, 0xed, 0xca, 0x90, 0xc4	/* Tcpu_hotplug_disable */
	.byte 0x0d, 0x74, 0xaf, 0xf0, 0x9c, 0xa3, 0x6f, 0xce, 0x6c, 0x75, 0x67, 0x0d, 0x90, 0xc4	/* t__pfx___cpu_hotplug_enable */
	.byte 0x0d, 0x74, 0xff, 0x63, 0x9c, 0xa3, 0x6f, 0xce, 0x6c, 0x75, 0x67, 0x0d, 0x90, 0xc4	/* t__cpu_hotplug_enable */
	.byte 0x0c, 0xeb, 0x63, 0x9c, 0xa3, 0x6f, 0xce, 0x6c, 0x75, 0x67, 0x0d, 0x90, 0xc4	/* T__pfx_cpu_hotplug_enable */
	.byte 0x0c, 0x54, 0x63, 0x9c, 0xa3, 0x6f, 0xce, 0x6c, 0x75, 0x67, 0x0d, 0x90, 0xc4	/* Tcpu_hotplug_enable */
	.byte 0x0b, 0xef, 0x63, 0x9c, 0xed, 0xad, 0x6e, 0x5f, 0x97, 0xe9, 0xa4, 0x9e	/* t__pfx_cpu_down_maps_locked */
	.byte 0x0a, 0x26, 0x9c, 0xed, 0xad, 0x6e, 0x5f, 0x97, 0xe9, 0xa4, 0x9e	/* tcpu_down_maps_locked */
	.byte 0x06, 0xeb, 0xf7, 0x17, 0x1a, 0x63, 0x9c	/* T__pfx_remove_cpu */
	.byte 0x06, 0x54, 0xf7, 0x17, 0x1a, 0x63, 0x9c	/* Tremove_cpu */
	.byte 0x05, 0xeb, 0xc8, 0x64, 0xf0, 0x9c	/* T__pfx_add_cpu */
	.byte 0x05, 0x54, 0xc8, 0x64, 0xf0, 0x9c	/* Tadd_cpu */
	.byte 0x08, 0xef, 0x66, 0x61, 0x69, 0x6c, 0xf6, 0x8a, 0xf7	/* t__pfx_fail_store */
	.byte 0x08, 0x74, 0x66, 0x61, 0x69, 0x6c, 0xf6, 0x8a, 0xf7	/* tfail_store */
	.byte 0x07, 0xef, 0x66, 0x61, 0x69, 0x6c, 0xf6, 0x7c	/* t__pfx_fail_show */
	.byte 0x07, 0x74, 0x66, 0x61, 0x69, 0x6c, 0xf6, 0x7c	/* tfail_show */
	.byte 0x07, 0xef, 0xf4, 0x72, 0x67, 0xe2, 0x73, 0x7c	/* t__pfx_target_show */
	.byte 0x07, 0x74, 0xf4, 0x72, 0x67, 0xe2, 0x73, 0x7c	/* ttarget_show */
	.byte 0x06, 0xef, 0x3d, 0x74, 0xfc, 0x73, 0x7c	/* t__pfx_state_show */
	.byte 0x06, 0x93, 0xf4, 0x74, 0xfc, 0x73, 0x7c	/* tstate_show */
	.byte 0x06, 0xef, 0x3d, 0x74, 0xd6, 0xf6, 0x7c	/* t__pfx_states_show */
	.byte 0x06, 0x93, 0xf4, 0x74, 0xd6, 0xf6, 0x7c	/* tstates_show */
	.byte 0x06, 0xef, 0xf2, 0xdc, 0x1a, 0x73, 0x7c	/* t__pfx_active_show */
	.byte 0x06, 0xf4, 0x63, 0xdc, 0x1a, 0x73, 0x7c	/* tactive_show */
	.byte 0x06, 0xef, 0x40, 0xf3, 0xa0, 0xf6, 0x7c	/* t__pfx_control_show */
	.byte 0x06, 0x74, 0x40, 0xf3, 0xa0, 0xf6, 0x7c	/* tcontrol_show */
	.byte 0x0d, 0xef, 0x19, 0x3b, 0xc3, 0x63, 0x9c, 0x68, 0x70, 0xc1, 0x02, 0xdc, 0x0d, 0xa2	/* t__pfx_perf_trace_cpuhp_multi_enter */
	.byte 0x0d, 0xce, 0xf5, 0x3b, 0xc3, 0x63, 0x9c, 0x68, 0x70, 0xc1, 0x02, 0xdc, 0x0d, 0xa2	/* tperf_trace_cpuhp_multi_enter */
	.byte 0x0d, 0xef, 0x7d, 0x7b, 0xcc, 0x63, 0x9c, 0x68, 0x70, 0xc1, 0x02, 0xdc, 0x0d, 0xa2	/* t__pfx_trace_event_raw_event_cpuhp_multi_enter */
	.byte 0x0d, 0x74, 0x7d, 0x7b, 0xcc, 0x63, 0x9c, 0x68, 0x70, 0xc1, 0x02, 0xdc, 0x0d, 0xa2	/* ttrace_event_raw_event_cpuhp_multi_enter */
	.byte 0x0a, 0xeb, 0x63, 0x9c, 0xe9, 0xf7, 0x61, 0xda, 0xf3, 0x79, 0xa4	/* T__pfx_cpus_read_trylock */
	.byte 0x0a, 0x54, 0x63, 0x9c, 0xe9, 0xf7, 0x61, 0xda, 0xf3, 0x79, 0xa4	/* Tcpus_read_trylock */
	.byte 0x10, 0xef, 0x63, 0x9c, 0xa3, 0x6f, 0xce, 0x6c, 0x75, 0x67, 0xec, 0x6d, 0xf0, 0x5d, 0x62, 0xf2, 0x6b	/* t__pfx_cpu_hotplug_pm_callback */
	.byte 0x0f, 0x26, 0x9c, 0xa3, 0x6f, 0xce, 0x6c, 0x75, 0x67, 0xec, 0x6d, 0xf0, 0x5d, 0x62, 0xf2, 0x6b	/* tcpu_hotplug_pm_callback */
	.byte 0x08, 0xeb, 0x63, 0x9c, 0xe9, 0xf7, 0x61, 0xda, 0xa4	/* T__pfx_cpus_read_lock */
	.byte 0x08, 0x54, 0x63, 0x9c, 0xe9, 0xf7, 0x61, 0xda, 0xa4	/* Tcpus_read_lock */
	.byte 0x09, 0xeb, 0x63, 0x9c, 0xe9, 0xf7, 0x61, 0xda, 0xe4, 0xa4	/* T__pfx_cpus_read_unlock */
	.byte 0x09, 0x54, 0x63, 0x9c, 0xe9, 0xf7, 0x61, 0xda, 0xe4, 0xa4	/* Tcpus_read_unlock */
	.byte 0x0f, 0xef, 0x63, 0x9c, 0x68, 0x70, 0x5f, 0x6b, 0x69, 0xc6, 0x5f, 0x61, 0x70, 0x92, 0xd5, 0x6b	/* t__pfx_cpuhp_kick_ap_work */
	.byte 0x0e, 0x26, 0x9c, 0x68, 0x70, 0x5f, 0x6b, 0x69, 0xc6, 0x5f, 0x61, 0x70, 0x92, 0xd5, 0x6b	/* tcpuhp_kick_ap_work */
	.byte 0x0f, 0xef, 0x63, 0x9c, 0x68, 0x70, 0xbf, 0x76, 0x6f, 0x6b, 0xfc, 0x63, 0x5d, 0x62, 0xf2, 0x6b	/* t__pfx_cpuhp_invoke_callback */
	.byte 0x0e, 0x26, 0x9c, 0x68, 0x70, 0xbf, 0x76, 0x6f, 0x6b, 0xfc, 0x63, 0x5d, 0x62, 0xf2, 0x6b	/* tcpuhp_invoke_callback */
	.byte 0x14, 0x74, 0xaf, 0xf0, 0x9c, 0x68, 0x70, 0xbf, 0x76, 0x6f, 0x6b, 0xfc, 0x63, 0x5d, 0x62, 0xf2, 0x6b, 0xa6, 0xd2, 0x67, 0x65	/* t__pfx___cpuhp_invoke_callback_range */
	.byte 0x14, 0x74, 0xff, 0x63, 0x9c, 0x68, 0x70, 0xbf, 0x76, 0x6f, 0x6b, 0xfc, 0x63, 0x5d, 0x62, 0xf2, 0x6b, 0xa6, 0xd2, 0x67, 0x65	/* t__cpuhp_invoke_callback_range */
	.byte 0x09, 0xef, 0xf4, 0x6b, 0xfc, 0x63, 0x9c, 0xed, 0xad, 0x6e	/* t__pfx_take_cpu_down */
	.byte 0x09, 0x74, 0xf4, 0x6b, 0xfc, 0x63, 0x9c, 0xed, 0xad, 0x6e	/* ttake_cpu_down */
	.byte 0x0c, 0xef, 0x63, 0x9c, 0x68, 0x70, 0x5f, 0xca, 0x73, 0x75, 0xfc, 0x63, 0x5d	/* t__pfx_cpuhp_issue_call */
	.byte 0x0b, 0x26, 0x9c, 0x68, 0x70, 0x5f, 0xca, 0x73, 0x75, 0xfc, 0x63, 0x5d	/* tcpuhp_issue_call */
	.byte 0x10, 0xef, 0x63, 0x9c, 0x68, 0x70, 0x5f, 0xe3, 0x6c, 0x6c, 0x62, 0xf2, 0x6b, 0xbf, 0x3d, 0x6c, 0x6c	/* t__pfx_cpuhp_rollback_install */
	.byte 0x0f, 0x26, 0x9c, 0x68, 0x70, 0x5f, 0xe3, 0x6c, 0x6c, 0x62, 0xf2, 0x6b, 0xbf, 0x3d, 0x6c, 0x6c	/* tcpuhp_rollback_install */
	.byte 0x10, 0x99, 0xf0, 0x9c, 0x68, 0x70, 0xa9, 0x74, 0xfc, 0xf7, 0x17, 0x1a, 0xf8, 0x3d, 0x6e, 0x63, 0x65	/* T__pfx___cpuhp_state_remove_instance */
	.byte 0x10, 0xb9, 0x63, 0x9c, 0x68, 0x70, 0xa9, 0x74, 0xfc, 0xf7, 0x17, 0x1a, 0xf8, 0x3d, 0x6e, 0x63, 0x65	/* T__cpuhp_state_remove_instance */
	.byte 0x10, 0x99, 0xf0, 0x9c, 0x68, 0x70, 0xf6, 0xd4, 0xcd, 0xa9, 0x74, 0xfc, 0x63, 0x70, 0xb1, 0xa4, 0x9e	/* T__pfx___cpuhp_setup_state_cpuslocked */
	.byte 0x10, 0xb9, 0x63, 0x9c, 0x68, 0x70, 0xf6, 0xd4, 0xcd, 0xa9, 0x74, 0xfc, 0x63, 0x70, 0xb1, 0xa4, 0x9e	/* T__cpuhp_setup_state_cpuslocked */
	.byte 0x0a, 0x99, 0xf0, 0x9c, 0x68, 0x70, 0xf6, 0xd4, 0xcd, 0xa9, 0x2c	/* T__pfx___cpuhp_setup_state */
	.byte 0x0a, 0xb9, 0x63, 0x9c, 0x68, 0x70, 0xf6, 0xd4, 0xcd, 0xa9, 0x2c	/* T__cpuhp_setup_state */
	.byte 0x10, 0x99, 0xf0, 0x9c, 0x68, 0x70, 0xde, 0x17, 0x1a, 0x3d, 0x74, 0xfc, 0x63, 0x70, 0xb1, 0xa4, 0x9e	/* T__pfx___cpuhp_remove_state_cpuslocked */
	.byte 0x10, 0xb9, 0x63, 0x9c, 0x68, 0x70, 0xde, 0x17, 0x1a, 0x3d, 0x74, 0xfc, 0x63, 0x70, 0xb1, 0xa4, 0x9e	/* T__cpuhp_remove_state_cpuslocked */
	.byte 0x0a, 0x99, 0xf0, 0x9c, 0x68, 0x70, 0xde, 0x17, 0x1a, 0x3d, 0x2c	/* T__pfx___cpuhp_remove_state */
	.byte 0x0a, 0xb9, 0x63, 0x9c, 0x68, 0x70, 0xde, 0x17, 0x1a, 0x3d, 0x2c	/* T__cpuhp_remove_state */
	.byte 0x0b, 0xef, 0x63, 0x9c, 0x68, 0x70, 0xa7, 0x68, 0xf7, 0xc8, 0xe6, 0xe4	/* t__pfx_cpuhp_thread_fun */
	.byte 0x0a, 0x26, 0x9c, 0x68, 0x70, 0xa7, 0x68, 0xf7, 0xc8, 0xe6, 0xe4	/* tcpuhp_thread_fun */
	.byte 0x0f, 0xef, 0x63, 0x9c, 0x68, 0x70, 0x92, 0x61, 0x9d, 0x66, 0xd5, 0x7f, 0x6e, 0x63, 0xa9, 0x2c	/* t__pfx_cpuhp_wait_for_sync_state */
	.byte 0x0e, 0x26, 0x9c, 0x68, 0x70, 0x92, 0x61, 0x9d, 0x66, 0xd5, 0x7f, 0x6e, 0x63, 0xa9, 0x2c	/* tcpuhp_wait_for_sync_state */
	.byte 0x0f, 0xeb, 0x63, 0x9c, 0x68, 0x70, 0x5f, 0x61, 0x70, 0xde, 0x70, 0xd5, 0xfe, 0x64, 0x65, 0xc8	/* T__pfx_cpuhp_ap_report_dead */
	.byte 0x0f, 0x54, 0x63, 0x9c, 0x68, 0x70, 0x5f, 0x61, 0x70, 0xde, 0x70, 0xd5, 0xfe, 0x64, 0x65, 0xc8	/* Tcpuhp_ap_report_dead */
	.byte 0x08, 0xef, 0xf4, 0x6b, 0x9e, 0xad, 0x6e, 0xf0, 0x9c	/* t__pfx_takedown_cpu */
	.byte 0x08, 0x74, 0xf4, 0x6b, 0x9e, 0xad, 0x6e, 0xf0, 0x9c	/* ttakedown_cpu */
	.byte 0x0f, 0xeb, 0x63, 0x9c, 0x68, 0x70, 0x5f, 0x61, 0x70, 0x7f, 0x6e, 0xc9, 0xe5, 0x69, 0x76, 0x65	/* T__pfx_cpuhp_ap_sync_alive */
	.byte 0x0f, 0x54, 0x63, 0x9c, 0x68, 0x70, 0x5f, 0x61, 0x70, 0x7f, 0x6e, 0xc9, 0xe5, 0x69, 0x76, 0x65	/* Tcpuhp_ap_sync_alive */
	.byte 0x0c, 0xef, 0x63, 0x9c, 0x68, 0x70, 0xb8, 0x72, 0x8d, 0xcd, 0x5f, 0x61, 0x70	/* t__pfx_cpuhp_bringup_ap */
	.byte 0x0b, 0x26, 0x9c, 0x68, 0x70, 0xb8, 0x72, 0x8d, 0xcd, 0x5f, 0x61, 0x70	/* tcpuhp_bringup_ap */
	.byte 0x0d, 0xeb, 0x63, 0x9c, 0x5f, 0x97, 0xe9, 0xcd, 0x64, 0x91, 0x62, 0x65, 0x67, 0xf8	/* T__pfx_cpu_maps_update_begin */
	.byte 0x0d, 0x54, 0x63, 0x9c, 0x5f, 0x97, 0xe9, 0xcd, 0x64, 0x91, 0x62, 0x65, 0x67, 0xf8	/* Tcpu_maps_update_begin */
	.byte 0x0c, 0xeb, 0x63, 0x9c, 0x5f, 0x97, 0xe9, 0xcd, 0x64, 0x91, 0x64, 0xe7, 0x65	/* T__pfx_cpu_maps_update_done */
	.byte 0x0c, 0x54, 0x63, 0x9c, 0x5f, 0x97, 0xe9, 0xcd, 0x64, 0x91, 0x64, 0xe7, 0x65	/* Tcpu_maps_update_done */
	.byte 0x08, 0xeb, 0x63, 0x9c, 0xe9, 0x77, 0x3c, 0xfc, 0xa4	/* T__pfx_cpus_write_lock */
	.byte 0x08, 0x54, 0x63, 0x9c, 0xe9, 0x77, 0x3c, 0xfc, 0xa4	/* Tcpus_write_lock */
	.byte 0x09, 0xeb, 0x63, 0x9c, 0xe9, 0x77, 0x3c, 0xfc, 0xe4, 0xa4	/* T__pfx_cpus_write_unlock */
	.byte 0x09, 0x54, 0x63, 0x9c, 0xe9, 0x77, 0x3c, 0xfc, 0xe4, 0xa4	/* Tcpus_write_unlock */
	.byte 0x10, 0xeb, 0xa4, 0x64, 0x65, 0x70, 0x5f, 0xbb, 0x73, 0xf5, 0xfe, 0x63, 0x9c, 0xe9, 0x68, 0xdb, 0x64	/* T__pfx_lockdep_assert_cpus_held */
	.byte 0x10, 0x54, 0xa4, 0x64, 0x65, 0x70, 0x5f, 0xbb, 0x73, 0xf5, 0xfe, 0x63, 0x9c, 0xe9, 0x68, 0xdb, 0x64	/* Tlockdep_assert_cpus_held */
	.byte 0x12, 0xeb, 0x63, 0x9c, 0xa3, 0x6f, 0xce, 0x6c, 0x75, 0x67, 0xed, 0xca, 0x90, 0xb0, 0x6f, 0x66, 0x66, 0x2d, 0x8d	/* T__pfx_cpu_hotplug_disable_offlining */
	.byte 0x12, 0x54, 0x63, 0x9c, 0xa3, 0x6f, 0xce, 0x6c, 0x75, 0x67, 0xed, 0xca, 0x90, 0xb0, 0x6f, 0x66, 0x66, 0x2d, 0x8d	/* Tcpu_hotplug_disable_offlining */
	.byte 0x0c, 0x74, 0xaf, 0xf0, 0x9c, 0xed, 0xad, 0x6e, 0x5f, 0x97, 0xe9, 0xa4, 0x9e	/* t__pfx___cpu_down_maps_locked */
	.byte 0x0c, 0x74, 0xff, 0x63, 0x9c, 0xed, 0xad, 0x6e, 0x5f, 0x97, 0xe9, 0xa4, 0x9e	/* t__cpu_down_maps_locked */
	.byte 0x06, 0x74, 0xaf, 0x63, 0x9c, 0x5f, 0xcd	/* t__pfx__cpu_up */
	.byte 0x05, 0xfe, 0x63, 0x9c, 0x5f, 0xcd	/* t_cpu_up */
	.byte 0x05, 0xef, 0x63, 0x9c, 0x5f, 0xcd	/* t__pfx_cpu_up */
	.byte 0x04, 0x26, 0x9c, 0x5f, 0xcd	/* tcpu_up */
	.byte 0x08, 0xef, 0xf4, 0x72, 0x67, 0xe2, 0x73, 0x8a, 0xf7	/* t__pfx_target_store */
	.byte 0x08, 0x74, 0xf4, 0x72, 0x67, 0xe2, 0x73, 0x8a, 0xf7	/* ttarget_store */
	.byte 0x0e, 0xeb, 0x63, 0xc4, 0xc5, 0x5f, 0xf4, 0x5e, 0xe9, 0x6d, 0x6d, 0xf0, 0x9c, 0xd9, 0x5e	/* T__pfx_clear_tasks_mm_cpumask */
	.byte 0x0e, 0x54, 0x63, 0xc4, 0xc5, 0x5f, 0xf4, 0x5e, 0xe9, 0x6d, 0x6d, 0xf0, 0x9c, 0xd9, 0x5e	/* Tclear_tasks_mm_cpumask */
	.byte 0x0e, 0xeb, 0x63, 0x9c, 0x68, 0x70, 0xde, 0x70, 0xd5, 0xfe, 0x9f, 0xb0, 0x64, 0x65, 0xc8	/* T__pfx_cpuhp_report_idle_dead */
	.byte 0x0e, 0x54, 0x63, 0x9c, 0x68, 0x70, 0xde, 0x70, 0xd5, 0xfe, 0x9f, 0xb0, 0x64, 0x65, 0xc8	/* Tcpuhp_report_idle_dead */
	.byte 0x09, 0xeb, 0x63, 0x9c, 0x2b, 0xaa, 0xfc, 0x64, 0xad, 0x6e	/* T__pfx_cpu_device_down */
	.byte 0x09, 0x54, 0x63, 0x9c, 0x2b, 0xaa, 0xfc, 0x64, 0xad, 0x6e	/* Tcpu_device_down */
	.byte 0x12, 0xeb, 0x73, 0xb6, 0xf6, 0x68, 0x20, 0x64, 0xad, 0x6e, 0xbd, 0xe7, 0x62, 0x6f, 0x6f, 0xfe, 0x63, 0x70, 0xb1	/* T__pfx_smp_shutdown_nonboot_cpus */
	.byte 0x12, 0x54, 0x73, 0xb6, 0xf6, 0x68, 0x20, 0x64, 0xad, 0x6e, 0xbd, 0xe7, 0x62, 0x6f, 0x6f, 0xfe, 0x63, 0x70, 0xb1	/* Tsmp_shutdown_nonboot_cpus */
	.byte 0x0c, 0xeb, 0x6e, 0x6f, 0xdc, 0x66, 0x79, 0xf0, 0x9c, 0xa9, 0x72, 0x74, 0x8d	/* T__pfx_notify_cpu_starting */
	.byte 0x0c, 0x54, 0x6e, 0x6f, 0xdc, 0x66, 0x79, 0xf0, 0x9c, 0xa9, 0x72, 0x74, 0x8d	/* Tnotify_cpu_starting */
	.byte 0x0b, 0xeb, 0x63, 0x9c, 0x68, 0x70, 0x5f, 0xe7, 0x2d, 0xfc, 0x9f, 0xc4	/* T__pfx_cpuhp_online_idle */
	.byte 0x0b, 0x54, 0x63, 0x9c, 0x68, 0x70, 0x5f, 0xe7, 0x2d, 0xfc, 0x9f, 0xc4	/* Tcpuhp_online_idle */
	.byte 0x07, 0xeb, 0x63, 0x9c, 0x2b, 0xaa, 0xfc, 0xcd	/* T__pfx_cpu_device_up */
	.byte 0x07, 0x54, 0x63, 0x9c, 0x2b, 0xaa, 0xfc, 0xcd	/* Tcpu_device_up */
	.byte 0x0d, 0xeb, 0x62, 0x72, 0x8d, 0xcd, 0xa3, 0x69, 0x62, 0xf5, 0x6e, 0x91, 0x63, 0x9c	/* T__pfx_bringup_hibernate_cpu */
	.byte 0x0d, 0x54, 0x62, 0x72, 0x8d, 0xcd, 0xa3, 0x69, 0x62, 0xf5, 0x6e, 0x91, 0x63, 0x9c	/* Tbringup_hibernate_cpu */
	.byte 0x0f, 0xeb, 0x66, 0xf7, 0x65, 0x7a, 0xfc, 0x73, 0xb4, 0xe7, 0x64, 0xc5, 0x79, 0xf0, 0x70, 0xb1	/* T__pfx_freeze_secondary_cpus */
	.byte 0x0f, 0x54, 0x66, 0xf7, 0x65, 0x7a, 0xfc, 0x73, 0xb4, 0xe7, 0x64, 0xc5, 0x79, 0xf0, 0x70, 0xb1	/* Tfreeze_secondary_cpus */
	.byte 0x0e, 0xeb, 0x74, 0x68, 0x61, 0x77, 0xf6, 0xb4, 0xe7, 0x64, 0xc5, 0x79, 0xf0, 0x70, 0xb1	/* T__pfx_thaw_secondary_cpus */
	.byte 0x0e, 0x54, 0x74, 0x68, 0x61, 0x77, 0xf6, 0xb4, 0xe7, 0x64, 0xc5, 0x79, 0xf0, 0x70, 0xb1	/* Tthaw_secondary_cpus */
	.byte 0x14, 0x99, 0xf0, 0x9c, 0x68, 0x70, 0xa9, 0x74, 0xfc, 0xc8, 0xda, 0xf8, 0x3d, 0x6e, 0x63, 0xfc, 0x63, 0x70, 0xb1, 0xa4, 0x9e	/* T__pfx___cpuhp_state_add_instance_cpuslocked */
	.byte 0x14, 0xb9, 0x63, 0x9c, 0x68, 0x70, 0xa9, 0x74, 0xfc, 0xc8, 0xda, 0xf8, 0x3d, 0x6e, 0x63, 0xfc, 0x63, 0x70, 0xb1, 0xa4, 0x9e	/* T__cpuhp_state_add_instance_cpuslocked */
	.byte 0x0f, 0x99, 0xf0, 0x9c, 0x68, 0x70, 0xa9, 0x74, 0xfc, 0xc8, 0xda, 0xf8, 0x3d, 0x6e, 0x63, 0x65	/* T__pfx___cpuhp_state_add_instance */
	.byte 0x0f, 0xb9, 0x63, 0x9c, 0x68, 0x70, 0xa9, 0x74, 0xfc, 0xc8, 0xda, 0xf8, 0x3d, 0x6e, 0x63, 0x65	/* T__cpuhp_state_add_instance */
	.byte 0x0c, 0xeb, 0x63, 0x9c, 0x68, 0x70, 0xf6, 0x6d, 0xfe, 0x64, 0xca, 0x90, 0xc4	/* T__pfx_cpuhp_smt_disable */
	.byte 0x0c, 0x54, 0x63, 0x9c, 0x68, 0x70, 0xf6, 0x6d, 0xfe, 0x64, 0xca, 0x90, 0xc4	/* Tcpuhp_smt_disable */
	.byte 0x0b, 0xeb, 0x63, 0x9c, 0x68, 0x70, 0xf6, 0x6d, 0xfe, 0xf1, 0x90, 0xc4	/* T__pfx_cpuhp_smt_enable */
	.byte 0x0b, 0x54, 0x63, 0x9c, 0x68, 0x70, 0xf6, 0x6d, 0xfe, 0xf1, 0x90, 0xc4	/* Tcpuhp_smt_enable */
	.byte 0x07, 0xef, 0x40, 0xf3, 0xa0, 0xf6, 0x8a, 0xf7	/* t__pfx_control_store */
	.byte 0x07, 0x74, 0x40, 0xf3, 0xa0, 0xf6, 0x8a, 0xf7	/* tcontrol_store */
	.byte 0x09, 0xeb, 0xf8, 0x9d, 0x63, 0x9c, 0xec, 0x29, 0xf1, 0x74	/* T__pfx_init_cpu_present */
	.byte 0x09, 0x54, 0xf8, 0x9d, 0x63, 0x9c, 0xec, 0x29, 0xf1, 0x74	/* Tinit_cpu_present */
	.byte 0x0b, 0xeb, 0xf8, 0x9d, 0x63, 0x9c, 0xec, 0x6f, 0x73, 0x85, 0x62, 0xc4	/* T__pfx_init_cpu_possible */
	.byte 0x0b, 0x54, 0xf8, 0x9d, 0x63, 0x9c, 0xec, 0x6f, 0x73, 0x85, 0x62, 0xc4	/* Tinit_cpu_possible */
	.byte 0x09, 0xeb, 0xf8, 0x9d, 0x63, 0x9c, 0x5f, 0xe7, 0x2d, 0x65	/* T__pfx_init_cpu_online */
	.byte 0x09, 0x54, 0xf8, 0x9d, 0x63, 0x9c, 0x5f, 0xe7, 0x2d, 0x65	/* Tinit_cpu_online */
	.byte 0x09, 0xeb, 0x73, 0xe2, 0x63, 0x9c, 0x5f, 0xe7, 0x2d, 0x65	/* T__pfx_set_cpu_online */
	.byte 0x09, 0x54, 0x73, 0xe2, 0x63, 0x9c, 0x5f, 0xe7, 0x2d, 0x65	/* Tset_cpu_online */
	.byte 0x13, 0xef, 0x77, 0x69, 0x6c, 0x6c, 0xb8, 0xb4, 0x6f, 0x6d, 0xfc, 0xd5, 0x70, 0x68, 0xd2, 0x9e, 0xec, 0x67, 0x72, 0x70	/* t__pfx_will_become_orphaned_pgrp */
	.byte 0x13, 0x74, 0x77, 0x69, 0x6c, 0x6c, 0xb8, 0xb4, 0x6f, 0x6d, 0xfc, 0xd5, 0x70, 0x68, 0xd2, 0x9e, 0xec, 0x67, 0x72, 0x70	/* twill_become_orphaned_pgrp */
	.byte 0x0b, 0xef, 0x66, 0xf8, 0xda, 0xe5, 0x69, 0x1a, 0x74, 0x68, 0xf7, 0xc8	/* t__pfx_find_alive_thread */
	.byte 0x0b, 0x74, 0x66, 0xf8, 0xda, 0xe5, 0x69, 0x1a, 0x74, 0x68, 0xf7, 0xc8	/* tfind_alive_thread */
	.byte 0x09, 0xef, 0x6f, 0xbe, 0x73, 0x3a, 0xe4, 0xfe, 0x73, 0x7c	/* t__pfx_oops_count_show */
	.byte 0x08, 0x8a, 0xbe, 0x73, 0x3a, 0xe4, 0xfe, 0x73, 0x7c	/* toops_count_show */
	.byte 0x0c, 0xeb, 0x72, 0x63, 0x75, 0x77, 0x61, 0x9d, 0x77, 0x61, 0x6b, 0xfc, 0xcd	/* T__pfx_rcuwait_wake_up */
	.byte 0x0c, 0x54, 0x72, 0x63, 0x75, 0x77, 0x61, 0x9d, 0x77, 0x61, 0x6b, 0xfc, 0xcd	/* Trcuwait_wake_up */
	.byte 0x0f, 0xef, 0x6b, 0x69, 0x6c, 0x6c, 0x5f, 0xd5, 0x70, 0x68, 0xd2, 0x9e, 0xec, 0x67, 0x72, 0x70	/* t__pfx_kill_orphaned_pgrp */
	.byte 0x0f, 0x74, 0x6b, 0x69, 0x6c, 0x6c, 0x5f, 0xd5, 0x70, 0x68, 0xd2, 0x9e, 0xec, 0x67, 0x72, 0x70	/* tkill_orphaned_pgrp */
	.byte 0x0d, 0xef, 0xba, 0x69, 0x6c, 0xda, 0x77, 0x61, 0x9d, 0x63, 0x5d, 0x62, 0xf2, 0x6b	/* t__pfx_child_wait_callback */
	.byte 0x0d, 0x74, 0xba, 0x69, 0x6c, 0xda, 0x77, 0x61, 0x9d, 0x63, 0x5d, 0x62, 0xf2, 0x6b	/* tchild_wait_callback */
	.byte 0x0f, 0xef, 0x64, 0xdb, 0x61, 0x79, 0x9e, 0xec, 0x1e, 0xf4, 0x5e, 0xf6, 0xf3, 0x75, 0x63, 0x74	/* t__pfx_delayed_put_task_struct */
	.byte 0x0f, 0x74, 0x64, 0xdb, 0x61, 0x79, 0x9e, 0xec, 0x1e, 0xf4, 0x5e, 0xf6, 0xf3, 0x75, 0x63, 0x74	/* tdelayed_put_task_struct */
	.byte 0x10, 0xeb, 0x9c, 0xfe, 0xf4, 0x5e, 0xf6, 0xf3, 0x75, 0x63, 0xfe, 0x72, 0x63, 0x75, 0x5f, 0xb1, 0xf5	/* T__pfx_put_task_struct_rcu_user */
	.byte 0x10, 0x54, 0x9c, 0xfe, 0xf4, 0x5e, 0xf6, 0xf3, 0x75, 0x63, 0xfe, 0x72, 0x63, 0x75, 0x5f, 0xb1, 0xf5	/* Tput_task_struct_rcu_user */
	.byte 0x07, 0xeb, 0xf7, 0xc4, 0xbb, 0xfc, 0xf4, 0x5e	/* T__pfx_release_task */
	.byte 0x07, 0x54, 0xf7, 0xc4, 0xbb, 0xfc, 0xf4, 0x5e	/* Trelease_task */
	.byte 0x0b, 0xef, 0x77, 0x61, 0x9d, 0x40, 0x73, 0x9f, 0xf5, 0x5f, 0xf4, 0x5e	/* t__pfx_wait_consider_task */
	.byte 0x0b, 0x74, 0x77, 0x61, 0x9d, 0x40, 0x73, 0x9f, 0xf5, 0x5f, 0xf4, 0x5e	/* twait_consider_task */
	.byte 0x11, 0xeb, 0xca, 0xf0, 0x98, 0xf7, 0x6e, 0xfe, 0x70, 0x67, 0x72, 0x70, 0x5f, 0xd5, 0x70, 0x68, 0xd2, 0x9e	/* T__pfx_is_current_pgrp_orphaned */
	.byte 0x11, 0x54, 0xca, 0xf0, 0x98, 0xf7, 0x6e, 0xfe, 0x70, 0x67, 0x72, 0x70, 0x5f, 0xd5, 0x70, 0x68, 0xd2, 0x9e	/* Tis_current_pgrp_orphaned */
	.byte 0x08, 0xeb, 0x3d, 0xc6, 0xbd, 0x6f, 0xfe, 0xb1, 0x9e	/* T__pfx_stack_not_used */
	.byte 0x08, 0x54, 0x3d, 0xc6, 0xbd, 0x6f, 0xfe, 0xb1, 0x9e	/* Tstack_not_used */
	.byte 0x06, 0xeb, 0x64, 0x6f, 0x5f, 0xcb, 0xea	/* T__pfx_do_exit */
	.byte 0x06, 0x54, 0x64, 0x6f, 0x5f, 0xcb, 0xea	/* Tdo_exit */
	.byte 0x09, 0xeb, 0xd9, 0x6b, 0xfc, 0xf4, 0x5e, 0xed, 0x65, 0xc8	/* T__pfx_make_task_dead */
	.byte 0x09, 0x54, 0xd9, 0x6b, 0xfc, 0xf4, 0x5e, 0xed, 0x65, 0xc8	/* Tmake_task_dead */
	.byte 0x08, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xcb, 0xea	/* T__pfx___x64_sys_exit */
	.byte 0x08, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xcb, 0xea	/* T__x64_sys_exit */
	.byte 0x09, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xcb, 0xea	/* T__pfx___ia32_sys_exit */
	.byte 0x09, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xcb, 0xea	/* T__ia32_sys_exit */
	.byte 0x09, 0xeb, 0x64, 0x6f, 0xc7, 0xe3, 0xcd, 0x5f, 0xcb, 0xea	/* T__pfx_do_group_exit */
	.byte 0x09, 0x54, 0x64, 0x6f, 0xc7, 0xe3, 0xcd, 0x5f, 0xcb, 0xea	/* Tdo_group_exit */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xcb, 0x9d, 0x67, 0xe3, 0xcd	/* T__pfx___x64_sys_exit_group */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xcb, 0x9d, 0x67, 0xe3, 0xcd	/* T__x64_sys_exit_group */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xcb, 0x9d, 0x67, 0xe3, 0xcd	/* T__pfx___ia32_sys_exit_group */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xcb, 0x9d, 0x67, 0xe3, 0xcd	/* T__ia32_sys_exit_group */
	.byte 0x10, 0xeb, 0xb2, 0x64, 0x25, 0x69, 0x6c, 0x64, 0xf6, 0x68, 0x6f, 0x02, 0xda, 0x77, 0x61, 0x6b, 0x65	/* T__pfx_pid_child_should_wake */
	.byte 0x10, 0x54, 0xb2, 0x64, 0x25, 0x69, 0x6c, 0x64, 0xf6, 0x68, 0x6f, 0x02, 0xda, 0x77, 0x61, 0x6b, 0x65	/* Tpid_child_should_wake */
	.byte 0x0b, 0x99, 0x92, 0x61, 0x6b, 0xfc, 0xcd, 0xec, 0x61, 0xf7, 0x6e, 0x74	/* T__pfx___wake_up_parent */
	.byte 0x0b, 0xb9, 0x77, 0x61, 0x6b, 0xfc, 0xcd, 0xec, 0x61, 0xf7, 0x6e, 0x74	/* T__wake_up_parent */
	.byte 0x06, 0x99, 0xed, 0x6f, 0x92, 0x61, 0xea	/* T__pfx___do_wait */
	.byte 0x06, 0xb9, 0x64, 0x6f, 0x92, 0x61, 0xea	/* T__do_wait */
	.byte 0x06, 0xef, 0x64, 0x6f, 0x92, 0x61, 0xea	/* t__pfx_do_wait */
	.byte 0x06, 0x74, 0x64, 0x6f, 0x92, 0x61, 0xea	/* tdo_wait */
	.byte 0x0e, 0xeb, 0x6b, 0xf5, 0x6e, 0xdb, 0x92, 0x61, 0xea, 0x9f, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* T__pfx_kernel_waitid_prepare */
	.byte 0x0e, 0x54, 0x6b, 0xf5, 0x6e, 0xdb, 0x92, 0x61, 0xea, 0x9f, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* Tkernel_waitid_prepare */
	.byte 0x09, 0xef, 0x6b, 0xf5, 0x6e, 0xdb, 0x92, 0x61, 0xea, 0x9f	/* t__pfx_kernel_waitid */
	.byte 0x09, 0x74, 0x6b, 0xf5, 0x6e, 0xdb, 0x92, 0x61, 0xea, 0x9f	/* tkernel_waitid */
	.byte 0x0a, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0xe9, 0x77, 0x61, 0xea, 0x9f	/* t__pfx___do_sys_waitid */
	.byte 0x0a, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0xe9, 0x77, 0x61, 0xea, 0x9f	/* t__do_sys_waitid */
	.byte 0x0e, 0x74, 0xaf, 0xed, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x77, 0x61, 0xea, 0x9f	/* t__pfx___do_compat_sys_waitid */
	.byte 0x0e, 0x74, 0xff, 0x64, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x77, 0x61, 0xea, 0x9f	/* t__do_compat_sys_waitid */
	.byte 0x0a, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x77, 0x61, 0xea, 0x9f	/* T__pfx___x64_sys_waitid */
	.byte 0x0a, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x77, 0x61, 0xea, 0x9f	/* T__x64_sys_waitid */
	.byte 0x0b, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x77, 0x61, 0xea, 0x9f	/* T__pfx___ia32_sys_waitid */
	.byte 0x0b, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x77, 0x61, 0xea, 0x9f	/* T__ia32_sys_waitid */
	.byte 0x09, 0xeb, 0x6b, 0xf5, 0x6e, 0xdb, 0x92, 0x61, 0xea, 0x34	/* T__pfx_kernel_wait4 */
	.byte 0x09, 0x54, 0x6b, 0xf5, 0x6e, 0xdb, 0x92, 0x61, 0xea, 0x34	/* Tkernel_wait4 */
	.byte 0x0a, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0xe9, 0x77, 0x61, 0xea, 0x34	/* t__pfx___do_sys_wait4 */
	.byte 0x0a, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0xe9, 0x77, 0x61, 0xea, 0x34	/* t__do_sys_wait4 */
	.byte 0x0e, 0x74, 0xaf, 0xed, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x77, 0x61, 0xea, 0x34	/* t__pfx___do_compat_sys_wait4 */
	.byte 0x0e, 0x74, 0xff, 0x64, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x77, 0x61, 0xea, 0x34	/* t__do_compat_sys_wait4 */
	.byte 0x08, 0xeb, 0x6b, 0xf5, 0x6e, 0xdb, 0x92, 0x61, 0xea	/* T__pfx_kernel_wait */
	.byte 0x08, 0x54, 0x6b, 0xf5, 0x6e, 0xdb, 0x92, 0x61, 0xea	/* Tkernel_wait */
	.byte 0x0a, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x77, 0x61, 0xea, 0x34	/* T__pfx___x64_sys_wait4 */
	.byte 0x0a, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x77, 0x61, 0xea, 0x34	/* T__x64_sys_wait4 */
	.byte 0x0b, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x77, 0x61, 0xea, 0x34	/* T__pfx___ia32_sys_wait4 */
	.byte 0x0b, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x77, 0x61, 0xea, 0x34	/* T__ia32_sys_wait4 */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x77, 0x61, 0xea, 0xb2, 0x64	/* T__pfx___x64_sys_waitpid */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x77, 0x61, 0xea, 0xb2, 0x64	/* T__x64_sys_waitpid */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x77, 0x61, 0xea, 0xb2, 0x64	/* T__pfx___ia32_sys_waitpid */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x77, 0x61, 0xea, 0xb2, 0x64	/* T__ia32_sys_waitpid */
	.byte 0x0f, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x77, 0x61, 0xea, 0x34	/* T__pfx___ia32_compat_sys_wait4 */
	.byte 0x0f, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x77, 0x61, 0xea, 0x34	/* T__ia32_compat_sys_wait4 */
	.byte 0x0f, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x77, 0x61, 0xea, 0x9f	/* T__pfx___ia32_compat_sys_waitid */
	.byte 0x0f, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x77, 0x61, 0xea, 0x9f	/* T__ia32_compat_sys_waitid */
	.byte 0x0c, 0x08, 0x18, 0x5f, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5, 0x0d, 0xf3, 0x79	/* T__pfx___traceiter_irq_handler_entry */
	.byte 0x0c, 0xb9, 0x18, 0x5f, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5, 0x0d, 0xf3, 0x79	/* T__traceiter_irq_handler_entry */
	.byte 0x0d, 0x99, 0xec, 0x10, 0x5f, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5, 0x0d, 0xf3, 0x79	/* T__pfx___probestub_irq_handler_entry */
	.byte 0x0d, 0x54, 0xfd, 0x10, 0x5f, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5, 0x0d, 0xf3, 0x79	/* T__probestub_irq_handler_entry */
	.byte 0x0c, 0x08, 0x18, 0x5f, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5, 0x5f, 0xcb, 0xea	/* T__pfx___traceiter_irq_handler_exit */
	.byte 0x0c, 0xb9, 0x18, 0x5f, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5, 0x5f, 0xcb, 0xea	/* T__traceiter_irq_handler_exit */
	.byte 0x0d, 0x99, 0xec, 0x10, 0x5f, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5, 0x5f, 0xcb, 0xea	/* T__pfx___probestub_irq_handler_exit */
	.byte 0x0d, 0x54, 0xfd, 0x10, 0x5f, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5, 0x5f, 0xcb, 0xea	/* T__probestub_irq_handler_exit */
	.byte 0x0b, 0x08, 0x18, 0xf6, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x0d, 0xf3, 0x79	/* T__pfx___traceiter_softirq_entry */
	.byte 0x0b, 0xb9, 0x18, 0xf6, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x0d, 0xf3, 0x79	/* T__traceiter_softirq_entry */
	.byte 0x0c, 0x99, 0xec, 0x10, 0xf6, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x0d, 0xf3, 0x79	/* T__pfx___probestub_softirq_entry */
	.byte 0x0c, 0x54, 0xfd, 0x10, 0xf6, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x0d, 0xf3, 0x79	/* T__probestub_softirq_entry */
	.byte 0x0b, 0x08, 0x18, 0xf6, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x5f, 0xcb, 0xea	/* T__pfx___traceiter_softirq_exit */
	.byte 0x0b, 0xb9, 0x18, 0xf6, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x5f, 0xcb, 0xea	/* T__traceiter_softirq_exit */
	.byte 0x0c, 0x08, 0x18, 0xf6, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x5f, 0xbc, 0xca, 0x65	/* T__pfx___traceiter_softirq_raise */
	.byte 0x0c, 0xb9, 0x18, 0xf6, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x5f, 0xbc, 0xca, 0x65	/* T__traceiter_softirq_raise */
	.byte 0x0a, 0x08, 0x18, 0x5f, 0xf4, 0x5e, 0x6c, 0xe2, 0xf1, 0xf3, 0x79	/* T__pfx___traceiter_tasklet_entry */
	.byte 0x0a, 0xb9, 0x18, 0x5f, 0xf4, 0x5e, 0x6c, 0xe2, 0xf1, 0xf3, 0x79	/* T__traceiter_tasklet_entry */
	.byte 0x0b, 0x99, 0xec, 0x10, 0x5f, 0xf4, 0x5e, 0x6c, 0xe2, 0xf1, 0xf3, 0x79	/* T__pfx___probestub_tasklet_entry */
	.byte 0x0b, 0x54, 0xfd, 0x10, 0x5f, 0xf4, 0x5e, 0x6c, 0xe2, 0xf1, 0xf3, 0x79	/* T__probestub_tasklet_entry */
	.byte 0x09, 0x08, 0x18, 0x5f, 0xf4, 0x5e, 0x6c, 0xe2, 0xcb, 0xea	/* T__pfx___traceiter_tasklet_exit */
	.byte 0x09, 0xb9, 0x18, 0x5f, 0xf4, 0x5e, 0x6c, 0xe2, 0xcb, 0xea	/* T__traceiter_tasklet_exit */
	.byte 0x08, 0xeb, 0xf4, 0x5e, 0x6c, 0xe2, 0x73, 0xd4, 0xcd	/* T__pfx_tasklet_setup */
	.byte 0x08, 0x54, 0xf4, 0x5e, 0x6c, 0xe2, 0x73, 0xd4, 0xcd	/* Ttasklet_setup */
	.byte 0x06, 0xeb, 0xf4, 0x5e, 0x6c, 0xe2, 0x0f	/* T__pfx_tasklet_init */
	.byte 0x06, 0x54, 0xf4, 0x5e, 0x6c, 0xe2, 0x0f	/* Ttasklet_init */
	.byte 0x10, 0xef, 0x6b, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x64, 0xf6, 0x68, 0x6f, 0x02, 0xda, 0x72, 0xe4	/* t__pfx_ksoftirqd_should_run */
	.byte 0x10, 0x74, 0x6b, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x64, 0xf6, 0x68, 0x6f, 0x02, 0xda, 0x72, 0xe4	/* tksoftirqd_should_run */
	.byte 0x0c, 0xef, 0x6b, 0x00, 0xf5, 0x64, 0xf6, 0x68, 0x6f, 0x02, 0xda, 0x72, 0xe4	/* t__pfx_ktimerd_should_run */
	.byte 0x0c, 0x74, 0x6b, 0x00, 0xf5, 0x64, 0xf6, 0x68, 0x6f, 0x02, 0xda, 0x72, 0xe4	/* tktimerd_should_run */
	.byte 0x0d, 0xeb, 0xf4, 0x5e, 0x6c, 0xe2, 0xe4, 0xa4, 0xf6, 0x70, 0xf8, 0x92, 0x61, 0xea	/* T__pfx_tasklet_unlock_spin_wait */
	.byte 0x0d, 0x54, 0xf4, 0x5e, 0x6c, 0xe2, 0xe4, 0xa4, 0xf6, 0x70, 0xf8, 0x92, 0x61, 0xea	/* Ttasklet_unlock_spin_wait */
	.byte 0x0a, 0xef, 0x19, 0x3b, 0xc3, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71	/* t__pfx_perf_trace_softirq */
	.byte 0x0a, 0xce, 0xf5, 0x3b, 0xc3, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71	/* tperf_trace_softirq */
	.byte 0x08, 0xef, 0x19, 0x3b, 0xc3, 0xf4, 0x5e, 0x6c, 0xd4	/* t__pfx_perf_trace_tasklet */
	.byte 0x08, 0xce, 0xf5, 0x3b, 0xc3, 0xf4, 0x5e, 0x6c, 0xd4	/* tperf_trace_tasklet */
	.byte 0x09, 0x99, 0xdd, 0x63, 0xe5, 0xb8, 0x68, 0x0d, 0x90, 0xc4	/* T__pfx__local_bh_enable */
	.byte 0x0a, 0x54, 0x5f, 0xdd, 0x63, 0xe5, 0xb8, 0x68, 0x0d, 0x90, 0xc4	/* T_local_bh_enable */
	.byte 0x0a, 0xef, 0x7d, 0x7b, 0xcc, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71	/* t__pfx_trace_event_raw_event_softirq */
	.byte 0x0a, 0x74, 0x7d, 0x7b, 0xcc, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71	/* ttrace_event_raw_event_softirq */
	.byte 0x08, 0xef, 0x7d, 0x7b, 0xcc, 0xf4, 0x5e, 0x6c, 0xd4	/* t__pfx_trace_event_raw_event_tasklet */
	.byte 0x08, 0x74, 0x7d, 0x7b, 0xcc, 0xf4, 0x5e, 0x6c, 0xd4	/* ttrace_event_raw_event_tasklet */
	.byte 0x10, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5, 0x0d, 0xf3, 0x79	/* t__pfx_trace_raw_output_irq_handler_entry */
	.byte 0x10, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5, 0x0d, 0xf3, 0x79	/* ttrace_raw_output_irq_handler_entry */
	.byte 0x10, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5, 0x5f, 0xcb, 0xea	/* t__pfx_trace_raw_output_irq_handler_exit */
	.byte 0x10, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5, 0x5f, 0xcb, 0xea	/* ttrace_raw_output_irq_handler_exit */
	.byte 0x0b, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0xf4, 0x5e, 0x6c, 0xd4	/* t__pfx_trace_raw_output_tasklet */
	.byte 0x0b, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0xf4, 0x5e, 0x6c, 0xd4	/* ttrace_raw_output_tasklet */
	.byte 0x0d, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71	/* t__pfx_trace_raw_output_softirq */
	.byte 0x0d, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71	/* ttrace_raw_output_softirq */
	.byte 0x08, 0xef, 0x6b, 0x00, 0xf5, 0x64, 0xf6, 0xd4, 0xcd	/* t__pfx_ktimerd_setup */
	.byte 0x08, 0x74, 0x6b, 0x00, 0xf5, 0x64, 0xf6, 0xd4, 0xcd	/* tktimerd_setup */
	.byte 0x0d, 0xef, 0x19, 0x3b, 0xc3, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5, 0x5f, 0xcb, 0xea	/* t__pfx_perf_trace_irq_handler_exit */
	.byte 0x0d, 0xce, 0xf5, 0x3b, 0xc3, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5, 0x5f, 0xcb, 0xea	/* tperf_trace_irq_handler_exit */
	.byte 0x0d, 0xef, 0x7d, 0x7b, 0xcc, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5, 0x5f, 0xcb, 0xea	/* t__pfx_trace_event_raw_event_irq_handler_exit */
	.byte 0x0d, 0x74, 0x7d, 0x7b, 0xcc, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5, 0x5f, 0xcb, 0xea	/* ttrace_event_raw_event_irq_handler_exit */
	.byte 0x0d, 0xef, 0x19, 0x3b, 0xc3, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5, 0x0d, 0xf3, 0x79	/* t__pfx_perf_trace_irq_handler_entry */
	.byte 0x0d, 0xce, 0xf5, 0x3b, 0xc3, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5, 0x0d, 0xf3, 0x79	/* tperf_trace_irq_handler_entry */
	.byte 0x0a, 0x99, 0xec, 0x10, 0x5f, 0xf4, 0x5e, 0x6c, 0xe2, 0xcb, 0xea	/* T__pfx___probestub_tasklet_exit */
	.byte 0x0a, 0x54, 0xfd, 0x10, 0x5f, 0xf4, 0x5e, 0x6c, 0xe2, 0xcb, 0xea	/* T__probestub_tasklet_exit */
	.byte 0x0d, 0x99, 0xec, 0x10, 0xf6, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x5f, 0xbc, 0xca, 0x65	/* T__pfx___probestub_softirq_raise */
	.byte 0x0d, 0x54, 0xfd, 0x10, 0xf6, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x5f, 0xbc, 0xca, 0x65	/* T__probestub_softirq_raise */
	.byte 0x0b, 0xef, 0xf4, 0x5e, 0x6c, 0xe2, 0x63, 0xc4, 0xc5, 0xf6, 0xba, 0x9e	/* t__pfx_tasklet_clear_sched */
	.byte 0x0b, 0x74, 0xf4, 0x5e, 0x6c, 0xe2, 0x63, 0xc4, 0xc5, 0xf6, 0xba, 0x9e	/* ttasklet_clear_sched */
	.byte 0x09, 0xeb, 0xf4, 0x5e, 0x6c, 0xe2, 0x6b, 0x69, 0x6c, 0x6c	/* T__pfx_tasklet_kill */
	.byte 0x09, 0x54, 0xf4, 0x5e, 0x6c, 0xe2, 0x6b, 0x69, 0x6c, 0x6c	/* Ttasklet_kill */
	.byte 0x0c, 0x99, 0xec, 0x10, 0xf6, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x5f, 0xcb, 0xea	/* T__pfx___probestub_softirq_exit */
	.byte 0x0c, 0x54, 0xfd, 0x10, 0xf6, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x5f, 0xcb, 0xea	/* T__probestub_softirq_exit */
	.byte 0x07, 0xeb, 0xf4, 0x5e, 0x6c, 0xe2, 0xe4, 0xa4	/* T__pfx_tasklet_unlock */
	.byte 0x07, 0x54, 0xf4, 0x5e, 0x6c, 0xe2, 0xe4, 0xa4	/* Ttasklet_unlock */
	.byte 0x0d, 0xef, 0x7d, 0x7b, 0xcc, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5, 0x0d, 0xf3, 0x79	/* t__pfx_trace_event_raw_event_irq_handler_entry */
	.byte 0x0d, 0x74, 0x7d, 0x7b, 0xcc, 0xab, 0x71, 0xa3, 0x05, 0x6c, 0xf5, 0x0d, 0xf3, 0x79	/* ttrace_event_raw_event_irq_handler_entry */
	.byte 0x0a, 0xeb, 0xf4, 0x5e, 0x6c, 0xe2, 0xe4, 0xa4, 0x92, 0x61, 0xea	/* T__pfx_tasklet_unlock_wait */
	.byte 0x0a, 0x54, 0xf4, 0x5e, 0x6c, 0xe2, 0xe4, 0xa4, 0x92, 0x61, 0xea	/* Ttasklet_unlock_wait */
	.byte 0x0b, 0xef, 0x68, 0x05, 0xb0, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x73	/* t__pfx_handle_softirqs */
	.byte 0x0b, 0x74, 0x68, 0x05, 0xb0, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x73	/* thandle_softirqs */
	.byte 0x08, 0xef, 0x72, 0xe4, 0x5f, 0x6b, 0x00, 0xf5, 0x64	/* t__pfx_run_ktimerd */
	.byte 0x07, 0xf3, 0xe4, 0x5f, 0x6b, 0x00, 0xf5, 0x64	/* trun_ktimerd */
	.byte 0x0c, 0xef, 0x72, 0xe4, 0x5f, 0x6b, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x64	/* t__pfx_run_ksoftirqd */
	.byte 0x0b, 0xf3, 0xe4, 0x5f, 0x6b, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x64	/* trun_ksoftirqd */
	.byte 0x0a, 0x08, 0xf4, 0x5e, 0x6c, 0xe2, 0x73, 0xba, 0x9e, 0x75, 0xc4	/* T__pfx___tasklet_schedule */
	.byte 0x0a, 0xb9, 0xf4, 0x5e, 0x6c, 0xe2, 0x73, 0xba, 0x9e, 0x75, 0xc4	/* T__tasklet_schedule */
	.byte 0x0c, 0x08, 0xf4, 0x5e, 0x6c, 0xe2, 0x68, 0x69, 0xf6, 0xba, 0x9e, 0x75, 0xc4	/* T__pfx___tasklet_hi_schedule */
	.byte 0x0c, 0xb9, 0xf4, 0x5e, 0x6c, 0xe2, 0x68, 0x69, 0xf6, 0xba, 0x9e, 0x75, 0xc4	/* T__tasklet_hi_schedule */
	.byte 0x0c, 0xef, 0xf4, 0x5e, 0x6c, 0xe2, 0xf2, 0xdc, 0xe7, 0x3a, 0x6d, 0x6d, 0xe7	/* t__pfx_tasklet_action_common */
	.byte 0x0c, 0x74, 0xf4, 0x5e, 0x6c, 0xe2, 0xf2, 0xdc, 0xe7, 0x3a, 0x6d, 0x6d, 0xe7	/* ttasklet_action_common */
	.byte 0x0b, 0xef, 0xf4, 0x5e, 0x6c, 0xe2, 0x68, 0x69, 0x5f, 0xf2, 0xdc, 0xe7	/* t__pfx_tasklet_hi_action */
	.byte 0x0b, 0x74, 0xf4, 0x5e, 0x6c, 0xe2, 0x68, 0x69, 0x5f, 0xf2, 0xdc, 0xe7	/* ttasklet_hi_action */
	.byte 0x08, 0xef, 0xf4, 0x5e, 0x6c, 0xe2, 0xf2, 0xdc, 0xe7	/* t__pfx_tasklet_action */
	.byte 0x08, 0x74, 0xf4, 0x5e, 0x6c, 0xe2, 0xf2, 0xdc, 0xe7	/* ttasklet_action */
	.byte 0x0c, 0xef, 0xf4, 0x6b, 0x65, 0x6f, 0x0b, 0x5f, 0xf4, 0x5e, 0x6c, 0xd4, 0x73	/* t__pfx_takeover_tasklets */
	.byte 0x0c, 0x74, 0xf4, 0x6b, 0x65, 0x6f, 0x0b, 0x5f, 0xf4, 0x5e, 0x6c, 0xd4, 0x73	/* ttakeover_tasklets */
	.byte 0x09, 0xeb, 0x64, 0x6f, 0xf6, 0x6f, 0x66, 0xdc, 0x72, 0x71	/* T__pfx_do_softirq */
	.byte 0x09, 0x54, 0x64, 0x6f, 0xf6, 0x6f, 0x66, 0xdc, 0x72, 0x71	/* Tdo_softirq */
	.byte 0x0a, 0x08, 0xdd, 0x63, 0xe5, 0xb8, 0x68, 0x0d, 0x90, 0xb0, 0x28	/* T__pfx___local_bh_enable_ip */
	.byte 0x0a, 0xb9, 0xdd, 0x63, 0xe5, 0xb8, 0x68, 0x0d, 0x90, 0xb0, 0x28	/* T__local_bh_enable_ip */
	.byte 0x08, 0xeb, 0xab, 0x71, 0x0d, 0xa2, 0xa6, 0x63, 0x75	/* T__pfx_irq_enter_rcu */
	.byte 0x08, 0x54, 0xab, 0x71, 0x0d, 0xa2, 0xa6, 0x63, 0x75	/* Tirq_enter_rcu */
	.byte 0x05, 0xeb, 0xab, 0x71, 0x0d, 0xa2	/* T__pfx_irq_enter */
	.byte 0x05, 0x54, 0xab, 0x71, 0x0d, 0xa2	/* Tirq_enter */
	.byte 0x09, 0xeb, 0xab, 0x71, 0x5f, 0xcb, 0x9d, 0x72, 0x63, 0x75	/* T__pfx_irq_exit_rcu */
	.byte 0x09, 0x54, 0xab, 0x71, 0x5f, 0xcb, 0x9d, 0x72, 0x63, 0x75	/* Tirq_exit_rcu */
	.byte 0x06, 0xeb, 0xab, 0x71, 0x5f, 0xcb, 0xea	/* T__pfx_irq_exit */
	.byte 0x06, 0x54, 0xab, 0x71, 0x5f, 0xcb, 0xea	/* Tirq_exit */
	.byte 0x10, 0xeb, 0xbc, 0xca, 0xfc, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x5f, 0xab, 0x71, 0x6f, 0x66, 0x66	/* T__pfx_raise_softirq_irqoff */
	.byte 0x10, 0x54, 0xbc, 0xca, 0xfc, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x5f, 0xab, 0x71, 0x6f, 0x66, 0x66	/* Traise_softirq_irqoff */
	.byte 0x0a, 0xeb, 0xbc, 0xca, 0xfc, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71	/* T__pfx_raise_softirq */
	.byte 0x0a, 0x54, 0xbc, 0xca, 0xfc, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71	/* Traise_softirq */
	.byte 0x10, 0x08, 0xbc, 0xca, 0xfc, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x5f, 0xab, 0x71, 0x6f, 0x66, 0x66	/* T__pfx___raise_softirq_irqoff */
	.byte 0x10, 0xb9, 0xbc, 0xca, 0xfc, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x5f, 0xab, 0x71, 0x6f, 0x66, 0x66	/* T__raise_softirq_irqoff */
	.byte 0x09, 0xeb, 0xbe, 0xf1, 0xf6, 0x6f, 0x66, 0xdc, 0x72, 0x71	/* T__pfx_open_softirq */
	.byte 0x09, 0x54, 0xbe, 0xf1, 0xf6, 0x6f, 0x66, 0xdc, 0x72, 0x71	/* Topen_softirq */
	.byte 0x0c, 0xeb, 0xbc, 0xca, 0xfc, 0x6b, 0x00, 0xf5, 0xe9, 0x74, 0x68, 0xf7, 0xc8	/* T__pfx_raise_ktimers_thread */
	.byte 0x0c, 0x54, 0xbc, 0xca, 0xfc, 0x6b, 0x00, 0xf5, 0xe9, 0x74, 0x68, 0xf7, 0xc8	/* Traise_ktimers_thread */
	.byte 0x05, 0xef, 0x72, 0xa9, 0x72, 0x74	/* t__pfx_r_start */
	.byte 0x04, 0xf3, 0xa9, 0x72, 0x74	/* tr_start */
	.byte 0x05, 0xef, 0x72, 0xf6, 0x74, 0xbe	/* t__pfx_r_stop */
	.byte 0x04, 0xf3, 0xf6, 0x74, 0xbe	/* tr_stop */
	.byte 0x0b, 0x74, 0xaf, 0xde, 0xa1, 0xd6, 0xfe, 0x29, 0x6f, 0x98, 0x63, 0x65	/* t__pfx___request_resource */
	.byte 0x0b, 0x74, 0xff, 0xf7, 0xa1, 0xd6, 0xfe, 0x29, 0x6f, 0x98, 0x63, 0x65	/* t__request_resource */
	.byte 0x0b, 0x74, 0xaf, 0xde, 0xc4, 0xbb, 0xfc, 0x29, 0x6f, 0x98, 0x63, 0x65	/* t__pfx___release_resource */
	.byte 0x0b, 0x74, 0xff, 0xf7, 0xc4, 0xbb, 0xfc, 0x29, 0x6f, 0x98, 0x63, 0x65	/* t__release_resource */
	.byte 0x0a, 0xeb, 0xf7, 0xc4, 0xbb, 0xfc, 0x29, 0x6f, 0x98, 0x63, 0x65	/* T__pfx_release_resource */
	.byte 0x0a, 0x54, 0xf7, 0xc4, 0xbb, 0xfc, 0x29, 0x6f, 0x98, 0x63, 0x65	/* Trelease_resource */
	.byte 0x0b, 0xef, 0x66, 0xf8, 0xda, 0x6e, 0xcb, 0xfe, 0xc0, 0xa8, 0x6d, 0x07	/* t__pfx_find_next_iomem_res */
	.byte 0x0b, 0x74, 0x66, 0xf8, 0xda, 0x6e, 0xcb, 0xfe, 0xc0, 0xa8, 0x6d, 0x07	/* tfind_next_iomem_res */
	.byte 0x09, 0xeb, 0xf7, 0x17, 0x1a, 0x29, 0x6f, 0x98, 0x63, 0x65	/* T__pfx_remove_resource */
	.byte 0x09, 0x54, 0xf7, 0x17, 0x1a, 0x29, 0x6f, 0x98, 0x63, 0x65	/* Tremove_resource */
	.byte 0x0a, 0xeb, 0xc8, 0x6a, 0xb1, 0xfe, 0x29, 0x6f, 0x98, 0x63, 0x65	/* T__pfx_adjust_resource */
	.byte 0x0a, 0x54, 0xc8, 0x6a, 0xb1, 0xfe, 0x29, 0x6f, 0x98, 0x63, 0x65	/* Tadjust_resource */
	.byte 0x0b, 0xef, 0xb5, 0x6d, 0x07, 0x6f, 0x98, 0x63, 0xfc, 0x6d, 0xe8, 0xba	/* t__pfx_devm_resource_match */
	.byte 0x0b, 0x74, 0xb5, 0x6d, 0x07, 0x6f, 0x98, 0x63, 0xfc, 0x6d, 0xe8, 0xba	/* tdevm_resource_match */
	.byte 0x0a, 0xef, 0xb5, 0x6d, 0xde, 0x67, 0x69, 0xe7, 0xc1, 0xe8, 0xba	/* t__pfx_devm_region_match */
	.byte 0x0a, 0x74, 0xb5, 0x6d, 0xde, 0x67, 0x69, 0xe7, 0xc1, 0xe8, 0xba	/* tdevm_region_match */
	.byte 0x04, 0xef, 0x72, 0xf6, 0x7c	/* t__pfx_r_show */
	.byte 0x03, 0xf3, 0xf6, 0x7c	/* tr_show */
	.byte 0x0f, 0xeb, 0x29, 0x6f, 0x98, 0x63, 0xfc, 0x6c, 0xca, 0xfe, 0x63, 0xf7, 0x91, 0xf1, 0xf3, 0x79	/* T__pfx_resource_list_create_entry */
	.byte 0x0f, 0x54, 0x29, 0x6f, 0x98, 0x63, 0xfc, 0x6c, 0xca, 0xfe, 0x63, 0xf7, 0x91, 0xf1, 0xf3, 0x79	/* Tresource_list_create_entry */
	.byte 0x0c, 0xeb, 0x29, 0x6f, 0x98, 0x63, 0xfc, 0x6c, 0xca, 0xfe, 0x66, 0xf7, 0x65	/* T__pfx_resource_list_free */
	.byte 0x0c, 0x54, 0x29, 0x6f, 0x98, 0x63, 0xfc, 0x6c, 0xca, 0xfe, 0x66, 0xf7, 0x65	/* Tresource_list_free */
	.byte 0x0c, 0xef, 0xc0, 0xa8, 0x6d, 0xe6, 0xe9, 0xf8, 0x9d, 0x95, 0x3e, 0x74, 0x8e	/* t__pfx_iomem_fs_init_fs_context */
	.byte 0x0c, 0xdc, 0x6f, 0xa8, 0x6d, 0xe6, 0xe9, 0xf8, 0x9d, 0x95, 0x3e, 0x74, 0x8e	/* tiomem_fs_init_fs_context */
	.byte 0x04, 0xef, 0x72, 0xbd, 0x8e	/* t__pfx_r_next */
	.byte 0x03, 0xf3, 0xbd, 0x8e	/* tr_next */
	.byte 0x0e, 0xef, 0x66, 0xf7, 0xfc, 0x29, 0x6f, 0x98, 0x63, 0x65, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__pfx_free_resource.part.0 */
	.byte 0x0e, 0x74, 0x66, 0xf7, 0xfc, 0x29, 0x6f, 0x98, 0x63, 0x65, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* tfree_resource.part.0 */
	.byte 0x09, 0x99, 0xde, 0xc4, 0xbb, 0xfc, 0xf7, 0x67, 0x69, 0xe7	/* T__pfx___release_region */
	.byte 0x09, 0xb9, 0xf7, 0xc4, 0xbb, 0xfc, 0xf7, 0x67, 0x69, 0xe7	/* T__release_region */
	.byte 0x0b, 0xef, 0xb5, 0x6d, 0xde, 0x67, 0x69, 0xe7, 0xde, 0xc4, 0xbb, 0x65	/* t__pfx_devm_region_release */
	.byte 0x0b, 0x74, 0xb5, 0x6d, 0xde, 0x67, 0x69, 0xe7, 0xde, 0xc4, 0xbb, 0x65	/* tdevm_region_release */
	.byte 0x0c, 0xeb, 0xb5, 0x6d, 0xde, 0xc4, 0xbb, 0xfc, 0x29, 0x6f, 0x98, 0x63, 0x65	/* T__pfx_devm_release_resource */
	.byte 0x0c, 0x54, 0xb5, 0x6d, 0xde, 0xc4, 0xbb, 0xfc, 0x29, 0x6f, 0x98, 0x63, 0x65	/* Tdevm_release_resource */
	.byte 0x0b, 0x99, 0x2b, 0x6d, 0xde, 0xc4, 0xbb, 0xfc, 0xf7, 0x67, 0x69, 0xe7	/* T__pfx___devm_release_region */
	.byte 0x0b, 0xb9, 0xb5, 0x6d, 0xde, 0xc4, 0xbb, 0xfc, 0xf7, 0x67, 0x69, 0xe7	/* T__devm_release_region */
	.byte 0x12, 0x74, 0xaf, 0xde, 0x67, 0x69, 0xe7, 0xbf, 0xa2, 0x73, 0xb4, 0x93, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__pfx___region_intersects.constprop.0 */
	.byte 0x12, 0x74, 0xff, 0xf7, 0x67, 0x69, 0xe7, 0xbf, 0xa2, 0x73, 0xb4, 0x93, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__region_intersects.constprop.0 */
	.byte 0x0a, 0xeb, 0xf7, 0x67, 0x69, 0xe7, 0xbf, 0xa2, 0x73, 0xb4, 0x93	/* T__pfx_region_intersects */
	.byte 0x0a, 0x54, 0xf7, 0x67, 0x69, 0xe7, 0xbf, 0xa2, 0x73, 0xb4, 0x93	/* Tregion_intersects */
	.byte 0x09, 0x99, 0xde, 0xa1, 0xd6, 0xfe, 0xf7, 0x67, 0x69, 0xe7	/* T__pfx___request_region */
	.byte 0x09, 0xb9, 0xf7, 0xa1, 0xd6, 0xfe, 0xf7, 0x67, 0x69, 0xe7	/* T__request_region */
	.byte 0x0b, 0x99, 0x2b, 0x6d, 0xde, 0xa1, 0xd6, 0xfe, 0xf7, 0x67, 0x69, 0xe7	/* T__pfx___devm_request_region */
	.byte 0x0b, 0xb9, 0xb5, 0x6d, 0xde, 0xa1, 0xd6, 0xfe, 0xf7, 0x67, 0x69, 0xe7	/* T__devm_request_region */
	.byte 0x0c, 0xef, 0xb5, 0x6d, 0x07, 0x6f, 0x98, 0x63, 0xfc, 0xf7, 0xc4, 0xbb, 0x65	/* t__pfx_devm_resource_release */
	.byte 0x0c, 0x74, 0xb5, 0x6d, 0x07, 0x6f, 0x98, 0x63, 0xfc, 0xf7, 0xc4, 0xbb, 0x65	/* tdevm_resource_release */
	.byte 0x0c, 0xeb, 0xb5, 0x6d, 0xde, 0xa1, 0xd6, 0xfe, 0x29, 0x6f, 0x98, 0x63, 0x65	/* T__pfx_devm_request_resource */
	.byte 0x0c, 0x54, 0xb5, 0x6d, 0xde, 0xa1, 0xd6, 0xfe, 0x29, 0x6f, 0x98, 0x63, 0x65	/* Tdevm_request_resource */
	.byte 0x0c, 0xeb, 0x77, 0xe5, 0x6b, 0x5f, 0xc0, 0xa8, 0x6d, 0x07, 0xed, 0xd6, 0x63	/* T__pfx_walk_iomem_res_desc */
	.byte 0x0c, 0x54, 0x77, 0xe5, 0x6b, 0x5f, 0xc0, 0xa8, 0x6d, 0x07, 0xed, 0xd6, 0x63	/* Twalk_iomem_res_desc */
	.byte 0x09, 0x57, 0xf9, 0x70, 0x83, 0xfc, 0x69, 0xe9, 0xbc, 0x6d	/* W__pfx_page_is_ram */
	.byte 0x08, 0x57, 0x70, 0x83, 0xfc, 0x69, 0xe9, 0xbc, 0x6d	/* Wpage_is_ram */
	.byte 0x0b, 0x74, 0xaf, 0xbf, 0x73, 0xf5, 0xfe, 0x29, 0x6f, 0x98, 0x63, 0x65	/* t__pfx___insert_resource */
	.byte 0x0b, 0x74, 0xff, 0xf8, 0x73, 0xf5, 0xfe, 0x29, 0x6f, 0x98, 0x63, 0x65	/* t__insert_resource */
	.byte 0x11, 0xeb, 0xf8, 0x73, 0xf5, 0xfe, 0x29, 0x6f, 0x98, 0x63, 0xfc, 0xcb, 0x70, 0xd2, 0xda, 0x8a, 0xe6, 0xea	/* T__pfx_insert_resource_expand_to_fit */
	.byte 0x11, 0x54, 0xf8, 0x73, 0xf5, 0xfe, 0x29, 0x6f, 0x98, 0x63, 0xfc, 0xcb, 0x70, 0xd2, 0xda, 0x8a, 0xe6, 0xea	/* Tinsert_resource_expand_to_fit */
	.byte 0x0a, 0xeb, 0xf8, 0x73, 0xf5, 0xfe, 0x29, 0x6f, 0x98, 0x63, 0x65	/* T__pfx_insert_resource */
	.byte 0x0a, 0x54, 0xf8, 0x73, 0xf5, 0xfe, 0x29, 0x6f, 0x98, 0x63, 0x65	/* Tinsert_resource */
	.byte 0x0a, 0xeb, 0xf7, 0xa1, 0xd6, 0xfe, 0x29, 0x6f, 0x98, 0x63, 0x65	/* T__pfx_request_resource */
	.byte 0x0a, 0x54, 0xf7, 0xa1, 0xd6, 0xfe, 0x29, 0x6f, 0x98, 0x63, 0x65	/* Trequest_resource */
	.byte 0x0f, 0x74, 0xaf, 0xde, 0xc4, 0xbb, 0xfc, 0xba, 0x69, 0x6c, 0x64, 0x07, 0x6f, 0x98, 0x63, 0xd6	/* t__pfx___release_child_resources */
	.byte 0x0f, 0x74, 0xff, 0xf7, 0xc4, 0xbb, 0xfc, 0xba, 0x69, 0x6c, 0x64, 0x07, 0x6f, 0x98, 0x63, 0xd6	/* t__release_child_resources */
	.byte 0x0e, 0xeb, 0xf7, 0xc4, 0xbb, 0xfc, 0xba, 0x69, 0x6c, 0x64, 0x07, 0x6f, 0x98, 0x63, 0xd6	/* T__pfx_release_child_resources */
	.byte 0x0e, 0x54, 0xf7, 0xc4, 0xbb, 0xfc, 0xba, 0x69, 0x6c, 0x64, 0x07, 0x6f, 0x98, 0x63, 0xd6	/* Trelease_child_resources */
	.byte 0x0f, 0xeb, 0xf7, 0xa1, 0xd6, 0xfe, 0x29, 0x6f, 0x98, 0x63, 0xfc, 0x40, 0x66, 0x6c, 0xaa, 0x74	/* T__pfx_request_resource_conflict */
	.byte 0x0f, 0x54, 0xf7, 0xa1, 0xd6, 0xfe, 0x29, 0x6f, 0x98, 0x63, 0xfc, 0x40, 0x66, 0x6c, 0xaa, 0x74	/* Trequest_resource_conflict */
	.byte 0x0b, 0xeb, 0x77, 0xe5, 0x6b, 0x7f, 0x73, 0x2c, 0xae, 0xbc, 0x6d, 0x07	/* T__pfx_walk_system_ram_res */
	.byte 0x0b, 0x54, 0x77, 0xe5, 0x6b, 0x7f, 0x73, 0x2c, 0xae, 0xbc, 0x6d, 0x07	/* Twalk_system_ram_res */
	.byte 0x0e, 0xeb, 0x77, 0xe5, 0x6b, 0x7f, 0x73, 0x2c, 0xae, 0xbc, 0x6d, 0xde, 0xe9, 0xf7, 0x76	/* T__pfx_walk_system_ram_res_rev */
	.byte 0x0e, 0x54, 0x77, 0xe5, 0x6b, 0x7f, 0x73, 0x2c, 0xae, 0xbc, 0x6d, 0xde, 0xe9, 0xf7, 0x76	/* Twalk_system_ram_res_rev */
	.byte 0x08, 0xeb, 0x77, 0xe5, 0x6b, 0xc1, 0x65, 0x6d, 0x07	/* T__pfx_walk_mem_res */
	.byte 0x08, 0x54, 0x77, 0xe5, 0x6b, 0xc1, 0x65, 0x6d, 0x07	/* Twalk_mem_res */
	.byte 0x0e, 0xeb, 0x77, 0xe5, 0x6b, 0x7f, 0x73, 0x2c, 0xae, 0xbc, 0xae, 0x72, 0xd2, 0x67, 0x65	/* T__pfx_walk_system_ram_range */
	.byte 0x0e, 0x54, 0x77, 0xe5, 0x6b, 0x7f, 0x73, 0x2c, 0xae, 0xbc, 0xae, 0x72, 0xd2, 0x67, 0x65	/* Twalk_system_ram_range */
	.byte 0x0e, 0x74, 0xaf, 0xe6, 0xf8, 0x64, 0x07, 0x6f, 0x98, 0x63, 0xfc, 0x73, 0x70, 0xf2, 0x65	/* t__pfx___find_resource_space */
	.byte 0x0e, 0x74, 0xff, 0x66, 0xf8, 0x64, 0x07, 0x6f, 0x98, 0x63, 0xfc, 0x73, 0x70, 0xf2, 0x65	/* t__find_resource_space */
	.byte 0x0d, 0xeb, 0x66, 0xf8, 0x64, 0x07, 0x6f, 0x98, 0x63, 0xfc, 0x73, 0x70, 0xf2, 0x65	/* T__pfx_find_resource_space */
	.byte 0x0d, 0x54, 0x66, 0xf8, 0x64, 0x07, 0x6f, 0x98, 0x63, 0xfc, 0x73, 0x70, 0xf2, 0x65	/* Tfind_resource_space */
	.byte 0x0a, 0xef, 0xf7, 0x22, 0x63, 0x91, 0x29, 0x6f, 0x98, 0x63, 0x65	/* t__pfx_reallocate_resource */
	.byte 0x0a, 0x74, 0xf7, 0x22, 0x63, 0x91, 0x29, 0x6f, 0x98, 0x63, 0x65	/* treallocate_resource */
	.byte 0x09, 0xeb, 0x22, 0x63, 0x91, 0x29, 0x6f, 0x98, 0x63, 0x65	/* T__pfx_allocate_resource */
	.byte 0x09, 0x54, 0x22, 0x63, 0x91, 0x29, 0x6f, 0x98, 0x63, 0x65	/* Tallocate_resource */
	.byte 0x0a, 0xeb, 0xdd, 0x6f, 0x6b, 0xcd, 0x07, 0x6f, 0x98, 0x63, 0x65	/* T__pfx_lookup_resource */
	.byte 0x0a, 0x54, 0xdd, 0x6f, 0x6b, 0xcd, 0x07, 0x6f, 0x98, 0x63, 0x65	/* Tlookup_resource */
	.byte 0x0f, 0xeb, 0xf8, 0x73, 0xf5, 0xfe, 0x29, 0x6f, 0x98, 0x63, 0xfc, 0x40, 0x66, 0x6c, 0xaa, 0x74	/* T__pfx_insert_resource_conflict */
	.byte 0x0f, 0x54, 0xf8, 0x73, 0xf5, 0xfe, 0x29, 0x6f, 0x98, 0x63, 0xfc, 0x40, 0x66, 0x6c, 0xaa, 0x74	/* Tinsert_resource_conflict */
	.byte 0x0c, 0xeb, 0x29, 0x6f, 0x98, 0x63, 0xfc, 0xe5, 0x0c, 0x6e, 0x6d, 0xf1, 0x74	/* T__pfx_resource_alignment */
	.byte 0x0c, 0x54, 0x29, 0x6f, 0x98, 0x63, 0xfc, 0xe5, 0x0c, 0x6e, 0x6d, 0xf1, 0x74	/* Tresource_alignment */
	.byte 0x08, 0xeb, 0xc0, 0xa8, 0x6d, 0x86, 0x97, 0x70, 0x8d	/* T__pfx_iomem_get_mapping */
	.byte 0x08, 0x54, 0xc0, 0xa8, 0x6d, 0x86, 0x97, 0x70, 0x8d	/* Tiomem_get_mapping */
	.byte 0x0c, 0xeb, 0xc0, 0xa8, 0xae, 0x97, 0xf6, 0xd2, 0xea, 0x79, 0x25, 0x65, 0xc6	/* T__pfx_iomem_map_sanity_check */
	.byte 0x0c, 0x54, 0xc0, 0xa8, 0xae, 0x97, 0xf6, 0xd2, 0xea, 0x79, 0x25, 0x65, 0xc6	/* Tiomem_map_sanity_check */
	.byte 0x0f, 0xeb, 0x29, 0x6f, 0x98, 0x63, 0xfc, 0x69, 0xe9, 0xcb, 0x63, 0x6c, 0xb1, 0x69, 0x76, 0x65	/* T__pfx_resource_is_exclusive */
	.byte 0x0f, 0x54, 0x29, 0x6f, 0x98, 0x63, 0xfc, 0x69, 0xe9, 0xcb, 0x63, 0x6c, 0xb1, 0x69, 0x76, 0x65	/* Tresource_is_exclusive */
	.byte 0x0d, 0xeb, 0xc0, 0xa8, 0xae, 0x69, 0xe9, 0xcb, 0x63, 0x6c, 0xb1, 0x69, 0x76, 0x65	/* T__pfx_iomem_is_exclusive */
	.byte 0x0d, 0x54, 0xc0, 0xa8, 0xae, 0x69, 0xe9, 0xcb, 0x63, 0x6c, 0xb1, 0x69, 0x76, 0x65	/* Tiomem_is_exclusive */
	.byte 0x0d, 0xef, 0x64, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0xb4, 0x3e, 0x76	/* t__pfx_do_proc_dointvec_conv */
	.byte 0x0d, 0x74, 0x64, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0xb4, 0x3e, 0x76	/* tdo_proc_dointvec_conv */
	.byte 0x0e, 0xef, 0x64, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0x75, 0xb3, 0x76, 0xb4, 0x3e, 0x76	/* t__pfx_do_proc_douintvec_conv */
	.byte 0x0e, 0x74, 0x64, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0x75, 0xb3, 0x76, 0xb4, 0x3e, 0x76	/* tdo_proc_douintvec_conv */
	.byte 0x13, 0xef, 0x64, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0x75, 0xb3, 0x76, 0x65, 0xc9, 0x6d, 0xf8, 0xd9, 0x78, 0x3e, 0x76	/* t__pfx_do_proc_douintvec_minmax_conv */
	.byte 0x13, 0x74, 0x64, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0x75, 0xb3, 0x76, 0x65, 0xc9, 0x6d, 0xf8, 0xd9, 0x78, 0x3e, 0x76	/* tdo_proc_douintvec_minmax_conv */
	.byte 0x13, 0xef, 0x64, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0x65, 0xc9, 0x6a, 0x69, 0x66, 0xa5, 0xd6, 0x3e, 0x76	/* t__pfx_do_proc_dointvec_jiffies_conv */
	.byte 0x13, 0x74, 0x64, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0x65, 0xc9, 0x6a, 0x69, 0x66, 0xa5, 0xd6, 0x3e, 0x76	/* tdo_proc_dointvec_jiffies_conv */
	.byte 0x15, 0xef, 0x64, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0x65, 0xc9, 0x6d, 0xe9, 0x6a, 0x69, 0x66, 0xa5, 0xd6, 0x3e, 0x76	/* t__pfx_do_proc_dointvec_ms_jiffies_conv */
	.byte 0x15, 0x74, 0x64, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0x65, 0xc9, 0x6d, 0xe9, 0x6a, 0x69, 0x66, 0xa5, 0xd6, 0x3e, 0x76	/* tdo_proc_dointvec_ms_jiffies_conv */
	.byte 0x18, 0xef, 0x64, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0x65, 0xc9, 0xb1, 0xf5, 0x68, 0x7a, 0x5f, 0x6a, 0x69, 0x66, 0xa5, 0xd6, 0x3e, 0x76	/* t__pfx_do_proc_dointvec_userhz_jiffies_conv */
	.byte 0x18, 0x74, 0x64, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0x65, 0xc9, 0xb1, 0xf5, 0x68, 0x7a, 0x5f, 0x6a, 0x69, 0x66, 0xa5, 0xd6, 0x3e, 0x76	/* tdo_proc_dointvec_userhz_jiffies_conv */
	.byte 0x10, 0xef, 0x70, 0xe3, 0xc9, 0x67, 0xe2, 0x6c, 0xe7, 0x67, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__pfx_proc_get_long.constprop.0 */
	.byte 0x0f, 0xce, 0xe3, 0xc9, 0x67, 0xe2, 0x6c, 0xe7, 0x67, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* tproc_get_long.constprop.0 */
	.byte 0x1a, 0xef, 0x70, 0xe3, 0x63, 0xe6, 0xab, 0x73, 0xfe, 0x70, 0x6f, 0xe9, 0x6e, 0xe7, 0x5f, 0x7a, 0xf5, 0x6f, 0x5f, 0x0c, 0x6e, 0x6f, 0xf7, 0x2e, 0xca, 0xbc, 0x7e	/* t__pfx_proc_first_pos_non_zero_ignore.isra.0 */
	.byte 0x19, 0xce, 0xe3, 0x63, 0xe6, 0xab, 0x73, 0xfe, 0x70, 0x6f, 0xe9, 0x6e, 0xe7, 0x5f, 0x7a, 0xf5, 0x6f, 0x5f, 0x0c, 0x6e, 0x6f, 0xf7, 0x2e, 0xca, 0xbc, 0x7e	/* tproc_first_pos_non_zero_ignore.isra.0 */
	.byte 0x09, 0xeb, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0x73, 0xf3, 0x8d	/* T__pfx_proc_dostring */
	.byte 0x09, 0x54, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0x73, 0xf3, 0x8d	/* Tproc_dostring */
	.byte 0x12, 0xef, 0x64, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0x65, 0xc9, 0x6d, 0xf8, 0xd9, 0x78, 0x3e, 0x76	/* t__pfx_do_proc_dointvec_minmax_conv */
	.byte 0x12, 0x74, 0x64, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0x65, 0xc9, 0x6d, 0xf8, 0xd9, 0x78, 0x3e, 0x76	/* tdo_proc_dointvec_minmax_conv */
	.byte 0x1a, 0xef, 0x64, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0x65, 0xc9, 0x6d, 0xe9, 0x6a, 0x69, 0x66, 0xa5, 0x65, 0xe9, 0x6d, 0xf8, 0xd9, 0x78, 0x3e, 0x76	/* t__pfx_do_proc_dointvec_ms_jiffies_minmax_conv */
	.byte 0x1a, 0x74, 0x64, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0x65, 0xc9, 0x6d, 0xe9, 0x6a, 0x69, 0x66, 0xa5, 0x65, 0xe9, 0x6d, 0xf8, 0xd9, 0x78, 0x3e, 0x76	/* tdo_proc_dointvec_ms_jiffies_minmax_conv */
	.byte 0x0e, 0xeb, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0x5f, 0x6c, 0xc5, 0x67, 0xfc, 0x62, 0xea, 0x97	/* T__pfx_proc_do_large_bitmap */
	.byte 0x0e, 0x54, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0x5f, 0x6c, 0xc5, 0x67, 0xfc, 0x62, 0xea, 0x97	/* Tproc_do_large_bitmap */
	.byte 0x13, 0x74, 0xaf, 0xed, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0x02, 0xe7, 0x67, 0x76, 0x65, 0xc9, 0x6d, 0xf8, 0xd9, 0x78	/* t__pfx___do_proc_doulongvec_minmax */
	.byte 0x13, 0x74, 0xff, 0x64, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0x02, 0xe7, 0x67, 0x76, 0x65, 0xc9, 0x6d, 0xf8, 0xd9, 0x78	/* t__do_proc_doulongvec_minmax */
	.byte 0x10, 0xeb, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0x02, 0xe7, 0x67, 0x76, 0x65, 0xc9, 0x6d, 0xf8, 0xd9, 0x78	/* T__pfx_proc_doulongvec_minmax */
	.byte 0x10, 0x54, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0x02, 0xe7, 0x67, 0x76, 0x65, 0xc9, 0x6d, 0xf8, 0xd9, 0x78	/* Tproc_doulongvec_minmax */
	.byte 0x18, 0xeb, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0x02, 0xe7, 0x67, 0x76, 0x65, 0xc9, 0x6d, 0xe9, 0x6a, 0x69, 0x66, 0xa5, 0x65, 0xe9, 0x6d, 0xf8, 0xd9, 0x78	/* T__pfx_proc_doulongvec_ms_jiffies_minmax */
	.byte 0x18, 0x54, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0x02, 0xe7, 0x67, 0x76, 0x65, 0xc9, 0x6d, 0xe9, 0x6a, 0x69, 0x66, 0xa5, 0x65, 0xe9, 0x6d, 0xf8, 0xd9, 0x78	/* Tproc_doulongvec_ms_jiffies_minmax */
	.byte 0x06, 0xef, 0x70, 0xe3, 0xc9, 0xf4, 0xb3	/* t__pfx_proc_taint */
	.byte 0x05, 0xce, 0xe3, 0xc9, 0xf4, 0xb3	/* tproc_taint */
	.byte 0x0d, 0x74, 0xaf, 0xed, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0x75, 0xb3, 0x76, 0xb4	/* t__pfx___do_proc_douintvec */
	.byte 0x0d, 0x74, 0xff, 0x64, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0x75, 0xb3, 0x76, 0xb4	/* t__do_proc_douintvec */
	.byte 0x0a, 0xeb, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0x75, 0xb3, 0x76, 0xb4	/* T__pfx_proc_douintvec */
	.byte 0x0a, 0x54, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0x75, 0xb3, 0x76, 0xb4	/* Tproc_douintvec */
	.byte 0x0f, 0xeb, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0x75, 0xb3, 0x76, 0x65, 0xc9, 0x6d, 0xf8, 0xd9, 0x78	/* T__pfx_proc_douintvec_minmax */
	.byte 0x0f, 0x54, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0x75, 0xb3, 0x76, 0x65, 0xc9, 0x6d, 0xf8, 0xd9, 0x78	/* Tproc_douintvec_minmax */
	.byte 0x0f, 0xeb, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0x75, 0x38, 0x76, 0x65, 0xc9, 0x6d, 0xf8, 0xd9, 0x78	/* T__pfx_proc_dou8vec_minmax */
	.byte 0x0f, 0x54, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0x75, 0x38, 0x76, 0x65, 0xc9, 0x6d, 0xf8, 0xd9, 0x78	/* Tproc_dou8vec_minmax */
	.byte 0x0c, 0x74, 0xaf, 0xed, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0xb4	/* t__pfx___do_proc_dointvec */
	.byte 0x0c, 0x74, 0xff, 0x64, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0xb4	/* t__do_proc_dointvec */
	.byte 0x09, 0xeb, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0xb4	/* T__pfx_proc_dointvec */
	.byte 0x09, 0x54, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0xb4	/* Tproc_dointvec */
	.byte 0x0e, 0xeb, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0x65, 0xc9, 0x6d, 0xf8, 0xd9, 0x78	/* T__pfx_proc_dointvec_minmax */
	.byte 0x0e, 0x54, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0x65, 0xc9, 0x6d, 0xf8, 0xd9, 0x78	/* Tproc_dointvec_minmax */
	.byte 0x0f, 0xeb, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0x65, 0xc9, 0x6a, 0x69, 0x66, 0xa5, 0xd6	/* T__pfx_proc_dointvec_jiffies */
	.byte 0x0f, 0x54, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0x65, 0xc9, 0x6a, 0x69, 0x66, 0xa5, 0xd6	/* Tproc_dointvec_jiffies */
	.byte 0x14, 0xeb, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0x65, 0xc9, 0xb1, 0xf5, 0x68, 0x7a, 0x5f, 0x6a, 0x69, 0x66, 0xa5, 0xd6	/* T__pfx_proc_dointvec_userhz_jiffies */
	.byte 0x14, 0x54, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0x65, 0xc9, 0xb1, 0xf5, 0x68, 0x7a, 0x5f, 0x6a, 0x69, 0x66, 0xa5, 0xd6	/* Tproc_dointvec_userhz_jiffies */
	.byte 0x11, 0xeb, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0x65, 0xc9, 0x6d, 0xe9, 0x6a, 0x69, 0x66, 0xa5, 0xd6	/* T__pfx_proc_dointvec_ms_jiffies */
	.byte 0x11, 0x54, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0x65, 0xc9, 0x6d, 0xe9, 0x6a, 0x69, 0x66, 0xa5, 0xd6	/* Tproc_dointvec_ms_jiffies */
	.byte 0x0a, 0xef, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0xf0, 0xc8, 0xec, 0x9f	/* t__pfx_proc_do_cad_pid */
	.byte 0x09, 0xce, 0xe3, 0x63, 0xed, 0x6f, 0xf0, 0xc8, 0xec, 0x9f	/* tproc_do_cad_pid */
	.byte 0x0d, 0xef, 0xe1, 0x73, 0x72, 0x71, 0x7f, 0x73, 0x63, 0x23, 0xa3, 0x05, 0x6c, 0xf5	/* t__pfx_sysrq_sysctl_handler */
	.byte 0x0d, 0x74, 0xe1, 0x73, 0x72, 0x71, 0x7f, 0x73, 0x63, 0x23, 0xa3, 0x05, 0x6c, 0xf5	/* tsysrq_sysctl_handler */
	.byte 0x09, 0xeb, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0x62, 0x6f, 0xa0	/* T__pfx_proc_dobool */
	.byte 0x09, 0x54, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0x62, 0x6f, 0xa0	/* Tproc_dobool */
	.byte 0x0c, 0xeb, 0x64, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0x75, 0xb3, 0x76, 0xb4	/* T__pfx_do_proc_douintvec */
	.byte 0x0c, 0x54, 0x64, 0x6f, 0xec, 0xe3, 0x63, 0xed, 0x6f, 0x75, 0xb3, 0x76, 0xb4	/* Tdo_proc_douintvec */
	.byte 0x16, 0xeb, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0x65, 0xc9, 0x6d, 0xe9, 0x6a, 0x69, 0x66, 0xa5, 0x65, 0xe9, 0x6d, 0xf8, 0xd9, 0x78	/* T__pfx_proc_dointvec_ms_jiffies_minmax */
	.byte 0x16, 0x54, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0xb3, 0x76, 0x65, 0xc9, 0x6d, 0xe9, 0x6a, 0x69, 0x66, 0xa5, 0x65, 0xe9, 0x6d, 0xf8, 0xd9, 0x78	/* Tproc_dointvec_ms_jiffies_minmax */
	.byte 0x0c, 0xeb, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0xa9, 0xdc, 0xc9, 0x6b, 0x65, 0x79	/* T__pfx_proc_do_static_key */
	.byte 0x0c, 0x54, 0x70, 0xe3, 0x63, 0xed, 0x6f, 0xa9, 0xdc, 0xc9, 0x6b, 0x65, 0x79	/* Tproc_do_static_key */
	.byte 0x0c, 0xef, 0x63, 0x61, 0x70, 0x5f, 0x76, 0xe5, 0x9f, 0x91, 0xd9, 0x67, 0xaa	/* t__pfx_cap_validate_magic */
	.byte 0x0b, 0x26, 0x61, 0x70, 0x5f, 0x76, 0xe5, 0x9f, 0x91, 0xd9, 0x67, 0xaa	/* tcap_validate_magic */
	.byte 0x0b, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0x73, 0xf0, 0x61, 0x70, 0x73, 0xd4	/* t__pfx___do_sys_capset */
	.byte 0x0b, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0x73, 0xf0, 0x61, 0x70, 0x73, 0xd4	/* t__do_sys_capset */
	.byte 0x0a, 0xeb, 0xa5, 0xb0, 0x6e, 0x73, 0xf0, 0x61, 0x70, 0x90, 0xc4	/* T__pfx_file_ns_capable */
	.byte 0x0a, 0x54, 0xa5, 0xb0, 0x6e, 0x73, 0xf0, 0x61, 0x70, 0x90, 0xc4	/* Tfile_ns_capable */
	.byte 0x0b, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0x73, 0xf0, 0x61, 0x70, 0x67, 0xd4	/* t__pfx___do_sys_capget */
	.byte 0x0b, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0x73, 0xf0, 0x61, 0x70, 0x67, 0xd4	/* t__do_sys_capget */
	.byte 0x0b, 0xeb, 0x68, 0xbb, 0xf0, 0x61, 0x70, 0x90, 0x69, 0x6c, 0xea, 0x79	/* T__pfx_has_capability */
	.byte 0x0b, 0x54, 0x68, 0xbb, 0xf0, 0x61, 0x70, 0x90, 0x69, 0x6c, 0xea, 0x79	/* Thas_capability */
	.byte 0x11, 0xeb, 0x68, 0xbb, 0xf0, 0x61, 0x70, 0x90, 0x69, 0x6c, 0xea, 0x79, 0xbd, 0x6f, 0x61, 0x75, 0x64, 0xea	/* T__pfx_has_capability_noaudit */
	.byte 0x11, 0x54, 0x68, 0xbb, 0xf0, 0x61, 0x70, 0x90, 0x69, 0x6c, 0xea, 0x79, 0xbd, 0x6f, 0x61, 0x75, 0x64, 0xea	/* Thas_capability_noaudit */
	.byte 0x0f, 0xeb, 0x63, 0x61, 0x70, 0x90, 0xb0, 0x77, 0x72, 0xfe, 0xf8, 0x16, 0x75, 0x9f, 0x67, 0x9f	/* T__pfx_capable_wrt_inode_uidgid */
	.byte 0x0f, 0x54, 0x63, 0x61, 0x70, 0x90, 0xb0, 0x77, 0x72, 0xfe, 0xf8, 0x16, 0x75, 0x9f, 0x67, 0x9f	/* Tcapable_wrt_inode_uidgid */
	.byte 0x08, 0xeb, 0x6e, 0x73, 0xf0, 0x61, 0x70, 0x90, 0xc4	/* T__pfx_ns_capable */
	.byte 0x08, 0x54, 0x6e, 0x73, 0xf0, 0x61, 0x70, 0x90, 0xc4	/* Tns_capable */
	.byte 0x0e, 0xeb, 0x6e, 0x73, 0xf0, 0x61, 0x70, 0x90, 0xb0, 0x6e, 0x6f, 0x61, 0x75, 0x64, 0xea	/* T__pfx_ns_capable_noaudit */
	.byte 0x0e, 0x54, 0x6e, 0x73, 0xf0, 0x61, 0x70, 0x90, 0xb0, 0x6e, 0x6f, 0x61, 0x75, 0x64, 0xea	/* Tns_capable_noaudit */
	.byte 0x0c, 0xeb, 0x6e, 0x73, 0xf0, 0x61, 0x70, 0x90, 0xb0, 0x73, 0x65, 0xdc, 0x64	/* T__pfx_ns_capable_setid */
	.byte 0x0c, 0x54, 0x6e, 0x73, 0xf0, 0x61, 0x70, 0x90, 0xb0, 0x73, 0x65, 0xdc, 0x64	/* Tns_capable_setid */
	.byte 0x06, 0xeb, 0x63, 0x61, 0x70, 0x90, 0xc4	/* T__pfx_capable */
	.byte 0x06, 0x54, 0x63, 0x61, 0x70, 0x90, 0xc4	/* Tcapable */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf0, 0x61, 0x70, 0x67, 0xd4	/* T__pfx___x64_sys_capget */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf0, 0x61, 0x70, 0x67, 0xd4	/* T__x64_sys_capget */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf0, 0x61, 0x70, 0x67, 0xd4	/* T__pfx___ia32_sys_capget */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf0, 0x61, 0x70, 0x67, 0xd4	/* T__ia32_sys_capget */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf0, 0x61, 0x70, 0x73, 0xd4	/* T__pfx___x64_sys_capset */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf0, 0x61, 0x70, 0x73, 0xd4	/* T__x64_sys_capset */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf0, 0x61, 0x70, 0x73, 0xd4	/* T__pfx___ia32_sys_capset */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf0, 0x61, 0x70, 0x73, 0xd4	/* T__ia32_sys_capset */
	.byte 0x0e, 0xeb, 0x68, 0x61, 0xe9, 0x6e, 0x73, 0xf0, 0x61, 0x70, 0x90, 0x69, 0x6c, 0xea, 0x79	/* T__pfx_has_ns_capability */
	.byte 0x0e, 0x54, 0x68, 0x61, 0xe9, 0x6e, 0x73, 0xf0, 0x61, 0x70, 0x90, 0x69, 0x6c, 0xea, 0x79	/* Thas_ns_capability */
	.byte 0x14, 0xeb, 0x68, 0x61, 0xe9, 0x6e, 0x73, 0xf0, 0x61, 0x70, 0x90, 0x69, 0x6c, 0xea, 0x79, 0xbd, 0x6f, 0x61, 0x75, 0x64, 0xea	/* T__pfx_has_ns_capability_noaudit */
	.byte 0x14, 0x54, 0x68, 0x61, 0xe9, 0x6e, 0x73, 0xf0, 0x61, 0x70, 0x90, 0x69, 0x6c, 0xea, 0x79, 0xbd, 0x6f, 0x61, 0x75, 0x64, 0xea	/* Thas_ns_capability_noaudit */
	.byte 0x13, 0xeb, 0x70, 0x72, 0x69, 0x76, 0x69, 0xc4, 0x67, 0x65, 0xda, 0x77, 0x72, 0xfe, 0xf8, 0x16, 0x75, 0x9f, 0x67, 0x9f	/* T__pfx_privileged_wrt_inode_uidgid */
	.byte 0x13, 0x54, 0x70, 0x72, 0x69, 0x76, 0x69, 0xc4, 0x67, 0x65, 0xda, 0x77, 0x72, 0xfe, 0xf8, 0x16, 0x75, 0x9f, 0x67, 0x9f	/* Tprivileged_wrt_inode_uidgid */
	.byte 0x09, 0xeb, 0x70, 0xdf, 0xf5, 0xf0, 0x61, 0x70, 0x90, 0xc4	/* T__pfx_ptracer_capable */
	.byte 0x09, 0x54, 0x70, 0xdf, 0xf5, 0xf0, 0x61, 0x70, 0x90, 0xc4	/* Tptracer_capable */
	.byte 0x0f, 0xef, 0x70, 0xc3, 0x67, 0xe2, 0xe1, 0x73, 0x63, 0x5d, 0xbf, 0x66, 0x6f, 0x0d, 0xf3, 0x79	/* t__pfx_ptrace_get_syscall_info_entry */
	.byte 0x0e, 0xce, 0xc3, 0x67, 0xe2, 0xe1, 0x73, 0x63, 0x5d, 0xbf, 0x66, 0x6f, 0x0d, 0xf3, 0x79	/* tptrace_get_syscall_info_entry */
	.byte 0x0b, 0xef, 0x70, 0xc3, 0xe4, 0x66, 0xf7, 0x65, 0x7a, 0xfc, 0xdf, 0x9e	/* t__pfx_ptrace_unfreeze_traced */
	.byte 0x0a, 0xce, 0xc3, 0xe4, 0x66, 0xf7, 0x65, 0x7a, 0xfc, 0xdf, 0x9e	/* tptrace_unfreeze_traced */
	.byte 0x0a, 0xef, 0x70, 0xc3, 0xba, 0x65, 0xc6, 0x5f, 0xe8, 0xf4, 0xba	/* t__pfx_ptrace_check_attach */
	.byte 0x09, 0xce, 0xc3, 0xba, 0x65, 0xc6, 0x5f, 0xe8, 0xf4, 0xba	/* tptrace_check_attach */
	.byte 0x0c, 0xef, 0x70, 0xc3, 0x67, 0xe2, 0xe1, 0x73, 0x63, 0x5d, 0xbf, 0x66, 0x6f	/* t__pfx_ptrace_get_syscall_info */
	.byte 0x0b, 0xce, 0xc3, 0x67, 0xe2, 0xe1, 0x73, 0x63, 0x5d, 0xbf, 0x66, 0x6f	/* tptrace_get_syscall_info */
	.byte 0x07, 0xef, 0x70, 0xc3, 0xf7, 0x67, 0x73, 0xd4	/* t__pfx_ptrace_regset */
	.byte 0x06, 0xce, 0xc3, 0xf7, 0x67, 0x73, 0xd4	/* tptrace_regset */
	.byte 0x0b, 0xef, 0x70, 0xc3, 0x70, 0x8b, 0x6b, 0xf6, 0x0c, 0xf8, 0x66, 0x6f	/* t__pfx_ptrace_peek_siginfo */
	.byte 0x0a, 0xce, 0xc3, 0x70, 0x8b, 0x6b, 0xf6, 0x0c, 0xf8, 0x66, 0x6f	/* tptrace_peek_siginfo */
	.byte 0x0a, 0x74, 0xaf, 0xec, 0xc3, 0xd9, 0x1d, 0xf2, 0x63, 0xd6, 0x73	/* t__pfx___ptrace_may_access */
	.byte 0x09, 0x74, 0xfd, 0xc3, 0xd9, 0x1d, 0xf2, 0x63, 0xd6, 0x73	/* t__ptrace_may_access */
	.byte 0x09, 0xeb, 0x70, 0xc3, 0xf2, 0x63, 0xd6, 0xe9, 0x76, 0x6d	/* T__pfx_ptrace_access_vm */
	.byte 0x09, 0x54, 0x70, 0xc3, 0xf2, 0x63, 0xd6, 0xe9, 0x76, 0x6d	/* Tptrace_access_vm */
	.byte 0x04, 0x99, 0xec, 0xc3, 0x01	/* T__pfx___ptrace_link */
	.byte 0x04, 0x54, 0xfd, 0xc3, 0x01	/* T__ptrace_link */
	.byte 0x05, 0xef, 0x70, 0xc3, 0x94, 0xa8	/* t__pfx_ptrace_traceme */
	.byte 0x04, 0xce, 0xc3, 0x94, 0xa8	/* tptrace_traceme */
	.byte 0x06, 0xef, 0x70, 0xc3, 0xe8, 0xf4, 0xba	/* t__pfx_ptrace_attach */
	.byte 0x05, 0xce, 0xc3, 0xe8, 0xf4, 0xba	/* tptrace_attach */
	.byte 0x05, 0x99, 0xec, 0xc3, 0xe4, 0x01	/* T__pfx___ptrace_unlink */
	.byte 0x05, 0x54, 0xfd, 0xc3, 0xe4, 0x01	/* T__ptrace_unlink */
	.byte 0x08, 0x74, 0xaf, 0xec, 0xc3, 0x64, 0x65, 0xf4, 0xba	/* t__pfx___ptrace_detach */
	.byte 0x07, 0x74, 0xfd, 0xc3, 0x64, 0x65, 0xf4, 0xba	/* t__ptrace_detach */
	.byte 0x09, 0xeb, 0x70, 0xc3, 0xd9, 0x1d, 0xf2, 0x63, 0xd6, 0x73	/* T__pfx_ptrace_may_access */
	.byte 0x09, 0x54, 0x70, 0xc3, 0xd9, 0x1d, 0xf2, 0x63, 0xd6, 0x73	/* Tptrace_may_access */
	.byte 0x05, 0xeb, 0xcb, 0x9d, 0x70, 0x94	/* T__pfx_exit_ptrace */
	.byte 0x05, 0x54, 0xcb, 0x9d, 0x70, 0x94	/* Texit_ptrace */
	.byte 0x07, 0xeb, 0x70, 0xc3, 0xf7, 0xc8, 0x64, 0x0a	/* T__pfx_ptrace_readdata */
	.byte 0x07, 0x54, 0x70, 0xc3, 0xf7, 0xc8, 0x64, 0x0a	/* Tptrace_readdata */
	.byte 0x07, 0xeb, 0x70, 0xc3, 0x77, 0x3c, 0x9e, 0x0a	/* T__pfx_ptrace_writedata */
	.byte 0x07, 0x54, 0x70, 0xc3, 0x77, 0x3c, 0x9e, 0x0a	/* Tptrace_writedata */
	.byte 0x06, 0xeb, 0x70, 0xc3, 0xf7, 0xa1, 0x60	/* T__pfx_ptrace_request */
	.byte 0x06, 0x54, 0x70, 0xc3, 0xf7, 0xa1, 0x60	/* Tptrace_request */
	.byte 0x08, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x94	/* T__pfx___x64_sys_ptrace */
	.byte 0x08, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x94	/* T__x64_sys_ptrace */
	.byte 0x09, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x94	/* T__pfx___ia32_sys_ptrace */
	.byte 0x09, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x94	/* T__ia32_sys_ptrace */
	.byte 0x0c, 0xeb, 0x67, 0xf1, 0xf5, 0xaa, 0xec, 0xc3, 0x70, 0x8b, 0x6b, 0x64, 0x0a	/* T__pfx_generic_ptrace_peekdata */
	.byte 0x0c, 0x54, 0x67, 0xf1, 0xf5, 0xaa, 0xec, 0xc3, 0x70, 0x8b, 0x6b, 0x64, 0x0a	/* Tgeneric_ptrace_peekdata */
	.byte 0x0c, 0xeb, 0x67, 0xf1, 0xf5, 0xaa, 0xec, 0xc3, 0x70, 0x6f, 0x6b, 0x9e, 0x0a	/* T__pfx_generic_ptrace_pokedata */
	.byte 0x0c, 0x54, 0x67, 0xf1, 0xf5, 0xaa, 0xec, 0xc3, 0x70, 0x6f, 0x6b, 0x9e, 0x0a	/* Tgeneric_ptrace_pokedata */
	.byte 0x0a, 0xeb, 0x03, 0xb6, 0x61, 0xfe, 0x70, 0xc3, 0xf7, 0xa1, 0x60	/* T__pfx_compat_ptrace_request */
	.byte 0x0a, 0x54, 0x03, 0xb6, 0x61, 0xfe, 0x70, 0xc3, 0xf7, 0xa1, 0x60	/* Tcompat_ptrace_request */
	.byte 0x0d, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0xec, 0x94	/* T__pfx___ia32_compat_sys_ptrace */
	.byte 0x0d, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0xec, 0x94	/* T__ia32_compat_sys_ptrace */
	.byte 0x06, 0xeb, 0x66, 0xf7, 0xfc, 0x75, 0x9f	/* T__pfx_free_uid */
	.byte 0x06, 0x54, 0x66, 0xf7, 0xfc, 0x75, 0x9f	/* Tfree_uid */
	.byte 0x0e, 0xef, 0x75, 0x69, 0xda, 0x68, 0xbb, 0x68, 0xe6, 0xf8, 0x64, 0x2e, 0xca, 0xbc, 0x7e	/* t__pfx_uid_hash_find.isra.0 */
	.byte 0x0e, 0x74, 0x75, 0x69, 0xda, 0x68, 0xbb, 0x68, 0xe6, 0xf8, 0x64, 0x2e, 0xca, 0xbc, 0x7e	/* tuid_hash_find.isra.0 */
	.byte 0x06, 0xeb, 0x66, 0xf8, 0xda, 0xb1, 0xf5	/* T__pfx_find_user */
	.byte 0x06, 0x54, 0x66, 0xf8, 0xda, 0xb1, 0xf5	/* Tfind_user */
	.byte 0x05, 0xeb, 0x22, 0xc9, 0x75, 0x9f	/* T__pfx_alloc_uid */
	.byte 0x05, 0x54, 0x22, 0xc9, 0x75, 0x9f	/* Talloc_uid */
	.byte 0x0a, 0x08, 0x18, 0xf6, 0x0c, 0x6e, 0xe5, 0xc7, 0xf1, 0xf5, 0x14	/* T__pfx___traceiter_signal_generate */
	.byte 0x0a, 0xb9, 0x18, 0xf6, 0x0c, 0x6e, 0xe5, 0xc7, 0xf1, 0xf5, 0x14	/* T__traceiter_signal_generate */
	.byte 0x0b, 0x99, 0xec, 0x10, 0xf6, 0x0c, 0x6e, 0xe5, 0xc7, 0xf1, 0xf5, 0x14	/* T__pfx___probestub_signal_generate */
	.byte 0x0b, 0x54, 0xfd, 0x10, 0xf6, 0x0c, 0x6e, 0xe5, 0xc7, 0xf1, 0xf5, 0x14	/* T__probestub_signal_generate */
	.byte 0x0a, 0x08, 0x18, 0xf6, 0x0c, 0x6e, 0xe5, 0xed, 0xdb, 0x69, 0x0b	/* T__pfx___traceiter_signal_deliver */
	.byte 0x0a, 0xb9, 0x18, 0xf6, 0x0c, 0x6e, 0xe5, 0xed, 0xdb, 0x69, 0x0b	/* T__traceiter_signal_deliver */
	.byte 0x0b, 0x99, 0xec, 0x10, 0xf6, 0x0c, 0x6e, 0xe5, 0xed, 0xdb, 0x69, 0x0b	/* T__pfx___probestub_signal_deliver */
	.byte 0x0b, 0x54, 0xfd, 0x10, 0xf6, 0x0c, 0x6e, 0xe5, 0xed, 0xdb, 0x69, 0x0b	/* T__probestub_signal_deliver */
	.byte 0x0c, 0xef, 0x19, 0x3b, 0xc3, 0x85, 0x67, 0x6e, 0xe5, 0xc7, 0xf1, 0xf5, 0x14	/* t__pfx_perf_trace_signal_generate */
	.byte 0x0c, 0xce, 0xf5, 0x3b, 0xc3, 0x85, 0x67, 0x6e, 0xe5, 0xc7, 0xf1, 0xf5, 0x14	/* tperf_trace_signal_generate */
	.byte 0x0c, 0xef, 0x19, 0x3b, 0xc3, 0x85, 0x67, 0x6e, 0xe5, 0xed, 0xdb, 0x69, 0x0b	/* t__pfx_perf_trace_signal_deliver */
	.byte 0x0c, 0xce, 0xf5, 0x3b, 0xc3, 0x85, 0x67, 0x6e, 0xe5, 0xed, 0xdb, 0x69, 0x0b	/* tperf_trace_signal_deliver */
	.byte 0x0c, 0xef, 0x7d, 0x7b, 0xcc, 0x85, 0x67, 0x6e, 0xe5, 0xc7, 0xf1, 0xf5, 0x14	/* t__pfx_trace_event_raw_event_signal_generate */
	.byte 0x0c, 0x74, 0x7d, 0x7b, 0xcc, 0x85, 0x67, 0x6e, 0xe5, 0xc7, 0xf1, 0xf5, 0x14	/* ttrace_event_raw_event_signal_generate */
	.byte 0x0c, 0xef, 0x7d, 0x7b, 0xcc, 0x85, 0x67, 0x6e, 0xe5, 0xed, 0xdb, 0x69, 0x0b	/* t__pfx_trace_event_raw_event_signal_deliver */
	.byte 0x0c, 0x74, 0x7d, 0x7b, 0xcc, 0x85, 0x67, 0x6e, 0xe5, 0xed, 0xdb, 0x69, 0x0b	/* ttrace_event_raw_event_signal_deliver */
	.byte 0x0f, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x85, 0x67, 0x6e, 0xe5, 0xc7, 0xf1, 0xf5, 0x14	/* t__pfx_trace_raw_output_signal_generate */
	.byte 0x0f, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x85, 0x67, 0x6e, 0xe5, 0xc7, 0xf1, 0xf5, 0x14	/* ttrace_raw_output_signal_generate */
	.byte 0x0f, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x85, 0x67, 0x6e, 0xe5, 0xed, 0xdb, 0x69, 0x0b	/* t__pfx_trace_raw_output_signal_deliver */
	.byte 0x0f, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x85, 0x67, 0x6e, 0xe5, 0xed, 0xdb, 0x69, 0x0b	/* ttrace_raw_output_signal_deliver */
	.byte 0x08, 0xef, 0x85, 0x67, 0x86, 0x75, 0x03, 0xe4, 0x93	/* t__pfx_sig_get_ucounts */
	.byte 0x07, 0x93, 0x0c, 0x86, 0x75, 0x03, 0xe4, 0x93	/* tsig_get_ucounts */
	.byte 0x0f, 0xef, 0xba, 0x65, 0xc6, 0x5f, 0x6b, 0x69, 0x6c, 0x6c, 0xec, 0xf5, 0x6d, 0xca, 0x85, 0xe7	/* t__pfx_check_kill_permission */
	.byte 0x0f, 0x74, 0xba, 0x65, 0xc6, 0x5f, 0x6b, 0x69, 0x6c, 0x6c, 0xec, 0xf5, 0x6d, 0xca, 0x85, 0xe7	/* tcheck_kill_permission */
	.byte 0x16, 0xef, 0x70, 0x6f, 0x73, 0xfe, 0x63, 0xbe, 0x79, 0xf6, 0x0c, 0xf8, 0x66, 0x6f, 0xe6, 0xe3, 0xae, 0xb1, 0xf5, 0x2e, 0xca, 0xbc, 0x7e	/* t__pfx_post_copy_siginfo_from_user.isra.0 */
	.byte 0x15, 0xce, 0x6f, 0x73, 0xfe, 0x63, 0xbe, 0x79, 0xf6, 0x0c, 0xf8, 0x66, 0x6f, 0xe6, 0xe3, 0xae, 0xb1, 0xf5, 0x2e, 0xca, 0xbc, 0x7e	/* tpost_copy_siginfo_from_user.isra.0 */
	.byte 0x10, 0xef, 0x64, 0x6f, 0xf6, 0x0c, 0xe5, 0x93, 0xf4, 0xc6, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* t__pfx_do_sigaltstack.constprop.0 */
	.byte 0x10, 0x74, 0x64, 0x6f, 0xf6, 0x0c, 0xe5, 0x93, 0xf4, 0xc6, 0x2e, 0x40, 0x73, 0xce, 0xe3, 0x70, 0x7e	/* tdo_sigaltstack.constprop.0 */
	.byte 0x0d, 0xef, 0x64, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0x85, 0x67, 0xe5, 0x93, 0xf4, 0xc6	/* t__pfx_do_compat_sigaltstack */
	.byte 0x0d, 0x74, 0x64, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0x85, 0x67, 0xe5, 0x93, 0xf4, 0xc6	/* tdo_compat_sigaltstack */
	.byte 0x0b, 0xeb, 0xf7, 0x63, 0xe5, 0x63, 0xf6, 0x0c, 0x70, 0xf1, 0x64, 0x8d	/* T__pfx_recalc_sigpending */
	.byte 0x0b, 0x54, 0xf7, 0x63, 0xe5, 0x63, 0xf6, 0x0c, 0x70, 0xf1, 0x64, 0x8d	/* Trecalc_sigpending */
	.byte 0x0b, 0x74, 0xaf, 0xf6, 0x0c, 0xa1, 0x65, 0x75, 0xfc, 0x66, 0xf7, 0x65	/* t__pfx___sigqueue_free */
	.byte 0x0b, 0x74, 0xff, 0x85, 0x67, 0xa1, 0x65, 0x75, 0xfc, 0x66, 0xf7, 0x65	/* t__sigqueue_free */
	.byte 0x10, 0x74, 0xaf, 0xe6, 0x6c, 0xb1, 0x68, 0x5f, 0xea, 0x69, 0x6d, 0xf5, 0xf6, 0x0c, 0x6e, 0xe5, 0x73	/* t__pfx___flush_itimer_signals */
	.byte 0x10, 0x74, 0xff, 0x66, 0x6c, 0xb1, 0x68, 0x5f, 0xea, 0x69, 0x6d, 0xf5, 0xf6, 0x0c, 0x6e, 0xe5, 0x73	/* t__flush_itimer_signals */
	.byte 0x0a, 0xef, 0x63, 0xa0, 0xc4, 0x63, 0xfe, 0x85, 0x67, 0x6e, 0xe5	/* t__pfx_collect_signal */
	.byte 0x09, 0x26, 0xa0, 0xc4, 0x63, 0xfe, 0x85, 0x67, 0x6e, 0xe5	/* tcollect_signal */
	.byte 0x0a, 0xeb, 0x66, 0x6c, 0xb1, 0x68, 0xf6, 0x0c, 0x6e, 0xe5, 0x73	/* T__pfx_flush_signals */
	.byte 0x0a, 0x54, 0x66, 0x6c, 0xb1, 0x68, 0xf6, 0x0c, 0x6e, 0xe5, 0x73	/* Tflush_signals */
	.byte 0x0b, 0xeb, 0x64, 0x65, 0xa1, 0x65, 0x75, 0xfc, 0x85, 0x67, 0x6e, 0xe5	/* T__pfx_dequeue_signal */
	.byte 0x0b, 0x54, 0x64, 0x65, 0xa1, 0x65, 0x75, 0xfc, 0x85, 0x67, 0x6e, 0xe5	/* Tdequeue_signal */
	.byte 0x13, 0xef, 0xf7, 0xf4, 0x72, 0x67, 0xe2, 0x73, 0x68, 0x61, 0xf7, 0x64, 0xec, 0xf1, 0x64, 0x8d, 0x2e, 0xca, 0xbc, 0x7e	/* t__pfx_retarget_shared_pending.isra.0 */
	.byte 0x13, 0x74, 0xf7, 0xf4, 0x72, 0x67, 0xe2, 0x73, 0x68, 0x61, 0xf7, 0x64, 0xec, 0xf1, 0x64, 0x8d, 0x2e, 0xca, 0xbc, 0x7e	/* tretarget_shared_pending.isra.0 */
	.byte 0x08, 0x74, 0xaf, 0x84, 0xf4, 0x5e, 0xb8, 0xa4, 0x9e	/* t__pfx___set_task_blocked */
	.byte 0x09, 0x74, 0xff, 0x73, 0xe2, 0xf4, 0x5e, 0xb8, 0xa4, 0x9e	/* t__set_task_blocked */
	.byte 0x0f, 0xef, 0x64, 0x6f, 0xf6, 0x0c, 0xdc, 0xa8, 0x64, 0x77, 0x61, 0xea, 0x2e, 0xca, 0xbc, 0x7e	/* t__pfx_do_sigtimedwait.isra.0 */
	.byte 0x0f, 0x74, 0x64, 0x6f, 0xf6, 0x0c, 0xdc, 0xa8, 0x64, 0x77, 0x61, 0xea, 0x2e, 0xca, 0xbc, 0x7e	/* tdo_sigtimedwait.isra.0 */
	.byte 0x0f, 0xef, 0xf4, 0x5e, 0xec, 0xc5, 0xdc, 0x9b, 0x70, 0x91, 0x67, 0xe3, 0xcd, 0xf6, 0x74, 0xbe	/* t__pfx_task_participate_group_stop */
	.byte 0x0f, 0x74, 0xf4, 0x5e, 0xec, 0xc5, 0xdc, 0x9b, 0x70, 0x91, 0x67, 0xe3, 0xcd, 0xf6, 0x74, 0xbe	/* ttask_participate_group_stop */
	.byte 0x0d, 0xef, 0x66, 0x6c, 0xb1, 0x68, 0xf6, 0x0c, 0xa1, 0x65, 0x75, 0xfc, 0xd9, 0x5e	/* t__pfx_flush_sigqueue_mask */
	.byte 0x0d, 0x74, 0x66, 0x6c, 0xb1, 0x68, 0xf6, 0x0c, 0xa1, 0x65, 0x75, 0xfc, 0xd9, 0x5e	/* tflush_sigqueue_mask */
	.byte 0x0a, 0xeb, 0x6b, 0xf5, 0x6e, 0xdb, 0xf6, 0x0c, 0xf2, 0xdc, 0xe7	/* T__pfx_kernel_sigaction */
	.byte 0x0a, 0x54, 0x6b, 0xf5, 0x6e, 0xdb, 0xf6, 0x0c, 0xf2, 0xdc, 0xe7	/* Tkernel_sigaction */
	.byte 0x08, 0xeb, 0x85, 0x67, 0x70, 0xe3, 0x63, 0xd9, 0x5e	/* T__pfx_sigprocmask */
	.byte 0x08, 0x54, 0x85, 0x67, 0x70, 0xe3, 0x63, 0xd9, 0x5e	/* Tsigprocmask */
	.byte 0x08, 0xef, 0x85, 0x67, 0x73, 0xb1, 0x70, 0xf1, 0x64	/* t__pfx_sigsuspend */
	.byte 0x07, 0x93, 0x0c, 0x73, 0xb1, 0x70, 0xf1, 0x64	/* tsigsuspend */
	.byte 0x0c, 0xeb, 0x63, 0xe5, 0x63, 0x02, 0x91, 0x85, 0x67, 0x70, 0xf1, 0x64, 0x8d	/* T__pfx_calculate_sigpending */
	.byte 0x0c, 0x54, 0x63, 0xe5, 0x63, 0x02, 0x91, 0x85, 0x67, 0x70, 0xf1, 0x64, 0x8d	/* Tcalculate_sigpending */
	.byte 0x08, 0xeb, 0x6e, 0xcb, 0xfe, 0x85, 0x67, 0x6e, 0xe5	/* T__pfx_next_signal */
	.byte 0x08, 0x54, 0x6e, 0xcb, 0xfe, 0x85, 0x67, 0x6e, 0xe5	/* Tnext_signal */
	.byte 0x0d, 0xeb, 0xf4, 0x5e, 0x84, 0x6a, 0x6f, 0x62, 0x63, 0x23, 0xec, 0xf1, 0x64, 0x8d	/* T__pfx_task_set_jobctl_pending */
	.byte 0x0d, 0x54, 0xf4, 0x5e, 0x84, 0x6a, 0x6f, 0x62, 0x63, 0x23, 0xec, 0xf1, 0x64, 0x8d	/* Ttask_set_jobctl_pending */
	.byte 0x0b, 0xef, 0x70, 0xc3, 0xf3, 0x61, 0x70, 0xbd, 0x6f, 0xdc, 0x66, 0x79	/* t__pfx_ptrace_trap_notify */
	.byte 0x0a, 0xce, 0xc3, 0xf3, 0x61, 0x70, 0xbd, 0x6f, 0xdc, 0x66, 0x79	/* tptrace_trap_notify */
	.byte 0x12, 0xeb, 0xf4, 0x5e, 0xf0, 0xc4, 0xc5, 0x5f, 0x6a, 0x6f, 0x62, 0x63, 0x23, 0x5f, 0xf3, 0x61, 0x70, 0x70, 0x8d	/* T__pfx_task_clear_jobctl_trapping */
	.byte 0x12, 0x54, 0xf4, 0x5e, 0xf0, 0xc4, 0xc5, 0x5f, 0x6a, 0x6f, 0x62, 0x63, 0x23, 0x5f, 0xf3, 0x61, 0x70, 0x70, 0x8d	/* Ttask_clear_jobctl_trapping */
	.byte 0x10, 0xeb, 0xf4, 0x5e, 0xf0, 0xc4, 0xc5, 0x5f, 0x6a, 0x6f, 0x62, 0x63, 0x23, 0xec, 0xf1, 0x64, 0x8d	/* T__pfx_task_clear_jobctl_pending */
	.byte 0x10, 0x54, 0xf4, 0x5e, 0xf0, 0xc4, 0xc5, 0x5f, 0x6a, 0x6f, 0x62, 0x63, 0x23, 0xec, 0xf1, 0x64, 0x8d	/* Ttask_clear_jobctl_pending */
	.byte 0x0a, 0xef, 0x70, 0xf7, 0x70, 0xc5, 0xfc, 0x85, 0x67, 0x6e, 0xe5	/* t__pfx_prepare_signal */
	.byte 0x09, 0xce, 0xf7, 0x70, 0xc5, 0xfc, 0x85, 0x67, 0x6e, 0xe5	/* tprepare_signal */
	.byte 0x0a, 0xef, 0x03, 0xb6, 0x6c, 0xd4, 0xfc, 0x85, 0x67, 0x6e, 0xe5	/* t__pfx_complete_signal */
	.byte 0x0a, 0x26, 0x6f, 0xb6, 0x6c, 0xd4, 0xfc, 0x85, 0x67, 0x6e, 0xe5	/* tcomplete_signal */
	.byte 0x0c, 0x74, 0xaf, 0xf6, 0xf1, 0x64, 0xf6, 0x0c, 0x6e, 0xe5, 0x5f, 0xa4, 0x9e	/* t__pfx___send_signal_locked */
	.byte 0x0c, 0x74, 0xff, 0x73, 0xf1, 0x64, 0xf6, 0x0c, 0x6e, 0xe5, 0x5f, 0xa4, 0x9e	/* t__send_signal_locked */
	.byte 0x10, 0xeb, 0x6b, 0x69, 0x6c, 0x6c, 0xec, 0x69, 0xda, 0xb1, 0x62, 0x5f, 0x61, 0xe1, 0x6e, 0x63, 0xc0	/* T__pfx_kill_pid_usb_asyncio */
	.byte 0x10, 0x54, 0x6b, 0x69, 0x6c, 0x6c, 0xec, 0x69, 0xda, 0xb1, 0x62, 0x5f, 0x61, 0xe1, 0x6e, 0x63, 0xc0	/* Tkill_pid_usb_asyncio */
	.byte 0x12, 0xef, 0x70, 0x6f, 0x85, 0x78, 0x00, 0xf5, 0x5f, 0xa1, 0x65, 0x75, 0xfc, 0x85, 0x67, 0xa1, 0x65, 0x75, 0x65	/* t__pfx_posixtimer_queue_sigqueue */
	.byte 0x11, 0xce, 0x6f, 0x85, 0x78, 0x00, 0xf5, 0x5f, 0xa1, 0x65, 0x75, 0xfc, 0x85, 0x67, 0xa1, 0x65, 0x75, 0x65	/* tposixtimer_queue_sigqueue */
	.byte 0x0d, 0xeb, 0xf4, 0x5e, 0x5f, 0x6a, 0x6f, 0xf8, 0xc7, 0xe3, 0xcd, 0xf6, 0x74, 0xbe	/* T__pfx_task_join_group_stop */
	.byte 0x0d, 0x54, 0xf4, 0x5e, 0x5f, 0x6a, 0x6f, 0xf8, 0xc7, 0xe3, 0xcd, 0xf6, 0x74, 0xbe	/* Ttask_join_group_stop */
	.byte 0x0b, 0xeb, 0x66, 0x6c, 0xb1, 0x68, 0xf6, 0x0c, 0xa1, 0x65, 0x75, 0x65	/* T__pfx_flush_sigqueue */
	.byte 0x0b, 0x54, 0x66, 0x6c, 0xb1, 0x68, 0xf6, 0x0c, 0xa1, 0x65, 0x75, 0x65	/* Tflush_sigqueue */
	.byte 0x0a, 0xeb, 0x0c, 0x6e, 0xd5, 0xfc, 0x85, 0x67, 0x6e, 0xe5, 0x73	/* T__pfx_ignore_signals */
	.byte 0x0a, 0x54, 0x0c, 0x6e, 0xd5, 0xfc, 0x85, 0x67, 0x6e, 0xe5, 0x73	/* Tignore_signals */
	.byte 0x0e, 0xeb, 0x66, 0x6c, 0xb1, 0x68, 0xf6, 0x0c, 0x6e, 0xe5, 0xa3, 0x05, 0x6c, 0xf5, 0x73	/* T__pfx_flush_signal_handlers */
	.byte 0x0e, 0x54, 0x66, 0x6c, 0xb1, 0x68, 0xf6, 0x0c, 0x6e, 0xe5, 0xa3, 0x05, 0x6c, 0xf5, 0x73	/* Tflush_signal_handlers */
	.byte 0x0a, 0xeb, 0xe4, 0x68, 0x05, 0xc4, 0x64, 0xf6, 0x0c, 0x6e, 0xe5	/* T__pfx_unhandled_signal */
	.byte 0x0a, 0x54, 0xe4, 0x68, 0x05, 0xc4, 0x64, 0xf6, 0x0c, 0x6e, 0xe5	/* Tunhandled_signal */
	.byte 0x0c, 0xeb, 0x85, 0x67, 0x6e, 0xe5, 0x92, 0x61, 0x6b, 0xfc, 0xcd, 0xa9, 0x2c	/* T__pfx_signal_wake_up_state */
	.byte 0x0c, 0x54, 0x85, 0x67, 0x6e, 0xe5, 0x92, 0x61, 0x6b, 0xfc, 0xcd, 0xa9, 0x2c	/* Tsignal_wake_up_state */
	.byte 0x0e, 0xeb, 0x7a, 0x61, 0x70, 0x5f, 0x6f, 0x74, 0x68, 0xf5, 0xa7, 0x68, 0xf7, 0xc8, 0x73	/* T__pfx_zap_other_threads */
	.byte 0x0e, 0x54, 0x7a, 0x61, 0x70, 0x5f, 0x6f, 0x74, 0x68, 0xf5, 0xa7, 0x68, 0xf7, 0xc8, 0x73	/* Tzap_other_threads */
	.byte 0x09, 0x08, 0xa4, 0x5f, 0xf4, 0x5e, 0xf6, 0x0c, 0x68, 0x05	/* T__pfx___lock_task_sighand */
	.byte 0x09, 0xb9, 0xa4, 0x5f, 0xf4, 0x5e, 0xf6, 0x0c, 0x68, 0x05	/* T__lock_task_sighand */
	.byte 0x0f, 0xeb, 0x66, 0x6c, 0xb1, 0x68, 0x5f, 0xea, 0x69, 0x6d, 0xf5, 0xf6, 0x0c, 0x6e, 0xe5, 0x73	/* T__pfx_flush_itimer_signals */
	.byte 0x0f, 0x54, 0x66, 0x6c, 0xb1, 0x68, 0x5f, 0xea, 0x69, 0x6d, 0xf5, 0xf6, 0x0c, 0x6e, 0xe5, 0x73	/* Tflush_itimer_signals */
	.byte 0x0f, 0xeb, 0x70, 0x6f, 0x85, 0x78, 0x00, 0xf5, 0xbf, 0x9d, 0x85, 0x67, 0xa1, 0x65, 0x75, 0x65	/* T__pfx_posixtimer_init_sigqueue */
	.byte 0x0f, 0x54, 0x70, 0x6f, 0x85, 0x78, 0x00, 0xf5, 0xbf, 0x9d, 0x85, 0x67, 0xa1, 0x65, 0x75, 0x65	/* Tposixtimer_init_sigqueue */
	.byte 0x10, 0xeb, 0x70, 0x6f, 0x85, 0x78, 0x00, 0xf5, 0xf6, 0xf1, 0x64, 0xf6, 0x0c, 0xa1, 0x65, 0x75, 0x65	/* T__pfx_posixtimer_send_sigqueue */
	.byte 0x10, 0x54, 0x70, 0x6f, 0x85, 0x78, 0x00, 0xf5, 0xf6, 0xf1, 0x64, 0xf6, 0x0c, 0xa1, 0x65, 0x75, 0x65	/* Tposixtimer_send_sigqueue */
	.byte 0x0c, 0xeb, 0x64, 0x6f, 0xbd, 0x6f, 0xdc, 0x66, 0x79, 0xec, 0x9f, 0x66, 0x64	/* T__pfx_do_notify_pidfd */
	.byte 0x0c, 0x54, 0x64, 0x6f, 0xbd, 0x6f, 0xdc, 0x66, 0x79, 0xec, 0x9f, 0x66, 0x64	/* Tdo_notify_pidfd */
	.byte 0x0d, 0xeb, 0x64, 0x6f, 0xbd, 0x6f, 0xdc, 0x66, 0x79, 0xec, 0x61, 0xf7, 0x6e, 0x74	/* T__pfx_do_notify_parent */
	.byte 0x0d, 0x54, 0x64, 0x6f, 0xbd, 0x6f, 0xdc, 0x66, 0x79, 0xec, 0x61, 0xf7, 0x6e, 0x74	/* Tdo_notify_parent */
	.byte 0x0e, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0xe9, 0xf7, 0x3d, 0x72, 0xfe, 0xe1, 0x73, 0x63, 0x5d	/* t__pfx___do_sys_restart_syscall */
	.byte 0x0f, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xf7, 0x3d, 0x72, 0xfe, 0xe1, 0x73, 0x63, 0x5d	/* T__pfx___ia32_sys_restart_syscall */
	.byte 0x0e, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xf7, 0x3d, 0x72, 0xfe, 0xe1, 0x73, 0x63, 0x5d	/* T__pfx___x64_sys_restart_syscall */
	.byte 0x0e, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0xe9, 0xf7, 0x3d, 0x72, 0xfe, 0xe1, 0x73, 0x63, 0x5d	/* t__do_sys_restart_syscall */
	.byte 0x0f, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xf7, 0x3d, 0x72, 0xfe, 0xe1, 0x73, 0x63, 0x5d	/* T__ia32_sys_restart_syscall */
	.byte 0x0e, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xf7, 0x3d, 0x72, 0xfe, 0xe1, 0x73, 0x63, 0x5d	/* T__x64_sys_restart_syscall */
	.byte 0x0d, 0xeb, 0x64, 0x6f, 0xbd, 0x6f, 0xde, 0x3d, 0x72, 0xfe, 0xe1, 0x73, 0x63, 0x5d	/* T__pfx_do_no_restart_syscall */
	.byte 0x0d, 0x54, 0x64, 0x6f, 0xbd, 0x6f, 0xde, 0x3d, 0x72, 0xfe, 0xe1, 0x73, 0x63, 0x5d	/* Tdo_no_restart_syscall */
	.byte 0x0b, 0xeb, 0x73, 0xe2, 0x63, 0x98, 0xf7, 0x6e, 0xfe, 0x62, 0xa4, 0x9e	/* T__pfx_set_current_blocked */
	.byte 0x0b, 0x54, 0x73, 0xe2, 0x63, 0x98, 0xf7, 0x6e, 0xfe, 0x62, 0xa4, 0x9e	/* Tset_current_blocked */
	.byte 0x0a, 0x99, 0x84, 0x63, 0x98, 0xf7, 0x6e, 0xfe, 0x62, 0xa4, 0x9e	/* T__pfx___set_current_blocked */
	.byte 0x0b, 0xb9, 0x73, 0xe2, 0x63, 0x98, 0xf7, 0x6e, 0xfe, 0x62, 0xa4, 0x9e	/* T__set_current_blocked */
	.byte 0x09, 0xeb, 0x73, 0xe2, 0xb1, 0xf5, 0xf6, 0x0c, 0xd9, 0x5e	/* T__pfx_set_user_sigmask */
	.byte 0x09, 0x54, 0x73, 0xe2, 0xb1, 0xf5, 0xf6, 0x0c, 0xd9, 0x5e	/* Tset_user_sigmask */
	.byte 0x0d, 0xeb, 0x73, 0xe2, 0x03, 0xb6, 0x61, 0xfe, 0xb1, 0xf5, 0xf6, 0x0c, 0xd9, 0x5e	/* T__pfx_set_compat_user_sigmask */
	.byte 0x0d, 0x54, 0x73, 0xe2, 0x03, 0xb6, 0x61, 0xfe, 0xb1, 0xf5, 0xf6, 0x0c, 0xd9, 0x5e	/* Tset_compat_user_sigmask */
	.byte 0x0f, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0x70, 0xe3, 0x63, 0xd9, 0x5e	/* T__pfx___x64_sys_rt_sigprocmask */
	.byte 0x0f, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0x70, 0xe3, 0x63, 0xd9, 0x5e	/* T__x64_sys_rt_sigprocmask */
	.byte 0x10, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0x70, 0xe3, 0x63, 0xd9, 0x5e	/* T__pfx___ia32_sys_rt_sigprocmask */
	.byte 0x10, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0x70, 0xe3, 0x63, 0xd9, 0x5e	/* T__ia32_sys_rt_sigprocmask */
	.byte 0x14, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0x70, 0xe3, 0x63, 0xd9, 0x5e	/* T__pfx___ia32_compat_sys_rt_sigprocmask */
	.byte 0x14, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0x70, 0xe3, 0x63, 0xd9, 0x5e	/* T__ia32_compat_sys_rt_sigprocmask */
	.byte 0x0e, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0x70, 0xf1, 0x64, 0x8d	/* T__pfx___x64_sys_rt_sigpending */
	.byte 0x0e, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0x70, 0xf1, 0x64, 0x8d	/* T__x64_sys_rt_sigpending */
	.byte 0x0f, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0x70, 0xf1, 0x64, 0x8d	/* T__pfx___ia32_sys_rt_sigpending */
	.byte 0x0f, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0x70, 0xf1, 0x64, 0x8d	/* T__ia32_sys_rt_sigpending */
	.byte 0x13, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0x70, 0xf1, 0x64, 0x8d	/* T__pfx___ia32_compat_sys_rt_sigpending */
	.byte 0x13, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0x70, 0xf1, 0x64, 0x8d	/* T__ia32_compat_sys_rt_sigpending */
	.byte 0x0c, 0xeb, 0x85, 0x67, 0xf8, 0x66, 0x6f, 0x5f, 0x6c, 0x61, 0x79, 0x6f, 0x20	/* T__pfx_siginfo_layout */
	.byte 0x0c, 0x54, 0x85, 0x67, 0xf8, 0x66, 0x6f, 0x5f, 0x6c, 0x61, 0x79, 0x6f, 0x20	/* Tsiginfo_layout */
	.byte 0x14, 0xef, 0x70, 0x6f, 0x73, 0xfe, 0x63, 0xbe, 0x79, 0xf6, 0x0c, 0xf8, 0x66, 0x6f, 0xe6, 0xe3, 0xae, 0xb1, 0xf5, 0x33, 0x32	/* t__pfx_post_copy_siginfo_from_user32 */
	.byte 0x13, 0xce, 0x6f, 0x73, 0xfe, 0x63, 0xbe, 0x79, 0xf6, 0x0c, 0xf8, 0x66, 0x6f, 0xe6, 0xe3, 0xae, 0xb1, 0xf5, 0x33, 0x32	/* tpost_copy_siginfo_from_user32 */
	.byte 0x11, 0x74, 0xaf, 0xf0, 0xbe, 0x79, 0xf6, 0x0c, 0xf8, 0x66, 0x6f, 0xe6, 0xe3, 0xae, 0xb1, 0xf5, 0x33, 0x32	/* t__pfx___copy_siginfo_from_user32 */
	.byte 0x11, 0x74, 0xff, 0x63, 0xbe, 0x79, 0xf6, 0x0c, 0xf8, 0x66, 0x6f, 0xe6, 0xe3, 0xae, 0xb1, 0xf5, 0x33, 0x32	/* t__copy_siginfo_from_user32 */
	.byte 0x0b, 0xeb, 0x73, 0xf1, 0x64, 0xf6, 0x0c, 0x6e, 0xe5, 0x5f, 0xa4, 0x9e	/* T__pfx_send_signal_locked */
	.byte 0x0b, 0x54, 0x73, 0xf1, 0x64, 0xf6, 0x0c, 0x6e, 0xe5, 0x5f, 0xa4, 0x9e	/* Tsend_signal_locked */
	.byte 0x0b, 0xeb, 0x64, 0x6f, 0xf6, 0xf1, 0x64, 0xf6, 0x0c, 0xbf, 0x66, 0x6f	/* T__pfx_do_send_sig_info */
	.byte 0x0b, 0x54, 0x64, 0x6f, 0xf6, 0xf1, 0x64, 0xf6, 0x0c, 0xbf, 0x66, 0x6f	/* Tdo_send_sig_info */
	.byte 0x0c, 0xeb, 0x67, 0xe3, 0xcd, 0xf6, 0xf1, 0x64, 0xf6, 0x0c, 0xbf, 0x66, 0x6f	/* T__pfx_group_send_sig_info */
	.byte 0x0c, 0x54, 0x67, 0xe3, 0xcd, 0xf6, 0xf1, 0x64, 0xf6, 0x0c, 0xbf, 0x66, 0x6f	/* Tgroup_send_sig_info */
	.byte 0x09, 0xeb, 0x73, 0xf1, 0x64, 0xf6, 0x0c, 0xbf, 0x66, 0x6f	/* T__pfx_send_sig_info */
	.byte 0x09, 0x54, 0x73, 0xf1, 0x64, 0xf6, 0x0c, 0xbf, 0x66, 0x6f	/* Tsend_sig_info */
	.byte 0x06, 0xeb, 0x73, 0xf1, 0x64, 0xf6, 0x0c	/* T__pfx_send_sig */
	.byte 0x06, 0x54, 0x73, 0xf1, 0x64, 0xf6, 0x0c	/* Tsend_sig */
	.byte 0x0a, 0xeb, 0x73, 0xf1, 0x64, 0xf6, 0x0c, 0xe6, 0x61, 0x02, 0x74	/* T__pfx_send_sig_fault */
	.byte 0x0a, 0x54, 0x73, 0xf1, 0x64, 0xf6, 0x0c, 0xe6, 0x61, 0x02, 0x74	/* Tsend_sig_fault */
	.byte 0x0b, 0xeb, 0x73, 0xf1, 0x64, 0xf6, 0x0c, 0xc1, 0x63, 0x65, 0xf5, 0x72	/* T__pfx_send_sig_mceerr */
	.byte 0x0b, 0x54, 0x73, 0xf1, 0x64, 0xf6, 0x0c, 0xc1, 0x63, 0x65, 0xf5, 0x72	/* Tsend_sig_mceerr */
	.byte 0x09, 0xeb, 0x73, 0xf1, 0x64, 0xf6, 0x0c, 0xec, 0xf5, 0x66	/* T__pfx_send_sig_perf */
	.byte 0x09, 0x54, 0x73, 0xf1, 0x64, 0xf6, 0x0c, 0xec, 0xf5, 0x66	/* Tsend_sig_perf */
	.byte 0x0f, 0xeb, 0x73, 0xf1, 0x64, 0xf6, 0x0c, 0xe6, 0x61, 0x02, 0xfe, 0xf3, 0x61, 0x70, 0x6e, 0x6f	/* T__pfx_send_sig_fault_trapno */
	.byte 0x0f, 0x54, 0x73, 0xf1, 0x64, 0xf6, 0x0c, 0xe6, 0x61, 0x02, 0xfe, 0xf3, 0x61, 0x70, 0x6e, 0x6f	/* Tsend_sig_fault_trapno */
	.byte 0x0c, 0xef, 0x64, 0x6f, 0xf6, 0xf1, 0x64, 0xf6, 0x70, 0xb4, 0x69, 0x66, 0xaa	/* t__pfx_do_send_specific */
	.byte 0x0c, 0x74, 0x64, 0x6f, 0xf6, 0xf1, 0x64, 0xf6, 0x70, 0xb4, 0x69, 0x66, 0xaa	/* tdo_send_specific */
	.byte 0x10, 0xef, 0x64, 0x6f, 0xa6, 0xfe, 0x74, 0x67, 0x85, 0x67, 0xa1, 0x65, 0x75, 0x65, 0xf8, 0x66, 0x6f	/* t__pfx_do_rt_tgsigqueueinfo */
	.byte 0x10, 0x74, 0x64, 0x6f, 0xa6, 0xfe, 0x74, 0x67, 0x85, 0x67, 0xa1, 0x65, 0x75, 0x65, 0xf8, 0x66, 0x6f	/* tdo_rt_tgsigqueueinfo */
	.byte 0x0c, 0x08, 0x6b, 0x69, 0x6c, 0x6c, 0xec, 0x67, 0x72, 0x70, 0xbf, 0x66, 0x6f	/* T__pfx___kill_pgrp_info */
	.byte 0x0c, 0x54, 0xd8, 0x69, 0x6c, 0x6c, 0xec, 0x67, 0x72, 0x70, 0xbf, 0x66, 0x6f	/* T__kill_pgrp_info */
	.byte 0x09, 0xeb, 0x6b, 0x69, 0x6c, 0x6c, 0xec, 0x67, 0x72, 0x70	/* T__pfx_kill_pgrp */
	.byte 0x09, 0x54, 0x6b, 0x69, 0x6c, 0x6c, 0xec, 0x67, 0x72, 0x70	/* Tkill_pgrp */
	.byte 0x0e, 0xef, 0x6b, 0x69, 0x6c, 0x6c, 0xec, 0x69, 0xda, 0xf8, 0x66, 0x6f, 0xa7, 0x21, 0x65	/* t__pfx_kill_pid_info_type */
	.byte 0x0e, 0x74, 0x6b, 0x69, 0x6c, 0x6c, 0xec, 0x69, 0xda, 0xf8, 0x66, 0x6f, 0xa7, 0x21, 0x65	/* tkill_pid_info_type */
	.byte 0x0b, 0xeb, 0x6b, 0x69, 0x6c, 0x6c, 0xec, 0x69, 0xda, 0xf8, 0x66, 0x6f	/* T__pfx_kill_pid_info */
	.byte 0x0b, 0x54, 0x6b, 0x69, 0x6c, 0x6c, 0xec, 0x69, 0xda, 0xf8, 0x66, 0x6f	/* Tkill_pid_info */
	.byte 0x07, 0xeb, 0x6b, 0x69, 0x6c, 0x6c, 0xec, 0x9f	/* T__pfx_kill_pid */
	.byte 0x07, 0x54, 0x6b, 0x69, 0x6c, 0x6c, 0xec, 0x9f	/* Tkill_pid */
	.byte 0x0e, 0xef, 0x64, 0x6f, 0xa6, 0xfe, 0x85, 0x67, 0xa1, 0x65, 0x75, 0x65, 0xf8, 0x66, 0x6f	/* t__pfx_do_rt_sigqueueinfo */
	.byte 0x0e, 0x74, 0x64, 0x6f, 0xa6, 0xfe, 0x85, 0x67, 0xa1, 0x65, 0x75, 0x65, 0xf8, 0x66, 0x6f	/* tdo_rt_sigqueueinfo */
	.byte 0x0e, 0xef, 0x6b, 0x69, 0x6c, 0x6c, 0xf6, 0x6f, 0x6d, 0xd4, 0x68, 0x8d, 0xbf, 0x66, 0x6f	/* t__pfx_kill_something_info */
	.byte 0x0e, 0x74, 0x6b, 0x69, 0x6c, 0x6c, 0xf6, 0x6f, 0x6d, 0xd4, 0x68, 0x8d, 0xbf, 0x66, 0x6f	/* tkill_something_info */
	.byte 0x0f, 0xef, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0xbf, 0x66, 0x6f, 0xa7, 0x6f, 0x5f, 0xf4, 0x5e	/* t__pfx_force_sig_info_to_task */
	.byte 0x0f, 0x74, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0xbf, 0x66, 0x6f, 0xa7, 0x6f, 0x5f, 0xf4, 0x5e	/* tforce_sig_info_to_task */
	.byte 0x0a, 0xeb, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0xbf, 0x66, 0x6f	/* T__pfx_force_sig_info */
	.byte 0x0a, 0x54, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0xbf, 0x66, 0x6f	/* Tforce_sig_info */
	.byte 0x0c, 0xeb, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0xc1, 0x63, 0x65, 0xf5, 0x72	/* T__pfx_force_sig_mceerr */
	.byte 0x0c, 0x54, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0xc1, 0x63, 0x65, 0xf5, 0x72	/* Tforce_sig_mceerr */
	.byte 0x0c, 0xeb, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0xb8, 0x6e, 0x64, 0xf5, 0x72	/* T__pfx_force_sig_bnderr */
	.byte 0x0c, 0x54, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0xb8, 0x6e, 0x64, 0xf5, 0x72	/* Tforce_sig_bnderr */
	.byte 0x0c, 0xeb, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0xec, 0x6b, 0x75, 0xf5, 0x72	/* T__pfx_force_sig_pkuerr */
	.byte 0x0c, 0x54, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0xec, 0x6b, 0x75, 0xf5, 0x72	/* Tforce_sig_pkuerr */
	.byte 0x11, 0xeb, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0xec, 0xc3, 0xf5, 0x72, 0x6e, 0x6f, 0x5f, 0xf3, 0x61, 0x70	/* T__pfx_force_sig_ptrace_errno_trap */
	.byte 0x11, 0x54, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0xec, 0xc3, 0xf5, 0x72, 0x6e, 0x6f, 0x5f, 0xf3, 0x61, 0x70	/* Tforce_sig_ptrace_errno_trap */
	.byte 0x10, 0xeb, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0xe6, 0x61, 0x02, 0xfe, 0xf3, 0x61, 0x70, 0x6e, 0x6f	/* T__pfx_force_sig_fault_trapno */
	.byte 0x10, 0x54, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0xe6, 0x61, 0x02, 0xfe, 0xf3, 0x61, 0x70, 0x6e, 0x6f	/* Tforce_sig_fault_trapno */
	.byte 0x0a, 0xeb, 0x66, 0xd5, 0x63, 0xfc, 0x66, 0x0a, 0x6c, 0xf6, 0x0c	/* T__pfx_force_fatal_sig */
	.byte 0x0a, 0x54, 0x66, 0xd5, 0x63, 0xfc, 0x66, 0x0a, 0x6c, 0xf6, 0x0c	/* Tforce_fatal_sig */
	.byte 0x09, 0xeb, 0x66, 0xd5, 0x63, 0xfc, 0xcb, 0x9d, 0x85, 0x67	/* T__pfx_force_exit_sig */
	.byte 0x09, 0x54, 0x66, 0xd5, 0x63, 0xfc, 0xcb, 0x9d, 0x85, 0x67	/* Tforce_exit_sig */
	.byte 0x0f, 0xeb, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0xe6, 0x61, 0x02, 0xfe, 0x8a, 0x5f, 0xf4, 0x5e	/* T__pfx_force_sig_fault_to_task */
	.byte 0x0f, 0x54, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0xe6, 0x61, 0x02, 0xfe, 0x8a, 0x5f, 0xf4, 0x5e	/* Tforce_sig_fault_to_task */
	.byte 0x0b, 0xeb, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0xf6, 0xb4, 0x03, 0xb6	/* T__pfx_force_sig_seccomp */
	.byte 0x0b, 0x54, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0xf6, 0xb4, 0x03, 0xb6	/* Tforce_sig_seccomp */
	.byte 0x07, 0xeb, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67	/* T__pfx_force_sig */
	.byte 0x07, 0x54, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67	/* Tforce_sig */
	.byte 0x0b, 0xeb, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0xe6, 0x61, 0x02, 0x74	/* T__pfx_force_sig_fault */
	.byte 0x0b, 0x54, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0xe6, 0x61, 0x02, 0x74	/* Tforce_sig_fault */
	.byte 0x0b, 0xeb, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0x73, 0x65, 0x67, 0x76	/* T__pfx_force_sigsegv */
	.byte 0x0b, 0x54, 0x66, 0xd5, 0x63, 0xfc, 0x85, 0x67, 0x73, 0x65, 0x67, 0x76	/* Tforce_sigsegv */
	.byte 0x13, 0xef, 0x64, 0x6f, 0xbd, 0x6f, 0xdc, 0x66, 0x79, 0xec, 0x61, 0xf7, 0x6e, 0xfe, 0x63, 0x6c, 0x64, 0x73, 0x74, 0xbe	/* t__pfx_do_notify_parent_cldstop */
	.byte 0x13, 0x74, 0x64, 0x6f, 0xbd, 0x6f, 0xdc, 0x66, 0x79, 0xec, 0x61, 0xf7, 0x6e, 0xfe, 0x63, 0x6c, 0x64, 0x73, 0x74, 0xbe	/* tdo_notify_parent_cldstop */
	.byte 0x06, 0xef, 0x70, 0xc3, 0x73, 0x74, 0xbe	/* t__pfx_ptrace_stop */
	.byte 0x05, 0xce, 0xc3, 0x73, 0x74, 0xbe	/* tptrace_stop */
	.byte 0x0a, 0xef, 0x70, 0xc3, 0x64, 0x6f, 0xbd, 0x6f, 0xdc, 0x66, 0x79	/* t__pfx_ptrace_do_notify */
	.byte 0x09, 0xce, 0xc3, 0x64, 0x6f, 0xbd, 0x6f, 0xdc, 0x66, 0x79	/* tptrace_do_notify */
	.byte 0x08, 0xeb, 0x70, 0xc3, 0x6e, 0x6f, 0xdc, 0x66, 0x79	/* T__pfx_ptrace_notify */
	.byte 0x08, 0x54, 0x70, 0xc3, 0x6e, 0x6f, 0xdc, 0x66, 0x79	/* Tptrace_notify */
	.byte 0x0b, 0xeb, 0x85, 0x67, 0x6e, 0xe5, 0xf6, 0xd4, 0xcd, 0xed, 0xe7, 0x65	/* T__pfx_signal_setup_done */
	.byte 0x0b, 0x54, 0x85, 0x67, 0x6e, 0xe5, 0xf6, 0xd4, 0xcd, 0xed, 0xe7, 0x65	/* Tsignal_setup_done */
	.byte 0x0a, 0xef, 0x64, 0x6f, 0xf6, 0x0c, 0x6e, 0xe5, 0xf6, 0x74, 0xbe	/* t__pfx_do_signal_stop */
	.byte 0x0a, 0x74, 0x64, 0x6f, 0xf6, 0x0c, 0x6e, 0xe5, 0xf6, 0x74, 0xbe	/* tdo_signal_stop */
	.byte 0x08, 0xeb, 0xcb, 0x9d, 0x85, 0x67, 0x6e, 0xe5, 0x73	/* T__pfx_exit_signals */
	.byte 0x08, 0x54, 0xcb, 0x9d, 0x85, 0x67, 0x6e, 0xe5, 0x73	/* Texit_signals */
	.byte 0x07, 0xeb, 0x67, 0xe2, 0x85, 0x67, 0x6e, 0xe5	/* T__pfx_get_signal */
	.byte 0x07, 0x54, 0x67, 0xe2, 0x85, 0x67, 0x6e, 0xe5	/* Tget_signal */
	.byte 0x0e, 0xeb, 0x63, 0xbe, 0x79, 0xf6, 0x0c, 0xf8, 0x66, 0x6f, 0xa7, 0x6f, 0x5f, 0xb1, 0xf5	/* T__pfx_copy_siginfo_to_user */
	.byte 0x0e, 0x54, 0x63, 0xbe, 0x79, 0xf6, 0x0c, 0xf8, 0x66, 0x6f, 0xa7, 0x6f, 0x5f, 0xb1, 0xf5	/* Tcopy_siginfo_to_user */
	.byte 0x0e, 0xeb, 0x63, 0xbe, 0x79, 0xf6, 0x0c, 0xf8, 0x66, 0x6f, 0xe6, 0xe3, 0xae, 0xb1, 0xf5	/* T__pfx_copy_siginfo_from_user */
	.byte 0x0e, 0x54, 0x63, 0xbe, 0x79, 0xf6, 0x0c, 0xf8, 0x66, 0x6f, 0xe6, 0xe3, 0xae, 0xb1, 0xf5	/* Tcopy_siginfo_from_user */
	.byte 0x12, 0xeb, 0x63, 0xbe, 0x79, 0xf6, 0x0c, 0xf8, 0x66, 0x6f, 0xa7, 0x6f, 0x5f, 0xcb, 0xa2, 0x6e, 0xe5, 0x33, 0x32	/* T__pfx_copy_siginfo_to_external32 */
	.byte 0x12, 0x54, 0x63, 0xbe, 0x79, 0xf6, 0x0c, 0xf8, 0x66, 0x6f, 0xa7, 0x6f, 0x5f, 0xcb, 0xa2, 0x6e, 0xe5, 0x33, 0x32	/* Tcopy_siginfo_to_external32 */
	.byte 0x10, 0x99, 0xf0, 0xbe, 0x79, 0xf6, 0x0c, 0xf8, 0x66, 0x6f, 0xa7, 0x6f, 0x5f, 0xb1, 0xf5, 0x33, 0x32	/* T__pfx___copy_siginfo_to_user32 */
	.byte 0x10, 0xb9, 0x63, 0xbe, 0x79, 0xf6, 0x0c, 0xf8, 0x66, 0x6f, 0xa7, 0x6f, 0x5f, 0xb1, 0xf5, 0x33, 0x32	/* T__copy_siginfo_to_user32 */
	.byte 0x10, 0xeb, 0x63, 0xbe, 0x79, 0xf6, 0x0c, 0xf8, 0x66, 0x6f, 0xe6, 0xe3, 0xae, 0xb1, 0xf5, 0x33, 0x32	/* T__pfx_copy_siginfo_from_user32 */
	.byte 0x10, 0x54, 0x63, 0xbe, 0x79, 0xf6, 0x0c, 0xf8, 0x66, 0x6f, 0xe6, 0xe3, 0xae, 0xb1, 0xf5, 0x33, 0x32	/* Tcopy_siginfo_from_user32 */
	.byte 0x11, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0x73, 0xec, 0x9f, 0x66, 0x64, 0xf6, 0xf1, 0x64, 0xf6, 0x0c, 0x6e, 0xe5	/* t__pfx___do_sys_pidfd_send_signal */
	.byte 0x11, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0x73, 0xec, 0x9f, 0x66, 0x64, 0xf6, 0xf1, 0x64, 0xf6, 0x0c, 0x6e, 0xe5	/* t__do_sys_pidfd_send_signal */
	.byte 0x10, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xdc, 0xa8, 0x64, 0x77, 0x61, 0xea	/* T__pfx___x64_sys_rt_sigtimedwait */
	.byte 0x10, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xdc, 0xa8, 0x64, 0x77, 0x61, 0xea	/* T__x64_sys_rt_sigtimedwait */
	.byte 0x11, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xdc, 0xa8, 0x64, 0x77, 0x61, 0xea	/* T__pfx___ia32_sys_rt_sigtimedwait */
	.byte 0x11, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xdc, 0xa8, 0x64, 0x77, 0x61, 0xea	/* T__ia32_sys_rt_sigtimedwait */
	.byte 0x14, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xdc, 0xa8, 0x64, 0x77, 0x61, 0x9d, 0xdc, 0xa8, 0x33, 0x32	/* T__pfx___x64_sys_rt_sigtimedwait_time32 */
	.byte 0x14, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xdc, 0xa8, 0x64, 0x77, 0x61, 0x9d, 0xdc, 0xa8, 0x33, 0x32	/* T__x64_sys_rt_sigtimedwait_time32 */
	.byte 0x15, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xdc, 0xa8, 0x64, 0x77, 0x61, 0x9d, 0xdc, 0xa8, 0x33, 0x32	/* T__pfx___ia32_sys_rt_sigtimedwait_time32 */
	.byte 0x15, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xdc, 0xa8, 0x64, 0x77, 0x61, 0x9d, 0xdc, 0xa8, 0x33, 0x32	/* T__ia32_sys_rt_sigtimedwait_time32 */
	.byte 0x19, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xdc, 0xa8, 0x64, 0x77, 0x61, 0x9d, 0xdc, 0xa8, 0x36, 0x34	/* T__pfx___ia32_compat_sys_rt_sigtimedwait_time64 */
	.byte 0x19, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xdc, 0xa8, 0x64, 0x77, 0x61, 0x9d, 0xdc, 0xa8, 0x36, 0x34	/* T__ia32_compat_sys_rt_sigtimedwait_time64 */
	.byte 0x19, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xdc, 0xa8, 0x64, 0x77, 0x61, 0x9d, 0xdc, 0xa8, 0x33, 0x32	/* T__pfx___ia32_compat_sys_rt_sigtimedwait_time32 */
	.byte 0x19, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xdc, 0xa8, 0x64, 0x77, 0x61, 0x9d, 0xdc, 0xa8, 0x33, 0x32	/* T__ia32_compat_sys_rt_sigtimedwait_time32 */
	.byte 0x0a, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x6b, 0x69, 0x6c, 0x6c	/* T__pfx___x64_sys_kill */
	.byte 0x0a, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x6b, 0x69, 0x6c, 0x6c	/* T__x64_sys_kill */
	.byte 0x0b, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x6b, 0x69, 0x6c, 0x6c	/* T__pfx___ia32_sys_kill */
	.byte 0x0b, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x6b, 0x69, 0x6c, 0x6c	/* T__ia32_sys_kill */
	.byte 0x11, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x9f, 0x66, 0x64, 0xf6, 0xf1, 0x64, 0xf6, 0x0c, 0x6e, 0xe5	/* T__pfx___x64_sys_pidfd_send_signal */
	.byte 0x11, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x9f, 0x66, 0x64, 0xf6, 0xf1, 0x64, 0xf6, 0x0c, 0x6e, 0xe5	/* T__x64_sys_pidfd_send_signal */
	.byte 0x12, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x9f, 0x66, 0x64, 0xf6, 0xf1, 0x64, 0xf6, 0x0c, 0x6e, 0xe5	/* T__pfx___ia32_sys_pidfd_send_signal */
	.byte 0x12, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x9f, 0x66, 0x64, 0xf6, 0xf1, 0x64, 0xf6, 0x0c, 0x6e, 0xe5	/* T__ia32_sys_pidfd_send_signal */
	.byte 0x0c, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x74, 0x67, 0x6b, 0x69, 0x6c, 0x6c	/* T__pfx___x64_sys_tgkill */
	.byte 0x0c, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x74, 0x67, 0x6b, 0x69, 0x6c, 0x6c	/* T__x64_sys_tgkill */
	.byte 0x0d, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x74, 0x67, 0x6b, 0x69, 0x6c, 0x6c	/* T__pfx___ia32_sys_tgkill */
	.byte 0x0d, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x74, 0x67, 0x6b, 0x69, 0x6c, 0x6c	/* T__ia32_sys_tgkill */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x74, 0x6b, 0x69, 0x6c, 0x6c	/* T__pfx___x64_sys_tkill */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x74, 0x6b, 0x69, 0x6c, 0x6c	/* T__x64_sys_tkill */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x74, 0x6b, 0x69, 0x6c, 0x6c	/* T__pfx___ia32_sys_tkill */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x74, 0x6b, 0x69, 0x6c, 0x6c	/* T__ia32_sys_tkill */
	.byte 0x11, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xa1, 0x65, 0x75, 0x65, 0xf8, 0x66, 0x6f	/* T__pfx___x64_sys_rt_sigqueueinfo */
	.byte 0x11, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xa1, 0x65, 0x75, 0x65, 0xf8, 0x66, 0x6f	/* T__x64_sys_rt_sigqueueinfo */
	.byte 0x12, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xa1, 0x65, 0x75, 0x65, 0xf8, 0x66, 0x6f	/* T__pfx___ia32_sys_rt_sigqueueinfo */
	.byte 0x12, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xa1, 0x65, 0x75, 0x65, 0xf8, 0x66, 0x6f	/* T__ia32_sys_rt_sigqueueinfo */
	.byte 0x16, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xa1, 0x65, 0x75, 0x65, 0xf8, 0x66, 0x6f	/* T__pfx___ia32_compat_sys_rt_sigqueueinfo */
	.byte 0x16, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xa1, 0x65, 0x75, 0x65, 0xf8, 0x66, 0x6f	/* T__ia32_compat_sys_rt_sigqueueinfo */
	.byte 0x13, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x72, 0xfe, 0x74, 0x67, 0x85, 0x67, 0xa1, 0x65, 0x75, 0x65, 0xf8, 0x66, 0x6f	/* T__pfx___x64_sys_rt_tgsigqueueinfo */
	.byte 0x13, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x72, 0xfe, 0x74, 0x67, 0x85, 0x67, 0xa1, 0x65, 0x75, 0x65, 0xf8, 0x66, 0x6f	/* T__x64_sys_rt_tgsigqueueinfo */
	.byte 0x14, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x72, 0xfe, 0x74, 0x67, 0x85, 0x67, 0xa1, 0x65, 0x75, 0x65, 0xf8, 0x66, 0x6f	/* T__pfx___ia32_sys_rt_tgsigqueueinfo */
	.byte 0x14, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x72, 0xfe, 0x74, 0x67, 0x85, 0x67, 0xa1, 0x65, 0x75, 0x65, 0xf8, 0x66, 0x6f	/* T__ia32_sys_rt_tgsigqueueinfo */
	.byte 0x18, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x72, 0xfe, 0x74, 0x67, 0x85, 0x67, 0xa1, 0x65, 0x75, 0x65, 0xf8, 0x66, 0x6f	/* T__pfx___ia32_compat_sys_rt_tgsigqueueinfo */
	.byte 0x18, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x72, 0xfe, 0x74, 0x67, 0x85, 0x67, 0xa1, 0x65, 0x75, 0x65, 0xf8, 0x66, 0x6f	/* T__ia32_compat_sys_rt_tgsigqueueinfo */
	.byte 0x08, 0xeb, 0x64, 0x6f, 0xf6, 0x0c, 0xf2, 0xdc, 0xe7	/* T__pfx_do_sigaction */
	.byte 0x08, 0x54, 0x64, 0x6f, 0xf6, 0x0c, 0xf2, 0xdc, 0xe7	/* Tdo_sigaction */
	.byte 0x0c, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x0c, 0xe5, 0x93, 0xf4, 0xc6	/* T__pfx___x64_sys_sigaltstack */
	.byte 0x0c, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x0c, 0xe5, 0x93, 0xf4, 0xc6	/* T__x64_sys_sigaltstack */
	.byte 0x0d, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x0c, 0xe5, 0x93, 0xf4, 0xc6	/* T__pfx___ia32_sys_sigaltstack */
	.byte 0x0d, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x0c, 0xe5, 0x93, 0xf4, 0xc6	/* T__ia32_sys_sigaltstack */
	.byte 0x09, 0xeb, 0x29, 0x74, 0xd5, 0xfc, 0xe5, 0x93, 0xf4, 0xc6	/* T__pfx_restore_altstack */
	.byte 0x09, 0x54, 0x29, 0x74, 0xd5, 0xfc, 0xe5, 0x93, 0xf4, 0xc6	/* Trestore_altstack */
	.byte 0x08, 0x99, 0xf6, 0x61, 0x1a, 0xe5, 0x93, 0xf4, 0xc6	/* T__pfx___save_altstack */
	.byte 0x08, 0xb9, 0x73, 0x61, 0x1a, 0xe5, 0x93, 0xf4, 0xc6	/* T__save_altstack */
	.byte 0x11, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0xf6, 0x0c, 0xe5, 0x93, 0xf4, 0xc6	/* T__pfx___ia32_compat_sys_sigaltstack */
	.byte 0x11, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0xf6, 0x0c, 0xe5, 0x93, 0xf4, 0xc6	/* T__ia32_compat_sys_sigaltstack */
	.byte 0x0d, 0xeb, 0x03, 0xb6, 0x61, 0xfe, 0x29, 0x74, 0xd5, 0xfc, 0xe5, 0x93, 0xf4, 0xc6	/* T__pfx_compat_restore_altstack */
	.byte 0x0d, 0x54, 0x03, 0xb6, 0x61, 0xfe, 0x29, 0x74, 0xd5, 0xfc, 0xe5, 0x93, 0xf4, 0xc6	/* Tcompat_restore_altstack */
	.byte 0x0c, 0x99, 0x3a, 0xb6, 0x61, 0xfe, 0x73, 0x61, 0x1a, 0xe5, 0x93, 0xf4, 0xc6	/* T__pfx___compat_save_altstack */
	.byte 0x0c, 0xb9, 0x03, 0xb6, 0x61, 0xfe, 0x73, 0x61, 0x1a, 0xe5, 0x93, 0xf4, 0xc6	/* T__compat_save_altstack */
	.byte 0x0c, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x0c, 0x70, 0xf1, 0x64, 0x8d	/* T__pfx___x64_sys_sigpending */
	.byte 0x0c, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x0c, 0x70, 0xf1, 0x64, 0x8d	/* T__x64_sys_sigpending */
	.byte 0x0d, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x0c, 0x70, 0xf1, 0x64, 0x8d	/* T__pfx___ia32_sys_sigpending */
	.byte 0x0d, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x0c, 0x70, 0xf1, 0x64, 0x8d	/* T__ia32_sys_sigpending */
	.byte 0x11, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0xf6, 0x0c, 0x70, 0xf1, 0x64, 0x8d	/* T__pfx___ia32_compat_sys_sigpending */
	.byte 0x11, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0xf6, 0x0c, 0x70, 0xf1, 0x64, 0x8d	/* T__ia32_compat_sys_sigpending */
	.byte 0x0d, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x0c, 0x70, 0xe3, 0x63, 0xd9, 0x5e	/* T__pfx___x64_sys_sigprocmask */
	.byte 0x0d, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x0c, 0x70, 0xe3, 0x63, 0xd9, 0x5e	/* T__x64_sys_sigprocmask */
	.byte 0x0e, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x0c, 0x70, 0xe3, 0x63, 0xd9, 0x5e	/* T__pfx___ia32_sys_sigprocmask */
	.byte 0x0e, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x0c, 0x70, 0xe3, 0x63, 0xd9, 0x5e	/* T__ia32_sys_sigprocmask */
	.byte 0x0d, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xf2, 0xdc, 0xe7	/* T__pfx___x64_sys_rt_sigaction */
	.byte 0x0d, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xf2, 0xdc, 0xe7	/* T__x64_sys_rt_sigaction */
	.byte 0x0e, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xf2, 0xdc, 0xe7	/* T__pfx___ia32_sys_rt_sigaction */
	.byte 0x0e, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xf2, 0xdc, 0xe7	/* T__ia32_sys_rt_sigaction */
	.byte 0x12, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xf2, 0xdc, 0xe7	/* T__pfx___ia32_compat_sys_rt_sigaction */
	.byte 0x12, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0xf2, 0xdc, 0xe7	/* T__ia32_compat_sys_rt_sigaction */
	.byte 0x10, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0xf6, 0x0c, 0xf2, 0xdc, 0xe7	/* T__pfx___ia32_compat_sys_sigaction */
	.byte 0x10, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0xf6, 0x0c, 0xf2, 0xdc, 0xe7	/* T__ia32_compat_sys_sigaction */
	.byte 0x0b, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0x73, 0xf6, 0x67, 0xd4, 0xd9, 0x5e	/* t__pfx___do_sys_sgetmask */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x67, 0xd4, 0xd9, 0x5e	/* T__pfx___ia32_sys_sgetmask */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x67, 0xd4, 0xd9, 0x5e	/* T__pfx___x64_sys_sgetmask */
	.byte 0x0b, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0x73, 0xf6, 0x67, 0xd4, 0xd9, 0x5e	/* t__do_sys_sgetmask */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x67, 0xd4, 0xd9, 0x5e	/* T__ia32_sys_sgetmask */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x67, 0xd4, 0xd9, 0x5e	/* T__x64_sys_sgetmask */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x73, 0xd4, 0xd9, 0x5e	/* T__pfx___x64_sys_ssetmask */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x73, 0xd4, 0xd9, 0x5e	/* T__x64_sys_ssetmask */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x73, 0xd4, 0xd9, 0x5e	/* T__pfx___ia32_sys_ssetmask */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x73, 0xd4, 0xd9, 0x5e	/* T__ia32_sys_ssetmask */
	.byte 0x0a, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x0c, 0x6e, 0xe5	/* T__pfx___x64_sys_signal */
	.byte 0x0a, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x0c, 0x6e, 0xe5	/* T__x64_sys_signal */
	.byte 0x0b, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x0c, 0x6e, 0xe5	/* T__pfx___ia32_sys_signal */
	.byte 0x0b, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x0c, 0x6e, 0xe5	/* T__ia32_sys_signal */
	.byte 0x0a, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0x73, 0xec, 0x61, 0xb1, 0x65	/* t__pfx___do_sys_pause */
	.byte 0x0b, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x61, 0xb1, 0x65	/* T__pfx___ia32_sys_pause */
	.byte 0x0a, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x61, 0xb1, 0x65	/* T__pfx___x64_sys_pause */
	.byte 0x0a, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0x73, 0xec, 0x61, 0xb1, 0x65	/* t__do_sys_pause */
	.byte 0x0b, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x61, 0xb1, 0x65	/* T__ia32_sys_pause */
	.byte 0x0a, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x61, 0xb1, 0x65	/* T__x64_sys_pause */
	.byte 0x0f, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0x73, 0xb1, 0x70, 0xf1, 0x64	/* T__pfx___x64_sys_rt_sigsuspend */
	.byte 0x0f, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0x73, 0xb1, 0x70, 0xf1, 0x64	/* T__x64_sys_rt_sigsuspend */
	.byte 0x10, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0x73, 0xb1, 0x70, 0xf1, 0x64	/* T__pfx___ia32_sys_rt_sigsuspend */
	.byte 0x10, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0x73, 0xb1, 0x70, 0xf1, 0x64	/* T__ia32_sys_rt_sigsuspend */
	.byte 0x14, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0x73, 0xb1, 0x70, 0xf1, 0x64	/* T__pfx___ia32_compat_sys_rt_sigsuspend */
	.byte 0x14, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x72, 0xfe, 0x85, 0x67, 0x73, 0xb1, 0x70, 0xf1, 0x64	/* T__ia32_compat_sys_rt_sigsuspend */
	.byte 0x0d, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x0c, 0x73, 0xb1, 0x70, 0xf1, 0x64	/* T__pfx___x64_sys_sigsuspend */
	.byte 0x0d, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x0c, 0x73, 0xb1, 0x70, 0xf1, 0x64	/* T__x64_sys_sigsuspend */
	.byte 0x0e, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x0c, 0x73, 0xb1, 0x70, 0xf1, 0x64	/* T__pfx___ia32_sys_sigsuspend */
	.byte 0x0e, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x0c, 0x73, 0xb1, 0x70, 0xf1, 0x64	/* T__ia32_sys_sigsuspend */
	.byte 0x0a, 0x57, 0xf9, 0xc5, 0xba, 0x5f, 0x76, 0xd9, 0xbd, 0x61, 0xa8	/* W__pfx_arch_vma_name */
	.byte 0x09, 0x57, 0xc5, 0xba, 0x5f, 0x76, 0xd9, 0xbd, 0x61, 0xa8	/* Warch_vma_name */
	.byte 0x11, 0xef, 0x70, 0xe3, 0x70, 0x83, 0x91, 0x68, 0xbb, 0x25, 0x69, 0x6c, 0x64, 0xf6, 0x88, 0xf7, 0x61, 0x19	/* t__pfx_propagate_has_child_subreaper */
	.byte 0x10, 0xce, 0xe3, 0x70, 0x83, 0x91, 0x68, 0xbb, 0x25, 0x69, 0x6c, 0x64, 0xf6, 0x88, 0xf7, 0x61, 0x19	/* tpropagate_has_child_subreaper */
	.byte 0x08, 0xef, 0x73, 0xe2, 0xe7, 0xfc, 0x70, 0x72, 0xc0	/* t__pfx_set_one_prio */
	.byte 0x07, 0x93, 0xe2, 0xe7, 0xfc, 0x70, 0x72, 0xc0	/* tset_one_prio */
	.byte 0x0e, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0x73, 0xf6, 0xd4, 0x70, 0x72, 0x69, 0xd5, 0xea, 0x79	/* t__pfx___do_sys_setpriority */
	.byte 0x0e, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0x73, 0xf6, 0xd4, 0x70, 0x72, 0x69, 0xd5, 0xea, 0x79	/* t__do_sys_setpriority */
	.byte 0x0e, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0xe9, 0x67, 0xd4, 0x70, 0x72, 0x69, 0xd5, 0xea, 0x79	/* t__pfx___do_sys_getpriority */
	.byte 0x0e, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0xe9, 0x67, 0xd4, 0x70, 0x72, 0x69, 0xd5, 0xea, 0x79	/* t__do_sys_getpriority */
	.byte 0x0d, 0xef, 0x66, 0x6c, 0x83, 0xbd, 0x70, 0xe3, 0xc9, 0xcb, 0x63, 0x65, 0x9e, 0x9e	/* t__pfx_flag_nproc_exceeded */
	.byte 0x0d, 0x74, 0x66, 0x6c, 0x83, 0xbd, 0x70, 0xe3, 0xc9, 0xcb, 0x63, 0x65, 0x9e, 0x9e	/* tflag_nproc_exceeded */
	.byte 0x07, 0xef, 0x64, 0x6f, 0x7f, 0xe9, 0x00, 0xd6	/* t__pfx_do_sys_times */
	.byte 0x07, 0x74, 0x64, 0x6f, 0x7f, 0xe9, 0x00, 0xd6	/* tdo_sys_times */
	.byte 0x0b, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0x73, 0xf6, 0xd4, 0x70, 0x67, 0x9f	/* t__pfx___do_sys_setpgid */
	.byte 0x0b, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0x73, 0xf6, 0xd4, 0x70, 0x67, 0x9f	/* t__do_sys_setpgid */
	.byte 0x08, 0xef, 0x64, 0x6f, 0xc7, 0xd4, 0x70, 0x67, 0x9f	/* t__pfx_do_getpgid */
	.byte 0x08, 0x74, 0x64, 0x6f, 0xc7, 0xd4, 0x70, 0x67, 0x9f	/* tdo_getpgid */
	.byte 0x0a, 0xef, 0x6f, 0x0b, 0x72, 0x9f, 0xfc, 0xf7, 0xc4, 0xbb, 0x65	/* t__pfx_override_release */
	.byte 0x09, 0x8a, 0x0b, 0x72, 0x9f, 0xfc, 0xf7, 0xc4, 0xbb, 0x65	/* toverride_release */
	.byte 0x0c, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0xe9, 0x6e, 0x65, 0x77, 0xe4, 0x61, 0xa8	/* t__pfx___do_sys_newuname */
	.byte 0x0c, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0xe9, 0x6e, 0x65, 0x77, 0xe4, 0x61, 0xa8	/* t__do_sys_newuname */
	.byte 0x09, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0xe9, 0xe4, 0x61, 0xa8	/* t__pfx___do_sys_uname */
	.byte 0x09, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0xe9, 0xe4, 0x61, 0xa8	/* t__do_sys_uname */
	.byte 0x0a, 0xef, 0x70, 0x72, 0x63, 0x23, 0x84, 0x61, 0x75, 0x78, 0x76	/* t__pfx_prctl_set_auxv */
	.byte 0x09, 0xce, 0x72, 0x63, 0x23, 0x84, 0x61, 0x75, 0x78, 0x76	/* tprctl_set_auxv */
	.byte 0x09, 0xef, 0x64, 0x6f, 0xec, 0x72, 0x6c, 0x69, 0x6d, 0xea	/* t__pfx_do_prlimit */
	.byte 0x09, 0x74, 0x64, 0x6f, 0xec, 0x72, 0x6c, 0x69, 0x6d, 0xea	/* tdo_prlimit */
	.byte 0x0e, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0x73, 0xec, 0x72, 0x6c, 0x69, 0x6d, 0xea, 0x36, 0x34	/* t__pfx___do_sys_prlimit64 */
	.byte 0x0e, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0x73, 0xec, 0x72, 0x6c, 0x69, 0x6d, 0xea, 0x36, 0x34	/* t__do_sys_prlimit64 */
	.byte 0x0c, 0xef, 0x64, 0x6f, 0x7f, 0x73, 0xf8, 0x66, 0x6f, 0x2e, 0xca, 0xbc, 0x7e	/* t__pfx_do_sysinfo.isra.0 */
	.byte 0x0c, 0x74, 0x64, 0x6f, 0x7f, 0x73, 0xf8, 0x66, 0x6f, 0x2e, 0xca, 0xbc, 0x7e	/* tdo_sysinfo.isra.0 */
	.byte 0x0f, 0x74, 0xaf, 0xed, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0x7f, 0x73, 0xf8, 0x66, 0x6f	/* t__pfx___do_compat_sys_sysinfo */
	.byte 0x0f, 0x74, 0xff, 0x64, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0x7f, 0x73, 0xf8, 0x66, 0x6f	/* t__do_compat_sys_sysinfo */
	.byte 0x0b, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0x73, 0x7f, 0x73, 0xf8, 0x66, 0x6f	/* t__pfx___do_sys_sysinfo */
	.byte 0x0b, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0x73, 0x7f, 0x73, 0xf8, 0x66, 0x6f	/* t__do_sys_sysinfo */
	.byte 0x08, 0xef, 0x70, 0x72, 0x63, 0x23, 0x84, 0x6d, 0x6d	/* t__pfx_prctl_set_mm */
	.byte 0x07, 0xce, 0x72, 0x63, 0x23, 0x84, 0x6d, 0x6d	/* tprctl_set_mm */
	.byte 0x0e, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x70, 0x72, 0x69, 0xd5, 0xea, 0x79	/* T__pfx___x64_sys_setpriority */
	.byte 0x0e, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x70, 0x72, 0x69, 0xd5, 0xea, 0x79	/* T__x64_sys_setpriority */
	.byte 0x0f, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x70, 0x72, 0x69, 0xd5, 0xea, 0x79	/* T__pfx___ia32_sys_setpriority */
	.byte 0x0f, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x70, 0x72, 0x69, 0xd5, 0xea, 0x79	/* T__ia32_sys_setpriority */
	.byte 0x0e, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x70, 0x72, 0x69, 0xd5, 0xea, 0x79	/* T__pfx___x64_sys_getpriority */
	.byte 0x0e, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x70, 0x72, 0x69, 0xd5, 0xea, 0x79	/* T__x64_sys_getpriority */
	.byte 0x0f, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x70, 0x72, 0x69, 0xd5, 0xea, 0x79	/* T__pfx___ia32_sys_getpriority */
	.byte 0x0f, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x70, 0x72, 0x69, 0xd5, 0xea, 0x79	/* T__ia32_sys_getpriority */
	.byte 0x08, 0x99, 0x7f, 0x73, 0xf6, 0xd4, 0xf7, 0x67, 0x9f	/* T__pfx___sys_setregid */
	.byte 0x08, 0xb9, 0xe1, 0x73, 0xf6, 0xd4, 0xf7, 0x67, 0x9f	/* T__sys_setregid */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0xf7, 0x67, 0x9f	/* T__pfx___x64_sys_setregid */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0xf7, 0x67, 0x9f	/* T__x64_sys_setregid */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0xf7, 0x67, 0x9f	/* T__pfx___ia32_sys_setregid */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0xf7, 0x67, 0x9f	/* T__ia32_sys_setregid */
	.byte 0x07, 0x99, 0x7f, 0x73, 0xf6, 0xd4, 0x67, 0x9f	/* T__pfx___sys_setgid */
	.byte 0x07, 0xb9, 0xe1, 0x73, 0xf6, 0xd4, 0x67, 0x9f	/* T__sys_setgid */
	.byte 0x0a, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x67, 0x9f	/* T__pfx___x64_sys_setgid */
	.byte 0x0a, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x67, 0x9f	/* T__x64_sys_setgid */
	.byte 0x0b, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x67, 0x9f	/* T__pfx___ia32_sys_setgid */
	.byte 0x0b, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x67, 0x9f	/* T__ia32_sys_setgid */
	.byte 0x08, 0x99, 0x7f, 0x73, 0xf6, 0xd4, 0xf7, 0x75, 0x9f	/* T__pfx___sys_setreuid */
	.byte 0x08, 0xb9, 0xe1, 0x73, 0xf6, 0xd4, 0xf7, 0x75, 0x9f	/* T__sys_setreuid */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0xf7, 0x75, 0x9f	/* T__pfx___x64_sys_setreuid */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0xf7, 0x75, 0x9f	/* T__x64_sys_setreuid */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0xf7, 0x75, 0x9f	/* T__pfx___ia32_sys_setreuid */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0xf7, 0x75, 0x9f	/* T__ia32_sys_setreuid */
	.byte 0x07, 0x99, 0x7f, 0x73, 0xf6, 0xd4, 0x75, 0x9f	/* T__pfx___sys_setuid */
	.byte 0x07, 0xb9, 0xe1, 0x73, 0xf6, 0xd4, 0x75, 0x9f	/* T__sys_setuid */
	.byte 0x0a, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x75, 0x9f	/* T__pfx___x64_sys_setuid */
	.byte 0x0a, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x75, 0x9f	/* T__x64_sys_setuid */
	.byte 0x0b, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x75, 0x9f	/* T__pfx___ia32_sys_setuid */
	.byte 0x0b, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x75, 0x9f	/* T__ia32_sys_setuid */
	.byte 0x08, 0x99, 0x7f, 0x73, 0xf6, 0xd4, 0x29, 0x75, 0x9f	/* T__pfx___sys_setresuid */
	.byte 0x08, 0xb9, 0xe1, 0x73, 0xf6, 0xd4, 0x29, 0x75, 0x9f	/* T__sys_setresuid */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x29, 0x75, 0x9f	/* T__pfx___x64_sys_setresuid */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x29, 0x75, 0x9f	/* T__x64_sys_setresuid */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x29, 0x75, 0x9f	/* T__pfx___ia32_sys_setresuid */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x29, 0x75, 0x9f	/* T__ia32_sys_setresuid */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x29, 0x75, 0x9f	/* T__pfx___x64_sys_getresuid */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x29, 0x75, 0x9f	/* T__x64_sys_getresuid */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x29, 0x75, 0x9f	/* T__pfx___ia32_sys_getresuid */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x29, 0x75, 0x9f	/* T__ia32_sys_getresuid */
	.byte 0x08, 0x99, 0x7f, 0x73, 0xf6, 0xd4, 0x29, 0x67, 0x9f	/* T__pfx___sys_setresgid */
	.byte 0x08, 0xb9, 0xe1, 0x73, 0xf6, 0xd4, 0x29, 0x67, 0x9f	/* T__sys_setresgid */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x29, 0x67, 0x9f	/* T__pfx___x64_sys_setresgid */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x29, 0x67, 0x9f	/* T__x64_sys_setresgid */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x29, 0x67, 0x9f	/* T__pfx___ia32_sys_setresgid */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x29, 0x67, 0x9f	/* T__ia32_sys_setresgid */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x29, 0x67, 0x9f	/* T__pfx___x64_sys_getresgid */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x29, 0x67, 0x9f	/* T__x64_sys_getresgid */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x29, 0x67, 0x9f	/* T__pfx___ia32_sys_getresgid */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x29, 0x67, 0x9f	/* T__ia32_sys_getresgid */
	.byte 0x08, 0x99, 0x7f, 0x73, 0xf6, 0xd4, 0x95, 0x75, 0x9f	/* T__pfx___sys_setfsuid */
	.byte 0x08, 0xb9, 0xe1, 0x73, 0xf6, 0xd4, 0x95, 0x75, 0x9f	/* T__sys_setfsuid */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x95, 0x75, 0x9f	/* T__pfx___x64_sys_setfsuid */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x95, 0x75, 0x9f	/* T__x64_sys_setfsuid */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x95, 0x75, 0x9f	/* T__pfx___ia32_sys_setfsuid */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x95, 0x75, 0x9f	/* T__ia32_sys_setfsuid */
	.byte 0x08, 0x99, 0x7f, 0x73, 0xf6, 0xd4, 0x95, 0x67, 0x9f	/* T__pfx___sys_setfsgid */
	.byte 0x08, 0xb9, 0xe1, 0x73, 0xf6, 0xd4, 0x95, 0x67, 0x9f	/* T__sys_setfsgid */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x95, 0x67, 0x9f	/* T__pfx___x64_sys_setfsgid */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x95, 0x67, 0x9f	/* T__x64_sys_setfsgid */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x95, 0x67, 0x9f	/* T__pfx___ia32_sys_setfsgid */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x95, 0x67, 0x9f	/* T__ia32_sys_setfsgid */
	.byte 0x0a, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0xe9, 0x67, 0xd4, 0xb2, 0x64	/* t__pfx___do_sys_getpid */
	.byte 0x0b, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0xb2, 0x64	/* T__pfx___ia32_sys_getpid */
	.byte 0x0a, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0xb2, 0x64	/* T__pfx___x64_sys_getpid */
	.byte 0x0a, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0xe9, 0x67, 0xd4, 0xb2, 0x64	/* t__do_sys_getpid */
	.byte 0x0b, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0xb2, 0x64	/* T__ia32_sys_getpid */
	.byte 0x0a, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0xb2, 0x64	/* T__x64_sys_getpid */
	.byte 0x0a, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0xe9, 0x67, 0xd4, 0xdc, 0x64	/* t__pfx___do_sys_gettid */
	.byte 0x0b, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0xdc, 0x64	/* T__pfx___ia32_sys_gettid */
	.byte 0x0a, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0xdc, 0x64	/* T__pfx___x64_sys_gettid */
	.byte 0x0a, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0xe9, 0x67, 0xd4, 0xdc, 0x64	/* t__do_sys_gettid */
	.byte 0x0b, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0xdc, 0x64	/* T__ia32_sys_gettid */
	.byte 0x0a, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0xdc, 0x64	/* T__x64_sys_gettid */
	.byte 0x0b, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0xe9, 0x67, 0xd4, 0x70, 0xb2, 0x64	/* t__pfx___do_sys_getppid */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x70, 0xb2, 0x64	/* T__pfx___ia32_sys_getppid */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x70, 0xb2, 0x64	/* T__pfx___x64_sys_getppid */
	.byte 0x0b, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0xe9, 0x67, 0xd4, 0x70, 0xb2, 0x64	/* t__do_sys_getppid */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x70, 0xb2, 0x64	/* T__ia32_sys_getppid */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x70, 0xb2, 0x64	/* T__x64_sys_getppid */
	.byte 0x0a, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0xe9, 0x67, 0xd4, 0x75, 0x9f	/* t__pfx___do_sys_getuid */
	.byte 0x0b, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x75, 0x9f	/* T__pfx___ia32_sys_getuid */
	.byte 0x0a, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x75, 0x9f	/* T__pfx___x64_sys_getuid */
	.byte 0x0a, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0xe9, 0x67, 0xd4, 0x75, 0x9f	/* t__do_sys_getuid */
	.byte 0x0b, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x75, 0x9f	/* T__ia32_sys_getuid */
	.byte 0x0a, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x75, 0x9f	/* T__x64_sys_getuid */
	.byte 0x0b, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0xe9, 0x67, 0xd4, 0x65, 0x75, 0x9f	/* t__pfx___do_sys_geteuid */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x65, 0x75, 0x9f	/* T__pfx___ia32_sys_geteuid */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x65, 0x75, 0x9f	/* T__pfx___x64_sys_geteuid */
	.byte 0x0b, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0xe9, 0x67, 0xd4, 0x65, 0x75, 0x9f	/* t__do_sys_geteuid */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x65, 0x75, 0x9f	/* T__ia32_sys_geteuid */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x65, 0x75, 0x9f	/* T__x64_sys_geteuid */
	.byte 0x0a, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0xe9, 0x67, 0xd4, 0x67, 0x9f	/* t__pfx___do_sys_getgid */
	.byte 0x0b, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x67, 0x9f	/* T__pfx___ia32_sys_getgid */
	.byte 0x0a, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x67, 0x9f	/* T__pfx___x64_sys_getgid */
	.byte 0x0a, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0xe9, 0x67, 0xd4, 0x67, 0x9f	/* t__do_sys_getgid */
	.byte 0x0b, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x67, 0x9f	/* T__ia32_sys_getgid */
	.byte 0x0a, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x67, 0x9f	/* T__x64_sys_getgid */
	.byte 0x0b, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0xe9, 0x67, 0xd4, 0x65, 0x67, 0x9f	/* t__pfx___do_sys_getegid */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x65, 0x67, 0x9f	/* T__pfx___ia32_sys_getegid */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x65, 0x67, 0x9f	/* T__pfx___x64_sys_getegid */
	.byte 0x0b, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0xe9, 0x67, 0xd4, 0x65, 0x67, 0x9f	/* t__do_sys_getegid */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x65, 0x67, 0x9f	/* T__ia32_sys_getegid */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x65, 0x67, 0x9f	/* T__x64_sys_getegid */
	.byte 0x08, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x00, 0xd6	/* T__pfx___x64_sys_times */
	.byte 0x08, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x00, 0xd6	/* T__x64_sys_times */
	.byte 0x09, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x00, 0xd6	/* T__pfx___ia32_sys_times */
	.byte 0x09, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x00, 0xd6	/* T__ia32_sys_times */
	.byte 0x0d, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x00, 0xd6	/* T__pfx___ia32_compat_sys_times */
	.byte 0x0d, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x00, 0xd6	/* T__ia32_compat_sys_times */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x70, 0x67, 0x9f	/* T__pfx___x64_sys_setpgid */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x70, 0x67, 0x9f	/* T__x64_sys_setpgid */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x70, 0x67, 0x9f	/* T__pfx___ia32_sys_setpgid */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x70, 0x67, 0x9f	/* T__ia32_sys_setpgid */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x70, 0x67, 0x9f	/* T__pfx___x64_sys_getpgid */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x70, 0x67, 0x9f	/* T__x64_sys_getpgid */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x70, 0x67, 0x9f	/* T__pfx___ia32_sys_getpgid */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x70, 0x67, 0x9f	/* T__ia32_sys_getpgid */
	.byte 0x0c, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0xe9, 0x67, 0xd4, 0x70, 0x67, 0x72, 0x70	/* t__pfx___do_sys_getpgrp */
	.byte 0x0d, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x70, 0x67, 0x72, 0x70	/* T__pfx___ia32_sys_getpgrp */
	.byte 0x0c, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x70, 0x67, 0x72, 0x70	/* T__pfx___x64_sys_getpgrp */
	.byte 0x0c, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0xe9, 0x67, 0xd4, 0x70, 0x67, 0x72, 0x70	/* t__do_sys_getpgrp */
	.byte 0x0d, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x70, 0x67, 0x72, 0x70	/* T__ia32_sys_getpgrp */
	.byte 0x0c, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x70, 0x67, 0x72, 0x70	/* T__x64_sys_getpgrp */
	.byte 0x0a, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x73, 0x9f	/* T__pfx___x64_sys_getsid */
	.byte 0x0a, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x73, 0x9f	/* T__x64_sys_getsid */
	.byte 0x0b, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x73, 0x9f	/* T__pfx___ia32_sys_getsid */
	.byte 0x0b, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x73, 0x9f	/* T__ia32_sys_getsid */
	.byte 0x08, 0xeb, 0x6b, 0xe1, 0x73, 0xf6, 0xd4, 0x73, 0x9f	/* T__pfx_ksys_setsid */
	.byte 0x08, 0x54, 0x6b, 0xe1, 0x73, 0xf6, 0xd4, 0x73, 0x9f	/* Tksys_setsid */
	.byte 0x0a, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0x73, 0xf6, 0xd4, 0x73, 0x9f	/* t__pfx___do_sys_setsid */
	.byte 0x0b, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x73, 0x9f	/* T__pfx___ia32_sys_setsid */
	.byte 0x0a, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x73, 0x9f	/* T__pfx___x64_sys_setsid */
	.byte 0x0a, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0x73, 0xf6, 0xd4, 0x73, 0x9f	/* t__do_sys_setsid */
	.byte 0x0b, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x73, 0x9f	/* T__ia32_sys_setsid */
	.byte 0x0a, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x73, 0x9f	/* T__x64_sys_setsid */
	.byte 0x0c, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x6e, 0x65, 0x77, 0xe4, 0x61, 0xa8	/* T__pfx___x64_sys_newuname */
	.byte 0x0c, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x6e, 0x65, 0x77, 0xe4, 0x61, 0xa8	/* T__x64_sys_newuname */
	.byte 0x0d, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x6e, 0x65, 0x77, 0xe4, 0x61, 0xa8	/* T__pfx___ia32_sys_newuname */
	.byte 0x0d, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x6e, 0x65, 0x77, 0xe4, 0x61, 0xa8	/* T__ia32_sys_newuname */
	.byte 0x09, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xe4, 0x61, 0xa8	/* T__pfx___x64_sys_uname */
	.byte 0x09, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xe4, 0x61, 0xa8	/* T__x64_sys_uname */
	.byte 0x0a, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xe4, 0x61, 0xa8	/* T__pfx___ia32_sys_uname */
	.byte 0x0a, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xe4, 0x61, 0xa8	/* T__ia32_sys_uname */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xa0, 0x64, 0xe4, 0x61, 0xa8	/* T__pfx___x64_sys_olduname */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xa0, 0x64, 0xe4, 0x61, 0xa8	/* T__x64_sys_olduname */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xa0, 0x64, 0xe4, 0x61, 0xa8	/* T__pfx___ia32_sys_olduname */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xa0, 0x64, 0xe4, 0x61, 0xa8	/* T__ia32_sys_olduname */
	.byte 0x0f, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0xa8	/* T__pfx___x64_sys_sethostname */
	.byte 0x0f, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0xa8	/* T__x64_sys_sethostname */
	.byte 0x10, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0xa8	/* T__pfx___ia32_sys_sethostname */
	.byte 0x10, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0xa8	/* T__ia32_sys_sethostname */
	.byte 0x0f, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0xa8	/* T__pfx___x64_sys_gethostname */
	.byte 0x0f, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0xa8	/* T__x64_sys_gethostname */
	.byte 0x10, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0xa8	/* T__pfx___ia32_sys_gethostname */
	.byte 0x10, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0xa8	/* T__ia32_sys_gethostname */
	.byte 0x0f, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x64, 0x6f, 0xd9, 0xf8, 0x6e, 0x61, 0xa8	/* T__pfx___x64_sys_setdomainname */
	.byte 0x0f, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x64, 0x6f, 0xd9, 0xf8, 0x6e, 0x61, 0xa8	/* T__x64_sys_setdomainname */
	.byte 0x10, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x64, 0x6f, 0xd9, 0xf8, 0x6e, 0x61, 0xa8	/* T__pfx___ia32_sys_setdomainname */
	.byte 0x10, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x64, 0x6f, 0xd9, 0xf8, 0x6e, 0x61, 0xa8	/* T__ia32_sys_setdomainname */
	.byte 0x0d, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0x65, 0xf3, 0x6c, 0x69, 0x6d, 0xea	/* T__pfx___x64_sys_getrlimit */
	.byte 0x0d, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0x65, 0xf3, 0x6c, 0x69, 0x6d, 0xea	/* T__x64_sys_getrlimit */
	.byte 0x0e, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0x65, 0xf3, 0x6c, 0x69, 0x6d, 0xea	/* T__pfx___ia32_sys_getrlimit */
	.byte 0x0e, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0x65, 0xf3, 0x6c, 0x69, 0x6d, 0xea	/* T__ia32_sys_getrlimit */
	.byte 0x12, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0xf6, 0x65, 0xf3, 0x6c, 0x69, 0x6d, 0xea	/* T__pfx___ia32_compat_sys_setrlimit */
	.byte 0x12, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0xf6, 0x65, 0xf3, 0x6c, 0x69, 0x6d, 0xea	/* T__ia32_compat_sys_setrlimit */
	.byte 0x12, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x67, 0x65, 0xf3, 0x6c, 0x69, 0x6d, 0xea	/* T__pfx___ia32_compat_sys_getrlimit */
	.byte 0x12, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x67, 0x65, 0xf3, 0x6c, 0x69, 0x6d, 0xea	/* T__ia32_compat_sys_getrlimit */
	.byte 0x0f, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xa0, 0xda, 0x67, 0x65, 0xf3, 0x6c, 0x69, 0x6d, 0xea	/* T__pfx___x64_sys_old_getrlimit */
	.byte 0x0f, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xa0, 0xda, 0x67, 0x65, 0xf3, 0x6c, 0x69, 0x6d, 0xea	/* T__x64_sys_old_getrlimit */
	.byte 0x10, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xa0, 0xda, 0x67, 0x65, 0xf3, 0x6c, 0x69, 0x6d, 0xea	/* T__pfx___ia32_sys_old_getrlimit */
	.byte 0x10, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xa0, 0xda, 0x67, 0x65, 0xf3, 0x6c, 0x69, 0x6d, 0xea	/* T__ia32_sys_old_getrlimit */
	.byte 0x14, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0xa0, 0xda, 0x67, 0x65, 0xf3, 0x6c, 0x69, 0x6d, 0xea	/* T__pfx___ia32_compat_sys_old_getrlimit */
	.byte 0x14, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0xa0, 0xda, 0x67, 0x65, 0xf3, 0x6c, 0x69, 0x6d, 0xea	/* T__ia32_compat_sys_old_getrlimit */
	.byte 0x0e, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x72, 0x6c, 0x69, 0x6d, 0xea, 0x36, 0x34	/* T__pfx___x64_sys_prlimit64 */
	.byte 0x0e, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x72, 0x6c, 0x69, 0x6d, 0xea, 0x36, 0x34	/* T__x64_sys_prlimit64 */
	.byte 0x0f, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x72, 0x6c, 0x69, 0x6d, 0xea, 0x36, 0x34	/* T__pfx___ia32_sys_prlimit64 */
	.byte 0x0f, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x72, 0x6c, 0x69, 0x6d, 0xea, 0x36, 0x34	/* T__ia32_sys_prlimit64 */
	.byte 0x0d, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x65, 0xf3, 0x6c, 0x69, 0x6d, 0xea	/* T__pfx___x64_sys_setrlimit */
	.byte 0x0d, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x65, 0xf3, 0x6c, 0x69, 0x6d, 0xea	/* T__x64_sys_setrlimit */
	.byte 0x0e, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x65, 0xf3, 0x6c, 0x69, 0x6d, 0xea	/* T__pfx___ia32_sys_setrlimit */
	.byte 0x0e, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x65, 0xf3, 0x6c, 0x69, 0x6d, 0xea	/* T__ia32_sys_setrlimit */
	.byte 0x07, 0xeb, 0x67, 0x65, 0xf3, 0xb1, 0x83, 0x65	/* T__pfx_getrusage */
	.byte 0x07, 0x54, 0x67, 0x65, 0xf3, 0xb1, 0x83, 0x65	/* Tgetrusage */
	.byte 0x0c, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0xe9, 0x67, 0x65, 0xf3, 0xb1, 0x83, 0x65	/* t__pfx___do_sys_getrusage */
	.byte 0x0c, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0xe9, 0x67, 0x65, 0xf3, 0xb1, 0x83, 0x65	/* t__do_sys_getrusage */
	.byte 0x10, 0x74, 0xaf, 0xed, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x67, 0x65, 0xf3, 0xb1, 0x83, 0x65	/* t__pfx___do_compat_sys_getrusage */
	.byte 0x10, 0x74, 0xff, 0x64, 0x6f, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x67, 0x65, 0xf3, 0xb1, 0x83, 0x65	/* t__do_compat_sys_getrusage */
	.byte 0x0c, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0x65, 0xf3, 0xb1, 0x83, 0x65	/* T__pfx___x64_sys_getrusage */
	.byte 0x0c, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0x65, 0xf3, 0xb1, 0x83, 0x65	/* T__x64_sys_getrusage */
	.byte 0x0d, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0x65, 0xf3, 0xb1, 0x83, 0x65	/* T__pfx___ia32_sys_getrusage */
	.byte 0x0d, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0x65, 0xf3, 0xb1, 0x83, 0x65	/* T__ia32_sys_getrusage */
	.byte 0x11, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x67, 0x65, 0xf3, 0xb1, 0x83, 0x65	/* T__pfx___ia32_compat_sys_getrusage */
	.byte 0x11, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x67, 0x65, 0xf3, 0xb1, 0x83, 0x65	/* T__ia32_compat_sys_getrusage */
	.byte 0x09, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x75, 0xd9, 0x5e	/* T__pfx___x64_sys_umask */
	.byte 0x09, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x75, 0xd9, 0x5e	/* T__x64_sys_umask */
	.byte 0x0a, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x75, 0xd9, 0x5e	/* T__pfx___ia32_sys_umask */
	.byte 0x0a, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x75, 0xd9, 0x5e	/* T__ia32_sys_umask */
	.byte 0x0e, 0x57, 0xf9, 0xc5, 0xba, 0x86, 0x73, 0x68, 0xc8, 0xad, 0xa9, 0xc6, 0xa9, 0x74, 0xb1	/* W__pfx_arch_get_shadow_stack_status */
	.byte 0x0d, 0x57, 0xc5, 0xba, 0x86, 0x73, 0x68, 0xc8, 0xad, 0xa9, 0xc6, 0xa9, 0x74, 0xb1	/* Warch_get_shadow_stack_status */
	.byte 0x0e, 0x57, 0xf9, 0xc5, 0xba, 0x84, 0x73, 0x68, 0xc8, 0xad, 0xa9, 0xc6, 0xa9, 0x74, 0xb1	/* W__pfx_arch_set_shadow_stack_status */
	.byte 0x0d, 0x57, 0xc5, 0xba, 0x84, 0x73, 0x68, 0xc8, 0xad, 0xa9, 0xc6, 0xa9, 0x74, 0xb1	/* Warch_set_shadow_stack_status */
	.byte 0x0f, 0x57, 0xf9, 0xc5, 0xba, 0x5f, 0xa4, 0xf6, 0x68, 0xc8, 0xad, 0xa9, 0xc6, 0xa9, 0x74, 0xb1	/* W__pfx_arch_lock_shadow_stack_status */
	.byte 0x0e, 0x57, 0xc5, 0xba, 0x5f, 0xa4, 0xf6, 0x68, 0xc8, 0xad, 0xa9, 0xc6, 0xa9, 0x74, 0xb1	/* Warch_lock_shadow_stack_status */
	.byte 0x0a, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0x73, 0xec, 0x72, 0x63, 0x23	/* t__pfx___do_sys_prctl */
	.byte 0x0a, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0x73, 0xec, 0x72, 0x63, 0x23	/* t__do_sys_prctl */
	.byte 0x0a, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x72, 0x63, 0x23	/* T__pfx___x64_sys_prctl */
	.byte 0x0a, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x72, 0x63, 0x23	/* T__x64_sys_prctl */
	.byte 0x0b, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x72, 0x63, 0x23	/* T__pfx___ia32_sys_prctl */
	.byte 0x0b, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x72, 0x63, 0x23	/* T__ia32_sys_prctl */
	.byte 0x0a, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x63, 0x9c	/* T__pfx___x64_sys_getcpu */
	.byte 0x0a, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x63, 0x9c	/* T__x64_sys_getcpu */
	.byte 0x0b, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x63, 0x9c	/* T__pfx___ia32_sys_getcpu */
	.byte 0x0b, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x63, 0x9c	/* T__ia32_sys_getcpu */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0x7f, 0x73, 0xf8, 0x66, 0x6f	/* T__pfx___x64_sys_sysinfo */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0x7f, 0x73, 0xf8, 0x66, 0x6f	/* T__x64_sys_sysinfo */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0x7f, 0x73, 0xf8, 0x66, 0x6f	/* T__pfx___ia32_sys_sysinfo */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0x7f, 0x73, 0xf8, 0x66, 0x6f	/* T__ia32_sys_sysinfo */
	.byte 0x10, 0x08, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0x7f, 0x73, 0xf8, 0x66, 0x6f	/* T__pfx___ia32_compat_sys_sysinfo */
	.byte 0x10, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0x7f, 0x73, 0xf8, 0x66, 0x6f	/* T__ia32_compat_sys_sysinfo */
	.byte 0x0e, 0xeb, 0xb1, 0xf5, 0x6d, 0xb7, 0x65, 0x68, 0xdb, 0x19, 0xde, 0x61, 0xda, 0xe4, 0xa4	/* T__pfx_usermodehelper_read_unlock */
	.byte 0x0e, 0x54, 0xb1, 0xf5, 0x6d, 0xb7, 0x65, 0x68, 0xdb, 0x19, 0xde, 0x61, 0xda, 0xe4, 0xa4	/* Tusermodehelper_read_unlock */
	.byte 0x10, 0xeb, 0xb1, 0xf5, 0x6d, 0xb7, 0x65, 0x68, 0xdb, 0x19, 0xde, 0x61, 0xda, 0xa4, 0x92, 0x61, 0xea	/* T__pfx_usermodehelper_read_lock_wait */
	.byte 0x10, 0x54, 0xb1, 0xf5, 0x6d, 0xb7, 0x65, 0x68, 0xdb, 0x19, 0xde, 0x61, 0xda, 0xa4, 0x92, 0x61, 0xea	/* Tusermodehelper_read_lock_wait */
	.byte 0x0b, 0xef, 0x70, 0xe3, 0x63, 0xf0, 0x61, 0x70, 0xa3, 0x05, 0x6c, 0xf5	/* t__pfx_proc_cap_handler */
	.byte 0x0a, 0xce, 0xe3, 0x63, 0xf0, 0x61, 0x70, 0xa3, 0x05, 0x6c, 0xf5	/* tproc_cap_handler */
	.byte 0x0f, 0xeb, 0x63, 0x5d, 0x5f, 0xb1, 0xf5, 0x6d, 0xb7, 0x65, 0x68, 0xdb, 0x19, 0xf6, 0xd4, 0xcd	/* T__pfx_call_usermodehelper_setup */
	.byte 0x0f, 0x54, 0x63, 0x5d, 0x5f, 0xb1, 0xf5, 0x6d, 0xb7, 0x65, 0x68, 0xdb, 0x19, 0xf6, 0xd4, 0xcd	/* Tcall_usermodehelper_setup */
	.byte 0x0f, 0xeb, 0xb1, 0xf5, 0x6d, 0xb7, 0x65, 0x68, 0xdb, 0x19, 0xde, 0x61, 0xda, 0xf3, 0x79, 0xa4	/* T__pfx_usermodehelper_read_trylock */
	.byte 0x0f, 0x54, 0xb1, 0xf5, 0x6d, 0xb7, 0x65, 0x68, 0xdb, 0x19, 0xde, 0x61, 0xda, 0xf3, 0x79, 0xa4	/* Tusermodehelper_read_trylock */
	.byte 0x0f, 0xeb, 0x63, 0x5d, 0x5f, 0xb1, 0xf5, 0x6d, 0xb7, 0x65, 0x68, 0xdb, 0x19, 0x5f, 0xcb, 0xb4	/* T__pfx_call_usermodehelper_exec */
	.byte 0x0f, 0x54, 0x63, 0x5d, 0x5f, 0xb1, 0xf5, 0x6d, 0xb7, 0x65, 0x68, 0xdb, 0x19, 0x5f, 0xcb, 0xb4	/* Tcall_usermodehelper_exec */
	.byte 0x0c, 0xeb, 0x63, 0x5d, 0x5f, 0xb1, 0xf5, 0x6d, 0xb7, 0x65, 0x68, 0xdb, 0x19	/* T__pfx_call_usermodehelper */
	.byte 0x0c, 0x54, 0x63, 0x5d, 0x5f, 0xb1, 0xf5, 0x6d, 0xb7, 0x65, 0x68, 0xdb, 0x19	/* Tcall_usermodehelper */
	.byte 0x14, 0xef, 0x63, 0x5d, 0x5f, 0xb1, 0xf5, 0x6d, 0xb7, 0x65, 0x68, 0xdb, 0x19, 0x5f, 0xcb, 0x65, 0xc9, 0x61, 0xe1, 0x6e, 0x63	/* t__pfx_call_usermodehelper_exec_async */
	.byte 0x13, 0x26, 0x5d, 0x5f, 0xb1, 0xf5, 0x6d, 0xb7, 0x65, 0x68, 0xdb, 0x19, 0x5f, 0xcb, 0x65, 0xc9, 0x61, 0xe1, 0x6e, 0x63	/* tcall_usermodehelper_exec_async */
	.byte 0x13, 0xef, 0x63, 0x5d, 0x5f, 0xb1, 0xf5, 0x6d, 0xb7, 0x65, 0x68, 0xdb, 0x19, 0x5f, 0xcb, 0x65, 0xc9, 0x77, 0xd5, 0x6b	/* t__pfx_call_usermodehelper_exec_work */
	.byte 0x12, 0x26, 0x5d, 0x5f, 0xb1, 0xf5, 0x6d, 0xb7, 0x65, 0x68, 0xdb, 0x19, 0x5f, 0xcb, 0x65, 0xc9, 0x77, 0xd5, 0x6b	/* tcall_usermodehelper_exec_work */
	.byte 0x13, 0x08, 0xb1, 0xf5, 0x6d, 0xb7, 0x65, 0x68, 0xdb, 0x19, 0x84, 0x64, 0xca, 0x90, 0xb0, 0x64, 0x65, 0x70, 0x74, 0x68	/* T__pfx___usermodehelper_set_disable_depth */
	.byte 0x13, 0xb9, 0xb1, 0xf5, 0x6d, 0xb7, 0x65, 0x68, 0xdb, 0x19, 0x84, 0x64, 0xca, 0x90, 0xb0, 0x64, 0x65, 0x70, 0x74, 0x68	/* T__usermodehelper_set_disable_depth */
	.byte 0x0d, 0x08, 0xb1, 0xf5, 0x6d, 0xb7, 0x65, 0x68, 0xdb, 0x19, 0xed, 0xca, 0x90, 0xc4	/* T__pfx___usermodehelper_disable */
	.byte 0x0d, 0xb9, 0xb1, 0xf5, 0x6d, 0xb7, 0x65, 0x68, 0xdb, 0x19, 0xed, 0xca, 0x90, 0xc4	/* T__usermodehelper_disable */
	.byte 0x05, 0xef, 0x6a, 0x68, 0xbb, 0x68	/* t__pfx_jhash */
	.byte 0x05, 0x74, 0x6a, 0x68, 0xbb, 0x68	/* tjhash */
	.byte 0x10, 0x08, 0x18, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xa1, 0x65, 0x75, 0xfc, 0x77, 0xd5, 0x6b	/* T__pfx___traceiter_workqueue_queue_work */
	.byte 0x10, 0xb9, 0x18, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xa1, 0x65, 0x75, 0xfc, 0x77, 0xd5, 0x6b	/* T__traceiter_workqueue_queue_work */
	.byte 0x11, 0x99, 0xec, 0x10, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xa1, 0x65, 0x75, 0xfc, 0x77, 0xd5, 0x6b	/* T__pfx___probestub_workqueue_queue_work */
	.byte 0x11, 0x54, 0xfd, 0x10, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xa1, 0x65, 0x75, 0xfc, 0x77, 0xd5, 0x6b	/* T__probestub_workqueue_queue_work */
	.byte 0x10, 0x08, 0x18, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xf2, 0xdc, 0x76, 0x91, 0x77, 0xd5, 0x6b	/* T__pfx___traceiter_workqueue_activate_work */
	.byte 0x10, 0xb9, 0x18, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xf2, 0xdc, 0x76, 0x91, 0x77, 0xd5, 0x6b	/* T__traceiter_workqueue_activate_work */
	.byte 0x11, 0x99, 0xec, 0x10, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xf2, 0xdc, 0x76, 0x91, 0x77, 0xd5, 0x6b	/* T__pfx___probestub_workqueue_activate_work */
	.byte 0x11, 0x54, 0xfd, 0x10, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xf2, 0xdc, 0x76, 0x91, 0x77, 0xd5, 0x6b	/* T__probestub_workqueue_activate_work */
	.byte 0x10, 0x08, 0x18, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xcb, 0xb4, 0x20, 0xfc, 0x3d, 0x72, 0x74	/* T__pfx___traceiter_workqueue_execute_start */
	.byte 0x10, 0xb9, 0x18, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xcb, 0xb4, 0x20, 0xfc, 0x3d, 0x72, 0x74	/* T__traceiter_workqueue_execute_start */
	.byte 0x0f, 0x08, 0x18, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xcb, 0xb4, 0x20, 0xfc, 0xf1, 0x64	/* T__pfx___traceiter_workqueue_execute_end */
	.byte 0x0f, 0xb9, 0x18, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xcb, 0xb4, 0x20, 0xfc, 0xf1, 0x64	/* T__traceiter_workqueue_execute_end */
	.byte 0x10, 0x99, 0xec, 0x10, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xcb, 0xb4, 0x20, 0xfc, 0xf1, 0x64	/* T__pfx___probestub_workqueue_execute_end */
	.byte 0x10, 0x54, 0xfd, 0x10, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xcb, 0xb4, 0x20, 0xfc, 0xf1, 0x64	/* T__probestub_workqueue_execute_end */
	.byte 0x0a, 0xef, 0x77, 0xd5, 0x6b, 0xe6, 0xd5, 0xf0, 0x9c, 0xe6, 0x6e	/* t__pfx_work_for_cpu_fn */
	.byte 0x0a, 0x74, 0x77, 0xd5, 0x6b, 0xe6, 0xd5, 0xf0, 0x9c, 0xe6, 0x6e	/* twork_for_cpu_fn */
	.byte 0x0b, 0xef, 0x77, 0xd5, 0x6b, 0xf5, 0x5f, 0xc4, 0x61, 0x1a, 0x9f, 0xc4	/* t__pfx_worker_leave_idle */
	.byte 0x0b, 0x74, 0x77, 0xd5, 0x6b, 0xf5, 0x5f, 0xc4, 0x61, 0x1a, 0x9f, 0xc4	/* tworker_leave_idle */
	.byte 0x0e, 0xef, 0x77, 0xd5, 0x6b, 0x5f, 0x6f, 0x66, 0x66, 0x71, 0xda, 0xe4, 0x70, 0xf2, 0x6b	/* t__pfx_work_offqd_unpack */
	.byte 0x0e, 0x74, 0x77, 0xd5, 0x6b, 0x5f, 0x6f, 0x66, 0x66, 0x71, 0xda, 0xe4, 0x70, 0xf2, 0x6b	/* twork_offqd_unpack */
	.byte 0x10, 0xef, 0x62, 0x68, 0xec, 0x6f, 0xa0, 0x5f, 0x6b, 0x69, 0xc6, 0xa3, 0x0c, 0x68, 0x70, 0x72, 0x69	/* t__pfx_bh_pool_kick_highpri */
	.byte 0x10, 0x74, 0x62, 0x68, 0xec, 0x6f, 0xa0, 0x5f, 0x6b, 0x69, 0xc6, 0xa3, 0x0c, 0x68, 0x70, 0x72, 0x69	/* tbh_pool_kick_highpri */
	.byte 0x0e, 0xef, 0x62, 0x68, 0xec, 0x6f, 0xa0, 0x5f, 0x6b, 0x69, 0xc6, 0xbd, 0xd5, 0x6d, 0xe5	/* t__pfx_bh_pool_kick_normal */
	.byte 0x0e, 0x74, 0x62, 0x68, 0xec, 0x6f, 0xa0, 0x5f, 0x6b, 0x69, 0xc6, 0xbd, 0xd5, 0x6d, 0xe5	/* tbh_pool_kick_normal */
	.byte 0x06, 0xef, 0xf8, 0x9d, 0x70, 0x77, 0x71	/* t__pfx_init_pwq */
	.byte 0x06, 0x74, 0xf8, 0x9d, 0x70, 0x77, 0x71	/* tinit_pwq */
	.byte 0x10, 0xef, 0x77, 0x71, 0x5f, 0xcd, 0x64, 0x91, 0x6e, 0x16, 0xd9, 0x78, 0x5f, 0xf2, 0xdc, 0x76, 0x65	/* t__pfx_wq_update_node_max_active */
	.byte 0x10, 0x74, 0x77, 0x71, 0x5f, 0xcd, 0x64, 0x91, 0x6e, 0x16, 0xd9, 0x78, 0x5f, 0xf2, 0xdc, 0x76, 0x65	/* twq_update_node_max_active */
	.byte 0x0b, 0xef, 0x70, 0x72, 0x3e, 0xfe, 0x70, 0x6f, 0xa0, 0xbf, 0x66, 0x6f	/* t__pfx_pr_cont_pool_info */
	.byte 0x0a, 0xce, 0x72, 0x3e, 0xfe, 0x70, 0x6f, 0xa0, 0xbf, 0x66, 0x6f	/* tpr_cont_pool_info */
	.byte 0x0c, 0xef, 0x70, 0x72, 0x3e, 0xfe, 0x77, 0xd5, 0x6b, 0xe6, 0x6c, 0xb1, 0x68	/* t__pfx_pr_cont_work_flush */
	.byte 0x0b, 0xce, 0x72, 0x3e, 0xfe, 0x77, 0xd5, 0x6b, 0xe6, 0x6c, 0xb1, 0x68	/* tpr_cont_work_flush */
	.byte 0x09, 0xef, 0xe4, 0x62, 0xf8, 0xda, 0x77, 0xd5, 0x6b, 0xf5	/* t__pfx_unbind_worker */
	.byte 0x09, 0x74, 0xe4, 0x62, 0xf8, 0xda, 0x77, 0xd5, 0x6b, 0xf5	/* tunbind_worker */
	.byte 0x0e, 0xef, 0x77, 0xd5, 0x6b, 0xf5, 0x5f, 0xe8, 0xf4, 0xba, 0xa7, 0x6f, 0xec, 0x6f, 0xa0	/* t__pfx_worker_attach_to_pool */
	.byte 0x0e, 0x74, 0x77, 0xd5, 0x6b, 0xf5, 0x5f, 0xe8, 0xf4, 0xba, 0xa7, 0x6f, 0xec, 0x6f, 0xa0	/* tworker_attach_to_pool */
	.byte 0x0d, 0xef, 0x66, 0xf7, 0xfc, 0x6e, 0x16, 0x6e, 0x72, 0x5f, 0xf2, 0xdc, 0x76, 0x65	/* t__pfx_free_node_nr_active */
	.byte 0x0d, 0x74, 0x66, 0xf7, 0xfc, 0x6e, 0x16, 0x6e, 0x72, 0x5f, 0xf2, 0xdc, 0x76, 0x65	/* tfree_node_nr_active */
	.byte 0x0a, 0xef, 0x77, 0x71, 0x2b, 0xaa, 0xfc, 0xf7, 0xc4, 0xbb, 0x65	/* t__pfx_wq_device_release */
	.byte 0x0a, 0x74, 0x77, 0x71, 0x2b, 0xaa, 0xfc, 0xf7, 0xc4, 0xbb, 0x65	/* twq_device_release */
	.byte 0x12, 0x99, 0x92, 0xc5, 0x6e, 0xe6, 0x6c, 0xb1, 0x68, 0x8d, 0x7f, 0x73, 0x2c, 0x6d, 0x77, 0x9f, 0xfc, 0x77, 0x71	/* T__pfx___warn_flushing_systemwide_wq */
	.byte 0x12, 0xb9, 0x77, 0xc5, 0x6e, 0xe6, 0x6c, 0xb1, 0x68, 0x8d, 0x7f, 0x73, 0x2c, 0x6d, 0x77, 0x9f, 0xfc, 0x77, 0x71	/* T__warn_flushing_systemwide_wq */
	.byte 0x13, 0xef, 0x66, 0x6c, 0xb1, 0x68, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x70, 0xf7, 0x70, 0xec, 0x77, 0x71, 0x73	/* t__pfx_flush_workqueue_prep_pwqs */
	.byte 0x13, 0x74, 0x66, 0x6c, 0xb1, 0x68, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x70, 0xf7, 0x70, 0xec, 0x77, 0x71, 0x73	/* tflush_workqueue_prep_pwqs */
	.byte 0x0a, 0xef, 0x77, 0x71, 0xb8, 0xc5, 0x72, 0x69, 0xf5, 0xe6, 0x96	/* t__pfx_wq_barrier_func */
	.byte 0x0a, 0x74, 0x77, 0x71, 0xb8, 0xc5, 0x72, 0x69, 0xf5, 0xe6, 0x96	/* twq_barrier_func */
	.byte 0x0d, 0xef, 0x77, 0x71, 0x5f, 0x61, 0x66, 0x66, 0x6e, 0xed, 0x66, 0x6c, 0xc7, 0xd4	/* t__pfx_wq_affn_dfl_get */
	.byte 0x0d, 0x74, 0x77, 0x71, 0x5f, 0x61, 0x66, 0x66, 0x6e, 0xed, 0x66, 0x6c, 0xc7, 0xd4	/* twq_affn_dfl_get */
	.byte 0x09, 0xef, 0xd9, 0x78, 0x5f, 0xf2, 0xdc, 0x1a, 0x73, 0x7c	/* t__pfx_max_active_show */
	.byte 0x09, 0x74, 0xd9, 0x78, 0x5f, 0xf2, 0xdc, 0x1a, 0x73, 0x7c	/* tmax_active_show */
	.byte 0x06, 0xef, 0x19, 0xf0, 0x9c, 0xf6, 0x7c	/* t__pfx_per_cpu_show */
	.byte 0x06, 0xce, 0xf5, 0xf0, 0x9c, 0xf6, 0x7c	/* tper_cpu_show */
	.byte 0x0f, 0xef, 0x77, 0x71, 0x5f, 0x61, 0x66, 0x66, 0x0f, 0x79, 0xf6, 0xf3, 0xaa, 0xfe, 0x73, 0x7c	/* t__pfx_wq_affinity_strict_show */
	.byte 0x0f, 0x74, 0x77, 0x71, 0x5f, 0x61, 0x66, 0x66, 0x0f, 0x79, 0xf6, 0xf3, 0xaa, 0xfe, 0x73, 0x7c	/* twq_affinity_strict_show */
	.byte 0x0e, 0xef, 0x77, 0x71, 0x5f, 0x61, 0x66, 0x66, 0x6e, 0xf6, 0x63, 0xbe, 0xfc, 0x73, 0x7c	/* t__pfx_wq_affn_scope_show */
	.byte 0x0e, 0x74, 0x77, 0x71, 0x5f, 0x61, 0x66, 0x66, 0x6e, 0xf6, 0x63, 0xbe, 0xfc, 0x73, 0x7c	/* twq_affn_scope_show */
	.byte 0x09, 0xef, 0x77, 0x71, 0xf0, 0x9c, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx_wq_cpumask_show */
	.byte 0x09, 0x74, 0x77, 0x71, 0xf0, 0x9c, 0xd9, 0x5e, 0xf6, 0x7c	/* twq_cpumask_show */
	.byte 0x08, 0xef, 0x77, 0x71, 0xbd, 0xaa, 0xfc, 0x73, 0x7c	/* t__pfx_wq_nice_show */
	.byte 0x08, 0x74, 0x77, 0x71, 0xbd, 0xaa, 0xfc, 0x73, 0x7c	/* twq_nice_show */
	.byte 0x0a, 0xef, 0x72, 0x63, 0x75, 0xe6, 0xf7, 0xfc, 0x70, 0x6f, 0xa0	/* t__pfx_rcu_free_pool */
	.byte 0x09, 0xf3, 0x63, 0x75, 0xe6, 0xf7, 0xfc, 0x70, 0x6f, 0xa0	/* trcu_free_pool */
	.byte 0x09, 0xef, 0x72, 0x63, 0x75, 0xe6, 0xf7, 0xfc, 0x77, 0x71	/* t__pfx_rcu_free_wq */
	.byte 0x08, 0xf3, 0x63, 0x75, 0xe6, 0xf7, 0xfc, 0x77, 0x71	/* trcu_free_wq */
	.byte 0x12, 0xef, 0x19, 0x3b, 0xc3, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xf2, 0xdc, 0x76, 0x91, 0x77, 0xd5, 0x6b	/* t__pfx_perf_trace_workqueue_activate_work */
	.byte 0x12, 0xce, 0xf5, 0x3b, 0xc3, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xf2, 0xdc, 0x76, 0x91, 0x77, 0xd5, 0x6b	/* tperf_trace_workqueue_activate_work */
	.byte 0x12, 0xef, 0x19, 0x3b, 0xc3, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xcb, 0xb4, 0x20, 0xfc, 0x3d, 0x72, 0x74	/* t__pfx_perf_trace_workqueue_execute_start */
	.byte 0x12, 0xce, 0xf5, 0x3b, 0xc3, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xcb, 0xb4, 0x20, 0xfc, 0x3d, 0x72, 0x74	/* tperf_trace_workqueue_execute_start */
	.byte 0x11, 0xef, 0x19, 0x3b, 0xc3, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xcb, 0xb4, 0x20, 0xfc, 0xf1, 0x64	/* t__pfx_perf_trace_workqueue_execute_end */
	.byte 0x11, 0xce, 0xf5, 0x3b, 0xc3, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xcb, 0xb4, 0x20, 0xfc, 0xf1, 0x64	/* tperf_trace_workqueue_execute_end */
	.byte 0x12, 0xef, 0x7d, 0x7b, 0xcc, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xf2, 0xdc, 0x76, 0x91, 0x77, 0xd5, 0x6b	/* t__pfx_trace_event_raw_event_workqueue_activate_work */
	.byte 0x12, 0x74, 0x7d, 0x7b, 0xcc, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xf2, 0xdc, 0x76, 0x91, 0x77, 0xd5, 0x6b	/* ttrace_event_raw_event_workqueue_activate_work */
	.byte 0x12, 0xef, 0x7d, 0x7b, 0xcc, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xcb, 0xb4, 0x20, 0xfc, 0x3d, 0x72, 0x74	/* t__pfx_trace_event_raw_event_workqueue_execute_start */
	.byte 0x12, 0x74, 0x7d, 0x7b, 0xcc, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xcb, 0xb4, 0x20, 0xfc, 0x3d, 0x72, 0x74	/* ttrace_event_raw_event_workqueue_execute_start */
	.byte 0x11, 0xef, 0x7d, 0x7b, 0xcc, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xcb, 0xb4, 0x20, 0xfc, 0xf1, 0x64	/* t__pfx_trace_event_raw_event_workqueue_execute_end */
	.byte 0x11, 0x74, 0x7d, 0x7b, 0xcc, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xcb, 0xb4, 0x20, 0xfc, 0xf1, 0x64	/* ttrace_event_raw_event_workqueue_execute_end */
	.byte 0x15, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xa1, 0x65, 0x75, 0xfc, 0x77, 0xd5, 0x6b	/* t__pfx_trace_raw_output_workqueue_queue_work */
	.byte 0x15, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xa1, 0x65, 0x75, 0xfc, 0x77, 0xd5, 0x6b	/* ttrace_raw_output_workqueue_queue_work */
	.byte 0x15, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xf2, 0xdc, 0x76, 0x91, 0x77, 0xd5, 0x6b	/* t__pfx_trace_raw_output_workqueue_activate_work */
	.byte 0x15, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xf2, 0xdc, 0x76, 0x91, 0x77, 0xd5, 0x6b	/* ttrace_raw_output_workqueue_activate_work */
	.byte 0x15, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xcb, 0xb4, 0x20, 0xfc, 0x3d, 0x72, 0x74	/* t__pfx_trace_raw_output_workqueue_execute_start */
	.byte 0x15, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xcb, 0xb4, 0x20, 0xfc, 0x3d, 0x72, 0x74	/* ttrace_raw_output_workqueue_execute_start */
	.byte 0x14, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xcb, 0xb4, 0x20, 0xfc, 0xf1, 0x64	/* t__pfx_trace_raw_output_workqueue_execute_end */
	.byte 0x14, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xcb, 0xb4, 0x20, 0xfc, 0xf1, 0x64	/* ttrace_raw_output_workqueue_execute_end */
	.byte 0x0c, 0xeb, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x40, 0x67, 0x60, 0x9e	/* T__pfx_workqueue_congested */
	.byte 0x0c, 0x54, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x40, 0x67, 0x60, 0x9e	/* Tworkqueue_congested */
	.byte 0x07, 0xef, 0x63, 0x9c, 0xd9, 0x5e, 0xf6, 0x7c	/* t__pfx_cpumask_show */
	.byte 0x06, 0x26, 0x9c, 0xd9, 0x5e, 0xf6, 0x7c	/* tcpumask_show */
	.byte 0x12, 0xef, 0x19, 0x3b, 0xc3, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xa1, 0x65, 0x75, 0xfc, 0x77, 0xd5, 0x6b	/* t__pfx_perf_trace_workqueue_queue_work */
	.byte 0x12, 0xce, 0xf5, 0x3b, 0xc3, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xa1, 0x65, 0x75, 0xfc, 0x77, 0xd5, 0x6b	/* tperf_trace_workqueue_queue_work */
	.byte 0x0a, 0xef, 0x73, 0xe2, 0x77, 0xd5, 0x6b, 0xf5, 0xed, 0x79, 0x8d	/* t__pfx_set_worker_dying */
	.byte 0x09, 0x93, 0xe2, 0x77, 0xd5, 0x6b, 0xf5, 0xed, 0x79, 0x8d	/* tset_worker_dying */
	.byte 0x0b, 0xef, 0x66, 0xd5, 0xd9, 0xfe, 0x77, 0xd5, 0x6b, 0xf5, 0x5f, 0x9f	/* t__pfx_format_worker_id */
	.byte 0x0b, 0x74, 0x66, 0xd5, 0xd9, 0xfe, 0x77, 0xd5, 0x6b, 0xf5, 0x5f, 0x9f	/* tformat_worker_id */
	.byte 0x0b, 0xef, 0x70, 0x72, 0x3e, 0xfe, 0x77, 0xd5, 0x6b, 0xf5, 0x5f, 0x9f	/* t__pfx_pr_cont_worker_id */
	.byte 0x0a, 0xce, 0x72, 0x3e, 0xfe, 0x77, 0xd5, 0x6b, 0xf5, 0x5f, 0x9f	/* tpr_cont_worker_id */
	.byte 0x0f, 0xef, 0x77, 0x71, 0x24, 0x73, 0xec, 0x6f, 0xda, 0x74, 0x21, 0x65, 0x2e, 0xca, 0xbc, 0x7e	/* t__pfx_wqattrs_pod_type.isra.0 */
	.byte 0x0f, 0x74, 0x77, 0x71, 0x24, 0x73, 0xec, 0x6f, 0xda, 0x74, 0x21, 0x65, 0x2e, 0xca, 0xbc, 0x7e	/* twqattrs_pod_type.isra.0 */
	.byte 0x0c, 0xef, 0x77, 0x71, 0xf0, 0xe5, 0x63, 0xec, 0xb7, 0xf0, 0x9c, 0xd9, 0x5e	/* t__pfx_wq_calc_pod_cpumask */
	.byte 0x0c, 0x74, 0x77, 0x71, 0xf0, 0xe5, 0x63, 0xec, 0xb7, 0xf0, 0x9c, 0xd9, 0x5e	/* twq_calc_pod_cpumask */
	.byte 0x07, 0xef, 0x6b, 0x69, 0xc6, 0xec, 0x6f, 0xa0	/* t__pfx_kick_pool */
	.byte 0x07, 0x74, 0x6b, 0x69, 0xc6, 0xec, 0x6f, 0xa0	/* tkick_pool */
	.byte 0x0a, 0xef, 0x77, 0xd5, 0x6b, 0xf5, 0x0d, 0xa2, 0x5f, 0x9f, 0xc4	/* t__pfx_worker_enter_idle */
	.byte 0x0a, 0x74, 0x77, 0xd5, 0x6b, 0xf5, 0x0d, 0xa2, 0x5f, 0x9f, 0xc4	/* tworker_enter_idle */
	.byte 0x08, 0xef, 0x63, 0xf7, 0x91, 0x77, 0xd5, 0x6b, 0xf5	/* t__pfx_create_worker */
	.byte 0x07, 0x26, 0xf7, 0x91, 0x77, 0xd5, 0x6b, 0xf5	/* tcreate_worker */
	.byte 0x11, 0x99, 0xec, 0x10, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xcb, 0xb4, 0x20, 0xfc, 0x3d, 0x72, 0x74	/* T__pfx___probestub_workqueue_execute_start */
	.byte 0x11, 0x54, 0xfd, 0x10, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xcb, 0xb4, 0x20, 0xfc, 0x3d, 0x72, 0x74	/* T__probestub_workqueue_execute_start */
	.byte 0x12, 0xef, 0x7d, 0x7b, 0xcc, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xa1, 0x65, 0x75, 0xfc, 0x77, 0xd5, 0x6b	/* t__pfx_trace_event_raw_event_workqueue_queue_work */
	.byte 0x12, 0x74, 0x7d, 0x7b, 0xcc, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xa1, 0x65, 0x75, 0xfc, 0x77, 0xd5, 0x6b	/* ttrace_event_raw_event_workqueue_queue_work */
	.byte 0x0b, 0xef, 0x63, 0x9c, 0xd9, 0x5e, 0xde, 0xa1, 0x60, 0x9e, 0xf6, 0x7c	/* t__pfx_cpumask_requested_show */
	.byte 0x0a, 0x26, 0x9c, 0xd9, 0x5e, 0xde, 0xa1, 0x60, 0x9e, 0xf6, 0x7c	/* tcpumask_requested_show */
	.byte 0x0c, 0xef, 0x63, 0x9c, 0xd9, 0x5e, 0x5f, 0xca, 0xa0, 0xe8, 0x9e, 0xf6, 0x7c	/* t__pfx_cpumask_isolated_show */
	.byte 0x0b, 0x26, 0x9c, 0xd9, 0x5e, 0x5f, 0xca, 0xa0, 0xe8, 0x9e, 0xf6, 0x7c	/* tcpumask_isolated_show */
	.byte 0x09, 0xeb, 0x63, 0x98, 0xf7, 0x6e, 0xfe, 0x77, 0xd5, 0x6b	/* T__pfx_current_work */
	.byte 0x09, 0x54, 0x63, 0x98, 0xf7, 0x6e, 0xfe, 0x77, 0xd5, 0x6b	/* Tcurrent_work */
	.byte 0x0a, 0xeb, 0x73, 0xe2, 0x77, 0xd5, 0x6b, 0xf5, 0xed, 0xd6, 0x63	/* T__pfx_set_worker_desc */
	.byte 0x0a, 0x54, 0x73, 0xe2, 0x77, 0xd5, 0x6b, 0xf5, 0xed, 0xd6, 0x63	/* Tset_worker_desc */
	.byte 0x0e, 0xef, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x92, 0x71, 0x24, 0x73, 0x3a, 0x6d, 0x6d, 0xea	/* t__pfx_apply_wqattrs_commit */
	.byte 0x0d, 0xf4, 0x70, 0x70, 0x6c, 0x79, 0x92, 0x71, 0x24, 0x73, 0x3a, 0x6d, 0x6d, 0xea	/* tapply_wqattrs_commit */
	.byte 0x08, 0xef, 0x9f, 0xb0, 0x63, 0x02, 0x6c, 0xe6, 0x6e	/* t__pfx_idle_cull_fn */
	.byte 0x08, 0xdc, 0x64, 0xb0, 0x63, 0x02, 0x6c, 0xe6, 0x6e	/* tidle_cull_fn */
	.byte 0x10, 0xef, 0x63, 0xc4, 0xc5, 0xec, 0xf1, 0x64, 0x8d, 0x5f, 0x69, 0x66, 0xed, 0xca, 0x90, 0xc4, 0x64	/* t__pfx_clear_pending_if_disabled */
	.byte 0x0f, 0x26, 0xc4, 0xc5, 0xec, 0xf1, 0x64, 0x8d, 0x5f, 0x69, 0x66, 0xed, 0xca, 0x90, 0xc4, 0x64	/* tclear_pending_if_disabled */
	.byte 0x0b, 0xeb, 0xa1, 0x65, 0x75, 0xfc, 0x72, 0x63, 0x75, 0x92, 0xd5, 0x6b	/* T__pfx_queue_rcu_work */
	.byte 0x0b, 0x54, 0xa1, 0x65, 0x75, 0xfc, 0x72, 0x63, 0x75, 0x92, 0xd5, 0x6b	/* Tqueue_rcu_work */
	.byte 0x15, 0xef, 0xba, 0x65, 0xc6, 0xe6, 0x6c, 0xb1, 0x68, 0xed, 0x65, 0x70, 0xf1, 0x64, 0xf1, 0x63, 0x79, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__pfx_check_flush_dependency.part.0 */
	.byte 0x15, 0x74, 0xba, 0x65, 0xc6, 0xe6, 0x6c, 0xb1, 0x68, 0xed, 0x65, 0x70, 0xf1, 0x64, 0xf1, 0x63, 0x79, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* tcheck_flush_dependency.part.0 */
	.byte 0x0c, 0x99, 0xe6, 0x6c, 0xb1, 0x68, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0x65	/* T__pfx___flush_workqueue */
	.byte 0x0c, 0xb9, 0x66, 0x6c, 0xb1, 0x68, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0x65	/* T__flush_workqueue */
	.byte 0x0b, 0xeb, 0x64, 0xbc, 0xf8, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0x65	/* T__pfx_drain_workqueue */
	.byte 0x0b, 0x54, 0x64, 0xbc, 0xf8, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0x65	/* Tdrain_workqueue */
	.byte 0x13, 0xef, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x92, 0x71, 0x24, 0x73, 0xf0, 0xc4, 0xd2, 0xcd, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__pfx_apply_wqattrs_cleanup.part.0 */
	.byte 0x12, 0xf4, 0x70, 0x70, 0x6c, 0x79, 0x92, 0x71, 0x24, 0x73, 0xf0, 0xc4, 0xd2, 0xcd, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* tapply_wqattrs_cleanup.part.0 */
	.byte 0x07, 0xef, 0xf8, 0x9d, 0x29, 0x63, 0x75, 0xf5	/* t__pfx_init_rescuer */
	.byte 0x07, 0x74, 0xf8, 0x9d, 0x29, 0x63, 0x75, 0xf5	/* tinit_rescuer */
	.byte 0x07, 0xeb, 0x77, 0xd5, 0x6b, 0xb8, 0x75, 0xe1	/* T__pfx_work_busy */
	.byte 0x07, 0x54, 0x77, 0xd5, 0x6b, 0xb8, 0x75, 0xe1	/* Twork_busy */
	.byte 0x10, 0xef, 0x70, 0x77, 0x71, 0x5f, 0xf3, 0x79, 0xf8, 0xc9, 0x6e, 0x72, 0x5f, 0xf2, 0xdc, 0x76, 0x65	/* t__pfx_pwq_tryinc_nr_active */
	.byte 0x0f, 0xce, 0x77, 0x71, 0x5f, 0xf3, 0x79, 0xf8, 0xc9, 0x6e, 0x72, 0x5f, 0xf2, 0xdc, 0x76, 0x65	/* tpwq_tryinc_nr_active */
	.byte 0x0d, 0x74, 0xaf, 0xec, 0x77, 0x71, 0x5f, 0xf2, 0xdc, 0x76, 0x91, 0x77, 0xd5, 0x6b	/* t__pfx___pwq_activate_work */
	.byte 0x0c, 0x74, 0xfd, 0x77, 0x71, 0x5f, 0xf2, 0xdc, 0x76, 0x91, 0x77, 0xd5, 0x6b	/* t__pwq_activate_work */
	.byte 0x0f, 0xef, 0x70, 0x77, 0x71, 0xed, 0x65, 0xc9, 0x6e, 0x72, 0xbf, 0xe6, 0x6c, 0x0c, 0x68, 0x74	/* t__pfx_pwq_dec_nr_in_flight */
	.byte 0x0e, 0xce, 0x77, 0x71, 0xed, 0x65, 0xc9, 0x6e, 0x72, 0xbf, 0xe6, 0x6c, 0x0c, 0x68, 0x74	/* tpwq_dec_nr_in_flight */
	.byte 0x0f, 0xef, 0x77, 0x71, 0x5f, 0xc8, 0x6a, 0xb1, 0xfe, 0xd9, 0x78, 0x5f, 0xf2, 0xdc, 0x76, 0x65	/* t__pfx_wq_adjust_max_active */
	.byte 0x0f, 0x74, 0x77, 0x71, 0x5f, 0xc8, 0x6a, 0xb1, 0xfe, 0xd9, 0x78, 0x5f, 0xf2, 0xdc, 0x76, 0x65	/* twq_adjust_max_active */
	.byte 0x11, 0xeb, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x73, 0xe2, 0xd9, 0x78, 0x5f, 0xf2, 0xdc, 0x76, 0x65	/* T__pfx_workqueue_set_max_active */
	.byte 0x11, 0x54, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x73, 0xe2, 0xd9, 0x78, 0x5f, 0xf2, 0xdc, 0x76, 0x65	/* Tworkqueue_set_max_active */
	.byte 0x0a, 0xef, 0xd9, 0x78, 0x5f, 0xf2, 0xdc, 0x1a, 0x73, 0x8a, 0xf7	/* t__pfx_max_active_store */
	.byte 0x0a, 0x74, 0xd9, 0x78, 0x5f, 0xf2, 0xdc, 0x1a, 0x73, 0x8a, 0xf7	/* tmax_active_store */
	.byte 0x0b, 0xef, 0x70, 0xe3, 0x63, 0xd6, 0xe9, 0xe7, 0xfc, 0x77, 0xd5, 0x6b	/* t__pfx_process_one_work */
	.byte 0x0a, 0xce, 0xe3, 0x63, 0xd6, 0xe9, 0xe7, 0xfc, 0x77, 0xd5, 0x6b	/* tprocess_one_work */
	.byte 0x09, 0xef, 0x77, 0xd5, 0x6b, 0xf5, 0xa7, 0x68, 0xf7, 0xc8	/* t__pfx_worker_thread */
	.byte 0x09, 0x74, 0x77, 0xd5, 0x6b, 0xf5, 0xa7, 0x68, 0xf7, 0xc8	/* tworker_thread */
	.byte 0x0c, 0xef, 0xf3, 0x79, 0xa7, 0x6f, 0xc7, 0xbc, 0x62, 0xec, 0xf1, 0x64, 0x8d	/* t__pfx_try_to_grab_pending */
	.byte 0x0c, 0x74, 0xf3, 0x79, 0xa7, 0x6f, 0xc7, 0xbc, 0x62, 0xec, 0xf1, 0x64, 0x8d	/* ttry_to_grab_pending */
	.byte 0x07, 0xeb, 0xf1, 0x90, 0xb0, 0x77, 0xd5, 0x6b	/* T__pfx_enable_work */
	.byte 0x07, 0x54, 0xf1, 0x90, 0xb0, 0x77, 0xd5, 0x6b	/* Tenable_work */
	.byte 0x0d, 0xeb, 0xf1, 0x90, 0xb0, 0x64, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b	/* T__pfx_enable_delayed_work */
	.byte 0x0d, 0x54, 0xf1, 0x90, 0xb0, 0x64, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b	/* Tenable_delayed_work */
	.byte 0x09, 0x74, 0xaf, 0xf0, 0xd2, 0x63, 0xdb, 0x92, 0xd5, 0x6b	/* t__pfx___cancel_work */
	.byte 0x09, 0x74, 0xff, 0x63, 0xd2, 0x63, 0xdb, 0x92, 0xd5, 0x6b	/* t__cancel_work */
	.byte 0x08, 0xeb, 0x63, 0xd2, 0x63, 0xdb, 0x92, 0xd5, 0x6b	/* T__pfx_cancel_work */
	.byte 0x08, 0x54, 0x63, 0xd2, 0x63, 0xdb, 0x92, 0xd5, 0x6b	/* Tcancel_work */
	.byte 0x0e, 0xeb, 0x63, 0xd2, 0x63, 0xdb, 0xed, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b	/* T__pfx_cancel_delayed_work */
	.byte 0x0e, 0x54, 0x63, 0xd2, 0x63, 0xdb, 0xed, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b	/* Tcancel_delayed_work */
	.byte 0x08, 0xeb, 0x64, 0xca, 0x90, 0xb0, 0x77, 0xd5, 0x6b	/* T__pfx_disable_work */
	.byte 0x08, 0x54, 0x64, 0xca, 0x90, 0xb0, 0x77, 0xd5, 0x6b	/* Tdisable_work */
	.byte 0x0e, 0xeb, 0x64, 0xca, 0x90, 0xb0, 0x64, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b	/* T__pfx_disable_delayed_work */
	.byte 0x0e, 0x54, 0x64, 0xca, 0x90, 0xb0, 0x64, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b	/* Tdisable_delayed_work */
	.byte 0x0a, 0xef, 0xf8, 0x9d, 0x77, 0xd5, 0x6b, 0xf5, 0xec, 0x6f, 0xa0	/* t__pfx_init_worker_pool */
	.byte 0x0a, 0x74, 0xf8, 0x9d, 0x77, 0xd5, 0x6b, 0xf5, 0xec, 0x6f, 0xa0	/* tinit_worker_pool */
	.byte 0x09, 0x74, 0xaf, 0xe6, 0x6c, 0xb1, 0x68, 0x92, 0xd5, 0x6b	/* t__pfx___flush_work */
	.byte 0x09, 0x74, 0xff, 0x66, 0x6c, 0xb1, 0x68, 0x92, 0xd5, 0x6b	/* t__flush_work */
	.byte 0x08, 0xeb, 0x66, 0x6c, 0xb1, 0x68, 0x92, 0xd5, 0x6b	/* T__pfx_flush_work */
	.byte 0x08, 0x54, 0x66, 0x6c, 0xb1, 0x68, 0x92, 0xd5, 0x6b	/* Tflush_work */
	.byte 0x0b, 0xef, 0x9c, 0xfe, 0xe4, 0x62, 0x6f, 0xe4, 0x64, 0xec, 0x6f, 0xa0	/* t__pfx_put_unbound_pool */
	.byte 0x0a, 0xce, 0x1e, 0xe4, 0x62, 0x6f, 0xe4, 0x64, 0xec, 0x6f, 0xa0	/* tput_unbound_pool */
	.byte 0x0b, 0xef, 0x22, 0xc9, 0xe4, 0x62, 0x6f, 0xe4, 0x64, 0xec, 0x77, 0x71	/* t__pfx_alloc_unbound_pwq */
	.byte 0x0c, 0xf4, 0x6c, 0xdd, 0xc9, 0xe4, 0x62, 0x6f, 0xe4, 0x64, 0xec, 0x77, 0x71	/* talloc_unbound_pwq */
	.byte 0x0b, 0xeb, 0x66, 0x6c, 0xb1, 0x68, 0xa6, 0x63, 0x75, 0x92, 0xd5, 0x6b	/* T__pfx_flush_rcu_work */
	.byte 0x0b, 0x54, 0x66, 0x6c, 0xb1, 0x68, 0xa6, 0x63, 0x75, 0x92, 0xd5, 0x6b	/* Tflush_rcu_work */
	.byte 0x0e, 0xef, 0x70, 0x6f, 0xa0, 0x5f, 0xd9, 0x79, 0x64, 0x61, 0x1d, 0xdc, 0xa8, 0x6f, 0x20	/* t__pfx_pool_mayday_timeout */
	.byte 0x0d, 0xce, 0x6f, 0xa0, 0x5f, 0xd9, 0x79, 0x64, 0x61, 0x1d, 0xdc, 0xa8, 0x6f, 0x20	/* tpool_mayday_timeout */
	.byte 0x11, 0xeb, 0x64, 0xca, 0x90, 0xb0, 0x64, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b, 0x7f, 0x6e, 0x63	/* T__pfx_disable_delayed_work_sync */
	.byte 0x11, 0x54, 0x64, 0xca, 0x90, 0xb0, 0x64, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b, 0x7f, 0x6e, 0x63	/* Tdisable_delayed_work_sync */
	.byte 0x0b, 0xeb, 0x64, 0xca, 0x90, 0xb0, 0x77, 0xd5, 0x6b, 0x7f, 0x6e, 0x63	/* T__pfx_disable_work_sync */
	.byte 0x0b, 0x54, 0x64, 0xca, 0x90, 0xb0, 0x77, 0xd5, 0x6b, 0x7f, 0x6e, 0x63	/* Tdisable_work_sync */
	.byte 0x0f, 0xef, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x92, 0x71, 0x24, 0x73, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* t__pfx_apply_wqattrs_prepare */
	.byte 0x0e, 0xf4, 0x70, 0x70, 0x6c, 0x79, 0x92, 0x71, 0x24, 0x73, 0xec, 0xf7, 0x70, 0x61, 0xf7	/* tapply_wqattrs_prepare */
	.byte 0x11, 0xef, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x24, 0xe9, 0xa4, 0x9e	/* t__pfx_apply_workqueue_attrs_locked */
	.byte 0x10, 0xf4, 0x70, 0x70, 0x6c, 0x79, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x24, 0xe9, 0xa4, 0x9e	/* tapply_workqueue_attrs_locked */
	.byte 0x10, 0xef, 0x77, 0x71, 0x5f, 0x61, 0x66, 0x66, 0x0f, 0x79, 0xf6, 0xf3, 0xaa, 0xfe, 0x73, 0x8a, 0xf7	/* t__pfx_wq_affinity_strict_store */
	.byte 0x10, 0x74, 0x77, 0x71, 0x5f, 0x61, 0x66, 0x66, 0x0f, 0x79, 0xf6, 0xf3, 0xaa, 0xfe, 0x73, 0x8a, 0xf7	/* twq_affinity_strict_store */
	.byte 0x0f, 0xef, 0x77, 0x71, 0x5f, 0x61, 0x66, 0x66, 0x6e, 0xf6, 0x63, 0xbe, 0xfc, 0x73, 0x8a, 0xf7	/* t__pfx_wq_affn_scope_store */
	.byte 0x0f, 0x74, 0x77, 0x71, 0x5f, 0x61, 0x66, 0x66, 0x6e, 0xf6, 0x63, 0xbe, 0xfc, 0x73, 0x8a, 0xf7	/* twq_affn_scope_store */
	.byte 0x0a, 0xef, 0x77, 0x71, 0xf0, 0x9c, 0xd9, 0x5e, 0xf6, 0x8a, 0xf7	/* t__pfx_wq_cpumask_store */
	.byte 0x0a, 0x74, 0x77, 0x71, 0xf0, 0x9c, 0xd9, 0x5e, 0xf6, 0x8a, 0xf7	/* twq_cpumask_store */
	.byte 0x09, 0xef, 0x77, 0x71, 0xbd, 0xaa, 0xfc, 0x73, 0x8a, 0xf7	/* t__pfx_wq_nice_store */
	.byte 0x09, 0x74, 0x77, 0x71, 0xbd, 0xaa, 0xfc, 0x73, 0x8a, 0xf7	/* twq_nice_store */
	.byte 0x16, 0xef, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x61, 0x70, 0x70, 0x6c, 0x1d, 0xe4, 0x62, 0x6f, 0xe4, 0x64, 0xf0, 0x9c, 0xd9, 0x5e	/* t__pfx_workqueue_apply_unbound_cpumask */
	.byte 0x16, 0x74, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x61, 0x70, 0x70, 0x6c, 0x1d, 0xe4, 0x62, 0x6f, 0xe4, 0x64, 0xf0, 0x9c, 0xd9, 0x5e	/* tworkqueue_apply_unbound_cpumask */
	.byte 0x08, 0xef, 0x63, 0x9c, 0xd9, 0x5e, 0xf6, 0x8a, 0xf7	/* t__pfx_cpumask_store */
	.byte 0x07, 0x26, 0x9c, 0xd9, 0x5e, 0xf6, 0x8a, 0xf7	/* tcpumask_store */
	.byte 0x0d, 0xef, 0x70, 0x77, 0x71, 0xde, 0xc4, 0xbb, 0xfc, 0x77, 0xd5, 0x6b, 0x66, 0x6e	/* t__pfx_pwq_release_workfn */
	.byte 0x0c, 0xce, 0x77, 0x71, 0xde, 0xc4, 0xbb, 0xfc, 0x77, 0xd5, 0x6b, 0x66, 0x6e	/* tpwq_release_workfn */
	.byte 0x0b, 0xeb, 0x63, 0xd2, 0x63, 0xdb, 0x92, 0xd5, 0x6b, 0x7f, 0x6e, 0x63	/* T__pfx_cancel_work_sync */
	.byte 0x0b, 0x54, 0x63, 0xd2, 0x63, 0xdb, 0x92, 0xd5, 0x6b, 0x7f, 0x6e, 0x63	/* Tcancel_work_sync */
	.byte 0x11, 0xeb, 0x63, 0xd2, 0x63, 0xdb, 0xed, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b, 0x7f, 0x6e, 0x63	/* T__pfx_cancel_delayed_work_sync */
	.byte 0x11, 0x54, 0x63, 0xd2, 0x63, 0xdb, 0xed, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b, 0x7f, 0x6e, 0x63	/* Tcancel_delayed_work_sync */
	.byte 0x0a, 0x74, 0xaf, 0x5f, 0xa1, 0x65, 0x75, 0xfc, 0x77, 0xd5, 0x6b	/* t__pfx___queue_work */
	.byte 0x09, 0x74, 0xff, 0xa1, 0x65, 0x75, 0xfc, 0x77, 0xd5, 0x6b	/* t__queue_work */
	.byte 0x0a, 0xeb, 0xa1, 0x65, 0x75, 0xfc, 0x77, 0xd5, 0x6b, 0x5f, 0xe7	/* T__pfx_queue_work_on */
	.byte 0x0a, 0x54, 0xa1, 0x65, 0x75, 0xfc, 0x77, 0xd5, 0x6b, 0x5f, 0xe7	/* Tqueue_work_on */
	.byte 0x0c, 0xef, 0x9f, 0xb0, 0x77, 0xd5, 0x6b, 0xf5, 0x5f, 0xdc, 0xa8, 0x6f, 0x20	/* t__pfx_idle_worker_timeout */
	.byte 0x0c, 0xdc, 0x64, 0xb0, 0x77, 0xd5, 0x6b, 0xf5, 0x5f, 0xdc, 0xa8, 0x6f, 0x20	/* tidle_worker_timeout */
	.byte 0x0c, 0xeb, 0x77, 0xd5, 0x6b, 0x5f, 0xe7, 0xf0, 0x9c, 0x5f, 0x6b, 0x65, 0x79	/* T__pfx_work_on_cpu_key */
	.byte 0x0c, 0x54, 0x77, 0xd5, 0x6b, 0x5f, 0xe7, 0xf0, 0x9c, 0x5f, 0x6b, 0x65, 0x79	/* Twork_on_cpu_key */
	.byte 0x0e, 0xeb, 0xcb, 0xb4, 0x20, 0xfc, 0xf8, 0xec, 0xe3, 0x63, 0xd6, 0x73, 0x3e, 0x74, 0x8e	/* T__pfx_execute_in_process_context */
	.byte 0x0e, 0x54, 0xcb, 0xb4, 0x20, 0xfc, 0xf8, 0xec, 0xe3, 0x63, 0xd6, 0x73, 0x3e, 0x74, 0x8e	/* Texecute_in_process_context */
	.byte 0x0f, 0xeb, 0x77, 0xd5, 0x6b, 0x5f, 0xe7, 0xf0, 0x9c, 0xf6, 0x61, 0x66, 0xfc, 0x6b, 0x65, 0x79	/* T__pfx_work_on_cpu_safe_key */
	.byte 0x0f, 0x54, 0x77, 0xd5, 0x6b, 0x5f, 0xe7, 0xf0, 0x9c, 0xf6, 0x61, 0x66, 0xfc, 0x6b, 0x65, 0x79	/* Twork_on_cpu_safe_key */
	.byte 0x0b, 0xeb, 0xa1, 0x65, 0x75, 0xfc, 0x77, 0xd5, 0x6b, 0xbd, 0xb7, 0x65	/* T__pfx_queue_work_node */
	.byte 0x0b, 0x54, 0xa1, 0x65, 0x75, 0xfc, 0x77, 0xd5, 0x6b, 0xbd, 0xb7, 0x65	/* Tqueue_work_node */
	.byte 0x0f, 0xeb, 0x64, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b, 0x5f, 0x00, 0xf5, 0xe6, 0x6e	/* T__pfx_delayed_work_timer_fn */
	.byte 0x0f, 0x54, 0x64, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b, 0x5f, 0x00, 0xf5, 0xe6, 0x6e	/* Tdelayed_work_timer_fn */
	.byte 0x0c, 0xef, 0x72, 0x63, 0x75, 0x92, 0xd5, 0x6b, 0xa6, 0x63, 0x75, 0x66, 0x6e	/* t__pfx_rcu_work_rcufn */
	.byte 0x0b, 0xf3, 0x63, 0x75, 0x92, 0xd5, 0x6b, 0xa6, 0x63, 0x75, 0x66, 0x6e	/* trcu_work_rcufn */
	.byte 0x10, 0x74, 0xaf, 0x5f, 0xa1, 0x65, 0x75, 0xfc, 0x64, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b	/* t__pfx___queue_delayed_work */
	.byte 0x0f, 0x74, 0xff, 0xa1, 0x65, 0x75, 0xfc, 0x64, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b	/* t__queue_delayed_work */
	.byte 0x10, 0xeb, 0xa1, 0x65, 0x75, 0xfc, 0x64, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b, 0x5f, 0xe7	/* T__pfx_queue_delayed_work_on */
	.byte 0x10, 0x54, 0xa1, 0x65, 0x75, 0xfc, 0x64, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b, 0x5f, 0xe7	/* Tqueue_delayed_work_on */
	.byte 0x0e, 0xeb, 0x6d, 0xb7, 0xed, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b, 0x5f, 0xe7	/* T__pfx_mod_delayed_work_on */
	.byte 0x0e, 0x54, 0x6d, 0xb7, 0xed, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b, 0x5f, 0xe7	/* Tmod_delayed_work_on */
	.byte 0x0e, 0xeb, 0x66, 0x6c, 0xb1, 0x68, 0xed, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b	/* T__pfx_flush_delayed_work */
	.byte 0x0e, 0x54, 0x66, 0x6c, 0xb1, 0x68, 0xed, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b	/* Tflush_delayed_work */
	.byte 0x08, 0xef, 0x70, 0x72, 0x3e, 0xfe, 0x77, 0xd5, 0x6b	/* t__pfx_pr_cont_work */
	.byte 0x07, 0xce, 0x72, 0x3e, 0xfe, 0x77, 0xd5, 0x6b	/* tpr_cont_work */
	.byte 0x06, 0xef, 0x73, 0x7c, 0xec, 0x77, 0x71	/* t__pfx_show_pwq */
	.byte 0x05, 0x93, 0x7c, 0xec, 0x77, 0x71	/* tshow_pwq */
	.byte 0x09, 0xef, 0x29, 0x63, 0x75, 0xf5, 0xa7, 0x68, 0xf7, 0xc8	/* t__pfx_rescuer_thread */
	.byte 0x09, 0x74, 0x29, 0x63, 0x75, 0xf5, 0xa7, 0x68, 0xf7, 0xc8	/* trescuer_thread */
	.byte 0x07, 0xef, 0x62, 0x68, 0x92, 0xd5, 0x6b, 0xf5	/* t__pfx_bh_worker */
	.byte 0x07, 0x74, 0x62, 0x68, 0x92, 0xd5, 0x6b, 0xf5	/* tbh_worker */
	.byte 0x12, 0xef, 0x64, 0xbc, 0xf8, 0xed, 0x65, 0xc8, 0xf6, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x92, 0xd5, 0x6b, 0x66, 0x6e	/* t__pfx_drain_dead_softirq_workfn */
	.byte 0x12, 0x74, 0x64, 0xbc, 0xf8, 0xed, 0x65, 0xc8, 0xf6, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x92, 0xd5, 0x6b, 0x66, 0x6e	/* tdrain_dead_softirq_workfn */
	.byte 0x0f, 0xef, 0xe4, 0x62, 0x6f, 0xe4, 0xda, 0x77, 0x71, 0x5f, 0xcd, 0x64, 0x91, 0x70, 0x77, 0x71	/* t__pfx_unbound_wq_update_pwq */
	.byte 0x0f, 0x74, 0xe4, 0x62, 0x6f, 0xe4, 0xda, 0x77, 0x71, 0x5f, 0xcd, 0x64, 0x91, 0x70, 0x77, 0x71	/* tunbound_wq_update_pwq */
	.byte 0x0d, 0xef, 0x77, 0x71, 0x5f, 0x61, 0x66, 0x66, 0x6e, 0xed, 0x66, 0x6c, 0xf6, 0xd4	/* t__pfx_wq_affn_dfl_set */
	.byte 0x0d, 0x74, 0x77, 0x71, 0x5f, 0x61, 0x66, 0x66, 0x6e, 0xed, 0x66, 0x6c, 0xf6, 0xd4	/* twq_affn_dfl_set */
	.byte 0x0b, 0xeb, 0x77, 0x71, 0x92, 0xd5, 0x6b, 0xf5, 0xa6, 0xe4, 0x6e, 0x8d	/* T__pfx_wq_worker_running */
	.byte 0x0b, 0x54, 0x77, 0x71, 0x92, 0xd5, 0x6b, 0xf5, 0xa6, 0xe4, 0x6e, 0x8d	/* Twq_worker_running */
	.byte 0x0c, 0xeb, 0x77, 0x71, 0x92, 0xd5, 0x6b, 0xf5, 0xf6, 0xc4, 0x65, 0x70, 0x8d	/* T__pfx_wq_worker_sleeping */
	.byte 0x0c, 0x54, 0x77, 0x71, 0x92, 0xd5, 0x6b, 0xf5, 0xf6, 0xc4, 0x65, 0x70, 0x8d	/* Twq_worker_sleeping */
	.byte 0x0a, 0xeb, 0x77, 0x71, 0x92, 0xd5, 0x6b, 0xf5, 0x5f, 0xdc, 0xc6	/* T__pfx_wq_worker_tick */
	.byte 0x0a, 0x54, 0x77, 0x71, 0x92, 0xd5, 0x6b, 0xf5, 0x5f, 0xdc, 0xc6	/* Twq_worker_tick */
	.byte 0x0d, 0xeb, 0x77, 0x71, 0x92, 0xd5, 0x6b, 0xf5, 0x5f, 0x6c, 0xbb, 0xfe, 0x66, 0x96	/* T__pfx_wq_worker_last_func */
	.byte 0x0d, 0x54, 0x77, 0x71, 0x92, 0xd5, 0x6b, 0xf5, 0x5f, 0x6c, 0xbb, 0xfe, 0x66, 0x96	/* Twq_worker_last_func */
	.byte 0x12, 0xeb, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x5f, 0xf2, 0xdc, 0xe7	/* T__pfx_workqueue_softirq_action */
	.byte 0x12, 0x54, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0x5f, 0xf2, 0xdc, 0xe7	/* Tworkqueue_softirq_action */
	.byte 0x11, 0xeb, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0xed, 0x65, 0xc8	/* T__pfx_workqueue_softirq_dead */
	.byte 0x11, 0x54, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x73, 0x6f, 0x66, 0xdc, 0x72, 0x71, 0xed, 0x65, 0xc8	/* Tworkqueue_softirq_dead */
	.byte 0x0d, 0xeb, 0x73, 0xba, 0x9e, 0x75, 0xb0, 0xe7, 0x5f, 0x65, 0xf2, 0x68, 0xf0, 0x9c	/* T__pfx_schedule_on_each_cpu */
	.byte 0x0d, 0x54, 0x73, 0xba, 0x9e, 0x75, 0xb0, 0xe7, 0x5f, 0x65, 0xf2, 0x68, 0xf0, 0x9c	/* Tschedule_on_each_cpu */
	.byte 0x0d, 0xeb, 0x66, 0xf7, 0xfc, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x24, 0x73	/* T__pfx_free_workqueue_attrs */
	.byte 0x0d, 0x54, 0x66, 0xf7, 0xfc, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x24, 0x73	/* Tfree_workqueue_attrs */
	.byte 0x0c, 0xeb, 0x22, 0xc9, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x24, 0x73	/* T__pfx_alloc_workqueue_attrs */
	.byte 0x0c, 0x54, 0x22, 0xc9, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x24, 0x73	/* Talloc_workqueue_attrs */
	.byte 0x0f, 0xeb, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x24, 0x73	/* T__pfx_apply_workqueue_attrs */
	.byte 0x0f, 0x54, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x24, 0x73	/* Tapply_workqueue_attrs */
	.byte 0x11, 0xeb, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x73, 0xe2, 0x6d, 0xf8, 0x5f, 0xf2, 0xdc, 0x76, 0x65	/* T__pfx_workqueue_set_min_active */
	.byte 0x11, 0x54, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x73, 0xe2, 0x6d, 0xf8, 0x5f, 0xf2, 0xdc, 0x76, 0x65	/* Tworkqueue_set_min_active */
	.byte 0x13, 0xeb, 0x63, 0x98, 0xf7, 0x6e, 0xfe, 0x69, 0xe9, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x29, 0x63, 0x75, 0xf5	/* T__pfx_current_is_workqueue_rescuer */
	.byte 0x13, 0x54, 0x63, 0x98, 0xf7, 0x6e, 0xfe, 0x69, 0xe9, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x29, 0x63, 0x75, 0xf5	/* Tcurrent_is_workqueue_rescuer */
	.byte 0x0b, 0xeb, 0x70, 0x72, 0x27, 0x77, 0xd5, 0x6b, 0xf5, 0xbf, 0x66, 0x6f	/* T__pfx_print_worker_info */
	.byte 0x0b, 0x54, 0x70, 0x72, 0x27, 0x77, 0xd5, 0x6b, 0xf5, 0xbf, 0x66, 0x6f	/* Tprint_worker_info */
	.byte 0x0d, 0xeb, 0x73, 0x7c, 0x5f, 0xe7, 0xfc, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0x65	/* T__pfx_show_one_workqueue */
	.byte 0x0d, 0x54, 0x73, 0x7c, 0x5f, 0xe7, 0xfc, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0x65	/* Tshow_one_workqueue */
	.byte 0x0d, 0xeb, 0x64, 0xd6, 0xf3, 0x6f, 0x79, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0x65	/* T__pfx_destroy_workqueue */
	.byte 0x0d, 0x54, 0x64, 0xd6, 0xf3, 0x6f, 0x79, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0x65	/* Tdestroy_workqueue */
	.byte 0x0c, 0xeb, 0x73, 0x7c, 0x5f, 0x5d, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xd6	/* T__pfx_show_all_workqueues */
	.byte 0x0c, 0x54, 0x73, 0x7c, 0x5f, 0x5d, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xd6	/* Tshow_all_workqueues */
	.byte 0x10, 0xeb, 0x73, 0x7c, 0xe6, 0xf7, 0x65, 0x7a, 0x90, 0xb0, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xd6	/* T__pfx_show_freezable_workqueues */
	.byte 0x10, 0x54, 0x73, 0x7c, 0xe6, 0xf7, 0x65, 0x7a, 0x90, 0xb0, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xd6	/* Tshow_freezable_workqueues */
	.byte 0x0a, 0xeb, 0x77, 0x71, 0x92, 0xd5, 0x6b, 0xf5, 0x3a, 0x6d, 0x6d	/* T__pfx_wq_worker_comm */
	.byte 0x0a, 0x54, 0x77, 0x71, 0x92, 0xd5, 0x6b, 0xf5, 0x3a, 0x6d, 0x6d	/* Twq_worker_comm */
	.byte 0x0f, 0xeb, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x70, 0xf7, 0x70, 0xc5, 0xfc, 0x63, 0x9c	/* T__pfx_workqueue_prepare_cpu */
	.byte 0x0f, 0x54, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x70, 0xf7, 0x70, 0xc5, 0xfc, 0x63, 0x9c	/* Tworkqueue_prepare_cpu */
	.byte 0x0d, 0xeb, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xe7, 0x2d, 0xfc, 0x63, 0x9c	/* T__pfx_workqueue_online_cpu */
	.byte 0x0d, 0x54, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xe7, 0x2d, 0xfc, 0x63, 0x9c	/* Tworkqueue_online_cpu */
	.byte 0x0f, 0xeb, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x6f, 0x66, 0x66, 0x2d, 0xfc, 0x63, 0x9c	/* T__pfx_workqueue_offline_cpu */
	.byte 0x0f, 0x54, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0x6f, 0x66, 0x66, 0x2d, 0xfc, 0x63, 0x9c	/* Tworkqueue_offline_cpu */
	.byte 0x12, 0xeb, 0x66, 0xf7, 0x65, 0x7a, 0xfc, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0x65, 0xe9, 0x62, 0x65, 0x67, 0xf8	/* T__pfx_freeze_workqueues_begin */
	.byte 0x12, 0x54, 0x66, 0xf7, 0x65, 0x7a, 0xfc, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0x65, 0xe9, 0x62, 0x65, 0x67, 0xf8	/* Tfreeze_workqueues_begin */
	.byte 0x10, 0xeb, 0x66, 0xf7, 0x65, 0x7a, 0xfc, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0x65, 0xe9, 0x06, 0xe1	/* T__pfx_freeze_workqueues_busy */
	.byte 0x10, 0x54, 0x66, 0xf7, 0x65, 0x7a, 0xfc, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0x65, 0xe9, 0x06, 0xe1	/* Tfreeze_workqueues_busy */
	.byte 0x0c, 0xeb, 0x74, 0x68, 0x61, 0x77, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xd6	/* T__pfx_thaw_workqueues */
	.byte 0x0c, 0x54, 0x74, 0x68, 0x61, 0x77, 0x92, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xd6	/* Tthaw_workqueues */
	.byte 0x17, 0xeb, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xe4, 0x62, 0x6f, 0xe4, 0xda, 0xcb, 0x63, 0x6c, 0x75, 0x64, 0xfc, 0x63, 0x9c, 0xd9, 0x5e	/* T__pfx_workqueue_unbound_exclude_cpumask */
	.byte 0x17, 0x54, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xe4, 0x62, 0x6f, 0xe4, 0xda, 0xcb, 0x63, 0x6c, 0x75, 0x64, 0xfc, 0x63, 0x9c, 0xd9, 0x5e	/* Tworkqueue_unbound_exclude_cpumask */
	.byte 0x0d, 0xeb, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xe1, 0x73, 0x80, 0xf7, 0x0e	/* T__pfx_workqueue_sysfs_register */
	.byte 0x0d, 0x54, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0xfc, 0xe1, 0x73, 0x80, 0xf7, 0x0e	/* Tworkqueue_sysfs_register */
	.byte 0x0a, 0xeb, 0x22, 0xc9, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0x65	/* T__pfx_alloc_workqueue */
	.byte 0x0a, 0x54, 0x22, 0xc9, 0x77, 0xd5, 0x6b, 0xa1, 0x65, 0x75, 0x65	/* Talloc_workqueue */
	.byte 0x05, 0xeb, 0xb2, 0xda, 0xf4, 0x5e	/* T__pfx_pid_task */
	.byte 0x05, 0x54, 0xb2, 0xda, 0xf4, 0x5e	/* Tpid_task */
	.byte 0x07, 0xeb, 0xb2, 0xda, 0x6e, 0x72, 0xbd, 0x73	/* T__pfx_pid_nr_ns */
	.byte 0x07, 0x54, 0xb2, 0xda, 0x6e, 0x72, 0xbd, 0x73	/* Tpid_nr_ns */
	.byte 0x06, 0xeb, 0xb2, 0xda, 0x76, 0x6e, 0x72	/* T__pfx_pid_vnr */
	.byte 0x06, 0x54, 0xb2, 0xda, 0x76, 0x6e, 0x72	/* Tpid_vnr */
	.byte 0x0b, 0xeb, 0xf4, 0x5e, 0x5f, 0xf2, 0xdc, 0x1a, 0xb2, 0xda, 0x6e, 0x73	/* T__pfx_task_active_pid_ns */
	.byte 0x0b, 0x54, 0xf4, 0x5e, 0x5f, 0xf2, 0xdc, 0x1a, 0xb2, 0xda, 0x6e, 0x73	/* Ttask_active_pid_ns */
	.byte 0x09, 0xeb, 0x66, 0xf8, 0x64, 0xec, 0x69, 0xda, 0x6e, 0x73	/* T__pfx_find_pid_ns */
	.byte 0x09, 0x54, 0x66, 0xf8, 0x64, 0xec, 0x69, 0xda, 0x6e, 0x73	/* Tfind_pid_ns */
	.byte 0x07, 0xeb, 0x66, 0xf8, 0xda, 0x76, 0xb2, 0x64	/* T__pfx_find_vpid */
	.byte 0x07, 0x54, 0x66, 0xf8, 0xda, 0x76, 0xb2, 0x64	/* Tfind_vpid */
	.byte 0x0a, 0x08, 0xf4, 0x5e, 0xec, 0x69, 0xda, 0x6e, 0x72, 0xbd, 0x73	/* T__pfx___task_pid_nr_ns */
	.byte 0x0a, 0xb9, 0xf4, 0x5e, 0xec, 0x69, 0xda, 0x6e, 0x72, 0xbd, 0x73	/* T__task_pid_nr_ns */
	.byte 0x08, 0xeb, 0x66, 0xf8, 0xda, 0x67, 0xfc, 0xb2, 0x64	/* T__pfx_find_ge_pid */
	.byte 0x08, 0x54, 0x66, 0xf8, 0xda, 0x67, 0xfc, 0xb2, 0x64	/* Tfind_ge_pid */
	.byte 0x0a, 0xef, 0x9c, 0xfe, 0xb2, 0x64, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* t__pfx_put_pid.part.0 */
	.byte 0x09, 0xce, 0x1e, 0xb2, 0x64, 0x2e, 0x70, 0xc5, 0x74, 0x7e	/* tput_pid.part.0 */
	.byte 0x05, 0xeb, 0x9c, 0xfe, 0xb2, 0x64	/* T__pfx_put_pid */
	.byte 0x05, 0x54, 0x9c, 0xfe, 0xb2, 0x64	/* Tput_pid */
	.byte 0x0a, 0xef, 0x64, 0xdb, 0x61, 0x79, 0x9e, 0xec, 0x1e, 0xb2, 0x64	/* t__pfx_delayed_put_pid */
	.byte 0x0a, 0x74, 0x64, 0xdb, 0x61, 0x79, 0x9e, 0xec, 0x1e, 0xb2, 0x64	/* tdelayed_put_pid */
	.byte 0x07, 0xeb, 0x67, 0xe2, 0xf4, 0x5e, 0xec, 0x9f	/* T__pfx_get_task_pid */
	.byte 0x07, 0x54, 0x67, 0xe2, 0xf4, 0x5e, 0xec, 0x9f	/* Tget_task_pid */
	.byte 0x07, 0xeb, 0x67, 0xe2, 0xb2, 0xda, 0xf4, 0x5e	/* T__pfx_get_pid_task */
	.byte 0x07, 0x54, 0x67, 0xe2, 0xb2, 0xda, 0xf4, 0x5e	/* Tget_pid_task */
	.byte 0x08, 0xeb, 0x66, 0xf8, 0xda, 0x67, 0xe2, 0xb2, 0x64	/* T__pfx_find_get_pid */
	.byte 0x08, 0x54, 0x66, 0xf8, 0xda, 0x67, 0xe2, 0xb2, 0x64	/* Tfind_get_pid */
	.byte 0x09, 0xef, 0xb2, 0x64, 0x66, 0xda, 0x67, 0xd4, 0x66, 0x64	/* t__pfx_pidfd_getfd */
	.byte 0x08, 0xce, 0x9f, 0x66, 0xda, 0x67, 0xd4, 0x66, 0x64	/* tpidfd_getfd */
	.byte 0x06, 0xeb, 0x66, 0xf7, 0xfc, 0xb2, 0x64	/* T__pfx_free_pid */
	.byte 0x06, 0x54, 0x66, 0xf7, 0xfc, 0xb2, 0x64	/* Tfree_pid */
	.byte 0x08, 0x74, 0xaf, 0x25, 0xd2, 0x67, 0xfc, 0xb2, 0x64	/* t__pfx___change_pid */
	.byte 0x08, 0x74, 0xff, 0xba, 0xd2, 0x67, 0xfc, 0xb2, 0x64	/* t__change_pid */
	.byte 0x05, 0xeb, 0x22, 0x63, 0xec, 0x9f	/* T__pfx_alloc_pid */
	.byte 0x05, 0x54, 0x22, 0x63, 0xec, 0x9f	/* Talloc_pid */
	.byte 0x0c, 0xeb, 0x64, 0xca, 0x90, 0xb0, 0xb2, 0xda, 0x22, 0x63, 0xe8, 0x69, 0xe7	/* T__pfx_disable_pid_allocation */
	.byte 0x0c, 0x54, 0x64, 0xca, 0x90, 0xb0, 0xb2, 0xda, 0x22, 0x63, 0xe8, 0x69, 0xe7	/* Tdisable_pid_allocation */
	.byte 0x06, 0xeb, 0xe8, 0xf4, 0xba, 0xec, 0x9f	/* T__pfx_attach_pid */
	.byte 0x06, 0x54, 0xe8, 0xf4, 0xba, 0xec, 0x9f	/* Tattach_pid */
	.byte 0x07, 0xeb, 0x64, 0x65, 0xf4, 0xba, 0xec, 0x9f	/* T__pfx_detach_pid */
	.byte 0x07, 0x54, 0x64, 0x65, 0xf4, 0xba, 0xec, 0x9f	/* Tdetach_pid */
	.byte 0x07, 0xeb, 0xba, 0xd2, 0x67, 0xfc, 0xb2, 0x64	/* T__pfx_change_pid */
	.byte 0x07, 0x54, 0xba, 0xd2, 0x67, 0xfc, 0xb2, 0x64	/* Tchange_pid */
	.byte 0x09, 0xeb, 0xcb, 0xba, 0xd2, 0x67, 0xfc, 0xdc, 0x64, 0x73	/* T__pfx_exchange_tids */
	.byte 0x09, 0x54, 0xcb, 0xba, 0xd2, 0x67, 0xfc, 0xdc, 0x64, 0x73	/* Texchange_tids */
	.byte 0x08, 0xeb, 0xf3, 0xd2, 0x73, 0x66, 0xf5, 0xec, 0x9f	/* T__pfx_transfer_pid */
	.byte 0x08, 0x54, 0xf3, 0xd2, 0x73, 0x66, 0xf5, 0xec, 0x9f	/* Ttransfer_pid */
	.byte 0x0d, 0xeb, 0x66, 0xf8, 0xda, 0xf4, 0x5e, 0xb8, 0x79, 0xec, 0x69, 0xda, 0x6e, 0x73	/* T__pfx_find_task_by_pid_ns */
	.byte 0x0d, 0x54, 0x66, 0xf8, 0xda, 0xf4, 0x5e, 0xb8, 0x79, 0xec, 0x69, 0xda, 0x6e, 0x73	/* Tfind_task_by_pid_ns */
	.byte 0x0b, 0xeb, 0x66, 0xf8, 0xda, 0xf4, 0x5e, 0xb8, 0x1d, 0x76, 0xb2, 0x64	/* T__pfx_find_task_by_vpid */
	.byte 0x0b, 0x54, 0x66, 0xf8, 0xda, 0xf4, 0x5e, 0xb8, 0x1d, 0x76, 0xb2, 0x64	/* Tfind_task_by_vpid */
	.byte 0x0d, 0xeb, 0x66, 0xf8, 0xda, 0x67, 0xe2, 0xf4, 0x5e, 0xb8, 0x1d, 0x76, 0xb2, 0x64	/* T__pfx_find_get_task_by_vpid */
	.byte 0x0d, 0x54, 0x66, 0xf8, 0xda, 0x67, 0xe2, 0xf4, 0x5e, 0xb8, 0x1d, 0x76, 0xb2, 0x64	/* Tfind_get_task_by_vpid */
	.byte 0x09, 0xeb, 0xb2, 0x64, 0x66, 0xda, 0x67, 0xe2, 0xb2, 0x64	/* T__pfx_pidfd_get_pid */
	.byte 0x09, 0x54, 0xb2, 0x64, 0x66, 0xda, 0x67, 0xe2, 0xb2, 0x64	/* Tpidfd_get_pid */
	.byte 0x09, 0xeb, 0xb2, 0x64, 0x66, 0xda, 0x67, 0xe2, 0xf4, 0x5e	/* T__pfx_pidfd_get_task */
	.byte 0x09, 0x54, 0xb2, 0x64, 0x66, 0xda, 0x67, 0xe2, 0xf4, 0x5e	/* Tpidfd_get_task */
	.byte 0x0c, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x9f, 0x66, 0xda, 0xbe, 0xf1	/* T__pfx___x64_sys_pidfd_open */
	.byte 0x0c, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x9f, 0x66, 0xda, 0xbe, 0xf1	/* T__x64_sys_pidfd_open */
	.byte 0x0d, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x9f, 0x66, 0xda, 0xbe, 0xf1	/* T__pfx___ia32_sys_pidfd_open */
	.byte 0x0d, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x9f, 0x66, 0xda, 0xbe, 0xf1	/* T__ia32_sys_pidfd_open */
	.byte 0x0e, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x9f, 0x66, 0xda, 0x67, 0xd4, 0x66, 0x64	/* T__pfx___x64_sys_pidfd_getfd */
	.byte 0x0e, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x9f, 0x66, 0xda, 0x67, 0xd4, 0x66, 0x64	/* T__x64_sys_pidfd_getfd */
	.byte 0x0f, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x9f, 0x66, 0xda, 0x67, 0xd4, 0x66, 0x64	/* T__pfx___ia32_sys_pidfd_getfd */
	.byte 0x0f, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x9f, 0x66, 0xda, 0x67, 0xd4, 0x66, 0x64	/* T__ia32_sys_pidfd_getfd */
	.byte 0x0e, 0xef, 0xf4, 0x5e, 0x92, 0xd5, 0x6b, 0x84, 0x6e, 0x6f, 0xdc, 0x66, 0x1d, 0xab, 0x71	/* t__pfx_task_work_set_notify_irq */
	.byte 0x0e, 0x74, 0xf4, 0x5e, 0x92, 0xd5, 0x6b, 0x84, 0x6e, 0x6f, 0xdc, 0x66, 0x1d, 0xab, 0x71	/* ttask_work_set_notify_irq */
	.byte 0x09, 0xeb, 0xf4, 0x5e, 0x92, 0xd5, 0x6b, 0x5f, 0xc8, 0x64	/* T__pfx_task_work_add */
	.byte 0x09, 0x54, 0xf4, 0x5e, 0x92, 0xd5, 0x6b, 0x5f, 0xc8, 0x64	/* Ttask_work_add */
	.byte 0x0d, 0xeb, 0xf4, 0x5e, 0x92, 0xd5, 0x6b, 0xf0, 0xd2, 0x63, 0xdb, 0xc1, 0xe8, 0xba	/* T__pfx_task_work_cancel_match */
	.byte 0x0d, 0x54, 0xf4, 0x5e, 0x92, 0xd5, 0x6b, 0xf0, 0xd2, 0x63, 0xdb, 0xc1, 0xe8, 0xba	/* Ttask_work_cancel_match */
	.byte 0x0c, 0xeb, 0xf4, 0x5e, 0x92, 0xd5, 0x6b, 0xf0, 0xd2, 0x63, 0xdb, 0xe6, 0x96	/* T__pfx_task_work_cancel_func */
	.byte 0x0c, 0x54, 0xf4, 0x5e, 0x92, 0xd5, 0x6b, 0xf0, 0xd2, 0x63, 0xdb, 0xe6, 0x96	/* Ttask_work_cancel_func */
	.byte 0x0a, 0xeb, 0xf4, 0x5e, 0x92, 0xd5, 0x6b, 0xf0, 0xd2, 0x63, 0xdb	/* T__pfx_task_work_cancel */
	.byte 0x0a, 0x54, 0xf4, 0x5e, 0x92, 0xd5, 0x6b, 0xf0, 0xd2, 0x63, 0xdb	/* Ttask_work_cancel */
	.byte 0x08, 0xeb, 0xf4, 0x5e, 0x92, 0xd5, 0x6b, 0xa6, 0xe4	/* T__pfx_task_work_run */
	.byte 0x08, 0x54, 0xf4, 0x5e, 0x92, 0xd5, 0x6b, 0xa6, 0xe4	/* Ttask_work_run */
	.byte 0x14, 0xeb, 0x73, 0x65, 0xc5, 0xba, 0x5f, 0x6b, 0xf5, 0x6e, 0xdb, 0x5f, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0x5f, 0xe0, 0xc4	/* T__pfx_search_kernel_exception_table */
	.byte 0x14, 0x54, 0x73, 0x65, 0xc5, 0xba, 0x5f, 0x6b, 0xf5, 0x6e, 0xdb, 0x5f, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0x5f, 0xe0, 0xc4	/* Tsearch_kernel_exception_table */
	.byte 0x10, 0xeb, 0x73, 0x65, 0xc5, 0xba, 0x5f, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0x5f, 0xe0, 0x6c, 0xd6	/* T__pfx_search_exception_tables */
	.byte 0x10, 0x54, 0x73, 0x65, 0xc5, 0xba, 0x5f, 0xcb, 0x63, 0x65, 0x70, 0xdc, 0xe7, 0x5f, 0xe0, 0x6c, 0xd6	/* Tsearch_exception_tables */
	.byte 0x0a, 0xeb, 0x63, 0xd5, 0xfc, 0x6b, 0xf5, 0x6e, 0xdb, 0xa7, 0x8e	/* T__pfx_core_kernel_text */
	.byte 0x0a, 0x54, 0x63, 0xd5, 0xfc, 0x6b, 0xf5, 0x6e, 0xdb, 0xa7, 0x8e	/* Tcore_kernel_text */
	.byte 0x0c, 0xeb, 0x6b, 0xf5, 0x6e, 0xdb, 0xa7, 0xcb, 0xfe, 0xc8, 0x64, 0x29, 0x73	/* T__pfx_kernel_text_address */
	.byte 0x0c, 0x54, 0x6b, 0xf5, 0x6e, 0xdb, 0xa7, 0xcb, 0xfe, 0xc8, 0x64, 0x29, 0x73	/* Tkernel_text_address */
	.byte 0x0c, 0x08, 0x6b, 0xf5, 0x6e, 0xdb, 0xa7, 0xcb, 0xfe, 0xc8, 0x64, 0x29, 0x73	/* T__pfx___kernel_text_address */
	.byte 0x0c, 0x54, 0xd8, 0xf5, 0x6e, 0xdb, 0xa7, 0xcb, 0xfe, 0xc8, 0x64, 0x29, 0x73	/* T__kernel_text_address */
	.byte 0x0e, 0xeb, 0x66, 0x96, 0xec, 0xf3, 0x5f, 0x69, 0xe9, 0x6b, 0xf5, 0x6e, 0xdb, 0xa7, 0x8e	/* T__pfx_func_ptr_is_kernel_text */
	.byte 0x0e, 0x54, 0x66, 0x96, 0xec, 0xf3, 0x5f, 0x69, 0xe9, 0x6b, 0xf5, 0x6e, 0xdb, 0xa7, 0x8e	/* Tfunc_ptr_is_kernel_text */
	.byte 0x08, 0xef, 0x6d, 0xb7, 0x75, 0xb0, 0x24, 0xf6, 0x7c	/* t__pfx_module_attr_show */
	.byte 0x08, 0x74, 0x6d, 0xb7, 0x75, 0xb0, 0x24, 0xf6, 0x7c	/* tmodule_attr_show */
	.byte 0x09, 0xef, 0x6d, 0xb7, 0x75, 0xb0, 0x24, 0xf6, 0x8a, 0xf7	/* t__pfx_module_attr_store */
	.byte 0x09, 0x74, 0x6d, 0xb7, 0x75, 0xb0, 0x24, 0xf6, 0x8a, 0xf7	/* tmodule_attr_store */
	.byte 0x06, 0xef, 0x75, 0xcc, 0xa5, 0x6c, 0xa2	/* t__pfx_uevent_filter */
	.byte 0x06, 0x74, 0x75, 0xcc, 0xa5, 0x6c, 0xa2	/* tuevent_filter */
	.byte 0x0d, 0xef, 0x70, 0xc5, 0x2a, 0x25, 0x65, 0xc6, 0x5f, 0xe4, 0x73, 0x61, 0x66, 0x65	/* t__pfx_param_check_unsafe */
	.byte 0x0c, 0xce, 0xc5, 0x2a, 0x25, 0x65, 0xc6, 0x5f, 0xe4, 0x73, 0x61, 0x66, 0x65	/* tparam_check_unsafe */
	.byte 0x08, 0xeb, 0x70, 0xc5, 0x2a, 0x84, 0x62, 0x79, 0x2c	/* T__pfx_param_set_byte */
	.byte 0x08, 0x54, 0x70, 0xc5, 0x2a, 0x84, 0x62, 0x79, 0x2c	/* Tparam_set_byte */
	.byte 0x08, 0xeb, 0x70, 0xc5, 0x2a, 0x86, 0x62, 0x79, 0x2c	/* T__pfx_param_get_byte */
	.byte 0x08, 0x54, 0x70, 0xc5, 0x2a, 0x86, 0x62, 0x79, 0x2c	/* Tparam_get_byte */
	.byte 0x09, 0xeb, 0x70, 0xc5, 0x2a, 0x86, 0x73, 0x68, 0xd5, 0x74	/* T__pfx_param_get_short */
	.byte 0x09, 0x54, 0x70, 0xc5, 0x2a, 0x86, 0x73, 0x68, 0xd5, 0x74	/* Tparam_get_short */
	.byte 0x09, 0xeb, 0x70, 0xc5, 0x2a, 0x86, 0xb1, 0x68, 0xd5, 0x74	/* T__pfx_param_get_ushort */
	.byte 0x09, 0x54, 0x70, 0xc5, 0x2a, 0x86, 0xb1, 0x68, 0xd5, 0x74	/* Tparam_get_ushort */
	.byte 0x06, 0xeb, 0x70, 0xc5, 0x2a, 0x86, 0xb3	/* T__pfx_param_get_int */
	.byte 0x06, 0x54, 0x70, 0xc5, 0x2a, 0x86, 0xb3	/* Tparam_get_int */
	.byte 0x07, 0xeb, 0x70, 0xc5, 0x2a, 0x86, 0x75, 0xb3	/* T__pfx_param_get_uint */
	.byte 0x07, 0x54, 0x70, 0xc5, 0x2a, 0x86, 0x75, 0xb3	/* Tparam_get_uint */
	.byte 0x08, 0xeb, 0x70, 0xc5, 0x2a, 0x86, 0x6c, 0xe7, 0x67	/* T__pfx_param_get_long */
	.byte 0x08, 0x54, 0x70, 0xc5, 0x2a, 0x86, 0x6c, 0xe7, 0x67	/* Tparam_get_long */
	.byte 0x08, 0xeb, 0x70, 0xc5, 0x2a, 0x86, 0x02, 0xe7, 0x67	/* T__pfx_param_get_ulong */
	.byte 0x08, 0x54, 0x70, 0xc5, 0x2a, 0x86, 0x02, 0xe7, 0x67	/* Tparam_get_ulong */
	.byte 0x09, 0xeb, 0x70, 0xc5, 0x2a, 0x86, 0x02, 0x6c, 0xe7, 0x67	/* T__pfx_param_get_ullong */
	.byte 0x09, 0x54, 0x70, 0xc5, 0x2a, 0x86, 0x02, 0x6c, 0xe7, 0x67	/* Tparam_get_ullong */
	.byte 0x08, 0xeb, 0x70, 0xc5, 0x2a, 0x86, 0x68, 0xcb, 0xb3	/* T__pfx_param_get_hexint */
	.byte 0x08, 0x54, 0x70, 0xc5, 0x2a, 0x86, 0x68, 0xcb, 0xb3	/* Tparam_get_hexint */
	.byte 0x08, 0xeb, 0x70, 0xc5, 0x2a, 0x86, 0xba, 0xc5, 0x70	/* T__pfx_param_get_charp */
	.byte 0x08, 0x54, 0x70, 0xc5, 0x2a, 0x86, 0xba, 0xc5, 0x70	/* Tparam_get_charp */
	.byte 0x08, 0xeb, 0x70, 0xc5, 0x2a, 0x86, 0x73, 0xf3, 0x8d	/* T__pfx_param_get_string */
	.byte 0x08, 0x54, 0x70, 0xc5, 0x2a, 0x86, 0x73, 0xf3, 0x8d	/* Tparam_get_string */
	.byte 0x09, 0xeb, 0x70, 0xc5, 0x2a, 0x84, 0x73, 0x68, 0xd5, 0x74	/* T__pfx_param_set_short */
	.byte 0x09, 0x54, 0x70, 0xc5, 0x2a, 0x84, 0x73, 0x68, 0xd5, 0x74	/* Tparam_set_short */
	.byte 0x09, 0xeb, 0x70, 0xc5, 0x2a, 0x84, 0xb1, 0x68, 0xd5, 0x74	/* T__pfx_param_set_ushort */
	.byte 0x09, 0x54, 0x70, 0xc5, 0x2a, 0x84, 0xb1, 0x68, 0xd5, 0x74	/* Tparam_set_ushort */
	.byte 0x06, 0xeb, 0x70, 0xc5, 0x2a, 0x84, 0xb3	/* T__pfx_param_set_int */
	.byte 0x06, 0x54, 0x70, 0xc5, 0x2a, 0x84, 0xb3	/* Tparam_set_int */
	.byte 0x07, 0xeb, 0x70, 0xc5, 0x2a, 0x84, 0x75, 0xb3	/* T__pfx_param_set_uint */
	.byte 0x07, 0x54, 0x70, 0xc5, 0x2a, 0x84, 0x75, 0xb3	/* Tparam_set_uint */
	.byte 0x0b, 0xeb, 0x70, 0xc5, 0x2a, 0x84, 0x75, 0x27, 0x6d, 0xf8, 0xd9, 0x78	/* T__pfx_param_set_uint_minmax */
	.byte 0x0b, 0x54, 0x70, 0xc5, 0x2a, 0x84, 0x75, 0x27, 0x6d, 0xf8, 0xd9, 0x78	/* Tparam_set_uint_minmax */
	.byte 0x08, 0xeb, 0x70, 0xc5, 0x2a, 0x84, 0x6c, 0xe7, 0x67	/* T__pfx_param_set_long */
	.byte 0x08, 0x54, 0x70, 0xc5, 0x2a, 0x84, 0x6c, 0xe7, 0x67	/* Tparam_set_long */
	.byte 0x08, 0xeb, 0x70, 0xc5, 0x2a, 0x84, 0x02, 0xe7, 0x67	/* T__pfx_param_set_ulong */
	.byte 0x08, 0x54, 0x70, 0xc5, 0x2a, 0x84, 0x02, 0xe7, 0x67	/* Tparam_set_ulong */
	.byte 0x0b, 0xeb, 0x70, 0xc5, 0x2a, 0x84, 0x63, 0xbe, 0x79, 0x73, 0xf3, 0x8d	/* T__pfx_param_set_copystring */
	.byte 0x0b, 0x54, 0x70, 0xc5, 0x2a, 0x84, 0x63, 0xbe, 0x79, 0x73, 0xf3, 0x8d	/* Tparam_set_copystring */
	.byte 0x0e, 0xef, 0xd9, 0x79, 0x62, 0xfc, 0x6b, 0x66, 0xf7, 0xfc, 0x70, 0xc5, 0x2a, 0xd4, 0xf5	/* t__pfx_maybe_kfree_parameter */
	.byte 0x0e, 0x74, 0xd9, 0x79, 0x62, 0xfc, 0x6b, 0x66, 0xf7, 0xfc, 0x70, 0xc5, 0x2a, 0xd4, 0xf5	/* tmaybe_kfree_parameter */
	.byte 0x0a, 0xeb, 0x70, 0xc5, 0x2a, 0xe6, 0xf7, 0xfc, 0xba, 0xc5, 0x70	/* T__pfx_param_free_charp */
	.byte 0x0a, 0x54, 0x70, 0xc5, 0x2a, 0xe6, 0xf7, 0xfc, 0xba, 0xc5, 0x70	/* Tparam_free_charp */
	.byte 0x08, 0xeb, 0x70, 0xc5, 0x2a, 0x84, 0xba, 0xc5, 0x70	/* T__pfx_param_set_charp */
	.byte 0x08, 0x54, 0x70, 0xc5, 0x2a, 0x84, 0xba, 0xc5, 0x70	/* Tparam_set_charp */
	.byte 0x08, 0xeb, 0x70, 0xc5, 0x2a, 0x84, 0x62, 0x6f, 0xa0	/* T__pfx_param_set_bool */
	.byte 0x08, 0x54, 0x70, 0xc5, 0x2a, 0x84, 0x62, 0x6f, 0xa0	/* Tparam_set_bool */
	.byte 0x0e, 0xeb, 0x70, 0xc5, 0x2a, 0x84, 0x62, 0x6f, 0xa0, 0x0d, 0x90, 0xb0, 0xe7, 0x6c, 0x79	/* T__pfx_param_set_bool_enable_only */
	.byte 0x0e, 0x54, 0x70, 0xc5, 0x2a, 0x84, 0x62, 0x6f, 0xa0, 0x0d, 0x90, 0xb0, 0xe7, 0x6c, 0x79	/* Tparam_set_bool_enable_only */
	.byte 0x0a, 0xeb, 0x70, 0xc5, 0x2a, 0x84, 0xf8, 0x76, 0x62, 0x6f, 0xa0	/* T__pfx_param_set_invbool */
	.byte 0x0a, 0x54, 0x70, 0xc5, 0x2a, 0x84, 0xf8, 0x76, 0x62, 0x6f, 0xa0	/* Tparam_set_invbool */
	.byte 0x07, 0xeb, 0x70, 0xc5, 0x2a, 0x84, 0x62, 0xb3	/* T__pfx_param_set_bint */
	.byte 0x07, 0x54, 0x70, 0xc5, 0x2a, 0x84, 0x62, 0xb3	/* Tparam_set_bint */
	.byte 0x08, 0xeb, 0x70, 0xc5, 0x2a, 0x86, 0x62, 0x6f, 0xa0	/* T__pfx_param_get_bool */
	.byte 0x08, 0x54, 0x70, 0xc5, 0x2a, 0x86, 0x62, 0x6f, 0xa0	/* Tparam_get_bool */
	.byte 0x0a, 0xeb, 0x70, 0xc5, 0x2a, 0x86, 0xf8, 0x76, 0x62, 0x6f, 0xa0	/* T__pfx_param_get_invbool */
	.byte 0x0a, 0x54, 0x70, 0xc5, 0x2a, 0x86, 0xf8, 0x76, 0x62, 0x6f, 0xa0	/* Tparam_get_invbool */
	.byte 0x0a, 0xeb, 0x6b, 0xf5, 0x6e, 0xdb, 0xec, 0xc5, 0x61, 0xae, 0xa4	/* T__pfx_kernel_param_lock */
	.byte 0x0a, 0x54, 0x6b, 0xf5, 0x6e, 0xdb, 0xec, 0xc5, 0x61, 0xae, 0xa4	/* Tkernel_param_lock */
	.byte 0x0b, 0xeb, 0x6b, 0xf5, 0x6e, 0xdb, 0xec, 0xc5, 0x61, 0xae, 0xe4, 0xa4	/* T__pfx_kernel_param_unlock */
	.byte 0x0b, 0x54, 0x6b, 0xf5, 0x6e, 0xdb, 0xec, 0xc5, 0x61, 0xae, 0xe4, 0xa4	/* Tkernel_param_unlock */
	.byte 0x09, 0xef, 0x70, 0xc5, 0x61, 0xae, 0x24, 0xf6, 0x8a, 0xf7	/* t__pfx_param_attr_store */
	.byte 0x08, 0xce, 0xc5, 0x61, 0xae, 0x24, 0xf6, 0x8a, 0xf7	/* tparam_attr_store */
	.byte 0x08, 0xef, 0x70, 0xc5, 0x61, 0xae, 0x24, 0xf6, 0x7c	/* t__pfx_param_attr_show */
	.byte 0x07, 0xce, 0xc5, 0x61, 0xae, 0x24, 0xf6, 0x7c	/* tparam_attr_show */
	.byte 0x0d, 0xef, 0x6d, 0xb7, 0x75, 0xb0, 0x6b, 0x6f, 0x62, 0x6a, 0xde, 0xc4, 0xbb, 0x65	/* t__pfx_module_kobj_release */
	.byte 0x0d, 0x74, 0x6d, 0xb7, 0x75, 0xb0, 0x6b, 0x6f, 0x62, 0x6a, 0xde, 0xc4, 0xbb, 0x65	/* tmodule_kobj_release */
	.byte 0x0b, 0xef, 0x70, 0xc5, 0x61, 0xae, 0xc5, 0xbc, 0x79, 0xe6, 0xf7, 0x65	/* t__pfx_param_array_free */
	.byte 0x0a, 0xce, 0xc5, 0x61, 0xae, 0xc5, 0xbc, 0x79, 0xe6, 0xf7, 0x65	/* tparam_array_free */
	.byte 0x0a, 0xef, 0x70, 0xc5, 0x61, 0xae, 0xc5, 0xbc, 0x79, 0xc7, 0xd4	/* t__pfx_param_array_get */
	.byte 0x09, 0xce, 0xc5, 0x61, 0xae, 0xc5, 0xbc, 0x79, 0xc7, 0xd4	/* tparam_array_get */
	.byte 0x09, 0xef, 0xc8, 0x64, 0x7f, 0x73, 0x95, 0xec, 0xc5, 0x2a	/* t__pfx_add_sysfs_param */
	.byte 0x09, 0xf4, 0x64, 0x64, 0x7f, 0x73, 0x95, 0xec, 0xc5, 0x2a	/* tadd_sysfs_param */
	.byte 0x0a, 0xef, 0x70, 0xc5, 0x61, 0xae, 0xc5, 0xbc, 0x79, 0xf6, 0xd4	/* t__pfx_param_array_set */
	.byte 0x09, 0xce, 0xc5, 0x61, 0xae, 0xc5, 0xbc, 0x79, 0xf6, 0xd4	/* tparam_array_set */
	.byte 0x09, 0xeb, 0x70, 0xc5, 0x2a, 0x84, 0x02, 0x6c, 0xe7, 0x67	/* T__pfx_param_set_ullong */
	.byte 0x09, 0x54, 0x70, 0xc5, 0x2a, 0x84, 0x02, 0x6c, 0xe7, 0x67	/* Tparam_set_ullong */
	.byte 0x08, 0xeb, 0x70, 0xc5, 0x2a, 0x84, 0x68, 0xcb, 0xb3	/* T__pfx_param_set_hexint */
	.byte 0x08, 0x54, 0x70, 0xc5, 0x2a, 0x84, 0x68, 0xcb, 0xb3	/* Tparam_set_hexint */
	.byte 0x07, 0xeb, 0x70, 0xc5, 0x61, 0xa8, 0x71, 0x6e	/* T__pfx_parameqn */
	.byte 0x07, 0x54, 0x70, 0xc5, 0x61, 0xa8, 0x71, 0x6e	/* Tparameqn */
	.byte 0x06, 0xeb, 0x70, 0xc5, 0x61, 0xa8, 0x71	/* T__pfx_parameq */
	.byte 0x06, 0x54, 0x70, 0xc5, 0x61, 0xa8, 0x71	/* Tparameq */
	.byte 0x08, 0xeb, 0x70, 0xc5, 0x73, 0xfc, 0xc5, 0x67, 0x73	/* T__pfx_parse_args */
	.byte 0x08, 0x54, 0x70, 0xc5, 0x73, 0xfc, 0xc5, 0x67, 0x73	/* Tparse_args */
	.byte 0x0e, 0xeb, 0x6d, 0xb7, 0x75, 0xb0, 0x70, 0xc5, 0x2a, 0x7f, 0x73, 0x95, 0xf6, 0xd4, 0xcd	/* T__pfx_module_param_sysfs_setup */
	.byte 0x0e, 0x54, 0x6d, 0xb7, 0x75, 0xb0, 0x70, 0xc5, 0x2a, 0x7f, 0x73, 0x95, 0xf6, 0xd4, 0xcd	/* Tmodule_param_sysfs_setup */
	.byte 0x0f, 0xeb, 0x6d, 0xb7, 0x75, 0xb0, 0x70, 0xc5, 0x2a, 0x7f, 0x73, 0x80, 0xf7, 0x17, 0x76, 0x65	/* T__pfx_module_param_sysfs_remove */
	.byte 0x0f, 0x54, 0x6d, 0xb7, 0x75, 0xb0, 0x70, 0xc5, 0x2a, 0x7f, 0x73, 0x80, 0xf7, 0x17, 0x76, 0x65	/* Tmodule_param_sysfs_remove */
	.byte 0x0a, 0xeb, 0x64, 0xd6, 0xf3, 0x6f, 0x79, 0xec, 0xc5, 0x2a, 0x73	/* T__pfx_destroy_params */
	.byte 0x0a, 0x54, 0x64, 0xd6, 0xf3, 0x6f, 0x79, 0xec, 0xc5, 0x2a, 0x73	/* Tdestroy_params */
	.byte 0x0a, 0x99, 0xc1, 0xb7, 0x0b, 0x5f, 0x0b, 0x85, 0xe7, 0xf6, 0x7c	/* T__pfx___modver_version_show */
	.byte 0x0a, 0xb9, 0x6d, 0xb7, 0x0b, 0x5f, 0x0b, 0x85, 0xe7, 0xf6, 0x7c	/* T__modver_version_show */
	.byte 0x08, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xe6, 0x96	/* T__pfx_kthread_func */
	.byte 0x08, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xe6, 0x96	/* Tkthread_func */
	.byte 0x0d, 0x08, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xf8, 0x9d, 0x77, 0xd5, 0x6b, 0xf5	/* T__pfx___kthread_init_worker */
	.byte 0x0d, 0x54, 0xd8, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xf8, 0x9d, 0x77, 0xd5, 0x6b, 0xf5	/* T__kthread_init_worker */
	.byte 0x08, 0xef, 0x8a, 0x5f, 0x6b, 0x74, 0x68, 0xf7, 0xc8	/* t__pfx_to_kthread */
	.byte 0x08, 0x74, 0x8a, 0x5f, 0x6b, 0x74, 0x68, 0xf7, 0xc8	/* tto_kthread */
	.byte 0x0f, 0xef, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xe6, 0x6c, 0xb1, 0x68, 0x92, 0xd5, 0x6b, 0xe6, 0x6e	/* t__pfx_kthread_flush_work_fn */
	.byte 0x0f, 0x74, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xe6, 0x6c, 0xb1, 0x68, 0x92, 0xd5, 0x6b, 0xe6, 0x6e	/* tkthread_flush_work_fn */
	.byte 0x0c, 0x74, 0xaf, 0x5f, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xec, 0xc5, 0x6b, 0xa8	/* t__pfx___kthread_parkme */
	.byte 0x0a, 0x74, 0xd8, 0x74, 0x68, 0xf7, 0xc8, 0xec, 0xc5, 0x6b, 0xa8	/* t__kthread_parkme */
	.byte 0x09, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xcb, 0xea	/* T__pfx_kthread_exit */
	.byte 0x09, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xcb, 0xea	/* Tkthread_exit */
	.byte 0x0f, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0x3a, 0xb6, 0x6c, 0xd4, 0xfc, 0xd2, 0xda, 0xcb, 0xea	/* T__pfx_kthread_complete_and_exit */
	.byte 0x0f, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0x3a, 0xb6, 0x6c, 0xd4, 0xfc, 0xd2, 0xda, 0xcb, 0xea	/* Tkthread_complete_and_exit */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf0, 0xf7, 0x91, 0xe7, 0xbd, 0xb7, 0x65	/* t__pfx___kthread_create_on_node */
	.byte 0x0d, 0x74, 0xd8, 0x74, 0x68, 0xf7, 0xc8, 0xf0, 0xf7, 0x91, 0xe7, 0xbd, 0xb7, 0x65	/* t__kthread_create_on_node */
	.byte 0x0d, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf0, 0xf7, 0x91, 0xe7, 0xbd, 0xb7, 0x65	/* T__pfx_kthread_create_on_node */
	.byte 0x0d, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf0, 0xf7, 0x91, 0xe7, 0xbd, 0xb7, 0x65	/* Tkthread_create_on_node */
	.byte 0x06, 0xef, 0x6b, 0x74, 0x68, 0xf7, 0xc8	/* t__pfx_kthread */
	.byte 0x06, 0x74, 0x6b, 0x74, 0x68, 0xf7, 0xc8	/* tkthread */
	.byte 0x0b, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xb1, 0xfc, 0x6d, 0x6d	/* T__pfx_kthread_use_mm */
	.byte 0x0b, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xb1, 0xfc, 0x6d, 0x6d	/* Tkthread_use_mm */
	.byte 0x15, 0xef, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xf8, 0x73, 0xf5, 0xfe, 0x77, 0xd5, 0x6b, 0xf6, 0xd2, 0xea, 0x79, 0x25, 0x65, 0xc6	/* t__pfx_kthread_insert_work_sanity_check */
	.byte 0x15, 0x74, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xf8, 0x73, 0xf5, 0xfe, 0x77, 0xd5, 0x6b, 0xf6, 0xd2, 0xea, 0x79, 0x25, 0x65, 0xc6	/* tkthread_insert_work_sanity_check */
	.byte 0x0e, 0x74, 0xaf, 0x5f, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x62, 0xf8, 0xda, 0xd9, 0x5e	/* t__pfx___kthread_bind_mask */
	.byte 0x0c, 0x74, 0xd8, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x62, 0xf8, 0xda, 0xd9, 0x5e	/* t__kthread_bind_mask */
	.byte 0x0c, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xe4, 0xb1, 0xfc, 0x6d, 0x6d	/* T__pfx_kthread_unuse_mm */
	.byte 0x0c, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xe4, 0xb1, 0xfc, 0x6d, 0x6d	/* Tkthread_unuse_mm */
	.byte 0x0a, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x62, 0xf8, 0x64	/* T__pfx_kthread_bind */
	.byte 0x0a, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x62, 0xf8, 0x64	/* Tkthread_bind */
	.byte 0x0f, 0x74, 0xaf, 0x5f, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf0, 0xf7, 0x91, 0x77, 0xd5, 0x6b, 0xf5	/* t__pfx___kthread_create_worker */
	.byte 0x0d, 0x74, 0xd8, 0x74, 0x68, 0xf7, 0xc8, 0xf0, 0xf7, 0x91, 0x77, 0xd5, 0x6b, 0xf5	/* t__kthread_create_worker */
	.byte 0x0d, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf0, 0xf7, 0x91, 0x77, 0xd5, 0x6b, 0xf5	/* T__pfx_kthread_create_worker */
	.byte 0x0d, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf0, 0xf7, 0x91, 0x77, 0xd5, 0x6b, 0xf5	/* Tkthread_create_worker */
	.byte 0x11, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf0, 0xf7, 0x91, 0x77, 0xd5, 0x6b, 0xf5, 0x5f, 0xe7, 0xf0, 0x9c	/* T__pfx_kthread_create_worker_on_cpu */
	.byte 0x11, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf0, 0xf7, 0x91, 0x77, 0xd5, 0x6b, 0xf5, 0x5f, 0xe7, 0xf0, 0x9c	/* Tkthread_create_worker_on_cpu */
	.byte 0x08, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xed, 0x0a	/* T__pfx_kthread_data */
	.byte 0x08, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xed, 0x0a	/* Tkthread_data */
	.byte 0x0e, 0xef, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xf8, 0x73, 0xf5, 0xfe, 0x77, 0xd5, 0x6b	/* t__pfx_kthread_insert_work */
	.byte 0x0e, 0x74, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xf8, 0x73, 0xf5, 0xfe, 0x77, 0xd5, 0x6b	/* tkthread_insert_work */
	.byte 0x0e, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xa1, 0x65, 0x75, 0xfc, 0x77, 0xd5, 0x6b	/* T__pfx_kthread_queue_work */
	.byte 0x0e, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xa1, 0x65, 0x75, 0xfc, 0x77, 0xd5, 0x6b	/* Tkthread_queue_work */
	.byte 0x14, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xed, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b, 0x5f, 0x00, 0xf5, 0xe6, 0x6e	/* T__pfx_kthread_delayed_work_timer_fn */
	.byte 0x14, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xed, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b, 0x5f, 0x00, 0xf5, 0xe6, 0x6e	/* Tkthread_delayed_work_timer_fn */
	.byte 0x0d, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xe6, 0x6c, 0xb1, 0x68, 0x92, 0xd5, 0x6b	/* T__pfx_kthread_flush_work */
	.byte 0x0d, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xe6, 0x6c, 0xb1, 0x68, 0x92, 0xd5, 0x6b	/* Tkthread_flush_work */
	.byte 0x12, 0x74, 0xaf, 0x5f, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf0, 0xd2, 0x63, 0xdb, 0x92, 0xd5, 0x6b, 0x7f, 0x6e, 0x63	/* t__pfx___kthread_cancel_work_sync */
	.byte 0x10, 0x74, 0xd8, 0x74, 0x68, 0xf7, 0xc8, 0xf0, 0xd2, 0x63, 0xdb, 0x92, 0xd5, 0x6b, 0x7f, 0x6e, 0x63	/* t__kthread_cancel_work_sync */
	.byte 0x10, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf0, 0xd2, 0x63, 0xdb, 0x92, 0xd5, 0x6b, 0x7f, 0x6e, 0x63	/* T__pfx_kthread_cancel_work_sync */
	.byte 0x10, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf0, 0xd2, 0x63, 0xdb, 0x92, 0xd5, 0x6b, 0x7f, 0x6e, 0x63	/* Tkthread_cancel_work_sync */
	.byte 0x16, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf0, 0xd2, 0x63, 0xdb, 0xed, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b, 0x7f, 0x6e, 0x63	/* T__pfx_kthread_cancel_delayed_work_sync */
	.byte 0x16, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf0, 0xd2, 0x63, 0xdb, 0xed, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b, 0x7f, 0x6e, 0x63	/* Tkthread_cancel_delayed_work_sync */
	.byte 0x16, 0x74, 0xaf, 0x5f, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xa1, 0x65, 0x75, 0xfc, 0x64, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b	/* t__pfx___kthread_queue_delayed_work */
	.byte 0x14, 0x74, 0xd8, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xa1, 0x65, 0x75, 0xfc, 0x64, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b	/* t__kthread_queue_delayed_work */
	.byte 0x14, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xa1, 0x65, 0x75, 0xfc, 0x64, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b	/* T__pfx_kthread_queue_delayed_work */
	.byte 0x14, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xa1, 0x65, 0x75, 0xfc, 0x64, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b	/* Tkthread_queue_delayed_work */
	.byte 0x12, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x6d, 0xb7, 0xed, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b	/* T__pfx_kthread_mod_delayed_work */
	.byte 0x12, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x6d, 0xb7, 0xed, 0xdb, 0x61, 0x79, 0x65, 0xda, 0x77, 0xd5, 0x6b	/* Tkthread_mod_delayed_work */
	.byte 0x0e, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xe6, 0x6c, 0xb1, 0x68, 0x92, 0xd5, 0x6b, 0xf5	/* T__pfx_kthread_flush_worker */
	.byte 0x0e, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xe6, 0x6c, 0xb1, 0x68, 0x92, 0xd5, 0x6b, 0xf5	/* Tkthread_flush_worker */
	.byte 0x0e, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf6, 0x68, 0x6f, 0x02, 0x64, 0xf6, 0x74, 0xbe	/* T__pfx_kthread_should_stop */
	.byte 0x0e, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf6, 0x68, 0x6f, 0x02, 0x64, 0xf6, 0x74, 0xbe	/* Tkthread_should_stop */
	.byte 0x0e, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf6, 0x68, 0x6f, 0x02, 0x64, 0xec, 0xc5, 0x6b	/* T__pfx_kthread_should_park */
	.byte 0x0e, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf6, 0x68, 0x6f, 0x02, 0x64, 0xec, 0xc5, 0x6b	/* Tkthread_should_park */
	.byte 0x0a, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xec, 0xc5, 0x6b, 0xa8	/* T__pfx_kthread_parkme */
	.byte 0x0a, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xec, 0xc5, 0x6b, 0xa8	/* Tkthread_parkme */
	.byte 0x0d, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x77, 0xd5, 0x6b, 0xf5, 0xe6, 0x6e	/* T__pfx_kthread_worker_fn */
	.byte 0x0d, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x77, 0xd5, 0x6b, 0xf5, 0xe6, 0x6e	/* Tkthread_worker_fn */
	.byte 0x14, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xe6, 0xf7, 0x65, 0x7a, 0x90, 0xb0, 0x73, 0x68, 0x6f, 0x02, 0x64, 0xf6, 0x74, 0xbe	/* T__pfx_kthread_freezable_should_stop */
	.byte 0x14, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xe6, 0xf7, 0x65, 0x7a, 0x90, 0xb0, 0x73, 0x68, 0x6f, 0x02, 0x64, 0xf6, 0x74, 0xbe	/* Tkthread_freezable_should_stop */
	.byte 0x0c, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf0, 0xf7, 0x91, 0xe7, 0xf0, 0x9c	/* T__pfx_kthread_create_on_cpu */
	.byte 0x0c, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf0, 0xf7, 0x91, 0xe7, 0xf0, 0x9c	/* Tkthread_create_on_cpu */
	.byte 0x0b, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xe4, 0x70, 0xc5, 0x6b	/* T__pfx_kthread_unpark */
	.byte 0x0b, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xe4, 0x70, 0xc5, 0x6b	/* Tkthread_unpark */
	.byte 0x09, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xec, 0xc5, 0x6b	/* T__pfx_kthread_park */
	.byte 0x09, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xec, 0xc5, 0x6b	/* Tkthread_park */
	.byte 0x09, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf6, 0x74, 0xbe	/* T__pfx_kthread_stop */
	.byte 0x09, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf6, 0x74, 0xbe	/* Tkthread_stop */
	.byte 0x0f, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xed, 0xd6, 0xf3, 0x6f, 0x79, 0x92, 0xd5, 0x6b, 0xf5	/* T__pfx_kthread_destroy_worker */
	.byte 0x0f, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xed, 0xd6, 0xf3, 0x6f, 0x79, 0x92, 0xd5, 0x6b, 0xf5	/* Tkthread_destroy_worker */
	.byte 0x0b, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf6, 0x74, 0xbe, 0xec, 0x20	/* T__pfx_kthread_stop_put */
	.byte 0x0b, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf6, 0x74, 0xbe, 0xec, 0x20	/* Tkthread_stop_put */
	.byte 0x11, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xbb, 0x73, 0x6f, 0x9b, 0x91, 0x62, 0x6c, 0x6b, 0x63, 0x67	/* T__pfx_kthread_associate_blkcg */
	.byte 0x11, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xbb, 0x73, 0x6f, 0x9b, 0x91, 0x62, 0x6c, 0x6b, 0x63, 0x67	/* Tkthread_associate_blkcg */
	.byte 0x0b, 0xeb, 0x67, 0xe2, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0x3a, 0x6d, 0x6d	/* T__pfx_get_kthread_comm */
	.byte 0x0b, 0x54, 0x67, 0xe2, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0x3a, 0x6d, 0x6d	/* Tget_kthread_comm */
	.byte 0x0d, 0xeb, 0x73, 0xe2, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf6, 0xf3, 0x75, 0x63, 0x74	/* T__pfx_set_kthread_struct */
	.byte 0x0d, 0x54, 0x73, 0xe2, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf6, 0xf3, 0x75, 0x63, 0x74	/* Tset_kthread_struct */
	.byte 0x0e, 0xeb, 0x66, 0xf7, 0xfc, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf6, 0xf3, 0x75, 0x63, 0x74	/* T__pfx_free_kthread_struct */
	.byte 0x0e, 0x54, 0x66, 0xf7, 0xfc, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf6, 0xf3, 0x75, 0x63, 0x74	/* Tfree_kthread_struct */
	.byte 0x13, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf6, 0x68, 0x6f, 0x02, 0x64, 0xf6, 0x74, 0xbe, 0x5f, 0xd5, 0xec, 0xc5, 0x6b	/* T__pfx_kthread_should_stop_or_park */
	.byte 0x13, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf6, 0x68, 0x6f, 0x02, 0x64, 0xf6, 0x74, 0xbe, 0x5f, 0xd5, 0xec, 0xc5, 0x6b	/* Tkthread_should_stop_or_park */
	.byte 0x0b, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xec, 0x8c, 0xfc, 0x64, 0x0a	/* T__pfx_kthread_probe_data */
	.byte 0x0b, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xec, 0x8c, 0xfc, 0x64, 0x0a	/* Tkthread_probe_data */
	.byte 0x0a, 0xeb, 0x93, 0x6b, 0xe6, 0xd5, 0x6b, 0x86, 0x6e, 0xb7, 0x65	/* T__pfx_tsk_fork_get_node */
	.byte 0x0a, 0x54, 0x93, 0x6b, 0xe6, 0xd5, 0x6b, 0x86, 0x6e, 0xb7, 0x65	/* Ttsk_fork_get_node */
	.byte 0x0c, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x62, 0xf8, 0xda, 0xd9, 0x5e	/* T__pfx_kthread_bind_mask */
	.byte 0x0c, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x62, 0xf8, 0xda, 0xd9, 0x5e	/* Tkthread_bind_mask */
	.byte 0x0a, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0x84, 0x19, 0xf0, 0x9c	/* T__pfx_kthread_set_per_cpu */
	.byte 0x0a, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0x84, 0x19, 0xf0, 0x9c	/* Tkthread_set_per_cpu */
	.byte 0x0c, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xca, 0xec, 0xf5, 0xf0, 0x9c	/* T__pfx_kthread_is_per_cpu */
	.byte 0x0c, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0xca, 0xec, 0xf5, 0xf0, 0x9c	/* Tkthread_is_per_cpu */
	.byte 0x07, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0x64	/* T__pfx_kthreadd */
	.byte 0x07, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0x64	/* Tkthreadd */
	.byte 0x0c, 0xeb, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x62, 0x6c, 0x6b, 0x63, 0x67	/* T__pfx_kthread_blkcg */
	.byte 0x0c, 0x54, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x62, 0x6c, 0x6b, 0x63, 0x67	/* Tkthread_blkcg */
	.byte 0x09, 0xeb, 0xe1, 0xe9, 0x6e, 0x69, 0x7f, 0x73, 0x63, 0x5d	/* T__pfx_sys_ni_syscall */
	.byte 0x09, 0x54, 0xe1, 0xe9, 0x6e, 0x69, 0x7f, 0x73, 0x63, 0x5d	/* Tsys_ni_syscall */
	.byte 0x13, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xc0, 0xec, 0x67, 0xd4, 0xd7, 0x74, 0xe9, 0xdc, 0xa8, 0x33, 0x32	/* W__pfx___x64_sys_io_pgetevents_time32 */
	.byte 0x12, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xc0, 0xec, 0x67, 0xd4, 0xd7, 0x74, 0xe9, 0xdc, 0xa8, 0x33, 0x32	/* W__x64_sys_io_pgetevents_time32 */
	.byte 0x14, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xc0, 0xec, 0x67, 0xd4, 0xd7, 0x74, 0xe9, 0xdc, 0xa8, 0x33, 0x32	/* W__pfx___ia32_sys_io_pgetevents_time32 */
	.byte 0x13, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xc0, 0xec, 0x67, 0xd4, 0xd7, 0x74, 0xe9, 0xdc, 0xa8, 0x33, 0x32	/* W__ia32_sys_io_pgetevents_time32 */
	.byte 0x0f, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xa0, 0xda, 0x6d, 0x73, 0x67, 0x63, 0x23	/* W__pfx___x64_sys_old_msgctl */
	.byte 0x0e, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xa0, 0xda, 0x6d, 0x73, 0x67, 0x63, 0x23	/* W__x64_sys_old_msgctl */
	.byte 0x10, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xa0, 0xda, 0x6d, 0x73, 0x67, 0x63, 0x23	/* W__pfx___ia32_sys_old_msgctl */
	.byte 0x0f, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xa0, 0xda, 0x6d, 0x73, 0x67, 0x63, 0x23	/* W__ia32_sys_old_msgctl */
	.byte 0x0f, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xa0, 0x64, 0xf6, 0x65, 0x6d, 0x63, 0x23	/* W__pfx___x64_sys_old_semctl */
	.byte 0x0e, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xa0, 0x64, 0xf6, 0x65, 0x6d, 0x63, 0x23	/* W__x64_sys_old_semctl */
	.byte 0x10, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xa0, 0x64, 0xf6, 0x65, 0x6d, 0x63, 0x23	/* W__pfx___ia32_sys_old_semctl */
	.byte 0x0f, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xa0, 0x64, 0xf6, 0x65, 0x6d, 0x63, 0x23	/* W__ia32_sys_old_semctl */
	.byte 0x0f, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xa0, 0x64, 0xf6, 0x68, 0x6d, 0x63, 0x23	/* W__pfx___x64_sys_old_shmctl */
	.byte 0x0e, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xa0, 0x64, 0xf6, 0x68, 0x6d, 0x63, 0x23	/* W__x64_sys_old_shmctl */
	.byte 0x10, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xa0, 0x64, 0xf6, 0x68, 0x6d, 0x63, 0x23	/* W__pfx___ia32_sys_old_shmctl */
	.byte 0x0f, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xa0, 0x64, 0xf6, 0x68, 0x6d, 0x63, 0x23	/* W__ia32_sys_old_shmctl */
	.byte 0x14, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0xf6, 0xd4, 0x73, 0x6f, 0xc6, 0xbe, 0x74	/* W__pfx___ia32_compat_sys_setsockopt */
	.byte 0x13, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0xf6, 0xd4, 0x73, 0x6f, 0xc6, 0xbe, 0x74	/* W__ia32_compat_sys_setsockopt */
	.byte 0x14, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x67, 0xd4, 0x73, 0x6f, 0xc6, 0xbe, 0x74	/* W__pfx___ia32_compat_sys_getsockopt */
	.byte 0x13, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x67, 0xd4, 0x73, 0x6f, 0xc6, 0xbe, 0x74	/* W__ia32_compat_sys_getsockopt */
	.byte 0x12, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x6c, 0x05, 0xa4, 0xf0, 0xf7, 0x91, 0x72, 0x02, 0xd6, 0xd4	/* W__pfx___x64_sys_landlock_create_ruleset */
	.byte 0x11, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x6c, 0x05, 0xa4, 0xf0, 0xf7, 0x91, 0x72, 0x02, 0xd6, 0xd4	/* W__x64_sys_landlock_create_ruleset */
	.byte 0x13, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x6c, 0x05, 0xa4, 0xf0, 0xf7, 0x91, 0x72, 0x02, 0xd6, 0xd4	/* W__pfx___ia32_sys_landlock_create_ruleset */
	.byte 0x12, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x6c, 0x05, 0xa4, 0xf0, 0xf7, 0x91, 0x72, 0x02, 0xd6, 0xd4	/* W__ia32_sys_landlock_create_ruleset */
	.byte 0x11, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x6c, 0x05, 0xa4, 0x5f, 0xc8, 0xda, 0x72, 0x75, 0xc4	/* W__pfx___x64_sys_landlock_add_rule */
	.byte 0x10, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x6c, 0x05, 0xa4, 0x5f, 0xc8, 0xda, 0x72, 0x75, 0xc4	/* W__x64_sys_landlock_add_rule */
	.byte 0x12, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x6c, 0x05, 0xa4, 0x5f, 0xc8, 0xda, 0x72, 0x75, 0xc4	/* W__pfx___ia32_sys_landlock_add_rule */
	.byte 0x11, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x6c, 0x05, 0xa4, 0x5f, 0xc8, 0xda, 0x72, 0x75, 0xc4	/* W__ia32_sys_landlock_add_rule */
	.byte 0x12, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x6c, 0x05, 0xa4, 0x07, 0xf3, 0xaa, 0xfe, 0x73, 0xdb, 0x66	/* W__pfx___x64_sys_landlock_restrict_self */
	.byte 0x11, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x6c, 0x05, 0xa4, 0x07, 0xf3, 0xaa, 0xfe, 0x73, 0xdb, 0x66	/* W__x64_sys_landlock_restrict_self */
	.byte 0x13, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x6c, 0x05, 0xa4, 0x07, 0xf3, 0xaa, 0xfe, 0x73, 0xdb, 0x66	/* W__pfx___ia32_sys_landlock_restrict_self */
	.byte 0x12, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x6c, 0x05, 0xa4, 0x07, 0xf3, 0xaa, 0xfe, 0x73, 0xdb, 0x66	/* W__ia32_sys_landlock_restrict_self */
	.byte 0x17, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x66, 0xc8, 0x76, 0xca, 0x65, 0x36, 0x34, 0x5f, 0x36, 0x34	/* W__pfx___ia32_compat_sys_fadvise64_64 */
	.byte 0x16, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x66, 0xc8, 0x76, 0xca, 0x65, 0x36, 0x34, 0x5f, 0x36, 0x34	/* W__ia32_compat_sys_fadvise64_64 */
	.byte 0x10, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x66, 0xd2, 0x6f, 0xdc, 0x66, 0x79, 0xbf, 0xea	/* W__pfx___x64_sys_fanotify_init */
	.byte 0x0f, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x66, 0xd2, 0x6f, 0xdc, 0x66, 0x79, 0xbf, 0xea	/* W__x64_sys_fanotify_init */
	.byte 0x11, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x66, 0xd2, 0x6f, 0xdc, 0x66, 0x79, 0xbf, 0xea	/* W__pfx___ia32_sys_fanotify_init */
	.byte 0x10, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x66, 0xd2, 0x6f, 0xdc, 0x66, 0x79, 0xbf, 0xea	/* W__ia32_sys_fanotify_init */
	.byte 0x11, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x66, 0xd2, 0x6f, 0xdc, 0x66, 0x1d, 0xd9, 0x72, 0x6b	/* W__pfx___x64_sys_fanotify_mark */
	.byte 0x10, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x66, 0xd2, 0x6f, 0xdc, 0x66, 0x1d, 0xd9, 0x72, 0x6b	/* W__x64_sys_fanotify_mark */
	.byte 0x12, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x66, 0xd2, 0x6f, 0xdc, 0x66, 0x1d, 0xd9, 0x72, 0x6b	/* W__pfx___ia32_sys_fanotify_mark */
	.byte 0x11, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x66, 0xd2, 0x6f, 0xdc, 0x66, 0x1d, 0xd9, 0x72, 0x6b	/* W__ia32_sys_fanotify_mark */
	.byte 0x17, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0xec, 0xe3, 0x63, 0xd6, 0xe9, 0x76, 0x6d, 0xde, 0xc8, 0x76	/* W__pfx___ia32_compat_sys_process_vm_readv */
	.byte 0x16, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0xec, 0xe3, 0x63, 0xd6, 0xe9, 0x76, 0x6d, 0xde, 0xc8, 0x76	/* W__ia32_compat_sys_process_vm_readv */
	.byte 0x17, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0xec, 0xe3, 0x63, 0xd6, 0xe9, 0x76, 0xae, 0x77, 0x3c, 0xee	/* W__pfx___ia32_compat_sys_process_vm_writev */
	.byte 0x16, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0xec, 0xe3, 0x63, 0xd6, 0xe9, 0x76, 0xae, 0x77, 0x3c, 0xee	/* W__ia32_compat_sys_process_vm_writev */
	.byte 0x0b, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x62, 0x70, 0x66	/* W__pfx___x64_sys_bpf */
	.byte 0x0a, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x62, 0x70, 0x66	/* W__x64_sys_bpf */
	.byte 0x0c, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x62, 0x70, 0x66	/* W__pfx___ia32_sys_bpf */
	.byte 0x0b, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x62, 0x70, 0x66	/* W__ia32_sys_bpf */
	.byte 0x10, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xb1, 0xf5, 0x66, 0x61, 0x02, 0x74, 0x66, 0x64	/* W__pfx___x64_sys_userfaultfd */
	.byte 0x0f, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xb1, 0xf5, 0x66, 0x61, 0x02, 0x74, 0x66, 0x64	/* W__x64_sys_userfaultfd */
	.byte 0x11, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xb1, 0xf5, 0x66, 0x61, 0x02, 0x74, 0x66, 0x64	/* W__pfx___ia32_sys_userfaultfd */
	.byte 0x10, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xb1, 0xf5, 0x66, 0x61, 0x02, 0x74, 0x66, 0x64	/* W__ia32_sys_userfaultfd */
	.byte 0x10, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x63, 0xaa, 0xe7, 0xa5, 0x67, 0xde, 0xc8	/* W__pfx___x64_sys_pciconfig_read */
	.byte 0x0f, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x63, 0xaa, 0xe7, 0xa5, 0x67, 0xde, 0xc8	/* W__x64_sys_pciconfig_read */
	.byte 0x11, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x63, 0xaa, 0xe7, 0xa5, 0x67, 0xde, 0xc8	/* W__pfx___ia32_sys_pciconfig_read */
	.byte 0x10, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x63, 0xaa, 0xe7, 0xa5, 0x67, 0xde, 0xc8	/* W__ia32_sys_pciconfig_read */
	.byte 0x11, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x63, 0xaa, 0xe7, 0xa5, 0x67, 0x92, 0x3c, 0x65	/* W__pfx___x64_sys_pciconfig_write */
	.byte 0x10, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x63, 0xaa, 0xe7, 0xa5, 0x67, 0x92, 0x3c, 0x65	/* W__x64_sys_pciconfig_write */
	.byte 0x12, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x63, 0xaa, 0xe7, 0xa5, 0x67, 0x92, 0x3c, 0x65	/* W__pfx___ia32_sys_pciconfig_write */
	.byte 0x11, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x63, 0xaa, 0xe7, 0xa5, 0x67, 0x92, 0x3c, 0x65	/* W__ia32_sys_pciconfig_write */
	.byte 0x13, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x63, 0xaa, 0xe7, 0xa5, 0x67, 0x5f, 0xc0, 0x62, 0xbb, 0x65	/* W__pfx___x64_sys_pciconfig_iobase */
	.byte 0x12, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x63, 0xaa, 0xe7, 0xa5, 0x67, 0x5f, 0xc0, 0x62, 0xbb, 0x65	/* W__x64_sys_pciconfig_iobase */
	.byte 0x14, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x63, 0xaa, 0xe7, 0xa5, 0x67, 0x5f, 0xc0, 0x62, 0xbb, 0x65	/* W__pfx___ia32_sys_pciconfig_iobase */
	.byte 0x13, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x63, 0xaa, 0xe7, 0xa5, 0x67, 0x5f, 0xc0, 0x62, 0xbb, 0x65	/* W__ia32_sys_pciconfig_iobase */
	.byte 0x16, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x66, 0xd2, 0x6f, 0xdc, 0x66, 0x1d, 0xd9, 0x72, 0x6b	/* W__pfx___ia32_compat_sys_fanotify_mark */
	.byte 0x15, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0xe9, 0x66, 0xd2, 0x6f, 0xdc, 0x66, 0x1d, 0xd9, 0x72, 0x6b	/* W__ia32_compat_sys_fanotify_mark */
	.byte 0x0e, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x76, 0x6d, 0x38, 0x36, 0xa0, 0x64	/* W__pfx___x64_sys_vm86old */
	.byte 0x0d, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x76, 0x6d, 0x38, 0x36, 0xa0, 0x64	/* W__x64_sys_vm86old */
	.byte 0x0f, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x76, 0x6d, 0x38, 0x36, 0xa0, 0x64	/* W__pfx___ia32_sys_vm86old */
	.byte 0x0e, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x76, 0x6d, 0x38, 0x36, 0xa0, 0x64	/* W__ia32_sys_vm86old */
	.byte 0x0c, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x76, 0x6d, 0x38, 0x36	/* W__pfx___x64_sys_vm86 */
	.byte 0x0b, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x76, 0x6d, 0x38, 0x36	/* W__x64_sys_vm86 */
	.byte 0x0d, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x76, 0x6d, 0x38, 0x36	/* W__pfx___ia32_sys_vm86 */
	.byte 0x0c, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x76, 0x6d, 0x38, 0x36	/* W__ia32_sys_vm86 */
	.byte 0x10, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x6b, 0xcb, 0xb4, 0xe6, 0x69, 0xb0, 0xdd, 0xc8	/* W__pfx___x64_sys_kexec_file_load */
	.byte 0x0f, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x6b, 0xcb, 0xb4, 0xe6, 0x69, 0xb0, 0xdd, 0xc8	/* W__x64_sys_kexec_file_load */
	.byte 0x11, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x6b, 0xcb, 0xb4, 0xe6, 0x69, 0xb0, 0xdd, 0xc8	/* W__pfx___ia32_sys_kexec_file_load */
	.byte 0x10, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x6b, 0xcb, 0xb4, 0xe6, 0x69, 0xb0, 0xdd, 0xc8	/* W__ia32_sys_kexec_file_load */
	.byte 0x0f, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x97, 0xf6, 0x68, 0xc8, 0xad, 0xa9, 0xc6	/* W__pfx___x64_sys_map_shadow_stack */
	.byte 0x0e, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x97, 0xf6, 0x68, 0xc8, 0xad, 0xa9, 0xc6	/* W__x64_sys_map_shadow_stack */
	.byte 0x10, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x97, 0xf6, 0x68, 0xc8, 0xad, 0xa9, 0xc6	/* W__pfx___ia32_sys_map_shadow_stack */
	.byte 0x0f, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x97, 0xf6, 0x68, 0xc8, 0xad, 0xa9, 0xc6	/* W__ia32_sys_map_shadow_stack */
	.byte 0x13, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x33, 0x39, 0x30, 0xec, 0x9b, 0xc1, 0x6d, 0xc0, 0xde, 0xc8	/* W__pfx___x64_sys_s390_pci_mmio_read */
	.byte 0x12, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x33, 0x39, 0x30, 0xec, 0x9b, 0xc1, 0x6d, 0xc0, 0xde, 0xc8	/* W__x64_sys_s390_pci_mmio_read */
	.byte 0x14, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x33, 0x39, 0x30, 0xec, 0x9b, 0xc1, 0x6d, 0xc0, 0xde, 0xc8	/* W__pfx___ia32_sys_s390_pci_mmio_read */
	.byte 0x13, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x33, 0x39, 0x30, 0xec, 0x9b, 0xc1, 0x6d, 0xc0, 0xde, 0xc8	/* W__ia32_sys_s390_pci_mmio_read */
	.byte 0x14, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x33, 0x39, 0x30, 0xec, 0x9b, 0xc1, 0x6d, 0xc0, 0x92, 0x3c, 0x65	/* W__pfx___x64_sys_s390_pci_mmio_write */
	.byte 0x13, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x33, 0x39, 0x30, 0xec, 0x9b, 0xc1, 0x6d, 0xc0, 0x92, 0x3c, 0x65	/* W__x64_sys_s390_pci_mmio_write */
	.byte 0x15, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x33, 0x39, 0x30, 0xec, 0x9b, 0xc1, 0x6d, 0xc0, 0x92, 0x3c, 0x65	/* W__pfx___ia32_sys_s390_pci_mmio_write */
	.byte 0x14, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x33, 0x39, 0x30, 0xec, 0x9b, 0xc1, 0x6d, 0xc0, 0x92, 0x3c, 0x65	/* W__ia32_sys_s390_pci_mmio_write */
	.byte 0x0f, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x33, 0x39, 0x30, 0x5f, 0x28, 0x63	/* W__pfx___x64_sys_s390_ipc */
	.byte 0x0e, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x33, 0x39, 0x30, 0x5f, 0x28, 0x63	/* W__x64_sys_s390_ipc */
	.byte 0x10, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x33, 0x39, 0x30, 0x5f, 0x28, 0x63	/* W__pfx___ia32_sys_s390_ipc */
	.byte 0x0f, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x33, 0x39, 0x30, 0x5f, 0x28, 0x63	/* W__ia32_sys_s390_ipc */
	.byte 0x14, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0xf6, 0x33, 0x39, 0x30, 0x5f, 0x28, 0x63	/* W__pfx___ia32_compat_sys_s390_ipc */
	.byte 0x13, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x3a, 0xb6, 0x61, 0xfe, 0xe1, 0x73, 0xf6, 0x33, 0x39, 0x30, 0x5f, 0x28, 0x63	/* W__ia32_compat_sys_s390_ipc */
	.byte 0x0b, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x72, 0xf4, 0x73	/* W__pfx___x64_sys_rtas */
	.byte 0x0a, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x72, 0xf4, 0x73	/* W__x64_sys_rtas */
	.byte 0x0c, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x72, 0xf4, 0x73	/* W__pfx___ia32_sys_rtas */
	.byte 0x0b, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x72, 0xf4, 0x73	/* W__ia32_sys_rtas */
	.byte 0x0c, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x9c, 0xa6, 0xe4	/* W__pfx___x64_sys_spu_run */
	.byte 0x0b, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x9c, 0xa6, 0xe4	/* W__x64_sys_spu_run */
	.byte 0x0d, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x9c, 0xa6, 0xe4	/* W__pfx___ia32_sys_spu_run */
	.byte 0x0c, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x9c, 0xa6, 0xe4	/* W__ia32_sys_spu_run */
	.byte 0x0d, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x9c, 0xf0, 0xf7, 0x14	/* W__pfx___x64_sys_spu_create */
	.byte 0x0c, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x9c, 0xf0, 0xf7, 0x14	/* W__x64_sys_spu_create */
	.byte 0x0e, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x9c, 0xf0, 0xf7, 0x14	/* W__pfx___ia32_sys_spu_create */
	.byte 0x0d, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x9c, 0xf0, 0xf7, 0x14	/* W__ia32_sys_spu_create */
	.byte 0x10, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x88, 0x70, 0x83, 0xfc, 0x70, 0xe3, 0x74	/* W__pfx___x64_sys_subpage_prot */
	.byte 0x0f, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0x88, 0x70, 0x83, 0xfc, 0x70, 0xe3, 0x74	/* W__x64_sys_subpage_prot */
	.byte 0x11, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x88, 0x70, 0x83, 0xfc, 0x70, 0xe3, 0x74	/* W__pfx___ia32_sys_subpage_prot */
	.byte 0x10, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0x88, 0x70, 0x83, 0xfc, 0x70, 0xe3, 0x74	/* W__ia32_sys_subpage_prot */
	.byte 0x0c, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xb1, 0xdb, 0x69, 0x62	/* W__pfx___x64_sys_uselib */
	.byte 0x0b, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xb1, 0xdb, 0x69, 0x62	/* W__x64_sys_uselib */
	.byte 0x0d, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xb1, 0xdb, 0x69, 0x62	/* W__pfx___ia32_sys_uselib */
	.byte 0x0c, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xb1, 0xdb, 0x69, 0x62	/* W__ia32_sys_uselib */
	.byte 0x13, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x73, 0xdb, 0xb4, 0x74, 0x36, 0x5f, 0xdc, 0xa8, 0x33, 0x32	/* W__pfx___x64_sys_pselect6_time32 */
	.byte 0x12, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x73, 0xdb, 0xb4, 0x74, 0x36, 0x5f, 0xdc, 0xa8, 0x33, 0x32	/* W__x64_sys_pselect6_time32 */
	.byte 0x14, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x73, 0xdb, 0xb4, 0x74, 0x36, 0x5f, 0xdc, 0xa8, 0x33, 0x32	/* W__pfx___ia32_sys_pselect6_time32 */
	.byte 0x13, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x73, 0xdb, 0xb4, 0x74, 0x36, 0x5f, 0xdc, 0xa8, 0x33, 0x32	/* W__ia32_sys_pselect6_time32 */
	.byte 0x11, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x70, 0xa0, 0x6c, 0x5f, 0xdc, 0xa8, 0x33, 0x32	/* W__pfx___x64_sys_ppoll_time32 */
	.byte 0x10, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xec, 0x70, 0xa0, 0x6c, 0x5f, 0xdc, 0xa8, 0x33, 0x32	/* W__x64_sys_ppoll_time32 */
	.byte 0x12, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x70, 0xa0, 0x6c, 0x5f, 0xdc, 0xa8, 0x33, 0x32	/* W__pfx___ia32_sys_ppoll_time32 */
	.byte 0x11, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xec, 0x70, 0xa0, 0x6c, 0x5f, 0xdc, 0xa8, 0x33, 0x32	/* W__ia32_sys_ppoll_time32 */
	.byte 0x0a, 0x57, 0xaf, 0x5f, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x28, 0x63	/* W__pfx___x64_sys_ipc */
	.byte 0x09, 0x57, 0xff, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x28, 0x63	/* W__x64_sys_ipc */
	.byte 0x0b, 0x57, 0xaf, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x28, 0x63	/* W__pfx___ia32_sys_ipc */
	.byte 0x0a, 0x57, 0xff, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x28, 0x63	/* W__ia32_sys_ipc */
	.byte 0x0d, 0xef, 0x63, 0xf7, 0x91, 0x6e, 0x65, 0x77, 0xbd, 0x2a, 0xd6, 0x70, 0xf2, 0xd6	/* t__pfx_create_new_namespaces */
	.byte 0x0c, 0x26, 0xf7, 0x91, 0x6e, 0x65, 0x77, 0xbd, 0x2a, 0xd6, 0x70, 0xf2, 0xd6	/* tcreate_new_namespaces */
	.byte 0x0a, 0xeb, 0x63, 0xbe, 0x79, 0xbd, 0x2a, 0xd6, 0x70, 0xf2, 0xd6	/* T__pfx_copy_namespaces */
	.byte 0x0a, 0x54, 0x63, 0xbe, 0x79, 0xbd, 0x2a, 0xd6, 0x70, 0xf2, 0xd6	/* Tcopy_namespaces */
	.byte 0x0a, 0xeb, 0x66, 0xf7, 0xfc, 0x6e, 0x73, 0x70, 0xe3, 0x78, 0x79	/* T__pfx_free_nsproxy */
	.byte 0x0a, 0x54, 0x66, 0xf7, 0xfc, 0x6e, 0x73, 0x70, 0xe3, 0x78, 0x79	/* Tfree_nsproxy */
	.byte 0x07, 0xef, 0x9c, 0xfe, 0x6e, 0x73, 0x73, 0xd4	/* t__pfx_put_nsset */
	.byte 0x06, 0xce, 0x1e, 0x6e, 0x73, 0x73, 0xd4	/* tput_nsset */
	.byte 0x12, 0xeb, 0xe4, 0x73, 0x68, 0xc5, 0xfc, 0x6e, 0x73, 0x70, 0xe3, 0x78, 0x79, 0xbd, 0x2a, 0xd6, 0x70, 0xf2, 0xd6	/* T__pfx_unshare_nsproxy_namespaces */
	.byte 0x12, 0x54, 0xe4, 0x73, 0x68, 0xc5, 0xfc, 0x6e, 0x73, 0x70, 0xe3, 0x78, 0x79, 0xbd, 0x2a, 0xd6, 0x70, 0xf2, 0xd6	/* Tunshare_nsproxy_namespaces */
	.byte 0x0e, 0xeb, 0x73, 0x77, 0xea, 0xba, 0x5f, 0xf4, 0x5e, 0xbd, 0x2a, 0xd6, 0x70, 0xf2, 0xd6	/* T__pfx_switch_task_namespaces */
	.byte 0x0e, 0x54, 0x73, 0x77, 0xea, 0xba, 0x5f, 0xf4, 0x5e, 0xbd, 0x2a, 0xd6, 0x70, 0xf2, 0xd6	/* Tswitch_task_namespaces */
	.byte 0x0a, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0x73, 0xf6, 0xd4, 0x6e, 0x73	/* t__pfx___do_sys_setns */
	.byte 0x0a, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0x73, 0xf6, 0xd4, 0x6e, 0x73	/* t__do_sys_setns */
	.byte 0x0b, 0xeb, 0xcb, 0x9d, 0xf4, 0x5e, 0xbd, 0x2a, 0xd6, 0x70, 0xf2, 0xd6	/* T__pfx_exit_task_namespaces */
	.byte 0x0b, 0x54, 0xcb, 0x9d, 0xf4, 0x5e, 0xbd, 0x2a, 0xd6, 0x70, 0xf2, 0xd6	/* Texit_task_namespaces */
	.byte 0x0c, 0xeb, 0xcb, 0x65, 0xc9, 0xf4, 0x5e, 0xbd, 0x2a, 0xd6, 0x70, 0xf2, 0xd6	/* T__pfx_exec_task_namespaces */
	.byte 0x0c, 0x54, 0xcb, 0x65, 0xc9, 0xf4, 0x5e, 0xbd, 0x2a, 0xd6, 0x70, 0xf2, 0xd6	/* Texec_task_namespaces */
	.byte 0x0a, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x6e, 0x73	/* T__pfx___x64_sys_setns */
	.byte 0x0a, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x6e, 0x73	/* T__x64_sys_setns */
	.byte 0x0b, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x6e, 0x73	/* T__pfx___ia32_sys_setns */
	.byte 0x0b, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x6e, 0x73	/* T__ia32_sys_setns */
	.byte 0x09, 0x08, 0x18, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0xde, 0x0e	/* T__pfx___traceiter_notifier_register */
	.byte 0x09, 0xb9, 0x18, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0xde, 0x0e	/* T__traceiter_notifier_register */
	.byte 0x0a, 0x99, 0xec, 0x10, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0xde, 0x0e	/* T__pfx___probestub_notifier_register */
	.byte 0x0a, 0x54, 0xfd, 0x10, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0xde, 0x0e	/* T__probestub_notifier_register */
	.byte 0x0b, 0x08, 0x18, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0x5f, 0xe4, 0xf7, 0x0e	/* T__pfx___traceiter_notifier_unregister */
	.byte 0x0b, 0xb9, 0x18, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0x5f, 0xe4, 0xf7, 0x0e	/* T__traceiter_notifier_unregister */
	.byte 0x09, 0x08, 0x18, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0xa6, 0xe4	/* T__pfx___traceiter_notifier_run */
	.byte 0x09, 0xb9, 0x18, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0xa6, 0xe4	/* T__traceiter_notifier_run */
	.byte 0x0c, 0xef, 0x19, 0x3b, 0xc3, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0xbf, 0x66, 0x6f	/* t__pfx_perf_trace_notifier_info */
	.byte 0x0c, 0xce, 0xf5, 0x3b, 0xc3, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0xbf, 0x66, 0x6f	/* tperf_trace_notifier_info */
	.byte 0x0c, 0xef, 0x7d, 0x7b, 0xcc, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0xbf, 0x66, 0x6f	/* t__pfx_trace_event_raw_event_notifier_info */
	.byte 0x0c, 0x74, 0x7d, 0x7b, 0xcc, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0xbf, 0x66, 0x6f	/* ttrace_event_raw_event_notifier_info */
	.byte 0x0f, 0xef, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0xbf, 0x66, 0x6f	/* t__pfx_trace_raw_output_notifier_info */
	.byte 0x0f, 0x74, 0xc3, 0x7b, 0x6f, 0x75, 0xce, 0x1e, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0xbf, 0x66, 0x6f	/* ttrace_raw_output_notifier_info */
	.byte 0x0f, 0xeb, 0x73, 0x72, 0x63, 0x75, 0xbf, 0x9d, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0xa3, 0x65, 0xc8	/* T__pfx_srcu_init_notifier_head */
	.byte 0x0f, 0x54, 0x73, 0x72, 0x63, 0x75, 0xbf, 0x9d, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0xa3, 0x65, 0xc8	/* Tsrcu_init_notifier_head */
	.byte 0x0c, 0x99, 0xec, 0x10, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0x5f, 0xe4, 0xf7, 0x0e	/* T__pfx___probestub_notifier_unregister */
	.byte 0x0c, 0x54, 0xfd, 0x10, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0x5f, 0xe4, 0xf7, 0x0e	/* T__probestub_notifier_unregister */
	.byte 0x0b, 0xef, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0xde, 0x0e	/* t__pfx_notifier_chain_register */
	.byte 0x0b, 0x74, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0xde, 0x0e	/* tnotifier_chain_register */
	.byte 0x10, 0xeb, 0xe8, 0x6f, 0x6d, 0x69, 0xc9, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0xde, 0x0e	/* T__pfx_atomic_notifier_chain_register */
	.byte 0x10, 0x54, 0xe8, 0x6f, 0x6d, 0x69, 0xc9, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0xde, 0x0e	/* Tatomic_notifier_chain_register */
	.byte 0x18, 0xeb, 0xe8, 0x6f, 0x6d, 0x69, 0xc9, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0xde, 0x0e, 0x5f, 0xe4, 0x69, 0xa1, 0xfc, 0x70, 0x72, 0xc0	/* T__pfx_atomic_notifier_chain_register_unique_prio */
	.byte 0x18, 0x54, 0xe8, 0x6f, 0x6d, 0x69, 0xc9, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0xde, 0x0e, 0x5f, 0xe4, 0x69, 0xa1, 0xfc, 0x70, 0x72, 0xc0	/* Tatomic_notifier_chain_register_unique_prio */
	.byte 0x0d, 0xeb, 0xbc, 0x77, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0xde, 0x0e	/* T__pfx_raw_notifier_chain_register */
	.byte 0x0d, 0x54, 0xbc, 0x77, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0xde, 0x0e	/* Traw_notifier_chain_register */
	.byte 0x16, 0xeb, 0x62, 0xa4, 0x8d, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0xde, 0x0e, 0x5f, 0xe4, 0x69, 0xa1, 0xfc, 0x70, 0x72, 0xc0	/* T__pfx_blocking_notifier_chain_register_unique_prio */
	.byte 0x16, 0x54, 0x62, 0xa4, 0x8d, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0xde, 0x0e, 0x5f, 0xe4, 0x69, 0xa1, 0xfc, 0x70, 0x72, 0xc0	/* Tblocking_notifier_chain_register_unique_prio */
	.byte 0x0f, 0xeb, 0x73, 0x72, 0x63, 0x75, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0xde, 0x0e	/* T__pfx_srcu_notifier_chain_register */
	.byte 0x0f, 0x54, 0x73, 0x72, 0x63, 0x75, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0xde, 0x0e	/* Tsrcu_notifier_chain_register */
	.byte 0x0a, 0x99, 0xec, 0x10, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0xa6, 0xe4	/* T__pfx___probestub_notifier_run */
	.byte 0x0a, 0x54, 0xfd, 0x10, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0xa6, 0xe4	/* T__probestub_notifier_run */
	.byte 0x0e, 0xeb, 0x62, 0xa4, 0x8d, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0xde, 0x0e	/* T__pfx_blocking_notifier_chain_register */
	.byte 0x0e, 0x54, 0x62, 0xa4, 0x8d, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0xde, 0x0e	/* Tblocking_notifier_chain_register */
	.byte 0x0b, 0xeb, 0xf7, 0x0e, 0xed, 0x69, 0xfc, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5	/* T__pfx_register_die_notifier */
	.byte 0x0b, 0x54, 0xf7, 0x0e, 0xed, 0x69, 0xfc, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5	/* Tregister_die_notifier */
	.byte 0x0b, 0xef, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0xf0, 0x5d, 0x25, 0x61, 0xf8	/* t__pfx_notifier_call_chain */
	.byte 0x0b, 0x74, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0xf0, 0x5d, 0x25, 0x61, 0xf8	/* tnotifier_call_chain */
	.byte 0x12, 0xeb, 0x62, 0xa4, 0x8d, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0xf0, 0x5d, 0x25, 0x61, 0xf8, 0x5f, 0x8c, 0xb1, 0x74	/* T__pfx_blocking_notifier_call_chain_robust */
	.byte 0x12, 0x54, 0x62, 0xa4, 0x8d, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0xf0, 0x5d, 0x25, 0x61, 0xf8, 0x5f, 0x8c, 0xb1, 0x74	/* Tblocking_notifier_call_chain_robust */
	.byte 0x0d, 0xeb, 0xbc, 0x77, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0xf0, 0x5d, 0x25, 0x61, 0xf8	/* T__pfx_raw_notifier_call_chain */
	.byte 0x0d, 0x54, 0xbc, 0x77, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0xf0, 0x5d, 0x25, 0x61, 0xf8	/* Traw_notifier_call_chain */
	.byte 0x10, 0xeb, 0xe8, 0x6f, 0x6d, 0x69, 0xc9, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0xf0, 0x5d, 0x25, 0x61, 0xf8	/* T__pfx_atomic_notifier_call_chain */
	.byte 0x10, 0x54, 0xe8, 0x6f, 0x6d, 0x69, 0xc9, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0xf0, 0x5d, 0x25, 0x61, 0xf8	/* Tatomic_notifier_call_chain */
	.byte 0x0e, 0xeb, 0x62, 0xa4, 0x8d, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0xf0, 0x5d, 0x25, 0x61, 0xf8	/* T__pfx_blocking_notifier_call_chain */
	.byte 0x0e, 0x54, 0x62, 0xa4, 0x8d, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0xf0, 0x5d, 0x25, 0x61, 0xf8	/* Tblocking_notifier_call_chain */
	.byte 0x0f, 0xeb, 0x73, 0x72, 0x63, 0x75, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0xf0, 0x5d, 0x25, 0x61, 0xf8	/* T__pfx_srcu_notifier_call_chain */
	.byte 0x0f, 0x54, 0x73, 0x72, 0x63, 0x75, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0xf0, 0x5d, 0x25, 0x61, 0xf8	/* Tsrcu_notifier_call_chain */
	.byte 0x09, 0xeb, 0x6e, 0x6f, 0xdc, 0x66, 0x79, 0xed, 0x69, 0x65	/* T__pfx_notify_die */
	.byte 0x09, 0x54, 0x6e, 0x6f, 0xdc, 0x66, 0x79, 0xed, 0x69, 0x65	/* Tnotify_die */
	.byte 0x11, 0xeb, 0xbc, 0x77, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0xf0, 0x5d, 0x25, 0x61, 0xf8, 0x5f, 0x8c, 0xb1, 0x74	/* T__pfx_raw_notifier_call_chain_robust */
	.byte 0x11, 0x54, 0xbc, 0x77, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0xf0, 0x5d, 0x25, 0x61, 0xf8, 0x5f, 0x8c, 0xb1, 0x74	/* Traw_notifier_call_chain_robust */
	.byte 0x0d, 0xef, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0x5f, 0xe4, 0xf7, 0x0e	/* t__pfx_notifier_chain_unregister */
	.byte 0x0d, 0x74, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0x5f, 0xe4, 0xf7, 0x0e	/* tnotifier_chain_unregister */
	.byte 0x0f, 0xeb, 0xbc, 0x77, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0x5f, 0xe4, 0xf7, 0x0e	/* T__pfx_raw_notifier_chain_unregister */
	.byte 0x0f, 0x54, 0xbc, 0x77, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0x5f, 0xe4, 0xf7, 0x0e	/* Traw_notifier_chain_unregister */
	.byte 0x12, 0xeb, 0xe8, 0x6f, 0x6d, 0x69, 0xc9, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0x5f, 0xe4, 0xf7, 0x0e	/* T__pfx_atomic_notifier_chain_unregister */
	.byte 0x12, 0x54, 0xe8, 0x6f, 0x6d, 0x69, 0xc9, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0x5f, 0xe4, 0xf7, 0x0e	/* Tatomic_notifier_chain_unregister */
	.byte 0x10, 0xeb, 0x62, 0xa4, 0x8d, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0x5f, 0xe4, 0xf7, 0x0e	/* T__pfx_blocking_notifier_chain_unregister */
	.byte 0x10, 0x54, 0x62, 0xa4, 0x8d, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0x5f, 0xe4, 0xf7, 0x0e	/* Tblocking_notifier_chain_unregister */
	.byte 0x11, 0xeb, 0x73, 0x72, 0x63, 0x75, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0x5f, 0xe4, 0xf7, 0x0e	/* T__pfx_srcu_notifier_chain_unregister */
	.byte 0x11, 0x54, 0x73, 0x72, 0x63, 0x75, 0xbd, 0x6f, 0xdc, 0xa5, 0xf5, 0x25, 0x61, 0xf8, 0x5f, 0xe4, 0xf7, 0x0e	/* Tsrcu_notifier_chain_unregister */
	.byte 0x0c, 0xeb, 0xe4, 0xf7, 0x0e, 0xed, 0x69, 0xfc, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5	/* T__pfx_unregister_die_notifier */
	.byte 0x0c, 0x54, 0xe4, 0xf7, 0x0e, 0xed, 0x69, 0xfc, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5	/* Tunregister_die_notifier */
	.byte 0x17, 0xeb, 0xe8, 0x6f, 0x6d, 0x69, 0xc9, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0xf0, 0x5d, 0x25, 0x61, 0xf8, 0x5f, 0x69, 0xe9, 0x65, 0xb6, 0x74, 0x79	/* T__pfx_atomic_notifier_call_chain_is_empty */
	.byte 0x17, 0x54, 0xe8, 0x6f, 0x6d, 0x69, 0xc9, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5, 0xf0, 0x5d, 0x25, 0x61, 0xf8, 0x5f, 0x69, 0xe9, 0x65, 0xb6, 0x74, 0x79	/* Tatomic_notifier_call_chain_is_empty */
	.byte 0x07, 0xef, 0x6e, 0x6f, 0x2c, 0xe9, 0xf7, 0xc8	/* t__pfx_notes_read */
	.byte 0x07, 0x74, 0x6e, 0x6f, 0x2c, 0xe9, 0xf7, 0xc8	/* tnotes_read */
	.byte 0x0b, 0xef, 0x72, 0x63, 0x75, 0xbd, 0xd5, 0x6d, 0xe5, 0xf6, 0x8a, 0xf7	/* t__pfx_rcu_normal_store */
	.byte 0x0a, 0xf3, 0x63, 0x75, 0xbd, 0xd5, 0x6d, 0xe5, 0xf6, 0x8a, 0xf7	/* trcu_normal_store */
	.byte 0x0d, 0xef, 0x72, 0x63, 0x75, 0x5f, 0xcb, 0x70, 0x9e, 0xea, 0x9e, 0xf6, 0x8a, 0xf7	/* t__pfx_rcu_expedited_store */
	.byte 0x0c, 0xf3, 0x63, 0x75, 0x5f, 0xcb, 0x70, 0x9e, 0xea, 0x9e, 0xf6, 0x8a, 0xf7	/* trcu_expedited_store */
	.byte 0x0a, 0xef, 0x72, 0x63, 0x75, 0xbd, 0xd5, 0x6d, 0xe5, 0xf6, 0x7c	/* t__pfx_rcu_normal_show */
	.byte 0x09, 0xf3, 0x63, 0x75, 0xbd, 0xd5, 0x6d, 0xe5, 0xf6, 0x7c	/* trcu_normal_show */
	.byte 0x0c, 0xef, 0x72, 0x63, 0x75, 0x5f, 0xcb, 0x70, 0x9e, 0xea, 0x9e, 0xf6, 0x7c	/* t__pfx_rcu_expedited_show */
	.byte 0x0b, 0xf3, 0x63, 0x75, 0x5f, 0xcb, 0x70, 0x9e, 0xea, 0x9e, 0xf6, 0x7c	/* trcu_expedited_show */
	.byte 0x0a, 0xef, 0x6b, 0xcb, 0x65, 0xc9, 0xdd, 0xc8, 0x9e, 0xf6, 0x7c	/* t__pfx_kexec_loaded_show */
	.byte 0x0a, 0x74, 0x6b, 0xcb, 0x65, 0xc9, 0xdd, 0xc8, 0x9e, 0xf6, 0x7c	/* tkexec_loaded_show */
	.byte 0x08, 0xef, 0x70, 0xe3, 0xa5, 0x6c, 0x8d, 0xf6, 0x7c	/* t__pfx_profiling_show */
	.byte 0x07, 0xce, 0xe3, 0xa5, 0x6c, 0x8d, 0xf6, 0x7c	/* tprofiling_show */
	.byte 0x0a, 0xef, 0xc8, 0x64, 0x29, 0xe9, 0x62, 0xea, 0x73, 0xf6, 0x7c	/* t__pfx_address_bits_show */
	.byte 0x0a, 0xf4, 0x64, 0x64, 0x29, 0xe9, 0x62, 0xea, 0x73, 0xf6, 0x7c	/* taddress_bits_show */
	.byte 0x0b, 0xef, 0x63, 0x9c, 0xb8, 0x79, 0x2c, 0xd5, 0x64, 0xf5, 0xf6, 0x7c	/* t__pfx_cpu_byteorder_show */
	.byte 0x0a, 0x26, 0x9c, 0xb8, 0x79, 0x2c, 0xd5, 0x64, 0xf5, 0xf6, 0x7c	/* tcpu_byteorder_show */
	.byte 0x0b, 0xef, 0x75, 0xcc, 0x73, 0x65, 0x71, 0x6e, 0x75, 0x6d, 0xf6, 0x7c	/* t__pfx_uevent_seqnum_show */
	.byte 0x0b, 0x74, 0x75, 0xcc, 0x73, 0x65, 0x71, 0x6e, 0x75, 0x6d, 0xf6, 0x7c	/* tuevent_seqnum_show */
	.byte 0x08, 0xef, 0x95, 0x63, 0x61, 0x70, 0x73, 0xf6, 0x7c	/* t__pfx_fscaps_show */
	.byte 0x08, 0x74, 0x95, 0x63, 0x61, 0x70, 0x73, 0xf6, 0x7c	/* tfscaps_show */
	.byte 0x12, 0xef, 0x63, 0xbc, 0x73, 0x68, 0x5f, 0xdb, 0x66, 0x03, 0xf7, 0x68, 0xac, 0xf6, 0x69, 0x7a, 0xfc, 0x73, 0x7c	/* t__pfx_crash_elfcorehdr_size_show */
	.byte 0x11, 0x26, 0xbc, 0x73, 0x68, 0x5f, 0xdb, 0x66, 0x03, 0xf7, 0x68, 0xac, 0xf6, 0x69, 0x7a, 0xfc, 0x73, 0x7c	/* tcrash_elfcorehdr_size_show */
	.byte 0x0a, 0xef, 0x76, 0x6d, 0x03, 0xf7, 0xf8, 0x66, 0x6f, 0xf6, 0x7c	/* t__pfx_vmcoreinfo_show */
	.byte 0x0a, 0x74, 0x76, 0x6d, 0x03, 0xf7, 0xf8, 0x66, 0x6f, 0xf6, 0x7c	/* tvmcoreinfo_show */
	.byte 0x0f, 0xef, 0x6b, 0xcb, 0xb4, 0xf0, 0xbc, 0x73, 0x68, 0xf6, 0x69, 0x7a, 0xfc, 0x73, 0x8a, 0xf7	/* t__pfx_kexec_crash_size_store */
	.byte 0x0f, 0x74, 0x6b, 0xcb, 0xb4, 0xf0, 0xbc, 0x73, 0x68, 0xf6, 0x69, 0x7a, 0xfc, 0x73, 0x8a, 0xf7	/* tkexec_crash_size_store */
	.byte 0x0e, 0xef, 0x6b, 0xcb, 0xb4, 0xf0, 0xbc, 0x73, 0x68, 0xf6, 0x69, 0x7a, 0xfc, 0x73, 0x7c	/* t__pfx_kexec_crash_size_show */
	.byte 0x0e, 0x74, 0x6b, 0xcb, 0xb4, 0xf0, 0xbc, 0x73, 0x68, 0xf6, 0x69, 0x7a, 0xfc, 0x73, 0x7c	/* tkexec_crash_size_show */
	.byte 0x0e, 0xef, 0x6b, 0xcb, 0xb4, 0xf0, 0xbc, 0x73, 0x68, 0x5f, 0xdd, 0xc8, 0x9e, 0xf6, 0x7c	/* t__pfx_kexec_crash_loaded_show */
	.byte 0x0e, 0x74, 0x6b, 0xcb, 0xb4, 0xf0, 0xbc, 0x73, 0x68, 0x5f, 0xdd, 0xc8, 0x9e, 0xf6, 0x7c	/* tkexec_crash_loaded_show */
	.byte 0x09, 0xef, 0x70, 0xe3, 0xa5, 0x6c, 0x8d, 0xf6, 0x8a, 0xf7	/* t__pfx_profiling_store */
	.byte 0x08, 0xce, 0xe3, 0xa5, 0x6c, 0x8d, 0xf6, 0x8a, 0xf7	/* tprofiling_store */
	.byte 0x0a, 0xeb, 0x6f, 0x0b, 0x72, 0x9f, 0xfc, 0x63, 0xf7, 0x64, 0x73	/* T__pfx_override_creds */
	.byte 0x0a, 0x54, 0x6f, 0x0b, 0x72, 0x9f, 0xfc, 0x63, 0xf7, 0x64, 0x73	/* Toverride_creds */
	.byte 0x08, 0xeb, 0x63, 0xf7, 0x64, 0xe6, 0x73, 0x63, 0xb6	/* T__pfx_cred_fscmp */
	.byte 0x08, 0x54, 0x63, 0xf7, 0x64, 0xe6, 0x73, 0x63, 0xb6	/* Tcred_fscmp */
	.byte 0x0d, 0xeb, 0x73, 0xe2, 0x73, 0xb4, 0x98, 0xea, 0x1d, 0x6f, 0x0b, 0x72, 0x9f, 0x65	/* T__pfx_set_security_override */
	.byte 0x0d, 0x54, 0x73, 0xe2, 0x73, 0xb4, 0x98, 0xea, 0x1d, 0x6f, 0x0b, 0x72, 0x9f, 0x65	/* Tset_security_override */
	.byte 0x13, 0xeb, 0x73, 0xe2, 0x73, 0xb4, 0x98, 0xea, 0x1d, 0x6f, 0x0b, 0x72, 0x9f, 0xfc, 0x66, 0xe3, 0x6d, 0xf0, 0x74, 0x78	/* T__pfx_set_security_override_from_ctx */
	.byte 0x13, 0x54, 0x73, 0xe2, 0x73, 0xb4, 0x98, 0xea, 0x1d, 0x6f, 0x0b, 0x72, 0x9f, 0xfc, 0x66, 0xe3, 0x6d, 0xf0, 0x74, 0x78	/* Tset_security_override_from_ctx */
	.byte 0x0a, 0xeb, 0x73, 0xe2, 0x63, 0xf7, 0x91, 0xa5, 0xc4, 0xe9, 0xbb	/* T__pfx_set_create_files_as */
	.byte 0x0a, 0x54, 0x73, 0xe2, 0x63, 0xf7, 0x91, 0xa5, 0xc4, 0xe9, 0xbb	/* Tset_create_files_as */
	.byte 0x08, 0xeb, 0x67, 0xe2, 0xf4, 0x5e, 0xf0, 0xf7, 0x64	/* T__pfx_get_task_cred */
	.byte 0x08, 0x54, 0x67, 0xe2, 0xf4, 0x5e, 0xf0, 0xf7, 0x64	/* Tget_task_cred */
	.byte 0x09, 0xef, 0x9c, 0xfe, 0x63, 0xf7, 0xda, 0x72, 0x63, 0x75	/* t__pfx_put_cred_rcu */
	.byte 0x08, 0xce, 0x1e, 0x63, 0xf7, 0xda, 0x72, 0x63, 0x75	/* tput_cred_rcu */
	.byte 0x06, 0x99, 0xec, 0x1e, 0x63, 0xf7, 0x64	/* T__pfx___put_cred */
	.byte 0x06, 0x54, 0xfd, 0x1e, 0x63, 0xf7, 0x64	/* T__put_cred */
	.byte 0x08, 0xeb, 0xf7, 0x0b, 0xfe, 0x63, 0xf7, 0x64, 0x73	/* T__pfx_revert_creds */
	.byte 0x08, 0x54, 0xf7, 0x0b, 0xfe, 0x63, 0xf7, 0x64, 0x73	/* Trevert_creds */
	.byte 0x08, 0xeb, 0x90, 0xd5, 0xfe, 0x63, 0xf7, 0x64, 0x73	/* T__pfx_abort_creds */
	.byte 0x08, 0x54, 0x90, 0xd5, 0xfe, 0x63, 0xf7, 0x64, 0x73	/* Tabort_creds */
	.byte 0x09, 0xeb, 0x03, 0x6d, 0x6d, 0x9d, 0x63, 0xf7, 0x64, 0x73	/* T__pfx_commit_creds */
	.byte 0x09, 0x54, 0x03, 0x6d, 0x6d, 0x9d, 0x63, 0xf7, 0x64, 0x73	/* Tcommit_creds */
	.byte 0x0d, 0xeb, 0x70, 0xf7, 0x70, 0xc5, 0xfc, 0x6b, 0xf5, 0x6e, 0xdb, 0xf0, 0xf7, 0x64	/* T__pfx_prepare_kernel_cred */
	.byte 0x0d, 0x54, 0x70, 0xf7, 0x70, 0xc5, 0xfc, 0x6b, 0xf5, 0x6e, 0xdb, 0xf0, 0xf7, 0x64	/* Tprepare_kernel_cred */
	.byte 0x0a, 0xeb, 0x70, 0xf7, 0x70, 0xc5, 0xfc, 0x63, 0xf7, 0x64, 0x73	/* T__pfx_prepare_creds */
	.byte 0x0a, 0x54, 0x70, 0xf7, 0x70, 0xc5, 0xfc, 0x63, 0xf7, 0x64, 0x73	/* Tprepare_creds */
	.byte 0x07, 0xeb, 0xcb, 0x9d, 0x63, 0xf7, 0x64, 0x73	/* T__pfx_exit_creds */
	.byte 0x07, 0x54, 0xcb, 0x9d, 0x63, 0xf7, 0x64, 0x73	/* Texit_creds */
	.byte 0x0a, 0xeb, 0x63, 0xf7, 0xda, 0x22, 0xc9, 0x62, 0x6c, 0xd2, 0x6b	/* T__pfx_cred_alloc_blank */
	.byte 0x0a, 0x54, 0x63, 0xf7, 0xda, 0x22, 0xc9, 0x62, 0x6c, 0xd2, 0x6b	/* Tcred_alloc_blank */
	.byte 0x0c, 0xeb, 0x70, 0xf7, 0x70, 0xc5, 0xfc, 0xcb, 0xb4, 0xf0, 0xf7, 0x64, 0x73	/* T__pfx_prepare_exec_creds */
	.byte 0x0c, 0x54, 0x70, 0xf7, 0x70, 0xc5, 0xfc, 0xcb, 0xb4, 0xf0, 0xf7, 0x64, 0x73	/* Tprepare_exec_creds */
	.byte 0x08, 0xeb, 0x63, 0xbe, 0x79, 0xf0, 0xf7, 0x64, 0x73	/* T__pfx_copy_creds */
	.byte 0x08, 0x54, 0x63, 0xbe, 0x79, 0xf0, 0xf7, 0x64, 0x73	/* Tcopy_creds */
	.byte 0x0a, 0xeb, 0x73, 0xe2, 0x63, 0xf7, 0xda, 0x75, 0x03, 0xe4, 0x93	/* T__pfx_set_cred_ucounts */
	.byte 0x0a, 0x54, 0x73, 0xe2, 0x63, 0xf7, 0xda, 0x75, 0x03, 0xe4, 0x93	/* Tset_cred_ucounts */
	.byte 0x0b, 0xef, 0xe1, 0xe9, 0x6f, 0x66, 0x66, 0xbd, 0x6f, 0xdc, 0x66, 0x79	/* t__pfx_sys_off_notify */
	.byte 0x0b, 0x74, 0xe1, 0xe9, 0x6f, 0x66, 0x66, 0xbd, 0x6f, 0xdc, 0x66, 0x79	/* tsys_off_notify */
	.byte 0x13, 0xef, 0x70, 0x6c, 0xe8, 0x66, 0xd5, 0x6d, 0xec, 0xad, 0xf5, 0x5f, 0x6f, 0x66, 0x66, 0xbd, 0x6f, 0xdc, 0x66, 0x79	/* t__pfx_platform_power_off_notify */
	.byte 0x12, 0xce, 0x6c, 0xe8, 0x66, 0xd5, 0x6d, 0xec, 0xad, 0xf5, 0x5f, 0x6f, 0x66, 0x66, 0xbd, 0x6f, 0xdc, 0x66, 0x79	/* tplatform_power_off_notify */
	.byte 0x0e, 0xef, 0xc4, 0x67, 0xf2, 0x79, 0xec, 0x6d, 0xec, 0xad, 0xf5, 0x5f, 0x6f, 0x66, 0x66	/* t__pfx_legacy_pm_power_off */
	.byte 0x0e, 0x74, 0xc4, 0x67, 0xf2, 0x79, 0xec, 0x6d, 0xec, 0xad, 0xf5, 0x5f, 0x6f, 0x66, 0x66	/* tlegacy_pm_power_off */
	.byte 0x0c, 0xeb, 0x65, 0x6d, 0xf5, 0x67, 0xf1, 0x63, 0x79, 0xde, 0x3d, 0x72, 0x74	/* T__pfx_emergency_restart */
	.byte 0x0c, 0x54, 0x65, 0x6d, 0xf5, 0x67, 0xf1, 0x63, 0x79, 0xde, 0x3d, 0x72, 0x74	/* Temergency_restart */
	.byte 0x0d, 0xeb, 0xf7, 0x0e, 0xde, 0x62, 0x6f, 0x6f, 0xfe, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5	/* T__pfx_register_reboot_notifier */
	.byte 0x0d, 0x54, 0xf7, 0x0e, 0xde, 0x62, 0x6f, 0x6f, 0xfe, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5	/* Tregister_reboot_notifier */
	.byte 0x0e, 0xeb, 0xe4, 0xf7, 0x0e, 0xde, 0x62, 0x6f, 0x6f, 0xfe, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5	/* T__pfx_unregister_reboot_notifier */
	.byte 0x0e, 0x54, 0xe4, 0xf7, 0x0e, 0xde, 0x62, 0x6f, 0x6f, 0xfe, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5	/* Tunregister_reboot_notifier */
	.byte 0x0f, 0xeb, 0xb5, 0x6d, 0xde, 0x0e, 0xde, 0x62, 0x6f, 0x6f, 0xfe, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5	/* T__pfx_devm_register_reboot_notifier */
	.byte 0x0f, 0x54, 0xb5, 0x6d, 0xde, 0x0e, 0xde, 0x62, 0x6f, 0x6f, 0xfe, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5	/* Tdevm_register_reboot_notifier */
	.byte 0x0b, 0xeb, 0xf7, 0x0e, 0xde, 0x3d, 0x72, 0xfe, 0x68, 0x05, 0x6c, 0xf5	/* T__pfx_register_restart_handler */
	.byte 0x0b, 0x54, 0xf7, 0x0e, 0xde, 0x3d, 0x72, 0xfe, 0x68, 0x05, 0x6c, 0xf5	/* Tregister_restart_handler */
	.byte 0x0c, 0xeb, 0xe4, 0xf7, 0x0e, 0xde, 0x3d, 0x72, 0xfe, 0x68, 0x05, 0x6c, 0xf5	/* T__pfx_unregister_restart_handler */
	.byte 0x0c, 0x54, 0xe4, 0xf7, 0x0e, 0xde, 0x3d, 0x72, 0xfe, 0x68, 0x05, 0x6c, 0xf5	/* Tunregister_restart_handler */
	.byte 0x0e, 0xeb, 0x6b, 0xf5, 0x6e, 0xdb, 0xf0, 0xd2, 0xec, 0xad, 0xf5, 0x5f, 0x6f, 0x66, 0x66	/* T__pfx_kernel_can_power_off */
	.byte 0x0e, 0x54, 0x6b, 0xf5, 0x6e, 0xdb, 0xf0, 0xd2, 0xec, 0xad, 0xf5, 0x5f, 0x6f, 0x66, 0x66	/* Tkernel_can_power_off */
	.byte 0x07, 0xef, 0x74, 0x21, 0xfc, 0x73, 0x8a, 0xf7	/* t__pfx_type_store */
	.byte 0x07, 0x74, 0x74, 0x21, 0xfc, 0x73, 0x8a, 0xf7	/* ttype_store */
	.byte 0x06, 0xef, 0x6d, 0x16, 0x73, 0x8a, 0xf7	/* t__pfx_mode_store */
	.byte 0x06, 0x74, 0x6d, 0x16, 0x73, 0x8a, 0xf7	/* tmode_store */
	.byte 0x06, 0xef, 0x63, 0x9c, 0xf6, 0x8a, 0xf7	/* t__pfx_cpu_store */
	.byte 0x05, 0x26, 0x9c, 0xf6, 0x8a, 0xf7	/* tcpu_store */
	.byte 0x05, 0xef, 0x63, 0x9c, 0xf6, 0x7c	/* t__pfx_cpu_show */
	.byte 0x04, 0x26, 0x9c, 0xf6, 0x7c	/* tcpu_show */
	.byte 0x06, 0xef, 0x74, 0x21, 0xfc, 0x73, 0x7c	/* t__pfx_type_show */
	.byte 0x06, 0x74, 0x74, 0x21, 0xfc, 0x73, 0x7c	/* ttype_show */
	.byte 0x07, 0xef, 0x66, 0xd5, 0x63, 0xfc, 0x73, 0x7c	/* t__pfx_force_show */
	.byte 0x07, 0x74, 0x66, 0xd5, 0x63, 0xfc, 0x73, 0x7c	/* tforce_show */
	.byte 0x05, 0xef, 0x6d, 0x16, 0x73, 0x7c	/* t__pfx_mode_show */
	.byte 0x05, 0x74, 0x6d, 0x16, 0x73, 0x7c	/* tmode_show */
	.byte 0x08, 0xef, 0x66, 0xd5, 0x63, 0xfc, 0x73, 0x8a, 0xf7	/* t__pfx_force_store */
	.byte 0x08, 0x74, 0x66, 0xd5, 0x63, 0xfc, 0x73, 0x8a, 0xf7	/* tforce_store */
	.byte 0x10, 0xef, 0xb5, 0xae, 0xe4, 0xf7, 0x0e, 0xde, 0x62, 0x6f, 0x6f, 0xfe, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5	/* t__pfx_devm_unregister_reboot_notifier */
	.byte 0x10, 0x74, 0xb5, 0xae, 0xe4, 0xf7, 0x0e, 0xde, 0x62, 0x6f, 0x6f, 0xfe, 0x6e, 0x6f, 0xdc, 0xa5, 0xf5	/* tdevm_unregister_reboot_notifier */
	.byte 0x0d, 0xeb, 0xe4, 0xf7, 0x0e, 0x7f, 0xe9, 0x6f, 0x66, 0x66, 0xa3, 0x05, 0x6c, 0xf5	/* T__pfx_unregister_sys_off_handler */
	.byte 0x0d, 0x54, 0xe4, 0xf7, 0x0e, 0x7f, 0xe9, 0x6f, 0x66, 0x66, 0xa3, 0x05, 0x6c, 0xf5	/* Tunregister_sys_off_handler */
	.byte 0x0f, 0xef, 0xb5, 0xae, 0xe4, 0xf7, 0x0e, 0x7f, 0xe9, 0x6f, 0x66, 0x66, 0xa3, 0x05, 0x6c, 0xf5	/* t__pfx_devm_unregister_sys_off_handler */
	.byte 0x0f, 0x74, 0xb5, 0xae, 0xe4, 0xf7, 0x0e, 0x7f, 0xe9, 0x6f, 0x66, 0x66, 0xa3, 0x05, 0x6c, 0xf5	/* tdevm_unregister_sys_off_handler */
	.byte 0x11, 0xeb, 0xe4, 0xf7, 0x0e, 0xec, 0x6c, 0xe8, 0x66, 0xd5, 0x6d, 0xec, 0xad, 0xf5, 0x5f, 0x6f, 0x66, 0x66	/* T__pfx_unregister_platform_power_off */
	.byte 0x11, 0x54, 0xe4, 0xf7, 0x0e, 0xec, 0x6c, 0xe8, 0x66, 0xd5, 0x6d, 0xec, 0xad, 0xf5, 0x5f, 0x6f, 0x66, 0x66	/* Tunregister_platform_power_off */
	.byte 0x0b, 0xeb, 0xd5, 0x64, 0xf5, 0x6c, 0x79, 0xde, 0x62, 0x6f, 0x6f, 0x74	/* T__pfx_orderly_reboot */
	.byte 0x0b, 0x54, 0xd5, 0x64, 0xf5, 0x6c, 0x79, 0xde, 0x62, 0x6f, 0x6f, 0x74	/* Torderly_reboot */
	.byte 0x0c, 0xeb, 0xd5, 0x64, 0xf5, 0x6c, 0x79, 0xec, 0xad, 0xf5, 0x6f, 0x66, 0x66	/* T__pfx_orderly_poweroff */
	.byte 0x0c, 0x54, 0xd5, 0x64, 0xf5, 0x6c, 0x79, 0xec, 0xad, 0xf5, 0x6f, 0x66, 0x66	/* Torderly_poweroff */
	.byte 0x0c, 0xeb, 0xf7, 0x0e, 0x7f, 0xe9, 0x6f, 0x66, 0x66, 0xa3, 0x05, 0x6c, 0xf5	/* T__pfx_register_sys_off_handler */
	.byte 0x0c, 0x54, 0xf7, 0x0e, 0x7f, 0xe9, 0x6f, 0x66, 0x66, 0xa3, 0x05, 0x6c, 0xf5	/* Tregister_sys_off_handler */
	.byte 0x0e, 0xeb, 0xb5, 0x6d, 0xde, 0x0e, 0x7f, 0xe9, 0x6f, 0x66, 0x66, 0xa3, 0x05, 0x6c, 0xf5	/* T__pfx_devm_register_sys_off_handler */
	.byte 0x0e, 0x54, 0xb5, 0x6d, 0xde, 0x0e, 0x7f, 0xe9, 0x6f, 0x66, 0x66, 0xa3, 0x05, 0x6c, 0xf5	/* Tdevm_register_sys_off_handler */
	.byte 0x0f, 0x99, 0xa3, 0x77, 0xec, 0xe3, 0x74, 0xb4, 0xdc, 0xe7, 0xf6, 0x68, 0x20, 0x64, 0xad, 0x6e	/* T__pfx___hw_protection_shutdown */
	.byte 0x0f, 0xb9, 0x68, 0x77, 0xec, 0xe3, 0x74, 0xb4, 0xdc, 0xe7, 0xf6, 0x68, 0x20, 0x64, 0xad, 0x6e	/* T__hw_protection_shutdown */
	.byte 0x0d, 0xeb, 0xb5, 0x6d, 0xde, 0x0e, 0xde, 0x3d, 0x72, 0xfe, 0x68, 0x05, 0x6c, 0xf5	/* T__pfx_devm_register_restart_handler */
	.byte 0x0d, 0x54, 0xb5, 0x6d, 0xde, 0x0e, 0xde, 0x3d, 0x72, 0xfe, 0x68, 0x05, 0x6c, 0xf5	/* Tdevm_register_restart_handler */
	.byte 0x10, 0xeb, 0xb5, 0x6d, 0xde, 0x0e, 0xec, 0xad, 0xf5, 0x5f, 0x6f, 0x66, 0x66, 0xa3, 0x05, 0x6c, 0xf5	/* T__pfx_devm_register_power_off_handler */
	.byte 0x10, 0x54, 0xb5, 0x6d, 0xde, 0x0e, 0xec, 0xad, 0xf5, 0x5f, 0x6f, 0x66, 0x66, 0xa3, 0x05, 0x6c, 0xf5	/* Tdevm_register_power_off_handler */
	.byte 0x10, 0xeb, 0xf7, 0x0e, 0xec, 0x6c, 0xe8, 0x66, 0xd5, 0x6d, 0xec, 0xad, 0xf5, 0x5f, 0x6f, 0x66, 0x66	/* T__pfx_register_platform_power_off */
	.byte 0x10, 0x54, 0xf7, 0x0e, 0xec, 0x6c, 0xe8, 0x66, 0xd5, 0x6d, 0xec, 0xad, 0xf5, 0x5f, 0x6f, 0x66, 0x66	/* Tregister_platform_power_off */
	.byte 0x0e, 0xeb, 0x6b, 0xf5, 0x6e, 0xdb, 0xde, 0x3d, 0x72, 0xfe, 0x70, 0xf7, 0x70, 0x61, 0xf7	/* T__pfx_kernel_restart_prepare */
	.byte 0x0e, 0x54, 0x6b, 0xf5, 0x6e, 0xdb, 0xde, 0x3d, 0x72, 0xfe, 0x70, 0xf7, 0x70, 0x61, 0xf7	/* Tkernel_restart_prepare */
	.byte 0x0c, 0xeb, 0x64, 0x6f, 0x5f, 0x6b, 0xf5, 0x6e, 0xdb, 0xde, 0x3d, 0x72, 0x74	/* T__pfx_do_kernel_restart */
	.byte 0x0c, 0x54, 0x64, 0x6f, 0x5f, 0x6b, 0xf5, 0x6e, 0xdb, 0xde, 0x3d, 0x72, 0x74	/* Tdo_kernel_restart */
	.byte 0x0d, 0xeb, 0x6d, 0x0c, 0x72, 0x91, 0x8a, 0xde, 0x62, 0x6f, 0x6f, 0xfe, 0x63, 0x9c	/* T__pfx_migrate_to_reboot_cpu */
	.byte 0x0d, 0x54, 0x6d, 0x0c, 0x72, 0x91, 0x8a, 0xde, 0x62, 0x6f, 0x6f, 0xfe, 0x63, 0x9c	/* Tmigrate_to_reboot_cpu */
	.byte 0x09, 0xeb, 0x6b, 0xf5, 0x6e, 0xdb, 0xde, 0x3d, 0x72, 0x74	/* T__pfx_kernel_restart */
	.byte 0x09, 0x54, 0x6b, 0xf5, 0x6e, 0xdb, 0xde, 0x3d, 0x72, 0x74	/* Tkernel_restart */
	.byte 0x09, 0xef, 0x64, 0x65, 0x66, 0xf5, 0xf7, 0x64, 0xf0, 0xc8	/* t__pfx_deferred_cad */
	.byte 0x09, 0x74, 0x64, 0x65, 0x66, 0xf5, 0xf7, 0x64, 0xf0, 0xc8	/* tdeferred_cad */
	.byte 0x0b, 0xef, 0xf7, 0x62, 0x6f, 0x6f, 0xfe, 0x77, 0xd5, 0x6b, 0xe6, 0x96	/* t__pfx_reboot_work_func */
	.byte 0x0b, 0x74, 0xf7, 0x62, 0x6f, 0x6f, 0xfe, 0x77, 0xd5, 0x6b, 0xe6, 0x96	/* treboot_work_func */
	.byte 0x08, 0xeb, 0x6b, 0xf5, 0x6e, 0xdb, 0xa3, 0xe5, 0x74	/* T__pfx_kernel_halt */
	.byte 0x08, 0x54, 0x6b, 0xf5, 0x6e, 0xdb, 0xa3, 0xe5, 0x74	/* Tkernel_halt */
	.byte 0x0c, 0xeb, 0x6b, 0xf5, 0x6e, 0xdb, 0xec, 0xad, 0xf5, 0x5f, 0x6f, 0x66, 0x66	/* T__pfx_kernel_power_off */
	.byte 0x0c, 0x54, 0x6b, 0xf5, 0x6e, 0xdb, 0xec, 0xad, 0xf5, 0x5f, 0x6f, 0x66, 0x66	/* Tkernel_power_off */
	.byte 0x0b, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0xe9, 0xf7, 0x62, 0x6f, 0x6f, 0x74	/* t__pfx___do_sys_reboot */
	.byte 0x0b, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0xe9, 0xf7, 0x62, 0x6f, 0x6f, 0x74	/* t__do_sys_reboot */
	.byte 0x18, 0xef, 0x68, 0x77, 0xe6, 0x61, 0x69, 0x6c, 0x98, 0xfc, 0x65, 0x6d, 0xf5, 0x67, 0xf1, 0x63, 0x79, 0xec, 0xad, 0xf5, 0x6f, 0x66, 0x66, 0xe6, 0x96	/* t__pfx_hw_failure_emergency_poweroff_func */
	.byte 0x18, 0x74, 0x68, 0x77, 0xe6, 0x61, 0x69, 0x6c, 0x98, 0xfc, 0x65, 0x6d, 0xf5, 0x67, 0xf1, 0x63, 0x79, 0xec, 0xad, 0xf5, 0x6f, 0x66, 0x66, 0xe6, 0x96	/* thw_failure_emergency_poweroff_func */
	.byte 0x0c, 0xef, 0x70, 0xad, 0xf5, 0x6f, 0x66, 0x66, 0x92, 0xd5, 0x6b, 0xe6, 0x96	/* t__pfx_poweroff_work_func */
	.byte 0x0b, 0xce, 0xad, 0xf5, 0x6f, 0x66, 0x66, 0x92, 0xd5, 0x6b, 0xe6, 0x96	/* tpoweroff_work_func */
	.byte 0x0f, 0xeb, 0x64, 0x6f, 0x5f, 0x6b, 0xf5, 0x6e, 0xdb, 0xec, 0xad, 0xf5, 0x5f, 0x6f, 0x66, 0x66	/* T__pfx_do_kernel_power_off */
	.byte 0x0f, 0x54, 0x64, 0x6f, 0x5f, 0x6b, 0xf5, 0x6e, 0xdb, 0xec, 0xad, 0xf5, 0x5f, 0x6f, 0x66, 0x66	/* Tdo_kernel_power_off */
	.byte 0x0b, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xf7, 0x62, 0x6f, 0x6f, 0x74	/* T__pfx___x64_sys_reboot */
	.byte 0x0b, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0xf7, 0x62, 0x6f, 0x6f, 0x74	/* T__x64_sys_reboot */
	.byte 0x0c, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xf7, 0x62, 0x6f, 0x6f, 0x74	/* T__pfx___ia32_sys_reboot */
	.byte 0x0c, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0xf7, 0x62, 0x6f, 0x6f, 0x74	/* T__ia32_sys_reboot */
	.byte 0x09, 0xeb, 0x63, 0xf3, 0x6c, 0x5f, 0xe5, 0xfe, 0x64, 0xdb	/* T__pfx_ctrl_alt_del */
	.byte 0x09, 0x54, 0x63, 0xf3, 0x6c, 0x5f, 0xe5, 0xfe, 0x64, 0xdb	/* Tctrl_alt_del */
	.byte 0x0b, 0xef, 0xdd, 0x77, 0xd6, 0xfe, 0xf8, 0xec, 0xe3, 0x67, 0x29, 0x73	/* t__pfx_lowest_in_progress */
	.byte 0x0b, 0x74, 0xdd, 0x77, 0xd6, 0xfe, 0xf8, 0xec, 0xe3, 0x67, 0x29, 0x73	/* tlowest_in_progress */
	.byte 0x12, 0x74, 0xaf, 0x5f, 0x61, 0xe1, 0x6e, 0x63, 0xf6, 0xba, 0x9e, 0x75, 0xb0, 0x6e, 0x16, 0x64, 0x6f, 0xd9, 0xf8	/* t__pfx___async_schedule_node_domain */
	.byte 0x11, 0x74, 0xff, 0x61, 0xe1, 0x6e, 0x63, 0xf6, 0xba, 0x9e, 0x75, 0xb0, 0x6e, 0x16, 0x64, 0x6f, 0xd9, 0xf8	/* t__async_schedule_node_domain */
	.byte 0x0c, 0xef, 0x61, 0xe1, 0x6e, 0xc9, 0x72, 0xe4, 0x0d, 0xf3, 0x79, 0xe6, 0x6e	/* t__pfx_async_run_entry_fn */
	.byte 0x0b, 0xf4, 0xe1, 0x6e, 0xc9, 0x72, 0xe4, 0x0d, 0xf3, 0x79, 0xe6, 0x6e	/* tasync_run_entry_fn */
	.byte 0x0c, 0xeb, 0x63, 0x98, 0xf7, 0x6e, 0xfe, 0x69, 0xe9, 0x61, 0xe1, 0x6e, 0x63	/* T__pfx_current_is_async */
	.byte 0x0c, 0x54, 0x63, 0x98, 0xf7, 0x6e, 0xfe, 0x69, 0xe9, 0x61, 0xe1, 0x6e, 0x63	/* Tcurrent_is_async */
	.byte 0x16, 0xeb, 0x61, 0xe1, 0x6e, 0x63, 0x7f, 0x6e, 0xba, 0x72, 0xe7, 0x69, 0x7a, 0xfc, 0x03, 0x6f, 0x6b, 0x69, 0xfc, 0x64, 0x6f, 0xd9, 0xf8	/* T__pfx_async_synchronize_cookie_domain */
	.byte 0x16, 0x54, 0x61, 0xe1, 0x6e, 0x63, 0x7f, 0x6e, 0xba, 0x72, 0xe7, 0x69, 0x7a, 0xfc, 0x03, 0x6f, 0x6b, 0x69, 0xfc, 0x64, 0x6f, 0xd9, 0xf8	/* Tasync_synchronize_cookie_domain */
	.byte 0x10, 0xeb, 0x61, 0xe1, 0x6e, 0x63, 0xf6, 0xba, 0x9e, 0x75, 0xb0, 0x6e, 0x16, 0x64, 0x6f, 0xd9, 0xf8	/* T__pfx_async_schedule_node_domain */
	.byte 0x10, 0x54, 0x61, 0xe1, 0x6e, 0x63, 0xf6, 0xba, 0x9e, 0x75, 0xb0, 0x6e, 0x16, 0x64, 0x6f, 0xd9, 0xf8	/* Tasync_schedule_node_domain */
	.byte 0x0d, 0xeb, 0x61, 0xe1, 0x6e, 0x63, 0xf6, 0xba, 0x9e, 0x75, 0xb0, 0x6e, 0xb7, 0x65	/* T__pfx_async_schedule_node */
	.byte 0x0d, 0x54, 0x61, 0xe1, 0x6e, 0x63, 0xf6, 0xba, 0x9e, 0x75, 0xb0, 0x6e, 0xb7, 0x65	/* Tasync_schedule_node */
	.byte 0x10, 0xeb, 0x61, 0xe1, 0x6e, 0x63, 0x7f, 0x6e, 0xba, 0x72, 0xe7, 0x69, 0x7a, 0xfc, 0x66, 0x02, 0x6c	/* T__pfx_async_synchronize_full */
	.byte 0x10, 0x54, 0x61, 0xe1, 0x6e, 0x63, 0x7f, 0x6e, 0xba, 0x72, 0xe7, 0x69, 0x7a, 0xfc, 0x66, 0x02, 0x6c	/* Tasync_synchronize_full */
	.byte 0x14, 0xeb, 0x61, 0xe1, 0x6e, 0x63, 0x7f, 0x6e, 0xba, 0x72, 0xe7, 0x69, 0x7a, 0xfc, 0x66, 0x02, 0x6c, 0xed, 0x6f, 0xd9, 0xf8	/* T__pfx_async_synchronize_full_domain */
	.byte 0x14, 0x54, 0x61, 0xe1, 0x6e, 0x63, 0x7f, 0x6e, 0xba, 0x72, 0xe7, 0x69, 0x7a, 0xfc, 0x66, 0x02, 0x6c, 0xed, 0x6f, 0xd9, 0xf8	/* Tasync_synchronize_full_domain */
	.byte 0x12, 0xeb, 0x61, 0xe1, 0x6e, 0x63, 0x7f, 0x6e, 0xba, 0x72, 0xe7, 0x69, 0x7a, 0xfc, 0x03, 0x6f, 0x6b, 0x69, 0x65	/* T__pfx_async_synchronize_cookie */
	.byte 0x12, 0x54, 0x61, 0xe1, 0x6e, 0x63, 0x7f, 0x6e, 0xba, 0x72, 0xe7, 0x69, 0x7a, 0xfc, 0x03, 0x6f, 0x6b, 0x69, 0x65	/* Tasync_synchronize_cookie */
	.byte 0x0f, 0xeb, 0x61, 0xe1, 0x6e, 0x63, 0xf6, 0xba, 0x9e, 0x75, 0xb0, 0xb5, 0xbd, 0x6f, 0x63, 0x5d	/* T__pfx_async_schedule_dev_nocall */
	.byte 0x0f, 0x54, 0x61, 0xe1, 0x6e, 0x63, 0xf6, 0xba, 0x9e, 0x75, 0xb0, 0xb5, 0xbd, 0x6f, 0x63, 0x5d	/* Tasync_schedule_dev_nocall */
	.byte 0x07, 0xef, 0x63, 0xb6, 0xa6, 0xd2, 0x67, 0x65	/* t__pfx_cmp_range */
	.byte 0x06, 0x26, 0xb6, 0xa6, 0xd2, 0x67, 0x65	/* tcmp_range */
	.byte 0x07, 0xeb, 0xc8, 0xda, 0x72, 0xd2, 0x67, 0x65	/* T__pfx_add_range */
	.byte 0x07, 0x54, 0xc8, 0xda, 0x72, 0xd2, 0x67, 0x65	/* Tadd_range */
	.byte 0x0e, 0xeb, 0xc8, 0xda, 0x72, 0xd2, 0x67, 0xfc, 0x77, 0xea, 0x68, 0xc1, 0xf5, 0x67, 0x65	/* T__pfx_add_range_with_merge */
	.byte 0x0e, 0x54, 0xc8, 0xda, 0x72, 0xd2, 0x67, 0xfc, 0x77, 0xea, 0x68, 0xc1, 0xf5, 0x67, 0x65	/* Tadd_range_with_merge */
	.byte 0x09, 0xeb, 0x73, 0x88, 0xdf, 0xfe, 0x72, 0xd2, 0x67, 0x65	/* T__pfx_subtract_range */
	.byte 0x09, 0x54, 0x73, 0x88, 0xdf, 0xfe, 0x72, 0xd2, 0x67, 0x65	/* Tsubtract_range */
	.byte 0x0b, 0xeb, 0x63, 0xc4, 0xd2, 0xf6, 0xd5, 0xfe, 0x72, 0xd2, 0x67, 0x65	/* T__pfx_clean_sort_range */
	.byte 0x0b, 0x54, 0x63, 0xc4, 0xd2, 0xf6, 0xd5, 0xfe, 0x72, 0xd2, 0x67, 0x65	/* Tclean_sort_range */
	.byte 0x08, 0xeb, 0x73, 0xd5, 0xfe, 0x72, 0xd2, 0x67, 0x65	/* T__pfx_sort_range */
	.byte 0x08, 0x54, 0x73, 0xd5, 0xfe, 0x72, 0xd2, 0x67, 0x65	/* Tsort_range */
	.byte 0x0d, 0xef, 0x73, 0xb6, 0x62, 0x6f, 0x6f, 0xfe, 0x74, 0x68, 0xf7, 0xc8, 0xe6, 0x6e	/* t__pfx_smpboot_thread_fn */
	.byte 0x0c, 0x93, 0xb6, 0x62, 0x6f, 0x6f, 0xfe, 0x74, 0x68, 0xf7, 0xc8, 0xe6, 0x6e	/* tsmpboot_thread_fn */
	.byte 0x11, 0xef, 0x73, 0xb6, 0x62, 0x6f, 0x6f, 0xfe, 0x64, 0xd6, 0xf3, 0x6f, 0x79, 0xa7, 0x68, 0xf7, 0xc8, 0x73	/* t__pfx_smpboot_destroy_threads */
	.byte 0x10, 0x93, 0xb6, 0x62, 0x6f, 0x6f, 0xfe, 0x64, 0xd6, 0xf3, 0x6f, 0x79, 0xa7, 0x68, 0xf7, 0xc8, 0x73	/* tsmpboot_destroy_threads */
	.byte 0x12, 0xeb, 0x73, 0xb6, 0x62, 0x6f, 0x6f, 0xfe, 0xe4, 0xf7, 0x0e, 0xec, 0xf5, 0x63, 0x9c, 0xa7, 0x68, 0xf7, 0xc8	/* T__pfx_smpboot_unregister_percpu_thread */
	.byte 0x12, 0x54, 0x73, 0xb6, 0x62, 0x6f, 0x6f, 0xfe, 0xe4, 0xf7, 0x0e, 0xec, 0xf5, 0x63, 0x9c, 0xa7, 0x68, 0xf7, 0xc8	/* Tsmpboot_unregister_percpu_thread */
	.byte 0x0f, 0x74, 0xaf, 0xf6, 0xb6, 0x62, 0x6f, 0x6f, 0xfe, 0x63, 0xf7, 0x91, 0x74, 0x68, 0xf7, 0xc8	/* t__pfx___smpboot_create_thread */
	.byte 0x0f, 0x74, 0xff, 0x73, 0xb6, 0x62, 0x6f, 0x6f, 0xfe, 0x63, 0xf7, 0x91, 0x74, 0x68, 0xf7, 0xc8	/* t__smpboot_create_thread */
	.byte 0x11, 0xeb, 0x73, 0xb6, 0x62, 0x6f, 0x6f, 0xfe, 0xf7, 0x0e, 0xec, 0xf5, 0x63, 0x9c, 0xa7, 0x68, 0xf7, 0xc8	/* T__pfx_smpboot_register_percpu_thread */
	.byte 0x11, 0x54, 0x73, 0xb6, 0x62, 0x6f, 0x6f, 0xfe, 0xf7, 0x0e, 0xec, 0xf5, 0x63, 0x9c, 0xa7, 0x68, 0xf7, 0xc8	/* Tsmpboot_register_percpu_thread */
	.byte 0x0a, 0xeb, 0x9f, 0xb0, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x67, 0xd4	/* T__pfx_idle_thread_get */
	.byte 0x0a, 0x54, 0x9f, 0xb0, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x67, 0xd4	/* Tidle_thread_get */
	.byte 0x0f, 0xeb, 0x73, 0xb6, 0x62, 0x6f, 0x6f, 0xfe, 0x63, 0xf7, 0x91, 0x74, 0x68, 0xf7, 0xc8, 0x73	/* T__pfx_smpboot_create_threads */
	.byte 0x0f, 0x54, 0x73, 0xb6, 0x62, 0x6f, 0x6f, 0xfe, 0x63, 0xf7, 0x91, 0x74, 0x68, 0xf7, 0xc8, 0x73	/* Tsmpboot_create_threads */
	.byte 0x10, 0xeb, 0x73, 0xb6, 0x62, 0x6f, 0x6f, 0xfe, 0xe4, 0x70, 0xc5, 0x6b, 0xa7, 0x68, 0xf7, 0xc8, 0x73	/* T__pfx_smpboot_unpark_threads */
	.byte 0x10, 0x54, 0x73, 0xb6, 0x62, 0x6f, 0x6f, 0xfe, 0xe4, 0x70, 0xc5, 0x6b, 0xa7, 0x68, 0xf7, 0xc8, 0x73	/* Tsmpboot_unpark_threads */
	.byte 0x0f, 0xeb, 0x73, 0xb6, 0x62, 0x6f, 0x6f, 0xfe, 0x70, 0xc5, 0x6b, 0xa7, 0x68, 0xf7, 0xc8, 0x73	/* T__pfx_smpboot_park_threads */
	.byte 0x0f, 0x54, 0x73, 0xb6, 0x62, 0x6f, 0x6f, 0xfe, 0x70, 0xc5, 0x6b, 0xa7, 0x68, 0xf7, 0xc8, 0x73	/* Tsmpboot_park_threads */
	.byte 0x07, 0xef, 0x73, 0xe2, 0xdd, 0x6f, 0x6b, 0xcd	/* t__pfx_set_lookup */
	.byte 0x06, 0x93, 0xe2, 0xdd, 0x6f, 0x6b, 0xcd	/* tset_lookup */
	.byte 0x07, 0xef, 0x73, 0xe2, 0xca, 0xf6, 0x65, 0xf1	/* t__pfx_set_is_seen */
	.byte 0x06, 0x93, 0xe2, 0xca, 0xf6, 0x65, 0xf1	/* tset_is_seen */
	.byte 0x09, 0xef, 0x73, 0xe2, 0x19, 0x6d, 0xca, 0x85, 0xe7, 0x73	/* t__pfx_set_permissions */
	.byte 0x08, 0x93, 0xe2, 0x19, 0x6d, 0xca, 0x85, 0xe7, 0x73	/* tset_permissions */
	.byte 0x0e, 0xeb, 0x73, 0xd4, 0xcd, 0x5f, 0xb1, 0xf5, 0x6e, 0x73, 0x7f, 0x73, 0x63, 0x23, 0x73	/* T__pfx_setup_userns_sysctls */
	.byte 0x0e, 0x54, 0x73, 0xd4, 0xcd, 0x5f, 0xb1, 0xf5, 0x6e, 0x73, 0x7f, 0x73, 0x63, 0x23, 0x73	/* Tsetup_userns_sysctls */
	.byte 0x0e, 0xeb, 0xf7, 0xdc, 0x72, 0xfc, 0xb1, 0xf5, 0x6e, 0x73, 0x7f, 0x73, 0x63, 0x23, 0x73	/* T__pfx_retire_userns_sysctls */
	.byte 0x0e, 0x54, 0xf7, 0xdc, 0x72, 0xfc, 0xb1, 0xf5, 0x6e, 0x73, 0x7f, 0x73, 0x63, 0x23, 0x73	/* Tretire_userns_sysctls */
	.byte 0x07, 0xeb, 0x9c, 0xfe, 0x75, 0x03, 0xe4, 0x93	/* T__pfx_put_ucounts */
	.byte 0x07, 0x54, 0x9c, 0xfe, 0x75, 0x03, 0xe4, 0x93	/* Tput_ucounts */
	.byte 0x07, 0xeb, 0x67, 0xe2, 0x75, 0x03, 0xe4, 0x93	/* T__pfx_get_ucounts */
	.byte 0x07, 0x54, 0x67, 0xe2, 0x75, 0x03, 0xe4, 0x93	/* Tget_ucounts */
	.byte 0x07, 0xeb, 0x22, 0xc9, 0x75, 0x03, 0xe4, 0x93	/* T__pfx_alloc_ucounts */
	.byte 0x07, 0x54, 0x22, 0xc9, 0x75, 0x03, 0xe4, 0x93	/* Talloc_ucounts */
	.byte 0x11, 0xef, 0x64, 0x6f, 0xed, 0x65, 0xc9, 0x72, 0x6c, 0x69, 0x6d, 0x9d, 0x9c, 0xfe, 0x75, 0x03, 0xe4, 0x93	/* t__pfx_do_dec_rlimit_put_ucounts */
	.byte 0x11, 0x74, 0x64, 0x6f, 0xed, 0x65, 0xc9, 0x72, 0x6c, 0x69, 0x6d, 0x9d, 0x9c, 0xfe, 0x75, 0x03, 0xe4, 0x93	/* tdo_dec_rlimit_put_ucounts */
	.byte 0x07, 0xeb, 0xf8, 0xc9, 0x75, 0x03, 0xe4, 0x74	/* T__pfx_inc_ucount */
	.byte 0x07, 0x54, 0xf8, 0xc9, 0x75, 0x03, 0xe4, 0x74	/* Tinc_ucount */
	.byte 0x08, 0xeb, 0x64, 0x65, 0xc9, 0x75, 0x03, 0xe4, 0x74	/* T__pfx_dec_ucount */
	.byte 0x08, 0x54, 0x64, 0x65, 0xc9, 0x75, 0x03, 0xe4, 0x74	/* Tdec_ucount */
	.byte 0x0c, 0xeb, 0xf8, 0xc9, 0x72, 0x6c, 0x69, 0x6d, 0x9d, 0x75, 0x03, 0xe4, 0x93	/* T__pfx_inc_rlimit_ucounts */
	.byte 0x0c, 0x54, 0xf8, 0xc9, 0x72, 0x6c, 0x69, 0x6d, 0x9d, 0x75, 0x03, 0xe4, 0x93	/* Tinc_rlimit_ucounts */
	.byte 0x0d, 0xeb, 0x64, 0x65, 0xc9, 0x72, 0x6c, 0x69, 0x6d, 0x9d, 0x75, 0x03, 0xe4, 0x93	/* T__pfx_dec_rlimit_ucounts */
	.byte 0x0d, 0x54, 0x64, 0x65, 0xc9, 0x72, 0x6c, 0x69, 0x6d, 0x9d, 0x75, 0x03, 0xe4, 0x93	/* Tdec_rlimit_ucounts */
	.byte 0x0f, 0xeb, 0x64, 0x65, 0xc9, 0x72, 0x6c, 0x69, 0x6d, 0x9d, 0x9c, 0xfe, 0x75, 0x03, 0xe4, 0x93	/* T__pfx_dec_rlimit_put_ucounts */
	.byte 0x0f, 0x54, 0x64, 0x65, 0xc9, 0x72, 0x6c, 0x69, 0x6d, 0x9d, 0x9c, 0xfe, 0x75, 0x03, 0xe4, 0x93	/* Tdec_rlimit_put_ucounts */
	.byte 0x0e, 0xeb, 0xf8, 0xc9, 0x72, 0x6c, 0x69, 0x6d, 0x9d, 0x67, 0xe2, 0x75, 0x03, 0xe4, 0x93	/* T__pfx_inc_rlimit_get_ucounts */
	.byte 0x0e, 0x54, 0xf8, 0xc9, 0x72, 0x6c, 0x69, 0x6d, 0x9d, 0x67, 0xe2, 0x75, 0x03, 0xe4, 0x93	/* Tinc_rlimit_get_ucounts */
	.byte 0x0e, 0xeb, 0x69, 0xe9, 0x72, 0x6c, 0x69, 0x6d, 0x9d, 0x6f, 0x0b, 0x6c, 0x69, 0x6d, 0xea	/* T__pfx_is_rlimit_overlimit */
	.byte 0x0e, 0x54, 0x69, 0xe9, 0x72, 0x6c, 0x69, 0x6d, 0x9d, 0x6f, 0x0b, 0x6c, 0x69, 0x6d, 0xea	/* Tis_rlimit_overlimit */
	.byte 0x09, 0xeb, 0xf7, 0x67, 0x73, 0xe2, 0x67, 0xe2, 0x22, 0x63	/* T__pfx_regset_get_alloc */
	.byte 0x09, 0x54, 0xf7, 0x67, 0x73, 0xe2, 0x67, 0xe2, 0x22, 0x63	/* Tregset_get_alloc */
	.byte 0x07, 0xeb, 0xf7, 0x67, 0x73, 0xe2, 0x67, 0xd4	/* T__pfx_regset_get */
	.byte 0x07, 0x54, 0xf7, 0x67, 0x73, 0xe2, 0x67, 0xd4	/* Tregset_get */
	.byte 0x0c, 0xeb, 0x63, 0xbe, 0x79, 0xde, 0x67, 0x73, 0xe2, 0x8a, 0x5f, 0xb1, 0xf5	/* T__pfx_copy_regset_to_user */
	.byte 0x0c, 0x54, 0x63, 0xbe, 0x79, 0xde, 0x67, 0x73, 0xe2, 0x8a, 0x5f, 0xb1, 0xf5	/* Tcopy_regset_to_user */
	.byte 0x0c, 0xeb, 0x6b, 0x5d, 0xd3, 0x73, 0xf6, 0x7c, 0x5f, 0x76, 0xe5, 0x75, 0x65	/* T__pfx_kallsyms_show_value */
	.byte 0x0c, 0x54, 0x6b, 0x5d, 0xd3, 0x73, 0xf6, 0x7c, 0x5f, 0x76, 0xe5, 0x75, 0x65	/* Tkallsyms_show_value */
	.byte 0x05, 0xef, 0x67, 0x9f, 0xf0, 0xb6	/* t__pfx_gid_cmp */
	.byte 0x05, 0x74, 0x67, 0x9f, 0xf0, 0xb6	/* tgid_cmp */
	.byte 0x07, 0xeb, 0x67, 0xe3, 0xcd, 0xe9, 0x22, 0x63	/* T__pfx_groups_alloc */
	.byte 0x07, 0x54, 0x67, 0xe3, 0xcd, 0xe9, 0x22, 0x63	/* Tgroups_alloc */
	.byte 0x08, 0xeb, 0x67, 0xe3, 0xcd, 0xe9, 0x66, 0xf7, 0x65	/* T__pfx_groups_free */
	.byte 0x08, 0x54, 0x67, 0xe3, 0xcd, 0xe9, 0x66, 0xf7, 0x65	/* Tgroups_free */
	.byte 0x08, 0xeb, 0x67, 0xe3, 0xcd, 0x73, 0xf6, 0xd5, 0x74	/* T__pfx_groups_sort */
	.byte 0x08, 0x54, 0x67, 0xe3, 0xcd, 0x73, 0xf6, 0xd5, 0x74	/* Tgroups_sort */
	.byte 0x08, 0xeb, 0xf8, 0x5f, 0x65, 0x67, 0xe3, 0xcd, 0xec	/* T__pfx_in_egroup_p */
	.byte 0x08, 0x54, 0xf8, 0x5f, 0x65, 0x67, 0xe3, 0xcd, 0xec	/* Tin_egroup_p */
	.byte 0x06, 0xeb, 0xf8, 0xc7, 0xe3, 0xcd, 0xec	/* T__pfx_in_group_p */
	.byte 0x06, 0x54, 0xf8, 0xc7, 0xe3, 0xcd, 0xec	/* Tin_group_p */
	.byte 0x07, 0xeb, 0x73, 0xe2, 0x67, 0xe3, 0xcd, 0x73	/* T__pfx_set_groups */
	.byte 0x07, 0x54, 0x73, 0xe2, 0x67, 0xe3, 0xcd, 0x73	/* Tset_groups */
	.byte 0x0c, 0xeb, 0x73, 0xe2, 0x63, 0x98, 0xf7, 0x6e, 0xfe, 0x67, 0xe3, 0xcd, 0x73	/* T__pfx_set_current_groups */
	.byte 0x0c, 0x54, 0x73, 0xe2, 0x63, 0x98, 0xf7, 0x6e, 0xfe, 0x67, 0xe3, 0xcd, 0x73	/* Tset_current_groups */
	.byte 0x0c, 0x74, 0xaf, 0xed, 0x6f, 0x7f, 0x73, 0xf6, 0xd4, 0x67, 0xe3, 0xcd, 0x73	/* t__pfx___do_sys_setgroups */
	.byte 0x0c, 0x74, 0xff, 0x64, 0x6f, 0x7f, 0x73, 0xf6, 0xd4, 0x67, 0xe3, 0xcd, 0x73	/* t__do_sys_setgroups */
	.byte 0x09, 0xeb, 0x67, 0xe3, 0xcd, 0x73, 0xf6, 0x65, 0xc5, 0xba	/* T__pfx_groups_search */
	.byte 0x09, 0x54, 0x67, 0xe3, 0xcd, 0x73, 0xf6, 0x65, 0xc5, 0xba	/* Tgroups_search */
	.byte 0x0c, 0x08, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x67, 0xe3, 0xcd, 0x73	/* T__pfx___x64_sys_getgroups */
	.byte 0x0c, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0xe9, 0x67, 0xd4, 0x67, 0xe3, 0xcd, 0x73	/* T__x64_sys_getgroups */
	.byte 0x0d, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x67, 0xe3, 0xcd, 0x73	/* T__pfx___ia32_sys_getgroups */
	.byte 0x0d, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0xe9, 0x67, 0xd4, 0x67, 0xe3, 0xcd, 0x73	/* T__ia32_sys_getgroups */
	.byte 0x09, 0xeb, 0xd9, 0x79, 0xf6, 0xd4, 0x67, 0xe3, 0xcd, 0x73	/* T__pfx_may_setgroups */
	.byte 0x09, 0x54, 0xd9, 0x79, 0xf6, 0xd4, 0x67, 0xe3, 0xcd, 0x73	/* Tmay_setgroups */
	.byte 0x0c, 0x08, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x67, 0xe3, 0xcd, 0x73	/* T__pfx___x64_sys_setgroups */
	.byte 0x0c, 0xb9, 0x78, 0x36, 0x34, 0x7f, 0x73, 0xf6, 0xd4, 0x67, 0xe3, 0xcd, 0x73	/* T__x64_sys_setgroups */
	.byte 0x0d, 0x08, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x67, 0xe3, 0xcd, 0x73	/* T__pfx___ia32_sys_setgroups */
	.byte 0x0d, 0xb9, 0x69, 0x61, 0x33, 0x32, 0x7f, 0x73, 0xf6, 0xd4, 0x67, 0xe3, 0xcd, 0x73	/* T__ia32_sys_setgroups */
	.byte 0x0e, 0x08, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf6, 0x74, 0xbe	/* T__pfx___traceiter_sched_kthread_stop */
	.byte 0x0e, 0xb9, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf6, 0x74, 0xbe	/* T__traceiter_sched_kthread_stop */
	.byte 0x0f, 0x99, 0xec, 0x10, 0xf6, 0xba, 0x65, 0xda, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf6, 0x74, 0xbe	/* T__pfx___probestub_sched_kthread_stop */
	.byte 0x0f, 0x54, 0xfd, 0x10, 0xf6, 0xba, 0x65, 0xda, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf6, 0x74, 0xbe	/* T__probestub_sched_kthread_stop */
	.byte 0x10, 0x08, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf6, 0x74, 0xbe, 0xde, 0x74	/* T__pfx___traceiter_sched_kthread_stop_ret */
	.byte 0x10, 0xb9, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf6, 0x74, 0xbe, 0xde, 0x74	/* T__traceiter_sched_kthread_stop_ret */
	.byte 0x11, 0x99, 0xec, 0x10, 0xf6, 0xba, 0x65, 0xda, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf6, 0x74, 0xbe, 0xde, 0x74	/* T__pfx___probestub_sched_kthread_stop_ret */
	.byte 0x11, 0x54, 0xfd, 0x10, 0xf6, 0xba, 0x65, 0xda, 0x6b, 0x74, 0x68, 0xf7, 0xc8, 0xf6, 0x74, 0xbe, 0xde, 0x74	/* T__probestub_sched_kthread_stop_ret */
	.byte 0x17, 0x08, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x77, 0xd5, 0x6b, 0x5f, 0xa1, 0x65, 0x75, 0xfc, 0x77, 0xd5, 0x6b	/* T__pfx___traceiter_sched_kthread_work_queue_work */
	.byte 0x17, 0xb9, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x77, 0xd5, 0x6b, 0x5f, 0xa1, 0x65, 0x75, 0xfc, 0x77, 0xd5, 0x6b	/* T__traceiter_sched_kthread_work_queue_work */
	.byte 0x18, 0x99, 0xec, 0x10, 0xf6, 0xba, 0x65, 0xda, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x77, 0xd5, 0x6b, 0x5f, 0xa1, 0x65, 0x75, 0xfc, 0x77, 0xd5, 0x6b	/* T__pfx___probestub_sched_kthread_work_queue_work */
	.byte 0x18, 0x54, 0xfd, 0x10, 0xf6, 0xba, 0x65, 0xda, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x77, 0xd5, 0x6b, 0x5f, 0xa1, 0x65, 0x75, 0xfc, 0x77, 0xd5, 0x6b	/* T__probestub_sched_kthread_work_queue_work */
	.byte 0x17, 0x08, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x77, 0xd5, 0x6b, 0x5f, 0xcb, 0xb4, 0x20, 0xfc, 0x3d, 0x72, 0x74	/* T__pfx___traceiter_sched_kthread_work_execute_start */
	.byte 0x17, 0xb9, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x77, 0xd5, 0x6b, 0x5f, 0xcb, 0xb4, 0x20, 0xfc, 0x3d, 0x72, 0x74	/* T__traceiter_sched_kthread_work_execute_start */
	.byte 0x16, 0x08, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x77, 0xd5, 0x6b, 0x5f, 0xcb, 0xb4, 0x20, 0xfc, 0xf1, 0x64	/* T__pfx___traceiter_sched_kthread_work_execute_end */
	.byte 0x16, 0xb9, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x77, 0xd5, 0x6b, 0x5f, 0xcb, 0xb4, 0x20, 0xfc, 0xf1, 0x64	/* T__traceiter_sched_kthread_work_execute_end */
	.byte 0x17, 0x99, 0xec, 0x10, 0xf6, 0xba, 0x65, 0xda, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x77, 0xd5, 0x6b, 0x5f, 0xcb, 0xb4, 0x20, 0xfc, 0xf1, 0x64	/* T__pfx___probestub_sched_kthread_work_execute_end */
	.byte 0x17, 0x54, 0xfd, 0x10, 0xf6, 0xba, 0x65, 0xda, 0x6b, 0x74, 0x68, 0xf7, 0x61, 0xda, 0x77, 0xd5, 0x6b, 0x5f, 0xcb, 0xb4, 0x20, 0xfc, 0xf1, 0x64	/* T__probestub_sched_kthread_work_execute_end */
	.byte 0x0a, 0x08, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x77, 0x61, 0x6b, 0x8d	/* T__pfx___traceiter_sched_waking */
	.byte 0x0a, 0xb9, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x77, 0x61, 0x6b, 0x8d	/* T__traceiter_sched_waking */
	.byte 0x0b, 0x08, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x77, 0x61, 0x6b, 0x65, 0xcd	/* T__pfx___traceiter_sched_wakeup */
	.byte 0x0b, 0xb9, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x77, 0x61, 0x6b, 0x65, 0xcd	/* T__traceiter_sched_wakeup */
	.byte 0x0e, 0x08, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x77, 0x61, 0x6b, 0x65, 0xcd, 0xbd, 0x65, 0x77	/* T__pfx___traceiter_sched_wakeup_new */
	.byte 0x0e, 0xb9, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x77, 0x61, 0x6b, 0x65, 0xcd, 0xbd, 0x65, 0x77	/* T__traceiter_sched_wakeup_new */
	.byte 0x09, 0x08, 0x18, 0xf6, 0xba, 0x9e, 0xf6, 0x77, 0xea, 0xba	/* T__pfx___traceiter_sched_switch */
	.byte 0x09, 0xb9, 0x18, 0xf6, 0xba, 0x9e, 0xf6, 0x77, 0xea, 0xba	/* T__traceiter_sched_switch */
	.byte 0x0a, 0x99, 0xec, 0x10, 0xf6, 0xba, 0x9e, 0xf6, 0x77, 0xea, 0xba	/* T__pfx___probestub_sched_switch */
	.byte 0x0a, 0x54, 0xfd, 0x10, 0xf6, 0xba, 0x9e, 0xf6, 0x77, 0xea, 0xba	/* T__probestub_sched_switch */
	.byte 0x0c, 0x08, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x6d, 0x0c, 0x72, 0x91, 0xf4, 0x5e	/* T__pfx___traceiter_sched_migrate_task */
	.byte 0x0c, 0xb9, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x6d, 0x0c, 0x72, 0x91, 0xf4, 0x5e	/* T__traceiter_sched_migrate_task */
	.byte 0x0d, 0x99, 0xec, 0x10, 0xf6, 0xba, 0x65, 0xda, 0x6d, 0x0c, 0x72, 0x91, 0xf4, 0x5e	/* T__pfx___probestub_sched_migrate_task */
	.byte 0x0d, 0x54, 0xfd, 0x10, 0xf6, 0xba, 0x65, 0xda, 0x6d, 0x0c, 0x72, 0x91, 0xf4, 0x5e	/* T__probestub_sched_migrate_task */
	.byte 0x0d, 0x08, 0x18, 0xf6, 0xba, 0x9e, 0xec, 0xe3, 0x63, 0xd6, 0xe9, 0x66, 0xf7, 0x65	/* T__pfx___traceiter_sched_process_free */
	.byte 0x0d, 0xb9, 0x18, 0xf6, 0xba, 0x9e, 0xec, 0xe3, 0x63, 0xd6, 0xe9, 0x66, 0xf7, 0x65	/* T__traceiter_sched_process_free */
	.byte 0x0c, 0x08, 0x18, 0xf6, 0xba, 0x9e, 0xec, 0xe3, 0x63, 0xd6, 0xe9, 0xcb, 0xea	/* T__pfx___traceiter_sched_process_exit */
	.byte 0x0c, 0xb9, 0x18, 0xf6, 0xba, 0x9e, 0xec, 0xe3, 0x63, 0xd6, 0xe9, 0xcb, 0xea	/* T__traceiter_sched_process_exit */
	.byte 0x0b, 0x08, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x77, 0x61, 0x9d, 0xf4, 0x5e	/* T__pfx___traceiter_sched_wait_task */
	.byte 0x0b, 0xb9, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x77, 0x61, 0x9d, 0xf4, 0x5e	/* T__traceiter_sched_wait_task */
	.byte 0x0d, 0x08, 0x18, 0xf6, 0xba, 0x9e, 0xec, 0xe3, 0x63, 0xd6, 0xe9, 0x77, 0x61, 0xea	/* T__pfx___traceiter_sched_process_wait */
	.byte 0x0d, 0xb9, 0x18, 0xf6, 0xba, 0x9e, 0xec, 0xe3, 0x63, 0xd6, 0xe9, 0x77, 0x61, 0xea	/* T__traceiter_sched_process_wait */
	.byte 0x0d, 0x08, 0x18, 0xf6, 0xba, 0x9e, 0xec, 0xe3, 0x63, 0xd6, 0xe9, 0x66, 0xd5, 0x6b	/* T__pfx___traceiter_sched_process_fork */
	.byte 0x0d, 0xb9, 0x18, 0xf6, 0xba, 0x9e, 0xec, 0xe3, 0x63, 0xd6, 0xe9, 0x66, 0xd5, 0x6b	/* T__traceiter_sched_process_fork */
	.byte 0x0c, 0x08, 0x18, 0xf6, 0xba, 0x9e, 0xec, 0xe3, 0x63, 0xd6, 0xe9, 0xcb, 0xb4	/* T__pfx___traceiter_sched_process_exec */
	.byte 0x0c, 0xb9, 0x18, 0xf6, 0xba, 0x9e, 0xec, 0xe3, 0x63, 0xd6, 0xe9, 0xcb, 0xb4	/* T__traceiter_sched_process_exec */
	.byte 0x0d, 0x99, 0xec, 0x10, 0xf6, 0xba, 0x9e, 0xec, 0xe3, 0x63, 0xd6, 0xe9, 0xcb, 0xb4	/* T__pfx___probestub_sched_process_exec */
	.byte 0x0d, 0x54, 0xfd, 0x10, 0xf6, 0xba, 0x9e, 0xec, 0xe3, 0x63, 0xd6, 0xe9, 0xcb, 0xb4	/* T__probestub_sched_process_exec */
	.byte 0x0c, 0x08, 0x18, 0xf6, 0xba, 0x9e, 0xec, 0xf7, 0x70, 0xc5, 0xfc, 0xcb, 0xb4	/* T__pfx___traceiter_sched_prepare_exec */
	.byte 0x0c, 0xb9, 0x18, 0xf6, 0xba, 0x9e, 0xec, 0xf7, 0x70, 0xc5, 0xfc, 0xcb, 0xb4	/* T__traceiter_sched_prepare_exec */
	.byte 0x0a, 0x08, 0x18, 0xf6, 0xba, 0x9e, 0xa9, 0xfe, 0x77, 0x61, 0xea	/* T__pfx___traceiter_sched_stat_wait */
	.byte 0x0a, 0xb9, 0x18, 0xf6, 0xba, 0x9e, 0xa9, 0xfe, 0x77, 0x61, 0xea	/* T__traceiter_sched_stat_wait */
	.byte 0x0b, 0x99, 0xec, 0x10, 0xf6, 0xba, 0x9e, 0xa9, 0xfe, 0x77, 0x61, 0xea	/* T__pfx___probestub_sched_stat_wait */
	.byte 0x0b, 0x54, 0xfd, 0x10, 0xf6, 0xba, 0x9e, 0xa9, 0xfe, 0x77, 0x61, 0xea	/* T__probestub_sched_stat_wait */
	.byte 0x0b, 0x08, 0x18, 0xf6, 0xba, 0x9e, 0xa9, 0xfe, 0x73, 0xc4, 0x65, 0x70	/* T__pfx___traceiter_sched_stat_sleep */
	.byte 0x0b, 0xb9, 0x18, 0xf6, 0xba, 0x9e, 0xa9, 0xfe, 0x73, 0xc4, 0x65, 0x70	/* T__traceiter_sched_stat_sleep */
	.byte 0x0b, 0x08, 0x18, 0xf6, 0xba, 0x9e, 0xa9, 0xfe, 0xc0, 0x77, 0x61, 0xea	/* T__pfx___traceiter_sched_stat_iowait */
	.byte 0x0b, 0xb9, 0x18, 0xf6, 0xba, 0x9e, 0xa9, 0xfe, 0xc0, 0x77, 0x61, 0xea	/* T__traceiter_sched_stat_iowait */
	.byte 0x0a, 0x08, 0x18, 0xf6, 0xba, 0x9e, 0xa9, 0xfe, 0x62, 0xa4, 0x9e	/* T__pfx___traceiter_sched_stat_blocked */
	.byte 0x0a, 0xb9, 0x18, 0xf6, 0xba, 0x9e, 0xa9, 0xfe, 0x62, 0xa4, 0x9e	/* T__traceiter_sched_stat_blocked */
	.byte 0x0b, 0x08, 0x18, 0xf6, 0xba, 0x9e, 0xa9, 0xfe, 0x72, 0xe4, 0xdc, 0xa8	/* T__pfx___traceiter_sched_stat_runtime */
	.byte 0x0b, 0xb9, 0x18, 0xf6, 0xba, 0x9e, 0xa9, 0xfe, 0x72, 0xe4, 0xdc, 0xa8	/* T__traceiter_sched_stat_runtime */
	.byte 0x0c, 0x08, 0x18, 0xf6, 0xba, 0x9e, 0xec, 0x69, 0xf6, 0xd4, 0x70, 0x72, 0xc0	/* T__pfx___traceiter_sched_pi_setprio */
	.byte 0x0c, 0xb9, 0x18, 0xf6, 0xba, 0x9e, 0xec, 0x69, 0xf6, 0xd4, 0x70, 0x72, 0xc0	/* T__traceiter_sched_pi_setprio */
	.byte 0x0b, 0x08, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x17, 0x1a, 0x6e, 0x75, 0xd9	/* T__pfx___traceiter_sched_move_numa */
	.byte 0x0b, 0xb9, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x17, 0x1a, 0x6e, 0x75, 0xd9	/* T__traceiter_sched_move_numa */
	.byte 0x0c, 0x99, 0xec, 0x10, 0xf6, 0xba, 0x65, 0xda, 0x17, 0x1a, 0x6e, 0x75, 0xd9	/* T__pfx___probestub_sched_move_numa */
	.byte 0x0c, 0x54, 0xfd, 0x10, 0xf6, 0xba, 0x65, 0xda, 0x17, 0x1a, 0x6e, 0x75, 0xd9	/* T__probestub_sched_move_numa */
	.byte 0x0b, 0x08, 0x18, 0xf6, 0xba, 0x9e, 0xf6, 0xdc, 0xc6, 0xbd, 0x75, 0xd9	/* T__pfx___traceiter_sched_stick_numa */
	.byte 0x0b, 0xb9, 0x18, 0xf6, 0xba, 0x9e, 0xf6, 0xdc, 0xc6, 0xbd, 0x75, 0xd9	/* T__traceiter_sched_stick_numa */
	.byte 0x0c, 0x99, 0xec, 0x10, 0xf6, 0xba, 0x9e, 0xf6, 0xdc, 0xc6, 0xbd, 0x75, 0xd9	/* T__pfx___probestub_sched_stick_numa */
	.byte 0x0c, 0x54, 0xfd, 0x10, 0xf6, 0xba, 0x9e, 0xf6, 0xdc, 0xc6, 0xbd, 0x75, 0xd9	/* T__probestub_sched_stick_numa */
	.byte 0x0c, 0x08, 0x18, 0xf6, 0xba, 0x9e, 0xf6, 0x77, 0x61, 0x70, 0xbd, 0x75, 0xd9	/* T__pfx___traceiter_sched_swap_numa */
	.byte 0x0c, 0xb9, 0x18, 0xf6, 0xba, 0x9e, 0xf6, 0x77, 0x61, 0x70, 0xbd, 0x75, 0xd9	/* T__traceiter_sched_swap_numa */
	.byte 0x13, 0x08, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x77, 0x61, 0x6b, 0xfc, 0x9f, 0xb0, 0x77, 0xea, 0x68, 0x6f, 0x1e, 0x69, 0xb2	/* T__pfx___traceiter_sched_wake_idle_without_ipi */
	.byte 0x13, 0xb9, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x77, 0x61, 0x6b, 0xfc, 0x9f, 0xb0, 0x77, 0xea, 0x68, 0x6f, 0x1e, 0x69, 0xb2	/* T__traceiter_sched_wake_idle_without_ipi */
	.byte 0x08, 0x08, 0x18, 0xec, 0xdb, 0xfe, 0x63, 0x80, 0xce	/* T__pfx___traceiter_pelt_cfs_tp */
	.byte 0x08, 0xb9, 0x18, 0xec, 0xdb, 0xfe, 0x63, 0x80, 0xce	/* T__traceiter_pelt_cfs_tp */
	.byte 0x08, 0x08, 0x18, 0xec, 0xdb, 0xfe, 0x72, 0xfe, 0xce	/* T__pfx___traceiter_pelt_rt_tp */
	.byte 0x08, 0xb9, 0x18, 0xec, 0xdb, 0xfe, 0x72, 0xfe, 0xce	/* T__traceiter_pelt_rt_tp */
	.byte 0x09, 0x08, 0x18, 0xec, 0xdb, 0xfe, 0x64, 0x6c, 0x5f, 0xce	/* T__pfx___traceiter_pelt_dl_tp */
	.byte 0x09, 0xb9, 0x18, 0xec, 0xdb, 0xfe, 0x64, 0x6c, 0x5f, 0xce	/* T__traceiter_pelt_dl_tp */
	.byte 0x08, 0x08, 0x18, 0xec, 0xdb, 0xfe, 0x68, 0x8f, 0xce	/* T__pfx___traceiter_pelt_hw_tp */
	.byte 0x08, 0xb9, 0x18, 0xec, 0xdb, 0xfe, 0x68, 0x8f, 0xce	/* T__traceiter_pelt_hw_tp */
	.byte 0x09, 0x08, 0x18, 0xec, 0xdb, 0xfe, 0xab, 0x71, 0x5f, 0xce	/* T__pfx___traceiter_pelt_irq_tp */
	.byte 0x09, 0xb9, 0x18, 0xec, 0xdb, 0xfe, 0xab, 0x71, 0x5f, 0xce	/* T__traceiter_pelt_irq_tp */
	.byte 0x08, 0x08, 0x18, 0xec, 0xdb, 0xfe, 0x73, 0xfc, 0xce	/* T__pfx___traceiter_pelt_se_tp */
	.byte 0x08, 0xb9, 0x18, 0xec, 0xdb, 0xfe, 0x73, 0xfc, 0xce	/* T__traceiter_pelt_se_tp */
	.byte 0x0e, 0x08, 0x18, 0xf6, 0xba, 0x9e, 0xf0, 0x9c, 0xf0, 0x61, 0x70, 0xf2, 0xea, 0x1d, 0xce	/* T__pfx___traceiter_sched_cpu_capacity_tp */
	.byte 0x0e, 0xb9, 0x18, 0xf6, 0xba, 0x9e, 0xf0, 0x9c, 0xf0, 0x61, 0x70, 0xf2, 0xea, 0x1d, 0xce	/* T__traceiter_sched_cpu_capacity_tp */
	.byte 0x10, 0x08, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x6f, 0x0b, 0x75, 0xdc, 0x6c, 0x69, 0x7a, 0x65, 0xda, 0xce	/* T__pfx___traceiter_sched_overutilized_tp */
	.byte 0x10, 0xb9, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x6f, 0x0b, 0x75, 0xdc, 0x6c, 0x69, 0x7a, 0x65, 0xda, 0xce	/* T__traceiter_sched_overutilized_tp */
	.byte 0x11, 0x99, 0xec, 0x10, 0xf6, 0xba, 0x65, 0xda, 0x6f, 0x0b, 0x75, 0xdc, 0x6c, 0x69, 0x7a, 0x65, 0xda, 0xce	/* T__pfx___probestub_sched_overutilized_tp */
	.byte 0x11, 0x54, 0xfd, 0x10, 0xf6, 0xba, 0x65, 0xda, 0x6f, 0x0b, 0x75, 0xdc, 0x6c, 0x69, 0x7a, 0x65, 0xda, 0xce	/* T__probestub_sched_overutilized_tp */
	.byte 0x0f, 0x08, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x75, 0xdc, 0x6c, 0x5f, 0xd6, 0xfe, 0x63, 0x80, 0xce	/* T__pfx___traceiter_sched_util_est_cfs_tp */
	.byte 0x0f, 0xb9, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x75, 0xdc, 0x6c, 0x5f, 0xd6, 0xfe, 0x63, 0x80, 0xce	/* T__traceiter_sched_util_est_cfs_tp */
	.byte 0x0f, 0x08, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x75, 0xdc, 0x6c, 0x5f, 0xd6, 0xfe, 0x73, 0xfc, 0xce	/* T__pfx___traceiter_sched_util_est_se_tp */
	.byte 0x0f, 0xb9, 0x18, 0xf6, 0xba, 0x65, 0xda, 0x75, 0xdc, 0x6c, 0x5f, 0xd6, 0xfe, 0x73, 0xfc, 0xce	/* 