#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched.h>
#include <linux/sched/signal.h>

#define PROC_NAME "pg_stats"
#define PRINT_STRING "[%d]: [[%ld],[%ld],[%ld]], [[%ld],[%ld],[%ld]], [[%ld],[%ld],[%ld]], [[%ld],[%ld],[%ld]]\n"

static int pg_stats_show(struct seq_file *m, void *v)
{
	struct task_struct *task;
	for_each_process(task) {
		seq_printf(
			m,
			PRINT_STRING,
			task->pid,
			task->pgd_alloc,
			task->pgd_free,
			task->pgd_set,
			task->pud_alloc,
			task->pud_free,
			task->pud_set,
			task->pmd_alloc,
			task->pmd_free,
			task->pmd_set,
			task->pte_alloc,
			task->pte_free,
			task->pte_set);
	}
	return 0;
}

static int op(struct inode *inode, struct file *f) {
	// TODO: deal with open.
	return single_open(f, pg_stats_show, NULL);
}

static struct proc_ops proc_pg_stats_ops = {
	.proc_open = op,
	.proc_read = seq_read,
	.proc_lseek = seq_lseek,
	.proc_release = seq_release
};

static int __init pg_stats_init(void) {
	proc_create(PROC_NAME, 0, NULL, &proc_pg_stats_ops);
	return 0;
}

static void __exit pg_stats_exit(void) {
	remove_proc_entry(PROC_NAME, NULL);
	// TODO.
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);
