#include <linux/fs.h>
#include <linux/kernel.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/mm.h>
#include <linux/sched/signal.h>
#include <linux/module.h>

static int pg_stats(struct seq_file *m, void *v) {

    struct task_struct *task;

    rcu_read_lock();
    for_each_process(task){
        seq_printf(m, "%d: [[%lu], [%lu], [%lu]], [[%lu], [%lu], [%lu]], [[%lu], [%lu], [%lu]], [[%lu], [%lu], [%lu]]\n", task->pid, task->pgd_alloc, task->pgd_free, task->pgd_set, task->pud_alloc, task->pud_free, task->pud_set, task->pmd_alloc, task->pmd_free, task->pmd_set, task->pte_alloc, task->pte_free, task->pte_set);
    }

    rcu_read_unlock();
    return 0;
}

static int open_stats(struct inode *inode, struct file *file){
    return single_open(file, pg_stats, NULL);
}

static const struct proc_ops pg_stats_ops = {
    .proc_open = open_stats,
    .proc_read = seq_read,
    .proc_lseek = seq_lseek,
    .proc_release = single_release,
};

static int __init pg_stats_init(void) {
    proc_create("pg_stats", 0444, NULL, &pg_stats_ops);
    return 0;
}

static void __exit pg_stats_exit(void) {
    remove_proc_entry("pg_stats", NULL);
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);