#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched/signal.h>

static int pg_stats_show(struct seq_file *m, void *v)
{
    struct task_struct *t;

    for_each_process(t) {
        seq_printf(m, "%d: ", t->pid);

        seq_printf(m, "[[%lu],[%lu],[%lu]], ", t->pgd_alloc, t->pgd_free, t->pgd_set);
        seq_printf(m, "[[%lu],[%lu],[%lu]], ", t->pud_alloc, t->pud_free, t->pud_set);
        seq_printf(m, "[[%lu],[%lu],[%lu]], ", t->pmd_alloc, t->pmd_free, t->pmd_set);
        seq_printf(m, "[[%lu],[%lu],[%lu]]\n", t->pte_alloc, t->pte_free, t->pte_set);
    }

    return 0;
}


static int pg_stats_open(struct inode *inode, struct file *file)
{
    return single_open(file, pg_stats_show, NULL);
}

static const struct proc_ops pg_stats_fops = {
    .proc_open    = pg_stats_open,
    .proc_read    = seq_read,
    .proc_lseek   = seq_lseek,
    .proc_release = single_release,
};

static int __init pg_stats_init(void)
{
    proc_create("pg_stats", 0, NULL, &pg_stats_fops);
    return 0;
}

fs_initcall(pg_stats_init);
