#include <linux/kernel.h>	
#include <linux/module.h>	
#include <linux/proc_fs.h>
#include <linux/seq_file.h>	

#define PROC_NAME	"pg_stats"

MODULE_AUTHOR("s2345314");

static void *pg_stats_seq_start(struct seq_file *s, loff_t *pos)
{
    struct task_struct *task;
    loff_t i = 0;

    rcu_read_lock();
    for_each_process(task) {
        if (i++ == *pos){
            return task;
        }
    }
    rcu_read_unlock();
    return NULL;
}

static void *pg_stats_seq_next(struct seq_file *s, void *v, loff_t *pos)
{
    struct task_struct *task = v;
    (*pos)++;
    task = next_task(task);

    if (task == &init_task)
	    return NULL;
    return task;
}

static void pg_stats_seq_stop(struct seq_file *s, void *v)
{
	/* nothing as we just use a static value in start() */
}

/**
 * For each PID print the stats *
 */

static int pg_stats_seq_show(struct seq_file *s, void *v)
{
    struct task_struct *task = v;
	
	seq_printf(s, "[%d]: [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]]\n", 
    task->pid,task->pgd_alloc, task->pgd_free, task->pgd_set, task->pud_alloc, task->pud_free, task->pud_set, 
    task->pmd_alloc, task->pmd_free, task->pmd_set,task->pte_alloc, task->pte_free, task->pte_set);

    return 0;
}

static struct seq_operations pg_stats_seq_ops = {
	.start = pg_stats_seq_start,
	.next  = pg_stats_seq_next,
	.stop  = pg_stats_seq_stop,
	.show  = pg_stats_seq_show
};

static int pg_stats_open(struct inode *inode, struct file *file)
{
	return seq_open(file, &pg_stats_seq_ops);
};

static struct proc_ops pg_stats_fops = {
	// .owner   = s2345314,
	.proc_open    = pg_stats_open,
	.proc_read    = seq_read,
	.proc_lseek  = seq_lseek,
	.proc_release = seq_release
};
	
static int __init pg_stats_init(void)
{
	proc_create(PROC_NAME, 0444, NULL, &pg_stats_fops);	
	return 0;
}

static void __exit pg_stats_exit(void)
{
	remove_proc_entry(PROC_NAME, NULL);
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);