#include <linux/fs.h>
#include <linux/init.h>
#include <linux/proc_fs.h>
#include <linux/sched.h>
#include <linux/seq_file.h>
#include <linux/module.h>

// CW2 Task 1
// future reference: go to /fs/proc/uptime.c or fd.c or base.c for skeleton code
// line 511 of base.c was used for CW1

static int pg_proc_show(struct seq_file *m, void *v) {
    // to point to a task
    struct task_struct *task;

    // FORMAT
    // [pid]: [[pgd_alloc],[pgd_free],[pgd_set]], [[pud_alloc],[pud_free],[pud_set]], [[pmd_alloc], 
    // [pmd_free],[pmd_set]], [[pte_alloc],[pte_free],[pte_set]]

    rcu_read_lock();
    for_each_process(task) {

        if (!task){
            continue;
        }

        seq_printf(m, "[%d]: [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]]\n",
            // process id
            task->pid,

            // PGD level
            task->pagetable_allocated_count[0],
            task->pagetable_freed_count[0],
            task->pagetable_set_count[0],

            // PUD level
            task->pagetable_allocated_count[1],
            task->pagetable_freed_count[1],
            task->pagetable_set_count[1],

            // PMD level
            task->pagetable_allocated_count[2],
            task->pagetable_freed_count[2],
            task->pagetable_set_count[2],

            // PTE level
            task->pagetable_allocated_count[3],
            task->pagetable_freed_count[3],
            task->pagetable_set_count[3]
        );
    }
    rcu_read_unlock();

    return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file) {
    return single_open(file, pg_proc_show, NULL);
}

static const struct proc_ops pg_stats_fops = {
    .proc_open    = pg_stats_open,
    .proc_read    = seq_read,
    .proc_lseek   = seq_lseek,
    .proc_release = single_release,
};

static int __init pg_stats_init(void) {
    proc_create("pg_stats", 0444, NULL, &pg_stats_fops);
    return 0;
}

static void __exit pg_stats_exit(void) {
    remove_proc_entry("pg_stats", NULL);
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);