#include <linux/module.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched.h>
#include <linux/sched/signal.h>

static int pg_stats_show(struct seq_file *m, void *v)
{
    struct task_struct *p;

    for_each_process(p) {
        seq_printf(m, "%d: [[%llu],[%llu],[%llu]], [[%llu],[%llu],[%llu]], [[%llu],[%llu],[%llu]], [[%llu],[%llu],[%llu]]\n",
                   p->pid,
                       atomic64_read(&p->pgd_alloc_count), atomic64_read(&p->pgd_free_count), atomic64_read(&p->pgd_set_count),
                       atomic64_read(&p->pud_alloc_count), atomic64_read(&p->pud_free_count), atomic64_read(&p->pud_set_count),
                       atomic64_read(&p->pmd_alloc_count), atomic64_read(&p->pmd_free_count), atomic64_read(&p->pmd_set_count),
                       atomic64_read(&p->pte_alloc_count), atomic64_read(&p->pte_free_count), atomic64_read(&p->pte_set_count));
    }
    return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file)
{
    return single_open(file, pg_stats_show, NULL);
}

static const struct proc_ops pg_stats_ops = {
    .proc_open    = pg_stats_open,
    .proc_read    = seq_read,
    .proc_lseek   = seq_lseek,
    .proc_release = single_release,
};

static int __init pg_stats_init(void)
{
    if (!proc_create("pg_stats", 0444, NULL, &pg_stats_ops)) {
        pr_err("Failed to create /proc/pg_stats\n");
        return -ENOMEM;
    }
    pr_info("pg_stats module loaded.\n");
    return 0;
}

static void __exit pg_stats_exit(void)
{
    remove_proc_entry("pg_stats", NULL);
    pr_info("pg_stats module unloaded.\n");
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Ellis");
MODULE_DESCRIPTION("Page Table Statistics Module");