/*
 * Added for CW2 - Task 1
 *
 * fs/proc/pg_stats.c
 *
 * Creates a /proc/pg_stats entry that prints a line per active process.
 * Each line has the format:
 *
 *   [pid]: [[pgd_alloc],[pgd_free],[pgd_set]], [[pud_alloc],[pud_free],[pud_set]],
 *          [[pmd_alloc],[pmd_free],[pmd_set]], [[pte_alloc],[pte_free],[pte_set]]
 *
 */

#include <linux/module.h>
#include <linux/init.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched.h>
#include <linux/sched/signal.h>

static int pg_stats_show(struct seq_file *m, void *v)
{
    struct task_struct *task;

    for_each_process(task) {
        seq_printf(m,
            "%d: [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]]\n",
            task->pid,
            task->pg_stats.pgd_alloc, task->pg_stats.pgd_free, task->pg_stats.pgd_set,
            task->pg_stats.pud_alloc, task->pg_stats.pud_free, task->pg_stats.pud_set,
            task->pg_stats.pmd_alloc, task->pg_stats.pmd_free, task->pg_stats.pmd_set,
            task->pg_stats.pte_alloc, task->pg_stats.pte_free, task->pg_stats.pte_set);
    }

    return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file)
{
    return single_open(file, pg_stats_show, NULL);
}

static const struct proc_ops pg_stats_ops = {
    .proc_open	  = pg_stats_open,
    .proc_read	  = seq_read,
    .proc_lseek	  = seq_lseek,
    .proc_release = single_release,
};

static int __init pg_stats_init(void)
{
    proc_create("pg_stats", 0, NULL, &pg_stats_ops);
    pr_info("pg_stats: /proc/pg_stats created\n");
    return 0;
}

static void __exit pg_stats_exit(void)
{
    remove_proc_entry("pg_stats", NULL);
    pr_info("pg_stats: /proc/pg_stats removed\n");
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);

