#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched.h>
#include <linux/sched/signal.h>

/*
You will need to implement a complete procfs module including the necessary 
initialization function, file operations structure, and a show function that 
displays the statistics for each process.
*/
// referenced arch/x86/mm/pat/set_memory.c and kernel docs
// show function displaying statistics
static int pg_stats_show(struct seq_file *s, void *v) {
    // use the seq file interface and iterate through all processes to display their page
    // table operation counters in the specified format
    // referenced base.c to understand how to iterate
    struct task_struct *task;
    rcu_read_lock();
    for_each_process(task) {
        // print out all counters
        seq_printf(s, "[%d]: [[%lu], [%lu], [%lu]], [[%lu], [%lu], [%lu]], [[%lu], [%lu], [%lu]], [[%lu], [%lu], [%lu]]\n",
            task->pid,
            task->pgd_alloc, task->pgd_free, task->pgd_set,
            task->pud_alloc, task->pud_free, task->pud_set,
            task->pmd_alloc, task->pmd_free, task->pmd_set,
            task->pte_alloc, task->pte_free, task->pte_set);
    }
    rcu_read_unlock();
    return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file) {
    return single_open(file, pg_stats_show, NULL);
}

// referenced stat.c and CW0
// file operations structure
static const struct proc_ops pg_stats_ops = {
    .proc_open = pg_stats_open,
    .proc_read = seq_read,
    .proc_lseek = seq_lseek,
    .proc_release = single_release,
};

// initialization function
static int __init pg_stats_init(void) {
    proc_create("pg_stats", 0, NULL, &pg_stats_ops);
    printk(KERN_INFO "Created.\n");
    return 0;
}

module_init(pg_stats_init);