#include <linux/fs.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched/signal.h>
#include <linux/atomic.h>
#include "internal.h"

// TODO: remember to test compilation w/ gcc before submission!

static int pg_stats_proc_show(struct seq_file *m, void *v)
{
	struct task_struct *p;
	for_each_process(p) {
		seq_printf(m, "[%d]: [[%lu], [%lu], [%lu]], [[%lu], [%lu], [%lu]], [[%lu], [%lu], [%lu]], [[%lu], [%lu], [%lu]]\n",
			p->pid,
			atomic_long_read(&p->n_alloc_pgd), atomic_long_read(&p->n_free_pgd), atomic_long_read(&p->n_set_pgd),
			atomic_long_read(&p->n_alloc_pud), atomic_long_read(&p->n_free_pud), atomic_long_read(&p->n_set_pud),
			atomic_long_read(&p->n_alloc_pmd), atomic_long_read(&p->n_free_pmd), atomic_long_read(&p->n_set_pmd),
			atomic_long_read(&p->n_alloc_pte), atomic_long_read(&p->n_free_pte), atomic_long_read(&p->n_set_pte)
		);
	}
	return 0;
}

static int __init proc_pg_stats_init(void)
{
	struct proc_dir_entry *pde;

	pde = proc_create_single("pg_stats", 0, NULL, pg_stats_proc_show);
	pde_make_permanent(pde);
	return 0;
}
fs_initcall(proc_pg_stats_init);
