#include <linux/module.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched.h>
#include <linux/sched/signal.h>

// 显示统计数据的函数
static int pg_stats_show(struct seq_file *m, void *v)
{
    struct task_struct *task;

    for_each_process(task) {
        seq_printf(m, "%d: [%lu,%lu,%lu], [%lu,%lu,%lu], [%lu,%lu,%lu], [%lu,%lu,%lu]\n",
                   task->pid,
                   task->pgd_alloc, task->pgd_free, task->pgd_set,
                   task->pud_alloc, task->pud_free, task->pud_set,
                   task->pmd_alloc, task->pmd_free, task->pmd_set,
                   task->pte_alloct, task->pte_free, task->pte_set);
    }

    return 0;
}

// 打开 proc 文件的函数
static int pg_stats_open(struct inode *inode, struct file *file)
{
    return single_open(file, pg_stats_show, NULL);
}

// 文件操作结构
static const struct file_operations pg_stats_fops = {
    .open = pg_stats_open,
    .read = seq_read,
    .llseek = seq_lseek,
    .release = single_release,
};

// 初始化模块
static int __init pg_stats_init(void)
{
    proc_create("pg_stats", 0, NULL, &pg_stats_fops);
    return 0;
}

// 清理模块
static void __exit pg_stats_exit(void)
{
    remove_proc_entry("pg_stats", NULL);
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);
