#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/seq_file.h>
#include <linux/proc_fs.h>

static struct proc_dir_entry *pg_stats_entry;

static int pg_stats_proc_show(struct seq_file *m, void *v)
{
	struct task_struct *task;
	rcu_read_lock();
	for_each_process(task) {
		seq_printf(m, "[%d]:[[%ld],[%ld],[%ld]], [[%ld],[%ld],[%ld]], [[%ld],[%ld],[%ld]], [[%ld],[%ld],[%ld]]\n",
                   task->pid,
                   atomic_long_read(&task->pgd_alloc_count),  // pgd_alloc_count
                   atomic_long_read(&task->pgd_free_count),   // pgd_free_count
                   atomic_long_read(&task->pgd_set_count),    // pgd_set_count
                   atomic_long_read(&task->pud_alloc_count),  // pud_alloc_count
                   atomic_long_read(&task->pud_free_count),   // pud_free_count
                   atomic_long_read(&task->pud_set_count),    // pud_set_count
                   atomic_long_read(&task->pmd_alloc_count),  // pmd_alloc_count
                   atomic_long_read(&task->pmd_free_count),   // pmd_free_count
                   atomic_long_read(&task->pmd_set_count),    // pmd_set_count
                   atomic_long_read(&task->pte_alloc_count),  // pte_alloc_count
                   atomic_long_read(&task->pte_free_count),   // pte_free_count
                   atomic_long_read(&task->pte_set_count));   // pte_set_count
    }

    rcu_read_unlock();
    return 0;
}
	
static int pg_fault_stats_open(struct inode *inode, struct file *file) {
	return single_open(file, pg_stats_proc_show, NULL);
}

static const struct proc_ops pg_stats_proc_fops = {
	.proc_open = pg_fault_stats_open,
	.proc_read = seq_read,
	.proc_lseek = seq_lseek,
	.proc_release = single_release,
};

static int __init proc_pg_stats_init(void)
{
	pg_stats_entry = proc_create("pg_stats", 0, NULL, &pg_stats_proc_fops);
	return 0;
}

static void __exit proc_pg_stats_exit(void)
{
    proc_remove(pg_stats_entry);
}

module_init(proc_pg_stats_init);
module_exit(proc_pg_stats_exit);
