#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/proc_fs.h>
#include <linux/sched.h>
#include <linux/seq_file.h>

#define PROC_NAME "pg_stats"

static void print_pg_stats(struct seq_file *f, struct task_struct *task) {
    struct pg_stats stats = task->pg_stats;

    seq_printf(f, "%d: [[%d],[%d],[%d]],", task->pid, stats.pgd.alloc, stats.pgd.free, stats.pgd.set);
    seq_printf(f, "[[%d],[%d],[%d]],",                stats.pud.alloc, stats.pud.free, stats.pud.set);
    seq_printf(f, "[[%d],[%d],[%d]],",                stats.pmd.alloc, stats.pmd.free, stats.pmd.set);
    seq_printf(f, "[[%d],[%d],[%d]]\n",               stats.pte.alloc, stats.pte.free, stats.pte.set);
}

static void *pg_stats_start(struct seq_file *f, loff_t *pos) {
        if (*pos == 0)
            return pos;
        else {
            *pos = 0;
            return NULL;
        }
}

static void *pg_stats_next(struct seq_file *f, void *v, loff_t *pos) {
        (*pos)++;
        return NULL;
}

static void pg_stats_stop(struct seq_file *f, void *v) {
        /* Nothing to release here */ 
}

static int pg_stats_show(struct seq_file *f, void *v) {
        struct task_struct *task;
        
        for_each_process(task) {
            print_pg_stats(f, task);
        }
        return 0;
}

static const struct seq_operations pg_stats_ops = {
        .start = pg_stats_start,
        .next = pg_stats_next,
        .stop = pg_stats_stop,
        .show = pg_stats_show,
};

static int __init pg_stats_init(void) {
        proc_create_seq(PROC_NAME, 0, NULL, &pg_stats_ops);
        printk(KERN_INFO "Loaded CW2 Module pg_stats.c");
        return 0;
}

void cleanup_module(void) {
        remove_proc_entry(PROC_NAME, NULL);
}

fs_initcall(pg_stats_init);

