#include <linux/fs.h>
#include <linux/init.h>
#include <linux/proc_fs.h>
#include <linux/sched.h>
#include <linux/seq_file.h>
#include <linux/seqlock.h>
#include "internal.h"

// CW2
static int pg_stats_proc_show(struct seq_file *m, void *v) {
    struct task_struct *task;

    for_each_process(task) {
        seq_printf(m,
            "%d: [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]]\n",
            task->pid,
            task->page_stats.pgd.allocated, task->page_stats.pgd.freed, task->page_stats.pgd.set,
            task->page_stats.pud.allocated, task->page_stats.pud.freed, task->page_stats.pud.set,
            task->page_stats.pmd.allocated, task->page_stats.pmd.freed, task->page_stats.pmd.set,
            task->page_stats.pte.allocated, task->page_stats.pte.freed, task->page_stats.pte.set
        );
    }

    return 0;
}

static int __init pg_stats_proc_init(void) {
    struct proc_dir_entry *pde;

    printk(KERN_INFO "CW2: pg_stats_proc_init called\n");
    
    pde = proc_create_single("pg_stats", 0, NULL, pg_stats_proc_show);
    if (!pde) {
        printk(KERN_ERR "CW2: Failed to create /proc/pg_stats\n");
        return -ENOMEM;
    }

    pde_make_permanent(pde);
    printk(KERN_INFO "CW2: /proc/pg_stats created successfully\n");

    return 0;
}

fs_initcall(pg_stats_proc_init);
