#include <linux/init.h>
#include <linux/module.h>
#include <linux/uaccess.h>
#include <linux/fs.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>

static struct proc_dir_entry* proc_entry;

static int hello_proc_show(struct seq_file *m, void *v) {
  seq_printf(m, "%d: [[%d],[%d].[%d]], [[%d],[%d],[%d]], [[%d],[%d].[%d]], [[%d],[%d],[%d]]\n", current->pid, current->pgd_alloc, current->pgd_free, current->pgd_set, current->pud_alloc, current->pud_free, current->pud_set, current->pmd_alloc, current->pmd_free, current->pmd_set, current->pte_alloc, current->pte_free, current->pte_set);
  return 0;
}

static int hello_proc_open(struct inode *inode, struct  file *file) {
  return single_open(file, hello_proc_show, NULL);
}

static const struct proc_ops hello_proc_fops = {
  .proc_open = hello_proc_open,
  .proc_read = seq_read,
  .proc_lseek = seq_lseek,
  .proc_release = single_release,
};

static int __init custom_init(void) {
   proc_entry = proc_create("pg_stats", 0666, NULL, &hello_proc_fops);
   printk(KERN_INFO);
   return 0;
}

static void __exit custom_exit(void) {
   proc_remove(proc_entry);
   printk(KERN_INFO);
}

module_init(custom_init);
module_exit(custom_exit);
