// expose /proc/pg_stats

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/proc_fs.h>
#include <linux/sched.h>
#include <linux/seq_file.h>
#include <linux/kprobes.h>
#include <linux/kallsyms.h>


#define PROCFS_NAME "pg_stats"

static int pg_stats_show(struct seq_file *m, void *v);
static int pg_stats_show(struct seq_file *m, void *v){
    //seq_printf(m,"well, this is awkward. we don't really have anything to show you so hang on!\n");
    //seq_printf(m,"but when this is done, we'll show you the following:\n");
    //seq_printf(m,"[pid]: [[pgd_alloc],[pgd_free],[pgd_set]],[[pud_alloc],[pud_free],[pud_set]],[[pmd_alloc],[pmd_free],[pmd_set]],[[pte_alloc],[pte_free],[pte_set]]\n");
    //seq_printf(m,"this will show for all processes\n");
    struct task_struct *task;
    for_each_process(task){
        seq_printf(m,"%d: [[%ld,%ld,%ld],[%ld,%ld,%ld],[%ld,%ld,%ld],[%ld,%ld,%ld]]\n",
            task->pid,
            task->pgd_alloc, task->pgd_free, task->pgd_set,
            task->pud_alloc, task->pud_free, task->pud_set,
            task->pmd_alloc, task->pmd_free, task->pmd_set,
            task->pte_alloc, task->pte_free, task->pte_set
        );
    }
    return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file);
static int pg_stats_open(struct inode *inode, struct file *file){
    return single_open(file, pg_stats_show, NULL);
}
static const struct proc_ops pg_stats_proc_fops = {
    .proc_open = pg_stats_open,
    .proc_read = seq_read,
    .proc_lseek = seq_lseek,
    .proc_release = single_release,
};



static int __init pg_stats_init(void);
static int __init pg_stats_init(void){
    struct proc_dir_entry *entry;

    entry = proc_create(PROCFS_NAME, 0, NULL, &pg_stats_proc_fops);
    if (!entry) {
        printk(KERN_ERR "pg_stats: Couldn't create proc entry\n");
        return -ENOMEM;
    }


    printk(KERN_INFO "pg_stats: Module loaded\n");

    return 0;
}
static void __exit pg_stats_exit(void);
static void __exit pg_stats_exit(void){
    remove_proc_entry(PROCFS_NAME, NULL);
    printk(KERN_INFO "pg_stats: Module unloaded\n");
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);

MODULE_LICENSE("GPL");
MODULE_AUTHOR("boykisser");
MODULE_DESCRIPTION("Expose page stats");
