#include <linux/types.h>
#include <linux/errno.h>
#include <linux/time.h>
#include <linux/time_namespace.h>
#include <linux/kernel.h>
#include <linux/kernel_stat.h>
#include <linux/tty.h>
#include <linux/string.h>
#include <linux/mman.h>
#include <linux/sched/mm.h>
#include <linux/sched/numa_balancing.h>
#include <linux/sched/task_stack.h>
#include <linux/sched/task.h>
#include <linux/sched/cputime.h>
#include <linux/proc_fs.h>
#include <linux/ioport.h>
#include <linux/io.h>
#include <linux/mm.h>
#include <linux/hugetlb.h>
#include <linux/pagemap.h>
#include <linux/swap.h>
#include <linux/smp.h>
#include <linux/signal.h>
#include <linux/highmem.h>
#include <linux/file.h>
#include <linux/fdtable.h>
#include <linux/times.h>
#include <linux/cpuset.h>
#include <linux/rcupdate.h>
#include <linux/delayacct.h>
#include <linux/seq_file.h>
#include <linux/pid_namespace.h>
#include <linux/prctl.h>
#include <linux/ptrace.h>
#include <linux/string_helpers.h>
#include <linux/user_namespace.h>
#include <linux/fs_struct.h>
#include <linux/kthread.h>
#include <linux/mmu_context.h>

#include <asm/processor.h>
#include "internal.h"

static int pg_stats_seq_show(struct seq_file *seq, void *v)
{
	struct task_struct *task = (struct task_struct *) v;

	seq_printf(
		seq, 
		"[%d]: [[%d,%d,%d], [%d,%d,%d], [%d,%d,%d], [%d,%d,%d]]\n", 
		task->pid,
		task->pgd_counters[0],
		task->pgd_counters[1],
		task->pgd_counters[2],
		task->pud_counters[0],
		task->pud_counters[1],
		task->pud_counters[2],
		task->pmd_counters[0],
		task->pmd_counters[1],
		task->pmd_counters[2],
		task->pte_counters[0],
		task->pte_counters[1],
		task->pte_counters[2]
	);
	return 0;
}

static void *pg_stats_seq_start(struct seq_file *seq, loff_t *pos)
{
	// if (*pos == 0) return (void *) get_proc_task(seq->file->f_path.dentry->d_inode);
	struct task_struct *task;
	loff_t i = 0;

	for_each_process(task) {
		if (i++ == *pos) return task;
	}
	return NULL;
}

static void *pg_stats_seq_next(struct seq_file *seq, void *v, loff_t *pos)
{
	struct task_struct *task = v;

	task = next_task(task);
	(*pos)++;
	return (task == &init_task) ? NULL : task;
}

static void pg_stats_seq_stop(struct seq_file *seq, void *v) {}

static const struct seq_operations pg_stats_seq_ops = {
	.start	= pg_stats_seq_start,
	.next	= pg_stats_seq_next,
	.stop	= pg_stats_seq_stop,
	.show	= pg_stats_seq_show,
};

static int pg_stats_seq_open(struct inode *inode, struct file *file)
{
	return seq_open(file, &pg_stats_seq_ops);
}

const struct proc_ops pg_stats_proc_ops = {
	.proc_open    = pg_stats_seq_open,
	.proc_read    = seq_read,
	.proc_lseek  = seq_lseek,
	.proc_release = seq_release,
};

static int __init pg_stats_init(void) {
	proc_create("pg_stats", 0, NULL, &pg_stats_proc_ops);
	return 0;
}

static void __exit pg_stats_exit(void) {
	remove_proc_entry("pg_stats", NULL);
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);
