// SPDX-License-Identifier: GPL-2.0
#include <linux/seq_file.h>
#include <linux/proc_fs.h>
#include <linux/sched.h>
#include <linux/init.h>
#include <linux/module.h>


static int pg_stats_show(struct seq_file *m, void *v)
{
    struct task_struct *task;

    rcu_read_lock();
    for_each_process(task) {
        seq_printf(m, "%d: [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]]\n",
                   task->pid,
                   task->pgd_allocate_counter, task->pgd_free_counter, task->pgd_set_counter,
                   task->pud_allocate_counter, task->pud_free_counter, task->pud_set_counter,
                   task->pmd_allocate_counter, task->pmd_free_counter, task->pmd_set_counter,
                   task->pte_allocate_counter, task->pte_free_counter, task->pte_set_counter);
    }
    rcu_read_unlock();
    return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file)
{
    return single_open(file, pg_stats_show, NULL);
}

static const struct proc_ops pg_stats_fops = {
    .proc_lseek   = seq_lseek,
    .proc_open    = pg_stats_open,
    .proc_read    = seq_read,
    .proc_release = single_release,
};

static int __init pg_stats_init(void)
{
    proc_create("pg_stats", 0444, NULL, &pg_stats_fops);
    return 0;
}

static void __exit pg_stats_exit(void)
{
    remove_proc_entry("pg_stats", NULL);
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);
