#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/seq_file.h>
#include <linux/proc_fs.h>
#include <linux/sched/signal.h>

static int show_pg_stats(struct seq_file *p, void *v) {
    struct task_struct *pr;

    for_each_process(pr) {
        seq_printf(p, "[%d]: [[%d], [%d], [%d]], [[%d], [%d], [%d]], [[%d], [%d], [%d]], [[%d], [%d], [%d]]\n", 
        pr->pid, pr->pgd_alloc, pr->pgd_free, pr->pgd_set, pr->pud_alloc, pr->pud_free, pr->pud_set, 
        pr->pmd_alloc, pr->pmd_free, pr->pmd_set, pr->pte_alloc, pr->pte_free, pr->pte_set);
    }

    return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file)
{
	unsigned int size = 1024 + 128 * num_online_cpus();

	/* minimum size to display an interrupt count : 2 bytes*/
	size += 2 * irq_get_nr_irqs();
	return single_open_size(file, show_pg_stats, NULL, size);
}

static const struct proc_ops pg_stat_proc_ops = {
	.proc_open	= pg_stats_open,
	.proc_read_iter	= seq_read_iter,
	.proc_lseek	= seq_lseek,
	.proc_release	= single_release,
};

static int __init pg_stats_init(void) {
    proc_create("pg_stats", 0, NULL, &pg_stat_proc_ops);
    return 0;
}



module_init(pg_stats_init); 
