#include <linux/module.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched/signal.h>
#include <linux/rcupdate.h>
#include <linux/init.h>

static int pg_stats_show(struct seq_file * m, void * v) {
  struct task_struct * p;

  rcu_read_lock();
  for_each_process(p) {
    seq_printf(m,
      "[%d]: [[%lu, %lu, %lu]], [[%lu, %lu, %lu]], [[%lu, %lu, %lu]], [[%lu, %lu, %lu]]\n",
      p -> pid,
      p -> pgd_alloc_count, p -> pgd_free_count, p -> pgd_set_count,
      p -> pud_alloc_count, p -> pud_free_count, p -> pud_set_count,
      p -> pmd_alloc_count, p -> pmd_free_count, p -> pmd_set_count,
      p -> pte_alloc_count, p -> pte_free_count, p -> pte_set_count);
  }
  rcu_read_unlock();

  return 0;
}

static int pg_stats_open(struct inode * inode, struct file * file) {
  return single_open(file, pg_stats_show, NULL);
}

static
const struct proc_ops pg_stats_proc_ops = {
  .proc_open = pg_stats_open,
  .proc_read = seq_read,
  .proc_lseek = seq_lseek,
  .proc_release = single_release,
};

static int __init pg_stats_init(void) {
  proc_create("pg_stats", 0444, NULL, & pg_stats_proc_ops);
  return 0;
}

static void __exit pg_stats_exit(void) {
  remove_proc_entry("pg_stats", NULL);
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);