#include <linux/fs.h>
#include <linux/init.h>
#include <linux/proc_fs.h>
#include <linux/sched.h>
#include <linux/seq_file.h>
#include "internal.h"


static int pg_stats_show(struct seq_file *f, void *v)
{

    struct task_struct *p;

    for_each_process(p) {
        seq_printf(
            f, "[%d]: [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]]\n",
            p->pid,
            // PGD
            atomic_read(&p->PGD_alloc),
            atomic_read(&p->PGD_free),
            atomic_read(&p->PGD_set),
            // PUD
            atomic_read(&p->PUD_alloc),
            atomic_read(&p->PUD_free),
            atomic_read(&p->PUD_set),
            // PMD
            atomic_read(&p->PMD_alloc),
            atomic_read(&p->PMD_free),
            atomic_read(&p->PMD_set),
            // PTE
            atomic_read(&p->PTE_alloc),
            atomic_read(&p->PTE_free),
            atomic_read(&p->PTE_set)
        );
    }

	return 0;
}


static int __init proc_pg_stats_init(void)
{
	struct proc_dir_entry *pde;

	pde = proc_create_single("pg_stats", 0, NULL, pg_stats_show);
	pde_make_permanent(pde);
	return 0;
}
fs_initcall(proc_pg_stats_init);
